static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Ali Alsam, Hans Jakob Rivertz, Øyvind Kolås (c) 2011                     \n"
" */                                                                           \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int  (iterations, _(\"Strength\"), 4)                                \n"
"  description (_(\"Controls the number of iterations; lower values give less plastic results\"))\n"
"  value_range (0, 32)                                                         \n"
"  ui_range    (0, 8)                                                          \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     noise_reduction                                      \n"
"#define GEGL_OP_C_SOURCE noise-reduction.c                                    \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"/* The core noise_reduction function, which is implemented as                 \n"
" * portable C - this is the function where most cpu time goes                 \n"
" */                                                                           \n"
"static void                                                                   \n"
"noise_reduction (float *src_buf,     /* source buffer, one pixel to the left  \n"
"                                        and up from the starting pixel */     \n"
"                 int    src_stride,  /* stridewidth of buffer in pixels */    \n"
"                 float *dst_buf,     /* destination buffer */                 \n"
"                 int    dst_width,   /* width to render */                    \n"
"                 int    dst_height,  /* height to render */                   \n"
"                 int    dst_stride)  /* stride of target buffer */            \n"
"{                                                                             \n"
"  int c;                                                                      \n"
"  int x,y;                                                                    \n"
"  int dst_offset;                                                             \n"
"                                                                              \n"
"#define NEIGHBOURS 8                                                          \n"
"#define AXES       (NEIGHBOURS/2)                                             \n"
"                                                                              \n"
"#define POW2(a) ((a)*(a))                                                     \n"
"/* core code/formulas to be tweaked for the tuning the implementation */      \n"
"#define GEN_METRIC(before, center, after) \\                                  \n"
"                   POW2((center) * 2 - (before) - (after))                    \n"
"                                                                              \n"
"/* Condition used to bail diffusion from a direction */                       \n"
"#define BAIL_CONDITION(new,original) ((new) > (original))                     \n"
"                                                                              \n"
"#define SYMMETRY(a)  (NEIGHBOURS - (a) - 1) /* point-symmetric neighbour pixel */\n"
"                                                                              \n"
"#define O(u,v) (((u)+((v) * src_stride)) * 4)                                 \n"
"  int   offsets[NEIGHBOURS] = {  /* array of the relative distance i float    \n"
"                                  * pointers to each of neighbours            \n"
"                                  * in source buffer, allows quick referencing.\n"
"                                  */                                          \n"
"              O( -1, -1), O(0, -1), O(1, -1),                                 \n"
"              O( -1,  0),           O(1,  0),                                 \n"
"              O( -1,  1), O(0, 1),  O(1,  1)};                                \n"
"#undef O                                                                      \n"
"                                                                              \n"
"  dst_offset = 0;                                                             \n"
"  for (y=0; y<dst_height; y++)                                                \n"
"    {                                                                         \n"
"      float *center_pix = src_buf + ((y+1) * src_stride + 1) * 4;             \n"
"      dst_offset = dst_stride * y;                                            \n"
"      for (x=0; x<dst_width; x++)                                             \n"
"        {                                                                     \n"
"          for (c=0; c<3; c++) /* do each color component individually */      \n"
"            {                                                                 \n"
"              float  metric_reference[AXES];                                  \n"
"              int    axis;                                                    \n"
"              int    direction;                                               \n"
"              float  sum;                                                     \n"
"              int    count;                                                   \n"
"                                                                              \n"
"              for (axis = 0; axis < AXES; axis++)                             \n"
"                { /* initialize original metrics for the horizontal, vertical \n"
"                     and 2 diagonal metrics */                                \n"
"                  float *before_pix  = center_pix + offsets[axis];            \n"
"                  float *after_pix   = center_pix + offsets[SYMMETRY(axis)];  \n"
"                                                                              \n"
"                  metric_reference[axis] =                                    \n"
"                    GEN_METRIC (before_pix[c], center_pix[c], after_pix[c]);  \n"
"                }                                                             \n"
"                                                                              \n"
"              sum   = center_pix[c];                                          \n"
"              count = 1;                                                      \n"
"                                                                              \n"
"              /* try smearing in data from all neighbours */                  \n"
"              for (direction = 0; direction < NEIGHBOURS; direction++)        \n"
"                {                                                             \n"
"                  float *pix   = center_pix + offsets[direction];             \n"
"                  float  value = pix[c] * 0.5 + center_pix[c] * 0.5;          \n"
"                  int    axis;                                                \n"
"                  int    valid;                                               \n"
"                                                                              \n"
"                  /* check if the non-smoothing operating check is true if    \n"
"                   * smearing from this direction for any of the axes */      \n"
"                  valid = 1; /* assume it will be valid */                    \n"
"                  for (axis = 0; axis < AXES; axis++)                         \n"
"                    {                                                         \n"
"                      float *before_pix = center_pix + offsets[axis];         \n"
"                      float *after_pix  = center_pix + offsets[SYMMETRY(axis)];\n"
"                      float  metric_new =                                     \n"
"                             GEN_METRIC (before_pix[c], value, after_pix[c]); \n"
"                                                                              \n"
"                      if (BAIL_CONDITION(metric_new, metric_reference[axis])) \n"
"                        {                                                     \n"
"                          valid = 0; /* mark as not a valid smoothing, and .. */\n"
"                          break;     /* .. break out of loop */               \n"
"                        }                                                     \n"
"                    }                                                         \n"
"                  if (valid) /* we were still smooth in all axes */           \n"
"                    {        /* add up contribution to final result  */       \n"
"                      sum += value;                                           \n"
"                      count ++;                                               \n"
"                    }                                                         \n"
"                }                                                             \n"
"              dst_buf[dst_offset*4+c] = sum / count;                          \n"
"            }                                                                 \n"
"          dst_buf[dst_offset*4+3] = center_pix[3]; /* copy alpha unmodified */\n"
"          dst_offset++;                                                       \n"
"          center_pix += 4;                                                    \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  GeglProperties              *o = GEGL_PROPERTIES (operation);               \n"
"                                                                              \n"
"  area->left = area->right = area->top = area->bottom = o->iterations;        \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"R'G'B'A float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"gegl-buffer-cl-iterator.h\"                                        \n"
"                                                                              \n"
"#include \"opencl/noise-reduction.cl.h\"                                      \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_noise_reduction (cl_mem                in_tex,                             \n"
"                    cl_mem                aux_tex,                            \n"
"                    cl_mem                out_tex,                            \n"
"                    size_t                global_worksize,                    \n"
"                    const GeglRectangle  *src_roi,                            \n"
"                    const GeglRectangle  *roi,                                \n"
"                    const int             iterations)                         \n"
"{                                                                             \n"
"  int i = 0;                                                                  \n"
"  size_t gbl_size_tmp[2];                                                     \n"
"                                                                              \n"
"  cl_int n_src_stride  = roi->width + iterations * 2;                         \n"
"  cl_int cl_err = 0;                                                          \n"
"                                                                              \n"
"  cl_mem temp_tex = NULL;                                                     \n"
"  cl_mem tmptex   = NULL;                                                     \n"
"                                                                              \n"
"  gint stride = 16; /*R'G'B'A float*/                                         \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] ={\"noise_reduction_cl\",\"transfer\", NULL}; \n"
"      cl_data = gegl_cl_compile_and_build(noise_reduction_cl_source, kernel_name);\n"
"    }                                                                         \n"
"  if (!cl_data)  return TRUE;                                                 \n"
"                                                                              \n"
"  temp_tex = gegl_clCreateBuffer (gegl_cl_get_context(),                      \n"
"                                  CL_MEM_READ_WRITE,                          \n"
"                                  src_roi->width * src_roi->height * stride,  \n"
"                                  NULL, &cl_err);                             \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueCopyBuffer(gegl_cl_get_command_queue(),              \n"
"                                    in_tex , temp_tex , 0 , 0 ,               \n"
"                                    src_roi->width * src_roi->height * stride,\n"
"                                    0, NULL, NULL);                           \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  tmptex = temp_tex;                                                          \n"
"  for (i = 0;i<iterations;i++)                                                \n"
"    {                                                                         \n"
"      if (i > 0)                                                              \n"
"      {                                                                       \n"
"        cl_mem temp = aux_tex;                                                \n"
"        aux_tex     = temp_tex;                                               \n"
"        temp_tex    = temp;                                                   \n"
"      }                                                                       \n"
"      gbl_size_tmp[0] = roi->width  + 2 * (iterations - 1 -i);                \n"
"      gbl_size_tmp[1] = roi->height + 2 * (iterations - 1 -i);                \n"
"                                                                              \n"
"      cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem), (void*)&temp_tex);\n"
"      CL_CHECK;                                                               \n"
"      cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_int), (void*)&n_src_stride);\n"
"      CL_CHECK;                                                               \n"
"      cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2, sizeof(cl_mem), (void*)&aux_tex);\n"
"      CL_CHECK;                                                               \n"
"      cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 3, sizeof(cl_int), (void*)&n_src_stride);\n"
"      CL_CHECK;                                                               \n"
"                                                                              \n"
"      cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue(), cl_data->kernel[0],\n"
"                                           2, NULL, gbl_size_tmp, NULL,       \n"
"                                           0, NULL, NULL);                    \n"
"      CL_CHECK;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  gbl_size_tmp[0] = roi->width ;                                              \n"
"  gbl_size_tmp[1] = roi->height;                                              \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[1], 0, sizeof(cl_mem), (void*)&aux_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[1], 1, sizeof(cl_int), (void*)&n_src_stride);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[1], 2, sizeof(cl_mem), (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue(), cl_data->kernel[1],\n"
"                                       2, NULL, gbl_size_tmp, NULL,           \n"
"                                       0, NULL, NULL);                        \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clFinish(gegl_cl_get_command_queue());                        \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  if (tmptex)                                                                 \n"
"    {                                                                         \n"
"      cl_err = gegl_clReleaseMemObject (tmptex);                              \n"
"      CL_CHECK_ONLY (cl_err);                                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  if (tmptex)                                                                 \n"
"    gegl_clReleaseMemObject (tmptex);                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"      GeglBuffer                *input,                                       \n"
"      GeglBuffer                *output,                                      \n"
"      const GeglRectangle       *result)                                      \n"
"{                                                                             \n"
"  const Babl *in_format  = gegl_operation_get_format (operation, \"input\");  \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"  gint err = 0;                                                               \n"
"                                                                              \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  GeglBufferClIterator *i = gegl_buffer_cl_iterator_new (output,              \n"
"                                                         result,              \n"
"                                                         out_format,          \n"
"                                                         GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"  gint read = gegl_buffer_cl_iterator_add_2 (i,                               \n"
"                                             input,                           \n"
"                                             result,                          \n"
"                                             in_format,                       \n"
"                                             GEGL_CL_BUFFER_READ,             \n"
"                                             op_area->left,                   \n"
"                                             op_area->right,                  \n"
"                                             op_area->top,                    \n"
"                                             op_area->bottom,                 \n"
"                                             GEGL_ABYSS_NONE);                \n"
"                                                                              \n"
"  gint aux = gegl_buffer_cl_iterator_add_aux (i,                              \n"
"                                              result,                         \n"
"                                              in_format,                      \n"
"                                              op_area->left,                  \n"
"                                              op_area->right,                 \n"
"                                              op_area->top,                   \n"
"                                              op_area->bottom);               \n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err) && !err)                      \n"
"    {                                                                         \n"
"      err = cl_noise_reduction (i->tex[read],                                 \n"
"                                i->tex[aux],                                  \n"
"                                i->tex[0],                                    \n"
"                                i->size[0],                                   \n"
"                                &i->roi[read],                                \n"
"                                &i->roi[0],                                   \n"
"                                o->iterations);                               \n"
"                                                                              \n"
"      if (err)                                                                \n"
"        {                                                                     \n"
"          gegl_buffer_cl_iterator_stop (i);                                   \n"
"          break;                                                              \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return !err;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#define INPLACE 1                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"                                                                              \n"
"  int iteration;                                                              \n"
"  int stride;                                                                 \n"
"  float *src_buf;                                                             \n"
"#ifndef INPLACE                                                               \n"
"  float *dst_buf;                                                             \n"
"#endif                                                                        \n"
"  GeglRectangle rect;                                                         \n"
"                                                                              \n"
"  if (gegl_operation_use_opencl (operation))                                  \n"
"    if(cl_process(operation, input, output, result))                          \n"
"      return TRUE;                                                            \n"
"                                                                              \n"
"  rect = *result;                                                             \n"
"                                                                              \n"
"  stride = result->width + o->iterations * 2;                                 \n"
"                                                                              \n"
"  src_buf = g_new0 (float,                                                    \n"
"         (stride) * (result->height + o->iterations * 2) * 4);                \n"
"#ifndef INPLACE                                                               \n"
"  dst_buf = g_new0 (float,                                                    \n"
"         (stride) * (result->height + o->iterations * 2) * 4);                \n"
"#endif                                                                        \n"
"                                                                              \n"
"  {                                                                           \n"
"    rect.x      -= o->iterations;                                             \n"
"    rect.y      -= o->iterations;                                             \n"
"    rect.width  += o->iterations*2;                                           \n"
"    rect.height += o->iterations*2;                                           \n"
"    gegl_buffer_get (input, &rect, 1.0, babl_format (\"R'G'B'A float\"),      \n"
"                     src_buf, stride * 4 * 4, GEGL_ABYSS_NONE);               \n"
"  }                                                                           \n"
"                                                                              \n"
"  for (iteration = 0; iteration < o->iterations; iteration++)                 \n"
"    {                                                                         \n"
"      noise_reduction (src_buf, stride,                                       \n"
"#ifdef INPLACE                                                                \n"
"                       src_buf + (stride + 1) * 4,                            \n"
"#else                                                                         \n"
"                       dst_buf,                                               \n"
"#endif                                                                        \n"
"                       result->width  + (o->iterations - 1 - iteration) * 2,  \n"
"                       result->height + (o->iterations - 1 - iteration) * 2,  \n"
"                       stride);                                               \n"
"#ifndef INPLACE                                                               \n"
"      { /* swap buffers */                                                    \n"
"        float *tmp = src_buf;                                                 \n"
"        src_buf = dst_buf;                                                    \n"
"        dst_buf = tmp;                                                        \n"
"      }                                                                       \n"
"#endif                                                                        \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (output, result, 0, babl_format (\"R'G'B'A float\"),        \n"
"#ifndef INPLACE                                                               \n"
"                   src_buf,                                                   \n"
"#else                                                                         \n"
"                   src_buf + ((stride +1) * 4) * o->iterations,               \n"
"#endif                                                                        \n"
"                   stride * 4 * 4);                                           \n"
"                                                                              \n"
"  g_free (src_buf);                                                           \n"
"#ifndef INPLACE                                                               \n"
"  g_free (dst_buf);                                                           \n"
"#endif                                                                        \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \n"
"                                                                     \"input\");\n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"  return *in_rect;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"/* Pass-through when iterations parameter is set to zero */                   \n"
"                                                                              \n"
"static gboolean                                                               \n"
"operation_process (GeglOperation        *operation,                           \n"
"                   GeglOperationContext *context,                             \n"
"                   const gchar          *output_prop,                         \n"
"                   const GeglRectangle  *result,                              \n"
"                   gint                  level)                               \n"
"{                                                                             \n"
"  GeglOperationClass  *operation_class;                                       \n"
"  GeglProperties      *o = GEGL_PROPERTIES (operation);                       \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (gegl_op_parent_class);              \n"
"                                                                              \n"
"  if (! o->iterations)                                                        \n"
"    {                                                                         \n"
"      gpointer in = gegl_operation_context_get_object (context, \"input\");   \n"
"      gegl_operation_context_take_object (context, \"output\",                \n"
"                                          g_object_ref (G_OBJECT (in)));      \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  return operation_class->process (operation, context, output_prop, result,   \n"
"                                   gegl_operation_context_get_level (context));\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class  = GEGL_OPERATION_CLASS (klass);                            \n"
"  filter_class     = GEGL_OPERATION_FILTER_CLASS (klass);                     \n"
"                                                                              \n"
"  filter_class->process           = process;                                  \n"
"  operation_class->process        = operation_process;                        \n"
"  operation_class->prepare        = prepare;                                  \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"title\",       _(\"Noise Reduction\"),                                  \n"
"    \"name\"       , \"gegl:noise-reduction\",                                \n"
"    \"categories\" , \"enhance:noise-reduction\",                             \n"
"    \"reference-hash\", \"f6549ca26f1f7b9706efbf9a6a83f052\",                 \n"
"    \"description\", _(\"Anisotropic smoothing operation\"),                  \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
