static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 1997 Miles O'Neal <meo@rru.com>  http://www.rru.com/~meo/        \n"
" * Copyright 2012 Maxime Nicco <maxime.nicco@gmail.com>                       \n"
" * Copyright 2013 Téo Mazars   <teo.mazars@ensimag.fr>                       \n"
" */                                                                           \n"
"                                                                              \n"
"/*                                                                            \n"
" *  PICK Operation                                                            \n"
" *     We pick a pixel at random from the neighborhood of the current pixel.  \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"                                                                              \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (pct_random, _(\"Randomization (%)\"), 50.0)                  \n"
"    value_range (0.0, 100.0)                                                  \n"
"                                                                              \n"
"property_int    (repeat, _(\"Repeat\"), 1)                                    \n"
"    value_range (1, 100)                                                      \n"
"                                                                              \n"
"property_seed (seed, _(\"Random seed\"), rand)                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     noise_pick                                           \n"
"#define GEGL_OP_C_SOURCE noise-pick.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"  const Babl              *format;                                            \n"
"                                                                              \n"
"  op_area->left   =                                                           \n"
"  op_area->right  =                                                           \n"
"  op_area->top    =                                                           \n"
"  op_area->bottom = o->repeat;                                                \n"
"                                                                              \n"
"  format = gegl_operation_get_source_format (operation, \"input\");           \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"/* We avoid unecessary calls to gegl_random                                   \n"
" * by recomputing a small part ourselves.                                     \n"
" * see gegl/gegl-random.c for details */                                      \n"
"#define RAND_UINT_TO_FLOAT(x) (((x) & 0xffff) * 0.00001525902189669642175)    \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties     *o;                                                      \n"
"  const Babl         *format;                                                 \n"
"  gint                bpp;                                                    \n"
"  GeglBufferIterator *gi;                                                     \n"
"                                                                              \n"
"  o = GEGL_PROPERTIES (operation);                                            \n"
"                                                                              \n"
"  format = gegl_operation_get_source_format (operation, \"input\");           \n"
"  bpp = babl_format_get_bytes_per_pixel (format);                             \n"
"                                                                              \n"
"  gi = gegl_buffer_iterator_new (output, result, 0, format,                   \n"
"                                 GEGL_ACCESS_WRITE, GEGL_ABYSS_CLAMP);        \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (gi))                                      \n"
"    {                                                                         \n"
"      gchar        *data = gi->data[0];                                       \n"
"      GeglRectangle roi  = gi->roi[0];                                        \n"
"      gint          i, j;                                                     \n"
"                                                                              \n"
"      for (j = roi.y; j < roi.y + roi.height ; j++)                           \n"
"        for (i = roi.x; i < roi.x + roi.width ; i++)                          \n"
"          {                                                                   \n"
"            gint r;                                                           \n"
"            gint pos_x = i, pos_y = j;                                        \n"
"                                                                              \n"
"            for (r = 0; r < o->repeat; r++)                                   \n"
"              {                                                               \n"
"                guint  rand = gegl_random_int (o->rand, pos_x, pos_y, 0, r);  \n"
"                gfloat pct  = RAND_UINT_TO_FLOAT (rand) * 100.0;              \n"
"                                                                              \n"
"                if (pct <= o->pct_random)                                     \n"
"                  {                                                           \n"
"                    gint rand2 = (gint) (rand % 9);                           \n"
"                                                                              \n"
"                    pos_x += (rand2 % 3) - 1;                                 \n"
"                    pos_y += (rand2 / 3) - 1;                                 \n"
"                  }                                                           \n"
"              }                                                               \n"
"                                                                              \n"
"            gegl_buffer_sample_at_level (input, pos_x, pos_y, NULL, data, format,\n"
"                                level,                                        \n"
"                                GEGL_SAMPLER_NEAREST, GEGL_ABYSS_CLAMP);      \n"
"            data += bpp;                                                      \n"
"          }                                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  filter_class->process = process;                                            \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",       \"gegl:noise-pick\",                                      \n"
"    \"title\",      _(\"Noise Pick\"),                                        \n"
"    \"reference-hash\", \"13aa5200ceff0b5607fb7ae867bf9d79\",                 \n"
"    \"categories\", \"noise\",                                                \n"
"    \"description\", _(\"Randomly interchange some pixels with neighbors\"),  \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
