# Parametrization of the compilations.

######################################################################
# Settings that we expect the distributor or end user to override by
# local defaults.

# It is common to pass default build flags via the environment instead
# of the command line, so we use ?= instead of := or =.

CC ?= gcc

CFLAGS ?= -g -O2 -fstack-protector --param=ssp-buffer-size=4 -Wformat -Werror=format-security
CPPFLAGS ?= -Wdate-time -D_FORTIFY_SOURCE=2

# Most people expect CFLAGS=-O2 to also affect Ada compilations,
# unless ADAFLAGS is set directly.
ADAFLAGS ?= $(filter-out -Wformat,$(CFLAGS))

LDFLAGS ?= -Wl,-z,relro

gnatmake_options ?=

######################################################################
# It is possible to override these variables directly, but this is not
# expected to be necessary.

# Each FOO variable (end user selection) takes precedence over
# default_FOO (author defaults).

default_ADAFLAGS := -gnat2012 -gnatwa -gnata -gnato -gnateE
default_CFLAGS := -Wall
default_LDFLAGS := -Wl,--as-needed
default_gnatmake_options :=
