// Copyright 2025 the Fearless_SIMD Authors
// SPDX-License-Identifier: Apache-2.0 OR MIT

// This file is autogenerated by fearless_simd_gen

use crate::{Level, Simd, SimdFrom, SimdInto, seal::Seal};
use crate::{
    f32x4, f32x8, f32x16, f64x2, f64x4, f64x8, i8x16, i8x32, i8x64, i16x8, i16x16, i16x32, i32x4,
    i32x8, i32x16, mask8x16, mask8x32, mask8x64, mask16x8, mask16x16, mask16x32, mask32x4,
    mask32x8, mask32x16, mask64x2, mask64x4, mask64x8, u8x16, u8x32, u8x64, u16x8, u16x16, u16x32,
    u32x4, u32x8, u32x16,
};
use core::arch::aarch64::*;
#[doc = r#" The SIMD token for the "neon" level."#]
#[derive(Clone, Copy, Debug)]
pub struct Neon {
    pub neon: crate::core_arch::aarch64::Neon,
}
impl Neon {
    #[inline]
    pub const unsafe fn new_unchecked() -> Self {
        Neon {
            neon: unsafe { crate::core_arch::aarch64::Neon::new_unchecked() },
        }
    }
}
impl Seal for Neon {}
impl Simd for Neon {
    type f32s = f32x4<Self>;
    type u8s = u8x16<Self>;
    type i8s = i8x16<Self>;
    type u16s = u16x8<Self>;
    type i16s = i16x8<Self>;
    type u32s = u32x4<Self>;
    type i32s = i32x4<Self>;
    type mask8s = mask8x16<Self>;
    type mask16s = mask16x8<Self>;
    type mask32s = mask32x4<Self>;
    #[inline(always)]
    fn level(self) -> Level {
        Level::Neon(self)
    }
    #[inline]
    fn vectorize<F: FnOnce() -> R, R>(self, f: F) -> R {
        #[target_feature(enable = "neon")]
        #[inline]
        unsafe fn vectorize_neon<F: FnOnce() -> R, R>(f: F) -> R {
            f()
        }
        unsafe { vectorize_neon(f) }
    }
    #[inline(always)]
    fn splat_f32x4(self, val: f32) -> f32x4<Self> {
        unsafe { vdupq_n_f32(val).simd_into(self) }
    }
    #[inline(always)]
    fn abs_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        unsafe { vabsq_f32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn neg_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        unsafe { vnegq_f32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sqrt_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        unsafe { vsqrtq_f32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn add_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { vaddq_f32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { vsubq_f32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { vmulq_f32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn div_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { vdivq_f32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn copysign_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe {
            let sign_mask = vdupq_n_u32(1 << 31);
            vbslq_f32(sign_mask, b.into(), a.into()).simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_eq_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vceqq_f32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vcltq_f32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vcleq_f32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vcgeq_f32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vcgtq_f32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip1q_f32(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip2q_f32(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp1q_f32(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_high_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp2q_f32(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn max_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { vmaxq_f32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_precise_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { vmaxnmq_f32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { vminq_f32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_precise_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { vminnmq_f32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn madd_f32x4(self, a: f32x4<Self>, b: f32x4<Self>, c: f32x4<Self>) -> f32x4<Self> {
        unsafe { vfmaq_f32(c.into(), b.into(), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn msub_f32x4(self, a: f32x4<Self>, b: f32x4<Self>, c: f32x4<Self>) -> f32x4<Self> {
        unsafe { vnegq_f32(vfmsq_f32(c.into(), b.into(), a.into())).simd_into(self) }
    }
    #[inline(always)]
    fn floor_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        unsafe { vrndmq_f32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn fract_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        unsafe {
            let c1 = vcvtq_s32_f32(a.into());
            let c2 = vcvtq_f32_s32(c1);
            vsubq_f32(a.into(), c2).simd_into(self)
        }
    }
    #[inline(always)]
    fn trunc_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        unsafe { vrndq_f32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn select_f32x4(self, a: mask32x4<Self>, b: f32x4<Self>, c: f32x4<Self>) -> f32x4<Self> {
        unsafe { vbslq_f32(vreinterpretq_u32_s32(a.into()), b.into(), c.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x8<Self> {
        let mut result = [0.0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_f64_f32x4(self, a: f32x4<Self>) -> f64x2<Self> {
        unsafe { vreinterpretq_f64_f32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_i32_f32x4(self, a: f32x4<Self>) -> i32x4<Self> {
        unsafe { vreinterpretq_s32_f32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_u8_f32x4(self, a: f32x4<Self>) -> u8x16<Self> {
        unsafe { vreinterpretq_u8_f32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_u32_f32x4(self, a: f32x4<Self>) -> u32x4<Self> {
        unsafe { vreinterpretq_u32_f32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn cvt_u32_f32x4(self, a: f32x4<Self>) -> u32x4<Self> {
        unsafe { vcvtq_u32_f32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn cvt_i32_f32x4(self, a: f32x4<Self>) -> i32x4<Self> {
        unsafe { vcvtq_s32_f32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn splat_i8x16(self, val: i8) -> i8x16<Self> {
        unsafe { vdupq_n_s8(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_i8x16(self, a: i8x16<Self>) -> i8x16<Self> {
        unsafe { vmvnq_s8(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn add_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { vaddq_s8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { vsubq_s8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { vmulq_s8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { vandq_s8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { vorrq_s8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { veorq_s8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn shr_i8x16(self, a: i8x16<Self>, shift: u32) -> i8x16<Self> {
        unsafe { vshlq_s8(a.into(), vdupq_n_s8(-(shift as i8))).simd_into(self) }
    }
    #[inline(always)]
    fn shrv_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { vshlq_s8(a.into(), vnegq_s8(b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn shl_i8x16(self, a: i8x16<Self>, shift: u32) -> i8x16<Self> {
        unsafe { vshlq_s8(a.into(), vdupq_n_s8(shift as i8)).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        unsafe { vreinterpretq_s8_u8(vceqq_s8(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        unsafe { vreinterpretq_s8_u8(vcltq_s8(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        unsafe { vreinterpretq_s8_u8(vcleq_s8(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        unsafe { vreinterpretq_s8_u8(vcgeq_s8(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        unsafe { vreinterpretq_s8_u8(vcgtq_s8(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip1q_s8(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip2q_s8(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp1q_s8(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_high_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp2q_s8(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn select_i8x16(self, a: mask8x16<Self>, b: i8x16<Self>, c: i8x16<Self>) -> i8x16<Self> {
        unsafe { vbslq_s8(vreinterpretq_u8_s8(a.into()), b.into(), c.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { vminq_s8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { vmaxq_s8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn neg_i8x16(self, a: i8x16<Self>) -> i8x16<Self> {
        unsafe { vnegq_s8(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_u8_i8x16(self, a: i8x16<Self>) -> u8x16<Self> {
        unsafe { vreinterpretq_u8_s8(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_u32_i8x16(self, a: i8x16<Self>) -> u32x4<Self> {
        unsafe { vreinterpretq_u32_s8(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn splat_u8x16(self, val: u8) -> u8x16<Self> {
        unsafe { vdupq_n_u8(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_u8x16(self, a: u8x16<Self>) -> u8x16<Self> {
        unsafe { vmvnq_u8(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn add_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { vaddq_u8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { vsubq_u8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { vmulq_u8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { vandq_u8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { vorrq_u8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { veorq_u8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn shr_u8x16(self, a: u8x16<Self>, shift: u32) -> u8x16<Self> {
        unsafe { vshlq_u8(a.into(), vdupq_n_s8(-(shift as i8))).simd_into(self) }
    }
    #[inline(always)]
    fn shrv_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { vshlq_u8(a.into(), vnegq_s8(vreinterpretq_s8_u8(b.into()))).simd_into(self) }
    }
    #[inline(always)]
    fn shl_u8x16(self, a: u8x16<Self>, shift: u32) -> u8x16<Self> {
        unsafe { vshlq_u8(a.into(), vdupq_n_s8(shift as i8)).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        unsafe { vreinterpretq_s8_u8(vceqq_u8(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        unsafe { vreinterpretq_s8_u8(vcltq_u8(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        unsafe { vreinterpretq_s8_u8(vcleq_u8(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        unsafe { vreinterpretq_s8_u8(vcgeq_u8(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        unsafe { vreinterpretq_s8_u8(vcgtq_u8(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip1q_u8(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip2q_u8(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp1q_u8(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_high_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp2q_u8(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn select_u8x16(self, a: mask8x16<Self>, b: u8x16<Self>, c: u8x16<Self>) -> u8x16<Self> {
        unsafe { vbslq_u8(vreinterpretq_u8_s8(a.into()), b.into(), c.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { vminq_u8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { vmaxq_u8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn widen_u8x16(self, a: u8x16<Self>) -> u16x16<Self> {
        unsafe {
            let low = vmovl_u8(vget_low_u8(a.into()));
            let high = vmovl_u8(vget_high_u8(a.into()));
            uint16x8x2_t(low, high).simd_into(self)
        }
    }
    #[inline(always)]
    fn reinterpret_u32_u8x16(self, a: u8x16<Self>) -> u32x4<Self> {
        unsafe { vreinterpretq_u32_u8(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn splat_mask8x16(self, val: i8) -> mask8x16<Self> {
        unsafe { vdupq_n_s8(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_mask8x16(self, a: mask8x16<Self>) -> mask8x16<Self> {
        unsafe { vmvnq_s8(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self> {
        unsafe { vandq_s8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self> {
        unsafe { vorrq_s8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self> {
        unsafe { veorq_s8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn select_mask8x16(
        self,
        a: mask8x16<Self>,
        b: mask8x16<Self>,
        c: mask8x16<Self>,
    ) -> mask8x16<Self> {
        unsafe { vbslq_s8(vreinterpretq_u8_s8(a.into()), b.into(), c.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self> {
        unsafe { vreinterpretq_s8_u8(vceqq_s8(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn combine_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn splat_i16x8(self, val: i16) -> i16x8<Self> {
        unsafe { vdupq_n_s16(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_i16x8(self, a: i16x8<Self>) -> i16x8<Self> {
        unsafe { vmvnq_s16(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn add_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { vaddq_s16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { vsubq_s16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { vmulq_s16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { vandq_s16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { vorrq_s16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { veorq_s16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn shr_i16x8(self, a: i16x8<Self>, shift: u32) -> i16x8<Self> {
        unsafe { vshlq_s16(a.into(), vdupq_n_s16(-(shift as i16))).simd_into(self) }
    }
    #[inline(always)]
    fn shrv_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { vshlq_s16(a.into(), vnegq_s16(b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn shl_i16x8(self, a: i16x8<Self>, shift: u32) -> i16x8<Self> {
        unsafe { vshlq_s16(a.into(), vdupq_n_s16(shift as i16)).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        unsafe { vreinterpretq_s16_u16(vceqq_s16(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        unsafe { vreinterpretq_s16_u16(vcltq_s16(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        unsafe { vreinterpretq_s16_u16(vcleq_s16(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        unsafe { vreinterpretq_s16_u16(vcgeq_s16(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        unsafe { vreinterpretq_s16_u16(vcgtq_s16(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip1q_s16(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip2q_s16(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp1q_s16(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_high_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp2q_s16(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn select_i16x8(self, a: mask16x8<Self>, b: i16x8<Self>, c: i16x8<Self>) -> i16x8<Self> {
        unsafe { vbslq_s16(vreinterpretq_u16_s16(a.into()), b.into(), c.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { vminq_s16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { vmaxq_s16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn neg_i16x8(self, a: i16x8<Self>) -> i16x8<Self> {
        unsafe { vnegq_s16(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_u8_i16x8(self, a: i16x8<Self>) -> u8x16<Self> {
        unsafe { vreinterpretq_u8_s16(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_u32_i16x8(self, a: i16x8<Self>) -> u32x4<Self> {
        unsafe { vreinterpretq_u32_s16(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn splat_u16x8(self, val: u16) -> u16x8<Self> {
        unsafe { vdupq_n_u16(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_u16x8(self, a: u16x8<Self>) -> u16x8<Self> {
        unsafe { vmvnq_u16(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn add_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { vaddq_u16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { vsubq_u16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { vmulq_u16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { vandq_u16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { vorrq_u16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { veorq_u16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn shr_u16x8(self, a: u16x8<Self>, shift: u32) -> u16x8<Self> {
        unsafe { vshlq_u16(a.into(), vdupq_n_s16(-(shift as i16))).simd_into(self) }
    }
    #[inline(always)]
    fn shrv_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { vshlq_u16(a.into(), vnegq_s16(vreinterpretq_s16_u16(b.into()))).simd_into(self) }
    }
    #[inline(always)]
    fn shl_u16x8(self, a: u16x8<Self>, shift: u32) -> u16x8<Self> {
        unsafe { vshlq_u16(a.into(), vdupq_n_s16(shift as i16)).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        unsafe { vreinterpretq_s16_u16(vceqq_u16(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        unsafe { vreinterpretq_s16_u16(vcltq_u16(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        unsafe { vreinterpretq_s16_u16(vcleq_u16(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        unsafe { vreinterpretq_s16_u16(vcgeq_u16(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        unsafe { vreinterpretq_s16_u16(vcgtq_u16(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip1q_u16(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip2q_u16(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp1q_u16(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_high_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp2q_u16(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn select_u16x8(self, a: mask16x8<Self>, b: u16x8<Self>, c: u16x8<Self>) -> u16x8<Self> {
        unsafe { vbslq_u16(vreinterpretq_u16_s16(a.into()), b.into(), c.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { vminq_u16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { vmaxq_u16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u8_u16x8(self, a: u16x8<Self>) -> u8x16<Self> {
        unsafe { vreinterpretq_u8_u16(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_u32_u16x8(self, a: u16x8<Self>) -> u32x4<Self> {
        unsafe { vreinterpretq_u32_u16(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn splat_mask16x8(self, val: i16) -> mask16x8<Self> {
        unsafe { vdupq_n_s16(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_mask16x8(self, a: mask16x8<Self>) -> mask16x8<Self> {
        unsafe { vmvnq_s16(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self> {
        unsafe { vandq_s16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self> {
        unsafe { vorrq_s16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self> {
        unsafe { veorq_s16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn select_mask16x8(
        self,
        a: mask16x8<Self>,
        b: mask16x8<Self>,
        c: mask16x8<Self>,
    ) -> mask16x8<Self> {
        unsafe { vbslq_s16(vreinterpretq_u16_s16(a.into()), b.into(), c.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self> {
        unsafe { vreinterpretq_s16_u16(vceqq_s16(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn combine_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn splat_i32x4(self, val: i32) -> i32x4<Self> {
        unsafe { vdupq_n_s32(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_i32x4(self, a: i32x4<Self>) -> i32x4<Self> {
        unsafe { vmvnq_s32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn add_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { vaddq_s32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { vsubq_s32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { vmulq_s32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { vandq_s32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { vorrq_s32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { veorq_s32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn shr_i32x4(self, a: i32x4<Self>, shift: u32) -> i32x4<Self> {
        unsafe { vshlq_s32(a.into(), vdupq_n_s32(-(shift as i32))).simd_into(self) }
    }
    #[inline(always)]
    fn shrv_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { vshlq_s32(a.into(), vnegq_s32(b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn shl_i32x4(self, a: i32x4<Self>, shift: u32) -> i32x4<Self> {
        unsafe { vshlq_s32(a.into(), vdupq_n_s32(shift as i32)).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vceqq_s32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vcltq_s32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vcleq_s32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vcgeq_s32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vcgtq_s32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip1q_s32(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip2q_s32(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp1q_s32(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_high_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp2q_s32(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn select_i32x4(self, a: mask32x4<Self>, b: i32x4<Self>, c: i32x4<Self>) -> i32x4<Self> {
        unsafe { vbslq_s32(vreinterpretq_u32_s32(a.into()), b.into(), c.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { vminq_s32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { vmaxq_s32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x8<Self> {
        let mut result = [0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn neg_i32x4(self, a: i32x4<Self>) -> i32x4<Self> {
        unsafe { vnegq_s32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_u8_i32x4(self, a: i32x4<Self>) -> u8x16<Self> {
        unsafe { vreinterpretq_u8_s32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_u32_i32x4(self, a: i32x4<Self>) -> u32x4<Self> {
        unsafe { vreinterpretq_u32_s32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn cvt_f32_i32x4(self, a: i32x4<Self>) -> f32x4<Self> {
        unsafe { vcvtq_f32_s32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn splat_u32x4(self, val: u32) -> u32x4<Self> {
        unsafe { vdupq_n_u32(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_u32x4(self, a: u32x4<Self>) -> u32x4<Self> {
        unsafe { vmvnq_u32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn add_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { vaddq_u32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { vsubq_u32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { vmulq_u32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { vandq_u32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { vorrq_u32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { veorq_u32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn shr_u32x4(self, a: u32x4<Self>, shift: u32) -> u32x4<Self> {
        unsafe { vshlq_u32(a.into(), vdupq_n_s32(-(shift as i32))).simd_into(self) }
    }
    #[inline(always)]
    fn shrv_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { vshlq_u32(a.into(), vnegq_s32(vreinterpretq_s32_u32(b.into()))).simd_into(self) }
    }
    #[inline(always)]
    fn shl_u32x4(self, a: u32x4<Self>, shift: u32) -> u32x4<Self> {
        unsafe { vshlq_u32(a.into(), vdupq_n_s32(shift as i32)).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vceqq_u32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vcltq_u32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vcleq_u32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vcgeq_u32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vcgtq_u32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip1q_u32(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip2q_u32(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp1q_u32(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_high_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp2q_u32(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn select_u32x4(self, a: mask32x4<Self>, b: u32x4<Self>, c: u32x4<Self>) -> u32x4<Self> {
        unsafe { vbslq_u32(vreinterpretq_u32_s32(a.into()), b.into(), c.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { vminq_u32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { vmaxq_u32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x8<Self> {
        let mut result = [0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u8_u32x4(self, a: u32x4<Self>) -> u8x16<Self> {
        unsafe { vreinterpretq_u8_u32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn cvt_f32_u32x4(self, a: u32x4<Self>) -> f32x4<Self> {
        unsafe { vcvtq_f32_u32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn splat_mask32x4(self, val: i32) -> mask32x4<Self> {
        unsafe { vdupq_n_s32(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_mask32x4(self, a: mask32x4<Self>) -> mask32x4<Self> {
        unsafe { vmvnq_s32(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self> {
        unsafe { vandq_s32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self> {
        unsafe { vorrq_s32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self> {
        unsafe { veorq_s32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn select_mask32x4(
        self,
        a: mask32x4<Self>,
        b: mask32x4<Self>,
        c: mask32x4<Self>,
    ) -> mask32x4<Self> {
        unsafe { vbslq_s32(vreinterpretq_u32_s32(a.into()), b.into(), c.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self> {
        unsafe { vreinterpretq_s32_u32(vceqq_s32(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn combine_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x8<Self> {
        let mut result = [0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn splat_f64x2(self, val: f64) -> f64x2<Self> {
        unsafe { vdupq_n_f64(val).simd_into(self) }
    }
    #[inline(always)]
    fn abs_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        unsafe { vabsq_f64(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn neg_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        unsafe { vnegq_f64(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sqrt_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        unsafe { vsqrtq_f64(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn add_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { vaddq_f64(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { vsubq_f64(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { vmulq_f64(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn div_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { vdivq_f64(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn copysign_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe {
            let sign_mask = vdupq_n_u64(1 << 63);
            vbslq_f64(sign_mask, b.into(), a.into()).simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_eq_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        unsafe { vreinterpretq_s64_u64(vceqq_f64(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        unsafe { vreinterpretq_s64_u64(vcltq_f64(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        unsafe { vreinterpretq_s64_u64(vcleq_f64(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        unsafe { vreinterpretq_s64_u64(vcgeq_f64(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        unsafe { vreinterpretq_s64_u64(vcgtq_f64(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip1q_f64(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vzip2q_f64(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp1q_f64(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_high_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        let x = a.into();
        let y = b.into();
        unsafe { vuzp2q_f64(x, y).simd_into(self) }
    }
    #[inline(always)]
    fn max_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { vmaxq_f64(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_precise_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { vmaxnmq_f64(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { vminq_f64(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_precise_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { vminnmq_f64(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn madd_f64x2(self, a: f64x2<Self>, b: f64x2<Self>, c: f64x2<Self>) -> f64x2<Self> {
        unsafe { vfmaq_f64(c.into(), b.into(), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn msub_f64x2(self, a: f64x2<Self>, b: f64x2<Self>, c: f64x2<Self>) -> f64x2<Self> {
        unsafe { vnegq_f64(vfmsq_f64(c.into(), b.into(), a.into())).simd_into(self) }
    }
    #[inline(always)]
    fn floor_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        unsafe { vrndmq_f64(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn fract_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        unsafe {
            let c1 = vcvtq_s64_f64(a.into());
            let c2 = vcvtq_f64_s64(c1);
            vsubq_f64(a.into(), c2).simd_into(self)
        }
    }
    #[inline(always)]
    fn trunc_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        unsafe { vrndq_f64(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn select_f64x2(self, a: mask64x2<Self>, b: f64x2<Self>, c: f64x2<Self>) -> f64x2<Self> {
        unsafe { vbslq_f64(vreinterpretq_u64_s64(a.into()), b.into(), c.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x4<Self> {
        let mut result = [0.0; 4usize];
        result[0..2usize].copy_from_slice(&a.val);
        result[2usize..4usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_f32_f64x2(self, a: f64x2<Self>) -> f32x4<Self> {
        unsafe { vreinterpretq_f32_f64(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn splat_mask64x2(self, val: i64) -> mask64x2<Self> {
        unsafe { vdupq_n_s64(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_mask64x2(self, a: mask64x2<Self>) -> mask64x2<Self> {
        unsafe { vreinterpretq_s64_s32(vmvnq_s32(vreinterpretq_s32_s64(a.into()))).simd_into(self) }
    }
    #[inline(always)]
    fn and_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self> {
        unsafe { vandq_s64(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self> {
        unsafe { vorrq_s64(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self> {
        unsafe { veorq_s64(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn select_mask64x2(
        self,
        a: mask64x2<Self>,
        b: mask64x2<Self>,
        c: mask64x2<Self>,
    ) -> mask64x2<Self> {
        unsafe { vbslq_s64(vreinterpretq_u64_s64(a.into()), b.into(), c.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self> {
        unsafe { vreinterpretq_s64_u64(vceqq_s64(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn combine_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x4<Self> {
        let mut result = [0; 4usize];
        result[0..2usize].copy_from_slice(&a.val);
        result[2usize..4usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn splat_f32x8(self, a: f32) -> f32x8<Self> {
        let half = self.splat_f32x4(a);
        self.combine_f32x4(half, half)
    }
    #[inline(always)]
    fn abs_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.abs_f32x4(a0), self.abs_f32x4(a1))
    }
    #[inline(always)]
    fn neg_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.neg_f32x4(a0), self.neg_f32x4(a1))
    }
    #[inline(always)]
    fn sqrt_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.sqrt_f32x4(a0), self.sqrt_f32x4(a1))
    }
    #[inline(always)]
    fn add_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.add_f32x4(a0, b0), self.add_f32x4(a1, b1))
    }
    #[inline(always)]
    fn sub_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.sub_f32x4(a0, b0), self.sub_f32x4(a1, b1))
    }
    #[inline(always)]
    fn mul_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.mul_f32x4(a0, b0), self.mul_f32x4(a1, b1))
    }
    #[inline(always)]
    fn div_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.div_f32x4(a0, b0), self.div_f32x4(a1, b1))
    }
    #[inline(always)]
    fn copysign_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.copysign_f32x4(a0, b0), self.copysign_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_eq_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_eq_f32x4(a0, b0), self.simd_eq_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_lt_f32x4(a0, b0), self.simd_lt_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_le_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_le_f32x4(a0, b0), self.simd_le_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_ge_f32x4(a0, b0), self.simd_ge_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_gt_f32x4(a0, b0), self.simd_gt_f32x4(a1, b1))
    }
    #[inline(always)]
    fn zip_low_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, _) = self.split_f32x8(a);
        let (b0, _) = self.split_f32x8(b);
        self.combine_f32x4(self.zip_low_f32x4(a0, b0), self.zip_high_f32x4(a0, b0))
    }
    #[inline(always)]
    fn zip_high_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (_, a1) = self.split_f32x8(a);
        let (_, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.zip_low_f32x4(a1, b1), self.zip_high_f32x4(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.unzip_low_f32x4(a0, a1), self.unzip_low_f32x4(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.unzip_high_f32x4(a0, a1), self.unzip_high_f32x4(b0, b1))
    }
    #[inline(always)]
    fn max_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.max_f32x4(a0, b0), self.max_f32x4(a1, b1))
    }
    #[inline(always)]
    fn max_precise_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(
            self.max_precise_f32x4(a0, b0),
            self.max_precise_f32x4(a1, b1),
        )
    }
    #[inline(always)]
    fn min_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.min_f32x4(a0, b0), self.min_f32x4(a1, b1))
    }
    #[inline(always)]
    fn min_precise_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(
            self.min_precise_f32x4(a0, b0),
            self.min_precise_f32x4(a1, b1),
        )
    }
    #[inline(always)]
    fn madd_f32x8(self, a: f32x8<Self>, b: f32x8<Self>, c: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        let (c0, c1) = self.split_f32x8(c);
        self.combine_f32x4(self.madd_f32x4(a0, b0, c0), self.madd_f32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn msub_f32x8(self, a: f32x8<Self>, b: f32x8<Self>, c: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        let (c0, c1) = self.split_f32x8(c);
        self.combine_f32x4(self.msub_f32x4(a0, b0, c0), self.msub_f32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn floor_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.floor_f32x4(a0), self.floor_f32x4(a1))
    }
    #[inline(always)]
    fn fract_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.fract_f32x4(a0), self.fract_f32x4(a1))
    }
    #[inline(always)]
    fn trunc_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.trunc_f32x4(a0), self.trunc_f32x4(a1))
    }
    #[inline(always)]
    fn select_f32x8(self, a: mask32x8<Self>, b: f32x8<Self>, c: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        let (c0, c1) = self.split_f32x8(c);
        self.combine_f32x4(self.select_f32x4(a0, b0, c0), self.select_f32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn combine_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x16<Self> {
        let mut result = [0.0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_f32x8(self, a: f32x8<Self>) -> (f32x4<Self>, f32x4<Self>) {
        let mut b0 = [0.0; 4usize];
        let mut b1 = [0.0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_f64_f32x8(self, a: f32x8<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f64x2(
            self.reinterpret_f64_f32x4(a0),
            self.reinterpret_f64_f32x4(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_i32_f32x8(self, a: f32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_i32x4(
            self.reinterpret_i32_f32x4(a0),
            self.reinterpret_i32_f32x4(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_u8_f32x8(self, a: f32x8<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_u8x16(self.reinterpret_u8_f32x4(a0), self.reinterpret_u8_f32x4(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_f32x8(self, a: f32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_u32x4(
            self.reinterpret_u32_f32x4(a0),
            self.reinterpret_u32_f32x4(a1),
        )
    }
    #[inline(always)]
    fn cvt_u32_f32x8(self, a: f32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_u32x4(self.cvt_u32_f32x4(a0), self.cvt_u32_f32x4(a1))
    }
    #[inline(always)]
    fn cvt_i32_f32x8(self, a: f32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_i32x4(self.cvt_i32_f32x4(a0), self.cvt_i32_f32x4(a1))
    }
    #[inline(always)]
    fn splat_i8x32(self, a: i8) -> i8x32<Self> {
        let half = self.splat_i8x16(a);
        self.combine_i8x16(half, half)
    }
    #[inline(always)]
    fn not_i8x32(self, a: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_i8x16(self.not_i8x16(a0), self.not_i8x16(a1))
    }
    #[inline(always)]
    fn add_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.add_i8x16(a0, b0), self.add_i8x16(a1, b1))
    }
    #[inline(always)]
    fn sub_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.sub_i8x16(a0, b0), self.sub_i8x16(a1, b1))
    }
    #[inline(always)]
    fn mul_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.mul_i8x16(a0, b0), self.mul_i8x16(a1, b1))
    }
    #[inline(always)]
    fn and_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.and_i8x16(a0, b0), self.and_i8x16(a1, b1))
    }
    #[inline(always)]
    fn or_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.or_i8x16(a0, b0), self.or_i8x16(a1, b1))
    }
    #[inline(always)]
    fn xor_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.xor_i8x16(a0, b0), self.xor_i8x16(a1, b1))
    }
    #[inline(always)]
    fn shr_i8x32(self, a: i8x32<Self>, b: u32) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_i8x16(self.shr_i8x16(a0, b), self.shr_i8x16(a1, b))
    }
    #[inline(always)]
    fn shrv_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.shrv_i8x16(a0, b0), self.shrv_i8x16(a1, b1))
    }
    #[inline(always)]
    fn shl_i8x32(self, a: i8x32<Self>, b: u32) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_i8x16(self.shl_i8x16(a0, b), self.shl_i8x16(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_eq_i8x16(a0, b0), self.simd_eq_i8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_lt_i8x16(a0, b0), self.simd_lt_i8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_le_i8x16(a0, b0), self.simd_le_i8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_ge_i8x16(a0, b0), self.simd_ge_i8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_gt_i8x16(a0, b0), self.simd_gt_i8x16(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, _) = self.split_i8x32(a);
        let (b0, _) = self.split_i8x32(b);
        self.combine_i8x16(self.zip_low_i8x16(a0, b0), self.zip_high_i8x16(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (_, a1) = self.split_i8x32(a);
        let (_, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.zip_low_i8x16(a1, b1), self.zip_high_i8x16(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.unzip_low_i8x16(a0, a1), self.unzip_low_i8x16(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.unzip_high_i8x16(a0, a1), self.unzip_high_i8x16(b0, b1))
    }
    #[inline(always)]
    fn select_i8x32(self, a: mask8x32<Self>, b: i8x32<Self>, c: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        let (c0, c1) = self.split_i8x32(c);
        self.combine_i8x16(self.select_i8x16(a0, b0, c0), self.select_i8x16(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.min_i8x16(a0, b0), self.min_i8x16(a1, b1))
    }
    #[inline(always)]
    fn max_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.max_i8x16(a0, b0), self.max_i8x16(a1, b1))
    }
    #[inline(always)]
    fn combine_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x64<Self> {
        let mut result = [0; 64usize];
        result[0..32usize].copy_from_slice(&a.val);
        result[32usize..64usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_i8x32(self, a: i8x32<Self>) -> (i8x16<Self>, i8x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i8x32(self, a: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_i8x16(self.neg_i8x16(a0), self.neg_i8x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i8x32(self, a: i8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_u8x16(self.reinterpret_u8_i8x16(a0), self.reinterpret_u8_i8x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i8x32(self, a: i8x32<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_u32x4(
            self.reinterpret_u32_i8x16(a0),
            self.reinterpret_u32_i8x16(a1),
        )
    }
    #[inline(always)]
    fn splat_u8x32(self, a: u8) -> u8x32<Self> {
        let half = self.splat_u8x16(a);
        self.combine_u8x16(half, half)
    }
    #[inline(always)]
    fn not_u8x32(self, a: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u8x16(self.not_u8x16(a0), self.not_u8x16(a1))
    }
    #[inline(always)]
    fn add_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.add_u8x16(a0, b0), self.add_u8x16(a1, b1))
    }
    #[inline(always)]
    fn sub_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.sub_u8x16(a0, b0), self.sub_u8x16(a1, b1))
    }
    #[inline(always)]
    fn mul_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.mul_u8x16(a0, b0), self.mul_u8x16(a1, b1))
    }
    #[inline(always)]
    fn and_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.and_u8x16(a0, b0), self.and_u8x16(a1, b1))
    }
    #[inline(always)]
    fn or_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.or_u8x16(a0, b0), self.or_u8x16(a1, b1))
    }
    #[inline(always)]
    fn xor_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.xor_u8x16(a0, b0), self.xor_u8x16(a1, b1))
    }
    #[inline(always)]
    fn shr_u8x32(self, a: u8x32<Self>, b: u32) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u8x16(self.shr_u8x16(a0, b), self.shr_u8x16(a1, b))
    }
    #[inline(always)]
    fn shrv_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.shrv_u8x16(a0, b0), self.shrv_u8x16(a1, b1))
    }
    #[inline(always)]
    fn shl_u8x32(self, a: u8x32<Self>, b: u32) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u8x16(self.shl_u8x16(a0, b), self.shl_u8x16(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_eq_u8x16(a0, b0), self.simd_eq_u8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_lt_u8x16(a0, b0), self.simd_lt_u8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_le_u8x16(a0, b0), self.simd_le_u8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_ge_u8x16(a0, b0), self.simd_ge_u8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_gt_u8x16(a0, b0), self.simd_gt_u8x16(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, _) = self.split_u8x32(a);
        let (b0, _) = self.split_u8x32(b);
        self.combine_u8x16(self.zip_low_u8x16(a0, b0), self.zip_high_u8x16(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (_, a1) = self.split_u8x32(a);
        let (_, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.zip_low_u8x16(a1, b1), self.zip_high_u8x16(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.unzip_low_u8x16(a0, a1), self.unzip_low_u8x16(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.unzip_high_u8x16(a0, a1), self.unzip_high_u8x16(b0, b1))
    }
    #[inline(always)]
    fn select_u8x32(self, a: mask8x32<Self>, b: u8x32<Self>, c: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        let (c0, c1) = self.split_u8x32(c);
        self.combine_u8x16(self.select_u8x16(a0, b0, c0), self.select_u8x16(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.min_u8x16(a0, b0), self.min_u8x16(a1, b1))
    }
    #[inline(always)]
    fn max_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.max_u8x16(a0, b0), self.max_u8x16(a1, b1))
    }
    #[inline(always)]
    fn combine_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x64<Self> {
        let mut result = [0; 64usize];
        result[0..32usize].copy_from_slice(&a.val);
        result[32usize..64usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_u8x32(self, a: u8x32<Self>) -> (u8x16<Self>, u8x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn widen_u8x32(self, a: u8x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u16x16(self.widen_u8x16(a0), self.widen_u8x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_u8x32(self, a: u8x32<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u32x4(
            self.reinterpret_u32_u8x16(a0),
            self.reinterpret_u32_u8x16(a1),
        )
    }
    #[inline(always)]
    fn splat_mask8x32(self, a: i8) -> mask8x32<Self> {
        let half = self.splat_mask8x16(a);
        self.combine_mask8x16(half, half)
    }
    #[inline(always)]
    fn not_mask8x32(self, a: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        self.combine_mask8x16(self.not_mask8x16(a0), self.not_mask8x16(a1))
    }
    #[inline(always)]
    fn and_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        self.combine_mask8x16(self.and_mask8x16(a0, b0), self.and_mask8x16(a1, b1))
    }
    #[inline(always)]
    fn or_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        self.combine_mask8x16(self.or_mask8x16(a0, b0), self.or_mask8x16(a1, b1))
    }
    #[inline(always)]
    fn xor_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        self.combine_mask8x16(self.xor_mask8x16(a0, b0), self.xor_mask8x16(a1, b1))
    }
    #[inline(always)]
    fn select_mask8x32(
        self,
        a: mask8x32<Self>,
        b: mask8x32<Self>,
        c: mask8x32<Self>,
    ) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        let (c0, c1) = self.split_mask8x32(c);
        self.combine_mask8x16(
            self.select_mask8x16(a0, b0, c0),
            self.select_mask8x16(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        self.combine_mask8x16(self.simd_eq_mask8x16(a0, b0), self.simd_eq_mask8x16(a1, b1))
    }
    #[inline(always)]
    fn combine_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x64<Self> {
        let mut result = [0; 64usize];
        result[0..32usize].copy_from_slice(&a.val);
        result[32usize..64usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_mask8x32(self, a: mask8x32<Self>) -> (mask8x16<Self>, mask8x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_i16x16(self, a: i16) -> i16x16<Self> {
        let half = self.splat_i16x8(a);
        self.combine_i16x8(half, half)
    }
    #[inline(always)]
    fn not_i16x16(self, a: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_i16x8(self.not_i16x8(a0), self.not_i16x8(a1))
    }
    #[inline(always)]
    fn add_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.add_i16x8(a0, b0), self.add_i16x8(a1, b1))
    }
    #[inline(always)]
    fn sub_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.sub_i16x8(a0, b0), self.sub_i16x8(a1, b1))
    }
    #[inline(always)]
    fn mul_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.mul_i16x8(a0, b0), self.mul_i16x8(a1, b1))
    }
    #[inline(always)]
    fn and_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.and_i16x8(a0, b0), self.and_i16x8(a1, b1))
    }
    #[inline(always)]
    fn or_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.or_i16x8(a0, b0), self.or_i16x8(a1, b1))
    }
    #[inline(always)]
    fn xor_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.xor_i16x8(a0, b0), self.xor_i16x8(a1, b1))
    }
    #[inline(always)]
    fn shr_i16x16(self, a: i16x16<Self>, b: u32) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_i16x8(self.shr_i16x8(a0, b), self.shr_i16x8(a1, b))
    }
    #[inline(always)]
    fn shrv_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.shrv_i16x8(a0, b0), self.shrv_i16x8(a1, b1))
    }
    #[inline(always)]
    fn shl_i16x16(self, a: i16x16<Self>, b: u32) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_i16x8(self.shl_i16x8(a0, b), self.shl_i16x8(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_eq_i16x8(a0, b0), self.simd_eq_i16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_lt_i16x8(a0, b0), self.simd_lt_i16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_le_i16x8(a0, b0), self.simd_le_i16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_ge_i16x8(a0, b0), self.simd_ge_i16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_gt_i16x8(a0, b0), self.simd_gt_i16x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, _) = self.split_i16x16(a);
        let (b0, _) = self.split_i16x16(b);
        self.combine_i16x8(self.zip_low_i16x8(a0, b0), self.zip_high_i16x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (_, a1) = self.split_i16x16(a);
        let (_, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.zip_low_i16x8(a1, b1), self.zip_high_i16x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.unzip_low_i16x8(a0, a1), self.unzip_low_i16x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.unzip_high_i16x8(a0, a1), self.unzip_high_i16x8(b0, b1))
    }
    #[inline(always)]
    fn select_i16x16(self, a: mask16x16<Self>, b: i16x16<Self>, c: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        let (c0, c1) = self.split_i16x16(c);
        self.combine_i16x8(self.select_i16x8(a0, b0, c0), self.select_i16x8(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.min_i16x8(a0, b0), self.min_i16x8(a1, b1))
    }
    #[inline(always)]
    fn max_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.max_i16x8(a0, b0), self.max_i16x8(a1, b1))
    }
    #[inline(always)]
    fn combine_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_i16x16(self, a: i16x16<Self>) -> (i16x8<Self>, i16x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i16x16(self, a: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_i16x8(self.neg_i16x8(a0), self.neg_i16x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i16x16(self, a: i16x16<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_u8x16(self.reinterpret_u8_i16x8(a0), self.reinterpret_u8_i16x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i16x16(self, a: i16x16<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_u32x4(
            self.reinterpret_u32_i16x8(a0),
            self.reinterpret_u32_i16x8(a1),
        )
    }
    #[inline(always)]
    fn splat_u16x16(self, a: u16) -> u16x16<Self> {
        let half = self.splat_u16x8(a);
        self.combine_u16x8(half, half)
    }
    #[inline(always)]
    fn not_u16x16(self, a: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u16x8(self.not_u16x8(a0), self.not_u16x8(a1))
    }
    #[inline(always)]
    fn add_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.add_u16x8(a0, b0), self.add_u16x8(a1, b1))
    }
    #[inline(always)]
    fn sub_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.sub_u16x8(a0, b0), self.sub_u16x8(a1, b1))
    }
    #[inline(always)]
    fn mul_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.mul_u16x8(a0, b0), self.mul_u16x8(a1, b1))
    }
    #[inline(always)]
    fn and_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.and_u16x8(a0, b0), self.and_u16x8(a1, b1))
    }
    #[inline(always)]
    fn or_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.or_u16x8(a0, b0), self.or_u16x8(a1, b1))
    }
    #[inline(always)]
    fn xor_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.xor_u16x8(a0, b0), self.xor_u16x8(a1, b1))
    }
    #[inline(always)]
    fn shr_u16x16(self, a: u16x16<Self>, b: u32) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u16x8(self.shr_u16x8(a0, b), self.shr_u16x8(a1, b))
    }
    #[inline(always)]
    fn shrv_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.shrv_u16x8(a0, b0), self.shrv_u16x8(a1, b1))
    }
    #[inline(always)]
    fn shl_u16x16(self, a: u16x16<Self>, b: u32) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u16x8(self.shl_u16x8(a0, b), self.shl_u16x8(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_eq_u16x8(a0, b0), self.simd_eq_u16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_lt_u16x8(a0, b0), self.simd_lt_u16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_le_u16x8(a0, b0), self.simd_le_u16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_ge_u16x8(a0, b0), self.simd_ge_u16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_gt_u16x8(a0, b0), self.simd_gt_u16x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, _) = self.split_u16x16(a);
        let (b0, _) = self.split_u16x16(b);
        self.combine_u16x8(self.zip_low_u16x8(a0, b0), self.zip_high_u16x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (_, a1) = self.split_u16x16(a);
        let (_, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.zip_low_u16x8(a1, b1), self.zip_high_u16x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.unzip_low_u16x8(a0, a1), self.unzip_low_u16x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.unzip_high_u16x8(a0, a1), self.unzip_high_u16x8(b0, b1))
    }
    #[inline(always)]
    fn select_u16x16(self, a: mask16x16<Self>, b: u16x16<Self>, c: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        let (c0, c1) = self.split_u16x16(c);
        self.combine_u16x8(self.select_u16x8(a0, b0, c0), self.select_u16x8(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.min_u16x8(a0, b0), self.min_u16x8(a1, b1))
    }
    #[inline(always)]
    fn max_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.max_u16x8(a0, b0), self.max_u16x8(a1, b1))
    }
    #[inline(always)]
    fn combine_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_u16x16(self, a: u16x16<Self>) -> (u16x8<Self>, u16x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn narrow_u16x16(self, a: u16x16<Self>) -> u8x16<Self> {
        unsafe {
            let converted: uint16x8x2_t = a.into();
            let low = vmovn_u16(converted.0);
            let high = vmovn_u16(converted.1);
            vcombine_u8(low, high).simd_into(self)
        }
    }
    #[inline(always)]
    fn reinterpret_u8_u16x16(self, a: u16x16<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u8x16(self.reinterpret_u8_u16x8(a0), self.reinterpret_u8_u16x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_u16x16(self, a: u16x16<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u32x4(
            self.reinterpret_u32_u16x8(a0),
            self.reinterpret_u32_u16x8(a1),
        )
    }
    #[inline(always)]
    fn splat_mask16x16(self, a: i16) -> mask16x16<Self> {
        let half = self.splat_mask16x8(a);
        self.combine_mask16x8(half, half)
    }
    #[inline(always)]
    fn not_mask16x16(self, a: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        self.combine_mask16x8(self.not_mask16x8(a0), self.not_mask16x8(a1))
    }
    #[inline(always)]
    fn and_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        self.combine_mask16x8(self.and_mask16x8(a0, b0), self.and_mask16x8(a1, b1))
    }
    #[inline(always)]
    fn or_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        self.combine_mask16x8(self.or_mask16x8(a0, b0), self.or_mask16x8(a1, b1))
    }
    #[inline(always)]
    fn xor_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        self.combine_mask16x8(self.xor_mask16x8(a0, b0), self.xor_mask16x8(a1, b1))
    }
    #[inline(always)]
    fn select_mask16x16(
        self,
        a: mask16x16<Self>,
        b: mask16x16<Self>,
        c: mask16x16<Self>,
    ) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        let (c0, c1) = self.split_mask16x16(c);
        self.combine_mask16x8(
            self.select_mask16x8(a0, b0, c0),
            self.select_mask16x8(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        self.combine_mask16x8(self.simd_eq_mask16x8(a0, b0), self.simd_eq_mask16x8(a1, b1))
    }
    #[inline(always)]
    fn combine_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_mask16x16(self, a: mask16x16<Self>) -> (mask16x8<Self>, mask16x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_i32x8(self, a: i32) -> i32x8<Self> {
        let half = self.splat_i32x4(a);
        self.combine_i32x4(half, half)
    }
    #[inline(always)]
    fn not_i32x8(self, a: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_i32x4(self.not_i32x4(a0), self.not_i32x4(a1))
    }
    #[inline(always)]
    fn add_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.add_i32x4(a0, b0), self.add_i32x4(a1, b1))
    }
    #[inline(always)]
    fn sub_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.sub_i32x4(a0, b0), self.sub_i32x4(a1, b1))
    }
    #[inline(always)]
    fn mul_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.mul_i32x4(a0, b0), self.mul_i32x4(a1, b1))
    }
    #[inline(always)]
    fn and_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.and_i32x4(a0, b0), self.and_i32x4(a1, b1))
    }
    #[inline(always)]
    fn or_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.or_i32x4(a0, b0), self.or_i32x4(a1, b1))
    }
    #[inline(always)]
    fn xor_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.xor_i32x4(a0, b0), self.xor_i32x4(a1, b1))
    }
    #[inline(always)]
    fn shr_i32x8(self, a: i32x8<Self>, b: u32) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_i32x4(self.shr_i32x4(a0, b), self.shr_i32x4(a1, b))
    }
    #[inline(always)]
    fn shrv_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.shrv_i32x4(a0, b0), self.shrv_i32x4(a1, b1))
    }
    #[inline(always)]
    fn shl_i32x8(self, a: i32x8<Self>, b: u32) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_i32x4(self.shl_i32x4(a0, b), self.shl_i32x4(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_eq_i32x4(a0, b0), self.simd_eq_i32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_lt_i32x4(a0, b0), self.simd_lt_i32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_le_i32x4(a0, b0), self.simd_le_i32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_ge_i32x4(a0, b0), self.simd_ge_i32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_gt_i32x4(a0, b0), self.simd_gt_i32x4(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, _) = self.split_i32x8(a);
        let (b0, _) = self.split_i32x8(b);
        self.combine_i32x4(self.zip_low_i32x4(a0, b0), self.zip_high_i32x4(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (_, a1) = self.split_i32x8(a);
        let (_, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.zip_low_i32x4(a1, b1), self.zip_high_i32x4(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.unzip_low_i32x4(a0, a1), self.unzip_low_i32x4(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.unzip_high_i32x4(a0, a1), self.unzip_high_i32x4(b0, b1))
    }
    #[inline(always)]
    fn select_i32x8(self, a: mask32x8<Self>, b: i32x8<Self>, c: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        let (c0, c1) = self.split_i32x8(c);
        self.combine_i32x4(self.select_i32x4(a0, b0, c0), self.select_i32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.min_i32x4(a0, b0), self.min_i32x4(a1, b1))
    }
    #[inline(always)]
    fn max_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.max_i32x4(a0, b0), self.max_i32x4(a1, b1))
    }
    #[inline(always)]
    fn combine_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_i32x8(self, a: i32x8<Self>) -> (i32x4<Self>, i32x4<Self>) {
        let mut b0 = [0; 4usize];
        let mut b1 = [0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i32x8(self, a: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_i32x4(self.neg_i32x4(a0), self.neg_i32x4(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i32x8(self, a: i32x8<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_u8x16(self.reinterpret_u8_i32x4(a0), self.reinterpret_u8_i32x4(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i32x8(self, a: i32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_u32x4(
            self.reinterpret_u32_i32x4(a0),
            self.reinterpret_u32_i32x4(a1),
        )
    }
    #[inline(always)]
    fn cvt_f32_i32x8(self, a: i32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_f32x4(self.cvt_f32_i32x4(a0), self.cvt_f32_i32x4(a1))
    }
    #[inline(always)]
    fn splat_u32x8(self, a: u32) -> u32x8<Self> {
        let half = self.splat_u32x4(a);
        self.combine_u32x4(half, half)
    }
    #[inline(always)]
    fn not_u32x8(self, a: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_u32x4(self.not_u32x4(a0), self.not_u32x4(a1))
    }
    #[inline(always)]
    fn add_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.add_u32x4(a0, b0), self.add_u32x4(a1, b1))
    }
    #[inline(always)]
    fn sub_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.sub_u32x4(a0, b0), self.sub_u32x4(a1, b1))
    }
    #[inline(always)]
    fn mul_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.mul_u32x4(a0, b0), self.mul_u32x4(a1, b1))
    }
    #[inline(always)]
    fn and_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.and_u32x4(a0, b0), self.and_u32x4(a1, b1))
    }
    #[inline(always)]
    fn or_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.or_u32x4(a0, b0), self.or_u32x4(a1, b1))
    }
    #[inline(always)]
    fn xor_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.xor_u32x4(a0, b0), self.xor_u32x4(a1, b1))
    }
    #[inline(always)]
    fn shr_u32x8(self, a: u32x8<Self>, b: u32) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_u32x4(self.shr_u32x4(a0, b), self.shr_u32x4(a1, b))
    }
    #[inline(always)]
    fn shrv_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.shrv_u32x4(a0, b0), self.shrv_u32x4(a1, b1))
    }
    #[inline(always)]
    fn shl_u32x8(self, a: u32x8<Self>, b: u32) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_u32x4(self.shl_u32x4(a0, b), self.shl_u32x4(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_eq_u32x4(a0, b0), self.simd_eq_u32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_lt_u32x4(a0, b0), self.simd_lt_u32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_le_u32x4(a0, b0), self.simd_le_u32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_ge_u32x4(a0, b0), self.simd_ge_u32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_gt_u32x4(a0, b0), self.simd_gt_u32x4(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, _) = self.split_u32x8(a);
        let (b0, _) = self.split_u32x8(b);
        self.combine_u32x4(self.zip_low_u32x4(a0, b0), self.zip_high_u32x4(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (_, a1) = self.split_u32x8(a);
        let (_, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.zip_low_u32x4(a1, b1), self.zip_high_u32x4(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.unzip_low_u32x4(a0, a1), self.unzip_low_u32x4(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.unzip_high_u32x4(a0, a1), self.unzip_high_u32x4(b0, b1))
    }
    #[inline(always)]
    fn select_u32x8(self, a: mask32x8<Self>, b: u32x8<Self>, c: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        let (c0, c1) = self.split_u32x8(c);
        self.combine_u32x4(self.select_u32x4(a0, b0, c0), self.select_u32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.min_u32x4(a0, b0), self.min_u32x4(a1, b1))
    }
    #[inline(always)]
    fn max_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.max_u32x4(a0, b0), self.max_u32x4(a1, b1))
    }
    #[inline(always)]
    fn combine_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_u32x8(self, a: u32x8<Self>) -> (u32x4<Self>, u32x4<Self>) {
        let mut b0 = [0; 4usize];
        let mut b1 = [0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_u8_u32x8(self, a: u32x8<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_u8x16(self.reinterpret_u8_u32x4(a0), self.reinterpret_u8_u32x4(a1))
    }
    #[inline(always)]
    fn cvt_f32_u32x8(self, a: u32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_f32x4(self.cvt_f32_u32x4(a0), self.cvt_f32_u32x4(a1))
    }
    #[inline(always)]
    fn splat_mask32x8(self, a: i32) -> mask32x8<Self> {
        let half = self.splat_mask32x4(a);
        self.combine_mask32x4(half, half)
    }
    #[inline(always)]
    fn not_mask32x8(self, a: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        self.combine_mask32x4(self.not_mask32x4(a0), self.not_mask32x4(a1))
    }
    #[inline(always)]
    fn and_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        self.combine_mask32x4(self.and_mask32x4(a0, b0), self.and_mask32x4(a1, b1))
    }
    #[inline(always)]
    fn or_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        self.combine_mask32x4(self.or_mask32x4(a0, b0), self.or_mask32x4(a1, b1))
    }
    #[inline(always)]
    fn xor_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        self.combine_mask32x4(self.xor_mask32x4(a0, b0), self.xor_mask32x4(a1, b1))
    }
    #[inline(always)]
    fn select_mask32x8(
        self,
        a: mask32x8<Self>,
        b: mask32x8<Self>,
        c: mask32x8<Self>,
    ) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        let (c0, c1) = self.split_mask32x8(c);
        self.combine_mask32x4(
            self.select_mask32x4(a0, b0, c0),
            self.select_mask32x4(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        self.combine_mask32x4(self.simd_eq_mask32x4(a0, b0), self.simd_eq_mask32x4(a1, b1))
    }
    #[inline(always)]
    fn combine_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_mask32x8(self, a: mask32x8<Self>) -> (mask32x4<Self>, mask32x4<Self>) {
        let mut b0 = [0; 4usize];
        let mut b1 = [0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_f64x4(self, a: f64) -> f64x4<Self> {
        let half = self.splat_f64x2(a);
        self.combine_f64x2(half, half)
    }
    #[inline(always)]
    fn abs_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.abs_f64x2(a0), self.abs_f64x2(a1))
    }
    #[inline(always)]
    fn neg_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.neg_f64x2(a0), self.neg_f64x2(a1))
    }
    #[inline(always)]
    fn sqrt_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.sqrt_f64x2(a0), self.sqrt_f64x2(a1))
    }
    #[inline(always)]
    fn add_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.add_f64x2(a0, b0), self.add_f64x2(a1, b1))
    }
    #[inline(always)]
    fn sub_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.sub_f64x2(a0, b0), self.sub_f64x2(a1, b1))
    }
    #[inline(always)]
    fn mul_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.mul_f64x2(a0, b0), self.mul_f64x2(a1, b1))
    }
    #[inline(always)]
    fn div_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.div_f64x2(a0, b0), self.div_f64x2(a1, b1))
    }
    #[inline(always)]
    fn copysign_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.copysign_f64x2(a0, b0), self.copysign_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_eq_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_eq_f64x2(a0, b0), self.simd_eq_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_lt_f64x2(a0, b0), self.simd_lt_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_le_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_le_f64x2(a0, b0), self.simd_le_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_ge_f64x2(a0, b0), self.simd_ge_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_gt_f64x2(a0, b0), self.simd_gt_f64x2(a1, b1))
    }
    #[inline(always)]
    fn zip_low_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, _) = self.split_f64x4(a);
        let (b0, _) = self.split_f64x4(b);
        self.combine_f64x2(self.zip_low_f64x2(a0, b0), self.zip_high_f64x2(a0, b0))
    }
    #[inline(always)]
    fn zip_high_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (_, a1) = self.split_f64x4(a);
        let (_, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.zip_low_f64x2(a1, b1), self.zip_high_f64x2(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.unzip_low_f64x2(a0, a1), self.unzip_low_f64x2(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.unzip_high_f64x2(a0, a1), self.unzip_high_f64x2(b0, b1))
    }
    #[inline(always)]
    fn max_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.max_f64x2(a0, b0), self.max_f64x2(a1, b1))
    }
    #[inline(always)]
    fn max_precise_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(
            self.max_precise_f64x2(a0, b0),
            self.max_precise_f64x2(a1, b1),
        )
    }
    #[inline(always)]
    fn min_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.min_f64x2(a0, b0), self.min_f64x2(a1, b1))
    }
    #[inline(always)]
    fn min_precise_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(
            self.min_precise_f64x2(a0, b0),
            self.min_precise_f64x2(a1, b1),
        )
    }
    #[inline(always)]
    fn madd_f64x4(self, a: f64x4<Self>, b: f64x4<Self>, c: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        let (c0, c1) = self.split_f64x4(c);
        self.combine_f64x2(self.madd_f64x2(a0, b0, c0), self.madd_f64x2(a1, b1, c1))
    }
    #[inline(always)]
    fn msub_f64x4(self, a: f64x4<Self>, b: f64x4<Self>, c: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        let (c0, c1) = self.split_f64x4(c);
        self.combine_f64x2(self.msub_f64x2(a0, b0, c0), self.msub_f64x2(a1, b1, c1))
    }
    #[inline(always)]
    fn floor_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.floor_f64x2(a0), self.floor_f64x2(a1))
    }
    #[inline(always)]
    fn fract_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.fract_f64x2(a0), self.fract_f64x2(a1))
    }
    #[inline(always)]
    fn trunc_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.trunc_f64x2(a0), self.trunc_f64x2(a1))
    }
    #[inline(always)]
    fn select_f64x4(self, a: mask64x4<Self>, b: f64x4<Self>, c: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        let (c0, c1) = self.split_f64x4(c);
        self.combine_f64x2(self.select_f64x2(a0, b0, c0), self.select_f64x2(a1, b1, c1))
    }
    #[inline(always)]
    fn combine_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x8<Self> {
        let mut result = [0.0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_f64x4(self, a: f64x4<Self>) -> (f64x2<Self>, f64x2<Self>) {
        let mut b0 = [0.0; 2usize];
        let mut b1 = [0.0; 2usize];
        b0.copy_from_slice(&a.val[0..2usize]);
        b1.copy_from_slice(&a.val[2usize..4usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_f32_f64x4(self, a: f64x4<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f32x4(
            self.reinterpret_f32_f64x2(a0),
            self.reinterpret_f32_f64x2(a1),
        )
    }
    #[inline(always)]
    fn splat_mask64x4(self, a: i64) -> mask64x4<Self> {
        let half = self.splat_mask64x2(a);
        self.combine_mask64x2(half, half)
    }
    #[inline(always)]
    fn not_mask64x4(self, a: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        self.combine_mask64x2(self.not_mask64x2(a0), self.not_mask64x2(a1))
    }
    #[inline(always)]
    fn and_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        self.combine_mask64x2(self.and_mask64x2(a0, b0), self.and_mask64x2(a1, b1))
    }
    #[inline(always)]
    fn or_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        self.combine_mask64x2(self.or_mask64x2(a0, b0), self.or_mask64x2(a1, b1))
    }
    #[inline(always)]
    fn xor_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        self.combine_mask64x2(self.xor_mask64x2(a0, b0), self.xor_mask64x2(a1, b1))
    }
    #[inline(always)]
    fn select_mask64x4(
        self,
        a: mask64x4<Self>,
        b: mask64x4<Self>,
        c: mask64x4<Self>,
    ) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        let (c0, c1) = self.split_mask64x4(c);
        self.combine_mask64x2(
            self.select_mask64x2(a0, b0, c0),
            self.select_mask64x2(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        self.combine_mask64x2(self.simd_eq_mask64x2(a0, b0), self.simd_eq_mask64x2(a1, b1))
    }
    #[inline(always)]
    fn combine_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x8<Self> {
        let mut result = [0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_mask64x4(self, a: mask64x4<Self>) -> (mask64x2<Self>, mask64x2<Self>) {
        let mut b0 = [0; 2usize];
        let mut b1 = [0; 2usize];
        b0.copy_from_slice(&a.val[0..2usize]);
        b1.copy_from_slice(&a.val[2usize..4usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_f32x16(self, a: f32) -> f32x16<Self> {
        let half = self.splat_f32x8(a);
        self.combine_f32x8(half, half)
    }
    #[inline(always)]
    fn abs_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.abs_f32x8(a0), self.abs_f32x8(a1))
    }
    #[inline(always)]
    fn neg_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.neg_f32x8(a0), self.neg_f32x8(a1))
    }
    #[inline(always)]
    fn sqrt_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.sqrt_f32x8(a0), self.sqrt_f32x8(a1))
    }
    #[inline(always)]
    fn add_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.add_f32x8(a0, b0), self.add_f32x8(a1, b1))
    }
    #[inline(always)]
    fn sub_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.sub_f32x8(a0, b0), self.sub_f32x8(a1, b1))
    }
    #[inline(always)]
    fn mul_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.mul_f32x8(a0, b0), self.mul_f32x8(a1, b1))
    }
    #[inline(always)]
    fn div_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.div_f32x8(a0, b0), self.div_f32x8(a1, b1))
    }
    #[inline(always)]
    fn copysign_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.copysign_f32x8(a0, b0), self.copysign_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_eq_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_eq_f32x8(a0, b0), self.simd_eq_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_lt_f32x8(a0, b0), self.simd_lt_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_le_f32x8(a0, b0), self.simd_le_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_ge_f32x8(a0, b0), self.simd_ge_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_gt_f32x8(a0, b0), self.simd_gt_f32x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, _) = self.split_f32x16(a);
        let (b0, _) = self.split_f32x16(b);
        self.combine_f32x8(self.zip_low_f32x8(a0, b0), self.zip_high_f32x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (_, a1) = self.split_f32x16(a);
        let (_, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.zip_low_f32x8(a1, b1), self.zip_high_f32x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.unzip_low_f32x8(a0, a1), self.unzip_low_f32x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.unzip_high_f32x8(a0, a1), self.unzip_high_f32x8(b0, b1))
    }
    #[inline(always)]
    fn max_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.max_f32x8(a0, b0), self.max_f32x8(a1, b1))
    }
    #[inline(always)]
    fn max_precise_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(
            self.max_precise_f32x8(a0, b0),
            self.max_precise_f32x8(a1, b1),
        )
    }
    #[inline(always)]
    fn min_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.min_f32x8(a0, b0), self.min_f32x8(a1, b1))
    }
    #[inline(always)]
    fn min_precise_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(
            self.min_precise_f32x8(a0, b0),
            self.min_precise_f32x8(a1, b1),
        )
    }
    #[inline(always)]
    fn madd_f32x16(self, a: f32x16<Self>, b: f32x16<Self>, c: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        let (c0, c1) = self.split_f32x16(c);
        self.combine_f32x8(self.madd_f32x8(a0, b0, c0), self.madd_f32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn msub_f32x16(self, a: f32x16<Self>, b: f32x16<Self>, c: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        let (c0, c1) = self.split_f32x16(c);
        self.combine_f32x8(self.msub_f32x8(a0, b0, c0), self.msub_f32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn floor_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.floor_f32x8(a0), self.floor_f32x8(a1))
    }
    #[inline(always)]
    fn fract_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.fract_f32x8(a0), self.fract_f32x8(a1))
    }
    #[inline(always)]
    fn trunc_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.trunc_f32x8(a0), self.trunc_f32x8(a1))
    }
    #[inline(always)]
    fn select_f32x16(self, a: mask32x16<Self>, b: f32x16<Self>, c: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        let (c0, c1) = self.split_f32x16(c);
        self.combine_f32x8(self.select_f32x8(a0, b0, c0), self.select_f32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn split_f32x16(self, a: f32x16<Self>) -> (f32x8<Self>, f32x8<Self>) {
        let mut b0 = [0.0; 8usize];
        let mut b1 = [0.0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_f64_f32x16(self, a: f32x16<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f64x4(
            self.reinterpret_f64_f32x8(a0),
            self.reinterpret_f64_f32x8(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_i32_f32x16(self, a: f32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_i32x8(
            self.reinterpret_i32_f32x8(a0),
            self.reinterpret_i32_f32x8(a1),
        )
    }
    #[inline(always)]
    fn load_interleaved_128_f32x16(self, src: &[f32; 16usize]) -> f32x16<Self> {
        unsafe { vld4q_f32(src.as_ptr()).simd_into(self) }
    }
    #[inline(always)]
    fn store_interleaved_128_f32x16(self, a: f32x16<Self>, dest: &mut [f32; 16usize]) -> () {
        unsafe { vst4q_f32(dest.as_mut_ptr(), a.into()) }
    }
    #[inline(always)]
    fn reinterpret_u8_f32x16(self, a: f32x16<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_u8x32(self.reinterpret_u8_f32x8(a0), self.reinterpret_u8_f32x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_f32x16(self, a: f32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_u32x8(
            self.reinterpret_u32_f32x8(a0),
            self.reinterpret_u32_f32x8(a1),
        )
    }
    #[inline(always)]
    fn cvt_u32_f32x16(self, a: f32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_u32x8(self.cvt_u32_f32x8(a0), self.cvt_u32_f32x8(a1))
    }
    #[inline(always)]
    fn cvt_i32_f32x16(self, a: f32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_i32x8(self.cvt_i32_f32x8(a0), self.cvt_i32_f32x8(a1))
    }
    #[inline(always)]
    fn splat_i8x64(self, a: i8) -> i8x64<Self> {
        let half = self.splat_i8x32(a);
        self.combine_i8x32(half, half)
    }
    #[inline(always)]
    fn not_i8x64(self, a: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_i8x32(self.not_i8x32(a0), self.not_i8x32(a1))
    }
    #[inline(always)]
    fn add_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.add_i8x32(a0, b0), self.add_i8x32(a1, b1))
    }
    #[inline(always)]
    fn sub_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.sub_i8x32(a0, b0), self.sub_i8x32(a1, b1))
    }
    #[inline(always)]
    fn mul_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.mul_i8x32(a0, b0), self.mul_i8x32(a1, b1))
    }
    #[inline(always)]
    fn and_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.and_i8x32(a0, b0), self.and_i8x32(a1, b1))
    }
    #[inline(always)]
    fn or_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.or_i8x32(a0, b0), self.or_i8x32(a1, b1))
    }
    #[inline(always)]
    fn xor_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.xor_i8x32(a0, b0), self.xor_i8x32(a1, b1))
    }
    #[inline(always)]
    fn shr_i8x64(self, a: i8x64<Self>, b: u32) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_i8x32(self.shr_i8x32(a0, b), self.shr_i8x32(a1, b))
    }
    #[inline(always)]
    fn shrv_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.shrv_i8x32(a0, b0), self.shrv_i8x32(a1, b1))
    }
    #[inline(always)]
    fn shl_i8x64(self, a: i8x64<Self>, b: u32) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_i8x32(self.shl_i8x32(a0, b), self.shl_i8x32(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_eq_i8x32(a0, b0), self.simd_eq_i8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_lt_i8x32(a0, b0), self.simd_lt_i8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_le_i8x32(a0, b0), self.simd_le_i8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_ge_i8x32(a0, b0), self.simd_ge_i8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_gt_i8x32(a0, b0), self.simd_gt_i8x32(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, _) = self.split_i8x64(a);
        let (b0, _) = self.split_i8x64(b);
        self.combine_i8x32(self.zip_low_i8x32(a0, b0), self.zip_high_i8x32(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (_, a1) = self.split_i8x64(a);
        let (_, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.zip_low_i8x32(a1, b1), self.zip_high_i8x32(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.unzip_low_i8x32(a0, a1), self.unzip_low_i8x32(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.unzip_high_i8x32(a0, a1), self.unzip_high_i8x32(b0, b1))
    }
    #[inline(always)]
    fn select_i8x64(self, a: mask8x64<Self>, b: i8x64<Self>, c: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        let (c0, c1) = self.split_i8x64(c);
        self.combine_i8x32(self.select_i8x32(a0, b0, c0), self.select_i8x32(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.min_i8x32(a0, b0), self.min_i8x32(a1, b1))
    }
    #[inline(always)]
    fn max_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.max_i8x32(a0, b0), self.max_i8x32(a1, b1))
    }
    #[inline(always)]
    fn split_i8x64(self, a: i8x64<Self>) -> (i8x32<Self>, i8x32<Self>) {
        let mut b0 = [0; 32usize];
        let mut b1 = [0; 32usize];
        b0.copy_from_slice(&a.val[0..32usize]);
        b1.copy_from_slice(&a.val[32usize..64usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i8x64(self, a: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_i8x32(self.neg_i8x32(a0), self.neg_i8x32(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i8x64(self, a: i8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_u8x32(self.reinterpret_u8_i8x32(a0), self.reinterpret_u8_i8x32(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i8x64(self, a: i8x64<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_u32x8(
            self.reinterpret_u32_i8x32(a0),
            self.reinterpret_u32_i8x32(a1),
        )
    }
    #[inline(always)]
    fn splat_u8x64(self, a: u8) -> u8x64<Self> {
        let half = self.splat_u8x32(a);
        self.combine_u8x32(half, half)
    }
    #[inline(always)]
    fn not_u8x64(self, a: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        self.combine_u8x32(self.not_u8x32(a0), self.not_u8x32(a1))
    }
    #[inline(always)]
    fn add_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.add_u8x32(a0, b0), self.add_u8x32(a1, b1))
    }
    #[inline(always)]
    fn sub_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.sub_u8x32(a0, b0), self.sub_u8x32(a1, b1))
    }
    #[inline(always)]
    fn mul_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.mul_u8x32(a0, b0), self.mul_u8x32(a1, b1))
    }
    #[inline(always)]
    fn and_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.and_u8x32(a0, b0), self.and_u8x32(a1, b1))
    }
    #[inline(always)]
    fn or_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.or_u8x32(a0, b0), self.or_u8x32(a1, b1))
    }
    #[inline(always)]
    fn xor_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.xor_u8x32(a0, b0), self.xor_u8x32(a1, b1))
    }
    #[inline(always)]
    fn shr_u8x64(self, a: u8x64<Self>, b: u32) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        self.combine_u8x32(self.shr_u8x32(a0, b), self.shr_u8x32(a1, b))
    }
    #[inline(always)]
    fn shrv_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.shrv_u8x32(a0, b0), self.shrv_u8x32(a1, b1))
    }
    #[inline(always)]
    fn shl_u8x64(self, a: u8x64<Self>, b: u32) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        self.combine_u8x32(self.shl_u8x32(a0, b), self.shl_u8x32(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_eq_u8x32(a0, b0), self.simd_eq_u8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_lt_u8x32(a0, b0), self.simd_lt_u8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_le_u8x32(a0, b0), self.simd_le_u8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_ge_u8x32(a0, b0), self.simd_ge_u8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_gt_u8x32(a0, b0), self.simd_gt_u8x32(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, _) = self.split_u8x64(a);
        let (b0, _) = self.split_u8x64(b);
        self.combine_u8x32(self.zip_low_u8x32(a0, b0), self.zip_high_u8x32(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (_, a1) = self.split_u8x64(a);
        let (_, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.zip_low_u8x32(a1, b1), self.zip_high_u8x32(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.unzip_low_u8x32(a0, a1), self.unzip_low_u8x32(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.unzip_high_u8x32(a0, a1), self.unzip_high_u8x32(b0, b1))
    }
    #[inline(always)]
    fn select_u8x64(self, a: mask8x64<Self>, b: u8x64<Self>, c: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        let (c0, c1) = self.split_u8x64(c);
        self.combine_u8x32(self.select_u8x32(a0, b0, c0), self.select_u8x32(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.min_u8x32(a0, b0), self.min_u8x32(a1, b1))
    }
    #[inline(always)]
    fn max_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.max_u8x32(a0, b0), self.max_u8x32(a1, b1))
    }
    #[inline(always)]
    fn split_u8x64(self, a: u8x64<Self>) -> (u8x32<Self>, u8x32<Self>) {
        let mut b0 = [0; 32usize];
        let mut b1 = [0; 32usize];
        b0.copy_from_slice(&a.val[0..32usize]);
        b1.copy_from_slice(&a.val[32usize..64usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn load_interleaved_128_u8x64(self, src: &[u8; 64usize]) -> u8x64<Self> {
        unsafe { vld4q_u8(src.as_ptr()).simd_into(self) }
    }
    #[inline(always)]
    fn store_interleaved_128_u8x64(self, a: u8x64<Self>, dest: &mut [u8; 64usize]) -> () {
        unsafe { vst4q_u8(dest.as_mut_ptr(), a.into()) }
    }
    #[inline(always)]
    fn reinterpret_u32_u8x64(self, a: u8x64<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u8x64(a);
        self.combine_u32x8(
            self.reinterpret_u32_u8x32(a0),
            self.reinterpret_u32_u8x32(a1),
        )
    }
    #[inline(always)]
    fn splat_mask8x64(self, a: i8) -> mask8x64<Self> {
        let half = self.splat_mask8x32(a);
        self.combine_mask8x32(half, half)
    }
    #[inline(always)]
    fn not_mask8x64(self, a: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        self.combine_mask8x32(self.not_mask8x32(a0), self.not_mask8x32(a1))
    }
    #[inline(always)]
    fn and_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        self.combine_mask8x32(self.and_mask8x32(a0, b0), self.and_mask8x32(a1, b1))
    }
    #[inline(always)]
    fn or_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        self.combine_mask8x32(self.or_mask8x32(a0, b0), self.or_mask8x32(a1, b1))
    }
    #[inline(always)]
    fn xor_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        self.combine_mask8x32(self.xor_mask8x32(a0, b0), self.xor_mask8x32(a1, b1))
    }
    #[inline(always)]
    fn select_mask8x64(
        self,
        a: mask8x64<Self>,
        b: mask8x64<Self>,
        c: mask8x64<Self>,
    ) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        let (c0, c1) = self.split_mask8x64(c);
        self.combine_mask8x32(
            self.select_mask8x32(a0, b0, c0),
            self.select_mask8x32(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        self.combine_mask8x32(self.simd_eq_mask8x32(a0, b0), self.simd_eq_mask8x32(a1, b1))
    }
    #[inline(always)]
    fn split_mask8x64(self, a: mask8x64<Self>) -> (mask8x32<Self>, mask8x32<Self>) {
        let mut b0 = [0; 32usize];
        let mut b1 = [0; 32usize];
        b0.copy_from_slice(&a.val[0..32usize]);
        b1.copy_from_slice(&a.val[32usize..64usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_i16x32(self, a: i16) -> i16x32<Self> {
        let half = self.splat_i16x16(a);
        self.combine_i16x16(half, half)
    }
    #[inline(always)]
    fn not_i16x32(self, a: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_i16x16(self.not_i16x16(a0), self.not_i16x16(a1))
    }
    #[inline(always)]
    fn add_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.add_i16x16(a0, b0), self.add_i16x16(a1, b1))
    }
    #[inline(always)]
    fn sub_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.sub_i16x16(a0, b0), self.sub_i16x16(a1, b1))
    }
    #[inline(always)]
    fn mul_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.mul_i16x16(a0, b0), self.mul_i16x16(a1, b1))
    }
    #[inline(always)]
    fn and_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.and_i16x16(a0, b0), self.and_i16x16(a1, b1))
    }
    #[inline(always)]
    fn or_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.or_i16x16(a0, b0), self.or_i16x16(a1, b1))
    }
    #[inline(always)]
    fn xor_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.xor_i16x16(a0, b0), self.xor_i16x16(a1, b1))
    }
    #[inline(always)]
    fn shr_i16x32(self, a: i16x32<Self>, b: u32) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_i16x16(self.shr_i16x16(a0, b), self.shr_i16x16(a1, b))
    }
    #[inline(always)]
    fn shrv_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.shrv_i16x16(a0, b0), self.shrv_i16x16(a1, b1))
    }
    #[inline(always)]
    fn shl_i16x32(self, a: i16x32<Self>, b: u32) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_i16x16(self.shl_i16x16(a0, b), self.shl_i16x16(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_eq_i16x16(a0, b0), self.simd_eq_i16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_lt_i16x16(a0, b0), self.simd_lt_i16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_le_i16x16(a0, b0), self.simd_le_i16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_ge_i16x16(a0, b0), self.simd_ge_i16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_gt_i16x16(a0, b0), self.simd_gt_i16x16(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, _) = self.split_i16x32(a);
        let (b0, _) = self.split_i16x32(b);
        self.combine_i16x16(self.zip_low_i16x16(a0, b0), self.zip_high_i16x16(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (_, a1) = self.split_i16x32(a);
        let (_, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.zip_low_i16x16(a1, b1), self.zip_high_i16x16(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.unzip_low_i16x16(a0, a1), self.unzip_low_i16x16(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(
            self.unzip_high_i16x16(a0, a1),
            self.unzip_high_i16x16(b0, b1),
        )
    }
    #[inline(always)]
    fn select_i16x32(self, a: mask16x32<Self>, b: i16x32<Self>, c: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        let (c0, c1) = self.split_i16x32(c);
        self.combine_i16x16(
            self.select_i16x16(a0, b0, c0),
            self.select_i16x16(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn min_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.min_i16x16(a0, b0), self.min_i16x16(a1, b1))
    }
    #[inline(always)]
    fn max_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.max_i16x16(a0, b0), self.max_i16x16(a1, b1))
    }
    #[inline(always)]
    fn split_i16x32(self, a: i16x32<Self>) -> (i16x16<Self>, i16x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i16x32(self, a: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_i16x16(self.neg_i16x16(a0), self.neg_i16x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i16x32(self, a: i16x32<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_u8x32(
            self.reinterpret_u8_i16x16(a0),
            self.reinterpret_u8_i16x16(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_u32_i16x32(self, a: i16x32<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_u32x8(
            self.reinterpret_u32_i16x16(a0),
            self.reinterpret_u32_i16x16(a1),
        )
    }
    #[inline(always)]
    fn splat_u16x32(self, a: u16) -> u16x32<Self> {
        let half = self.splat_u16x16(a);
        self.combine_u16x16(half, half)
    }
    #[inline(always)]
    fn not_u16x32(self, a: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u16x16(self.not_u16x16(a0), self.not_u16x16(a1))
    }
    #[inline(always)]
    fn add_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.add_u16x16(a0, b0), self.add_u16x16(a1, b1))
    }
    #[inline(always)]
    fn sub_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.sub_u16x16(a0, b0), self.sub_u16x16(a1, b1))
    }
    #[inline(always)]
    fn mul_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.mul_u16x16(a0, b0), self.mul_u16x16(a1, b1))
    }
    #[inline(always)]
    fn and_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.and_u16x16(a0, b0), self.and_u16x16(a1, b1))
    }
    #[inline(always)]
    fn or_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.or_u16x16(a0, b0), self.or_u16x16(a1, b1))
    }
    #[inline(always)]
    fn xor_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.xor_u16x16(a0, b0), self.xor_u16x16(a1, b1))
    }
    #[inline(always)]
    fn shr_u16x32(self, a: u16x32<Self>, b: u32) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u16x16(self.shr_u16x16(a0, b), self.shr_u16x16(a1, b))
    }
    #[inline(always)]
    fn shrv_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.shrv_u16x16(a0, b0), self.shrv_u16x16(a1, b1))
    }
    #[inline(always)]
    fn shl_u16x32(self, a: u16x32<Self>, b: u32) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u16x16(self.shl_u16x16(a0, b), self.shl_u16x16(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_eq_u16x16(a0, b0), self.simd_eq_u16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_lt_u16x16(a0, b0), self.simd_lt_u16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_le_u16x16(a0, b0), self.simd_le_u16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_ge_u16x16(a0, b0), self.simd_ge_u16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_gt_u16x16(a0, b0), self.simd_gt_u16x16(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, _) = self.split_u16x32(a);
        let (b0, _) = self.split_u16x32(b);
        self.combine_u16x16(self.zip_low_u16x16(a0, b0), self.zip_high_u16x16(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (_, a1) = self.split_u16x32(a);
        let (_, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.zip_low_u16x16(a1, b1), self.zip_high_u16x16(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.unzip_low_u16x16(a0, a1), self.unzip_low_u16x16(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(
            self.unzip_high_u16x16(a0, a1),
            self.unzip_high_u16x16(b0, b1),
        )
    }
    #[inline(always)]
    fn select_u16x32(self, a: mask16x32<Self>, b: u16x32<Self>, c: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        let (c0, c1) = self.split_u16x32(c);
        self.combine_u16x16(
            self.select_u16x16(a0, b0, c0),
            self.select_u16x16(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn min_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.min_u16x16(a0, b0), self.min_u16x16(a1, b1))
    }
    #[inline(always)]
    fn max_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.max_u16x16(a0, b0), self.max_u16x16(a1, b1))
    }
    #[inline(always)]
    fn split_u16x32(self, a: u16x32<Self>) -> (u16x16<Self>, u16x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn load_interleaved_128_u16x32(self, src: &[u16; 32usize]) -> u16x32<Self> {
        unsafe { vld4q_u16(src.as_ptr()).simd_into(self) }
    }
    #[inline(always)]
    fn store_interleaved_128_u16x32(self, a: u16x32<Self>, dest: &mut [u16; 32usize]) -> () {
        unsafe { vst4q_u16(dest.as_mut_ptr(), a.into()) }
    }
    #[inline(always)]
    fn narrow_u16x32(self, a: u16x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u8x16(self.narrow_u16x16(a0), self.narrow_u16x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_u16x32(self, a: u16x32<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u8x32(
            self.reinterpret_u8_u16x16(a0),
            self.reinterpret_u8_u16x16(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_u32_u16x32(self, a: u16x32<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u32x8(
            self.reinterpret_u32_u16x16(a0),
            self.reinterpret_u32_u16x16(a1),
        )
    }
    #[inline(always)]
    fn splat_mask16x32(self, a: i16) -> mask16x32<Self> {
        let half = self.splat_mask16x16(a);
        self.combine_mask16x16(half, half)
    }
    #[inline(always)]
    fn not_mask16x32(self, a: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        self.combine_mask16x16(self.not_mask16x16(a0), self.not_mask16x16(a1))
    }
    #[inline(always)]
    fn and_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        self.combine_mask16x16(self.and_mask16x16(a0, b0), self.and_mask16x16(a1, b1))
    }
    #[inline(always)]
    fn or_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        self.combine_mask16x16(self.or_mask16x16(a0, b0), self.or_mask16x16(a1, b1))
    }
    #[inline(always)]
    fn xor_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        self.combine_mask16x16(self.xor_mask16x16(a0, b0), self.xor_mask16x16(a1, b1))
    }
    #[inline(always)]
    fn select_mask16x32(
        self,
        a: mask16x32<Self>,
        b: mask16x32<Self>,
        c: mask16x32<Self>,
    ) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        let (c0, c1) = self.split_mask16x32(c);
        self.combine_mask16x16(
            self.select_mask16x16(a0, b0, c0),
            self.select_mask16x16(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        self.combine_mask16x16(
            self.simd_eq_mask16x16(a0, b0),
            self.simd_eq_mask16x16(a1, b1),
        )
    }
    #[inline(always)]
    fn split_mask16x32(self, a: mask16x32<Self>) -> (mask16x16<Self>, mask16x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_i32x16(self, a: i32) -> i32x16<Self> {
        let half = self.splat_i32x8(a);
        self.combine_i32x8(half, half)
    }
    #[inline(always)]
    fn not_i32x16(self, a: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_i32x8(self.not_i32x8(a0), self.not_i32x8(a1))
    }
    #[inline(always)]
    fn add_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.add_i32x8(a0, b0), self.add_i32x8(a1, b1))
    }
    #[inline(always)]
    fn sub_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.sub_i32x8(a0, b0), self.sub_i32x8(a1, b1))
    }
    #[inline(always)]
    fn mul_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.mul_i32x8(a0, b0), self.mul_i32x8(a1, b1))
    }
    #[inline(always)]
    fn and_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.and_i32x8(a0, b0), self.and_i32x8(a1, b1))
    }
    #[inline(always)]
    fn or_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.or_i32x8(a0, b0), self.or_i32x8(a1, b1))
    }
    #[inline(always)]
    fn xor_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.xor_i32x8(a0, b0), self.xor_i32x8(a1, b1))
    }
    #[inline(always)]
    fn shr_i32x16(self, a: i32x16<Self>, b: u32) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_i32x8(self.shr_i32x8(a0, b), self.shr_i32x8(a1, b))
    }
    #[inline(always)]
    fn shrv_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.shrv_i32x8(a0, b0), self.shrv_i32x8(a1, b1))
    }
    #[inline(always)]
    fn shl_i32x16(self, a: i32x16<Self>, b: u32) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_i32x8(self.shl_i32x8(a0, b), self.shl_i32x8(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_eq_i32x8(a0, b0), self.simd_eq_i32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_lt_i32x8(a0, b0), self.simd_lt_i32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_le_i32x8(a0, b0), self.simd_le_i32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_ge_i32x8(a0, b0), self.simd_ge_i32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_gt_i32x8(a0, b0), self.simd_gt_i32x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, _) = self.split_i32x16(a);
        let (b0, _) = self.split_i32x16(b);
        self.combine_i32x8(self.zip_low_i32x8(a0, b0), self.zip_high_i32x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (_, a1) = self.split_i32x16(a);
        let (_, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.zip_low_i32x8(a1, b1), self.zip_high_i32x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.unzip_low_i32x8(a0, a1), self.unzip_low_i32x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.unzip_high_i32x8(a0, a1), self.unzip_high_i32x8(b0, b1))
    }
    #[inline(always)]
    fn select_i32x16(self, a: mask32x16<Self>, b: i32x16<Self>, c: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        let (c0, c1) = self.split_i32x16(c);
        self.combine_i32x8(self.select_i32x8(a0, b0, c0), self.select_i32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.min_i32x8(a0, b0), self.min_i32x8(a1, b1))
    }
    #[inline(always)]
    fn max_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.max_i32x8(a0, b0), self.max_i32x8(a1, b1))
    }
    #[inline(always)]
    fn split_i32x16(self, a: i32x16<Self>) -> (i32x8<Self>, i32x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i32x16(self, a: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_i32x8(self.neg_i32x8(a0), self.neg_i32x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i32x16(self, a: i32x16<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_u8x32(self.reinterpret_u8_i32x8(a0), self.reinterpret_u8_i32x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i32x16(self, a: i32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_u32x8(
            self.reinterpret_u32_i32x8(a0),
            self.reinterpret_u32_i32x8(a1),
        )
    }
    #[inline(always)]
    fn cvt_f32_i32x16(self, a: i32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_f32x8(self.cvt_f32_i32x8(a0), self.cvt_f32_i32x8(a1))
    }
    #[inline(always)]
    fn splat_u32x16(self, a: u32) -> u32x16<Self> {
        let half = self.splat_u32x8(a);
        self.combine_u32x8(half, half)
    }
    #[inline(always)]
    fn not_u32x16(self, a: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_u32x8(self.not_u32x8(a0), self.not_u32x8(a1))
    }
    #[inline(always)]
    fn add_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.add_u32x8(a0, b0), self.add_u32x8(a1, b1))
    }
    #[inline(always)]
    fn sub_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.sub_u32x8(a0, b0), self.sub_u32x8(a1, b1))
    }
    #[inline(always)]
    fn mul_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.mul_u32x8(a0, b0), self.mul_u32x8(a1, b1))
    }
    #[inline(always)]
    fn and_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.and_u32x8(a0, b0), self.and_u32x8(a1, b1))
    }
    #[inline(always)]
    fn or_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.or_u32x8(a0, b0), self.or_u32x8(a1, b1))
    }
    #[inline(always)]
    fn xor_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.xor_u32x8(a0, b0), self.xor_u32x8(a1, b1))
    }
    #[inline(always)]
    fn shr_u32x16(self, a: u32x16<Self>, b: u32) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_u32x8(self.shr_u32x8(a0, b), self.shr_u32x8(a1, b))
    }
    #[inline(always)]
    fn shrv_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.shrv_u32x8(a0, b0), self.shrv_u32x8(a1, b1))
    }
    #[inline(always)]
    fn shl_u32x16(self, a: u32x16<Self>, b: u32) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_u32x8(self.shl_u32x8(a0, b), self.shl_u32x8(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_eq_u32x8(a0, b0), self.simd_eq_u32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_lt_u32x8(a0, b0), self.simd_lt_u32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_le_u32x8(a0, b0), self.simd_le_u32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_ge_u32x8(a0, b0), self.simd_ge_u32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_gt_u32x8(a0, b0), self.simd_gt_u32x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, _) = self.split_u32x16(a);
        let (b0, _) = self.split_u32x16(b);
        self.combine_u32x8(self.zip_low_u32x8(a0, b0), self.zip_high_u32x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (_, a1) = self.split_u32x16(a);
        let (_, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.zip_low_u32x8(a1, b1), self.zip_high_u32x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.unzip_low_u32x8(a0, a1), self.unzip_low_u32x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.unzip_high_u32x8(a0, a1), self.unzip_high_u32x8(b0, b1))
    }
    #[inline(always)]
    fn select_u32x16(self, a: mask32x16<Self>, b: u32x16<Self>, c: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        let (c0, c1) = self.split_u32x16(c);
        self.combine_u32x8(self.select_u32x8(a0, b0, c0), self.select_u32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.min_u32x8(a0, b0), self.min_u32x8(a1, b1))
    }
    #[inline(always)]
    fn max_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.max_u32x8(a0, b0), self.max_u32x8(a1, b1))
    }
    #[inline(always)]
    fn split_u32x16(self, a: u32x16<Self>) -> (u32x8<Self>, u32x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn load_interleaved_128_u32x16(self, src: &[u32; 16usize]) -> u32x16<Self> {
        unsafe { vld4q_u32(src.as_ptr()).simd_into(self) }
    }
    #[inline(always)]
    fn store_interleaved_128_u32x16(self, a: u32x16<Self>, dest: &mut [u32; 16usize]) -> () {
        unsafe { vst4q_u32(dest.as_mut_ptr(), a.into()) }
    }
    #[inline(always)]
    fn reinterpret_u8_u32x16(self, a: u32x16<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_u8x32(self.reinterpret_u8_u32x8(a0), self.reinterpret_u8_u32x8(a1))
    }
    #[inline(always)]
    fn cvt_f32_u32x16(self, a: u32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_f32x8(self.cvt_f32_u32x8(a0), self.cvt_f32_u32x8(a1))
    }
    #[inline(always)]
    fn splat_mask32x16(self, a: i32) -> mask32x16<Self> {
        let half = self.splat_mask32x8(a);
        self.combine_mask32x8(half, half)
    }
    #[inline(always)]
    fn not_mask32x16(self, a: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        self.combine_mask32x8(self.not_mask32x8(a0), self.not_mask32x8(a1))
    }
    #[inline(always)]
    fn and_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        self.combine_mask32x8(self.and_mask32x8(a0, b0), self.and_mask32x8(a1, b1))
    }
    #[inline(always)]
    fn or_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        self.combine_mask32x8(self.or_mask32x8(a0, b0), self.or_mask32x8(a1, b1))
    }
    #[inline(always)]
    fn xor_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        self.combine_mask32x8(self.xor_mask32x8(a0, b0), self.xor_mask32x8(a1, b1))
    }
    #[inline(always)]
    fn select_mask32x16(
        self,
        a: mask32x16<Self>,
        b: mask32x16<Self>,
        c: mask32x16<Self>,
    ) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        let (c0, c1) = self.split_mask32x16(c);
        self.combine_mask32x8(
            self.select_mask32x8(a0, b0, c0),
            self.select_mask32x8(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        self.combine_mask32x8(self.simd_eq_mask32x8(a0, b0), self.simd_eq_mask32x8(a1, b1))
    }
    #[inline(always)]
    fn split_mask32x16(self, a: mask32x16<Self>) -> (mask32x8<Self>, mask32x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_f64x8(self, a: f64) -> f64x8<Self> {
        let half = self.splat_f64x4(a);
        self.combine_f64x4(half, half)
    }
    #[inline(always)]
    fn abs_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.abs_f64x4(a0), self.abs_f64x4(a1))
    }
    #[inline(always)]
    fn neg_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.neg_f64x4(a0), self.neg_f64x4(a1))
    }
    #[inline(always)]
    fn sqrt_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.sqrt_f64x4(a0), self.sqrt_f64x4(a1))
    }
    #[inline(always)]
    fn add_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.add_f64x4(a0, b0), self.add_f64x4(a1, b1))
    }
    #[inline(always)]
    fn sub_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.sub_f64x4(a0, b0), self.sub_f64x4(a1, b1))
    }
    #[inline(always)]
    fn mul_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.mul_f64x4(a0, b0), self.mul_f64x4(a1, b1))
    }
    #[inline(always)]
    fn div_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.div_f64x4(a0, b0), self.div_f64x4(a1, b1))
    }
    #[inline(always)]
    fn copysign_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.copysign_f64x4(a0, b0), self.copysign_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_eq_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_eq_f64x4(a0, b0), self.simd_eq_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_lt_f64x4(a0, b0), self.simd_lt_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_le_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_le_f64x4(a0, b0), self.simd_le_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_ge_f64x4(a0, b0), self.simd_ge_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_gt_f64x4(a0, b0), self.simd_gt_f64x4(a1, b1))
    }
    #[inline(always)]
    fn zip_low_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, _) = self.split_f64x8(a);
        let (b0, _) = self.split_f64x8(b);
        self.combine_f64x4(self.zip_low_f64x4(a0, b0), self.zip_high_f64x4(a0, b0))
    }
    #[inline(always)]
    fn zip_high_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (_, a1) = self.split_f64x8(a);
        let (_, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.zip_low_f64x4(a1, b1), self.zip_high_f64x4(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.unzip_low_f64x4(a0, a1), self.unzip_low_f64x4(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.unzip_high_f64x4(a0, a1), self.unzip_high_f64x4(b0, b1))
    }
    #[inline(always)]
    fn max_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.max_f64x4(a0, b0), self.max_f64x4(a1, b1))
    }
    #[inline(always)]
    fn max_precise_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(
            self.max_precise_f64x4(a0, b0),
            self.max_precise_f64x4(a1, b1),
        )
    }
    #[inline(always)]
    fn min_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.min_f64x4(a0, b0), self.min_f64x4(a1, b1))
    }
    #[inline(always)]
    fn min_precise_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(
            self.min_precise_f64x4(a0, b0),
            self.min_precise_f64x4(a1, b1),
        )
    }
    #[inline(always)]
    fn madd_f64x8(self, a: f64x8<Self>, b: f64x8<Self>, c: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        let (c0, c1) = self.split_f64x8(c);
        self.combine_f64x4(self.madd_f64x4(a0, b0, c0), self.madd_f64x4(a1, b1, c1))
    }
    #[inline(always)]
    fn msub_f64x8(self, a: f64x8<Self>, b: f64x8<Self>, c: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        let (c0, c1) = self.split_f64x8(c);
        self.combine_f64x4(self.msub_f64x4(a0, b0, c0), self.msub_f64x4(a1, b1, c1))
    }
    #[inline(always)]
    fn floor_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.floor_f64x4(a0), self.floor_f64x4(a1))
    }
    #[inline(always)]
    fn fract_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.fract_f64x4(a0), self.fract_f64x4(a1))
    }
    #[inline(always)]
    fn trunc_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.trunc_f64x4(a0), self.trunc_f64x4(a1))
    }
    #[inline(always)]
    fn select_f64x8(self, a: mask64x8<Self>, b: f64x8<Self>, c: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        let (c0, c1) = self.split_f64x8(c);
        self.combine_f64x4(self.select_f64x4(a0, b0, c0), self.select_f64x4(a1, b1, c1))
    }
    #[inline(always)]
    fn split_f64x8(self, a: f64x8<Self>) -> (f64x4<Self>, f64x4<Self>) {
        let mut b0 = [0.0; 4usize];
        let mut b1 = [0.0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_f32_f64x8(self, a: f64x8<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f32x8(
            self.reinterpret_f32_f64x4(a0),
            self.reinterpret_f32_f64x4(a1),
        )
    }
    #[inline(always)]
    fn splat_mask64x8(self, a: i64) -> mask64x8<Self> {
        let half = self.splat_mask64x4(a);
        self.combine_mask64x4(half, half)
    }
    #[inline(always)]
    fn not_mask64x8(self, a: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        self.combine_mask64x4(self.not_mask64x4(a0), self.not_mask64x4(a1))
    }
    #[inline(always)]
    fn and_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        self.combine_mask64x4(self.and_mask64x4(a0, b0), self.and_mask64x4(a1, b1))
    }
    #[inline(always)]
    fn or_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        self.combine_mask64x4(self.or_mask64x4(a0, b0), self.or_mask64x4(a1, b1))
    }
    #[inline(always)]
    fn xor_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        self.combine_mask64x4(self.xor_mask64x4(a0, b0), self.xor_mask64x4(a1, b1))
    }
    #[inline(always)]
    fn select_mask64x8(
        self,
        a: mask64x8<Self>,
        b: mask64x8<Self>,
        c: mask64x8<Self>,
    ) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        let (c0, c1) = self.split_mask64x8(c);
        self.combine_mask64x4(
            self.select_mask64x4(a0, b0, c0),
            self.select_mask64x4(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        self.combine_mask64x4(self.simd_eq_mask64x4(a0, b0), self.simd_eq_mask64x4(a1, b1))
    }
    #[inline(always)]
    fn split_mask64x8(self, a: mask64x8<Self>) -> (mask64x4<Self>, mask64x4<Self>) {
        let mut b0 = [0; 4usize];
        let mut b1 = [0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
}
impl<S: Simd> SimdFrom<float32x4_t, S> for f32x4<S> {
    #[inline(always)]
    fn simd_from(arch: float32x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<f32x4<S>> for float32x4_t {
    #[inline(always)]
    fn from(value: f32x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int8x16_t, S> for i8x16<S> {
    #[inline(always)]
    fn simd_from(arch: int8x16_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i8x16<S>> for int8x16_t {
    #[inline(always)]
    fn from(value: i8x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<uint8x16_t, S> for u8x16<S> {
    #[inline(always)]
    fn simd_from(arch: uint8x16_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u8x16<S>> for uint8x16_t {
    #[inline(always)]
    fn from(value: u8x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int8x16_t, S> for mask8x16<S> {
    #[inline(always)]
    fn simd_from(arch: int8x16_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask8x16<S>> for int8x16_t {
    #[inline(always)]
    fn from(value: mask8x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int16x8_t, S> for i16x8<S> {
    #[inline(always)]
    fn simd_from(arch: int16x8_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i16x8<S>> for int16x8_t {
    #[inline(always)]
    fn from(value: i16x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<uint16x8_t, S> for u16x8<S> {
    #[inline(always)]
    fn simd_from(arch: uint16x8_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u16x8<S>> for uint16x8_t {
    #[inline(always)]
    fn from(value: u16x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int16x8_t, S> for mask16x8<S> {
    #[inline(always)]
    fn simd_from(arch: int16x8_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask16x8<S>> for int16x8_t {
    #[inline(always)]
    fn from(value: mask16x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int32x4_t, S> for i32x4<S> {
    #[inline(always)]
    fn simd_from(arch: int32x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i32x4<S>> for int32x4_t {
    #[inline(always)]
    fn from(value: i32x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<uint32x4_t, S> for u32x4<S> {
    #[inline(always)]
    fn simd_from(arch: uint32x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u32x4<S>> for uint32x4_t {
    #[inline(always)]
    fn from(value: u32x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int32x4_t, S> for mask32x4<S> {
    #[inline(always)]
    fn simd_from(arch: int32x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask32x4<S>> for int32x4_t {
    #[inline(always)]
    fn from(value: mask32x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<float64x2_t, S> for f64x2<S> {
    #[inline(always)]
    fn simd_from(arch: float64x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<f64x2<S>> for float64x2_t {
    #[inline(always)]
    fn from(value: f64x2<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int64x2_t, S> for mask64x2<S> {
    #[inline(always)]
    fn simd_from(arch: int64x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask64x2<S>> for int64x2_t {
    #[inline(always)]
    fn from(value: mask64x2<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<float32x4x2_t, S> for f32x8<S> {
    #[inline(always)]
    fn simd_from(arch: float32x4x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<f32x8<S>> for float32x4x2_t {
    #[inline(always)]
    fn from(value: f32x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int8x16x2_t, S> for i8x32<S> {
    #[inline(always)]
    fn simd_from(arch: int8x16x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i8x32<S>> for int8x16x2_t {
    #[inline(always)]
    fn from(value: i8x32<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<uint8x16x2_t, S> for u8x32<S> {
    #[inline(always)]
    fn simd_from(arch: uint8x16x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u8x32<S>> for uint8x16x2_t {
    #[inline(always)]
    fn from(value: u8x32<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int8x16x2_t, S> for mask8x32<S> {
    #[inline(always)]
    fn simd_from(arch: int8x16x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask8x32<S>> for int8x16x2_t {
    #[inline(always)]
    fn from(value: mask8x32<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int16x8x2_t, S> for i16x16<S> {
    #[inline(always)]
    fn simd_from(arch: int16x8x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i16x16<S>> for int16x8x2_t {
    #[inline(always)]
    fn from(value: i16x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<uint16x8x2_t, S> for u16x16<S> {
    #[inline(always)]
    fn simd_from(arch: uint16x8x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u16x16<S>> for uint16x8x2_t {
    #[inline(always)]
    fn from(value: u16x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int16x8x2_t, S> for mask16x16<S> {
    #[inline(always)]
    fn simd_from(arch: int16x8x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask16x16<S>> for int16x8x2_t {
    #[inline(always)]
    fn from(value: mask16x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int32x4x2_t, S> for i32x8<S> {
    #[inline(always)]
    fn simd_from(arch: int32x4x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i32x8<S>> for int32x4x2_t {
    #[inline(always)]
    fn from(value: i32x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<uint32x4x2_t, S> for u32x8<S> {
    #[inline(always)]
    fn simd_from(arch: uint32x4x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u32x8<S>> for uint32x4x2_t {
    #[inline(always)]
    fn from(value: u32x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int32x4x2_t, S> for mask32x8<S> {
    #[inline(always)]
    fn simd_from(arch: int32x4x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask32x8<S>> for int32x4x2_t {
    #[inline(always)]
    fn from(value: mask32x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<float64x2x2_t, S> for f64x4<S> {
    #[inline(always)]
    fn simd_from(arch: float64x2x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<f64x4<S>> for float64x2x2_t {
    #[inline(always)]
    fn from(value: f64x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int64x2x2_t, S> for mask64x4<S> {
    #[inline(always)]
    fn simd_from(arch: int64x2x2_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask64x4<S>> for int64x2x2_t {
    #[inline(always)]
    fn from(value: mask64x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<float32x4x4_t, S> for f32x16<S> {
    #[inline(always)]
    fn simd_from(arch: float32x4x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<f32x16<S>> for float32x4x4_t {
    #[inline(always)]
    fn from(value: f32x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int8x16x4_t, S> for i8x64<S> {
    #[inline(always)]
    fn simd_from(arch: int8x16x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i8x64<S>> for int8x16x4_t {
    #[inline(always)]
    fn from(value: i8x64<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<uint8x16x4_t, S> for u8x64<S> {
    #[inline(always)]
    fn simd_from(arch: uint8x16x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u8x64<S>> for uint8x16x4_t {
    #[inline(always)]
    fn from(value: u8x64<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int8x16x4_t, S> for mask8x64<S> {
    #[inline(always)]
    fn simd_from(arch: int8x16x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask8x64<S>> for int8x16x4_t {
    #[inline(always)]
    fn from(value: mask8x64<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int16x8x4_t, S> for i16x32<S> {
    #[inline(always)]
    fn simd_from(arch: int16x8x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i16x32<S>> for int16x8x4_t {
    #[inline(always)]
    fn from(value: i16x32<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<uint16x8x4_t, S> for u16x32<S> {
    #[inline(always)]
    fn simd_from(arch: uint16x8x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u16x32<S>> for uint16x8x4_t {
    #[inline(always)]
    fn from(value: u16x32<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int16x8x4_t, S> for mask16x32<S> {
    #[inline(always)]
    fn simd_from(arch: int16x8x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask16x32<S>> for int16x8x4_t {
    #[inline(always)]
    fn from(value: mask16x32<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int32x4x4_t, S> for i32x16<S> {
    #[inline(always)]
    fn simd_from(arch: int32x4x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i32x16<S>> for int32x4x4_t {
    #[inline(always)]
    fn from(value: i32x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<uint32x4x4_t, S> for u32x16<S> {
    #[inline(always)]
    fn simd_from(arch: uint32x4x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u32x16<S>> for uint32x4x4_t {
    #[inline(always)]
    fn from(value: u32x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int32x4x4_t, S> for mask32x16<S> {
    #[inline(always)]
    fn simd_from(arch: int32x4x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask32x16<S>> for int32x4x4_t {
    #[inline(always)]
    fn from(value: mask32x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<float64x2x4_t, S> for f64x8<S> {
    #[inline(always)]
    fn simd_from(arch: float64x2x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<f64x8<S>> for float64x2x4_t {
    #[inline(always)]
    fn from(value: f64x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<int64x2x4_t, S> for mask64x8<S> {
    #[inline(always)]
    fn simd_from(arch: int64x2x4_t, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask64x8<S>> for int64x2x4_t {
    #[inline(always)]
    fn from(value: mask64x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
