#! /bin/sh

# Test upload of a CSV file.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g')

DB_DIR=db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}.db

sqlite3 ${TMP_DB_FILE} <<END
    create table sample (
        id integer primary key not null,
        uuid char(36),
        SolsaID char(12)
    );
    create unique index sample_SolsaID on sample(SolsaID);
END

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}.db/sample"
export HTTP_HOST=restfuldb.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=------------------------b989696a28305e74"
export REMOTE_USER=writer

echo "==="

perl -lne 'print "$_\r"' <<EOF |
--------------------------b989696a28305e74
Content-Disposition: form-data; name="jsonfile"; filename="fill.csv"
Content-Type: text/plain

{
   "data" : [
      {
         "type" : "sample",
         "attributes" : {
            "SolsaID" : "VU-TEST-0001"
         }
      },
      {
         "type" : "sample",
         "attributes" : {
            "SolsaID" : "VU-TEST-0001"
         }
      },
      {
         "type" : "sample",
         "attributes" : {
            "SolsaID" : "VU-TEST-0001"
         }
      }
   ]
}

--------------------------b989696a28305e74--
EOF
${INPUT_SCRIPT}

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from sample order by id';

rm -f ${TMP_DB_FILE}
