// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from AssetStrip.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.assetmgrmodel {
  public class AssetStrip_2_0_4 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip:2.0.4", null);

    public AssetStrip_2_0_4(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public AssetStrip_2_0_4(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new AssetStrip_2_0_4 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new AssetStrip_2_0_4(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int NO_ERROR = 0;

    public const int ERR_INVALID_PARAM = 1;

    public const int ERR_NO_SUCH_OBJECT = 2;

    public const int ERR_NOT_SUPPORTED = 3;

    public const int ERR_OPERATION_FAILED = 4;

    public const int MAIN_STRIP_COLUMN = 0;

    public enum State {
      DISCONNECTED,
      FIRMWARE_UPDATE,
      UNSUPPORTED,
      AVAILABLE,
    }

    public enum StripType {
      SIMPLE,
      COMPOSITE,
    }

    public enum TagType {
      SINGLE,
      EXTENSION,
      NONE,
    }

    public enum CascadeState {
      CASCADE_ACTIVE,
      CASCADE_FIRMWARE_UPDATE,
    }

    public class DeviceInfo : ICloneable {
      public object Clone() {
        DeviceInfo copy = new DeviceInfo();
        copy.deviceId = this.deviceId;
        copy.hardwareId = this.hardwareId;
        copy.protocolVersion = this.protocolVersion;
        copy.bootVersion = this.bootVersion;
        copy.appVersion = this.appVersion;
        copy.orientationSensAvailable = this.orientationSensAvailable;
        copy.isCascadable = this.isCascadable;
        copy.rackUnitCountConfigurable = this.rackUnitCountConfigurable;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["deviceId"] = this.deviceId;
        json["hardwareId"] = this.hardwareId;
        json["protocolVersion"] = this.protocolVersion;
        json["bootVersion"] = this.bootVersion;
        json["appVersion"] = this.appVersion;
        json["orientationSensAvailable"] = this.orientationSensAvailable;
        json["isCascadable"] = this.isCascadable;
        json["rackUnitCountConfigurable"] = this.rackUnitCountConfigurable;
        return json;
      }

      public static DeviceInfo Decode(LightJson.JsonObject json, Agent agent) {
        DeviceInfo inst = new DeviceInfo();
        inst.deviceId = (int)json["deviceId"];
        inst.hardwareId = (int)json["hardwareId"];
        inst.protocolVersion = (int)json["protocolVersion"];
        inst.bootVersion = (int)json["bootVersion"];
        inst.appVersion = (int)json["appVersion"];
        inst.orientationSensAvailable = (bool)json["orientationSensAvailable"];
        inst.isCascadable = (bool)json["isCascadable"];
        inst.rackUnitCountConfigurable = (bool)json["rackUnitCountConfigurable"];
        return inst;
      }

      public int deviceId = 0;
      public int hardwareId = 0;
      public int protocolVersion = 0;
      public int bootVersion = 0;
      public int appVersion = 0;
      public bool orientationSensAvailable = false;
      public bool isCascadable = false;
      public bool rackUnitCountConfigurable = false;
    }

    public class StripInfo : ICloneable {
      public object Clone() {
        StripInfo copy = new StripInfo();
        copy.maxMainTagCount = this.maxMainTagCount;
        copy.maxBladeTagCount = this.maxBladeTagCount;
        copy.mainTagCount = this.mainTagCount;
        copy.bladeTagCount = this.bladeTagCount;
        copy.bladeOverflow = this.bladeOverflow;
        copy.rackUnitCount = this.rackUnitCount;
        copy.componentCount = this.componentCount;
        copy.cascadeState = this.cascadeState;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["maxMainTagCount"] = this.maxMainTagCount;
        json["maxBladeTagCount"] = this.maxBladeTagCount;
        json["mainTagCount"] = this.mainTagCount;
        json["bladeTagCount"] = this.bladeTagCount;
        json["bladeOverflow"] = this.bladeOverflow;
        json["rackUnitCount"] = this.rackUnitCount;
        json["componentCount"] = this.componentCount;
        json["cascadeState"] = (int)this.cascadeState;
        return json;
      }

      public static StripInfo Decode(LightJson.JsonObject json, Agent agent) {
        StripInfo inst = new StripInfo();
        inst.maxMainTagCount = (int)json["maxMainTagCount"];
        inst.maxBladeTagCount = (int)json["maxBladeTagCount"];
        inst.mainTagCount = (int)json["mainTagCount"];
        inst.bladeTagCount = (int)json["bladeTagCount"];
        inst.bladeOverflow = (bool)json["bladeOverflow"];
        inst.rackUnitCount = (int)json["rackUnitCount"];
        inst.componentCount = (int)json["componentCount"];
        inst.cascadeState = (Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.CascadeState)(int)json["cascadeState"];
        return inst;
      }

      public int maxMainTagCount = 0;
      public int maxBladeTagCount = 0;
      public int mainTagCount = 0;
      public int bladeTagCount = 0;
      public bool bladeOverflow = false;
      public int rackUnitCount = 0;
      public int componentCount = 0;
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.CascadeState cascadeState = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.CascadeState.CASCADE_ACTIVE;
    }

    public class TagInfo : ICloneable {
      public object Clone() {
        TagInfo copy = new TagInfo();
        copy.rackUnitNumber = this.rackUnitNumber;
        copy.slotNumber = this.slotNumber;
        copy.familyDesc = this.familyDesc;
        copy.rawId = this.rawId;
        copy.programmable = this.programmable;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["rackUnitNumber"] = this.rackUnitNumber;
        json["slotNumber"] = this.slotNumber;
        json["familyDesc"] = this.familyDesc;
        json["rawId"] = this.rawId;
        json["programmable"] = this.programmable;
        return json;
      }

      public static TagInfo Decode(LightJson.JsonObject json, Agent agent) {
        TagInfo inst = new TagInfo();
        inst.rackUnitNumber = (int)json["rackUnitNumber"];
        inst.slotNumber = (int)json["slotNumber"];
        inst.familyDesc = (string)json["familyDesc"];
        inst.rawId = (string)json["rawId"];
        inst.programmable = (bool)json["programmable"];
        return inst;
      }

      public int rackUnitNumber = 0;
      public int slotNumber = 0;
      public string familyDesc = "";
      public string rawId = "";
      public bool programmable = false;
    }

    public class RackUnitInfo : ICloneable {
      public object Clone() {
        RackUnitInfo copy = new RackUnitInfo();
        copy.rackUnitNumber = this.rackUnitNumber;
        copy.rackUnitPosition = this.rackUnitPosition;
        copy.type = this.type;
        copy.size = this.size;
        copy.settings = this.settings;
        copy.assetStripCascadePosition = this.assetStripCascadePosition;
        copy.rackUnitRelativePosition = this.rackUnitRelativePosition;
        copy.assetStripNumberOfRackUnits = this.assetStripNumberOfRackUnits;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["rackUnitNumber"] = this.rackUnitNumber;
        json["rackUnitPosition"] = this.rackUnitPosition;
        json["type"] = (int)this.type;
        json["size"] = this.size;
        json["settings"] = this.settings.Encode();
        json["assetStripCascadePosition"] = this.assetStripCascadePosition;
        json["rackUnitRelativePosition"] = this.rackUnitRelativePosition;
        json["assetStripNumberOfRackUnits"] = this.assetStripNumberOfRackUnits;
        return json;
      }

      public static RackUnitInfo Decode(LightJson.JsonObject json, Agent agent) {
        RackUnitInfo inst = new RackUnitInfo();
        inst.rackUnitNumber = (int)json["rackUnitNumber"];
        inst.rackUnitPosition = (int)json["rackUnitPosition"];
        inst.type = (Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagType)(int)json["type"];
        inst.size = (int)json["size"];
        inst.settings = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig_1_0_1.RackUnitSettings.Decode(json["settings"], agent);
        inst.assetStripCascadePosition = (int)json["assetStripCascadePosition"];
        inst.rackUnitRelativePosition = (int)json["rackUnitRelativePosition"];
        inst.assetStripNumberOfRackUnits = (int)json["assetStripNumberOfRackUnits"];
        return inst;
      }

      public int rackUnitNumber = 0;
      public int rackUnitPosition = 0;
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagType type = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagType.SINGLE;
      public int size = 0;
      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig_1_0_1.RackUnitSettings settings = new Com.Raritan.Idl.assetmgrmodel.AssetStripConfig_1_0_1.RackUnitSettings();
      public int assetStripCascadePosition = 0;
      public int rackUnitRelativePosition = 0;
      public int assetStripNumberOfRackUnits = 0;
    }

    public class StripInfoChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip_2_0_4.StripInfoChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.StripInfo oldInfo = new Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.StripInfo();
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.StripInfo newInfo = new Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.StripInfo();
    }

    public class StateChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip_2_0_4.StateChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.State oldState = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.State.DISCONNECTED;
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.State newState = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.State.DISCONNECTED;
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.DeviceInfo deviceInfo = new Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.DeviceInfo();
    }

    public class RackUnitChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip_2_0_4.RackUnitChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int rackUnitNumber = 0;
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo rackUnit = new Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo();
    }

    public class TagChangeInfo : ICloneable {
      public object Clone() {
        TagChangeInfo copy = new TagChangeInfo();
        copy.tag = this.tag;
        copy.info = this.info;
        copy.parentBladeTagId = this.parentBladeTagId;
        copy.slotPosition = this.slotPosition;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["tag"] = this.tag.Encode();
        json["info"] = this.info.Encode();
        json["parentBladeTagId"] = this.parentBladeTagId;
        json["slotPosition"] = this.slotPosition;
        return json;
      }

      public static TagChangeInfo Decode(LightJson.JsonObject json, Agent agent) {
        TagChangeInfo inst = new TagChangeInfo();
        inst.tag = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo.Decode(json["tag"], agent);
        inst.info = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo.Decode(json["info"], agent);
        inst.parentBladeTagId = (string)json["parentBladeTagId"];
        inst.slotPosition = (int)json["slotPosition"];
        return inst;
      }

      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo tag = new Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo();
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo info = new Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo();
      public string parentBladeTagId = "";
      public int slotPosition = 0;
    }

    public class TagEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip_2_0_4.TagEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagChangeInfo> tags = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagChangeInfo>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo> allTags = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo>();
    }

    public class TagAddedEvent : Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip_2_0_4.TagAddedEvent:1.0.0", Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagEvent.typeInfo);

    }

    public class TagRemovedEvent : Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip_2_0_4.TagRemovedEvent:1.0.0", Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagEvent.typeInfo);

    }

    public enum FirmwareUpdateState {
      UPDATE_STARTED,
      UPDATE_SUCCESSFUL,
      UPDATE_FAILED,
    }

    public class FirmwareUpdateStateChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip_2_0_4.FirmwareUpdateStateChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.FirmwareUpdateState state = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.FirmwareUpdateState.UPDATE_STARTED;
    }

    public class BladeOverflowChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip_2_0_4.BladeOverflowChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public bool overflow = false;
    }

    public class OrientationChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip_2_0_4.OrientationChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig_1_0_1.Orientation oldOrientation = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig_1_0_1.Orientation.TOP_CONNECTOR;
      public Com.Raritan.Idl.assetmgrmodel.AssetStripConfig_1_0_1.Orientation newOrientation = Com.Raritan.Idl.assetmgrmodel.AssetStripConfig_1_0_1.Orientation.TOP_CONNECTOR;
    }

    public class CompositionChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip_2_0_4.CompositionChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public int oldComponentCount = 0;
      public int newComponentCount = 0;
    }

    public class GetStateResult {
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.State _ret_;
    }

    public GetStateResult getState() {
      JsonObject _parameters = null;
      var _result = RpcCall("getState", _parameters);
      var _ret = new GetStateResult();
      _ret._ret_ = (Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.State)(int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest getState(AsyncRpcResponse<GetStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getState(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getState(AsyncRpcResponse<GetStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getState", _parameters,
        _result => {
          try {
            var _ret = new GetStateResult();
            _ret._ret_ = (Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.State)(int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetDeviceInfoResult {
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.DeviceInfo _ret_;
    }

    public GetDeviceInfoResult getDeviceInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDeviceInfo", _parameters);
      var _ret = new GetDeviceInfoResult();
      _ret._ret_ = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.DeviceInfo.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getDeviceInfo(AsyncRpcResponse<GetDeviceInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDeviceInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDeviceInfo(AsyncRpcResponse<GetDeviceInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDeviceInfo", _parameters,
        _result => {
          try {
            var _ret = new GetDeviceInfoResult();
            _ret._ret_ = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.DeviceInfo.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetStripInfoResult {
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.StripInfo _ret_;
    }

    public GetStripInfoResult getStripInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getStripInfo", _parameters);
      var _ret = new GetStripInfoResult();
      _ret._ret_ = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.StripInfo.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getStripInfo(AsyncRpcResponse<GetStripInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getStripInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getStripInfo(AsyncRpcResponse<GetStripInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getStripInfo", _parameters,
        _result => {
          try {
            var _ret = new GetStripInfoResult();
            _ret._ret_ = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.StripInfo.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetRackUnitInfoResult {
      public int _ret_;
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo info;
    }

    public GetRackUnitInfoResult getRackUnitInfo(int rackUnitNumber) {
      var _parameters = new LightJson.JsonObject();
      _parameters["rackUnitNumber"] = rackUnitNumber;

      var _result = RpcCall("getRackUnitInfo", _parameters);
      var _ret = new GetRackUnitInfoResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.info = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo.Decode(_result["info"], agent);
      return _ret;
    }

    public AsyncRequest getRackUnitInfo(int rackUnitNumber, AsyncRpcResponse<GetRackUnitInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getRackUnitInfo(rackUnitNumber, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getRackUnitInfo(int rackUnitNumber, AsyncRpcResponse<GetRackUnitInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["rackUnitNumber"] = rackUnitNumber;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getRackUnitInfo", _parameters,
        _result => {
          try {
            var _ret = new GetRackUnitInfoResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.info = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo.Decode(_result["info"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetAllRackUnitInfosResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo> _ret_;
    }

    public GetAllRackUnitInfosResult getAllRackUnitInfos() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAllRackUnitInfos", _parameters);
      var _ret = new GetAllRackUnitInfosResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getAllRackUnitInfos(AsyncRpcResponse<GetAllRackUnitInfosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAllRackUnitInfos(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAllRackUnitInfos(AsyncRpcResponse<GetAllRackUnitInfosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAllRackUnitInfos", _parameters,
        _result => {
          try {
            var _ret = new GetAllRackUnitInfosResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.RackUnitInfo.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetTagResult {
      public int _ret_;
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo tagInfo;
    }

    public GetTagResult getTag(int rackUnitNumber, int slotNumber) {
      var _parameters = new LightJson.JsonObject();
      _parameters["rackUnitNumber"] = rackUnitNumber;
      _parameters["slotNumber"] = slotNumber;

      var _result = RpcCall("getTag", _parameters);
      var _ret = new GetTagResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.tagInfo = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo.Decode(_result["tagInfo"], agent);
      return _ret;
    }

    public AsyncRequest getTag(int rackUnitNumber, int slotNumber, AsyncRpcResponse<GetTagResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getTag(rackUnitNumber, slotNumber, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getTag(int rackUnitNumber, int slotNumber, AsyncRpcResponse<GetTagResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["rackUnitNumber"] = rackUnitNumber;
        _parameters["slotNumber"] = slotNumber;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getTag", _parameters,
        _result => {
          try {
            var _ret = new GetTagResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.tagInfo = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo.Decode(_result["tagInfo"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetAllTagsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo> _ret_;
    }

    public GetAllTagsResult getAllTags() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAllTags", _parameters);
      var _ret = new GetAllTagsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getAllTags(AsyncRpcResponse<GetAllTagsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAllTags(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAllTags(AsyncRpcResponse<GetAllTagsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAllTags", _parameters,
        _result => {
          try {
            var _ret = new GetAllTagsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetMainTagsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo> _ret_;
    }

    public GetMainTagsResult getMainTags() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMainTags", _parameters);
      var _ret = new GetMainTagsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getMainTags(AsyncRpcResponse<GetMainTagsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMainTags(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMainTags(AsyncRpcResponse<GetMainTagsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMainTags", _parameters,
        _result => {
          try {
            var _ret = new GetMainTagsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetExtensionTagsResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo> tags;
    }

    public GetExtensionTagsResult getExtensionTags(int rackUnitNumber) {
      var _parameters = new LightJson.JsonObject();
      _parameters["rackUnitNumber"] = rackUnitNumber;

      var _result = RpcCall("getExtensionTags", _parameters);
      var _ret = new GetExtensionTagsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.tags = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo>(_result["tags"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getExtensionTags(int rackUnitNumber, AsyncRpcResponse<GetExtensionTagsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getExtensionTags(rackUnitNumber, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getExtensionTags(int rackUnitNumber, AsyncRpcResponse<GetExtensionTagsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["rackUnitNumber"] = rackUnitNumber;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getExtensionTags", _parameters,
        _result => {
          try {
            var _ret = new GetExtensionTagsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.tags = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo>(_result["tags"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TriggerPowercycleResult {
    }

    public TriggerPowercycleResult triggerPowercycle(bool hard) {
      var _parameters = new LightJson.JsonObject();
      _parameters["hard"] = hard;

      var _result = RpcCall("triggerPowercycle", _parameters);
      var _ret = new TriggerPowercycleResult();
      return _ret;
    }

    public AsyncRequest triggerPowercycle(bool hard, AsyncRpcResponse<TriggerPowercycleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return triggerPowercycle(hard, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest triggerPowercycle(bool hard, AsyncRpcResponse<TriggerPowercycleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["hard"] = hard;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("triggerPowercycle", _parameters,
        _result => {
          try {
            var _ret = new TriggerPowercycleResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ProgramTagIDsResult {
      public int _ret_;
    }

    public ProgramTagIDsResult programTagIDs(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo> tagInfos) {
      var _parameters = new LightJson.JsonObject();
      _parameters["tagInfos"] = new JsonArray(tagInfos.Select(
        _value => (JsonValue)(_value.Encode())));

      var _result = RpcCall("programTagIDs", _parameters);
      var _ret = new ProgramTagIDsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest programTagIDs(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo> tagInfos, AsyncRpcResponse<ProgramTagIDsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return programTagIDs(tagInfos, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest programTagIDs(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_4.TagInfo> tagInfos, AsyncRpcResponse<ProgramTagIDsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["tagInfos"] = new JsonArray(tagInfos.Select(
          _value => (JsonValue)(_value.Encode())));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("programTagIDs", _parameters,
        _result => {
          try {
            var _ret = new ProgramTagIDsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
