% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wm_records_taxamatch.R
\name{wm_records_taxamatch}
\alias{wm_records_taxamatch}
\title{Get records for one or more taxonomic name(s) using
the TAXAMATCH fuzzy matching algorithm}
\usage{
wm_records_taxamatch(name, marine_only = TRUE, ...)
}
\arguments{
\item{name}{(character) taxon name. required.}

\item{marine_only}{(logical) marine only or not. default: \code{TRUE}}

\item{...}{named curl options. see \code{curl::curl_options}}
}
\value{
A list of tibble's/data.frame's, one for each of the input names
}
\description{
Get records for one or more taxonomic name(s) using
the TAXAMATCH fuzzy matching algorithm
}
\note{
there is no underscore method like other functions in this package
as this function already accepts many names
}
\examples{
\dontrun{
wm_records_taxamatch(name = 'Leucophaeus')
wm_records_taxamatch(name = c('Leucophaeus', 'Coryphaena'))
}
}
