% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniqtag.R
\name{make_unique}
\alias{make_unique}
\alias{make_unique_duplicates}
\alias{make_unique_all}
\alias{make_unique_all_or_none}
\title{Make character strings unique.}
\usage{
make_unique(xs, sep = "-")

make_unique_duplicates(xs, sep = "-")

make_unique_all(xs, sep = "-")

make_unique_all_or_none(xs, sep = "-")
}
\arguments{
\item{xs}{a character vector}

\item{sep}{a character string used to separate a duplicate string from its sequence number}
}
\description{
Append sequence numbers to duplicate elements to make all elements of a character vector unique.
}
\section{Functions}{
\itemize{
\item \code{make_unique}: Append a sequence number to duplicated elements, including the first occurrence.

\item \code{make_unique_duplicates}: Append a sequence number to duplicated elements, except the first occurrence.

This function behaves similarly to make.unique

\item \code{make_unique_all}: Append a sequence number to every element.

\item \code{make_unique_all_or_none}: Append a sequence number to every element or no elements.

Return \code{xs} unchanged if the elements of the character vector \code{xs} are already unique.
Otherwise append a sequence number to every element.
}}

\examples{
abcb <- c("a", "b", "c", "b")
make_unique(abcb)
make_unique_duplicates(abcb)
make_unique_all(abcb)
make_unique_all_or_none(abcb)
make_unique_all_or_none(c("a", "b", "c"))
x <- make_unique(abbreviate(state.name, 3, strict = TRUE))
x[grep("-", x)]
}
\seealso{
make.unique
}
