% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate.r
\name{str_locate}
\alias{str_locate}
\alias{str_locate_all}
\title{Locate the position of patterns in a string.}
\usage{
str_locate(string, pattern)

str_locate_all(string, pattern)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described
in \link[stringi:stringi-search-regex]{stringi::stringi-search-regex}. Control options with
\code{\link[=regex]{regex()}}.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[=boundary]{boundary()}}. An empty pattern, "", is equivalent to
\code{boundary("character")}.}
}
\value{
For \code{str_locate}, an integer matrix. First column gives start
postion of match, and second column gives end position. For
\code{str_locate_all} a list of integer matrices.
}
\description{
Vectorised over \code{string} and \code{pattern}. If the match is of length
0, (e.g. from a special match like \code{$}) end will be one character less
than start.
}
\examples{
fruit <- c("apple", "banana", "pear", "pineapple")
str_locate(fruit, "$")
str_locate(fruit, "a")
str_locate(fruit, "e")
str_locate(fruit, c("a", "b", "p", "p"))

str_locate_all(fruit, "a")
str_locate_all(fruit, "e")
str_locate_all(fruit, c("a", "b", "p", "p"))

# Find location of every character
str_locate_all(fruit, "")
}
\seealso{
\code{\link[=str_extract]{str_extract()}} for a convenient way of extracting matches,
\code{\link[stringi:stri_locate]{stringi::stri_locate()}} for the underlying implementation.
}
