% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{Read10X_Segmentations}
\alias{Read10X_Segmentations}
\title{Load 10X Genomics Visium Cell Segmentations}
\usage{
Read10X_Segmentations(
  image.dir,
  data.dir,
  image.name = "tissue_lowres_image.png",
  assay = "Spatial.Polygons",
  slice = "slice1.polygons",
  segmentation.type = "cell",
  compact = TRUE
)
}
\arguments{
\item{image.dir}{Path to directory with 10X Genomics visium image data;}

\item{data.dir}{Directory of the base spaceranger outs}

\item{image.name}{Name of the tissue image to be plotted. tissue_lowres_image.png or tissue_hires_image.png}

\item{assay}{Name of assay to associate segmentations to}

\item{slice}{Name of the slice to associate the segmentations to}

\item{segmentation.type}{Which segmentations to load, cell or nucleus. If using nucleus the full matrix from cells is still used}

\item{compact}{Whether to store segmentations in only the \code{sf.data} slot; see \code{\link{Load10X_Spatial}} for details}
}
\value{
A VisiumV2 object with segmentations
}
\description{
Load 10X Genomics Visium Cell Segmentations
}
\concept{preprocessing}
