% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stubs.R
\name{projects}
\alias{projects}
\alias{openProject}
\alias{initializeProject}
\title{Open a project in RStudio}
\usage{
openProject(path = NULL, newSession = FALSE)

initializeProject(path = getwd())
}
\arguments{
\item{path}{Either the path to an existing \code{.Rproj} file, or a path
to a directory in which a new project should be initialized and opened.}

\item{newSession}{Boolean; should the project be opened in a new session,
or should the current RStudio session switch to that project? Note that
\code{TRUE} values are only supported with RStudio Desktop and RStudio
Server Pro.}
}
\description{
Initialize and open RStudio projects.
}
\details{
Calling \code{openProject()} without arguments effectively re-opens the
currently open project in RStudio. When switching projects, users will
be prompted to save any unsaved files; alternatively, you can explicitly
save any open documents using \code{\link[=documentSaveAll]{documentSaveAll()}}.
}
\note{
The \code{openProject} and \code{initializeProject} functions were
added in version 1.1.287 of RStudio.
}
