% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R
\name{inject}
\alias{inject}
\title{Inject objects in an R expression}
\usage{
inject(expr, env = caller_env())
}
\arguments{
\item{expr}{An argument to evaluate. This argument is immediately
evaluated in \code{env} (the current environment by default) with
injected objects and expressions.}

\item{env}{The environment in which to evaluate \code{expr}. Defaults to
the current environment. For expert use only.}
}
\description{
\code{inject()} evaluates an expression with \link[=quasiquotation]{injection}
(unquotation) support. There are three main usages:
}
\details{
\itemize{
\item \link[=!!!]{Splicing} lists of arguments in a function call.
\item Inline objects or other expressions in an expression with \verb{!!}
and \verb{!!!}. For instance to create functions or formulas
programmatically.
\item Pass arguments to NSE functions that \link[=nse-defuse]{defuse} their
arguments without injection support (see for instance
\code{\link[=enquo0]{enquo0()}}). You can use \code{{{ arg }}} with functions documented
to support quosures. Otherwise, use \code{!!enexpr(arg)}.
}
}
\examples{
# inject() simply evaluates its argument with injection
# support. These expressions are equivalent:
2 * 3
inject(2 * 3)
inject(!!2 * !!3)

# Injection with `!!` can be useful to insert objects or
# expressions within other expressions, like formulas:
lhs <- sym("foo")
rhs <- sym("bar")
inject(!!lhs ~ !!rhs + 10)

# Injection with `!!!` splices lists of arguments in function
# calls:
args <- list(na.rm = TRUE, finite = 0.2)
inject(mean(1:10, !!!args))
}
