% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coercion.R
\name{as.matrix.network}
\alias{as.matrix.network}
\alias{as.matrix.network.adjacency}
\alias{as.matrix.network.edgelist}
\alias{as_tibble.network}
\alias{as.tibble.network}
\alias{as.matrix.network.incidence}
\title{Coerce a Network Object to Matrix or Table Form}
\usage{
\method{as.matrix}{network}(x, matrix.type = NULL, attrname = NULL, ...)

\method{as.matrix.network}{adjacency}(x, attrname=NULL, 
   expand.bipartite = FALSE, ...)

\method{as.matrix.network}{edgelist}(x, attrname=NULL, 
   as.sna.edgelist = FALSE, na.rm = TRUE, ...)

\method{as_tibble}{network}(
  x,
  attrnames = (match.arg(unit) == "vertices"),
  na.rm = TRUE,
  ...,
  unit = c("edges", "vertices"),
  store.eid = FALSE
)

as.tibble.network(
  x,
  attrnames = (match.arg(unit) == "vertices"),
  na.rm = TRUE,
  ...,
  unit = c("edges", "vertices"),
  store.eid = FALSE
)

\method{as.matrix.network}{incidence}(x, attrname=NULL, ...)
}
\arguments{
\item{x}{an object of class \code{network}}

\item{matrix.type}{one of \code{"adjacency"}, \code{"incidence"},
\code{"edgelist"}, or \code{NULL}}

\item{attrname}{optionally, the name of an edge attribute to use for edge
values}

\item{...}{additional arguments.}

\item{expand.bipartite}{logical; if \code{x} is bipartite, should we return
the full adjacency matrix (rather than the abbreviated, two-mode form)?}

\item{as.sna.edgelist}{logical; should the edgelist be returned in sna
edglist form?}

\item{na.rm}{logical; should missing edges/vertices be included in the
edgelist formats? Ignored if \code{as.sna.edgelist=TRUE}.}

\item{attrnames}{optionally, either a character vector of the names of edge
attributes to use for edge values, or a numerical or logical vector to use
as indices for selecting them from \code{\link{list.edge.attributes}(x)} or
\code{\link{list.vertex.attributes}(x)} (depending on \code{unit}); passing
\code{TRUE} therefore returns all edge attributes as columns}

\item{unit}{whether a \code{\link{tibble}} of edge or vertex attributes
should be returned.}

\item{store.eid}{whether the edge ID should be stored in the third column (\code{.eid}).}
}
\value{
For \code{as.matrix} methods, an adjacency, incidence, or edgelist
matrix. For the \code{as_tibble} method, a \code{tibble} whose first two
columns are \code{.head} and \code{.tail}, whose third column \code{.eid} is
the edge ID, and whose subsequent columns are the requested edge attributes.
}
\description{
The \code{as.matrix} methods attempt to coerce their input to a matrix in
adjacency, incidence, or edgelist form.  Edge values (from a stored
attribute) may be used if present. \code{\link[tibble:as_tibble]{as_tibble}}
coerces into an edgelist in \code{\link{tibble}} (a type of
\code{\link{data.frame}}) form; this can be especially useful if extrecting
a character-type edge attribute.
}
\details{
If no matrix type is specified, \code{\link{which.matrix.type}} will be used
to make an educated guess based on the shape of \code{x}.  Where edge values
are not specified, a dichotomous matrix will be assumed.

Edgelists returned by the \code{as.matrix} methods are by default in a
slightly different form from the \code{sna} edgelist standard, but do
contain the \code{sna} extended matrix attributes (see
\code{\link{as.network.matrix}}).  They should typically be compatible with
\code{sna} library functions.  To ensure compatibility, the
\code{as.sna.edgelist} argument can be set (which returns an exact
\code{sna} edgelist). The \code{\link{as.edgelist}} function also returns a
similar edgelist matrix but with an enforced sorting.

For the \code{as.matrix} methods, if the \code{attrname} attribute is used
to include a charcter attribute, the resulting edgelist matrix will be
character rather than numeric. The \code{as_tibble} methods never coerce.

Note that adjacency matrices may also be obtained using the extraction
operator.  See the relevant man page for details. Also note that which
attributes get returned by the \code{as_tibble} method by default depends on
\code{unit}: by default no edge attributes are returned but all vertex
attributes are.
}
\examples{

# Create a random network
m <- matrix(rbinom(25,4,0.159),5,5) # 50\% density
diag(m) <- 0
g <- network(m, ignore.eval=FALSE, names.eval="a") # With values
g \%e\% "ac" <- letters[g \%e\% "a"]

# Coerce to matrix form
# No attributes:
as.matrix(g,matrix.type="adjacency")
as.matrix(g,matrix.type="incidence")
as.matrix(g,matrix.type="edgelist")
# Attributes:
as.matrix(g,matrix.type="adjacency",attrname="a")
as.matrix(g,matrix.type="incidence",attrname="a")
as.matrix(g,matrix.type="edgelist",attrname="a")
as.matrix(g,matrix.type="edgelist",attrname="ac")

# Coerce to a tibble:
library(tibble)
as_tibble(g)
as_tibble(g, attrnames=c("a","ac"))
as_tibble(g, attrnames=TRUE)
# Get vertex attributes instead:
as_tibble(g, unit = "vertices")

# Missing data handling:
g[1,2] <- NA
as.matrix(g,matrix.type="adjacency") # NA in the corresponding cell
as.matrix(g,matrix.type="edgelist", na.rm=TRUE) # (1,2) excluded
as.matrix(g,matrix.type="edgelist", na.rm=FALSE) # (1,2) included
as_tibble(g, attrnames="na", na.rm=FALSE) # Which edges are marked missing?

# Can also use the extraction operator
g[,]                            # Get entire adjacency matrix
g[1:2,3:5]                      # Obtain a submatrix

}
\references{
Butts, C. T.  (2008).  \dQuote{network: a Package for Managing
Relational Data in R.} \emph{Journal of Statistical Software}, 24(2).
\url{https://www.jstatsoft.org/v24/i02/}
}
\seealso{
\code{\link{which.matrix.type}}, \code{\link{network}},
\code{\link{network.extraction}},\code{\link{as.edgelist}}
}
\author{
Carter T. Butts \email{buttsc@uci.edu} and David Hunter
\email{dhunter@stat.psu.edu}
}
\keyword{classes}
\keyword{graphs}
