% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-refresh.R
\name{oauth_flow_refresh}
\alias{oauth_flow_refresh}
\title{OAuth flow: refresh token}
\usage{
oauth_flow_refresh(
  client,
  refresh_token = Sys.getenv("HTTR2_REFRESH_TOKEN"),
  scope = NULL,
  token_params = list()
)
}
\arguments{
\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{refresh_token}{A refresh token. This is equivalent to a password
so shouldn't be typed into the console or stored in a script. Instead,
we recommend placing in an environment variable; the default behaviour
is to look in \code{HTTR2_REFRESH_TOKEN}.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}
}
\value{
An \link{oauth_token}.
}
\description{
This function generates an access token from a refresh token, following
the process described in
\href{https://datatracker.ietf.org/doc/html/rfc6749#section-6}{rfc6749},
Section 6. Errors if the refresh returns a new refresh token, see
\code{\link[=req_oauth_refresh]{req_oauth_refresh()}} for details.
}
\seealso{
Other OAuth flows: 
\code{\link{oauth_flow_auth_code}()},
\code{\link{oauth_flow_bearer_jwt}()},
\code{\link{oauth_flow_client_credentials}()},
\code{\link{oauth_flow_device}()},
\code{\link{oauth_flow_password}()}
}
\concept{OAuth flows}
\keyword{internal}
