% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul.nfac.prior.R
\name{simul.nfac.prior}
\alias{simul.nfac.prior}
\title{Simulate prior distribution of number of latent factors}
\usage{
simul.nfac.prior(nvar, Kmax, Nid = 3, kappa = 1/Kmax, nrep = 10^6)
}
\arguments{
\item{nvar}{Number of manifest variables.}

\item{Kmax}{Maximum number of latent factors.}

\item{Nid}{Minimum number of manifest variables dedicated to each latent factor
for identification.}

\item{kappa}{Concentration parameter of the Dirichlet prior distribution on
the indicators.}

\item{nrep}{Number of Monte Carlo replications.}
}
\value{
A list of length equal to the number of parameters specified in
\code{kappa} is returned, where each element of the list contains:
\itemize{
  \item \code{nfac}: Vector of integers of length equal to the number of
  accepted draws.
  \item \code{acc}: Acceptance rate of the accept/reject sampling scheme.
}
}
\description{
This function produces a sample from the prior distribution of the number of
latent factors. It depends on the prior parameters used for the distribution
of the indicators, on the size of the model (number of manifest variables
and maximum number of latent factors), and on the identification restriction
(minimum number of manifest variables dedicated to each factor).
}
\details{
This function simulates the prior distribution of the number of
latent factors for models that fulfill the identification restriction
restriction that at least \code{Nid} manifest variables (or no variables) are
loading on each latent factor. Several (scalar) parameters \code{kappa} can
be passed to the function to simulate the prior for different prior parameter
values and compare the results.

An accept/reject sampling scheme is used: a vector of probabilities is drawn
from a Dirichlet distribution with concentration parameter \code{kappa}, and
the \code{nvar} manifest variables are randomly allocated to the \code{Kmax}
latent factors. If each latent factor has at least \code{Nid} dedicated
variables or no variables at all, the identification requirement is fulfilled
and the draw is accepted. The number of factors loaded by at least \code{Nid}
manifest variables is returned as a draw from the prior distribution.

Note that this function does not use the two-level prior distribution
implemented in CFSHP, where manifest variables can be discarded from the
model according to a given probability. Therefore, this function only help
understand the prior distribution conditional on all the manifest variables
being included into the model.
}
\examples{
# replicate first row of table 2 in CFSHP (p.44)
# note: use larger number of replications nrep to improve accuracy
prior.nfac <- simul.nfac.prior(nvar = 15, Kmax = 5, kappa = c(.3, .7, 1), 
                               nrep = 10000)
summary(prior.nfac)
plot(prior.nfac)

}
\references{
G. Conti, S. Frühwirth-Schnatter, J.J. Heckman, R. Piatek (2014):
``Bayesian Exploratory Factor Analysis'', \emph{Journal of Econometrics},
183(1), pages 31-57, \url{http://dx.doi.org/10.1016/j.jeconom.2014.06.008}.
}
\author{
Rémi Piatek \email{remi.piatek@gmail.com}
}
