% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_genes_violin}
\alias{plot_genes_violin}
\title{Plots expression for one or more genes as a violin plot}
\usage{
plot_genes_violin(cds_subset, grouping = "State", min_expr = NULL,
  cell_size = 0.75, nrow = NULL, ncol = 1, panel_order = NULL,
  color_by = NULL, plot_trend = FALSE, label_by_short_name = TRUE,
  relative_expr = TRUE, log_scale = TRUE)
}
\arguments{
\item{cds_subset}{CellDataSet for the experiment}

\item{grouping}{the cell attribute (e.g. the column of pData(cds)) to group cells by on the horizontal axis}

\item{min_expr}{the minimum (untransformed) expression level to use in plotted the genes.}

\item{cell_size}{the size (in points) of each cell used in the plot}

\item{nrow}{the number of rows used when laying out the panels for each gene's expression}

\item{ncol}{the number of columns used when laying out the panels for each gene's expression}

\item{panel_order}{the order in which genes should be layed out (left-to-right, top-to-bottom)}

\item{color_by}{the cell attribute (e.g. the column of pData(cds)) to be used to color each cell}

\item{plot_trend}{whether to plot a trendline tracking the average expression across the horizontal axis.}

\item{label_by_short_name}{label figure panels by gene_short_name (TRUE) or feature id (FALSE)}

\item{relative_expr}{Whether to transform expression into relative values}

\item{log_scale}{a boolean that determines whether or not to scale data logarithmically}
}
\value{
a ggplot2 plot object
}
\description{
Accepts a subset of a CellDataSet and an attribute to group cells by,
and produces one or more ggplot2 objects that plots the level of expression for
each group of cells.
}
\examples{
\dontrun{
library(HSMMSingleCell)
HSMM <- load_HSMM()
my_genes <- HSMM[row.names(subset(fData(HSMM), gene_short_name \%in\% c("ACTA1", "ID1", "CCNB2"))),]
plot_genes_violin(my_genes, grouping="Hours", ncol=2, min_expr=0.1)
}
}
