% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-CellTypeHierarchy.R
\name{markerDiffTable}
\alias{markerDiffTable}
\title{Test genes for cell type-dependent expression}
\usage{
markerDiffTable(cds, cth, residualModelFormulaStr = "~1", balanced = FALSE,
  reclassify_cells = TRUE, remove_ambig = TRUE, remove_unknown = TRUE,
  verbose = FALSE, cores = 1)
}
\arguments{
\item{cds}{A CellDataSet object containing cells to classify}

\item{cth}{The CellTypeHierarchy object to use for classification}

\item{residualModelFormulaStr}{A model formula string specify effects you
want to exclude when testing for cell type dependent expression}

\item{balanced}{Whether to downsample the cells so that there's an equal number of each type prior to performing the test}

\item{reclassify_cells}{a boolean that indicates whether or not the cds and cth should be run through classifyCells again}

\item{remove_ambig}{a boolean that indicates whether or not ambiguous cells should be removed the cds}

\item{remove_unknown}{a boolean that indicates whether or not unknown cells should be removed from the cds}

\item{verbose}{Whether to emit verbose output during the the search for cell-type dependent genes}

\item{cores}{The number of cores to use when testing}
}
\value{
A table of differential expression test results
}
\description{
takes a CellDataSet and a CellTypeHierarchy and classifies all cells into types passed
functions passed into the CellTypeHierarchy. The function will remove all "Unknown" and "Ambiguous" types
before identifying genes that are differentially expressed between types.
}
