% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkInstalled.R
\name{checkInstalled}
\alias{checkInstalled}
\title{Check packages are installed otherwise suggest}
\usage{
checkInstalled(pkgs)
}
\arguments{
\item{pkgs}{\code{character()} package names required for a function}
}
\value{
\code{TRUE} if all packages are installed, otherwise stops with a message
and suggests installation of missing packages
}
\description{
\code{checkInstalled} allows to check if a package is installed. If the package is
not available, a convenient copy-and-paste message is provided for package
installation with \code{BiocManager}. The function is typically used within
functions that check for package availability from the \code{Suggests} field.
}
\examples{
if (interactive()) {
    checkInstalled(
        c("BiocParallel", "SummarizedExperiment")
    )
}
}
\author{
M. Morgan, M. Ramos
}
