\name{B_05_qq}
\alias{qq}
\alias{qq.formula}
\alias{qq.data.frame}
\title{ Quantile-Quantile Plots of Two Samples }
\description{
  Quantile-Quantile plots for comparing two Distributions
}
\usage{
qq(x, data, ...)

\method{qq}{formula}(x, data, aspect = "fill", 
   panel = lattice.getOption("panel.qq"),
   prepanel, scales, strip, 
   groups, xlab, xlim, ylab, ylim, f.value = NULL, 
   drop.unused.levels = lattice.getOption("drop.unused.levels"),
   ...,
   lattice.options = NULL,
   qtype = 7,
   default.scales = list(),
   default.prepanel = lattice.getOption("prepanel.default.qq"),
   subscripts,
   subset)

\method{qq}{data.frame}(x, data = NULL, formula = data, ...)

}
\arguments{
  \item{x}{
    The object on which method dispatch is carried out.

    For the \code{"formula"} method, \code{x} should be a formula of the
    form \code{y ~ x | g1 * g2 * ...}, where \code{x} should be a
    numeric variable, and \code{y} a factor, shingle, character, or
    numeric variable, with the restriction that there must be exactly
    two levels of \code{y}, which divide the values of \code{x} into two
    groups.  Quantiles for these groups will be plotted against each
    other along the two axes.

  }
  \item{data}{

    For the \code{formula} method, an optional data source (usually a
    data frame) in which variables are to be evaluated (see
    \code{\link{xyplot}} for details).

    % \code{data} should not be
    % specified for other methods, and is ignored with a warning if it
    % is.

  }
  \item{formula}{
    The formula to be used for the \code{"data.frame"} method. See
    documentation for argument \code{x} for details.
  }
  \item{f.value}{

    An optional numeric vector of probabilities, quantiles corresponding
    to which should be plotted.  This can also be a function of a single
    integer (representing sample size) that returns such a numeric
    vector.  A typical value for this argument is the function
    \code{ppoints}, which is also the S-PLUS default.  If specified, the
    probabilities generated by this function is used for the plotted
    quantiles, through the \code{quantile} function.

    \code{f.value} defaults to \code{NULL}, which is equivalent to
    \preformatted{
      f.value = function(n) ppoints(n, a = 1)
    }
    This has the effect of including the minimum and maximum data values
    in the computed quantiles. This is similar to what happens for
    \code{qqplot} but different from the default behaviour of \code{qq}
    in S-PLUS.

    For large \code{x}, this argument can be used to restrict the number
    of quantiles plotted.

  }
  \item{panel}{

    A function, called once for each panel, that uses the packet (subset
    of panel variables) corresponding to the panel to create a display.
    The default panel function \code{\link{panel.qq}} is documented
    separately, and has arguments that can be used to customize its
    output in various ways.  Such arguments can usually be directly
    supplied to the high-level function.

  }
  \item{qtype}{ The \code{type} argument for \code{\link{quantile}}. }
  \item{aspect}{ See \code{\link{xyplot}}. }
  \item{prepanel}{ See \code{\link{xyplot}}. }
  \item{scales}{ See \code{\link{xyplot}}. }
  \item{strip}{ See \code{\link{xyplot}}. }
  \item{groups}{ See \code{\link{xyplot}}.  }
  \item{xlab, ylab}{ See \code{\link{xyplot}}. }
  \item{xlim, ylim}{ See \code{\link{xyplot}}. }
  \item{drop.unused.levels}{ See \code{\link{xyplot}}. }
  \item{lattice.options}{ See \code{\link{xyplot}}. }
  \item{default.scales}{ See \code{\link{xyplot}}. }
  \item{subscripts}{ See \code{\link{xyplot}}. }
  \item{subset}{ See \code{\link{xyplot}}. }
  \item{default.prepanel}{
    Fallback prepanel function.  See \code{\link{xyplot}}.
  }
  \item{...}{
    Further arguments.  See corresponding entry in \code{\link{xyplot}}
    for non-trivial details.
  }
}
\value{

  An object of class \code{"trellis"}. The
  \code{\link[lattice:update.trellis]{update}} method can be used to
  update components of the object and the
  \code{\link[lattice:print.trellis]{print}} method (usually called by
  default) will plot it on an appropriate plotting device.

}
\author{Deepayan Sarkar \email{Deepayan.Sarkar@R-project.org}}
\details{

  \code{qq} produces Q-Q plots of two samples.  The default behaviour of
  \code{qq} is different from the corresponding S-PLUS function. See the
  entry for \code{f.value} for specifics.

  This and all other high level Trellis functions have several
  arguments in common. These are extensively documented only in the
  help page for \code{xyplot}, which should be consulted to learn more
  detailed usage.
}

\seealso{\code{\link{xyplot}}, \code{\link{panel.qq}},
  \code{\link{qqmath}}, \code{\link{Lattice}}
}

\examples{
qq(voice.part ~ height, aspect = 1, data = singer,
   subset = (voice.part == "Bass 2" | voice.part == "Tenor 1"))
}
\keyword{dplot}
