# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.media.v1.player_streamer.playback_grant import PlaybackGrantList


class PlayerStreamerList(ListResource):

    def __init__(self, version):
        """
        Initialize the PlayerStreamerList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.media.v1.player_streamer.PlayerStreamerList
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerList
        """
        super(PlayerStreamerList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/PlayerStreamers'.format(**self._solution)

    def create(self, video=values.unset, status_callback=values.unset,
               status_callback_method=values.unset):
        """
        Create the PlayerStreamerInstance

        :param bool video: Whether the PlayerStreamer is configured to stream video
        :param unicode status_callback: The URL to which Twilio will send PlayerStreamer event updates
        :param unicode status_callback_method: The HTTP method Twilio should use to call the `status_callback` URL

        :returns: The created PlayerStreamerInstance
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerInstance
        """
        data = values.of({
            'Video': video,
            'StatusCallback': status_callback,
            'StatusCallbackMethod': status_callback_method,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return PlayerStreamerInstance(self._version, payload, )

    def stream(self, order=values.unset, status=values.unset, limit=None,
               page_size=None):
        """
        Streams PlayerStreamerInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param PlayerStreamerInstance.Order order: The sort order of the list
        :param PlayerStreamerInstance.Status status: Status to filter by
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.media.v1.player_streamer.PlayerStreamerInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(order=order, status=status, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, order=values.unset, status=values.unset, limit=None,
             page_size=None):
        """
        Lists PlayerStreamerInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param PlayerStreamerInstance.Order order: The sort order of the list
        :param PlayerStreamerInstance.Status status: Status to filter by
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.media.v1.player_streamer.PlayerStreamerInstance]
        """
        return list(self.stream(order=order, status=status, limit=limit, page_size=page_size, ))

    def page(self, order=values.unset, status=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of PlayerStreamerInstance records from the API.
        Request is executed immediately

        :param PlayerStreamerInstance.Order order: The sort order of the list
        :param PlayerStreamerInstance.Status status: Status to filter by
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of PlayerStreamerInstance
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerPage
        """
        data = values.of({
            'Order': order,
            'Status': status,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return PlayerStreamerPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of PlayerStreamerInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of PlayerStreamerInstance
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return PlayerStreamerPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a PlayerStreamerContext

        :param sid: The SID that identifies the resource to fetch

        :returns: twilio.rest.media.v1.player_streamer.PlayerStreamerContext
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerContext
        """
        return PlayerStreamerContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a PlayerStreamerContext

        :param sid: The SID that identifies the resource to fetch

        :returns: twilio.rest.media.v1.player_streamer.PlayerStreamerContext
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerContext
        """
        return PlayerStreamerContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Media.V1.PlayerStreamerList>'


class PlayerStreamerPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the PlayerStreamerPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.media.v1.player_streamer.PlayerStreamerPage
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerPage
        """
        super(PlayerStreamerPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of PlayerStreamerInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.media.v1.player_streamer.PlayerStreamerInstance
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerInstance
        """
        return PlayerStreamerInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Media.V1.PlayerStreamerPage>'


class PlayerStreamerContext(InstanceContext):

    def __init__(self, version, sid):
        """
        Initialize the PlayerStreamerContext

        :param Version version: Version that contains the resource
        :param sid: The SID that identifies the resource to fetch

        :returns: twilio.rest.media.v1.player_streamer.PlayerStreamerContext
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerContext
        """
        super(PlayerStreamerContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/PlayerStreamers/{sid}'.format(**self._solution)

        # Dependents
        self._playback_grant = None

    def fetch(self):
        """
        Fetch the PlayerStreamerInstance

        :returns: The fetched PlayerStreamerInstance
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return PlayerStreamerInstance(self._version, payload, sid=self._solution['sid'], )

    def update(self, status):
        """
        Update the PlayerStreamerInstance

        :param PlayerStreamerInstance.UpdateStatus status: The status the PlayerStreamer should be transitioned to

        :returns: The updated PlayerStreamerInstance
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerInstance
        """
        data = values.of({'Status': status, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return PlayerStreamerInstance(self._version, payload, sid=self._solution['sid'], )

    @property
    def playback_grant(self):
        """
        Access the playback_grant

        :returns: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantList
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantList
        """
        if self._playback_grant is None:
            self._playback_grant = PlaybackGrantList(self._version, sid=self._solution['sid'], )
        return self._playback_grant

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Media.V1.PlayerStreamerContext {}>'.format(context)


class PlayerStreamerInstance(InstanceResource):

    class Status(object):
        CREATED = "created"
        STARTED = "started"
        ENDED = "ended"
        FAILED = "failed"

    class UpdateStatus(object):
        ENDED = "ended"

    class Order(object):
        ASC = "asc"
        DESC = "desc"

    class EndedReason(object):
        ENDED_VIA_API = "ended-via-api"
        MAX_DURATION_EXCEEDED = "max-duration-exceeded"
        STREAM_DISCONNECTED_BY_SOURCE = "stream-disconnected-by-source"
        UNEXPECTED_FAILURE = "unexpected-failure"

    def __init__(self, version, payload, sid=None):
        """
        Initialize the PlayerStreamerInstance

        :returns: twilio.rest.media.v1.player_streamer.PlayerStreamerInstance
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerInstance
        """
        super(PlayerStreamerInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'video': payload.get('video'),
            'links': payload.get('links'),
            'sid': payload.get('sid'),
            'status': payload.get('status'),
            'url': payload.get('url'),
            'status_callback': payload.get('status_callback'),
            'status_callback_method': payload.get('status_callback_method'),
            'ended_reason': payload.get('ended_reason'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: PlayerStreamerContext for this PlayerStreamerInstance
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerContext
        """
        if self._context is None:
            self._context = PlayerStreamerContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def video(self):
        """
        :returns: Whether the PlayerStreamer is configured to stream video
        :rtype: bool
        """
        return self._properties['video']

    @property
    def links(self):
        """
        :returns: The URLs of related resources
        :rtype: unicode
        """
        return self._properties['links']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def status(self):
        """
        :returns: The status of the PlayerStreamer
        :rtype: PlayerStreamerInstance.Status
        """
        return self._properties['status']

    @property
    def url(self):
        """
        :returns: The absolute URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def status_callback(self):
        """
        :returns: The URL to which Twilio will send PlayerStreamer event updates
        :rtype: unicode
        """
        return self._properties['status_callback']

    @property
    def status_callback_method(self):
        """
        :returns: The HTTP method Twilio should use to call the `status_callback` URL
        :rtype: unicode
        """
        return self._properties['status_callback_method']

    @property
    def ended_reason(self):
        """
        :returns: The reason why a PlayerStreamer ended
        :rtype: PlayerStreamerInstance.EndedReason
        """
        return self._properties['ended_reason']

    def fetch(self):
        """
        Fetch the PlayerStreamerInstance

        :returns: The fetched PlayerStreamerInstance
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerInstance
        """
        return self._proxy.fetch()

    def update(self, status):
        """
        Update the PlayerStreamerInstance

        :param PlayerStreamerInstance.UpdateStatus status: The status the PlayerStreamer should be transitioned to

        :returns: The updated PlayerStreamerInstance
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerInstance
        """
        return self._proxy.update(status, )

    @property
    def playback_grant(self):
        """
        Access the playback_grant

        :returns: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantList
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantList
        """
        return self._proxy.playback_grant

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Media.V1.PlayerStreamerInstance {}>'.format(context)
