# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class CapabilitiesListResult(msrest.serialization.Model):
    """location capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of supported capabilities.
    :vartype value:
     list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.CapabilityProperties]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CapabilityProperties]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapabilitiesListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class CapabilityProperties(msrest.serialization.Model):
    """Location capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar zone: zone name.
    :vartype zone: str
    :ivar supported_flexible_server_editions: A list of supported flexible server editions.
    :vartype supported_flexible_server_editions:
     list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.ServerEditionCapability]
    """

    _validation = {
        'zone': {'readonly': True},
        'supported_flexible_server_editions': {'readonly': True},
    }

    _attribute_map = {
        'zone': {'key': 'zone', 'type': 'str'},
        'supported_flexible_server_editions': {'key': 'supportedFlexibleServerEditions', 'type': '[ServerEditionCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapabilityProperties, self).__init__(**kwargs)
        self.zone = None
        self.supported_flexible_server_editions = None


class Resource(msrest.serialization.Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Configuration(Resource):
    """Represents a Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param value: Value of the configuration.
    :type value: str
    :ivar description: Description of the configuration.
    :vartype description: str
    :ivar default_value: Default value of the configuration.
    :vartype default_value: str
    :ivar data_type: Data type of the configuration.
    :vartype data_type: str
    :ivar allowed_values: Allowed values of the configuration.
    :vartype allowed_values: str
    :param source: Source of the configuration.
    :type source: str
    :ivar is_read_only: If is the configuration read only. Possible values include: "True",
     "False".
    :vartype is_read_only: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.IsReadOnly
    :ivar is_config_pending_restart: If is the configuration pending restart or not. Possible
     values include: "True", "False".
    :vartype is_config_pending_restart: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.IsConfigPendingRestart
    :ivar is_dynamic_config: If is the configuration dynamic. Possible values include: "True",
     "False".
    :vartype is_dynamic_config: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.IsDynamicConfig
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'default_value': {'readonly': True},
        'data_type': {'readonly': True},
        'allowed_values': {'readonly': True},
        'is_read_only': {'readonly': True},
        'is_config_pending_restart': {'readonly': True},
        'is_dynamic_config': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'default_value': {'key': 'properties.defaultValue', 'type': 'str'},
        'data_type': {'key': 'properties.dataType', 'type': 'str'},
        'allowed_values': {'key': 'properties.allowedValues', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'is_read_only': {'key': 'properties.isReadOnly', 'type': 'str'},
        'is_config_pending_restart': {'key': 'properties.isConfigPendingRestart', 'type': 'str'},
        'is_dynamic_config': {'key': 'properties.isDynamicConfig', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Configuration, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.description = None
        self.default_value = None
        self.data_type = None
        self.allowed_values = None
        self.source = kwargs.get('source', None)
        self.is_read_only = None
        self.is_config_pending_restart = None
        self.is_dynamic_config = None


class ConfigurationListResult(msrest.serialization.Model):
    """A list of server configurations.

    :param value: The list of server configurations.
    :type value: list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.Configuration]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Configuration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfigurationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Database(Resource):
    """Represents a Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param charset: The charset of the database.
    :type charset: str
    :param collation: The collation of the database.
    :type collation: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'charset': {'key': 'properties.charset', 'type': 'str'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Database, self).__init__(**kwargs)
        self.charset = kwargs.get('charset', None)
        self.collation = kwargs.get('collation', None)


class DatabaseListResult(msrest.serialization.Model):
    """A List of databases.

    :param value: The list of databases housed in a server.
    :type value: list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.Database]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Database]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class DelegatedSubnetArguments(msrest.serialization.Model):
    """Delegated subnet arguments of a server.

    :param subnet_arm_resource_id: delegated subnet arm resource id.
    :type subnet_arm_resource_id: str
    """

    _attribute_map = {
        'subnet_arm_resource_id': {'key': 'subnetArmResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DelegatedSubnetArguments, self).__init__(**kwargs)
        self.subnet_arm_resource_id = kwargs.get('subnet_arm_resource_id', None)


class DelegatedSubnetUsage(msrest.serialization.Model):
    """Delegated subnet usage data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subnet_name: name of the subnet.
    :vartype subnet_name: str
    :ivar usage: Number of used delegated subnets.
    :vartype usage: long
    """

    _validation = {
        'subnet_name': {'readonly': True},
        'usage': {'readonly': True},
    }

    _attribute_map = {
        'subnet_name': {'key': 'subnetName', 'type': 'str'},
        'usage': {'key': 'usage', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DelegatedSubnetUsage, self).__init__(**kwargs)
        self.subnet_name = None
        self.usage = None


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(msrest.serialization.Model):
    """The resource management error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class FirewallRule(Resource):
    """Represents a server firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param start_ip_address: Required. The start IP address of the server firewall rule. Must be
     IPv4 format.
    :type start_ip_address: str
    :param end_ip_address: Required. The end IP address of the server firewall rule. Must be IPv4
     format.
    :type end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
        'end_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallRule, self).__init__(**kwargs)
        self.start_ip_address = kwargs['start_ip_address']
        self.end_ip_address = kwargs['end_ip_address']


class FirewallRuleListResult(msrest.serialization.Model):
    """A list of firewall rules.

    :param value: The list of firewall rules in a server.
    :type value: list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.FirewallRule]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FirewallRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value: "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'constant': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "SystemAssigned"

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None


class MaintenanceWindow(msrest.serialization.Model):
    """Maintenance window of a server.

    :param custom_window: indicates whether custom window is enabled or disabled.
    :type custom_window: str
    :param start_hour: start hour for maintenance window.
    :type start_hour: int
    :param start_minute: start minute for maintenance window.
    :type start_minute: int
    :param day_of_week: day of week for maintenance window.
    :type day_of_week: int
    """

    _attribute_map = {
        'custom_window': {'key': 'customWindow', 'type': 'str'},
        'start_hour': {'key': 'startHour', 'type': 'int'},
        'start_minute': {'key': 'startMinute', 'type': 'int'},
        'day_of_week': {'key': 'dayOfWeek', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MaintenanceWindow, self).__init__(**kwargs)
        self.custom_window = kwargs.get('custom_window', None)
        self.start_hour = kwargs.get('start_hour', None)
        self.start_minute = kwargs.get('start_minute', None)
        self.day_of_week = kwargs.get('day_of_week', None)


class NameAvailability(msrest.serialization.Model):
    """Represents a resource name availability.

    :param message: Error Message.
    :type message: str
    :param name_available: Indicates whether the resource name is available.
    :type name_available: bool
    :param reason: Reason for name being unavailable.
    :type reason: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailability, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)


class NameAvailabilityRequest(msrest.serialization.Model):
    """Request from client to check resource name availability.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Resource type used for verification.
    :type type: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs.get('type', None)


class Operation(msrest.serialization.Model):
    """REST API operation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: The localized display information for this particular operation or action.
    :vartype display: ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Possible values include: "NotSpecified",
     "user", "system".
    :vartype origin: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, object]
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'origin': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.origin = None
        self.properties = None


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Operation resource provider name.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of resource provider operations.

    :param value: The list of resource provider operations.
    :type value: list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class Server(TrackedResource):
    """Represents a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param identity: The Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.Identity
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.Sku
    :param administrator_login: The administrator's login name of a server. Can only be specified
     when the server is being created (and is required for creation).
    :type administrator_login: str
    :param administrator_login_password: The password of the administrator login (required for
     server creation).
    :type administrator_login_password: str
    :param version: Server version. Possible values include: "5.7".
    :type version: str or ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.SslEnforcementEnum
    :param infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Possible values include: "Enabled", "Disabled".
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.InfrastructureEncryptionEnum
    :ivar state: The state of a server. Possible values include: "Ready", "Dropping", "Disabled",
     "Starting", "Stopping", "Stopped", "Updating".
    :vartype state: str or ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.ServerState
    :ivar ha_state: The state of a HA server. Possible values include: "NotEnabled",
     "CreatingStandby", "ReplicatingData", "FailingOver", "Healthy", "RemovingStandby".
    :vartype ha_state: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.ServerHAState
    :param ha_enabled: Enable HA or not for a server. Possible values include: "Enabled",
     "Disabled".
    :type ha_enabled: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.HaEnabledEnum
    :ivar fully_qualified_domain_name: The fully qualified domain name of a server.
    :vartype fully_qualified_domain_name: str
    :ivar earliest_restore_date: Earliest restore point creation time (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.StorageProfile
    :param replication_role: The replication role.
    :type replication_role: str
    :ivar replica_capacity: The maximum number of replicas that a primary server can have.
    :vartype replica_capacity: int
    :ivar public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.PublicNetworkAccessEnum
    :param maintenance_window: Maintenance window of a server.
    :type maintenance_window:
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.MaintenanceWindow
    :param source_server_id: The source MySQL server id.
    :type source_server_id: str
    :param restore_point_in_time: Restore point creation time (ISO8601 format), specifying the time
     to restore from.
    :type restore_point_in_time: ~datetime.datetime
    :param availability_zone: availability Zone information of the server.
    :type availability_zone: str
    :ivar standby_availability_zone: availability Zone information of the server.
    :vartype standby_availability_zone: str
    :ivar byok_enforcement: Status showing whether the data encryption is enabled with customer-
     managed keys.
    :vartype byok_enforcement: str
    :param delegated_subnet_arguments: Delegated subnet arguments.
    :type delegated_subnet_arguments:
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.DelegatedSubnetArguments
    :param create_mode: The mode to create a new MySQL server. Possible values include: "Default",
     "PointInTimeRestore", "Replica".
    :type create_mode: str or ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.CreateMode
    :param tags_properties_tags: Application-specific metadata in the form of key-value pairs.
    :type tags_properties_tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'state': {'readonly': True},
        'ha_state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
        'replica_capacity': {'readonly': True, 'minimum': 0},
        'public_network_access': {'readonly': True},
        'standby_availability_zone': {'readonly': True},
        'byok_enforcement': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'ssl_enforcement': {'key': 'properties.sslEnforcement', 'type': 'str'},
        'infrastructure_encryption': {'key': 'properties.infrastructureEncryption', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'ha_state': {'key': 'properties.haState', 'type': 'str'},
        'ha_enabled': {'key': 'properties.haEnabled', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
        'replica_capacity': {'key': 'properties.replicaCapacity', 'type': 'int'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'maintenance_window': {'key': 'properties.maintenanceWindow', 'type': 'MaintenanceWindow'},
        'source_server_id': {'key': 'properties.sourceServerId', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'availability_zone': {'key': 'properties.availabilityZone', 'type': 'str'},
        'standby_availability_zone': {'key': 'properties.standbyAvailabilityZone', 'type': 'str'},
        'byok_enforcement': {'key': 'properties.byokEnforcement', 'type': 'str'},
        'delegated_subnet_arguments': {'key': 'properties.delegatedSubnetArguments', 'type': 'DelegatedSubnetArguments'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'tags_properties_tags': {'key': 'properties.tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Server, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.administrator_login = kwargs.get('administrator_login', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.version = kwargs.get('version', None)
        self.ssl_enforcement = kwargs.get('ssl_enforcement', None)
        self.infrastructure_encryption = kwargs.get('infrastructure_encryption', None)
        self.state = None
        self.ha_state = None
        self.ha_enabled = kwargs.get('ha_enabled', None)
        self.fully_qualified_domain_name = None
        self.earliest_restore_date = None
        self.storage_profile = kwargs.get('storage_profile', None)
        self.replication_role = kwargs.get('replication_role', None)
        self.replica_capacity = None
        self.public_network_access = None
        self.maintenance_window = kwargs.get('maintenance_window', None)
        self.source_server_id = kwargs.get('source_server_id', None)
        self.restore_point_in_time = kwargs.get('restore_point_in_time', None)
        self.availability_zone = kwargs.get('availability_zone', None)
        self.standby_availability_zone = None
        self.byok_enforcement = None
        self.delegated_subnet_arguments = kwargs.get('delegated_subnet_arguments', None)
        self.create_mode = kwargs.get('create_mode', None)
        self.tags_properties_tags = kwargs.get('tags_properties_tags', None)


class ServerEditionCapability(msrest.serialization.Model):
    """Server edition capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Server edition name.
    :vartype name: str
    :ivar supported_storage_editions: A list of supported storage editions.
    :vartype supported_storage_editions:
     list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.StorageEditionCapability]
    :ivar supported_server_versions: A list of supported server versions.
    :vartype supported_server_versions:
     list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.ServerVersionCapability]
    """

    _validation = {
        'name': {'readonly': True},
        'supported_storage_editions': {'readonly': True},
        'supported_server_versions': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_storage_editions': {'key': 'supportedStorageEditions', 'type': '[StorageEditionCapability]'},
        'supported_server_versions': {'key': 'supportedServerVersions', 'type': '[ServerVersionCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_storage_editions = None
        self.supported_server_versions = None


class ServerForUpdate(msrest.serialization.Model):
    """Parameters allowed to update for a server.

    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.Sku
    :param tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.StorageProfile
    :param administrator_login_password: The password of the administrator login.
    :type administrator_login_password: str
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.SslEnforcementEnum
    :param delegated_subnet_arguments: Delegated subnet arguments.
    :type delegated_subnet_arguments:
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.DelegatedSubnetArguments
    :param ha_enabled: Enable HA or not for a server. Possible values include: "Enabled",
     "Disabled".
    :type ha_enabled: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.HaEnabledEnum
    :param maintenance_window: Maintenance window of a server.
    :type maintenance_window:
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.MaintenanceWindow
    :param replication_role: The replication role of the server.
    :type replication_role: str
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'ssl_enforcement': {'key': 'properties.sslEnforcement', 'type': 'str'},
        'delegated_subnet_arguments': {'key': 'properties.delegatedSubnetArguments', 'type': 'DelegatedSubnetArguments'},
        'ha_enabled': {'key': 'properties.haEnabled', 'type': 'str'},
        'maintenance_window': {'key': 'properties.maintenanceWindow', 'type': 'MaintenanceWindow'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerForUpdate, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.ssl_enforcement = kwargs.get('ssl_enforcement', None)
        self.delegated_subnet_arguments = kwargs.get('delegated_subnet_arguments', None)
        self.ha_enabled = kwargs.get('ha_enabled', None)
        self.maintenance_window = kwargs.get('maintenance_window', None)
        self.replication_role = kwargs.get('replication_role', None)


class ServerKey(Resource):
    """A MySQL Server key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar kind: Kind of encryption protector used to protect the key.
    :vartype kind: str
    :param server_key_type: The key type like 'AzureKeyVault'. Possible values include:
     "AzureKeyVault".
    :type server_key_type: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.ServerKeyType
    :param uri: The URI of the key.
    :type uri: str
    :ivar creation_date: The key creation date.
    :vartype creation_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'creation_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerKey, self).__init__(**kwargs)
        self.kind = None
        self.server_key_type = kwargs.get('server_key_type', None)
        self.uri = kwargs.get('uri', None)
        self.creation_date = None


class ServerKeyListResult(msrest.serialization.Model):
    """A list of MySQL Server keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of MySQL Server keys.
    :vartype value: list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.ServerKey]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerKey]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerKeyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerListResult(msrest.serialization.Model):
    """A list of servers.

    :param value: The list of servers.
    :type value: list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.Server]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Server]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ServerVersionCapability(msrest.serialization.Model):
    """Server version capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: server version.
    :vartype name: str
    :ivar supported_vcores: A list of supported Vcores.
    :vartype supported_vcores:
     list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.VcoreCapability]
    """

    _validation = {
        'name': {'readonly': True},
        'supported_vcores': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_vcores': {'key': 'supportedVcores', 'type': '[VcoreCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerVersionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_vcores = None


class Sku(msrest.serialization.Model):
    """Billing information related properties of a server.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the sku, e.g. Standard_D32s_v3.
    :type name: str
    :param tier: Required. The tier of the particular SKU, e.g. GeneralPurpose. Possible values
     include: "Burstable", "GeneralPurpose", "MemoryOptimized".
    :type tier: str or ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = kwargs['tier']


class StorageEditionCapability(msrest.serialization.Model):
    """storage edition capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: storage edition name.
    :vartype name: str
    :ivar min_storage_size: The minimal supported storage size in MB.
    :vartype min_storage_size:
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.StorageMBCapability
    :ivar max_storage_size: The maximum supported storage size in MB.
    :vartype max_storage_size:
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.StorageMBCapability
    :ivar min_backup_retention_days: Minimal backup retention days.
    :vartype min_backup_retention_days: long
    :ivar max_backup_retention_days: Maximum backup retention days.
    :vartype max_backup_retention_days: long
    """

    _validation = {
        'name': {'readonly': True},
        'min_storage_size': {'readonly': True},
        'max_storage_size': {'readonly': True},
        'min_backup_retention_days': {'readonly': True},
        'max_backup_retention_days': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'min_storage_size': {'key': 'minStorageSize', 'type': 'StorageMBCapability'},
        'max_storage_size': {'key': 'maxStorageSize', 'type': 'StorageMBCapability'},
        'min_backup_retention_days': {'key': 'minBackupRetentionDays', 'type': 'long'},
        'max_backup_retention_days': {'key': 'maxBackupRetentionDays', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.min_storage_size = None
        self.max_storage_size = None
        self.min_backup_retention_days = None
        self.max_backup_retention_days = None


class StorageMBCapability(msrest.serialization.Model):
    """storage size in MB capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: storage MB name.
    :vartype name: str
    :ivar storage_size_mb: storage size in MB.
    :vartype storage_size_mb: long
    """

    _validation = {
        'name': {'readonly': True},
        'storage_size_mb': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'storage_size_mb': {'key': 'storageSizeMB', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageMBCapability, self).__init__(**kwargs)
        self.name = None
        self.storage_size_mb = None


class StorageProfile(msrest.serialization.Model):
    """Storage Profile properties of a server.

    :param backup_retention_days: Backup retention days for the server.
    :type backup_retention_days: int
    :param storage_mb: Max storage allowed for a server.
    :type storage_mb: int
    :param storage_iops: Storage IOPS for a server.
    :type storage_iops: int
    :param storage_autogrow: Enable Storage Auto Grow. Possible values include: "Enabled",
     "Disabled".
    :type storage_autogrow: str or
     ~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.StorageAutogrow
    """

    _attribute_map = {
        'backup_retention_days': {'key': 'backupRetentionDays', 'type': 'int'},
        'storage_mb': {'key': 'storageMB', 'type': 'int'},
        'storage_iops': {'key': 'storageIops', 'type': 'int'},
        'storage_autogrow': {'key': 'storageAutogrow', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageProfile, self).__init__(**kwargs)
        self.backup_retention_days = kwargs.get('backup_retention_days', None)
        self.storage_mb = kwargs.get('storage_mb', None)
        self.storage_iops = kwargs.get('storage_iops', None)
        self.storage_autogrow = kwargs.get('storage_autogrow', None)


class VcoreCapability(msrest.serialization.Model):
    """Vcores capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: vCore name.
    :vartype name: str
    :ivar v_cores: supported vCores.
    :vartype v_cores: long
    :ivar supported_iops: supported IOPS.
    :vartype supported_iops: long
    :ivar supported_memory_per_vcore_mb: supported memory per vCore in MB.
    :vartype supported_memory_per_vcore_mb: long
    """

    _validation = {
        'name': {'readonly': True},
        'v_cores': {'readonly': True},
        'supported_iops': {'readonly': True},
        'supported_memory_per_vcore_mb': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'v_cores': {'key': 'vCores', 'type': 'long'},
        'supported_iops': {'key': 'supportedIops', 'type': 'long'},
        'supported_memory_per_vcore_mb': {'key': 'supportedMemoryPerVcoreMB', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VcoreCapability, self).__init__(**kwargs)
        self.name = None
        self.v_cores = None
        self.supported_iops = None
        self.supported_memory_per_vcore_mb = None


class VirtualNetworkSubnetUsageParameter(msrest.serialization.Model):
    """Virtual network subnet usage parameter.

    :param virtual_network_arm_resource_id: Virtual network resource id.
    :type virtual_network_arm_resource_id: str
    """

    _attribute_map = {
        'virtual_network_arm_resource_id': {'key': 'virtualNetworkArmResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkSubnetUsageParameter, self).__init__(**kwargs)
        self.virtual_network_arm_resource_id = kwargs.get('virtual_network_arm_resource_id', None)


class VirtualNetworkSubnetUsageResult(msrest.serialization.Model):
    """Virtual network subnet usage data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar delegated_subnets_usage: A list of delegated subnet usage.
    :vartype delegated_subnets_usage:
     list[~azure.mgmt.rdbms.mysql.v2020_07_01_privatepreview.models.DelegatedSubnetUsage]
    """

    _validation = {
        'delegated_subnets_usage': {'readonly': True},
    }

    _attribute_map = {
        'delegated_subnets_usage': {'key': 'delegatedSubnetsUsage', 'type': '[DelegatedSubnetUsage]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkSubnetUsageResult, self).__init__(**kwargs)
        self.delegated_subnets_usage = None
