// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type ModifyVpcRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* Vpc ID  */
    VpcId string `json:"vpcId"`

    /* 私有网络名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符。 (Optional) */
    VpcName *string `json:"vpcName"`

    /* vpc描述，允许输入UTF-8编码下的全部字符，不超过256字符。 (Optional) */
    Description *string `json:"description"`
}

/*
 * param regionId: Region ID (Required)
 * param vpcId: Vpc ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewModifyVpcRequest(
    regionId string,
    vpcId string,
) *ModifyVpcRequest {

	return &ModifyVpcRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/vpcs/{vpcId}",
			Method:  "PATCH",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        VpcId: vpcId,
	}
}

/*
 * param regionId: Region ID (Required)
 * param vpcId: Vpc ID (Required)
 * param vpcName: 私有网络名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符。 (Optional)
 * param description: vpc描述，允许输入UTF-8编码下的全部字符，不超过256字符。 (Optional)
 */
func NewModifyVpcRequestWithAllParams(
    regionId string,
    vpcId string,
    vpcName *string,
    description *string,
) *ModifyVpcRequest {

    return &ModifyVpcRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/vpcs/{vpcId}",
            Method:  "PATCH",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        VpcId: vpcId,
        VpcName: vpcName,
        Description: description,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewModifyVpcRequestWithoutParam() *ModifyVpcRequest {

    return &ModifyVpcRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/vpcs/{vpcId}",
            Method:  "PATCH",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *ModifyVpcRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param vpcId: Vpc ID(Required) */
func (r *ModifyVpcRequest) SetVpcId(vpcId string) {
    r.VpcId = vpcId
}

/* param vpcName: 私有网络名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符。(Optional) */
func (r *ModifyVpcRequest) SetVpcName(vpcName string) {
    r.VpcName = &vpcName
}

/* param description: vpc描述，允许输入UTF-8编码下的全部字符，不超过256字符。(Optional) */
func (r *ModifyVpcRequest) SetDescription(description string) {
    r.Description = &description
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r ModifyVpcRequest) GetRegionId() string {
    return r.RegionId
}

type ModifyVpcResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result ModifyVpcResult `json:"result"`
}

type ModifyVpcResult struct {
}