// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <IFSelect_ContextModif.hxx>
#include <IGESData_BasicEditor.hxx>
#include <IGESData_IGESEntity.hxx>
#include <IGESData_IGESModel.hxx>
#include <IGESData_Protocol.hxx>
#include <IGESSelect_AutoCorrect.hxx>
#include <Interface_Check.hxx>
#include <Interface_CopyTool.hxx>
#include <Interface_Macros.hxx>
#include <Standard_Type.hxx>
#include <TCollection_AsciiString.hxx>

IMPLEMENT_STANDARD_RTTIEXT(IGESSelect_AutoCorrect, IGESSelect_ModelModifier)

IGESSelect_AutoCorrect::IGESSelect_AutoCorrect()
    : IGESSelect_ModelModifier(Standard_False)
{
}

void IGESSelect_AutoCorrect::Performing(IFSelect_ContextModif&            ctx,
                                        const Handle(IGESData_IGESModel)& target,
                                        Interface_CopyTool&) const
{
  DeclareAndCast(IGESData_Protocol, protocol, ctx.Protocol());
  if (protocol.IsNull())
  {
    ctx.CCheck()->AddFail("IGES Auto Correct, not called with Protocol");
    return;
  }

  IGESData_BasicEditor corrector(target, protocol);
  for (ctx.Start(); ctx.More(); ctx.Next())
  {
    DeclareAndCast(IGESData_IGESEntity, ent, ctx.ValueResult());
    Standard_Boolean done = corrector.AutoCorrect(ent);
    if (done)
      ctx.Trace();
  }
}

TCollection_AsciiString IGESSelect_AutoCorrect::Label() const
{
  return TCollection_AsciiString("Auto-Correction of IGES Entities");
}
