/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/lda_exc/lda_c_1d_csc.mpl
  Type of functional: lda_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t13;
  double t14, t15, t16, t17, t18, t21, t24, t25;
  double t26, t29, t30, t31, t33, t34, tzk0;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = 0.1e1 / rho[0];
  t2 = t1 / 0.2e1;
  t3 = params->para[4];
  t4 = rho[0] * rho[0];
  t5 = 0.1e1 / t4;
  t8 = t2 + t3 * t5 / 0.4e1;
  t9 = params->para[7];
  t13 = params->para[9];
  t14 = pow(t2, t13);
  t15 = params->para[8] * t14;
  t16 = 0.1e1 + t9 * t1 / 0.2e1 + t15;
  t17 = log(t16);
  t18 = t8 * t17;
  t21 = params->para[1];
  t24 = params->para[5];
  t25 = pow(t2, t24);
  t26 = params->para[2] * t25;
  t29 = params->para[6];
  t30 = pow(t2, t29);
  t31 = params->para[3] * t30;
  t33 = t21 * t1 + 0.2e1 * t26 + 0.2e1 * t31 + 0.2e1 * params->para[0];
  t34 = 0.1e1 / t33;
  tzk0 = -t18 * t34;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t13;
  double t14, t15, t16, t17, t18, t21, t24, t25;
  double t26, t29, t30, t31, t33, t34, tzk0;

  double t37, t40, t41, t42, t44, t49, t50, t52;
  double t54, t55, t56, t64, t65, tvrho0;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = 0.1e1 / rho[0];
  t2 = t1 / 0.2e1;
  t3 = params->para[4];
  t4 = rho[0] * rho[0];
  t5 = 0.1e1 / t4;
  t8 = t2 + t3 * t5 / 0.4e1;
  t9 = params->para[7];
  t13 = params->para[9];
  t14 = pow(t2, t13);
  t15 = params->para[8] * t14;
  t16 = 0.1e1 + t9 * t1 / 0.2e1 + t15;
  t17 = log(t16);
  t18 = t8 * t17;
  t21 = params->para[1];
  t24 = params->para[5];
  t25 = pow(t2, t24);
  t26 = params->para[2] * t25;
  t29 = params->para[6];
  t30 = pow(t2, t29);
  t31 = params->para[3] * t30;
  t33 = t21 * t1 + 0.2e1 * t26 + 0.2e1 * t31 + 0.2e1 * params->para[0];
  t34 = 0.1e1 / t33;
  tzk0 = -t18 * t34;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t37 = 0.1e1 / t4 / rho[0];
  t40 = -t3 * t37 / 0.2e1 - t5 / 0.2e1;
  t41 = rho[0] * t40;
  t42 = t17 * t34;
  t44 = rho[0] * t8;
  t49 = -t9 * t5 / 0.2e1 - t15 * t13 * t1;
  t50 = 0.1e1 / t16;
  t52 = t49 * t50 * t34;
  t54 = t33 * t33;
  t55 = 0.1e1 / t54;
  t56 = t17 * t55;
  t64 = -0.2e1 * t26 * t24 * t1 - 0.2e1 * t31 * t29 * t1 - t21 * t5;
  t65 = t56 * t64;
  tvrho0 = -t41 * t42 - t44 * t52 + t44 * t65 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t13;
  double t14, t15, t16, t17, t18, t21, t24, t25;
  double t26, t29, t30, t31, t33, t34, tzk0;

  double t37, t40, t41, t42, t44, t49, t50, t52;
  double t54, t55, t56, t64, t65, tvrho0;

  double t67, t70, t71, t74, t77, t78, t81, t82;
  double t89, t94, t96, t98, t99, t100, t102, t104;
  double t105, t106, t110, t111, t112, t113, t117, t122;
  double t128, t129, tv2rho20;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = 0.1e1 / rho[0];
  t2 = t1 / 0.2e1;
  t3 = params->para[4];
  t4 = rho[0] * rho[0];
  t5 = 0.1e1 / t4;
  t8 = t2 + t3 * t5 / 0.4e1;
  t9 = params->para[7];
  t13 = params->para[9];
  t14 = pow(t2, t13);
  t15 = params->para[8] * t14;
  t16 = 0.1e1 + t9 * t1 / 0.2e1 + t15;
  t17 = log(t16);
  t18 = t8 * t17;
  t21 = params->para[1];
  t24 = params->para[5];
  t25 = pow(t2, t24);
  t26 = params->para[2] * t25;
  t29 = params->para[6];
  t30 = pow(t2, t29);
  t31 = params->para[3] * t30;
  t33 = t21 * t1 + 0.2e1 * t26 + 0.2e1 * t31 + 0.2e1 * params->para[0];
  t34 = 0.1e1 / t33;
  tzk0 = -t18 * t34;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t37 = 0.1e1 / t4 / rho[0];
  t40 = -t3 * t37 / 0.2e1 - t5 / 0.2e1;
  t41 = rho[0] * t40;
  t42 = t17 * t34;
  t44 = rho[0] * t8;
  t49 = -t9 * t5 / 0.2e1 - t15 * t13 * t1;
  t50 = 0.1e1 / t16;
  t52 = t49 * t50 * t34;
  t54 = t33 * t33;
  t55 = 0.1e1 / t54;
  t56 = t17 * t55;
  t64 = -0.2e1 * t26 * t24 * t1 - 0.2e1 * t31 * t29 * t1 - t21 * t5;
  t65 = t56 * t64;
  tvrho0 = -t41 * t42 - t44 * t52 + t44 * t65 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t67 = t40 * t17;
  t70 = t8 * t49;
  t71 = t50 * t34;
  t74 = t55 * t64;
  t77 = t4 * t4;
  t78 = 0.1e1 / t77;
  t81 = t37 + 0.3e1 / 0.2e1 * t3 * t78;
  t82 = rho[0] * t81;
  t89 = t13 * t13;
  t94 = t15 * t13 * t5 + t15 * t89 * t5 + t9 * t37;
  t96 = t94 * t50 * t34;
  t98 = t49 * t49;
  t99 = t16 * t16;
  t100 = 0.1e1 / t99;
  t102 = t98 * t100 * t34;
  t104 = t44 * t49;
  t105 = t50 * t55;
  t106 = t105 * t64;
  t110 = 0.1e1 / t54 / t33;
  t111 = t17 * t110;
  t112 = t64 * t64;
  t113 = t111 * t112;
  t117 = t24 * t24;
  t122 = t29 * t29;
  t128 = 0.2e1 * t26 * t117 * t5 + 0.2e1 * t31 * t122 * t5 + 0.2e1 * t26 * t24 * t5 + 0.2e1 * t31 * t29 * t5 + 0.2e1 * t21 * t37;
  t129 = t56 * t128;
  tv2rho20 = t44 * t102 + 0.2e1 * t104 * t106 - 0.2e1 * t44 * t113 + t44 * t129 + 0.2e1 * t18 * t74 - 0.2e1 * t67 * t34 - 0.2e1 * t41 * t52 + 0.2e1 * t41 * t65 - t82 * t42 - t44 * t96 - 0.2e1 * t70 * t71;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t13;
  double t14, t15, t16, t17, t18, t21, t24, t25;
  double t26, t29, t30, t31, t33, t34, tzk0;

  double t37, t40, t41, t42, t44, t49, t50, t52;
  double t54, t55, t56, t64, t65, tvrho0;

  double t67, t70, t71, t74, t77, t78, t81, t82;
  double t89, t94, t96, t98, t99, t100, t102, t104;
  double t105, t106, t110, t111, t112, t113, t117, t122;
  double t128, t129, tv2rho20;

  double t131, t136, t145, t147, t151, t161, t171, t172;
  double t174, t175, t177, t178, t195, t197, t199, t202;
  double t203, t206, t207, t212, t215, t218, t223, t226;
  double t227, t229, t232, t233, t238, t239, t240, t243;
  double t246, t247, t248, t251, t252, t255, tv3rho30;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = 0.1e1 / rho[0];
  t2 = t1 / 0.2e1;
  t3 = params->para[4];
  t4 = rho[0] * rho[0];
  t5 = 0.1e1 / t4;
  t8 = t2 + t3 * t5 / 0.4e1;
  t9 = params->para[7];
  t13 = params->para[9];
  t14 = pow(t2, t13);
  t15 = params->para[8] * t14;
  t16 = 0.1e1 + t9 * t1 / 0.2e1 + t15;
  t17 = log(t16);
  t18 = t8 * t17;
  t21 = params->para[1];
  t24 = params->para[5];
  t25 = pow(t2, t24);
  t26 = params->para[2] * t25;
  t29 = params->para[6];
  t30 = pow(t2, t29);
  t31 = params->para[3] * t30;
  t33 = t21 * t1 + 0.2e1 * t26 + 0.2e1 * t31 + 0.2e1 * params->para[0];
  t34 = 0.1e1 / t33;
  tzk0 = -t18 * t34;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t37 = 0.1e1 / t4 / rho[0];
  t40 = -t3 * t37 / 0.2e1 - t5 / 0.2e1;
  t41 = rho[0] * t40;
  t42 = t17 * t34;
  t44 = rho[0] * t8;
  t49 = -t9 * t5 / 0.2e1 - t15 * t13 * t1;
  t50 = 0.1e1 / t16;
  t52 = t49 * t50 * t34;
  t54 = t33 * t33;
  t55 = 0.1e1 / t54;
  t56 = t17 * t55;
  t64 = -0.2e1 * t26 * t24 * t1 - 0.2e1 * t31 * t29 * t1 - t21 * t5;
  t65 = t56 * t64;
  tvrho0 = -t41 * t42 - t44 * t52 + t44 * t65 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t67 = t40 * t17;
  t70 = t8 * t49;
  t71 = t50 * t34;
  t74 = t55 * t64;
  t77 = t4 * t4;
  t78 = 0.1e1 / t77;
  t81 = t37 + 0.3e1 / 0.2e1 * t3 * t78;
  t82 = rho[0] * t81;
  t89 = t13 * t13;
  t94 = t15 * t13 * t5 + t15 * t89 * t5 + t9 * t37;
  t96 = t94 * t50 * t34;
  t98 = t49 * t49;
  t99 = t16 * t16;
  t100 = 0.1e1 / t99;
  t102 = t98 * t100 * t34;
  t104 = t44 * t49;
  t105 = t50 * t55;
  t106 = t105 * t64;
  t110 = 0.1e1 / t54 / t33;
  t111 = t17 * t110;
  t112 = t64 * t64;
  t113 = t111 * t112;
  t117 = t24 * t24;
  t122 = t29 * t29;
  t128 = 0.2e1 * t26 * t117 * t5 + 0.2e1 * t31 * t122 * t5 + 0.2e1 * t26 * t24 * t5 + 0.2e1 * t31 * t29 * t5 + 0.2e1 * t21 * t37;
  t129 = t56 * t128;
  tv2rho20 = t44 * t102 + 0.2e1 * t104 * t106 - 0.2e1 * t44 * t113 + t44 * t129 + 0.2e1 * t18 * t74 - 0.2e1 * t67 * t34 - 0.2e1 * t41 * t52 + 0.2e1 * t41 * t65 - t82 * t42 - t44 * t96 - 0.2e1 * t70 * t71;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t131 = t81 * t17;
  t136 = t89 * t13;
  t145 = -0.2e1 * t15 * t13 * t37 - t15 * t136 * t37 - 0.3e1 * t15 * t89 * t37 - 0.3e1 * t9 * t78;
  t147 = t145 * t50 * t34;
  t151 = t117 * t24;
  t161 = t122 * t29;
  t171 = -0.6e1 * t26 * t117 * t37 - 0.6e1 * t31 * t122 * t37 - 0.2e1 * t26 * t151 * t37 - 0.2e1 * t31 * t161 * t37 - 0.4e1 * t26 * t24 * t37 - 0.4e1 * t31 * t29 * t37 - 0.6e1 * t21 * t78;
  t172 = t56 * t171;
  t174 = t54 * t54;
  t175 = 0.1e1 / t174;
  t177 = t112 * t64;
  t178 = t17 * t175 * t177;
  t195 = t98 * t49;
  t197 = 0.1e1 / t99 / t16;
  t199 = t195 * t197 * t34;
  t202 = t8 * t98;
  t203 = t100 * t34;
  t206 = 0.3e1 * t41 * t102 + 0.6e1 * t70 * t106 - 0.6e1 * t41 * t113 + 0.3e1 * t41 * t129 - 0.3e1 * t131 * t34 - t44 * t147 + t44 * t172 + 0.6e1 * t44 * t178 - 0.2e1 * t44 * t199 + 0.3e1 * t202 * t203 - 0.3e1 * t41 * t96 - 0.3e1 * t82 * t52 + 0.3e1 * t82 * t65;
  t207 = t110 * t112;
  t212 = t40 * t49;
  t215 = t8 * t94;
  t218 = t55 * t128;
  t223 = 0.1e1 / t77 / rho[0];
  t226 = -0.6e1 * t3 * t223 - 0.3e1 * t78;
  t227 = rho[0] * t226;
  t229 = t41 * t49;
  t232 = t44 * t94;
  t233 = t203 * t49;
  t238 = t44 * t98;
  t239 = t100 * t55;
  t240 = t239 * t64;
  t243 = t105 * t128;
  t246 = t44 * t17;
  t247 = t110 * t64;
  t248 = t247 * t128;
  t251 = t50 * t110;
  t252 = t251 * t112;
  t255 = 0.3e1 * t104 * t243 - 0.6e1 * t104 * t252 + 0.6e1 * t229 * t106 + 0.3e1 * t232 * t106 - 0.6e1 * t18 * t207 + 0.3e1 * t18 * t218 - 0.6e1 * t212 * t71 - 0.3e1 * t215 * t71 - t227 * t42 + 0.3e1 * t232 * t233 - 0.3e1 * t238 * t240 - 0.6e1 * t246 * t248 + 0.6e1 * t67 * t74;
  tv3rho30 = t206 + t255;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t13;
  double t14, t15, t16, t17, t18, t21, t24, t25;
  double t26, t29, t30, t31, t33, t34, tzk0;

  double t37, t40, t41, t42, t44, t49, t50, t52;
  double t54, t55, t56, t64, t65, tvrho0;

  double t67, t70, t71, t74, t77, t78, t81, t82;
  double t89, t94, t96, t98, t99, t100, t102, t104;
  double t105, t106, t110, t111, t112, t113, t117, t122;
  double t128, t129, tv2rho20;

  double t131, t136, t145, t147, t151, t161, t171, t172;
  double t174, t175, t177, t178, t195, t197, t199, t202;
  double t203, t206, t207, t212, t215, t218, t223, t226;
  double t227, t229, t232, t233, t238, t239, t240, t243;
  double t246, t247, t248, t251, t252, t255, tv3rho30;

  double t266, t272, t280, t287, t288, t300, t309, t327;
  double t340, t372, t378, t423, t433, t470, tv4rho40;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = 0.1e1 / rho[0];
  t2 = t1 / 0.2e1;
  t3 = params->para[4];
  t4 = rho[0] * rho[0];
  t5 = 0.1e1 / t4;
  t8 = t2 + t3 * t5 / 0.4e1;
  t9 = params->para[7];
  t13 = params->para[9];
  t14 = pow(t2, t13);
  t15 = params->para[8] * t14;
  t16 = 0.1e1 + t9 * t1 / 0.2e1 + t15;
  t17 = log(t16);
  t18 = t8 * t17;
  t21 = params->para[1];
  t24 = params->para[5];
  t25 = pow(t2, t24);
  t26 = params->para[2] * t25;
  t29 = params->para[6];
  t30 = pow(t2, t29);
  t31 = params->para[3] * t30;
  t33 = t21 * t1 + 0.2e1 * t26 + 0.2e1 * t31 + 0.2e1 * params->para[0];
  t34 = 0.1e1 / t33;
  tzk0 = -t18 * t34;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t37 = 0.1e1 / t4 / rho[0];
  t40 = -t3 * t37 / 0.2e1 - t5 / 0.2e1;
  t41 = rho[0] * t40;
  t42 = t17 * t34;
  t44 = rho[0] * t8;
  t49 = -t9 * t5 / 0.2e1 - t15 * t13 * t1;
  t50 = 0.1e1 / t16;
  t52 = t49 * t50 * t34;
  t54 = t33 * t33;
  t55 = 0.1e1 / t54;
  t56 = t17 * t55;
  t64 = -0.2e1 * t26 * t24 * t1 - 0.2e1 * t31 * t29 * t1 - t21 * t5;
  t65 = t56 * t64;
  tvrho0 = -t41 * t42 - t44 * t52 + t44 * t65 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t67 = t40 * t17;
  t70 = t8 * t49;
  t71 = t50 * t34;
  t74 = t55 * t64;
  t77 = t4 * t4;
  t78 = 0.1e1 / t77;
  t81 = t37 + 0.3e1 / 0.2e1 * t3 * t78;
  t82 = rho[0] * t81;
  t89 = t13 * t13;
  t94 = t15 * t13 * t5 + t15 * t89 * t5 + t9 * t37;
  t96 = t94 * t50 * t34;
  t98 = t49 * t49;
  t99 = t16 * t16;
  t100 = 0.1e1 / t99;
  t102 = t98 * t100 * t34;
  t104 = t44 * t49;
  t105 = t50 * t55;
  t106 = t105 * t64;
  t110 = 0.1e1 / t54 / t33;
  t111 = t17 * t110;
  t112 = t64 * t64;
  t113 = t111 * t112;
  t117 = t24 * t24;
  t122 = t29 * t29;
  t128 = 0.2e1 * t26 * t117 * t5 + 0.2e1 * t31 * t122 * t5 + 0.2e1 * t26 * t24 * t5 + 0.2e1 * t31 * t29 * t5 + 0.2e1 * t21 * t37;
  t129 = t56 * t128;
  tv2rho20 = t44 * t102 + 0.2e1 * t104 * t106 - 0.2e1 * t44 * t113 + t44 * t129 + 0.2e1 * t18 * t74 - 0.2e1 * t67 * t34 - 0.2e1 * t41 * t52 + 0.2e1 * t41 * t65 - t82 * t42 - t44 * t96 - 0.2e1 * t70 * t71;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t131 = t81 * t17;
  t136 = t89 * t13;
  t145 = -0.2e1 * t15 * t13 * t37 - t15 * t136 * t37 - 0.3e1 * t15 * t89 * t37 - 0.3e1 * t9 * t78;
  t147 = t145 * t50 * t34;
  t151 = t117 * t24;
  t161 = t122 * t29;
  t171 = -0.6e1 * t26 * t117 * t37 - 0.6e1 * t31 * t122 * t37 - 0.2e1 * t26 * t151 * t37 - 0.2e1 * t31 * t161 * t37 - 0.4e1 * t26 * t24 * t37 - 0.4e1 * t31 * t29 * t37 - 0.6e1 * t21 * t78;
  t172 = t56 * t171;
  t174 = t54 * t54;
  t175 = 0.1e1 / t174;
  t177 = t112 * t64;
  t178 = t17 * t175 * t177;
  t195 = t98 * t49;
  t197 = 0.1e1 / t99 / t16;
  t199 = t195 * t197 * t34;
  t202 = t8 * t98;
  t203 = t100 * t34;
  t206 = 0.3e1 * t41 * t102 + 0.6e1 * t70 * t106 - 0.6e1 * t41 * t113 + 0.3e1 * t41 * t129 - 0.3e1 * t131 * t34 - t44 * t147 + t44 * t172 + 0.6e1 * t44 * t178 - 0.2e1 * t44 * t199 + 0.3e1 * t202 * t203 - 0.3e1 * t41 * t96 - 0.3e1 * t82 * t52 + 0.3e1 * t82 * t65;
  t207 = t110 * t112;
  t212 = t40 * t49;
  t215 = t8 * t94;
  t218 = t55 * t128;
  t223 = 0.1e1 / t77 / rho[0];
  t226 = -0.6e1 * t3 * t223 - 0.3e1 * t78;
  t227 = rho[0] * t226;
  t229 = t41 * t49;
  t232 = t44 * t94;
  t233 = t203 * t49;
  t238 = t44 * t98;
  t239 = t100 * t55;
  t240 = t239 * t64;
  t243 = t105 * t128;
  t246 = t44 * t17;
  t247 = t110 * t64;
  t248 = t247 * t128;
  t251 = t50 * t110;
  t252 = t251 * t112;
  t255 = 0.3e1 * t104 * t243 - 0.6e1 * t104 * t252 + 0.6e1 * t229 * t106 + 0.3e1 * t232 * t106 - 0.6e1 * t18 * t207 + 0.3e1 * t18 * t218 - 0.6e1 * t212 * t71 - 0.3e1 * t215 * t71 - t227 * t42 + 0.3e1 * t232 * t233 - 0.3e1 * t238 * t240 - 0.6e1 * t246 * t248 + 0.6e1 * t67 * t74;
  tv3rho30 = t206 + t255;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t266 = t112 * t112;
  t272 = t128 * t128;
  t280 = t94 * t94;
  t287 = t98 * t98;
  t288 = t99 * t99;
  t300 = -0.4e1 * t226 * t17 * t34 - 0.24e2 * t70 * t252 + 0.12e2 * t70 * t243 - 0.24e2 * t44 * t17 / t174 / t33 * t266 - 0.24e2 * t18 * t248 - 0.6e1 * t44 * t111 * t272 + 0.24e2 * t41 * t178 + 0.12e2 * t215 * t233 + 0.3e1 * t44 * t280 * t100 * t34 + 0.12e2 * t215 * t106 + 0.6e1 * t44 * t287 / t288 * t34 - 0.12e2 * t202 * t240 + 0.6e1 * t82 * t129 - 0.4e1 * t227 * t52;
  t309 = t89 * t89;
  t327 = t117 * t117;
  t340 = t122 * t122;
  t372 = t197 * t34;
  t378 = -0.6e1 * t82 * t96 - 0.4e1 * t41 * t147 + 0.4e1 * t41 * t172 - t44 * (0.6e1 * t15 * t13 * t78 + 0.6e1 * t15 * t136 * t78 + t15 * t309 * t78 + 0.11e2 * t15 * t89 * t78 + 0.12e2 * t9 * t223) * t50 * t34 + t44 * t56 * (0.22e2 * t26 * t117 * t78 + 0.22e2 * t31 * t122 * t78 + 0.12e2 * t26 * t151 * t78 + 0.12e2 * t31 * t161 * t78 + 0.12e2 * t26 * t24 * t78 + 0.2e1 * t26 * t327 * t78 + 0.12e2 * t31 * t29 * t78 + 0.2e1 * t31 * t340 * t78 + 0.24e2 * t21 * t223) + 0.6e1 * t82 * t102 - 0.12e2 * t82 * t113 + 0.4e1 * t227 * t65 - 0.8e1 * t41 * t199 + 0.24e2 * t212 * t106 + 0.12e2 * t40 * t98 * t203 - 0.24e2 * t67 * t207 - 0.8e1 * t8 * t195 * t372 + 0.24e2 * t18 * t175 * t177;
  t423 = 0.12e2 * t131 * t74 - 0.12e2 * t81 * t49 * t71 - 0.12e2 * t40 * t94 * t71 + 0.12e2 * t67 * t218 - 0.4e1 * t8 * t145 * t71 + 0.4e1 * t18 * t55 * t171 - rho[0] * (0.12e2 * t223 + 0.3e2 * t3 / t77 / t4) * t42 + 0.12e2 * t229 * t203 * t94 - 0.12e2 * t41 * t98 * t240 + 0.12e2 * t82 * t49 * t106 + 0.12e2 * t41 * t94 * t106 + 0.12e2 * t229 * t243 - 0.24e2 * t229 * t252 - 0.12e2 * t232 * t372 * t98;
  t433 = t44 * t145;
  t470 = 0.8e1 * t44 * t195 * t197 * t55 * t64 + 0.12e2 * t238 * t100 * t110 * t112 - 0.24e2 * t104 * t251 * t128 * t64 + 0.24e2 * t104 * t50 * t175 * t177 + 0.36e2 * t246 * t175 * t112 * t128 - 0.12e2 * t232 * t239 * t49 * t64 + 0.4e1 * t104 * t105 * t171 - 0.6e1 * t238 * t239 * t128 - 0.24e2 * t41 * t17 * t248 - 0.8e1 * t246 * t247 * t171 + 0.4e1 * t433 * t106 + 0.6e1 * t232 * t243 - 0.12e2 * t232 * t252 + 0.4e1 * t433 * t233;
  tv4rho40 = t300 + t378 + t423 + t470;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t9, t10;
  double t14, t15, t16, t17, t18, t19, t22, t25;
  double t26, t27, t30, t31, t32, t34, t35, t36;
  double t37, t40, t41, t45, t46, t47, t48, t49;
  double t50, t53, t56, t57, t58, t61, t62, t63;
  double t65, t66, t68, t69, t70, t71, t72, tzk0;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = 0.1e1 / t1;
  t3 = t2 / 0.2e1;
  t4 = params->para[4];
  t5 = t1 * t1;
  t6 = 0.1e1 / t5;
  t9 = t3 + t4 * t6 / 0.4e1;
  t10 = params->para[7];
  t14 = params->para[9];
  t15 = pow(t3, t14);
  t16 = params->para[8] * t15;
  t17 = 0.1e1 + t10 * t2 / 0.2e1 + t16;
  t18 = log(t17);
  t19 = t9 * t18;
  t22 = params->para[1];
  t25 = params->para[5];
  t26 = pow(t3, t25);
  t27 = params->para[2] * t26;
  t30 = params->para[6];
  t31 = pow(t3, t30);
  t32 = params->para[3] * t31;
  t34 = t22 * t2 + 0.2e1 * t27 + 0.2e1 * t32 + 0.2e1 * params->para[0];
  t35 = 0.1e1 / t34;
  t36 = t19 * t35;
  t37 = params->ferro[4];
  t40 = t3 + t37 * t6 / 0.4e1;
  t41 = params->ferro[7];
  t45 = params->ferro[9];
  t46 = pow(t3, t45);
  t47 = params->ferro[8] * t46;
  t48 = 0.1e1 + t41 * t2 / 0.2e1 + t47;
  t49 = log(t48);
  t50 = t40 * t49;
  t53 = params->ferro[1];
  t56 = params->ferro[5];
  t57 = pow(t3, t56);
  t58 = params->ferro[2] * t57;
  t61 = params->ferro[6];
  t62 = pow(t3, t61);
  t63 = params->ferro[3] * t62;
  t65 = t53 * t2 + 0.2e1 * t58 + 0.2e1 * t63 + 0.2e1 * params->ferro[0];
  t66 = 0.1e1 / t65;
  t68 = -t50 * t66 + t36;
  t69 = rho[0] - rho[1];
  t70 = t69 * t69;
  t71 = t68 * t70;
  t72 = t71 * t6;
  tzk0 = -t36 + t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t9, t10;
  double t14, t15, t16, t17, t18, t19, t22, t25;
  double t26, t27, t30, t31, t32, t34, t35, t36;
  double t37, t40, t41, t45, t46, t47, t48, t49;
  double t50, t53, t56, t57, t58, t61, t62, t63;
  double t65, t66, t68, t69, t70, t71, t72, tzk0;

  double t74, t77, t78, t79, t84, t85, t86, t87;
  double t88, t89, t90, t98, t99, t100, t103, t104;
  double t110, t111, t112, t113, t115, t116, t124, t125;
  double t127, t128, t129, t130, t131, t132, t133, t134;
  double tvrho0, tvrho1;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = 0.1e1 / t1;
  t3 = t2 / 0.2e1;
  t4 = params->para[4];
  t5 = t1 * t1;
  t6 = 0.1e1 / t5;
  t9 = t3 + t4 * t6 / 0.4e1;
  t10 = params->para[7];
  t14 = params->para[9];
  t15 = pow(t3, t14);
  t16 = params->para[8] * t15;
  t17 = 0.1e1 + t10 * t2 / 0.2e1 + t16;
  t18 = log(t17);
  t19 = t9 * t18;
  t22 = params->para[1];
  t25 = params->para[5];
  t26 = pow(t3, t25);
  t27 = params->para[2] * t26;
  t30 = params->para[6];
  t31 = pow(t3, t30);
  t32 = params->para[3] * t31;
  t34 = t22 * t2 + 0.2e1 * t27 + 0.2e1 * t32 + 0.2e1 * params->para[0];
  t35 = 0.1e1 / t34;
  t36 = t19 * t35;
  t37 = params->ferro[4];
  t40 = t3 + t37 * t6 / 0.4e1;
  t41 = params->ferro[7];
  t45 = params->ferro[9];
  t46 = pow(t3, t45);
  t47 = params->ferro[8] * t46;
  t48 = 0.1e1 + t41 * t2 / 0.2e1 + t47;
  t49 = log(t48);
  t50 = t40 * t49;
  t53 = params->ferro[1];
  t56 = params->ferro[5];
  t57 = pow(t3, t56);
  t58 = params->ferro[2] * t57;
  t61 = params->ferro[6];
  t62 = pow(t3, t61);
  t63 = params->ferro[3] * t62;
  t65 = t53 * t2 + 0.2e1 * t58 + 0.2e1 * t63 + 0.2e1 * params->ferro[0];
  t66 = 0.1e1 / t65;
  t68 = -t50 * t66 + t36;
  t69 = rho[0] - rho[1];
  t70 = t69 * t69;
  t71 = t68 * t70;
  t72 = t71 * t6;
  tzk0 = -t36 + t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = 0.1e1 / t5 / t1;
  t77 = -t4 * t74 / 0.2e1 - t6 / 0.2e1;
  t78 = t77 * t18;
  t79 = t78 * t35;
  t84 = -t10 * t6 / 0.2e1 - t16 * t14 * t2;
  t85 = t9 * t84;
  t86 = 0.1e1 / t17;
  t87 = t86 * t35;
  t88 = t85 * t87;
  t89 = t34 * t34;
  t90 = 0.1e1 / t89;
  t98 = -0.2e1 * t27 * t25 * t2 - 0.2e1 * t32 * t30 * t2 - t22 * t6;
  t99 = t90 * t98;
  t100 = t19 * t99;
  t103 = -t37 * t74 / 0.2e1 - t6 / 0.2e1;
  t104 = t103 * t49;
  t110 = -t41 * t6 / 0.2e1 - t47 * t45 * t2;
  t111 = t40 * t110;
  t112 = 0.1e1 / t48;
  t113 = t112 * t66;
  t115 = t65 * t65;
  t116 = 0.1e1 / t115;
  t124 = -0.2e1 * t58 * t56 * t2 - 0.2e1 * t63 * t61 * t2 - t53 * t6;
  t125 = t116 * t124;
  t127 = -t104 * t66 - t111 * t113 + t50 * t125 - t100 + t79 + t88;
  t128 = t127 * t70;
  t129 = t128 * t6;
  t130 = t68 * t69;
  t131 = t130 * t6;
  t132 = 0.2e1 * t131;
  t133 = t71 * t74;
  t134 = 0.2e1 * t133;
  tvrho0 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 + t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvrho1 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 - t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t9, t10;
  double t14, t15, t16, t17, t18, t19, t22, t25;
  double t26, t27, t30, t31, t32, t34, t35, t36;
  double t37, t40, t41, t45, t46, t47, t48, t49;
  double t50, t53, t56, t57, t58, t61, t62, t63;
  double t65, t66, t68, t69, t70, t71, t72, tzk0;

  double t74, t77, t78, t79, t84, t85, t86, t87;
  double t88, t89, t90, t98, t99, t100, t103, t104;
  double t110, t111, t112, t113, t115, t116, t124, t125;
  double t127, t128, t129, t130, t131, t132, t133, t134;
  double tvrho0, tvrho1;

  double t139, t140, t141, t142, t143, t144, t145, t146;
  double t149, t150, t151, t152, t153, t154, t155, t156;
  double t158, t163, t164, t165, t166, t167, t168, t169;
  double t170, t171, t172, t173, t174, t175, t177, t178;
  double t179, t180, t181, t183, t188, t194, t195, t196;
  double t199, t200, t202, t208, t213, t214, t216, t217;
  double t218, t219, t220, t222, t223, t227, t228, t229;
  double t233, t238, t244, t245, t247, t248, t249, t250;
  double t251, t252, t253, t254, t255, t256, t257, t258;
  double t259, t260, t261, tv2rho20, t263, tv2rho21, t265, tv2rho22;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = 0.1e1 / t1;
  t3 = t2 / 0.2e1;
  t4 = params->para[4];
  t5 = t1 * t1;
  t6 = 0.1e1 / t5;
  t9 = t3 + t4 * t6 / 0.4e1;
  t10 = params->para[7];
  t14 = params->para[9];
  t15 = pow(t3, t14);
  t16 = params->para[8] * t15;
  t17 = 0.1e1 + t10 * t2 / 0.2e1 + t16;
  t18 = log(t17);
  t19 = t9 * t18;
  t22 = params->para[1];
  t25 = params->para[5];
  t26 = pow(t3, t25);
  t27 = params->para[2] * t26;
  t30 = params->para[6];
  t31 = pow(t3, t30);
  t32 = params->para[3] * t31;
  t34 = t22 * t2 + 0.2e1 * t27 + 0.2e1 * t32 + 0.2e1 * params->para[0];
  t35 = 0.1e1 / t34;
  t36 = t19 * t35;
  t37 = params->ferro[4];
  t40 = t3 + t37 * t6 / 0.4e1;
  t41 = params->ferro[7];
  t45 = params->ferro[9];
  t46 = pow(t3, t45);
  t47 = params->ferro[8] * t46;
  t48 = 0.1e1 + t41 * t2 / 0.2e1 + t47;
  t49 = log(t48);
  t50 = t40 * t49;
  t53 = params->ferro[1];
  t56 = params->ferro[5];
  t57 = pow(t3, t56);
  t58 = params->ferro[2] * t57;
  t61 = params->ferro[6];
  t62 = pow(t3, t61);
  t63 = params->ferro[3] * t62;
  t65 = t53 * t2 + 0.2e1 * t58 + 0.2e1 * t63 + 0.2e1 * params->ferro[0];
  t66 = 0.1e1 / t65;
  t68 = -t50 * t66 + t36;
  t69 = rho[0] - rho[1];
  t70 = t69 * t69;
  t71 = t68 * t70;
  t72 = t71 * t6;
  tzk0 = -t36 + t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = 0.1e1 / t5 / t1;
  t77 = -t4 * t74 / 0.2e1 - t6 / 0.2e1;
  t78 = t77 * t18;
  t79 = t78 * t35;
  t84 = -t10 * t6 / 0.2e1 - t16 * t14 * t2;
  t85 = t9 * t84;
  t86 = 0.1e1 / t17;
  t87 = t86 * t35;
  t88 = t85 * t87;
  t89 = t34 * t34;
  t90 = 0.1e1 / t89;
  t98 = -0.2e1 * t27 * t25 * t2 - 0.2e1 * t32 * t30 * t2 - t22 * t6;
  t99 = t90 * t98;
  t100 = t19 * t99;
  t103 = -t37 * t74 / 0.2e1 - t6 / 0.2e1;
  t104 = t103 * t49;
  t110 = -t41 * t6 / 0.2e1 - t47 * t45 * t2;
  t111 = t40 * t110;
  t112 = 0.1e1 / t48;
  t113 = t112 * t66;
  t115 = t65 * t65;
  t116 = 0.1e1 / t115;
  t124 = -0.2e1 * t58 * t56 * t2 - 0.2e1 * t63 * t61 * t2 - t53 * t6;
  t125 = t116 * t124;
  t127 = -t104 * t66 - t111 * t113 + t50 * t125 - t100 + t79 + t88;
  t128 = t127 * t70;
  t129 = t128 * t6;
  t130 = t68 * t69;
  t131 = t130 * t6;
  t132 = 0.2e1 * t131;
  t133 = t71 * t74;
  t134 = 0.2e1 * t133;
  tvrho0 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 + t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvrho1 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 - t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t139 = 0.2e1 * t79;
  t140 = 0.2e1 * t88;
  t141 = 0.2e1 * t100;
  t142 = 0.2e1 * t129;
  t143 = 0.4e1 * t131;
  t144 = 0.4e1 * t133;
  t145 = t5 * t5;
  t146 = 0.1e1 / t145;
  t149 = t74 + 0.3e1 / 0.2e1 * t4 * t146;
  t150 = t149 * t18;
  t151 = t150 * t35;
  t152 = t77 * t84;
  t153 = t152 * t87;
  t154 = 0.2e1 * t153;
  t155 = t78 * t99;
  t156 = 0.2e1 * t155;
  t158 = t14 * t14;
  t163 = t16 * t14 * t6 + t16 * t158 * t6 + t10 * t74;
  t164 = t9 * t163;
  t165 = t164 * t87;
  t166 = t84 * t84;
  t167 = t9 * t166;
  t168 = t17 * t17;
  t169 = 0.1e1 / t168;
  t170 = t169 * t35;
  t171 = t167 * t170;
  t172 = t86 * t90;
  t173 = t172 * t98;
  t174 = t85 * t173;
  t175 = 0.2e1 * t174;
  t177 = 0.1e1 / t89 / t34;
  t178 = t98 * t98;
  t179 = t177 * t178;
  t180 = t19 * t179;
  t181 = 0.2e1 * t180;
  t183 = t25 * t25;
  t188 = t30 * t30;
  t194 = 0.2e1 * t27 * t183 * t6 + 0.2e1 * t32 * t188 * t6 + 0.2e1 * t27 * t25 * t6 + 0.2e1 * t32 * t30 * t6 + 0.2e1 * t22 * t74;
  t195 = t90 * t194;
  t196 = t19 * t195;
  t199 = t74 + 0.3e1 / 0.2e1 * t37 * t146;
  t200 = t199 * t49;
  t202 = t103 * t110;
  t208 = t45 * t45;
  t213 = t47 * t208 * t6 + t47 * t45 * t6 + t41 * t74;
  t214 = t40 * t213;
  t216 = t110 * t110;
  t217 = t40 * t216;
  t218 = t48 * t48;
  t219 = 0.1e1 / t218;
  t220 = t219 * t66;
  t222 = t112 * t116;
  t223 = t222 * t124;
  t227 = 0.1e1 / t115 / t65;
  t228 = t124 * t124;
  t229 = t227 * t228;
  t233 = t56 * t56;
  t238 = t61 * t61;
  t244 = 0.2e1 * t58 * t233 * t6 + 0.2e1 * t63 * t238 * t6 + 0.2e1 * t58 * t56 * t6 + 0.2e1 * t63 * t61 * t6 + 0.2e1 * t53 * t74;
  t245 = t116 * t244;
  t247 = 0.2e1 * t104 * t125 + 0.2e1 * t111 * t223 - 0.2e1 * t202 * t113 - t214 * t113 - t200 * t66 + t217 * t220 - 0.2e1 * t50 * t229 + t50 * t245 + t151 + t154 - t156 + t165 - t171 - t175 + t181 - t196;
  t248 = t247 * t70;
  t249 = t248 * t6;
  t250 = t127 * t69;
  t251 = t250 * t6;
  t252 = 0.4e1 * t251;
  t253 = t128 * t74;
  t254 = 0.4e1 * t253;
  t255 = t68 * t6;
  t256 = 0.2e1 * t255;
  t257 = t130 * t74;
  t258 = 0.8e1 * t257;
  t259 = t71 * t146;
  t260 = 0.6e1 * t259;
  t261 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 + t252 - t254 + t256 - t258 + t260;
  tv2rho20 = t1 * t261 - t139 - t140 + t141 + t142 + t143 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t263 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 - t254 - t256 + t260;
  tv2rho21 = t1 * t263 - t139 - t140 + t141 + t142 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t265 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 - t252 - t254 + t256 + t258 + t260;
  tv2rho22 = t1 * t265 - t139 - t140 + t141 + t142 - t143 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t9, t10;
  double t14, t15, t16, t17, t18, t19, t22, t25;
  double t26, t27, t30, t31, t32, t34, t35, t36;
  double t37, t40, t41, t45, t46, t47, t48, t49;
  double t50, t53, t56, t57, t58, t61, t62, t63;
  double t65, t66, t68, t69, t70, t71, t72, tzk0;

  double t74, t77, t78, t79, t84, t85, t86, t87;
  double t88, t89, t90, t98, t99, t100, t103, t104;
  double t110, t111, t112, t113, t115, t116, t124, t125;
  double t127, t128, t129, t130, t131, t132, t133, t134;
  double tvrho0, tvrho1;

  double t139, t140, t141, t142, t143, t144, t145, t146;
  double t149, t150, t151, t152, t153, t154, t155, t156;
  double t158, t163, t164, t165, t166, t167, t168, t169;
  double t170, t171, t172, t173, t174, t175, t177, t178;
  double t179, t180, t181, t183, t188, t194, t195, t196;
  double t199, t200, t202, t208, t213, t214, t216, t217;
  double t218, t219, t220, t222, t223, t227, t228, t229;
  double t233, t238, t244, t245, t247, t248, t249, t250;
  double t251, t252, t253, t254, t255, t256, t257, t258;
  double t259, t260, t261, tv2rho20, t263, tv2rho21, t265, tv2rho22;

  double t267, t268, t269, t270, t271, t272, t273, t274;
  double t275, t276, t277, t278, t279, t280, t281, t282;
  double t283, t284, t285, t286, t288, t289, t290, t291;
  double t292, t293, t294, t295, t296, t297, t298, t299;
  double t300, t301, t302, t303, t304, t306, t307, t308;
  double t309, t312, t313, t314, t317, t322, t323, t326;
  double t329, t330, t334, t337, t342, t343, t345, t346;
  double t349, t350, t351, t352, t355, t358, t361, t368;
  double t377, t378, t382, t392, t402, t403, t407, t408;
  double t410, t411, t412, t413, t414, t415, t416, t418;
  double t419, t420, t421, t422, t423, t424, t425, t426;
  double t427, t428, t429, t430, t431, t432, t433, t434;
  double t435, t436, t437, t440, t449, t450, t451, t454;
  double t464, t474, t475, t476, t477, t478, t479, t480;
  double t481, t484, t485, t486, t487, t488, t489, t490;
  double t491, t492, t493, t494, t495, t496, t497, tv3rho30;
  double t498, t499, t500, t501, t502, t503, t504, tv3rho31;
  double t507, t508, tv3rho32, t511, t512, tv3rho33;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = 0.1e1 / t1;
  t3 = t2 / 0.2e1;
  t4 = params->para[4];
  t5 = t1 * t1;
  t6 = 0.1e1 / t5;
  t9 = t3 + t4 * t6 / 0.4e1;
  t10 = params->para[7];
  t14 = params->para[9];
  t15 = pow(t3, t14);
  t16 = params->para[8] * t15;
  t17 = 0.1e1 + t10 * t2 / 0.2e1 + t16;
  t18 = log(t17);
  t19 = t9 * t18;
  t22 = params->para[1];
  t25 = params->para[5];
  t26 = pow(t3, t25);
  t27 = params->para[2] * t26;
  t30 = params->para[6];
  t31 = pow(t3, t30);
  t32 = params->para[3] * t31;
  t34 = t22 * t2 + 0.2e1 * t27 + 0.2e1 * t32 + 0.2e1 * params->para[0];
  t35 = 0.1e1 / t34;
  t36 = t19 * t35;
  t37 = params->ferro[4];
  t40 = t3 + t37 * t6 / 0.4e1;
  t41 = params->ferro[7];
  t45 = params->ferro[9];
  t46 = pow(t3, t45);
  t47 = params->ferro[8] * t46;
  t48 = 0.1e1 + t41 * t2 / 0.2e1 + t47;
  t49 = log(t48);
  t50 = t40 * t49;
  t53 = params->ferro[1];
  t56 = params->ferro[5];
  t57 = pow(t3, t56);
  t58 = params->ferro[2] * t57;
  t61 = params->ferro[6];
  t62 = pow(t3, t61);
  t63 = params->ferro[3] * t62;
  t65 = t53 * t2 + 0.2e1 * t58 + 0.2e1 * t63 + 0.2e1 * params->ferro[0];
  t66 = 0.1e1 / t65;
  t68 = -t50 * t66 + t36;
  t69 = rho[0] - rho[1];
  t70 = t69 * t69;
  t71 = t68 * t70;
  t72 = t71 * t6;
  tzk0 = -t36 + t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = 0.1e1 / t5 / t1;
  t77 = -t4 * t74 / 0.2e1 - t6 / 0.2e1;
  t78 = t77 * t18;
  t79 = t78 * t35;
  t84 = -t10 * t6 / 0.2e1 - t16 * t14 * t2;
  t85 = t9 * t84;
  t86 = 0.1e1 / t17;
  t87 = t86 * t35;
  t88 = t85 * t87;
  t89 = t34 * t34;
  t90 = 0.1e1 / t89;
  t98 = -0.2e1 * t27 * t25 * t2 - 0.2e1 * t32 * t30 * t2 - t22 * t6;
  t99 = t90 * t98;
  t100 = t19 * t99;
  t103 = -t37 * t74 / 0.2e1 - t6 / 0.2e1;
  t104 = t103 * t49;
  t110 = -t41 * t6 / 0.2e1 - t47 * t45 * t2;
  t111 = t40 * t110;
  t112 = 0.1e1 / t48;
  t113 = t112 * t66;
  t115 = t65 * t65;
  t116 = 0.1e1 / t115;
  t124 = -0.2e1 * t58 * t56 * t2 - 0.2e1 * t63 * t61 * t2 - t53 * t6;
  t125 = t116 * t124;
  t127 = -t104 * t66 - t111 * t113 + t50 * t125 - t100 + t79 + t88;
  t128 = t127 * t70;
  t129 = t128 * t6;
  t130 = t68 * t69;
  t131 = t130 * t6;
  t132 = 0.2e1 * t131;
  t133 = t71 * t74;
  t134 = 0.2e1 * t133;
  tvrho0 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 + t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvrho1 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 - t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t139 = 0.2e1 * t79;
  t140 = 0.2e1 * t88;
  t141 = 0.2e1 * t100;
  t142 = 0.2e1 * t129;
  t143 = 0.4e1 * t131;
  t144 = 0.4e1 * t133;
  t145 = t5 * t5;
  t146 = 0.1e1 / t145;
  t149 = t74 + 0.3e1 / 0.2e1 * t4 * t146;
  t150 = t149 * t18;
  t151 = t150 * t35;
  t152 = t77 * t84;
  t153 = t152 * t87;
  t154 = 0.2e1 * t153;
  t155 = t78 * t99;
  t156 = 0.2e1 * t155;
  t158 = t14 * t14;
  t163 = t16 * t14 * t6 + t16 * t158 * t6 + t10 * t74;
  t164 = t9 * t163;
  t165 = t164 * t87;
  t166 = t84 * t84;
  t167 = t9 * t166;
  t168 = t17 * t17;
  t169 = 0.1e1 / t168;
  t170 = t169 * t35;
  t171 = t167 * t170;
  t172 = t86 * t90;
  t173 = t172 * t98;
  t174 = t85 * t173;
  t175 = 0.2e1 * t174;
  t177 = 0.1e1 / t89 / t34;
  t178 = t98 * t98;
  t179 = t177 * t178;
  t180 = t19 * t179;
  t181 = 0.2e1 * t180;
  t183 = t25 * t25;
  t188 = t30 * t30;
  t194 = 0.2e1 * t27 * t183 * t6 + 0.2e1 * t32 * t188 * t6 + 0.2e1 * t27 * t25 * t6 + 0.2e1 * t32 * t30 * t6 + 0.2e1 * t22 * t74;
  t195 = t90 * t194;
  t196 = t19 * t195;
  t199 = t74 + 0.3e1 / 0.2e1 * t37 * t146;
  t200 = t199 * t49;
  t202 = t103 * t110;
  t208 = t45 * t45;
  t213 = t47 * t208 * t6 + t47 * t45 * t6 + t41 * t74;
  t214 = t40 * t213;
  t216 = t110 * t110;
  t217 = t40 * t216;
  t218 = t48 * t48;
  t219 = 0.1e1 / t218;
  t220 = t219 * t66;
  t222 = t112 * t116;
  t223 = t222 * t124;
  t227 = 0.1e1 / t115 / t65;
  t228 = t124 * t124;
  t229 = t227 * t228;
  t233 = t56 * t56;
  t238 = t61 * t61;
  t244 = 0.2e1 * t58 * t233 * t6 + 0.2e1 * t63 * t238 * t6 + 0.2e1 * t58 * t56 * t6 + 0.2e1 * t63 * t61 * t6 + 0.2e1 * t53 * t74;
  t245 = t116 * t244;
  t247 = 0.2e1 * t104 * t125 + 0.2e1 * t111 * t223 - 0.2e1 * t202 * t113 - t214 * t113 - t200 * t66 + t217 * t220 - 0.2e1 * t50 * t229 + t50 * t245 + t151 + t154 - t156 + t165 - t171 - t175 + t181 - t196;
  t248 = t247 * t70;
  t249 = t248 * t6;
  t250 = t127 * t69;
  t251 = t250 * t6;
  t252 = 0.4e1 * t251;
  t253 = t128 * t74;
  t254 = 0.4e1 * t253;
  t255 = t68 * t6;
  t256 = 0.2e1 * t255;
  t257 = t130 * t74;
  t258 = 0.8e1 * t257;
  t259 = t71 * t146;
  t260 = 0.6e1 * t259;
  t261 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 + t252 - t254 + t256 - t258 + t260;
  tv2rho20 = t1 * t261 - t139 - t140 + t141 + t142 + t143 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t263 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 - t254 - t256 + t260;
  tv2rho21 = t1 * t263 - t139 - t140 + t141 + t142 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t265 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 - t252 - t254 + t256 + t258 + t260;
  tv2rho22 = t1 * t265 - t139 - t140 + t141 + t142 - t143 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t267 = t127 * t6;
  t268 = 0.6e1 * t267;
  t269 = t68 * t74;
  t270 = 0.12e2 * t269;
  t271 = t170 * t84;
  t272 = t164 * t271;
  t273 = 0.3e1 * t272;
  t274 = t164 * t173;
  t275 = 0.3e1 * t274;
  t276 = t169 * t90;
  t277 = t276 * t98;
  t278 = t167 * t277;
  t279 = 0.3e1 * t278;
  t280 = t172 * t194;
  t281 = t85 * t280;
  t282 = 0.3e1 * t281;
  t283 = t177 * t98;
  t284 = t283 * t194;
  t285 = t19 * t284;
  t286 = 0.6e1 * t285;
  t288 = t86 * t177 * t178;
  t289 = t85 * t288;
  t290 = 0.6e1 * t289;
  t291 = t152 * t173;
  t292 = 0.6e1 * t291;
  t293 = t247 * t69;
  t294 = t293 * t6;
  t295 = 0.6e1 * t294;
  t296 = t248 * t74;
  t297 = 0.6e1 * t296;
  t298 = t250 * t74;
  t299 = 0.24e2 * t298;
  t300 = t128 * t146;
  t301 = 0.18e2 * t300;
  t302 = t268 - t270 + t273 + t275 - t279 + t282 - t286 - t290 + t292 + t295 - t297 - t299 + t301;
  t303 = t130 * t146;
  t304 = 0.36e2 * t303;
  t306 = 0.1e1 / t145 / t1;
  t307 = t71 * t306;
  t308 = 0.24e2 * t307;
  t309 = 0.3e1 * t146;
  t312 = -0.6e1 * t4 * t306 - t309;
  t313 = t312 * t18;
  t314 = t313 * t35;
  t317 = t220 * t110;
  t322 = t219 * t116;
  t323 = t322 * t124;
  t326 = t222 * t244;
  t329 = t227 * t124;
  t330 = t329 * t244;
  t334 = t112 * t227 * t228;
  t337 = t103 * t216;
  t342 = t216 * t110;
  t343 = t40 * t342;
  t345 = 0.1e1 / t218 / t48;
  t346 = t345 * t66;
  t349 = t115 * t115;
  t350 = 0.1e1 / t349;
  t351 = t228 * t124;
  t352 = t350 * t351;
  t355 = -0.6e1 * t104 * t229 + 0.3e1 * t111 * t326 - 0.6e1 * t111 * t334 + 0.6e1 * t202 * t223 + 0.3e1 * t214 * t223 + 0.3e1 * t214 * t317 - 0.3e1 * t217 * t323 + 0.3e1 * t337 * t220 - 0.6e1 * t50 * t330 - 0.2e1 * t343 * t346 + 0.6e1 * t50 * t352 - t273 - t275 + t279 - t282 + t286 + t290 - t292;
  t358 = t199 * t110;
  t361 = t103 * t213;
  t368 = t208 * t45;
  t377 = -0.3e1 * t47 * t208 * t74 - t47 * t368 * t74 - 0.2e1 * t47 * t45 * t74 - 0.3e1 * t41 * t146;
  t378 = t40 * t377;
  t382 = t233 * t56;
  t392 = t238 * t61;
  t402 = -0.6e1 * t58 * t233 * t74 - 0.6e1 * t63 * t238 * t74 - 0.2e1 * t58 * t382 * t74 - 0.2e1 * t63 * t392 * t74 - 0.4e1 * t58 * t56 * t74 - 0.4e1 * t63 * t61 * t74 - 0.6e1 * t53 * t146;
  t403 = t116 * t402;
  t407 = -0.6e1 * t37 * t306 - t309;
  t408 = t407 * t49;
  t410 = t77 * t166;
  t411 = t410 * t170;
  t412 = 0.3e1 * t411;
  t413 = t78 * t179;
  t414 = 0.6e1 * t413;
  t415 = t166 * t84;
  t416 = t9 * t415;
  t418 = 0.1e1 / t168 / t17;
  t419 = t418 * t35;
  t420 = t416 * t419;
  t421 = 0.2e1 * t420;
  t422 = t89 * t89;
  t423 = 0.1e1 / t422;
  t424 = t178 * t98;
  t425 = t423 * t424;
  t426 = t19 * t425;
  t427 = 0.6e1 * t426;
  t428 = t150 * t99;
  t429 = 0.3e1 * t428;
  t430 = t149 * t84;
  t431 = t430 * t87;
  t432 = 0.3e1 * t431;
  t433 = t77 * t163;
  t434 = t433 * t87;
  t435 = 0.3e1 * t434;
  t436 = t78 * t195;
  t437 = 0.3e1 * t436;
  t440 = t158 * t14;
  t449 = -0.2e1 * t16 * t14 * t74 - 0.3e1 * t16 * t158 * t74 - t16 * t440 * t74 - 0.3e1 * t10 * t146;
  t450 = t9 * t449;
  t451 = t450 * t87;
  t454 = t183 * t25;
  t464 = t188 * t30;
  t474 = -0.6e1 * t27 * t183 * t74 - 0.6e1 * t32 * t188 * t74 - 0.4e1 * t27 * t25 * t74 - 0.2e1 * t27 * t454 * t74 - 0.4e1 * t32 * t30 * t74 - 0.2e1 * t32 * t464 * t74 - 0.6e1 * t22 * t146;
  t475 = t90 * t474;
  t476 = t19 * t475;
  t477 = 0.3e1 * t104 * t245 - 0.3e1 * t358 * t113 - 0.3e1 * t361 * t113 - t378 * t113 + 0.3e1 * t200 * t125 + t50 * t403 - t408 * t66 + t314 - t412 + t414 + t421 - t427 - t429 + t432 + t435 - t437 + t451 - t476;
  t478 = t355 + t477;
  t479 = t478 * t70;
  t480 = t479 * t6;
  t481 = t304 - t308 - t314 + t480 + t412 - t414 - t421 + t427 + t429 - t432 - t435 + t437 - t451 + t476;
  t484 = 0.3e1 * t171;
  t485 = 0.6e1 * t174;
  t486 = 0.6e1 * t180;
  t487 = 0.6e1 * t155;
  t488 = 0.6e1 * t153;
  t489 = 0.3e1 * t165;
  t490 = 0.3e1 * t196;
  t491 = 0.12e2 * t251;
  t492 = 0.12e2 * t253;
  t493 = 0.24e2 * t257;
  t494 = 0.18e2 * t259;
  t495 = 0.3e1 * t151;
  t496 = 0.3e1 * t249;
  t497 = 0.6e1 * t255;
  tv3rho30 = t1 * (t302 + t481) + t484 + t485 - t486 + t487 - t488 - t489 + t490 + t491 - t492 - t493 + t494 - t495 + t496 + t497;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t498 = 0.2e1 * t267;
  t499 = 0.4e1 * t269;
  t500 = 0.2e1 * t294;
  t501 = 0.8e1 * t298;
  t502 = -t498 + t499 + t273 + t275 - t279 + t282 - t286 - t290 + t292 + t500 - t297 - t501 + t301;
  t503 = 0.12e2 * t303;
  t504 = t503 - t308 - t314 + t480 + t412 - t414 - t421 + t427 + t429 - t432 - t435 + t437 - t451 + t476;
  tv3rho31 = t1 * (t502 + t504) + t484 + t485 - t486 + t487 - t488 - t489 + t490 + t252 - t492 - t258 + t494 - t495 + t496 - t256;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t507 = -t498 + t499 + t273 + t275 - t279 + t282 - t286 - t290 + t292 - t500 - t297 + t501 + t301;
  t508 = -t503 - t308 - t314 + t480 + t412 - t414 - t421 + t427 + t429 - t432 - t435 + t437 - t451 + t476;
  tv3rho32 = t1 * (t507 + t508) + t484 + t485 - t486 + t487 - t488 - t489 + t490 - t252 - t492 + t258 + t494 - t495 + t496 - t256;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t511 = t268 - t270 + t273 + t275 - t279 + t282 - t286 - t290 + t292 - t295 - t297 + t299 + t301;
  t512 = -t304 - t308 - t314 + t480 + t412 - t414 - t421 + t427 + t429 - t432 - t435 + t437 - t451 + t476;
  tv3rho33 = t1 * (t511 + t512) + t484 + t485 - t486 + t487 - t488 - t489 + t490 - t491 - t492 + t493 + t494 - t495 + t496 + t497;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t9, t10;
  double t14, t15, t16, t17, t18, t19, t22, t25;
  double t26, t27, t30, t31, t32, t34, t35, t36;
  double t37, t40, t41, t45, t46, t47, t48, t49;
  double t50, t53, t56, t57, t58, t61, t62, t63;
  double t65, t66, t68, t69, t70, t71, t72, tzk0;

  double t74, t77, t78, t79, t84, t85, t86, t87;
  double t88, t89, t90, t98, t99, t100, t103, t104;
  double t110, t111, t112, t113, t115, t116, t124, t125;
  double t127, t128, t129, t130, t131, t132, t133, t134;
  double tvrho0, tvrho1;

  double t139, t140, t141, t142, t143, t144, t145, t146;
  double t149, t150, t151, t152, t153, t154, t155, t156;
  double t158, t163, t164, t165, t166, t167, t168, t169;
  double t170, t171, t172, t173, t174, t175, t177, t178;
  double t179, t180, t181, t183, t188, t194, t195, t196;
  double t199, t200, t202, t208, t213, t214, t216, t217;
  double t218, t219, t220, t222, t223, t227, t228, t229;
  double t233, t238, t244, t245, t247, t248, t249, t250;
  double t251, t252, t253, t254, t255, t256, t257, t258;
  double t259, t260, t261, tv2rho20, t263, tv2rho21, t265, tv2rho22;

  double t267, t268, t269, t270, t271, t272, t273, t274;
  double t275, t276, t277, t278, t279, t280, t281, t282;
  double t283, t284, t285, t286, t288, t289, t290, t291;
  double t292, t293, t294, t295, t296, t297, t298, t299;
  double t300, t301, t302, t303, t304, t306, t307, t308;
  double t309, t312, t313, t314, t317, t322, t323, t326;
  double t329, t330, t334, t337, t342, t343, t345, t346;
  double t349, t350, t351, t352, t355, t358, t361, t368;
  double t377, t378, t382, t392, t402, t403, t407, t408;
  double t410, t411, t412, t413, t414, t415, t416, t418;
  double t419, t420, t421, t422, t423, t424, t425, t426;
  double t427, t428, t429, t430, t431, t432, t433, t434;
  double t435, t436, t437, t440, t449, t450, t451, t454;
  double t464, t474, t475, t476, t477, t478, t479, t480;
  double t481, t484, t485, t486, t487, t488, t489, t490;
  double t491, t492, t493, t494, t495, t496, t497, tv3rho30;
  double t498, t499, t500, t501, t502, t503, t504, tv3rho31;
  double t507, t508, tv3rho32, t511, t512, tv3rho33;

  double t515, t516, t517, t518, t519, t521, t526, t579;
  double t599, t616, t629, t652, t654, t661, t665, t674;
  double t680, t681, t684, t686, t688, t691, t694, t697;
  double t699, t702, t716, t719, t732, t747, t748, t750;
  double t754, t757, t760, t761, t764, t767, t769, t770;
  double t773, t776, t779, t783, t786, t787, t789, t791;
  double t793, t795, t797, t801, t805, t809, t812, t814;
  double t816, t819, t821, t823, t825, t828, t833, t842;
  double t846, t848, t849, t850, t852, t853, t854, t855;
  double t857, t858, t859, t861, t863, t864, t865, t866;
  double t867, t869, t870, t871, t874, t875, t876, t877;
  double t878, t879, t880, t881, t882, t883, t884, t885;
  double t886, t887, t888, t889, t890, t891, t892, t893;
  double t894, t895, t896, t897, t898, t899, t900, t901;
  double t902, tv4rho40, t903, t904, t905, t906, t907, t908;
  double t910, t911, t912, t915, t916, t917, t918, t919;
  double tv4rho41, t923, t924, t926, t932, tv4rho42, t933, t937;
  double tv4rho43, t938, t939, t943, t944, tv4rho44;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = 0.1e1 / t1;
  t3 = t2 / 0.2e1;
  t4 = params->para[4];
  t5 = t1 * t1;
  t6 = 0.1e1 / t5;
  t9 = t3 + t4 * t6 / 0.4e1;
  t10 = params->para[7];
  t14 = params->para[9];
  t15 = pow(t3, t14);
  t16 = params->para[8] * t15;
  t17 = 0.1e1 + t10 * t2 / 0.2e1 + t16;
  t18 = log(t17);
  t19 = t9 * t18;
  t22 = params->para[1];
  t25 = params->para[5];
  t26 = pow(t3, t25);
  t27 = params->para[2] * t26;
  t30 = params->para[6];
  t31 = pow(t3, t30);
  t32 = params->para[3] * t31;
  t34 = t22 * t2 + 0.2e1 * t27 + 0.2e1 * t32 + 0.2e1 * params->para[0];
  t35 = 0.1e1 / t34;
  t36 = t19 * t35;
  t37 = params->ferro[4];
  t40 = t3 + t37 * t6 / 0.4e1;
  t41 = params->ferro[7];
  t45 = params->ferro[9];
  t46 = pow(t3, t45);
  t47 = params->ferro[8] * t46;
  t48 = 0.1e1 + t41 * t2 / 0.2e1 + t47;
  t49 = log(t48);
  t50 = t40 * t49;
  t53 = params->ferro[1];
  t56 = params->ferro[5];
  t57 = pow(t3, t56);
  t58 = params->ferro[2] * t57;
  t61 = params->ferro[6];
  t62 = pow(t3, t61);
  t63 = params->ferro[3] * t62;
  t65 = t53 * t2 + 0.2e1 * t58 + 0.2e1 * t63 + 0.2e1 * params->ferro[0];
  t66 = 0.1e1 / t65;
  t68 = -t50 * t66 + t36;
  t69 = rho[0] - rho[1];
  t70 = t69 * t69;
  t71 = t68 * t70;
  t72 = t71 * t6;
  tzk0 = -t36 + t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = 0.1e1 / t5 / t1;
  t77 = -t4 * t74 / 0.2e1 - t6 / 0.2e1;
  t78 = t77 * t18;
  t79 = t78 * t35;
  t84 = -t10 * t6 / 0.2e1 - t16 * t14 * t2;
  t85 = t9 * t84;
  t86 = 0.1e1 / t17;
  t87 = t86 * t35;
  t88 = t85 * t87;
  t89 = t34 * t34;
  t90 = 0.1e1 / t89;
  t98 = -0.2e1 * t27 * t25 * t2 - 0.2e1 * t32 * t30 * t2 - t22 * t6;
  t99 = t90 * t98;
  t100 = t19 * t99;
  t103 = -t37 * t74 / 0.2e1 - t6 / 0.2e1;
  t104 = t103 * t49;
  t110 = -t41 * t6 / 0.2e1 - t47 * t45 * t2;
  t111 = t40 * t110;
  t112 = 0.1e1 / t48;
  t113 = t112 * t66;
  t115 = t65 * t65;
  t116 = 0.1e1 / t115;
  t124 = -0.2e1 * t58 * t56 * t2 - 0.2e1 * t63 * t61 * t2 - t53 * t6;
  t125 = t116 * t124;
  t127 = -t104 * t66 - t111 * t113 + t50 * t125 - t100 + t79 + t88;
  t128 = t127 * t70;
  t129 = t128 * t6;
  t130 = t68 * t69;
  t131 = t130 * t6;
  t132 = 0.2e1 * t131;
  t133 = t71 * t74;
  t134 = 0.2e1 * t133;
  tvrho0 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 + t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvrho1 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 - t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t139 = 0.2e1 * t79;
  t140 = 0.2e1 * t88;
  t141 = 0.2e1 * t100;
  t142 = 0.2e1 * t129;
  t143 = 0.4e1 * t131;
  t144 = 0.4e1 * t133;
  t145 = t5 * t5;
  t146 = 0.1e1 / t145;
  t149 = t74 + 0.3e1 / 0.2e1 * t4 * t146;
  t150 = t149 * t18;
  t151 = t150 * t35;
  t152 = t77 * t84;
  t153 = t152 * t87;
  t154 = 0.2e1 * t153;
  t155 = t78 * t99;
  t156 = 0.2e1 * t155;
  t158 = t14 * t14;
  t163 = t16 * t14 * t6 + t16 * t158 * t6 + t10 * t74;
  t164 = t9 * t163;
  t165 = t164 * t87;
  t166 = t84 * t84;
  t167 = t9 * t166;
  t168 = t17 * t17;
  t169 = 0.1e1 / t168;
  t170 = t169 * t35;
  t171 = t167 * t170;
  t172 = t86 * t90;
  t173 = t172 * t98;
  t174 = t85 * t173;
  t175 = 0.2e1 * t174;
  t177 = 0.1e1 / t89 / t34;
  t178 = t98 * t98;
  t179 = t177 * t178;
  t180 = t19 * t179;
  t181 = 0.2e1 * t180;
  t183 = t25 * t25;
  t188 = t30 * t30;
  t194 = 0.2e1 * t27 * t183 * t6 + 0.2e1 * t32 * t188 * t6 + 0.2e1 * t27 * t25 * t6 + 0.2e1 * t32 * t30 * t6 + 0.2e1 * t22 * t74;
  t195 = t90 * t194;
  t196 = t19 * t195;
  t199 = t74 + 0.3e1 / 0.2e1 * t37 * t146;
  t200 = t199 * t49;
  t202 = t103 * t110;
  t208 = t45 * t45;
  t213 = t47 * t208 * t6 + t47 * t45 * t6 + t41 * t74;
  t214 = t40 * t213;
  t216 = t110 * t110;
  t217 = t40 * t216;
  t218 = t48 * t48;
  t219 = 0.1e1 / t218;
  t220 = t219 * t66;
  t222 = t112 * t116;
  t223 = t222 * t124;
  t227 = 0.1e1 / t115 / t65;
  t228 = t124 * t124;
  t229 = t227 * t228;
  t233 = t56 * t56;
  t238 = t61 * t61;
  t244 = 0.2e1 * t58 * t233 * t6 + 0.2e1 * t63 * t238 * t6 + 0.2e1 * t58 * t56 * t6 + 0.2e1 * t63 * t61 * t6 + 0.2e1 * t53 * t74;
  t245 = t116 * t244;
  t247 = 0.2e1 * t104 * t125 + 0.2e1 * t111 * t223 - 0.2e1 * t202 * t113 - t214 * t113 - t200 * t66 + t217 * t220 - 0.2e1 * t50 * t229 + t50 * t245 + t151 + t154 - t156 + t165 - t171 - t175 + t181 - t196;
  t248 = t247 * t70;
  t249 = t248 * t6;
  t250 = t127 * t69;
  t251 = t250 * t6;
  t252 = 0.4e1 * t251;
  t253 = t128 * t74;
  t254 = 0.4e1 * t253;
  t255 = t68 * t6;
  t256 = 0.2e1 * t255;
  t257 = t130 * t74;
  t258 = 0.8e1 * t257;
  t259 = t71 * t146;
  t260 = 0.6e1 * t259;
  t261 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 + t252 - t254 + t256 - t258 + t260;
  tv2rho20 = t1 * t261 - t139 - t140 + t141 + t142 + t143 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t263 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 - t254 - t256 + t260;
  tv2rho21 = t1 * t263 - t139 - t140 + t141 + t142 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t265 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 - t252 - t254 + t256 + t258 + t260;
  tv2rho22 = t1 * t265 - t139 - t140 + t141 + t142 - t143 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t267 = t127 * t6;
  t268 = 0.6e1 * t267;
  t269 = t68 * t74;
  t270 = 0.12e2 * t269;
  t271 = t170 * t84;
  t272 = t164 * t271;
  t273 = 0.3e1 * t272;
  t274 = t164 * t173;
  t275 = 0.3e1 * t274;
  t276 = t169 * t90;
  t277 = t276 * t98;
  t278 = t167 * t277;
  t279 = 0.3e1 * t278;
  t280 = t172 * t194;
  t281 = t85 * t280;
  t282 = 0.3e1 * t281;
  t283 = t177 * t98;
  t284 = t283 * t194;
  t285 = t19 * t284;
  t286 = 0.6e1 * t285;
  t288 = t86 * t177 * t178;
  t289 = t85 * t288;
  t290 = 0.6e1 * t289;
  t291 = t152 * t173;
  t292 = 0.6e1 * t291;
  t293 = t247 * t69;
  t294 = t293 * t6;
  t295 = 0.6e1 * t294;
  t296 = t248 * t74;
  t297 = 0.6e1 * t296;
  t298 = t250 * t74;
  t299 = 0.24e2 * t298;
  t300 = t128 * t146;
  t301 = 0.18e2 * t300;
  t302 = t268 - t270 + t273 + t275 - t279 + t282 - t286 - t290 + t292 + t295 - t297 - t299 + t301;
  t303 = t130 * t146;
  t304 = 0.36e2 * t303;
  t306 = 0.1e1 / t145 / t1;
  t307 = t71 * t306;
  t308 = 0.24e2 * t307;
  t309 = 0.3e1 * t146;
  t312 = -0.6e1 * t4 * t306 - t309;
  t313 = t312 * t18;
  t314 = t313 * t35;
  t317 = t220 * t110;
  t322 = t219 * t116;
  t323 = t322 * t124;
  t326 = t222 * t244;
  t329 = t227 * t124;
  t330 = t329 * t244;
  t334 = t112 * t227 * t228;
  t337 = t103 * t216;
  t342 = t216 * t110;
  t343 = t40 * t342;
  t345 = 0.1e1 / t218 / t48;
  t346 = t345 * t66;
  t349 = t115 * t115;
  t350 = 0.1e1 / t349;
  t351 = t228 * t124;
  t352 = t350 * t351;
  t355 = -0.6e1 * t104 * t229 + 0.3e1 * t111 * t326 - 0.6e1 * t111 * t334 + 0.6e1 * t202 * t223 + 0.3e1 * t214 * t223 + 0.3e1 * t214 * t317 - 0.3e1 * t217 * t323 + 0.3e1 * t337 * t220 - 0.6e1 * t50 * t330 - 0.2e1 * t343 * t346 + 0.6e1 * t50 * t352 - t273 - t275 + t279 - t282 + t286 + t290 - t292;
  t358 = t199 * t110;
  t361 = t103 * t213;
  t368 = t208 * t45;
  t377 = -0.3e1 * t47 * t208 * t74 - t47 * t368 * t74 - 0.2e1 * t47 * t45 * t74 - 0.3e1 * t41 * t146;
  t378 = t40 * t377;
  t382 = t233 * t56;
  t392 = t238 * t61;
  t402 = -0.6e1 * t58 * t233 * t74 - 0.6e1 * t63 * t238 * t74 - 0.2e1 * t58 * t382 * t74 - 0.2e1 * t63 * t392 * t74 - 0.4e1 * t58 * t56 * t74 - 0.4e1 * t63 * t61 * t74 - 0.6e1 * t53 * t146;
  t403 = t116 * t402;
  t407 = -0.6e1 * t37 * t306 - t309;
  t408 = t407 * t49;
  t410 = t77 * t166;
  t411 = t410 * t170;
  t412 = 0.3e1 * t411;
  t413 = t78 * t179;
  t414 = 0.6e1 * t413;
  t415 = t166 * t84;
  t416 = t9 * t415;
  t418 = 0.1e1 / t168 / t17;
  t419 = t418 * t35;
  t420 = t416 * t419;
  t421 = 0.2e1 * t420;
  t422 = t89 * t89;
  t423 = 0.1e1 / t422;
  t424 = t178 * t98;
  t425 = t423 * t424;
  t426 = t19 * t425;
  t427 = 0.6e1 * t426;
  t428 = t150 * t99;
  t429 = 0.3e1 * t428;
  t430 = t149 * t84;
  t431 = t430 * t87;
  t432 = 0.3e1 * t431;
  t433 = t77 * t163;
  t434 = t433 * t87;
  t435 = 0.3e1 * t434;
  t436 = t78 * t195;
  t437 = 0.3e1 * t436;
  t440 = t158 * t14;
  t449 = -0.2e1 * t16 * t14 * t74 - 0.3e1 * t16 * t158 * t74 - t16 * t440 * t74 - 0.3e1 * t10 * t146;
  t450 = t9 * t449;
  t451 = t450 * t87;
  t454 = t183 * t25;
  t464 = t188 * t30;
  t474 = -0.6e1 * t27 * t183 * t74 - 0.6e1 * t32 * t188 * t74 - 0.4e1 * t27 * t25 * t74 - 0.2e1 * t27 * t454 * t74 - 0.4e1 * t32 * t30 * t74 - 0.2e1 * t32 * t464 * t74 - 0.6e1 * t22 * t146;
  t475 = t90 * t474;
  t476 = t19 * t475;
  t477 = 0.3e1 * t104 * t245 - 0.3e1 * t358 * t113 - 0.3e1 * t361 * t113 - t378 * t113 + 0.3e1 * t200 * t125 + t50 * t403 - t408 * t66 + t314 - t412 + t414 + t421 - t427 - t429 + t432 + t435 - t437 + t451 - t476;
  t478 = t355 + t477;
  t479 = t478 * t70;
  t480 = t479 * t6;
  t481 = t304 - t308 - t314 + t480 + t412 - t414 - t421 + t427 + t429 - t432 - t435 + t437 - t451 + t476;
  t484 = 0.3e1 * t171;
  t485 = 0.6e1 * t174;
  t486 = 0.6e1 * t180;
  t487 = 0.6e1 * t155;
  t488 = 0.6e1 * t153;
  t489 = 0.3e1 * t165;
  t490 = 0.3e1 * t196;
  t491 = 0.12e2 * t251;
  t492 = 0.12e2 * t253;
  t493 = 0.24e2 * t257;
  t494 = 0.18e2 * t259;
  t495 = 0.3e1 * t151;
  t496 = 0.3e1 * t249;
  t497 = 0.6e1 * t255;
  tv3rho30 = t1 * (t302 + t481) + t484 + t485 - t486 + t487 - t488 - t489 + t490 + t491 - t492 - t493 + t494 - t495 + t496 + t497;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t498 = 0.2e1 * t267;
  t499 = 0.4e1 * t269;
  t500 = 0.2e1 * t294;
  t501 = 0.8e1 * t298;
  t502 = -t498 + t499 + t273 + t275 - t279 + t282 - t286 - t290 + t292 + t500 - t297 - t501 + t301;
  t503 = 0.12e2 * t303;
  t504 = t503 - t308 - t314 + t480 + t412 - t414 - t421 + t427 + t429 - t432 - t435 + t437 - t451 + t476;
  tv3rho31 = t1 * (t502 + t504) + t484 + t485 - t486 + t487 - t488 - t489 + t490 + t252 - t492 - t258 + t494 - t495 + t496 - t256;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t507 = -t498 + t499 + t273 + t275 - t279 + t282 - t286 - t290 + t292 - t500 - t297 + t501 + t301;
  t508 = -t503 - t308 - t314 + t480 + t412 - t414 - t421 + t427 + t429 - t432 - t435 + t437 - t451 + t476;
  tv3rho32 = t1 * (t507 + t508) + t484 + t485 - t486 + t487 - t488 - t489 + t490 - t252 - t492 + t258 + t494 - t495 + t496 - t256;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t511 = t268 - t270 + t273 + t275 - t279 + t282 - t286 - t290 + t292 - t295 - t297 + t299 + t301;
  t512 = -t304 - t308 - t314 + t480 + t412 - t414 - t421 + t427 + t429 - t432 - t435 + t437 - t451 + t476;
  tv3rho33 = t1 * (t511 + t512) + t484 + t485 - t486 + t487 - t488 - t489 + t490 - t491 - t492 + t493 + t494 - t495 + t496 + t497;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t515 = t68 * t146;
  t516 = 0.72e2 * t515;
  t517 = t127 * t74;
  t518 = 0.48e2 * t517;
  t519 = 0.12e2 * t306;
  t521 = 0.1e1 / t145 / t5;
  t526 = (0.3e2 * t4 * t521 + t519) * t18 * t35;
  t579 = -(0.3e2 * t37 * t521 + t519) * t49 * t66 + t526 + 0.12e2 * t217 * t219 * t227 * t228 + 0.24e2 * t111 * t112 * t350 * t351 - 0.12e2 * t214 * t346 * t216 + 0.36e2 * t50 * t350 * t228 * t244 - 0.8e1 * t50 * t329 * t402 + 0.4e1 * t378 * t317 + 0.4e1 * t378 * t223 + 0.6e1 * t214 * t326 + 0.8e1 * t343 * t345 * t116 * t124 - 0.6e1 * t217 * t322 * t244 + 0.4e1 * t111 * t222 * t402 - 0.24e2 * t202 * t334 - 0.12e2 * t214 * t334 + 0.12e2 * t202 * t220 * t213 - 0.12e2 * t337 * t323 + 0.12e2 * t358 * t223 + 0.12e2 * t361 * t223;
  t599 = t208 * t208;
  t616 = t233 * t233;
  t629 = t238 * t238;
  t652 = t216 * t216;
  t654 = t218 * t218;
  t661 = t228 * t228;
  t665 = t244 * t244;
  t674 = t213 * t213;
  t680 = 0.6e1 * t149 * t166 * t170;
  t681 = 0.12e2 * t202 * t326 - 0.24e2 * t104 * t330 + 0.6e1 * t200 * t245 - 0.4e1 * t407 * t110 * t113 - 0.6e1 * t199 * t213 * t113 - 0.4e1 * t103 * t377 * t113 + 0.4e1 * t104 * t403 - t40 * (0.11e2 * t47 * t208 * t146 + 0.6e1 * t47 * t368 * t146 + 0.6e1 * t47 * t45 * t146 + t47 * t599 * t146 + 0.12e2 * t41 * t306) * t113 + t50 * t116 * (0.22e2 * t58 * t233 * t146 + 0.22e2 * t63 * t238 * t146 + 0.12e2 * t58 * t382 * t146 + 0.12e2 * t63 * t392 * t146 + 0.12e2 * t58 * t56 * t146 + 0.2e1 * t58 * t616 * t146 + 0.12e2 * t63 * t61 * t146 + 0.2e1 * t63 * t629 * t146 + 0.24e2 * t53 * t306) + 0.6e1 * t199 * t216 * t220 - 0.12e2 * t200 * t229 + 0.4e1 * t408 * t125 + 0.6e1 * t40 * t652 / t654 * t66 - 0.24e2 * t50 / t349 / t65 * t661 - 0.6e1 * t50 * t227 * t665 - 0.8e1 * t103 * t342 * t346 + 0.24e2 * t104 * t352 + 0.3e1 * t40 * t674 * t220 - t680;
  t684 = 0.12e2 * t150 * t179;
  t686 = 0.4e1 * t313 * t99;
  t688 = 0.6e1 * t150 * t195;
  t691 = 0.4e1 * t312 * t84 * t87;
  t694 = 0.6e1 * t149 * t163 * t87;
  t697 = 0.4e1 * t77 * t449 * t87;
  t699 = 0.4e1 * t78 * t475;
  t702 = t158 * t158;
  t716 = t9 * (0.6e1 * t16 * t14 * t146 + 0.11e2 * t16 * t158 * t146 + 0.6e1 * t16 * t440 * t146 + t16 * t702 * t146 + 0.12e2 * t10 * t306) * t87;
  t719 = t183 * t183;
  t732 = t188 * t188;
  t747 = t19 * t90 * (0.22e2 * t27 * t183 * t146 + 0.22e2 * t32 * t188 * t146 + 0.12e2 * t27 * t25 * t146 + 0.12e2 * t27 * t454 * t146 + 0.2e1 * t27 * t719 * t146 + 0.12e2 * t32 * t30 * t146 + 0.12e2 * t32 * t464 * t146 + 0.2e1 * t32 * t732 * t146 + 0.24e2 * t22 * t306);
  t748 = t166 * t166;
  t750 = t168 * t168;
  t754 = 0.6e1 * t9 * t748 / t750 * t35;
  t757 = t178 * t178;
  t760 = 0.24e2 * t19 / t422 / t34 * t757;
  t761 = t194 * t194;
  t764 = 0.6e1 * t19 * t177 * t761;
  t767 = 0.8e1 * t77 * t415 * t419;
  t769 = 0.24e2 * t78 * t425;
  t770 = t163 * t163;
  t773 = 0.3e1 * t9 * t770 * t170;
  t776 = 0.6e1 * t167 * t276 * t194;
  t779 = 0.4e1 * t85 * t172 * t474;
  t783 = 0.36e2 * t19 * t423 * t178 * t194;
  t786 = 0.8e1 * t19 * t283 * t474;
  t787 = t684 - t686 - t688 + t691 + t694 + t697 - t699 + t716 - t747 - t754 + t760 + t764 + t767 - t769 - t773 + t776 - t779 - t783 + t786;
  t789 = 0.12e2 * t152 * t280;
  t791 = 0.24e2 * t78 * t284;
  t793 = 0.4e1 * t450 * t271;
  t795 = 0.4e1 * t450 * t173;
  t797 = 0.6e1 * t164 * t280;
  t801 = 0.8e1 * t416 * t418 * t90 * t98;
  t805 = 0.12e2 * t167 * t169 * t177 * t178;
  t809 = 0.24e2 * t85 * t86 * t423 * t424;
  t812 = 0.12e2 * t164 * t419 * t166;
  t814 = 0.24e2 * t152 * t288;
  t816 = 0.12e2 * t164 * t288;
  t819 = 0.12e2 * t152 * t170 * t163;
  t821 = 0.12e2 * t410 * t277;
  t823 = 0.12e2 * t430 * t173;
  t825 = 0.12e2 * t433 * t173;
  t828 = 0.24e2 * t85 * t86 * t284;
  t833 = 0.12e2 * t164 * t169 * t90 * t84 * t98;
  t842 = -0.12e2 * t214 * t219 * t116 * t110 * t124 - 0.24e2 * t111 * t112 * t330 - t789 + t791 - t793 - t795 - t797 - t801 - t805 - t809 + t812 + t814 + t816 - t819 + t821 - t823 - t825 + t828 + t833;
  t846 = (t579 + t681 + t787 + t842) * t70 * t6;
  t848 = 0.8e1 * t479 * t74;
  t849 = t247 * t6;
  t850 = 0.12e2 * t849;
  t852 = t478 * t69 * t6;
  t853 = 0.8e1 * t852;
  t854 = t250 * t146;
  t855 = 0.144e3 * t854;
  t857 = 0.96e2 * t128 * t306;
  t858 = t130 * t306;
  t859 = 0.192e3 * t858;
  t861 = 0.12e3 * t71 * t521;
  t863 = 0.36e2 * t248 * t146;
  t864 = t516 - t518 - t526 + t846 - t848 + t850 + t853 + t855 - t857 - t859 + t861 + t863;
  t865 = t293 * t74;
  t866 = 0.48e2 * t865;
  t867 = -t866 + t680 - t684 + t686 + t688 - t691 - t694 - t697 + t699 - t716 + t747 + t754 - t760;
  t869 = -t764 - t767 + t769 + t773 - t776 + t779 + t783 - t786 + t789 - t791 + t793 + t795;
  t870 = t797 + t801 + t805 + t809 - t812 - t814 - t816 + t819 - t821 + t823 + t825 - t828 - t833;
  t871 = t869 + t870;
  t874 = 0.24e2 * t267;
  t875 = 0.48e2 * t269;
  t876 = 0.12e2 * t272;
  t877 = 0.12e2 * t274;
  t878 = 0.12e2 * t278;
  t879 = 0.12e2 * t281;
  t880 = 0.24e2 * t285;
  t881 = 0.24e2 * t289;
  t882 = 0.24e2 * t291;
  t883 = 0.24e2 * t294;
  t884 = 0.24e2 * t296;
  t885 = 0.96e2 * t298;
  t886 = 0.72e2 * t300;
  t887 = t1 * (t864 + t867 + t871) + t874 - t875 + t876 + t877 - t878 + t879 - t880 - t881 + t882 + t883 - t884 - t885 + t886;
  t888 = 0.144e3 * t303;
  t889 = 0.96e2 * t307;
  t890 = 0.4e1 * t314;
  t891 = 0.4e1 * t480;
  t892 = 0.12e2 * t411;
  t893 = 0.24e2 * t413;
  t894 = 0.8e1 * t420;
  t895 = 0.24e2 * t426;
  t896 = 0.12e2 * t428;
  t897 = 0.12e2 * t431;
  t898 = 0.12e2 * t434;
  t899 = 0.12e2 * t436;
  t900 = 0.4e1 * t451;
  t901 = 0.4e1 * t476;
  t902 = t888 - t889 - t890 + t891 + t892 - t893 - t894 + t895 + t896 - t897 - t898 + t899 - t900 + t901;
  tv4rho40 = t887 + t902;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t903 = 0.4e1 * t852;
  t904 = 0.72e2 * t854;
  t905 = 0.96e2 * t858;
  t906 = 0.24e2 * t865;
  t907 = -t526 + t846 - t848 + t903 + t904 - t857 - t905 + t861 + t863 - t906 + t680;
  t908 = -t684 + t686 + t688 - t691 - t694 - t697 + t699 - t716 + t747 + t754 - t760 - t764;
  t910 = -t767 + t769 + t773 - t776 + t779 + t783 - t786 + t789 - t791 + t793 + t795 + t797;
  t911 = t801 + t805 + t809 - t812 - t814 - t816 + t819 - t821 + t823 + t825 - t828 - t833;
  t912 = t910 + t911;
  t915 = 0.12e2 * t294;
  t916 = 0.48e2 * t298;
  t917 = 0.72e2 * t303;
  t918 = t1 * (t907 + t908 + t912) + t876 + t877 - t878 + t879 - t880 - t881 + t882 + t915 - t884 - t916 + t886 + t917;
  t919 = -t889 - t890 + t891 + t892 - t893 - t894 + t895 + t896 - t897 - t898 + t899 - t900 + t901;
  tv4rho41 = t918 + t919;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t923 = -0.24e2 * t515 + 0.16e2 * t517 - t526 + t846 - t848 - 0.4e1 * t849 - t857 + t861 + t863 + t680 - t684;
  t924 = t686 + t688 - t691 - t694 - t697 + t699 - t716 + t747 + t754 - t760 - t764 - t767;
  t926 = t769 + t773 - t776 + t779 + t783 - t786 + t789 - t791 + t793 + t795 + t797;
  t932 = t1 * (t923 + t924 + t926 + t911) - 0.8e1 * t267 + 0.16e2 * t269 + t876 + t877 - t878 + t879 - t880 - t881 + t882 - t884 + t886;
  tv4rho42 = t932 + t919;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t933 = -t526 + t846 - t848 - t903 - t904 - t857 + t905 + t861 + t863 + t906 + t680;
  t937 = t1 * (t933 + t908 + t912) + t876 + t877 - t878 + t879 - t880 - t881 + t882 - t915 - t884 + t916 + t886 - t917;
  tv4rho43 = t937 + t919;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t938 = t516 - t518 - t526 + t846 - t848 + t850 - t853 - t855 - t857 + t859 + t861 + t863;
  t939 = t866 + t680 - t684 + t686 + t688 - t691 - t694 - t697 + t699 - t716 + t747 + t754 - t760;
  t943 = t874 - t875 + t876 + t877 - t878 + t879 - t880 - t881 + t882 + t1 * (t938 + t939 + t871) - t883 - t884 + t885 + t886;
  t944 = -t888 - t889 - t890 + t891 + t892 - t893 - t894 + t895 + t896 - t897 - t898 + t899 - t900 + t901;
  tv4rho44 = t943 + t944;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

}

#endif

