/*
 *                            COPYRIGHT
 *
 *  pcb-rnd, interactive printed circuit board design
 *  Copyright (C) 2025 Tibor 'Igor2' Palinkas
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 31 Milk Street, # 960789 Boston, MA 02196 USA.
 *
 *  Contact:
 *    Project page: http://www.repo.hu/projects/librnd
 *    lead developer: http://www.repo.hu/projects/librnd/contact.html
 *    mailing list: pcb-rnd (at) list.repo.hu (send "subscribe")
 */

/* Helper functions to create misc "small" widgets; the code for creating such
   a widget is already longer than convenient at the caller dispatch, and
   the resulting widget is typically composite, but the implementation is
   not large enough to warrant a separate file. */

/*** checkbox (BOOL) ***/


static mbtk_event_handled_t rnd_mbtk_chkbox_cb(mbtk_widget_t *w, mbtk_kw_t id, void *user_data)
{
	attr_widget_t *aw = user_data;
	rnd_hid_attribute_t *dst = &aw->actx->attrs[aw->idx];

	dst->val.lng = w->flags.activated;
	enter_cb(aw->actx, dst);
	return 0;
}

static void rnd_mbtk_chk_btn_new(mbtk_widget_t **w_out, mbtk_widget_t **wtop_out, int active, mbtk_event_handled_t (*cb)(mbtk_widget_t *, mbtk_kw_t, void *), attr_widget_t *cb_data, const char *string)
{
	mbtk_widget_t *wtop = NULL;
	mbtk_checkbox_t *chk = mbtk_checkbox_new(NULL);

	if (string != NULL) {
		mbtk_box_t *bx = mbtk_hbox_new(NULL);
		mbtk_label_t *lab = mbtk_label_new(NULL, string);

		mbtk_box_add_widget(bx, &chk->w, 0);
		mbtk_box_add_widget(bx, &lab->w, 0);

		wtop = &bx->w;
	}

	mbtk_checkbox_set_activated(chk, active);
	mbtk_checkbox_callback_toggle(chk, cb, cb_data);

	*w_out = &chk->w;
	*wtop_out = wtop;
}

void *rnd_mbtk_attr_sub_new(rnd_mbtk_t *mctx, mbtk_box_t *parent_box, rnd_hid_attribute_t *attrs, int n_attrs, void *caller_data)
{
	attr_dlg_t *actx;

	actx = calloc(sizeof(attr_dlg_t), 1);

	actx->mctx = mctx;
	actx->attrs = attrs;
	actx->n_attrs = n_attrs;
	actx->aw = calloc(sizeof(attr_widget_t), n_attrs);
	actx->caller_data = caller_data;
	actx->modal = 0;
	gdl_append(&mctx->dad_dialogs, actx, link);

	rnd_mbtk_attr_dlg_add(actx, &parent_box->w, NULL, 0);

	rnd_mbtk_initial_wstates(actx);

	return actx;
}

void rnd_mbtk_attr_sub_update_hidlib(void *hid_ctx, rnd_design_t *new_dsg)
{
	attr_dlg_t *actx = hid_ctx;

	actx->mctx->hidlib = new_dsg;
}

