package de.intarsys.tools.event;

public class NotificationSupportProxy implements INotificationSupport {

	private EventDispatcher dispatcher = new EventDispatcher(this);

	private INotificationSupport delegate;

	public void addNotificationListener(EventType type,
			INotificationListener listener) {
		dispatcher.addNotificationListener(type, listener);
		if (delegate != null) {
			delegate.addNotificationListener(type, listener);
		}
	}

	public INotificationSupport getDelegate() {
		return delegate;
	}

	public void removeNotificationListener(EventType type,
			INotificationListener listener) {
		dispatcher.removeNotificationListener(type, listener);
		if (delegate != null) {
			delegate.removeNotificationListener(type, listener);
		}
	}

	public void setDelegate(INotificationSupport pDelegate) {
		if (delegate != null) {
			dispatcher.detach(delegate);
		}
		this.delegate = pDelegate;
		if (delegate != null) {
			dispatcher.attach(delegate);
		}
	}

}
