/**************************************************************************\
 ibtk (Insomnia's Basic ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#include <string.h>

#include "isbutton.h"

ISButton::~ISButton()  {
  Win->RemoveClaim(this);
  }

ISButton::ISButton(char *txt, IWindow *w, int xp, int yp, int xs, int ys)  {
  Init(txt, w, xp, yp, xs, ys);
  }

void ISButton::Rebuild()  {
  Redraw();
  }

void ISButton::Redraw()  {
  if(!hidden) {
    XCopyArea(Win->GetDisplay(), Img[state<?2], Win->GetWindowBuffer(), Win->GetGC(),
	0, 0, xsize, ysize, xpos, ypos);
    Win->Redraw(xpos, ypos, xsize, ysize);        
    }
  else {
    Win->Rebuild(xpos, ypos, xsize, ysize);        
    }
  }

int ISButton::Press(int b, int x, int y)  {
  if(state == 2) return 0;
  state = 1^state;
  Redraw();
  if(state == 1 && downcallback != NULL)  (*downcallback)(parent, this, 1);
  else if(state == 0 && upcallback != NULL)  (*upcallback)(parent, this, 0);
  return 1;
  }

int ISButton::Release(int b, int x, int y)  {
  return 1;
  }
