/*
 * StringIndexConstants
 * 
 * Copyright (c) 2001, 2002, 2003, 2004 Marco Schmidt.
 * All rights reserved.
 */

package net.sourceforge.jiu.apps;

/**
 * Interface of integer index values to be used with {@link Strings}.
 * @author Marco Schmidt
 */
public interface StringIndexConstants
{
	int ERROR_LOADING_IMAGE = 0;
	int FILE_FORMAT_UNKNOWN = 1;
	int LOAD_IMAGE_FILE = 2;
	int SCREEN_RESOLUTION = 3;
	int COULD_NOT_CREATE_HISTOGRAM = 4;
	int NUMBER_OF_USED_COLORS = 5;
	int COUNT_COLORS_USED = 6;
	int CLOSE = 7;
	int HELP = 8;
	int ABOUT = 9;
	int SYSTEM  = 10;
	int SYSTEM_INFORMATION  = 11;
	int COLOR = 12;
	int INVERT = 13;
	int CONVERT_TO_GRAYSCALE  = 14;
	int FILE = 15;
	int OPEN = 16;
	int SAVEAS = 17;
	int EXIT = 18;
	int PROPERTY_JAVA_VERSION = 19;
	int PROPERTY_JAVA_VENDOR = 20;
	int PROPERTY_JAVA_VENDOR_URL = 21;
	int PROPERTY_JAVA_HOME = 22;
	int PROPERTY_JAVA_VM_SPECIFICATION_VERSION = 23;
	int PROPERTY_JAVA_VM_SPECIFICATION_VENDOR = 24;
	int PROPERTY_JAVA_VM_SPECIFICATION_NAME = 25;
	int PROPERTY_JAVA_VM_VERSION = 26;
	int PROPERTY_JAVA_VM_VENDOR = 27;
	int PROPERTY_JAVA_VM_NAME = 28;
	int PROPERTY_JAVA_SPECIFICATION_VERSION = 29;
	int PROPERTY_JAVA_SPECIFICATION_VENDOR = 30;
	int PROPERTY_JAVA_SPECIFICATION_NAME = 31;
	int PROPERTY_JAVA_CLASS_VERSION = 32;
	int PROPERTY_JAVA_CLASS_PATH = 33;
	int PROPERTY_OS_NAME = 34;
	int PROPERTY_OS_ARCH = 35;
	int PROPERTY_OS_VERSION = 36;
	int HOMEPAGE = 37;
	int FEEDBACK = 38;
	int MEDIAN_CUT = 39;
	int ERROR_MESSAGE = 40;
	int NUMBER_OF_COLORS_SMALL_ENOUGH = 41;
	int CPU_ENDIANNESS = 42;
	int CPU_ISALIST = 43;
	int FREE_MEMORY = 44;
	int USED_MEMORY = 45;
	int TOTAL_MEMORY = 46;
	int SAVE_AS = 47;
	int TRANSFORMATIONS = 48;
	int FLIP = 49;
	int MIRROR = 50;
	int MEDIAN_CUT_CONTOUR_REMOVAL = 51;
	int PROMOTE_TO_RGB = 52;
	int REDUCE_TO_BILEVEL_THRESHOLD_MENU_ITEM = 53;
	int REDUCE_TO_BILEVEL_ORDERED_DITHERING = 54;
	int ROTATE_90_LEFT = 55;
	int ROTATE_90_RIGHT = 56;
	int ROTATE_180 = 57;
	int ROTATE_OTHER = 58;
	int SCALE = 59;
	int SCALE_IMAGE = 60;
	int NEW_WIDTH = 61;
	int NEW_HEIGHT = 62;
	int MAINTAIN_ASPECT_RATIO = 63;
	int OK = 64;
	int CANCEL = 65;
	int NUM_COLORS = 66;
	int MEDIAN_CUT_COLOR_QUANTIZATION = 67;
	int OUTPUT_COLOR_TYPE = 68;
	int METHOD_REPR_COLOR_AVERAGE = 69;
	int METHOD_REPR_COLOR_WEIGHTED_AVERAGE = 70;
	int METHOD_REPR_COLOR_MEDIAN = 71;
	int OUTPUT_COLOR_TYPE_PALETTED = 72;
	int OUTPUT_COLOR_TYPE_RGB = 73;
	int METHOD_REPR_COLOR = 74;
	int CONTOUR_REMOVAL = 75;
	int METHOD = 76;
	int FILTERS = 77;
	int SHARPEN = 78;
	int BLUR = 79;
	int EMBOSS = 80;
	int PSYCHEDELIC_DISTILLATION = 81;
	int LITHOGRAPH = 82;
	int MAXIMUM_COLOR_DISTANCE = 83;
	int PORTABLE_BITMAP = 84;
	int PORTABLE_GRAYMAP = 85;
	int PORTABLE_PIXMAP = 86;
	int UNIFORM_PALETTE_COLOR_QUANTIZATION_MENU_ITEM = 87;
	int NUMBER_OF_BITS_RED = 88;
	int NUMBER_OF_BITS_GREEN = 89;
	int NUMBER_OF_BITS_BLUE = 90;
	int ORDERED_DITHERING = 91;
	int DITHERING_NONE = 92;
	int DITHERING_METHOD = 93;
	int UNIFORM_PALETTE_COLOR_QUANTIZATION = 94;
	int SAVE_IMAGE_AS = 95;
	int ERROR_NO_MORE_THAN_8_BITS = 96;
	int TOTAL_NUMBER_OF_BITS_AND_COLORS = 97;
	int EDGE_DETECTION = 98;
	int REDUCE_NUMBER_OF_SHADES_OF_GRAY = 99;
	int REDUCE_NUMBER_OF_SHADES_OF_GRAY_MENU_ITEM = 100;
	int NUMBER_OF_BITS = 101;
	int NUMBER_OF_SHADES_OF_GRAY = 102;
	int SUN_RASTER = 103;
	int ADJUST = 104;
	int CONTRAST_MENU_ITEM = 105;
	int BRIGHTNESS_MENU_ITEM = 106;
	int GAMMA_MENU_ITEM = 107;
	int ADJUST_CONTRAST = 108;
	int ENTER_CONTRAST_VALUE = 109;
	int ADJUST_BRIGHTNESS = 110;
	int ENTER_BRIGHTNESS_VALUE = 111;
	int ADJUST_GAMMA = 112;
	int ENTER_GAMMA_VALUE = 113;
	int CROP_IMAGE = 114;
	int LEFT_COLUMN = 115;
	int TOP_ROW = 116;
	int RIGHT_COLUMN = 117;
	int BOTTOM_ROW = 118;
	int CROP_MENU_ITEM = 119;
	int CONVERT_TO_MINIMUM_COLOR_TYPE_MENU_ITEM = 120;
	int HISTOGRAM = 121;
	int REDUCE_TO_BILEVEL_THRESHOLD = 122;
	int ENTER_THRESHOLD_VALUE = 123;
	int FLOYD_STEINBERG_ERROR_DIFFUSION = 124;
	int STUCKI_ERROR_DIFFUSION = 125;
	int BURKES_ERROR_DIFFUSION = 126;
	int SIERRA_ERROR_DIFFUSION = 127;
	int JARVIS_JUDICE_NINKE_ERROR_DIFFUSION = 128;
	int STEVENSON_ARCE_ERROR_DIFFUSION = 129;
	int OUTPUT_QUALITY_IMPROVEMENT_ALGORITHM = 130;
	int ALGORITHMS_NONE = 131;
	int ERROR_DIFFUSION = 132;
	int COLOR_IMAGE_QUANTIZATION = 133;
	int HORIZONTAL_SOBEL = 134;
	int VERTICAL_SOBEL = 135;
	int HORIZONTAL_PREWITT = 136;
	int VERTICAL_PREWITT = 137;
	int SHEAR_MENU_ITEM = 138;
	int SHEAR_IMAGE = 139;
	int SHEAR_ENTER_ANGLE = 140;
	int HUE_SATURATION_VALUE_MENU_ITEM = 141;
	int ADJUST_HUE_SATURATION_AND_VALUE = 142;
	int SET_HUE = 143;
	int HUE = 144;
	int SATURATION = 145;
	int VALUE = 146;
	int MEAN_FILTER_MENU_ITEM = 147;
	int MEDIAN_FILTER_MENU_ITEM = 148;
	int OIL_FILTER_MENU_ITEM = 149;
	int APPLY_MEAN_FILTER = 150;
	int APPLY_MEDIAN_FILTER = 151;
	int APPLY_OIL_FILTER = 152;
	int WINDOW_WIDTH = 153;
	int WINDOW_HEIGHT = 154;
	int ENTER_WINDOW_SIZE = 155;
	int CONTOUR_REMOVAL_NUM_PASSES = 156;
	int CONTOUR_REMOVAL_TAU = 157;
	int PALETTE_MENU_ITEM = 158;
	int PALETTE_SAVE_AS_MENU_ITEM = 159;
	int MAP_TO_ARBITRARY_PALETTE_MENU_ITEM = 160;
	int SAVE_PALETTE = 161;
	int LOAD_PALETTE = 162;
	int CHOOSE_DITHERING_METHOD = 163;
	int WEBSAFE_PALETTE = 164;
	int PALETTE_FROM_FILE = 165;
	int CHOOSE_PALETTE_TYPE = 166;
	int MAP_TO_ARBITRARY_PALETTE = 167;
	int EQUALIZE_HISTOGRAM_MENU_ITEM = 168;
	int NORMALIZE_HISTOGRAM_MENU_ITEM = 169;
	int OCTREE_COLOR_QUANTIZATION_MENU_ITEM = 170;
	int OCTREE_COLOR_QUANTIZATION = 171;
	int SAVE_COOCCURRENCE_MATRIX = 172;
	int SAVE_COOCCURRENCE_MATRIX_MENU_ITEM = 173;
	int SAVE_COOCCURRENCE_FREQUENCY_MATRIX = 174;
	int SAVE_COOCCURRENCE_FREQUENCY_MATRIX_MENU_ITEM = 175;
	int WINDOWS_BITMAP = 176;
	int PROMOTE = 177;
	int PROMOTE_TO_PALETTED = 178;
	int PROMOTE_TO_GRAY8 = 179;
	int PROMOTE_TO_GRAY16 = 180;
	int PROMOTE_TO_RGB24 = 181;
	int PROMOTE_TO_RGB48 = 182;
	int REDUCE = 183;
	int SAVE_HISTOGRAM_AS_MENU_ITEM = 184;
	int SAVE_HISTOGRAM_AS = 185;
	int EDIT = 186;
	int EDIT_UNDO = 187;
	int EDIT_REDO = 188;
	int TEXTURE_PROPERTIES_MENU_ITEM = 189;
	int CONTRAST = 190;
	int ENERGY = 191;
	int ENTROPY = 192;
	int HOMOGENEITY = 193;
	int TEXTURE_PROPERTIES = 194;
	int CORRELATION = 195;
	int DISSIMILARITY = 196;
	int MINIMUM_FILTER_MENU_ITEM = 197;
	int MAXIMUM_FILTER_MENU_ITEM = 198;
	int APPLY_MINIMUM_FILTER = 199;
	int APPLY_MAXIMUM_FILTER = 200;
	int VIEW = 201;
	int VIEW_ZOOMIN = 202;
	int VIEW_ZOOMOUT = 203;
	int VIEW_SETORIGINALSIZE = 204;
	int VIEW_INTERPOLATIONTYPE = 205;
	int VIEW_INTERPOLATIONTYPE_NEARESTNEIGHBOR = 206;
	int VIEW_INTERPOLATIONTYPE_BILINEAR = 207;
	int VIEW_INTERPOLATIONTYPE_BICUBIC = 208;
	int PALM = 209;
	int PALETTE_PALM_256_COLORS = 210;
	int PALETTE_PALM_16_COLORS = 211;
	int PALETTE_PALM_16_GRAY = 212;
	int PALETTE_PALM_4_GRAY = 213;
	int DO_YOU_REALLY_WANT_TO_QUIT_WITHOUT_SAVING = 214;
	int QUIT_PROGRAM = 215;
	int YES = 216;
	int NO = 217;
	int DO_YOU_REALLY_WANT_TO_CLOSE_WITHOUT_SAVING = 218;
	int CLOSE_FILE = 219;
	int BITS_PER_PIXEL = 220;
	int BILEVEL = 221;
	int GRAYSCALE = 222;
	int RGB_TRUECOLOR = 223;
	int IMAGE_TYPE_UNKNOWN = 224;
	int IMAGE_TYPE = 225;
	int PALETTED = 226;
	int PIXELS = 227;
	int PORTABLE_NETWORK_GRAPHICS = 228;
	int MEMORY = 229;
	int DISK_SPACE = 230;
	int GIF = 231;
	int IMAGE_1 = 232; 
}
