/*
 * $Id: waterfall.h,v 1.4 2003/04/29 03:09:45 nlevitt Exp $
 *
 * Copyright (c) 2003 Noah Levitt
 * 
 * This program is free software; the author gives unlimited permission to
 * copy and/or distribute it, with or without modifications, as long as
 * this notice is preserved.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY, to the extent permitted by law; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef WATERFALL_H
#define WATERFALL_H

#include <gtk/gtk.h>
#include <X11/Xft/Xft.h>

G_BEGIN_DECLS

#define WATERFALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                        waterfall_get_type (), Waterfall))

#define WATERFALL_CLASS(clazz) (G_TYPE_CHECK_CLASS_CAST ((clazz), \
                                                         waterfall_get_type (),\
                                                         WaterfallClass))

#define IS_WATERFALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                           waterfall_get_type ()))


typedef struct _Waterfall Waterfall;
typedef struct _WaterfallClass WaterfallClass;

enum { UNICODE_MAX = 0x10ffff };
enum { WATERFALL_PAGE_SIZE = 128 };
enum { WATERFALL_LAST_PAGE = UNICODE_MAX / WATERFALL_PAGE_SIZE };

struct _Waterfall
{
  GtkDrawingArea parent;

  GdkPixmap *pixmap;
  XftDraw *xftdraw;

  gchar *font_family;
  gchar *font_style;
  XftFont *font;

  gdouble min_size;
  gdouble max_size;
  gdouble increment;

  gboolean hint;
  gboolean antialias;
  gboolean autohint;
  gint rgba; /* subpixel geometry */
  gdouble aspect;

  gint page;
};


struct _WaterfallClass
{
  GtkDrawingAreaClass parent_class;
};


GType waterfall_get_type ();
GtkWidget *waterfall_new ();

const gchar * waterfall_get_font_family (Waterfall *waterfall);
void waterfall_set_font_family (Waterfall *waterfall, 
                                const gchar *new_family);
void waterfall_set_font_style (Waterfall *waterfall,
                               const gchar *new_style);
const gchar * waterfall_get_font_style (Waterfall *waterfall);
void waterfall_set_antialias (Waterfall *waterfall, 
                              gboolean antialias);
void waterfall_set_hint (Waterfall *waterfall, 
                         gboolean hint);
gboolean waterfall_get_antialias (Waterfall *waterfall);
gboolean waterfall_get_hint (Waterfall *waterfall);
gdouble waterfall_get_min_size (Waterfall *waterfall);
gdouble waterfall_get_max_size (Waterfall *waterfall);
gdouble waterfall_get_increment (Waterfall *waterfall);
void waterfall_set_min_size (Waterfall *waterfall, 
                             gdouble min_size);
void waterfall_set_max_size (Waterfall *waterfall, 
                             gdouble max_size);
void waterfall_set_increment (Waterfall *waterfall,
                              gdouble increment);
gint waterfall_get_page (Waterfall *waterfall);
void waterfall_set_page (Waterfall *waterfall,
                         gint page);
gboolean waterfall_is_page_empty (Waterfall *waterfall,
                                  gint page);
gboolean waterfall_get_autohint (Waterfall *waterfall);
void waterfall_set_autohint (Waterfall *waterfall, 
                             gboolean autohint);
gint waterfall_get_rgba (Waterfall *waterfall);
void waterfall_set_rgba (Waterfall *waterfall, 
                         gboolean rgba);
gdouble waterfall_get_aspect (Waterfall *waterfall);
void waterfall_set_aspect (Waterfall *waterfall,
                           gdouble aspect);


G_END_DECLS

#endif /* #ifndef WATERFALL_H */
