//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsupport_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/support/armsupport/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/CheckNameAvailability.json
func ExampleTicketsNoSubscriptionClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTicketsNoSubscriptionClient().CheckNameAvailability(ctx, armsupport.CheckNameAvailabilityInput{
		Name: to.Ptr("sampleName"),
		Type: to.Ptr(armsupport.TypeMicrosoftSupportSupportTickets),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityOutput = armsupport.CheckNameAvailabilityOutput{
	// 	Message: to.Ptr("Name not available"),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr("Name is already in use"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/ListSupportTicketsCreatedOnOrAfterAndInOpenState.json
func ExampleTicketsNoSubscriptionClient_NewListPager_listSupportTicketsCreatedOnOrAfterACertainDateAndInOpenStateForASubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTicketsNoSubscriptionClient().NewListPager(&armsupport.TicketsNoSubscriptionClientListOptions{Top: nil,
		Filter: to.Ptr("createdDate ge 2020-03-10T22:08:51Z and status eq 'Open'"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TicketsListResult = armsupport.TicketsListResult{
		// 	Value: []*armsupport.TicketDetails{
		// 		{
		// 			Name: to.Ptr("testticket"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("my description"),
		// 				AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("usa"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-11T21:36:18.000Z"); return t}()),
		// 				FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-12T21:36:23.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("Connectivity / Cannot connect to virtual machine by using RDP or SSH"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_service_guid/problemClassifications/problemClassification_guid"),
		// 				ProblemScopingQuestions: to.Ptr("{\"articleId\":\"076846c1-4c0b-4b21-91c6-1a30246b3867\",\"scopingDetails\":[{\"question\":\"When did the problem begin?\",\"controlId\":\"problem_start_time\",\"orderId\":1,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"2023-08-31T18:55:00.739Z\",\"value\":\"2023-08-31T18:55:00.739Z\",\"type\":\"datetime\"}},{\"question\":\"API Type of the Cosmos DB account\",\"controlId\":\"api_type\",\"orderId\":2,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"Table\",\"value\":\"tables\",\"type\":\"string\"}},{\"question\":\"Table name\",\"controlId\":\"collection_name_table\",\"orderId\":11,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"Select Table Name\",\"value\":\"dont_know_answer\",\"type\":\"string\"}},{\"question\":\"Provide additional details about the issue you're facing\",\"controlId\":\"problem_description\",\"orderId\":12,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"test ticket, please ignore and close\",\"value\":\"test ticket, please ignore and close\",\"type\":\"string\"}}]}"),
		// 				Require24X7Response: to.Ptr(false),
		// 				SecondaryConsent: []*armsupport.SecondaryConsent{
		// 					{
		// 						Type: to.Ptr("VirtualMachine"),
		// 						UserConsent: to.Ptr(armsupport.UserConsentYes),
		// 				}},
		// 				ServiceDisplayName: to.Ptr("Virtual Machine running Linux"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_service_guid"),
		// 				ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-12T17:36:18.000Z"); return t}()),
		// 					SLAMinutes: to.Ptr[int32](240),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-11T21:36:18.000Z"); return t}()),
		// 				},
		// 				Severity: to.Ptr(armsupport.SeverityLevelModerate),
		// 				Status: to.Ptr("Open"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("119120321001170"),
		// 				Title: to.Ptr("my title"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testticket2"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket2"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("This is a test - please ignore"),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("USA"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-11T21:36:18.000Z"); return t}()),
		// 				FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-12T21:36:18.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("Add or Edit VAT, TAX ID, or PO Number"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid/problemClassifications/problemClassification_guid"),
		// 				Require24X7Response: to.Ptr(false),
		// 				ServiceDisplayName: to.Ptr("Subscription management"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid"),
		// 				ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-12T17:36:18.000Z"); return t}()),
		// 					SLAMinutes: to.Ptr[int32](240),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-11T21:36:18.000Z"); return t}()),
		// 				},
		// 				Severity: to.Ptr(armsupport.SeverityLevelMinimal),
		// 				Status: to.Ptr("Open"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("118032014183771"),
		// 				Title: to.Ptr("Test - please ignore"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/ListSupportTicketsCreatedOnOrAfterAndInUpdatingState.json
func ExampleTicketsNoSubscriptionClient_NewListPager_listSupportTicketsCreatedOnOrAfterACertainDateAndInUpdatingStateForASubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTicketsNoSubscriptionClient().NewListPager(&armsupport.TicketsNoSubscriptionClientListOptions{Top: nil,
		Filter: to.Ptr("createdDate ge 2020-03-10T22:08:51Z and status eq 'Updating'"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TicketsListResult = armsupport.TicketsListResult{
		// 	Value: []*armsupport.TicketDetails{
		// 		{
		// 			Name: to.Ptr("testticket"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("my description"),
		// 				AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("usa"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-11T21:36:18.000Z"); return t}()),
		// 				FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-12T21:36:23.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("Connectivity / Cannot connect to virtual machine by using RDP or SSH"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_service_guid/problemClassifications/problemClassification_guid"),
		// 				ProblemScopingQuestions: to.Ptr("{\"articleId\":\"076846c1-4c0b-4b21-91c6-1a30246b3867\",\"scopingDetails\":[{\"question\":\"When did the problem begin?\",\"controlId\":\"problem_start_time\",\"orderId\":1,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"2023-08-31T18:55:00.739Z\",\"value\":\"2023-08-31T18:55:00.739Z\",\"type\":\"datetime\"}},{\"question\":\"API Type of the Cosmos DB account\",\"controlId\":\"api_type\",\"orderId\":2,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"Table\",\"value\":\"tables\",\"type\":\"string\"}},{\"question\":\"Table name\",\"controlId\":\"collection_name_table\",\"orderId\":11,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"Select Table Name\",\"value\":\"dont_know_answer\",\"type\":\"string\"}},{\"question\":\"Provide additional details about the issue you're facing\",\"controlId\":\"problem_description\",\"orderId\":12,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"test ticket, please ignore and close\",\"value\":\"test ticket, please ignore and close\",\"type\":\"string\"}}]}"),
		// 				Require24X7Response: to.Ptr(false),
		// 				SecondaryConsent: []*armsupport.SecondaryConsent{
		// 					{
		// 						Type: to.Ptr("VirtualMachine"),
		// 						UserConsent: to.Ptr(armsupport.UserConsentYes),
		// 				}},
		// 				ServiceDisplayName: to.Ptr("Virtual Machine running Linux"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_service_guid"),
		// 				ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-12T17:36:18.000Z"); return t}()),
		// 					SLAMinutes: to.Ptr[int32](240),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-11T21:36:18.000Z"); return t}()),
		// 				},
		// 				Severity: to.Ptr(armsupport.SeverityLevelModerate),
		// 				Status: to.Ptr("Updating"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("119120321001170"),
		// 				Title: to.Ptr("my title"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testticket2"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket2"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("This is a test - please ignore"),
		// 				AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("USA"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-11T21:36:18.000Z"); return t}()),
		// 				FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-12T21:36:18.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("Add or Edit VAT, TAX ID, or PO Number"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid/problemClassifications/problemClassification_guid"),
		// 				ProblemScopingQuestions: to.Ptr("{\"articleId\":\"076846c1-4c0b-4b21-91c6-1a30246b3867\",\"scopingDetails\":[{\"question\":\"When did the problem begin?\",\"controlId\":\"problem_start_time\",\"orderId\":1,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"2023-08-31T18:55:00.739Z\",\"value\":\"2023-08-31T18:55:00.739Z\",\"type\":\"datetime\"}},{\"question\":\"API Type of the Cosmos DB account\",\"controlId\":\"api_type\",\"orderId\":2,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"Table\",\"value\":\"tables\",\"type\":\"string\"}},{\"question\":\"Table name\",\"controlId\":\"collection_name_table\",\"orderId\":11,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"Select Table Name\",\"value\":\"dont_know_answer\",\"type\":\"string\"}},{\"question\":\"Provide additional details about the issue you're facing\",\"controlId\":\"problem_description\",\"orderId\":12,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"test ticket, please ignore and close\",\"value\":\"test ticket, please ignore and close\",\"type\":\"string\"}}]}"),
		// 				Require24X7Response: to.Ptr(false),
		// 				SecondaryConsent: []*armsupport.SecondaryConsent{
		// 					{
		// 						Type: to.Ptr("VirtualMachine"),
		// 						UserConsent: to.Ptr(armsupport.UserConsentYes),
		// 				}},
		// 				ServiceDisplayName: to.Ptr("Subscription management"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid"),
		// 				ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-12T17:36:18.000Z"); return t}()),
		// 					SLAMinutes: to.Ptr[int32](240),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-11T21:36:18.000Z"); return t}()),
		// 				},
		// 				Severity: to.Ptr(armsupport.SeverityLevelMinimal),
		// 				Status: to.Ptr("Updating"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("118032014183771"),
		// 				Title: to.Ptr("Test - please ignore"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/ListSupportTickets.json
func ExampleTicketsNoSubscriptionClient_NewListPager_listSupportTicketsForASubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTicketsNoSubscriptionClient().NewListPager(&armsupport.TicketsNoSubscriptionClientListOptions{Top: nil,
		Filter: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TicketsListResult = armsupport.TicketsListResult{
		// 	Value: []*armsupport.TicketDetails{
		// 		{
		// 			Name: to.Ptr("testticket"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("my description"),
		// 				AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("usa"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
		// 				FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("Connectivity / Cannot connect to virtual machine by using RDP or SSH"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_service_guid/problemClassifications/problemClassification_guid"),
		// 				ProblemScopingQuestions: to.Ptr("{\"articleId\":\"076846c1-4c0b-4b21-91c6-1a30246b3867\",\"scopingDetails\":[{\"question\":\"When did the problem begin?\",\"controlId\":\"problem_start_time\",\"orderId\":1,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"2023-08-31T18:55:00.739Z\",\"value\":\"2023-08-31T18:55:00.739Z\",\"type\":\"datetime\"}},{\"question\":\"API Type of the Cosmos DB account\",\"controlId\":\"api_type\",\"orderId\":2,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"Table\",\"value\":\"tables\",\"type\":\"string\"}},{\"question\":\"Table name\",\"controlId\":\"collection_name_table\",\"orderId\":11,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"Select Table Name\",\"value\":\"dont_know_answer\",\"type\":\"string\"}},{\"question\":\"Provide additional details about the issue you're facing\",\"controlId\":\"problem_description\",\"orderId\":12,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"test ticket, please ignore and close\",\"value\":\"test ticket, please ignore and close\",\"type\":\"string\"}}]}"),
		// 				Require24X7Response: to.Ptr(false),
		// 				SecondaryConsent: []*armsupport.SecondaryConsent{
		// 					{
		// 						Type: to.Ptr("VirtualMachine"),
		// 						UserConsent: to.Ptr(armsupport.UserConsentYes),
		// 				}},
		// 				ServiceDisplayName: to.Ptr("Virtual Machine running Linux"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_service_guid"),
		// 				ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
		// 					SLAMinutes: to.Ptr[int32](240),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
		// 				},
		// 				Severity: to.Ptr(armsupport.SeverityLevelModerate),
		// 				Status: to.Ptr("Open"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("119120321001170"),
		// 				Title: to.Ptr("my title"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testticket2"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket2"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("This is a test - please ignore"),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("USA"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
		// 				FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("Add or Edit VAT, TAX ID, or PO Number"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid/problemClassifications/problemClassification_guid"),
		// 				Require24X7Response: to.Ptr(false),
		// 				ServiceDisplayName: to.Ptr("Subscription management"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid"),
		// 				ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
		// 					SLAMinutes: to.Ptr[int32](240),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
		// 				},
		// 				Severity: to.Ptr(armsupport.SeverityLevelMinimal),
		// 				Status: to.Ptr("Open"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("118032014183771"),
		// 				Title: to.Ptr("Test - please ignore"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/ListSupportTicketsInOpenState.json
func ExampleTicketsNoSubscriptionClient_NewListPager_listSupportTicketsInOpenStateForASubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTicketsNoSubscriptionClient().NewListPager(&armsupport.TicketsNoSubscriptionClientListOptions{Top: nil,
		Filter: to.Ptr("status eq 'Open'"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TicketsListResult = armsupport.TicketsListResult{
		// 	Value: []*armsupport.TicketDetails{
		// 		{
		// 			Name: to.Ptr("testticket"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("my description"),
		// 				AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("usa"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
		// 				FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("Connectivity / Cannot connect to virtual machine by using RDP or SSH"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_service_guid/problemClassifications/problemClassification_guid"),
		// 				ProblemScopingQuestions: to.Ptr("{\"articleId\":\"076846c1-4c0b-4b21-91c6-1a30246b3867\",\"scopingDetails\":[{\"question\":\"When did the problem begin?\",\"controlId\":\"problem_start_time\",\"orderId\":1,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"2023-08-31T18:55:00.739Z\",\"value\":\"2023-08-31T18:55:00.739Z\",\"type\":\"datetime\"}},{\"question\":\"API Type of the Cosmos DB account\",\"controlId\":\"api_type\",\"orderId\":2,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"Table\",\"value\":\"tables\",\"type\":\"string\"}},{\"question\":\"Table name\",\"controlId\":\"collection_name_table\",\"orderId\":11,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"Select Table Name\",\"value\":\"dont_know_answer\",\"type\":\"string\"}},{\"question\":\"Provide additional details about the issue you're facing\",\"controlId\":\"problem_description\",\"orderId\":12,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"test ticket, please ignore and close\",\"value\":\"test ticket, please ignore and close\",\"type\":\"string\"}}]}"),
		// 				Require24X7Response: to.Ptr(false),
		// 				SecondaryConsent: []*armsupport.SecondaryConsent{
		// 					{
		// 						Type: to.Ptr("VirtualMachine"),
		// 						UserConsent: to.Ptr(armsupport.UserConsentYes),
		// 				}},
		// 				ServiceDisplayName: to.Ptr("Virtual Machine running Linux"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_service_guid"),
		// 				ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
		// 					SLAMinutes: to.Ptr[int32](240),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
		// 				},
		// 				Severity: to.Ptr(armsupport.SeverityLevelModerate),
		// 				Status: to.Ptr("Open"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("119120321001170"),
		// 				Title: to.Ptr("my title"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testticket2"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket2"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("This is a test - please ignore"),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("USA"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
		// 				FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("Add or Edit VAT, TAX ID, or PO Number"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid/problemClassifications/problemClassification_guid"),
		// 				Require24X7Response: to.Ptr(false),
		// 				ServiceDisplayName: to.Ptr("Subscription management"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid"),
		// 				ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
		// 					SLAMinutes: to.Ptr[int32](240),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
		// 				},
		// 				Severity: to.Ptr(armsupport.SeverityLevelMinimal),
		// 				Status: to.Ptr("Open"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("118032014183771"),
		// 				Title: to.Ptr("Test - please ignore"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/ListSupportTicketsInUpdatingState.json
func ExampleTicketsNoSubscriptionClient_NewListPager_listSupportTicketsInUpdatingStateForASubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTicketsNoSubscriptionClient().NewListPager(&armsupport.TicketsNoSubscriptionClientListOptions{Top: nil,
		Filter: to.Ptr("status eq 'Updating'"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TicketsListResult = armsupport.TicketsListResult{
		// 	Value: []*armsupport.TicketDetails{
		// 		{
		// 			Name: to.Ptr("testticket"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("my description"),
		// 				AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("usa"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
		// 				FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("Connectivity / Cannot connect to virtual machine by using RDP or SSH"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_service_guid/problemClassifications/problemClassification_guid"),
		// 				ProblemScopingQuestions: to.Ptr("{\"articleId\":\"076846c1-4c0b-4b21-91c6-1a30246b3867\",\"scopingDetails\":[{\"question\":\"When did the problem begin?\",\"controlId\":\"problem_start_time\",\"orderId\":1,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"2023-08-31T18:55:00.739Z\",\"value\":\"2023-08-31T18:55:00.739Z\",\"type\":\"datetime\"}},{\"question\":\"API Type of the Cosmos DB account\",\"controlId\":\"api_type\",\"orderId\":2,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"Table\",\"value\":\"tables\",\"type\":\"string\"}},{\"question\":\"Table name\",\"controlId\":\"collection_name_table\",\"orderId\":11,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"Select Table Name\",\"value\":\"dont_know_answer\",\"type\":\"string\"}},{\"question\":\"Provide additional details about the issue you're facing\",\"controlId\":\"problem_description\",\"orderId\":12,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"test ticket, please ignore and close\",\"value\":\"test ticket, please ignore and close\",\"type\":\"string\"}}]}"),
		// 				Require24X7Response: to.Ptr(false),
		// 				SecondaryConsent: []*armsupport.SecondaryConsent{
		// 					{
		// 						Type: to.Ptr("VirtualMachine"),
		// 						UserConsent: to.Ptr(armsupport.UserConsentYes),
		// 				}},
		// 				ServiceDisplayName: to.Ptr("Virtual Machine running Linux"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_service_guid"),
		// 				ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
		// 					SLAMinutes: to.Ptr[int32](240),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
		// 				},
		// 				Severity: to.Ptr(armsupport.SeverityLevelModerate),
		// 				Status: to.Ptr("Updating"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("119120321001170"),
		// 				Title: to.Ptr("my title"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testticket2"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket2"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("This is a test - please ignore"),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("USA"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
		// 				FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("Add or Edit VAT, TAX ID, or PO Number"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid/problemClassifications/problemClassification_guid"),
		// 				Require24X7Response: to.Ptr(false),
		// 				ServiceDisplayName: to.Ptr("Subscription management"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid"),
		// 				ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
		// 					ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
		// 					SLAMinutes: to.Ptr[int32](240),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
		// 				},
		// 				Severity: to.Ptr(armsupport.SeverityLevelMinimal),
		// 				Status: to.Ptr("Updating"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("118032014183771"),
		// 				Title: to.Ptr("Test - please ignore"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/ListSupportTicketsProblemClassificationIdEquals.json
func ExampleTicketsNoSubscriptionClient_NewListPager_listSupportTicketsWithACertainProblemClassificationIdForASubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTicketsNoSubscriptionClient().NewListPager(&armsupport.TicketsNoSubscriptionClientListOptions{Top: nil,
		Filter: to.Ptr("ProblemClassificationId eq 'compute_vm_problemClassification_guid'"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TicketsListResult = armsupport.TicketsListResult{
		// 	Value: []*armsupport.TicketDetails{
		// 		{
		// 			Name: to.Ptr("testTicket1"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testTicket1"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("my description"),
		// 				AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("usa"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-04T21:52:10.000Z"); return t}()),
		// 				EnrollmentID: to.Ptr(""),
		// 				FileWorkspaceName: to.Ptr("testTicket1"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-12T23:05:19.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("Compute-VM (cores-vCPUs) subscription limit increases"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/service_guid/problemClassifications/compute_vm_problemClassification_guid"),
		// 				Require24X7Response: to.Ptr(false),
		// 				ServiceDisplayName: to.Ptr("service_displayName"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/service_guid"),
		// 				Severity: to.Ptr(armsupport.SeverityLevelMinimal),
		// 				Status: to.Ptr("Open"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("2205060010000072"),
		// 				Title: to.Ptr("my title"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testTicket2"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testTicket2"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("This is a test - please ignore"),
		// 				AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("USA"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-04T21:38:42.000Z"); return t}()),
		// 				FileWorkspaceName: to.Ptr("testTicket2"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-04T21:39:14.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("Compute-VM (cores-vCPUs) subscription limit increases"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/service_guid/problemClassifications/compute_vm_problemClassification_guid"),
		// 				Require24X7Response: to.Ptr(false),
		// 				ServiceDisplayName: to.Ptr("service_displayName"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/service_guid"),
		// 				Severity: to.Ptr(armsupport.SeverityLevelMinimal),
		// 				Status: to.Ptr("Open"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("2205040010000077"),
		// 				Title: to.Ptr("Test - please ignore"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/ListSupportTicketsServiceIdEquals.json
func ExampleTicketsNoSubscriptionClient_NewListPager_listSupportTicketsWithACertainServiceIdForASubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTicketsNoSubscriptionClient().NewListPager(&armsupport.TicketsNoSubscriptionClientListOptions{Top: nil,
		Filter: to.Ptr("ServiceId eq 'vm_windows_service_guid'"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TicketsListResult = armsupport.TicketsListResult{
		// 	Value: []*armsupport.TicketDetails{
		// 		{
		// 			Name: to.Ptr("testticket1"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("my description"),
		// 				AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("usa"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-04T21:52:10.000Z"); return t}()),
		// 				EnrollmentID: to.Ptr(""),
		// 				FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-12T23:05:19.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("problemClassification_displayName"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/vm_windows_service_guid/problemClassifications/problemClassification_guid"),
		// 				ProblemScopingQuestions: to.Ptr("{\"articleId\":\"076846c1-4c0b-4b21-91c6-1a30246b3867\",\"scopingDetails\":[{\"question\":\"When did the problem begin?\",\"controlId\":\"problem_start_time\",\"orderId\":1,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"2023-08-31T18:55:00.739Z\",\"value\":\"2023-08-31T18:55:00.739Z\",\"type\":\"datetime\"}},{\"question\":\"API Type of the Cosmos DB account\",\"controlId\":\"api_type\",\"orderId\":2,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"Table\",\"value\":\"tables\",\"type\":\"string\"}},{\"question\":\"Table name\",\"controlId\":\"collection_name_table\",\"orderId\":11,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"Select Table Name\",\"value\":\"dont_know_answer\",\"type\":\"string\"}},{\"question\":\"Provide additional details about the issue you're facing\",\"controlId\":\"problem_description\",\"orderId\":12,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"test ticket, please ignore and close\",\"value\":\"test ticket, please ignore and close\",\"type\":\"string\"}}]}"),
		// 				Require24X7Response: to.Ptr(false),
		// 				SecondaryConsent: []*armsupport.SecondaryConsent{
		// 					{
		// 						Type: to.Ptr("VirtualMachine"),
		// 						UserConsent: to.Ptr(armsupport.UserConsentYes),
		// 				}},
		// 				ServiceDisplayName: to.Ptr("Virtual Machine running Windows"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/vm_windows_service_guid"),
		// 				Severity: to.Ptr(armsupport.SeverityLevelMinimal),
		// 				Status: to.Ptr("Open"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("2205040010000082"),
		// 				Title: to.Ptr("my title"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testticket2"),
		// 			Type: to.Ptr("Microsoft.Support/supportTickets"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets"),
		// 			Properties: &armsupport.TicketDetailsProperties{
		// 				Description: to.Ptr("This is a test - please ignore"),
		// 				AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
		// 				ContactDetails: &armsupport.ContactProfile{
		// 					Country: to.Ptr("USA"),
		// 					FirstName: to.Ptr("abc"),
		// 					LastName: to.Ptr("xyz"),
		// 					PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
		// 					PreferredSupportLanguage: to.Ptr("en-US"),
		// 					PreferredTimeZone: to.Ptr("Pacific Standard Time"),
		// 					PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-04T21:38:42.000Z"); return t}()),
		// 				FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
		// 				ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-04T21:39:14.000Z"); return t}()),
		// 				ProblemClassificationDisplayName: to.Ptr("problemClassification_displayName"),
		// 				ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/vm_windows_service_guid/problemClassifications/problemClassification_guid"),
		// 				ProblemScopingQuestions: to.Ptr("{\"articleId\":\"076846c1-4c0b-4b21-91c6-1a30246b3867\",\"scopingDetails\":[{\"question\":\"When did the problem begin?\",\"controlId\":\"problem_start_time\",\"orderId\":1,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"2023-08-31T18:55:00.739Z\",\"value\":\"2023-08-31T18:55:00.739Z\",\"type\":\"datetime\"}},{\"question\":\"API Type of the Cosmos DB account\",\"controlId\":\"api_type\",\"orderId\":2,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"Table\",\"value\":\"tables\",\"type\":\"string\"}},{\"question\":\"Table name\",\"controlId\":\"collection_name_table\",\"orderId\":11,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"Select Table Name\",\"value\":\"dont_know_answer\",\"type\":\"string\"}},{\"question\":\"Provide additional details about the issue you're facing\",\"controlId\":\"problem_description\",\"orderId\":12,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"test ticket, please ignore and close\",\"value\":\"test ticket, please ignore and close\",\"type\":\"string\"}}]}"),
		// 				Require24X7Response: to.Ptr(false),
		// 				SecondaryConsent: []*armsupport.SecondaryConsent{
		// 					{
		// 						Type: to.Ptr("VirtualMachine"),
		// 						UserConsent: to.Ptr(armsupport.UserConsentYes),
		// 				}},
		// 				ServiceDisplayName: to.Ptr("Virtual Machine running Windows"),
		// 				ServiceID: to.Ptr("/providers/Microsoft.Support/services/vm_windows_service_guid"),
		// 				Severity: to.Ptr(armsupport.SeverityLevelMinimal),
		// 				Status: to.Ptr("Open"),
		// 				SupportEngineer: &armsupport.Engineer{
		// 					EmailAddress: to.Ptr("xyz@contoso.com"),
		// 				},
		// 				SupportPlanDisplayName: to.Ptr("Premier"),
		// 				SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
		// 				SupportPlanType: to.Ptr("Premier"),
		// 				SupportTicketID: to.Ptr("2205040010000080"),
		// 				Title: to.Ptr("Test - please ignore"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/GetSupportTicketDetails.json
func ExampleTicketsNoSubscriptionClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTicketsNoSubscriptionClient().Get(ctx, "testticket", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TicketDetails = armsupport.TicketDetails{
	// 	Name: to.Ptr("testticket"),
	// 	Type: to.Ptr("Microsoft.Support/supportTickets"),
	// 	ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
	// 	Properties: &armsupport.TicketDetailsProperties{
	// 		Description: to.Ptr("This is a test - please ignore"),
	// 		AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
	// 		ContactDetails: &armsupport.ContactProfile{
	// 			Country: to.Ptr("USA"),
	// 			FirstName: to.Ptr("abc"),
	// 			LastName: to.Ptr("xyz"),
	// 			PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
	// 			PreferredSupportLanguage: to.Ptr("en-US"),
	// 			PreferredTimeZone: to.Ptr("Pacific Standard Time"),
	// 			PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
	// 		},
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 		FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
	// 		ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
	// 		ProblemClassificationDisplayName: to.Ptr("Add or Edit VAT, TAX ID, or PO Number"),
	// 		ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid/problemClassifications/problemClassification_guid"),
	// 		Require24X7Response: to.Ptr(false),
	// 		ServiceDisplayName: to.Ptr("Subscription management"),
	// 		ServiceID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid"),
	// 		ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
	// 			ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
	// 			SLAMinutes: to.Ptr[int32](240),
	// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 		},
	// 		Severity: to.Ptr(armsupport.SeverityLevelMinimal),
	// 		Status: to.Ptr("Open"),
	// 		SupportEngineer: &armsupport.Engineer{
	// 			EmailAddress: to.Ptr("xyz@contoso.com"),
	// 		},
	// 		SupportPlanDisplayName: to.Ptr("Premier"),
	// 		SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
	// 		SupportPlanType: to.Ptr("Premier"),
	// 		SupportTicketID: to.Ptr("118032014183770"),
	// 		Title: to.Ptr("Test - please ignore"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/UpdateAdvancedDiagnosticConsentOfSupportTicket.json
func ExampleTicketsNoSubscriptionClient_Update_updateAdvancedDiagnosticConsentOfASupportTicket() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTicketsNoSubscriptionClient().Update(ctx, "testticket", armsupport.UpdateSupportTicket{
		AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TicketDetails = armsupport.TicketDetails{
	// 	Name: to.Ptr("testticket"),
	// 	Type: to.Ptr("Microsoft.Support/supportTickets"),
	// 	ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
	// 	Properties: &armsupport.TicketDetailsProperties{
	// 		Description: to.Ptr("This is a test - please ignore"),
	// 		AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
	// 		ContactDetails: &armsupport.ContactProfile{
	// 			AdditionalEmailAddresses: []*string{
	// 				to.Ptr("tname@contoso.com"),
	// 				to.Ptr("teamtest@contoso.com")},
	// 				Country: to.Ptr("USA"),
	// 				FirstName: to.Ptr("abc"),
	// 				LastName: to.Ptr("xyz"),
	// 				PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
	// 				PreferredSupportLanguage: to.Ptr("en-US"),
	// 				PreferredTimeZone: to.Ptr("Pacific Standard Time"),
	// 				PrimaryEmailAddress: to.Ptr("test.name@contoso.com"),
	// 			},
	// 			CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 			FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
	// 			ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
	// 			ProblemClassificationDisplayName: to.Ptr("Add or Edit VAT, TAX ID, or PO Number"),
	// 			ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid/problemClassifications/problemClassification_guid"),
	// 			Require24X7Response: to.Ptr(false),
	// 			ServiceDisplayName: to.Ptr("Subscription management"),
	// 			ServiceID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid"),
	// 			ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
	// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
	// 				SLAMinutes: to.Ptr[int32](240),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 			},
	// 			Severity: to.Ptr(armsupport.SeverityLevelCritical),
	// 			Status: to.Ptr("Open"),
	// 			SupportEngineer: &armsupport.Engineer{
	// 				EmailAddress: to.Ptr("xyz@contoso.com"),
	// 			},
	// 			SupportPlanDisplayName: to.Ptr("Premier"),
	// 			SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
	// 			SupportPlanType: to.Ptr("Premier"),
	// 			SupportTicketID: to.Ptr("118032014183770"),
	// 			Title: to.Ptr("Test - please ignore"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/UpdateContactDetailsOfSupportTicket.json
func ExampleTicketsNoSubscriptionClient_Update_updateContactDetailsOfASupportTicket() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTicketsNoSubscriptionClient().Update(ctx, "testticket", armsupport.UpdateSupportTicket{
		ContactDetails: &armsupport.UpdateContactProfile{
			AdditionalEmailAddresses: []*string{
				to.Ptr("tname@contoso.com"),
				to.Ptr("teamtest@contoso.com")},
			Country:                  to.Ptr("USA"),
			FirstName:                to.Ptr("first name"),
			LastName:                 to.Ptr("last name"),
			PhoneNumber:              to.Ptr("123-456-7890"),
			PreferredContactMethod:   to.Ptr(armsupport.PreferredContactMethodEmail),
			PreferredSupportLanguage: to.Ptr("en-US"),
			PreferredTimeZone:        to.Ptr("Pacific Standard Time"),
			PrimaryEmailAddress:      to.Ptr("test.name@contoso.com"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TicketDetails = armsupport.TicketDetails{
	// 	Name: to.Ptr("testticket"),
	// 	Type: to.Ptr("Microsoft.Support/supportTickets"),
	// 	ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
	// 	Properties: &armsupport.TicketDetailsProperties{
	// 		Description: to.Ptr("This is a test - please ignore"),
	// 		AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
	// 		ContactDetails: &armsupport.ContactProfile{
	// 			AdditionalEmailAddresses: []*string{
	// 				to.Ptr("tname@contoso.com"),
	// 				to.Ptr("teamtest@contoso.com")},
	// 				Country: to.Ptr("USA"),
	// 				FirstName: to.Ptr("first name"),
	// 				LastName: to.Ptr("last name"),
	// 				PhoneNumber: to.Ptr("123-456-7890"),
	// 				PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
	// 				PreferredSupportLanguage: to.Ptr("en-US"),
	// 				PreferredTimeZone: to.Ptr("Pacific Standard Time"),
	// 				PrimaryEmailAddress: to.Ptr("test.name@contoso.com"),
	// 			},
	// 			CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 			FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
	// 			ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
	// 			ProblemClassificationDisplayName: to.Ptr("Add or Edit VAT, TAX ID, or PO Number"),
	// 			ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid/problemClassifications/problemClassification_guid"),
	// 			Require24X7Response: to.Ptr(false),
	// 			ServiceDisplayName: to.Ptr("Subscription management"),
	// 			ServiceID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid"),
	// 			ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
	// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
	// 				SLAMinutes: to.Ptr[int32](240),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 			},
	// 			Severity: to.Ptr(armsupport.SeverityLevelCritical),
	// 			Status: to.Ptr("Open"),
	// 			SupportEngineer: &armsupport.Engineer{
	// 				EmailAddress: to.Ptr("xyz@contoso.com"),
	// 			},
	// 			SupportPlanDisplayName: to.Ptr("Premier"),
	// 			SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
	// 			SupportPlanType: to.Ptr("Premier"),
	// 			SupportTicketID: to.Ptr("118032014183770"),
	// 			Title: to.Ptr("Test - please ignore"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/UpdateSeverityOfSupportTicket.json
func ExampleTicketsNoSubscriptionClient_Update_updateSeverityOfASupportTicket() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTicketsNoSubscriptionClient().Update(ctx, "testticket", armsupport.UpdateSupportTicket{
		Severity: to.Ptr(armsupport.SeverityLevelCritical),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TicketDetails = armsupport.TicketDetails{
	// 	Name: to.Ptr("testticket"),
	// 	Type: to.Ptr("Microsoft.Support/supportTickets"),
	// 	ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
	// 	Properties: &armsupport.TicketDetailsProperties{
	// 		Description: to.Ptr("This is a test - please ignore"),
	// 		AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
	// 		ContactDetails: &armsupport.ContactProfile{
	// 			AdditionalEmailAddresses: []*string{
	// 				to.Ptr("tname@contoso.com"),
	// 				to.Ptr("teamtest@contoso.com")},
	// 				Country: to.Ptr("USA"),
	// 				FirstName: to.Ptr("abc"),
	// 				LastName: to.Ptr("xyz"),
	// 				PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
	// 				PreferredSupportLanguage: to.Ptr("en-US"),
	// 				PreferredTimeZone: to.Ptr("Pacific Standard Time"),
	// 				PrimaryEmailAddress: to.Ptr("test.name@contoso.com"),
	// 			},
	// 			CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 			FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
	// 			ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
	// 			ProblemClassificationDisplayName: to.Ptr("Add or Edit VAT, TAX ID, or PO Number"),
	// 			ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid/problemClassifications/problemClassification_guid"),
	// 			Require24X7Response: to.Ptr(false),
	// 			ServiceDisplayName: to.Ptr("Subscription management"),
	// 			ServiceID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid"),
	// 			ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
	// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
	// 				SLAMinutes: to.Ptr[int32](240),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 			},
	// 			Severity: to.Ptr(armsupport.SeverityLevelCritical),
	// 			Status: to.Ptr("Open"),
	// 			SupportEngineer: &armsupport.Engineer{
	// 				EmailAddress: to.Ptr("xyz@contoso.com"),
	// 			},
	// 			SupportPlanDisplayName: to.Ptr("Premier"),
	// 			SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
	// 			SupportPlanType: to.Ptr("Premier"),
	// 			SupportTicketID: to.Ptr("118032014183770"),
	// 			Title: to.Ptr("Test - please ignore"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/UpdateStatusOfSupportTicket.json
func ExampleTicketsNoSubscriptionClient_Update_updateStatusOfASupportTicket() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTicketsNoSubscriptionClient().Update(ctx, "testticket", armsupport.UpdateSupportTicket{
		Status: to.Ptr(armsupport.StatusClosed),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TicketDetails = armsupport.TicketDetails{
	// 	Name: to.Ptr("testticket"),
	// 	Type: to.Ptr("Microsoft.Support/supportTickets"),
	// 	ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
	// 	Properties: &armsupport.TicketDetailsProperties{
	// 		Description: to.Ptr("This is a test - please ignore"),
	// 		AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
	// 		ContactDetails: &armsupport.ContactProfile{
	// 			AdditionalEmailAddresses: []*string{
	// 				to.Ptr("tname@contoso.com"),
	// 				to.Ptr("teamtest@contoso.com")},
	// 				Country: to.Ptr("USA"),
	// 				FirstName: to.Ptr("abc"),
	// 				LastName: to.Ptr("xyz"),
	// 				PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
	// 				PreferredSupportLanguage: to.Ptr("en-US"),
	// 				PreferredTimeZone: to.Ptr("Pacific Standard Time"),
	// 				PrimaryEmailAddress: to.Ptr("test.name@contoso.com"),
	// 			},
	// 			CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 			FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
	// 			ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
	// 			ProblemClassificationDisplayName: to.Ptr("Add or Edit VAT, TAX ID, or PO Number"),
	// 			ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid/problemClassifications/problemClassification_guid"),
	// 			Require24X7Response: to.Ptr(false),
	// 			ServiceDisplayName: to.Ptr("Subscription management"),
	// 			ServiceID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid"),
	// 			ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
	// 				ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
	// 				SLAMinutes: to.Ptr[int32](240),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 			},
	// 			Severity: to.Ptr(armsupport.SeverityLevelCritical),
	// 			Status: to.Ptr("Closed"),
	// 			SupportEngineer: &armsupport.Engineer{
	// 			},
	// 			SupportPlanDisplayName: to.Ptr("Premier"),
	// 			SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
	// 			SupportPlanType: to.Ptr("Premier"),
	// 			SupportTicketID: to.Ptr("118032014183770"),
	// 			Title: to.Ptr("Test - please ignore"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/CreateBillingSupportTicket.json
func ExampleTicketsNoSubscriptionClient_BeginCreate_createATicketForBillingRelatedIssues() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTicketsNoSubscriptionClient().BeginCreate(ctx, "testticket", armsupport.TicketDetails{
		Properties: &armsupport.TicketDetailsProperties{
			Description: to.Ptr("my description"),
			ContactDetails: &armsupport.ContactProfile{
				Country:                  to.Ptr("usa"),
				FirstName:                to.Ptr("abc"),
				LastName:                 to.Ptr("xyz"),
				PreferredContactMethod:   to.Ptr(armsupport.PreferredContactMethodEmail),
				PreferredSupportLanguage: to.Ptr("en-US"),
				PreferredTimeZone:        to.Ptr("Pacific Standard Time"),
				PrimaryEmailAddress:      to.Ptr("abc@contoso.com"),
			},
			FileWorkspaceName:       to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
			ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/billing_service_guid/problemClassifications/billing_problemClassification_guid"),
			ServiceID:               to.Ptr("/providers/Microsoft.Support/services/billing_service_guid"),
			Severity:                to.Ptr(armsupport.SeverityLevelModerate),
			SupportPlanID:           to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
			Title:                   to.Ptr("my title"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TicketDetails = armsupport.TicketDetails{
	// 	Name: to.Ptr("testticket"),
	// 	Type: to.Ptr("Microsoft.Support/supportTickets"),
	// 	ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
	// 	Properties: &armsupport.TicketDetailsProperties{
	// 		Description: to.Ptr("my description"),
	// 		ContactDetails: &armsupport.ContactProfile{
	// 			Country: to.Ptr("usa"),
	// 			FirstName: to.Ptr("abc"),
	// 			LastName: to.Ptr("xyz"),
	// 			PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
	// 			PreferredSupportLanguage: to.Ptr("en-US"),
	// 			PreferredTimeZone: to.Ptr("Pacific Standard Time"),
	// 			PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
	// 		},
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 		FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
	// 		ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
	// 		ProblemClassificationDisplayName: to.Ptr("Refund request"),
	// 		ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/billing_service_guid/problemClassifications/billing_problemClassification_guid"),
	// 		Require24X7Response: to.Ptr(false),
	// 		ServiceDisplayName: to.Ptr("Billing"),
	// 		ServiceID: to.Ptr("/providers/Microsoft.Support/services/billing_service_guid"),
	// 		ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
	// 			ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
	// 			SLAMinutes: to.Ptr[int32](240),
	// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 		},
	// 		Severity: to.Ptr(armsupport.SeverityLevelModerate),
	// 		Status: to.Ptr("Open"),
	// 		SupportEngineer: &armsupport.Engineer{
	// 		},
	// 		SupportPlanDisplayName: to.Ptr("Premier"),
	// 		SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
	// 		SupportPlanType: to.Ptr("Premier"),
	// 		SupportTicketID: to.Ptr("119120321001170"),
	// 		Title: to.Ptr("my title"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/CreateSubMgmtSupportTicket.json
func ExampleTicketsNoSubscriptionClient_BeginCreate_createATicketForSubscriptionManagementRelatedIssues() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTicketsNoSubscriptionClient().BeginCreate(ctx, "testticket", armsupport.TicketDetails{
		Properties: &armsupport.TicketDetailsProperties{
			Description: to.Ptr("my description"),
			ContactDetails: &armsupport.ContactProfile{
				Country:                  to.Ptr("usa"),
				FirstName:                to.Ptr("abc"),
				LastName:                 to.Ptr("xyz"),
				PreferredContactMethod:   to.Ptr(armsupport.PreferredContactMethodEmail),
				PreferredSupportLanguage: to.Ptr("en-US"),
				PreferredTimeZone:        to.Ptr("Pacific Standard Time"),
				PrimaryEmailAddress:      to.Ptr("abc@contoso.com"),
			},
			FileWorkspaceName:       to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
			ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid/problemClassifications/subscription_management_problemClassification_guid"),
			ServiceID:               to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid"),
			Severity:                to.Ptr(armsupport.SeverityLevelModerate),
			SupportPlanID:           to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
			Title:                   to.Ptr("my title"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TicketDetails = armsupport.TicketDetails{
	// 	Name: to.Ptr("testticket"),
	// 	Type: to.Ptr("Microsoft.Support/supportTickets"),
	// 	ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
	// 	Properties: &armsupport.TicketDetailsProperties{
	// 		Description: to.Ptr("my description"),
	// 		ContactDetails: &armsupport.ContactProfile{
	// 			Country: to.Ptr("usa"),
	// 			FirstName: to.Ptr("abc"),
	// 			LastName: to.Ptr("xyz"),
	// 			PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
	// 			PreferredSupportLanguage: to.Ptr("en-US"),
	// 			PreferredTimeZone: to.Ptr("Pacific Standard Time"),
	// 			PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
	// 		},
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 		FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
	// 		ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
	// 		ProblemClassificationDisplayName: to.Ptr("Transfer ownership of my subscription"),
	// 		ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid/problemClassifications/subscription_management_problemClassification_guid"),
	// 		Require24X7Response: to.Ptr(false),
	// 		ServiceDisplayName: to.Ptr("Subscription management"),
	// 		ServiceID: to.Ptr("/providers/Microsoft.Support/services/subscription_management_service_guid"),
	// 		ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
	// 			ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
	// 			SLAMinutes: to.Ptr[int32](240),
	// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 		},
	// 		Severity: to.Ptr(armsupport.SeverityLevelModerate),
	// 		Status: to.Ptr("Open"),
	// 		SupportEngineer: &armsupport.Engineer{
	// 		},
	// 		SupportPlanDisplayName: to.Ptr("Premier"),
	// 		SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
	// 		SupportPlanType: to.Ptr("Premier"),
	// 		SupportTicketID: to.Ptr("119120321001170"),
	// 		Title: to.Ptr("my title"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/support/resource-manager/Microsoft.Support/preview/2022-09-01-preview/examples/CreateTechnicalSupportTicket.json
func ExampleTicketsNoSubscriptionClient_BeginCreate_createATicketForTechnicalIssueRelatedToASpecificResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTicketsNoSubscriptionClient().BeginCreate(ctx, "testticket", armsupport.TicketDetails{
		Properties: &armsupport.TicketDetailsProperties{
			Description:               to.Ptr("my description"),
			AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
			ContactDetails: &armsupport.ContactProfile{
				Country:                  to.Ptr("usa"),
				FirstName:                to.Ptr("abc"),
				LastName:                 to.Ptr("xyz"),
				PreferredContactMethod:   to.Ptr(armsupport.PreferredContactMethodEmail),
				PreferredSupportLanguage: to.Ptr("en-US"),
				PreferredTimeZone:        to.Ptr("Pacific Standard Time"),
				PrimaryEmailAddress:      to.Ptr("abc@contoso.com"),
			},
			FileWorkspaceName:       to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
			ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_running_linux_service_guid/problemClassifications/problemClassification_guid"),
			ProblemScopingQuestions: to.Ptr("{\"articleId\":\"076846c1-4c0b-4b21-91c6-1a30246b3867\",\"scopingDetails\":[{\"question\":\"When did the problem begin?\",\"controlId\":\"problem_start_time\",\"orderId\":1,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"2023-08-31T18:55:00.739Z\",\"value\":\"2023-08-31T18:55:00.739Z\",\"type\":\"datetime\"}},{\"question\":\"API Type of the Cosmos DB account\",\"controlId\":\"api_type\",\"orderId\":2,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"Table\",\"value\":\"tables\",\"type\":\"string\"}},{\"question\":\"Table name\",\"controlId\":\"collection_name_table\",\"orderId\":11,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"Select Table Name\",\"value\":\"dont_know_answer\",\"type\":\"string\"}},{\"question\":\"Provide additional details about the issue you're facing\",\"controlId\":\"problem_description\",\"orderId\":12,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"test ticket, please ignore and close\",\"value\":\"test ticket, please ignore and close\",\"type\":\"string\"}}]}"),
			SecondaryConsent: []*armsupport.SecondaryConsent{
				{
					Type:        to.Ptr("virtualmachinerunninglinuxservice"),
					UserConsent: to.Ptr(armsupport.UserConsentYes),
				}},
			ServiceID:     to.Ptr("/providers/Microsoft.Support/services/cddd3eb5-1830-b494-44fd-782f691479dc"),
			Severity:      to.Ptr(armsupport.SeverityLevelModerate),
			SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
			Title:         to.Ptr("my title"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TicketDetails = armsupport.TicketDetails{
	// 	Name: to.Ptr("testticket"),
	// 	Type: to.Ptr("Microsoft.Support/supportTickets"),
	// 	ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket"),
	// 	Properties: &armsupport.TicketDetailsProperties{
	// 		Description: to.Ptr("my description"),
	// 		AdvancedDiagnosticConsent: to.Ptr(armsupport.ConsentYes),
	// 		ContactDetails: &armsupport.ContactProfile{
	// 			Country: to.Ptr("usa"),
	// 			FirstName: to.Ptr("abc"),
	// 			LastName: to.Ptr("xyz"),
	// 			PreferredContactMethod: to.Ptr(armsupport.PreferredContactMethodEmail),
	// 			PreferredSupportLanguage: to.Ptr("en-US"),
	// 			PreferredTimeZone: to.Ptr("Pacific Standard Time"),
	// 			PrimaryEmailAddress: to.Ptr("abc@contoso.com"),
	// 		},
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 		FileWorkspaceName: to.Ptr("6f16735c-1530836f-e9970f1a-2e49-47b7-96cd-9746b83aa066"),
	// 		ModifiedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:23.000Z"); return t}()),
	// 		ProblemClassificationDisplayName: to.Ptr("Connectivity / Cannot connect to virtual machine by using RDP or SSH"),
	// 		ProblemClassificationID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_running_linux_service_guid/problemClassifications/problemClassification_guid"),
	// 		ProblemScopingQuestions: to.Ptr("{\"articleId\":\"076846c1-4c0b-4b21-91c6-1a30246b3867\",\"scopingDetails\":[{\"question\":\"When did the problem begin?\",\"controlId\":\"problem_start_time\",\"orderId\":1,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"2023-08-31T18:55:00.739Z\",\"value\":\"2023-08-31T18:55:00.739Z\",\"type\":\"datetime\"}},{\"question\":\"API Type of the Cosmos DB account\",\"controlId\":\"api_type\",\"orderId\":2,\"inputType\":\"static\",\"answer\":{\"displayValue\":\"Table\",\"value\":\"tables\",\"type\":\"string\"}},{\"question\":\"Table name\",\"controlId\":\"collection_name_table\",\"orderId\":11,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"Select Table Name\",\"value\":\"dont_know_answer\",\"type\":\"string\"}},{\"question\":\"Provide additional details about the issue you're facing\",\"controlId\":\"problem_description\",\"orderId\":12,\"inputType\":\"nonstatic\",\"answer\":{\"displayValue\":\"test ticket, please ignore and close\",\"value\":\"test ticket, please ignore and close\",\"type\":\"string\"}}]}"),
	// 		Require24X7Response: to.Ptr(false),
	// 		SecondaryConsent: []*armsupport.SecondaryConsent{
	// 			{
	// 				Type: to.Ptr("virtualmachinerunninglinuxservice"),
	// 				UserConsent: to.Ptr(armsupport.UserConsentYes),
	// 		}},
	// 		ServiceDisplayName: to.Ptr("Virtual Machine running Linux"),
	// 		ServiceID: to.Ptr("/providers/Microsoft.Support/services/virtual_machine_running_linux_service_guid"),
	// 		ServiceLevelAgreement: &armsupport.ServiceLevelAgreement{
	// 			ExpirationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-21T17:36:18.000Z"); return t}()),
	// 			SLAMinutes: to.Ptr[int32](240),
	// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-20T21:36:18.000Z"); return t}()),
	// 		},
	// 		Severity: to.Ptr(armsupport.SeverityLevelModerate),
	// 		Status: to.Ptr("Open"),
	// 		SupportEngineer: &armsupport.Engineer{
	// 		},
	// 		SupportPlanDisplayName: to.Ptr("Premier"),
	// 		SupportPlanID: to.Ptr("U291cmNlOlNDTSxDbGFyaWZ5SW5zdGFsbGF0aW9uU2l0ZUlkOjcsTGluZUl0ZW1JZDo5ODY1NzIyOSxDb250cmFjdElkOjk4NjU5MTk0LFN1YnNjcmlwdGlvbklkOjc2Y2I3N2ZhLThiMTctNGVhYi05NDkzLWI2NWRhY2U5OTgxMyw="),
	// 		SupportPlanType: to.Ptr("Premier"),
	// 		SupportTicketID: to.Ptr("119120321001170"),
	// 		Title: to.Ptr("my title"),
	// 	},
	// }
}
