//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armsqlvirtualmachine.ClientFactory type.
type ServerFactory struct {
	AvailabilityGroupListenersServer AvailabilityGroupListenersServer
	GroupsServer                     GroupsServer
	OperationsServer                 OperationsServer
	SQLVirtualMachinesServer         SQLVirtualMachinesServer
	TroubleshootServer               TroubleshootServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armsqlvirtualmachine.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armsqlvirtualmachine.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                *ServerFactory
	trMu                               sync.Mutex
	trAvailabilityGroupListenersServer *AvailabilityGroupListenersServerTransport
	trGroupsServer                     *GroupsServerTransport
	trOperationsServer                 *OperationsServerTransport
	trSQLVirtualMachinesServer         *SQLVirtualMachinesServerTransport
	trTroubleshootServer               *TroubleshootServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AvailabilityGroupListenersClient":
		initServer(s, &s.trAvailabilityGroupListenersServer, func() *AvailabilityGroupListenersServerTransport {
			return NewAvailabilityGroupListenersServerTransport(&s.srv.AvailabilityGroupListenersServer)
		})
		resp, err = s.trAvailabilityGroupListenersServer.Do(req)
	case "GroupsClient":
		initServer(s, &s.trGroupsServer, func() *GroupsServerTransport { return NewGroupsServerTransport(&s.srv.GroupsServer) })
		resp, err = s.trGroupsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "SQLVirtualMachinesClient":
		initServer(s, &s.trSQLVirtualMachinesServer, func() *SQLVirtualMachinesServerTransport {
			return NewSQLVirtualMachinesServerTransport(&s.srv.SQLVirtualMachinesServer)
		})
		resp, err = s.trSQLVirtualMachinesServer.Do(req)
	case "TroubleshootClient":
		initServer(s, &s.trTroubleshootServer, func() *TroubleshootServerTransport { return NewTroubleshootServerTransport(&s.srv.TroubleshootServer) })
		resp, err = s.trTroubleshootServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
