//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// SoftwareInventoriesServer is a fake server for instances of the armsecurity.SoftwareInventoriesClient type.
type SoftwareInventoriesServer struct {
	// Get is the fake for method SoftwareInventoriesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, softwareName string, options *armsecurity.SoftwareInventoriesClientGetOptions) (resp azfake.Responder[armsecurity.SoftwareInventoriesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByExtendedResourcePager is the fake for method SoftwareInventoriesClient.NewListByExtendedResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByExtendedResourcePager func(resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *armsecurity.SoftwareInventoriesClientListByExtendedResourceOptions) (resp azfake.PagerResponder[armsecurity.SoftwareInventoriesClientListByExtendedResourceResponse])

	// NewListBySubscriptionPager is the fake for method SoftwareInventoriesClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armsecurity.SoftwareInventoriesClientListBySubscriptionOptions) (resp azfake.PagerResponder[armsecurity.SoftwareInventoriesClientListBySubscriptionResponse])
}

// NewSoftwareInventoriesServerTransport creates a new instance of SoftwareInventoriesServerTransport with the provided implementation.
// The returned SoftwareInventoriesServerTransport instance is connected to an instance of armsecurity.SoftwareInventoriesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSoftwareInventoriesServerTransport(srv *SoftwareInventoriesServer) *SoftwareInventoriesServerTransport {
	return &SoftwareInventoriesServerTransport{
		srv:                            srv,
		newListByExtendedResourcePager: newTracker[azfake.PagerResponder[armsecurity.SoftwareInventoriesClientListByExtendedResourceResponse]](),
		newListBySubscriptionPager:     newTracker[azfake.PagerResponder[armsecurity.SoftwareInventoriesClientListBySubscriptionResponse]](),
	}
}

// SoftwareInventoriesServerTransport connects instances of armsecurity.SoftwareInventoriesClient to instances of SoftwareInventoriesServer.
// Don't use this type directly, use NewSoftwareInventoriesServerTransport instead.
type SoftwareInventoriesServerTransport struct {
	srv                            *SoftwareInventoriesServer
	newListByExtendedResourcePager *tracker[azfake.PagerResponder[armsecurity.SoftwareInventoriesClientListByExtendedResourceResponse]]
	newListBySubscriptionPager     *tracker[azfake.PagerResponder[armsecurity.SoftwareInventoriesClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for SoftwareInventoriesServerTransport.
func (s *SoftwareInventoriesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SoftwareInventoriesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SoftwareInventoriesClient.NewListByExtendedResourcePager":
		resp, err = s.dispatchNewListByExtendedResourcePager(req)
	case "SoftwareInventoriesClient.NewListBySubscriptionPager":
		resp, err = s.dispatchNewListBySubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SoftwareInventoriesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/softwareInventories/(?P<softwareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	softwareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("softwareName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, resourceNamespaceParam, resourceTypeParam, resourceNameParam, softwareNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Software, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SoftwareInventoriesServerTransport) dispatchNewListByExtendedResourcePager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByExtendedResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByExtendedResourcePager not implemented")}
	}
	newListByExtendedResourcePager := s.newListByExtendedResourcePager.get(req)
	if newListByExtendedResourcePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/softwareInventories`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceNamespace")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByExtendedResourcePager(resourceGroupNameParam, resourceNamespaceParam, resourceTypeParam, resourceNameParam, nil)
		newListByExtendedResourcePager = &resp
		s.newListByExtendedResourcePager.add(req, newListByExtendedResourcePager)
		server.PagerResponderInjectNextLinks(newListByExtendedResourcePager, req, func(page *armsecurity.SoftwareInventoriesClientListByExtendedResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByExtendedResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByExtendedResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByExtendedResourcePager) {
		s.newListByExtendedResourcePager.remove(req)
	}
	return resp, nil
}

func (s *SoftwareInventoriesServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := s.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/softwareInventories`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := s.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		s.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armsecurity.SoftwareInventoriesClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		s.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}
