//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/powerbidedicated/armpowerbidedicated"
	"net/http"
	"net/url"
	"regexp"
)

// CapacitiesServer is a fake server for instances of the armpowerbidedicated.CapacitiesClient type.
type CapacitiesServer struct {
	// CheckNameAvailability is the fake for method CapacitiesClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, location string, capacityParameters armpowerbidedicated.CheckCapacityNameAvailabilityParameters, options *armpowerbidedicated.CapacitiesClientCheckNameAvailabilityOptions) (resp azfake.Responder[armpowerbidedicated.CapacitiesClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method CapacitiesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, dedicatedCapacityName string, capacityParameters armpowerbidedicated.DedicatedCapacity, options *armpowerbidedicated.CapacitiesClientBeginCreateOptions) (resp azfake.PollerResponder[armpowerbidedicated.CapacitiesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method CapacitiesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, dedicatedCapacityName string, options *armpowerbidedicated.CapacitiesClientBeginDeleteOptions) (resp azfake.PollerResponder[armpowerbidedicated.CapacitiesClientDeleteResponse], errResp azfake.ErrorResponder)

	// GetDetails is the fake for method CapacitiesClient.GetDetails
	// HTTP status codes to indicate success: http.StatusOK
	GetDetails func(ctx context.Context, resourceGroupName string, dedicatedCapacityName string, options *armpowerbidedicated.CapacitiesClientGetDetailsOptions) (resp azfake.Responder[armpowerbidedicated.CapacitiesClientGetDetailsResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method CapacitiesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armpowerbidedicated.CapacitiesClientListOptions) (resp azfake.PagerResponder[armpowerbidedicated.CapacitiesClientListResponse])

	// NewListByResourceGroupPager is the fake for method CapacitiesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armpowerbidedicated.CapacitiesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armpowerbidedicated.CapacitiesClientListByResourceGroupResponse])

	// ListSKUs is the fake for method CapacitiesClient.ListSKUs
	// HTTP status codes to indicate success: http.StatusOK
	ListSKUs func(ctx context.Context, options *armpowerbidedicated.CapacitiesClientListSKUsOptions) (resp azfake.Responder[armpowerbidedicated.CapacitiesClientListSKUsResponse], errResp azfake.ErrorResponder)

	// ListSKUsForCapacity is the fake for method CapacitiesClient.ListSKUsForCapacity
	// HTTP status codes to indicate success: http.StatusOK
	ListSKUsForCapacity func(ctx context.Context, resourceGroupName string, dedicatedCapacityName string, options *armpowerbidedicated.CapacitiesClientListSKUsForCapacityOptions) (resp azfake.Responder[armpowerbidedicated.CapacitiesClientListSKUsForCapacityResponse], errResp azfake.ErrorResponder)

	// BeginResume is the fake for method CapacitiesClient.BeginResume
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResume func(ctx context.Context, resourceGroupName string, dedicatedCapacityName string, options *armpowerbidedicated.CapacitiesClientBeginResumeOptions) (resp azfake.PollerResponder[armpowerbidedicated.CapacitiesClientResumeResponse], errResp azfake.ErrorResponder)

	// BeginSuspend is the fake for method CapacitiesClient.BeginSuspend
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSuspend func(ctx context.Context, resourceGroupName string, dedicatedCapacityName string, options *armpowerbidedicated.CapacitiesClientBeginSuspendOptions) (resp azfake.PollerResponder[armpowerbidedicated.CapacitiesClientSuspendResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method CapacitiesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, dedicatedCapacityName string, capacityUpdateParameters armpowerbidedicated.DedicatedCapacityUpdateParameters, options *armpowerbidedicated.CapacitiesClientBeginUpdateOptions) (resp azfake.PollerResponder[armpowerbidedicated.CapacitiesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewCapacitiesServerTransport creates a new instance of CapacitiesServerTransport with the provided implementation.
// The returned CapacitiesServerTransport instance is connected to an instance of armpowerbidedicated.CapacitiesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCapacitiesServerTransport(srv *CapacitiesServer) *CapacitiesServerTransport {
	return &CapacitiesServerTransport{
		srv:                         srv,
		beginCreate:                 newTracker[azfake.PollerResponder[armpowerbidedicated.CapacitiesClientCreateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armpowerbidedicated.CapacitiesClientDeleteResponse]](),
		newListPager:                newTracker[azfake.PagerResponder[armpowerbidedicated.CapacitiesClientListResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armpowerbidedicated.CapacitiesClientListByResourceGroupResponse]](),
		beginResume:                 newTracker[azfake.PollerResponder[armpowerbidedicated.CapacitiesClientResumeResponse]](),
		beginSuspend:                newTracker[azfake.PollerResponder[armpowerbidedicated.CapacitiesClientSuspendResponse]](),
		beginUpdate:                 newTracker[azfake.PollerResponder[armpowerbidedicated.CapacitiesClientUpdateResponse]](),
	}
}

// CapacitiesServerTransport connects instances of armpowerbidedicated.CapacitiesClient to instances of CapacitiesServer.
// Don't use this type directly, use NewCapacitiesServerTransport instead.
type CapacitiesServerTransport struct {
	srv                         *CapacitiesServer
	beginCreate                 *tracker[azfake.PollerResponder[armpowerbidedicated.CapacitiesClientCreateResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armpowerbidedicated.CapacitiesClientDeleteResponse]]
	newListPager                *tracker[azfake.PagerResponder[armpowerbidedicated.CapacitiesClientListResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armpowerbidedicated.CapacitiesClientListByResourceGroupResponse]]
	beginResume                 *tracker[azfake.PollerResponder[armpowerbidedicated.CapacitiesClientResumeResponse]]
	beginSuspend                *tracker[azfake.PollerResponder[armpowerbidedicated.CapacitiesClientSuspendResponse]]
	beginUpdate                 *tracker[azfake.PollerResponder[armpowerbidedicated.CapacitiesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for CapacitiesServerTransport.
func (c *CapacitiesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CapacitiesClient.CheckNameAvailability":
		resp, err = c.dispatchCheckNameAvailability(req)
	case "CapacitiesClient.BeginCreate":
		resp, err = c.dispatchBeginCreate(req)
	case "CapacitiesClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "CapacitiesClient.GetDetails":
		resp, err = c.dispatchGetDetails(req)
	case "CapacitiesClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "CapacitiesClient.NewListByResourceGroupPager":
		resp, err = c.dispatchNewListByResourceGroupPager(req)
	case "CapacitiesClient.ListSKUs":
		resp, err = c.dispatchListSKUs(req)
	case "CapacitiesClient.ListSKUsForCapacity":
		resp, err = c.dispatchListSKUsForCapacity(req)
	case "CapacitiesClient.BeginResume":
		resp, err = c.dispatchBeginResume(req)
	case "CapacitiesClient.BeginSuspend":
		resp, err = c.dispatchBeginSuspend(req)
	case "CapacitiesClient.BeginUpdate":
		resp, err = c.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CapacitiesServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if c.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBIDedicated/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpowerbidedicated.CheckCapacityNameAvailabilityParameters](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.CheckNameAvailability(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckCapacityNameAvailabilityResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CapacitiesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := c.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBIDedicated/capacities/(?P<dedicatedCapacityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armpowerbidedicated.DedicatedCapacity](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dedicatedCapacityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dedicatedCapacityName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreate(req.Context(), resourceGroupNameParam, dedicatedCapacityNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		c.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		c.beginCreate.remove(req)
	}

	return resp, nil
}

func (c *CapacitiesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBIDedicated/capacities/(?P<dedicatedCapacityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dedicatedCapacityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dedicatedCapacityName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, dedicatedCapacityNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *CapacitiesServerTransport) dispatchGetDetails(req *http.Request) (*http.Response, error) {
	if c.srv.GetDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDetails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBIDedicated/capacities/(?P<dedicatedCapacityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dedicatedCapacityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dedicatedCapacityName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetDetails(req.Context(), resourceGroupNameParam, dedicatedCapacityNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DedicatedCapacity, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CapacitiesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBIDedicated/capacities`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := c.srv.NewListPager(nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *CapacitiesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := c.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBIDedicated/capacities`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		c.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		c.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (c *CapacitiesServerTransport) dispatchListSKUs(req *http.Request) (*http.Response, error) {
	if c.srv.ListSKUs == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSKUs not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBIDedicated/skus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := c.srv.ListSKUs(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SKUEnumerationForNewResourceResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CapacitiesServerTransport) dispatchListSKUsForCapacity(req *http.Request) (*http.Response, error) {
	if c.srv.ListSKUsForCapacity == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSKUsForCapacity not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBIDedicated/capacities/(?P<dedicatedCapacityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dedicatedCapacityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dedicatedCapacityName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.ListSKUsForCapacity(req.Context(), resourceGroupNameParam, dedicatedCapacityNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SKUEnumerationForExistingResourceResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CapacitiesServerTransport) dispatchBeginResume(req *http.Request) (*http.Response, error) {
	if c.srv.BeginResume == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResume not implemented")}
	}
	beginResume := c.beginResume.get(req)
	if beginResume == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBIDedicated/capacities/(?P<dedicatedCapacityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resume`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dedicatedCapacityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dedicatedCapacityName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginResume(req.Context(), resourceGroupNameParam, dedicatedCapacityNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResume = &respr
		c.beginResume.add(req, beginResume)
	}

	resp, err := server.PollerResponderNext(beginResume, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginResume.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResume) {
		c.beginResume.remove(req)
	}

	return resp, nil
}

func (c *CapacitiesServerTransport) dispatchBeginSuspend(req *http.Request) (*http.Response, error) {
	if c.srv.BeginSuspend == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSuspend not implemented")}
	}
	beginSuspend := c.beginSuspend.get(req)
	if beginSuspend == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBIDedicated/capacities/(?P<dedicatedCapacityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/suspend`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dedicatedCapacityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dedicatedCapacityName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginSuspend(req.Context(), resourceGroupNameParam, dedicatedCapacityNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSuspend = &respr
		c.beginSuspend.add(req, beginSuspend)
	}

	resp, err := server.PollerResponderNext(beginSuspend, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginSuspend.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSuspend) {
		c.beginSuspend.remove(req)
	}

	return resp, nil
}

func (c *CapacitiesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := c.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBIDedicated/capacities/(?P<dedicatedCapacityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armpowerbidedicated.DedicatedCapacityUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dedicatedCapacityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dedicatedCapacityName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdate(req.Context(), resourceGroupNameParam, dedicatedCapacityNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		c.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		c.beginUpdate.remove(req)
	}

	return resp, nil
}
