//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hdinsight/armhdinsight"
	"net/http"
	"net/url"
	"regexp"
)

// VirtualMachinesServer is a fake server for instances of the armhdinsight.VirtualMachinesClient type.
type VirtualMachinesServer struct {
	// GetAsyncOperationStatus is the fake for method VirtualMachinesClient.GetAsyncOperationStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetAsyncOperationStatus func(ctx context.Context, resourceGroupName string, clusterName string, operationID string, options *armhdinsight.VirtualMachinesClientGetAsyncOperationStatusOptions) (resp azfake.Responder[armhdinsight.VirtualMachinesClientGetAsyncOperationStatusResponse], errResp azfake.ErrorResponder)

	// ListHosts is the fake for method VirtualMachinesClient.ListHosts
	// HTTP status codes to indicate success: http.StatusOK
	ListHosts func(ctx context.Context, resourceGroupName string, clusterName string, options *armhdinsight.VirtualMachinesClientListHostsOptions) (resp azfake.Responder[armhdinsight.VirtualMachinesClientListHostsResponse], errResp azfake.ErrorResponder)

	// BeginRestartHosts is the fake for method VirtualMachinesClient.BeginRestartHosts
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestartHosts func(ctx context.Context, resourceGroupName string, clusterName string, hosts []*string, options *armhdinsight.VirtualMachinesClientBeginRestartHostsOptions) (resp azfake.PollerResponder[armhdinsight.VirtualMachinesClientRestartHostsResponse], errResp azfake.ErrorResponder)
}

// NewVirtualMachinesServerTransport creates a new instance of VirtualMachinesServerTransport with the provided implementation.
// The returned VirtualMachinesServerTransport instance is connected to an instance of armhdinsight.VirtualMachinesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVirtualMachinesServerTransport(srv *VirtualMachinesServer) *VirtualMachinesServerTransport {
	return &VirtualMachinesServerTransport{
		srv:               srv,
		beginRestartHosts: newTracker[azfake.PollerResponder[armhdinsight.VirtualMachinesClientRestartHostsResponse]](),
	}
}

// VirtualMachinesServerTransport connects instances of armhdinsight.VirtualMachinesClient to instances of VirtualMachinesServer.
// Don't use this type directly, use NewVirtualMachinesServerTransport instead.
type VirtualMachinesServerTransport struct {
	srv               *VirtualMachinesServer
	beginRestartHosts *tracker[azfake.PollerResponder[armhdinsight.VirtualMachinesClientRestartHostsResponse]]
}

// Do implements the policy.Transporter interface for VirtualMachinesServerTransport.
func (v *VirtualMachinesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VirtualMachinesClient.GetAsyncOperationStatus":
		resp, err = v.dispatchGetAsyncOperationStatus(req)
	case "VirtualMachinesClient.ListHosts":
		resp, err = v.dispatchListHosts(req)
	case "VirtualMachinesClient.BeginRestartHosts":
		resp, err = v.dispatchBeginRestartHosts(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchGetAsyncOperationStatus(req *http.Request) (*http.Response, error) {
	if v.srv.GetAsyncOperationStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAsyncOperationStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restartHosts/azureasyncoperations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.GetAsyncOperationStatus(req.Context(), resourceGroupNameParam, clusterNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AsyncOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchListHosts(req *http.Request) (*http.Response, error) {
	if v.srv.ListHosts == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListHosts not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listHosts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.ListHosts(req.Context(), resourceGroupNameParam, clusterNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HostInfoArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginRestartHosts(req *http.Request) (*http.Response, error) {
	if v.srv.BeginRestartHosts == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestartHosts not implemented")}
	}
	beginRestartHosts := v.beginRestartHosts.get(req)
	if beginRestartHosts == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restartHosts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[[]*string](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginRestartHosts(req.Context(), resourceGroupNameParam, clusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestartHosts = &respr
		v.beginRestartHosts.add(req, beginRestartHosts)
	}

	resp, err := server.PollerResponderNext(beginRestartHosts, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginRestartHosts.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestartHosts) {
		v.beginRestartHosts.remove(req)
	}

	return resp, nil
}
