/*
 * A font chooser JavaBean component.
 * Copyright (C) 2009 Dr Christos Bohoris
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 3 as published by the Free Software Foundation;
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * swing@connectina.com
 */
package com.connectina.swing.fontchooser;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFrame;

/**
 * A dialog containing a <code>JFontChooser</code> as well as OK and
 * Cancel buttons.
 *
 * @author Christos Bohoris
 */
class FontChooserDialog extends javax.swing.JDialog {

	private static final long serialVersionUID = -953666562985797384L;
	private ResourceBundle bundle = ResourceBundle.getBundle("com/connectina/swing/fontchooser/resources/i18n/FontChooserDialog");
    private JFontChooser chooserPane;

    FontChooserDialog(JFrame owner, boolean modal,
         JFontChooser chooserPane, ActionListener selectionListener)
        throws HeadlessException {
        super(owner, modal);
        initDialog(chooserPane, selectionListener);
    }

    FontChooserDialog(JDialog owner, boolean modal,
         JFontChooser chooserPane, ActionListener selectionListener)
        throws HeadlessException {
        super(owner, modal);
        initDialog(chooserPane, selectionListener);
    }

    private void initDialog(JFontChooser chooserPane, ActionListener selectionListener) {
        this.chooserPane = chooserPane;
        initComponents();
        okButton.addActionListener(selectionListener);
        okButton.addActionListener(new OKActionListener());
        cancelButton.addActionListener(new CancelActionListener());
        addWindowListener(new FontChooserDialogAdapter());
        getRootPane().setDefaultButton(okButton);
        okButton.requestFocusInWindow();
    }

    private class FontChooserDialogAdapter extends WindowAdapter {

        @Override
        public void windowClosing(WindowEvent event) {
            dispose();
        }

    }

    private class OKActionListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            dispose();
        }

    }

    private class CancelActionListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            dispose();
        }

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        basePanel = new javax.swing.JPanel();
        chooserPanel = new javax.swing.JPanel();
        chooserSeparator = new javax.swing.JSeparator();
        controlPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle(bundle.getString("window.title"));

        basePanel.setLayout(new java.awt.BorderLayout());

        chooserPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 0, 11));
        chooserPanel.setLayout(new java.awt.BorderLayout(0, 12));
        chooserPanel.add(chooserSeparator, java.awt.BorderLayout.PAGE_END);

        basePanel.add(chooserPanel, java.awt.BorderLayout.CENTER);
        chooserPanel.add(chooserPane, java.awt.BorderLayout.CENTER);

        controlPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(7, 7, 6, 6));
        controlPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        okButton.setMnemonic(bundle.getString("action.ok.mnemonic").charAt(0));
        okButton.setText(bundle.getString("action.ok"));
        controlPanel.add(okButton);

        cancelButton.setMnemonic(bundle.getString("action.cancel.mnemonic").charAt(0));
        cancelButton.setText(bundle.getString("action.cancel"));
        controlPanel.add(cancelButton);

        basePanel.add(controlPanel, java.awt.BorderLayout.SOUTH);

        getContentPane().add(basePanel, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel basePanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel chooserPanel;
    private javax.swing.JSeparator chooserSeparator;
    private javax.swing.JPanel controlPanel;
    private javax.swing.JButton okButton;
    // End of variables declaration//GEN-END:variables
}
