# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Django Application Configuration for the server application."""

from django.apps import AppConfig


class ServerConfig(AppConfig):
    """Django's AppConfig for the server application."""

    name = 'debusine.server'

    def ready(self) -> None:
        """Mark workers as disconnected. Runs on Django startup."""
        # Import the provisioner and scheduler so that their Celery tasks
        # and signal receivers are registered.
        import debusine.server.provisioning  # noqa: F401
        import debusine.server.scheduler  # noqa: F401

        # Import various tasks so that they are registered.
        import debusine.server.tasks  # noqa: F401
        import debusine.server.tasks.wait  # noqa: F401
        import debusine.signing.tasks  # noqa: F401
