#include "SpaceGroup.h"
#include "Matrix_3x3.h"
#include "Vec3.h"

/// CONSTRUCTOR
SpaceGroup::SpaceGroup() :
  sgID_(-1)
{
  IdMap_["P1"] = 0;
  IdMap_["P-1"] = 1;
  IdMap_["P2"] = 2;
  IdMap_["P121"] = 2;
  IdMap_["P2(1)"] = 3;
  IdMap_["P12(1)1"] = 3;
  IdMap_["C2"] = 4;
  IdMap_["C121"] = 4;
  IdMap_["Pm"] = 5;
  IdMap_["Pc"] = 6;
  IdMap_["Cm"] = 7;
  IdMap_["Cc"] = 8;
  IdMap_["P2/m"] = 9;
  IdMap_["P2(1)/m"] = 10;
  IdMap_["C2/m"] = 11;
  IdMap_["P2/c"] = 12;
  IdMap_["P2(1)/c"] = 13;
  IdMap_["P12(1)/c1"] = 13;
  IdMap_["C2/c"] = 14;
  IdMap_["C12/c1"] = 14;
  IdMap_["P222"] = 15;
  IdMap_["P222(1)"] = 16;
  IdMap_["P2(1)22_NSO"] = 17;
  IdMap_["P2(1)2(1)2"] = 18;
  IdMap_["P2(1)2(1)2_NSO"] = 19;
  IdMap_["P2(1)2(1)2(1)"] = 20;
  IdMap_["C222(1)"] = 21;
  IdMap_["C222"] = 22;
  IdMap_["F222"] = 23;
  IdMap_["I222"] = 24;
  IdMap_["I2(1)2(1)2(1)"] = 25;
  IdMap_["Pmm2"] = 26;
  IdMap_["Pmc2(1)"] = 27;
  IdMap_["Pcc2"] = 28;
  IdMap_["Pma2"] = 29;
  IdMap_["Pca2(1)"] = 30;
  IdMap_["Pnc2"] = 31;
  IdMap_["Pmn2(1)"] = 32;
  IdMap_["Pba2"] = 33;
  IdMap_["Pna2(1)"] = 34;
  IdMap_["Pnn2"] = 35;
  IdMap_["Cmm2"] = 36;
  IdMap_["Cmc2(1)"] = 37;
  IdMap_["Ccc2"] = 38;
  IdMap_["Amm2"] = 39;
  IdMap_["Abm2"] = 40;
  IdMap_["Ama2"] = 41;
  IdMap_["Aba2"] = 42;
  IdMap_["Fmm2"] = 43;
  IdMap_["Fdd2"] = 44;
  IdMap_["Imm2"] = 45;
  IdMap_["Iba2"] = 46;
  IdMap_["Ima2"] = 47;
  IdMap_["Pmmm"] = 48;
  IdMap_["Pnnn"] = 49;
  IdMap_["Pccm"] = 50;
  IdMap_["Pban"] = 51;
  IdMap_["Pmma"] = 52;
  IdMap_["Pnna"] = 53;
  IdMap_["Pmna"] = 54;
  IdMap_["Pcca"] = 55;
  IdMap_["Pbam"] = 56;
  IdMap_["Pccn"] = 57;
  IdMap_["Pbcm"] = 58;
  IdMap_["Pnnm"] = 59;
  IdMap_["Pmmn"] = 60;
  IdMap_["Pmmn_NSO"] = 61;
  IdMap_["Pbcn"] = 62;
  IdMap_["Pbca"] = 63;
  IdMap_["Pnma"] = 64;
  IdMap_["Cmcm"] = 65;
  IdMap_["Cmca"] = 66;
  IdMap_["Cmmm"] = 67;
  IdMap_["Cccm"] = 68;
  IdMap_["Cmma"] = 69;
  IdMap_["Ccca"] = 70;
  IdMap_["Fmmm"] = 71;
  IdMap_["Fddd"] = 72;
  IdMap_["Immm"] = 73;
  IdMap_["Ibam"] = 74;
  IdMap_["Ibca"] = 75;
  IdMap_["Imma"] = 76;
  IdMap_["P4"] = 77;
  IdMap_["P4(1)"] = 78;
  IdMap_["P4(2)"] = 79;
  IdMap_["P4(3)"] = 80;
  IdMap_["I4"] = 81;
  IdMap_["I4(1)"] = 82;
  IdMap_["P-4"] = 83;
  IdMap_["I-4"] = 84;
  IdMap_["P4/m"] = 85;
  IdMap_["P4(2)/m"] = 86;
  IdMap_["P4/n"] = 87;
  IdMap_["P4(2)/n"] = 88;
  IdMap_["I4/m"] = 89;
  IdMap_["I4(1)/a"] = 90;
  IdMap_["P422"] = 91;
  IdMap_["P42(1)2"] = 92;
  IdMap_["P4(1)22"] = 93;
  IdMap_["P4(1)2(1)2"] = 94;
  IdMap_["P4(2)22"] = 95;
  IdMap_["P4(2)2(1)2"] = 96;
  IdMap_["P4(3)22"] = 97;
  IdMap_["P4(3)2(1)2"] = 98;
  IdMap_["I422"] = 99;
  IdMap_["I4(1)22"] = 100;
  IdMap_["P4mm"] = 101;
  IdMap_["P4bm"] = 102;
  IdMap_["P4(2)cm"] = 103;
  IdMap_["P4(2)nm"] = 104;
  IdMap_["P4cc"] = 105;
  IdMap_["P4nc"] = 106;
  IdMap_["P4(2)mc"] = 107;
  IdMap_["P4(2)bc"] = 108;
  IdMap_["I4mm"] = 109;
  IdMap_["I4cm"] = 110;
  IdMap_["I4(1)md"] = 111;
  IdMap_["I4(1)cd"] = 112;
  IdMap_["P-42m"] = 113;
  IdMap_["P-42c"] = 114;
  IdMap_["P-42(1)m"] = 115;
  IdMap_["P-42(1)c"] = 116;
  IdMap_["P-4m2"] = 117;
  IdMap_["P-4c2"] = 118;
  IdMap_["P-4b2"] = 119;
  IdMap_["P-4n2"] = 120;
  IdMap_["I-4m2"] = 121;
  IdMap_["I-4c2"] = 122;
  IdMap_["I-42m"] = 123;
  IdMap_["I-42d"] = 124;
  IdMap_["P4/mmm"] = 125;
  IdMap_["P4/mcc"] = 126;
  IdMap_["P4/nbm"] = 127;
  IdMap_["P4/nnc"] = 128;
  IdMap_["P4/mbm"] = 129;
  IdMap_["P4/mnc"] = 130;
  IdMap_["P4/nmm"] = 131;
  IdMap_["P4/ncc"] = 132;
  IdMap_["P4(2)/mmc"] = 133;
  IdMap_["P4(2)/mcm"] = 134;
  IdMap_["P4(2)/nbc"] = 135;
  IdMap_["P4(2)/nnm"] = 136;
  IdMap_["P4(2)/mbc"] = 137;
  IdMap_["P4(2)/mnm"] = 138;
  IdMap_["P4(2)/nmc"] = 139;
  IdMap_["P4(2)/ncm"] = 140;
  IdMap_["I4/mmm"] = 141;
  IdMap_["I4/mcm"] = 142;
  IdMap_["I4(1)/amd"] = 143;
  IdMap_["I4(1)/acd"] = 144;
  IdMap_["P3"] = 145;
  IdMap_["P3(1)"] = 146;
  IdMap_["P3(2)"] = 147;
  IdMap_["R3"] = 148;
  IdMap_["P-3"] = 149;
  IdMap_["R-3"] = 150;
  IdMap_["P312"] = 151;
  IdMap_["P321"] = 152;
  IdMap_["P3(1)12"] = 153;
  IdMap_["P3(1)21"] = 154;
  IdMap_["P3(2)12"] = 155;
  IdMap_["P3(2)21"] = 156;
  IdMap_["R32"] = 157;
  IdMap_["P3m1"] = 158;
  IdMap_["P31m"] = 159;
  IdMap_["P3c1"] = 160;
  IdMap_["P31c"] = 161;
  IdMap_["R3m"] = 162;
  IdMap_["R3c"] = 163;
  IdMap_["P-31m"] = 164;
  IdMap_["P-31c"] = 165;
  IdMap_["P-3m1"] = 166;
  IdMap_["P-3c1"] = 167;
  IdMap_["R-3m"] = 168;
  IdMap_["R-3c"] = 169;
  IdMap_["P6"] = 170;
  IdMap_["P6(1)"] = 171;
  IdMap_["P6(5)"] = 172;
  IdMap_["P6(2)"] = 173;
  IdMap_["P6(4)"] = 174;
  IdMap_["P6(3)"] = 175;
  IdMap_["P-6"] = 176;
  IdMap_["P6/m"] = 177;
  IdMap_["P6(3)/m"] = 178;
  IdMap_["P622"] = 179;
  IdMap_["P6(1)22"] = 180;
  IdMap_["P6(5)22"] = 181;
  IdMap_["P6(2)22"] = 182;
  IdMap_["P6(4)22"] = 183;
  IdMap_["P6(3)22"] = 184;
  IdMap_["P6mm"] = 185;
  IdMap_["P6cc"] = 186;
  IdMap_["P6(3)cm"] = 187;
  IdMap_["P6(3)mc"] = 188;
  IdMap_["P-6m2"] = 189;
  IdMap_["P-6c2"] = 190;
  IdMap_["P-62m"] = 191;
  IdMap_["P-62c"] = 192;
  IdMap_["P6/mmm"] = 193;
  IdMap_["P6/mcc"] = 194;
  IdMap_["P6(3)/mcm"] = 195;
  IdMap_["P6(3)/mmc"] = 196;
  IdMap_["P23"] = 197;
  IdMap_["F23"] = 198;
  IdMap_["I23"] = 199;
  IdMap_["P2(1)3"] = 200;
  IdMap_["I2(1)3"] = 201;
  IdMap_["Pm-3"] = 202;
  IdMap_["Pn-3"] = 203;
  IdMap_["Fm-3"] = 204;
  IdMap_["Fd-3"] = 205;
  IdMap_["Im-3"] = 206;
  IdMap_["Pa-3"] = 207;
  IdMap_["Ia-3"] = 208;
  IdMap_["P432"] = 209;
  IdMap_["P4(2)32"] = 210;
  IdMap_["F432"] = 211;
  IdMap_["F4(1)32"] = 212;
  IdMap_["I432"] = 213;
  IdMap_["P4(3)32"] = 214;
  IdMap_["P4(1)32"] = 215;
  IdMap_["I4(1)32"] = 216;
  IdMap_["P-43m"] = 217;
  IdMap_["F4-3m"] = 218;
  IdMap_["I-43m"] = 219;
  IdMap_["P-43n"] = 220;
  IdMap_["F-43c"] = 221;
  IdMap_["I-43d"] = 222;
  IdMap_["Pm-3m"] = 223;
  IdMap_["Pn-3n"] = 224;
  IdMap_["Pm-3n"] = 225;
  IdMap_["Pn-3m"] = 226;
  IdMap_["P22(1)2(1)"] = 227;
  IdMap_["I121"] = 228;
  IdMap_["B112"] = 229;
  IdMap_["P2(1)/n"] = 230;
  IdMap_["P12(1)/n1"] = 230;
  IdMap_["Pcab"] = 231;
  IdMap_["H32"] = 232;
  IdMap_["P22(1)2"] = 233;
  IdMap_["I2"] = 234;
  IdMap_["I121"] = 234;
  IdMap_["H3"] = 235;
  IdMap_["P2(1)22(1)"] = 236;
}

// SpaceGroup::ID()
int SpaceGroup::ID(std::string const& sgIn) {
  MapType::const_iterator it = IdMap_.find(sgIn);
  if (it == IdMap_.end())
    sgID_ = -1;
  else
    sgID_ = it->second;
  return sgID_;
}

//---------------------------------------------------------------------------------------------
/** LoadSpaceGroupSymOps: function for creating a list of symmetry operations based on the space
  *                       group specified in an xtalsymm command.  This code was created by a
  *                       python script and should not be edited by hand.
  */
// NOTE: RefT was being passed here but had nothing done to it.
// FIXME: To avoid massive recode, pass in R, T, and RefT; these were renamed to follow
//        existing cpptraj Class variable naming conventions.
int SpaceGroup::LoadSymmOps(int nCopyA_, int nCopyB_, int nCopyC_, std::vector<Matrix_3x3>& R, std::vector<Vec3>& T)
const
{
  int i, j, k;

  double dnA = (double)nCopyA_;
  double dnB = (double)nCopyB_;
  double dnC = (double)nCopyC_;
  double Rdata[9];
  int nops_ = 0;

  // Loop over all unit cell replicas, then all possible space groups to find a match.
  // The giant branch over space groups goes in the nest loops to cut down on the
  // sheer amount of code.  Writing the same loops for every case would make the file
  // even longer, even though the computer will now have to evaluate the switch for
  // each replica of the unit cell during setup.
  for (i = 0; i < nCopyA_; i++) {
    double di = (double)i;
    for (j = 0; j < nCopyB_; j++) {
      double dj = (double)j;
      for (k = 0; k < nCopyC_; k++) {
        double dk = (double)k;
        int iuc = (i*nCopyB_ + j)*nCopyC_ + k;
        switch (sgID_) {
          case 0 :
          nops_ = 1 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 1;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 1 :
          nops_ = 2 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 2;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 2 :
          nops_ = 2 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 2;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 3 :
          nops_ = 2 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 2;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 4 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 5 :
          nops_ = 2 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 2;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 6 :
          nops_ = 2 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 2;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 7 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 8 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 9 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 10 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 11 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 12 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 13 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 14 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 15 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 16 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 17 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 18 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 19 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 20 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 21 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 22 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 23 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 24 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 25 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 26 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 27 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 28 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 29 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 30 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 31 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 32 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 33 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 34 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 35 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 36 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 37 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 38 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 39 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 40 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 41 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 42 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 43 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 44 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.2500000000 + di) / dnA, (  0.2500000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.2500000000 + di) / dnA, (  0.2500000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.2500000000 + di) / dnA, (  0.7500000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.2500000000 + di) / dnA, (  0.7500000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.7500000000 + di) / dnA, (  0.2500000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.7500000000 + di) / dnA, (  0.2500000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.7500000000 + di) / dnA, (  0.7500000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.7500000000 + di) / dnA, (  0.7500000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          break;
          case 45 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 46 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 47 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 48 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 49 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 50 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 51 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 52 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 53 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 54 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 55 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 56 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 57 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 58 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 59 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 60 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 61 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 62 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 63 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 64 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 65 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 66 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 67 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 68 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 69 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 70 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 71 :
          nops_ = 32 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 32;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 18 + iuc] = Matrix_3x3(Rdata);
          T[ 18 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 19 + iuc] = Matrix_3x3(Rdata);
          T[ 19 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 20 + iuc] = Matrix_3x3(Rdata);
          T[ 20 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 21 + iuc] = Matrix_3x3(Rdata);
          T[ 21 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 22 + iuc] = Matrix_3x3(Rdata);
          T[ 22 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 23 + iuc] = Matrix_3x3(Rdata);
          T[ 23 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 24 + iuc] = Matrix_3x3(Rdata);
          T[ 24 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 25 + iuc] = Matrix_3x3(Rdata);
          T[ 25 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 26 + iuc] = Matrix_3x3(Rdata);
          T[ 26 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 27 + iuc] = Matrix_3x3(Rdata);
          T[ 27 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 28 + iuc] = Matrix_3x3(Rdata);
          T[ 28 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 29 + iuc] = Matrix_3x3(Rdata);
          T[ 29 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 30 + iuc] = Matrix_3x3(Rdata);
          T[ 30 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 31 + iuc] = Matrix_3x3(Rdata);
          T[ 31 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 72 :
          nops_ = 32 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 32;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.2500000000 + di) / dnA, (  0.2500000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.2500000000 + di) / dnA, (  0.2500000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.2500000000 + di) / dnA, (  0.2500000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.2500000000 + di) / dnA, (  0.2500000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.2500000000 + di) / dnA, (  0.7500000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.2500000000 + di) / dnA, (  0.7500000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.2500000000 + di) / dnA, (  0.7500000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.2500000000 + di) / dnA, (  0.7500000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 18 + iuc] = Matrix_3x3(Rdata);
          T[ 18 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 19 + iuc] = Matrix_3x3(Rdata);
          T[ 19 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 20 + iuc] = Matrix_3x3(Rdata);
          T[ 20 + iuc] = Vec3((  0.7500000000 + di) / dnA, (  0.2500000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 21 + iuc] = Matrix_3x3(Rdata);
          T[ 21 + iuc] = Vec3((  0.7500000000 + di) / dnA, (  0.2500000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 22 + iuc] = Matrix_3x3(Rdata);
          T[ 22 + iuc] = Vec3((  0.7500000000 + di) / dnA, (  0.2500000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 23 + iuc] = Matrix_3x3(Rdata);
          T[ 23 + iuc] = Vec3((  0.7500000000 + di) / dnA, (  0.2500000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 24 + iuc] = Matrix_3x3(Rdata);
          T[ 24 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 25 + iuc] = Matrix_3x3(Rdata);
          T[ 25 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 26 + iuc] = Matrix_3x3(Rdata);
          T[ 26 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 27 + iuc] = Matrix_3x3(Rdata);
          T[ 27 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 28 + iuc] = Matrix_3x3(Rdata);
          T[ 28 + iuc] = Vec3((  0.7500000000 + di) / dnA, (  0.7500000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 29 + iuc] = Matrix_3x3(Rdata);
          T[ 29 + iuc] = Vec3((  0.7500000000 + di) / dnA, (  0.7500000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 30 + iuc] = Matrix_3x3(Rdata);
          T[ 30 + iuc] = Vec3((  0.7500000000 + di) / dnA, (  0.7500000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 31 + iuc] = Matrix_3x3(Rdata);
          T[ 31 + iuc] = Vec3((  0.7500000000 + di) / dnA, (  0.7500000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          break;
          case 73 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 74 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 75 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 76 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 77 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 78 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          break;
          case 79 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 80 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          break;
          case 81 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 82 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          break;
          case 83 :
          nops_ = 4 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 4;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 84 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 85 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 86 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 87 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 88 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 89 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 90 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 91 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 92 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 93 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          break;
          case 94 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 95 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 96 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 97 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          break;
          case 98 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 99 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 100 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 101 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 102 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 103 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 104 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 105 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 106 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 107 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 108 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 109 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 110 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 111 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          break;
          case 112 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          break;
          case 113 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 114 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 115 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 116 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 117 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 118 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 119 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 120 :
          nops_ = 8 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 8;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 121 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 122 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 123 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 124 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          break;
          case 125 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 126 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 127 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 128 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 129 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 130 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 131 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 132 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 133 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 134 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 135 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 136 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 137 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 138 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 139 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 140 :
          nops_ = 16 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 16;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 141 :
          nops_ = 32 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 32;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 18 + iuc] = Matrix_3x3(Rdata);
          T[ 18 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 19 + iuc] = Matrix_3x3(Rdata);
          T[ 19 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 20 + iuc] = Matrix_3x3(Rdata);
          T[ 20 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 21 + iuc] = Matrix_3x3(Rdata);
          T[ 21 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 22 + iuc] = Matrix_3x3(Rdata);
          T[ 22 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 23 + iuc] = Matrix_3x3(Rdata);
          T[ 23 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 24 + iuc] = Matrix_3x3(Rdata);
          T[ 24 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 25 + iuc] = Matrix_3x3(Rdata);
          T[ 25 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 26 + iuc] = Matrix_3x3(Rdata);
          T[ 26 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 27 + iuc] = Matrix_3x3(Rdata);
          T[ 27 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 28 + iuc] = Matrix_3x3(Rdata);
          T[ 28 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 29 + iuc] = Matrix_3x3(Rdata);
          T[ 29 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 30 + iuc] = Matrix_3x3(Rdata);
          T[ 30 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 31 + iuc] = Matrix_3x3(Rdata);
          T[ 31 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 142 :
          nops_ = 32 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 32;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 18 + iuc] = Matrix_3x3(Rdata);
          T[ 18 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 19 + iuc] = Matrix_3x3(Rdata);
          T[ 19 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 20 + iuc] = Matrix_3x3(Rdata);
          T[ 20 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 21 + iuc] = Matrix_3x3(Rdata);
          T[ 21 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 22 + iuc] = Matrix_3x3(Rdata);
          T[ 22 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 23 + iuc] = Matrix_3x3(Rdata);
          T[ 23 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 24 + iuc] = Matrix_3x3(Rdata);
          T[ 24 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 25 + iuc] = Matrix_3x3(Rdata);
          T[ 25 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 26 + iuc] = Matrix_3x3(Rdata);
          T[ 26 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 27 + iuc] = Matrix_3x3(Rdata);
          T[ 27 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 28 + iuc] = Matrix_3x3(Rdata);
          T[ 28 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 29 + iuc] = Matrix_3x3(Rdata);
          T[ 29 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 30 + iuc] = Matrix_3x3(Rdata);
          T[ 30 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 31 + iuc] = Matrix_3x3(Rdata);
          T[ 31 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 143 :
          nops_ = 32 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 32;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 18 + iuc] = Matrix_3x3(Rdata);
          T[ 18 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 19 + iuc] = Matrix_3x3(Rdata);
          T[ 19 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 20 + iuc] = Matrix_3x3(Rdata);
          T[ 20 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 21 + iuc] = Matrix_3x3(Rdata);
          T[ 21 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 22 + iuc] = Matrix_3x3(Rdata);
          T[ 22 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 23 + iuc] = Matrix_3x3(Rdata);
          T[ 23 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 24 + iuc] = Matrix_3x3(Rdata);
          T[ 24 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 25 + iuc] = Matrix_3x3(Rdata);
          T[ 25 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 26 + iuc] = Matrix_3x3(Rdata);
          T[ 26 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 27 + iuc] = Matrix_3x3(Rdata);
          T[ 27 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 28 + iuc] = Matrix_3x3(Rdata);
          T[ 28 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 29 + iuc] = Matrix_3x3(Rdata);
          T[ 29 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 30 + iuc] = Matrix_3x3(Rdata);
          T[ 30 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 31 + iuc] = Matrix_3x3(Rdata);
          T[ 31 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          break;
          case 144 :
          nops_ = 32 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 32;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 18 + iuc] = Matrix_3x3(Rdata);
          T[ 18 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 19 + iuc] = Matrix_3x3(Rdata);
          T[ 19 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 20 + iuc] = Matrix_3x3(Rdata);
          T[ 20 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 21 + iuc] = Matrix_3x3(Rdata);
          T[ 21 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 22 + iuc] = Matrix_3x3(Rdata);
          T[ 22 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 23 + iuc] = Matrix_3x3(Rdata);
          T[ 23 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 24 + iuc] = Matrix_3x3(Rdata);
          T[ 24 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 25 + iuc] = Matrix_3x3(Rdata);
          T[ 25 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 26 + iuc] = Matrix_3x3(Rdata);
          T[ 26 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 27 + iuc] = Matrix_3x3(Rdata);
          T[ 27 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 28 + iuc] = Matrix_3x3(Rdata);
          T[ 28 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 29 + iuc] = Matrix_3x3(Rdata);
          T[ 29 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 30 + iuc] = Matrix_3x3(Rdata);
          T[ 30 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.5000000000 + dj) / dnB, 
                              (  0.7500000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 31 + iuc] = Matrix_3x3(Rdata);
          T[ 31 + iuc] = Vec3((  0.5000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.2500000000 + dk) / dnC);
          break;
          case 145 :
          nops_ = 3 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 3;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 146 :
          nops_ = 3 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 3;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          break;
          case 147 :
          nops_ = 3 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 3;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          break;
          case 148 :
          nops_ = 9 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 9;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          break;
          case 149 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 150 :
          nops_ = 18 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 18;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          break;
          case 151 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 152 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 153 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 154 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          break;
          case 155 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 156 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          break;
          case 157 :
          nops_ = 18 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 18;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          break;
          case 158 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 159 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 160 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 161 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 162 :
          nops_ = 18 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 18;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          break;
          case 163 :
          nops_ = 18 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 18;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          break;
          case 164 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 165 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 166 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 167 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 168 :
          nops_ = 36 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 36;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 18 + iuc] = Matrix_3x3(Rdata);
          T[ 18 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 19 + iuc] = Matrix_3x3(Rdata);
          T[ 19 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 20 + iuc] = Matrix_3x3(Rdata);
          T[ 20 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 21 + iuc] = Matrix_3x3(Rdata);
          T[ 21 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 22 + iuc] = Matrix_3x3(Rdata);
          T[ 22 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 23 + iuc] = Matrix_3x3(Rdata);
          T[ 23 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 24 + iuc] = Matrix_3x3(Rdata);
          T[ 24 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 25 + iuc] = Matrix_3x3(Rdata);
          T[ 25 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 26 + iuc] = Matrix_3x3(Rdata);
          T[ 26 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 27 + iuc] = Matrix_3x3(Rdata);
          T[ 27 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 28 + iuc] = Matrix_3x3(Rdata);
          T[ 28 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 29 + iuc] = Matrix_3x3(Rdata);
          T[ 29 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 30 + iuc] = Matrix_3x3(Rdata);
          T[ 30 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 31 + iuc] = Matrix_3x3(Rdata);
          T[ 31 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.3333333333;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 32 + iuc] = Matrix_3x3(Rdata);
          T[ 32 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 33 + iuc] = Matrix_3x3(Rdata);
          T[ 33 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 34 + iuc] = Matrix_3x3(Rdata);
          T[ 34 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 35 + iuc] = Matrix_3x3(Rdata);
          T[ 35 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          break;
          case 169 :
          nops_ = 36 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 36;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 18 + iuc] = Matrix_3x3(Rdata);
          T[ 18 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 19 + iuc] = Matrix_3x3(Rdata);
          T[ 19 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 20 + iuc] = Matrix_3x3(Rdata);
          T[ 20 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 21 + iuc] = Matrix_3x3(Rdata);
          T[ 21 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 22 + iuc] = Matrix_3x3(Rdata);
          T[ 22 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 23 + iuc] = Matrix_3x3(Rdata);
          T[ 23 + iuc] = Vec3((  0.6666666667 + di) / dnA, (  0.3333333333 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 24 + iuc] = Matrix_3x3(Rdata);
          T[ 24 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 25 + iuc] = Matrix_3x3(Rdata);
          T[ 25 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 26 + iuc] = Matrix_3x3(Rdata);
          T[ 26 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 27 + iuc] = Matrix_3x3(Rdata);
          T[ 27 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 28 + iuc] = Matrix_3x3(Rdata);
          T[ 28 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 29 + iuc] = Matrix_3x3(Rdata);
          T[ 29 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 30 + iuc] = Matrix_3x3(Rdata);
          T[ 30 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 31 + iuc] = Matrix_3x3(Rdata);
          T[ 31 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 32 + iuc] = Matrix_3x3(Rdata);
          T[ 32 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 33 + iuc] = Matrix_3x3(Rdata);
          T[ 33 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 34 + iuc] = Matrix_3x3(Rdata);
          T[ 34 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 35 + iuc] = Matrix_3x3(Rdata);
          T[ 35 + iuc] = Vec3((  0.3333333333 + di) / dnA, (  0.6666666667 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          break;
          case 170 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 171 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          break;
          case 172 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          break;
          case 173 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          break;
          case 174 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          break;
          case 175 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 176 :
          nops_ = 6 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 6;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 177 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 178 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 179 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 180 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          break;
          case 181 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.1666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.8333333333 + dk) / dnC);
          break;
          case 182 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          break;
          case 183 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.3333333333 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.6666666667 + dk) / dnC);
          break;
          case 184 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 185 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 186 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 187 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 188 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 189 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 190 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 191 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 192 :
          nops_ = 12 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 12;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 193 :
          nops_ = 24 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 24;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 18 + iuc] = Matrix_3x3(Rdata);
          T[ 18 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 19 + iuc] = Matrix_3x3(Rdata);
          T[ 19 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 20 + iuc] = Matrix_3x3(Rdata);
          T[ 20 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 21 + iuc] = Matrix_3x3(Rdata);
          T[ 21 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 22 + iuc] = Matrix_3x3(Rdata);
          T[ 22 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 23 + iuc] = Matrix_3x3(Rdata);
          T[ 23 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          break;
          case 194 :
          nops_ = 24 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 24;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 15 + iuc] = Matrix_3x3(Rdata);
          T[ 15 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 16 + iuc] = Matrix_3x3(Rdata);
          T[ 16 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 17 + iuc] = Matrix_3x3(Rdata);
          T[ 17 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 18 + iuc] = Matrix_3x3(Rdata);
          T[ 18 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 19 + iuc] = Matrix_3x3(Rdata);
          T[ 19 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 20 + iuc] = Matrix_3x3(Rdata);
          T[ 20 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 21 + iuc] = Matrix_3x3(Rdata);
          T[ 21 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 22 + iuc] = Matrix_3x3(Rdata);
          T[ 22 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[ 23 + iuc] = Matrix_3x3(Rdata);
          T[ 23 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          break;
          case 195 :
          nops_ = 24 * nCopyA_ * nCopyB_ * nCopyC_;
          iuc *= 24;
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  0 + iuc] = Matrix_3x3(Rdata);
          T[  0 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  1 + iuc] = Matrix_3x3(Rdata);
          T[  1 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  2 + iuc] = Matrix_3x3(Rdata);
          T[  2 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  3 + iuc] = Matrix_3x3(Rdata);
          T[  3 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  4 + iuc] = Matrix_3x3(Rdata);
          T[  4 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =   1.0000000000;
          R[  5 + iuc] = Matrix_3x3(Rdata);
          T[  5 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  6 + iuc] = Matrix_3x3(Rdata);
          T[  6 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  7 + iuc] = Matrix_3x3(Rdata);
          T[  7 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  8 + iuc] = Matrix_3x3(Rdata);
          T[  8 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.5000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[  9 + iuc] = Matrix_3x3(Rdata);
          T[  9 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 10 + iuc] = Matrix_3x3(Rdata);
          T[ 10 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 11 + iuc] = Matrix_3x3(Rdata);
          T[ 11 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =  -1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =  -1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 12 + iuc] = Matrix_3x3(Rdata);
          T[ 12 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   0.0000000000;  Rdata[1] =   1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =  -1.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 13 + iuc] = Matrix_3x3(Rdata);
          T[ 13 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =  -1.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   1.0000000000;  Rdata[4] =   0.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
          R[ 14 + iuc] = Matrix_3x3(Rdata);
          T[ 14 + iuc] = Vec3((  0.0000000000 + di) / dnA, (  0.0000000000 + dj) / dnB, 
                              (  0.0000000000 + dk) / dnC);
          Rdata[0] =   1.0000000000;  Rdata[1] =   0.0000000000;  Rdata[2] =   0.0000000000;
          Rdata[3] =   0.0000000000;  Rdata[4] =   1.0000000000;  Rdata[5] =   0.0000000000;
          Rdata[6] =   0.0000000000;  Rdata[7] =   0.0000000000;  Rdata[8] =  -1.0000000000;
       