//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_20.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot20(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[20] = {3.046323927948253e-02,2.744447157928503e-01,7.638875584439140e-01,1.501801497668106e+00,2.492830145121370e+00,
    3.743418041216293e+00,5.262055853788349e+00,7.059627735741558e+00,9.149898312030656e+00,1.155019828644284e+01,1.428240368521040e+01,1.737436697519908e+01,
    2.086207518543782e+01,2.479303989246347e+01,2.923191015709341e+01,3.427042892503958e+01,4.004681579024558e+01,4.678884639212502e+01,5.493155562102061e+01,
    6.558993199063974e+01};
  constexpr double aw[20] = {3.386432774255900e-01,2.657282518773771e-01,1.633787327132713e-01,7.847460586540446e-02,2.931256553617237e-02,
    8.460888008258097e-03,1.871496829597982e-03,3.138535945413305e-04,3.936933981092488e-05,3.631576150693002e-06,2.411144163670552e-07,1.121236083227565e-08,
    3.525620791365528e-10,7.156528052690270e-12,8.805707645216158e-14,6.008358789490948e-16,1.989181012116456e-18,2.567593365411567e-21,8.544056963775383e-25,
    2.591043713847118e-29};
  constexpr double x[7680] = {  2.934473439558871e-03, -3.573508586948995e-05,  3.258966628330927e-07, -2.636853771472591e-09,  1.995245283177864e-11,
 -1.445121416712311e-13,  1.014041035772519e-15, -6.942155136312800e-18,  4.656450777409809e-20, -3.068293222095214e-22,  1.989317669239406e-24, -1.270123387830068e-26,
  2.631182300747988e-02, -3.167555042529075e-04,  2.822346969331323e-06, -2.195225182029967e-08,  1.562821147471952e-10, -1.035103707819503e-12,  6.391061886037619e-15,
 -3.644088687692954e-17,  1.867748931170394e-19, -8.009152604268712e-22,  2.156261145231332e-24,  6.521801961979763e-27,  7.254344219992115e-02, -8.533351418241553e-04,
  7.249222500813396e-06, -5.182189381228240e-08,  3.203084045229669e-10, -1.667213145613742e-12,  6.450108049521799e-15, -6.656963146613252e-18, -1.900421252577641e-19,
  2.475263530116717e-21, -2.047196373032090e-23,  1.288670797830215e-25,  1.405924061802417e-01, -1.596725621668213e-03,  1.258729029610686e-05, -7.796073819839351e-08,
  3.605501930860687e-10, -7.970595057721558e-13, -6.106592433349008e-15,  9.806157489554087e-17, -7.754644068481066e-19,  3.833548181550327e-21, -4.564555164178722e-24,
 -1.412706625508135e-25,  2.289264457053848e-01, -2.479080471851045e-03,  1.756873841308021e-05, -8.592054347302009e-08,  1.779250681885691e-10,  1.664731024052931e-12,
 -2.303875988221041e-14,  1.437928050823580e-16, -2.846024722649175e-19, -4.478040082951160e-21,  6.015468405458794e-23, -3.718453486093138e-25,  3.355457605912585e-01,
 -3.419348091589434e-03,  2.093508408272885e-05, -6.670658043851742e-08, -2.031891343032924e-10,  4.268775705490904e-12, -2.547476897192649e-14,  4.419853906040569e-18,
  1.278628221458946e-18, -1.134864983492833e-20,  2.853208087310690e-23,  3.982820850127060e-25,  4.580201842016599e-01, -4.330419243103609e-03,  2.169882240568456e-05,
 -2.064380751193628e-08, -6.304679373377563e-10,  4.931539698164107e-12, -3.220351554411846e-15, -2.301492098195978e-16,  1.796889151577572e-18,  1.459166394117207e-22,
 -1.065164364592331e-22,  7.762158833198452e-25,  5.935356872526737e-01, -5.126963828903768e-03,  1.935697171716201e-05,  4.197094829912654e-08, -8.931992924233645e-10,
  2.536126602074824e-12,  3.088389990860156e-14, -2.963407756369455e-16, -1.495749541360346e-19,  1.823656745931690e-20, -9.182378856794024e-23, -6.281376771467291e-25,
  7.389501058275925e-01, -5.733307484965813e-03,  1.401199772051123e-05,  1.038187695145865e-07, -8.323788245141712e-10, -1.989357249475408e-12,  4.848256535071439e-14,
 -5.773553909315848e-17, -2.596538170834189e-18,  1.275036597637289e-20,  1.161210048878539e-22, -1.246028095622106e-24,  8.908578092525610e-01, -6.090656093527580e-03,
  6.371932152808107e-06,  1.462276063396736e-07, -4.327497095023023e-10, -6.044461813940803e-12,  3.094470346392429e-14,  2.878344362585020e-16, -2.259538053418823e-18,
 -1.409962822993391e-20,  1.660391859733398e-22,  6.531051917149988e-25,  1.045662779033452e+00, -6.162985771071566e-03, -2.375474827477733e-06,  1.556434806777785e-07,
  1.559906815670427e-10, -7.051596178887207e-12, -1.123287390807692e-14,  3.872973086703564e-16,  8.462198208614428e-19, -2.348833490846303e-20, -6.552695637927127e-23,
  1.512340337950540e-24,  1.199659246273550e+00, -5.940985708828963e-03, -1.079391367060282e-05,  1.285793863514090e-07,  6.856666171771530e-10, -4.290738556923933e-12,
 -4.528442012191896e-14,  1.273920778146060e-16,  2.978248071681137e-18, -2.766109257589789e-22, -1.902550097733271e-22, -4.770451944233656e-25,  1.349118635934010e+00,
 -5.443576225252587e-03, -1.749074370992500e-05,  7.314049790835666e-08,  9.324039562842103e-10,  5.181016293892489e-13, -4.485698886122028e-14, -2.237774315000522e-16,
  1.600773976365958e-18,  2.080161297485002e-20, -4.763997417029864e-24, -1.364582496944629e-24,  1.490381107328019e+00, -4.716723128293473e-03, -2.140999922193228e-05,
  6.395518693360931e-09,  8.104685549711417e-10,  4.394407322297091e-12, -1.355184910260028e-14, -3.175909931478530e-16, -1.236099654084996e-18,  1.081271715999313e-20,
  1.458613475799455e-22,  2.801316277893769e-25,  1.619949490737613e+00, -3.829521982387419e-03, -2.206182142525305e-05, -5.159666666782677e-08,  4.134082608285004e-10,
  5.197027438078042e-12,  1.979975536754794e-14, -1.122502854601400e-16, -1.971531895482357e-18, -9.620353840962783e-21,  3.682626650638299e-23,  8.892017212000445e-25,
  1.734582945314849e+00, -2.867811942355601e-03, -1.963422474013175e-05, -8.495906067348616e-08, -4.232882902098213e-11,  3.049900873192624e-12,  2.922017430426643e-14,
  1.203443083884603e-16, -3.770141217888608e-19, -1.011234866552997e-20, -7.721201949135091e-23, -1.777978787460587e-25,  1.831387268015902e+00, -1.925868085608779e-03,
 -1.495686320428023e-05, -8.764249944763976e-08, -3.401949364488078e-10,  6.218176131561652e-15,  1.443946800095235e-14,  1.490533649122176e-16,  8.768463461242680e-19,
  1.896483564986078e-21, -2.519745604308039e-23, -3.802491310021080e-25,  1.907898578170674e+00, -1.096975166807336e-03, -9.319332729654347e-06, -6.530273966233482e-08,
 -3.815835463287866e-10, -1.721934121317394e-12, -3.823010092177115e-15,  2.976294588683198e-17,  5.086002268952774e-19,  4.505168792657557e-21,  2.844637390554878e-23,
  1.152539326945384e-25,  1.962157539131169e+00, -4.638592238583345e-04, -4.181107153241151e-06, -3.259332829157814e-08, -2.295099168451190e-10, -1.474250221848810e-12,
 -8.548895536089896e-15, -4.304217136632533e-17, -1.661791925479128e-19, -1.998669135235227e-22,  4.721078812991704e-24,  6.678738668189775e-26,  1.992778849535578e+00,
 -8.993043346999696e-05, -8.369507301777290e-07, -6.890120340497465e-09, -5.285028670692409e-11, -3.862387777353067e-13, -2.719404042515935e-15, -1.855258879114653e-17,
 -1.229793139534898e-19, -7.925615907517535e-22, -4.960242538169711e-24, -3.005114058264622e-26,  2.796554424375075e-03, -3.324926586443422e-05,  2.960785847813677e-07,
 -2.339477344862315e-09,  1.729066384176346e-11, -1.223490268538650e-13,  8.389645082761250e-16, -5.614496220301198e-18,  3.682591125497444e-20, -2.373911918824993e-22,
  1.506447771939385e-24, -9.419788227601125e-27,  2.508834817498619e-02, -2.951894487371390e-04,  2.573265938519157e-06, -1.960935573456499e-08,  1.370346271123215e-10,
 -8.933130175752166e-13,  5.450178939023646e-15, -3.090833956727164e-17,  1.595442016132399e-19, -7.110030807885745e-22,  2.294602326789266e-24,  3.516599266608187e-28,
  6.924227045443627e-02, -7.977441687146212e-04,  6.657036065750774e-06, -4.695537723888231e-08,  2.884938477213935e-10, -1.515257531976097e-12,  6.190905412532398e-15,
 -1.145999601990393e-17, -1.143793320561769e-19,  1.761768279181653e-21, -1.539597464411538e-23,  1.023689203428089e-25,  1.344011121164147e-01, -1.499672603910344e-03,
  1.168582483561081e-05, -7.232654291037429e-08,  3.433518682091278e-10, -9.133471289351198e-13, -3.687843701796350e-15,  7.540888987936986e-17, -6.420233702875612e-19,
  3.550132845665098e-21, -9.079643644283218e-24, -6.884535796134285e-26,  2.192847650929533e-01, -2.342604013092901e-03,  1.655577779662558e-05, -8.283607931949079e-08,
  2.060106155684230e-10,  1.158952909554632e-12, -1.916117028015247e-14,  1.325391001803525e-16, -4.063597517457507e-19, -2.389432539075286e-21,  4.456713997185921e-23,
 -3.321880591059796e-25,  3.221981901288806e-01, -3.255118328986156e-03,  2.011780905194464e-05, -6.930770106479745e-08, -1.238952162613259e-10,  3.663120983539448e-12,
 -2.483785866038090e-14,  3.904941282863040e-17,  8.941993944610357e-19, -9.926702140779658e-21,  4.095191153728287e-23,  1.768487347391281e-25,  4.410438871944166e-01,
 -4.157983595643763e-03,  2.139380730133675e-05, -2.994852183143817e-08, -5.330985070144193e-10,  4.783395792725699e-12, -8.864207509689316e-15, -1.733199286402527e-16,
  1.733714200131311e-18, -3.429749370743549e-21, -7.242816952693621e-23,  7.548987816328349e-25,  5.733403956829725e-01, -4.970332297314378e-03,  1.977667254642260e-05,
  2.812298909754826e-08, -8.357370425278496e-10,  3.177808920364302e-12,  2.261271652120874e-14, -2.913779957726105e-16,  4.353581484799806e-19,  1.414082278143141e-20,
 -1.098545634661474e-22, -2.022391168373784e-25,  7.162486349708855e-01, -5.616457225779112e-03,  1.517680450609756e-05,  9.024491958996669e-08, -8.607077142761583e-10,
 -8.541104178384893e-13,  4.577748681818332e-14, -1.326931813379270e-16, -2.067392801937845e-18,  1.627312328244503e-20,  5.978602988343044e-23, -1.278412184760675e-24,
  8.666080711480836e-01, -6.032788331552510e-03,  8.081267943508023e-06,  1.383794366312940e-07, -5.456034541157685e-10, -5.213669032179838e-12,  3.792490058237984e-14,
  2.087354325333588e-16, -2.642239889529475e-18, -7.058110480241729e-21,  1.816908261201064e-22,  5.832941889907689e-26,  1.020984702928147e+00, -6.174487048251007e-03,
 -4.974692702952828e-07,  1.570001604911203e-07,  1.315370190280446e-11, -7.188789436253001e-12, -1.393963762124384e-16,  4.004749183299692e-16, -2.998244525898659e-20,
 -2.472519182558826e-20,  4.520118468990812e-24,  1.626705240130045e-24,  1.175732627075208e+00, -6.020985605095287e-03, -9.188156429145547e-06,  1.388058890585696e-07,
  5.893279349179531e-10, -5.324054100202145e-12, -4.039534352769807e-14,  2.210370310349973e-16,  2.827805400299129e-18, -8.133804519720494e-21, -1.981184892285091e-22,
  1.371350130373243e-25,  1.327070396401806e+00, -5.579737419793169e-03, -1.652340003500301e-05,  8.808134655988013e-08,  9.315256214529917e-10, -6.271792871468398e-13,
 -5.029399737757846e-14, -1.607297826789677e-16,  2.331043423984077e-18,  1.933729803937484e-20, -6.990325952875047e-23, -1.562408025235014e-24,  1.471172460749736e+00,
 -4.887469140356828e-03, -2.125261339441487e-05,  2.004535025666137e-08,  8.943625354895831e-10,  3.958383038648466e-12, -2.293151683786301e-14, -3.497747888095433e-16,
 -7.399133865845146e-19,  1.677466714694645e-20,  1.489941389041832e-22, -1.645488617014854e-25,  1.604274661686406e+00, -4.008372685357538e-03, -2.263778379727699e-05,
 -4.412599208910897e-08,  5.218080086265469e-10,  5.627068538895902e-12,  1.572392698540880e-14, -1.805155291935058e-16, -2.281274631091676e-18, -7.294605612021551e-21,
  8.109514630925634e-23,  1.112385617817218e-24,  1.722791083237340e+00, -3.028970399655116e-03, -2.065565761368313e-05, -8.510911805981126e-08,  2.594641941301127e-11,
  3.789899441756458e-12,  3.236185908893670e-14,  1.018464256356455e-16, -7.981231700632147e-19, -1.331037218614993e-20, -8.133377733151170e-23,  8.750187059445537e-27,
  1.823437694572812e+00, -2.049822225177299e-03, -1.604116279913196e-05, -9.306431769131834e-08, -3.362504214416651e-10,  4.060732890815808e-13,  1.901446454319474e-14,
  1.779750819162997e-16,  9.225645223345027e-19,  5.117941149067540e-22, -4.512245788024119e-23, -5.291011251436776e-25,  1.903356455153802e+00, -1.174770799053358e-03,
 -1.014074939277233e-05, -7.168825263920340e-08, -4.168620787824769e-10, -1.801688960003829e-12, -2.735790065147816e-15,  4.886255204511491e-17,  6.924724223134106e-19,
  5.742242218154205e-21,  3.331418084002410e-23,  1.022519055942352e-25,  1.960232636248361e+00, -4.989373029047287e-04, -4.595270306234080e-06, -3.651293539995536e-08,
 -2.611474043910434e-10, -1.694491981116792e-12, -9.829310439212405e-15, -4.843227739289669e-17, -1.691812507369947e-19,  5.735104646087277e-23,  8.401226878748261e-24,
  1.027539495215108e-25,  1.992405191842207e+00, -9.697175139805999e-05, -9.249727087579938e-07, -7.801254207903677e-09, -6.127221181607679e-11, -4.582106375118577e-13,
 -3.298549357832692e-15, -2.298547766844417e-17, -1.554255144439826e-19, -1.020084136777686e-21, -6.486809689611132e-24, -3.980199560825948e-26,  2.668123221064153e-03,
 -3.098840815695785e-05,  2.695874133103904e-07, -2.081359709429210e-09,  1.503295725483155e-11, -1.039746868842557e-13,  6.970503107105306e-16, -4.561938789398139e-18,
  2.927159441166429e-20, -1.846638247614609e-22,  1.147313761393852e-24, -7.027762137038276e-27,  2.394732321154771e-02, -2.755086099672710e-04,  2.350541649221092e-06,
 -1.755290891500105e-08,  1.204091930967092e-10, -7.723400313838105e-13,  4.652499397490597e-15, -2.619479011714287e-17,  1.355932087484813e-19, -6.200539180158858e-22,
  2.228661019640892e-24, -2.987420558246082e-27,  6.615434555839694e-02, -7.466655192809810e-04,  6.120292714225561e-06, -4.257395976955284e-08,  2.596466194768147e-10,
 -1.370885392113389e-12,  5.827519807188809e-15, -1.421582858612360e-17, -6.101970915088463e-20,  1.228990755243003e-21, -1.140959785052336e-23,  7.948710312905157e-26,
  1.285840280624448e-01, -1.409565703708385e-03,  1.085025157771646e-05, -6.698317989597631e-08,  3.243593639467585e-10, -9.787240905859847e-13, -1.845337278039977e-15,
  5.683394998988564e-17, -5.213431868061239e-19,  3.141717775153145e-21, -1.100179976403873e-23, -2.214374217683092e-26,  2.101730271769359e-01, -2.214076282211034e-03,
  1.558220921800305e-05, -7.937822873744378e-08,  2.248837028065434e-10,  7.420806919428666e-13, -1.564276421504936e-14,  1.184756947067508e-16, -4.636678613345193e-19,
 -8.829174473834689e-22,  3.117696629676570e-23, -2.749748810048340e-25,  3.094942938750627e-01, -3.097530966135426e-03,  1.927653658993229e-05, -7.073588792706808e-08,
 -5.648996680821690e-11,  3.083047822959538e-12, -2.339527043936476e-14,  6.227425181503615e-17,  5.677279542313019e-19, -8.183805486449148e-21,  4.504985828517124e-23,
  1.979815275199958e-26,  4.247517824130538e-01, -3.988408481150197e-03,  2.098636294105139e-05, -3.772585240540362e-08, -4.399192427396223e-10,  4.518555930591468e-12,
 -1.296264083310589e-14, -1.203123047138066e-16,  1.565862912861701e-18, -5.689561964919527e-21, -4.134845006705699e-23,  6.477229392839782e-25,  5.537773162716255e-01,
 -4.810991325734031e-03,  2.003610303090963e-05,  1.528639295455026e-08, -7.674046368726142e-10,  3.624625116012957e-12,  1.471958837245058e-14, -2.701603582011026e-16,
  8.641752011617910e-19,  9.675637559725516e-21, -1.109462058238527e-22,  1.349219297566958e-25,  6.940321618106251e-01, -5.490946063302597e-03,  1.617674149186549e-05,
  7.639524167508978e-08, -8.671405609072286e-10,  1.930437830850409e-13,  4.122661810441626e-14, -1.891230459917962e-16, -1.451772716143315e-18,  1.757471497972245e-20,
  6.463606680749064e-24, -1.118908975587803e-24,  8.426165154021570e-01, -5.961651973504246e-03,  9.686167434968757e-06,  1.288668611437422e-07, -6.403516386419061e-10,
 -4.243075347928423e-12,  4.255755038287684e-14,  1.215158803731858e-16, -2.766421554734773e-18,  9.461843899790656e-23,  1.720103444100348e-22, -4.805151000574255e-25,
  9.962907179052420e-01, -6.170938126160157e-03,  1.383060610690196e-06,  1.560640317162395e-07, -1.297512996028915e-10, -7.058501557992362e-12,  1.092771042234501e-14,
  3.854474026837477e-16, -8.998001800976215e-19, -2.314032948579045e-20,  7.355976246757679e-23,  1.467611601907682e-24,  1.151512438614563e+00, -6.087676300266337e-03,
 -7.469588600494102e-06,  1.473328960733906e-07,  4.737047827654100e-10, -6.209373295735981e-12, -3.299424873970506e-14,  3.053357300602063e-16,  2.395573212480530e-18,
 -1.574280748917243e-20, -1.775184394737753e-22,  7.957948003589457e-25,  1.304494122408149e+00, -5.707444726825384e-03, -1.537762759509704e-05,  1.028184539671916e-07,
  9.065931522620589e-10, -1.879190782586582e-12, -5.365010084339028e-14, -7.567297665786088e-17,  2.960196816534503e-18,  1.516007034717810e-20, -1.386167040841079e-22,
 -1.514690883063528e-24,  1.451284416923347e+00, -5.056278798324959e-03, -2.092370391566484e-05,  3.495521896673521e-08,  9.672220314709786e-10,  3.288425367840207e-12,
 -3.295783610812491e-14, -3.626633666981823e-16, -3.196993093855690e-20,  2.242587316655109e-20,  1.293053268537127e-22, -7.482635656335593e-25,  1.587875824636415e+00,
 -4.191442394365123e-03, -2.311342690955277e-05, -3.485809877110773e-08,  6.376701398383013e-10,  5.935322640282691e-12,  9.613035171551556e-15, -2.569933225040028e-16,
 -2.473266252887925e-18, -3.026560649036020e-21,  1.331800487451138e-22,  1.230796432414525e-24,  1.710338260733272e+00, -3.198287801406146e-03, -2.167183563259429e-05,
 -8.404447980890736e-08,  1.097253665083317e-10,  4.597453344368090e-12,  3.477951469036618e-14,  6.801726377083614e-17, -1.335038570028720e-18, -1.647448098550168e-20,
 -7.461560869664234e-23,  3.187553978282917e-25,  1.814974546086251e+00, -2.182709287956293e-03, -1.718986155223683e-05, -9.835280341876050e-08, -3.231445726970450e-10,
  9.255594493226211e-13,  2.441108435949776e-14,  2.073952203085311e-16,  9.024578965412870e-19, -1.806320490561459e-21, -7.197268557194572e-23, -6.919802650541061e-25,
  1.898489507948328e+00, -1.259453976051289e-03, -1.104222646971339e-05, -7.864937084445407e-08, -4.534278416922815e-10, -1.848225710749379e-12, -1.024452011814288e-15,
  7.459463511969812e-17,  9.241767457466088e-19,  7.154733295969184e-21,  3.699370108392359e-23,  5.844674443649994e-26,  1.958160483944644e+00, -5.375257795831679e-04,
 -5.059656851782729e-06, -4.097570204050956e-08, -2.975092672943317e-10, -1.947275975944487e-12, -1.126037943089375e-14, -5.373852832371910e-17, -1.598528025780371e-19,
  4.978445474764762e-22,  1.400376713246413e-23,  1.550706871747315e-25,  1.992001887894594e+00, -1.047633848662154e-04, -1.024786866904716e-06, -8.859453993266144e-09,
 -7.128326286339507e-11, -5.456967723669840e-13, -4.017671949287894e-15, -2.860037443795233e-17, -1.972730662467111e-19, -1.318142744606074e-21, -8.510757329443721e-24,
 -5.281232151174456e-26,  2.548330375186604e-03, -2.892767749641326e-05,  2.459884674942620e-07, -1.856600990684882e-09,  1.311093118258063e-11, -8.867828510531146e-14,
  5.814901117128456e-16, -3.723327649037646e-18,  2.338037340062528e-20, -1.443999516715413e-22,  8.786360665715820e-25, -5.273554382422955e-27,  2.288160815453285e-02,
 -2.575152008449161e-04,  2.150975271806826e-06, -1.574411018266972e-08,  1.060220311997272e-10, -6.690112076775653e-13,  3.976556295740729e-15, -2.219604651458434e-17,
  1.148388441121096e-19, -5.341071050949961e-22,  2.057051616698388e-24, -4.594869254619374e-27,  6.326246956216060e-02, -6.996781388169570e-04,  5.633450725289922e-06,
 -3.863149524528909e-08,  2.335942970896420e-10, -1.235984187622599e-12,  5.408200960367849e-15, -1.554215685323935e-17, -2.420175901445902e-20,  8.367161905314849e-22,
 -8.341407681854676e-24,  6.063484419368307e-26,  1.231144011272386e-01, -1.325892158715974e-03,  1.007693956487749e-05, -6.195192379617196e-08,  3.044615900189558e-10,
 -1.005699721680973e-12, -4.711591156182469e-16,  4.187434377564690e-17, -4.163096941785214e-19,  2.691566555318193e-21, -1.130166903559094e-23,  5.970569531403121e-27,
  2.015600923324083e-01, -2.093166594166028e-03,  1.465168601536056e-05, -7.568065731827922e-08,  2.362309959641232e-10,  4.047642307338489e-13, -1.253636214078971e-14,
  1.033478540561026e-16, -4.757584599544239e-19,  1.400592105752798e-22,  2.041212981850411e-23, -2.146521796332026e-25,  2.974072029088372e-01, -2.946724870197883e-03,
  1.842422058936134e-05, -7.117632075614029e-08, -2.931374371967509e-13,  2.544278597037344e-12, -2.143906077655823e-14,  7.607511495627735e-17,  3.054498202988826e-19,
 -6.397326705453317e-21,  4.355620588671301e-23, -7.896177317996605e-26,  4.091309031121353e-01, -3.822441323467189e-03,  2.049434506777031e-05, -4.405954065351213e-08,
 -3.529036037521771e-10,  4.172490441602458e-12, -1.566263568176106e-14, -7.374780577996470e-17,  1.337759396394289e-18, -6.815259000859774e-21, -1.601217331565119e-23,
  5.005708680666937e-25,  5.348548031052226e-01, -4.650171867078748e-03,  2.014831644566188e-05,  3.604541243596255e-09, -6.919747518989428e-10,  3.890537816389628e-12,
  7.588597001112000e-15, -2.377738737548586e-16,  1.134738132465636e-18,  5.430700102886818e-21, -9.967562590859603e-23,  3.581008997736800e-25,  6.723326792931819e-01,
 -5.358100388597657e-03,  1.701053531776303e-05,  6.260375180393469e-08, -8.538388788704309e-10,  1.114271749961567e-12,  3.537571271411971e-14, -2.254986802629887e-16,
 -8.256079723326743e-19,  1.692533454153979e-20, -3.687017492528731e-23, -8.369648069609148e-25,  8.189344261307032e-01, -5.878157284248352e-03,  1.116847807338607e-05,
  1.179988152716789e-07, -7.147752518494146e-10, -3.190818731825782e-12,  4.473033894310141e-14,  3.432353534589894e-17, -2.645454085590018e-18,  6.423802596529242e-21,
  1.415841700302016e-22, -8.731007561427000e-25,  9.716408914055578e-01, -6.152428478502100e-03,  3.238770278420093e-06,  1.528765016952310e-07, -2.674444836972409e-10,
 -6.670726271507106e-12,  2.119664403686129e-14,  3.440133742396683e-16, -1.665224268288651e-18, -1.900805891779963e-20,  1.301662842517525e-22,  1.072625368884789e-24,
  1.127053586421249e+00, -6.140241885092928e-03, -5.660347440569893e-06,  1.538787038398353e-07,  3.423335724818084e-10, -6.890550834576461e-12, -2.346615181373139e-14,
  3.716351396469554e-16,  1.711101273969085e-18, -2.196463956109949e-20, -1.294130858167130e-22,  1.364932028831756e-24,  1.281426459451740e+00, -5.825287182125193e-03,
 -1.405824158034232e-05,  1.169527923759774e-07,  8.560189966715599e-10, -3.181052377868451e-12, -5.436909359335921e-14,  2.658935060131541e-17,  3.390774479136611e-18,
  8.361545244299580e-21, -1.988093639555928e-22, -1.171642247978407e-24,  1.430727556694707e+00, -5.221722792674671e-03, -2.040936624327590e-05,  5.091049776555595e-08,
  1.024260829975806e-09,  2.376246668485616e-12, -4.299867532566184e-14, -3.498465102802199e-16,  8.588135196576844e-19,  2.675115967434988e-20,  8.227284952625673e-23,
 -1.389538894236298e-24,  1.570737847859614e+00, -4.377840461775820e-03, -2.346655691726808e-05, -2.369579789823704e-08,  7.580543549458029e-10,  6.070681106204384e-12,
  1.300763344979946e-15, -3.367470487085783e-16, -2.473297487272774e-18,  3.378797590243291e-21,  1.865508973452796e-22,  1.155648318796910e-24,  1.697192024499536e+00,
 -3.375659490579883e-03, -2.266665298276436e-05, -8.150737546452326e-08,  2.101484329629791e-10,  5.449620205022886e-12,  3.599282755506849e-14,  1.526522183635800e-17,
 -1.977372513691726e-18, -1.905687462340958e-20, -5.124451871243272e-23,  7.660644114466548e-25,  1.805961074376582e+00, -2.325035386563520e-03, -1.840039755658308e-05,
 -1.033411628797748e-07, -2.982878181940172e-10,  1.584292078568843e-12,  3.060835571621310e-14,  2.346154429722025e-16,  7.778474570876534e-19, -5.340455411365060e-21,
 -1.058268369531963e-22, -8.412234876682645e-25,  1.893268861241957e+00, -1.351693104183974e-03, -1.203077005695891e-05, -8.620049489751145e-08, -4.904507252902338e-10,
 -1.844158632066858e-12,  1.519009253887109e-15,  1.085787183232477e-16,  1.208796609370361e-18,  8.662471191520406e-21,  3.770254175810420e-23, -3.683950648385473e-26,
  1.955926193894111e+00, -5.800538484547698e-04, -5.581260354252126e-06, -4.606261974553266e-08, -3.392820587111257e-10, -2.236138478271658e-12, -1.283312416211129e-14,
 -5.844443220501896e-17, -1.300229360614230e-19,  1.214620488409113e-21,  2.237964026427810e-23,  2.299688343082605e-25,  1.991565735935816e+00, -1.134071875433569e-04,
 -1.138321414696121e-06, -1.009282242175889e-08, -8.323018686291884e-11, -6.524902777177167e-13, -4.914490668676159e-15, -3.574288853304976e-17, -2.514565705117107e-19,
 -1.709792951268251e-21, -1.119779228663576e-23, -7.013869150856175e-26,  2.436419241890060e-03, -2.704545046534794e-05,  2.249117402263817e-07, -1.660290338539798e-09,
  1.146889599804306e-11, -7.589358866348476e-14,  4.869757077001146e-16, -3.051975786444029e-18,  1.876245286920679e-20, -1.134858222311877e-22,  6.764809122811832e-25,
 -3.979512710334641e-27,  2.188480581608362e-02, -2.410352621938987e-04,  1.971798754322349e-06, -1.414981810473476e-08,  9.354791267492389e-11, -5.806336797991010e-13,
  3.403735063355268e-15, -1.881337897388770e-17,  9.704116729977292e-20, -4.560954161163373e-22,  1.839378450692317e-24, -5.172141327640334e-27,  6.055104350497095e-02,
 -6.564031407550967e-04,  5.191504522205463e-06, -3.508484086879896e-08,  2.101369897969403e-10, -1.111471388712201e-12,  4.966276190879585e-15, -1.589412762008143e-17,
  5.140100782624632e-22,  5.517289899566752e-22, -6.017465000683306e-24,  4.559057785883912e-26,  1.179674700742911e-01, -1.248169051768880e-03,  9.362080066451647e-06,
 -5.724169202639024e-08,  2.843220770433462e-10, -1.004356704910576e-12,  5.287651060833565e-16,  3.001637201179697e-17, -3.274377476578641e-19,  2.250027819139548e-21,
 -1.066405961694603e-23,  2.130927327485709e-26,  1.934161925979022e-01, -1.979521008970654e-03,  1.376641310796437e-05, -7.185159349006067e-08,  2.415430944936442e-10,
  1.369059299833578e-13, -9.853982524937332e-15,  8.834438161692532e-17, -4.581417126638773e-19,  7.844721309317196e-22,  1.221195916082812e-23, -1.593154663340425e-25,
  2.859096863189393e-01, -2.802743959273718e-03,  1.757166728536460e-05, -7.080114141713693e-08,  4.562444667963390e-11,  2.056205914656705e-12, -1.920438615394701e-14,
  8.249295199540988e-17,  1.054970323770856e-19, -4.742881747212907e-21,  3.878664749869720e-23, -1.312647005719836e-25,  3.941655714899552e-01, -3.660691204307343e-03,
  1.993443780345388e-05, -4.905944190822641e-08, -2.733560622797359e-10,  3.776415154613618e-12, -1.716578739577360e-14, -3.494835122640204e-17,  1.085775220718901e-18,
 -7.060667505237313e-21,  2.627830914064740e-24,  3.479732757268386e-25,  5.165765047911540e-01, -4.488994567689292e-03,  2.012773517084621e-05, -6.836860941676539e-09,
 -6.128601284666925e-10,  3.997029283344158e-12,  1.463387367440699e-15, -1.990702743294853e-16,  1.262656510726995e-18,  1.799283936933225e-21, -8.108285240336544e-23,
  4.699747313704090e-25,  6.511768789121876e-01, -5.219241387599318e-03,  1.768069067394402e-05,  4.916454979003600e-08, -8.235877861785469e-10,  1.885087049344164e-12,
  2.878105864098599e-14, -2.425201102561311e-16, -2.508479973066095e-19,  1.480982149858482e-20, -6.650186237096556e-23, -5.079788228611531e-25,  7.956091801632681e-01,
 -5.783344405551845e-03,  1.251392891829941e-05,  1.061103663692371e-07, -7.678268947832591e-10, -2.115073040824497e-12,  4.454833434664760e-14, -4.561767368689916e-17,
 -2.322209611159782e-18,  1.124537590701231e-20,  9.803586348871452e-23, -1.073406058274666e-24,  9.470945006087961e-01, -6.119262933226456e-03,  5.043309154374003e-06,
  1.475608731232699e-07, -3.950252573085192e-10, -6.053034007478232e-12,  2.998778156789601e-14,  2.808657786607516e-16, -2.245795514674524e-18, -1.301006161802726e-20,
  1.657739260573047e-22,  5.308436179822443e-25,  1.102413865522233e+00, -6.178056026560420e-03, -3.785575942247157e-06,  1.582265926043888e-07,  1.997623041838071e-10,
 -7.323445025248428e-12, -1.241907115762025e-14,  4.128648956243790e-16,  8.428282056707729e-19, -2.581643261541078e-20, -6.057898342721841e-23,  1.720279369786240e-24,
  1.257909589029024e+00, -5.931911837218047e-03, -1.257495816845520e-05,  1.300697073696937e-07,  7.794740109874040e-10, -4.464494620594648e-12, -5.207175235610638e-14,
  1.382842556096140e-16,  3.537693078175443e-18, -4.567455563908294e-22, -2.375582220782642e-22, -5.488300695180010e-25,  1.409518382461377e+00, -5.382272188440221e-03,
 -1.969873347445163e-05,  6.761953716583077e-08,  1.060692527550890e-09,  1.230744899598878e-12, -5.226106952551152e-14, -3.064510531669044e-16,  1.864723887149338e-18,
  2.864169558297248e-20,  8.104515189323264e-24, -1.956626804762579e-24,  1.552849523473417e+00, -4.566494902736096e-03, -2.367413027262255e-05, -1.059728781756751e-08,
  8.789708691486946e-10,  5.979975240116999e-12, -9.207082794817587e-15, -4.124112111024247e-16, -2.205793807290692e-18,  1.177614432941099e-20,  2.307396713709719e-22,
  8.009698602253952e-25,  1.683320617531334e+00, -3.560839319566160e-03, -2.362081838629957e-05, -7.722611821522742e-08,  3.277740483198926e-10,  6.310780755141634e-12,
  3.542886252414485e-14, -5.930771663131896e-17, -2.690750600881792e-18, -2.027260497131704e-20, -5.397093927579102e-24,  1.334121791998675e-24,  1.796358561513850e+00,
 -2.477277398397450e-03, -1.966794600015769e-05, -1.078180863760606e-07, -2.587101931153694e-10,  2.400327415955856e-12,  3.749090706879386e-14,  2.555390463662439e-16,
  5.001733662569432e-19, -1.034576302424453e-20, -1.450661645169520e-22, -9.261266666088978e-25,  1.887662853260789e+00, -1.452213075779685e-03, -1.311346697184418e-05,
 -9.433967499489345e-08, -5.266992289141731e-10, -1.766550521966245e-12,  5.149679958944350e-15,  1.525351365473604e-16,  1.547005370320931e-18,  1.009343487621996e-20,
  3.257020021609952e-23, -2.125547904096366e-25,  1.953513042669630e+00, -6.270107322039338e-04, -6.168114466706775e-06, -5.186621350295253e-08, -3.872195643027711e-10,
 -2.564193849925124e-12, -1.451989051354046e-14, -6.171132359241155e-17, -6.748967032926560e-20,  2.340651981286747e-21,  3.468697220670360e-23,  3.351480061874450e-25,
  1.991093093665932e+00, -1.230218881272049e-04, -1.267877754865228e-06, -1.153566974283438e-08, -9.754548737398348e-11, -7.834170527059290e-13, -6.037850580199852e-15,
 -4.486719153746976e-17, -3.218718633273555e-19, -2.225728142634073e-21, -1.476612309185524e-23, -9.311486837490390e-26,  2.331714102798707e-03, -2.532284231212558e-05,
  2.060411608450124e-07, -1.488323841210500e-09,  1.006131178074219e-11, -6.516738692544632e-14,  4.093471209597909e-16, -2.512046614448015e-18,  1.512463119542643e-20,
 -8.962520661435392e-23,  5.235320072932224e-25, -3.019450489998590e-27,  2.095117295528002e-02, -2.259154729870646e-04,  1.810612221240235e-06, -1.274168739983886e-08,
  8.271121768864938e-11, -5.049291076988909e-13,  2.918065155339845e-15, -1.595702007376782e-17,  8.189092058225454e-20, -3.871001328840169e-22,  1.610496470010863e-24,
 -5.161195676514839e-27,  5.800590708370046e-02, -6.164996677904648e-04,  4.789946576358354e-06, -3.189415948927202e-08,  1.890635021647843e-10, -9.976025435305943e-13,
  4.524147267769013e-15, -1.560263880012652e-17,  1.649326509803080e-20,  3.474759193265979e-22, -4.280567537050678e-24,  3.385881136194778e-26,  1.131203439539052e-01,
 -1.175944197656651e-03,  8.701814771150440e-06, -5.285228097271768e-08,  2.644241115864307e-10, -9.826929062203170e-13,  1.234133043008582e-15,  2.075404932442970e-17,
 -2.538648945910934e-19,  1.844754568795913e-21, -9.549168832164702e-24,  2.828393814785844e-26,  1.857130033773364e-01, -1.872772752202973e-03,  1.292743308490324e-05,
 -6.797703702423658e-08,  2.421081825546811e-10, -7.153343676025573e-14, -7.580744708704179e-15,  7.421714403212931e-17, -4.226649609318276e-19,  1.147174951118432e-21,
  6.263092954407645e-24, -1.126586004349119e-25,  2.749744977119167e-01, -2.665553699275781e-03,  1.672771166994345e-05, -6.976640956498885e-08,  8.232794641253878e-11,
  1.623252405116593e-12, -1.687092239918738e-14,  8.342459944345298e-17, -3.878485916835841e-20, -3.314492290116499e-21,  3.249642259684669e-23, -1.501813435078423e-25,
  3.798379315743260e-01, -3.503639314593091e-03,  1.932190149871760e-05, -5.285156173399893e-08, -2.020075118178367e-10,  3.356386328117773e-12, -1.769582064987158e-14,
 -4.222784965416288e-18,  8.367898549035648e-19, -6.691124719780071e-21,  1.485559676793082e-23,  2.117013337427620e-25,  4.989418233580007e-01, -4.328461474793558e-03,
  1.998949750865926e-05, -1.600300250548680e-08, -5.329960489389932e-10,  3.969867223534375e-12, -3.539396794481070e-15, -1.582135657996098e-16,  1.274153142506088e-18,
 -1.018605243384546e-21, -5.966282543908441e-23,  4.908573417222573e-25,  6.305862287314836e-01, -5.075656882037639e-03,  1.819296023826770e-05,  3.632397064982993e-08,
 -7.795312941058808e-10,  2.493911935786691e-12,  2.195438113497614e-14, -2.425681745034751e-16,  2.299061622649766e-19,  1.179761428311037e-20, -8.182889599406154e-23,
 -1.956669912274821e-25,  7.726837911795449e-01, -5.678351365784884e-03,  1.371233261746121e-05,  9.354423507813164e-08, -7.995819352376999e-10, -1.069238851632786e-12,
  4.229640416840015e-14, -1.127877831526382e-16, -1.858338793087168e-18,  1.420656485392978e-20,  4.996210894247513e-23, -1.082483510985563e-24,  9.227091929642272e-01,
 -6.071949918843155e-03,  6.772255816092976e-06,  1.403136102866814e-07, -5.082955024395888e-10, -5.247463213960217e-12,  3.678483511723118e-14,  2.028217695561564e-16,
 -2.590725673858440e-18, -6.082544392410864e-21,  1.764081312742789e-22, -4.318679949719215e-26,  1.077653159345970e+00, -6.200702639459763e-03, -1.872554734507901e-06,
  1.602388179708218e-07,  5.126126189876394e-11, -7.480604216585879e-12, -6.234475815065667e-16,  4.246484020188962e-16, -1.115253077061120e-19, -2.668475704672668e-20,
  1.761888481226117e-23,  1.782729887351905e-24,  1.233990917471758e+00, -6.026063359396728e-03, -1.094245454315293e-05,  1.417606166094628e-07,  6.780663327970358e-10,
 -5.655042551748385e-12, -4.663066115038079e-14,  2.493597011676796e-16,  3.346460382540379e-18, -1.021245797783853e-20, -2.443044710838344e-22,  2.618501774294233e-25,
  1.387679662254438e+00, -5.536326396056932e-03, -1.878488865770662e-05,  8.471660444268768e-08,  1.072108623067562e-09, -1.187948203109282e-13, -5.985186100927371e-14,
 -2.303957061761392e-16,  2.879778732287430e-18,  2.712368246069766e-20, -8.644322569146868e-23, -2.288925026321439e-24,  1.534204301770226e+00, -4.756148543151590e-03,
 -2.371301969090611e-05,  4.406972090633086e-09,  9.953860027606477e-10,  5.612915867050257e-12, -2.166600986947367e-14, -4.743734486157449e-16, -1.608797400594795e-18,
  2.153326686706214e-20,  2.521202683070454e-22,  1.152821864522205e-25,  1.668693596859741e+00, -3.753413676793748e-03, -2.451175271236720e-05, -7.092655757038083e-08,
  4.623049384991737e-10,  7.130743515114598e-12,  3.245349634653580e-14, -1.570047001502396e-16, -3.408642616232697e-18, -1.913178762035447e-20,  6.698055500851052e-23,
  1.955676006354502e-24,  1.786126476490202e+00, -2.639862625403265e-03, -2.098484992255213e-05, -1.115220484815936e-07, -2.011185298567941e-10,  3.387392775172652e-12,
  4.480564023853006e-14,  2.643857925778966e-16,  1.346811493836033e-20, -1.695975227972130e-20, -1.852134739982291e-22, -8.667185844497640e-25,  1.881636809942401e+00,
 -1.561795012039782e-03, -1.429724614928337e-05, -1.030412383979379e-07, -5.604180002385846e-10, -1.585768220513212e-12,  1.017001322400672e-14,  2.080818845023437e-16,
  1.930886853593433e-18,  1.113278800620589e-20,  1.726572205227840e-23, -5.059251727283315e-25,  1.950902214087634e+00, -6.789545734251703e-04, -6.829437420301113e-06,
 -5.849152227037456e-08, -4.421290698665237e-10, -2.933562080235537e-12, -1.626328790792311e-14, -6.222385641055722e-17,  4.565468575577396e-20,  4.062350414211721e-21,
  5.244628123109938e-23,  4.792131211550046e-25,  1.990579804263883e+00, -1.337463988420107e-04, -1.416213937348970e-06, -1.323006669157166e-08, -1.147710161820328e-10,
 -9.446430511567944e-13, -7.451237699272928e-15, -5.657160554801662e-17, -4.136917564686033e-19, -2.906626949670849e-21, -1.949881097120555e-23, -1.233487479719390e-25,
  2.233610016688467e-03, -2.374331159424010e-05,  1.891058162330326e-07, -1.337258813527666e-09,  8.850780533792550e-12, -5.613525598874788e-14,  3.453279773892515e-16,
 -2.075886900513183e-18,  1.224513459655705e-20, -7.111502009534487e-23,  4.071865234970196e-25, -2.303209799440878e-27,  2.007554327010599e-02, -2.120204222646345e-04,
  1.665330919435938e-06, -1.149543816105229e-08,  7.327825797010699e-11, -4.399734280554574e-13,  2.505946830055591e-15, -1.354748702546940e-17,  6.906083809198186e-20,
 -3.271424773994811e-22,  1.389771615479171e-24, -4.836281389679534e-27,  5.561419425021678e-02, -5.796610683223896e-04,  4.424727048042058e-06, -2.902300770072316e-08,
  1.701622130483139e-10, -8.941954101919390e-13,  4.096323325638247e-15, -1.490501284364700e-17,  2.625337052862892e-20,  2.032231257521236e-22, -2.997489844460396e-24,
  2.486820433142029e-26,  1.085518790100953e-01, -1.108796147936933e-03,  8.092329251610815e-06, -4.877693491925296e-08,  2.451090223457502e-10, -9.469595384651515e-13,
  1.710987553692965e-15,  1.362172087591565e-17, -1.940212222807326e-19,  1.488494236022547e-21, -8.251084525567980e-24,  3.007068352345807e-26,  1.784236777925027e-01,
 -1.772550501432283e-03,  1.213487365844472e-05, -6.412395719017036e-08,  2.390187283005670e-10, -2.300230444850562e-13, -5.685518010312452e-15,  6.139200061626839e-17,
 -3.779450671750520e-19,  1.310152618987058e-21,  2.155473708491924e-24, -7.562031256922294e-26,  2.645746587460785e-01, -2.535056072032639e-03,  1.589942048288843e-05,
 -6.821065136783866e-08,  1.109320190894784e-10,  1.246139081711477e-12, -1.456863380419896e-14,  8.051223330337404e-17, -1.363077915258928e-19, -2.147211764360650e-21,
  2.588852286755353e-23, -1.474575237959541e-25,  3.661284369877135e-01, -3.351650971809830e-03,  1.867043051967694e-05, -5.556972403027339e-08, -1.391216497789213e-10,
  2.933075547730638e-12, -1.747447630134825e-14,  1.883121443750731e-17,  6.085342611862839e-19, -5.944899038606929e-21,  2.165959155260168e-23,  1.024330038704260e-25,
  4.819463964294141e-01, -4.169452616700575e-03,  1.974889510268438e-05, -2.390179979536485e-08, -4.547833770995996e-10,  3.836319968105695e-12, -7.407110014018374e-15,
 -1.184461883783771e-16,  1.199657453562849e-18, -2.982014438290597e-21, -3.881930025966745e-23,  4.485100248348402e-25,  6.105771550671076e-01, -4.928577716695859e-03,
  1.855574533585238e-05,  2.427683487596039e-08, -7.249282700799036e-10,  2.940515041252660e-12,  1.532474156595879e-14, -2.290594392820331e-16,  5.943639202132828e-19,
  8.432041606782328e-21, -8.460330325258224e-23,  5.754652055155527e-26,  7.501965836622612e-01, -5.564381340556167e-03,  1.475757332356539e-05,  8.063381194262551e-08,
 -8.111040583753888e-10, -9.825751805716049e-14,  3.838491525888004e-14, -1.637773070382562e-16, -1.322124345201335e-18,  1.528557608950420e-20,  5.044513971476048e-24,
 -9.384429511647297e-25,  8.985402079183372e-01, -6.011182731006185e-03,  8.403919690099095e-06,  1.313910157643726e-07, -6.040055040694137e-10, -4.306001027783976e-12,
  4.127992223864000e-14,  1.177637195727895e-16, -2.684568084378132e-18,  7.806425165946028e-22,  1.631194723789402e-22, -5.405675298633411e-25,  1.052832570773476e+00,
 -6.207989026808413e-03,  5.030333389122082e-08,  1.598653126181595e-07, -9.754316835126958e-11, -7.354167394994506e-12,  1.107417266008234e-14,  4.059960316125776e-16,
 -1.041005270733795e-18, -2.446132059400554e-20,  9.178908178967547e-23,  1.541541680459660e-24,  1.209722607130869e+00, -6.106623030168999e-03, -9.180155072279579e-06,
  1.516466513492302e-07,  5.544005250263173e-10, -6.678699059009679e-12, -3.821788676998729e-14,  3.487156780180266e-16,  2.807987087734573e-18, -1.950225029079911e-20,
 -2.140219166610972e-22,  1.105076941481084e-24,  1.365240647714206e+00, -5.682248192482138e-03, -1.766570371280839e-05,  1.017712936750706e-07,  1.054903285820760e-09,
 -1.621365691080306e-12, -6.487191401975249e-14, -1.234854884623375e-16,  3.769511087402651e-18,  2.163473262431987e-20, -1.876481276811841e-22, -2.238637115017882e-24,
  1.514801027429929e+00, -4.945362095759945e-03, -2.356097853226109e-05,  2.119835135590087e-08,  1.101341826473855e-09,  4.928510564578494e-12, -3.553881329534133e-14,
 -5.115114612500189e-16, -6.533010675215114e-19,  3.144637117393127e-20,  2.362752243795052e-22, -8.794515996381679e-25,  1.653282555842092e+00, -3.952775320985619e-03,
 -2.531365139000994e-05, -6.234816460445922e-08,  6.122862413061315e-10,  7.843934645270086e-12,  2.643146452825121e-14, -2.764053493884429e-16, -4.026848586022618e-18,
 -1.456063547491366e-20,  1.655326429892849e-22,  2.495458497615360e-24,  1.775222722766338e+00, -2.813143646447719e-03, -2.233999008243640e-05, -1.141370254724316e-07,
 -1.220200279347568e-10,  4.550993417332060e-12,  5.211208171874214e-14,  2.535472711696826e-16, -7.390315651888586e-19, -2.506138937941416e-20, -2.175995600436966e-22,
 -5.531269810960029e-25,  1.875152824564496e+00, -1.681273708218988e-03, -1.558853906152599e-05, -1.122462762845004e-07, -5.891829623723486e-10, -1.264416421173836e-12,
  1.692225816754187e-14,  2.763655382852284e-16,  2.337660439727364e-18,  1.125787156131086e-20, -1.430596019239806e-23, -9.588539440391233e-25,  1.948072503605969e+00,
 -7.365225246829090e-04, -7.575786532691363e-06, -6.605675216836603e-08, -5.048431414832465e-10, -3.344472435377951e-12, -1.795997659579025e-14, -5.797378748922652e-17,
  2.352143181137065e-19,  6.634449934721238e-21,  7.754692769324680e-23,  6.698717629948554e-25,  1.990021107712399e+00, -1.457438730303023e-04, -1.586649232784160e-06,
 -1.522782902066563e-08, -1.355886404945608e-10, -1.144079067140114e-12, -9.237445033479846e-15, -7.164574113092439e-17, -5.337749411129516e-19, -3.805968533250956e-21,
 -2.575408580708842e-23, -1.626183930267407e-25,  2.141564121475520e-03, -2.229232857007173e-05,  1.738727426541245e-07, -1.204196653315696e-09,  7.806465209919943e-12,
 -4.850286202153501e-14,  2.923254046499693e-16, -1.722049229550512e-18,  9.955307258809948e-21, -5.668506608444177e-23,  3.182184567699031e-25, -1.766005336008386e-27,
  1.925326050558640e-02, -1.992302724064727e-04,  1.534140235046884e-06, -1.039023864228508e-08,  6.505073674266431e-11, -3.841434444273919e-13,  2.155860073978045e-15,
 -1.151565369294295e-17,  5.823425208447839e-20, -2.756752140959143e-22,  1.187040609390566e-24, -4.364255743377870e-27,  5.336420345429844e-02, -5.456113973559677e-04,
  4.092213278560622e-06, -2.643828206089311e-08,  1.532281343331662e-10, -8.007908192708371e-13,  3.691691086072402e-15, -1.396897988151029e-17,  3.165514646411792e-20,
  1.030652026746963e-22, -2.059852708769345e-24,  1.807158005076394e-26,  1.042425568824633e-01, -1.046333561434416e-03,  7.529919057923629e-06, -4.500435529132043e-08,
  2.266079388056887e-10, -9.019732198399794e-13,  2.013090774468151e-15,  8.209295646080476e-18, -1.460588281575353e-19,  1.184715899518067e-21, -6.946843673423682e-24,
  2.885600560936149e-26,  1.715228516095332e-01, -1.678484844014768e-03,  1.138815767820913e-05, -6.034331471295631e-08,  2.331861037213557e-10, -3.471703890719401e-13,
 -4.128687212482505e-15,  5.006308093997199e-17, -3.299477086765036e-19,  1.338687147342241e-21, -5.248689857115665e-25, -4.760626837818849e-26,  2.546836861204452e-01,
 -2.411102871453713e-03,  1.509230512526967e-05, -6.625459754601713e-08,  1.325381049658171e-10,  9.229865020055635e-13, -1.238562544052865e-14,  7.510097230337267e-17,
 -1.964979856200937e-19, -1.237637209023514e-21,  1.970057671674380e-23, -1.324095855162302e-25,  3.530162889597114e-01, -3.204988404221328e-03,  1.799210075034178e-05,
 -5.734894866653002e-08, -8.460074842253928e-11,  2.522024280460453e-12, -1.670551731497945e-14,  3.505450536496000e-17,  4.109624073954160e-19, -5.013942557911154e-21,
  2.430810092439026e-23,  2.273768312195728e-26,  4.655825847131358e-01, -4.012726680180513e-03,  1.942091208836779e-05, -3.057523243642228e-08, -3.800813578338050e-10,
  3.622980395007155e-12, -1.020421446393524e-14, -8.203710819283797e-17,  1.068921041204715e-18, -4.161346000513425e-21, -2.071893853590261e-23,  3.703825440821959e-25,
  5.911613088360308e-01, -4.779159057667817e-03,  1.877947385423908e-05,  1.316630980956941e-08, -6.629473248349506e-10,  3.233751408474493e-12,  9.218376208213152e-15,
 -2.058275768307766e-16,  8.381458830903827e-19,  5.155892161624546e-21, -7.793190009952456e-23,  2.322353908420895e-25,  7.281809963818712e-01, -5.442670783520178e-03,
  1.564740591217184e-05,  6.768884107307979e-08, -8.042508273858769e-10,  7.636783928751696e-13,  3.328939298759612e-14, -1.973187955013803e-16, -7.775751301498297e-19,
  1.472710877228035e-20, -3.122005852833626e-23, -6.994569960234105e-25,  8.746396853056974e-01, -5.937815084764728e-03,  9.919962401038090e-06,  1.210927437813252e-07,
 -6.800011543186712e-10, -3.285351977234120e-12,  4.338751833934573e-14,  3.351288865354831e-17, -2.545810963622947e-18,  6.715779851499060e-21,  1.311341840481885e-22,
 -8.837343174202499e-25,  1.028013517230227e+00, -6.199950662508899e-03,  1.954526343519052e-06,  1.571461830744320e-07, -2.410707205189342e-10, -6.956522055040664e-12,
  2.184909114282154e-14,  3.594280444035513e-16, -1.840319129005409e-18, -1.956151714153667e-20,  1.496564499535318e-22,  1.056698068600411e-24,  1.185160956793309e+00,
 -6.172644892751135e-03, -7.311732688136828e-06,  1.594021253579517e-07,  4.124946541701115e-10, -7.469311380053962e-12, -2.731257783040728e-14,  4.257943506027599e-16,
  1.965568895827844e-18, -2.686955605113534e-20, -1.492699585325342e-22,  1.799065712060588e-24,  1.342237139438628e+00, -5.818404885275218e-03, -1.634452419634130e-05,
  1.183048130800360e-07,  1.006699942368964e-09, -3.205488993249943e-12, -6.653509330563349e-14,  7.965509380002200e-18,  4.390521606353001e-18,  1.227596105563454e-20,
 -2.765364695697023e-22, -1.723649220855382e-24,  1.494644646848177e+00, -5.132525672225136e-03, -2.319778017687652e-05,  3.955714158611877e-08,  1.190215074922152e-09,
  3.902457859112007e-12, -4.997115795255878e-14, -5.125757894378328e-16,  6.364833014187425e-19,  3.978381307914134e-20,  1.720078382356716e-22, -2.054806502684654e-24,
  1.637061948777419e+00, -4.158098569589124e-03, -2.599776907576909e-05, -5.126498763142950e-08,  7.748044731993404e-10,  8.370423300832255e-12,  1.681967277549485e-14,
 -4.121520608816491e-16, -4.404398411336775e-18, -5.640052737784670e-21,  2.823617855833519e-22,  2.747473755306276e-24,  1.763603996760266e+00, -2.997367963024485e-03,
 -2.371811807867055e-05, -1.152908784004675e-07, -1.793578537507078e-11,  5.883308218516436e-12,  5.873248164158430e-14,  2.137451697001821e-16, -1.802261640145141e-18,
 -3.407950647953905e-20, -2.282572120362377e-22,  1.419654067495189e-25,  1.868169553806765e+00, -1.811531864589898e-03, -1.699281141127516e-05, -1.218506558667698e-07,
 -6.097378979851660e-10, -7.566021207852799e-13,  2.576737741379338e-14,  3.574520042371310e-16,  2.720901464955430e-18,  9.666039504843404e-21, -7.000530798252314e-23,
 -1.607028430043860e-24,  1.944999979852537e+00, -8.004420968054517e-04, -8.419217179605942e-06, -7.469331139139044e-08, -5.761690541868358e-10, -3.793896939529627e-12,
 -1.943733956561185e-14, -4.596522162125601e-17,  5.375966573880287e-19,  1.039294914938656e-20,  1.121255679198377e-22,  9.096519112423286e-25,  1.989411534055890e+00,
 -1.592067035887561e-04, -1.783195752598832e-06, -1.759306403433865e-08, -1.608602406554785e-10, -1.391914918682037e-12, -1.150475741258525e-14, -9.113240940809764e-17,
 -6.911820846268727e-19, -4.993113782358815e-21, -3.396665604665375e-23, -2.125367726911311e-25,  2.055088155638445e-03, -2.095709603627210e-05,  1.601409830821851e-07,
 -1.086688245123338e-09,  6.902838810470991e-12, -4.203146381919477e-14,  2.482778972742360e-16, -1.433817541049922e-18,  8.126211598908011e-21, -4.538291806089400e-23,
  2.498346218660575e-25, -1.361030016913500e-27,  1.848012023360545e-02, -1.874387543434097e-04,  1.415457523071215e-06, -9.408184518803609e-09,  5.786020730152484e-11,
 -3.360703387980808e-13,  1.858081964985281e-15, -9.802149137368567e-18,  4.911971604374217e-20, -2.318821410120547e-22,  1.006408920066614e-24, -3.843952123659185e-27,
  5.124528124131653e-02, -5.141022371916348e-04,  3.789150508169773e-06, -2.411007536418389e-08,  1.380672463298329e-10, -7.167664489334924e-13,  3.315194091823583e-15,
 -1.291109468059116e-17,  3.405920988278818e-20,  3.496846529207114e-23, -1.381953045349802e-24,  1.298941691886705e-26,  1.001743662424573e-01, -9.881941342589349e-04,
  7.011034549254037e-06, -4.152024977839584e-08,  2.090676657725686e-10, -8.513913149131912e-13,  2.183560202447377e-15,  4.166620689542552e-18, -1.081113821300724e-19,
  9.314953974008274e-22, -5.734486129931745e-24,  2.608234521728408e-26,  1.649866254708639e-01, -1.590213195471357e-03,  1.068617844738802e-05, -5.667281242023462e-08,
  2.253593761447360e-10, -4.305864866816430e-13, -2.867543194087163e-15,  4.026808699396816e-17, -2.825777380147441e-19,  1.282281612825712e-21, -2.147770903690238e-24,
 -2.731127048036002e-26,  2.452757687836033e-01, -2.293507299264771e-03,  1.431053238870993e-05, -6.400175917997729e-08,  1.481917859634450e-10,  6.502188743172194e-13,
 -1.037650740166177e-14,  6.824119543062830e-17, -2.282197776465673e-19, -5.602825525857362e-22,  1.431816463378616e-23, -1.117454011012660e-25,  3.404798228260418e-01,
 -3.063823665452213e-03,  1.729738663808457e-05, -5.832046236635413e-08, -3.808308650152351e-11,  2.134196172584076e-12, -1.556567152358807e-14,  4.550581581286661e-17,
  2.480426369166241e-19, -4.038903670140350e-21,  2.406152217312199e-23, -2.983639831876912e-26,  4.498399500640754e-01, -3.858924959881038e-03,  1.901986758271920e-05,
 -3.609087687058135e-08, -3.102374513373746e-10,  3.354236616607846e-12, -1.204586156666996e-14, -5.035822397243777e-17,  9.078814854839927e-19, -4.690728311433317e-21,
 -6.417438846712795e-24,  2.790193100701595e-25,  5.723458968220267e-01, -4.628466621734956e-03,  1.887599462476902e-05,  3.086670637449828e-09, -5.965103888896464e-10,
  3.389015637890044e-12,  3.854434055003705e-15, -1.766166417620222e-16,  9.704257650182253e-19,  2.276619977245522e-21, -6.533519119787965e-23,  3.280735715919286e-25,
  7.066655091360745e-01, -5.314459794767465e-03,  1.638310332682377e-05,  5.498450286327799e-08, -7.814478126733717e-10,  1.493992860223309e-12,  2.749377249654185e-14,
 -2.140148453165313e-16, -2.765696938114302e-19,  1.294261324576606e-20, -5.600927177884830e-23, -4.262929555650051e-25,  8.510560801734691e-01, -5.852832519402564e-03,
  1.130581063214645e-05,  1.097438029430584e-07, -7.352656848390941e-10, -2.241739227493076e-12,  4.322845960906235e-14, -4.315231098690816e-17, -2.219565038529555e-18,
  1.112381848184794e-20,  8.813381705496146e-23, -1.039609790608377e-24,  1.003256823852850e+00, -6.176847378543101e-03,  3.812647781144282e-06,  1.522077933522647e-07,
 -3.741791929172870e-10, -6.318637966174598e-12,  3.099145922800375e-14,  2.905062580597153e-16, -2.427170686805071e-18, -1.282176691629325e-20,  1.828224060655162e-22,
  4.397937856483239e-25,  1.160365647223897e+00, -6.223386817835414e-03, -5.364341453031606e-06,  1.647755040172304e-07,  2.575519120278741e-10, -7.975569835684180e-12,
 -1.466245389214328e-14,  4.722270507560932e-16,  9.111911254391210e-19, -3.111681084957326e-20, -6.026171865554469e-23,  2.186352794745893e-24,  1.318711378116953e+00,
 -5.943214059910000e-03, -1.483061900724485e-05,  1.338127380715942e-07,  9.267232997325827e-10, -4.783450084247996e-12, -6.429467710430053e-14,  1.532644539078705e-16,
  4.617313243324000e-18, -5.048404323781843e-23, -3.328450428084618e-22, -7.732369017656732e-25,  1.473746850319760e+00, -5.315879947961316e-03, -2.260648248222041e-05,
  5.915499271465934e-08,  1.255126300304393e-09,  2.534592208063897e-12, -6.381448456646893e-14, -4.681625078538591e-16,  2.167617846089197e-18,  4.451341012956633e-20,
  5.632402026623380e-23, -3.168278737099758e-24,  1.620010008508393e+00, -4.368317849894767e-03, -2.653298358651788e-05, -3.751112729018235e-08,  9.452320969319539e-10,
  8.619582211443184e-12,  3.292626006662470e-15, -5.539265053076631e-16, -4.375257032560739e-18,  8.035753840412720e-21,  3.993773918776860e-22,  2.462094769653308e-24,
  1.751226278453442e+00, -3.192642298566711e-03, -2.509919414067838e-05, -1.145580320212345e-07,  1.142722299112189e-10,  7.356993181988273e-12,  6.371308933463449e-14,
  1.347109607458655e-16, -3.189199424550776e-18, -4.277392247660290e-20, -1.978293325026685e-22,  1.328016227001184e-24,  1.860642045356856e+00, -1.953489950176769e-03,
 -1.851393490317474e-05, -1.316903340604475e-07, -6.178229381893002e-10, -7.943878957261019e-15,  3.704258802932498e-14,  4.493958699673485e-16,  2.999307441279902e-18,
  5.215313627965139e-21, -1.587239467793037e-22, -2.456380151809276e-24,  1.941657598236993e+00, -8.715437645824036e-04, -9.373436321956752e-06, -8.454478392734780e-08,
 -6.568045707555239e-10, -4.273514769978920e-12, -2.042062779689218e-14, -2.182715935993561e-17,  1.002841822393924e-18,  1.575825766055927e-20,  1.581644830016174e-22,
  1.187005318446568e-24,  1.988744774348640e+00, -1.743627083452291e-04, -2.010724847671211e-06, -2.040545124438222e-08, -1.916800263879416e-10, -1.701324838083225e-12,
 -1.439511761618503e-14, -1.164077985298866e-16, -8.977991871048994e-19, -6.556023823444806e-21, -4.462468391041739e-23, -2.737209443741930e-25,  1.973742007944564e-03,
 -1.972631348532474e-05,  1.477366685615272e-07, -9.826572439513679e-10,  6.118690029931861e-12, -3.652661604871027e-14,  2.115390381765781e-16, -1.198101845519626e-18,
  6.658764829649477e-21, -3.649077501587667e-23,  1.970037039982721e-25, -1.054300784909341e-27,  1.775231907869179e-02, -1.765514445752464e-04,  1.307899683369970e-06,
 -8.533859734350517e-09,  5.156339512635965e-11, -2.945997204280307e-13,  1.604425997495299e-15, -8.356434519726084e-18,  4.145720485241106e-20, -1.948558173469745e-22,
  8.486411878608042e-25, -3.331752848272209e-27,  4.924771795102212e-02, -4.849098244526236e-04,  3.512624666486679e-06, -2.201147972814358e-08,  1.244989217010452e-10,
 -6.414159523607260e-13,  2.969061267174101e-15, -1.181068191639076e-17,  3.444979876269761e-20, -1.007124163234981e-23, -8.974315245887025e-25,  9.222400730961952e-27,
  9.633068931853257e-02, -9.340432388951538e-04,  6.532309445204407e-06, -3.830850935927088e-08,  1.925714493309210e-10, -7.979473592499774e-13,  2.256530025522297e-15,
  1.201514079962994e-18, -7.843869805415459e-20,  7.240854382315610e-22, -4.661011883388489e-24,  2.265821294458579e-26,  1.587925300571294e-01, -1.507383442092952e-03,
  1.002744390325056e-05, -5.313933000729640e-08,  2.161456619236762e-10, -4.868572391582601e-13, -1.859822317058695e-15,  3.194554232983828e-17, -2.382094802413128e-19,
  1.176882662814727e-21, -3.019743539746337e-24, -1.322415683248873e-26,  2.363259020728722e-01, -2.182053912842695e-03,  1.355712474299533e-05, -6.153955194292926e-08,
  1.588562422923855e-10,  4.232715793168402e-13, -8.570294370835168e-15,  6.071674524412982e-17, -2.392070137527095e-19, -7.943308120261602e-23,  9.883890312343434e-24,
 -8.987562177850085e-26,  3.284968434849032e-01, -2.928251198824293e-03,  1.659522915237983e-05, -5.860817030236037e-08,  9.723722260631243e-13,  1.776679147584034e-12,
 -1.420093787894213e-14,  5.129931011779710e-17,  1.195530480512113e-19, -3.113061457032716e-21,  2.200995934901676e-23, -6.022003724644056e-26,  4.347057126587632e-01,
 -3.708577771655951e-03,  1.855915600726742e-05, -4.053412839508554e-08, -2.461416384903859e-10,  3.051341236388021e-12, -1.307476919936916e-14, -2.403501301617934e-17,
  7.371093569894715e-19, -4.728597018153634e-21,  3.876591870312598e-24,  1.902761376705813e-25,  5.541340585989145e-01, -4.477467579501805e-03,  1.885801826612978e-05,
 -5.911844360678088e-09, -5.281871852006709e-10,  3.425746335251861e-12, -6.471882982240100e-16, -1.447269813146954e-16,  1.008946583785525e-18, -3.522363833444079e-23,
 -5.004630601896209e-23,  3.572978157605938e-25,  6.856736816314682e-01, -5.180965772193692e-03,  1.696899494159592e-05,  4.275417853879253e-08, -7.454582363178447e-10,
  2.081348579269943e-12,  2.144422704413766e-14, -2.158744873329455e-16,  1.452333692501532e-19,  1.040531549987604e-20, -6.897912253109008e-23, -1.691755741231583e-25,
  8.278336972186982e-01, -5.757321367891377e-03,  1.255085235155269e-05,  9.767669337446658e-08, -7.698633361451155e-10, -1.226389200081866e-12,  4.109036144156157e-14,
 -1.071807181786527e-16, -1.766747195038059e-18,  1.372877524203778e-20,  4.227227525857295e-23, -1.018579576381183e-24,  9.786218484948092e-01, -6.139151327651853e-03,
  5.599187871342951e-06,  1.452529598107829e-07, -4.925021164794045e-10, -5.486384804052189e-12,  3.797909722389881e-14,  2.068894923683202e-16, -2.754160151910093e-18,
 -5.308133099907591e-21,  1.883388706574166e-22, -1.790013926676764e-25,  1.135398876215472e+00, -6.258334495719600e-03, -3.367623834485464e-06,  1.676056650942493e-07,
  9.560512791989072e-11, -8.166552570051491e-12, -1.202502256435921e-15,  4.831870637764348e-16, -2.289124747591572e-19, -3.157544722121530e-20,  3.728768148425580e-23,
  2.180732974914884e-24,  1.294711747341132e+00, -6.055191738890604e-03, -1.313932466344736e-05,  1.477928771224155e-07,  8.160571217614363e-10, -6.258424090725787e-12,
 -5.795359364398717e-14,  2.983738952697196e-16,  4.370800985580519e-18, -1.369556045612670e-20, -3.404307697408445e-22,  4.552070290917201e-25,  1.452126608928219e+00,
 -5.493547683359524e-03, -2.177473896313038e-05,  7.955503735424756e-08,  1.289487701367880e-09,  8.550692709744875e-13, -7.570959372667261e-14, -3.730127781280037e-16,
  3.774677038516450e-18,  4.372388311698933e-20, -1.011645268874564e-22, -3.899599822615995e-24,  1.602109738770383e+00, -4.582112047227884e-03, -2.688668708458845e-05,
 -2.100954047271571e-08,  1.117077453239466e-09,  8.497047537392475e-12, -1.411079835228073e-14, -6.860246955318952e-16, -3.774454977085352e-18,  2.593027659197421e-20,
  4.877371922693802e-22,  1.415401377164781e-24,  1.738045475053072e+00, -3.398891827316282e-03, -2.645779268742537e-05, -1.114684193253276e-07,  2.769429335933290e-10,
  8.918363955072594e-12,  6.581464847714219e-14,  6.633023001637064e-18, -4.853239649420983e-18, -4.905271374076965e-20, -1.036963681764432e-22,  3.030154319422054e-24,
  1.852521617294548e+00, -2.108090289487129e-03, -2.015336652573523e-05, -1.415239934376178e-07, -6.080157548949076e-10,  1.043044869766953e-12,  5.098754397260460e-14,
  5.469240826913329e-16,  3.044151791786848e-18, -3.579774466886349e-21, -2.882225254461265e-22, -3.440767055268995e-24,  1.938014761798012e+00, -9.507747251177847e-04,
 -1.045393413951800e-05, -9.576418331268708e-08, -7.472041879371397e-10, -4.766747027193851e-12, -2.048790974811527e-14,  2.066872508999245e-17,  1.697363509965926e-18,
  2.321238348909810e-20,  2.165370802188297e-22,  1.459393973633643e-24,  1.988013523928190e+00, -1.914828194719065e-04, -2.275178399457368e-06, -2.376448440207841e-08,
 -2.294431145578622e-10, -2.089398124703483e-12, -1.809482966954368e-14, -1.492829001144204e-16, -1.169031227334384e-18, -8.602076933116896e-21, -5.819035184337995e-23,
 -3.439405195951091e-25,  1.897128137317875e-03, -1.858997718407183e-05,  1.365089316961991e-07, -8.903376028999105e-10,  5.436329262273504e-12, -3.182932487669978e-14,
  1.807881647530500e-16, -1.004605446347171e-18,  5.476435688777011e-21, -2.946511739602605e-23,  1.559758892866225e-25, -8.210585715344788e-28,  1.706641034860438e-02,
 -1.664842817152252e-04,  1.210255582718160e-06, -7.753966133077355e-09,  4.603825864152907e-11, -2.587576036265996e-13,  1.388009189865344e-15, -7.135767534794972e-18,
  3.501939388242260e-20, -1.636992523913945e-22,  7.126377548272181e-25, -2.858210564796284e-27,  4.736265432862043e-02, -4.578324647884785e-04,  3.260027711180159e-06,
 -2.011836208051109e-08,  1.123570322658691e-10, -5.740028646605862e-13,  2.653696113871767e-15, -1.072027771668135e-17,  3.353075805864884e-20, -3.873189364871698e-23,
 -5.557778242529436e-25,  6.448081894930617e-27,  9.269619423984143e-02, -8.835723860741119e-04,  6.090577097972707e-06, -3.535208860059181e-08,  1.771554261995396e-10,
 -7.436477176077925e-13,  2.258705078344801e-15, -9.255465802605072e-19, -5.549680219507388e-20,  5.565390982118892e-22, -3.742088510136516e-24,  1.912262859600214e-26,
  1.529194788083214e-01, -1.429656541418022e-03,  9.410193539779553e-06, -4.976103266550792e-08,  2.060303236237849e-10, -5.215823483280361e-13, -1.065867555582265e-15,
  2.497646102476287e-17, -1.981278833800900e-19,  1.047499024004782e-21, -3.381724851789566e-24, -3.907475001367593e-27,  2.278099851724366e-01, -2.076507030922351e-03,
  1.283414501913883e-05, -5.894074182438366e-08,  1.653980366331980e-10,  2.371202694104575e-13, -6.977319093015204e-15,  5.308530887116965e-17, -2.358466767012426e-19,
  2.430155137644087e-22,  6.387698327647678e-24, -6.941671688551796e-26,  3.170449119203933e-01, -2.798299710600793e-03,  1.589313843030578e-05, -5.832636682662878e-08,
  3.321589339503978e-11,  1.453427898056319e-12, -1.272666553247880e-14,  5.349629364091621e-17,  2.264327472360781e-20, -2.290738679957210e-21,  1.900612095521183e-23,
 -7.404264711773455e-26,  4.201651789303009e-01, -3.562112585965400e-03,  1.805107501249149e-05, -4.400141237292520e-08, -1.882941570249338e-10,  2.731980555386686e-12,
 -1.344281460688525e-14, -3.126318392571322e-18,  5.714713907491673e-19, -4.429756032828636e-21,  1.050577746402020e-23,  1.134938406612618e-25,  5.365252712993800e-01,
 -4.327025673739243e-03,  1.873862481595611e-05, -1.381687615121779e-08, -4.601370221165575e-10,  3.365219676264151e-12, -4.250303236464651e-15, -1.128166955712172e-16,
  9.754138155017462e-19, -1.725460627199415e-21, -3.460807442687189e-23,  3.380317845782791e-25,  6.652242899108631e-01, -5.043361041555900e-03,  1.741193978056188e-05,
  3.118578436902355e-08, -6.991701409667654e-10,  2.524328162112865e-12,  1.551725834906806e-14, -2.057766339999392e-16,  4.689700100994915e-19,  7.562823973361430e-21,
 -7.162786990304269e-23,  3.895787928331571e-26,  8.050123511600573e-01, -5.652436992130429e-03,  1.364842688888213e-05,  8.521511020355948e-08, -7.848035627352343e-10,
 -2.821555963208673e-13,  3.737392778198515e-14, -1.555680677291846e-16, -1.252545743726138e-18,  1.456126945504468e-20,  4.950020575923199e-25, -8.626383224035998e-25,
  9.541656697159233e-01, -6.087527651687459e-03,  7.291487541999390e-06,  1.365464177794238e-07, -5.926976353217202e-10, -4.515455795107853e-12,  4.251964016005011e-14,
  1.171276515770664e-16, -2.813026369876635e-18,  1.907491345063817e-21,  1.687427908998718e-22, -6.857838693139216e-25,  1.110324414643273e+00, -6.277216810493142e-03,
 -1.352560261410577e-06,  1.678317024017161e-07, -6.692733853106715e-11, -8.034924989541468e-12,  1.205641281616612e-14,  4.581451398358361e-16, -1.316419350021805e-18,
 -2.825375238581012e-20,  1.259583520638471e-22,  1.792653102620770e-24,  1.270292283673729e+00, -6.153000299112517e-03, -1.129183557893951e-05,  1.597759898499388e-07,
  6.777358999271671e-10, -7.533800035750134e-12, -4.773352531438797e-14,  4.277845388461699e-16,  3.640910713460531e-18, -2.653629802824481e-20, -2.924816950463898e-22,
  1.703198761077799e-24,  1.429810564602838e+00, -5.663575570892180e-03, -2.069605221884608e-05,  1.002216391186582e-07,  1.287649375583397e-09, -1.072225947528488e-12,
 -8.423380191379031e-14, -2.281600503237025e-16,  5.233807383064516e-18,  3.617557494576515e-20, -2.765439531475280e-22, -3.936676450024506e-24,  1.583349952657606e+00,
 -4.797897394193494e-03, -2.702603209655797e-05, -1.801938213536401e-09,  1.282009530062080e-09,  7.915235311882877e-12, -3.484269953707429e-14, -7.880129002847948e-16,
 -2.479211828751183e-18,  4.618720895430412e-20,  5.112794383479272e-22, -4.809056108723751e-25,  1.724018236380572e+00, -3.615815212012627e-03, -2.776266371000368e-05,
 -1.055248455614123e-07,  4.710230690355679e-10,  1.048094168945860e-11,  6.355662304830446e-14, -1.774297368342217e-16, -6.656315518780026e-18, -4.994249822034726e-20,
  7.428161425658859e-23,  5.093022234032216e-24,  1.843755815637503e+00, -2.276273709622380e-03, -2.190910548014720e-05, -1.510134681880791e-07, -5.736213536050960e-10,
  2.461313786930635e-12,  6.762816030653264e-14,  6.397364734612271e-16,  2.668652519280419e-18, -1.842209618173177e-20, -4.606171981161196e-22, -4.357378660389951e-24,
  1.934036825177528e+00, -1.039213536139500e-03, -1.167806770901305e-05, -1.085085283880138e-07, -8.473741253573471e-10, -5.244539416791730e-12, -1.901047608621881e-14,
  9.015585458273222e-17,  2.704971870383540e-18,  3.321966806056568e-20,  2.850462776708260e-22,  1.623525519319267e-24,  1.987209291199692e+00, -2.108906870084013e-04,
 -2.583838261155992e-06, -2.779497464668437e-08, -2.759355318034102e-10, -2.578363265146832e-12, -2.284841182175775e-14, -1.921268018932146e-16, -1.524443965917862e-18,
 -1.125357500205770e-20, -7.489896116514977e-23, -4.142178186511907e-25,  1.824886731468526e-03, -1.753921014889561e-05,  1.263264990646583e-07, -8.082224986287348e-10,
  4.840951814915842e-12, -2.780909232427821e-14,  1.549613827334546e-16, -8.451945283049038e-19,  4.519802620722045e-21, -2.389276040386978e-23,  1.239353606982655e-25,
 -6.432702512100985e-28,  1.641926518419428e-02, -1.571622869021094e-04,  1.121462564603591e-06, -7.057010969546893e-09,  4.118067688623544e-11, -2.277216253790811e-13,
  1.203048283886038e-15, -6.104174403544640e-18,  2.961018141181459e-20, -1.375813041334695e-22,  5.963133654532867e-25, -2.439066937886058e-27,  4.558199793983886e-02,
 -4.326882138662515e-04,  3.029025734989728e-06, -1.840912949643913e-08,  1.014901690891353e-10, -5.137963527938686e-13,  2.368312928870424e-15, -9.673378261189554e-18,
  3.179866060669601e-20, -5.593447226325441e-23, -3.191728270326704e-25,  4.409816656505645e-27,  8.925673373182759e-02, -8.364975945336286e-04,  5.682877656688378e-06,
 -3.263365225913685e-08,  1.628214997276039e-10, -6.899329363164310e-13,  2.210742465587324e-15, -2.408181500341655e-18, -3.796212352574127e-20,  4.226763699508055e-22,
 -2.975514799917335e-24,  1.576516896736108e-26,  1.473477119612003e-01, -1.356708283125244e-03,  8.832491931901452e-06, -4.654916523103113e-08,  1.953959568848044e-10,
 -5.394536046441875e-13, -4.498063591974065e-16,  1.921340435756816e-17, -1.628763029865373e-19,  9.107117776846521e-22, -3.415686553361228e-24,  1.867788254823192e-27,
  2.197048877892334e-01, -1.976617734352766e-03,  1.214286270012327e-05, -5.626504227064255e-08,  1.685819156822063e-10,  8.665815829402931e-14, -5.594955953712983e-15,
  4.572186057303992e-17, -2.231851710377808e-19,  4.428738664760887e-22,  3.734225869268664e-24, -5.171191785070165e-26,  3.061015860238360e-01, -2.673943130121732e-03,
  1.519731765219323e-05, -5.757844980829253e-08,  5.935149961928997e-11,  1.165973445029893e-12, -1.123001390977439e-14,  5.304167041182680e-17, -4.693805595682664e-20,
 -1.597052659071502e-21,  1.566026517146662e-23, -7.657274089726314e-26,  4.062021347057618e-01, -3.419863230950392e-03,  1.750672815377732e-05, -4.659452586845383e-08,
 -1.368778462661309e-10,  2.410224770790012e-12, -1.329767712968056e-14,  1.269893256819946e-17,  4.205917690127386e-19, -3.928749925012116e-21,  1.410188043277111e-23,
  5.272081162742912e-26,  5.195157665186173e-01, -4.177899968488797e-03,  1.853084945611072e-05, -2.064718713392757e-08, -3.940906171651071e-10,  3.228766844450215e-12,
 -6.983263418326406e-15, -8.283613744904843e-17,  8.918498057482762e-19, -2.825181697133211e-21, -2.073699809686700e-23,  2.889948350685815e-25,  6.453315436320616e-01,
 -4.902754821090325e-03,  1.772077518836761e-05,  2.042126366882750e-08, -6.454163770499395e-10,  2.829529146669820e-12,  1.000263266604213e-14, -1.869600999812425e-16,
  6.905116183210775e-19,  4.779258991806842e-21, -6.649971601947508e-23,  1.832200738458912e-25,  7.826271528296461e-01, -5.539372838205453e-03,  1.459563448479795e-05,
  7.266028760292696e-08, -7.818511177580708e-10,  5.585013284784382e-13,  3.253530288546540e-14, -1.873288404133306e-16, -7.365448186402659e-19,  1.388714879717716e-20,
 -3.249047703491727e-23, -6.286909428063559e-25,  9.299423642523713e-01, -6.022809235524430e-03,  8.870347593351632e-06,  1.263971616062344e-07, -6.725885281194910e-10,
 -3.465693008651537e-12,  4.455821368659983e-14,  2.944635155290056e-17, -2.631158481707490e-18,  7.944027387569088e-21,  1.307330183561856e-22, -1.008251068309568e-24,
  1.085206619999019e+00, -6.280011664784041e-03,  6.497547042916291e-07,  1.654952627841932e-07, -2.237216771349311e-10, -7.597295926000469e-12,  2.414958659065685e-14,
  4.008617088603306e-16, -2.225477385652568e-18, -2.181935948106248e-20,  1.908685475986314e-22,  1.123487508770379e-24,  1.245512000752431e+00, -6.235493226701748e-03,
 -9.314623317266096e-06,  1.693564090320975e-07,  5.166380828042195e-10, -8.523462943184717e-12, -3.428319764950825e-14,  5.269168450970264e-16,  2.496006366859474e-18,
 -3.642032571580509e-20, -1.945787839118571e-22,  2.679767284783878e-24,  1.406833233726574e+00, -5.823985462097084e-03, -1.937084676531784e-05,  1.205408151015977e-07,
  1.245573888439997e-09, -3.150454728761566e-12, -8.809889302044922e-14, -4.230516692052601e-17,  6.296814737356502e-18,  2.183188877408436e-20, -4.344907965749697e-22,
 -3.092971882653258e-24,  1.563726317355826e+00, -5.013831739264815e-03, -2.691952640083564e-05,  1.992357491471829e-08,  1.430125471628948e-09,  6.806949047108215e-12,
 -5.774008851386946e-14, -8.368805332892019e-16, -4.599463407520053e-19,  6.549371940585928e-20,  4.352226722456647e-22, -3.057294968864589e-24,  1.709102955567438e+00,
 -3.842837136739623e-03, -2.897656346101127e-05, -9.623079109808076e-08,  6.953617504381527e-10,  1.192098576801358e-11,  5.534308170200030e-14, -4.181499378136487e-16,
 -8.341148955192584e-18, -4.187748464199058e-20,  3.435233039295121e-22,  7.078945967199743e-24,  1.834288483509019e+00, -2.458946879891723e-03, -2.377440758093234e-05,
 -1.597031577868206e-07, -5.066666192711407e-10,  4.308241499731610e-12,  8.660905400771726e-14,  7.105794602359554e-16,  1.625867232570044e-18, -4.086286310479897e-20,
 -6.646310959621765e-22, -4.786973304804092e-24,  1.929684539202973e+00, -1.138085100665516e-03, -1.306505686072012e-05, -1.229293811514111e-07, -9.565674171232857e-10,
 -5.659530142204790e-12, -1.507800180416539e-14,  1.981895967909203e-16,  4.123269824829639e-18,  4.603784115605745e-20,  3.547682493826422e-22,  1.467242561891558e-24,
  1.986322163239713e+00, -2.329747285300291e-04, -2.945671246643893e-06, -3.265420883247010e-08, -3.334523150387768e-10, -3.197188057764724e-12, -2.897615165264694e-14,
 -2.480059868741687e-16, -1.988049217386058e-18, -1.463078594875069e-20, -9.430747701483914e-23, -4.608979701172978e-25,  1.756691494750580e-03, -1.656611709319377e-05,
  1.170748397123739e-07, -7.350224167835269e-10,  4.320125012866145e-12, -2.435842277785930e-14,  1.331980135010130e-16, -7.134190544552841e-19,  3.742467944541220e-21,
 -1.945886768824305e-23,  9.874375105901094e-26, -5.079613998784968e-28,  1.580803847430784e-02, -1.485184579932342e-04,  1.040586409083990e-06, -6.433043066920064e-09,
  3.690166621691236e-11, -2.007968157407715e-13,  1.044683809920759e-15, -5.231495155154192e-18,  2.506174256284019e-20, -1.157655565441032e-22,  4.970667135400583e-25,
 -2.083224468414882e-27,  4.389834836959607e-02, -4.093128022311655e-04,  2.817529888728379e-06, -1.686449597389026e-08,  9.176128398002690e-11, -4.600940534851467e-13,
  2.111385906881299e-15, -8.690153022109719e-18,  2.959758089547240e-20, -6.529694830373605e-23, -1.599173463322500e-25,  2.901383014022419e-27,  8.599925040290171e-02,
 -7.925577312325363e-04,  5.306458607781184e-06, -3.013603994842604e-08,  1.495473047787523e-10, -6.378082659607893e-13,  2.128437688599546e-15, -3.401177734043594e-18,
 -2.472941941813903e-20,  3.166057553615438e-22, -2.350295359029714e-24,  1.270609574521611e-26,  1.420587349102919e-01, -1.288230382814701e-03,  8.292302496728319e-06,
 -4.350955635083333e-08,  1.845395885700769e-10, -5.443528576677535e-13,  1.994242709266579e-17,  1.449979345411231e-17, -1.325198398132585e-19,  7.768298350157215e-22,
 -3.255175301953740e-24,  5.068899379939845e-27,  2.119884913637864e-01, -1.882129614077060e-03,  1.148390077286660e-05, -5.356074118644175e-08,  1.690718816422743e-10,
 -3.304961969930846e-14, -4.412152876294547e-15,  3.885968156080473e-17, -2.050601077959324e-19,  5.512262124042440e-22,  1.788433370294415e-24, -3.729071551783502e-26,
  2.956446196343780e-01, -2.555110531255808e-03,  1.451279747631961e-05, -5.645641273741361e-08,  8.009497629632253e-11,  9.140564200579244e-13, -9.773694646260564e-15,
  5.073410405875350e-17, -9.396096340354416e-20, -1.037116037708165e-21,  1.236860859699293e-23, -7.222837864013962e-26,  3.927992003763967e-01, -3.282079622146678e-03,
  1.693598854169357e-05, -4.841612899515935e-08, -9.182867224057178e-11,  2.096741523180539e-12, -1.277414617561356e-14,  2.400743946089799e-17,  2.897376098859438e-19,
 -3.332504491012094e-21,  1.538681701867217e-23,  8.259840753890945e-27,  5.030989461103658e-01, -4.030746585590674e-03,  1.824734998227464e-05, -2.644587232377147e-08,
 -3.313628866758096e-10,  3.036461405070529e-12, -8.919418944554159e-15, -5.606052766833154e-17,  7.781148062702270e-19, -3.418301007666720e-21, -9.378138420146671e-24,
  2.261351850342411e-25,  6.260053666934392e-01, -4.760179575202731e-03,  1.790577536957331e-05,  1.055863665334541e-08, -5.868356743711710e-10,  3.009411673655415e-12,
  5.099404395896752e-15, -1.626067195973646e-16,  8.168912330705109e-19,  2.308533316415568e-21, -5.645360898481717e-23,  2.634163549895259e-25,  7.607084150350598e-01,
 -5.419331616493314e-03,  1.539300129329196e-05,  6.028063049691404e-08, -7.633093213348963e-10,  1.274194479148795e-12,  2.703320099978281e-14, -2.031997036080187e-16,
 -2.659810367326598e-19,  1.210970232128776e-20, -5.451354801793072e-23, -3.728919564499408e-25,  9.060023943132157e-01, -5.945967224747015e-03,  1.032044625240143e-05,
  1.151394510631764e-07, -7.311895581166995e-10, -2.395618052140641e-12,  4.425362234949608e-14, -4.925569705822394e-17, -2.262210226926739e-18,  1.223702576412085e-20,
  8.306700440547512e-23, -1.125361489635932e-24,  1.060109446201108e+00, -6.266942031799124e-03,  2.609318428718093e-06,  1.607353023250738e-07, -3.690070113299560e-10,
 -6.891734615198996e-12,  3.426961256217288e-14,  3.186350026048414e-16, -2.863721916198773e-18, -1.342599092161753e-20,  2.230127772107490e-22,  3.316588656384772e-25,
  1.220434045932853e+00, -6.301753800650449e-03, -7.238505388481284e-06,  1.762193216292903e-07,  3.391772317851365e-10, -9.161449327291038e-12, -1.861773766940134e-14,
  5.845510330379790e-16,  1.074913113899290e-18, -4.166455119827148e-20, -6.419725708094025e-23,  3.149692821988884e-24,  1.383236990478134e+00, -5.972833016369271e-03,
 -1.780723341713650e-05,  1.398510585777053e-07,  1.161445411337463e-09, -5.255673255654788e-12, -8.636964375998064e-14,  1.681729155431778e-16,  6.741046924351073e-18,
  2.171443751511145e-21, -5.362577385127869e-22, -1.412912987304679e-24,  1.543242354312897e+00, -5.227832806934208e-03, -2.653892454215206e-05,  4.381143322998082e-08,
  1.550509849482706e-09,  5.140623182003157e-12, -8.100215861664979e-14, -8.108268589910927e-16,  2.171281699130242e-18,  7.939067338883122e-20,  2.394754288055559e-22,
 -5.810868230192952e-24,  1.693260959937381e+00, -4.079061017265523e-03, -3.005648882639129e-05, -8.313001820475864e-08,  9.459540461225372e-10,  1.307727715934693e-11,
  3.969398005944920e-14, -7.058996090360634e-16, -9.522278714186594e-18, -2.147782320227516e-20,  6.848810983943067e-22,  8.218611676006143e-24,  1.824059983067575e+00,
 -2.656938389206237e-03, -2.573625749735087e-05, -1.670007156489580e-07, -3.980801067089471e-10,  6.629939787832093e-12,  1.069735689993007e-13,  7.335316320406078e-16,
 -3.737077867911028e-19, -7.155380320138144e-20, -8.645205481903186e-22, -4.030688322151486e-24,  1.924913436445874e+00, -1.248775071882770e-03, -1.463583304012308e-05,
 -1.391574707569533e-07, -1.072843326019869e-09, -5.938268461833894e-12, -7.412100669617061e-15,  3.595072228130294e-16,  6.050047979982615e-18,  6.133424717489884e-20,
  4.038123550939681e-22,  6.003200685580739e-25,  1.985340517088745e+00, -2.582033170381477e-04, -3.371772490868874e-06, -3.854127771168877e-08, -4.049521460277105e-10,
 -3.983648188234550e-12, -3.689556825228118e-14, -3.208187163840170e-16, -2.587553480661891e-18, -1.880801490450251e-20, -1.143410558506804e-22, -4.299304479467492e-25,
  1.692245973604773e-03, -1.566366030660414e-05,  1.086537707926597e-07, -6.696306303221595e-10,  3.863373334515789e-12, -2.138846756351902e-14,  1.147987856025565e-16,
 -6.041478356241454e-19,  3.107954520653984e-21, -1.592397593777060e-23,  7.874085061417486e-26, -4.062786920882098e-28,  1.523013889230523e-02, -1.404928121359689e-04,
  9.668042068220400e-07, -5.873429851700685e-09,  3.312504148395305e-11, -1.773952813828807e-13,  9.088294300272409e-16, -4.492536852355122e-18,  2.123080081546079e-20,
 -9.762706887865118e-23,  4.119216153563156e-25, -1.800132675073732e-27,  4.230493027354272e-02, -3.875577817171514e-04,  2.623670055248013e-06, -1.546725806450501e-08,
  8.304697002143297e-11, -4.122358686851748e-13,  1.880960487373112e-15, -7.781648286615509e-18,  2.715920213155427e-20, -6.950024355262485e-23, -5.863845903689568e-26,
  1.746571305485247e-27,  8.291168864716869e-02, -7.515128670241891e-04,  4.958770614661724e-06, -2.784259077106934e-08,  1.372938309031134e-10, -5.879480697142106e-13,
  2.023716128487680e-15, -4.027255224503261e-18, -1.489670951618836e-20,  2.329422457381166e-22, -1.853022439706085e-24,  9.938519117629784e-27,  1.370352532660250e-01,
 -1.223931053373588e-03,  7.787544789491344e-06, -4.064386364699257e-08,  1.736878330187360e-10, -5.394565471190339e-13,  3.705954842462603e-16,  1.068195152439487e-17,
 -1.068391162057217e-19,  6.515892593706980e-22, -2.997357093289688e-24,  6.378653325516266e-27,  2.046397095159744e-01, -1.792783421751139e-03,  1.085736330880930e-05,
 -5.086627562382431e-08,  1.674363535147147e-10, -1.266071789444472e-13, -3.412884580707508e-15,  3.262607554259650e-17, -1.842914777752903e-19,  5.934412909357166e-22,
  4.027030797753189e-25, -2.625383820447776e-26,  2.856521240684354e-01, -2.441694964488443e-03,  1.384357293842778e-05, -5.504091252083550e-08,  9.614359253635807e-11,
  6.961634082186211e-13, -8.400201746268318e-15,  4.721936801691464e-17, -1.231385484834140e-19, -6.038014904284839e-22,  9.353743086538731e-24, -6.449717092076059e-26,
  3.799381468834767e-01, -3.148937585372760e-03,  1.634750999947121e-05, -4.956632057180718e-08, -5.290022828264288e-11,  1.799169606522648e-12, -1.198932293342056e-14,
  3.147841106186032e-17,  1.808424096608076e-19, -2.719584219181439e-21,  1.503964562609358e-23, -2.193984920253228e-26,  4.872657862249629e-01, -3.886122780902352e-03,
  1.790015372656048e-05, -3.127396016119548e-08, -2.728874134386042e-10,  2.806256841987692e-12, -1.015942726313675e-14, -3.318388842966137e-17,  6.505258303459648e-19,
 -3.613724245412347e-21, -8.681106213020462e-25,  1.610128285598149e-25,  6.072517239861995e-01, -4.616581566948955e-03,  1.797814643631443e-05,  1.655927317230496e-09,
 -5.257768388535182e-10,  3.080177184910701e-12,  9.219050858482224e-16, -1.355489059804840e-16,  8.622519035571550e-19,  2.932084142996412e-22, -4.412961484314799e-23,
  2.887624587332023e-25,  7.392816676371284e-01, -5.293499599874491e-03,  1.604404100466790e-05,  4.830485700673176e-08, -7.318016388593456e-10,  1.854141471843870e-12,
  2.128682251092887e-14, -2.051845216695641e-16,  1.274192486069264e-19,  9.672438271790703e-21, -6.564952453545215e-23, -1.399195826071072e-25,  8.823921180436849e-01,
 -5.858079113966326e-03,  1.163052966324239e-05,  1.031142153029937e-07, -7.686332347958357e-10, -1.357833599086963e-12,  4.193123113269237e-14, -1.140532758143379e-16,
 -1.773758297805199e-18,  1.457657893016399e-20,  3.438066972330977e-23, -1.061733420979845e-24,  1.035095487925186e+00, -6.238462730584027e-03,  4.498321422125674e-06,
  1.537760421718221e-07, -4.979495191240400e-10, -5.972942369196449e-12,  4.184815570742643e-14,  2.209989310846482e-16, -3.185063443934910e-18, -4.441983475362650e-21,
  2.207288382959571e-22, -4.156993791622760e-25,  1.195124719032256e+00, -6.351125115395336e-03, -5.097422377862433e-06,  1.801616649012770e-07,  1.528199138931598e-10,
 -9.409375908443848e-12, -1.996193334881855e-15,  5.947259820688827e-16, -4.377274265772602e-19, -4.145786921071023e-20,  7.348921951263563e-23,  3.007513138061579e-24,
  1.359071805911175e+00, -6.108270830361348e-03, -1.602135009517490e-05,  1.574826904269434e-07,  1.036110384312423e-09, -7.247741095136668e-12, -7.865910043318527e-14,
  3.809125889813702e-16,  6.423781887406254e-18, -1.989633262789620e-20, -5.510355411540203e-22,  7.883848948322762e-25,  1.521910334748642e+00, -5.437612425930341e-03,
 -2.586130841592438e-05,  6.932892026499892e-08,  1.632094821574642e-09,  2.934678658945364e-12, -1.022928450076384e-13, -6.943116042807860e-16,  5.133615875184402e-18,
  8.315150205031547e-20, -6.711755644897342e-23, -7.949749863230903e-24,  1.676457883998841e+00, -4.323225691406628e-03, -3.095445865520840e-05, -6.585797497149053e-08,
  1.215244925138753e-09,  1.375780999777429e-11,  1.558837194908834e-14, -1.016988492800059e-15, -9.715297481537048e-18,  1.310949434692706e-20,  1.039390532469484e-21,
  7.503401951260880e-24,  1.813007618943685e+00, -2.870941743079079e-03, -2.777363520804074e-05, -1.721627874355849e-07, -2.381619836024536e-10,  9.439794013947121e-12,
  1.269083651791800e-13,  6.733731349876657e-16, -3.609139670215003e-18, -1.090202928940273e-19, -9.878487607036935e-22, -1.137236544153588e-24,  1.919673162933424e+00,
 -1.372842178463637e-03, -1.641265585617077e-05, -1.572789089763977e-07, -1.192450107519546e-09, -5.971335044426617e-12,  5.718847595118650e-15,  5.915770076796512e-16,
  8.550590693678216e-18,  7.748670760416748e-20,  3.877045537543323e-22, -1.626388295668263e-24,  1.984250662425693e+00, -2.871440088791667e-04, -3.875937052604744e-06,
 -4.570923843835633e-08, -4.942587918527988e-10, -4.986951571518167e-12, -4.714600144163449e-14, -4.153711435066351e-16, -3.351139454265620e-18, -2.371401692155030e-20,
 -1.293567504417252e-22, -2.063951422502166e-25,  1.631280342647273e-03, -1.482555313862291e-05,  1.009754403476362e-07, -6.110946700368723e-10,  3.461841394628068e-12,
 -1.882556081910784e-14,  9.919296779654198e-17, -5.132911437757154e-19,  2.587293963884080e-21, -1.310838929353390e-23,  6.256971160291406e-26, -3.333342773697110e-28,
  1.468320250436421e-02, -1.330315552510822e-04,  8.993896969703678e-07, -5.370668747664607e-09,  2.978544922840245e-11, -1.570192344037480e-13,  7.920432337444653e-16,
 -3.866355344060370e-18,  1.799431623788534e-20, -8.267041669356269e-23,  3.373053571382372e-25, -1.609343181871110e-27,  4.079553343949457e-02, -3.672888719101599e-04,
  2.445771138872007e-06, -1.420208385483751e-08,  7.523653207926469e-11, -3.696115677858741e-13,  1.674863078228028e-15, -6.952906089647899e-18,  2.463080303706041e-20,
 -7.060274834618401e-23, -3.578139350838073e-27,  7.695647891989448e-28,  7.998291303595177e-02, -7.131426792719943e-04,  4.637460128743339e-06, -2.573736145615810e-08,
  1.260111802593827e-10, -5.407786494233796e-13,  1.905442675617088e-15, -4.383271512312021e-18, -7.746616550506821e-21,  1.667953784928918e-22, -1.473289712833295e-24,
  7.329470904694230e-27,  1.322611064551204e-01, -1.163535173778816e-03,  7.316138243488117e-06, -3.795059309850419e-08,  1.630099640561197e-10, -5.273385891645579e-13,
  6.251908339976949e-16,  7.615829129583579e-18, -8.547179278086785e-20,  5.373499097888201e-22, -2.716201586225398e-24,  6.159875903444211e-27,  1.976384918122033e-01,
 -1.708320773685097e-03,  1.026294473485933e-05, -4.821170265326724e-08,  1.641557535374510e-10, -1.982006471605198e-13, -2.578695500785395e-15,  2.707157410100274e-17,
 -1.628928507395601e-19,  5.889446380305559e-22, -5.718617233948820e-25, -1.861326173734326e-26,  2.761026964954305e-01, -2.333561204524559e-03,  1.319273696693198e-05,
 -5.340174147347729e-08,  1.081555283325250e-10,  5.099613671466721e-13, -7.136009869411875e-15,  4.299795456223279e-17, -1.388018663041884e-19, -2.839120426039565e-22,
  6.701819925781078e-24, -5.614770857013413e-26,  3.676001728273782e-01, -3.020548442930596e-03,  1.574877338442548e-05, -5.014018084324226e-08, -1.971986997697549e-11,
  1.522570161069151e-12, -1.104081352017807e-14,  3.581271203244005e-17,  9.347422354057388e-20, -2.143656384675200e-21,  1.361614675108376e-23, -4.131345513980447e-26,
  4.720052214648427e-01, -3.744492748516199e-03,  1.750047746436970e-05, -3.520468070387157e-08, -2.192641530999219e-10,  2.553512978705365e-12, -1.081667099841135e-14,
 -1.444251529108688e-17,  5.213466638575605e-19, -3.525060943885951e-21,  4.859425297422253e-24,  1.003799444767885e-25,  5.890729781885282e-01, -4.472815238746356e-03,
  1.794957640783826e-05, -6.263705911338077e-09, -4.642433500810937e-10,  3.059874564887983e-12, -2.487873872411358e-15, -1.081038679575138e-16,  8.440804573501676e-19,
 -1.220108888753001e-21, -3.165678544096760e-23,  2.724171657380710e-25,  7.183677679821125e-01, -5.163024699760001e-03,  1.655475467165274e-05,  3.691851031041134e-08,
 -6.900716507399799e-10,  2.296847352881175e-12,  1.564742137003421e-14, -1.960510978793639e-16,  4.274093108883105e-19,  6.981106400832994e-21, -6.759444565258904e-23,
  4.146311844862803e-26,  8.591534293069191e-01, -5.760296177068852e-03,  1.279338917285077e-05,  9.065231360018312e-08, -7.860161471440989e-10, -3.957277104839429e-13,
  3.802336065464995e-14, -1.622406117746870e-16, -1.235074419654006e-18,  1.506634812757529e-20, -8.504077608807242e-24, -8.722371203085030e-25,  1.010225094400749e+00,
 -6.195239066187843e-03,  6.292070645877030e-06,  1.449096444815588e-07, -6.069235146361378e-10, -4.905936113343308e-12,  4.659706300547960e-14,  1.181752436673952e-16,
 -3.192163674311941e-18,  3.837018483463664e-21,  1.890457705588925e-22, -9.879358383652375e-25,  1.169652391938380e+00, -6.383229458716689e-03, -2.927014943920251e-06,
  1.811042962444383e-07, -3.451179039319150e-11, -9.260391971711537e-12,  1.424116064900477e-14,  5.576556587533199e-16, -1.846893796303705e-18, -3.604227315950320e-20,
  1.921665889998401e-22,  2.307087065276634e-24,  1.334394732199075e+00, -6.228612303257306e-03, -1.403719608548374e-05,  1.728022807763846e-07,  8.732579808877439e-10,
 -8.985155977811048e-12, -6.525311066805597e-14,  5.708673962583572e-16,  5.325231723695819e-18, -4.057654213115877e-20, -4.668933360177142e-22,  2.986837657912917e-24,
  1.499752004583789e+00, -5.640727612544311e-03, -2.487119264672427e-05,  9.577235535529480e-08,  1.664770964276085e-09,  2.676548940131542e-13, -1.189914622776024e-13,
 -4.833649664359449e-16,  7.991243865258853e-18,  7.314427982990514e-20, -4.380809019517108e-22, -8.603673343219852e-24,  1.658665199018067e+00, -4.573671003496972e-03,
 -3.161897279946628e-05, -4.420278457859109e-08,  1.491657189543385e-09,  1.375583044309093e-11, -1.710807277230865e-14, -1.311701046485918e-15, -8.422369650443556e-18,
  6.048270835607541e-20,  1.303816544801056e-21,  4.002549009296014e-24,  1.801066318291179e+00, -3.101443964242255e-03, -2.985566903892478e-05, -1.742913970353324e-07,
 -1.746471820568420e-11,  1.269489751953253e-11,  1.435013782582498e-13,  4.874467626900714e-16, -8.243839686288440e-18, -1.480219027402639e-19, -9.186357233904754e-22,
  4.856293790158234e-24,  1.913906768759340e+00, -1.512026157014883e-03, -1.841837809764028e-05, -1.772998448212784e-07, -1.308991481949334e-09, -5.601713980381914e-12,
  2.655324547975304e-14,  9.126173954064072e-16,  1.159206272255810e-17,  9.043278272217466e-20,  2.266407116937526e-22, -6.170946093735660e-24,  1.983036397177811e+00,
 -3.204879872774901e-04, -4.475398642838875e-06, -5.448095254558286e-08, -6.063210298818273e-10, -6.270962852107955e-12, -6.041322766607711e-14, -5.372751116157116e-16,
 -4.298884568492058e-18, -2.892128045967518e-20, -1.263260668023292e-22,  4.431943815505972e-25,  1.573548586593891e-03, -1.404616833722935e-05,  9.396262224363999e-08,
 -5.585926734566975e-10,  3.108018907883967e-12, -1.660845922143038e-14,  8.591226328371258e-17, -4.375928649728697e-19,  2.157050199677417e-21, -1.088367016241186e-23,
  4.899123587939190e-26, -2.887877390973650e-28,  1.416506947886793e-02, -1.260863602701676e-04,  8.377006901915857e-07, -4.918227484533096e-09,  2.682671095898212e-11,
 -1.392468849842436e-13,  6.914170982194229e-16, -3.335687983628591e-18,  1.524425359075669e-20, -7.056607542962088e-23,  2.683279510466855e-25, -1.553382963893847e-27,
  3.936445909931074e-02, -3.483844864298522e-04,  2.282331793613219e-06, -1.305531779032100e-08,  6.823094900653131e-11, -3.316643135614716e-13,  1.490834308559681e-15,
 -6.205365997195283e-18,  2.209208847289282e-20, -7.035589935364879e-23,  8.562808533282066e-27, -2.451948921319330e-28,  7.720263296610595e-02, -6.772449226005321e-04,
  4.340359884171981e-06, -2.380526462419480e-08,  1.156428495955458e-10, -4.965436597986536e-13,  1.780065620817243e-15, -4.545878683840325e-18, -2.732137623307105e-21,
  1.135292895819831e-22, -1.209965206424982e-24,  4.582437090557358e-27,  1.277212012729501e-01, -1.106784153509311e-03,  6.876034865394982e-06, -3.542592543513245e-08,
  1.526289866376265e-10, -5.100670191035101e-13,  8.029042916196078e-16,  5.169784742534332e-18, -6.802096745725034e-20,  4.337232224327691e-22, -2.477998273067190e-24,
  4.386065514221373e-27,  1.909658143564243e-01, -1.628487049042972e-03,  9.700022229742099e-06, -4.562003794588034e-08,  1.596312902981077e-10, -2.515629159257318e-13,
 -1.890520346445843e-15,  2.219231084446213e-17, -1.422861917417257e-19,  5.511489924728765e-22, -1.288707516397891e-24, -1.461333846518428e-26,  2.669755194164150e-01,
 -2.230552457395908e-03,  1.256260652846304e-05, -5.159856435136765e-08,  1.167370050209430e-10,  3.526348239736633e-13, -5.995445379740205e-15,  3.843979861296175e-17,
 -1.447730096131382e-19, -6.311552572718780e-23,  4.385746273012806e-24, -4.963265642428623e-26,  3.557661441391251e-01, -2.896968125857142e-03,  1.514615731097799e-05,
 -5.022613861688531e-08,  8.164418876286359e-12,  1.269894069437397e-12, -1.000705501077684e-14,  3.767044973921513e-17,  2.563015634306448e-20, -1.639468113293167e-21,
  1.149994589511309e-23, -5.420695798051654e-26,  4.573045033581696e-01, -3.606234604173812e-03,  1.705861126889396e-05, -3.831855507881116e-08, -1.708133993267771e-10,
  2.290829658334938e-12, -1.100626312206851e-14,  2.553081672099546e-19,  3.988578616380403e-19, -3.258710108080801e-21,  8.065009776008923e-24,  4.637499350496146e-26,
  5.714682622444437e-01, -4.329640934514997e-03,  1.783185090262106e-05, -1.320623860713542e-08, -4.038725561208771e-10,  2.966846132643325e-12, -5.144847158247912e-15,
 -8.201768253781172e-17,  7.801495938475933e-19, -2.258298779857410e-21, -2.058541544288788e-23,  2.268787500185771e-25,  6.979830908358078e-01, -5.028998658751401e-03,
  1.693310690424452e-05,  2.626342790337800e-08, -6.408150611206355e-10,  2.608271505957107e-12,  1.038356410673091e-14, -1.788687091409231e-16,  6.308654457586053e-19,
  4.352898665732801e-21, -6.297160817926403e-23,  1.573462388785296e-25,  8.363235261740773e-01, -5.653811836369748e-03,  1.380565441662200e-05,  7.806070277586912e-08,
 -7.851940251818202e-10,  4.583511087791681e-13,  3.300796699763111e-14, -1.932212916377236e-16, -7.074151775923033e-19,  1.402971880077704e-20, -4.151181792029564e-23,
 -6.239986629967961e-25,  9.855555820122857e-01, -6.138118978785074e-03,  7.969683209033948e-06,  1.344756005275654e-07, -6.936498510219464e-10, -3.759265013070430e-12,
  4.850652283679361e-14,  1.960325966749941e-17, -2.929480135075229e-18,  1.041375122597256e-20,  1.373792934772171e-22, -1.319141323495184e-24,  1.144086374164049e+00,
 -6.397975888582609e-03, -7.631140407903988e-07,  1.790941892901034e-07, -2.150763824858200e-10, -8.739051453580300e-12,  2.884469208047861e-14,  4.794594429594533e-16,
 -2.984255700511784e-18, -2.662211379932880e-20,  2.710039496238997e-22,  1.235138741542090e-24,  1.309269137484946e+00, -6.332392018229828e-03, -1.188592613888452e-05,
  1.852574560575093e-07,  6.792821853338878e-10, -1.034163476953953e-11, -4.712676466296817e-14,  7.145885187902679e-16,  3.564966546788028e-18, -5.608767541198327e-20,
 -2.968310150317708e-22,  4.604117807790907e-24,  1.476799072263604e+00, -5.834647884849026e-03, -2.356244359405999e-05,  1.222922987721622e-07,  1.640629005734231e-09,
 -2.719360463126759e-12, -1.285780903875104e-13, -1.896239702136253e-16,  1.021987803718361e-17,  4.831085284602163e-20, -7.931448128612124e-22, -7.169357432406386e-24,
  1.639861852130006e+00, -4.828318088995317e-03, -3.199723591613031e-05, -1.817065156702824e-08,  1.759545396099091e-09,  1.287642835159324e-11, -5.720831583994284e-14,
 -1.536068094814932e-15, -5.279148463997058e-18,  1.144289905825438e-19,  1.345333284155093e-21, -2.596793128765580e-24,  1.788169625874217e+00, -3.348639521392861e-03,
 -3.193984638815076e-05, -1.723484843912491e-07,  2.718032548833483e-10,  1.626773866851283e-11,  1.526081313683368e-13,  1.318570595459750e-16, -1.415979109758624e-17,
 -1.779456259228461e-19, -5.084144299103752e-22,  1.433200658722438e-23,  1.907549981754719e+00, -1.668247863344366e-03, -2.067519874857517e-05, -1.990958760661756e-07,
 -1.412353589547407e-09, -4.612824329635041e-12,  5.779802121974445e-14,  1.336752647040626e-15,  1.492702309520017e-17,  9.199594805983167e-20, -2.068851371715529e-22,
 -1.420615535414410e-23,  1.981678452226643e+00, -3.590812517204012e-04, -5.191785589611050e-06, -6.526962910912857e-08, -7.475425443759914e-10, -7.917945116850688e-12,
 -7.754598706497282e-14, -6.924148332431606e-16, -5.423124296488845e-18, -3.321951723693826e-20, -7.751251905774822e-23,  1.976853149760329e-24,  1.518826023245895e-03,
 -1.332045896360069e-05,  8.754727023291640e-08, -5.114137248781872e-10,  2.795515027971461e-12, -1.468614533156899e-14,  7.456967374043915e-17, -3.744824829938473e-19,
  1.797509181939514e-21, -9.172086222872611e-24,  3.667498621696622e-26, -2.769275973294486e-28,  1.367376349313900e-02, -1.196137387538235e-04,  7.811682577862526e-07,
 -4.510408796270619e-09,  2.420042320530996e-11, -1.237208191486694e-13,  6.044793453450309e-16, -2.886581390078114e-18,  1.288038747583308e-20, -6.122647491466411e-23,
  1.975649219601841e-25, -1.703821601700001e-27,  3.800647180972561e-02, -3.307344203037177e-04,  2.132005392051605e-06, -1.201480251626443e-08,  6.194179213088509e-11,
 -2.978917469977810e-13,  1.326600797329986e-15, -5.538920041560017e-18,  1.955963121673820e-20, -7.058759713696263e-23, -2.979766165527053e-26, -1.574368839443198e-27,
  7.456133326425411e-02, -6.436339812550947e-04,  4.065478103848327e-06, -2.203214822001580e-08,  1.061288458751812e-10, -4.553559282972976e-13,  1.652106862637344e-15,
 -4.576915099829192e-18,  5.240039460043242e-22,  6.823711384911488e-23, -1.079049003704503e-24,  1.223760859487185e-27,  1.234014464426285e-01, -1.053435572195342e-03,
  6.465243014339348e-06, -3.306438041549303e-08,  1.426308559405894e-10, -4.892924804410011e-13,  9.193977200215230e-16,  3.224132321327531e-18, -5.415288003270399e-20,
  3.375205951056606e-22, -2.359448727392209e-24,  6.268101118152803e-28,  1.846036601683873e-01, -1.553033610695491e-03,  9.167732916665826e-06, -4.310845036090804e-08,
  1.541940566166976e-10, -2.899753476306027e-13, -1.329975139251713e-15,  1.794542951888994e-17, -1.235247657539992e-19,  4.869938211507979e-22, -1.921103290043342e-24,
 -1.490677402590367e-26,  2.582504352722724e-01, -2.132496096801678e-03,  1.195483890013835e-05, -4.968181224727381e-08,  1.224352657171681e-10,  2.211354145966543e-13,
 -4.984113905132796e-15,  3.380036394280510e-17, -1.444035354847065e-19,  6.968546187605018e-23,  2.270785493773985e-24, -4.740271639631174e-26,  3.444167985415228e-01,
 -2.778205654056885e-03,  1.454502427450748e-05, -4.990501444160223e-08,  3.124630237506671e-11,  1.042423218599504e-12, -8.949067939607691e-15,  3.763019886733530e-17,
 -2.571544669574707e-20, -1.230459398426991e-21,  8.868220776445737e-24, -6.557607756040505e-26,  4.431495293927437e-01, -3.471648076982342e-03,  1.658385604485311e-05,
 -4.069936187686819e-08, -1.276307280236663e-10,  2.028101307687362e-12, -1.083759965305137e-14,  1.120711069179536e-17,  2.877085425826846e-19, -2.909998835482491e-21,
  9.013109549268479e-24, -2.763224627212865e-27,  5.544338552457984e-01, -4.187725417737313e-03,  1.763653864708960e-05, -1.920094407358063e-08, -3.459421714177673e-10,
  2.818552542798552e-12, -7.105082263175424e-15, -5.849412802077891e-17,  6.862725372751758e-19, -2.900175231862390e-21, -1.198811837266053e-23,  1.611007361780236e-25,
  6.781397811864942e-01, -4.892443416413895e-03,  1.718851056235973e-05,  1.643959043197701e-08, -5.865509079470108e-10,  2.799786140536742e-12,  5.678044467992153e-15,
 -1.566451218631413e-16,  7.440789830999169e-19,  1.991328748327921e-21, -5.476315791738613e-23,  2.046165771332850e-25,  8.139348016576328e-01, -5.539832293040126e-03,
  1.466744103683770e-05,  6.561209730521358e-08, -7.685546023834452e-10,  1.183515929126397e-12,  2.735420373369324e-14, -2.081471818630012e-16, -2.381752842715589e-19,
  1.189394434339504e-20, -6.350190906121462e-23, -3.810848324089609e-25,  9.611405677969097e-01, -6.068100660013529e-03,  9.514523867840521e-06,  1.228389738435411e-07,
 -7.572022729010475e-10, -2.598733316840720e-12,  4.780625524730804e-14, -6.719766721144814e-17, -2.470085557589776e-18,  1.470453994872061e-20,  7.648010338207526e-23,
 -1.413473489121989e-24,  1.118495772175542e+00, -6.395555797749474e-03,  1.359734945099279e-06,  1.742966921380300e-07, -3.819065193146382e-10, -7.897280052335654e-12,
  4.080395989488918e-14,  3.708064179557166e-16, -3.737623224943213e-18, -1.504602865311444e-20,  2.990838073684344e-22,  4.221922483411591e-26,  1.283763713819453e+00,
 -6.418418388607562e-03, -9.604631026242161e-06,  1.944168663460401e-07,  4.628181923702486e-10, -1.122162194842480e-11, -2.583868417769578e-14,  7.944827360356344e-16,
  1.383417797297849e-18, -6.365033926786384e-20, -7.695223628208273e-23,  5.198828617121066e-24,  1.453093399013525e+00, -6.016836381109805e-03, -2.193977680762846e-05,
  1.479384773202487e-07,  1.555149952229383e-09, -5.830619468035662e-12, -1.290945789120298e-13,  1.585501644926326e-16,  1.131991750296449e-17,  1.117526909822594e-20,
 -1.037965349345358e-21, -3.657713176393945e-24,  1.620035943799145e+00, -5.084670557564750e-03, -3.203815125145627e-05,  1.195278918511134e-08,  1.999778987189872e-09,
  1.097238995653332e-11, -1.018919569012524e-13, -1.629074105946902e-15, -2.410867659549947e-19,  1.634640805969883e-19,  1.041999192107769e-21, -1.140364285084014e-23,
  1.774251070366090e+00, -3.612331067180881e-03, -3.397055271949408e-05, -1.651975359391482e-07,  6.337928933669592e-10,  1.991741070255663e-11,  1.489736445176820e-13,
 -4.262438171811612e-16, -2.074925542259833e-17, -1.822807443334957e-19,  3.779237099969275e-22,  2.611693115105991e-23,  1.900530504945608e+00, -1.843596670130525e-03,
 -2.320269833797903e-05, -2.223424814277448e-07, -1.487415169717330e-09, -2.719577544543183e-12,  1.023928758311808e-13,  1.864394364501344e-15,  1.790954979886146e-17,
  6.788918038092309e-20, -1.089097469380768e-21, -2.664648648130127e-23,  1.980153794365380e+00, -4.039645366617161e-04, -6.052357512841936e-06, -7.860525992387181e-08,
 -9.261889789529179e-10, -1.003243159918521e-11, -9.954601034570653e-14, -8.854726733521199e-16, -6.646879380933961e-18, -3.378208165378196e-20,  7.314252968174841e-23,
  5.263280808919946e-24,  1.466907121093641e-03, -1.264388998886842e-05,  8.166928763557681e-08, -4.689414807762449e-10,  2.518871848876840e-12, -1.301609505446088e-14,
  6.484168850099768e-17, -3.219862403979648e-19,  1.490745976050042e-21, -7.953413728987092e-24,  2.408114522015071e-26, -3.010506289104381e-28,  1.320747349049436e-02,
 -1.135744928662559e-04,  7.292874173143507e-07, -4.142235782868027e-09,  2.186476735142032e-11, -1.101386165684094e-13,  5.291041191499312e-16, -2.508302643047273e-18,
  1.079951419958469e-20, -5.492579419949815e-23,  1.144655476227962e-25, -2.114255644198739e-27,  3.671675629230976e-02, -3.142386813338476e-04,  1.993583027828708e-06,
 -1.106971812247883e-08,  5.629013463583228e-11, -2.678460375142139e-13,  1.179889161625539e-15, -4.954065428688987e-18,  1.697577934180382e-20, -7.367249311400008e-23,
 -1.379842867387071e-25, -3.428300914746367e-27,  7.205021040394191e-02, -6.121395108532452e-04,  3.810987019083776e-06, -2.040483279917663e-08,  9.740787085746311e-11,
 -4.172393389442401e-13,  1.524498165623829e-15, -4.529138219111053e-18,  2.205729053493714e-21,  2.494314509019428e-23, -1.117397620754943e-24, -3.125704774506067e-27,
  1.192886889488527e-01, -1.003262658544631e-03,  6.081844037708851e-06, -3.085934731452791e-08,  1.330720073783205e-10, -4.663288678386278e-13,  9.871095841066009e-16,
  1.667396413610692e-18, -4.370888822370250e-20,  2.420580223490739e-22, -2.458314875907410e-24, -5.482446187651965e-27,  1.785349918262543e-01, -1.481719463409927e-03,
  8.665037588119018e-06, -4.068931279178677e-08,  1.481138141395074e-10, -3.162961159491987e-13, -8.803200640331014e-16,  1.425696903108131e-17, -1.075441716920775e-19,
  3.958756604234322e-22, -2.671720853439734e-24, -1.994391412943068e-26,  2.499079998967466e-01, -2.039208514736242e-03,  1.137053669183241e-05, -4.769365319381181e-08,
  1.257357590763013e-10,  1.123542832302780e-13, -4.101918147418151e-15,  2.923300928091702e-17, -1.407678150581043e-19,  1.181361898862400e-22,  1.242345311594982e-25,
 -5.114653982177862e-26,  3.335329175268400e-01, -2.664230891122979e-03,  1.394981491840944e-05, -4.924959940794860e-08,  5.003168992774431e-11,  8.401577216472328e-13,
 -7.913147820517363e-15,  3.616115343493071e-17, -6.435682321810570e-20, -9.372856986130734e-22,  5.689014779124021e-24, -7.948456231677497e-26,  4.295251405692173e-01,
 -3.340962522052307e-03,  1.608450425520297e-05, -4.243096535248928e-08, -8.963933313037359e-11,  1.772710527374066e-12, -1.041016546713019e-14,  1.880612795649756e-17,
  1.892809967422044e-19, -2.565918818338517e-21,  7.846186565639392e-24, -5.005453818535220e-26,  5.379635516490527e-01, -4.047644628728869e-03,  1.737474568573080e-05,
 -2.429482892004342e-08, -2.913966003192883e-10,  2.630758641400661e-12, -8.451749591677402e-15, -3.828393274414016e-17,  5.747379812165209e-19, -3.260623701619226e-21,
 -6.615701707754579e-24,  8.145212336250889e-26,  6.588460535257378e-01, -4.754301476846487e-03,  1.733134464672736e-05,  7.508703705917191e-09, -5.295335928018403e-10,
  2.886168598665791e-12,  1.633193719443635e-15, -1.320926968963879e-16,  7.785102185024869e-19, -1.963592242305700e-23, -4.590260378022011e-23,  1.887918778160488e-25,
  7.920148455881295e-01, -5.419550410121330e-03,  1.538189618641577e-05,  5.353826393027661e-08, -7.387941910765579e-10,  1.769595494405223e-12,  2.148008347108503e-14,
 -2.094371841058430e-16,  1.408059333884880e-19,  9.079263270148804e-21, -7.584933144630461e-23, -1.914855113585861e-25,  9.370294378327843e-01, -5.986297706210935e-03,
  1.091438478466067e-05,  1.103694855351671e-07, -7.978998604103530e-10, -1.482386197263119e-12,  4.490121106641766e-14, -1.373011460040641e-16, -1.900530160308890e-18,
  1.653470381231976e-20,  1.566762404577010e-23, -1.326794120110582e-24,  1.092948389269646e+00, -6.376427197195409e-03,  3.409601423712546e-06,  1.669791127056791e-07,
 -5.292898537329400e-10, -6.807327529626895e-12,  4.944703856153117e-14,  2.448283750264052e-16, -4.066542142562485e-18, -3.377808846729232e-21,  2.764657553965196e-22,
 -1.034266788678069e-24,  1.257951296854859e+00, -6.485814778633934e-03, -7.234692673401701e-06,  2.000004305072450e-07,  2.340031829276478e-10, -1.157192920881191e-11,
 -3.319531539750539e-15,  8.019392635603444e-16, -9.089185862526896e-19, -6.224106158796320e-20,  1.431661666923714e-22,  4.618588710827259e-24,  1.428686844512467e+00,
 -6.184840493610842e-03, -2.001960828711146e-05,  1.717218858321846e-07,  1.408126515572248e-09, -8.834604762697839e-12, -1.195819310613921e-13,  5.189768431497431e-16,
  1.094839573764919e-17, -3.219941995240854e-20, -1.095560303187255e-21,  1.154151026397825e-24,  1.599186348283586e+00, -5.339842355817075e-03, -3.169596986868032e-05,
  4.555651603864616e-08,  2.191097505522305e-09,  7.984440104725165e-12, -1.466784974228633e-13, -1.535731886233544e-15,  6.248513145541356e-18,  1.924434066787616e-19,
  3.435386558680285e-22, -2.005610449896915e-23,  1.759245947090535e+00, -3.891821068319828e-03, -3.587831878073521e-05, -1.516812861662595e-07,  1.066515139298994e-09,
  2.326863131694857e-11,  1.267914749099182e-13, -1.189844433772006e-15, -2.673153077458129e-17, -1.408460014686625e-19,  1.769757308872357e-21,  3.643583652259981e-23,
  1.892767401651545e+00, -2.040298446213479e-03, -2.601491102742179e-05, -2.464237965953787e-07, -1.512660999430444e-09,  4.309448498083229e-13,  1.629122646763646e-13,
  2.465632824425599e-15,  1.924546980650784e-17, -3.713967755097411e-21, -2.610023062084331e-21, -4.291538761789053e-23,  1.978434747621683e+00, -4.564245089492844e-04,
 -7.091600765800210e-06, -9.516815685293975e-08, -1.152865776421772e-09, -1.274418044771851e-11, -1.274927803948078e-13, -1.116521465095544e-15, -7.740209682404069e-18,
 -2.459180224019744e-20,  4.342994827950831e-22,  1.188643206982495e-23,  1.417603572024223e-03, -1.201237899567992e-05,  7.627547668299462e-08, -4.306405244962340e-10,
  2.273408446723967e-12, -1.156294994045789e-14,  5.645205587881350e-17, -2.787042674486200e-19,  1.218458103417193e-21, -7.267270969538578e-24,  9.937253767487787e-27,
 -3.391385512755056e-28,  1.276453748864510e-02, -1.079332366725057e-04,  6.816090854293486e-07, -3.809354931717903e-09,  1.978348534651150e-11, -9.824565649021307e-14,
  4.634177693189994e-16, -2.193663106666374e-18,  8.880757167847346e-21, -5.236334330737852e-23,  9.995015681160843e-27, -2.603188985950987e-27,  3.549087868780205e-02,
 -2.988064500242060e-04,  1.865978342475089e-06, -1.021043884898841e-08,  5.120545814377783e-11, -2.411343759127183e-13,  1.048372278964256e-15, -4.454672849028233e-18,
  1.418229951642323e-20, -8.281609056156430e-23, -3.334463076021882e-25, -5.346725450932804e-27,  6.966111397002547e-02, -5.826051732357639e-04,  3.575211125162973e-06,
 -1.891112018044551e-08,  8.941873514519335e-11, -3.821646844103426e-13,  1.398741981712061e-15, -4.453166868538467e-18,  2.253285339236652e-21, -2.389182304747579e-23,
 -1.357048320896568e-24, -7.539319513825583e-27,  1.153706526846266e-01, -9.560536597175409e-04,  5.724003211879493e-06, -2.880350749799573e-08,  1.239853327975187e-10,
 -4.422286846733702e-13,  1.015386461327105e-15,  3.885612938039036e-19, -3.684207365621110e-20,  1.368067724948944e-22, -2.854043999248619e-24, -1.219006513242027e-26,
  1.727437184194933e-01, -1.414312450343714e-03,  8.190772641229262e-06, -3.837111819046782e-08,  1.416069930762087e-10, -3.330099495035848e-13, -5.273198684489103e-16,
  1.102110841837474e-17, -9.544748817791685e-20,  2.692912515168184e-22, -3.709711440215218e-24, -2.691288474620784e-26,  2.419295181727826e-01, -1.950499179056709e-03,
  1.081034105217519e-05, -4.566898407429676e-08,  1.270620706245527e-10,  2.322537514488854e-14, -3.345837767182480e-15,  2.479292156017320e-17, -1.369863300123566e-19,
  7.606361023331575e-23, -2.276378459487083e-24, -5.752824468966008e-26,  3.230954688449456e-01, -2.554981532237304e-03,  1.336414477640926e-05, -4.832464619625901e-08,
  6.501637253427023e-11,  6.621298251979211e-13, -6.934267797458493e-15,  3.359866745837122e-17, -9.488665183208525e-20, -7.841012703733560e-22,  1.869152475473467e-24,
 -9.299804409872916e-26,  4.164153868167741e-01, -3.214344948986006e-03,  1.556785382788523e-05, -4.359494557852549e-08, -5.663772740818366e-11,  1.529786546671956e-12,
 -9.812279773497143e-15,  2.344061966656184e-17,  1.019061460805680e-19, -2.309177368835838e-21,  4.689700647186955e-24, -9.093321547000583e-26,  5.220490159416286e-01,
 -3.909888149419030e-03,  1.705693335667429e-05, -2.854760270263898e-08, -2.408864010759789e-10,  2.417021361385470e-12, -9.284194337843044e-15, -2.181596753733933e-17,
  4.532331637760668e-19, -3.477929289481443e-21, -4.833442133834162e-24,  1.995052682629166e-27,  6.401065222472249e-01, -4.615429940257269e-03,  1.737252232183704e-05,
 -5.011241238944750e-10, -4.717033394351559e-10,  2.883784258882358e-12, -1.719172027217968e-15, -1.075306607716512e-16,  7.466219444242094e-19, -1.704652677082242e-21,
 -3.876352396829241e-23,  1.328223277502603e-25,  7.705865432612107e-01, -5.294123494065736e-03,  1.595468435832656e-05,  4.202672115859232e-08, -6.987182291356787e-10,
  2.215536474747339e-12,  1.572380260405851e-14, -2.003012652680018e-16,  4.113940049582335e-19,  5.917286960744031e-21, -8.135033846105723e-23, -6.708359330913476e-26,
  9.132669563518520e-01, -5.893903801180969e-03,  1.216142765860922e-05,  9.742303347266385e-08, -8.171158690351784e-10, -4.572110716179652e-13,  4.029504297767855e-14,
 -1.885843223092332e-16, -1.307599240853448e-18,  1.604691875895384e-20, -3.856025190465134e-23, -1.121296492586984e-24,  1.067509708167547e+00, -6.341289272964251e-03,
  5.358260708301292e-06,  1.574878470834408e-07, -6.530900467146454e-10, -5.553079438541643e-12,  5.447676443176821e-14,  1.147829358553186e-16, -4.002425880819318e-18,
  6.515369334089444e-21,  2.125366445181454e-22, -1.808289464217405e-24,  1.231907549367740e+00, -6.534046230374567e-03, -4.819854035972257e-06,  2.018961933712980e-07,
  3.561112295849158e-12, -1.138745446227965e-11,  1.840079549486601e-14,  7.384829785768675e-16, -3.001078353548645e-18, -5.285034690570367e-20,  3.150192197961275e-22,
  3.069316999555040e-24,  1.403640741441893e+00, -6.336386113307866e-03, -1.783008628648933e-05,  1.926880747442075e-07,  1.204110766238413e-09, -1.149197486591700e-11,
 -1.003792525145500e-13,  8.425082361484539e-16,  9.025997886846136e-18, -7.354802699761138e-20, -9.369143081986197e-22,  5.931497629215575e-24,  1.577324161368343e+00,
 -5.590616600433445e-03, -3.093433494395618e-05,  8.168618667682370e-08,  2.312244566097269e-09,  3.977196140812655e-12, -1.858298356472687e-13, -1.224125197709139e-15,
  1.319341023962844e-17,  1.866551944954976e-19, -6.704724406856195e-22, -2.515353705406425e-23,  1.743093539387088e+00, -4.185801849178820e-03, -3.758025115417911e-05,
 -1.307418477842932e-07,  1.559101747547850e-09,  2.581106084222731e-11,  8.085395217690467e-14, -2.109477114830412e-15, -3.012624581584782e-17, -3.647969779385045e-20,
  3.465820670083540e-21,  3.867794288656802e-23,  1.884170662970206e+00, -2.260655363640921e-03, -2.911617234663413e-05, -2.703202683757896e-07, -1.458994902973052e-09,
  5.237942523725702e-12,  2.403853330096239e-13,  3.055206851690091e-15,  1.673221992558784e-17, -1.508074349501266e-19, -4.859836549166605e-21, -5.854830027979209e-23,
  1.976487881526499e+00, -5.180594722175385e-04, -8.353273726376819e-06, -1.158304706416490e-07, -1.441027516139790e-09, -1.620781656907153e-11, -1.623253858401573e-13,
 -1.373817364894466e-15, -8.158819924841986e-18,  6.412679872844834e-21,  1.207898109695210e-21,  2.458328412135057e-23,  1.370742585392027e-03, -1.142224467057779e-05,
  7.131863744090061e-08, -3.960450249295484e-10,  2.055087592426710e-12, -1.029757900919417e-14,  4.915525267605998e-17, -2.438520520432626e-19,  9.604033455022281e-22,
 -7.165097286797278e-24, -4.439820488082284e-27, -2.811106667822736e-28,  1.234342818114309e-02, -1.026579774265140e-04,  6.377331004658943e-07, -3.507954502691287e-09,
  1.792497581760303e-11, -8.783033267303244e-14,  4.056896298723309e-16, -1.939789367727931e-18,  6.975026504580466e-21, -5.426063583450220e-23, -1.021464989701783e-25,
 -2.188776034287411e-27,  3.432475173843078e-02, -2.843551543139071e-04,  1.748213966172553e-06, -9.428407463499808e-09,  4.662452975044171e-11, -2.174217866359697e-13,
  9.295258115658971e-16, -4.051590412002838e-18,  1.090222443995329e-20, -1.010112112558450e-22, -5.718541848622627e-25, -4.618087147213684e-27,  6.738649299555899e-02,
 -5.548874653572664e-04,  3.356615445653207e-06, -1.753978506963097e-08,  8.210107706877593e-11, -3.500841792046161e-13,  1.274854822810091e-15, -4.405987836161777e-18,
  3.308460802181214e-22, -8.527484994013992e-23, -1.707225556716542e-24, -6.637743220855481e-27,  1.116358797655654e-01, -9.116111419483258e-04,  5.389976136361303e-06,
 -2.688917334620052e-08,  1.153846609620115e-10, -4.178583381255129e-13,  1.010337857956992e-15, -7.347244573020175e-19, -3.410893953534996e-20,  1.126030087916940e-23,
 -3.412503823256527e-24, -1.031908396146466e-26,  1.672146584801070e-01, -1.350590075931434e-03,  7.743691752275597e-06, -3.615927670255319e-08,  1.348434835642740e-10,
 -3.422997965574299e-13, -2.602497363800244e-16,  8.090904002023860e-18, -8.871413666284452e-20,  9.697829702227944e-23, -4.872102509414911e-24, -2.166757001131258e-26,
  2.342970648746587e-01, -1.866173992899322e-03,  1.027451302150920e-05, -4.363641071463809e-08,  1.267772554615709e-10, -4.923787316233906e-14, -2.712748189547540e-15,
  2.043064831576947e-17, -1.364946794747244e-19, -6.495729159306574e-23, -4.702062779935937e-24, -4.670259522804799e-26,  3.130857225804058e-01, -2.450369323338118e-03,
  1.279089916754167e-05, -4.718717239306122e-08,  7.666906385857014e-11,  5.066276742727267e-13, -6.040201663963861e-15,  3.011703075718534e-17, -1.227587367036419e-19,
 -7.910443088814713e-22, -2.131952227165929e-24, -8.025486691988261e-26,  4.038037606796794e-01, -3.091907837935193e-03,  1.504024609473530e-05, -4.426894977070011e-08,
 -2.834219776115143e-11,  1.302460653090274e-12, -9.122575004243288e-15,  2.539950938991166e-17,  2.113201532481240e-20, -2.206925604881043e-21,  4.088926160726230e-25,
 -9.131853214730411e-26,  5.066801169029849e-01, -3.774864894296226e-03,  1.669279254764391e-05, -3.202734798871864e-08, -1.948156849157338e-10,  2.188392383990006e-12,
 -9.711085710563299e-15, -9.353957846974468e-18,  3.244193228146793e-19, -3.684839316962704e-21, -5.739272170391840e-24, -2.713733431613263e-26,  6.219225493786207e-01,
 -4.476597755049492e-03,  1.732311866563940e-05, -7.590189822510134e-09, -4.146704609379312e-10,  2.809026476271744e-12, -4.406841354308772e-15, -8.490936369549521e-17,
  6.586212086123531e-19, -3.151807882041498e-21, -3.378288655188543e-23,  1.097346333925373e-25,  7.496682545540244e-01, -5.164655296464595e-03,  1.639345159289393e-05,
  3.122034136199505e-08, -6.510796290278476e-10,  2.527268383492392e-12,  1.032719425699172e-14, -1.843602202077615e-16,  5.654214524525360e-19,  2.636589171931547e-21,
 -8.177936021240432e-23,  6.064995643458236e-26,  8.898930138702422e-01, -5.792158692638372e-03,  1.325192428824533e-05,  8.432669685591129e-08, -8.170392068910037e-10,
  4.422981905916946e-13,  3.451306616695695e-14, -2.215737131466747e-16, -7.687982775527484e-19,  1.360411123946466e-20, -8.113385761741678e-23, -7.822175081540040e-25,
  1.042241990995198e+00, -6.291049385905250e-03,  7.181985672323177e-06,  1.462217869982338e-07, -7.508905612256984e-10, -4.221271424449114e-12,  5.594361512627627e-14,
 -8.065137120077648e-18, -3.635261859147678e-18,  1.329713014469366e-20,  1.244021048153669e-22, -2.098580254917745e-24,  1.205709569677269e+00, -6.562930195762017e-03,
 -2.404177151616330e-06,  2.001619865982842e-07, -2.181601150169473e-10, -1.071022213829110e-11,  3.746651195162615e-14,  6.146688419506633e-16, -4.649507259259968e-18,
 -3.811912276301094e-20,  4.072838747122416e-22,  1.126990314659808e-24,  1.378024998230381e+00, -6.469468534009658e-03, -1.541022020580218e-05,  2.099928105926461e-07,
  9.522484559133054e-10, -1.358804728221665e-11, -7.319167703135030e-14,  1.082324777532667e-15,  5.777214724563001e-18, -1.046616846251895e-19, -5.935803667661671e-22,
  9.381806374327145e-24,  1.554473847580651e+00, -5.833536995616296e-03, -2.973031482795550e-05,  1.190654109205683e-07,  2.344685070551643e-09, -8.403487415818303e-13,
 -2.132340459444356e-13, -7.017788398279176e-16,  1.916184118310549e-17,  1.376256502952047e-19, -1.768692827014397e-21, -2.343390259880897e-23,  1.725739762743721e+00,
 -4.492255581309221e-03, -3.898216233605522e-05, -1.015830641596671e-07,  2.089379213397699e-09,  2.693365824853794e-11,  8.304040676839962e-15, -3.064574012147250e-15,
 -2.855517888285870e-17,  1.336087203274020e-19,  4.942042246871706e-21,  2.535555841639371e-23,  1.874641091406902e+00, -2.506946815136614e-03, -3.249552472437288e-05,
 -2.924825578694757e-07, -1.289328256051825e-09,  1.208775780221279e-11,  3.323134498057719e-13,  3.461045228932532e-15,  7.158673245496447e-18, -3.991652559826373e-19,
 -7.583701981692898e-21, -6.171735384153520e-23,  1.974272600493160e+00, -5.908635622726650e-04, -9.892997837040713e-06, -1.417054369158697e-07, -1.807407924340198e-09,
 -2.059412563773192e-11, -2.043323605445704e-13, -1.619431053382086e-15, -6.745770680904801e-18,  8.222596971663609e-20,  2.750460170607299e-21,  4.770468667127124e-23,
  1.326165374514984e-03, -1.087016199558118e-05,  6.675679058089374e-08, -3.647493997028370e-10,  1.860397146886749e-12, -9.196554500509479e-15,  4.271851577861598e-17,
 -2.173000721991034e-19,  6.970313298915421e-22, -7.500068348700025e-24, -9.033275954895750e-27,  1.780882144411576e-28,  1.194274010790084e-02, -9.771974900051727e-05,
  5.973021403089982e-07, -3.234696760011804e-09,  1.626145780736836e-11, -7.872216618085683e-14,  3.542001572712417e-16, -1.748779297286798e-18,  4.931413509205239e-21,
 -5.948577586235852e-23, -1.301249132900406e-25,  1.876517746603856e-27,  3.321460346346251e-02, -2.708096470656237e-04,  1.639409355624688e-06, -8.716028278228644e-09,
  4.249018008649591e-11, -1.964386049953793e-13,  8.203855258913799e-16, -3.765607501743569e-18,  6.822408494214929e-21, -1.258522957413438e-22, -5.915159619240406e-25,
  6.424682311917390e-27,  6.521934679619126e-02, -5.288546415181005e-04,  3.153793942999201e-06, -1.628056085903862e-08,  7.539535825561245e-11, -3.209701975346504e-13,
  1.151077546654469e-15, -4.458067965155490e-18, -4.005667498918551e-21, -1.553907320630587e-22, -1.645949268897844e-24,  1.479236031589368e-26,  1.080736747198305e-01,
 -8.697512551791135e-04,  5.078111440361356e-06, -2.510856784249713e-08,  1.072676696074018e-10, -3.939810183558538e-13,  9.743543468234379e-16, -1.846614338112371e-18,
 -3.621412653635669e-20, -1.275264931752697e-22, -3.269502472103914e-24,  2.581425500724880e-26,  1.619335002309783e-01, -1.290340031908878e-03,  7.322498585736698e-06,
 -3.405681701680583e-08,  1.279517286468386e-10, -3.461461923178032e-13, -7.319985743049424e-17,  5.268990124899699e-18, -8.887034462455129e-20, -1.060658320541335e-22,
 -4.875174668534423e-24,  3.515664735437344e-26,  2.269934933001685e-01, -1.786038049922604e-03,  9.763003263791645e-06, -4.161920453173255e-08,  1.251852101560550e-10,
 -1.079762400936583e-13, -2.202469275670122e-15,  1.598593410403926e-17, -1.425765214208723e-19, -2.776340312108684e-22, -5.330653068658503e-24,  3.759411998126376e-26,
  3.034853438420691e-01, -2.350285539995982e-03,  1.223232295283832e-05, -4.588700498246076e-08,  8.541786595678683e-11,  3.713112080804249e-13, -5.256353773450248e-15,
  2.571089564514167e-17, -1.534360559255859e-19, -9.245140821589982e-22, -3.719164773148010e-24,  3.507435926715235e-26,  3.916734004561095e-01, -2.973716584187560e-03,
  1.450711959872531e-05, -4.452568483054265e-08, -4.424713373148207e-12,  1.092056030306891e-12, -8.413882490843602e-15,  2.480112983771692e-17, -5.878017255677410e-20,
 -2.245055452198583e-21, -1.310554376672072e-24,  4.986514125435278e-26,  4.918452374003503e-01, -3.642909612762615e-03,  1.629116518940843e-05, -3.480698895158748e-08,
 -1.533941758736638e-10,  1.953232302103321e-12, -9.847923050351351e-15, -1.140465735279931e-18,  1.875451858873166e-19, -3.912762488101437e-21, -4.544563719447790e-24,
  1.298402664609296e-25,  6.042925977467568e-01, -4.338485696659823e-03,  1.719406125786747e-05, -1.378198640453189e-08, -3.597283174950830e-10,  2.677000403868694e-12,
 -6.508096720909445e-15, -6.589879556333428e-17,  5.222469838655078e-19, -4.374692302445747e-21, -2.598625504160183e-23,  3.041833215030620e-25,  7.292740564894332e-01,
 -5.032182280616207e-03,  1.670729895903110e-05,  2.121917947805479e-08, -5.984630065300525e-10,  2.715285908863356e-12,  5.428234835662984e-15, -1.653700681541438e-16,
  6.027522587581732e-19, -5.048352498887230e-22, -7.273952571939069e-23,  4.183796151382292e-25,  8.669425062159075e-01, -5.682316897515815e-03,  1.418584071485757e-05,
  7.136768846110211e-08, -8.004251698324258e-10,  1.193811667363456e-12,  2.803339478098570e-14, -2.390237916831949e-16, -3.443287273215478e-19,  9.834352011929653e-21,
 -1.023988118427354e-22, -9.342852271379776e-26,  1.017203521872189e+00, -6.226785040682749e-03,  8.862011122989131e-06,  1.336047777556747e-07, -8.219737618414510e-10,
 -2.894007424775958e-12,  5.416697351794819e-14, -1.159513093380350e-16, -3.088671063894027e-18,  1.650348617897743e-20,  3.961298177902932e-23, -1.580839308750197e-24,
  1.179434489567749e+00, -6.572631111520687e-03, -3.007194411029593e-08,  1.950121795966202e-07, -4.220703812486356e-10, -9.622463489346646e-12,  5.241078728150160e-14,
  4.471388255576617e-16, -5.721148362117956e-18, -2.132172437979627e-20,  4.224704057191334e-22, -2.396218719930229e-25,  1.351916857740516e+00, -6.582432850557347e-03,
 -1.280813894182383e-05,  2.229698899186811e-07,  6.654688812610851e-10, -1.496372056263041e-11, -4.089261915767423e-14,  1.203174536631176e-15,  1.687294107226282e-18,
 -1.195363835340358e-19, -1.378971219722149e-22,  1.108250085079679e-23,  1.530673959897344e+00, -6.065029731943343e-03, -2.807791059713330e-05,  1.561624781680135e-07,
  2.275485881330411e-09, -6.120432135945344e-12, -2.236629216278423e-13, -2.486776697226353e-17,  2.261506321229951e-17,  4.864889355176261e-20, -2.605110403637613e-21,
 -1.313892549144883e-23,  1.707140161708218e+00, -4.808379698567932e-03, -3.998285144648563e-05, -6.386374470388595e-08,  2.622585232527215e-09,  2.600585694228627e-11,
 -8.929125308411352e-14, -3.861509432564302e-15, -1.999014490162992e-17,  3.454302131778935e-19,  5.414058267882739e-21, -6.789073574603343e-24,  1.864070679945570e+00,
 -2.781279519426126e-03, -3.611961858390981e-05, -3.107112087210662e-07, -9.598988181480924e-10,  2.123657980406521e-11,  4.298226685931609e-13,  3.396629987673948e-15,
 -1.327923131581506e-17, -7.510725026708716e-19, -9.787488822806875e-21, -3.044850835064951e-23,  1.971739351074291e+00, -6.773341332472570e-04, -1.178147255152470e-05,
 -1.742012856852326e-07, -2.272114408555763e-09, -2.606301725874287e-11, -2.520755183137996e-13, -1.762008674843751e-15, -1.208824311028122e-18,  2.444393246027022e-19,
  5.647042094122116e-21,  8.718504312523060e-23,  1.283725810633761e-03, -1.035312324104485e-05,  6.255250107733952e-08, -3.364008156932034e-10,  1.686237624599525e-12,
 -8.242053758513189e-15,  3.690547123927170e-17, -1.993515323447266e-19,  4.252494737800401e-22, -7.375761774620601e-24,  2.569495872810064e-26,  1.625028270706869e-27,
  1.156117819951123e-02, -9.309229094435142e-05,  5.599963738772781e-07, -2.986663457881958e-09,  1.476813994181971e-11, -7.079312805713841e-14,  3.071162196716692e-16,
 -1.625919632995775e-18,  2.741576852694466e-21, -6.008729504314437e-23,  1.939841482943662e-25,  1.488817599374520e-26,  3.215694893784712e-02, -2.581014760617370e-04,
  1.538769792400930e-06, -8.066581250719192e-09,  3.874986931957296e-11, -1.779942546925839e-13,  7.172966277877014e-16, -3.623348293007891e-18,  2.004444400339114e-21,
 -1.356751447103504e-22,  3.615144740414349e-25,  4.259973878991549e-26,  6.315317993120070e-02, -5.043857276926738e-04,  2.965458072161062e-06, -1.512413212513925e-08,
  6.924200371741230e-11, -2.948623079084285e-13,  1.023537119588976e-15, -4.686309365099710e-18, -1.048924590917140e-20, -1.920961588206446e-22,  3.259726318057353e-25,
  8.617925464164134e-26,  1.046740516425312e-01, -8.303029888000086e-04,  4.786850356893479e-06, -2.345407153194258e-08,  9.961700835725761e-11, -3.713529900659313e-13,
  9.055750344024904e-16, -3.100463251180394e-18, -4.265217703441374e-20, -2.084971456603427e-22,  8.721209382329852e-26,  1.458237678439061e-25,  1.568867602019024e-01,
 -1.233360494106604e-03,  6.925871504817482e-06, -3.206502388014389e-08,  1.210215065801438e-10, -3.464587219438327e-13,  3.370403490235570e-17,  2.331712614866706e-18,
 -9.546657421277382e-20, -2.284014879718816e-22,  8.945927164415128e-26,  2.195598241738673e-25,  2.200024339252618e-01, -1.709897877318402e-03,  9.275510415249261e-06,
 -3.963624660865307e-08,  1.225306402350699e-10, -1.559903533727293e-13, -1.820498742863286e-15,  1.122896253398127e-17, -1.554885098740474e-19, -3.971886177487615e-22,
  1.279831433320635e-24,  3.045323508032035e-25,  2.942764649268561e-01, -2.254605777918425e-03,  1.169010251462434e-05, -4.446752923619436e-08,  9.163787634452022e-11,
  2.532111294770906e-13, -4.610356894457340e-15,  2.024728543430738e-17, -1.883056563643000e-19, -9.590146891205307e-22,  4.648160280296467e-24,  4.027459659310470e-25,
  3.800072644818960e-01, -2.859796473995568e-03,  1.397307245884529e-05, -4.443249165810426e-08,  1.545190833564449e-11,  8.981686503976682e-13, -7.757953596918066e-15,
  2.162709495070570e-17, -1.390837177291514e-19, -2.145082633994538e-21,  9.790213302314925e-24,  5.321936693451088e-25,  4.775315571669734e-01, -3.514289864461538e-03,
  1.586000301284630e-05, -3.696162062131003e-08, -1.166926687143253e-10,  1.717046112131625e-12, -9.817162342455518e-15,  2.590597869257597e-18,  4.594314987061691e-20,
 -3.845755346109593e-21,  1.227399242506578e-23,  7.368802713639975e-25,  5.872125796652159e-01, -4.201688577125968e-03,  1.699588119603045e-05, -1.911840128705824e-08,
 -3.078905924364744e-10,  2.500400647937794e-12, -8.144207496800628e-15, -5.187207601060682e-17,  3.507117002212680e-19, -4.978395601663925e-21,  1.300257050079044e-24,
  1.066878787157574e-24,  7.094140324881797e-01, -4.897663984702319e-03,  1.690628747364318e-05,  1.208376002321060e-08, -5.432184479172245e-10,  2.792143006043799e-12,
  1.061440974178217e-15, -1.468853495374781e-16,  5.386863527302583e-19, -2.809381169160951e-21, -3.498354335977302e-23,  1.458766783926145e-24,  8.444453313360440e-01,
 -5.565620197678850e-03,  1.496631222601974e-05,  5.878615716301014e-08, -7.703681768366874e-10,  1.785355094447955e-12,  2.123411038637686e-14, -2.451555176810354e-16,
 -6.176166846020249e-20,  6.028534077322493e-21, -7.660562785901053e-23,  1.468658127915173e-24,  9.924480069834655e-01, -6.149703445490196e-03,  1.038467424699451e-05,
  1.200594924325703e-07, -8.671721755876191e-10, -1.643571371133338e-12,  4.962743716501401e-14, -2.050888394004063e-16, -2.478969959303936e-18,  1.714036175601905e-20,
  6.390064930345137e-24,  3.779432232203408e-25,  1.153158124121030e+00, -6.563640068123110e-03,  2.263436729187670e-06,  1.867916796284053e-07, -6.010364550791607e-10,
 -8.235646888457189e-12,  6.227531235919217e-14,  2.550168588531750e-16, -6.187614646640911e-18, -4.655917838711983e-21,  4.149301502112090e-22,  3.507699840611647e-25,
  1.325399367012859e+00, -6.674037434002606e-03, -1.007863258650239e-05,  2.311813856367679e-07,  3.591236385422123e-10, -1.553876590436309e-11, -7.096735802396109e-15,
  1.188221455561202e-15, -2.595169876892375e-18, -1.150123950026143e-19,  3.715428057116716e-22,  1.214748098573079e-23,  1.505977321888394e+00, -6.281549478687813e-03,
 -2.599049552643832e-05,  1.913005746590740e-07,  2.099768540684737e-09, -1.141404540868917e-11, -2.141129441541622e-13,  7.058761995590012e-16,  2.239503159633093e-17,
 -6.221914461717027e-20, -2.803498062680225e-21,  5.332004165764647e-24,  1.687263121653589e+00, -5.130556041511631e-03, -4.048076472710337e-05, -1.789578009520102e-08,
  3.112195107256838e-09,  2.250607205918718e-11, -2.042086382456136e-13, -4.261751385220034e-15, -3.841267397995675e-18,  5.435529494807308e-19,  4.175573102799300e-21,
 -4.987664683440515e-23,  1.852343712652861e+00, -3.085375621700476e-03, -3.992438614049272e-05, -3.220801231093746e-07, -4.246703896758402e-10,  3.261784578430302e-11,
  5.143664614039528e-13,  2.462131266582199e-15, -4.749388465556637e-17, -1.147038697700393e-18, -9.323254201754237e-21,  6.431529583407454e-23,  1.968827344168957e+00,
 -7.806074250472259e-04, -1.410832308290192e-05, -2.150706374040972e-07, -2.857850875379885e-09, -3.269934306666039e-11, -3.002715261547319e-13, -1.607848706902141e-15,
  1.272730579846991e-17,  5.633982136099791e-19,  1.074713169201672e-20,  1.484347412428649e-22,  1.243289222605487e-03, -9.868404039524486e-06,  5.867228110862248e-08,
 -3.106934907678308e-10,  1.529808678463518e-12, -7.422000858456318e-15,  3.147666098244025e-17, -1.896094637582329e-19,  2.023538998597455e-22, -4.132756896146816e-24,
  1.594102613199521e-25,  4.781332015111495e-27,  1.119754752357397e-02, -8.875176794512301e-05,  5.255286856931926e-07, -2.761314964923570e-09,  1.342234075850006e-11,
 -6.396064054400349e-14,  2.625135336196141e-16, -1.569621107331687e-18,  9.381928349342430e-22, -3.214537234455519e-23,  1.410227456582681e-24,  4.336661852010161e-26,
  3.114856482079945e-02, -2.461682383033591e-04,  1.445576264440650e-06, -7.474161487396368e-09,  3.535393668383422e-11, -1.619936351027633e-13,  6.160531161574544e-16,
 -3.629782758808454e-18, -1.994158310366844e-21, -6.395574457899041e-23,  3.803188623240298e-24,  1.221764031613860e-25,  6.118196092421794e-02, -4.813696273762247e-04,
  2.790425309597267e-06, -1.406214871781057e-08,  6.357955581350779e-11, -2.719160227495105e-13,  8.866532207769243e-16, -5.120472013261988e-18, -1.591231550143621e-20,
 -6.407242258368086e-23,  7.221857174517974e-24,  2.438465197386740e-25,  1.014276843018167e-01, -7.931074424947441e-04,  4.514723375971123e-06, -2.191846738366717e-08,
  9.239942948024579e-11, -3.508217091809955e-13,  7.986209324514855e-16, -4.568492555304651e-18, -4.797078729971921e-20, -1.085530818161708e-23,  1.172338756465421e-23,
  4.110049015642907e-25,  1.520617410061571e-01, -1.179460251611582e-03,  6.552480807994848e-06, -3.018405332576124e-08,  1.141038950063403e-10, -3.452185797254245e-13,
  5.512870797719762e-17, -8.295050218552841e-19, -1.004107677415983e-19,  6.921415501799795e-23,  1.774398632732682e-23,  6.255769762597118e-25,  2.133082849482204e-01,
 -1.637563257539001e-03,  8.811528021374296e-06, -3.770299212715741e-08,  1.189964227239149e-10, -1.964837009385468e-13, -1.577634345873108e-15,  6.068837906998700e-18,
 -1.643594710569314e-19,  6.736368655593039e-23,  2.620277866985389e-23,  8.896444735280714e-25,  2.854417395714783e-01, -2.163194126974575e-03,  1.116543754144831e-05,
 -4.296664122342656e-08,  9.563788771942988e-11,  1.486551820817091e-13, -4.132472783264009e-15,  1.375096079832337e-17, -2.134520823669594e-19, -2.182389160788514e-22,
  3.825891266705309e-23,  1.209724065997073e-24,  3.687882785277581e-01, -2.750139150531994e-03,  1.344192650272332e-05, -4.405147454697419e-08,  3.159953501594581e-11,
  7.186742925983720e-13, -7.225437005774926e-15,  1.607722822804215e-17, -2.012774852646466e-19, -1.018987000891317e-21,  5.432403971916774e-23,  1.606154300343031e-24,
  4.637253072005297e-01, -3.389213211686360e-03,  1.540635292303530e-05, -3.856675146145038e-08, -8.470165582912509e-11,  1.482348165599815e-12, -9.743720303909051e-15,
  2.023071775908044e-18, -7.284748517902639e-20, -2.363706182317582e-21,  7.192397869659496e-23,  2.125322263054039e-24,  5.706761931483636e-01, -4.066719227815705e-03,
  1.673851744805277e-05, -2.365567981159982e-08, -2.599489738782190e-10,  2.288616293432473e-12, -9.465728321393485e-15, -4.339053424809844e-17,  1.875554741566943e-19,
 -3.552106853110986e-21,  8.288273439025180e-23,  2.836941286134277e-24,  6.900945925173083e-01, -4.761977173604424e-03,  1.700098718166336e-05,  3.839027289586666e-09,
 -4.874443310157149e-10,  2.770112578390974e-12, -2.826265154784876e-15, -1.313780695831593e-16,  4.328236891987273e-19, -2.355992586671087e-21,  7.437625473166888e-23,
  3.759363719868028e-24,  8.224264872578341e-01, -5.443274622430818e-03,  1.559905241282864e-05,  4.677127692083547e-08, -7.301212689994659e-10,  2.212561484379541e-12,
  1.437144559002969e-14, -2.440796725140208e-16,  1.226456885022226e-19,  5.047203931586036e-21,  5.042889424583080e-23,  4.617260220490954e-24,  9.680241367401046e-01,
 -6.061101154816929e-03,  1.174125878951616e-05,  1.059843739967544e-07, -8.886420549838173e-10, -5.298128847697923e-13,  4.286796394431577e-14, -2.744014064997008e-16,
 -1.844005189155802e-18,  1.878649552545387e-20,  1.067521825334630e-22,  4.618019229165631e-24,  1.126953728378971e+00, -6.536742035755263e-03,  4.442070571444105e-06,
  1.759406242237151e-07, -7.503408090660843e-10, -6.677766894600868e-12,  6.664177915239096e-14,  5.761335657470380e-17, -6.045049974422108e-18,  1.315253381398205e-20,
  5.050410610358326e-22,  4.419863842399229e-24,  1.298559635696291e+00, -6.743495730294325e-03, -7.280235254577792e-06,  2.344430024226522e-07,  4.927571547598846e-11,
 -1.532292603224439e-11,  2.441504809716820e-14,  1.042876474832034e-15, -6.333921732502550e-18, -8.883092945089795e-20,  9.584972070805760e-22,  1.506484295317716e-23,
  1.480450596088838e+00, -6.479739002421728e-03, -2.350172673809553e-05,  2.227995636747016e-07,  1.822108428886216e-09, -1.623742592238105e-11, -1.848018385096649e-13,
  1.365898597225113e-15,  1.825500668584556e-17, -1.628051127928697e-19, -2.047544498281761e-21,  2.974548541514362e-23,  1.666093082932569e+00, -5.454382362135325e-03,
 -4.038286285950368e-05,  3.519344525420595e-08,  3.503649579891300e-09,  1.617834013382908e-11, -3.221153503477411e-13, -4.044338599724050e-15,  1.809993265703985e-17,
  6.555375520830920e-19,  1.189535367495783e-21, -8.152209225073708e-23,  1.839338849805398e+00, -3.420292028192300e-03, -4.380636002079765e-05, -3.229654229279475e-07,
  3.556603215536635e-10,  4.557763555127734e-11,  5.553528477159948e-13,  2.178361533386594e-16, -9.440880048115030e-17, -1.417245784797213e-18, -2.897820339409420e-21,
  2.409252664439110e-22,  1.965461669694710e+00, -9.046270543453669e-04, -1.698641357169988e-05, -2.664339073044903e-07, -3.587220235800214e-09, -4.037802698512423e-11,
 -3.358683021423883e-13, -7.789798869821434e-16,  4.252596415360363e-17,  1.146559945766117e-18,  1.899479170740361e-20,  2.281227400062807e-22,  1.204731323137722e-03,
 -9.413533993935632e-06,  5.508605038615872e-08, -2.873648196399533e-10,  1.388496421135072e-12, -6.729619907083256e-15,  2.624742713860570e-17, -1.837933105276966e-19,
  2.312344397312473e-22,  7.812499645006871e-24,  4.743006330310629e-25,  9.755645292056603e-27,  1.085074407954031e-02, -8.467652577133875e-05,  4.936403049586436e-07,
 -2.556463788439063e-09,  1.220258604346448e-11, -5.818489055250443e-14,  2.189132017416329e-16, -1.542780686994277e-18,  1.366201336085630e-21,  7.471964777600700e-23,
  4.262234916903674e-24,  8.829619883206095e-26,  3.018646630918511e-02, -2.349530128517160e-04,  1.359175896158201e-06, -6.933648848708031e-09,  3.225364285508158e-11,
 -1.484359591644103e-13,  5.134596627295901e-16, -3.688559015221700e-18,  4.512129943244306e-23,  2.300859000920335e-22,  1.182035778619228e-23,  2.479342597289859e-25,
  5.930008437515601e-02, -4.597043204455892e-04,  2.627607307292688e-06, -1.308727597785109e-08,  5.834212163026266e-11, -2.524139091777760e-13,  7.363429012702786e-16,
 -5.585865954960653e-18, -9.822780043811109e-21,  5.076295000525461e-22,  2.319186365910463e-23,  4.934110113385206e-25,  9.832585908891098e-02, -7.580171359881514e-04,
  4.260343817364338e-06, -2.049521316170807e-08,  8.556341992722821e-11, -3.333594107015843e-13,  6.500361399612433e-16, -5.977258136724400e-18, -3.453483254688153e-20,
  9.346082682815128e-22,  3.862782921066743e-23,  8.310910070117643e-25,  1.474464888291729e-01, -1.128458727778464e-03,  6.200998493488733e-06, -2.841356843043406e-08,
  1.072090289481340e-10, -3.445285709309297e-13, -1.136861623764622e-17, -3.801742242944501e-18, -7.693688857409692e-20,  1.505266925567187e-21,  5.877060201894504e-23,
  1.268674295935324e-24,  2.068961962233396e-01, -1.568848721740299e-03,  8.370379561619940e-06, -3.583249679165533e-08,  1.146988517688108e-10, -2.328904829972273e-13,
 -1.479017974565755e-15,  1.141703794428513e-18, -1.313690749546694e-19,  2.151560906194557e-21,  8.479491721504076e-23,  1.816096865827983e-24,  2.769643815789878e-01,
 -2.075906820377102e-03,  1.065910006515445e-05, -4.141792187891531e-08,  9.764641310871298e-11,  5.333056311917602e-14, -3.841445755814234e-15,  7.214572144347454e-18,
 -1.778072526405643e-19,  2.726194325155626e-21,  1.183365321165463e-22,  2.489171159221618e-24,  3.579994583358052e-01, -2.644708582338197e-03,  1.291678655439447e-05,
 -4.344017636535898e-08,  4.427154089525038e-11,  5.499229483907371e-13, -6.867038840496633e-15,  9.634161477392384e-18, -1.776376355295837e-19,  3.034519263320936e-21,
  1.608922877626963e-22,  3.317943228198101e-24,  4.504119952687371e-01, -3.267834460528621e-03,  1.493635777834001e-05, -3.969749431093346e-08, -5.739020333573596e-11,
  1.248861610922989e-12, -9.727312062476171e-15, -8.960360640536595e-19, -7.817563833984797e-20,  2.992287287778541e-21,  2.122484162234008e-22,  4.360141105764553e-24,
  5.546752393471200e-01, -3.934013870485697e-03,  1.643116359028791e-05, -2.746143020797528e-08, -2.165437237230885e-10,  2.047449383439593e-12, -1.060966562401601e-14,
 -3.850543009008497e-17,  1.564216184057127e-19,  3.041039527885957e-21,  2.678267989913562e-22,  5.710574710982211e-24,  6.713188097189537e-01, -4.625913407170019e-03,
  1.700207383824505e-05, -3.521772736943541e-09, -4.330104888435277e-10,  2.659655507372750e-12, -6.317444126094873e-15, -1.179285311992408e-16,  4.504351009500471e-19,
  4.935446452603227e-21,  3.173469663699022e-22,  7.466000812131007e-24,  8.009062524305222e-01, -5.316432301468457e-03,  1.609173076496002e-05,  3.545977353385795e-08,
 -6.829713741063780e-10,  2.476101966053002e-12,  7.624933614897253e-15, -2.363829688205213e-16,  4.016478922510103e-19,  1.247235185645607e-20,  3.568984440536932e-22,
  9.542809245934579e-24,  9.439753052147266e-01, -5.962326000753692e-03,  1.292758562967921e-05,  9.173450699846713e-08, -8.896040080579557e-10,  4.008176033549556e-13,
  3.446897712003714e-14, -3.212609341990362e-16, -1.025532587440474e-18,  2.894571857959896e-20,  4.502273085535445e-22,  1.131283441099225e-23,  1.100890904052067e+00,
 -6.492973998387858e-03,  6.477200080275413e-06,  1.629537917284764e-07, -8.678820218571303e-10, -5.080276499118573e-12,  6.564854069907738e-14, -1.238520108233196e-16,
 -5.142323427606003e-18,  3.935450062627764e-20,  8.637358001332652e-22,  1.243082582480614e-23,  1.271486975212477e+00, -6.790493981729212e-03, -4.472172700320811e-06,
  2.328210640732995e-07, -2.490877852421966e-10, -1.441211833546490e-11,  5.035796895220877e-14,  7.978165543639477e-16, -8.667011330397258e-18, -3.553323747415427e-20,
  1.755641573815396e-21,  2.179277668122329e-23,  1.454173210479964e+00, -6.656589001181325e-03, -2.066466864177031e-05,  2.491284454002390e-07,  1.456421666933781e-09,
 -2.015362671170065e-11, -1.393551146675798e-13,  1.843502364888591e-15,  1.130617915349475e-17, -2.107367901722004e-19, -1.570511958194856e-22,  5.597559522712025e-23,
  1.643633476539095e+00, -5.774781310230240e-03, -3.961497582096647e-05,  9.338329102554320e-08,  3.741167549439647e-09,  7.176080531842053e-12, -4.236762414079773e-13,
 -3.085525704743936e-15,  4.167377969005464e-17,  6.301538619163620e-19, -2.398477168590639e-21, -7.301262579529691e-23,  1.824932468378435e+00, -3.786074542855658e-03,
 -4.761538509889754e-05, -3.092629310961618e-07,  1.399026353697871e-09,  5.859055667009561e-11,  5.114667238040690e-13, -3.617307309739472e-15, -1.443641675774203e-16,
 -1.255184996625509e-18,  1.266731976739471e-20,  4.676903367642637e-22,  1.961549667859357e+00, -1.054347158165628e-03, -2.055607423298894e-05, -3.307319930490360e-07,
 -4.476178590242590e-09, -4.850293578394305e-11, -3.312569075667164e-13,  1.409921007803869e-15,  1.001043832734704e-16,  2.129312828780826e-18,  3.061484656903395e-20,
  2.911987579016720e-22,  1.167937244207945e-03, -8.986271446426299e-06,  5.176663279247344e-08, -2.661931193212313e-10,  1.259792535239858e-12, -6.160186732394130e-15,
  2.127852348965005e-17, -1.672981600783100e-19,  9.716831449037732e-22,  3.691211363383680e-23,  1.015268226018004e-24,  1.440265800303398e-26,  1.051974650152483e-02,
 -8.084688114891838e-05,  4.640966705980829e-07, -2.370261084832310e-09,  1.108796938984906e-11, -5.344054191838959e-14,  1.770146036966903e-16, -1.414666849393854e-18,
  8.189999994507467e-21,  3.368486169189267e-22,  9.156781018747665e-24,  1.302903081835396e-25,  2.926788620800509e-02, -2.244038692828322e-04,  1.278972565155642e-06,
 -6.440705742708772e-09,  2.939983537398098e-11, -1.373406310310819e-13,  4.122314315910932e-16, -3.439604387602916e-18,  1.982868374444059e-20,  9.601245144216476e-22,
  2.555725299385078e-23,  3.655835854961749e-25,  5.750233608238765e-02, -4.392961598735828e-04,  2.475997210145073e-06, -1.219328159455081e-08,  5.345781204346453e-11,
 -2.366296230021648e-13,  5.798312081523494e-16, -5.381547938976786e-18,  3.109855897581226e-20,  1.947050355410547e-21,  5.051905858290851e-23,  7.271703809737050e-25,
  9.536043060472080e-02, -7.248953839198642e-04,  4.022397916498082e-06, -1.917874693381145e-08,  7.903821547244465e-11, -3.198481098547228e-13,  4.748392364535607e-16,
 -6.166309328271162e-18,  3.694285868096514e-20,  3.341725760510702e-21,  8.466086729095101e-23,  1.225143199523478e-24,  1.430297509402246e-01, -1.080185954236317e-03,
  5.870100193048983e-06, -2.675340373763873e-08,  1.003059498421186e-10, -3.462877831831739e-13, -1.402110116431619e-16, -4.821544260811430e-18,  3.486958817493030e-20,
  5.172704663453621e-21,  1.290984079500319e-22,  1.872952798966478e-24,  2.007520477014998e-01, -1.503574813506200e-03,  7.951240746449757e-06, -3.403650277820048e-08,
  1.096866145222478e-10, -2.683791603274979e-13, -1.488599785283320e-15, -9.942292213197175e-19,  2.906368246033772e-20,  7.430234529963612e-21,  1.856311862523844e-22,
  2.688582395346385e-24,  2.688281896989260e-01, -1.992595471464808e-03,  1.017147819325682e-05, -3.985199698195674e-08,  9.780463936265587e-11, -3.695388518226262e-14,
 -3.696466603332939e-15,  4.247241586056209e-18,  3.562158047558186e-20,  1.004958681745367e-20,  2.568275190961601e-22,  3.698042122088292e-24,  3.476240091674574e-01,
 -2.543446598389717e-03,  1.240008867530877e-05, -4.265271670833774e-08,  5.364105575392073e-11,  3.878617844318885e-13, -6.649769977326361e-15,  7.258056330940107e-18,
  8.758011852503920e-20,  1.292614967964170e-20,  3.457805015824310e-22,  4.943205770616551e-24,  4.375766025025103e-01, -3.150262872360865e-03,  1.445526151612665e-05,
 -4.042861580873127e-08, -3.475035117266474e-11,  1.014990577979854e-12, -9.757161884399102e-15,  3.826743625346366e-19,  2.350901270193381e-19,  1.602240040049456e-20,
  4.551456394774062e-22,  6.495907344195315e-24,  5.391999162488367e-01, -3.803938589839829e-03,  1.608214375906075e-05, -3.061272716115728e-08, -1.782247222180899e-10,
  1.780633484344048e-12, -1.158342111369621e-14, -2.913371654889062e-17,  5.276718426368507e-19,  1.968809369439534e-20,  5.850932014977826e-22,  8.475371905600612e-24,
  6.530867605968174e-01, -4.490179656697852e-03,  1.691996925578702e-05, -1.003372390312438e-08, -3.815915386587436e-10,  2.470310639202325e-12, -9.369395598323698e-15,
 -9.750768361833076e-17,  9.465947323281130e-19,  2.537310576015253e-20,  7.311502392401789e-22,  1.104441471363510e-23,  7.799004286286798e-01, -5.186178337203851e-03,
  1.645334315845028e-05,  2.493613299311700e-08, -6.321457713421115e-10,  2.581663537552675e-12,  1.278517232922046e-15, -2.126748356850439e-16,  1.223135682104393e-18,
  3.669981690660183e-20,  8.898145258845248e-22,  1.429804995899231e-23,  9.203394739486898e-01, -5.854743145814468e-03,  1.394339937798229e-05,  7.760680986906316e-08,
 -8.740582633148439e-10,  1.117534686288158e-12,  2.520194583587624e-14, -3.328261550538294e-16,  4.802569990119693e-19,  5.904119674694136e-20,  1.103436938142906e-21,
  1.789972168735727e-23,  1.075034684992325e+00, -6.433577852644856e-03,  8.346249238643385e-06,  1.483389465617307e-07, -9.541023805314655e-10, -3.563343392991067e-12,
  6.014446317586553e-14, -2.578343885498862e-16, -2.946702291059044e-18,  8.758543566961698e-20,  1.611995013405788e-21,  2.107654804940230e-23,  1.244271014972259e+00,
 -6.815185148539977e-03, -1.711512272088435e-06,  2.266024087464173e-07, -5.235998538583457e-10, -1.296744883414348e-11,  6.872993449157159e-14,  5.155836190859405e-16,
 -8.428386021088856e-18,  5.634161825837389e-20,  2.895585713586747e-21,  2.948066853801876e-23,  1.427235671039104e+00, -6.809583762563916e-03, -1.754915131765253e-05,
  2.690430892026038e-07,  1.024266760697112e-09, -2.284477580708159e-11, -8.379108419680032e-14,  2.087933107688175e-15,  4.261990001251745e-18, -1.611285710209096e-19,
  2.779063181670834e-21,  7.511112343452384e-23,  1.619909055119239e+00, -6.086193936911206e-03, -3.813235080288927e-05,  1.538112686113293e-07,  3.776873767324564e-09,
 -3.858035711267355e-12, -4.881553404949773e-13, -1.413007231470057e-15,  6.198244579751091e-17,  4.843133555701247e-19, -4.452561284835322e-21, -1.300774505421893e-23,
  1.809003479906771e+00, -4.181368529221970e-03, -5.115152132314540e-05, -2.768813883197013e-07,  2.682526533183900e-09,  6.909112919822014e-11,  3.396618732740570e-13,
 -8.818366193960889e-15, -1.749438654962368e-16, -2.810686091124157e-19,  3.713481022213557e-20,  6.142970231588943e-22,  1.956976426936568e+00, -1.235964842633899e-03,
 -2.498792795262600e-05, -4.105223494024783e-07, -5.520337166175787e-09, -5.553748872434089e-11, -2.335780132024121e-13,  6.101149462074394e-15,  2.018741532571557e-16,
  3.605628452159609e-18,  4.270631554002722e-20,  2.188062173549640e-22,  1.132800665502993e-03, -8.584582181043186e-06,  4.868927544199250e-08, -2.469958321816260e-10,
  1.141340704319030e-12, -5.700661429375957e-15,  1.729245359762883e-17, -1.058411674599694e-19,  3.187147970592592e-21,  9.037516293148297e-23,  1.642934666723291e-24,
  1.215484263472565e-26,  1.020360853631251e-02, -7.724494418260536e-05,  4.366834244453233e-07, -2.201185998530974e-09,  1.005864430921316e-11, -4.962388949724612e-14,
  1.434662462815457e-16, -8.764383185403537e-19,  2.831735368589609e-20,  8.193867378017390e-22,  1.483510535662012e-23,  1.099872571255521e-25,  2.839025581679524e-02,
 -2.144734513030286e-04,  1.204417491566738e-06, -5.991776298418148e-09,  2.674469160333217e-11, -1.284912984703110e-13,  3.315943218042082e-16, -2.022671332302692e-18,
  7.674499086142731e-20,  2.308666847533916e-21,  4.149233988158002e-23,  3.088038583972750e-25,  5.578386076834000e-02, -4.200592741915808e-04,  2.334655921618010e-06,
 -1.137510947200517e-08,  4.885308559081165e-11, -2.243291336476782e-13,  4.567674095116585e-16, -2.811069558178203e-18,  1.454248320549409e-19,  4.616845541183490e-21,
  8.222422926815741e-23,  6.148558413149788e-25,  9.252377956536786e-02, -6.936157644683562e-04,  3.799631376943238e-06, -1.796474661935120e-08,  7.274248525393625e-11,
 -3.102530780140792e-13,  3.421005547891375e-16, -2.298185890095876e-18,  2.314441024846961e-19,  7.821989674990807e-21,  1.381059579158538e-22,  1.037479619916244e-24,
  1.388009332894551e-01, -1.034482560608123e-03,  5.558459462812732e-06, -2.520413846769296e-08,  9.333713292915195e-11, -3.509350357791611e-13, -2.235406407626121e-16,
  4.348467747404228e-19,  3.342913252515371e-19,  1.200970943408907e-20,  2.108704774522783e-22,  1.589359232727668e-24,  1.948624230911155e-01, -1.441569225483186e-03,
  7.553149196714348e-06, -3.232640260542702e-08,  1.039613098050203e-10, -3.040302896080415e-13, -1.451621321635349e-15,  5.884862451202054e-18,  4.592963016940671e-19,
  1.725892540056077e-20,  3.031474674847018e-22,  2.287584206682071e-24,  2.610175601561415e-01, -1.913110026171006e-03,  9.702603598338754e-06, -3.829780777447778e-08,
  9.619041068995928e-11, -1.236999946046420e-13, -3.491180366524163e-15,  1.348342249144761e-17,  6.223620965583634e-19,  2.363157836775923e-20,  4.186930060553068e-22,
  3.156530109562805e-24,  3.376454038911795e-01, -2.446278095420586e-03,  1.189363373289196e-05, -4.174099190800302e-08,  5.982265137042680e-11,  2.315588566309858e-13,
 -6.315805071686574e-15,  2.061021072166238e-17,  8.554425033629919e-19,  3.118459875012107e-20,  5.624681003697831e-22,  4.234369943177084e-24,  4.252037512084296e-01,
 -3.036569345655166e-03,  1.396741083660653e-05, -4.083491916644978e-08, -1.678423258302494e-11,  7.824700696898702e-13, -9.526055600080106e-15,  2.121967066379253e-17,
  1.210021990870446e-18,  4.005061086515122e-20,  7.402773296394295e-22,  5.585690573644750e-24,  5.242390846273630e-01, -3.676796720570502e-03,  1.569880709611372e-05,
 -3.319475904670190e-08, -1.454448612125751e-10,  1.495585329663626e-12, -1.201969784684543e-14,  4.354837213595047e-18,  1.749620076893975e-18,  5.069273115973689e-20,
  9.575623604226579e-22,  7.320939305159006e-24,  6.353958572291932e-01, -4.355401643117085e-03,  1.676452024975488e-05, -1.575701022257526e-08, -3.346330444768920e-10,
  2.217175279662581e-12, -1.149234985670976e-14, -4.598497032876347e-17,  2.506300636326624e-18,  6.453423413424782e-20,  1.217531117995156e-21,  9.610313108216360e-24,
  7.594206263480301e-01, -5.053522675908471e-03,  1.669359475761731e-05,  1.523460720356939e-08, -5.806589699833307e-10,  2.546809583565085e-12, -3.873523631862356e-15,
 -1.442645753834763e-16,  3.340570194611105e-18,  8.517619819245820e-20,  1.523226046217540e-21,  1.262942955782928e-23,  8.971491607242357e-01, -5.739706671107258e-03,
  1.479160700829367e-05,  6.383043773295964e-08, -8.463954080810317e-10,  1.614596083943096e-12,  1.648741512857071e-14, -2.733424187220734e-16,  3.596480262942247e-18,
  1.194683343044003e-19,  1.907766620976726e-21,  1.626101069705629e-23,  1.049444814439493e+00, -6.359952024707090e-03,  1.003261793509767e-05,  1.325789976722498e-07,
 -1.011560280810899e-09, -2.213759128784898e-12,  5.217860183352468e-14, -2.873486937678874e-16,  1.600320562454711e-18,  1.714745101468371e-19,  2.574072166788579e-21,
  1.960039833248528e-23,  1.216999885676374e+00, -6.818161856248867e-03,  9.491950064909919e-07,  2.162440354976331e-07, -7.654307433235241e-10, -1.117243421404940e-11,
  7.986958339686000e-14,  3.032606490233741e-16, -3.997832799758100e-18,  1.983691661012356e-19,  4.175173050349709e-21,  2.484630103116401e-23,  1.399737343607248e+00,
 -6.936819638603505e-03, -1.423768127716375e-05,  2.816870242350258e-07,  5.520570358210801e-10, -2.414323560823240e-11, -2.410071923647745e-14,  2.159513287076722e-15,
  1.269239747181100e-18,  1.677143679272173e-20,  6.062913180387728e-21,  6.726268153862786e-23,  1.594967288732442e+00, -6.382852542369830e-03, -3.592867059200287e-05,
  2.129781833180691e-07,  3.580573273970859e-09, -1.580952603337672e-11, -4.975748735591973e-13,  8.153233187421350e-16,  7.628995170549820e-17,  3.184005054736036e-19,
 -3.279807196060233e-21,  6.279269724261897e-23,  1.791439710073604e+00, -4.603033926191906e-03, -5.416979737833020e-05, -2.225588047775743e-07,  4.122600422656282e-09,
  7.364965067374723e-11,  1.520003604747497e-14, -1.423940667987847e-14, -1.519188050715025e-16,  1.727356014274079e-18,  6.209354346058432e-20,  4.465333225925918e-22,
  1.951599327842601e+00, -1.457160919184046e-03, -3.048159597963235e-05, -5.079654570881427e-07, -6.668982507397688e-09, -5.823129820416066e-11,  4.964204790397475e-14,
  1.498119733847832e-14,  3.638952687264078e-16,  5.405024192418218e-18,  4.367255402765980e-20, -2.831768209957109e-22,  1.099223020532971e-03, -8.206621855296471e-06,
  4.583120260955093e-08, -2.296246945147418e-10,  1.031311658919418e-12, -5.306198782883363e-15,  1.634126207090292e-17,  6.170549869042364e-20,  7.715894595998914e-21,
  1.624379602217019e-22,  1.808191642627882e-24, -8.956965592368696e-27,  9.901452168801492e-03, -7.385447200918686e-05,  4.112026590338266e-07, -2.048006542509337e-09,
  9.099271078010966e-12, -4.634123783599437e-14,  1.369082817846995e-16,  6.236189467934042e-19,  6.933245305903710e-20,  1.470261569747974e-21,  1.633484121404970e-23,
 -8.080751719131523e-26,  2.755118733236526e-02, -2.051186346457548e-04,  1.135000224564233e-06, -5.584000604130799e-09,  2.425166448858580e-11, -1.208463363385728e-13,
  3.242461867153509e-16,  2.104095535397625e-18,  1.920807345452097e-19,  4.129992910354497e-21,  4.572605385413451e-23, -2.256034761510204e-25,  5.414013197279612e-02,
 -4.019150812314544e-04,  2.202698330740495e-06, -1.062877224115769e-08,  4.447320729325834e-11, -2.136079972128708e-13,  4.729721667753897e-16,  5.178082548348223e-18,
  3.755167093318090e-19,  8.228390195075374e-21,  9.071603318928570e-23, -4.457980682939529e-25,  8.980877260375573e-02, -6.640617040556481e-04,  3.590834358618994e-06,
 -1.685006434875582e-08,  6.661988988719349e-11, -3.016777656696293e-13,  4.317985289382479e-16,  1.074974778993472e-17,  6.203883789799954e-19,  1.389201244990589e-20,
  1.525560433735085e-22, -7.457036509770605e-25,  1.347500580198567e-01, -9.911998310385226e-04,  5.264737680629927e-06, -2.376715384500937e-08,  8.627393260286223e-11,
 -3.544845319685857e-13,  1.565410207799183e-17,  1.978517356109543e-17,  9.306162611425192e-19,  2.128307797560989e-20,  2.332032811936586e-22, -1.132142838476091e-24,
  1.892145790666230e-01, -1.382667895754771e-03,  7.175006102325748e-06, -3.071346529747260e-08,  9.755699965117740e-11, -3.345691506920470e-13, -9.700480677393990e-16,
  3.301870396483064e-17,  1.316401564605926e-18,  3.059539762105129e-20,  3.355785321430342e-22, -1.615018746487239e-24,  2.535174877286228e-01, -1.837301545126708e-03,
  9.252168268276199e-06, -3.678292560266085e-08,  9.292451405292867e-11, -1.998000574019526e-13, -2.682586249429241e-15,  5.045719075603057e-17,  1.798778543418276e-18,
  4.205520552883621e-20,  4.638721532238521e-22, -2.207269812649797e-24,  3.280474407038944e-01, -2.353116021694724e-03,  1.139861165768278e-05, -4.075474914614230e-08,
  6.300575832521705e-11,  9.119811389611779e-14, -5.154003663904081e-15,  7.057667216021838e-17,  2.415639527592873e-18,  5.594095561024883e-20,  6.238224939819516e-22,
 -2.923136406377034e-24,  4.132778439682805e-01, -2.926793590355471e-03,  1.347625749537582e-05, -4.099039377188672e-08, -3.343914509060633e-12,  5.668967234643121e-13,
 -8.130005308093959e-15,  8.910506515243755e-17,  3.227980276152101e-18,  7.265907711573949e-20,  8.227759517066556e-22, -3.773024091856533e-24,  5.097805028758814e-01,
 -3.552837001027818e-03,  1.528744403584768e-05, -3.529807727877295e-08, -1.183671464045213e-10,  1.216866344262811e-12, -1.078383971191809e-14,  9.743517502822126e-17,
  4.320900471123376e-18,  9.296586936493185e-20,  1.069178183642135e-21, -4.753811201043906e-24,  6.182411612676894e-01, -4.222129566459720e-03,  1.654472541008940e-05,
 -2.077162070578958e-08, -2.930947678929262e-10,  1.937471068782822e-12, -1.123682174525524e-14,  8.145018335817397e-17,  5.781587611940519e-18,  1.185348477952156e-19,
  1.371283182602312e-21, -5.841461808015852e-24,  7.394745730729881e-01, -4.919396763404070e-03,  1.682232817393433e-05,  6.345386670716852e-09, -5.309035567266617e-10,
  2.420728667126863e-12, -5.866232392160980e-15,  2.433319289672607e-17,  7.604046173420606e-18,  1.532176203098887e-19,  1.737352206725230e-21, -7.031331795402306e-24,
  8.744315292465785e-01, -5.618537591488835e-03,  1.547744715319689e-05,  5.056563422841503e-08, -8.106803560818163e-10,  1.935986609487135e-12,  1.120349855289812e-14,
 -7.357331517829319e-17,  9.401517876744318e-18,  2.050782665093598e-19,  2.193874363732755e-21, -8.598728079398875e-24,  1.024175211897044e+00, -6.273605369473466e-03,
  1.152520839176554e-05,  1.161053214853542e-07, -1.043907488068999e-09, -1.045784456482771e-12,  4.592773067006585e-14, -1.161329695945362e-16,  9.782422220197094e-18,
  2.854189544045685e-19,  2.896719748861603e-21, -1.188950942113265e-23,  1.189758544472188e+00, -6.800413071493680e-03,  3.463613113926637e-06,  2.023164272130740e-07,
 -9.690652981572868e-10, -9.160328863024534e-12,  8.788343797413309e-14,  3.235011434373308e-16,  6.339040903365759e-18,  3.784121959077983e-19,  4.515608612400254e-21,
 -1.844786954636248e-23,  1.371783833840833e+00, -7.037086751562423e-03, -1.082041942506430e-05,  2.866462575351133e-07,  6.833853221461033e-11, -2.398910553658322e-11,
  3.738862731950233e-14,  2.261615302653346e-15,  6.828470313114571e-18,  3.038863394098711e-19,  7.790232325633537e-21, -2.438336423214423e-24,  1.568878544194642e+00,
 -6.659113225169539e-03, -3.304169996525704e-05,  2.671018468093284e-07,  3.148281764955258e-09, -2.719167564982895e-11, -4.389902566141380e-13,  3.420797698157831e-15,
  8.615601237123303e-17,  2.517215990465684e-19, -4.813781475226771e-23,  6.166923447045566e-23,  1.772145673111550e+00, -5.045842414348880e-03, -5.639645264990669e-05,
 -1.449379648213828e-07,  5.564416262365905e-09,  6.875606181978540e-11, -4.386174828700359e-13, -1.759706274075022e-14, -4.171023003997869e-17,  4.439930701750693e-18,
  6.841647291290446e-20, -2.560038560296234e-22,  1.945241697187899e+00, -1.727297270640839e-03, -3.725517482342986e-05, -6.237527431875300e-07, -7.780112602395529e-09,
 -5.049945167310805e-11,  6.635649695213705e-13,  3.003312081561282e-14,  5.839589203190646e-16,  6.560582939972328e-18,  3.366510385096329e-21, -1.769429423728911e-21,
  1.067112766447483e-03, -7.850721624754443e-06,  4.317128210284684e-08, -2.139502275083319e-10,  9.294183762969727e-13, -4.859504536511282e-15,  2.249637746184849e-17,
  4.146345311824474e-19,  1.465613543042115e-20,  2.137916482800361e-22,  3.682831004655433e-25, -6.276109887759252e-26,  9.612461277585818e-03, -7.066074927791702e-05,
  3.874701321626763e-07, -1.909643159112964e-09,  8.208237421505018e-12, -4.254207213802136e-14,  1.942144771408647e-16,  3.801660597022896e-18,  1.321317236597662e-19,
  1.934219567910259e-21,  3.327208910967664e-24, -5.671032272191962e-25,  2.674845748744201e-02, -1.963002492082364e-04,  1.070242077031228e-06, -5.214852164795918e-09,
  2.192154497215389e-11, -1.115136991702027e-13,  4.938794388375061e-16,  1.094460430154349e-17,  3.683932705517666e-19,  5.429019943130296e-21,  9.319293873807883e-24,
 -1.588008587197625e-24,  5.256692368959206e-02, -3.847918992609947e-04,  2.079283709928339e-06, -9.950683984063538e-09,  4.033456993205664e-11, -1.988618215151976e-13,
  8.353152796413984e-16,  2.255932353823710e-17,  7.265741430356497e-19,  1.080660288596945e-20,  1.852584585562846e-23, -3.150917158613136e-24,  8.720872351530409e-02,
 -6.361261658636121e-04,  3.394832202947902e-06, -1.583170247863011e-08,  6.072804644454359e-11, -2.849578465902799e-13,  1.093635402762053e-15,  3.965561815010038e-17,
  1.212756874777831e-18,  1.823098491463704e-20,  3.130358528993332e-23, -5.296584484221305e-24,  1.308677206153423e-01, -9.501998239378548e-04,  4.987580919751694e-06,
 -2.244320947014128e-08,  7.925348907933241e-11, -3.433276834488455e-13,  1.113554173689852e-15,  6.343227974250924e-17,  1.837927958611444e-18,  2.792397585438518e-20,
  4.829221052507875e-23, -8.084483032458805e-24,  1.837964101413101e-01, -1.326716072573499e-03,  6.815586172841431e-06, -2.920693543209574e-08,  9.073693039430723e-11,
 -3.408914319474956e-13,  7.268164040889016e-16,  9.508243872323041e-17,  2.621109773062408e-18,  4.016984812753852e-20,  7.056120787035661e-23, -1.159782233070743e-23,
  2.463135559955982e-01, -1.765024827438507e-03,  8.819552350832705e-06, -3.533098299224126e-08,  8.843912253024989e-11, -2.392052137963964e-13, -2.127989470403000e-16,
  1.354462336646668e-16,  3.594148559229817e-18,  5.532672186779436e-20,  9.977993761759366e-23, -1.595061157240664e-23,  3.188142813696009e-01, -2.263866119807788e-03,
  1.091564391039518e-05, -3.973793165095501e-08,  6.380646161654088e-11,  1.973049538260064e-15, -1.761223616347866e-15,  1.844138363493195e-16,  4.808646591642040e-18,
  7.385623872541317e-20,  1.383502758803240e-22, -2.129732028997991e-23,  4.017831742283752e-01, -2.820951180854126e-03,  1.298439446020578e-05, -4.096270309504487e-08,
  6.316274032422248e-12,  4.160184165507122e-13, -3.753868910286581e-15,  2.399522860859189e-16,  6.344993363657416e-18,  9.640177352792020e-20,  1.893363296360749e-22,
 -2.784604471467172e-23,  4.958110282001452e-01, -3.432262188145034e-03,  1.485326474650459e-05, -3.701006407864541e-08, -9.630206606928050e-11,  1.009786625448468e-12,
 -5.562319099950537e-15,  2.966748485756430e-16,  8.321030517956567e-18,  1.239915882075557e-19,  2.558258485876828e-22, -3.587774805736831e-23,  6.016156711863490e-01,
 -4.090845667428309e-03,  1.626856327199898e-05, -2.516458885403786e-08, -2.567313661182180e-10,  1.720360129735027e-12, -5.654603183749416e-15,  3.442789239638136e-16,
  1.088952574209263e-17,  1.585513169506005e-19,  3.391639080395745e-22, -4.578209062461965e-23,  7.200664264451854e-01, -4.784654332010953e-03,  1.684908094987979e-05,
 -1.768607097345170e-09, -4.836762970502511e-10,  2.321160071072779e-12, -8.602965622391504e-16,  3.680307100167831e-16,  1.418791961413933e-17,  2.041263584785502e-19,
  4.364142487550176e-22, -5.815494955018237e-23,  8.522085537203902e-01, -5.492508331933505e-03,  1.600773428525773e-05,  3.791912001777005e-08, -7.692319042797673e-10,
  2.221538943712374e-12,  1.457740607575825e-14,  3.607116274578248e-16,  1.813424872583476e-17,  2.694038716572421e-19,  5.459706413337830e-22, -7.413496055572591e-23,
  9.992736152886673e-01, -6.176115792695806e-03,  1.281775970346145e-05,  9.929502584796335e-08, -1.053838037354378e-09,  6.308167535160429e-14,  4.875124234244300e-14,
  3.815066855089588e-16,  2.183887753488327e-17,  3.704019022741379e-19,  7.372214490449822e-22, -9.652030325179930e-23,  1.162627296525354e+00, -6.763269725427120e-03,
  5.792715157705480e-06,  1.854639949012895e-07, -1.130269936875923e-09, -6.905740765755163e-12,  1.020613005355664e-13,  7.760597508247735e-16,  2.277832858050239e-17,
  5.154076950552103e-19,  1.511027040992206e-21, -1.316915094248454e-22,  1.343484123939274e+00, -7.109908535993314e-03, -7.389718492556859e-06,  2.839722969939881e-07,
 -3.971627663565549e-10, -2.229497272487909e-11,  1.058338288854826e-13,  2.712739411592908e-15,  2.298364484964359e-17,  5.713423001294049e-19,  4.336510757702899e-21,
 -1.737611292264136e-22,  1.541734873822709e+00, -6.909814469257427e-03, -2.955394084503584e-05,  3.125895225299671e-07,  2.508494850326458e-09, -3.625805725296995e-11,
 -3.032292208071163e-13,  6.325681981501949e-15,  9.550919806255330e-17,  2.648701152370554e-19, -6.734388429699916e-22, -1.285186746696657e-22,  1.751051213749608e+00,
 -5.502357578992948e-03, -5.755845776326740e-05, -4.564645925670323e-08,  6.794272421937708e-09,  5.233148806659044e-11, -9.224468339672608e-13, -1.588720370515283e-14,
  1.617530064847510e-16,  6.624895379051853e-18,  3.207578903515941e-20, -1.449970596216610e-21,  1.937685940342692e+00, -2.057464545546310e-03, -4.551674656515727e-05,
 -7.551224942171040e-07, -8.550902908279074e-09, -2.215657757339451e-11,  1.800700082770094e-12,  5.232798417641661e-14,  7.968927238710774e-16,  4.353924091351876e-18,
 -1.363533275069068e-19, -4.878178520839835e-21,  1.036384707671982e-03, -7.515375349125270e-06,  4.069000456778668e-08, -1.998227273011100e-10,  8.388717446828107e-13,
 -4.120223657629018e-15,  4.181130146922943e-17,  1.002816445710657e-18,  2.173647700142229e-20,  1.491310935502833e-22, -4.254566183155026e-24, -1.519358566360183e-25,
  9.335875738754135e-03, -6.765048125278382e-05,  3.653152690174024e-07, -1.784819226559972e-09,  7.415370708429736e-12, -3.606195862820735e-14,  3.701628049528958e-16,
  9.108210202558254e-18,  1.961950765843969e-19,  1.349861806529445e-21, -3.844984947508289e-23, -1.373152956297331e-24,  2.597999223550344e-02, -1.879828275296857e-04,
  1.009697153900636e-06, -4.881175152538867e-09,  1.984227188672338e-11, -9.447196069561323e-14,  9.942991003192575e-16,  2.576012155787633e-17,  5.482433233239153e-19,
  3.792418132753960e-21, -1.076948382287828e-22, -3.846618225872439e-24,  5.106028348034151e-02, -3.686245853287515e-04,  1.963620611035425e-06, -9.335792880522554e-09,
  3.662407063034251e-11, -1.682504398446348e-13,  1.850073037675508e-15,  5.183572447681088e-17,  1.084684628210004e-18,  7.559594548022734e-21, -2.137367077952603e-22,
 -7.636712911793882e-24,  8.471735572059204e-02, -6.097113335793259e-04,  3.210499451375383e-06, -1.490375672420685e-08,  5.540652722749859e-11, -2.403993446560408e-13,
  2.844479679595400e-15,  8.863221659091728e-17,  1.817182215126806e-18,  1.277715500849069e-20, -3.592981154699745e-22, -1.284611305253187e-23,  1.271450466918637e-01,
 -9.113554025844257e-04,  4.725650812205793e-06, -2.122789868775102e-08,  7.283632516065097e-11, -2.877215154797248e-13,  3.861920716764651e-15,  1.378261451167015e-16,
  2.764322505323984e-18,  1.961603639045824e-20, -5.482193667050660e-22, -1.962403169347718e-23,  1.785964096766529e-01, -1.273569142397852e-03,  6.473594695777949e-06,
 -2.780764662598830e-08,  8.436381578356536e-11, -2.806959613513092e-13,  4.777617041901688e-15,  2.013822474810758e-16,  3.954949256355331e-18,  2.829641316062615e-20,
 -7.856917533198022e-22, -2.817893234670064e-23,  2.393919178567659e-01, -1.696140598335619e-03,  8.403916073880890e-06, -3.395296055937972e-08,  8.398608763486875e-11,
 -1.839785847688537e-13,  5.485098754117085e-15,  2.813664120256100e-16,  5.433380125587623e-18,  3.909643573016589e-20, -1.078648185702821e-21, -3.879764722670366e-23,
  3.099304716092369e-01, -2.178431035712308e-03,  1.044491363238543e-05, -3.871690934106312e-08,  6.394173637264597e-11,  4.149564503075597e-14,  5.951012267171736e-15,
  3.795875208835603e-16,  7.267354457190744e-18,  5.237358588935462e-20, -1.436451127235081e-21, -5.187408838763984e-23,  3.907040098859650e-01, -2.719039903188871e-03,
  1.249371442613583e-05, -4.079723664848773e-08,  1.441207458918116e-11,  4.326812374283140e-13,  6.322559297662246e-15,  4.969561798557630e-16,  9.559616368256321e-18,
  6.862025262844241e-20, -1.872178196930172e-21, -6.795304535945151e-23,  4.823167839228243e-01, -3.315237243254600e-03,  1.440055107875399e-05, -3.839316605175913e-08,
 -7.659545798723010e-11,  1.010166402065833e-12,  7.135678368315342e-15,  6.324410111351216e-16,  1.246310983637704e-17,  8.861099513486840e-20, -2.405144649703813e-21,
 -8.779951770548102e-23,  5.855105778461839e-01, -3.961972306022910e-03,  1.594306435558767e-05, -2.900035316551705e-08, -2.226745881389637e-10,  1.744955025572443e-12,
  9.712555174036905e-15,  7.817029436076220e-16,  1.619505641387212e-17,  1.137910204475371e-19, -3.065941298345615e-21, -1.125170418282802e-22,  7.011970789349483e-01,
 -4.650074595184385e-03,  1.678296505712241e-05, -9.132650405631939e-09, -4.363309467185587e-10,  2.482237053235858e-12,  1.689399574277691e-14,  9.366459063380628e-16,
  2.102753953097038e-17,  1.472764918054105e-19, -3.905985584829945e-21, -1.437797529684757e-22,  8.304972352437787e-01, -5.362832048489969e-03,  1.639045772683712e-05,
  2.599059322187564e-08, -7.201075839578645e-10,  2.767092128373293e-12,  3.424420205388928e-14,  1.092296692555928e-15,  2.717420334300923e-17,  1.962492744295764e-19,
 -5.011114829501168e-21, -1.843898824174330e-22,  9.747813786974788e-01, -6.069093664517658e-03,  1.390839280992926e-05,  8.251249252386193e-08, -1.039550478324521e-09,
  1.452545384311679e-12,  7.120344757504915e-14,  1.288851706571726e-15,  3.433592725006387e-17,  2.763175463278233e-19, -6.491258672006609e-21, -2.398843065453634e-22,
  1.135680549609000e+00, -6.708342754428788e-03,  7.905674737332962e-06,  1.664169363583402e-07, -1.241631044397060e-09, -4.095920239300548e-12,  1.367880595466848e-13,
  1.799190405191785e-15,  4.056457715364393e-17,  4.084154646235582e-19, -8.261189728239560e-21, -3.229697599345756e-22,  1.314947640298395e+00, -7.155536498524577e-03,
 -4.034371482510758e-06,  2.742160765941320e-07, -8.109965079113283e-10, -1.874061974116781e-11,  1.953099490208045e-13,  3.791433207839703e-15,  4.415383199272274e-17,
  5.160306033376240e-19, -9.149936907506378e-21, -4.534674069546296e-22,  1.513647397455688e+00, -7.130616744950416e-03, -2.558708248876734e-05,  3.465952821174834e-07,
  1.726725721071928e-09, -4.105652879705081e-11, -8.201964855771764e-14,  9.512093997675821e-15,  1.022368555414260e-16,  1.631380263830991e-20, -1.481741445019645e-20,
 -5.466570968406023e-22,  1.728120082154054e+00, -5.963097198305559e-03, -5.742370439810496e-05,  7.009422556129815e-08,  7.587461803265249e-09,  2.566527330484071e-11,
 -1.258038950019014e-12, -6.795124177587318e-15,  4.045195980017737e-16,  6.256857149656332e-18, -5.919401875491585e-20, -2.632634279320741e-21,  1.928667119446488e+00,
 -2.460185976998393e-03, -5.540463127354093e-05, -8.925824812274790e-07, -8.427854139815188e-09,  4.161943777657174e-11,  3.636157210764420e-12,  7.879007815144137e-14,
  7.924290154127821e-16, -6.643693782286946e-18, -4.452467117533574e-19, -9.167621047400437e-21,  1.006959374202154e-03, -7.199224485575311e-06,  3.837015039049064e-08,
 -1.869944831129824e-10,  7.691982197972113e-13, -2.697776597591132e-15,  8.011673502636048e-17,  1.736627231794698e-18,  2.216872039989268e-20, -1.831606305669273e-22,
 -1.300183340484602e-23, -2.380640594418493e-25,  9.070985991559076e-03, -6.481166463690508e-05,  3.445873452074742e-07, -1.671360596758430e-09,  6.807436137477565e-12,
 -2.337717948002731e-14,  7.175154067387830e-16,  1.573328116425600e-17,  2.001762658214813e-19, -1.653297259344635e-21, -1.175107930562364e-22, -2.151854941916497e-24,
  2.524385255291943e-02, -1.801342834146166e-04,  9.529705173323119e-07, -4.577235593816535e-09,  1.826053226085021e-11, -5.988352089181048e-14,  1.973658278763712e-15,
  4.428193546431824e-17,  5.598008320073403e-19, -4.620134212416353e-21, -3.291999714608410e-22, -6.029676655106647e-24,  4.961650729809614e-02, -3.533540140727778e-04,
  1.855005300484753e-06, -8.773748782788753e-09,  3.384170844442877e-11, -1.023350905786825e-13,  3.812323000719788e-15,  8.850535714923133e-17,  1.108768164489319e-18,
 -9.140215417433291e-21, -6.535851161899823e-22, -1.197574299172950e-23,  8.232876652238504e-02, -5.847279843397124e-04,  3.036829348370549e-06, -1.405104075057541e-08,
  5.151753907017862e-11, -1.354847327819295e-13,  6.182524798767874e-15,  1.501153148070664e-16,  1.860032623050552e-18, -1.530741822565835e-20, -1.099397504418119e-21,
 -2.015623392316795e-23,  1.235736496168295e-01, -8.745497210937486e-04,  4.477738764331374e-06, -2.010201853070837e-08,  6.837507611855278e-11, -1.382748440630458e-13,
  9.024565919145887e-15,  2.314372964291504e-16,  2.833715161187054e-18, -2.326532287469077e-20, -1.679208813407662e-21, -3.081271293314989e-23,  1.736036291381160e-01,
 -1.223092580496608e-03,  6.147842662670575e-06, -2.649432305310503e-08,  8.043016312737386e-11, -8.340928093130424e-14,  1.228239148192380e-14,  3.354253318094122e-16,
  4.060257255949358e-18, -3.322625739195339e-20, -2.410414161657649e-21, -4.428305258034927e-23,  2.327392696540823e-01, -1.630516386032187e-03,  8.004453153695986e-06,
 -3.262842205793808e-08,  8.236676158930441e-11,  6.276183097013358e-14,  1.592819446517668e-14,  4.656420112696209e-16,  5.585431019195104e-18, -4.549905161215777e-20,
 -3.316761336752185e-21, -6.103340081975993e-23,  3.013809483239224e-01, -2.096712612734930e-03,  9.986512702187350e-06, -3.767533820888954e-08,  6.720216945985992e-11,
  3.393641447779789e-13,  2.001081652794931e-14,  6.261587916671851e-16,  7.478197617326227e-18, -6.052683900556780e-20, -4.430771091600110e-21, -8.170718580938325e-23,
  3.800246556145873e-01, -2.621043797717802e-03,  1.200585789676922e-05, -4.048379399201826e-08,  2.589615551902989e-11,  7.875739802109549e-13,  2.475062579520843e-14,
  8.213030832103406e-16,  9.842807065000842e-18, -7.893170543581048e-20, -5.797705237005755e-21, -1.072016499719910e-22,  4.692832986148051e-01, -3.201894911361716e-03,
  1.393319524217072e-05, -3.944090056969181e-08, -5.300284787505481e-11,  1.441067196802267e-12,  3.072590052616530e-14,  1.055159147506316e-15,  1.283658852139979e-17,
 -1.015462554308828e-19, -7.482386580517548e-21, -1.387913285117038e-22,  5.699154917687416e-01, -3.835877599638887e-03,  1.557489900835896e-05, -3.226275509710326e-08,
 -1.833567818885733e-10,  2.301944693926140e-12,  3.924016415851049e-14,  1.330825845800217e-15,  1.669287062731023e-17, -1.293592609820812e-19, -9.581545078473245e-21,
 -1.783378801744111e-22,  6.828644515781026e-01, -4.516363957834203e-03,  1.663322288576869e-05, -1.568442349822147e-08, -3.800985867180136e-10,  3.281924824026028e-12,
  5.304251765238825e-14,  1.650145591238556e-15,  2.173779708082661e-17, -1.631500136673065e-19, -1.224715710402643e-20, -2.286782348397339e-22,  8.093098591196979e-01,
 -5.230652152320577e-03,  1.663521826294370e-05,  1.496849420873874e-08, -6.535406915292043e-10,  4.058938211521251e-12,  7.768620228432801e-14,  2.018180064795758e-15,
  2.834678275546274e-17, -2.022105282434546e-19, -1.573067396856191e-20, -2.944477647129543e-22,  9.507334138426691e-01, -5.954145798690916e-03,  1.480004443359834e-05,
  6.621954077396356e-08, -9.898152794065563e-10,  3.725476921346124e-12,  1.236783654975569e-13,  2.473161977251147e-15,  3.663609498206666e-17, -2.411460365346120e-19,
 -2.045510335685277e-20, -3.841839153975102e-22,  1.108985833656547e+00, -6.637452037884564e-03,  9.781409355413096e-06,  1.460937769777161e-07, -1.285834756656579e-09,
 -5.125058676880203e-14,  2.069142695150815e-13,  3.237135688877303e-15,  4.532012413712758e-17, -2.687200189863815e-19, -2.703469340958518e-20, -5.165504060723211e-22,
  1.286281438121036e+00, -7.174896329304622e-03, -8.330720963408770e-07,  2.585354710979154e-07, -1.129450164424435e-09, -1.260602750383915e-11,  3.232870449998822e-13,
  5.386435804472474e-15,  5.050364848178569e-17, -3.393466327855903e-19, -3.570146184138143e-20, -7.338905916341760e-22,  1.484742458887744e+00, -7.318269786251425e-03,
 -2.128935383974681e-05,  3.676440581522334e-07,  9.093776360168892e-10, -3.946412519979387e-11,  2.290774487498151e-13,  1.262270739989617e-14,  8.500367874538737e-17,
 -1.205542670427712e-18, -4.978785004429995e-20, -1.020112253880935e-21,  1.703357192590034e+00, -6.417030373580461e-03, -5.584266023215127e-05,  1.939236610414468e-07,
  7.791791114378999e-09, -5.162152346449709e-12, -1.237851540167188e-12,  9.056950469256516e-15,  5.573540048275038e-16,  1.382754814861254e-18, -1.870113322640032e-19,
 -2.961647587309127e-21,  1.917868955857359e+00, -2.948461376217220e-03, -6.687970241869280e-05, -1.015230053649989e-06, -6.530734389641242e-09,  1.578615785787397e-10,
  6.131969936716684e-12,  9.603856752400313e-14,  1.273912010206711e-16, -3.332067983180945e-17, -8.959257351680203e-19, -9.968470585631643e-21,  9.787624780127561e-04,
 -6.901033130049670e-06,  3.619866589858016e-08, -1.749966260828295e-10,  7.387830745329876e-13, -1.215048280100411e-16,  1.368458592878965e-16,  2.219228180640466e-18,
  3.638778436696362e-21, -9.154422225789567e-22, -2.329077278694147e-23, -1.896529885344503e-25,  8.817128282959864e-03, -6.213336822280104e-05,  3.251725721157643e-07,
 -1.565084583424964e-09,  6.551153670246811e-12, -2.386964226417006e-16,  1.231215797460844e-15,  2.009030438511384e-17,  3.277455746121204e-20, -8.272028520255076e-21,
 -2.105248930684500e-22, -1.714944236649308e-24,  2.453822199345025e-02, -1.727253317908165e-04,  8.997667481514268e-07, -4.291619772110362e-09,  1.764640755458573e-11,
  4.129594778749883e-15,  3.418151374343778e-15,  5.646292211822834e-17,  9.122535182834803e-20, -2.316424211861649e-20, -5.899047617404155e-22, -4.809245476184129e-24,
  4.823211735795318e-02, -3.389260254605725e-04,  1.752920144576077e-06, -8.242774960761989e-09,  3.292938397737925e-11,  2.239729714257144e-14,  6.695665754676581e-15,
  1.126226650936602e-16,  1.795675089071933e-19, -4.596393561934772e-20, -1.171596372945378e-21, -9.563425495672694e-24,  8.003739556190409e-02, -5.610939327428443e-04,
  2.873103413371260e-06, -1.323883541312451e-08,  5.066346527348592e-11,  6.920403242022260e-14,  1.106543328273183e-14,  1.905595978094878e-16,  2.992667198711229e-19,
 -7.726530560365609e-20, -1.971754464759273e-21, -1.612287166097659e-23,  1.201455928886823e-01, -8.396742319319996e-04,  4.243031839752898e-06, -1.901600061214264e-08,
  6.834814365176557e-11,  1.650200040531372e-13,  1.654029098074272e-14,  2.930418505976304e-16,  4.535724730019944e-19, -1.179345940550214e-19, -3.013758790474267e-21,
 -2.469992656136973e-23,  1.688076415998118e-01, -1.175159695568099e-03,  5.837638227827850e-06, -2.520133374440957e-08,  8.253895113958760e-11,  3.368860640585879e-13,
  2.315825440344144e-14,  4.237109358270043e-16,  6.490468698493735e-19, -1.691877387549559e-19, -4.330153900823809e-21, -3.559342819573317e-23,  2.263428275534093e-01,
 -1.568024267574551e-03,  7.620940926191500e-06, -3.127497475705492e-08,  8.859503762284164e-11,  6.191294105443670e-13,  3.100855676443737e-14,  5.871914317324939e-16,
  8.981197900539649e-19, -2.327088416866436e-19, -5.965646304751756e-21, -4.921883842734434e-23,  2.931510454880719e-01, -2.018609931555898e-03,  9.541185933597050e-06,
 -3.651330279389670e-08,  8.033835914523935e-11,  1.053640140536569e-12,  4.028041569959402e-14,  7.891978949027342e-16,  1.223298470776089e-18, -3.108302398693170e-19,
 -7.981787033260067e-21, -6.615493229878267e-23,  3.697295092185083e-01, -2.526931664852632e-03,  1.152318554188084e-05, -3.990276089352140e-08,  4.961672237285197e-11,
  1.688679228850611e-12,  5.135575038710820e-14,  1.036605892999588e-15,  1.663948561612067e-18, -4.068071548119009e-19, -1.046449327265339e-20, -8.721755421449281e-23,
  4.566956355120891e-01, -3.092334425650769e-03,  1.345592636975300e-05, -4.000749452330784e-08, -1.419712479583524e-11,  2.573694034722193e-12,  6.498894993807799e-14,
  1.337440209592230e-15,  2.286655582975821e-18, -5.252374520837155e-19, -1.353663026844210e-20, -1.135797943678841e-22,  5.548186624894120e-01, -3.712872994431660e-03,
  1.517186578328215e-05, -3.476331199378309e-08, -1.245991212459211e-10,  3.743891261280960e-12,  8.266319906873202e-14,  1.700783081178038e-15,  3.198862817552969e-18,
 -6.726973799056340e-19, -1.738016169164180e-20, -1.469769168107495e-22,  6.650637965834588e-01, -4.384148892607817e-03,  1.641095656322413e-05, -2.115470854384191e-08,
 -2.976180652153710e-10,  5.178691941389800e-12,  1.073112474282260e-13,  2.137036763885418e-15,  4.557720609114802e-18, -8.586703062308241e-19, -2.227748172106469e-20,
 -1.900810523687704e-22,  7.886543097364356e-01, -5.097022751386638e-03,  1.675516398539550e-05,  5.283499417941999e-09, -5.486566854971187e-10,  6.692306643799483e-12,
  1.447838431452366e-13,  2.661327211756522e-15,  6.531650886790166e-18, -1.096790315037625e-18, -2.869294592388151e-20, -2.472685099397985e-22,  9.271582928940333e-01,
 -5.832829298466805e-03,  1.550270760903044e-05,  5.116561230632850e-08, -8.793864478311212e-10,  7.642709551660038e-12,  2.067122585576736e-13,  3.314688621605717e-15,
  9.032501424432198e-18, -1.406405946868985e-18, -3.743750232293144e-20, -3.264968906114672e-22,  1.082603139726728e+00, -6.552536169396104e-03,  1.141202561029776e-05,
  1.258156062021829e-07, -1.229080317638625e-09,  6.148717055590295e-12,  3.146505008537281e-13,  4.278103777310988e-15,  1.053286564582891e-17, -1.817794185539266e-18,
 -4.996395296404859e-20, -4.449872004617445e-22,  1.257587717150175e+00, -7.169474569087052e-03,  2.154119413860038e-06,  2.389231808014268e-07, -1.290910532981150e-09,
 -2.877424143580397e-12,  4.925545473643873e-13,  6.466269176176301e-15,  4.532442475025144e-18, -2.434808283407317e-18, -6.852794343184515e-20, -6.466835384158024e-22,
  1.455156964340870e+00, -7.470747779375933e-03, -1.681506336103627e-05,  3.763035891440133e-07,  2.050630834327650e-10, -2.947376910626134e-11,  6.107989654638023e-13,
  1.417192702856701e-14, -5.658102627458513e-18, -4.148875665321340e-18, -9.711982032102592e-20, -9.651845159916788e-22,  1.676813295920317e+00, -6.852361710383583e-03,
 -5.277587701212903e-05,  3.162747310991252e-07,  7.422408164111779e-09, -2.982377968929557e-11, -7.387886714099970e-13,  2.600301431137914e-14,  4.432119130553488e-16,
 -8.439950511704423e-18, -2.936674951386590e-19, -1.506510315367655e-21,  1.904925757130610e+00, -3.533709982637636e-03, -7.955684154694584e-05, -1.085562064408793e-06,
 -1.687299985961409e-09,  3.363837974341683e-10,  8.644130844631348e-12,  7.328208596624982e-14, -1.800774190734042e-15, -7.519121693442241e-17, -1.088952403772363e-18,
  5.219528557152728e-21,  9.517245094401966e-04, -6.619641612951558e-06,  3.417018471730228e-08, -1.629961826542625e-10,  7.741434949491623e-13,  3.884412295478821e-15,
  1.943059817510824e-16,  1.616980139087078e-18, -4.733773859547007e-20, -1.923583420540857e-21, -2.396814574033700e-23,  2.465311368049234e-25,  8.573681154250048e-03,
 -5.960531877989814e-05,  3.070260298164501e-07, -1.458509537424124e-09,  6.886659907232485e-12,  3.584315560924478e-14,  1.751419297873041e-15,  1.464431616306605e-17,
 -4.279163073796878e-19, -1.738550441020456e-20, -2.167006073004229e-22,  2.226692667409601e-24,  2.386139759536608e-02, -1.657283578428763e-04,  8.499799879234792e-07,
 -4.003627319312647e-09,  1.867522865952371e-11,  1.045251089017974e-13,  4.880318090725787e-15,  4.119127878427207e-17, -1.199194767024365e-18, -4.870595872371175e-20,
 -6.075103357095271e-22,  6.229731461845597e-24,  4.690384629520646e-02, -3.252892646478024e-04,  1.657214038880751e-06, -7.702529142275783e-09,  3.523535396209499e-11,
  2.197152197312262e-13,  9.612661519663647e-15,  8.226326108174081e-17, -2.381967063046883e-18, -9.670749835986552e-20, -1.207479130527472e-21,  1.234362224963474e-23,
  7.783800305652364e-02, -5.387305811824282e-04,  2.719198416782059e-06, -1.240092288814504e-08,  5.512805231726485e-11,  3.967427722297455e-13,  1.600233880437128e-14,
  1.394206862434163e-16, -4.008856838901327e-18, -1.627015041701416e-19, -2.034267525334667e-21,  2.070700271861346e-23,  1.168533660240453e-01, -8.066237498190246e-04,
  4.021587600432228e-06, -1.787169806398987e-08,  7.627149270718192e-11,  6.572922529508892e-13,  2.413508959612464e-14,  2.148421865115720e-16, -6.126199556416620e-18,
 -2.485940974205361e-19, -3.113535303829210e-21,  3.151814648313314e-23,  1.641985223693282e-01, -1.129645074997117e-03,  5.543477068747511e-06, -2.379261875183843e-08,
  9.577932340005548e-11,  1.030514198366625e-12,  3.414533840211647e-14,  3.114077895058761e-16, -8.796859149478345e-18, -3.570520781600731e-19, -4.481176678161372e-21,
  4.504877961443934e-23,  2.201903242656613e-01, -1.508532609727739e-03,  7.254701122637855e-06, -2.971242579892658e-08,  1.097290899269287e-10,  1.554407101064925e-12,
  4.624563080247200e-14,  4.327969019417670e-16, -1.210433338569223e-17, -4.917579026537318e-19, -6.186782754347687e-21,  6.166493236748739e-23,  2.852265231623188e-01,
 -1.944009250704221e-03,  9.111624715280660e-06, -3.499934319918807e-08,  1.128389491985497e-10,  2.277308140622624e-12,  6.077902771293949e-14,  5.835868085849317e-16,
 -1.615876845450776e-17, -6.578030138183361e-19, -8.299059750290201e-21,  8.185862509579956e-23,  3.598031439623966e-01, -2.436644966672698e-03,  1.105047385845200e-05,
 -3.876196292127695e-08,  9.802936670501731e-11,  3.258963411858075e-12,  7.831491778319006e-14,  7.693192828620526e-16, -2.110606817088910e-17, -8.623046326897347e-19,
 -1.091453198245579e-20,  1.062971887453994e-22,  4.445385525381177e-01, -2.986606710524346e-03,  1.297648124503689e-05, -3.972549274673632e-08,  5.586175592475637e-11,
  4.569673717768334e-12,  9.983008233523352e-14,  9.964730304557818e-16, -2.714266296008737e-17, -1.115396382566137e-18, -1.417207083838156e-20,  1.359029420185665e-22,
  5.402072389890664e-01, -3.593194126980187e-03,  1.474560867855593e-05, -3.603401873073097e-08, -2.607823884766687e-11,  6.283410185202125e-12,  1.270638147996133e-13,
  1.272256779818980e-15, -3.454234778527022e-17, -1.431865693351398e-18, -1.827839268218639e-20,  1.719881596297725e-22,  6.477880659210572e-01, -4.253948736728378e-03,
  1.613245532284036e-05, -2.492786080543341e-08, -1.635022447687607e-10,  8.453644936729538e-12,  1.632425461256193e-13,  1.604274668699361e-15, -4.371363422018638e-17,
 -1.833948251516418e-18, -2.355560436716762e-20,  2.164958706558880e-22,  7.685345073261985e-01, -4.962865541596846e-03,  1.677099249186676e-05, -2.210228150050557e-09,
 -3.740895644011791e-10,  1.104010805255583e-11,  2.146148177388571e-13,  2.001300113647371e-15, -5.534786137830726e-17, -2.356274061416958e-18, -3.053609764660180e-20,
  2.724470172481531e-22,  9.040785876371277e-01, -5.706577356487851e-03,  1.603827731351367e-05,  3.861925359694068e-08, -6.694728510889004e-10,  1.369251075460365e-11,
  2.937686479080769e-13,  2.483583308018696e-15, -7.087737094588307e-17, -3.055138493910217e-18, -4.016401107697139e-20,  3.447526160397267e-22,  1.056584693404326e+00,
 -6.455522911635340e-03,  1.280931936710862e-05,  1.075849166084996e-07, -1.020999696069542e-09,  1.510081219948388e-11,  4.263900591537917e-13,  3.153343992185858e-15,
 -9.410745220427370e-17, -4.029174370372613e-18, -5.422422489722473e-20,  4.413112986677355e-22,  1.228961947095899e+00, -7.141124326907610e-03,  4.897617876574683e-06,
  2.185111368253341e-07, -1.215912118329269e-09,  1.103187351143420e-11,  6.584287233735330e-13,  4.636775350676144e-15, -1.372820502347425e-16, -5.500765112752542e-18,
 -7.599564672093957e-20,  5.728370693454686e-22,  1.425033558286378e+00, -7.587188900930780e-03, -1.229624356980864e-05,  3.757977809474615e-07, -2.064733892884921e-10,
 -1.023985612177469e-11,  9.768805697310646e-13,  1.078591746954462e-14, -2.323163932466999e-16, -8.537227303107315e-18, -1.095686968310346e-19,  8.063560776600352e-22,
  1.648586256100058e+00, -7.257418904408356e-03, -4.829009708103415e-05,  4.295700488907292e-07,  6.714386942543962e-09, -3.757902420881191e-11,  1.255413706213082e-13,
  3.298551668440374e-14, -7.893747766838760e-17, -2.046104135499676e-17, -2.746149689646766e-19,  3.023538717534430e-21,  1.889435626975621e+00, -4.222143235418200e-03,
 -9.248549237354549e-05, -1.046919839502015e-06,  7.235876875777122e-09,  5.591743030851936e-10,  9.427924993309305e-12, -3.500598039865958e-14, -5.141792622386859e-15,
 -1.033320633646997e-16,  3.823079202397615e-21,  4.911276572728297e-20,  };
  constexpr double w[7680] = {  1.529206004707937e-01, -1.037943029039419e-03,  7.645172861035773e-06, -5.907109737408723e-08,  4.662989538825228e-10,
 -3.701651114025197e-12,  2.930668557512846e-14, -2.305526830245033e-16,  1.799574041137816e-18, -1.393330802754416e-20,  1.070300461460584e-22, -8.160025423030863e-25,
  1.503351540737381e-01, -1.846614058201295e-03,  2.529533342856384e-05, -3.276871780593868e-07,  4.001427979559353e-09, -4.661442210939976e-11,  5.228430286477518e-13,
 -5.682030691714457e-15,  6.009813231707088e-17, -6.207232658577818e-19,  6.276914634175757e-21, -6.226887195594441e-23,  1.453444371683174e-01, -3.366061251501729e-03,
  7.076732495515794e-05, -1.292954814455306e-06,  2.144932189182313e-08, -3.309859225805960e-10,  4.820546497150216e-12, -6.691606671488808e-14,  8.915981052590017e-16,
 -1.146317566890957e-17,  1.427951538288710e-19, -1.728808185315089e-21,  1.382821035262757e-01, -5.417556727106826e-03,  1.605403470592369e-04, -3.933660513857392e-06,
  8.486474670281253e-08, -1.664604652941502e-09,  3.027339793962255e-11, -5.172323209651170e-13,  8.380143363849158e-15, -1.296546038560879e-16,  1.925883739411961e-18,
 -2.757692405106466e-20,  1.295880865690076e-01, -7.771336030132631e-03,  3.110482090119606e-04, -9.879459098006547e-06,  2.687520812624423e-07, -6.513870524986935e-09,
  1.440918117941936e-10, -2.956097840160937e-12,  5.688844749823126e-14, -1.035693642157794e-15,  1.795433163874188e-17, -2.978300927382791e-19,  1.197512972201759e-01,
 -1.018195014380548e-02,  5.320189423849075e-04, -2.129546218984149e-05,  7.127859802680812e-07, -2.088263482224429e-08,  5.505898046637126e-10, -1.330849606676097e-11,
  2.988108993113031e-13, -6.293224137204306e-15,  1.252634089498027e-16, -2.369714476099036e-18,  1.092536472109634e-01, -1.242145445549123e-02,  8.216357055680482e-04,
 -4.044245233740841e-05,  1.631097369924334e-06, -5.669688815693056e-08,  1.751694691461504e-09, -4.910424411870466e-11,  1.267361225944648e-12, -3.044639022156237e-14,
  6.865500951839037e-16, -1.462271334260392e-17,  9.852476711931808e-02, -1.430438496077815e-02,  1.164846060349746e-03, -6.897073361485390e-05,  3.289775720986113e-06,
 -1.334499117303810e-07,  4.759378459703398e-09, -1.525951408274137e-10,  4.468833425427192e-12, -1.209657052460384e-13,  3.054376023812690e-15, -7.243073482510451e-17,
  8.791275791321414e-02, -1.570146740937727e-02,  1.535005927993499e-03, -1.071590011703273e-04,  5.942435250414123e-06, -2.770893062495508e-07,  1.125199115572224e-08,
 -4.074374368104371e-10,  1.338032419474701e-11, -4.035979804233009e-13,  1.129190519941891e-14, -2.951611386929149e-16,  7.767187559690213e-02, -1.654215050847890e-02,
  1.898042382862139e-03, -1.533674096180739e-04,  9.732198304670329e-06, -5.143378429879636e-07,  2.347914128218277e-08, -9.489415117068205e-10,  3.456469853758019e-11,
 -1.149883275547433e-12,  3.530190240426460e-14, -1.007758121004396e-15,  6.796453018018449e-02, -1.680839288873967e-02,  2.217779555367468e-03, -2.039128979830599e-04,
  1.458849859661417e-05, -8.623034264927553e-07,  4.371851174138514e-08, -1.950310624747624e-09,  7.797800619112695e-11, -2.833321876166885e-12,  9.457278481771434e-14,
 -2.922753981406533e-15,  5.887306579937173e-02, -1.652322672508384e-02,  2.461064291961904e-03, -2.534333853649547e-04,  2.015748323476092e-05, -1.315875528914267e-06,
  7.324458503282181e-08, -3.568254266375721e-09,  1.550500413062397e-10, -6.095864323688869e-12,  2.192783459620654e-13, -7.275312213868351e-15,  5.041647083237735e-02,
 -1.573755412389364e-02,  2.601709908519614e-03, -2.956548164479561e-04,  2.579904673302595e-05, -1.837679280997096e-06,  1.110611255624064e-07, -5.847977790543589e-09,
  2.735160709838721e-10, -1.153055153941997e-11,  4.431838901581928e-13, -1.565836602630750e-14,  4.256797712440859e-02, -1.451781484342818e-02,  2.622812092619795e-03,
 -3.243710053845557e-04,  3.066365293007538e-05, -2.355817942707646e-06,  1.529330771362260e-07, -8.617061490709746e-09,  4.297538948163934e-10, -1.925533155507621e-11,
  7.842036469175091e-13, -2.927237298653982e-14,  3.527083400134807e-02, -1.293607657878822e-02,  2.517472159492345e-03, -3.344167750511618e-04,  3.383671409763146e-05,
 -2.772664110595316e-06,  1.913345955949191e-07, -1.142408482406486e-08,  6.019690447620256e-10, -2.841860060542958e-11,  1.216353546126270e-12, -4.759663741939343e-14,
  2.845087590399191e-02, -1.106311254259353e-02,  2.288272819831115e-03, -3.224509300601420e-04,  3.451748398998606e-05, -2.984193556845411e-06,  2.166907237734777e-07,
 -1.357939531137817e-08,  7.492079287246797e-10, -3.695030814154940e-11,  1.648686586609795e-12, -6.711308761555774e-14,  2.202554696503550e-02, -8.964337267901927e-03,
  1.945970417442032e-03, -2.874378112765132e-04,  3.218990687534192e-05, -2.905338046457403e-06,  2.197855872240939e-07, -1.432066452272854e-08,  8.199465249178705e-10,
 -4.189108170914803e-11,  1.932965585052806e-12, -8.123510197687749e-14,  1.590972878233517e-02, -6.698111327622955e-03,  1.507840524549108e-03, -2.307933521247757e-04,
  2.674603345085092e-05, -2.494217962183253e-06,  1.946576267373183e-07, -1.306549515423664e-08,  7.695235005759415e-10, -4.038724866787802e-11,  1.911944950631647e-12,
 -8.233164545106576e-14,  1.001929502774128e-02, -4.315928083220824e-03,  9.960283152423907e-04, -1.562256167764896e-04,  1.853581061965601e-05, -1.767945847132578e-06,
  1.409747803959650e-07, -9.658163331736139e-09,  5.800544794184949e-10, -3.101469636466875e-11,  1.494487253141918e-12, -6.544753411015496e-14,  4.278939734941117e-03,
 -1.866472378557864e-03,  4.366883462888621e-04, -6.942548887193013e-05,  8.345219613637360e-06, -8.059642589954035e-07,  6.503766158114785e-08, -4.506663757316225e-09,
  2.736120218909812e-10, -1.478148416212205e-11,  7.193086350029843e-13, -3.179626216667441e-14,  1.488868336577189e-01, -9.794956141742142e-04,  6.978759366121903e-06,
 -5.216644581940191e-08,  3.988084085765685e-10, -3.069684685804666e-12,  2.358752095421273e-14, -1.802309665047143e-16,  1.367118890550778e-18, -1.029087195826879e-20,
  7.687773068786239e-23, -5.701675383137883e-25,  1.433299673535134e-01, -1.658958664850403e-03,  2.171852841447245e-05, -2.704912822137639e-07,  3.182776421727069e-09,
 -3.577707597778284e-11,  3.876275634122360e-13, -4.072856345221433e-15,  4.168194292496630e-17, -4.168436996059585e-19,  4.083875437651181e-21, -3.927233121225222e-23,
  1.329218258899023e-01, -2.856615469332342e-03,  5.711130244536155e-05, -9.970209799039014e-07,  1.584994557992446e-08, -2.348978748401508e-10,  3.291369167809423e-12,
 -4.401852024390559e-14,  5.657372291883794e-16, -7.023218606537914e-18,  8.455166264990794e-20, -9.901185284973057e-22,  1.189111118648100e-01, -4.301262576422494e-03,
  1.205004196652535e-04, -2.807114116517855e-06,  5.780525535848056e-08, -1.085365164600631e-09,  1.893719402513605e-11, -3.109666868394216e-13,  4.849680541414264e-15,
 -7.231902050902757e-17,  1.036570447134366e-18, -1.433745627576622e-20,  1.028202055487374e-01, -5.692870248657824e-03,  2.145355306639733e-04, -6.458587609078792e-06,
  1.672854114796502e-07, -3.873271019071176e-09,  8.205923441677852e-11, -1.615733166098018e-12,  2.989571914159614e-14, -5.241043755007870e-16,  8.760838293886174e-18,
 -1.403034334109771e-19,  8.615439870849154e-02, -6.781738447805288e-03,  3.331393838294987e-04, -1.262377389954169e-05,  4.018984112572406e-07, -1.123885380617290e-08,
  2.836297425845677e-10, -6.577120564723275e-12,  1.419493192336688e-13, -2.878564880867584e-15,  5.525143901753641e-17, -1.009308355543417e-18,  7.016931109580468e-02,
 -7.419312930852991e-03,  4.617870469703158e-04, -2.152853891833016e-05,  8.261863126084924e-07, -2.742284709089968e-08,  8.113407088884749e-10, -2.183171029962315e-11,
  5.419730156139288e-13, -1.254569634795814e-14,  2.730230448578796e-16, -5.620187135836746e-18,  5.574204864835799e-02, -7.570103302122004e-03,  5.816751434546182e-04,
 -3.268638906330178e-05,  1.486018694180548e-06, -5.765065859357036e-08,  1.971851866681900e-09, -6.077528199389330e-11,  1.714465546196228e-12, -4.478421918075782e-14,
  1.092972358524266e-15, -2.508843460675563e-17,  4.334971161821476e-02, -7.290796045470074e-03,  6.753966463078717e-04, -4.489572544826061e-05,  2.379750018079002e-06,
 -1.063979099543939e-07,  4.153626951025129e-09, -1.449177014297223e-10,  4.594563709813997e-12, -1.340299400370245e-13,  3.632247978328028e-15, -9.209858597044891e-17,
  3.312751306813002e-02, -6.692335278215039e-03,  7.314628114839715e-04, -5.652356871460929e-05,  3.441483774122008e-06, -1.749948678286004e-07,  7.704310123189820e-09,
 -3.009304029138615e-10,  1.061280886191007e-11, -3.424001278547114e-13,  1.020947423120926e-14, -2.834564439798053e-16,  2.496653748944788e-02, -5.901323897778631e-03,
  7.461509814953696e-04, -6.594316050043883e-05,  4.547124644134129e-06, -2.596688169362228e-07,  1.274568643089086e-08, -5.514938389993104e-10,  2.142218801670114e-11,
 -7.573346793654833e-13,  2.462888561694943e-14, -7.425217456368248e-16,  1.861571814827023e-02, -5.031456074832489e-03,  7.226888334685107e-04, -7.193144724338293e-05,
  5.542003627911391e-06, -3.511363616523288e-07,  1.900344541073620e-08, -9.015627821020768e-10,  3.820468988058821e-11, -1.466727721610468e-12,  5.158172126304743e-14,
 -1.675048684933119e-15,  1.376579894676701e-02, -4.168462116582895e-03,  6.688153906304992e-04, -7.388484084508814e-05,  6.278123600676242e-06, -4.361485017209761e-07,
  2.574476086694940e-08, -1.325753810612596e-09,  6.071406022222561e-11, -2.508888015002027e-12,  9.461879933008944e-14, -3.283375362966790e-15,  1.010683198810829e-02,
 -3.366666440742533e-03,  5.939846834136299e-04, -7.182000637738851e-05,  6.646082061175856e-06, -5.004318765362478e-07,  3.187523227628885e-08, -1.764045365913975e-09,
  8.649358702552626e-11, -3.813394250537208e-12,  1.529469165568658e-13, -5.626815825615991e-15,  7.360511685904033e-03, -2.652884850663915e-03,  5.071197547652765e-04,
 -6.621785999060331e-05,  6.591733287089205e-06, -5.318810451525390e-07,  3.617250028988731e-08, -2.130161897440397e-09,  1.107863867258077e-10, -5.165694592427403e-12,
  2.185103791745756e-13, -8.455500328299792e-15,  5.293361442592289e-03, -2.033435618936498e-03,  4.152836231660810e-04, -5.780549513719336e-05,  6.115993253116411e-06,
 -5.229237522233662e-07,  3.757398826270091e-08, -2.331316950356907e-09,  1.274150536570348e-10, -6.227920887240444e-12,  2.755277563760567e-13, -1.112571798021427e-14,
  3.717655440623573e-03, -1.501294456552407e-03,  3.232080295777734e-04, -4.735728503272869e-05,  5.262763637819242e-06, -4.715261876522868e-07,  3.542288527382717e-08,
 -2.292856176538856e-09,  1.304586830558391e-10, -6.625507732576055e-12,  3.039904007432623e-13, -1.270702181287288e-14,  2.485760222304834e-03, -1.041864226355822e-03,
  2.334153626956238e-04, -3.555965727003414e-05,  4.102379601506582e-06, -3.809279520819361e-07,  2.960746370098934e-08, -1.979534748308447e-09,  1.161578468802993e-10,
 -6.074881662175320e-12,  2.866215908724654e-13, -1.230305128476753e-14,  1.481777268042805e-03, -6.369352999336352e-04,  1.466509411386924e-04, -2.294943324941494e-05,
  2.716890066293286e-06, -2.585885288308940e-07,  2.057790212933961e-08, -1.407058431365697e-09,  8.434925309091065e-11, -4.502046961477084e-12,  2.165698889078380e-13,
 -9.468823718469473e-15,  6.134791957267575e-04, -2.673773212495621e-04,  6.249919160786792e-05, -9.927083600875234e-06,  1.192199823218598e-06, -1.150394201259559e-07,
  9.275282964424373e-09, -6.421854932141140e-10,  3.895785715307317e-11, -2.103020761858504e-12,  1.022626577051703e-13, -4.517157809249597e-15,  1.450766939335309e-01,
 -9.260655270165162e-04,  6.389116782077689e-06, -4.624753374889613e-08,  3.426911257021506e-10, -2.559520535176853e-12,  1.910179258302035e-14, -1.418629494111497e-16,
  1.046454252892142e-18, -7.663452225343786e-21,  5.571350248124472e-23, -4.022256132590922e-25,  1.370222262146517e-01, -1.497379583140021e-03,  1.875610425126625e-05,
 -2.248219543475591e-07,  2.551752242753113e-09, -2.770458924516632e-11,  2.902117746670593e-13, -2.950699126586640e-15,  2.924292586602245e-17, -2.833838123050861e-19,
  2.691862607143028e-21, -2.511147002790151e-23,  1.223390196562504e-01, -2.443601972646285e-03,  4.652645310061234e-05, -7.770985953136061e-07,  1.185174247985905e-08,
 -1.688617617481493e-10,  2.278494537197447e-12, -2.938410013146576e-14,  3.645773562115293e-16, -4.373545000249313e-18,  5.092319026126659e-20, -5.771837790568996e-22,
  1.034409353333196e-01, -3.457780501585566e-03,  9.172061312226494e-05, -2.033867480860737e-06,  4.001898031901299e-08, -7.199682002493760e-10,  1.206202190187705e-11,
 -1.905191623117023e-13,  2.862143623603897e-15, -4.116521784832853e-17,  5.697137338112734e-19, -7.616299522397678e-21,  8.304770714334438e-02, -4.246357918799275e-03,
  1.508443481835058e-04, -4.308377723222964e-06,  1.063423678716943e-07, -2.353917071521484e-09,  4.779582069335030e-11, -9.037869562970682e-13,  1.608739115221612e-14,
 -2.717186923781258e-16,  4.381678631366218e-18, -6.777515550700246e-20,  6.353276256803783e-02, -4.628205503253146e-03,  2.138654960456252e-04, -7.676234215004173e-06,
  2.325713168728189e-07, -6.210771795065999e-09,  1.500873774567624e-10, -3.340198841083507e-12,  6.931722219719629e-14, -1.353857228248982e-15,  2.506473994209152e-17,
 -4.422236418138251e-19,  4.651433487206151e-02, -4.569377988559673e-03,  2.675931490010684e-04, -1.181649377737464e-05,  4.315346208850330e-07, -1.367877721004684e-08,
  3.875826095291695e-10, -1.001146507918031e-11,  2.390618767295971e-13, -5.332274705936233e-15,  1.119896357170971e-16, -2.227956771001937e-18,  3.275738350304249e-02,
 -4.154852961308055e-03,  3.010271788239754e-04, -1.604643489793529e-05,  6.950781976454997e-07, -2.578129667396250e-08,  8.454453876027212e-10, -2.504244944910955e-11,
  6.803046915007110e-13, -1.714362944971761e-14,  4.042807386607308e-16, -8.980068758431264e-18,  2.231862057566253e-02, -3.527668421256688e-03,  3.092688608223073e-04,
 -1.955638344427728e-05,  9.900387640839171e-07, -4.241187120809257e-08,  1.590666639279277e-09, -5.343983185466047e-11,  1.634731087357488e-12, -4.609232404571602e-14,
  1.209242061132785e-15, -2.972594704202802e-17,  1.480433316608578e-02, -2.830254419586432e-03,  2.941727102002450e-04, -2.170933792105507e-05,  1.266715876395529e-06,
 -6.190607913957165e-08,  2.625955754098116e-09, -9.903629409460045e-11,  3.378713071245156e-12, -1.056274496763283e-13,  3.056504698886282e-15, -8.247041383545585e-17,
  9.623564360009553e-03, -2.168637018180139e-03,  2.622330243095584e-04, -2.223894665290259e-05,  1.475827710720766e-06, -8.131436959027610e-08,  3.859325043409575e-09,
 -1.617809867036218e-10,  6.098673359524562e-12, -2.095630524755339e-13,  6.633378726967017e-15, -1.949092383741989e-16,  6.171319224475808e-03, -1.602286469525133e-03,
  2.214690493160684e-04, -2.126702833402986e-05,  1.584576346928313e-06, -9.729699344632617e-08,  5.112691674497019e-09, -2.359045603795649e-10,  9.737257267282550e-12,
 -3.646229919090553e-13,  1.252297947940153e-14, -3.976212859754030e-16,  3.928361458650261e-03, -1.151273947182772e-03,  1.789044460273399e-04, -1.917743675023722e-05,
  1.584136525719651e-06, -1.071686468616454e-07,  6.169739010982267e-09, -3.103103753097341e-10,  1.389740868630953e-11, -5.622696214883772e-13,  2.078382568913733e-14,
 -7.076155387415799e-16,  2.495156036641182e-03, -8.101415826147778e-04,  1.393248195507501e-04, -1.644179544374509e-05,  1.487048239680716e-06, -1.095811466915601e-07,
  6.839252331400158e-09, -3.712949934043708e-10,  1.787710603692432e-11, -7.747171239113250e-13,  3.056839991464091e-14, -1.107293032677423e-15,  1.586557452256306e-03,
 -5.610062509896901e-04,  1.051721830900499e-04, -1.347933950079164e-05,  1.318339369995818e-06, -1.046165905126642e-07,  7.003628837186348e-09, -4.063386439908225e-10,
  2.083714223101528e-11, -9.586871384924505e-13,  4.004182887385444e-14, -1.530955471077837e-15,  1.009618510578821e-03, -3.826785196397656e-04,  7.707262875105839e-05,
 -1.058506244938285e-05,  1.105727539403318e-06, -9.340482358974382e-08,  6.635126577230426e-09, -4.072480207340883e-10,  2.203036826315519e-11, -1.066396026391436e-12,
  4.674453011719464e-14, -1.871085987703841e-15,  6.384275437686886e-04, -2.555945063817459e-04,  5.452528793300111e-05, -7.918633442429345e-06,  8.725712408097474e-07,
 -7.755349502681961e-08,  5.781871300360781e-09, -3.715539594954438e-10,  2.099618629047364e-11, -1.059401917562767e-12,  4.830787359849980e-14, -2.007511495341634e-15,
  3.924655808258119e-04, -1.636841412923413e-04,  3.647726928678864e-05, -5.528431405140950e-06,  6.346372058795442e-07, -5.865157790075195e-08,  4.538225949159335e-09,
 -3.021294110350890e-10,  1.765693615208756e-11, -9.198739036084482e-13,  4.324189687069819e-14, -1.849672574144955e-15,  2.202856691796658e-04, -9.446681979540219e-05,
  2.169503302307902e-05, -3.386544564886414e-06,  3.999498314476616e-07, -3.797831142681540e-08,  3.015540171198571e-09, -2.057582097918576e-10,  1.230973768252154e-11,
 -6.557518099996910e-13,  3.148667207339355e-14, -1.374235854104679e-15,  8.813690285787688e-05, -3.837900509526580e-05,  8.962163962951968e-06, -1.422100496309169e-06,
  1.706230197775440e-07, -1.644855049964109e-08,  1.324992950925607e-09, -9.165694353876126e-11,  5.555601872219608e-12, -2.996560355480947e-13,  1.455967566268648e-14,
 -6.426392275443858e-16,  1.414712695415215e-01, -8.770829974738909e-04,  5.865432594488693e-06, -4.115037586307660e-08,  2.957819278111066e-10, -2.145199839615433e-12,
  1.555984421631606e-14, -1.123927799770048e-16,  8.067631598524129e-19, -5.751653461426160e-21,  4.071851981543347e-23, -2.863441314397840e-25,  1.313166463702707e-01,
 -1.357467910763515e-03,  1.628607741662184e-05, -1.880745186450114e-07,  2.061128131969223e-09, -2.163393277807918e-11,  2.192958925716196e-13, -2.159354563028391e-15,
  2.073997891184632e-17, -1.949032096749408e-19,  1.796348917384251e-21, -1.626743931644799e-23,  1.132542109224303e-01, -2.105706071491529e-03,  3.823650178467150e-05,
 -6.117751935932689e-07,  8.960946160504440e-09, -1.228652026798210e-10,  1.597940285769343e-12, -1.988842071869806e-14,  2.384093447410655e-16, -2.765782707055804e-18,
  3.116788415639835e-20, -3.421643423363921e-22,  9.093681226090662e-02, -2.811756540251432e-03,  7.072725349897218e-05, -1.494673485750988e-06,  2.813060566126520e-08,
 -4.853714939458437e-10,  7.814872616153041e-12, -1.188241995740121e-13,  1.720797631418968e-15, -2.388716803570214e-17,  3.194090642808774e-19, -4.129585742677314e-21,
  6.818492917144883e-02, -3.220692002449257e-03,  1.079797665595587e-04, -2.928863216221079e-06,  6.895150209600577e-08, -1.460277007022852e-09,  2.843754098376805e-11,
 -5.167525321116298e-13,  8.853966745254824e-15, -1.441551669250409e-16,  2.243663028808151e-18, -3.353432432546377e-20,  4.793668460332952e-02, -3.230791582758334e-03,
  1.405352274839420e-04, -4.780907471302724e-06,  1.379280414071178e-07, -3.519285095355321e-09,  8.147544423797887e-11, -1.740931164901314e-12,  3.475232605224208e-14,
 -6.539551233763312e-16,  1.168119021019200e-17, -1.991011840430850e-19,  3.176218304177793e-02, -2.896372296374642e-03,  1.596043149230452e-04, -6.676894984869444e-06,
  2.320867949754853e-07, -7.026826959591343e-09,  1.907094904619471e-10, -4.729465894259586e-12,  1.086406923091550e-13, -2.335136713819733e-15,  4.733244490271712e-17,
 -9.100679335033139e-19,  1.995788889776346e-02, -2.360854343807717e-03,  1.611941262926523e-04, -8.148218538350608e-06,  3.362088032779402e-07, -1.192012912688050e-08,
  3.747036433447840e-10, -1.066432670264331e-11,  2.789319589913182e-13, -6.779692653762431e-15,  1.544511151847848e-16, -3.319088690926516e-18,  1.197948538935283e-02,
 -1.776076576354339e-03,  1.471919807915926e-04, -8.846629163736585e-06,  4.274422220580469e-07, -1.753398750712782e-08,  6.314312096858031e-10, -2.041614834448112e-11,
  6.022712117877967e-13, -1.640527342436646e-14,  4.164540785262819e-16, -9.920291214582330e-18,  6.925750204971270e-03, -1.250146848376480e-03,  1.233686224594418e-04,
 -8.683549333065493e-06,  4.850289347565323e-07, -2.275983006806080e-08,  9.293454663210145e-10, -3.381373090008803e-11,  1.115055450065794e-12, -3.375303736521734e-14,
  9.471552226445649e-16, -2.481848373886947e-17,  3.891821656888088e-03, -8.340167787350372e-04,  9.626236083419276e-05, -7.820954719502440e-06,  4.987873904996965e-07,
 -2.648117241009305e-08,  1.213861481117761e-09, -4.924325518693957e-11,  1.799661072572330e-12, -6.004823193910625e-14,  1.848323898665135e-15, -5.288351456065475e-17,
  2.146378562587284e-03, -5.339520132678578e-04,  7.087127492052323e-05, -6.553790975745132e-06,  4.714615398083116e-07, -2.801329239736940e-08,  1.427295181075456e-09,
 -6.396924335032140e-11,  2.568818643152277e-12, -9.371891749097284e-14,  3.140114627804396e-15, -9.738622441651242e-17,  1.173318844867251e-03, -3.319787525284004e-04,
  4.985846599512585e-05, -5.176141648301655e-06,  4.149471856409908e-07, -2.729350309092959e-08,  1.530297437354168e-09, -7.507194769532917e-11,  3.283830612145442e-12,
 -1.299263766199737e-13,  4.701956419392362e-15, -1.568991896629042e-16,  6.417515453053991e-04, -2.026549996105857e-04,  3.390425512644301e-05, -3.898014538509095e-06,
  3.440017336626537e-07, -2.477113091135397e-08,  1.512775912585991e-09, -8.045866000554353e-11,  3.799490206340057e-12, -1.616562044859287e-13,  6.268367428391436e-15,
 -2.233421670378674e-16,  3.539830289678488e-04, -1.225769118538215e-04,  2.249778990772638e-05, -2.825699962022016e-06,  2.711363076516379e-07, -2.113175902156730e-08,
  1.390831705517576e-09, -7.940817322385573e-11,  4.010689339656905e-12, -1.818909923246849e-13,  7.494202933060355e-15, -2.828549610609056e-16,  1.978061434855491e-04,
 -7.387495312798241e-05,  1.465314323152199e-05, -1.983110712493143e-06,  2.042919049585856e-07, -1.703140881506160e-08,  1.194874575598458e-09, -7.247996837959824e-11,
  3.877401760179068e-12, -1.857174576124526e-13,  8.059678169142340e-15, -3.195686769716731e-16,  1.117239307834147e-04, -4.430198944923488e-05,  9.355995747448621e-06,
 -1.345557273861120e-06,  1.468972789752226e-07, -1.294148884299372e-08,  9.568066161587771e-10, -6.100182710915836e-11,  3.421426842862207e-12, -1.714125686251351e-13,
  7.763778471449053e-15, -3.205837158137277e-16,  6.268214039609077e-05, -2.599952631654720e-05,  5.760144820871305e-06, -8.680209960819517e-07,  9.910116711710534e-08,
 -9.111159091407885e-09,  7.015115404737211e-10, -4.648423822813175e-11,  2.704552615515139e-12, -1.403049748836105e-13,  6.569096049960335e-15, -2.799252064159031e-16,
  3.293600430791584e-05, -1.408760720008781e-05,  3.226235694041032e-06, -5.022181264015002e-07,  5.915426520627087e-08, -5.602883543210171e-09,  4.437997554396749e-10,
 -3.021162511936728e-11,  1.803463693168030e-12, -9.587029264300650e-14,  4.594085439682049e-15, -2.001257828811257e-16,  1.269051360152732e-05, -5.520709078121558e-06,
  1.287802904481224e-06, -2.041285454330259e-07,  2.446579189898218e-08, -2.356196223765068e-09,  1.896156481883000e-10, -1.310440386002040e-11,  7.935757705734590e-13,
 -4.276606155599534e-14,  2.076155362613608e-15, -9.156314683656520e-17,  1.380537664856737e-01, -8.320574360629568e-04,  5.398670239740608e-06, -3.674182679456260e-08,
  2.563716907666137e-10, -1.806790961725578e-12,  1.274525461394490e-14, -8.959801697248296e-17,  6.262240591534033e-19, -4.349025332172892e-21,  2.999954488929701e-23,
 -2.056216333853530e-25,  1.261338086433530e-01, -1.235677364030721e-03,  1.421364631081107e-05, -1.582912221509373e-07,  1.676544851681034e-09, -1.702739871661468e-11,
  1.671619843385365e-13, -1.595358204492717e-15,  1.486137202355348e-17, -1.355317339627700e-19,  1.212857930513983e-21, -1.066942089543409e-23,  1.053998865093031e-01,
 -1.826915987372741e-03,  3.168062654697573e-05, -4.861497003141736e-07,  6.846134961124126e-09, -9.041913130774884e-11,  1.134462461779347e-12, -1.363841353524385e-14,
  1.580776058687231e-16, -1.774743827806397e-18,  1.937027226548635e-20, -2.061013167320871e-22,  8.071773349431517e-02, -2.310708066228579e-03,  5.520153270080326e-05,
 -1.113081273626311e-06,  2.005833327194414e-08, -3.322315582083817e-10,  5.145152887871546e-12, -7.536785338615899e-14,  1.052929257155957e-15, -1.411641865518924e-17,
  1.824899439573087e-19, -2.283116495645312e-21,  5.683107106393874e-02, -2.480685474576300e-03,  7.859691160971715e-05, -2.026600281248335e-06,  4.554613682683300e-08,
 -9.236294457531127e-10,  1.726346108657116e-11, -3.016616220352540e-13,  4.978215681545713e-15, -7.817453920223186e-17,  1.174952807950327e-18, -1.697685655228037e-20,
  3.694542374111889e-02, -2.303209928241721e-03,  9.438646139557350e-05, -3.045463248478863e-06,  8.371566496773917e-08, -2.042070628554632e-09,  4.531489990840517e-11,
 -9.300873287407775e-13,  1.786650204020291e-14, -3.240386728607007e-16,  5.586349881651518e-18, -9.201306489056507e-20,  2.229975167224905e-02, -1.886164144606906e-03,
  9.782181123999500e-05, -3.877950506274046e-06,  1.283367734793712e-07, -3.712375038999128e-09,  9.653001710890057e-11, -2.298771202643434e-12,  5.080620846501840e-14,
 -1.052478638357161e-15,  2.059146631647518e-17, -3.826671751085765e-19,  1.258299073765201e-02, -1.386350366992646e-03,  8.916774116919722e-05, -4.273382400525069e-06,
  1.679392802614071e-07, -5.690874177939951e-09,  1.714620320808878e-10, -4.688360186310628e-12,  1.180517021559074e-13, -2.767187931030242e-15,  6.089143388943885e-17,
 -1.265737650215570e-18,  6.692633249234442e-03, -9.290438740899825e-04,  7.271161862965015e-05, -4.150792949928642e-06,  1.913010752358876e-07, -7.510534891520763e-09,
  2.595791079746295e-10, -8.074014562277970e-12,  2.295941893984162e-13, -6.039215366551425e-15,  1.482804176954564e-16, -3.421341212127127e-18,  3.388020888410764e-03,
 -5.761485591473609e-04,  5.390104539351736e-05, -3.614334366170147e-06,  1.930651706934929e-07, -8.690972603729452e-09,  3.413334128187048e-10, -1.197221979209823e-11,
  3.813399520860120e-13, -1.116915076158921e-14,  3.037378737413447e-16, -7.724173194798742e-18,  1.650619585549150e-03, -3.355487021178206e-04,  3.689801603058250e-05,
 -2.867523935750649e-06,  1.755128921802674e-07, -8.967949899620700e-09,  3.965785783733477e-10, -1.555314516202239e-11,  5.505219269284989e-13, -1.782018364875972e-14,
  5.329219841792527e-16, -1.483478572153781e-17,  7.835422085958418e-04, -1.862756647010010e-04,  2.369192182249543e-05, -2.106020570307322e-06,  1.460376576158397e-07,
 -8.384592747906327e-09,  4.136661892572038e-10, -1.798614943767124e-11,  7.018693743549406e-13, -2.492062801850115e-14,  8.137270724606500e-16, -2.462572777617635e-17,
  3.672467807656344e-04, -1.000616821084206e-04,  1.449213930300090e-05, -1.454321532213937e-06,  1.129482065508301e-07, -7.211925052676219e-09,  3.932359994323506e-10,
 -1.879057979474403e-11,  8.017879228709020e-13, -3.098599056499271e-14,  1.096627768191074e-15, -3.582690994961323e-17,  1.722784764642015e-04, -5.278797480365488e-05,
  8.573411767918603e-06, -9.585055299856862e-07,  8.239680327803868e-08, -5.788798867674371e-09,  3.454166956081130e-10, -1.797395312410212e-11,  8.314254824528745e-13,
 -3.468950072526893e-14,  1.320411198009127e-15, -4.622700662305050e-17,  8.192748725250095e-05, -2.772772953061557e-05,  4.973301318567367e-06, -6.111075173053037e-07,
  5.743943440152970e-08, -4.390485790865089e-09,  2.837219981121245e-10, -1.592114125339476e-11,  7.911011581472700e-13, -3.532720829881121e-14,  1.434368850937033e-15,
 -5.339186391021847e-17,  3.989310003725241e-05, -1.465801532029445e-05,  2.859143934100265e-06, -3.807847205699171e-07,  3.863505753799280e-08, -3.175028848450411e-09,
  2.197534905533316e-10, -1.316055700841882e-11,  6.955737606726415e-13, -3.293690117530506e-14,  1.413958952039512e-15, -5.549140188365948e-17,  1.995850892113837e-05,
 -7.830450246121732e-06,  1.635375325588208e-06, -2.326801810142498e-07,  2.514378319523491e-08, -2.193802077084274e-09,  1.607170741244147e-10, -1.015829769056216e-11,
  5.651029090912709e-13, -2.809271654059797e-14,  1.263080461459188e-15, -5.179381246532140e-17,  1.013892401800089e-05, -4.179863261648033e-06,  9.200385667468549e-07,
 -1.377707149462361e-07,  1.563447811497519e-08, -1.429183550838791e-09,  1.094430575819696e-10, -7.214752877610348e-12,  4.177244496721212e-13, -2.157026836002265e-14,
  1.005491895278452e-15, -4.266838257744375e-17,  4.955519288312321e-06, -2.113521325141412e-06,  4.825191549802665e-07, -7.488362184563412e-08,  8.794447803672743e-09,
 -8.306531640962077e-10,  6.562030645702911e-11, -4.455780343663498e-12,  2.653434073650099e-13, -1.407297756108185e-14,  6.728976659020574e-16, -2.925147021280888e-17,
  1.831645286441427e-06, -7.959787226681528e-07,  1.854613138879151e-07, -2.936348147677613e-08,  3.515409183109321e-09, -3.381867817567106e-10,  2.718718887019402e-11,
 -1.877018519218972e-12,  1.135576885287531e-13, -6.113913898456800e-15,  2.965420017138643e-16, -1.306676768543401e-17,  1.348092180433852e-01, -7.905645911512434e-04,
  4.981239118002731e-06, -3.291316049237056e-08,  2.231026421259612e-10, -1.528882161692020e-12,  1.049507579159341e-14, -7.184887029199289e-17,  4.892463371424055e-19,
 -3.311842828670887e-21,  2.227199656901717e-23, -1.488803013942391e-25,  1.214070987620998e-01, -1.129134689124877e-03,  1.246452866908649e-05, -1.339871847008068e-07,
  1.372757229276663e-09, -1.350200767447923e-11,  1.284781483176920e-13, -1.189343067747631e-15,  1.075323471042678e-17, -9.523477071390204e-20,  8.280444416059137e-22,
 -7.080591681295143e-24,  9.856462429105682e-02, -1.595072443130009e-03,  2.644884288579323e-05, -3.897195235182691e-07,  5.281813189763339e-09, -6.725702731003200e-11,
  8.147723758054409e-13, -9.468723907747637e-15,  1.061962970626345e-16, -1.154665088531705e-18,  1.221412890941619e-20, -1.260395498988243e-22,  7.228061905776580e-02,
 -1.917532544799789e-03,  4.357080994311016e-05, -8.392502687823240e-07,  1.449545796773041e-08, -2.306877616858625e-10,  3.439178699293541e-12, -4.857168301649195e-14,
  6.550835019867065e-16, -8.487979809376222e-18,  1.061510425982758e-19, -1.285879352381721e-21,  4.802766518492588e-02, -1.938069155779145e-03,  5.810632884653834e-05,
 -1.425709588448531e-06,  3.061568249132121e-08, -5.949723680770648e-10,  1.068119035746328e-11, -1.795995515010367e-13,  2.856439318166264e-15, -4.328748616703515e-17,
  6.285972562339455e-19, -8.784637853849421e-21,  2.903980181647924e-02, -1.674289527816887e-03,  6.469958097682482e-05, -1.981469707029390e-06,  5.193358325190848e-08,
 -1.211829668039789e-09,  2.578994364911956e-11, -5.087186732415452e-13,  9.408108493111656e-15, -1.645238121056010e-16,  2.738485129828502e-18, -4.360214261364635e-20,
  1.606827358258552e-02, -1.259745312607144e-03,  6.151159474096701e-05, -2.311644430793179e-06,  7.286211518596082e-08, -2.014373812798644e-09,  5.019701931971544e-11,
 -1.148202616954788e-12,  2.442182937297851e-14, -4.876795895108242e-16,  9.210964986277117e-18, -1.654678764349072e-19,  8.194172750411854e-03, -8.398428536537496e-04,
  5.087186021060612e-05, -2.311293387647144e-06,  8.650855666009950e-08, -2.801794568666003e-09,  8.090981932683352e-11, -2.125446318977119e-12,  5.151919797047512e-14,
 -1.164564280793130e-15,  2.475042687421227e-17, -4.976069252538920e-19,  3.885159821695318e-03, -5.041007501120899e-04,  3.722754982486449e-05, -2.017320133973901e-06,
  8.864422782405899e-08, -3.329532123082839e-09,  1.104023929429419e-10, -3.302327409537293e-12,  9.048933935938077e-14, -2.297729308582270e-15,  5.454747706933374e-17,
 -1.218690236217207e-18,  1.730930177085101e-03, -2.767124463292412e-04,  2.450839977349724e-05, -1.563964203858792e-06,  7.982222385266684e-08, -3.444388435520293e-09,
  1.300212834896590e-10, -4.393388565140822e-12,  1.350811441406252e-13, -3.825845488191016e-15,  1.007668662785468e-16, -2.485513945814370e-18,  7.337690582282145e-04,
 -1.411498869273065e-04,  1.476085065975950e-05, -1.095665401425491e-06,  6.427991380641019e-08, -3.157398210179757e-09,  1.345608708053831e-10, -5.096822168679614e-12,
  1.745713088783078e-13, -5.477247997975751e-15,  1.590110531279402e-16, -4.303018875146797e-18,  3.002908365489580e-04, -6.804280662715766e-05,  8.275453295897196e-06,
 -7.058646744690762e-07,  4.710770892074012e-08, -2.609725149278346e-09,  1.245140632798702e-10, -5.245834407735443e-12,  1.987002366269063e-13, -6.858781746159395e-15,
  2.180361444111001e-16, -6.432461673244031e-18,  1.205863698986687e-04, -3.155517515120250e-05,  4.397470092798604e-06, -4.257413265045971e-07,  3.197722900712470e-08,
 -1.978932324357050e-09,  1.047819397661353e-10, -4.870478531616543e-12,  2.024689817389142e-13, -7.633743019613571e-15,  2.639102169388196e-16, -8.432409797104864e-18,
  4.835681370609879e-05, -1.434166630328415e-05,  2.256269322616771e-06, -2.448135751366916e-07,  2.046359862981219e-08, -1.400395062889225e-09,  8.152363378159923e-11,
 -4.144613855925229e-12,  1.875551522988703e-13, -7.664506553071804e-15,  2.860539963298949e-16, -9.829610866204617e-18,  1.971278153858200e-05, -6.506736480872606e-06,
  1.138250182103395e-06, -1.365898297476404e-07,  1.255536036384559e-08, -9.397888119064764e-10,  5.954502499393014e-11, -3.279844720660353e-12,  1.601359467387279e-13,
 -7.033288625228166e-15,  2.811152350105948e-16, -1.030953844148453e-17,  8.300408110170849e-06, -2.995483061188464e-06,  5.736604214648991e-07, -7.507194428552963e-08,
  7.491682113599023e-09, -6.061202456338969e-10,  4.133804078919982e-11, -2.441481912777035e-12,  1.273570057587051e-13, -5.956252478761969e-15,  2.527117365627928e-16,
 -9.808218982755721e-18,  3.646525015353066e-06, -1.413866248420440e-06,  2.916720889145247e-07, -4.100999741338057e-08,  4.382047633340807e-09, -3.782928373609782e-10,
  2.743683538622202e-11, -1.717813728040623e-12,  9.470907298062738e-14, -4.668495927433117e-15,  2.082232841905365e-16, -8.473865986579954e-18,  1.663066115103436e-06,
 -6.809639774812820e-07,  1.488100843767764e-07, -2.212795694389639e-08,  2.494414694823598e-09, -2.265815535048700e-10,  1.724736454515153e-11, -1.130559518765692e-12,
  6.510742673022636e-14, -3.344935776786482e-15,  1.551734482081149e-16, -6.554872914592583e-18,  7.508029246878509e-07, -3.191943834302101e-07,  7.262161957566692e-08,
 -1.123243482513806e-08,  1.314896423609189e-09, -1.238124940040348e-10,  9.752370532347541e-12, -6.603676409421912e-13,  3.922112368119626e-14, -2.074931139578322e-15,
  9.897501445976507e-17, -4.292748967386403e-18,  2.650519142757615e-07, -1.150523966736285e-07,  2.677331552208090e-08, -4.233647596540176e-09,  5.062397634043343e-10,
 -4.864386457248333e-11,  3.906117064769934e-12, -2.693873349331281e-13,  1.628059833163687e-14, -8.756592123399266e-16,  4.243068054175947e-17, -1.867911502924882e-18,
  1.317242408200168e-01, -7.522360642501201e-04,  4.606732519437079e-06, -2.957510731113722e-08,  1.948895608021108e-10, -1.299476768772558e-12,  8.685721630863725e-15,
 -5.794069352771107e-17,  3.845958910822926e-19, -2.539136002506296e-21,  1.665577017397329e-23, -1.086515732104636e-25,  1.170803108248238e-01, -1.035495942762537e-03,
  1.098006917594424e-05, -1.140265161783289e-07,  1.131042701105816e-09, -1.078222124168447e-11,  9.952085947899357e-14, -8.942647857151911e-16,  7.852933792181609e-18,
 -6.758559882175769e-20,  5.713238099356926e-22, -4.751773063879657e-24,  9.257979893519094e-02, -1.400847332998638e-03,  2.223808395052378e-05, -3.149928680126538e-07,
  4.112576023026433e-09, -5.053526335082777e-11,  5.915893364153263e-13, -6.651097430117125e-15,  7.223383080067342e-17, -7.611504532542088e-19,  7.808560992767135e-21,
 -7.819683139709376e-23,  6.524897687085852e-02, -1.605630956609349e-03,  3.475247564620456e-05, -6.401714279364068e-07,  1.060808763043295e-08, -1.623543440368405e-10,
  2.331971224683533e-12, -3.177768471735361e-14,  4.140416347780688e-16, -5.188266748385517e-18,  6.280853820221846e-20, -7.371170941293391e-22,  4.110740446051835e-02,
 -1.534146779669277e-03,  4.358509342008515e-05, -1.018666808545469e-06,  2.092023639959400e-08, -3.899238095424387e-10,  6.728481032131585e-12, -1.089407954365362e-13,
  1.670888391382504e-15, -2.445011237620103e-17,  3.432240858142889e-19, -4.641498672599681e-21,  2.324500790356768e-02, -1.239322760919788e-03,  4.520479895912973e-05,
 -1.315089322629743e-06,  3.288787862463893e-08, -7.345811556343183e-10,  1.500172095101557e-11, -2.845395398199718e-13,  5.068554477764154e-15, -8.550041714989428e-17,
  1.374583191281840e-18, -2.116404776070369e-20,  1.186221156697413e-02, -8.614780394134627e-04,  3.962271989809834e-05, -1.412220905922940e-06,  4.241359557227318e-08,
 -1.121124940376278e-09,  2.678392187350884e-11, -5.886528320759031e-13,  1.205252215557490e-14, -2.320592570564465e-16,  4.232101225420879e-18, -7.350469299568542e-20,
  5.501452671520968e-03, -5.239413708634924e-04,  2.988555921543381e-05, -1.287256377172572e-06,  4.589076386391972e-08, -1.420651370554335e-09,  3.932400324622991e-11,
 -9.924845283096565e-13,  2.315913316812926e-14, -5.048320993108874e-16,  1.036240695750907e-17, -2.014946445886986e-19,  2.339461136548220e-03, -2.832612188461222e-04,
  1.972480123689571e-05, -1.014173417199968e-06,  4.247470556651241e-08, -1.525869118766275e-09,  4.852814328060193e-11, -1.395550526147191e-12,  3.683981902701076e-14,
 -9.027923401891681e-16,  2.071670152577385e-17, -4.480493918467211e-19,  9.222737925800961e-04, -1.383147020009261e-04,  1.158347453479627e-05, -7.027936994247965e-07,
  3.424623129593555e-08, -1.415571867639669e-09,  5.132846579526934e-11, -1.669864497862116e-12,  4.953285217590292e-14, -1.355869752704235e-15,  3.456943280249022e-17,
 -8.266312636497903e-19,  3.416176586798587e-04, -6.203186363573171e-05,  6.158658203357225e-06, -4.360331894621272e-07,  2.449078856488346e-08, -1.155242736110790e-09,
  4.740252160439999e-11, -1.732557827245399e-12,  5.737380462136092e-14, -1.743442832031304e-15,  4.909670515877360e-17, -1.290636245563027e-18,  1.208195250175937e-04,
 -2.602332702678397e-05,  3.020248163736410e-06, -2.467685326276158e-07,  1.582606498310834e-08, -8.448355947314038e-10,  3.893245583335948e-11, -1.587504277286023e-12,
  5.830345976960955e-14, -1.954538769998518e-15,  6.043166171944867e-17, -1.736388970309769e-18,  4.157247779251206e-05, -1.041960310777918e-05,  1.394025695288374e-06,
 -1.299514101455411e-07,  9.423202622091042e-09, -5.643184724655519e-10,  2.897386202501771e-11, -1.308303207292149e-12,  5.291990754399092e-14, -1.944283625262024e-15,
  6.558721202482078e-17, -2.047389744452247e-18,  1.421543691866788e-05, -4.070090160555668e-06,  6.188438098372841e-07, -6.503607400489801e-08,  5.276467888338011e-09,
 -3.511424179673890e-10,  1.991279653317207e-11, -9.876858203794402e-13,  4.366722825610478e-14, -1.745635435171215e-15,  6.380629977159478e-17, -2.149687164742675e-18,
  4.941799952916623e-06, -1.587189629213452e-06,  2.702312406248304e-07, -3.160813990562378e-08,  2.836457740718496e-09, -2.075803372489460e-10,  1.287653979229189e-11,
 -6.952520035027780e-13,  3.331226382514788e-14, -1.437308581386841e-15,  5.648925409522717e-17, -2.038945369569214e-18,  1.785902443388160e-06, -6.318446328096818e-07,
  1.185937675464838e-07, -1.522512484504636e-08,  1.492160263853635e-09, -1.186893121008397e-10,  7.966237764850681e-12, -4.634562626614861e-13,  2.383417612280314e-14,
 -1.099800907798792e-15,  4.607292947100481e-17, -1.766826160070794e-18,  6.827964067676637e-07, -2.612866931357886e-07,  5.317340227468083e-08, -7.379281328996514e-09,
  7.788033264488933e-10, -6.645215686716871e-11,  4.766887767874716e-12, -2.953712348504515e-13,  1.612602696683923e-14, -7.875732142343963e-16,  3.482083986945409e-17,
 -1.405395724557819e-18,  2.770288076850787e-07, -1.125740188000748e-07,  2.440385889059091e-08, -3.600744891640639e-09,  4.029113459542056e-10, -3.634353322294780e-11,
  2.748235183261805e-12, -1.790239324524995e-13,  1.024903242873203e-14, -5.236164110042811e-16,  2.416268720210796e-17, -1.015595105791370e-18,  1.146314563291637e-07,
 -4.856076356820499e-08,  1.100607041034739e-08, -1.695963835841890e-09,  1.978246377218260e-10, -1.856415020676133e-11,  1.457529137167141e-12, -9.839223324444977e-14,
  5.826807976451800e-15, -3.074069192292454e-16,  1.462495415324699e-17, -6.327356829701488e-19,  3.846319724494518e-08, -1.667514987007667e-08,  3.875097825489021e-09,
 -6.119371677422452e-10,  7.307640449553070e-11, -7.012906868567850e-12,  5.624516019294216e-13, -3.874426222238379e-14,  2.338894092556319e-15, -1.256620245062485e-16,
  6.082687477581449e-18, -2.675078541767989e-19,  1.287868288980832e-01, -7.167507035447901e-04,  4.269718214165791e-06, -2.665399205373526e-08,  1.708600340660281e-10,
 -1.109176909638913e-12,  7.222804724237571e-15, -4.697637328467779e-17,  3.041117287403874e-19, -1.959356338378146e-21,  1.254225457591510e-23, -7.989653183319642e-26,
  1.131057558710941e-01, -9.528366046395342e-04,  9.713613099563150e-06, -9.753324299853641e-08,  9.373928488794007e-10, -8.667897402532125e-12,  7.766301560056786e-14,
 -6.778678757345729e-16,  5.785425759964424e-18, -4.841769004650161e-20,  3.981735553815985e-22, -3.223043969868581e-24,  8.730976339657609e-02, -1.237015796373281e-03,
  1.882196006887403e-05, -2.565647848251538e-07,  3.230017317718116e-09, -3.833400961462838e-11,  4.339937794397009e-13, -4.723889661546295e-15,  4.971468300844674e-17,
 -5.080315493768668e-19,  5.057836624917758e-21, -4.918401250971019e-23,  5.933761095105258e-02, -1.355682402020539e-03,  2.799072504183236e-05, -4.936554697197412e-07,
  7.855665740491593e-09, -1.157238582243843e-10,  1.602729454028071e-12, -2.108889451646477e-14,  2.656356903699991e-16, -3.221211759846542e-18,  3.777109818894721e-20,
 -4.297061548376640e-22,  3.559807813695393e-02, -1.229212156355303e-03,  3.313791271585800e-05, -7.384948697011021e-07,  1.451760790293716e-08, -2.597300384981382e-10,
  4.311179099998508e-12, -6.725942277056133e-14,  9.954512109268577e-16, -1.407350038903152e-17,  1.910823263899656e-19, -2.501774615697962e-21,  1.892234885811590e-02,
 -9.328648478424783e-04,  3.215282688045516e-05, -8.892661078611716e-07,  2.123523455906754e-08, -4.543226003487051e-10,  8.908873867129866e-12, -1.625693864499584e-13,
  2.790715550561272e-15, -4.543142584520491e-17,  7.057676670864310e-19, -1.051198323797984e-20,  8.957229565033248e-03, -6.022485313021050e-04,  2.610734776773184e-05,
 -8.829655344026813e-07,  2.528045405819606e-08, -6.392069095692008e-10,  1.464606293286546e-11, -3.093914858932415e-13,  6.099950117045797e-15, -1.132753924415480e-16,
  1.995206678769765e-18, -3.351130525329541e-20,  3.801168687043732e-03, -3.360306120132670e-04,  1.804986261671351e-05, -7.371617193815007e-07,  2.503526485653195e-08,
 -7.409170386252752e-10,  1.966105886968375e-11, -4.768056908862449e-13,  1.071173616130148e-14, -2.251873530597221e-16,  4.464476341727639e-18, -8.396146901625066e-20,
  1.458636013690006e-03, -1.645556122235311e-04,  1.079893074899482e-05, -5.266606471010506e-07,  2.101811500377749e-08, -7.220275123462757e-10,  2.202095446325071e-11,
 -6.087286538062151e-13,  1.547795291831496e-14, -3.659925799831115e-16,  8.116650704620698e-18, -1.698940414208454e-19,  5.117170688889850e-04, -7.185043391066048e-05,
  5.683348228177690e-06, -3.275840571860321e-07,  1.523047027561591e-08, -6.027219715196009e-10,  2.098178330274440e-11, -6.568876648832875e-13,  1.878954537511280e-14,
 -4.968599115497807e-16,  1.225734416040921e-17, -2.840158138816418e-19,  1.664010376412032e-04, -2.845402555452727e-05,  2.677673142848693e-06, -1.805965381547674e-07,
  9.700947935794071e-09, -4.390253774181668e-10,  1.732929708858368e-11, -6.106926440174178e-13,  1.953753991526289e-14, -5.745816157792067e-16,  1.568450500382151e-17,
 -4.002501472971463e-19,  5.101938819914069e-05, -1.041794446505832e-05,  1.151489221650075e-06, -8.997133707856807e-08,  5.537004298456014e-09, -2.844533079704330e-10,
  1.264604816573032e-11, -4.985282341248285e-13,  1.773448864574354e-14, -5.768295303728012e-16,  1.733020397450330e-17, -4.845445295670637e-19,  1.505740856249464e-05,
 -3.604520136043735e-06,  4.619228766199709e-07, -4.138133390742579e-08,  2.892012021600094e-09, -1.673360163256833e-10,  8.319211847224380e-12, -3.644432691925628e-13,
  1.432617712860548e-14, -5.123060001195832e-16,  1.684432936922625e-17, -5.131781194565235e-19,  4.383124294705370e-06, -1.208190728382292e-06,  1.771243959362373e-07,
 -1.799218999503819e-08,  1.414203833149801e-09, -9.136773699231990e-11,  5.039487381114371e-12, -2.435211063302592e-13,  1.050472417467501e-14, -4.102802646218390e-16,
  1.466978137347106e-17, -4.840315890395117e-19,  1.293520895058780e-06, -4.032430228105111e-07,  6.667121309791719e-08, -7.586041796685467e-09,  6.633925858522730e-10,
 -4.738793265256580e-11,  2.873515009109049e-12, -1.518711523169472e-13,  7.131635257094293e-15, -3.019074782017822e-16,  1.165400140746569e-17, -4.135472801510605e-19,
  3.983125562851464e-07, -1.378720063741363e-07,  2.531400220805853e-08, -3.182554975297186e-09,  3.058348197028108e-10, -2.388135095754540e-11,  1.575284108601476e-12,
 -9.016061511058293e-14,  4.565820944618849e-15, -2.076437706376317e-16,  8.579914556600024e-18, -3.247844312294912e-19,  1.313190719207152e-07, -4.952305214940540e-08,
  9.927662681587153e-09, -1.358023161906350e-09,  1.413863143424219e-10, -1.191021899539090e-11,  8.441179401011055e-13, -5.171282669294144e-14,  2.793197001279869e-15,
 -1.350425519598898e-16,  5.913801050291129e-18, -2.365417444632627e-19,  4.693941349114324e-08, -1.891279695243520e-08,  4.063403731659156e-09, -5.943925759142575e-10,
  6.596763678219512e-11, -5.904537842478275e-12,  4.432410190318893e-13, -2.867501016148424e-14,  1.630982537542337e-15, -8.281514526887380e-17,  3.799419020731248e-18,
 -1.588215393776625e-19,  1.765178483124112e-08, -7.448001630658300e-09,  1.680862638909727e-09, -2.579356341796206e-10,  2.996754696207733e-11, -2.801618470828007e-12,
  2.191794225264519e-13, -1.474597730852653e-14,  8.704635740095989e-16, -4.578390867926903e-17,  2.171904095332181e-18, -9.370909781053437e-20,  5.598797293067069e-09,
 -2.423972203527248e-09,  5.624610604511856e-10, -8.869016922954192e-11,  1.057607639700492e-11, -1.013555155781139e-12,  8.118204226023896e-14, -5.585097337444008e-15,
  3.367476334707574e-16, -1.807131420120450e-17,  8.737613642811446e-19, -3.838537065999281e-20,  1.259861793338641e-01, -6.838275024208162e-04,  3.965570149079522e-06,
 -2.408870950963928e-08,  1.503088453385541e-10, -9.505758666469894e-13,  6.033756789608282e-15, -3.828303296919127e-17,  2.418190001042496e-19, -1.521386866393463e-21,
  9.506804886522989e-24, -5.918423618529450e-26,  1.094427581155429e-01, -8.795668724736669e-04,  8.627794363775266e-06, -8.382664495289886e-08,  7.812382830476900e-10,
 -7.012335690144097e-12,  6.103295869744421e-14, -5.178060387799831e-16,  4.297946256075800e-18, -3.499829359219965e-20,  2.801656765702906e-22, -2.208429555604682e-24,
  8.264452052798282e-02, -1.097931462529219e-03,  1.602968151860443e-05, -2.104939620831998e-07,  2.557643973550352e-09, -2.934121866073756e-11,  3.215032572006205e-13,
 -3.390467598695917e-15,  3.460036140889368e-17, -3.431206618700695e-19,  3.317158330297822e-21, -3.134196533486231e-23,  5.432801576027118e-02, -1.153478576123940e-03,
  2.275088573431371e-05, -3.845754377386331e-07,  5.882558757857837e-09, -8.348125329206898e-11,  1.115694919737308e-12, -1.418569832787277e-14,  1.728586288359572e-16,
 -2.029820206769693e-18,  2.306775341462866e-20, -2.545425793232760e-22,  3.116040719052154e-02, -9.959690196584968e-04,  2.551484746312192e-05, -5.427292382105218e-07,
  1.022193841211470e-08, -1.756816319581904e-10,  2.807101645010876e-12, -4.222738314358378e-14,  6.034540291046039e-16, -8.247623322420083e-18,  1.083690064590789e-19,
 -1.374359365352790e-21,  1.564508085219151e-02, -7.131731247067897e-04,  2.325416387620542e-05, -6.119605116503473e-07,  1.396458843079426e-08, -2.863784089390845e-10,
  5.395466079115608e-12, -9.477805230935749e-14,  1.568724628237298e-15, -2.465765188093266e-17,  3.702967006566157e-19, -5.337548566388688e-21,  6.907414559672825e-03,
 -4.297564882531880e-04,  1.757148538335355e-05, -5.642448411721978e-07,  1.540947519290730e-08, -3.728806586184853e-10,  8.197937688769135e-12, -1.665215241657337e-13,
  3.162605048917778e-15, -5.666084847671612e-17,  9.641741099053099e-19, -1.566438709972992e-20,  2.698133856468713e-03, -2.211855122791303e-04,  1.119043797984541e-05,
 -4.334336234459436e-07,  1.402654999344057e-08, -3.969411111622779e-10,  1.010001439460698e-11, -2.353986358238546e-13,  5.092235171701445e-15, -1.032537543880377e-16,
  1.977366576546352e-18, -3.596942738222763e-20,  9.399984911377730e-04, -9.866303315102882e-05,  6.099509356610036e-06, -2.821045219791001e-07,  1.072671594394832e-08,
 -3.523389681091409e-10,  1.030414931722711e-11, -2.737765046998805e-13,  6.704399197096246e-15, -1.529527547686431e-16,  3.277764486549327e-18, -6.639144078749894e-20,
  2.951843766208573e-04, -3.873010268518636e-05,  2.890747922115150e-06, -1.581856738019830e-07,  7.013461467695341e-09, -2.655957026454947e-10,  8.872847712332227e-12,
 -2.672173939653408e-13,  7.367758678492099e-15, -1.881399905974435e-16,  4.489185657538251e-18, -1.007570566313682e-19,  8.470275134772068e-05, -1.360755945484592e-05,
  1.211962651204429e-06, -7.777894462719679e-08,  3.991830422907706e-09, -1.731751556098384e-10,  6.570605698854224e-12, -2.230952160772985e-13,  6.890685231657816e-15,
 -1.959961986029192e-16,  5.182817543488543e-18, -1.283119850026142e-19,  2.260073237610244e-05, -4.363427662237425e-06,  4.584180231890821e-07, -3.419941545945127e-08,
  2.016916208135383e-09, -9.959457743632406e-11,  4.266819604743645e-12, -1.624522665873183e-13,  5.592237193230281e-15, -1.763177687957795e-16,  5.142907403611266e-18,
 -1.398045657430903e-19,  5.731840183983968e-06, -1.306763124138206e-06,  1.600440604782499e-07, -1.375211591311708e-08,  9.247296477392676e-10, -5.161934527076539e-11,
  2.481511711651255e-12, -1.053305206909274e-13,  4.019060667471286e-15, -1.397308840770459e-16,  4.473186791469836e-18, -1.328685297828006e-19,  1.419357939358503e-06,
 -3.755806119385493e-07,  5.296209570263422e-08, -5.189097237625729e-09,  3.944085357098753e-10, -2.469628747970886e-11,  1.322799936986266e-12, -6.218455850922797e-14,
  2.613715650957465e-15, -9.961044516574372e-17,  3.479883987408707e-18, -1.123220184776368e-19,  3.542535263092365e-07, -1.069058737659479e-07,  1.712445540369429e-08,
 -1.891457969472346e-09,  1.608822135021004e-10, -1.119805279856818e-11,  6.627216578357692e-13, -3.423520868344093e-14,  1.573417743965813e-15, -6.526967524911150e-17,
  2.471586629433814e-18, -8.612811411279974e-20,  9.231646328883766e-08, -3.119312736210132e-08,  5.590839066197997e-09, -6.870521291107995e-10,  6.462642216068205e-11,
 -4.946209731784144e-12,  3.201834271478913e-13, -1.800420050875962e-14,  8.966893741648121e-16, -4.014395369713515e-17,  1.634335085284458e-18, -6.100595079888255e-20,
  2.600311217955409e-08, -9.647997112527184e-09,  1.902138443836818e-09, -2.560930654583404e-10,  2.626578978321061e-11, -2.181655644681673e-12,  1.525881503009721e-13,
 -9.232270560516169e-15,  4.928556999283087e-16, -2.356612013385238e-17,  1.021298374720715e-18, -4.045025672700465e-20,  8.104494628897674e-09, -3.234446158129027e-09,
  6.880140887399964e-10, -9.967981993322465e-11,  1.096257586260795e-11, -9.728398211820744e-13,  7.244121889987157e-14, -4.650966640717500e-15,  2.626469799802277e-16,
 -1.324623765455919e-17,  6.038420082515641e-19, -2.508981854519220e-20,  2.744077067212865e-09, -1.152673208923246e-09,  2.588965189633810e-10, -3.954512153568846e-11,
  4.574199992373638e-12, -4.258492063753900e-13,  3.318392238416892e-14, -2.224210685006327e-15,  1.308323416655141e-16, -6.858380953665595e-18,  3.243174025106703e-19,
 -1.395106137712671e-20,  8.177184688221795e-10, -3.534979635871773e-10,  8.189203169966384e-11, -1.289210196377847e-11,  1.534952774781512e-12, -1.468813070990028e-13,
  1.174774886026616e-14, -8.070994692058334e-16,  4.859901397369093e-17, -2.604731255111686e-18,  1.257878544833736e-19, -5.519590803484260e-21,  1.233125435805455e-01,
 -6.532197107837315e-04,  3.690332431321311e-06, -2.182834145004151e-08,  1.326629172428181e-10, -8.178024893861941e-13,  5.062428233213794e-15, -3.135255224463542e-17,
  1.933104784658353e-19, -1.188424940128281e-21,  7.250540474692401e-24, -4.415883418510202e-26,  1.060564510760290e-01, -8.143658647747898e-04,  7.692490334023891e-06,
 -7.237388324839097e-08,  6.545407422402040e-10, -5.707077444259758e-12,  4.828484545823333e-14, -3.984443962520865e-16,  3.218348397466027e-18, -2.551511981272370e-20,
  1.989363041374857e-22, -1.527934147411482e-24,  7.849419862254019e-02, -9.791440678629912e-04,  1.373119754455017e-05, -1.738771772165358e-07,  2.040892111235279e-09,
 -2.264978323714789e-11,  2.403822343972807e-13, -2.457755974958888e-15,  2.433800526560472e-17, -2.343617544832329e-19,  2.201481453402808e-21, -2.022219892314723e-23,
  5.005099064063135e-02, -9.884491222406061e-04,  1.864997749440188e-05, -3.024812405482115e-07,  4.451492726138171e-09, -6.090756884080980e-11,  7.861038981810464e-13,
 -9.665111891771778e-15,  1.140107373478471e-16, -1.297238053656070e-18,  1.429663277656168e-20, -1.531007281135002e-22,  2.754712210788242e-02, -8.153659782134199e-04,
  1.987829898327838e-05, -4.039928119765198e-07,  7.296451818432079e-09, -1.205646277524838e-10,  1.855789773002438e-12, -2.693628805673369e-14,  3.719148293011659e-16,
 -4.916819765848435e-18,  6.255404782003452e-20, -7.688466411093514e-22,  1.312278704848651e-02, -5.531092337518873e-04,  1.708277817568874e-05, -4.281217703033465e-07,
  9.343149911752014e-09, -1.837884666731875e-10,  3.329020727316656e-12, -5.632652041377587e-14,  8.993884620462368e-16, -1.365622910855316e-17,  1.983438843124691e-19,
 -2.767968440311684e-21,  5.431898547334470e-03, -3.125814173685937e-04,  1.206449962943509e-05, -3.680653373881943e-07,  9.593672731378729e-09, -2.222939955771613e-10,
  4.691698841538478e-12, -9.167808318061079e-14,  1.677911592137864e-15, -2.901289130072597e-17,  4.771145460378842e-19, -7.499965414748598e-21,  1.964184246203819e-03,
 -1.491793022926179e-04,  7.111052695279019e-06, -2.612978737263541e-07,  8.060202199674467e-09, -2.181779945240252e-10,  5.324558940005585e-12, -1.192935007715335e-13,
  2.485404154025888e-15, -4.861651927771568e-17,  8.994633082910074e-19, -1.582769179636905e-20,  6.250075963398577e-04, -6.094993741219358e-05,  3.548803136258952e-06,
 -1.556421601039565e-07,  5.638599706610733e-09, -1.770921808233179e-10,  4.966139308732154e-12, -1.268215938608504e-13,  2.991009644571198e-15, -6.583143870182959e-17,
  1.363142538623646e-18, -2.671603423599493e-20,  1.767360578243528e-04, -2.162883329793114e-05,  1.522047644104498e-06, -7.902948939019270e-08,  3.340019964993244e-09,
 -1.209953884567580e-10,  3.877812807233434e-12, -1.123071111814339e-13,  2.983950265055638e-15, -7.355863393122560e-17,  1.697114930740795e-18, -3.688463704150055e-20,
  4.499767198755005e-05, -6.776005864130496e-06,  5.704081714170668e-07, -3.479654317901001e-08,  1.704847305852926e-09, -7.084616218414803e-11,  2.582096374977516e-12,
 -8.441645996137722e-14,  2.515729997367062e-15, -6.916743988904758e-17,  1.770822243963151e-18, -4.250864609708137e-20,  1.049513247019183e-05, -1.910714020121692e-06,
  1.904500123711999e-07, -1.354590751750802e-08,  7.645886041946691e-10, -3.624941139429428e-11,  1.495033091424466e-12, -5.492206772908272e-14,  1.827888361107035e-15,
 -5.581782805325500e-17,  1.579386821690364e-18, -4.171025046192460e-20,  2.293454189307220e-06, -4.965152488349960e-07,  5.798631346908453e-08, -4.770247148940523e-09,
  3.081273705363143e-10, -1.656929932255471e-11,  7.692039532112843e-13, -3.159617738795065e-14,  1.168890987624604e-15, -3.946735481879256e-17,  1.228893685068427e-18,
 -3.555345725115919e-20,  4.832301712471349e-07, -1.223845101355869e-07,  1.655925866855839e-08, -1.561598343024869e-09,  1.145607189117499e-10, -6.940485132055732e-12,
  3.604520947627924e-13, -1.646078988198959e-14,  6.732443402348881e-16, -2.500483524394026e-17,  8.524830852001508e-19, -2.688736187176333e-20,  1.017096240837100e-07,
 -2.962856342085946e-08,  4.586677559885517e-09, -4.907200936738298e-10,  4.051819026231492e-11, -2.743139346561900e-12,  1.581863247444697e-13, -7.975052596820580e-15,
  3.582203936532205e-16, -1.454214582322158e-17,  5.395343320021070e-19, -1.844172903168491e-20,  2.229062870525628e-08, -7.334432785267187e-09,  1.280403793403744e-09,
 -1.534899453655096e-10,  1.410628149832262e-11, -1.056418816258498e-12,  6.700660753557538e-14, -3.696484108874618e-15,  1.808199994880857e-16, -7.959116888479628e-18,
  3.188891036022618e-19, -1.172514870049140e-20,  5.314863437334561e-09, -1.936548602166064e-09,  3.748232777979630e-10, -4.958693483771825e-11,  5.002654061819006e-12,
 -4.091477532480313e-13,  2.820415651000057e-14, -1.683378622895576e-15,  8.872096665313540e-17, -4.191331648123837e-18,  1.795862201662113e-19, -7.036954370925783e-21,
  1.428743591591664e-09, -5.641201234608332e-10,  1.186647849323383e-10, -1.700910184090796e-11,  1.851797317064356e-12, -1.627752917884227e-13,  1.201286478517869e-14,
 -7.648021416832792e-16,  4.284874971745945e-17, -2.144950294799773e-18,  9.709377854014277e-20, -4.007625056159979e-21,  4.311223156994214e-10, -1.801879620764361e-10,
  4.025527104973530e-11, -6.117018910911349e-12,  7.040822652045846e-13, -6.524419369281331e-14,  5.061795583155007e-15, -3.378708404115987e-16,  1.979648576720919e-17,
 -1.033918602939647e-18,  4.872074291455907e-20, -2.088886039879370e-21,  1.198711346922021e-10, -5.173460219767551e-11,  1.196340925716192e-11, -1.880044125420397e-12,
  2.234587223146564e-13, -2.134800470558595e-14,  1.704765064259214e-15, -1.169460988884698e-16,  7.031746553266899e-18, -3.763591752016294e-19,  1.815128519042545e-20,
 -7.954812562660377e-22,  1.207571004583238e-01, -6.247099290126359e-04,  3.440608821694773e-06, -1.983026815367363e-08,  1.174541944721915e-10, -7.061772793351879e-13,
  4.265106221438696e-15, -2.579876275855390e-17,  1.553114469750324e-19, -9.337844022272852e-22,  5.561239021757361e-24, -3.319107277374449e-26,  1.029168074471130e-01,
 -7.561301371230399e-04,  6.883267047375481e-06, -6.275499449795013e-08,  5.511406172391940e-10, -4.671277834089799e-12,  3.844236782632664e-14, -3.087405048770734e-16,
  2.428214037005173e-18, -1.875357007773949e-20,  1.424903721061784e-22, -1.066942220034567e-24,  7.478484758972739e-02, -8.771179705732424e-04,  1.182660325216880e-05,
 -1.445553190208149e-07,  1.640437821185302e-09, -1.762563799673262e-11,  1.813119235353117e-13, -1.798534691900920e-15,  1.729299225674641e-17, -1.617983202330082e-19,
  1.477635732639448e-21, -1.320319415412022e-23,  4.637420039778462e-02, -8.526439439386600e-04,  1.541043273059521e-05, -2.400625995560979e-07,  3.402046718756263e-09,
 -4.491579841826891e-11,  5.602536319396921e-13, -6.665547942384305e-15,  7.616539426026221e-17, -8.402472314652966e-19,  8.985488393260516e-21, -9.343603858655618e-23,
  2.457558611271941e-02, -6.739153240519710e-04,  1.565846414186824e-05, -3.043541487834632e-07,  5.275771600971267e-09, -8.387921606435284e-11,  1.244676285410848e-12,
 -1.744335004922965e-14,  2.328425137945276e-16, -2.979284058590766e-18,  3.672100163429363e-20, -4.376325959625270e-22,  1.115438930944666e-02, -4.347091148178144e-04,
  1.273368471154807e-05, -3.041795244653316e-07,  6.353659048871563e-09, -1.199703744890152e-10,  2.090573980025648e-12, -3.409093318247942e-14,  5.254203757737399e-16,
 -7.710602366366165e-18,  1.083599717538142e-19, -1.464699747156348e-21,  4.349915667569304e-03, -2.314251453863985e-04,  8.439665321447720e-06, -2.447904373267292e-07,
  6.093568916004871e-09, -1.352775115107111e-10,  2.742342272179583e-12, -5.157402958995602e-14,  9.100150214610243e-16, -1.519223820146087e-17,  2.415261460670568e-19,
 -3.674649003098413e-21,  1.464093784883349e-03, -1.029323713224627e-04,  4.624996513290929e-06, -1.612923919595066e-07,  4.744369923174512e-09, -1.228829022999683e-10,
  2.877285576272317e-12, -6.198595664407689e-14,  1.244113389586842e-15, -2.348186322838314e-17,  4.197911276438637e-19, -7.147020033208508e-21,  4.280167506717965e-04,
 -3.872903493470591e-05,  2.123613933583707e-06, -8.832098155313409e-08,  3.048808704395607e-09, -9.156502159448339e-11,  2.462348653256169e-12, -6.044200319660970e-14,
  1.372904189897504e-15, -2.915281525346979e-17,  5.832750262724102e-19, -1.106084977516444e-20,  1.096430760310706e-04, -1.249305836240828e-05,  8.283444318524425e-07,
 -4.079409390352866e-08,  1.642938824799481e-09, -5.691975904615027e-11,  1.749673875224948e-12, -4.871910485164260e-14,  1.247096555478103e-15, -2.967147905765619e-17,
  6.617675930749056e-19, -1.392385247135405e-20,  2.491170527674571e-05, -3.508481334990562e-06,  2.788056241469425e-07, -1.615259655337382e-08,  7.549477142392188e-10,
 -3.003250272460744e-11,  1.050835959616962e-12, -3.306175358091833e-14,  9.501758336108248e-16, -2.523929302164477e-17,  6.253065389484564e-19, -1.454742906191524e-20,
  5.104227076811749e-06, -8.739666533231722e-07,  8.250324438943902e-08, -5.586924882985512e-09,  3.014675677341970e-10, -1.370866159454936e-11,  5.437783209263430e-13,
 -1.925824484527645e-14,  6.191670822262183e-16, -1.829808702916062e-17,  5.018790656189761e-19, -1.286708449646924e-20,  9.644489390180803e-07, -1.976887703416115e-07,
  2.196717956291283e-08, -1.727004785914634e-09,  1.069919851769474e-10, -5.534750196533317e-12,  2.478099385165889e-13, -9.839143081517327e-15,  3.525237998490188e-16,
 -1.154775209515154e-17,  3.493785377673423e-19, -9.835932934517271e-21,  1.731148753291056e-07, -4.183356033975449e-08,  5.417676052180347e-09, -4.907092594384024e-10,
  3.468113026072742e-11, -2.029493652266093e-12,  1.020410373141565e-13, -4.520402188802043e-15,  1.796681426681262e-16, -6.495127356378875e-18,  2.158449296669352e-19,
 -6.644821068799186e-21,  3.066960211979238e-08, -8.598235400279282e-09,  1.283076489071092e-09, -1.326676938138266e-10,  1.061235296378093e-11, -6.975577486133522e-13,
  3.912977436706329e-14, -1.922311176001986e-15,  8.426785276494260e-17, -3.343236948736108e-18,  1.213767863630875e-19, -4.064574076507360e-21,  5.621558450591616e-09,
 -1.796413965801952e-09,  3.047237074884335e-10, -3.555691698505266e-11,  3.186565235762193e-12, -2.330966064784418e-13,  1.446318770586949e-14, -7.815862476817271e-16,
  3.749871810094082e-17, -1.620723455837146e-18,  6.382752640728212e-20, -2.309075720452238e-21,  1.124359679346540e-09, -4.014788805339985e-10,  7.613788936923734e-11,
 -9.879754089498552e-12,  9.788288195066274e-13, -7.870758389578047e-14,  5.340059800818263e-15, -3.140074427832348e-16,  1.631933446752738e-17, -7.608636203992895e-19,
  3.219867348225832e-20, -1.247029257719408e-21,  2.577395527877387e-10, -1.005439443162351e-10,  2.088723972540572e-11, -2.958371113349144e-12,  3.184754570619358e-13,
 -2.770007634601431e-14,  2.024099583701913e-15, -1.276704683389903e-16,  7.090537914678335e-18, -3.520326750973477e-19,  1.581210929988693e-20, -6.479152282103005e-22,
  6.853960454088514e-11, -2.848394694666520e-11,  6.325363219052071e-12, -9.556100158169064e-13,  1.093887813450949e-13, -1.008405090992159e-14,  7.785242926630740e-16,
 -5.172682284482892e-17,  3.017627803437685e-18, -1.569579485425042e-19,  7.367660085435881e-21, -3.147353716872911e-22,  1.764369666320921e-11, -7.600855863006027e-12,
  1.754180437634213e-12, -2.751316312913956e-13,  3.264033325730612e-14, -3.112680635356810e-15,  2.481401120448215e-16, -1.699445416388674e-17,  1.020248362867505e-18,
 -5.452513794389702e-20,  2.625921660247575e-21, -1.149245820838872e-22,  1.183118471143499e-01, -5.981060022046958e-04,  3.213472497731184e-06, -1.805866359184275e-08,
  1.042985388065519e-10, -6.119511023881562e-13,  3.607557069507545e-15, -2.132642385906867e-17,  1.253708848908146e-19, -7.379942488566487e-22,  4.286748328970285e-24,
 -2.514954053364499e-26,  9.999785246175034e-02, -7.039331188679645e-04,  6.180188282477324e-06, -5.463680908778243e-08,  4.662838729038046e-10, -3.844204040959123e-12,
  3.079132103521939e-14, -2.408252621190789e-16,  1.845304803127531e-18, -1.389139472387043e-20,  1.029092739797547e-22, -7.516567667894912e-25,  7.145521159805340e-02,
 -7.890229363412481e-04,  1.023851017723185e-05, -1.209080473839709e-07,  1.327662578503073e-09, -1.382092868398324e-11,  1.378997575749269e-13, -1.327993047839061e-15,
  1.240576041979291e-17, -1.128462668577744e-19,  1.002523587556201e-21, -8.718497017164173e-24,  4.319316878031074e-02, -7.400219517991373e-04,  1.282883791432603e-05,
 -1.921446451492155e-07,  2.624387363427325e-09, -3.345957651991351e-11,  4.036446019084893e-13, -4.650176600668852e-15,  5.150533697519517e-17, -5.512379347608631e-19,
  5.723259259711077e-21, -5.782045512833080e-23,  2.210919947615797e-02, -5.619393187390171e-04,  1.246216580663593e-05, -2.318915093206149e-07,  3.861313008856169e-09,
 -5.911581944315831e-11,  8.462743111495271e-13, -1.145875571957744e-14,  1.479670380074508e-16, -1.833471970646012e-18,  2.190503015891428e-20, -2.532625396221018e-22,
  9.598394044970858e-03, -3.458781856892325e-04,  9.622320716195762e-06, -2.192835090482522e-07,  4.387501405594931e-09, -7.958065747634587e-11,  1.334992554249792e-12,
 -2.099381849377803e-14,  3.124889555620262e-16, -4.434423475309338e-18,  6.032774747294142e-20, -7.901796575416771e-22,  3.542741048380695e-03, -1.741849195463199e-04,
  6.008251245971344e-06, -1.657993793546265e-07,  3.944292605258984e-09, -8.394531734454007e-11,  1.635398287582321e-12, -2.961571258740223e-14,  5.040217044568159e-16,
 -8.127400522719421e-18,  1.249587825721351e-19, -1.840689744266503e-21,  1.115709091187461e-03, -7.254900362159040e-05,  3.074560976541695e-06, -1.018099018528391e-07,
  2.856989353347904e-09, -7.083544795138338e-11,  1.591930345486403e-12, -3.298809748338685e-14,  6.380279876637521e-16, -1.162284180814518e-17,  2.008234318119026e-19,
 -3.308647555006762e-21,  3.013764667993085e-04, -2.527110518774681e-05,  1.305034393934353e-06, -5.147664193895229e-08,  1.693449745768169e-09, -4.864229323959098e-11,
  1.254577782901068e-12, -2.960431851337156e-14,  6.477027558251941e-16, -1.327005158652682e-17,  2.565499576213991e-19, -4.707415095555871e-21,  7.035703502809878e-05,
 -7.451247012426649e-06,  4.652646723822405e-07, -2.172639036136662e-08,  8.336687113698223e-10, -2.761790029173386e-11,  8.141409951061457e-13, -2.179226784960474e-14,
  5.373480855039617e-16, -1.233740090508116e-17,  2.659533980000180e-19, -5.416268200375161e-21,  1.435035698396697e-05, -1.886106266538856e-06,  1.413350706669665e-07,
 -7.770550553949624e-09,  3.462498905858960e-10, -1.317898708759857e-11,  4.424936000273285e-13, -1.339184559393860e-14,  3.709991935526429e-16, -9.516975727864312e-18,
  2.280744643025985e-19, -5.140208325652651e-21,  2.596958076279271e-06, -4.171142613436351e-07,  3.723162870095879e-08, -2.397424809135985e-09,  1.235399444118784e-10,
 -5.383250554821280e-12,  2.052040381026874e-13, -7.000709032176531e-15,  2.172712787683890e-16, -6.209679264619025e-18,  1.649853730284752e-19, -4.103612884484291e-21,
  4.260810162921096e-07, -8.244560293366281e-08,  8.698341303715044e-09, -6.523991733548136e-10,  3.870790765432254e-11, -1.923759351061324e-12,  8.297302425728817e-14,
 -3.180836019960562e-15,  1.102590358474010e-16, -3.500597753567432e-18,  1.028151921086468e-19, -2.814095084471869e-21,  6.529549178928503e-08, -1.500753654083644e-08,
  1.855621765267279e-09, -1.610916983088578e-10,  1.094834947987306e-11, -6.178308851390859e-13,  3.002858393958227e-14, -1.288647546838819e-15,  4.970937866491637e-17,
 -1.746996628095376e-18,  5.652481666274449e-20, -1.696621650770006e-21,  9.728880911017168e-09, -2.616586005938498e-09,  3.753856293205922e-10, -3.742519549690383e-11,
  2.894340389464880e-12, -1.843671825303061e-13,  1.004339733078878e-14, -4.800307715707901e-16,  2.050674798768250e-17, -7.940317917473967e-19,  2.817271045646217e-20,
 -9.231683759398409e-22,  1.484475767975492e-09, -4.593778070621218e-10,  7.552225770995826e-11, -8.558276033774843e-12,  7.463779117430133e-13, -5.322924330893308e-14,
  3.225384837602350e-15, -1.704709318572070e-16,  8.010058953091767e-18, -3.394765202565008e-19,  1.312438711098004e-20, -4.665964409084994e-22,  2.468907527144694e-10,
 -8.619364927567414e-11,  1.598134786288603e-11, -2.030061059922421e-12,  1.971604833724993e-13, -1.556142763728268e-14,  1.037583915655590e-15, -6.002616807425717e-17,
  3.072305218085534e-18, -1.411985664732611e-19,  5.895085486038118e-21, -2.254274911499630e-22,  4.769420220955159e-11, -1.835389064243731e-11,  3.759876945328348e-12,
 -5.254746614395048e-13,  5.586377832043774e-14, -4.802138087145685e-15,  3.470631845829742e-16, -2.166655781558964e-17,  1.191729811584692e-18, -5.863207063934053e-20,
  2.611140337453424e-21, -1.061381414685483e-22,  1.104172727654001e-11, -4.559328783505336e-12,  1.005636742750907e-12, -1.509389800775074e-13,  1.717165555381159e-14,
 -1.573804389686963e-15,  1.208413441921263e-16, -7.987830364277610e-18,  4.637462877477678e-19, -2.401166671526590e-20,  1.122292991876914e-21, -4.774958204577136e-23,
  2.608646579089106e-12, -1.121515976447589e-12,  2.582626287019769e-13, -4.041956394900938e-14,  4.785272602593067e-15, -4.554372104224038e-16,  3.623875622418194e-17,
 -2.477449131007656e-18,  1.484777585786715e-19, -7.922181703273955e-21,  3.809383856729161e-22, -1.664726935497595e-23,  1.159695050686597e-01, -5.732375694510558e-04,
  3.006392009175683e-06, -1.648329006750798e-08,  9.287920502756912e-11, -5.321054869345238e-13,  3.062813306311749e-15, -1.770859634808103e-17,  1.016401445692731e-19,
 -5.867853726138094e-22,  3.316586605273734e-24, -1.925236883214659e-26,  9.727702226581349e-02, -6.569929434715372e-04,  5.566896725363392e-06, -4.775336614461744e-08,
  3.962761401602060e-10, -3.179892202925509e-12,  2.480504076484031e-14, -1.890428810795446e-16,  1.411985938223114e-18, -1.036659310553865e-20,  7.491205733829464e-23,
 -5.340591954747586e-25,  6.845423052806272e-02, -7.125772161488218e-04,  8.906497191195091e-06, -1.017088543539216e-07,  1.081544919416287e-09, -1.091617543437477e-11,
  1.057141315423393e-13, -9.889606033520604e-16,  8.981435670993401e-18, -7.947277746995622e-20,  6.871988762845935e-22, -5.819599871979258e-24,  4.042468415347383e-02,
 -6.459480039162186e-04,  1.075455165653899e-05, -1.550227662058765e-07,  2.042414038567610e-09, -2.516519372249971e-11,  2.938191335113645e-13, -3.279868604027805e-15,
  3.523479437917164e-17, -3.660594425401440e-19,  3.692070872363441e-21, -3.625802618441236e-23,  2.004458579013129e-02, -4.724056990383244e-04,  1.001443548077945e-05,
 -1.785656775007059e-07,  2.858640799840911e-09, -4.217577029720193e-11,  5.828859060120642e-13, -7.630394604151404e-15,  9.537512935266011e-17, -1.145123476827871e-18,
  1.326852500795911e-20, -1.489023005154861e-22,  8.353711336206385e-03, -2.783423963373320e-04,  7.364733547940126e-06, -1.602568313038333e-07,  3.073941973935368e-09,
 -5.359719526547521e-11,  8.661259907104835e-13, -1.314307145314337e-14,  1.890423175157110e-16, -2.595423843338362e-18,  3.419773831197429e-20, -4.342402461469456e-22,
  2.930894911026436e-03, -1.331194516435224e-04,  4.348116439623647e-06, -1.142416932782826e-07,  2.599099396329978e-09, -5.306350745664374e-11,  9.940324602206111e-13,
 -1.734253332158396e-14,  2.848088796248452e-16, -4.437842518343734e-18,  6.601316582942822e-20, -9.418080479911075e-22,  8.679388997477044e-04, -5.215787928921981e-05,
  2.086318079890090e-06, -6.563286390836202e-08,  1.757990814772556e-09, -4.174352051520699e-11,  9.007948476577568e-13, -1.796159400424758e-14,  3.348798099824855e-16,
 -5.889679816144630e-18,  9.838089596974302e-20, -1.568892418213422e-21,  2.178250428342910e-04, -1.690564381591223e-05,  8.224015864641328e-07, -3.077296926369167e-08,
  9.650200127878242e-10, -2.651687354583960e-11,  6.560859671404240e-13, -1.488557360452304e-14,  3.137418663903099e-16, -6.202702402379973e-18,  1.158858345701176e-19,
 -2.057636520969442e-21,  4.661744113508275e-05, -4.581224580350259e-06,  2.692984230042958e-07, -1.192203662004629e-08,  4.358145387626196e-10, -1.380475253534808e-11,
  3.902368354117565e-13, -1.004071033395226e-14,  2.384722325145262e-16, -5.283188009607436e-18,  1.100647657723771e-19, -2.169357885090774e-21,  8.587333139145031e-06,
 -1.051062746397718e-06,  7.420142096785360e-08, -3.869046146506244e-09,  1.642841235010894e-10, -5.980351638918500e-12,  1.926062361858447e-13, -5.605208657651838e-15,
  1.496333299240595e-16, -3.705597242979392e-18,  8.587146337306504e-20, -1.874188148302525e-21,  1.380499565254833e-06, -2.074602748285710e-07,  1.748313985228503e-08,
 -1.069290462785972e-09,  5.257160615539347e-11, -2.193411848602769e-12,  8.028918712286662e-14, -2.636799461244187e-15,  7.894491850408228e-17, -2.180663131978309e-18,
  5.608986318449390e-20, -1.352656648287698e-21,  1.976299979539773e-07, -3.599229764946432e-08,  3.598064323355390e-09, -2.570395341681293e-10,  1.458535969859972e-11,
 -6.955742744951030e-13,  2.886783015001998e-14, -1.067427804485805e-15,  3.576303430188980e-17, -1.099471492761490e-18,  3.132098373027230e-20, -8.327474086936205e-22,
  2.593763094475447e-08, -5.651670972545416e-09,  6.655382187046293e-10, -5.526327363417697e-11,  3.605319740592053e-12, -1.958840891008173e-13,  9.189925790582099e-15,
 -3.815275256911783e-16,  1.426580614516893e-17, -4.868275959417510e-19,  1.531899279459248e-20, -4.478356641168436e-22,  3.251168677386768e-09, -8.360482320037478e-10,
  1.149967073483054e-10, -1.102874427379037e-11,  8.229062742756876e-13, -5.070369223964985e-14,  2.677730257649572e-15, -1.243211837323614e-16,  5.168065083224683e-18,
 -1.950344335752869e-19,  6.754075286006285e-21, -2.163036393945548e-22,  4.114627410654107e-10, -1.229177700665206e-10,  1.953175992009564e-11, -2.144383442041182e-12,
  1.815993232370292e-13, -1.260194093543349e-14,  7.443848913067993e-16, -3.841570824685115e-17,  1.765138717634074e-18, -7.325183246977046e-20,  2.776399487803543e-21,
 -9.688053735187090e-23,  5.643967500570839e-11, -1.921523019517531e-11,  3.474977302431975e-12, -4.311883854472574e-13,  4.097176894751737e-14, -3.168587489546185e-15,
  2.072907163507130e-16, -1.178074559509895e-17,  5.930054064052886e-19, -2.683059325383847e-20,  1.103828017508406e-21, -4.163074821293913e-23,  9.077671128591763e-12,
 -3.439999969097475e-12,  6.937190030779720e-13, -9.551836674462729e-14,  1.001376576565472e-14, -8.496314719466107e-16,  6.066020739363408e-17, -3.743916810988629e-18,
  2.037363701870023e-19, -9.923577819225202e-21,  4.377942079864527e-22, -1.763885894133600e-23,  1.805481977834433e-12, -7.400818750223857e-13,  1.619902337412660e-13,
 -2.413532875375219e-14,  2.726777572432591e-15, -2.482895207887401e-16,  1.894824870192281e-17, -1.245352942088870e-18,  7.191282075768595e-20, -3.704683182602861e-21,
  1.723327441238511e-22, -7.299429853587864e-24,  3.876206242241306e-13, -1.662687656987917e-13,  3.819466429028410e-14, -5.963392557079058e-15,  7.043898359791756e-16,
 -6.689399825214431e-17,  5.311669880535118e-18, -3.624152344168847e-19,  2.167949599533082e-20, -1.154670775662222e-21,  5.542818495899346e-23, -2.418343165657169e-24,
  1.137234389639293e-01, -5.499531518202745e-04,  2.817170234503921e-06, -1.507852797125892e-08,  8.293382721484364e-11, -4.641991680823504e-13,  2.609505072825878e-15,
 -1.477006934269100e-17,  8.271226067123253e-20, -4.697012133188711e-22,  2.568718058646349e-24, -1.497802137373478e-26,  9.473463763549189e-02, -6.146467759978833e-04,
  5.029900183221947e-06, -4.189109693325308e-08,  3.382277523156791e-10, -2.643309131725968e-12,  2.009217752524294e-14, -1.492951440371373e-16,  1.087511613649480e-18,
 -7.791526956355432e-21,  5.494203653567057e-23, -3.825948539197677e-25,  6.573909025671093e-02, -6.459288248680423e-04,  7.783036723333240e-06, -8.602173518063186e-08,
  8.865071195655332e-10, -8.681315767216106e-12,  8.165192234886946e-14, -7.424885993595045e-16,  6.559206347321033e-18, -5.649003943327212e-20,  4.756974288392149e-22,
 -3.924835471207070e-24,  3.800192004712754e-02, -5.668330549047857e-04,  9.074902154810388e-06, -1.260165110634234e-07,  1.602798287740115e-09, -1.909939109550353e-11,
  2.159733684743226e-13, -2.337552379874700e-15,  2.437107113062847e-17, -2.459211738444818e-19,  2.410841354082650e-21, -2.302621712946535e-23,  1.830264197696105e-02,
 -4.001433234102965e-04,  8.120518427375451e-06, -1.388823555858272e-07,  2.139345389950209e-09, -3.044016760795019e-11,  4.064278009152603e-13, -5.147112274470703e-15,
  6.231239988116362e-17, -7.253446709197349e-19,  8.155436449494664e-21, -8.887815167577216e-23,  7.347079494519878e-03, -2.263554483789281e-04,  5.704719858164344e-06,
 -1.186337261746921e-07,  2.183257902572451e-09, -3.662041049931640e-11,  5.704505336214784e-13, -8.357980687244792e-15,  1.162324079363173e-16, -1.544721803165489e-18,
  1.972242270737237e-20, -2.428924806690709e-22,  2.460206005044839e-03, -1.031841519432178e-04,  3.195496237165481e-06, -7.999834449678739e-08,  1.741820683574800e-09,
 -3.413517355957256e-11,  6.152308057569601e-13, -1.034652408784370e-14,  1.640441948432945e-16, -2.471092562248705e-18,  3.557700391109963e-20, -4.917933299351258e-22,
  6.883004628217800e-04, -3.819612565657424e-05,  1.443325309312737e-06, -4.316081273429328e-08,  1.104090258157817e-09, -2.512037945322604e-11,  5.207434422575890e-13,
 -9.995542993030169e-15,  1.797099984014191e-16, -3.052453564033643e-18,  4.930766361338178e-20, -7.613043874681396e-22,  1.613458080022595e-04, -1.157642445442436e-05,
  5.306947852943828e-07, -1.884347238280630e-08,  5.634741461777205e-10, -1.481611107008475e-11,  3.517581849228443e-13, -7.675365954301213e-15,  1.558767301745115e-16,
 -2.974249685529634e-18,  5.370821449919854e-20, -9.229083969464930e-22,  3.183858362389367e-05, -2.898649089806596e-06,  1.603811983273354e-07, -6.730954312081530e-09,
  2.344122089587962e-10, -7.099853500426799e-12,  1.924642453129029e-13, -4.760189238258291e-15,  1.088967626317241e-16, -2.327838260822753e-18,  4.686586558957280e-20,
 -8.939238149060493e-22,  5.329131704658973e-06, -6.061689253902056e-07,  4.028528186548858e-08, -1.991198903989534e-09,  8.053826342413665e-11, -2.803104051067580e-12,
  8.657259366496885e-14, -2.421997838898078e-15,  6.228728847712586e-17, -1.488734836024330e-18,  3.335054854976429e-20, -7.047031790306361e-22,  7.656409419323548e-07,
 -1.073819822723121e-07,  8.532034381296451e-09, -4.951570521477814e-10,  2.320834040644348e-11, -9.264944407630092e-13,  3.254626014539658e-14, -1.028320917414067e-15,
  2.968369575907808e-17, -7.920332505917886e-19,  1.971187058792716e-20, -4.606656759916657e-22,  9.615784611223479e-08, -1.643357053210867e-08,  1.553603859806378e-09,
 -1.055530103108112e-10,  5.720953776222109e-12, -2.615082001127855e-13,  1.043278007769352e-14, -3.717371827252730e-16,  1.202735928350113e-17, -3.577466499196612e-19,
  9.876710131913250e-21, -2.548868722632603e-22,  1.085129818737760e-08, -2.234116859222469e-09,  2.499530528212186e-10, -1.981236096541729e-11,  1.238595878255591e-12,
 -6.469283638199185e-14,  2.925589756652753e-15, -1.173503978544479e-16,  4.248155475136786e-18, -1.406090743854035e-19,  4.298433640784795e-21, -1.222633988618253e-22,
  1.145878987052477e-09, -2.807593255661736e-10,  3.692231784660945e-11, -3.398264440013481e-12,  2.441292232929326e-13, -1.452300836747258e-14,  7.422979376797198e-16,
 -3.342475305561103e-17,  1.350129415656971e-18, -4.959184164208753e-20,  1.674065565971611e-21, -5.233473770202899e-23,  1.199872713545675e-10, -3.448608927372639e-11,
  5.281337769908488e-12, -5.603561383202148e-13,  4.597738268646454e-14, -3.098292767283398e-15,  1.780784188058234e-16, -8.958364054212824e-18,  4.018843617336512e-19,
 -1.630688248317052e-20,  6.051096715128775e-22, -2.069775019373945e-23,  1.347344261757699e-11, -4.460510907901920e-12,  7.847505682483918e-13, -9.489786549103400e-14,
  8.803815458996808e-15, -6.658508029775732e-16,  4.266542072299121e-17, -2.378209749879532e-18,  1.175592902465855e-19, -5.229254352956908e-21,  2.117235442525153e-22,
 -7.866158492923830e-24,  1.782322355800165e-12, -6.637663434597228e-13,  1.315172680780222e-13, -1.780925424318480e-14,  1.838193292312048e-15, -1.537152854448877e-16,
  1.082698326117804e-17, -6.598358890357657e-19,  3.548462250724434e-20, -1.709334861355036e-21,  7.463013765984663e-23, -2.977717974858329e-24,  3.002056773738895e-13,
 -1.220338962673567e-13,  2.647952641087053e-14, -3.912566715644843e-15,  4.385921779329096e-16, -3.964499895791993e-17,  3.004849744451372e-18, -1.962276317002311e-19,
  1.126325149754202e-20, -5.769791415066597e-22,  2.669792170750894e-23, -1.125231869752439e-24,  5.791807941085554e-14, -2.478050085626680e-14,  5.676906752648811e-15,
 -8.839820747876984e-16,  1.041493067598343e-16, -9.866872260001334e-18,  7.816764732998656e-19, -5.321791190872084e-20,  3.176907694505888e-21, -1.688740827068365e-22,
  8.091465664894525e-24, -3.524095537687912e-25,  1.115675860556317e-01, -5.281176854377823e-04,  2.643893825691192e-06, -1.382259123160848e-08,  7.424410846147043e-11,
 -4.062496480647958e-13,  2.230590410139659e-15, -1.237522431468556e-17,  6.750256024319492e-20, -3.791742159693015e-22,  1.979113201570309e-24, -1.202749898342414e-26,
  9.235346999947942e-02, -5.763302036252618e-04,  4.558013449468797e-06, -3.687753587490953e-08,  2.898643672120896e-10, -2.207572386667834e-12,  1.635979459595693e-14,
 -1.185893764365220e-16,  8.428325716535693e-19, -5.896524259815531e-21,  4.058035522442352e-23, -2.763460338475261e-25,  6.327368974488538e-02, -5.875649817181457e-04,
  6.830477477531199e-06, -7.312682229818370e-08,  7.309083585804646e-10, -6.949183392811290e-12,  6.351939210688174e-14, -5.617725942207244e-16,  4.830215154368934e-18,
 -4.051000485227582e-20,  3.323952242742011e-22, -2.673131312149418e-24,  3.587078838392495e-02, -4.998739747989107e-04,  7.704822127203186e-06, -1.031667783739240e-07,
  1.267765513297697e-09, -1.462088289107637e-11,  1.602312630681741e-13, -1.682531045125267e-15,  1.703470109032598e-17, -1.670464155963636e-19,  1.592584077452702e-21,
 -1.480092903353183e-23,  1.682220648485584e-02, -3.413066807305189e-04,  6.640808797697413e-06, -1.090385093312818e-07,  1.617480794481484e-09, -2.221206108771185e-11,
  2.867072336674536e-13, -3.514875563265575e-15,  4.123842143562417e-17, -4.656561888352569e-19,  5.083120795756385e-21, -5.382213060045685e-23,  6.524687679518312e-03,
 -1.858694588415106e-04,  4.468747474439277e-06, -8.888961270766357e-08,  1.570774304638351e-09, -2.536399877523796e-11,  3.811146185680378e-13, -5.394736299349432e-15,
  7.257796458110497e-17, -9.341764107098151e-19,  1.156305832136613e-20, -1.381802277273648e-22,  2.093123932248473e-03, -8.103344964219961e-05,  2.382554848647833e-06,
 -5.687737116367767e-08,  1.186056197633813e-09, -2.232621579605363e-11,  3.873840752634350e-13, -6.283173547441599e-15,  9.622500038171318e-17, -1.401926833446479e-18,
  1.954391149192147e-20, -2.618639145352768e-22,  5.557076057998098e-04, -2.845512996939822e-05,  1.016773940486939e-06, -2.892022473671979e-08,  7.069635580986778e-10,
 -1.542059805963744e-11,  3.072349218667572e-13, -5.679463762486314e-15,  9.850706717956058e-17, -1.616494686433116e-18,  2.525962888768050e-20, -3.777107362461694e-22,
  1.222891614118972e-04, -8.101953850877988e-06,  3.501960895559830e-07, -1.180383555545292e-08,  3.367076257813059e-10, -8.475053059152451e-12,  1.931360688092563e-13,
 -4.054078110085446e-15,  7.935212789701370e-17, -1.461629964882202e-18,  2.551506626295511e-20, -4.243885818144884e-22,  2.237613036563402e-05, -1.884285716835662e-06,
  9.813168263226973e-08, -3.904473005921306e-09,  1.295585573328162e-10, -3.752542068437101e-12,  9.755955676635859e-14, -2.319616376107785e-15,  5.111509580701965e-17,
 -1.054343015692272e-18,  2.051366535694911e-20, -3.786556052471297e-22,  3.423800290022768e-06, -3.611850573767024e-07,  2.258373408733554e-08, -1.057752352920376e-09,
  4.074365051350420e-11, -1.355546468043229e-12,  4.013954921317239e-14, -1.079340775145731e-15,  2.673577296082046e-17, -6.166161430290161e-19,  1.335080899026961e-20,
 -2.730591719825101e-22,  4.423451378415834e-07, -5.775490411903215e-08,  4.321397927436502e-09, -2.377717437044404e-10,  1.061730838610528e-11, -4.053131527169011e-13,
  1.365656209340952e-14, -4.149172542681823e-16,  1.154214636239833e-17, -2.973526859696779e-19,  7.157261234406492e-21, -1.620178757823112e-22,  4.902514215482707e-08,
 -7.839140579219718e-09,  6.995801825890021e-10, -4.514058234943329e-11,  2.334248483865986e-12, -1.021686041814166e-13,  3.914531573068483e-15, -1.342947597990126e-16,
  4.192606759028556e-18, -1.205627266132231e-19,  3.223408030235404e-21, -8.068583364303367e-23,  4.779903670284371e-09, -9.267365972409528e-10,  9.827252229866895e-11,
 -7.421543883055349e-12,  4.438799977174636e-13, -2.225541863147621e-14,  9.688743043477952e-16, -3.750327060164770e-17,  1.312917609853401e-18, -4.210356615308145e-20,
  1.249150109277346e-21, -3.453620620801723e-23,  4.263201295880587e-10, -9.916520950370760e-11,  1.243344769310247e-11, -1.095629807166301e-12,  7.562640178559349e-14,
 -4.335723040526952e-15,  2.141180865147813e-16, -9.336575601641508e-18,  3.659302147018104e-19, -1.306479444278377e-20,  4.293619741420416e-22, -1.308702365850977e-23,
  3.689079639174998e-11, -1.016451183126138e-11,  1.495727032914899e-12, -1.529683075501193e-13,  1.213248564525276e-14, -7.922881516952494e-16,  4.422635303402446e-17,
 -2.164966131886165e-18,  9.467339648947291e-20, -3.750401203428064e-21,  1.360604459724144e-22, -4.556000890230887e-24,  3.369337183911047e-12, -1.081229468198174e-12,
  1.845353421100451e-13, -2.169329474783446e-14,  1.960472498956999e-15, -1.447132958081406e-16,  9.065398894228339e-18, -4.947694705534055e-19,  2.397996210137354e-20,
 -1.047153619264092e-21,  4.166871890903056e-23, -1.523128809653058e-24,  3.621546014218155e-13, -1.322409760001918e-13,  2.568805835580182e-14, -3.414255009833121e-15,
  3.463367488554695e-16, -2.849770703702621e-17,  1.977296183984536e-18, -1.188268540298356e-19,  6.307198964872589e-21, -3.001295283016143e-22,  1.295438572089929e-23,
 -5.113581680228670e-25,  5.086755876816217e-14, -2.048103217443623e-14,  4.400285403576439e-15, -6.440758800657163e-16,  7.156444123693044e-17, -6.415644438020303e-18,
  4.825356040955488e-19, -3.128547324336704e-20,  1.783715866225814e-21, -9.080044176766412e-23,  4.176789372187791e-24, -1.750684430163943e-25,  8.708195000898262e-15,
 -3.715122611313565e-15,  8.484702214960392e-16, -1.317254772353181e-16,  1.547556753963124e-17, -1.462174919370066e-18,  1.155421112698117e-19, -7.847381829052729e-21,
  4.673922907022819e-22, -2.479147154057393e-23,  1.185434276556053e-24, -5.152955386480775e-26,  1.094963948168836e-01, -5.076104239833839e-04,  2.484891150895396e-06,
 -1.269689032707303e-08,  6.662760006388201e-11, -3.566415558615317e-13,  1.912376305814423e-15, -1.041926586910032e-17,  5.515527105702631e-20, -3.100011819717864e-22,
  1.491898146775941e-24, -1.033351974559505e-26,  9.011838175939814e-02, -5.415605969441904e-04,  4.141919146198302e-06, -3.257266095521515e-08,  2.493852669759468e-10,
 -1.851921167110852e-12,  1.338707214203289e-14, -9.472416192533527e-17,  6.570669895784577e-19, -4.492521280504643e-21,  3.016491480157353e-23, -2.013549213547161e-25,
  6.102742720876143e-02, -5.362424922498383e-04,  6.018790764945281e-06, -6.246637885664921e-08,  6.059801101016300e-10, -5.597268681131399e-12,  4.975150090629636e-14,
 -4.281867611654609e-16,  3.585340990143084e-18, -2.929620281559484e-20,  2.343632714561596e-22, -1.837701883811398e-24,  3.398718810342401e-02, -4.428635124432659e-04,
  6.579512064869712e-06, -8.502790642565669e-08,  1.010283648116045e-09, -1.128421216368515e-11,  1.199286842868586e-13, -1.222513264495106e-15,  1.202652297604670e-17,
 -1.146705680948788e-19,  1.063781170735784e-21, -9.624122558781014e-24,  1.555552524503189e-02, -2.930055932503731e-04,  5.474090555607508e-06, -8.636984441963745e-08,
  1.234787268161775e-09, -1.637716076587569e-11,  2.045004782246777e-13, -2.428425042247462e-15,  2.762825746754324e-17, -3.027924438052340e-19,  3.210715464127420e-21,
 -3.304617410645130e-23,  5.846510318729602e-03, -1.539944914132294e-04,  3.537606273152403e-06, -6.736549523646705e-08,  1.143961790267536e-09, -1.779559171452847e-11,
  2.580948180903379e-13, -3.531725939187114e-15,  4.599121577752136e-17, -5.736228344531452e-19,  6.886807348475374e-21, -7.989292488957999e-23,  1.803202834970145e-03,
 -6.441144478080006e-05,  1.800639224983962e-06, -4.102162185066505e-08,  8.198721744524609e-10, -1.483394367421414e-11,  2.479347397755642e-13, -3.880572862563244e-15,
  5.743393512338091e-17, -8.096904291179576e-19,  1.093452353794043e-20, -1.420656649510056e-22,  4.562010829293590e-04, -2.153789616578558e-05,  7.285862277393805e-07,
 -1.972375521659637e-08,  4.610427003324628e-10, -9.646585288651942e-12,  1.848149465368952e-13, -3.291768641611082e-15,  5.510189066687912e-17, -8.739158775796443e-19,
  1.321480910683641e-20, -1.914338554695638e-22,  9.470155382360751e-05, -5.786803214106995e-06,  2.360020074426066e-07, -7.554665131208674e-09,  2.056641997320038e-10,
 -4.957407025530152e-12,  1.084791085481432e-13, -2.191246213389603e-15,  4.134934409181343e-17, -7.354315036110276e-19,  1.241354907034726e-20, -1.998929849110499e-22,
  1.615550676893242e-05, -1.256381906956357e-06,  6.159783002251179e-08, -2.323881893250870e-09,  7.348582494946964e-11, -2.035795507670426e-12,  5.076847582111037e-14,
 -1.160577456414361e-15,  2.463767815410816e-17, -4.904184781185314e-19,  9.221774077023594e-21, -1.647369753194914e-22,  2.273313296507824e-06, -2.219701562361814e-07,
  1.305258821561403e-08, -5.791660279869665e-10,  2.124262744061343e-11, -6.755142811523689e-13,  1.917640936803238e-14, -4.955669635392001e-16,  1.182216714029706e-17,
 -2.630693411706773e-19,  5.504411352047206e-21, -1.089532729972093e-22,  2.657870418273406e-07, -3.222618255874655e-08,  2.268350098799361e-09, -1.182455778360923e-10,
  5.027535515879409e-12, -1.834451835723840e-13,  5.926051256924198e-15, -1.730629805292739e-16,  4.637634517335033e-18, -1.153122996626716e-19,  2.683341569624293e-21,
 -5.881444155243897e-23,  2.615795745979330e-08, -3.901858403088643e-09,  3.281513455995368e-10, -2.008458040973217e-11,  9.898782906813177e-13, -4.144950265416540e-14,
  1.523978920729733e-15, -5.030087430704079e-17,  1.514197408816474e-18, -4.206672655302958e-20,  1.088477724333220e-21, -2.641000082116316e-23,  2.215659262508820e-09,
 -4.031541098223358e-10,  4.042723144701810e-11, -2.903590641719179e-12,  1.658902337061240e-13, -7.973500431153315e-15,  3.337520354465562e-16, -1.245274239797485e-17,
  4.211388960056413e-19, -1.307191364939501e-20,  3.760258723040220e-22, -1.009605952637418e-23,  1.675213205284031e-10, -3.685466512675817e-11,  4.393169858012230e-12,
 -3.697813644182713e-13,  2.447538066272797e-14, -1.349872044928364e-15,  6.430573843192991e-17, -2.711308816734708e-18,  1.029647374116318e-19, -3.568574631297092e-21,
  1.140350782715748e-22, -3.384905448191760e-24,  1.198151533122346e-11, -3.152643185355733e-12,  4.443735593328357e-13, -4.368836025934775e-14,  3.341657836744436e-15,
 -2.110259584238450e-16,  1.141856380587988e-17, -5.429628629544874e-19,  2.310701907262111e-20, -8.923067050892741e-22,  3.160395763301588e-23, -1.034606745048142e-24,
  8.854028177411789e-13, -2.744509251844051e-13,  4.530185210277293e-14, -5.163181378567188e-15,  4.534547449163227e-16, -3.259762705017030e-17,  1.992466138846681e-18,
 -1.062838019102910e-19,  5.042325032371920e-21, -2.158262581515297e-22,  8.428562973028227e-24, -3.027152344614378e-25,  7.641946107575905e-14, -2.728821375074653e-14,
  5.184116566990455e-15, -6.748117632846191e-16,  6.713945276012500e-17, -5.426141185320670e-18,  3.702634788784777e-19, -2.190865252277269e-20,  1.146188885946914e-21,
 -5.380983831455001e-23,  2.293405100408690e-24, -8.946568512826017e-26,  8.804820921846817e-15, -3.506404913865582e-15,  7.448735920790548e-16, -1.078659174783039e-16,
  1.186577814116151e-17, -1.053879633054736e-18,  7.858000623007386e-20, -5.053765461618386e-21,  2.859720066140160e-22, -1.445529365849608e-23,  6.605716345743958e-25,
 -2.751762720278304e-26,  1.318530058562875e-15, -5.606792992054448e-16,  1.276043620941289e-16, -1.974406575355347e-17,  2.312204460974156e-18, -2.178059366824922e-19,
  1.716233772040865e-20, -1.162511225264517e-21,  6.906462650077202e-23, -3.654591826128235e-24,  1.743543017630136e-25, -7.562835592675174e-27,  1.075047713058136e-01,
 -4.883231491765456e-04,  2.338697148358736e-06, -1.168551336770617e-08,  5.993109677774127e-11, -3.140558782503735e-13,  1.643745728918155e-15, -8.822216222417772e-18,
  4.496175260588318e-20, -2.592279738524796e-22,  1.048697259699302e-24, -1.007294408667077e-26,  8.801602674602760e-02, -5.099236045225756e-04,  3.773820114306959e-06,
 -2.886220819147931e-08,  2.153565806664742e-10, -1.560224322949934e-12,  1.100641316125963e-14, -7.606912416137265e-17,  5.150767716837273e-19, -3.446149771457558e-21,
  2.253957139057074e-23, -1.482707340451667e-25,  5.897423243399504e-02, -4.909338314111227e-04,  5.323873659733355e-06, -5.360523909158048e-08,  5.050670602188246e-10,
 -4.535052347179136e-12,  3.922199215659946e-14, -3.286681261961881e-16,  2.681618049703976e-18, -2.135700161869149e-20,  1.666885182522826e-22, -1.274467732717583e-24,
  3.231491067418039e-02, -3.940501490116633e-04,  5.649193399065794e-06, -7.052335704765410e-08,  8.108192011113600e-10, -8.776740337735000e-12,  9.051968221831170e-14,
 -8.962639306310311e-16,  8.572270710621927e-18, -7.951034359936451e-20,  7.181655047216198e-22, -6.326854418645794e-24,  1.446496760190001e-02, -2.530460278571410e-04,
  4.546187777898194e-06, -6.898836726535365e-08,  9.512930902030185e-10, -1.219444782028343e-11,  1.474048451555799e-13, -1.696529539451500e-15,  1.872755313678224e-17,
 -1.993086150036306e-19,  2.054041105951823e-21, -2.055922606927432e-23,  5.282420459161036e-03, -1.286410456795823e-04,  2.828300601465796e-06, -5.160370261354613e-08,
  8.427676836392312e-10, -1.263900918390117e-11,  1.770487688755031e-13, -2.343432706848928e-15,  2.955548099176403e-17, -3.573885632938605e-19,  4.163853983796823e-21,
 -4.691346449349908e-23,  1.571537182961282e-03, -5.177298003966182e-05,  1.378251720988393e-06, -2.998731530328192e-08,  5.748656230210058e-10, -1.000389397503428e-11,
  1.611648287009325e-13, -2.435524360351586e-15,  3.485409644257889e-17, -4.756896864275491e-19,  6.225760190127171e-21, -7.846645665534203e-23,  3.803673797294446e-04,
 -1.654378225243781e-05,  5.304974344554462e-07, -1.367761935235676e-08,  3.059193167237478e-10, -6.143604923805601e-12,  1.132433652249246e-13, -1.944332396481380e-15,
  3.142509786849424e-17, -4.818930683610754e-19,  7.054082835583402e-21, -9.903061051862769e-23,  7.482630219398043e-05, -4.212180278040374e-06,  1.622249713945596e-07,
 -4.934219681603101e-09,  1.282614582620341e-10, -2.962067547328238e-12,  6.226362181503172e-14, -1.210750654211655e-15,  2.203360309629920e-17, -3.785130803562058e-19,
  6.179341899236154e-21, -9.635586173734821e-23,  1.196355011745782e-05, -8.578707520395667e-07,  3.960996672154515e-08, -1.417266198183520e-09,  4.272161671414467e-11,
 -1.132296088864627e-12,  2.709161321011284e-14, -5.955727987116142e-16,  1.218223039972302e-17, -2.340397323191472e-19,  4.253764402789885e-21, -7.354683612323819e-23,
  1.557240304544969e-06, -1.404563914717484e-07,  7.765792987954976e-09, -3.264077311430221e-10,  1.139940136306779e-11, -3.464773177056797e-13,  9.429234234651613e-15,
 -2.341800835436488e-16,  5.380075040007272e-18, -1.155016614471740e-19,  2.335312866049114e-21, -4.473165000708381e-23,  1.658067497761545e-07, -1.862341617261261e-08,
  1.232134761710365e-09, -6.081725399155825e-11,  2.461110982309354e-12, -8.580320545700084e-14,  2.656630586297808e-15, -7.455127944858183e-17,  1.923904052381345e-18,
 -4.615565430877853e-20,  1.038048429031348e-21, -2.202327023340473e-23,  1.458534336370832e-08, -2.023584357735374e-09,  1.601401193122734e-10, -9.286898045802978e-12,
  4.358569867381859e-13, -1.744676645813050e-14,  6.151334834092436e-16, -1.952094635287863e-17,  5.662665193408226e-19, -1.518955091183410e-20,  3.801470336012591e-22,
 -8.935502470412684e-24,  1.079885692717052e-09, -1.837725711808114e-10,  1.738851961818737e-11, -1.185744012985223e-12,  6.462161925397514e-14, -2.973896992967414e-15,
  1.195518800679243e-16, -4.295220594999219e-18,  1.401889215280928e-19, -4.207818772417828e-21,  1.172553378804162e-22, -3.054703150616458e-24,  6.954055596560076e-11,
 -1.441392930469689e-11,  1.628953286253262e-12, -1.306732936813024e-13,  8.277576372587594e-15, -4.384238539778138e-16,  2.011588129076846e-17, -8.189154691498327e-19,
  3.009300861381889e-20, -1.011175835684773e-21,  3.138160016449747e-23, -9.061099875015378e-25,  4.117450913922075e-12, -1.030443253607493e-12,  1.386776539116250e-13,
 -1.307111836015782e-14,  9.618933339472899e-16, -5.861671547166912e-17,  3.068597846276061e-18, -1.414884009233775e-19,  5.850345760636045e-21, -2.198922155626881e-22,
  7.592573737886867e-24, -2.426719996672880e-25,  2.452457759132678e-13, -7.314981847647072e-14,  1.163943098225231e-14, -1.282478310560139e-15,  1.091817538216302e-16,
 -7.626407792885460e-18,  4.538954636520593e-19, -2.361958614527755e-20,  1.094961401408330e-21, -4.586528710876701e-23,  1.755221744106769e-24, -6.185288344676460e-26,
  1.680853632894025e-14, -5.851893097166534e-15,  1.084270902671079e-15, -1.378867059436428e-16,  1.342619808452701e-17, -1.063663491228021e-18,  7.125205134850875e-20,
 -4.144268481453290e-21,  2.133783710436708e-22, -9.869267809890475e-24,  4.148175426208020e-25, -1.597292562969346e-26,  1.561249776723384e-15, -6.139233079755850e-16,
  1.287409249671496e-16, -1.841683990710288e-17,  2.003045139699711e-18, -1.760370394711652e-19,  1.299787896491956e-20, -8.283686017563046e-22,  4.647871888508489e-23,
 -2.330929438060224e-24,  1.057355953187092e-25, -4.374480348599383e-27,  2.012342835195023e-16, -8.525178902437026e-17,  1.932571247603301e-17, -2.978870069287500e-18,
  3.475975840336269e-19, -3.263236901708957e-20,  2.563140615118063e-21, -1.730984114397632e-22,  1.025482363550183e-23, -5.412011599647867e-25,  2.575520403075452e-26,
 -1.114531425071648e-27,  1.055880321656857e-01, -4.701586392175920e-04,  2.204023816861527e-06, -1.077480248557963e-08,  5.402527403918933e-11, -2.774160189445149e-13,
  1.415516226072130e-15, -7.525541558346046e-18,  3.627534798316474e-20, -2.264372642800115e-22,  5.805245080228911e-25, -1.148326800953549e-26,  8.603459960541399e-02,
 -4.810621343701653e-04,  3.447162689659124e-06, -2.565247850834683e-08,  1.866302695817016e-10, -1.319875828996635e-12,  9.089751835581036e-15, -6.140966742108510e-17,
  4.057826514628600e-19, -2.663044377601097e-21,  1.688845817977914e-23, -1.107488515264121e-25,  5.709179034668579e-02, -4.507850912160373e-04,  4.726261619225615e-06,
 -4.620159215803347e-08,  4.230811307137958e-10, -3.695127280370853e-12,  3.111364236525813e-14, -2.539732199295281e-16,  2.020412157055236e-18, -1.568743763337988e-20,
  1.195765411738802e-22, -8.908991152841655e-25,  3.082403208030888e-02, -3.520337941053401e-04,  4.875319422998358e-06, -5.884449740006164e-08,  6.551260475413433e-10,
 -6.876874606104523e-12,  6.887094603363879e-14, -6.627066413638551e-16,  6.166323989795431e-18, -5.565840980151337e-20,  4.898563619361903e-22, -4.202282763906441e-24,
  1.352062171877724e-02, -2.197465778044274e-04,  3.802184437950170e-06, -5.554158584378217e-08,  7.392573466952476e-10, -9.165150382042437e-12,  1.073168841273106e-13,
 -1.197805816529821e-15,  1.283673196424772e-17, -1.327270292307560e-19,  1.330220731578955e-21, -1.295239385769388e-23,  4.809487262011847e-03, -1.082802005674756e-04,
  2.282311336021146e-06, -3.993131797481992e-08,  6.276700696090660e-10, -9.081190953224197e-12,  1.229470792470279e-13, -1.575010456054809e-15,  1.924916878917102e-17,
 -2.257786911036797e-19,  2.554009673141262e-21, -2.795896112579375e-23,  1.384420544758264e-03, -4.204394104657078e-05,  1.067610922398818e-06, -2.220103516416457e-08,
  4.085334997935384e-10, -6.842500300794625e-12,  1.063175308343421e-13, -1.552151288315255e-15,  2.148878024862841e-17, -2.840588745552282e-19,  3.604643083732211e-21,
 -4.408941916569537e-23,  3.217469774274990e-04, -1.288158158605286e-05,  3.921117504313993e-07, -9.634871092896473e-09,  2.063415970508737e-10, -3.979701330725489e-12,
  7.061642580376808e-14, -1.169353947425455e-15,  1.825661926495673e-17, -2.707987939387936e-19,  3.838865921996042e-21, -5.224627514196831e-23,  6.024209737599831e-05,
 -3.120362696534116e-06,  1.136071078146093e-07, -3.285014314144560e-09,  8.158133842314011e-11, -1.805949594886000e-12,  3.648259538480407e-14, -6.832103306262036e-16,
  1.199484781431168e-17, -1.990911576596153e-19,  3.144466704761548e-21, -4.749299068212524e-23,  9.072508587567537e-06, -5.989163305519720e-07,  2.605738642999995e-08,
 -8.845268686348526e-10,  2.542536936329650e-11, -6.449096135237776e-13,  1.480853816182443e-14, -3.131417155682601e-16,  6.172967586962452e-18, -1.144811447195568e-19,
  2.011514124751240e-21, -3.366546174262006e-23,  1.098632113806092e-06, -9.135354277546116e-08,  4.749051968095115e-09, -1.890809015539856e-10,  6.288063486068838e-12,
 -1.826873456399190e-13,  4.766582752275603e-15, -1.137731555447212e-16,  2.517293258833915e-18, -5.213908517861101e-20,  1.018662715998106e-21, -1.888101864673132e-23,
  1.072028361987800e-07, -1.112713386288989e-08,  6.915100668366375e-10, -3.230549182694817e-11,  1.243904804851046e-12, -4.142613070826652e-14,  1.229061462771894e-15,
 -3.313510122012665e-17,  8.232986357344109e-19, -1.905300358104965e-20,  4.140445264565319e-22, -8.500828072531820e-24,  8.485444080540759e-09, -1.091781800028636e-09,
  8.119167880280406e-11, -4.457108550016535e-12,  1.990471702945228e-13, -7.611676314099776e-15,  2.572027374546063e-16, -7.843391937173560e-18,  2.191335025105700e-19,
 -5.672554901352479e-21,  1.372439580143678e-22, -3.123655110289256e-24,  5.528162985838742e-10, -8.768187495128997e-11,  7.812353273296136e-12, -5.050159409037206e-13,
  2.622030434346664e-14, -1.154037047931851e-15,  4.451083606210992e-17, -1.538419395482900e-18,  4.841570329101409e-20, -1.404081659232997e-21,  3.787148677174846e-23,
 -9.565536420955024e-25,  3.049236401526333e-11, -5.931129740556242e-12,  6.337485256784027e-13, -4.834595740447986e-14,  2.925531605605984e-15, -1.485641522350447e-16,
  6.555473281731161e-18, -2.573252800770939e-19,  9.138459193739156e-21, -2.973498267585767e-22,  8.952125391965224e-24, -2.511640509975985e-25,  1.499129549660981e-12,
 -3.553146213112722e-13,  4.550701577025326e-14, -4.100977266491907e-15,  2.896620943894215e-16, -1.699778971322669e-17,  8.592615692820311e-19, -3.835023407648906e-20,
  1.538192578671408e-21, -5.618737997446890e-23,  1.888649290682846e-24, -5.885660488718534e-26,  7.181329588813203e-14, -2.052542523535885e-14,  3.137350478241234e-15,
 -3.331913491782148e-16,  2.742384431362079e-17, -1.856896779123528e-18,  1.073798053118231e-19, -5.440355131227438e-21,  2.459980527695119e-22, -1.006703796048501e-23,
  3.769392888361698e-25, -1.301412001150298e-26,  3.868843635394975e-15, -1.308762944621041e-15,  2.357828527842108e-16, -2.921412972192293e-17,  2.777190311492982e-18,
 -2.152024722446883e-19,  1.412392998079988e-20, -8.060648128864751e-22,  4.077731628496063e-23, -1.855342452296768e-24,  7.679661747278037e-26, -2.915143376279351e-27,
  2.845009849185695e-16, -1.102456708440652e-16,  2.277806917798726e-17, -3.213360694928888e-18,  3.450005307778907e-19, -2.995976893772923e-20,  2.187756440833406e-21,
 -1.380046473845480e-22,  7.669843872532577e-24, -3.812526350126673e-25,  1.715216487023877e-26, -7.041827722411402e-28,  3.099136691388477e-17, -1.307301990025519e-17,
  2.950139380716109e-18, -4.527669321571785e-19,  5.261700635916154e-20, -4.920798370277699e-21,  3.851257166504777e-22, -2.592174478935918e-23,  1.530842740399522e-24,
 -8.055177889774086e-26,  3.822710852737014e-27, -1.649915304767011e-28,  1.037418633093435e-01, -4.530293543539977e-04,  2.079735307629271e-06, -9.953008209139655e-09,
  4.880025607951279e-11, -2.458484370396884e-13,  1.219852963098336e-15, -6.491706870759688e-18,  2.841337950052057e-20, -2.140361232095170e-22,  2.123562508824407e-26,
 -1.393904366149400e-26,  8.416362519718364e-02, -4.546673203899057e-04,  3.156415194277066e-06, -2.286628060322088e-08,  1.622822399225002e-10, -1.120972271555161e-12,
  7.538536294218997e-15, -4.983716749263180e-17,  3.209768564128668e-19, -2.076477388985601e-21,  1.263352711739005e-23, -8.409197572318304e-26,  5.536091422286232e-02,
 -4.150829611091733e-04,  4.210144638001374e-06, -3.998523500016028e-08,  3.561055054650921e-10, -3.026919678861407e-12,  2.482879969327953e-14, -1.975043184039666e-16,
  1.533097744715708e-18, -1.160358131385473e-20,  8.653282613660475e-23, -6.271583167107079e-25,  2.948966831864568e-02, -3.156874794577697e-04,  4.227813406573344e-06,
 -4.937890312414626e-08,  5.327224086279284e-10, -5.426068555833294e-12,  5.280145486250993e-14, -4.939956561006713e-16,  4.474938186768062e-18, -3.931178812786596e-20,
  3.375258814986366e-22, -2.818133205351390e-24,  1.269851578597913e-02, -1.918070956703162e-04,  3.201029156869929e-06, -4.505057228957792e-08,  5.792161787670738e-10,
 -6.949663976249304e-12,  7.887809335174838e-14, -8.542306861182105e-16,  8.893355638978618e-18, -8.937049304444375e-20,  8.716656728383567e-22, -8.258289754949737e-24,
  4.410072714562908e-03, -9.178051835524433e-05,  1.857879438060353e-06, -3.119509595194083e-08,  4.723116722857415e-10, -6.596920207938493e-12,  8.637627643474085e-14,
 -1.071545257062352e-15,  1.269793461810150e-17, -1.445355351671867e-19,  1.588313797870466e-21, -1.690046178194448e-23,  1.231783492621228e-03, -3.446715019721706e-05,
  8.363134965211121e-07, -1.663415159686242e-08,  2.940442505030745e-10, -4.743239421096027e-12,  7.112534933348049e-14, -1.003695661222999e-15,  1.345017219470889e-17,
 -1.722881933484786e-19,  2.120795143722487e-21, -2.518414993778558e-23,  2.758341402752874e-04, -1.015653818013354e-05,  2.939459811161094e-07, -6.888124254888221e-09,
  1.413499015815758e-10, -2.619843929661482e-12,  4.477575095536894e-14, -7.154634356965394e-16,  1.079533610754971e-17, -1.549533058065648e-19,  2.128131180176516e-21,
 -2.808871583241310e-23,  4.935676076263487e-05, -2.349461752488656e-06,  8.096485780709175e-08, -2.226892383995556e-09,  5.286756861559001e-11, -1.122398714955506e-12,
  2.180088858069985e-14, -3.933474342950589e-16,  6.664911969240450e-18, -1.069214137742984e-19,  1.634297320822213e-21, -2.391571485134820e-23,  7.035150100496365e-06,
 -4.268669565196160e-07,  1.751353526233448e-08, -5.642195194591020e-10,  1.547203464910523e-11, -3.757159347132456e-13,  8.282414673327448e-15, -1.685168158000804e-16,
  3.202368376626639e-18, -5.734398162881397e-20,  9.742463281419905e-22, -1.578610343575694e-23,  7.969261591354334e-07, -6.096874108833693e-08,  2.980686952366071e-09,
 -1.124253310203414e-10,  3.560850321465737e-12, -9.890339619585658e-14,  2.474381432756431e-15, -5.676856361875212e-17,  1.209752214932304e-18, -2.417596936137612e-20,
  4.564350779958121e-22, -8.186660671193828e-24,  7.170932239169137e-08, -6.861303626315080e-09,  4.003606671572880e-10, -1.769750812287179e-11,  6.482674355541366e-13,
 -2.062033506917326e-14,  5.861524902051202e-16, -1.517955911127157e-17,  3.630851498971947e-19, -8.104262928980408e-21,  1.701440738885344e-22, -3.379896554483813e-24,
  5.142176922772224e-09, -6.117596736832355e-10,  4.270330636426697e-11, -2.217333980377714e-12,  9.416714420386999e-14, -3.438356797693932e-15,  1.112965659987835e-16,
 -3.259966137886340e-18,  8.768296614849307e-20, -2.189508551942679e-21,  5.119009448935851e-23, -1.127651087120699e-24,  2.968606207506965e-10, -4.373065433535051e-11,
  3.662100327521189e-12, -2.241004893002660e-13,  1.107202828701547e-14, -4.656001292723388e-16,  1.721413511452489e-17, -5.718895482653125e-19,  1.734061072752820e-20,
 -4.855177099576521e-22,  1.266636996861590e-23, -3.099563894917232e-25,  1.411677402685115e-11, -2.566406101719802e-12,  2.585892122710604e-13, -1.872066489423152e-14,
  1.080287458861011e-15, -5.251737488515725e-17,  2.225550847985241e-18, -8.412791387955836e-20,  2.883873230210597e-21, -9.076419463558210e-23,  2.647991425079056e-24,
 -7.211512847827078e-26,  5.788375267719784e-13, -1.293502991788593e-13,  1.571363957915396e-14, -1.350238909130978e-15,  9.132555645288304e-17, -5.149934729022738e-18,
  2.509210280048076e-19, -1.082171381957194e-20,  4.203674725382473e-22, -1.490081298551718e-23,  4.869079946861359e-25, -1.477501913121953e-26,  2.229158815212604e-14,
 -6.077702369326585e-15,  8.891263409659608e-16, -9.072906835515934e-17,  7.199889982040038e-18, -4.714261809454902e-19,  2.642944662440180e-20, -1.301080457464457e-21,
  5.727681919942311e-23, -2.286046734253919e-24,  8.361405370377482e-26, -2.824140657346641e-27,  9.357149136360531e-16, -3.063780834011648e-16,  5.348589526730782e-17,
 -6.437505251574551e-18,  5.958822862797968e-19, -4.505682173957938e-20,  2.891024799477759e-21, -1.615780190930800e-22,  8.016812306243791e-24, -3.582330289841828e-25,
  1.458049760518924e-26, -5.448455863414670e-28,  5.347297348395781e-17, -2.037153934295565e-17,  4.137736395849749e-18, -5.744817585493379e-19,  6.077680288796736e-20,
 -5.206639972335018e-21,  3.754693052268078e-22, -2.341191317409805e-23,  1.287266586119626e-24, -6.335322781982338e-26,  2.823918585262557e-27, -1.149423873198347e-28,
  4.822529945364518e-18, -2.024179170920710e-18,  4.544165978899193e-19, -6.939517590876450e-20,  8.027096181921116e-21, -7.474463906862466e-22,  5.826201068173016e-23,
 -3.906628575466657e-24,  2.298952881229554e-25, -1.205684538305768e-26,  5.703982043217545e-28, -2.454716464846832e-29,  1.019622834874964e-01, -4.368563062720125e-04,
  1.964826761781856e-06, -9.210009217479493e-09,  4.416182955946721e-11, -2.186575807337691e-13,  1.049650083786186e-15, -5.706825606209572e-18,  2.057195608662332e-20,
 -2.257731317443948e-22, -6.051340751856033e-25, -1.334608749777663e-26,  8.239378086903497e-02, -4.304710818204255e-04,  2.896889675188184e-06, -2.043974449666381e-08,
  1.415647299570775e-10, -9.556977935259296e-13,  6.276310661531894e-15, -4.067128287938967e-17,  2.544859195057556e-19, -1.638849185216080e-21,  9.396317799874271e-24,
 -6.360603335580814e-26,  5.376503674739457e-02, -3.832286341022562e-04,  3.762610148665138e-06, -3.474126252922001e-08,  3.011051795099389e-10, -2.492209622565438e-12,
  1.992717598885645e-14, -1.545111891961344e-16,  1.171564681023680e-18, -8.635582869164086e-21,  6.319130905394990e-23, -4.449881059663800e-25,  2.829100484661693e-02,
 -2.840980815716236e-04,  3.683037564618180e-06, -4.165909005245586e-08,  4.358314040141283e-10, -4.309854974008624e-12,  4.077885655694258e-14, -3.710598058205064e-16,
  3.275592226819467e-18, -2.799514131761043e-20,  2.349132362212188e-22, -1.908511160618444e-24,  1.197928931340847e-02, -1.682136764686311e-04,  2.711752539349340e-06,
 -3.679979218351167e-08,  4.573706530790941e-10, -5.314201584094564e-12,  5.850434045888429e-14, -6.150424972876439e-16,  6.225002696711504e-18, -6.080822961634436e-20,
  5.777211944131730e-22, -5.326943506809698e-24,  4.070474896125581e-03, -7.829572171245031e-05,  1.524865082595664e-06, -2.459041433465930e-08,  3.588916947661467e-10,
 -4.842415961944051e-12,  6.135912616739725e-14, -7.375212094616254e-16,  8.479305819692603e-18, -9.370027866000854e-20,  1.000903621314632e-21, -1.035591572854815e-23,
  1.106135824954041e-03, -2.850175273889615e-05,  6.620776698049584e-07, -1.260436265401703e-08,  2.142021726484693e-10, -3.330032078395675e-12,  4.822040378442094e-14,
 -6.581008841431726e-16,  8.540950863300117e-18, -1.060619118170598e-19,  1.267086978034200e-21, -1.461401842045288e-23,  2.394370937651540e-04, -8.100787121050989e-06,
  2.233010631310425e-07, -4.993482872811571e-09,  9.825836418805981e-11, -1.751207400172111e-12,  2.884496177879020e-14, -4.449822306575018e-16,  6.492010349272474e-18,
 -9.021307511129095e-20,  1.200855637088175e-21, -1.537688069413660e-23,  4.110337143187974e-05, -1.795792070617178e-06,  5.865946043891258e-08, -1.535519288506686e-09,
  3.487064950953089e-11, -7.103935399474091e-13,  1.327367379461811e-14, -2.308454226371105e-16,  3.776560471194080e-18, -5.857870842233482e-20,  8.668132754302997e-22,
 -1.229364145256965e-23,  5.570286076507568e-06, -3.101409336516737e-07,  1.201129836732560e-08, -3.673992245697745e-10,  9.615931823499668e-12, -2.236486454119822e-13,
  4.734922348185525e-15, -9.272631154027393e-17,  1.699170780007287e-18, -2.938633549970643e-20,  4.828591037080539e-22, -7.576352734391211e-24,  5.933905026104093e-07,
 -4.168287608627801e-08,  1.917292731433180e-09, -6.852059814899250e-11,  2.067486456427906e-12, -5.491171403541382e-14,  1.317546412449011e-15, -2.905972904838529e-17,
  5.965381500369406e-19, -1.150363124375119e-20,  2.098931682932013e-22, -3.643239086909803e-24,  4.953796173905695e-08, -4.358579200014911e-09,  2.387460404335751e-10,
 -9.984070939949253e-12,  3.479018789029175e-13, -1.056903089598302e-14,  2.878384457267884e-16, -7.159945897165637e-18,  1.648586049719124e-19, -3.548793516518190e-21,
  7.197164352128549e-23, -1.383152676660811e-24,  3.240167571654667e-09, -3.553689628412657e-10,  2.326329149072547e-11, -1.141807501367924e-12,  4.609179768395670e-14,
 -1.606310893408813e-15,  4.978960023210824e-17, -1.400305269439672e-18,  3.624721580441928e-20, -8.728110705399829e-22,  1.971222888836797e-23, -4.201383414965158e-25,
  1.669740387842867e-10, -2.276403189315085e-11,  1.788674432152450e-12, -1.034901918248081e-13,  4.860788529016902e-15, -1.951304312719637e-16,  6.910137328887250e-18,
 -2.205045558089804e-19,  6.437418657827189e-21, -1.738997367864298e-22,  4.385234163874710e-24, -1.039004950347440e-25,  6.895066697387613e-12, -1.166747219884983e-12,
  1.105794834538031e-13, -7.582553403177859e-15,  4.165908924270875e-16, -1.936052501171348e-17,  7.869438890660102e-19, -2.861278403039374e-20,  9.457205578332763e-22,
 -2.876012733305260e-23,  8.122735874265343e-25, -2.145225554450264e-26,  2.371495206570814e-13, -4.973321192524905e-14,  5.711702470333873e-15, -4.667344284436280e-16,
  3.016093476202297e-17, -1.631149683011547e-18,  7.646211317950282e-20, -3.181269803814750e-21,  1.194961376881211e-22, -4.104492417240671e-24,  1.302051543879649e-25,
 -3.842239887144939e-27,  7.353213804016650e-15, -1.903136332345408e-15,  2.654456398411406e-16, -2.594230838425311e-17,  1.979315369471910e-18, -1.250113012533300e-19,
  6.779325056535960e-21, -3.236099951904347e-22,  1.384347132239877e-23, -5.379287870928870e-25,  1.918810447062335e-26, -6.330481724953991e-28,  2.388092710730083e-16,
 -7.535385705663369e-17,  1.269945416657203e-17, -1.479938275277822e-18,  1.330048301703210e-19, -9.788387610163205e-21,  6.126054038141492e-22, -3.345916337662388e-23,
  1.625068435499568e-24, -7.119154179228059e-26,  2.844576913488879e-27, -1.044838898554997e-28,  1.040913108864529e-17, -3.887765869747527e-18,  7.742660231512448e-19,
 -1.055511050996413e-19,  1.098053480814826e-20, -9.262677413607336e-22,  6.585420043322686e-23, -4.052822655451612e-24,  2.201572529583017e-25, -1.071434647127402e-26,
  4.726417617265621e-28, -1.905329122135995e-29,  7.594284268239843e-19, -3.169127232162011e-19,  7.071727696565103e-20, -1.073780147003174e-20,  1.235451011619009e-21,
 -1.144699325253838e-22,  8.881643356135908e-24, -5.929878789376871e-25,  3.475653459151589e-26, -1.816009631387169e-27,  8.561416161445497e-29, -3.672409552009861e-30,
  1.002456120607282e-01, -4.215680843340754e-04,  1.858406161090656e-06, -8.537089502415651e-09,  4.002800277099094e-11, -1.953167870478538e-13,  8.978140410797819e-16,
 -5.184242497182941e-18,  1.189084528517864e-20, -2.587875241514829e-22, -9.311655172927332e-25,  2.779426758807181e-27,  8.071674586632670e-02, -4.082399678933512e-04,
  2.664597686335516e-06, -1.831980746370861e-08,  1.238693797022639e-10, -8.178637180017255e-13,  5.243142148891852e-15, -3.340429809649377e-17,  2.016312916655713e-19,
 -1.313088835876410e-21,  7.045109969580208e-24, -4.236357606390402e-26,  5.228979447152542e-02, -3.547170592466440e-04,  3.373056566222693e-06, -3.029774640311880e-08,
  2.557138137555232e-10, -2.061907495223646e-12,  1.608225637866859e-14, -1.215432033065340e-16,  9.018344104718577e-19, -6.459460528086580e-21,  4.651144337298122e-23,
 -3.217238647313882e-25,  2.721053416762214e-02, -2.565210934482542e-04,  3.222286880556898e-06, -3.532551946762975e-08,  3.586371527441142e-10, -3.444864204238934e-12,
  3.171717545933160e-14, -2.807047624089200e-16,  2.418472057444815e-18, -2.008366799591293e-20,  1.649961081090406e-22, -1.311777695793334e-24,  1.134719143540014e-02,
 -1.481692508086824e-04,  2.310787287995374e-06, -3.026131898258148e-08,  3.638410423418510e-10, -4.096115999239429e-12,  4.377218625348669e-14, -4.468288621704193e-16,
  4.401012268052328e-18, -4.178123444622027e-20,  3.870346339255408e-22, -3.480103978258950e-24,  3.779949704152530e-03, -6.718639578515230e-05,  1.261278961264592e-06,
 -1.954942841275759e-08,  2.752430420739388e-10, -3.589804028302257e-12,  4.405048448766342e-14, -5.132382152349598e-16,  5.729051186875872e-18, -6.147665147906446e-20,
  6.387387849980577e-22, -6.431726672169710e-24,  1.001840184599831e-03, -2.375655991728555e-05,  5.293787152908805e-07, -9.652805077723180e-09,  1.578276774692861e-10,
 -2.366187301560082e-12,  3.310899813694511e-14, -4.372323143786560e-16,  5.498858148467134e-18, -6.622551617929636e-20,  7.682342851214720e-22, -8.610418744532200e-24,
  2.102617634706090e-04, -6.529776420122290e-06,  1.717674799143116e-07, -3.667777704305040e-09,  6.925748542490627e-11, -1.187666675348634e-12,  1.886479791107643e-14,
 -2.811085174080261e-16,  3.967549515658959e-18, -5.339767336440323e-20,  6.892146935473820e-22, -8.565576005044317e-24,  3.475415119841976e-05, -1.391713832781951e-06,
  4.316255619564284e-08, -1.075917749794266e-09,  2.338800456421248e-11, -4.574665085291440e-13,  8.227085152621488e-15, -1.379764507467070e-16,  2.180356645579476e-18,
 -3.271223479367004e-20,  4.687830672676807e-22, -6.445761439056396e-24,  4.497270775726478e-06, -2.293739811910088e-07,  8.395858537977280e-09, -2.439373003798748e-10,
  6.097081134888393e-12, -1.358811158788437e-13,  2.763999778747849e-15, -5.211863734731226e-17,  9.212549494959717e-19, -1.539249422640386e-20,  2.446775745372171e-22,
 -3.718525527102130e-24,  4.528245439147488e-07, -2.914470148408281e-08,  1.262175705948942e-09, -4.275083640739044e-11,  1.229268605460888e-12, -3.122922908725802e-14,
  7.188246481913160e-16, -1.524517686719038e-17,  3.015251998126020e-19, -5.611798506068805e-21,  9.896783148629987e-23, -1.662622000138896e-24,  3.527991169089349e-08,
 -2.847142892860501e-09,  1.464126667247063e-10, -5.792119880112270e-12,  1.920075559580604e-13, -5.571300238526289e-15,  1.453746452645409e-16, -3.473551572624526e-18,
  7.698948344959694e-20, -1.598300780621642e-21,  3.131132811347266e-23, -5.821138364388745e-25,  2.119067930020269e-09, -2.136099497313049e-10,  1.310509633207906e-11,
 -6.077203600824149e-13,  2.331064973387219e-14, -7.751644663476590e-16,  2.300225871269747e-17, -6.210112522946574e-19,  1.546652318042884e-20, -3.590387408863134e-22,
  7.831017455618984e-24, -1.614444110694218e-25,  9.820974689192598e-11, -1.234703306882591e-11,  9.089619208351489e-13, -4.967177583701147e-14,  2.216051409389557e-15,
 -8.486313480471403e-17,  2.876655173869609e-18, -8.811656889124730e-20,  2.475367442740468e-21, -6.448019248756064e-23,  1.570813199585908e-24, -3.601519923145589e-26,
  3.549251635556367e-12, -5.566613827338235e-13,  4.950860941154374e-14, -3.209842006158509e-15,  1.676572705175555e-16, -7.439127203220407e-18,  2.896956630966691e-19,
 -1.012068951962371e-20,  3.222140730935614e-22, -9.459055619326581e-24,  2.583871850468169e-25, -6.611768468347558e-27,  1.031092842978935e-13, -2.019456662186650e-14,
  2.185509472438667e-15, -1.693996776487444e-16,  1.043611612495199e-17, -5.402551298354585e-19,  2.432317792596802e-20, -9.747247123878378e-22,  3.535210930742847e-23,
 -1.175016325423764e-24,  3.613889812421843e-26, -1.035772479551727e-27,  2.582994676412938e-15, -6.313104251428823e-16,  8.361855122143164e-17, -7.801140804291459e-18,
  5.706385278860295e-19, -3.467789722642665e-20,  1.814976803483907e-21, -8.383578201805586e-23,  3.478356533373206e-24, -1.313588581877813e-25,  4.562071157045114e-27,
 -1.467881512641416e-28,  6.458762857040105e-17, -1.954418540199426e-17,  3.166711762631919e-18, -3.560528044224302e-19,  3.097256543550442e-20, -2.212441641445289e-21,
  1.347247986787584e-22, -7.174852255534805e-24,  3.404225734254905e-25, -1.459325110271739e-26,  5.714406977546659e-28, -2.059857363262043e-29,  2.108338427157574e-18,
 -7.694468747433334e-19,  1.497954833483329e-19, -1.999683257719437e-20,  2.040726726889409e-21, -1.691484318788930e-22,  1.183361982077701e-23, -7.175599031651258e-25,
  3.845059744120864e-26, -1.847803285035192e-27,  8.056508143312151e-29, -3.212811093078867e-30,  1.212551337575632e-19, -5.025606151900302e-20,  1.113573224424857e-20,
 -1.679680024734311e-21,  1.920707059581035e-22, -1.769503271181725e-23,  1.365721433571668e-24, -9.073841989776800e-26,  5.294320956433444e-27, -2.754594171052516e-28,
  1.293525664985006e-29, -5.528245976245473e-31,  9.858844039179139e-02, -4.071000172422249e-04,  1.759678525378970e-06, -7.926770087556330e-09,  3.632556934273238e-11,
 -1.754770054392500e-13,  7.565352373903601e-16, -4.959053882365308e-18,  2.043157997486014e-21, -2.807993353242059e-22,  2.466274911171146e-25,  6.052949191929669e-26,
  7.912507323330131e-02, -3.877700449500295e-04,  2.456132975681955e-06, -1.646222395852616e-08,  1.086982880612381e-10, -7.025648674762652e-13,  4.391415170454751e-15,
 -2.765721158369516e-17,  1.590580149717005e-19, -1.060129281942480e-21,  5.843186111309035e-24, -9.123735270165945e-27,  5.092268673781196e-02, -3.291203477529107e-04,
  3.032736181901647e-06, -2.651636037243142e-08,  2.180757317184106e-10, -1.713713511005699e-12,  1.305051738404940e-14, -9.607218950270079e-17,  6.996073064310438e-19,
 -4.856780094020734e-21,  3.416498716750736e-23, -2.472489985382523e-25,  2.623345278063362e-02, -2.323458541750132e-04,  2.830663235833267e-06, -3.009966720253805e-08,
  2.967578711176892e-10, -2.769848771329786e-12,  2.484069071945105e-14, -2.137132297156326e-16,  1.801509000491878e-18, -1.451336031232623e-20,  1.162609170245856e-22,
 -9.346038908788667e-25,  1.078931911757623e-02, -1.310424063255878e-04,  1.980050686912509e-06, -2.504214623844188e-08,  2.914873540996190e-10, -3.181093924391995e-12,
  3.302619675924577e-14, -3.273503707261933e-16,  3.142204994439169e-18, -2.898008398028757e-20,  2.614668201459741e-22, -2.317117010391191e-24,  3.529997769424110e-03,
 -5.796477668775674e-05,  1.050913443944915e-06, -1.566700443164974e-08,  2.129540408142719e-10, -2.686205642214098e-12,  3.194591050831220e-14, -3.608927323573516e-16,
  3.914907971666985e-18, -4.080040340843200e-20,  4.123213472645526e-22, -4.054148254801097e-24,  9.146065849417575e-04, -1.994527112014660e-05,  4.272641104351094e-07,
 -7.466809057429976e-09,  1.175525797226103e-10, -1.700605411783952e-12,  2.300991916475665e-14, -2.941529155432803e-16,  3.587359181757496e-18, -4.191655649880018e-20,
  4.722915329888561e-22, -5.150380607963610e-24,  1.866365874401551e-04, -5.314509617053576e-06,  1.336919539887324e-07, -2.727523963752367e-09,  4.946139579662936e-11,
 -8.166200914120819e-13,  1.251628909657597e-14, -1.802418282355062e-16,  2.462389878868499e-18, -3.211053615248458e-20,  4.020279804733919e-22, -4.852286749613512e-24,
  2.980427172951396e-05, -1.092327537225704e-06,  3.222633932598285e-08, -7.653606553802034e-10,  1.593680376259436e-11, -2.994636502971150e-13,  5.186416273806978e-15,
 -8.391840468896951e-17,  1.281533474674602e-18, -1.860472644402742e-20,  2.582958909231034e-22, -3.444603800469172e-24,  3.697665085220331e-06, -1.724430607606491e-07,
  5.974699804973238e-09, -1.649629131156028e-10,  3.939880041590033e-12, -8.417736346007566e-14,  1.645912101845384e-15, -2.989502672824445e-17,  5.099176599230001e-19,
 -8.233620543767437e-21,  1.266521523469743e-22, -1.864859729967373e-24,  3.536078201797398e-07, -2.080700190419401e-08,  8.492464183623966e-10, -2.726953408587150e-11,
  7.475578122725260e-13, -1.817202437691265e-14,  4.013891899133880e-16, -8.188027403466323e-18,  1.560709669432547e-19, -2.803973200489994e-21,  4.780494205156054e-23,
 -7.774093341399845e-25,  2.585768066824046e-08, -1.909019982764326e-09,  9.219732945283217e-11, -3.450502960227843e-12,  1.088345202235527e-13, -3.016648759592526e-15,
  7.542744078215443e-17, -1.731334422968468e-18,  3.694251495431194e-20, -7.396603695131385e-22,  1.399741530743351e-23, -2.517399163361603e-25,  1.435734786205399e-09,
 -1.326083726093434e-10,  7.621800210818345e-12, -3.338213333637990e-13,  1.216469815487564e-14, -3.859252709493136e-16,  1.096179855936359e-17, -2.840458731975132e-19,
  6.805374664163822e-21, -1.522745558265841e-22,  3.206884863708161e-24, -6.393631501210562e-26,  6.029715013362640e-11, -6.965032499753287e-12,  4.798260639587572e-13,
 -2.474347714228512e-14,  1.047858447791089e-15, -3.825709244037239e-17,  1.240679571058695e-18, -3.646299870539446e-20,  9.851747451239381e-22, -2.473396480720361e-23,
  5.818246775141367e-25, -1.290284407808787e-26,  1.922863747086292e-12, -2.783206541507012e-13,  2.317908945805238e-14, -1.418636462476164e-15,  7.035492719024792e-17,
 -2.977139624750635e-18,  1.109613308846264e-19, -3.721188583271658e-21,  1.140144889328443e-22, -3.228251043991956e-24,  8.522038546841226e-26, -2.111140683998554e-27,
  4.756237714435173e-14, -8.656383415090176e-15,  8.800116972744331e-16, -6.454235676412315e-17,  3.782999076807184e-18, -1.871242730796174e-19,  8.078282345946894e-21,
 -3.113453192198382e-22,  1.088811864678357e-23, -3.497325109059071e-25,  1.041572306991981e-26, -2.895984139008626e-28,  9.678353205093389e-16, -2.221427884131897e-16,
  2.782804535574054e-17, -2.470174010644321e-18,  1.727435814463645e-19, -1.007558783285404e-20,  5.078049344239089e-22, -2.265109728958694e-23,  9.097765472023296e-25,
 -3.333201063247675e-26,  1.125237266418481e-27, -3.525528580305821e-29,  1.858864257809009e-17, -5.364840519482616e-18,  8.319982148209042e-19, -8.991573063077919e-20,
  7.545915852952667e-21, -5.216696056859640e-22,  3.082798067442591e-23, -1.597039324138503e-24,  7.386399031287972e-26, -3.092305912870293e-27,  1.184503716827130e-28,
 -4.183122795899777e-30,  4.466446371589368e-19, -1.586499581070472e-19,  3.008522011179134e-20, -3.920662699890597e-21,  3.914363616207153e-22, -3.180267023036425e-23,
  2.184628522870042e-24, -1.302691771300512e-25,  6.873771042639833e-27, -3.256698004063299e-28,  1.401409600593564e-29, -5.521170849295378e-31,  1.967501772748517e-20,
 -8.088877496893328e-21,  1.777574496172533e-21, -2.660545002685413e-22,  3.020637948355673e-23, -2.764578175717931e-24,  2.120824983119111e-25, -1.401207074068114e-26,
  8.133406429925753e-28, -4.211484556283048e-29,  1.968865224625518e-30, -8.379726023907843e-32,  9.698760634985273e-02, -3.933934539984715e-04,  1.667931790834128e-06,
 -7.372697971979188e-09,  3.298634986221167e-11, -1.589881239748003e-13,  6.171300931562667e-16, -5.046441641127200e-18, -6.956017479756763e-21, -1.845099385841777e-22,
  5.555550445042943e-24,  1.965627339162869e-25,  7.761208042961346e-02, -3.688826339214444e-04,  2.268575484895281e-06, -1.482998870776913e-08,  9.564103248542133e-11,
 -6.059222279032589e-13,  3.682855072440916e-15, -2.313280059598114e-17,  1.251378258275632e-19, -8.192596478842550e-22,  6.632992070737092e-24,  5.043718274956955e-26,
  4.965279432307207e-02, -3.060744256399214e-04,  2.734396808343675e-06, -2.328519602610598e-08,  1.867281153299574e-10, -1.430404208058259e-12,  1.064939622018000e-14,
 -7.623903764294395e-17,  5.468500942807950e-19, -3.696372089535450e-21,  2.405025360462811e-23, -2.205096986001328e-25,  2.534718105857138e-02, -2.110686235384297e-04,
  2.496227522054713e-06, -2.576424804120158e-08,  2.468696885115332e-10, -2.239418172056889e-12,  1.959120575933093e-14, -1.636029956875473e-16,  1.353503206651216e-18,
 -1.061315849189264e-20,  8.025629309373213e-23, -7.272024339522894e-25,  1.029503299091324e-02, -1.163293094367234e-04,  1.705559650182760e-06, -2.084718107068555e-08,
  2.351042107365070e-10, -2.487989200922872e-12,  2.512456330527135e-14, -2.416584913305123e-16,  2.264817667015157e-18, -2.032318448065806e-20,  1.765729914351744e-22,
 -1.601628948126979e-24,  3.313839297928136e-03, -5.025539031661961e-05,  8.817062122494501e-07, -1.265107255301726e-08,  1.661462326204675e-10, -2.027858902378794e-12,
  2.339480189083885e-14, -2.562527671624661e-16,  2.704432759782185e-18, -2.739650778695749e-20,  2.683717949803553e-22, -2.607179024304605e-24,  8.411362105871131e-04,
 -1.685599376326747e-05,  3.479151174874992e-07, -5.830643328004997e-09,  8.845727876722753e-11, -1.235504983341042e-12,  1.617755803374060e-14, -2.002565798452592e-16,
  2.370080636946647e-18, -2.688376179192505e-20,  2.939890087051282e-22, -3.130837176601915e-24,  1.673278089929007e-04, -4.363584773025038e-06,  1.052195293446852e-07,
 -2.052047979753951e-09,  3.576597263124866e-11, -5.688530909282227e-13,  8.418810865083426e-15, -1.172116077478914e-16,  1.550902034755926e-18, -1.960570702328609e-20,
  2.381159796418989e-22, -2.794689687575028e-24,  2.589798609390948e-05, -8.673342221386400e-07,  2.439420786192183e-08, -5.522457037688714e-10,  1.102350469973884e-11,
 -1.991065005531046e-13,  3.322806082237555e-15, -5.189444730539891e-17,  7.662298376316323e-19, -1.076839904829662e-20,  1.448759765494331e-22, -1.874979365436934e-24,
  3.092311069734108e-06, -1.316073296486364e-07,  4.324063814919812e-09, -1.135015619654955e-10,  2.592032480532282e-12, -5.311886480539810e-14,  9.988743272772949e-16,
 -1.748313200052172e-17,  2.878789765384227e-19, -4.493839912744303e-21,  6.691145524909969e-23, -9.548653847996589e-25,  2.821497725317298e-07, -1.514320292502784e-08,
  5.832885779484241e-10, -1.776159508493037e-11,  4.644443579646503e-13, -1.080707123577735e-14,  2.291577177866370e-16, -4.497692078564681e-18,  8.264382068867650e-20,
 -1.433657061699584e-21,  2.363430300943873e-23, -3.721220933563475e-25,  1.947098252021408e-08, -1.311481842744091e-09,  5.952715679325669e-11, -2.107817036743521e-12,
  6.327595767428556e-14, -1.675751208855193e-15,  4.015808409903160e-17, -8.856480175418464e-19,  1.819504767132462e-20, -3.513854755702533e-22,  6.423989784078739e-24,
 -1.117713404895122e-25,  1.005880046775409e-09, -8.485416357465844e-11,  4.568898494138330e-12, -1.889585528694095e-13,  6.541326558048043e-15, -1.979729235924101e-16,
  5.382248544190561e-18, -1.338502880665439e-19,  3.084735292059291e-21, -6.652376086219104e-23,  1.352572881074177e-24, -2.607504363017007e-26,  3.857085447708282e-11,
 -4.078228539285415e-12,  2.626753287317696e-13, -1.277321976773989e-14,  5.132083641796686e-16, -1.785591750801692e-17,  5.537765101654623e-19, -1.560928068649363e-20,
  4.054692269571600e-22, -9.807707545118344e-24,  2.226895817626880e-25, -4.774811928835856e-27,  1.094681008201911e-12, -1.455810475696133e-13,  1.133177881367477e-14,
 -6.537902422480458e-16,  3.075133980084249e-17, -1.239808423351615e-18,  4.418749770166516e-20, -1.421334376855456e-21,  4.187747727903473e-23, -1.142788017584412e-24,
  2.913249023760581e-26, -6.981797343328567e-28,  2.326065993324103e-14, -3.913618431336120e-15,  3.726222067171020e-16, -2.580081774019138e-17,  1.436057597662222e-18,
 -6.776171107335555e-20,  2.800882324535157e-21, -1.036773197640992e-22,  3.491508130791200e-24, -1.082485779206081e-25,  3.118126389475195e-27, -8.401050082454445e-29,
  3.872732267389657e-16, -8.298490027086647e-17,  9.791901707103103e-18, -8.242995113328701e-19,  5.495791206727218e-20, -3.069164592466636e-21,  1.486296003393685e-22,
 -6.389446642715851e-24,  2.479740150748629e-25, -8.798827378103564e-27,  2.882592285271976e-28, -8.781123331409784e-30,  5.715644933746557e-18, -1.563808278814724e-18,
  2.310190134587656e-19, -2.390210281818192e-20,  1.928552269600235e-21, -1.286429180858838e-22,  7.357474044170085e-24, -3.698579993988155e-25,  1.663745656509986e-26,
 -6.788190925833302e-28,  2.538704543457807e-29, -8.768070598333223e-31,  9.953182848502817e-20, -3.424909648295584e-20,  6.300510870517535e-21, -7.987020408514810e-22,
  7.777100551938901e-23, -6.176618821897255e-24,  4.155960029039325e-25, -2.431705609853433e-26,  1.261009828461045e-27, -5.879723909720490e-29,  2.493087060655152e-30,
 -9.689255407367426e-32,  3.253522753691951e-21, -1.324712113364106e-21,  2.882760386914617e-22, -4.275578389943693e-23,  4.813850558739144e-24, -4.372185415773579e-25,
  3.330635446171411e-26, -2.186376033157925e-27,  1.261584803946580e-28, -6.496782145954976e-30,  3.021866611028030e-31, -1.280116685821166e-32,  9.544017147190521e-02,
 -3.803951535614830e-04,  1.582523646861326e-06, -6.869598290833081e-09,  2.994310435894564e-11, -1.459018793729526e-13,  4.721360564810946e-16, -5.311921710252075e-18,
 -6.960597256216174e-21,  2.728243859383949e-22,  1.901541516935705e-23,  4.296253479287398e-25,  7.617175557244087e-02, -3.514207460014966e-04,  2.099412224373771e-06,
 -1.339208971475192e-08,  8.435623797584637e-11, -5.248791159055353e-13,  3.087161886781959e-15, -1.954327963197991e-17,  1.011794097874542e-19, -4.844593149200579e-22,
  1.078393524265403e-23,  1.430142809453591e-25,  4.847054624103674e-02, -2.852682379919210e-04,  2.471999370573595e-06, -2.051321577441722e-08,  1.605126965518334e-10,
 -1.198574394742815e-12,  8.740900645667085e-15, -6.070235419100505e-17,  4.287397553151574e-19, -2.931104843105354e-21,  1.406900129230228e-23, -2.399814674919940e-25,
  2.454097863214290e-02, -1.922715840416047e-04,  2.209356719794338e-06, -2.214856676300410e-08,  2.064360348067345e-10, -1.819637969753370e-12,  1.556331751557435e-14,
 -1.258451332934594e-16,  1.021788470769296e-18, -8.013202694655007e-21,  5.026073050406055e-23, -6.550055795676319e-25,  9.855505870775971e-03, -1.036251283216412e-04,
  1.476421585537876e-06, -1.745299099450115e-08,  1.908658636033783e-10, -1.958637897402515e-12,  1.927173843987465e-14, -1.796564392049362e-16,  1.644639543832509e-18,
 -1.452973967065783e-20,  1.161114808387398e-22, -1.186210734178750e-24,  3.126023526574968e-03, -4.376669590606871e-05,  7.445975465191251e-07, -1.028895800600331e-08,
  1.306695518702577e-10, -1.543547819109339e-12,  1.729660165245791e-14, -1.836257948524646e-16,  1.886447615618282e-18, -1.866525904916409e-20,  1.745570909982607e-22,
 -1.729566310818884e-24,  7.788674019717555e-04, -1.433023311078291e-05,  2.856873356480857e-07, -4.593675089656222e-09,  6.721638374938455e-11, -9.067789159704424e-13,
  1.150141804718778e-14, -1.378742343666372e-16,  1.584433180554246e-18, -1.748303646542185e-20,  1.846820535595884e-22, -1.939934810457144e-24,  1.514137044224357e-04,
 -3.611396986547626e-06,  8.368578194359824e-08, -1.560853492768924e-09,  2.617002679535251e-11, -4.011686090671129e-13,  5.737417459298951e-15, -7.725360423862230e-17,
  9.905395077361989e-19, -1.215137598250448e-20,  1.429867773396508e-22, -1.637116052430198e-24,  2.278085256800919e-05, -6.959667159173618e-07,  1.870690195478771e-08,
 -4.038421409811996e-10,  7.734084562623301e-12, -1.343468744866226e-13,  2.161881943284906e-15, -3.260280178621157e-17,  4.656570995164323e-19, -6.339126257732476e-21,
  8.263717003331366e-23, -1.039080715091926e-24,  2.627339279531057e-06, -1.018308958769901e-07,  3.179627456507317e-09, -7.937498761404912e-11,  1.734540081119764e-12,
 -3.411210594682081e-14,  6.172518284034589e-16, -1.041519452029799e-17,  1.656259094909591e-19, -2.500596440356226e-21,  3.604707373886104e-23, -4.988177073894656e-25,
  2.297185962037061e-07, -1.121780000887031e-08,  4.084661246405519e-10, -1.179878908705284e-11,  2.944635337760643e-13, -6.561549988242834e-15,  1.336240754208140e-16,
 -2.524252219582377e-18,  4.472722698179520e-20, -7.494167383007338e-22,  1.194845593080397e-23, -1.821956505856783e-25,  1.503861802303366e-08, -9.214731915470992e-10,
  3.935099344307176e-11, -1.318537432513889e-12,  3.768641933785547e-14, -9.538692017051412e-16,  2.191433398983677e-17, -4.644593672726301e-19,  9.189007967081131e-21,
 -1.711965180519597e-22,  3.023936211466425e-24, -5.090580501252784e-26,  7.273706422998214e-10, -5.585466536189048e-11,  2.818381874902954e-12, -1.100531873267917e-13,
  3.619492680910399e-15, -1.045067082316154e-16,  2.719567598331944e-18, -6.490996903717970e-20,  1.438941258181399e-21, -2.990709861102358e-23,  5.870341494992755e-25,
 -1.094200916773780e-26,  2.565639241879936e-11, -2.473440675495138e-12,  1.488683751865443e-13, -6.822576605147431e-15,  2.599825008136111e-16, -8.617446737440804e-18,
  2.555136771415075e-19, -6.905545201699113e-21,  1.724112958576582e-22, -4.016797524770720e-24,  8.800700517901505e-26, -1.823906711286308e-27,  6.537022546956166e-13,
 -7.951212822118819e-14,  5.775462712566174e-15, -3.137426075416083e-16,  1.398299922801636e-17, -5.366948905542388e-19,  1.827794082653662e-20, -5.635236198047483e-22,
  1.595567737331937e-23, -4.193715026004367e-25,  1.031744384305240e-26, -2.390595230704335e-28,  1.204778374794906e-14, -1.863856535145680e-15,  1.657461388847919e-16,
 -1.081217501742107e-17,  5.705054292374194e-19, -2.564166769036287e-20,  1.013434326592444e-21, -3.598408097918504e-23,  1.165602986894573e-24, -3.484195355320198e-26,
  9.696802387340320e-28, -2.529029582507588e-29,  1.655935880840660e-16, -3.292090572045289e-17,  3.644217912564171e-18, -2.900148319579597e-19,  1.838571904169203e-20,
 -9.807972519935513e-22,  4.554195671212036e-23, -1.883217565384619e-24,  7.049633871254523e-26, -2.418534023859230e-27,  7.677207598643157e-29, -2.270437966958959e-30,
  1.884384973738752e-18, -4.855092200607504e-19,  6.797740084714625e-20, -6.705402116187745e-21,  5.183171628047189e-22, -3.325557919405634e-23,  1.835639108064443e-24,
 -8.931615503749504e-26,  3.898623720754543e-27, -1.546926835491550e-28,  5.637339659233702e-30, -1.900624617272971e-31,  2.347663190668008e-20, -7.782747765891599e-21,
  1.382372752594787e-21, -1.697798843967327e-22,  1.606689196981222e-23, -1.243546042562853e-24,  8.173455823728103e-26, -4.681260107228271e-27,  2.380520684174018e-28,
 -1.090196432706798e-29,  4.546687324955630e-31, -1.740290613741213e-32,  5.501955626927906e-22, -2.214144234412465e-22,  4.762295812412528e-23, -6.987426902896497e-24,
  7.790125444264571e-25, -7.012337364473974e-26,  5.298417378735642e-27, -3.452252405000663e-28,  1.978436081644450e-29, -1.012443788360985e-30,  4.681963008214831e-32,
 -1.972779187622746e-33,  9.394340035703469e-02, -3.680567786034049e-04,  1.502868565560744e-06, -6.413288103097988e-09,  2.712626274087863e-11, -1.363652610434748e-13,
  3.230448894334973e-16, -5.188919950727466e-18,  2.184014613582822e-20,  1.491616653449634e-21,  4.383905679558620e-23,  6.883912540049410e-25,  7.479867675799520e-02,
 -3.352460961754856e-04,  1.946471473697010e-06, -1.212252455079206e-08,  7.455708473047375e-11, -4.570007074270405e-13,  2.583330486212086e-15, -1.648717529060298e-17,
  9.330075797892248e-20,  1.034270266224041e-22,  1.933661384712196e-23,  2.411763752441340e-25,  4.736752559944635e-02, -2.664349684711989e-04,  2.240494348111862e-06,
 -1.812593760729034e-08,  1.385089628739705e-10, -1.007732589176215e-12,  7.218098156465748e-15, -4.858377206735355e-17,  3.306925034704603e-19, -2.591992104224656e-21,
  2.571016312942594e-24, -2.821249955315344e-25,  2.380563449644941e-02, -1.756063505731352e-04,  1.962253435713624e-06, -1.911757257587708e-08,  1.735110649608969e-10,
 -1.484961597992360e-12,  1.245648832672915e-14, -9.743169895992671e-17,  7.625769054948552e-19, -6.577359608490017e-21,  2.152086948846770e-23, -6.541082408979415e-25,
  9.463371238731418e-03, -9.260240562693997e-05,  1.284093090750959e-06, -1.468899812358318e-08,  1.559396549810434e-10, -1.550987427385771e-12,  1.490534543694876e-14,
 -1.345979331572707e-16,  1.193321267795963e-18, -1.085079761895781e-20,  6.955036809232919e-23, -9.483261811280654e-25,  2.962135601294338e-03, -3.827045126267756e-05,
  6.327241492187181e-07, -8.424290957628755e-09,  1.035660999941209e-10, -1.183882434072568e-12,  1.290799137434855e-14, -1.328009822812618e-16,  1.323481301909087e-18,
 -1.302854073398369e-20,  1.111684923892270e-22, -1.192811118316867e-24,  7.257924567658557e-04, -1.224823495973877e-05,  2.364627617650781e-07, -3.649516191150981e-09,
  5.155576217978483e-11, -6.718757558290043e-13,  8.265418020952033e-15, -9.596915929104649e-17,  1.069640078739164e-18, -1.156720539693950e-20,  1.162659360864731e-22,
 -1.228707292369269e-24,  1.381977665397154e-04, -3.010278026713019e-06,  6.722546121337390e-08, -1.199514277825523e-09,  1.936535284461403e-11, -2.862139768947427e-13,
  3.959437561741458e-15, -5.157876056714528e-17,  6.407475537112080e-19, -7.651157287657181e-21,  8.681553155476864e-23, -9.758806192821648e-25,  2.026832611917730e-05,
 -5.637795704756300e-07,  1.452295062214662e-08, -2.990557715973591e-10,  5.499939442827053e-12, -9.192252256288218e-14,  1.427388705314361e-15, -2.079497357224386e-17,
  2.873646283210959e-19, -3.794583916983716e-21,  4.786963292627899e-23, -5.860523008931611e-25,  2.265460974169722e-06, -7.977915369765174e-08,  2.373489610556849e-09,
 -5.636473993591486e-11,  1.179592070850382e-12, -2.227286277175751e-14,  3.880539720937586e-16, -6.315130247393527e-18,  9.701880037443067e-20, -1.417713880892515e-21,
  1.978295026453944e-23, -2.656728397149745e-25,  1.905873642820516e-07, -8.445268805907602e-09,  2.913236669772995e-10, -7.984385553283642e-12,  1.903182564666209e-13,
 -4.062968462061474e-15,  7.950375008008277e-17, -1.446085925476949e-18,  2.471667333491118e-20, -4.001665921237524e-22,  6.171342247516762e-24, -9.117025127119678e-26,
  1.189490206139616e-08, -6.609883124150782e-10,  2.659866642618519e-11, -8.434868744930174e-13,  2.296536437640449e-14, -5.557130911202124e-16,  1.224372662011853e-17,
 -2.494492210762440e-19,  4.753684972308812e-21, -8.545838147241089e-23,  1.458638703518988e-24, -2.376216558252511e-26,  5.418881907057444e-10, -3.774419893121041e-11,
  1.786239950827739e-12, -6.585170896778644e-14,  2.058031212248126e-15, -5.669703953054198e-17,  1.412444443533379e-18, -3.235784505024933e-20,  6.900360921507121e-22,
 -1.382280066327660e-23,  2.619343073097723e-25, -4.720547943363428e-27,  1.771094871649433e-11, -1.550482038733296e-12,  8.719161944960709e-14, -3.764482777297827e-15,
  1.360274945536558e-16, -4.294659356055280e-18,  1.217242430724076e-19, -3.153709392776387e-21,  7.566621466599592e-23, -1.697600742636579e-24,  3.588262150149624e-26,
 -7.186188052117121e-28,  4.086776081035506e-13, -4.524858499840604e-14,  3.063406911616163e-15, -1.565323499187865e-16,  6.605657826721384e-18, -2.412130782952969e-19,
  7.845156596220156e-21, -2.317033862296920e-22,  6.301135110770808e-24, -1.594295556631065e-25,  3.783312248085268e-27, -8.470693599997508e-29,  6.599314691351980e-15,
 -9.335212013572074e-16,  7.734453404683686e-17, -4.744561452787577e-18,  2.369746274377142e-19, -1.013200490911327e-20,  3.824459282479225e-22, -1.301166223116612e-23,
  4.049780069906100e-25, -1.165983953071274e-26,  3.132236997706757e-28, -7.900572940107246e-30,  7.566703205415504e-17, -1.386535502502085e-17,  1.434274911419029e-18,
 -1.075811885854322e-19,  6.468772856019373e-21, -3.289090642699137e-22,  1.461494560585319e-23, -5.802679650472818e-25,  2.091625906044593e-26, -6.927028392913594e-28,
  2.127344593859349e-29, -6.099051695651166e-31,  6.682119385871090e-19, -1.609450318541234e-19,  2.124522358131459e-20, -1.989517891312407e-21,  1.468002683273477e-22,
 -9.031032767692668e-24,  4.797477016160327e-25, -2.253612650296041e-26,  9.522927621086191e-28, -3.666731149291915e-29,  1.299438525836099e-30, -4.268676538908897e-32,
  5.900022805828411e-21, -1.872135150399610e-21,  3.193443124200418e-22, -3.782714306142042e-23,  3.465514199071511e-24, -2.605034094601190e-25,  1.667516487138479e-26,
 -9.323406567817685e-28,  4.638028169890406e-29, -2.081655607450454e-30,  8.522053298011550e-32, -3.206689536588384e-33,  9.555567669911740e-23, -3.790975404306216e-23,
  8.039916588888628e-24, -1.164564731730084e-24,  1.283317041467202e-25, -1.143083476002471e-26,  8.554868057490285e-28, -5.525816108216421e-29,  3.141754642882417e-30,
 -1.596130165291550e-31,  7.332127397804863e-33, -3.070580885157701e-34,  9.249474187614153e-02, -3.563344943396347e-04,  1.428424463111356e-06, -6.000712301941180e-09,
  2.446538747572552e-11, -1.302134488926858e-13,  1.983821143973832e-16, -3.230476569614038e-18,  1.147837250827747e-19,  3.887479342394265e-21,  7.611104420266661e-23,
  7.010031858448060e-25,  7.348794234574656e-02, -3.202365995466722e-04,  1.807867536699806e-06, -1.099951343280638e-08,  6.600145634071052e-11, -4.001937799579658e-13,
  2.165237665237267e-15, -1.327095484933237e-17,  1.136426226375642e-19,  1.102296519582906e-21,  3.064783019855657e-23,  2.435066558679700e-25,  4.633630730615007e-02,
 -2.493448570680764e-04,  2.035644128621210e-06, -1.606206112160035e-08,  1.199822813823062e-10, -8.497127164598379e-13,  5.991873741830250e-15, -3.949941864657947e-17,
  2.361887388810991e-19, -2.741749281752024e-21, -9.979182428540125e-24, -2.686358045639437e-25,  2.313321599354781e-02, -1.607809275847695e-04,  1.748569747605527e-06,
 -1.656362682562125e-08,  1.465937548688307e-10, -1.216199687865982e-12,  1.003529883721943e-14, -7.670752529735212e-17,  5.344274639463243e-19, -6.281541330355437e-21,
 -6.158379286640616e-24, -5.710058372219230e-25,  9.112447666137231e-03, -8.299455450937583e-05,  1.121831304608222e-06, -1.242389325099740e-08,  1.282127539454938e-10,
 -1.234512694277636e-12,  1.161585907593363e-14, -1.022029253010633e-16,  8.432444277182291e-19, -8.844254199155916e-21,  3.234950773371669e-23, -7.285725079585582e-25,
  2.818574663895921e-03, -3.358655014592181e-05,  5.408449055830690e-07, -6.941005959548926e-09,  8.270817472003039e-11, -9.143311705255491e-13,  9.717532158722113e-15,
 -9.719138123727654e-17,  9.229133606135977e-19, -9.515853587751475e-21,  6.715071882720446e-23, -8.214846748376039e-25,  6.803240918536257e-04, -1.051864197148390e-05,
  1.972070567763612e-07, -2.922194684198238e-09,  3.990275491391526e-11, -5.022386742234978e-13,  6.000709739388241e-15, -6.760262218424740e-17,  7.252447514082323e-19,
 -7.853445108109387e-21,  7.263262385058867e-23, -7.856801587949158e-25,  1.271480009215701e-04, -2.525187426424929e-06,  5.451693920364317e-08, -9.307521469744141e-10,
  1.448533298359615e-11, -2.064334713596102e-13,  2.765210708159074e-15, -3.488768022860551e-17,  4.186627117178571e-19, -4.908853116262303e-21,  5.309895336984933e-23,
 -5.896015028615476e-25,  1.822478869152659e-05, -4.605832005747926e-07,  1.140713677566422e-08, -2.240837986115158e-10,  3.961778308826662e-12, -6.372735443130620e-14,
  9.557013487552985e-16, -1.346059648254100e-17,  1.797998713697788e-19, -2.311167517465174e-21,  2.811292197199176e-23, -3.358645755588026e-25,  1.980448607060110e-06,
 -6.320673723478306e-08,  1.797142327669559e-09, -4.060326534561640e-11,  8.145762278614044e-13, -1.477284678320597e-14,  2.479914730721871e-16, -3.894666911740679e-18,
  5.779662561838658e-20, -8.186787345207589e-22,  1.104810128755747e-23, -1.441209492618919e-25,  1.609263667117099e-07, -6.451727929365668e-09,  2.114017718785007e-10,
 -5.498009447617162e-12,  1.252711150988258e-13, -2.563171536354601e-15,  4.821978378720052e-17, -8.448795505942501e-19,  1.393222904881510e-20, -2.181139746196828e-22,
  3.253390602116840e-24, -4.658529746846632e-26,  9.620245172262498e-09, -4.831913762701230e-10,  1.836062939545499e-11, -5.510876391553046e-13,  1.430193843694103e-14,
 -3.309747687781609e-16,  6.996113290535648e-18, -1.370639466689869e-19,  2.516457826380715e-21, -4.366865176620845e-23,  7.203176666272123e-25, -1.135803833087531e-26,
  4.151765716307518e-10, -2.613095566242121e-11,  1.161391375989351e-12, -4.042131484064514e-14,  1.200867937170811e-15, -3.157186966782166e-17,  7.531140203701980e-19,
 -1.656307207214207e-20,  3.398139553222212e-22, -6.561701364255710e-24,  1.200438471429152e-25, -2.091843084831318e-27,  1.266275230300843e-11, -1.002272721897267e-12,
  5.268456657240822e-14, -2.142197523845274e-15,  7.340162791527233e-17, -2.207222280602450e-18,  5.979787131222388e-20, -1.485117001623799e-21,  3.423818302694683e-23,
 -7.396351400275402e-25,  1.508053106827140e-26, -2.918050956413837e-28,  2.669266100859298e-13, -2.676781773320143e-14,  1.687928972373344e-15, -8.106065248076097e-17,
  3.237275273252655e-18, -1.124118028509248e-19,  3.489976817090666e-21, -9.869918716645359e-23,  2.576904119624345e-24, -6.273788925587473e-26,  1.435407920257155e-27,
 -3.104157764308060e-29,  3.816290890670549e-15, -4.907303086791833e-16,  3.780330370544654e-17, -2.177138127456616e-18,  1.028015245100617e-19, -4.176532500785697e-21,
  1.504097248485459e-22, -4.898625256259197e-24,  1.463651147881396e-25, -4.055345464048734e-27,  1.050644053988553e-28, -2.560797226939567e-30,  3.693079965140779e-17,
 -6.194443217587469e-18,  5.965936009574711e-19, -4.205808223850294e-20,  2.393070113795288e-21, -1.157408243752238e-22,  4.912526129225643e-24, -1.869600753077059e-25,
  6.479044828772321e-27, -2.068265835953405e-28,  6.136536661184082e-30, -1.703250750196530e-31,  2.554927830131810e-19, -5.707189120783335e-20,  7.064593956719157e-21,
 -6.253843810837274e-22,  4.389081509283617e-23, -2.580847540556402e-24,  1.315744257195342e-25, -5.951881384083818e-27,  2.429060762165565e-28, -9.056392877690509e-30,
  3.114774039496921e-31, -9.950804481005200e-33,  1.590720330208477e-21, -4.794669367153149e-22,  7.806869922717624e-23, -8.873998388199013e-24,  7.836762624477089e-25,
 -5.699995050140254e-26,  3.541691857772789e-27, -1.927454723251293e-28,  9.354981936150179e-30, -4.105074456903435e-31,  1.646097750701507e-32, -6.077037125943489e-34,
  1.713421648020675e-23, -6.679225826644039e-24,  1.392557397044417e-24, -1.986147496843869e-25,  2.158517317815573e-26, -1.898825940858157e-27,  1.405206343167785e-28,
 -8.984780739557911e-30,  5.061427612198310e-31, -2.549846129413618e-32,  1.162339968008168e-33, -4.833535489325532e-35,  9.109181177179339e-02, -3.451886745995297e-04,
  1.358679427771809e-06, -5.629862977301591e-09,  2.190417826163653e-11, -1.259709735616889e-13,  1.848943257396269e-16,  3.322174628533861e-18,  3.157381009627356e-19,
  7.399239432300616e-21,  9.382209414372776e-23, -8.802273670308152e-26,  7.223511043007765e-02, -3.062842740476896e-04,  1.681954207176876e-06, -1.000481605615900e-08,
  5.848945094504462e-11, -3.522305891757327e-13,  1.852323226567551e-15, -8.744786618094167e-18,  1.775050225437467e-19,  2.485530665006945e-21,  3.637599605853372e-23,
 -5.463943379845791e-26,  4.537032189940064e-02, -2.337992904012304e-04,  1.853881200374971e-06, -1.427084711904371e-08,  1.043405071857217e-10, -7.184199823114786e-13,
  4.976191751506508e-15, -3.361851211889170e-17,  1.278206482440634e-19, -3.332865970657600e-21, -1.794550392462420e-23, -4.107402441876131e-26,  2.251686452110263e-02,
 -1.475493172883776e-04,  1.563117005962347e-06, -1.440033085773555e-08,  1.245133510038744e-10, -9.994055342569234e-13,  8.092315841995441e-15, -6.331574554782379e-17,
  2.985961062377480e-19, -6.936325454383260e-21, -2.332747453316640e-23, -1.179402578578162e-25,  8.797521411145233e-03, -7.458315974979385e-05,  9.842847624741879e-07,
 -1.055578594407836e-08,  1.060930479497075e-10, -9.873098033463255e-13,  9.085530779064181e-15, -8.012057904059799e-17,  5.413217192291265e-19, -8.087607108351042e-21,
  8.654035603362399e-24, -2.882625387044161e-25,  2.692384491346911e-03, -2.957177438360345e-05,  4.649280150137302e-07, -5.752165595186146e-09,  6.654929534949331e-11,
 -7.107290866578152e-13,  7.361455563923281e-15, -7.268541625757375e-17,  6.209228382402098e-19, -7.448283325177818e-21,  3.894877404664195e-23, -4.450837738864217e-25,
  6.411971266105424e-04, -9.071112892151831e-06,  1.656636026824848e-07, -2.356883424658154e-09,  3.115734177705453e-11, -3.785563883486898e-13,  4.393878941047565e-15,
 -4.841924823550031e-17,  4.873934565045803e-19, -5.540937175394012e-21,  4.529434944670740e-23, -4.679981837175411e-25,  1.178539613785774e-04, -2.130079902453508e-06,
  4.461309334176544e-08, -7.287171907213461e-10,  1.094836951378902e-11, -1.504265890486604e-13,  1.952002386534103e-15, -2.395397941567197e-17,  2.746453478538181e-19,
 -3.226061949670893e-21,  3.276344794057038e-23, -3.518859111161121e-25,  1.654934279851436e-05, -3.790938857768379e-07,  9.060114754594618e-09, -1.697628493136009e-10,
  2.889130892456471e-12, -4.473290541629254e-14,  6.482415870796866e-16, -8.847145276499652e-18,  1.137209252474437e-19, -1.434731418498804e-21,  1.673655072118810e-23,
 -1.939891122376370e-25,  1.753575718660061e-06, -5.057751429223413e-08,  1.379306936841069e-09, -2.964395859429153e-11,  5.707788753950905e-13, -9.945131207245481e-15,
  1.609461040149244e-16, -2.442467848244402e-18,  3.495646897702624e-20, -4.815891971830168e-22,  6.274713003209397e-24, -7.940251743825611e-26,  1.381274720832231e-07,
 -4.993868516310228e-09,  1.559436912337593e-10, -3.848122157811579e-12,  8.389680035014786e-14, -1.645844828147684e-15,  2.978261711039219e-17, -5.030912876325456e-19,
  8.000719722351839e-21, -1.212879151876794e-22,  1.749177289109811e-24, -2.427335282540175e-26,  7.944263233607836e-09, -3.593181035453897e-10,  1.292846384754275e-11,
 -3.672476199339744e-13,  9.092165902008450e-15, -2.012975812902380e-16,  4.083985224600193e-18, -7.697890389680518e-20,  1.361660670857987e-21, -2.282324279635831e-23,
  3.638421284423022e-25, -5.553738142690961e-27,  3.265680335981922e-10, -1.849572240439982e-11,  7.735795135902842e-13, -2.541494184814908e-14,  7.181448209377034e-16,
 -1.802266316986950e-17,  4.117656460409783e-19, -8.696145835526801e-21,  1.716630341307585e-22, -3.196062853521587e-24,  5.645427575881762e-26, -9.512794846761704e-28,
  9.358132614189959e-12, -6.665669260590668e-13,  3.278668958973104e-14, -1.255140176920965e-15,  4.078923997722743e-17, -1.168255576170996e-18,  3.025456775082511e-20,
 -7.202998439605647e-22,  1.595577684395731e-23, -3.318901430545775e-25,  6.526984394946636e-27, -1.220146931985691e-28,  1.817517046799689e-13, -1.642012354928946e-14,
  9.643142779035196e-16, -4.349448195758389e-17,  1.643340665137089e-18, -5.424535825509722e-20,  1.607136292142495e-21, -4.350859232475974e-23,  1.090236106743899e-24,
 -2.553268707678318e-26,  5.630382199338250e-28, -1.175644962511876e-29,  2.325228793998433e-15, -2.701166448436241e-16,  1.931764282713343e-17, -1.043018372481828e-18,
  4.651233425451023e-20, -1.793940719534733e-21,  6.158710300866299e-23, -1.918578205973967e-24,  5.498883349031700e-26, -1.465107157694638e-27,  3.657993464495483e-29,
 -8.609168927275172e-31,  1.923248691730716e-17, -2.931261123227099e-18,  2.619809245779885e-19, -1.731387360216253e-20,  9.302928292857125e-22, -4.272075167076848e-23,
  1.729180713261380e-24, -6.298480085233532e-26,  2.095474384525624e-27, -6.439003422685662e-29,  1.843296413270542e-30, -4.946926103542366e-32,  1.055159648348643e-19,
 -2.167182304742223e-20,  2.502144205599516e-21, -2.085091279378740e-22,  1.387008743519597e-23, -7.771771687343291e-25,  3.792066911463485e-26, -1.647761251306113e-27,
  6.479998323916833e-29, -2.334390781535867e-30,  7.776289956920255e-32, -2.411477640605228e-33,  4.632827848214990e-22, -1.314768728343671e-22,  2.029734120217985e-23,
 -2.201879177906142e-24,  1.865709075913563e-25, -1.307741799569515e-26,  7.859478524181783e-28, -4.150102343002275e-29,  1.959649114147840e-30, -8.385642475678060e-32,
  3.285850123902226e-33, -1.187609790600652e-34,  3.192875426110160e-24, -1.217699265419393e-24,  2.486338948494192e-25, -3.480485281908576e-26,  3.720140881567403e-27,
 -3.224371638910157e-28,  2.354659218140706e-29, -1.487655021421846e-30,  8.290396013858479e-32, -4.135797108646041e-33,  1.868539569614322e-34, -7.707278685186089e-36,
  8.973237623568954e-02, -3.345837043210662e-04,  1.293141656554955e-06, -5.299254809626253e-09,  1.944370522610027e-11, -1.190042555863689e-13,  4.643841541200302e-16,
  1.837401968013092e-17,  6.439466574820903e-19,  1.052396704302282e-20,  4.548776828684533e-23, -2.420492317922136e-24,  7.103614600858500e-02, -2.932934824903621e-04,
  1.567286556653085e-06, -9.122996853257963e-09,  5.187326722686075e-11, -3.099788224283147e-13,  1.702363201279771e-15, -1.368241732271658e-18,  2.908063004117914e-19,
  3.686582774401312e-21,  1.736157010053341e-23, -9.247771459216427e-25,  4.446374093086458e-02, -2.196259122423222e-04,  1.692193728218662e-06, -1.271017044806325e-08,
  9.109204715087002e-11, -6.099407535682594e-13,  4.073132592810529e-15, -3.158149198403861e-17, -4.174976043388000e-21, -3.932178445928687e-21, -7.276874916893675e-24,
  6.126026304028562e-25,  2.195062859201152e-02, -1.357031829528133e-04,  1.401639284872036e-06, -1.255805610594900e-08,  1.063283736315653e-10, -8.256214564129040e-13,
  6.414440713376875e-15, -5.793028224904229e-17,  3.334016289502747e-20, -7.686472192000056e-21, -5.478766192976678e-24,  1.080995757521532e-24,  8.514173942275325e-03,
 -6.718812946025917e-05,  8.671850097608536e-07, -9.005150170163825e-09,  8.835464780352807e-11, -7.944871759122042e-13,  7.041292732313903e-15, -6.740159514426557e-17,
  2.553925070641203e-19, -7.761301312600508e-21,  1.456791101837442e-23,  6.632922692436201e-25,  2.581123282651223e-03, -2.611137402775085e-05,  4.018509736404794e-07,
 -4.792148829756551e-09,  5.394720139758923e-11, -5.564690028023966e-13,  5.566089639065912e-15, -5.683538853664813e-17,  3.773938197526188e-19, -6.137556150032190e-21,
  3.058836782151391e-23,  1.060654069254956e-25,  6.073954195820471e-04, -7.851000026433969e-06,  1.401396308562155e-07, -1.913636848570039e-09,  2.453929896660139e-11,
 -2.877824609692720e-13,  3.228789688624055e-15, -3.569970019092763e-17,  3.163518900974507e-19, -4.054879573321535e-21,  3.116538169240486e-23, -1.708184340790174e-25,
  1.099959910071550e-04, -1.805388799529909e-06,  3.682791132585809e-08, -5.752775872581741e-10,  8.358698566180416e-12, -1.107329104757796e-13,  1.388516268449651e-15,
 -1.679770883851592e-17,  1.788448525683358e-19, -2.173281985568879e-21,  2.106910722316751e-23, -1.873319760851656e-25,  1.516605333806477e-05, -3.140386331151841e-07,
  7.273318012908845e-09, -1.299261083669071e-10,  2.131923722180623e-12, -3.178001964243065e-14,  4.445367997478113e-16, -5.920239784268364e-18,  7.232325991371775e-20,
 -9.081238516434230e-22,  1.020574595635063e-23, -1.095502838295414e-25,  1.571282467747820e-06, -4.082457688876675e-08,  1.072431780696169e-09, -2.191401142759265e-11,
  4.055548898762354e-13, -6.791134160121752e-15,  1.059206369585111e-16, -1.558902120353564e-18,  2.140675465087538e-20, -2.885308130074136e-22,  3.634436258337501e-24,
 -4.400908486858234e-26,  1.203838490610438e-07, -3.910480116340770e-09,  1.168479250125120e-10, -2.734588233685382e-12,  5.712072302939262e-14, -1.074768904796546e-15,
  1.870937300725039e-17, -3.052695916799459e-19,  4.673066702907815e-21, -6.876806902275291e-23,  9.593797411637639e-25, -1.285510490500055e-26,  6.689062953198333e-09,
 -2.713198917513586e-10,  9.276926164002994e-12, -2.493081395308336e-13,  5.894338645458392e-15, -1.248925322870401e-16,  2.432642148968463e-18, -4.416006145894488e-20,
  7.521861544548804e-22, -1.219043168409630e-23,  1.878714176923690e-25, -2.773842357243034e-27,  2.632744729682721e-10, -1.335594404314688e-11,  5.271844438372594e-13,
 -1.634415117187633e-14,  4.396001991216790e-16, -1.053400270713500e-17,  2.305713225542828e-19, -4.678536418386706e-21,  8.885479441667354e-23, -1.595787871208027e-24,
  2.721983058087389e-26, -4.434817848099977e-28,  7.134669040111854e-12, -4.549751669984794e-13,  2.098100708441267e-14, -7.559260634727668e-16,  2.330873011686150e-17,
 -6.359388492841545e-19,  1.574455386308803e-20, -3.594046337605477e-22,  7.649490421929053e-24, -1.532230754206652e-25,  2.906451562952720e-27, -5.248766656245378e-29,
  1.287319408910198e-13, -1.041699502493959e-14,  5.701458042799583e-16, -2.413738639817592e-17,  8.627336476622391e-19, -2.706644278656551e-20,  7.651102168557674e-22,
 -1.982484502582010e-23,  4.766710625725610e-25, -1.073619022751199e-26,  2.281300513987349e-28, -4.598058096732532e-30,  1.489402540060943e-15, -1.552721042906040e-16,
  1.030026871295336e-17, -5.207672606024208e-19,  2.191553652149448e-20, -8.018666142200684e-22,  2.622512214575662e-23, -7.809534861614454e-25,  2.145749660305452e-26,
 -5.494283655910937e-28,  1.321179815008127e-29, -3.000606995080576e-31,  1.067028979676251e-17, -1.466231205525779e-18,  1.212695629186936e-19, -7.496106811676542e-21,
  3.796651631033612e-22, -1.652794462076991e-23,  6.370556889903266e-25, -2.217891716463594e-26,  7.074849090136469e-28, -2.090083046641846e-29,  5.766163335270026e-31,
 -1.494563353797342e-32,  4.711163866360816e-20, -8.814153792778082e-21,  9.442787577133411e-22, -7.377683433473636e-23,  4.636156392119467e-24, -2.468264184162122e-25,
  1.149647133217613e-26, -4.787240223007103e-28,  1.810111483431770e-29, -6.287692690621650e-31,  2.024772642899478e-32, -6.083742481460155e-34,  1.467192570781836e-22,
 -3.880540284513413e-23,  5.638553956232096e-24, -5.803373456996959e-25,  4.694827421138826e-26, -3.157795128735018e-27,  1.828763233492361e-28, -9.338038545014430e-30,
  4.276821276493976e-31, -1.779775765827186e-32,  6.797725604692812e-34, -2.399833895907956e-35,  6.233438142188998e-25, -2.312741251622755e-25,  4.602334922485360e-26,
 -6.297692085866796e-27,  6.597741011656788e-28, -5.617914773217605e-29,  4.038321065518404e-30, -2.515595237539811e-31,  1.384202516304875e-32, -6.826605514523398e-34,
  3.052350282622253e-35, -1.247199130170410e-36,  8.841433617567857e-02, -3.244878225094699e-04,  1.231341202025068e-06, -5.006369278795963e-09,  1.723028990389538e-11,
 -9.900055774903538e-14,  1.325283622818152e-15,  4.512033463039927e-17,  1.019897994835555e-18,  9.088360947908929e-21, -1.484748419257463e-22, -6.688322017138737e-24,
  6.988737463209288e-02, -2.811794410850755e-04,  1.462593046266696e-06, -8.340393815513584e-09,  4.608511958954011e-11, -2.684052623520353e-13,  1.814663330974752e-15,
  1.009145049197602e-17,  4.225024512040325e-19,  3.149186153744746e-21, -5.581880509202883e-23, -2.509522807694007e-24,  4.361138020725792e-02, -2.066745676632402e-04,
  1.548030337559393e-06, -1.134527945906181e-08,  7.979852184358168e-11, -5.229432252704404e-13,  3.165692123775511e-15, -3.396540855652529e-17, -1.416818656110312e-19,
 -3.369606445078868e-21,  4.412780666052702e-23,  1.805438810927782e-24,  2.142932691715796e-02, -1.250651373913401e-04,  1.260630811109892e-06, -1.098108972463395e-08,
  9.122356608843465e-11, -6.912731968353258e-13,  4.766125818751157e-15, -6.120745094130237e-17, -2.308129589770290e-19, -6.387284993983492e-21,  8.611692343001768e-23,
  3.225393483000101e-24,  8.258644400537500e-03, -6.066001522233289e-05,  7.671089144291471e-07, -7.710040208772282e-09,  7.400564544756946e-11, -6.474718738261489e-13,
  5.227713096334287e-15, -6.350513785577601e-17, -2.653791837453730e-21, -6.163902485762149e-21,  7.713391204429222e-23,  2.281896433034381e-24,  2.482762855603195e-03,
 -2.311271701602335e-05,  3.491789358064876e-07, -4.011289516487905e-09,  4.403099873502790e-11, -4.408101415374911e-13,  4.112354234883573e-15, -4.803581448951554e-17,
  1.815810109894549e-19, -4.598140627299745e-21,  5.236959797914810e-23,  9.256204516510744e-25,  5.780970960373457e-04, -6.815474543504748e-06,  1.193545806765971e-07,
 -1.563163842786525e-09,  1.948296242267013e-11, -2.212692190588064e-13,  2.350636625494589e-15, -2.768049789217338e-17,  1.918686770459080e-19, -2.862918131354988e-21,
  3.088594496154945e-23,  1.655113996590906e-25,  1.033229630280009e-04, -1.536262567337894e-06,  3.065938586873229e-08, -4.575942015014878e-10,  6.442242564797524e-12,
 -8.247267731131431e-14,  9.876195706306645e-16, -1.217748008786335e-17,  1.141643721798717e-19, -1.454551913853216e-21,  1.584081607194379e-23, -5.353788266213133e-26,
  1.401715690530854e-05, -2.615534604443360e-07,  5.899628837710013e-09, -1.003724725078139e-10,  1.590818013611960e-12, -2.286642017950450e-14,  3.067686397243914e-16,
 -4.058528533822003e-18,  4.598051033559510e-20, -5.787011908623670e-22,  6.660233456054043e-24, -5.514428537553675e-26,  1.423620774272368e-06, -3.319617784863538e-08,
  8.443247258421205e-10, -1.638715601080394e-11,  2.919802654022939e-13, -4.704103614421080e-15,  7.048025945850202e-17, -1.015390398861629e-18,  1.323249658256552e-20,
 -1.751608602722788e-22,  2.179717507087426e-24, -2.390370486310398e-26,  1.064236306439781e-07, -3.092908545646783e-09,  8.887886863173651e-11, -1.970851719398666e-12,
  3.950174946313225e-14, -7.134644085648907e-16,  1.193021935543815e-17, -1.889137365402589e-19,  2.770981337000302e-21, -3.966352709636529e-23,  5.392013456137529e-25,
 -6.862535042797114e-27,  5.735303560972887e-09, -2.076391453726091e-10,  6.777890127679829e-12, -1.721855576659358e-13,  3.892674651145191e-15, -7.898599399476526e-17,
  1.476271038445403e-18, -2.587044254141295e-20,  4.236130214402850e-22, -6.645130067004076e-24,  9.924001332263537e-26, -1.410935898275877e-27,  2.171934051991764e-10,
 -9.817674582631711e-12,  3.671686099139044e-13, -1.073469542080742e-14,  2.751062085963804e-16, -6.297397036515156e-18,  1.320456857621470e-19, -2.577232791875279e-21,
  4.706896167233668e-23, -8.158564173524430e-25,  1.344891637679848e-26, -2.116450367675229e-28,  5.600839714846610e-12, -3.179199966218276e-13,  1.378603882571577e-14,
 -4.671877844414840e-16,  1.367744001924617e-17, -3.555627747968518e-19,  8.416085268293435e-21, -1.842915161813477e-22,  3.768320829497329e-24, -7.270128317380125e-26,
  1.330417340781748e-27, -2.320486694949971e-29,  9.463605690801002e-14, -6.815243811565616e-15,  3.482376715922825e-16, -1.382832223508081e-17,  4.676623745379924e-19,
 -1.394404695081657e-20,  3.760430604140940e-22, -9.326081144538040e-24,  2.151286165503337e-25, -4.659541153251578e-27,  9.539177004155485e-29, -1.855495125147000e-30,
  1.000589513596665e-15, -9.293437271835658e-17,  5.719095223768672e-18, -2.704612415326399e-19,  1.073595288670408e-20, -3.724548639927531e-22,  1.159855415702136e-23,
 -3.300135503467922e-25,  8.688168183719207e-27, -2.136915969826253e-28,  4.946522267245670e-30, -1.083556511794441e-31,  6.294354918709042e-18, -7.732323398900955e-19,
  5.906380027202332e-20, -3.407892379361655e-21,  1.624604704490595e-22, -6.695511675876925e-24,  2.454519929767033e-25, -8.158267419028806e-27,  2.492435245824031e-28,
 -7.071567521241122e-30,  1.878159750142371e-31, -4.696800984975799e-33,  2.274195991420576e-20, -3.836586089919561e-21,  3.795750957284849e-22, -2.770076425843663e-23,
  1.639393111985572e-24, -8.270747524913558e-26,  3.668474781169925e-27, -1.460642941116455e-28,  5.299127795733824e-30, -1.771461633147705e-31,  5.504294391659797e-33,
 -1.599623355432015e-34,  5.083142181716550e-23, -1.238374812812506e-23,  1.680469894540377e-24, -1.630928296778126e-25,  1.253257276644348e-26, -8.053274767201018e-28,
  4.476680304908808e-29, -2.202791071755650e-30,  9.754736629751841e-32, -3.936392743672170e-33,  1.461640604810000e-34, -5.028039945453385e-36,  1.287753889471979e-25,
 -4.613496711378584e-26,  8.892797135863551e-27, -1.183510898301045e-27,  1.210191431965398e-28, -1.008754948085119e-29,  7.116004854651848e-31, -4.359184594176806e-32,
  2.362990252268252e-33, -1.149803963043813e-34,  5.079010309780181e-36, -2.052634929062381e-37,  8.713571229592025e-02, -3.148728488189133e-04,  1.172860476938338e-06,
 -4.744297318348338e-09,  1.569082245572808e-11, -4.809994962559454e-14,  3.082804246167681e-15,  8.117993110133474e-17,  1.155546384099721e-18, -4.236887385699368e-21,
 -5.537205459478758e-22, -1.153605180131056e-23,  6.878544166544986e-02, -2.698668924750611e-04,  1.366763340826909e-06, -7.643485722327188e-09,  4.118368606767404e-11,
 -2.198514634786262e-13,  2.299060784021378e-15,  2.474509786850442e-17,  4.639865277567286e-19, -1.848728509319283e-21, -2.074145516074571e-22, -4.309047393758288e-24,
  4.280861780719827e-02, -1.948139628801238e-04,  1.419214962977627e-06, -1.014837981332478e-08,  7.001932461618277e-11, -4.589869079819973e-13,  2.136403416539161e-15,
 -3.991889224669918e-17, -2.082440141453280e-19,  4.031345599948744e-22,  1.545310612333845e-22,  3.157416418532711e-24,  2.094843558954342e-02, -1.154833837183797e-04,
  1.137177454934682e-06, -9.626501488978554e-09,  7.839804994514795e-11, -5.984674924963338e-13,  2.920914247131878e-15, -7.128504493575175e-17, -3.576971465869056e-19,
  6.456736918273088e-22,  2.834791011498277e-22,  5.647176004978910e-24,  8.027719291977247e-03, -5.487403917999747e-05,  6.812860667705982e-07, -6.623335559248364e-09,
  6.216600480664651e-11, -5.435323442209511e-13,  3.420569675639977e-15, -6.631494509852367e-17, -1.397060204375745e-19, -5.107952356462697e-22,  2.189067733430506e-22,
  4.088768109614549e-24,  2.395610058197272e-03, -2.050048841496772e-05,  3.049956483522352e-07, -3.372407936712600e-09,  3.609561990868938e-11, -3.577332974672251e-13,
  2.827239525234869e-15, -4.437330077045500e-17,  6.607425233582297e-20, -1.414918012771652e-21,  1.133215764966854e-22,  1.808096126920981e-24,  5.526331322826538e-04,
 -5.930688072953286e-06,  1.023301778972411e-07, -1.284026457392839e-09,  1.556216550457878e-11, -1.735470297206772e-13,  1.647858813111107e-15, -2.293084127225549e-17,
  1.137388675241040e-19, -1.379046612754983e-21,  4.573335461775928e-23,  4.942659747953001e-25,  9.763600419077181e-05, -1.311317250854166e-06,  2.573615032651218e-08,
 -3.665351728022013e-10,  5.004143046571936e-12, -6.249270920518428e-14,  6.907793947558204e-16, -9.242237983735358e-18,  7.295845947481542e-20, -8.332778357978330e-22,
  1.602419102986910e-23,  5.566513419231512e-26,  1.305827692030083e-05, -2.187739444150118e-07,  4.833982777617855e-09, -7.821386041403693e-11,  1.198693294036082e-12,
 -1.671888826424549e-14,  2.109399160562584e-16, -2.873077062943269e-18,  2.946851899718444e-20, -3.488934482740152e-22,  5.096520501770961e-24, -1.860844280351018e-26,
  1.303203225559962e-06, -2.715534276428965e-08,  6.728774677660182e-10, -1.238509683235654e-11,  2.127351542846256e-13, -3.311171116482964e-15,  4.713878982292459e-17,
 -6.778278987358637e-19,  8.279339760141068e-21, -1.050707520704019e-22,  1.410409356629957e-24, -1.210762402740019e-26,  9.533812975789641e-08, -2.466725647552869e-09,
  6.859580848785492e-11, -1.439054759883251e-12,  2.771394161417173e-14, -4.817781669499734e-16,  7.693973112463242e-18, -1.194479872189948e-19,  1.668788373778644e-21,
 -2.304043474760622e-23,  3.152963437401245e-25, -3.638729736901904e-27,  5.001458004744270e-09, -1.607307952432958e-10,  5.038852937289194e-12, -1.208367767475294e-13,
  2.615655027370652e-15, -5.091255241592549e-17,  9.105464991062943e-19, -1.548290305980366e-20,  2.430893677706114e-22, -3.681715068309277e-24,  5.387379078822412e-26,
 -7.271345096394949e-28,  1.830758627516575e-10, -7.329326026053946e-12,  2.611035810494760e-13, -7.190179552561142e-15,  1.757807291670536e-16, -3.847881718135475e-18,
  7.720132677536080e-20, -1.452952886637327e-21,  2.549374871631479e-23, -4.262521858721380e-25,  6.814151090501228e-27, -1.031719795640762e-28,  4.518849933811719e-12,
 -2.268134025714941e-13,  9.289433134718711e-15, -2.958012371620107e-16,  8.229425949278188e-18, -2.039675818450824e-19,  4.613758490196947e-21, -9.702155970278810e-23,
  1.905390598481272e-24, -3.540553523168542e-26,  6.256697346456747e-28, -1.052998745502085e-29,  7.205110648633834e-14, -4.584296984825429e-15,  2.193659646422327e-16,
 -8.162955080153238e-18,  2.613273695669920e-19, -7.406815143008093e-21,  1.905237172718531e-22, -4.524083795738739e-24,  1.001039299534852e-25, -2.084888117906343e-27,
  4.112778044933064e-29, -7.718044298254637e-31,  7.032858641486177e-16, -5.772502171256356e-17,  3.299985502779762e-18, -1.458100207069885e-19,  5.458557497240725e-21,
 -1.795007532089292e-22,  5.320307041693546e-24, -1.446034250221086e-25,  3.646278940966197e-27, -8.611493710086682e-29,  1.918221471395277e-30, -4.051030348899006e-32,
  3.938630584507620e-18, -4.285380708820846e-19,  3.020418983517216e-20, -1.623761996192156e-21,  7.277637759943195e-23, -2.836483227620222e-24,  9.879760875284195e-26,
 -3.132128025539353e-27,  9.156058406923485e-29, -2.492590133229364e-30,  6.367539226244401e-32, -1.534949782121146e-33,  1.185947771120190e-20, -1.784069546391688e-21,
  1.623478281837273e-22, -1.102863121187072e-23,  6.130329416958414e-25, -2.923677330352525e-26,  1.232226482163077e-27, -4.681773729443377e-29,  1.626619904852990e-30,
 -5.223634120006153e-32,  1.563439090833152e-33, -4.387351028027401e-35,  1.936336651233657e-23, -4.287568660484276e-24,  5.390438139060835e-25, -4.902434910003200e-26,
  3.559957711862150e-27, -2.175766581154968e-28,  1.156369907532725e-29, -5.463831678708988e-31,  2.331959661139201e-32, -9.098398082279769e-34,  3.275475013185819e-35,
 -1.095180291716927e-36,  2.849510268207281e-26, -9.760200895698437e-27,  1.808168643553320e-27, -2.325866510875618e-28,  2.309396868716001e-29, -1.876328448866636e-30,
  1.294176140827478e-31, -7.771871352808894e-33,  4.139016180457002e-34, -1.982366143978322e-35,  8.632954783743606e-37, -3.444499446723161e-38,  8.589463206849089e-02,
 -3.057134662346091e-04,  1.117418789144342e-06, -4.496075672945640e-09,  1.567317068165646e-11,  5.702295164979519e-14,  5.814122680888090e-15,  1.104018432937014e-16,
  4.754123828790045e-19, -3.714668024307032e-20, -1.090751919023426e-21, -1.119103376672039e-23,  6.772727680414310e-02, -2.592887845096103e-04,  1.278860468626488e-06,
 -7.016460670556070e-09,  3.740272414298244e-11, -1.548101617633027e-13,  3.176128060948482e-15,  3.653798361188831e-17,  1.999406070275670e-19, -1.416466734809966e-20,
 -4.080449172422378e-22, -4.186212469822980e-24,  4.205132410626662e-02, -1.839290016512522e-04,  1.303861283530940e-06, -9.099115584411591e-09,  6.125813027934278e-11,
 -4.218159266274071e-13,  9.377107915817076e-16, -4.487257317709242e-17, -4.715684323861504e-20,  9.531747434791673e-21,  3.015919182259449e-22,  3.058440318765179e-24,
  2.050399421231369e-02, -1.068276002655334e-04,  1.028801091310748e-06, -8.464779378525199e-09,  6.696177669062059e-11, -5.534985222613465e-13,  7.867204940762302e-16,
 -7.966113724750585e-17, -6.715578902082422e-20,  1.726053965212864e-20,  5.468607366590028e-22,  5.490174434468872e-24,  7.818643153970349e-03, -4.972556195942730e-05,
  6.074279476542827e-07, -5.711824194406575e-09,  5.196345861810191e-11, -4.841731659706879e-13,  1.512578439699187e-15, -6.901993510790203e-17,  4.537675305458339e-20,
  1.207627390196981e-20,  4.103503639874987e-22,  4.000894548958325e-24,  2.318244903363028e-03, -1.821310268360174e-05,  2.677666263801401e-07, -2.848847024626789e-09,
  2.952001473081591e-11, -3.045618085823938e-13,  1.613915700860626e-15, -4.203449317512660e-17,  1.171583678510070e-19,  4.827504855627371e-21,  1.990053429010763e-22,
  1.801784014492301e-24,  5.304557212080689e-04, -5.169697896926161e-06,  8.830766813301869e-08, -1.060861883120356e-09,  1.243668433843843e-11, -1.413240285059296e-13,
  1.052068317769585e-15, -1.968643757330948e-17,  1.027579704083344e-19,  9.332535953225845e-22,  7.017921366203809e-23,  5.241578314765081e-25,  9.277646013602529e-05,
 -1.121750164908099e-06,  2.177956898123728e-08, -2.956504913702920e-10,  3.900376907429270e-12, -4.877873067636933e-14,  4.610883877490664e-16, -7.257805157650728e-18,
  5.526675814822353e-20, -1.253061309057775e-22,  1.960083631384799e-23,  8.435207416061052e-26,  1.225500950155400e-05, -1.835540570269020e-07,  4.000277136363661e-09,
 -6.146029384779545e-11,  9.089314485049982e-13, -1.252535636580118e-14,  1.420808356014161e-16, -2.092873490479352e-18,  2.044397249513104e-20, -1.547846963051392e-22,
  4.726731752554640e-24, -2.769949333671501e-27,  1.204482147777485e-06, -2.231360732203738e-08,  5.426761965255878e-10, -9.455608186409807e-12,  1.564289630937155e-13,
 -2.380781207305439e-15,  3.137239545171976e-17, -4.634246840125340e-19,  5.404557913069070e-21, -5.711683945758711e-23,  1.031698587486282e-24, -6.025248543236099e-27,
  8.646914432603259e-08, -1.980167971784807e-09,  5.369934997671107e-11, -1.063720857576747e-12,  1.968225180554724e-14, -3.319094474444752e-16,  4.988075657073720e-18,
 -7.716022753204535e-20,  1.033267210656706e-21, -1.304377552531061e-23,  1.968446716235209e-25, -1.942273806010978e-27,  4.430884154149450e-09, -1.255790243797820e-10,
  3.809790541436388e-12, -8.607796862411974e-14,  1.784892651390100e-15, -3.349168704877041e-17,  5.686440475824546e-19, -9.463860718291749e-21,  1.427486642937768e-22,
 -2.047049746261409e-24,  3.036849314899409e-26, -3.803515068779521e-28,  1.574502984428745e-10, -5.543070883626745e-12,  1.894487091448523e-13, -4.905016736553893e-15,
  1.144785797489490e-16, -2.403553036856775e-18,  4.596227291531195e-20, -8.378087974181265e-22,  1.413056056283142e-23, -2.264303607228627e-25,  3.551313572596999e-27,
 -5.133203827730499e-29,  3.740541898330527e-12, -1.647330658290622e-13,  6.412457963852388e-15, -1.915621311871099e-16,  5.068505344334333e-18, -1.199718162741897e-19,
  2.588972847608577e-21, -5.239257637345055e-23,  9.883697530472802e-25, -1.765653408795410e-26,  3.023690255019289e-28, -4.899056001850423e-30,  5.669069662487735e-14,
 -3.159944463214292e-15,  1.423104662158910e-16, -4.955710030101441e-18,  1.502691927876115e-19, -4.051814724760517e-21,  9.934205338534893e-23, -2.260455101936438e-24,
  4.797650340568933e-26, -9.603866935420476e-28,  1.827045850907619e-29, -3.305693298463069e-31,  5.158898092937569e-16, -3.707304290356878e-17,  1.975028136187460e-18,
 -8.142704880551401e-20,  2.875124511432470e-21, -8.962542876370105e-23,  2.527209417019510e-24, -6.561689260170646e-26,  1.584333305597769e-27, -3.591684988354248e-29,
  7.698010307381121e-31, -1.566665706044402e-32,  2.607500125251484e-18, -2.486514635164728e-19,  1.618167407565040e-20, -8.091184971858184e-22,  3.406857518865512e-23,
 -1.254788805437342e-24,  4.149092791456569e-26, -1.253735416303238e-27,  3.504188614970442e-29, -9.146433442941539e-31,  2.245740591686488e-32, -5.214331763231305e-34,
  6.670289262004908e-21, -8.837658592896066e-22,  7.375976016953925e-23, -4.649700963590805e-24,  2.421895935834249e-25, -1.089646452971236e-26,  4.355473990421430e-28,
 -1.576325340002738e-29,  5.236005746251199e-31, -1.612653022346802e-32,  4.642033064152833e-34, -1.255960829168785e-35,  8.140885401956631e-24, -1.613608204336827e-24,
  1.864952040019585e-25, -1.579704637024357e-26,  1.078590004514413e-27, -6.242672159139696e-29,  3.159930216348218e-30, -1.428710634935393e-31,  5.858168413373383e-33,
 -2.203371440034758e-34,  7.669702728865876e-36, -2.486223253048519e-37,  6.852193915225774e-27, -2.214516871882598e-27,  3.904771430433279e-28, -4.817551178084561e-29,
  4.616033013854894e-30, -3.636718455190084e-31,  2.441897779975012e-32, -1.432175551992441e-33,  7.469255690438311e-35, -3.511281326724117e-36,  1.503799468807558e-37,
 -5.910831908690939e-39,  8.468932140368399e-02, -2.969855232400950e-04,  1.065035604858704e-06, -4.227536649844197e-09,  1.846188686907421e-11,  2.338184653442968e-13,
  8.852536846787087e-15,  9.501162531937288e-17, -1.737131950984762e-18, -8.714447331455366e-20, -1.280204062349795e-21,  6.744329519466297e-24,  6.671006427103375e-02,
 -2.493847239798906e-04,  1.198165809572404e-06, -6.438291393671171e-09,  3.515296111789768e-11, -6.617494187893132e-14,  4.187867884232409e-15,  3.133245989488964e-17,
 -6.375000031880504e-19, -3.287793856674783e-20, -4.796663739938625e-22,  2.485819356692173e-24,  4.133580103264262e-02, -1.739188420521096e-04,  1.200277075392452e-06,
 -8.185678603965054e-09,  5.294587731647004e-11, -4.141525846935502e-13, -2.703679195188167e-16, -3.834891789136252e-17,  5.375807663016178e-19,  2.332090308621672e-20,
  3.521601234271082e-22, -1.906540301623269e-24,  2.009252591341035e-02, -9.898612574712546e-05,  9.332880199473098e-07, -7.481678656307439e-09,  5.590171229702632e-11,
 -5.608909027278953e-13, -1.348036728519967e-15, -6.726113902740608e-17,  9.919767819676427e-19,  4.224629898798483e-20,  6.386714180557626e-22, -3.378497825001559e-24,
  7.629044650545427e-03, -4.512689823613391e-05,  5.435596095374613e-07, -4.956551961408407e-09,  4.248946642540881e-11, -4.703754913094702e-13, -3.100125536270704e-16,
 -5.716338977525851e-17,  8.076392245252583e-19,  3.075533948901666e-20,  4.769177881272893e-22, -2.494787476414338e-24,  2.249470986469132e-03, -1.620013609347425e-05,
  2.362191204602397e-07, -2.423542055674693e-09,  2.372386599588791e-11, -2.793089203606890e-13,  5.272789354445859e-16, -3.384239447410370e-17,  4.486131318116728e-19,
  1.379946592560587e-20,  2.281214255459576e-22, -1.186699987111381e-24,  5.111137294086042e-04, -4.510981944833350e-06,  7.668192258545706e-08, -8.832950153984450e-10,
  9.820177119801924e-12, -1.222660773328520e-13,  5.560171684218922e-16, -1.528255743542459e-17,  1.909988841268904e-19,  4.025458167213063e-21,  7.772355259951753e-23,
 -4.099499583866586e-25,  8.861686765473611e-05, -9.607144999040780e-07,  1.857577280127770e-08, -2.405132963923637e-10,  3.020038144305955e-12, -3.994999410689850e-14,
  2.830641694824850e-16, -5.404578429048533e-18,  6.547895262986143e-20,  6.976685813895805e-22,  2.012956910282804e-23, -1.134049701057822e-25,  1.158045205604084e-05,
 -1.542726332253378e-07,  3.342293087197749e-09, -4.875482162085303e-11,  6.881420199113334e-13, -9.748548396884898e-15,  9.205977967068770e-17, -1.491706885768030e-18,
  1.822071477815213e-20,  2.839642792397872e-23,  4.252217814839013e-24, -2.797500382649634e-26,  1.123247518757696e-06, -1.838689181686649e-08,  4.427760242987652e-10,
 -7.296842003137875e-12,  1.153856025826625e-13, -1.765638808644246e-15,  2.056259838268744e-17, -3.158965334171170e-19,  4.032077095902300e-21, -2.072769844838544e-23,
  7.848094890649771e-25, -6.474741107088548e-27,  7.933376118172696e-08, -1.596743835674908e-09,  4.262434887298458e-11, -7.960782886232165e-13,  1.408385558777089e-14,
 -2.347685493545726e-16,  3.229850354314039e-18, -5.023967799954009e-20,  6.872840256722641e-22, -6.623370933225383e-24,  1.286781304954047e-25, -1.323917135603656e-27,
  3.983606625910256e-09, -9.879345393022316e-11,  2.928276484753207e-12, -6.221844928854230e-14,  1.232476301202150e-15, -2.256835918483257e-17,  3.580291382915749e-19,
 -5.869580523388531e-21,  8.743906734995295e-23, -1.108508865186314e-24,  1.774315595603737e-26, -2.167803785477531e-28,  1.379760023474577e-10, -4.235084020877970e-12,
  1.401664788685961e-13, -3.405137437661418e-15,  7.577367187613400e-17, -1.537516939321840e-18,  2.778128615544276e-20, -4.925084627680352e-22,  8.073284834496350e-24,
 -1.208798737276555e-25,  1.905215205618122e-27, -2.656102911912946e-29,  3.171381016084350e-12, -1.214124133146214e-13,  4.530820370926836e-15, -1.267267714190847e-16,
  3.187847945249452e-18, -7.237965907678804e-20,  1.483697914836965e-21, -2.896527432425557e-23,  5.269656192295563e-25, -8.973792310269577e-27,  1.501871357566032e-28,
 -2.345440947339552e-30,  4.600177929649452e-14, -2.223874172715528e-15,  9.496112347145170e-17, -3.088914296271920e-18,  8.872563026067748e-20, -2.281163347431312e-21,
  5.320702135766116e-23, -1.161585375547238e-24,  2.367641798887683e-26, -4.544146510150166e-28,  8.358201424342910e-30, -1.457688583832168e-31,  3.939577022081376e-16,
 -2.451683255895734e-17,  1.223949313947348e-18, -4.700469744498000e-20,  1.565543787798336e-21, -4.630219333613250e-23,  1.240996574611378e-24, -3.079202440679454e-26,
  7.119980487368016e-28, -1.548227735567546e-29,  3.194207790136949e-31, -6.262187114484558e-33,  1.821255952935688e-18, -1.503760609834074e-19,  9.062065771359285e-21,
 -4.206757436686637e-22,  1.663235847710422e-23, -5.787317232994132e-25,  1.815207838521006e-26, -5.225857002166473e-28,  1.395769434405586e-29, -3.490634056564201e-31,
  8.233480170001160e-33, -1.840131021816863e-34,  4.037049346171692e-21, -4.644977401728590e-22,  3.552079793320171e-23, -2.071945994273731e-24,  1.009422713497767e-25,
 -4.277250076322351e-27,  1.618778769645454e-28, -5.572378273894692e-30,  1.766999710233233e-31, -5.212071838548515e-33,  1.440914887061079e-34, -3.753696451389105e-36,
  3.785887982512863e-24, -6.601231749211585e-25,  6.965261820930877e-26, -5.462971231712494e-27,  3.490738115958816e-28, -1.905452688077293e-29,  9.152308717835124e-31,
 -3.946479446133409e-32,  1.549811068358469e-33, -5.603229800587370e-35,  1.880806552406861e-36, -5.896057615332871e-38,  1.820835237256158e-27, -5.455993212750949e-28,
  9.047842264085159e-29, -1.060899963558571e-29,  9.737397270277954e-31, -7.393737920188352e-32,  4.808177174533196e-33, -2.742052645579624e-34,  1.395138368042193e-35,
 -6.416113320379756e-37,  2.694562265669582e-38, -1.040720993389087e-39,  };
  int offset = -20;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 20;
    if (std::isnan(t)) {
      fill_n(rr+offset, 20, 0.5);
      fill_n(ww+offset, 20, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 20; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=20; ++j) {
        const int boxof = it*240+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
