/* Copyright (C) 2013-2016, The Regents of The University of Michigan.
All rights reserved.
This software was developed in the APRIL Robotics Lab under the
direction of Edwin Olson, ebolson@umich.edu. This software may be
available under alternative licensing terms; contact the address above.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the Regents of The University of Michigan.
*/

#include <stdlib.h>
#include "apriltag.h"

apriltag_family_t *tagCircle49h12_create()
{
   apriltag_family_t *tf = calloc(1, sizeof(apriltag_family_t));
   tf->name = strdup("tagCircle49h12");
   tf->h = 12;
   tf->ncodes = 65698;
   tf->codes = calloc(65698, sizeof(uint64_t));
   tf->codes[0] = 0x0000c6c921d8614aUL;
   tf->codes[1] = 0x0000c6c95c67670fUL;
   tf->codes[2] = 0x0000c6c996f66cd4UL;
   tf->codes[3] = 0x0000c6c9d1857299UL;
   tf->codes[4] = 0x0000c6ca813283e8UL;
   tf->codes[5] = 0x0000c6cabbc189adUL;
   tf->codes[6] = 0x0000c6caf6508f72UL;
   tf->codes[7] = 0x0000c6cb30df9537UL;
   tf->codes[8] = 0x0000c6cb6b6e9afcUL;
   tf->codes[9] = 0x0000c6cba5fda0c1UL;
   tf->codes[10] = 0x0000c6cbe08ca686UL;
   tf->codes[11] = 0x0000c6cc1b1bac4bUL;
   tf->codes[12] = 0x0000c6cc55aab210UL;
   tf->codes[13] = 0x0000c6cc9039b7d5UL;
   tf->codes[14] = 0x0000c6cccac8bd9aUL;
   tf->codes[15] = 0x0000c6cd0557c35fUL;
   tf->codes[16] = 0x0000c6cd3fe6c924UL;
   tf->codes[17] = 0x0000c6cd7a75cee9UL;
   tf->codes[18] = 0x0000c6cdb504d4aeUL;
   tf->codes[19] = 0x0000c6cdef93da73UL;
   tf->codes[20] = 0x0000c6ce2a22e038UL;
   tf->codes[21] = 0x0000c6ce64b1e5fdUL;
   tf->codes[22] = 0x0000c6ce9f40ebc2UL;
   tf->codes[23] = 0x0000c6cf4eedfd11UL;
   tf->codes[24] = 0x0000c6cf897d02d6UL;
   tf->codes[25] = 0x0000c6cfc40c089bUL;
   tf->codes[26] = 0x0000c6d0392a1425UL;
   tf->codes[27] = 0x0000c6d073b919eaUL;
   tf->codes[28] = 0x0000c6d0ae481fafUL;
   tf->codes[29] = 0x0000c6d0e8d72574UL;
   tf->codes[30] = 0x0000c6d123662b39UL;
   tf->codes[31] = 0x0000c6d15df530feUL;
   tf->codes[32] = 0x0000c6d1988436c3UL;
   tf->codes[33] = 0x0000c6d1d3133c88UL;
   tf->codes[34] = 0x0000c6d20da2424dUL;
   tf->codes[35] = 0x0000c6d248314812UL;
   tf->codes[36] = 0x0000c6d2bd4f539cUL;
   tf->codes[37] = 0x0000c6d2f7de5961UL;
   tf->codes[38] = 0x0000c6d3326d5f26UL;
   tf->codes[39] = 0x0000c6d36cfc64ebUL;
   tf->codes[40] = 0x0000c6d3a78b6ab0UL;
   tf->codes[41] = 0x0000c6d3e21a7075UL;
   tf->codes[42] = 0x0000c6d41ca9763aUL;
   tf->codes[43] = 0x0000c6d491c781c4UL;
   tf->codes[44] = 0x0000c6d4cc568789UL;
   tf->codes[45] = 0x0000c6d506e58d4eUL;
   tf->codes[46] = 0x0000c6d541749313UL;
   tf->codes[47] = 0x0000c6d57c0398d8UL;
   tf->codes[48] = 0x0000c6d5b6929e9dUL;
   tf->codes[49] = 0x0000c6d5f121a462UL;
   tf->codes[50] = 0x0000c6d62bb0aa27UL;
   tf->codes[51] = 0x0000c6d6663fafecUL;
   tf->codes[52] = 0x0000c6d6a0ceb5b1UL;
   tf->codes[53] = 0x0000c6d6db5dbb76UL;
   tf->codes[54] = 0x0000c6d715ecc13bUL;
   tf->codes[55] = 0x0000c6d7507bc700UL;
   tf->codes[56] = 0x0000c6d78b0accc5UL;
   tf->codes[57] = 0x0000c6d7c599d28aUL;
   tf->codes[58] = 0x0000c6d83ab7de14UL;
   tf->codes[59] = 0x0000c6d87546e3d9UL;
   tf->codes[60] = 0x0000c6d8afd5e99eUL;
   tf->codes[61] = 0x0000c6d8ea64ef63UL;
   tf->codes[62] = 0x0000c6d924f3f528UL;
   tf->codes[63] = 0x0000c6d95f82faedUL;
   tf->codes[64] = 0x0000c6d99a1200b2UL;
   tf->codes[65] = 0x0000c6d9d4a10677UL;
   tf->codes[66] = 0x0000c6da49bf1201UL;
   tf->codes[67] = 0x0000c6da844e17c6UL;
   tf->codes[68] = 0x0000c6daf96c2350UL;
   tf->codes[69] = 0x0000c6db33fb2915UL;
   tf->codes[70] = 0x0000c6db6e8a2edaUL;
   tf->codes[71] = 0x0000c6dba919349fUL;
   tf->codes[72] = 0x0000c6dc1e374029UL;
   tf->codes[73] = 0x0000c6dc58c645eeUL;
   tf->codes[74] = 0x0000c6dc93554bb3UL;
   tf->codes[75] = 0x0000c6dccde45178UL;
   tf->codes[76] = 0x0000c6dd7d9162c7UL;
   tf->codes[77] = 0x0000c6ddf2af6e51UL;
   tf->codes[78] = 0x0000c6de2d3e7416UL;
   tf->codes[79] = 0x0000c6dedceb8565UL;
   tf->codes[80] = 0x0000c6df520990efUL;
   tf->codes[81] = 0x0000c6df8c9896b4UL;
   tf->codes[82] = 0x0000c6dfc7279c79UL;
   tf->codes[83] = 0x0000c6e076d4adc8UL;
   tf->codes[84] = 0x0000c6e0b163b38dUL;
   tf->codes[85] = 0x0000c6e0ebf2b952UL;
   tf->codes[86] = 0x0000c6e16110c4dcUL;
   tf->codes[87] = 0x0000c6e19b9fcaa1UL;
   tf->codes[88] = 0x0000c6e1d62ed066UL;
   tf->codes[89] = 0x0000c6e210bdd62bUL;
   tf->codes[90] = 0x0000c6e285dbe1b5UL;
   tf->codes[91] = 0x0000c6e2c06ae77aUL;
   tf->codes[92] = 0x0000c6e2faf9ed3fUL;
   tf->codes[93] = 0x0000c6e37017f8c9UL;
   tf->codes[94] = 0x0000c6e3aaa6fe8eUL;
   tf->codes[95] = 0x0000c6e3e5360453UL;
   tf->codes[96] = 0x0000c6e494e315a2UL;
   tf->codes[97] = 0x0000c6e50a01212cUL;
   tf->codes[98] = 0x0000c6e5449026f1UL;
   tf->codes[99] = 0x0000c6e57f1f2cb6UL;
   tf->codes[100] = 0x0000c6e5b9ae327bUL;
   tf->codes[101] = 0x0000c6e5f43d3840UL;
   tf->codes[102] = 0x0000c6e6695b43caUL;
   tf->codes[103] = 0x0000c6e6a3ea498fUL;
   tf->codes[104] = 0x0000c6e6de794f54UL;
   tf->codes[105] = 0x0000c6e719085519UL;
   tf->codes[106] = 0x0000c6e753975adeUL;
   tf->codes[107] = 0x0000c6e7c8b56668UL;
   tf->codes[108] = 0x0000c6e83dd371f2UL;
   tf->codes[109] = 0x0000c6e8ed808341UL;
   tf->codes[110] = 0x0000c6e9280f8906UL;
   tf->codes[111] = 0x0000c6e99d2d9490UL;
   tf->codes[112] = 0x0000c6e9d7bc9a55UL;
   tf->codes[113] = 0x0000c6ea124ba01aUL;
   tf->codes[114] = 0x0000c6ea4cdaa5dfUL;
   tf->codes[115] = 0x0000c6eafc87b72eUL;
   tf->codes[116] = 0x0000c6eb3716bcf3UL;
   tf->codes[117] = 0x0000c6ebac34c87dUL;
   tf->codes[118] = 0x0000c6ec5be1d9ccUL;
   tf->codes[119] = 0x0000c6ecd0ffe556UL;
   tf->codes[120] = 0x0000c6ed0b8eeb1bUL;
   tf->codes[121] = 0x0000c6edf5cb022fUL;
   tf->codes[122] = 0x0000c6ee305a07f4UL;
   tf->codes[123] = 0x0000c6eee0071943UL;
   tf->codes[124] = 0x0000c6ef1a961f08UL;
   tf->codes[125] = 0x0000c6ef552524cdUL;
   tf->codes[126] = 0x0000c6f03f613be1UL;
   tf->codes[127] = 0x0000c6f079f041a6UL;
   tf->codes[128] = 0x0000c6f0b47f476bUL;
   tf->codes[129] = 0x0000c6f0ef0e4d30UL;
   tf->codes[130] = 0x0000c6f1299d52f5UL;
   tf->codes[131] = 0x0000c6f1642c58baUL;
   tf->codes[132] = 0x0000c6f19ebb5e7fUL;
   tf->codes[133] = 0x0000c6f1d94a6444UL;
   tf->codes[134] = 0x0000c6f213d96a09UL;
   tf->codes[135] = 0x0000c6f288f77593UL;
   tf->codes[136] = 0x0000c6f2c3867b58UL;
   tf->codes[137] = 0x0000c6f2fe15811dUL;
   tf->codes[138] = 0x0000c6f373338ca7UL;
   tf->codes[139] = 0x0000c6f3e8519831UL;
   tf->codes[140] = 0x0000c6f45d6fa3bbUL;
   tf->codes[141] = 0x0000c6f50d1cb50aUL;
   tf->codes[142] = 0x0000c6f5bcc9c659UL;
   tf->codes[143] = 0x0000c6f6e194e332UL;
   tf->codes[144] = 0x0000c6f79141f481UL;
   tf->codes[145] = 0x0000c6f8b60d115aUL;
   tf->codes[146] = 0x0000c6f965ba22a9UL;
   tf->codes[147] = 0x0000c6f9dad82e33UL;
   tf->codes[148] = 0x0000c6fa4ff639bdUL;
   tf->codes[149] = 0x0000c6faffa34b0cUL;
   tf->codes[150] = 0x0000c6fb74c15696UL;
   tf->codes[151] = 0x0000c6fbaf505c5bUL;
   tf->codes[152] = 0x0000c6fc5efd6daaUL;
   tf->codes[153] = 0x0000c6fcd41b7934UL;
   tf->codes[154] = 0x0000c6fd493984beUL;
   tf->codes[155] = 0x0000c6fd83c88a83UL;
   tf->codes[156] = 0x0000c6fee322ad21UL;
   tf->codes[157] = 0x0000c6ffcd5ec435UL;
   tf->codes[158] = 0x0000c700427ccfbfUL;
   tf->codes[159] = 0x0000c7007d0bd584UL;
   tf->codes[160] = 0x0000c700b79adb49UL;
   tf->codes[161] = 0x0000c7012cb8e6d3UL;
   tf->codes[162] = 0x0000c7016747ec98UL;
   tf->codes[163] = 0x0000c701a1d6f25dUL;
   tf->codes[164] = 0x0000c701dc65f822UL;
   tf->codes[165] = 0x0000c702518403acUL;
   tf->codes[166] = 0x0000c7028c130971UL;
   tf->codes[167] = 0x0000c702c6a20f36UL;
   tf->codes[168] = 0x0000c703013114fbUL;
   tf->codes[169] = 0x0000c703764f2085UL;
   tf->codes[170] = 0x0000c703b0de264aUL;
   tf->codes[171] = 0x0000c703eb6d2c0fUL;
   tf->codes[172] = 0x0000c704608b3799UL;
   tf->codes[173] = 0x0000c7049b1a3d5eUL;
   tf->codes[174] = 0x0000c704d5a94323UL;
   tf->codes[175] = 0x0000c705103848e8UL;
   tf->codes[176] = 0x0000c7054ac74eadUL;
   tf->codes[177] = 0x0000c70585565472UL;
   tf->codes[178] = 0x0000c705bfe55a37UL;
   tf->codes[179] = 0x0000c705fa745ffcUL;
   tf->codes[180] = 0x0000c7066f926b86UL;
   tf->codes[181] = 0x0000c706aa21714bUL;
   tf->codes[182] = 0x0000c706e4b07710UL;
   tf->codes[183] = 0x0000c7071f3f7cd5UL;
   tf->codes[184] = 0x0000c70759ce829aUL;
   tf->codes[185] = 0x0000c707945d885fUL;
   tf->codes[186] = 0x0000c708440a99aeUL;
   tf->codes[187] = 0x0000c7087e999f73UL;
   tf->codes[188] = 0x0000c708b928a538UL;
   tf->codes[189] = 0x0000c708f3b7aafdUL;
   tf->codes[190] = 0x0000c7092e46b0c2UL;
   tf->codes[191] = 0x0000c70968d5b687UL;
   tf->codes[192] = 0x0000c709ddf3c211UL;
   tf->codes[193] = 0x0000c70a1882c7d6UL;
   tf->codes[194] = 0x0000c70a5311cd9bUL;
   tf->codes[195] = 0x0000c70a8da0d360UL;
   tf->codes[196] = 0x0000c70ac82fd925UL;
   tf->codes[197] = 0x0000c70b02bedeeaUL;
   tf->codes[198] = 0x0000c70b3d4de4afUL;
   tf->codes[199] = 0x0000c70b77dcea74UL;
   tf->codes[200] = 0x0000c70bb26bf039UL;
   tf->codes[201] = 0x0000c70becfaf5feUL;
   tf->codes[202] = 0x0000c70c9ca8074dUL;
   tf->codes[203] = 0x0000c70cd7370d12UL;
   tf->codes[204] = 0x0000c70d4c55189cUL;
   tf->codes[205] = 0x0000c70d86e41e61UL;
   tf->codes[206] = 0x0000c70dc1732426UL;
   tf->codes[207] = 0x0000c70dfc0229ebUL;
   tf->codes[208] = 0x0000c70e36912fb0UL;
   tf->codes[209] = 0x0000c70e71203575UL;
   tf->codes[210] = 0x0000c70eabaf3b3aUL;
   tf->codes[211] = 0x0000c70ee63e40ffUL;
   tf->codes[212] = 0x0000c70f20cd46c4UL;
   tf->codes[213] = 0x0000c70f95eb524eUL;
   tf->codes[214] = 0x0000c70fd07a5813UL;
   tf->codes[215] = 0x0000c71080276962UL;
   tf->codes[216] = 0x0000c710bab66f27UL;
   tf->codes[217] = 0x0000c710f54574ecUL;
   tf->codes[218] = 0x0000c7116a638076UL;
   tf->codes[219] = 0x0000c711a4f2863bUL;
   tf->codes[220] = 0x0000c7121a1091c5UL;
   tf->codes[221] = 0x0000c712549f978aUL;
   tf->codes[222] = 0x0000c7128f2e9d4fUL;
   tf->codes[223] = 0x0000c712c9bda314UL;
   tf->codes[224] = 0x0000c7133edbae9eUL;
   tf->codes[225] = 0x0000c713796ab463UL;
   tf->codes[226] = 0x0000c713ee88bfedUL;
   tf->codes[227] = 0x0000c7142917c5b2UL;
   tf->codes[228] = 0x0000c71463a6cb77UL;
   tf->codes[229] = 0x0000c7149e35d13cUL;
   tf->codes[230] = 0x0000c714d8c4d701UL;
   tf->codes[231] = 0x0000c7151353dcc6UL;
   tf->codes[232] = 0x0000c7158871e850UL;
   tf->codes[233] = 0x0000c715fd8ff3daUL;
   tf->codes[234] = 0x0000c716381ef99fUL;
   tf->codes[235] = 0x0000c71672adff64UL;
   tf->codes[236] = 0x0000c716ad3d0529UL;
   tf->codes[237] = 0x0000c716e7cc0aeeUL;
   tf->codes[238] = 0x0000c717225b10b3UL;
   tf->codes[239] = 0x0000c7175cea1678UL;
   tf->codes[240] = 0x0000c717d2082202UL;
   tf->codes[241] = 0x0000c71847262d8cUL;
   tf->codes[242] = 0x0000c718bc443916UL;
   tf->codes[243] = 0x0000c718f6d33edbUL;
   tf->codes[244] = 0x0000c719316244a0UL;
   tf->codes[245] = 0x0000c7196bf14a65UL;
   tf->codes[246] = 0x0000c71a1b9e5bb4UL;
   tf->codes[247] = 0x0000c71a562d6179UL;
   tf->codes[248] = 0x0000c71b4069788dUL;
   tf->codes[249] = 0x0000c71b7af87e52UL;
   tf->codes[250] = 0x0000c71bb5878417UL;
   tf->codes[251] = 0x0000c71bf01689dcUL;
   tf->codes[252] = 0x0000c71c2aa58fa1UL;
   tf->codes[253] = 0x0000c71c9fc39b2bUL;
   tf->codes[254] = 0x0000c71d14e1a6b5UL;
   tf->codes[255] = 0x0000c71d4f70ac7aUL;
   tf->codes[256] = 0x0000c71d89ffb23fUL;
   tf->codes[257] = 0x0000c71dff1dbdc9UL;
   tf->codes[258] = 0x0000c71e39acc38eUL;
   tf->codes[259] = 0x0000c71eaecacf18UL;
   tf->codes[260] = 0x0000c71ee959d4ddUL;
   tf->codes[261] = 0x0000c71f9906e62cUL;
   tf->codes[262] = 0x0000c7208342fd40UL;
   tf->codes[263] = 0x0000c720bdd20305UL;
   tf->codes[264] = 0x0000c720f86108caUL;
   tf->codes[265] = 0x0000c72132f00e8fUL;
   tf->codes[266] = 0x0000c7216d7f1454UL;
   tf->codes[267] = 0x0000c721a80e1a19UL;
   tf->codes[268] = 0x0000c721e29d1fdeUL;
   tf->codes[269] = 0x0000c7221d2c25a3UL;
   tf->codes[270] = 0x0000c72257bb2b68UL;
   tf->codes[271] = 0x0000c722ccd936f2UL;
   tf->codes[272] = 0x0000c72341f7427cUL;
   tf->codes[273] = 0x0000c7237c864841UL;
   tf->codes[274] = 0x0000c723b7154e06UL;
   tf->codes[275] = 0x0000c723f1a453cbUL;
   tf->codes[276] = 0x0000c7242c335990UL;
   tf->codes[277] = 0x0000c724a151651aUL;
   tf->codes[278] = 0x0000c724dbe06adfUL;
   tf->codes[279] = 0x0000c7258b8d7c2eUL;
   tf->codes[280] = 0x0000c725c61c81f3UL;
   tf->codes[281] = 0x0000c72675c99342UL;
   tf->codes[282] = 0x0000c726eae79eccUL;
   tf->codes[283] = 0x0000c7272576a491UL;
   tf->codes[284] = 0x0000c7276005aa56UL;
   tf->codes[285] = 0x0000c7279a94b01bUL;
   tf->codes[286] = 0x0000c727d523b5e0UL;
   tf->codes[287] = 0x0000c7280fb2bba5UL;
   tf->codes[288] = 0x0000c7284a41c16aUL;
   tf->codes[289] = 0x0000c728bf5fccf4UL;
   tf->codes[290] = 0x0000c728f9eed2b9UL;
   tf->codes[291] = 0x0000c7296f0cde43UL;
   tf->codes[292] = 0x0000c729a99be408UL;
   tf->codes[293] = 0x0000c72a93d7fb1cUL;
   tf->codes[294] = 0x0000c72ace6700e1UL;
   tf->codes[295] = 0x0000c72b08f606a6UL;
   tf->codes[296] = 0x0000c72b7e141230UL;
   tf->codes[297] = 0x0000c72bb8a317f5UL;
   tf->codes[298] = 0x0000c72bf3321dbaUL;
   tf->codes[299] = 0x0000c72cdd6e34ceUL;
   tf->codes[300] = 0x0000c72d17fd3a93UL;
   tf->codes[301] = 0x0000c72d528c4058UL;
   tf->codes[302] = 0x0000c72e023951a7UL;
   tf->codes[303] = 0x0000c72eb1e662f6UL;
   tf->codes[304] = 0x0000c72f61937445UL;
   tf->codes[305] = 0x0000c73011408594UL;
   tf->codes[306] = 0x0000c7304bcf8b59UL;
   tf->codes[307] = 0x0000c730865e911eUL;
   tf->codes[308] = 0x0000c730fb7c9ca8UL;
   tf->codes[309] = 0x0000c731360ba26dUL;
   tf->codes[310] = 0x0000c731709aa832UL;
   tf->codes[311] = 0x0000c731ab29adf7UL;
   tf->codes[312] = 0x0000c731e5b8b3bcUL;
   tf->codes[313] = 0x0000c7322047b981UL;
   tf->codes[314] = 0x0000c7325ad6bf46UL;
   tf->codes[315] = 0x0000c7329565c50bUL;
   tf->codes[316] = 0x0000c732cff4cad0UL;
   tf->codes[317] = 0x0000c7334512d65aUL;
   tf->codes[318] = 0x0000c7337fa1dc1fUL;
   tf->codes[319] = 0x0000c7342f4eed6eUL;
   tf->codes[320] = 0x0000c734a46cf8f8UL;
   tf->codes[321] = 0x0000c734defbfebdUL;
   tf->codes[322] = 0x0000c735198b0482UL;
   tf->codes[323] = 0x0000c735541a0a47UL;
   tf->codes[324] = 0x0000c735c93815d1UL;
   tf->codes[325] = 0x0000c73603c71b96UL;
   tf->codes[326] = 0x0000c7363e56215bUL;
   tf->codes[327] = 0x0000c736b3742ce5UL;
   tf->codes[328] = 0x0000c736ee0332aaUL;
   tf->codes[329] = 0x0000c7379db043f9UL;
   tf->codes[330] = 0x0000c737d83f49beUL;
   tf->codes[331] = 0x0000c73812ce4f83UL;
   tf->codes[332] = 0x0000c738c27b60d2UL;
   tf->codes[333] = 0x0000c738fd0a6697UL;
   tf->codes[334] = 0x0000c73937996c5cUL;
   tf->codes[335] = 0x0000c73972287221UL;
   tf->codes[336] = 0x0000c739e7467dabUL;
   tf->codes[337] = 0x0000c73a21d58370UL;
   tf->codes[338] = 0x0000c73a5c648935UL;
   tf->codes[339] = 0x0000c73bbbbeabd3UL;
   tf->codes[340] = 0x0000c73bf64db198UL;
   tf->codes[341] = 0x0000c73ce089c8acUL;
   tf->codes[342] = 0x0000c73d1b18ce71UL;
   tf->codes[343] = 0x0000c73eb501f6d4UL;
   tf->codes[344] = 0x0000c73f2a20025eUL;
   tf->codes[345] = 0x0000c73f64af0823UL;
   tf->codes[346] = 0x0000c73f9f3e0de8UL;
   tf->codes[347] = 0x0000c73fd9cd13adUL;
   tf->codes[348] = 0x0000c740145c1972UL;
   tf->codes[349] = 0x0000c740897a24fcUL;
   tf->codes[350] = 0x0000c740c4092ac1UL;
   tf->codes[351] = 0x0000c74173b63c10UL;
   tf->codes[352] = 0x0000c741ae4541d5UL;
   tf->codes[353] = 0x0000c741e8d4479aUL;
   tf->codes[354] = 0x0000c74223634d5fUL;
   tf->codes[355] = 0x0000c742988158e9UL;
   tf->codes[356] = 0x0000c742d3105eaeUL;
   tf->codes[357] = 0x0000c743482e6a38UL;
   tf->codes[358] = 0x0000c74382bd6ffdUL;
   tf->codes[359] = 0x0000c743bd4c75c2UL;
   tf->codes[360] = 0x0000c744326a814cUL;
   tf->codes[361] = 0x0000c7446cf98711UL;
   tf->codes[362] = 0x0000c744a7888cd6UL;
   tf->codes[363] = 0x0000c7451ca69860UL;
   tf->codes[364] = 0x0000c74557359e25UL;
   tf->codes[365] = 0x0000c74591c4a3eaUL;
   tf->codes[366] = 0x0000c746b68fc0c3UL;
   tf->codes[367] = 0x0000c746f11ec688UL;
   tf->codes[368] = 0x0000c747663cd212UL;
   tf->codes[369] = 0x0000c7485078e926UL;
   tf->codes[370] = 0x0000c7488b07eeebUL;
   tf->codes[371] = 0x0000c7490025fa75UL;
   tf->codes[372] = 0x0000c7493ab5003aUL;
   tf->codes[373] = 0x0000c749754405ffUL;
   tf->codes[374] = 0x0000c749ea621189UL;
   tf->codes[375] = 0x0000c74a9a0f22d8UL;
   tf->codes[376] = 0x0000c74b0f2d2e62UL;
   tf->codes[377] = 0x0000c74bf9694576UL;
   tf->codes[378] = 0x0000c74c33f84b3bUL;
   tf->codes[379] = 0x0000c74ca91656c5UL;
   tf->codes[380] = 0x0000c74ce3a55c8aUL;
   tf->codes[381] = 0x0000c74d93526dd9UL;
   tf->codes[382] = 0x0000c74dcde1739eUL;
   tf->codes[383] = 0x0000c74e42ff7f28UL;
   tf->codes[384] = 0x0000c74e7d8e84edUL;
   tf->codes[385] = 0x0000c74eb81d8ab2UL;
   tf->codes[386] = 0x0000c74f2d3b963cUL;
   tf->codes[387] = 0x0000c74f67ca9c01UL;
   tf->codes[388] = 0x0000c74fa259a1c6UL;
   tf->codes[389] = 0x0000c7505206b315UL;
   tf->codes[390] = 0x0000c7508c95b8daUL;
   tf->codes[391] = 0x0000c75101b3c464UL;
   tf->codes[392] = 0x0000c7513c42ca29UL;
   tf->codes[393] = 0x0000c75176d1cfeeUL;
   tf->codes[394] = 0x0000c752267ee13dUL;
   tf->codes[395] = 0x0000c752610de702UL;
   tf->codes[396] = 0x0000c752d62bf28cUL;
   tf->codes[397] = 0x0000c75310baf851UL;
   tf->codes[398] = 0x0000c75385d903dbUL;
   tf->codes[399] = 0x0000c753c06809a0UL;
   tf->codes[400] = 0x0000c7543586152aUL;
   tf->codes[401] = 0x0000c75470151aefUL;
   tf->codes[402] = 0x0000c754aaa420b4UL;
   tf->codes[403] = 0x0000c754e5332679UL;
   tf->codes[404] = 0x0000c75609fe4352UL;
   tf->codes[405] = 0x0000c756448d4917UL;
   tf->codes[406] = 0x0000c7572ec9602bUL;
   tf->codes[407] = 0x0000c757695865f0UL;
   tf->codes[408] = 0x0000c758c8b2888eUL;
   tf->codes[409] = 0x0000c75903418e53UL;
   tf->codes[410] = 0x0000c7593dd09418UL;
   tf->codes[411] = 0x0000c75a280cab2cUL;
   tf->codes[412] = 0x0000c75b4cd7c805UL;
   tf->codes[413] = 0x0000c75d966e01b7UL;
   tf->codes[414] = 0x0000c75dd0fd077cUL;
   tf->codes[415] = 0x0000c75e0b8c0d41UL;
   tf->codes[416] = 0x0000c75f30572a1aUL;
   tf->codes[417] = 0x0000c75fa57535a4UL;
   tf->codes[418] = 0x0000c760552246f3UL;
   tf->codes[419] = 0x0000c76179ed63ccUL;
   tf->codes[420] = 0x0000c761b47c6991UL;
   tf->codes[421] = 0x0000c761ef0b6f56UL;
   tf->codes[422] = 0x0000c7629eb880a5UL;
   tf->codes[423] = 0x0000c762d947866aUL;
   tf->codes[424] = 0x0000c763c3839d7eUL;
   tf->codes[425] = 0x0000c763fe12a343UL;
   tf->codes[426] = 0x0000c76438a1a908UL;
   tf->codes[427] = 0x0000c764adbfb492UL;
   tf->codes[428] = 0x0000c76597fbcba6UL;
   tf->codes[429] = 0x0000c7668237e2baUL;
   tf->codes[430] = 0x0000c768913f16a7UL;
   tf->codes[431] = 0x0000c769b60a3380UL;
   tf->codes[432] = 0x0000c76b1564561eUL;
   tf->codes[433] = 0x0000c76b8a8261a8UL;
   tf->codes[434] = 0x0000c76bc511676dUL;
   tf->codes[435] = 0x0000c76caf4d7e81UL;
   tf->codes[436] = 0x0000c76d5efa8fd0UL;
   tf->codes[437] = 0x0000c76dd4189b5aUL;
   tf->codes[438] = 0x0000c76ebe54b26eUL;
   tf->codes[439] = 0x0000c76ef8e3b833UL;
   tf->codes[440] = 0x0000c770583ddad1UL;
   tf->codes[441] = 0x0000c7714279f1e5UL;
   tf->codes[442] = 0x0000c7717d08f7aaUL;
   tf->codes[443] = 0x0000c7722cb608f9UL;
   tf->codes[444] = 0x0000c772a1d41483UL;
   tf->codes[445] = 0x0000c774012e3721UL;
   tf->codes[446] = 0x0000c774764c42abUL;
   tf->codes[447] = 0x0000c774b0db4870UL;
   tf->codes[448] = 0x0000c775d5a66549UL;
   tf->codes[449] = 0x0000c7764ac470d3UL;
   tf->codes[450] = 0x0000c776fa718222UL;
   tf->codes[451] = 0x0000c777aa1e9371UL;
   tf->codes[452] = 0x0000c778945aaa85UL;
   tf->codes[453] = 0x0000c778cee9b04aUL;
   tf->codes[454] = 0x0000c7797e96c199UL;
   tf->codes[455] = 0x0000c779f3b4cd23UL;
   tf->codes[456] = 0x0000c77bc82cfb4bUL;
   tf->codes[457] = 0x0000c77c77da0c9aUL;
   tf->codes[458] = 0x0000c77d621623aeUL;
   tf->codes[459] = 0x0000c77d9ca52973UL;
   tf->codes[460] = 0x0000c77e11c334fdUL;
   tf->codes[461] = 0x0000c77e4c523ac2UL;
   tf->codes[462] = 0x0000c77f368e51d6UL;
   tf->codes[463] = 0x0000c77f711d579bUL;
   tf->codes[464] = 0x0000c780d0777a39UL;
   tf->codes[465] = 0x0000c781459585c3UL;
   tf->codes[466] = 0x0000c78180248b88UL;
   tf->codes[467] = 0x0000c781bab3914dUL;
   tf->codes[468] = 0x0000c7822fd19cd7UL;
   tf->codes[469] = 0x0000c7826a60a29cUL;
   tf->codes[470] = 0x0000c782df7eae26UL;
   tf->codes[471] = 0x0000c7831a0db3ebUL;
   tf->codes[472] = 0x0000c783549cb9b0UL;
   tf->codes[473] = 0x0000c7859e32f362UL;
   tf->codes[474] = 0x0000c78772ab218aUL;
   tf->codes[475] = 0x0000c787ad3a274fUL;
   tf->codes[476] = 0x0000c787e7c92d14UL;
   tf->codes[477] = 0x0000c788225832d9UL;
   tf->codes[478] = 0x0000c788d2054428UL;
   tf->codes[479] = 0x0000c7890c9449edUL;
   tf->codes[480] = 0x0000c78ae10c7815UL;
   tf->codes[481] = 0x0000c78b562a839fUL;
   tf->codes[482] = 0x0000c78b90b98964UL;
   tf->codes[483] = 0x0000c78bcb488f29UL;
   tf->codes[484] = 0x0000c78c05d794eeUL;
   tf->codes[485] = 0x0000c78c40669ab3UL;
   tf->codes[486] = 0x0000c78cb584a63dUL;
   tf->codes[487] = 0x0000c78d6531b78cUL;
   tf->codes[488] = 0x0000c78d9fc0bd51UL;
   tf->codes[489] = 0x0000c78dda4fc316UL;
   tf->codes[490] = 0x0000c78e89fcd465UL;
   tf->codes[491] = 0x0000c78eff1adfefUL;
   tf->codes[492] = 0x0000c78f7438eb79UL;
   tf->codes[493] = 0x0000c7905e75028dUL;
   tf->codes[494] = 0x0000c790d3930e17UL;
   tf->codes[495] = 0x0000c7910e2213dcUL;
   tf->codes[496] = 0x0000c79148b119a1UL;
   tf->codes[497] = 0x0000c791bdcf252bUL;
   tf->codes[498] = 0x0000c79357b84d8eUL;
   tf->codes[499] = 0x0000c79407655eddUL;
   tf->codes[500] = 0x0000c79441f464a2UL;
   tf->codes[501] = 0x0000c794b712702cUL;
   tf->codes[502] = 0x0000c795a14e8740UL;
   tf->codes[503] = 0x0000c795dbdd8d05UL;
   tf->codes[504] = 0x0000c796166c92caUL;
   tf->codes[505] = 0x0000c79650fb988fUL;
   tf->codes[506] = 0x0000c796c619a419UL;
   tf->codes[507] = 0x0000c79700a8a9deUL;
   tf->codes[508] = 0x0000c797b055bb2dUL;
   tf->codes[509] = 0x0000c7994a3ee390UL;
   tf->codes[510] = 0x0000c79984cde955UL;
   tf->codes[511] = 0x0000c79a6f0a0069UL;
   tf->codes[512] = 0x0000c79ae4280bf3UL;
   tf->codes[513] = 0x0000c79b5946177dUL;
   tf->codes[514] = 0x0000c79c7e113456UL;
   tf->codes[515] = 0x0000c79cb8a03a1bUL;
   tf->codes[516] = 0x0000c79d684d4b6aUL;
   tf->codes[517] = 0x0000c79da2dc512fUL;
   tf->codes[518] = 0x0000c79e17fa5cb9UL;
   tf->codes[519] = 0x0000c79f77547f57UL;
   tf->codes[520] = 0x0000c7a1113da7baUL;
   tf->codes[521] = 0x0000c7a1c0eab909UL;
   tf->codes[522] = 0x0000c7a2ab26d01dUL;
   tf->codes[523] = 0x0000c7a39562e731UL;
   tf->codes[524] = 0x0000c7a4ba2e040aUL;
   tf->codes[525] = 0x0000c7a4f4bd09cfUL;
   tf->codes[526] = 0x0000c7a5def920e3UL;
   tf->codes[527] = 0x0000c7a6c93537f7UL;
   tf->codes[528] = 0x0000c7a8d83c6be4UL;
   tf->codes[529] = 0x0000c7a94d5a776eUL;
   tf->codes[530] = 0x0000c7a987e97d33UL;
   tf->codes[531] = 0x0000c7a9fd0788bdUL;
   tf->codes[532] = 0x0000c7aa72259447UL;
   tf->codes[533] = 0x0000c7aae7439fd1UL;
   tf->codes[534] = 0x0000c7ac469dc26fUL;
   tf->codes[535] = 0x0000c7ad30d9d983UL;
   tf->codes[536] = 0x0000c7ae9033fc21UL;
   tf->codes[537] = 0x0000c7af055207abUL;
   tf->codes[538] = 0x0000c7afb4ff18faUL;
   tf->codes[539] = 0x0000c7b02a1d2484UL;
   tf->codes[540] = 0x0000c7b064ac2a49UL;
   tf->codes[541] = 0x0000c7b114593b98UL;
   tf->codes[542] = 0x0000c7b189774722UL;
   tf->codes[543] = 0x0000c7b2e8d169c0UL;
   tf->codes[544] = 0x0000c7b3d30d80d4UL;
   tf->codes[545] = 0x0000c7b40d9c8699UL;
   tf->codes[546] = 0x0000c7b482ba9223UL;
   tf->codes[547] = 0x0000c7b4bd4997e8UL;
   tf->codes[548] = 0x0000c7b56cf6a937UL;
   tf->codes[549] = 0x0000c7b5e214b4c1UL;
   tf->codes[550] = 0x0000c7b98b051111UL;
   tf->codes[551] = 0x0000c7b9c59416d6UL;
   tf->codes[552] = 0x0000c7ba3ab22260UL;
   tf->codes[553] = 0x0000c7bb24ee3974UL;
   tf->codes[554] = 0x0000c7bb5f7d3f39UL;
   tf->codes[555] = 0x0000c7bc49b9564dUL;
   tf->codes[556] = 0x0000c7bda91378ebUL;
   tf->codes[557] = 0x0000c7bde3a27eb0UL;
   tf->codes[558] = 0x0000c7be58c08a3aUL;
   tf->codes[559] = 0x0000c7be934f8fffUL;
   tf->codes[560] = 0x0000c7bf7d8ba713UL;
   tf->codes[561] = 0x0000c7c02d38b862UL;
   tf->codes[562] = 0x0000c7c11774cf76UL;
   tf->codes[563] = 0x0000c7c15203d53bUL;
   tf->codes[564] = 0x0000c7c2b15df7d9UL;
   tf->codes[565] = 0x0000c7c3267c0363UL;
   tf->codes[566] = 0x0000c7c3d62914b2UL;
   tf->codes[567] = 0x0000c7c535833750UL;
   tf->codes[568] = 0x0000c7c5aaa142daUL;
   tf->codes[569] = 0x0000c7c65a4e5429UL;
   tf->codes[570] = 0x0000c7c6cf6c5fb3UL;
   tf->codes[571] = 0x0000c7c8a3e48ddbUL;
   tf->codes[572] = 0x0000c7c8de7393a0UL;
   tf->codes[573] = 0x0000c7ca033eb079UL;
   tf->codes[574] = 0x0000c7ca785cbc03UL;
   tf->codes[575] = 0x0000c7ccc1f2f5b5UL;
   tf->codes[576] = 0x0000c7cde6be128eUL;
   tf->codes[577] = 0x0000c7cf4618352cUL;
   tf->codes[578] = 0x0000c7d11a906354UL;
   tf->codes[579] = 0x0000c7d1551f6919UL;
   tf->codes[580] = 0x0000c7d364269d06UL;
   tf->codes[581] = 0x0000c7d4c380bfa4UL;
   tf->codes[582] = 0x0000c7d5389ecb2eUL;
   tf->codes[583] = 0x0000c7d65d69e807UL;
   tf->codes[584] = 0x0000c7d7bcc40aa5UL;
   tf->codes[585] = 0x0000c7d8a70021b9UL;
   tf->codes[586] = 0x0000c7d956ad3308UL;
   tf->codes[587] = 0x0000c7d9913c38cdUL;
   tf->codes[588] = 0x0000c7da7b784fe1UL;
   tf->codes[589] = 0x0000c7dd3a2c951dUL;
   tf->codes[590] = 0x0000c7dd74bb9ae2UL;
   tf->codes[591] = 0x0000c7de2468ac31UL;
   tf->codes[592] = 0x0000c7ded415bd80UL;
   tf->codes[593] = 0x0000c7e0e31cf16dUL;
   tf->codes[594] = 0x0000c7e192ca02bcUL;
   tf->codes[595] = 0x0000c7e32cb32b1fUL;
   tf->codes[596] = 0x0000c7e48c0d4dbdUL;
   tf->codes[597] = 0x0000c7e5012b5947UL;
   tf->codes[598] = 0x0000c7e660857be5UL;
   tf->codes[599] = 0x0000c7e69b1481aaUL;
   tf->codes[600] = 0x0000c7e74ac192f9UL;
   tf->codes[601] = 0x0000c7e7855098beUL;
   tf->codes[602] = 0x0000c7e959c8c6e6UL;
   tf->codes[603] = 0x0000c7e99457ccabUL;
   tf->codes[604] = 0x0000c7eab922e984UL;
   tf->codes[605] = 0x0000c7eaf3b1ef49UL;
   tf->codes[606] = 0x0000c7eba35f0098UL;
   tf->codes[607] = 0x0000c7ec8d9b17acUL;
   tf->codes[608] = 0x0000c7edb2663485UL;
   tf->codes[609] = 0x0000c7eed731515eUL;
   tf->codes[610] = 0x0000c7efc16d6872UL;
   tf->codes[611] = 0x0000c7f0aba97f86UL;
   tf->codes[612] = 0x0000c7f0e638854bUL;
   tf->codes[613] = 0x0000c7f1d0749c5fUL;
   tf->codes[614] = 0x0000c7f57964f8afUL;
   tf->codes[615] = 0x0000c7f5ee830439UL;
   tf->codes[616] = 0x0000c7f663a10fc3UL;
   tf->codes[617] = 0x0000c7f74ddd26d7UL;
   tf->codes[618] = 0x0000c7f7886c2c9cUL;
   tf->codes[619] = 0x0000c7f7fd8a3826UL;
   tf->codes[620] = 0x0000c7f9225554ffUL;
   tf->codes[621] = 0x0000c7f95ce45ac4UL;
   tf->codes[622] = 0x0000c7fabc3e7d62UL;
   tf->codes[623] = 0x0000c7fb6beb8eb1UL;
   tf->codes[624] = 0x0000c7fba67a9476UL;
   tf->codes[625] = 0x0000c7fd4063bcd9UL;
   tf->codes[626] = 0x0000c7feda4ce53cUL;
   tf->codes[627] = 0x0000c80039a707daUL;
   tf->codes[628] = 0x0000c80074360d9fUL;
   tf->codes[629] = 0x0000c800e9541929UL;
   tf->codes[630] = 0x0000c80123e31eeeUL;
   tf->codes[631] = 0x0000c8015e7224b3UL;
   tf->codes[632] = 0x0000c80199012a78UL;
   tf->codes[633] = 0x0000c801d390303dUL;
   tf->codes[634] = 0x0000c8020e1f3602UL;
   tf->codes[635] = 0x0000c80248ae3bc7UL;
   tf->codes[636] = 0x0000c802833d418cUL;
   tf->codes[637] = 0x0000c802bdcc4751UL;
   tf->codes[638] = 0x0000c802f85b4d16UL;
   tf->codes[639] = 0x0000c80332ea52dbUL;
   tf->codes[640] = 0x0000c8036d7958a0UL;
   tf->codes[641] = 0x0000c803a8085e65UL;
   tf->codes[642] = 0x0000c803e297642aUL;
   tf->codes[643] = 0x0000c8041d2669efUL;
   tf->codes[644] = 0x0000c80457b56fb4UL;
   tf->codes[645] = 0x0000c80492447579UL;
   tf->codes[646] = 0x0000c804ccd37b3eUL;
   tf->codes[647] = 0x0000c80541f186c8UL;
   tf->codes[648] = 0x0000c805b70f9252UL;
   tf->codes[649] = 0x0000c8062c2d9ddcUL;
   tf->codes[650] = 0x0000c80666bca3a1UL;
   tf->codes[651] = 0x0000c806a14ba966UL;
   tf->codes[652] = 0x0000c806dbdaaf2bUL;
   tf->codes[653] = 0x0000c80875c3d78eUL;
   tf->codes[654] = 0x0000c808eae1e318UL;
   tf->codes[655] = 0x0000c8092570e8ddUL;
   tf->codes[656] = 0x0000c8095fffeea2UL;
   tf->codes[657] = 0x0000c8099a8ef467UL;
   tf->codes[658] = 0x0000c809d51dfa2cUL;
   tf->codes[659] = 0x0000c80a0facfff1UL;
   tf->codes[660] = 0x0000c80a4a3c05b6UL;
   tf->codes[661] = 0x0000c80a84cb0b7bUL;
   tf->codes[662] = 0x0000c80abf5a1140UL;
   tf->codes[663] = 0x0000c80b34781ccaUL;
   tf->codes[664] = 0x0000c80b6f07228fUL;
   tf->codes[665] = 0x0000c80ba9962854UL;
   tf->codes[666] = 0x0000c80be4252e19UL;
   tf->codes[667] = 0x0000c80c1eb433deUL;
   tf->codes[668] = 0x0000c80c594339a3UL;
   tf->codes[669] = 0x0000c80cce61452dUL;
   tf->codes[670] = 0x0000c80d08f04af2UL;
   tf->codes[671] = 0x0000c80d437f50b7UL;
   tf->codes[672] = 0x0000c80ea2d97355UL;
   tf->codes[673] = 0x0000c80edd68791aUL;
   tf->codes[674] = 0x0000c80f17f77edfUL;
   tf->codes[675] = 0x0000c80f528684a4UL;
   tf->codes[676] = 0x0000c810023395f3UL;
   tf->codes[677] = 0x0000c8103cc29bb8UL;
   tf->codes[678] = 0x0000c8107751a17dUL;
   tf->codes[679] = 0x0000c810b1e0a742UL;
   tf->codes[680] = 0x0000c810ec6fad07UL;
   tf->codes[681] = 0x0000c81126feb2ccUL;
   tf->codes[682] = 0x0000c811618db891UL;
   tf->codes[683] = 0x0000c8119c1cbe56UL;
   tf->codes[684] = 0x0000c811d6abc41bUL;
   tf->codes[685] = 0x0000c812113ac9e0UL;
   tf->codes[686] = 0x0000c8124bc9cfa5UL;
   tf->codes[687] = 0x0000c8128658d56aUL;
   tf->codes[688] = 0x0000c812c0e7db2fUL;
   tf->codes[689] = 0x0000c812fb76e0f4UL;
   tf->codes[690] = 0x0000c8133605e6b9UL;
   tf->codes[691] = 0x0000c813ab23f243UL;
   tf->codes[692] = 0x0000c813e5b2f808UL;
   tf->codes[693] = 0x0000c8145ad10392UL;
   tf->codes[694] = 0x0000c814cfef0f1cUL;
   tf->codes[695] = 0x0000c815450d1aa6UL;
   tf->codes[696] = 0x0000c8157f9c206bUL;
   tf->codes[697] = 0x0000c815ba2b2630UL;
   tf->codes[698] = 0x0000c815f4ba2bf5UL;
   tf->codes[699] = 0x0000c8162f4931baUL;
   tf->codes[700] = 0x0000c81669d8377fUL;
   tf->codes[701] = 0x0000c816def64309UL;
   tf->codes[702] = 0x0000c817198548ceUL;
   tf->codes[703] = 0x0000c81754144e93UL;
   tf->codes[704] = 0x0000c81878df6b6cUL;
   tf->codes[705] = 0x0000c818edfd76f6UL;
   tf->codes[706] = 0x0000c819631b8280UL;
   tf->codes[707] = 0x0000c8199daa8845UL;
   tf->codes[708] = 0x0000c819d8398e0aUL;
   tf->codes[709] = 0x0000c81a4d579994UL;
   tf->codes[710] = 0x0000c81afd04aae3UL;
   tf->codes[711] = 0x0000c81b7222b66dUL;
   tf->codes[712] = 0x0000c81bacb1bc32UL;
   tf->codes[713] = 0x0000c81be740c1f7UL;
   tf->codes[714] = 0x0000c81c5c5ecd81UL;
   tf->codes[715] = 0x0000c81c96edd346UL;
   tf->codes[716] = 0x0000c81d0c0bded0UL;
   tf->codes[717] = 0x0000c81e6b66016eUL;
   tf->codes[718] = 0x0000c81ea5f50733UL;
   tf->codes[719] = 0x0000c81f1b1312bdUL;
   tf->codes[720] = 0x0000c81f55a21882UL;
   tf->codes[721] = 0x0000c820054f29d1UL;
   tf->codes[722] = 0x0000c8203fde2f96UL;
   tf->codes[723] = 0x0000c8207a6d355bUL;
   tf->codes[724] = 0x0000c820b4fc3b20UL;
   tf->codes[725] = 0x0000c820ef8b40e5UL;
   tf->codes[726] = 0x0000c8212a1a46aaUL;
   tf->codes[727] = 0x0000c822fe9274d2UL;
   tf->codes[728] = 0x0000c82339217a97UL;
   tf->codes[729] = 0x0000c8245dec9770UL;
   tf->codes[730] = 0x0000c824987b9d35UL;
   tf->codes[731] = 0x0000c824d30aa2faUL;
   tf->codes[732] = 0x0000c8250d99a8bfUL;
   tf->codes[733] = 0x0000c8254828ae84UL;
   tf->codes[734] = 0x0000c82582b7b449UL;
   tf->codes[735] = 0x0000c825bd46ba0eUL;
   tf->codes[736] = 0x0000c825f7d5bfd3UL;
   tf->codes[737] = 0x0000c8263264c598UL;
   tf->codes[738] = 0x0000c8266cf3cb5dUL;
   tf->codes[739] = 0x0000c826a782d122UL;
   tf->codes[740] = 0x0000c826e211d6e7UL;
   tf->codes[741] = 0x0000c8271ca0dcacUL;
   tf->codes[742] = 0x0000c827572fe271UL;
   tf->codes[743] = 0x0000c82791bee836UL;
   tf->codes[744] = 0x0000c827cc4dedfbUL;
   tf->codes[745] = 0x0000c8287bfaff4aUL;
   tf->codes[746] = 0x0000c828f1190ad4UL;
   tf->codes[747] = 0x0000c8292ba81099UL;
   tf->codes[748] = 0x0000c8296637165eUL;
   tf->codes[749] = 0x0000c829db5521e8UL;
   tf->codes[750] = 0x0000c82a15e427adUL;
   tf->codes[751] = 0x0000c82a50732d72UL;
   tf->codes[752] = 0x0000c82a8b023337UL;
   tf->codes[753] = 0x0000c82b3aaf4486UL;
   tf->codes[754] = 0x0000c82b753e4a4bUL;
   tf->codes[755] = 0x0000c82bea5c55d5UL;
   tf->codes[756] = 0x0000c82c24eb5b9aUL;
   tf->codes[757] = 0x0000c82cd4986ce9UL;
   tf->codes[758] = 0x0000c82dbed483fdUL;
   tf->codes[759] = 0x0000c82e33f28f87UL;
   tf->codes[760] = 0x0000c82ee39fa0d6UL;
   tf->codes[761] = 0x0000c82f1e2ea69bUL;
   tf->codes[762] = 0x0000c82f934cb225UL;
   tf->codes[763] = 0x0000c82fcddbb7eaUL;
   tf->codes[764] = 0x0000c83042f9c374UL;
   tf->codes[765] = 0x0000c830b817cefeUL;
   tf->codes[766] = 0x0000c831a253e612UL;
   tf->codes[767] = 0x0000c832c71f02ebUL;
   tf->codes[768] = 0x0000c8333c3d0e75UL;
   tf->codes[769] = 0x0000c833b15b19ffUL;
   tf->codes[770] = 0x0000c833ebea1fc4UL;
   tf->codes[771] = 0x0000c83426792589UL;
   tf->codes[772] = 0x0000c83461082b4eUL;
   tf->codes[773] = 0x0000c8349b973113UL;
   tf->codes[774] = 0x0000c8354b444262UL;
   tf->codes[775] = 0x0000c83585d34827UL;
   tf->codes[776] = 0x0000c835c0624decUL;
   tf->codes[777] = 0x0000c836700f5f3bUL;
   tf->codes[778] = 0x0000c836e52d6ac5UL;
   tf->codes[779] = 0x0000c8375a4b764fUL;
   tf->codes[780] = 0x0000c83809f8879eUL;
   tf->codes[781] = 0x0000c838b9a598edUL;
   tf->codes[782] = 0x0000c838f4349eb2UL;
   tf->codes[783] = 0x0000c8392ec3a477UL;
   tf->codes[784] = 0x0000c8396952aa3cUL;
   tf->codes[785] = 0x0000c839de70b5c6UL;
   tf->codes[786] = 0x0000c83a18ffbb8bUL;
   tf->codes[787] = 0x0000c83a538ec150UL;
   tf->codes[788] = 0x0000c83a8e1dc715UL;
   tf->codes[789] = 0x0000c83ac8acccdaUL;
   tf->codes[790] = 0x0000c83bb2e8e3eeUL;
   tf->codes[791] = 0x0000c83bed77e9b3UL;
   tf->codes[792] = 0x0000c83c6295f53dUL;
   tf->codes[793] = 0x0000c83d4cd20c51UL;
   tf->codes[794] = 0x0000c83d87611216UL;
   tf->codes[795] = 0x0000c83f5bd9403eUL;
   tf->codes[796] = 0x0000c840f5c268a1UL;
   tf->codes[797] = 0x0000c8416ae0742bUL;
   tf->codes[798] = 0x0000c8421a8d857aUL;
   tf->codes[799] = 0x0000c842551c8b3fUL;
   tf->codes[800] = 0x0000c8428fab9104UL;
   tf->codes[801] = 0x0000c842ca3a96c9UL;
   tf->codes[802] = 0x0000c8433f58a253UL;
   tf->codes[803] = 0x0000c84379e7a818UL;
   tf->codes[804] = 0x0000c8442994b967UL;
   tf->codes[805] = 0x0000c8446423bf2cUL;
   tf->codes[806] = 0x0000c8449eb2c4f1UL;
   tf->codes[807] = 0x0000c844d941cab6UL;
   tf->codes[808] = 0x0000c84588eedc05UL;
   tf->codes[809] = 0x0000c846732af319UL;
   tf->codes[810] = 0x0000c84722d80468UL;
   tf->codes[811] = 0x0000c84797f60ff2UL;
   tf->codes[812] = 0x0000c84847a32141UL;
   tf->codes[813] = 0x0000c848f7503290UL;
   tf->codes[814] = 0x0000c849a6fd43dfUL;
   tf->codes[815] = 0x0000c84a56aa552eUL;
   tf->codes[816] = 0x0000c84a91395af3UL;
   tf->codes[817] = 0x0000c84acbc860b8UL;
   tf->codes[818] = 0x0000c84bb60477ccUL;
   tf->codes[819] = 0x0000c84bf0937d91UL;
   tf->codes[820] = 0x0000c84d155e9a6aUL;
   tf->codes[821] = 0x0000c84dc50babb9UL;
   tf->codes[822] = 0x0000c84dff9ab17eUL;
   tf->codes[823] = 0x0000c84ee9d6c892UL;
   tf->codes[824] = 0x0000c84f2465ce57UL;
   tf->codes[825] = 0x0000c84f5ef4d41cUL;
   tf->codes[826] = 0x0000c84f9983d9e1UL;
   tf->codes[827] = 0x0000c84fd412dfa6UL;
   tf->codes[828] = 0x0000c8504930eb30UL;
   tf->codes[829] = 0x0000c850be4ef6baUL;
   tf->codes[830] = 0x0000c851336d0244UL;
   tf->codes[831] = 0x0000c851a88b0dceUL;
   tf->codes[832] = 0x0000c85292c724e2UL;
   tf->codes[833] = 0x0000c85342743631UL;
   tf->codes[834] = 0x0000c8537d033bf6UL;
   tf->codes[835] = 0x0000c853b79241bbUL;
   tf->codes[836] = 0x0000c853f2214780UL;
   tf->codes[837] = 0x0000c8542cb04d45UL;
   tf->codes[838] = 0x0000c854673f530aUL;
   tf->codes[839] = 0x0000c855517b6a1eUL;
   tf->codes[840] = 0x0000c8558c0a6fe3UL;
   tf->codes[841] = 0x0000c855c69975a8UL;
   tf->codes[842] = 0x0000c856764686f7UL;
   tf->codes[843] = 0x0000c856b0d58cbcUL;
   tf->codes[844] = 0x0000c856eb649281UL;
   tf->codes[845] = 0x0000c85725f39846UL;
   tf->codes[846] = 0x0000c85760829e0bUL;
   tf->codes[847] = 0x0000c8579b11a3d0UL;
   tf->codes[848] = 0x0000c858102faf5aUL;
   tf->codes[849] = 0x0000c8584abeb51fUL;
   tf->codes[850] = 0x0000c858bfdcc0a9UL;
   tf->codes[851] = 0x0000c8596f89d1f8UL;
   tf->codes[852] = 0x0000c859aa18d7bdUL;
   tf->codes[853] = 0x0000c859e4a7dd82UL;
   tf->codes[854] = 0x0000c85b7e9105e5UL;
   tf->codes[855] = 0x0000c85bb9200baaUL;
   tf->codes[856] = 0x0000c85bf3af116fUL;
   tf->codes[857] = 0x0000c85c2e3e1734UL;
   tf->codes[858] = 0x0000c85d8d9839d2UL;
   tf->codes[859] = 0x0000c85dc8273f97UL;
   tf->codes[860] = 0x0000c85e02b6455cUL;
   tf->codes[861] = 0x0000c85e3d454b21UL;
   tf->codes[862] = 0x0000c85eb26356abUL;
   tf->codes[863] = 0x0000c85f621067faUL;
   tf->codes[864] = 0x0000c85f9c9f6dbfUL;
   tf->codes[865] = 0x0000c86011bd7949UL;
   tf->codes[866] = 0x0000c860fbf9905dUL;
   tf->codes[867] = 0x0000c86136889622UL;
   tf->codes[868] = 0x0000c861aba6a1acUL;
   tf->codes[869] = 0x0000c861e635a771UL;
   tf->codes[870] = 0x0000c862d071be85UL;
   tf->codes[871] = 0x0000c863801ecfd4UL;
   tf->codes[872] = 0x0000c8658f2603c1UL;
   tf->codes[873] = 0x0000c865c9b50986UL;
   tf->codes[874] = 0x0000c8663ed31510UL;
   tf->codes[875] = 0x0000c866b3f1209aUL;
   tf->codes[876] = 0x0000c867290f2c24UL;
   tf->codes[877] = 0x0000c867639e31e9UL;
   tf->codes[878] = 0x0000c8679e2d37aeUL;
   tf->codes[879] = 0x0000c867d8bc3d73UL;
   tf->codes[880] = 0x0000c868134b4338UL;
   tf->codes[881] = 0x0000c868fd875a4cUL;
   tf->codes[882] = 0x0000c86938166011UL;
   tf->codes[883] = 0x0000c86a5ce17ceaUL;
   tf->codes[884] = 0x0000c86b81ac99c3UL;
   tf->codes[885] = 0x0000c86bbc3b9f88UL;
   tf->codes[886] = 0x0000c86bf6caa54dUL;
   tf->codes[887] = 0x0000c86c3159ab12UL;
   tf->codes[888] = 0x0000c86d5624c7ebUL;
   tf->codes[889] = 0x0000c86e05d1d93aUL;
   tf->codes[890] = 0x0000c86ef00df04eUL;
   tf->codes[891] = 0x0000c86f2a9cf613UL;
   tf->codes[892] = 0x0000c86f9fbb019dUL;
   tf->codes[893] = 0x0000c8704f6812ecUL;
   tf->codes[894] = 0x0000c87089f718b1UL;
   tf->codes[895] = 0x0000c8725e6f46d9UL;
   tf->codes[896] = 0x0000c8746d767ac6UL;
   tf->codes[897] = 0x0000c874a805808bUL;
   tf->codes[898] = 0x0000c87557b291daUL;
   tf->codes[899] = 0x0000c8759241979fUL;
   tf->codes[900] = 0x0000c87641eea8eeUL;
   tf->codes[901] = 0x0000c876b70cb478UL;
   tf->codes[902] = 0x0000c876f19bba3dUL;
   tf->codes[903] = 0x0000c8772c2ac002UL;
   tf->codes[904] = 0x0000c877a148cb8cUL;
   tf->codes[905] = 0x0000c87900a2ee2aUL;
   tf->codes[906] = 0x0000c8793b31f3efUL;
   tf->codes[907] = 0x0000c879eadf053eUL;
   tf->codes[908] = 0x0000c87a9a8c168dUL;
   tf->codes[909] = 0x0000c87ad51b1c52UL;
   tf->codes[910] = 0x0000c87d59405bc9UL;
   tf->codes[911] = 0x0000c87e437c72ddUL;
   tf->codes[912] = 0x0000c8808d12ac8fUL;
   tf->codes[913] = 0x0000c880c7a1b254UL;
   tf->codes[914] = 0x0000c881774ec3a3UL;
   tf->codes[915] = 0x0000c881b1ddc968UL;
   tf->codes[916] = 0x0000c882618adab7UL;
   tf->codes[917] = 0x0000c8829c19e07cUL;
   tf->codes[918] = 0x0000c8838655f790UL;
   tf->codes[919] = 0x0000c883c0e4fd55UL;
   tf->codes[920] = 0x0000c883fb74031aUL;
   tf->codes[921] = 0x0000c884ab211469UL;
   tf->codes[922] = 0x0000c885cfec3142UL;
   tf->codes[923] = 0x0000c886450a3cccUL;
   tf->codes[924] = 0x0000c8867f994291UL;
   tf->codes[925] = 0x0000c886ba284856UL;
   tf->codes[926] = 0x0000c887a4645f6aUL;
   tf->codes[927] = 0x0000c888541170b9UL;
   tf->codes[928] = 0x0000c888c92f7c43UL;
   tf->codes[929] = 0x0000c88978dc8d92UL;
   tf->codes[930] = 0x0000c889edfa991cUL;
   tf->codes[931] = 0x0000c88ad836b030UL;
   tf->codes[932] = 0x0000c88bc272c744UL;
   tf->codes[933] = 0x0000c88bfd01cd09UL;
   tf->codes[934] = 0x0000c88ebbb61245UL;
   tf->codes[935] = 0x0000c890902e406dUL;
   tf->codes[936] = 0x0000c890cabd4632UL;
   tf->codes[937] = 0x0000c891b4f95d46UL;
   tf->codes[938] = 0x0000c8922a1768d0UL;
   tf->codes[939] = 0x0000c89264a66e95UL;
   tf->codes[940] = 0x0000c8929f35745aUL;
   tf->codes[941] = 0x0000c892d9c47a1fUL;
   tf->codes[942] = 0x0000c89314537fe4UL;
   tf->codes[943] = 0x0000c8934ee285a9UL;
   tf->codes[944] = 0x0000c89389718b6eUL;
   tf->codes[945] = 0x0000c893fe8f96f8UL;
   tf->codes[946] = 0x0000c894391e9cbdUL;
   tf->codes[947] = 0x0000c89473ada282UL;
   tf->codes[948] = 0x0000c895235ab3d1UL;
   tf->codes[949] = 0x0000c8955de9b996UL;
   tf->codes[950] = 0x0000c895d307c520UL;
   tf->codes[951] = 0x0000c8960d96cae5UL;
   tf->codes[952] = 0x0000c8964825d0aaUL;
   tf->codes[953] = 0x0000c897e20ef90dUL;
   tf->codes[954] = 0x0000c898572d0497UL;
   tf->codes[955] = 0x0000c898cc4b1021UL;
   tf->codes[956] = 0x0000c89906da15e6UL;
   tf->codes[957] = 0x0000c8997bf82170UL;
   tf->codes[958] = 0x0000c89adb52440eUL;
   tf->codes[959] = 0x0000c89b15e149d3UL;
   tf->codes[960] = 0x0000c89bc58e5b22UL;
   tf->codes[961] = 0x0000c89c001d60e7UL;
   tf->codes[962] = 0x0000c89c3aac66acUL;
   tf->codes[963] = 0x0000c89d5f778385UL;
   tf->codes[964] = 0x0000c89e8442a05eUL;
   tf->codes[965] = 0x0000c89fa90dbd37UL;
   tf->codes[966] = 0x0000c89fe39cc2fcUL;
   tf->codes[967] = 0x0000c8a01e2bc8c1UL;
   tf->codes[968] = 0x0000c8a09349d44bUL;
   tf->codes[969] = 0x0000c8a142f6e59aUL;
   tf->codes[970] = 0x0000c8a17d85eb5fUL;
   tf->codes[971] = 0x0000c8a1b814f124UL;
   tf->codes[972] = 0x0000c8a267c20273UL;
   tf->codes[973] = 0x0000c8a2a2510838UL;
   tf->codes[974] = 0x0000c8a3176f13c2UL;
   tf->codes[975] = 0x0000c8a38c8d1f4cUL;
   tf->codes[976] = 0x0000c8a3c71c2511UL;
   tf->codes[977] = 0x0000c8a401ab2ad6UL;
   tf->codes[978] = 0x0000c8a43c3a309bUL;
   tf->codes[979] = 0x0000c8a5d62358feUL;
   tf->codes[980] = 0x0000c8a64b416488UL;
   tf->codes[981] = 0x0000c8a685d06a4dUL;
   tf->codes[982] = 0x0000c8a6c05f7012UL;
   tf->codes[983] = 0x0000c8a7357d7b9cUL;
   tf->codes[984] = 0x0000c8a7700c8161UL;
   tf->codes[985] = 0x0000c8a7aa9b8726UL;
   tf->codes[986] = 0x0000c8a7e52a8cebUL;
   tf->codes[987] = 0x0000c8a81fb992b0UL;
   tf->codes[988] = 0x0000c8a85a489875UL;
   tf->codes[989] = 0x0000c8a8cf66a3ffUL;
   tf->codes[990] = 0x0000c8a94484af89UL;
   tf->codes[991] = 0x0000c8a9b9a2bb13UL;
   tf->codes[992] = 0x0000c8aa2ec0c69dUL;
   tf->codes[993] = 0x0000c8aade6dd7ecUL;
   tf->codes[994] = 0x0000c8ab8e1ae93bUL;
   tf->codes[995] = 0x0000c8ad2804119eUL;
   tf->codes[996] = 0x0000c8ad9d221d28UL;
   tf->codes[997] = 0x0000c8add7b122edUL;
   tf->codes[998] = 0x0000c8ae875e343cUL;
   tf->codes[999] = 0x0000c8aefc7c3fc6UL;
   tf->codes[1000] = 0x0000c8afac295115UL;
   tf->codes[1001] = 0x0000c8afe6b856daUL;
   tf->codes[1002] = 0x0000c8b021475c9fUL;
   tf->codes[1003] = 0x0000c8b146127978UL;
   tf->codes[1004] = 0x0000c8b180a17f3dUL;
   tf->codes[1005] = 0x0000c8b1f5bf8ac7UL;
   tf->codes[1006] = 0x0000c8b26add9651UL;
   tf->codes[1007] = 0x0000c8b2a56c9c16UL;
   tf->codes[1008] = 0x0000c8b2dffba1dbUL;
   tf->codes[1009] = 0x0000c8b35519ad65UL;
   tf->codes[1010] = 0x0000c8b38fa8b32aUL;
   tf->codes[1011] = 0x0000c8b3ca37b8efUL;
   tf->codes[1012] = 0x0000c8b404c6beb4UL;
   tf->codes[1013] = 0x0000c8b4b473d003UL;
   tf->codes[1014] = 0x0000c8b4ef02d5c8UL;
   tf->codes[1015] = 0x0000c8b52991db8dUL;
   tf->codes[1016] = 0x0000c8b5d93eecdcUL;
   tf->codes[1017] = 0x0000c8b64e5cf866UL;
   tf->codes[1018] = 0x0000c8b6fe0a09b5UL;
   tf->codes[1019] = 0x0000c8b77328153fUL;
   tf->codes[1020] = 0x0000c8b7e84620c9UL;
   tf->codes[1021] = 0x0000c8b822d5268eUL;
   tf->codes[1022] = 0x0000c8b8d28237ddUL;
   tf->codes[1023] = 0x0000c8b90d113da2UL;
   tf->codes[1024] = 0x0000c8ba31dc5a7bUL;
   tf->codes[1025] = 0x0000c8baa6fa6605UL;
   tf->codes[1026] = 0x0000c8bb91367d19UL;
   tf->codes[1027] = 0x0000c8bc065488a3UL;
   tf->codes[1028] = 0x0000c8bcb60199f2UL;
   tf->codes[1029] = 0x0000c8bd2b1fa57cUL;
   tf->codes[1030] = 0x0000c8be4feac255UL;
   tf->codes[1031] = 0x0000c8beff97d3a4UL;
   tf->codes[1032] = 0x0000c8bf3a26d969UL;
   tf->codes[1033] = 0x0000c8bf74b5df2eUL;
   tf->codes[1034] = 0x0000c8c05ef1f642UL;
   tf->codes[1035] = 0x0000c8c0d41001ccUL;
   tf->codes[1036] = 0x0000c8c10e9f0791UL;
   tf->codes[1037] = 0x0000c8c1492e0d56UL;
   tf->codes[1038] = 0x0000c8c1be4c18e0UL;
   tf->codes[1039] = 0x0000c8c1f8db1ea5UL;
   tf->codes[1040] = 0x0000c8c358354143UL;
   tf->codes[1041] = 0x0000c8c4b78f63e1UL;
   tf->codes[1042] = 0x0000c8c4f21e69a6UL;
   tf->codes[1043] = 0x0000c8c5dc5a80baUL;
   tf->codes[1044] = 0x0000c8c651788c44UL;
   tf->codes[1045] = 0x0000c8c6c69697ceUL;
   tf->codes[1046] = 0x0000c8c9102cd180UL;
   tf->codes[1047] = 0x0000c8c9854add0aUL;
   tf->codes[1048] = 0x0000c8c9fa68e894UL;
   tf->codes[1049] = 0x0000c8ca6f86f41eUL;
   tf->codes[1050] = 0x0000c8caaa15f9e3UL;
   tf->codes[1051] = 0x0000c8cb59c30b32UL;
   tf->codes[1052] = 0x0000c8cb945210f7UL;
   tf->codes[1053] = 0x0000c8cbcee116bcUL;
   tf->codes[1054] = 0x0000c8cc09701c81UL;
   tf->codes[1055] = 0x0000c8cd2e3b395aUL;
   tf->codes[1056] = 0x0000c8cd68ca3f1fUL;
   tf->codes[1057] = 0x0000c8cddde84aa9UL;
   tf->codes[1058] = 0x0000c8cf3d426d47UL;
   tf->codes[1059] = 0x0000c8cf77d1730cUL;
   tf->codes[1060] = 0x0000c8d0277e845bUL;
   tf->codes[1061] = 0x0000c8d0d72b95aaUL;
   tf->codes[1062] = 0x0000c8d111ba9b6fUL;
   tf->codes[1063] = 0x0000c8d186d8a6f9UL;
   tf->codes[1064] = 0x0000c8d1c167acbeUL;
   tf->codes[1065] = 0x0000c8d27114be0dUL;
   tf->codes[1066] = 0x0000c8d2e632c997UL;
   tf->codes[1067] = 0x0000c8d320c1cf5cUL;
   tf->codes[1068] = 0x0000c8d35b50d521UL;
   tf->codes[1069] = 0x0000c8d4801bf1faUL;
   tf->codes[1070] = 0x0000c8d4f539fd84UL;
   tf->codes[1071] = 0x0000c8d52fc90349UL;
   tf->codes[1072] = 0x0000c8d61a051a5dUL;
   tf->codes[1073] = 0x0000c8d654942022UL;
   tf->codes[1074] = 0x0000c8d68f2325e7UL;
   tf->codes[1075] = 0x0000c8d6c9b22bacUL;
   tf->codes[1076] = 0x0000c8d704413171UL;
   tf->codes[1077] = 0x0000c8d7ee7d4885UL;
   tf->codes[1078] = 0x0000c8d8290c4e4aUL;
   tf->codes[1079] = 0x0000c8d8639b540fUL;
   tf->codes[1080] = 0x0000c8d89e2a59d4UL;
   tf->codes[1081] = 0x0000c8d8d8b95f99UL;
   tf->codes[1082] = 0x0000c8da38138237UL;
   tf->codes[1083] = 0x0000c8db224f994bUL;
   tf->codes[1084] = 0x0000c8dbd1fcaa9aUL;
   tf->codes[1085] = 0x0000c8de5621ea11UL;
   tf->codes[1086] = 0x0000c8de90b0efd6UL;
   tf->codes[1087] = 0x0000c8df405e0125UL;
   tf->codes[1088] = 0x0000c8dff00b1274UL;
   tf->codes[1089] = 0x0000c8e1ff124661UL;
   tf->codes[1090] = 0x0000c8e323dd633aUL;
   tf->codes[1091] = 0x0000c8e3d38a7489UL;
   tf->codes[1092] = 0x0000c8e56d739cecUL;
   tf->codes[1093] = 0x0000c8e5a802a2b1UL;
   tf->codes[1094] = 0x0000c8e657afb400UL;
   tf->codes[1095] = 0x0000c8e6923eb9c5UL;
   tf->codes[1096] = 0x0000c8e7075cc54fUL;
   tf->codes[1097] = 0x0000c8e741ebcb14UL;
   tf->codes[1098] = 0x0000c8e82c27e228UL;
   tf->codes[1099] = 0x0000c8e8a145edb2UL;
   tf->codes[1100] = 0x0000c8e91663f93cUL;
   tf->codes[1101] = 0x0000c8e950f2ff01UL;
   tf->codes[1102] = 0x0000c8e9c6110a8bUL;
   tf->codes[1103] = 0x0000c8ea00a01050UL;
   tf->codes[1104] = 0x0000c8eab04d219fUL;
   tf->codes[1105] = 0x0000c8eaeadc2764UL;
   tf->codes[1106] = 0x0000c8eb256b2d29UL;
   tf->codes[1107] = 0x0000c8ec4a364a02UL;
   tf->codes[1108] = 0x0000c8ecbf54558cUL;
   tf->codes[1109] = 0x0000c8ed6f0166dbUL;
   tf->codes[1110] = 0x0000c8ef7e089ac8UL;
   tf->codes[1111] = 0x0000c8efb897a08dUL;
   tf->codes[1112] = 0x0000c8f02db5ac17UL;
   tf->codes[1113] = 0x0000c8f0a2d3b7a1UL;
   tf->codes[1114] = 0x0000c8f117f1c32bUL;
   tf->codes[1115] = 0x0000c8f15280c8f0UL;
   tf->codes[1116] = 0x0000c8f18d0fceb5UL;
   tf->codes[1117] = 0x0000c8f1c79ed47aUL;
   tf->codes[1118] = 0x0000c8f2ec69f153UL;
   tf->codes[1119] = 0x0000c8f39c1702a2UL;
   tf->codes[1120] = 0x0000c8f411350e2cUL;
   tf->codes[1121] = 0x0000c8f4c0e21f7bUL;
   tf->codes[1122] = 0x0000c8f4fb712540UL;
   tf->codes[1123] = 0x0000c8f5708f30caUL;
   tf->codes[1124] = 0x0000c8f5ab1e368fUL;
   tf->codes[1125] = 0x0000c8f6203c4219UL;
   tf->codes[1126] = 0x0000c8f70a78592dUL;
   tf->codes[1127] = 0x0000c8f9540e92dfUL;
   tf->codes[1128] = 0x0000c8f9c92c9e69UL;
   tf->codes[1129] = 0x0000c8fa78d9afb8UL;
   tf->codes[1130] = 0x0000c8faedf7bb42UL;
   tf->codes[1131] = 0x0000c8fcc26fe96aUL;
   tf->codes[1132] = 0x0000c8fd721cfab9UL;
   tf->codes[1133] = 0x0000c8fdacac007eUL;
   tf->codes[1134] = 0x0000c8fe5c5911cdUL;
   tf->codes[1135] = 0x0000c8fe96e81792UL;
   tf->codes[1136] = 0x0000c8ffbbb3346bUL;
   tf->codes[1137] = 0x0000c90030d13ff5UL;
   tf->codes[1138] = 0x0000c900e07e5144UL;
   tf->codes[1139] = 0x0000c9011b0d5709UL;
   tf->codes[1140] = 0x0000c901559c5cceUL;
   tf->codes[1141] = 0x0000c901902b6293UL;
   tf->codes[1142] = 0x0000c90205496e1dUL;
   tf->codes[1143] = 0x0000c902ef858531UL;
   tf->codes[1144] = 0x0000c9032a148af6UL;
   tf->codes[1145] = 0x0000c90364a390bbUL;
   tf->codes[1146] = 0x0000c903d9c19c45UL;
   tf->codes[1147] = 0x0000c904c3fdb359UL;
   tf->codes[1148] = 0x0000c905391bbee3UL;
   tf->codes[1149] = 0x0000c9069875e181UL;
   tf->codes[1150] = 0x0000c906d304e746UL;
   tf->codes[1151] = 0x0000c9070d93ed0bUL;
   tf->codes[1152] = 0x0000c9074822f2d0UL;
   tf->codes[1153] = 0x0000c90782b1f895UL;
   tf->codes[1154] = 0x0000c9086cee0fa9UL;
   tf->codes[1155] = 0x0000c908a77d156eUL;
   tf->codes[1156] = 0x0000c908e20c1b33UL;
   tf->codes[1157] = 0x0000c9091c9b20f8UL;
   tf->codes[1158] = 0x0000c909cc483247UL;
   tf->codes[1159] = 0x0000c90ab684495bUL;
   tf->codes[1160] = 0x0000c90b2ba254e5UL;
   tf->codes[1161] = 0x0000c90ba0c0606fUL;
   tf->codes[1162] = 0x0000c90bdb4f6634UL;
   tf->codes[1163] = 0x0000c90c15de6bf9UL;
   tf->codes[1164] = 0x0000c90d001a830dUL;
   tf->codes[1165] = 0x0000c90d3aa988d2UL;
   tf->codes[1166] = 0x0000c90dafc7945cUL;
   tf->codes[1167] = 0x0000c90e5f74a5abUL;
   tf->codes[1168] = 0x0000c90f0f21b6faUL;
   tf->codes[1169] = 0x0000c9106e7bd998UL;
   tf->codes[1170] = 0x0000c9111e28eae7UL;
   tf->codes[1171] = 0x0000c91158b7f0acUL;
   tf->codes[1172] = 0x0000c912086501fbUL;
   tf->codes[1173] = 0x0000c91242f407c0UL;
   tf->codes[1174] = 0x0000c913a24e2a5eUL;
   tf->codes[1175] = 0x0000c913dcdd3023UL;
   tf->codes[1176] = 0x0000c91451fb3badUL;
   tf->codes[1177] = 0x0000c914c7194737UL;
   tf->codes[1178] = 0x0000c9153c3752c1UL;
   tf->codes[1179] = 0x0000c915b1555e4bUL;
   tf->codes[1180] = 0x0000c91710af80e9UL;
   tf->codes[1181] = 0x0000c9174b3e86aeUL;
   tf->codes[1182] = 0x0000c917c05c9238UL;
   tf->codes[1183] = 0x0000c9187009a387UL;
   tf->codes[1184] = 0x0000c918aa98a94cUL;
   tf->codes[1185] = 0x0000c9195a45ba9bUL;
   tf->codes[1186] = 0x0000c91994d4c060UL;
   tf->codes[1187] = 0x0000c91a7f10d774UL;
   tf->codes[1188] = 0x0000c91ab99fdd39UL;
   tf->codes[1189] = 0x0000c91af42ee2feUL;
   tf->codes[1190] = 0x0000c91b694cee88UL;
   tf->codes[1191] = 0x0000c91ba3dbf44dUL;
   tf->codes[1192] = 0x0000c91cc8a71126UL;
   tf->codes[1193] = 0x0000c91d3dc51cb0UL;
   tf->codes[1194] = 0x0000c91d78542275UL;
   tf->codes[1195] = 0x0000c91ded722dffUL;
   tf->codes[1196] = 0x0000c91e62903989UL;
   tf->codes[1197] = 0x0000c91e9d1f3f4eUL;
   tf->codes[1198] = 0x0000c91f123d4ad8UL;
   tf->codes[1199] = 0x0000c920ac26733bUL;
   tf->codes[1200] = 0x0000c92121447ec5UL;
   tf->codes[1201] = 0x0000c92196628a4fUL;
   tf->codes[1202] = 0x0000c922460f9b9eUL;
   tf->codes[1203] = 0x0000c922809ea163UL;
   tf->codes[1204] = 0x0000c9236adab877UL;
   tf->codes[1205] = 0x0000c923dff8c401UL;
   tf->codes[1206] = 0x0000c924ca34db15UL;
   tf->codes[1207] = 0x0000c92504c3e0daUL;
   tf->codes[1208] = 0x0000c9253f52e69fUL;
   tf->codes[1209] = 0x0000c926641e0378UL;
   tf->codes[1210] = 0x0000c92788e92051UL;
   tf->codes[1211] = 0x0000c927c3782616UL;
   tf->codes[1212] = 0x0000c927fe072bdbUL;
   tf->codes[1213] = 0x0000c92922d248b4UL;
   tf->codes[1214] = 0x0000c9295d614e79UL;
   tf->codes[1215] = 0x0000c92997f0543eUL;
   tf->codes[1216] = 0x0000c92a0d0e5fc8UL;
   tf->codes[1217] = 0x0000c92af74a76dcUL;
   tf->codes[1218] = 0x0000c92b31d97ca1UL;
   tf->codes[1219] = 0x0000c92ba6f7882bUL;
   tf->codes[1220] = 0x0000c92be1868df0UL;
   tf->codes[1221] = 0x0000c92c56a4997aUL;
   tf->codes[1222] = 0x0000c92db5febc18UL;
   tf->codes[1223] = 0x0000c92df08dc1ddUL;
   tf->codes[1224] = 0x0000c92e65abcd67UL;
   tf->codes[1225] = 0x0000c92f8a76ea40UL;
   tf->codes[1226] = 0x0000c93074b30154UL;
   tf->codes[1227] = 0x0000c930af420719UL;
   tf->codes[1228] = 0x0000c930e9d10cdeUL;
   tf->codes[1229] = 0x0000c931246012a3UL;
   tf->codes[1230] = 0x0000c9315eef1868UL;
   tf->codes[1231] = 0x0000c931d40d23f2UL;
   tf->codes[1232] = 0x0000c9320e9c29b7UL;
   tf->codes[1233] = 0x0000c932492b2f7cUL;
   tf->codes[1234] = 0x0000c932be493b06UL;
   tf->codes[1235] = 0x0000c933a885521aUL;
   tf->codes[1236] = 0x0000c93458326369UL;
   tf->codes[1237] = 0x0000c93492c1692eUL;
   tf->codes[1238] = 0x0000c935f21b8bccUL;
   tf->codes[1239] = 0x0000c9375175ae6aUL;
   tf->codes[1240] = 0x0000c9378c04b42fUL;
   tf->codes[1241] = 0x0000c9380122bfb9UL;
   tf->codes[1242] = 0x0000c9387640cb43UL;
   tf->codes[1243] = 0x0000c9399b0be81cUL;
   tf->codes[1244] = 0x0000c93a4ab8f96bUL;
   tf->codes[1245] = 0x0000c93afa660abaUL;
   tf->codes[1246] = 0x0000c93baa131c09UL;
   tf->codes[1247] = 0x0000c93be4a221ceUL;
   tf->codes[1248] = 0x0000c93c1f312793UL;
   tf->codes[1249] = 0x0000c93c944f331dUL;
   tf->codes[1250] = 0x0000c93e2e385b80UL;
   tf->codes[1251] = 0x0000c93ea356670aUL;
   tf->codes[1252] = 0x0000c93fc82183e3UL;
   tf->codes[1253] = 0x0000c94002b089a8UL;
   tf->codes[1254] = 0x0000c9403d3f8f6dUL;
   tf->codes[1255] = 0x0000c941620aac46UL;
   tf->codes[1256] = 0x0000c941d728b7d0UL;
   tf->codes[1257] = 0x0000c94211b7bd95UL;
   tf->codes[1258] = 0x0000c9424c46c35aUL;
   tf->codes[1259] = 0x0000c942fbf3d4a9UL;
   tf->codes[1260] = 0x0000c9437111e033UL;
   tf->codes[1261] = 0x0000c94420bef182UL;
   tf->codes[1262] = 0x0000c944d06c02d1UL;
   tf->codes[1263] = 0x0000c945f5371faaUL;
   tf->codes[1264] = 0x0000c9466a552b34UL;
   tf->codes[1265] = 0x0000c946a4e430f9UL;
   tf->codes[1266] = 0x0000c946df7336beUL;
   tf->codes[1267] = 0x0000c94754914248UL;
   tf->codes[1268] = 0x0000c9478f20480dUL;
   tf->codes[1269] = 0x0000c949d8b681bfUL;
   tf->codes[1270] = 0x0000c94a13458784UL;
   tf->codes[1271] = 0x0000c94a4dd48d49UL;
   tf->codes[1272] = 0x0000c94afd819e98UL;
   tf->codes[1273] = 0x0000c94b729faa22UL;
   tf->codes[1274] = 0x0000c94c5cdbc136UL;
   tf->codes[1275] = 0x0000c94dbc35e3d4UL;
   tf->codes[1276] = 0x0000c94ea671fae8UL;
   tf->codes[1277] = 0x0000c94ee10100adUL;
   tf->codes[1278] = 0x0000c94f1b900672UL;
   tf->codes[1279] = 0x0000c950405b234bUL;
   tf->codes[1280] = 0x0000c950f008349aUL;
   tf->codes[1281] = 0x0000c95165264024UL;
   tf->codes[1282] = 0x0000c951da444baeUL;
   tf->codes[1283] = 0x0000c952ff0f6887UL;
   tf->codes[1284] = 0x0000c953399e6e4cUL;
   tf->codes[1285] = 0x0000c953742d7411UL;
   tf->codes[1286] = 0x0000c953e94b7f9bUL;
   tf->codes[1287] = 0x0000c9545e698b25UL;
   tf->codes[1288] = 0x0000c95498f890eaUL;
   tf->codes[1289] = 0x0000c954d38796afUL;
   tf->codes[1290] = 0x0000c95548a5a239UL;
   tf->codes[1291] = 0x0000c955bdc3adc3UL;
   tf->codes[1292] = 0x0000c955f852b388UL;
   tf->codes[1293] = 0x0000c95632e1b94dUL;
   tf->codes[1294] = 0x0000c957923bdbebUL;
   tf->codes[1295] = 0x0000c957cccae1b0UL;
   tf->codes[1296] = 0x0000c95b3b2c383bUL;
   tf->codes[1297] = 0x0000c95bb04a43c5UL;
   tf->codes[1298] = 0x0000c95cd515609eUL;
   tf->codes[1299] = 0x0000c95ea98d8ec6UL;
   tf->codes[1300] = 0x0000c95f593aa015UL;
   tf->codes[1301] = 0x0000c960b894c2b3UL;
   tf->codes[1302] = 0x0000c960f323c878UL;
   tf->codes[1303] = 0x0000c961a2d0d9c7UL;
   tf->codes[1304] = 0x0000c9628d0cf0dbUL;
   tf->codes[1305] = 0x0000c962c79bf6a0UL;
   tf->codes[1306] = 0x0000c963774907efUL;
   tf->codes[1307] = 0x0000c96461851f03UL;
   tf->codes[1308] = 0x0000c96586503bdcUL;
   tf->codes[1309] = 0x0000c965c0df41a1UL;
   tf->codes[1310] = 0x0000c965fb6e4766UL;
   tf->codes[1311] = 0x0000c96635fd4d2bUL;
   tf->codes[1312] = 0x0000c966e5aa5e7aUL;
   tf->codes[1313] = 0x0000c96795576fc9UL;
   tf->codes[1314] = 0x0000c967cfe6758eUL;
   tf->codes[1315] = 0x0000c9680a757b53UL;
   tf->codes[1316] = 0x0000c968f4b19267UL;
   tf->codes[1317] = 0x0000c9692f40982cUL;
   tf->codes[1318] = 0x0000c969a45ea3b6UL;
   tf->codes[1319] = 0x0000c96a8e9abacaUL;
   tf->codes[1320] = 0x0000c96dfcfc1155UL;
   tf->codes[1321] = 0x0000c96e721a1cdfUL;
   tf->codes[1322] = 0x0000c96ee7382869UL;
   tf->codes[1323] = 0x0000c970812150ccUL;
   tf->codes[1324] = 0x0000c971a5ec6da5UL;
   tf->codes[1325] = 0x0000c97305469043UL;
   tf->codes[1326] = 0x0000c975144dc430UL;
   tf->codes[1327] = 0x0000c9763918e109UL;
   tf->codes[1328] = 0x0000c9772354f81dUL;
   tf->codes[1329] = 0x0000c978f7cd2645UL;
   tf->codes[1330] = 0x0000c979325c2c0aUL;
   tf->codes[1331] = 0x0000c97a1c98431eUL;
   tf->codes[1332] = 0x0000c97a91b64ea8UL;
   tf->codes[1333] = 0x0000c97acc45546dUL;
   tf->codes[1334] = 0x0000c97b41635ff7UL;
   tf->codes[1335] = 0x0000c97b7bf265bcUL;
   tf->codes[1336] = 0x0000c97bf1107146UL;
   tf->codes[1337] = 0x0000c97cdb4c885aUL;
   tf->codes[1338] = 0x0000c97d15db8e1fUL;
   tf->codes[1339] = 0x0000c97d506a93e4UL;
   tf->codes[1340] = 0x0000c97dc5889f6eUL;
   tf->codes[1341] = 0x0000c97f9a00cd96UL;
   tf->codes[1342] = 0x0000c9800f1ed920UL;
   tf->codes[1343] = 0x0000c980843ce4aaUL;
   tf->codes[1344] = 0x0000c98133e9f5f9UL;
   tf->codes[1345] = 0x0000c981a9080183UL;
   tf->codes[1346] = 0x0000c98342f129e6UL;
   tf->codes[1347] = 0x0000c983b80f3570UL;
   tf->codes[1348] = 0x0000c9842d2d40faUL;
   tf->codes[1349] = 0x0000c984a24b4c84UL;
   tf->codes[1350] = 0x0000c9851769580eUL;
   tf->codes[1351] = 0x0000c98601a56f22UL;
   tf->codes[1352] = 0x0000c986b1528071UL;
   tf->codes[1353] = 0x0000c9879b8e9785UL;
   tf->codes[1354] = 0x0000c987d61d9d4aUL;
   tf->codes[1355] = 0x0000c988c059b45eUL;
   tf->codes[1356] = 0x0000c98a94d1e286UL;
   tf->codes[1357] = 0x0000c98acf60e84bUL;
   tf->codes[1358] = 0x0000c98b447ef3d5UL;
   tf->codes[1359] = 0x0000c98b7f0df99aUL;
   tf->codes[1360] = 0x0000c98bf42c0524UL;
   tf->codes[1361] = 0x0000c98c694a10aeUL;
   tf->codes[1362] = 0x0000c98e03333911UL;
   tf->codes[1363] = 0x0000c98f628d5bafUL;
   tf->codes[1364] = 0x0000c98fd7ab6739UL;
   tf->codes[1365] = 0x0000c990123a6cfeUL;
   tf->codes[1366] = 0x0000c990fc768412UL;
   tf->codes[1367] = 0x0000c991370589d7UL;
   tf->codes[1368] = 0x0000c991e6b29b26UL;
   tf->codes[1369] = 0x0000c9925bd0a6b0UL;
   tf->codes[1370] = 0x0000c9930b7db7ffUL;
   tf->codes[1371] = 0x0000c993f5b9cf13UL;
   tf->codes[1372] = 0x0000c994a566e062UL;
   tf->codes[1373] = 0x0000c994dff5e627UL;
   tf->codes[1374] = 0x0000c995ca31fd3bUL;
   tf->codes[1375] = 0x0000c9963f5008c5UL;
   tf->codes[1376] = 0x0000c997298c1fd9UL;
   tf->codes[1377] = 0x0000c997641b259eUL;
   tf->codes[1378] = 0x0000c997d9393128UL;
   tf->codes[1379] = 0x0000c998c375483cUL;
   tf->codes[1380] = 0x0000c9997322598bUL;
   tf->codes[1381] = 0x0000c999e8406515UL;
   tf->codes[1382] = 0x0000c99b0d0b81eeUL;
   tf->codes[1383] = 0x0000c99b479a87b3UL;
   tf->codes[1384] = 0x0000c99ca6f4aa51UL;
   tf->codes[1385] = 0x0000c99d1c12b5dbUL;
   tf->codes[1386] = 0x0000c99d56a1bba0UL;
   tf->codes[1387] = 0x0000c99ef08ae403UL;
   tf->codes[1388] = 0x0000c99fa037f552UL;
   tf->codes[1389] = 0x0000c9a04fe506a1UL;
   tf->codes[1390] = 0x0000c9a13a211db5UL;
   tf->codes[1391] = 0x0000c9a25eec3a8eUL;
   tf->codes[1392] = 0x0000c9a383b75767UL;
   tf->codes[1393] = 0x0000c9a3be465d2cUL;
   tf->codes[1394] = 0x0000c9a4336468b6UL;
   tf->codes[1395] = 0x0000c9a4a8827440UL;
   tf->codes[1396] = 0x0000c9a51da07fcaUL;
   tf->codes[1397] = 0x0000c9a5cd4d9119UL;
   tf->codes[1398] = 0x0000c9a6426b9ca3UL;
   tf->codes[1399] = 0x0000c9a6b789a82dUL;
   tf->codes[1400] = 0x0000c9a7dc54c506UL;
   tf->codes[1401] = 0x0000c9a85172d090UL;
   tf->codes[1402] = 0x0000c9a9011fe1dfUL;
   tf->codes[1403] = 0x0000c9a9763ded69UL;
   tf->codes[1404] = 0x0000c9aa9b090a42UL;
   tf->codes[1405] = 0x0000c9aad5981007UL;
   tf->codes[1406] = 0x0000c9ab102715ccUL;
   tf->codes[1407] = 0x0000c9ab4ab61b91UL;
   tf->codes[1408] = 0x0000c9ab85452156UL;
   tf->codes[1409] = 0x0000c9ad59bd4f7eUL;
   tf->codes[1410] = 0x0000c9ae096a60cdUL;
   tf->codes[1411] = 0x0000c9aeb917721cUL;
   tf->codes[1412] = 0x0000c9afdde28ef5UL;
   tf->codes[1413] = 0x0000c9b08d8fa044UL;
   tf->codes[1414] = 0x0000c9b0c81ea609UL;
   tf->codes[1415] = 0x0000c9b1b25abd1dUL;
   tf->codes[1416] = 0x0000c9b1ece9c2e2UL;
   tf->codes[1417] = 0x0000c9b3fbf0f6cfUL;
   tf->codes[1418] = 0x0000c9b4ab9e081eUL;
   tf->codes[1419] = 0x0000c9b4e62d0de3UL;
   tf->codes[1420] = 0x0000c9b520bc13a8UL;
   tf->codes[1421] = 0x0000c9b595da1f32UL;
   tf->codes[1422] = 0x0000c9b6f53441d0UL;
   tf->codes[1423] = 0x0000c9b76a524d5aUL;
   tf->codes[1424] = 0x0000c9be81a40035UL;
   tf->codes[1425] = 0x0000c9bebc3305faUL;
   tf->codes[1426] = 0x0000c9bf31511184UL;
   tf->codes[1427] = 0x0000c9c0561c2e5dUL;
   tf->codes[1428] = 0x0000c9c0cb3a39e7UL;
   tf->codes[1429] = 0x0000c9c26523624aUL;
   tf->codes[1430] = 0x0000c9c314d07399UL;
   tf->codes[1431] = 0x0000c9c3ff0c8aadUL;
   tf->codes[1432] = 0x0000c9c4aeb99bfcUL;
   tf->codes[1433] = 0x0000c9c523d7a786UL;
   tf->codes[1434] = 0x0000c9c55e66ad4bUL;
   tf->codes[1435] = 0x0000c9c5d384b8d5UL;
   tf->codes[1436] = 0x0000c9c6bdc0cfe9UL;
   tf->codes[1437] = 0x0000c9c732dedb73UL;
   tf->codes[1438] = 0x0000c9c81d1af287UL;
   tf->codes[1439] = 0x0000c9ca2c222674UL;
   tf->codes[1440] = 0x0000c9cadbcf37c3UL;
   tf->codes[1441] = 0x0000c9cbc60b4ed7UL;
   tf->codes[1442] = 0x0000c9cd9a837cffUL;
   tf->codes[1443] = 0x0000c9ce84bf9413UL;
   tf->codes[1444] = 0x0000c9cfe419b6b1UL;
   tf->codes[1445] = 0x0000c9d1b891e4d9UL;
   tf->codes[1446] = 0x0000c9d317ec0777UL;
   tf->codes[1447] = 0x0000c9d3527b0d3cUL;
   tf->codes[1448] = 0x0000c9d402281e8bUL;
   tf->codes[1449] = 0x0000c9d4ec64359fUL;
   tf->codes[1450] = 0x0000c9d6112f5278UL;
   tf->codes[1451] = 0x0000c9d6c0dc63c7UL;
   tf->codes[1452] = 0x0000c9d97f90a903UL;
   tf->codes[1453] = 0x0000c9d9f4aeb48dUL;
   tf->codes[1454] = 0x0000c9da69ccc017UL;
   tf->codes[1455] = 0x0000c9daa45bc5dcUL;
   tf->codes[1456] = 0x0000c9db8e97dcf0UL;
   tf->codes[1457] = 0x0000c9dd28810553UL;
   tf->codes[1458] = 0x0000c9dd63100b18UL;
   tf->codes[1459] = 0x0000c9ddd82e16a2UL;
   tf->codes[1460] = 0x0000c9de4d4c222cUL;
   tf->codes[1461] = 0x0000c9defcf9337bUL;
   tf->codes[1462] = 0x0000c9e05c535619UL;
   tf->codes[1463] = 0x0000c9e0d17161a3UL;
   tf->codes[1464] = 0x0000c9e1811e72f2UL;
   tf->codes[1465] = 0x0000c9e230cb8441UL;
   tf->codes[1466] = 0x0000c9e26b5a8a06UL;
   tf->codes[1467] = 0x0000c9e2e0789590UL;
   tf->codes[1468] = 0x0000c9e35596a11aUL;
   tf->codes[1469] = 0x0000c9e39025a6dfUL;
   tf->codes[1470] = 0x0000c9e4ef7fc97dUL;
   tf->codes[1471] = 0x0000c9e64ed9ec1bUL;
   tf->codes[1472] = 0x0000c9e73916032fUL;
   tf->codes[1473] = 0x0000c9e8d2ff2b92UL;
   tf->codes[1474] = 0x0000c9e9481d371cUL;
   tf->codes[1475] = 0x0000c9e9f7ca486bUL;
   tf->codes[1476] = 0x0000c9ea6ce853f5UL;
   tf->codes[1477] = 0x0000c9eaa77759baUL;
   tf->codes[1478] = 0x0000c9eb1c956544UL;
   tf->codes[1479] = 0x0000c9eb57246b09UL;
   tf->codes[1480] = 0x0000c9ec4160821dUL;
   tf->codes[1481] = 0x0000c9ecb67e8da7UL;
   tf->codes[1482] = 0x0000c9ed2b9c9931UL;
   tf->codes[1483] = 0x0000c9eec585c194UL;
   tf->codes[1484] = 0x0000c9ef7532d2e3UL;
   tf->codes[1485] = 0x0000c9efea50de6dUL;
   tf->codes[1486] = 0x0000c9f149ab010bUL;
   tf->codes[1487] = 0x0000c9f1f958125aUL;
   tf->codes[1488] = 0x0000c9f26e761de4UL;
   tf->codes[1489] = 0x0000c9f2e394296eUL;
   tf->codes[1490] = 0x0000c9f31e232f33UL;
   tf->codes[1491] = 0x0000c9f393413abdUL;
   tf->codes[1492] = 0x0000c9f4085f4647UL;
   tf->codes[1493] = 0x0000c9f567b968e5UL;
   tf->codes[1494] = 0x0000c9f651f57ff9UL;
   tf->codes[1495] = 0x0000c9f73c31970dUL;
   tf->codes[1496] = 0x0000c9f8d61abf70UL;
   tf->codes[1497] = 0x0000c9f94b38cafaUL;
   tf->codes[1498] = 0x0000c9f9c056d684UL;
   tf->codes[1499] = 0x0000c9fa3574e20eUL;
   tf->codes[1500] = 0x0000c9faaa92ed98UL;
   tf->codes[1501] = 0x0000c9fbcf5e0a71UL;
   tf->codes[1502] = 0x0000c9fd694732d4UL;
   tf->codes[1503] = 0x0000c9fdde653e5eUL;
   tf->codes[1504] = 0x0000c9fe18f44423UL;
   tf->codes[1505] = 0x0000c9fe538349e8UL;
   tf->codes[1506] = 0x0000c9ff3dbf60fcUL;
   tf->codes[1507] = 0x0000ca00628a7dd5UL;
   tf->codes[1508] = 0x0000ca009d19839aUL;
   tf->codes[1509] = 0x0000ca0112378f24UL;
   tf->codes[1510] = 0x0000ca01c1e4a073UL;
   tf->codes[1511] = 0x0000ca027191b1c2UL;
   tf->codes[1512] = 0x0000ca02ac20b787UL;
   tf->codes[1513] = 0x0000ca03213ec311UL;
   tf->codes[1514] = 0x0000ca03d0ebd460UL;
   tf->codes[1515] = 0x0000ca040b7ada25UL;
   tf->codes[1516] = 0x0000ca044609dfeaUL;
   tf->codes[1517] = 0x0000ca04bb27eb74UL;
   tf->codes[1518] = 0x0000ca04f5b6f139UL;
   tf->codes[1519] = 0x0000ca05a5640288UL;
   tf->codes[1520] = 0x0000ca05dff3084dUL;
   tf->codes[1521] = 0x0000ca06ca2f1f61UL;
   tf->codes[1522] = 0x0000ca0704be2526UL;
   tf->codes[1523] = 0x0000ca0779dc30b0UL;
   tf->codes[1524] = 0x0000ca07eefa3c3aUL;
   tf->codes[1525] = 0x0000ca08d936534eUL;
   tf->codes[1526] = 0x0000ca0988e3649dUL;
   tf->codes[1527] = 0x0000ca09c3726a62UL;
   tf->codes[1528] = 0x0000ca0a389075ecUL;
   tf->codes[1529] = 0x0000ca0a731f7bb1UL;
   tf->codes[1530] = 0x0000ca0aadae8176UL;
   tf->codes[1531] = 0x0000ca0b5d5b92c5UL;
   tf->codes[1532] = 0x0000ca0cbcb5b563UL;
   tf->codes[1533] = 0x0000ca0cf744bb28UL;
   tf->codes[1534] = 0x0000ca0ecbbce950UL;
   tf->codes[1535] = 0x0000ca0f40daf4daUL;
   tf->codes[1536] = 0x0000ca0ff0880629UL;
   tf->codes[1537] = 0x0000ca10a0351778UL;
   tf->codes[1538] = 0x0000ca1115532302UL;
   tf->codes[1539] = 0x0000ca12af3c4b65UL;
   tf->codes[1540] = 0x0000ca12e9cb512aUL;
   tf->codes[1541] = 0x0000ca13245a56efUL;
   tf->codes[1542] = 0x0000ca14be437f52UL;
   tf->codes[1543] = 0x0000ca16582ca7b5UL;
   tf->codes[1544] = 0x0000ca1692bbad7aUL;
   tf->codes[1545] = 0x0000ca174268bec9UL;
   tf->codes[1546] = 0x0000ca19c68dfe40UL;
   tf->codes[1547] = 0x0000ca1a011d0405UL;
   tf->codes[1548] = 0x0000ca1d34ef54cbUL;
   tf->codes[1549] = 0x0000ca1d6f7e5a90UL;
   tf->codes[1550] = 0x0000ca1daa0d6055UL;
   tf->codes[1551] = 0x0000ca1de49c661aUL;
   tf->codes[1552] = 0x0000ca1f43f688b8UL;
   tf->codes[1553] = 0x0000ca1f7e858e7dUL;
   tf->codes[1554] = 0x0000ca1fb9149442UL;
   tf->codes[1555] = 0x0000ca202e329fccUL;
   tf->codes[1556] = 0x0000ca21186eb6e0UL;
   tf->codes[1557] = 0x0000ca218d8cc26aUL;
   tf->codes[1558] = 0x0000ca21c81bc82fUL;
   tf->codes[1559] = 0x0000ca22b257df43UL;
   tf->codes[1560] = 0x0000ca236204f092UL;
   tf->codes[1561] = 0x0000ca25367d1ebaUL;
   tf->codes[1562] = 0x0000ca25e62a3009UL;
   tf->codes[1563] = 0x0000ca2695d74158UL;
   tf->codes[1564] = 0x0000ca27baa25e31UL;
   tf->codes[1565] = 0x0000ca27f53163f6UL;
   tf->codes[1566] = 0x0000ca282fc069bbUL;
   tf->codes[1567] = 0x0000ca29548b8694UL;
   tf->codes[1568] = 0x0000ca29c9a9921eUL;
   tf->codes[1569] = 0x0000ca2b2903b4bcUL;
   tf->codes[1570] = 0x0000ca2c4dced195UL;
   tf->codes[1571] = 0x0000ca2cc2ecdd1fUL;
   tf->codes[1572] = 0x0000ca2d380ae8a9UL;
   tf->codes[1573] = 0x0000ca2fbc302820UL;
   tf->codes[1574] = 0x0000ca30314e33aaUL;
   tf->codes[1575] = 0x0000ca30e0fb44f9UL;
   tf->codes[1576] = 0x0000ca3156195083UL;
   tf->codes[1577] = 0x0000ca3240556797UL;
   tf->codes[1578] = 0x0000ca327ae46d5cUL;
   tf->codes[1579] = 0x0000ca32f00278e6UL;
   tf->codes[1580] = 0x0000ca34c47aa70eUL;
   tf->codes[1581] = 0x0000ca34ff09acd3UL;
   tf->codes[1582] = 0x0000ca357427b85dUL;
   tf->codes[1583] = 0x0000ca37832eec4aUL;
   tf->codes[1584] = 0x0000ca37bdbdf20fUL;
   tf->codes[1585] = 0x0000ca386d6b035eUL;
   tf->codes[1586] = 0x0000ca38a7fa0923UL;
   tf->codes[1587] = 0x0000ca391d1814adUL;
   tf->codes[1588] = 0x0000ca3992362037UL;
   tf->codes[1589] = 0x0000ca3a41e33186UL;
   tf->codes[1590] = 0x0000ca3a7c72374bUL;
   tf->codes[1591] = 0x0000ca3ab7013d10UL;
   tf->codes[1592] = 0x0000ca3b2c1f489aUL;
   tf->codes[1593] = 0x0000ca3c8b796b38UL;
   tf->codes[1594] = 0x0000ca3d009776c2UL;
   tf->codes[1595] = 0x0000ca3d3b267c87UL;
   tf->codes[1596] = 0x0000ca3e5ff19960UL;
   tf->codes[1597] = 0x0000ca3ff9dac1c3UL;
   tf->codes[1598] = 0x0000ca4208e1f5b0UL;
   tf->codes[1599] = 0x0000ca42f31e0cc4UL;
   tf->codes[1600] = 0x0000ca43683c184eUL;
   tf->codes[1601] = 0x0000ca4417e9299dUL;
   tf->codes[1602] = 0x0000ca45022540b1UL;
   tf->codes[1603] = 0x0000ca453cb44676UL;
   tf->codes[1604] = 0x0000ca4577434c3bUL;
   tf->codes[1605] = 0x0000ca45b1d25200UL;
   tf->codes[1606] = 0x0000ca45ec6157c5UL;
   tf->codes[1607] = 0x0000ca47112c749eUL;
   tf->codes[1608] = 0x0000ca474bbb7a63UL;
   tf->codes[1609] = 0x0000ca492033a88bUL;
   tf->codes[1610] = 0x0000ca495ac2ae50UL;
   tf->codes[1611] = 0x0000ca499551b415UL;
   tf->codes[1612] = 0x0000ca4af4abd6b3UL;
   tf->codes[1613] = 0x0000ca4ba458e802UL;
   tf->codes[1614] = 0x0000ca4bdee7edc7UL;
   tf->codes[1615] = 0x0000ca4d3e421065UL;
   tf->codes[1616] = 0x0000ca4dedef21b4UL;
   tf->codes[1617] = 0x0000ca4e287e2779UL;
   tf->codes[1618] = 0x0000ca4e630d2d3eUL;
   tf->codes[1619] = 0x0000ca4e9d9c3303UL;
   tf->codes[1620] = 0x0000ca4ed82b38c8UL;
   tf->codes[1621] = 0x0000ca4f12ba3e8dUL;
   tf->codes[1622] = 0x0000ca4f4d494452UL;
   tf->codes[1623] = 0x0000ca4fc2674fdcUL;
   tf->codes[1624] = 0x0000ca4ffcf655a1UL;
   tf->codes[1625] = 0x0000ca5037855b66UL;
   tf->codes[1626] = 0x0000ca507214612bUL;
   tf->codes[1627] = 0x0000ca50aca366f0UL;
   tf->codes[1628] = 0x0000ca5121c1727aUL;
   tf->codes[1629] = 0x0000ca515c50783fUL;
   tf->codes[1630] = 0x0000ca52468c8f53UL;
   tf->codes[1631] = 0x0000ca52811b9518UL;
   tf->codes[1632] = 0x0000ca52bbaa9addUL;
   tf->codes[1633] = 0x0000ca54cab1cecaUL;
   tf->codes[1634] = 0x0000ca55ef7ceba3UL;
   tf->codes[1635] = 0x0000ca57c3f519cbUL;
   tf->codes[1636] = 0x0000ca57fe841f90UL;
   tf->codes[1637] = 0x0000ca5839132555UL;
   tf->codes[1638] = 0x0000ca5873a22b1aUL;
   tf->codes[1639] = 0x0000ca58ae3130dfUL;
   tf->codes[1640] = 0x0000ca595dde422eUL;
   tf->codes[1641] = 0x0000ca59986d47f3UL;
   tf->codes[1642] = 0x0000ca59d2fc4db8UL;
   tf->codes[1643] = 0x0000ca5b32567056UL;
   tf->codes[1644] = 0x0000ca5c1c92876aUL;
   tf->codes[1645] = 0x0000ca5c91b092f4UL;
   tf->codes[1646] = 0x0000ca5db67bafcdUL;
   tf->codes[1647] = 0x0000ca5e6628c11cUL;
   tf->codes[1648] = 0x0000ca60ea4e0093UL;
   tf->codes[1649] = 0x0000ca6199fb11e2UL;
   tf->codes[1650] = 0x0000ca620f191d6cUL;
   tf->codes[1651] = 0x0000ca62843728f6UL;
   tf->codes[1652] = 0x0000ca63e3914b94UL;
   tf->codes[1653] = 0x0000ca6458af571eUL;
   tf->codes[1654] = 0x0000ca6667b68b0bUL;
   tf->codes[1655] = 0x0000ca678c81a7e4UL;
   tf->codes[1656] = 0x0000ca67c710ada9UL;
   tf->codes[1657] = 0x0000ca683c2eb933UL;
   tf->codes[1658] = 0x0000ca69d617e196UL;
   tf->codes[1659] = 0x0000ca6a85c4f2e5UL;
   tf->codes[1660] = 0x0000ca6b35720434UL;
   tf->codes[1661] = 0x0000ca6b700109f9UL;
   tf->codes[1662] = 0x0000ca6be51f1583UL;
   tf->codes[1663] = 0x0000ca6d44793821UL;
   tf->codes[1664] = 0x0000ca6df4264970UL;
   tf->codes[1665] = 0x0000ca6e2eb54f35UL;
   tf->codes[1666] = 0x0000ca6f8e0f71d3UL;
   tf->codes[1667] = 0x0000ca703dbc8322UL;
   tf->codes[1668] = 0x0000ca70784b88e7UL;
   tf->codes[1669] = 0x0000ca7162879ffbUL;
   tf->codes[1670] = 0x0000ca719d16a5c0UL;
   tf->codes[1671] = 0x0000ca71d7a5ab85UL;
   tf->codes[1672] = 0x0000ca728752bcd4UL;
   tf->codes[1673] = 0x0000ca72c1e1c299UL;
   tf->codes[1674] = 0x0000ca72fc70c85eUL;
   tf->codes[1675] = 0x0000ca7336ffce23UL;
   tf->codes[1676] = 0x0000ca73ac1dd9adUL;
   tf->codes[1677] = 0x0000ca75bb250d9aUL;
   tf->codes[1678] = 0x0000ca7630431924UL;
   tf->codes[1679] = 0x0000ca771a7f3038UL;
   tf->codes[1680] = 0x0000ca78eef75e60UL;
   tf->codes[1681] = 0x0000ca7be83aa961UL;
   tf->codes[1682] = 0x0000ca7c97e7bab0UL;
   tf->codes[1683] = 0x0000ca7fcbba0b76UL;
   tf->codes[1684] = 0x0000ca807b671cc5UL;
   tf->codes[1685] = 0x0000ca8165a333d9UL;
   tf->codes[1686] = 0x0000ca81dac13f63UL;
   tf->codes[1687] = 0x0000ca8215504528UL;
   tf->codes[1688] = 0x0000ca82ff8c5c3cUL;
   tf->codes[1689] = 0x0000ca8374aa67c6UL;
   tf->codes[1690] = 0x0000ca845ee67edaUL;
   tf->codes[1691] = 0x0000ca849975849fUL;
   tf->codes[1692] = 0x0000ca84d4048a64UL;
   tf->codes[1693] = 0x0000ca850e939029UL;
   tf->codes[1694] = 0x0000ca8583b19bb3UL;
   tf->codes[1695] = 0x0000ca86335ead02UL;
   tf->codes[1696] = 0x0000ca866dedb2c7UL;
   tf->codes[1697] = 0x0000ca86a87cb88cUL;
   tf->codes[1698] = 0x0000ca871d9ac416UL;
   tf->codes[1699] = 0x0000ca87cd47d565UL;
   tf->codes[1700] = 0x0000ca887cf4e6b4UL;
   tf->codes[1701] = 0x0000ca89dc4f0952UL;
   tf->codes[1702] = 0x0000ca8ac68b2066UL;
   tf->codes[1703] = 0x0000ca8b763831b5UL;
   tf->codes[1704] = 0x0000ca8beb563d3fUL;
   tf->codes[1705] = 0x0000ca8d10215a18UL;
   tf->codes[1706] = 0x0000ca8d4ab05fddUL;
   tf->codes[1707] = 0x0000ca8eaa0a827bUL;
   tf->codes[1708] = 0x0000ca8f1f288e05UL;
   tf->codes[1709] = 0x0000ca8f9446998fUL;
   tf->codes[1710] = 0x0000ca8fced59f54UL;
   tf->codes[1711] = 0x0000ca907e82b0a3UL;
   tf->codes[1712] = 0x0000ca9168bec7b7UL;
   tf->codes[1713] = 0x0000ca91dddcd341UL;
   tf->codes[1714] = 0x0000ca92186bd906UL;
   tf->codes[1715] = 0x0000ca928d89e490UL;
   tf->codes[1716] = 0x0000ca94620212b8UL;
   tf->codes[1717] = 0x0000ca95fbeb3b1bUL;
   tf->codes[1718] = 0x0000ca97d0636943UL;
   tf->codes[1719] = 0x0000ca980af26f08UL;
   tf->codes[1720] = 0x0000ca9880107a92UL;
   tf->codes[1721] = 0x0000ca98f52e861cUL;
   tf->codes[1722] = 0x0000ca996a4c91a6UL;
   tf->codes[1723] = 0x0000ca9a19f9a2f5UL;
   tf->codes[1724] = 0x0000ca9b3ec4bfceUL;
   tf->codes[1725] = 0x0000ca9ee7b51c1eUL;
   tf->codes[1726] = 0x0000ca9f5cd327a8UL;
   tf->codes[1727] = 0x0000ca9f97622d6dUL;
   tf->codes[1728] = 0x0000caa1a669615aUL;
   tf->codes[1729] = 0x0000caa2cb347e33UL;
   tf->codes[1730] = 0x0000caa3405289bdUL;
   tf->codes[1731] = 0x0000caa37ae18f82UL;
   tf->codes[1732] = 0x0000caa3b5709547UL;
   tf->codes[1733] = 0x0000caa4651da696UL;
   tf->codes[1734] = 0x0000caa6aeb3e048UL;
   tf->codes[1735] = 0x0000caa75e60f197UL;
   tf->codes[1736] = 0x0000caa96d682584UL;
   tf->codes[1737] = 0x0000caa9a7f72b49UL;
   tf->codes[1738] = 0x0000caaa1d1536d3UL;
   tf->codes[1739] = 0x0000caaa57a43c98UL;
   tf->codes[1740] = 0x0000caaa9233425dUL;
   tf->codes[1741] = 0x0000caab07514de7UL;
   tf->codes[1742] = 0x0000caabb6fe5f36UL;
   tf->codes[1743] = 0x0000caabf18d64fbUL;
   tf->codes[1744] = 0x0000caad165881d4UL;
   tf->codes[1745] = 0x0000caad8b768d5eUL;
   tf->codes[1746] = 0x0000caadc6059323UL;
   tf->codes[1747] = 0x0000caae009498e8UL;
   tf->codes[1748] = 0x0000caaeb041aa37UL;
   tf->codes[1749] = 0x0000cab084b9d85fUL;
   tf->codes[1750] = 0x0000cab13466e9aeUL;
   tf->codes[1751] = 0x0000cab259320687UL;
   tf->codes[1752] = 0x0000cab293c10c4cUL;
   tf->codes[1753] = 0x0000cab468393a74UL;
   tf->codes[1754] = 0x0000cab677406e61UL;
   tf->codes[1755] = 0x0000cab6b1cf7426UL;
   tf->codes[1756] = 0x0000cab79c0b8b3aUL;
   tf->codes[1757] = 0x0000cab7d69a90ffUL;
   tf->codes[1758] = 0x0000cab8112996c4UL;
   tf->codes[1759] = 0x0000cab8c0d6a813UL;
   tf->codes[1760] = 0x0000cab935f4b39dUL;
   tf->codes[1761] = 0x0000cab9e5a1c4ecUL;
   tf->codes[1762] = 0x0000caba5abfd076UL;
   tf->codes[1763] = 0x0000cabbf4a8f8d9UL;
   tf->codes[1764] = 0x0000cabdc9212701UL;
   tf->codes[1765] = 0x0000cabe03b02cc6UL;
   tf->codes[1766] = 0x0000cac087d56c3dUL;
   tf->codes[1767] = 0x0000cac0c2647202UL;
   tf->codes[1768] = 0x0000cac137827d8cUL;
   tf->codes[1769] = 0x0000cac1aca08916UL;
   tf->codes[1770] = 0x0000cac221be94a0UL;
   tf->codes[1771] = 0x0000cac30bfaabb4UL;
   tf->codes[1772] = 0x0000cac3f636c2c8UL;
   tf->codes[1773] = 0x0000cac46b54ce52UL;
   tf->codes[1774] = 0x0000cac4e072d9dcUL;
   tf->codes[1775] = 0x0000cac5901feb2bUL;
   tf->codes[1776] = 0x0000cac5caaef0f0UL;
   tf->codes[1777] = 0x0000cac67a5c023fUL;
   tf->codes[1778] = 0x0000cac6ef7a0dc9UL;
   tf->codes[1779] = 0x0000cac764981953UL;
   tf->codes[1780] = 0x0000cac84ed43067UL;
   tf->codes[1781] = 0x0000cac88963362cUL;
   tf->codes[1782] = 0x0000cac8fe8141b6UL;
   tf->codes[1783] = 0x0000cac93910477bUL;
   tf->codes[1784] = 0x0000cacb48177b68UL;
   tf->codes[1785] = 0x0000cacbf7c48cb7UL;
   tf->codes[1786] = 0x0000cacdcc3cbadfUL;
   tf->codes[1787] = 0x0000cace415ac669UL;
   tf->codes[1788] = 0x0000cace7be9cc2eUL;
   tf->codes[1789] = 0x0000cacf6625e342UL;
   tf->codes[1790] = 0x0000cad299f83408UL;
   tf->codes[1791] = 0x0000cad2d48739cdUL;
   tf->codes[1792] = 0x0000cad30f163f92UL;
   tf->codes[1793] = 0x0000cad384344b1cUL;
   tf->codes[1794] = 0x0000cad51e1d737fUL;
   tf->codes[1795] = 0x0000cad558ac7944UL;
   tf->codes[1796] = 0x0000cad6b8069be2UL;
   tf->codes[1797] = 0x0000cad72d24a76cUL;
   tf->codes[1798] = 0x0000cad851efc445UL;
   tf->codes[1799] = 0x0000cad88c7eca0aUL;
   tf->codes[1800] = 0x0000cad8c70dcfcfUL;
   tf->codes[1801] = 0x0000cad93c2bdb59UL;
   tf->codes[1802] = 0x0000cadce51c37a9UL;
   tf->codes[1803] = 0x0000cadd5a3a4333UL;
   tf->codes[1804] = 0x0000cadfa3d07ce5UL;
   tf->codes[1805] = 0x0000cae08e0c93f9UL;
   tf->codes[1806] = 0x0000cae13db9a548UL;
   tf->codes[1807] = 0x0000cae1b2d7b0d2UL;
   tf->codes[1808] = 0x0000cae1ed66b697UL;
   tf->codes[1809] = 0x0000cae26284c221UL;
   tf->codes[1810] = 0x0000cae31231d370UL;
   tf->codes[1811] = 0x0000cae730403b4aUL;
   tf->codes[1812] = 0x0000cae76acf410fUL;
   tf->codes[1813] = 0x0000cae81a7c525eUL;
   tf->codes[1814] = 0x0000cae8550b5823UL;
   tf->codes[1815] = 0x0000cae8ca2963adUL;
   tf->codes[1816] = 0x0000cae9b4657ac1UL;
   tf->codes[1817] = 0x0000caea9ea191d5UL;
   tf->codes[1818] = 0x0000caead930979aUL;
   tf->codes[1819] = 0x0000caee0d02e860UL;
   tf->codes[1820] = 0x0000caf140d53926UL;
   tf->codes[1821] = 0x0000caf265a055ffUL;
   tf->codes[1822] = 0x0000caf2a02f5bc4UL;
   tf->codes[1823] = 0x0000caf4af368fb1UL;
   tf->codes[1824] = 0x0000caf55ee3a100UL;
   tf->codes[1825] = 0x0000caf60e90b24fUL;
   tf->codes[1826] = 0x0000caf942630315UL;
   tf->codes[1827] = 0x0000caf9f2101464UL;
   tf->codes[1828] = 0x0000cafc01174851UL;
   tf->codes[1829] = 0x0000cafc763553dbUL;
   tf->codes[1830] = 0x0000cafd60716aefUL;
   tf->codes[1831] = 0x0000cafd9b0070b4UL;
   tf->codes[1832] = 0x0000cafefa5a9352UL;
   tf->codes[1833] = 0x0000caff34e99917UL;
   tf->codes[1834] = 0x0000caffe496aa66UL;
   tf->codes[1835] = 0x0000cb001f25b02bUL;
   tf->codes[1836] = 0x0000cb010961c73fUL;
   tf->codes[1837] = 0x0000cb0143f0cd04UL;
   tf->codes[1838] = 0x0000cb022e2ce418UL;
   tf->codes[1839] = 0x0000cb038d8706b6UL;
   tf->codes[1840] = 0x0000cb04b252238fUL;
   tf->codes[1841] = 0x0000cb0527702f19UL;
   tf->codes[1842] = 0x0000cb059c8e3aa3UL;
   tf->codes[1843] = 0x0000cb064c3b4bf2UL;
   tf->codes[1844] = 0x0000cb0686ca51b7UL;
   tf->codes[1845] = 0x0000cb06fbe85d41UL;
   tf->codes[1846] = 0x0000cb085b427fdfUL;
   tf->codes[1847] = 0x0000cb08d0608b69UL;
   tf->codes[1848] = 0x0000cb09800d9cb8UL;
   tf->codes[1849] = 0x0000cb0d28fdf908UL;
   tf->codes[1850] = 0x0000cb0ec2e7216bUL;
   tf->codes[1851] = 0x0000cb0fe7b23e44UL;
   tf->codes[1852] = 0x0000cb12e0f58945UL;
   tf->codes[1853] = 0x0000cb131b848f0aUL;
   tf->codes[1854] = 0x0000cb13cb31a059UL;
   tf->codes[1855] = 0x0000cb152a8bc2f7UL;
   tf->codes[1856] = 0x0000cb15da38d446UL;
   tf->codes[1857] = 0x0000cb16ff03f11fUL;
   tf->codes[1858] = 0x0000cb1823cf0df8UL;
   tf->codes[1859] = 0x0000cb185e5e13bdUL;
   tf->codes[1860] = 0x0000cb18d37c1f47UL;
   tf->codes[1861] = 0x0000cb190e0b250cUL;
   tf->codes[1862] = 0x0000cb1a6d6547aaUL;
   tf->codes[1863] = 0x0000cb1ddbc69e35UL;
   tf->codes[1864] = 0x0000cb1e1655a3faUL;
   tf->codes[1865] = 0x0000cb1e8b73af84UL;
   tf->codes[1866] = 0x0000cb1ec602b549UL;
   tf->codes[1867] = 0x0000cb1f0091bb0eUL;
   tf->codes[1868] = 0x0000cb1feacdd222UL;
   tf->codes[1869] = 0x0000cb20d509e936UL;
   tf->codes[1870] = 0x0000cb2234640bd4UL;
   tf->codes[1871] = 0x0000cb231ea022e8UL;
   tf->codes[1872] = 0x0000cb2408dc39fcUL;
   tf->codes[1873] = 0x0000cb27ec5b9c11UL;
   tf->codes[1874] = 0x0000cb2a7080db88UL;
   tf->codes[1875] = 0x0000cb2aab0fe14dUL;
   tf->codes[1876] = 0x0000cb2b5abcf29cUL;
   tf->codes[1877] = 0x0000cb2ddee23213UL;
   tf->codes[1878] = 0x0000cb2fede96600UL;
   tf->codes[1879] = 0x0000cb3028786bc5UL;
   tf->codes[1880] = 0x0000cb31c2619428UL;
   tf->codes[1881] = 0x0000cb31fcf099edUL;
   tf->codes[1882] = 0x0000cb32720ea577UL;
   tf->codes[1883] = 0x0000cb3321bbb6c6UL;
   tf->codes[1884] = 0x0000cb35a5e0f63dUL;
   tf->codes[1885] = 0x0000cb361aff01c7UL;
   tf->codes[1886] = 0x0000cb36901d0d51UL;
   tf->codes[1887] = 0x0000cb3864953b79UL;
   tf->codes[1888] = 0x0000cb3989605852UL;
   tf->codes[1889] = 0x0000cb3ae8ba7af0UL;
   tf->codes[1890] = 0x0000cb3b234980b5UL;
   tf->codes[1891] = 0x0000cb3c48149d8eUL;
   tf->codes[1892] = 0x0000cb3da76ec02cUL;
   tf->codes[1893] = 0x0000cb3e91aad740UL;
   tf->codes[1894] = 0x0000cb3f4157e88fUL;
   tf->codes[1895] = 0x0000cb3fb675f419UL;
   tf->codes[1896] = 0x0000cb41c57d2806UL;
   tf->codes[1897] = 0x0000cb42000c2dcbUL;
   tf->codes[1898] = 0x0000cb440f1361b8UL;
   tf->codes[1899] = 0x0000cb45a8fc8a1bUL;
   tf->codes[1900] = 0x0000cb45e38b8fe0UL;
   tf->codes[1901] = 0x0000cb4658a99b6aUL;
   tf->codes[1902] = 0x0000cb469338a12fUL;
   tf->codes[1903] = 0x0000cb477d74b843UL;
   tf->codes[1904] = 0x0000cb4a76b80344UL;
   tf->codes[1905] = 0x0000cb4ab1470909UL;
   tf->codes[1906] = 0x0000cb4bd61225e2UL;
   tf->codes[1907] = 0x0000cb4c4b30316cUL;
   tf->codes[1908] = 0x0000cb4de51959cfUL;
   tf->codes[1909] = 0x0000cb4e1fa85f94UL;
   tf->codes[1910] = 0x0000cb4f09e476a8UL;
   tf->codes[1911] = 0x0000cb502eaf9381UL;
   tf->codes[1912] = 0x0000cb5118ebaa95UL;
   tf->codes[1913] = 0x0000cb527845cd33UL;
   tf->codes[1914] = 0x0000cb52b2d4d2f8UL;
   tf->codes[1915] = 0x0000cb53d79fefd1UL;
   tf->codes[1916] = 0x0000cb54874d0120UL;
   tf->codes[1917] = 0x0000cb54fc6b0caaUL;
   tf->codes[1918] = 0x0000cb5571891834UL;
   tf->codes[1919] = 0x0000cb55ac181df9UL;
   tf->codes[1920] = 0x0000cb570b724097UL;
   tf->codes[1921] = 0x0000cb57bb1f51e6UL;
   tf->codes[1922] = 0x0000cb58a55b68faUL;
   tf->codes[1923] = 0x0000cb591a797484UL;
   tf->codes[1924] = 0x0000cb598f97800eUL;
   tf->codes[1925] = 0x0000cb5a3f44915dUL;
   tf->codes[1926] = 0x0000cb5a79d39722UL;
   tf->codes[1927] = 0x0000cb5de834edadUL;
   tf->codes[1928] = 0x0000cb6031cb275fUL;
   tf->codes[1929] = 0x0000cb6156964438UL;
   tf->codes[1930] = 0x0000cb627b616111UL;
   tf->codes[1931] = 0x0000cb64c4f79ac3UL;
   tf->codes[1932] = 0x0000cb653a15a64dUL;
   tf->codes[1933] = 0x0000cb6574a4ac12UL;
   tf->codes[1934] = 0x0000cb662451bd61UL;
   tf->codes[1935] = 0x0000cb66996fc8ebUL;
   tf->codes[1936] = 0x0000cb670e8dd475UL;
   tf->codes[1937] = 0x0000cb67be3ae5c4UL;
   tf->codes[1938] = 0x0000cb691d950862UL;
   tf->codes[1939] = 0x0000cb6958240e27UL;
   tf->codes[1940] = 0x0000cb69cd4219b1UL;
   tf->codes[1941] = 0x0000cb6ab77e30c5UL;
   tf->codes[1942] = 0x0000cb6b672b4214UL;
   tf->codes[1943] = 0x0000cb6ba1ba47d9UL;
   tf->codes[1944] = 0x0000cb6c16d85363UL;
   tf->codes[1945] = 0x0000cb6e606e8d15UL;
   tf->codes[1946] = 0x0000cb6f101b9e64UL;
   tf->codes[1947] = 0x0000cb6f4aaaa429UL;
   tf->codes[1948] = 0x0000cb6fbfc8afb3UL;
   tf->codes[1949] = 0x0000cb711f22d251UL;
   tf->codes[1950] = 0x0000cb727e7cf4efUL;
   tf->codes[1951] = 0x0000cb7418661d52UL;
   tf->codes[1952] = 0x0000cb7502a23466UL;
   tf->codes[1953] = 0x0000cb753d313a2bUL;
   tf->codes[1954] = 0x0000cb7661fc5704UL;
   tf->codes[1955] = 0x0000cb783674852cUL;
   tf->codes[1956] = 0x0000cb7a0aecb354UL;
   tf->codes[1957] = 0x0000cb7a457bb919UL;
   tf->codes[1958] = 0x0000cb7db3dd0fa4UL;
   tf->codes[1959] = 0x0000cb7e9e1926b8UL;
   tf->codes[1960] = 0x0000cb80729154e0UL;
   tf->codes[1961] = 0x0000cb80ad205aa5UL;
   tf->codes[1962] = 0x0000cb820c7a7d43UL;
   tf->codes[1963] = 0x0000cb8247098308UL;
   tf->codes[1964] = 0x0000cb8331459a1cUL;
   tf->codes[1965] = 0x0000cb836bd49fe1UL;
   tf->codes[1966] = 0x0000cb83a663a5a6UL;
   tf->codes[1967] = 0x0000cb8505bdc844UL;
   tf->codes[1968] = 0x0000cb857adbd3ceUL;
   tf->codes[1969] = 0x0000cb86da35f66cUL;
   tf->codes[1970] = 0x0000cb874f5401f6UL;
   tf->codes[1971] = 0x0000cb87ff011345UL;
   tf->codes[1972] = 0x0000cb883990190aUL;
   tf->codes[1973] = 0x0000cb88741f1ecfUL;
   tf->codes[1974] = 0x0000cb88e93d2a59UL;
   tf->codes[1975] = 0x0000cb8923cc301eUL;
   tf->codes[1976] = 0x0000cb8a0e084732UL;
   tf->codes[1977] = 0x0000cb8be280755aUL;
   tf->codes[1978] = 0x0000cb8df187a947UL;
   tf->codes[1979] = 0x0000cb8e2c16af0cUL;
   tf->codes[1980] = 0x0000cb8e66a5b4d1UL;
   tf->codes[1981] = 0x0000cb8f8b70d1aaUL;
   tf->codes[1982] = 0x0000cb903b1de2f9UL;
   tf->codes[1983] = 0x0000cb919a780597UL;
   tf->codes[1984] = 0x0000cb941e9d450eUL;
   tf->codes[1985] = 0x0000cb9493bb5098UL;
   tf->codes[1986] = 0x0000cb94ce4a565dUL;
   tf->codes[1987] = 0x0000cb95436861e7UL;
   tf->codes[1988] = 0x0000cb95f3157336UL;
   tf->codes[1989] = 0x0000cb97526f95d4UL;
   tf->codes[1990] = 0x0000cb97c78da15eUL;
   tf->codes[1991] = 0x0000cb98ec58be37UL;
   tf->codes[1992] = 0x0000cb9c95491a87UL;
   tf->codes[1993] = 0x0000cb9d44f62bd6UL;
   tf->codes[1994] = 0x0000cb9e2f3242eaUL;
   tf->codes[1995] = 0x0000cb9f196e59feUL;
   tf->codes[1996] = 0x0000cb9fc91b6b4dUL;
   tf->codes[1997] = 0x0000cba003aa7112UL;
   tf->codes[1998] = 0x0000cba0ede68826UL;
   tf->codes[1999] = 0x0000cba19d939975UL;
   tf->codes[2000] = 0x0000cba24d40aac4UL;
   tf->codes[2001] = 0x0000cba287cfb089UL;
   tf->codes[2002] = 0x0000cba54683f5c5UL;
   tf->codes[2003] = 0x0000cba58112fb8aUL;
   tf->codes[2004] = 0x0000cba6a5de1863UL;
   tf->codes[2005] = 0x0000cba6e06d1e28UL;
   tf->codes[2006] = 0x0000cba964925d9fUL;
   tf->codes[2007] = 0x0000cbaa4ece74b3UL;
   tf->codes[2008] = 0x0000cbab390a8bc7UL;
   tf->codes[2009] = 0x0000cbabe8b79d16UL;
   tf->codes[2010] = 0x0000cbad82a0c579UL;
   tf->codes[2011] = 0x0000cbadf7bed103UL;
   tf->codes[2012] = 0x0000cbafcc36ff2bUL;
   tf->codes[2013] = 0x0000cbb07be4107aUL;
   tf->codes[2014] = 0x0000cbb0b673163fUL;
   tf->codes[2015] = 0x0000cbb12b9121c9UL;
   tf->codes[2016] = 0x0000cbb1a0af2d53UL;
   tf->codes[2017] = 0x0000cbb2c57a4a2cUL;
   tf->codes[2018] = 0x0000cbb45f63728fUL;
   tf->codes[2019] = 0x0000cbb6e388b206UL;
   tf->codes[2020] = 0x0000cbba175b02ccUL;
   tf->codes[2021] = 0x0000cbba8c790e56UL;
   tf->codes[2022] = 0x0000cbbd4b2d5392UL;
   tf->codes[2023] = 0x0000cbbee5167bf5UL;
   tf->codes[2024] = 0x0000cbbf1fa581baUL;
   tf->codes[2025] = 0x0000cbbf5a34877fUL;
   tf->codes[2026] = 0x0000cbc0f41dafe2UL;
   tf->codes[2027] = 0x0000cbc1de59c6f6UL;
   tf->codes[2028] = 0x0000cbc218e8ccbbUL;
   tf->codes[2029] = 0x0000cbc28e06d845UL;
   tf->codes[2030] = 0x0000cbc4d79d11f7UL;
   tf->codes[2031] = 0x0000cbc5874a2346UL;
   tf->codes[2032] = 0x0000cbc6ac15401fUL;
   tf->codes[2033] = 0x0000cbc6e6a445e4UL;
   tf->codes[2034] = 0x0000cbc721334ba9UL;
   tf->codes[2035] = 0x0000cbc796515733UL;
   tf->codes[2036] = 0x0000cbc8808d6e47UL;
   tf->codes[2037] = 0x0000cbc9303a7f96UL;
   tf->codes[2038] = 0x0000cbc9dfe790e5UL;
   tf->codes[2039] = 0x0000cbca8f94a234UL;
   tf->codes[2040] = 0x0000cbcb04b2adbeUL;
   tf->codes[2041] = 0x0000cbcb3f41b383UL;
   tf->codes[2042] = 0x0000cbcbeeeec4d2UL;
   tf->codes[2043] = 0x0000cbceada30a0eUL;
   tf->codes[2044] = 0x0000cbd0478c3271UL;
   tf->codes[2045] = 0x0000cbd0821b3836UL;
   tf->codes[2046] = 0x0000cbd1a6e6550fUL;
   tf->codes[2047] = 0x0000cbd1e1755ad4UL;
   tf->codes[2048] = 0x0000cbd25693665eUL;
   tf->codes[2049] = 0x0000cbd291226c23UL;
   tf->codes[2050] = 0x0000cbd3b5ed88fcUL;
   tf->codes[2051] = 0x0000cbd3f07c8ec1UL;
   tf->codes[2052] = 0x0000cbd42b0b9486UL;
   tf->codes[2053] = 0x0000cbd4a029a010UL;
   tf->codes[2054] = 0x0000cbd58a65b724UL;
   tf->codes[2055] = 0x0000cbd5c4f4bce9UL;
   tf->codes[2056] = 0x0000cbd7996ceb11UL;
   tf->codes[2057] = 0x0000cbd96de51939UL;
   tf->codes[2058] = 0x0000cbda1d922a88UL;
   tf->codes[2059] = 0x0000cbdcdc466fc4UL;
   tf->codes[2060] = 0x0000cbde762f9827UL;
   tf->codes[2061] = 0x0000cbdeb0be9decUL;
   tf->codes[2062] = 0x0000cbdeeb4da3b1UL;
   tf->codes[2063] = 0x0000cbe08536cc14UL;
   tf->codes[2064] = 0x0000cbe134e3dd63UL;
   tf->codes[2065] = 0x0000cbe16f72e328UL;
   tf->codes[2066] = 0x0000cbe1aa01e8edUL;
   tf->codes[2067] = 0x0000cbe37e7a1715UL;
   tf->codes[2068] = 0x0000cbe3f398229fUL;
   tf->codes[2069] = 0x0000cbe468b62e29UL;
   tf->codes[2070] = 0x0000cbe5c81050c7UL;
   tf->codes[2071] = 0x0000cbe6029f568cUL;
   tf->codes[2072] = 0x0000cbe63d2e5c51UL;
   tf->codes[2073] = 0x0000cbe7d71784b4UL;
   tf->codes[2074] = 0x0000cbe811a68a79UL;
   tf->codes[2075] = 0x0000cbe84c35903eUL;
   tf->codes[2076] = 0x0000cbe93671a752UL;
   tf->codes[2077] = 0x0000cbe9e61eb8a1UL;
   tf->codes[2078] = 0x0000cbee042d207bUL;
   tf->codes[2079] = 0x0000cbef28f83d54UL;
   tf->codes[2080] = 0x0000cbef9e1648deUL;
   tf->codes[2081] = 0x0000cbf137ff7141UL;
   tf->codes[2082] = 0x0000cbf1728e7706UL;
   tf->codes[2083] = 0x0000cbf1e7ac8290UL;
   tf->codes[2084] = 0x0000cbf38195aaf3UL;
   tf->codes[2085] = 0x0000cbf3bc24b0b8UL;
   tf->codes[2086] = 0x0000cbf5560dd91bUL;
   tf->codes[2087] = 0x0000cbf5cb2be4a5UL;
   tf->codes[2088] = 0x0000cbf79fa412cdUL;
   tf->codes[2089] = 0x0000cbf7da331892UL;
   tf->codes[2090] = 0x0000cbf84f51241cUL;
   tf->codes[2091] = 0x0000cbf889e029e1UL;
   tf->codes[2092] = 0x0000cbf9741c40f5UL;
   tf->codes[2093] = 0x0000cbfbbdb27aa7UL;
   tf->codes[2094] = 0x0000cbfc32d08631UL;
   tf->codes[2095] = 0x0000cbfd1d0c9d45UL;
   tf->codes[2096] = 0x0000cbfd922aa8cfUL;
   tf->codes[2097] = 0x0000cbfef184cb6dUL;
   tf->codes[2098] = 0x0000cbffa131dcbcUL;
   tf->codes[2099] = 0x0000cbffdbc0e281UL;
   tf->codes[2100] = 0x0000cc013b1b051fUL;
   tf->codes[2101] = 0x0000cc01b03910a9UL;
   tf->codes[2102] = 0x0000cc025fe621f8UL;
   tf->codes[2103] = 0x0000cc034a22390cUL;
   tf->codes[2104] = 0x0000cc03bf404496UL;
   tf->codes[2105] = 0x0000cc0608d67e48UL;
   tf->codes[2106] = 0x0000cc064365840dUL;
   tf->codes[2107] = 0x0000cc06b8838f97UL;
   tf->codes[2108] = 0x0000cc06f312955cUL;
   tf->codes[2109] = 0x0000cc072da19b21UL;
   tf->codes[2110] = 0x0000cc08c78ac384UL;
   tf->codes[2111] = 0x0000cc093ca8cf0eUL;
   tf->codes[2112] = 0x0000cc09b1c6da98UL;
   tf->codes[2113] = 0x0000cc0a26e4e622UL;
   tf->codes[2114] = 0x0000cc0ad691f771UL;
   tf->codes[2115] = 0x0000cc0b1120fd36UL;
   tf->codes[2116] = 0x0000cc0b863f08c0UL;
   tf->codes[2117] = 0x0000cc0c35ec1a0fUL;
   tf->codes[2118] = 0x0000cc0d5ab736e8UL;
   tf->codes[2119] = 0x0000cc0f2f2f6510UL;
   tf->codes[2120] = 0x0000cc108e8987aeUL;
   tf->codes[2121] = 0x0000cc10c9188d73UL;
   tf->codes[2122] = 0x0000cc1103a79338UL;
   tf->codes[2123] = 0x0000cc122872b011UL;
   tf->codes[2124] = 0x0000cc155c4500d7UL;
   tf->codes[2125] = 0x0000cc1596d4069cUL;
   tf->codes[2126] = 0x0000cc176b4c34c4UL;
   tf->codes[2127] = 0x0000cc189017519dUL;
   tf->codes[2128] = 0x0000cc19b4e26e76UL;
   tf->codes[2129] = 0x0000cc1a9f1e858aUL;
   tf->codes[2130] = 0x0000cc1ad9ad8b4fUL;
   tf->codes[2131] = 0x0000cc1c7396b3b2UL;
   tf->codes[2132] = 0x0000cc1d5dd2cac6UL;
   tf->codes[2133] = 0x0000cc1d9861d08bUL;
   tf->codes[2134] = 0x0000cc1dd2f0d650UL;
   tf->codes[2135] = 0x0000cc1fe1f80a3dUL;
   tf->codes[2136] = 0x0000cc217be132a0UL;
   tf->codes[2137] = 0x0000cc22661d49b4UL;
   tf->codes[2138] = 0x0000cc26499cabc9UL;
   tf->codes[2139] = 0x0000cc26842bb18eUL;
   tf->codes[2140] = 0x0000cc276e67c8a2UL;
   tf->codes[2141] = 0x0000cc27a8f6ce67UL;
   tf->codes[2142] = 0x0000cc2858a3dfb6UL;
   tf->codes[2143] = 0x0000cc289332e57bUL;
   tf->codes[2144] = 0x0000cc29b7fe0254UL;
   tf->codes[2145] = 0x0000cc2b175824f2UL;
   tf->codes[2146] = 0x0000cc2b51e72ab7UL;
   tf->codes[2147] = 0x0000cc2d60ee5ea4UL;
   tf->codes[2148] = 0x0000cc2ec0488142UL;
   tf->codes[2149] = 0x0000cc2f6ff59291UL;
   tf->codes[2150] = 0x0000cc305a31a9a5UL;
   tf->codes[2151] = 0x0000cc317efcc67eUL;
   tf->codes[2152] = 0x0000cc32a3c7e357UL;
   tf->codes[2153] = 0x0000cc32de56e91cUL;
   tf->codes[2154] = 0x0000cc3318e5eee1UL;
   tf->codes[2155] = 0x0000cc335374f4a6UL;
   tf->codes[2156] = 0x0000cc343db10bbaUL;
   tf->codes[2157] = 0x0000cc36122939e2UL;
   tf->codes[2158] = 0x0000cc37ac126245UL;
   tf->codes[2159] = 0x0000cc38d0dd7f1eUL;
   tf->codes[2160] = 0x0000cc39bb199632UL;
   tf->codes[2161] = 0x0000cc3b5502be95UL;
   tf->codes[2162] = 0x0000cc3ceeebe6f8UL;
   tf->codes[2163] = 0x0000cc3d6409f282UL;
   tf->codes[2164] = 0x0000cc3e13b703d1UL;
   tf->codes[2165] = 0x0000cc3ec3641520UL;
   tf->codes[2166] = 0x0000cc3efdf31ae5UL;
   tf->codes[2167] = 0x0000cc40d26b490dUL;
   tf->codes[2168] = 0x0000cc426c547170UL;
   tf->codes[2169] = 0x0000cc42e1727cfaUL;
   tf->codes[2170] = 0x0000cc43911f8e49UL;
   tf->codes[2171] = 0x0000cc45a026c236UL;
   tf->codes[2172] = 0x0000cc464fd3d385UL;
   tf->codes[2173] = 0x0000cc468a62d94aUL;
   tf->codes[2174] = 0x0000cc4aa8714124UL;
   tf->codes[2175] = 0x0000cc4b581e5273UL;
   tf->codes[2176] = 0x0000cc4b92ad5838UL;
   tf->codes[2177] = 0x0000cc4bcd3c5dfdUL;
   tf->codes[2178] = 0x0000cc4d2c96809bUL;
   tf->codes[2179] = 0x0000cc4e8bf0a339UL;
   tf->codes[2180] = 0x0000cc4f3b9db488UL;
   tf->codes[2181] = 0x0000cc509af7d726UL;
   tf->codes[2182] = 0x0000cc51fa51f9c4UL;
   tf->codes[2183] = 0x0000cc5234e0ff89UL;
   tf->codes[2184] = 0x0000cc52e48e10d8UL;
   tf->codes[2185] = 0x0000cc5568b3504fUL;
   tf->codes[2186] = 0x0000cc568d7e6d28UL;
   tf->codes[2187] = 0x0000cc56c80d72edUL;
   tf->codes[2188] = 0x0000cc57029c78b2UL;
   tf->codes[2189] = 0x0000cc5777ba843cUL;
   tf->codes[2190] = 0x0000cc589c85a115UL;
   tf->codes[2191] = 0x0000cc594c32b264UL;
   tf->codes[2192] = 0x0000cc5986c1b829UL;
   tf->codes[2193] = 0x0000cc59c150bdeeUL;
   tf->codes[2194] = 0x0000cc5c4575fd65UL;
   tf->codes[2195] = 0x0000cc5cf5230eb4UL;
   tf->codes[2196] = 0x0000cc5d6a411a3eUL;
   tf->codes[2197] = 0x0000cc5e547d3152UL;
   tf->codes[2198] = 0x0000cc5f3eb94866UL;
   tf->codes[2199] = 0x0000cc61fd6d8da2UL;
   tf->codes[2200] = 0x0000cc62ad1a9ef1UL;
   tf->codes[2201] = 0x0000cc62e7a9a4b6UL;
   tf->codes[2202] = 0x0000cc644703c754UL;
   tf->codes[2203] = 0x0000cc64bc21d2deUL;
   tf->codes[2204] = 0x0000cc661b7bf57cUL;
   tf->codes[2205] = 0x0000cc67b5651ddfUL;
   tf->codes[2206] = 0x0000cc689fa134f3UL;
   tf->codes[2207] = 0x0000cc6914bf407dUL;
   tf->codes[2208] = 0x0000cc69fefb5791UL;
   tf->codes[2209] = 0x0000cc6a398a5d56UL;
   tf->codes[2210] = 0x0000cc6b23c6746aUL;
   tf->codes[2211] = 0x0000cc6de27ab9a6UL;
   tf->codes[2212] = 0x0000cc6e1d09bf6bUL;
   tf->codes[2213] = 0x0000cc70a12efee2UL;
   tf->codes[2214] = 0x0000cc72b03632cfUL;
   tf->codes[2215] = 0x0000cc72eac53894UL;
   tf->codes[2216] = 0x0000cc739a7249e3UL;
   tf->codes[2217] = 0x0000cc75a9797dd0UL;
   tf->codes[2218] = 0x0000cc7659268f1fUL;
   tf->codes[2219] = 0x0000cc7708d3a06eUL;
   tf->codes[2220] = 0x0000cc77b880b1bdUL;
   tf->codes[2221] = 0x0000cc77f30fb782UL;
   tf->codes[2222] = 0x0000cc7ab1c3fcbeUL;
   tf->codes[2223] = 0x0000cc7b26e20848UL;
   tf->codes[2224] = 0x0000cc7dab0747bfUL;
   tf->codes[2225] = 0x0000cc7e5ab4590eUL;
   tf->codes[2226] = 0x0000cc7f0a616a5dUL;
   tf->codes[2227] = 0x0000cc7fba0e7bacUL;
   tf->codes[2228] = 0x0000cc802f2c8736UL;
   tf->codes[2229] = 0x0000cc80a44a92c0UL;
   tf->codes[2230] = 0x0000cc8119689e4aUL;
   tf->codes[2231] = 0x0000cc818e86a9d4UL;
   tf->codes[2232] = 0x0000cc8203a4b55eUL;
   tf->codes[2233] = 0x0000cc8278c2c0e8UL;
   tf->codes[2234] = 0x0000cc82b351c6adUL;
   tf->codes[2235] = 0x0000cc8362fed7fcUL;
   tf->codes[2236] = 0x0000cc87f62b4b60UL;
   tf->codes[2237] = 0x0000cc8830ba5125UL;
   tf->codes[2238] = 0x0000cc88e0676274UL;
   tf->codes[2239] = 0x0000cc891af66839UL;
   tf->codes[2240] = 0x0000cc8a05327f4dUL;
   tf->codes[2241] = 0x0000cc8b29fd9c26UL;
   tf->codes[2242] = 0x0000cc8c1439b33aUL;
   tf->codes[2243] = 0x0000cc8de8b1e162UL;
   tf->codes[2244] = 0x0000cc8e5dcfececUL;
   tf->codes[2245] = 0x0000cc8f0d7cfe3bUL;
   tf->codes[2246] = 0x0000cc90a766269eUL;
   tf->codes[2247] = 0x0000cc911c843228UL;
   tf->codes[2248] = 0x0000cc92b66d5a8bUL;
   tf->codes[2249] = 0x0000cc94505682eeUL;
   tf->codes[2250] = 0x0000cc94c5748e78UL;
   tf->codes[2251] = 0x0000cc953a929a02UL;
   tf->codes[2252] = 0x0000cc95ea3fab51UL;
   tf->codes[2253] = 0x0000cc97f946df3eUL;
   tf->codes[2254] = 0x0000cc9833d5e503UL;
   tf->codes[2255] = 0x0000cc986e64eac8UL;
   tf->codes[2256] = 0x0000cc98e382f652UL;
   tf->codes[2257] = 0x0000cc9958a101dcUL;
   tf->codes[2258] = 0x0000cc9a42dd18f0UL;
   tf->codes[2259] = 0x0000cc9a7d6c1eb5UL;
   tf->codes[2260] = 0x0000cc9af28a2a3fUL;
   tf->codes[2261] = 0x0000cc9b67a835c9UL;
   tf->codes[2262] = 0x0000cc9ba2373b8eUL;
   tf->codes[2263] = 0x0000cc9d3c2063f1UL;
   tf->codes[2264] = 0x0000cc9d76af69b6UL;
   tf->codes[2265] = 0x0000cc9f10989219UL;
   tf->codes[2266] = 0x0000cc9f4b2797deUL;
   tf->codes[2267] = 0x0000cc9f85b69da3UL;
   tf->codes[2268] = 0x0000cca03563aef2UL;
   tf->codes[2269] = 0x0000cca36935ffb8UL;
   tf->codes[2270] = 0x0000cca3a3c5057dUL;
   tf->codes[2271] = 0x0000cca4c8902256UL;
   tf->codes[2272] = 0x0000cca5031f281bUL;
   tf->codes[2273] = 0x0000cca53dae2de0UL;
   tf->codes[2274] = 0x0000cca5ed5b3f2fUL;
   tf->codes[2275] = 0x0000cca627ea44f4UL;
   tf->codes[2276] = 0x0000cca74cb561cdUL;
   tf->codes[2277] = 0x0000cca7c1d36d57UL;
   tf->codes[2278] = 0x0000cca7fc62731cUL;
   tf->codes[2279] = 0x0000cca8ac0f846bUL;
   tf->codes[2280] = 0x0000cca9212d8ff5UL;
   tf->codes[2281] = 0x0000ccaa0b69a709UL;
   tf->codes[2282] = 0x0000ccaa8087b293UL;
   tf->codes[2283] = 0x0000ccab3034c3e2UL;
   tf->codes[2284] = 0x0000ccad79cafd94UL;
   tf->codes[2285] = 0x0000ccb0e82c541fUL;
   tf->codes[2286] = 0x0000ccb20cf770f8UL;
   tf->codes[2287] = 0x0000ccb2bca48247UL;
   tf->codes[2288] = 0x0000ccb36c519396UL;
   tf->codes[2289] = 0x0000ccb4911cb06fUL;
   tf->codes[2290] = 0x0000ccb6dab2ea21UL;
   tf->codes[2291] = 0x0000ccb8749c1284UL;
   tf->codes[2292] = 0x0000ccba0e853ae7UL;
   tf->codes[2293] = 0x0000ccba491440acUL;
   tf->codes[2294] = 0x0000ccbb6ddf5d85UL;
   tf->codes[2295] = 0x0000ccbba86e634aUL;
   tf->codes[2296] = 0x0000ccbc1d8c6ed4UL;
   tf->codes[2297] = 0x0000ccbd7ce69172UL;
   tf->codes[2298] = 0x0000ccbfc67ccb24UL;
   tf->codes[2299] = 0x0000ccc0b0b8e238UL;
   tf->codes[2300] = 0x0000ccc16065f387UL;
   tf->codes[2301] = 0x0000ccc24aa20a9bUL;
   tf->codes[2302] = 0x0000ccc334de21afUL;
   tf->codes[2303] = 0x0000ccc543e5559cUL;
   tf->codes[2304] = 0x0000ccc752ec8989UL;
   tf->codes[2305] = 0x0000ccc7c80a9513UL;
   tf->codes[2306] = 0x0000ccc92764b7b1UL;
   tf->codes[2307] = 0x0000ccc99c82c33bUL;
   tf->codes[2308] = 0x0000ccca86beda4fUL;
   tf->codes[2309] = 0x0000cccdba912b15UL;
   tf->codes[2310] = 0x0000ccce6a3e3c64UL;
   tf->codes[2311] = 0x0000ccd163818765UL;
   tf->codes[2312] = 0x0000ccd2884ca43eUL;
   tf->codes[2313] = 0x0000ccd2c2dbaa03UL;
   tf->codes[2314] = 0x0000ccd71b7917a2UL;
   tf->codes[2315] = 0x0000ccd7cb2628f1UL;
   tf->codes[2316] = 0x0000ccd8b5624005UL;
   tf->codes[2317] = 0x0000ccd92a804b8fUL;
   tf->codes[2318] = 0x0000ccdafef879b7UL;
   tf->codes[2319] = 0x0000ccdb74168541UL;
   tf->codes[2320] = 0x0000ccdbe93490cbUL;
   tf->codes[2321] = 0x0000ccdd0dffada4UL;
   tf->codes[2322] = 0x0000ccdd488eb369UL;
   tf->codes[2323] = 0x0000ccddbdacbef3UL;
   tf->codes[2324] = 0x0000ccdf5795e756UL;
   tf->codes[2325] = 0x0000cce375a44f30UL;
   tf->codes[2326] = 0x0000cce75923b145UL;
   tf->codes[2327] = 0x0000cce793b2b70aUL;
   tf->codes[2328] = 0x0000cce92d9bdf6dUL;
   tf->codes[2329] = 0x0000cce9682ae532UL;
   tf->codes[2330] = 0x0000ccea5266fc46UL;
   tf->codes[2331] = 0x0000cceb3ca3135aUL;
   tf->codes[2332] = 0x0000cceb7732191fUL;
   tf->codes[2333] = 0x0000ccec616e3033UL;
   tf->codes[2334] = 0x0000ccecd68c3bbdUL;
   tf->codes[2335] = 0x0000cced111b4182UL;
   tf->codes[2336] = 0x0000cced4baa4747UL;
   tf->codes[2337] = 0x0000cced86394d0cUL;
   tf->codes[2338] = 0x0000ccf044ed9248UL;
   tf->codes[2339] = 0x0000ccf0f49aa397UL;
   tf->codes[2340] = 0x0000ccf1a447b4e6UL;
   tf->codes[2341] = 0x0000ccf1ded6baabUL;
   tf->codes[2342] = 0x0000ccf21965c070UL;
   tf->codes[2343] = 0x0000ccf378bfe30eUL;
   tf->codes[2344] = 0x0000ccf512a90b71UL;
   tf->codes[2345] = 0x0000ccf6e7213999UL;
   tf->codes[2346] = 0x0000ccf8bb9967c1UL;
   tf->codes[2347] = 0x0000ccf96b467910UL;
   tf->codes[2348] = 0x0000ccfa55829024UL;
   tf->codes[2349] = 0x0000ccfa901195e9UL;
   tf->codes[2350] = 0x0000ccfc6489c411UL;
   tf->codes[2351] = 0x0000ccfd8954e0eaUL;
   tf->codes[2352] = 0x0000ccfe3901f239UL;
   tf->codes[2353] = 0x0000ccfee8af0388UL;
   tf->codes[2354] = 0x0000ccffd2eb1a9cUL;
   tf->codes[2355] = 0x0000cd00f7b63775UL;
   tf->codes[2356] = 0x0000cd0132453d3aUL;
   tf->codes[2357] = 0x0000cd01e1f24e89UL;
   tf->codes[2358] = 0x0000cd037bdb76ecUL;
   tf->codes[2359] = 0x0000cd03f0f98276UL;
   tf->codes[2360] = 0x0000cd04a0a693c5UL;
   tf->codes[2361] = 0x0000cd055053a514UL;
   tf->codes[2362] = 0x0000cd058ae2aad9UL;
   tf->codes[2363] = 0x0000cd080f07ea50UL;
   tf->codes[2364] = 0x0000cd084996f015UL;
   tf->codes[2365] = 0x0000cd0a1e0f1e3dUL;
   tf->codes[2366] = 0x0000cd0d1752693eUL;
   tf->codes[2367] = 0x0000cd0d8c7074c8UL;
   tf->codes[2368] = 0x0000cd0dc6ff7a8dUL;
   tf->codes[2369] = 0x0000cd0f26599d2bUL;
   tf->codes[2370] = 0x0000cd101095b43fUL;
   tf->codes[2371] = 0x0000cd116fefd6ddUL;
   tf->codes[2372] = 0x0000cd11e50de267UL;
   tf->codes[2373] = 0x0000cd13b986108fUL;
   tf->codes[2374] = 0x0000cd13f4151654UL;
   tf->codes[2375] = 0x0000cd142ea41c19UL;
   tf->codes[2376] = 0x0000cd15c88d447cUL;
   tf->codes[2377] = 0x0000cd16783a55cbUL;
   tf->codes[2378] = 0x0000cd19717da0ccUL;
   tf->codes[2379] = 0x0000cd19ac0ca691UL;
   tf->codes[2380] = 0x0000cd1b45f5cef4UL;
   tf->codes[2381] = 0x0000cd1c3031e608UL;
   tf->codes[2382] = 0x0000cd1cdfdef757UL;
   tf->codes[2383] = 0x0000cd1eeee62b44UL;
   tf->codes[2384] = 0x0000cd2222b87c0aUL;
   tf->codes[2385] = 0x0000cd225d4781cfUL;
   tf->codes[2386] = 0x0000cd23bca1a46dUL;
   tf->codes[2387] = 0x0000cd23f730aa32UL;
   tf->codes[2388] = 0x0000cd251bfbc70bUL;
   tf->codes[2389] = 0x0000cd259119d295UL;
   tf->codes[2390] = 0x0000cd25cba8d85aUL;
   tf->codes[2391] = 0x0000cd26b5e4ef6eUL;
   tf->codes[2392] = 0x0000cd27a0210682UL;
   tf->codes[2393] = 0x0000cd27dab00c47UL;
   tf->codes[2394] = 0x0000cd28c4ec235bUL;
   tf->codes[2395] = 0x0000cd293a0a2ee5UL;
   tf->codes[2396] = 0x0000cd2ad3f35748UL;
   tf->codes[2397] = 0x0000cd2b491162d2UL;
   tf->codes[2398] = 0x0000cd2bf8be7421UL;
   tf->codes[2399] = 0x0000cd2ef201bf22UL;
   tf->codes[2400] = 0x0000cd2fdc3dd636UL;
   tf->codes[2401] = 0x0000cd313b97f8d4UL;
   tf->codes[2402] = 0x0000cd32606315adUL;
   tf->codes[2403] = 0x0000cd38185aa5eaUL;
   tf->codes[2404] = 0x0000cd3bc14b023aUL;
   tf->codes[2405] = 0x0000cd3d20a524d8UL;
   tf->codes[2406] = 0x0000cd3d95c33062UL;
   tf->codes[2407] = 0x0000cd41042486edUL;
   tf->codes[2408] = 0x0000cd42637ea98bUL;
   tf->codes[2409] = 0x0000cd434dbac09fUL;
   tf->codes[2410] = 0x0000cd4437f6d7b3UL;
   tf->codes[2411] = 0x0000cd44ad14e33dUL;
   tf->codes[2412] = 0x0000cd44e7a3e902UL;
   tf->codes[2413] = 0x0000cd45d1e00016UL;
   tf->codes[2414] = 0x0000cd46818d1165UL;
   tf->codes[2415] = 0x0000cd46bc1c172aUL;
   tf->codes[2416] = 0x0000cd481b7639c8UL;
   tf->codes[2417] = 0x0000cd49404156a1UL;
   tf->codes[2418] = 0x0000cd49b55f622bUL;
   tf->codes[2419] = 0x0000cd4bc4669618UL;
   tf->codes[2420] = 0x0000cd4bfef59bddUL;
   tf->codes[2421] = 0x0000cd501d0403b7UL;
   tf->codes[2422] = 0x0000cd522c0b37a4UL;
   tf->codes[2423] = 0x0000cd5350d6547dUL;
   tf->codes[2424] = 0x0000cd560f8a99b9UL;
   tf->codes[2425] = 0x0000cd5684a8a543UL;
   tf->codes[2426] = 0x0000cd56bf37ab08UL;
   tf->codes[2427] = 0x0000cd57a973c21cUL;
   tf->codes[2428] = 0x0000cd585920d36bUL;
   tf->codes[2429] = 0x0000cd5a68280758UL;
   tf->codes[2430] = 0x0000cd5b17d518a7UL;
   tf->codes[2431] = 0x0000cd5c3ca03580UL;
   tf->codes[2432] = 0x0000cd5d9bfa581eUL;
   tf->codes[2433] = 0x0000cd5f35e38081UL;
   tf->codes[2434] = 0x0000cd5f70728646UL;
   tf->codes[2435] = 0x0000cd60201f9795UL;
   tf->codes[2436] = 0x0000cd60cfcca8e4UL;
   tf->codes[2437] = 0x0000cd6269b5d147UL;
   tf->codes[2438] = 0x0000cd6478bd0534UL;
   tf->codes[2439] = 0x0000cd664d35335cUL;
   tf->codes[2440] = 0x0000cd67ac8f55faUL;
   tf->codes[2441] = 0x0000cd67e71e5bbfUL;
   tf->codes[2442] = 0x0000cd6a30b49571UL;
   tf->codes[2443] = 0x0000cd6bca9dbdd4UL;
   tf->codes[2444] = 0x0000cd6cb4d9d4e8UL;
   tf->codes[2445] = 0x0000cd70233b2b73UL;
   tf->codes[2446] = 0x0000cd705dca3138UL;
   tf->codes[2447] = 0x0000cd70985936fdUL;
   tf->codes[2448] = 0x0000cd7182954e11UL;
   tf->codes[2449] = 0x0000cd73919c81feUL;
   tf->codes[2450] = 0x0000cd75a0a3b5ebUL;
   tf->codes[2451] = 0x0000cd765050c73aUL;
   tf->codes[2452] = 0x0000cd76c56ed2c4UL;
   tf->codes[2453] = 0x0000cd77ea39ef9dUL;
   tf->codes[2454] = 0x0000cd785f57fb27UL;
   tf->codes[2455] = 0x0000cd794994123bUL;
   tf->codes[2456] = 0x0000cd79beb21dc5UL;
   tf->codes[2457] = 0x0000cd7b589b4628UL;
   tf->codes[2458] = 0x0000cd7bcdb951b2UL;
   tf->codes[2459] = 0x0000cd7cf2846e8bUL;
   tf->codes[2460] = 0x0000cd7e174f8b64UL;
   tf->codes[2461] = 0x0000cd809b74cadbUL;
   tf->codes[2462] = 0x0000cd8394b815dcUL;
   tf->codes[2463] = 0x0000cd83cf471ba1UL;
   tf->codes[2464] = 0x0000cd8569304404UL;
   tf->codes[2465] = 0x0000cd86536c5b18UL;
   tf->codes[2466] = 0x0000cd891220a054UL;
   tf->codes[2467] = 0x0000cd89c1cdb1a3UL;
   tf->codes[2468] = 0x0000cd89fc5cb768UL;
   tf->codes[2469] = 0x0000cd8b5bb6da06UL;
   tf->codes[2470] = 0x0000cd8cbb10fca4UL;
   tf->codes[2471] = 0x0000cd8d302f082eUL;
   tf->codes[2472] = 0x0000cd8d6abe0df3UL;
   tf->codes[2473] = 0x0000cd8f04a73656UL;
   tf->codes[2474] = 0x0000cd902972532fUL;
   tf->codes[2475] = 0x0000cd90640158f4UL;
   tf->codes[2476] = 0x0000cd909e905eb9UL;
   tf->codes[2477] = 0x0000cd9113ae6a43UL;
   tf->codes[2478] = 0x0000cd9397d3a9baUL;
   tf->codes[2479] = 0x0000cd93d262af7fUL;
   tf->codes[2480] = 0x0000cd940cf1b544UL;
   tf->codes[2481] = 0x0000cd96cba5fa80UL;
   tf->codes[2482] = 0x0000cd9706350045UL;
   tf->codes[2483] = 0x0000cd9740c4060aUL;
   tf->codes[2484] = 0x0000cd98a01e28a8UL;
   tf->codes[2485] = 0x0000cd99153c3432UL;
   tf->codes[2486] = 0x0000cd994fcb39f7UL;
   tf->codes[2487] = 0x0000cd99ff784b46UL;
   tf->codes[2488] = 0x0000cd9b2443681fUL;
   tf->codes[2489] = 0x0000cd9c490e84f8UL;
   tf->codes[2490] = 0x0000cd9cf8bb9647UL;
   tf->codes[2491] = 0x0000cd9e5815b8e5UL;
   tf->codes[2492] = 0x0000cd9f4251cff9UL;
   tf->codes[2493] = 0x0000cda02c8de70dUL;
   tf->codes[2494] = 0x0000cda23b951afaUL;
   tf->codes[2495] = 0x0000cda325d1320eUL;
   tf->codes[2496] = 0x0000cda3606037d3UL;
   tf->codes[2497] = 0x0000cda39aef3d98UL;
   tf->codes[2498] = 0x0000cda534d865fbUL;
   tf->codes[2499] = 0x0000cda5a9f67185UL;
   tf->codes[2500] = 0x0000cda5e485774aUL;
   tf->codes[2501] = 0x0000cda709509423UL;
   tf->codes[2502] = 0x0000cda98d75d39aUL;
   tf->codes[2503] = 0x0000cda9c804d95fUL;
   tf->codes[2504] = 0x0000cdaa0293df24UL;
   tf->codes[2505] = 0x0000cdaab240f073UL;
   tf->codes[2506] = 0x0000cdab9c7d0787UL;
   tf->codes[2507] = 0x0000cdae95c05288UL;
   tf->codes[2508] = 0x0000cdaed04f584dUL;
   tf->codes[2509] = 0x0000cdb06a3880b0UL;
   tf->codes[2510] = 0x0000cdb39e0ad176UL;
   tf->codes[2511] = 0x0000cdb5e7a10b28UL;
   tf->codes[2512] = 0x0000cdb6d1dd223cUL;
   tf->codes[2513] = 0x0000cdb7f6a83f15UL;
   tf->codes[2514] = 0x0000cdb9560261b3UL;
   tf->codes[2515] = 0x0000cdba403e78c7UL;
   tf->codes[2516] = 0x0000cdbb650995a0UL;
   tf->codes[2517] = 0x0000cdbbda27a12aUL;
   tf->codes[2518] = 0x0000cdbdae9fcf52UL;
   tf->codes[2519] = 0x0000cdbe5e4ce0a1UL;
   tf->codes[2520] = 0x0000cdbf4888f7b5UL;
   tf->codes[2521] = 0x0000cdbff8360904UL;
   tf->codes[2522] = 0x0000cdc0a7e31a53UL;
   tf->codes[2523] = 0x0000cdc0e2722018UL;
   tf->codes[2524] = 0x0000cdc1ccae372cUL;
   tf->codes[2525] = 0x0000cdc32c0859caUL;
   tf->codes[2526] = 0x0000cdc3a1266554UL;
   tf->codes[2527] = 0x0000cdc6d4f8b61aUL;
   tf->codes[2528] = 0x0000cdc70f87bbdfUL;
   tf->codes[2529] = 0x0000cdc74a16c1a4UL;
   tf->codes[2530] = 0x0000cdc7bf34cd2eUL;
   tf->codes[2531] = 0x0000cdc8a970e442UL;
   tf->codes[2532] = 0x0000cdc9ce3c011bUL;
   tf->codes[2533] = 0x0000cdcab878182fUL;
   tf->codes[2534] = 0x0000cdcaf3071df4UL;
   tf->codes[2535] = 0x0000cdcb6825297eUL;
   tf->codes[2536] = 0x0000cdcba2b42f43UL;
   tf->codes[2537] = 0x0000cdcbdd433508UL;
   tf->codes[2538] = 0x0000cdced6868009UL;
   tf->codes[2539] = 0x0000cdd1cfc9cb0aUL;
   tf->codes[2540] = 0x0000cdd4196004bcUL;
   tf->codes[2541] = 0x0000cdd48e7e1046UL;
   tf->codes[2542] = 0x0000cdd53e2b2195UL;
   tf->codes[2543] = 0x0000cdd5edd832e4UL;
   tf->codes[2544] = 0x0000cdd6286738a9UL;
   tf->codes[2545] = 0x0000cdd921aa83aaUL;
   tf->codes[2546] = 0x0000cdd95c39896fUL;
   tf->codes[2547] = 0x0000cdda4675a083UL;
   tf->codes[2548] = 0x0000cdda8104a648UL;
   tf->codes[2549] = 0x0000cddaf622b1d2UL;
   tf->codes[2550] = 0x0000cddb30b1b797UL;
   tf->codes[2551] = 0x0000cddbe05ec8e6UL;
   tf->codes[2552] = 0x0000cddcca9adffaUL;
   tf->codes[2553] = 0x0000cddd0529e5bfUL;
   tf->codes[2554] = 0x0000cdde9f130e22UL;
   tf->codes[2555] = 0x0000cde038fc3685UL;
   tf->codes[2556] = 0x0000cde123384d99UL;
   tf->codes[2557] = 0x0000cde1d2e55ee8UL;
   tf->codes[2558] = 0x0000cde2bd2175fcUL;
   tf->codes[2559] = 0x0000cde5b664c0fdUL;
   tf->codes[2560] = 0x0000cde78adcef25UL;
   tf->codes[2561] = 0x0000cdea49913461UL;
   tf->codes[2562] = 0x0000cded42d47f62UL;
   tf->codes[2563] = 0x0000cdedf28190b1UL;
   tf->codes[2564] = 0x0000cdeea22ea200UL;
   tf->codes[2565] = 0x0000cdf03c17ca63UL;
   tf->codes[2566] = 0x0000cdf0ebc4dbb2UL;
   tf->codes[2567] = 0x0000cdf24b1efe50UL;
   tf->codes[2568] = 0x0000cdf2c03d09daUL;
   tf->codes[2569] = 0x0000cdf2facc0f9fUL;
   tf->codes[2570] = 0x0000cdf3aa7920eeUL;
   tf->codes[2571] = 0x0000cdf544624951UL;
   tf->codes[2572] = 0x0000cdf57ef14f16UL;
   tf->codes[2573] = 0x0000cdf5f40f5aa0UL;
   tf->codes[2574] = 0x0000cdf803168e8dUL;
   tf->codes[2575] = 0x0000cdf878349a17UL;
   tf->codes[2576] = 0x0000cdf8ed52a5a1UL;
   tf->codes[2577] = 0x0000cdf927e1ab66UL;
   tf->codes[2578] = 0x0000cdf96270b12bUL;
   tf->codes[2579] = 0x0000cdf99cffb6f0UL;
   tf->codes[2580] = 0x0000cdfa121dc27aUL;
   tf->codes[2581] = 0x0000cdfe6abb3019UL;
   tf->codes[2582] = 0x0000cdffca1552b7UL;
   tf->codes[2583] = 0x0000ce00b45169cbUL;
   tf->codes[2584] = 0x0000ce0163fe7b1aUL;
   tf->codes[2585] = 0x0000ce01d91c86a4UL;
   tf->codes[2586] = 0x0000ce024e3a922eUL;
   tf->codes[2587] = 0x0000ce037305af07UL;
   tf->codes[2588] = 0x0000ce05f72aee7eUL;
   tf->codes[2589] = 0x0000ce06e1670592UL;
   tf->codes[2590] = 0x0000ce075685111cUL;
   tf->codes[2591] = 0x0000ce08f06e397fUL;
   tf->codes[2592] = 0x0000ce09658c4509UL;
   tf->codes[2593] = 0x0000ce09a01b4aceUL;
   tf->codes[2594] = 0x0000ce0a15395658UL;
   tf->codes[2595] = 0x0000ce0baf227ebbUL;
   tf->codes[2596] = 0x0000ce0cd3ed9b94UL;
   tf->codes[2597] = 0x0000ce0d0e7ca159UL;
   tf->codes[2598] = 0x0000ce0f5812db0bUL;
   tf->codes[2599] = 0x0000ce0fcd30e695UL;
   tf->codes[2600] = 0x0000ce10f1fc036eUL;
   tf->codes[2601] = 0x0000ce11671a0ef8UL;
   tf->codes[2602] = 0x0000ce128be52bd1UL;
   tf->codes[2603] = 0x0000ce12c6743196UL;
   tf->codes[2604] = 0x0000ce133b923d20UL;
   tf->codes[2605] = 0x0000ce14605d59f9UL;
   tf->codes[2606] = 0x0000ce14d57b6583UL;
   tf->codes[2607] = 0x0000ce15852876d2UL;
   tf->codes[2608] = 0x0000ce15fa46825cUL;
   tf->codes[2609] = 0x0000ce187e6bc1d3UL;
   tf->codes[2610] = 0x0000ce19a336deacUL;
   tf->codes[2611] = 0x0000ce1a1854ea36UL;
   tf->codes[2612] = 0x0000ce1b77af0cd4UL;
   tf->codes[2613] = 0x0000ce1c9c7a29adUL;
   tf->codes[2614] = 0x0000ce1dc1454686UL;
   tf->codes[2615] = 0x0000ce1e70f257d5UL;
   tf->codes[2616] = 0x0000ce20456a85fdUL;
   tf->codes[2617] = 0x0000ce21df53ae60UL;
   tf->codes[2618] = 0x0000ce2219e2b425UL;
   tf->codes[2619] = 0x0000ce25c2d31075UL;
   tf->codes[2620] = 0x0000ce27222d3313UL;
   tf->codes[2621] = 0x0000ce27974b3e9dUL;
   tf->codes[2622] = 0x0000ce2846f84fecUL;
   tf->codes[2623] = 0x0000ce2ee92bf73dUL;
   tf->codes[2624] = 0x0000ce32ccab5952UL;
   tf->codes[2625] = 0x0000ce337c586aa1UL;
   tf->codes[2626] = 0x0000ce36007daa18UL;
   tf->codes[2627] = 0x0000ce372548c6f1UL;
   tf->codes[2628] = 0x0000ce3884a2e98fUL;
   tf->codes[2629] = 0x0000ce38f9c0f519UL;
   tf->codes[2630] = 0x0000ce39344ffadeUL;
   tf->codes[2631] = 0x0000ce3a93aa1d7cUL;
   tf->codes[2632] = 0x0000ce3ace392341UL;
   tf->codes[2633] = 0x0000ce3c2d9345dfUL;
   tf->codes[2634] = 0x0000ce3eec478b1bUL;
   tf->codes[2635] = 0x0000ce3fd683a22fUL;
   tf->codes[2636] = 0x0000ce41706cca92UL;
   tf->codes[2637] = 0x0000ce41e58ad61cUL;
   tf->codes[2638] = 0x0000ce4469b01593UL;
   tf->codes[2639] = 0x0000ce458e7b326cUL;
   tf->codes[2640] = 0x0000ce463e2843bbUL;
   tf->codes[2641] = 0x0000ce4762f36094UL;
   tf->codes[2642] = 0x0000ce484d2f77a8UL;
   tf->codes[2643] = 0x0000ce4a5c36ab95UL;
   tf->codes[2644] = 0x0000ce4e052707e5UL;
   tf->codes[2645] = 0x0000ce4e3fb60daaUL;
   tf->codes[2646] = 0x0000ce4f64812a83UL;
   tf->codes[2647] = 0x0000ce4f9f103048UL;
   tf->codes[2648] = 0x0000ce50894c475cUL;
   tf->codes[2649] = 0x0000ce51e8a669faUL;
   tf->codes[2650] = 0x0000ce525dc47584UL;
   tf->codes[2651] = 0x0000ce546ccba971UL;
   tf->codes[2652] = 0x0000ce54a75aaf36UL;
   tf->codes[2653] = 0x0000ce551c78bac0UL;
   tf->codes[2654] = 0x0000ce555707c085UL;
   tf->codes[2655] = 0x0000ce56f0f0e8e8UL;
   tf->codes[2656] = 0x0000ce572b7feeadUL;
   tf->codes[2657] = 0x0000ce57db2cfffcUL;
   tf->codes[2658] = 0x0000ce5815bc05c1UL;
   tf->codes[2659] = 0x0000ce588ada114bUL;
   tf->codes[2660] = 0x0000ce58c5691710UL;
   tf->codes[2661] = 0x0000ce5b841d5c4cUL;
   tf->codes[2662] = 0x0000ce5bbeac6211UL;
   tf->codes[2663] = 0x0000ce6176a3f24eUL;
   tf->codes[2664] = 0x0000ce6260e00962UL;
   tf->codes[2665] = 0x0000ce629b6f0f27UL;
   tf->codes[2666] = 0x0000ce634b1c2076UL;
   tf->codes[2667] = 0x0000ce6385ab263bUL;
   tf->codes[2668] = 0x0000ce655a235463UL;
   tf->codes[2669] = 0x0000ce66445f6b77UL;
   tf->codes[2670] = 0x0000ce66b97d7701UL;
   tf->codes[2671] = 0x0000ce697831bc3dUL;
   tf->codes[2672] = 0x0000ce6a9cfcd916UL;
   tf->codes[2673] = 0x0000ce6b4ca9ea65UL;
   tf->codes[2674] = 0x0000ce6e807c3b2bUL;
   tf->codes[2675] = 0x0000ce7054f46953UL;
   tf->codes[2676] = 0x0000ce70ca1274ddUL;
   tf->codes[2677] = 0x0000ce71b44e8bf1UL;
   tf->codes[2678] = 0x0000ce72296c977bUL;
   tf->codes[2679] = 0x0000ce7263fb9d40UL;
   tf->codes[2680] = 0x0000ce72d919a8caUL;
   tf->codes[2681] = 0x0000ce743873cb68UL;
   tf->codes[2682] = 0x0000ce75d25cf3cbUL;
   tf->codes[2683] = 0x0000ce76f72810a4UL;
   tf->codes[2684] = 0x0000ce77a6d521f3UL;
   tf->codes[2685] = 0x0000ce797b4d501bUL;
   tf->codes[2686] = 0x0000ce79f06b5ba5UL;
   tf->codes[2687] = 0x0000ce7adaa772b9UL;
   tf->codes[2688] = 0x0000ce7b8a548408UL;
   tf->codes[2689] = 0x0000ce7bff728f92UL;
   tf->codes[2690] = 0x0000ce7f6dd3e61dUL;
   tf->codes[2691] = 0x0000ce80580ffd31UL;
   tf->codes[2692] = 0x0000ce80929f02f6UL;
   tf->codes[2693] = 0x0000ce8610078d6eUL;
   tf->codes[2694] = 0x0000ce8734d2aa47UL;
   tf->codes[2695] = 0x0000ce87e47fbb96UL;
   tf->codes[2696] = 0x0000ce8943d9de34UL;
   tf->codes[2697] = 0x0000ce8a68a4fb0dUL;
   tf->codes[2698] = 0x0000ce8aa33400d2UL;
   tf->codes[2699] = 0x0000ce8e4c245d22UL;
   tf->codes[2700] = 0x0000ce8ec14268acUL;
   tf->codes[2701] = 0x0000ce8fab7e7fc0UL;
   tf->codes[2702] = 0x0000ce8fe60d8585UL;
   tf->codes[2703] = 0x0000ce91f514b972UL;
   tf->codes[2704] = 0x0000ce93546edc10UL;
   tf->codes[2705] = 0x0000ce943eaaf324UL;
   tf->codes[2706] = 0x0000ce964db22711UL;
   tf->codes[2707] = 0x0000ce9737ee3e25UL;
   tf->codes[2708] = 0x0000ce9b55fca5ffUL;
   tf->codes[2709] = 0x0000ce9bcb1ab189UL;
   tf->codes[2710] = 0x0000ce9c4038bd13UL;
   tf->codes[2711] = 0x0000cea1bda1478bUL;
   tf->codes[2712] = 0x0000cea26d4e58daUL;
   tf->codes[2713] = 0x0000cea40737813dUL;
   tf->codes[2714] = 0x0000cea5dbafaf65UL;
   tf->codes[2715] = 0x0000cea68b5cc0b4UL;
   tf->codes[2716] = 0x0000cea77598d7c8UL;
   tf->codes[2717] = 0x0000cea94a1105f0UL;
   tf->codes[2718] = 0x0000cea984a00bb5UL;
   tf->codes[2719] = 0x0000ceaae3fa2e53UL;
   tf->codes[2720] = 0x0000ceabce364567UL;
   tf->codes[2721] = 0x0000ceacb8725c7bUL;
   tf->codes[2722] = 0x0000ceacf3016240UL;
   tf->codes[2723] = 0x0000ceae8cea8aa3UL;
   tf->codes[2724] = 0x0000ceafb1b5a77cUL;
   tf->codes[2725] = 0x0000ceb06162b8cbUL;
   tf->codes[2726] = 0x0000ceb09bf1be90UL;
   tf->codes[2727] = 0x0000ceb0d680c455UL;
   tf->codes[2728] = 0x0000ceb1862dd5a4UL;
   tf->codes[2729] = 0x0000ceb1fb4be12eUL;
   tf->codes[2730] = 0x0000ceb32016fe07UL;
   tf->codes[2731] = 0x0000ceb395350991UL;
   tf->codes[2732] = 0x0000ceb40a53151bUL;
   tf->codes[2733] = 0x0000ceb6c9075a57UL;
   tf->codes[2734] = 0x0000ceb828617cf5UL;
   tf->codes[2735] = 0x0000ceb89d7f887fUL;
   tf->codes[2736] = 0x0000ceb94d2c99ceUL;
   tf->codes[2737] = 0x0000ceb9c24aa558UL;
   tf->codes[2738] = 0x0000ceb9fcd9ab1dUL;
   tf->codes[2739] = 0x0000cebb5c33cdbbUL;
   tf->codes[2740] = 0x0000cebbd151d945UL;
   tf->codes[2741] = 0x0000cebde0590d32UL;
   tf->codes[2742] = 0x0000cebf05242a0bUL;
   tf->codes[2743] = 0x0000cec029ef46e4UL;
   tf->codes[2744] = 0x0000cec0d99c5833UL;
   tf->codes[2745] = 0x0000cec238f67ad1UL;
   tf->codes[2746] = 0x0000cec35dc197aaUL;
   tf->codes[2747] = 0x0000cec53239c5d2UL;
   tf->codes[2748] = 0x0000cec65704e2abUL;
   tf->codes[2749] = 0x0000cec8db2a2222UL;
   tf->codes[2750] = 0x0000cec950482dacUL;
   tf->codes[2751] = 0x0000cecaea31560fUL;
   tf->codes[2752] = 0x0000cecd33c78fc1UL;
   tf->codes[2753] = 0x0000cece1e03a6d5UL;
   tf->codes[2754] = 0x0000cecf7d5dc973UL;
   tf->codes[2755] = 0x0000ced1c6f40325UL;
   tf->codes[2756] = 0x0000ced2b1301a39UL;
   tf->codes[2757] = 0x0000ced360dd2b88UL;
   tf->codes[2758] = 0x0000ced44b19429cUL;
   tf->codes[2759] = 0x0000ceda0310d2d9UL;
   tf->codes[2760] = 0x0000cedaed4ce9edUL;
   tf->codes[2761] = 0x0000cedbd7890101UL;
   tf->codes[2762] = 0x0000cedcfc541ddaUL;
   tf->codes[2763] = 0x0000cedd71722964UL;
   tf->codes[2764] = 0x0000cee11a6285b4UL;
   tf->codes[2765] = 0x0000cee23f2da28dUL;
   tf->codes[2766] = 0x0000cee65d3c0a67UL;
   tf->codes[2767] = 0x0000cee782072740UL;
   tf->codes[2768] = 0x0000cee8a6d24419UL;
   tf->codes[2769] = 0x0000cee91bf04fa3UL;
   tf->codes[2770] = 0x0000cee9567f5568UL;
   tf->codes[2771] = 0x0000ceeaf0687dcbUL;
   tf->codes[2772] = 0x0000ceeba0158f1aUL;
   tf->codes[2773] = 0x0000ceee9958da1bUL;
   tf->codes[2774] = 0x0000ceef8394f12fUL;
   tf->codes[2775] = 0x0000cef03342027eUL;
   tf->codes[2776] = 0x0000cef06dd10843UL;
   tf->codes[2777] = 0x0000cef0a8600e08UL;
   tf->codes[2778] = 0x0000cef1580d1f57UL;
   tf->codes[2779] = 0x0000cef1929c251cUL;
   tf->codes[2780] = 0x0000cef24249366bUL;
   tf->codes[2781] = 0x0000cef2b76741f5UL;
   tf->codes[2782] = 0x0000cef367145344UL;
   tf->codes[2783] = 0x0000cef3a1a35909UL;
   tf->codes[2784] = 0x0000cef53b8c816cUL;
   tf->codes[2785] = 0x0000cef5761b8731UL;
   tf->codes[2786] = 0x0000cef5b0aa8cf6UL;
   tf->codes[2787] = 0x0000cef71004af94UL;
   tf->codes[2788] = 0x0000cef86f5ed232UL;
   tf->codes[2789] = 0x0000cefa7e66061fUL;
   tf->codes[2790] = 0x0000cefab8f50be4UL;
   tf->codes[2791] = 0x0000cefc184f2e82UL;
   tf->codes[2792] = 0x0000cefffbce9097UL;
   tf->codes[2793] = 0x0000cf0070ec9c21UL;
   tf->codes[2794] = 0x0000cf020ad5c484UL;
   tf->codes[2795] = 0x0000cf07fd5c5a86UL;
   tf->codes[2796] = 0x0000cf09974582e9UL;
   tf->codes[2797] = 0x0000cf0ffeea2475UL;
   tf->codes[2798] = 0x0000cf10e9263b89UL;
   tf->codes[2799] = 0x0000cf1123b5414eUL;
   tf->codes[2800] = 0x0000cf11d362529dUL;
   tf->codes[2801] = 0x0000cf120df15862UL;
   tf->codes[2802] = 0x0000cf1248805e27UL;
   tf->codes[2803] = 0x0000cf14921697d9UL;
   tf->codes[2804] = 0x0000cf150734a363UL;
   tf->codes[2805] = 0x0000cf1541c3a928UL;
   tf->codes[2806] = 0x0000cf16668ec601UL;
   tf->codes[2807] = 0x0000cf1a4a0e2816UL;
   tf->codes[2808] = 0x0000cf1abf2c33a0UL;
   tf->codes[2809] = 0x0000cf1b344a3f2aUL;
   tf->codes[2810] = 0x0000cf1c93a461c8UL;
   tf->codes[2811] = 0x0000cf1d7de078dcUL;
   tf->codes[2812] = 0x0000cf203c94be18UL;
   tf->codes[2813] = 0x0000cf20b1b2c9a2UL;
   tf->codes[2814] = 0x0000cf2335d80919UL;
   tf->codes[2815] = 0x0000cf250a503741UL;
   tf->codes[2816] = 0x0000cf262f1b541aUL;
   tf->codes[2817] = 0x0000cf2803938242UL;
   tf->codes[2818] = 0x0000cf2a129ab62fUL;
   tf->codes[2819] = 0x0000cf2bac83de92UL;
   tf->codes[2820] = 0x0000cf2d466d06f5UL;
   tf->codes[2821] = 0x0000cf31d9997a59UL;
   tf->codes[2822] = 0x0000cf337382a2bcUL;
   tf->codes[2823] = 0x0000cf345dbeb9d0UL;
   tf->codes[2824] = 0x0000cf371c72ff0cUL;
   tf->codes[2825] = 0x0000cf37570204d1UL;
   tf->codes[2826] = 0x0000cf3806af1620UL;
   tf->codes[2827] = 0x0000cf39a0983e83UL;
   tf->codes[2828] = 0x0000cf3e33c4b1e7UL;
   tf->codes[2829] = 0x0000cf40b7e9f15eUL;
   tf->codes[2830] = 0x0000cf43ebbc4224UL;
   tf->codes[2831] = 0x0000cf454b1664c2UL;
   tf->codes[2832] = 0x0000cf5045e779b2UL;
   tf->codes[2833] = 0x0000cf50f5948b01UL;
   tf->codes[2834] = 0x0000cf55fddf09efUL;
   tf->codes[2835] = 0x0000cf5b062988ddUL;
   tf->codes[2836] = 0x0000cf5f2437f0b7UL;
   tf->codes[2837] = 0x0000cf62580a417dUL;
   tf->codes[2838] = 0x0000cf6292994742UL;
   tf->codes[2839] = 0x0000cf6600fa9dcdUL;
   tf->codes[2840] = 0x0000cf676054c06bUL;
   tf->codes[2841] = 0x0000cf684a90d77fUL;
   tf->codes[2842] = 0x0000cf6b43d42280UL;
   tf->codes[2843] = 0x0000cf6f61e28a5aUL;
   tf->codes[2844] = 0x0000cf70118f9ba9UL;
   tf->codes[2845] = 0x0000cf755469205cUL;
   tf->codes[2846] = 0x0000cf763ea53770UL;
   tf->codes[2847] = 0x0000cf7c312bcd72UL;
   tf->codes[2848] = 0x0000cf7d9085f010UL;
   tf->codes[2849] = 0x0000cf7e4033015fUL;
   tf->codes[2850] = 0x0000cf8298d06efeUL;
   tf->codes[2851] = 0x0000cf83830c8612UL;
   tf->codes[2852] = 0x0000cf855784b43aUL;
   tf->codes[2853] = 0x0000cf8641c0cb4eUL;
   tf->codes[2854] = 0x0000cf87668be827UL;
   tf->codes[2855] = 0x0000cf88c5e60ac5UL;
   tf->codes[2856] = 0x0000cf893b04164fUL;
   tf->codes[2857] = 0x0000cf89eab1279eUL;
   tf->codes[2858] = 0x0000cf8a25402d63UL;
   tf->codes[2859] = 0x0000cf8e08bf8f78UL;
   tf->codes[2860] = 0x0000cf8ef2fba68cUL;
   tf->codes[2861] = 0x0000cf90c773d4b4UL;
   tf->codes[2862] = 0x0000cf9226cdf752UL;
   tf->codes[2863] = 0x0000cf93110a0e66UL;
   tf->codes[2864] = 0x0000cf934b99142bUL;
   tf->codes[2865] = 0x0000cf9470643104UL;
   tf->codes[2866] = 0x0000cf94aaf336c9UL;
   tf->codes[2867] = 0x0000cf972f187640UL;
   tf->codes[2868] = 0x0000cf97a43681caUL;
   tf->codes[2869] = 0x0000cf9a285bc141UL;
   tf->codes[2870] = 0x0000cf9ad808d290UL;
   tf->codes[2871] = 0x0000cf9dd14c1d91UL;
   tf->codes[2872] = 0x0000cf9fe053517eUL;
   tf->codes[2873] = 0x0000cfa34eb4a809UL;
   tf->codes[2874] = 0x0000cfa38943adceUL;
   tf->codes[2875] = 0x0000cfa3c3d2b393UL;
   tf->codes[2876] = 0x0000cfa4737fc4e2UL;
   tf->codes[2877] = 0x0000cfa81c702132UL;
   tf->codes[2878] = 0x0000cfa9413b3e0bUL;
   tf->codes[2879] = 0x0000cfabffef8347UL;
   tf->codes[2880] = 0x0000cfad24baa020UL;
   tf->codes[2881] = 0x0000cfadd467b16fUL;
   tf->codes[2882] = 0x0000cfae0ef6b734UL;
   tf->codes[2883] = 0x0000cfaf33c1d40dUL;
   tf->codes[2884] = 0x0000cfb01dfdeb21UL;
   tf->codes[2885] = 0x0000cfb1b7e71384UL;
   tf->codes[2886] = 0x0000cfb22d051f0eUL;
   tf->codes[2887] = 0x0000cfb2dcb2305dUL;
   tf->codes[2888] = 0x0000cfb3c6ee4771UL;
   tf->codes[2889] = 0x0000cfb5d5f57b5eUL;
   tf->codes[2890] = 0x0000cfb76fdea3c1UL;
   tf->codes[2891] = 0x0000cfb94456d1e9UL;
   tf->codes[2892] = 0x0000cfbbc87c1160UL;
   tf->codes[2893] = 0x0000cfbd626539c3UL;
   tf->codes[2894] = 0x0000cfbe12124b12UL;
   tf->codes[2895] = 0x0000cfbe4ca150d7UL;
   tf->codes[2896] = 0x0000cfbfabfb7375UL;
   tf->codes[2897] = 0x0000cfc31a5cca00UL;
   tf->codes[2898] = 0x0000cfc5d9110f3cUL;
   tf->codes[2899] = 0x0000cfc613a01501UL;
   tf->codes[2900] = 0x0000cfc688be208bUL;
   tf->codes[2901] = 0x0000cfcb1bea93efUL;
   tf->codes[2902] = 0x0000cfcfe9a60d18UL;
   tf->codes[2903] = 0x0000cfd2333c46caUL;
   tf->codes[2904] = 0x0000cfd26dcb4c8fUL;
   tf->codes[2905] = 0x0000cfd3580763a3UL;
   tf->codes[2906] = 0x0000cfd392966968UL;
   tf->codes[2907] = 0x0000cfd47cd2807cUL;
   tf->codes[2908] = 0x0000cfd4b7618641UL;
   tf->codes[2909] = 0x0000cfd8d56fee1bUL;
   tf->codes[2910] = 0x0000cfd9851cff6aUL;
   tf->codes[2911] = 0x0000cfd9fa3b0af4UL;
   tf->codes[2912] = 0x0000cfdb94243357UL;
   tf->codes[2913] = 0x0000cfde184972ceUL;
   tf->codes[2914] = 0x0000cfdf028589e2UL;
   tf->codes[2915] = 0x0000cfe02750a6bbUL;
   tf->codes[2916] = 0x0000cfe14c1bc394UL;
   tf->codes[2917] = 0x0000cfe23657daa8UL;
   tf->codes[2918] = 0x0000cfe32093f1bcUL;
   tf->codes[2919] = 0x0000cfe3d041030bUL;
   tf->codes[2920] = 0x0000cfe5df4836f8UL;
   tf->codes[2921] = 0x0000cfe654664282UL;
   tf->codes[2922] = 0x0000cfe7ee4f6ae5UL;
   tf->codes[2923] = 0x0000cfecf699e9d3UL;
   tf->codes[2924] = 0x0000cfed6bb7f55dUL;
   tf->codes[2925] = 0x0000cfefb54e2f0fUL;
   tf->codes[2926] = 0x0000cff114a851adUL;
   tf->codes[2927] = 0x0000cff27402744bUL;
   tf->codes[2928] = 0x0000cff2ae917a10UL;
   tf->codes[2929] = 0x0000cff4487aa273UL;
   tf->codes[2930] = 0x0000cff61cf2d09bUL;
   tf->codes[2931] = 0x0000cff65781d660UL;
   tf->codes[2932] = 0x0000cff6cc9fe1eaUL;
   tf->codes[2933] = 0x0000cff77c4cf339UL;
   tf->codes[2934] = 0x0000cff8dba715d7UL;
   tf->codes[2935] = 0x0000cffa007232b0UL;
   tf->codes[2936] = 0x0000cffb5fcc554eUL;
   tf->codes[2937] = 0x0000cffe590fa04fUL;
   tf->codes[2938] = 0x0000cffff2f8c8b2UL;
   tf->codes[2939] = 0x0000d000a2a5da01UL;
   tf->codes[2940] = 0x0000d001c770f6daUL;
   tf->codes[2941] = 0x0000d0023c8f0264UL;
   tf->codes[2942] = 0x0000d002771e0829UL;
   tf->codes[2943] = 0x0000d002ec3c13b3UL;
   tf->codes[2944] = 0x0000d003615a1f3dUL;
   tf->codes[2945] = 0x0000d003d6782ac7UL;
   tf->codes[2946] = 0x0000d0044b963651UL;
   tf->codes[2947] = 0x0000d004c0b441dbUL;
   tf->codes[2948] = 0x0000d00535d24d65UL;
   tf->codes[2949] = 0x0000d005aaf058efUL;
   tf->codes[2950] = 0x0000d005e57f5eb4UL;
   tf->codes[2951] = 0x0000d0065a9d6a3eUL;
   tf->codes[2952] = 0x0000d006952c7003UL;
   tf->codes[2953] = 0x0000d006cfbb75c8UL;
   tf->codes[2954] = 0x0000d0077f688717UL;
   tf->codes[2955] = 0x0000d007f48692a1UL;
   tf->codes[2956] = 0x0000d008dec2a9b5UL;
   tf->codes[2957] = 0x0000d00a78abd218UL;
   tf->codes[2958] = 0x0000d00ab33ad7ddUL;
   tf->codes[2959] = 0x0000d00aedc9dda2UL;
   tf->codes[2960] = 0x0000d00b2858e367UL;
   tf->codes[2961] = 0x0000d00b62e7e92cUL;
   tf->codes[2962] = 0x0000d00b9d76eef1UL;
   tf->codes[2963] = 0x0000d00bd805f4b6UL;
   tf->codes[2964] = 0x0000d00e219c2e68UL;
   tf->codes[2965] = 0x0000d00e96ba39f2UL;
   tf->codes[2966] = 0x0000d00f46674b41UL;
   tf->codes[2967] = 0x0000d00fbb8556cbUL;
   tf->codes[2968] = 0x0000d01030a36255UL;
   tf->codes[2969] = 0x0000d0106b32681aUL;
   tf->codes[2970] = 0x0000d011556e7f2eUL;
   tf->codes[2971] = 0x0000d0118ffd84f3UL;
   tf->codes[2972] = 0x0000d012051b907dUL;
   tf->codes[2973] = 0x0000d0123faa9642UL;
   tf->codes[2974] = 0x0000d012ef57a791UL;
   tf->codes[2975] = 0x0000d01329e6ad56UL;
   tf->codes[2976] = 0x0000d0136475b31bUL;
   tf->codes[2977] = 0x0000d013d993bea5UL;
   tf->codes[2978] = 0x0000d014fe5edb7eUL;
   tf->codes[2979] = 0x0000d015737ce708UL;
   tf->codes[2980] = 0x0000d0165db8fe1cUL;
   tf->codes[2981] = 0x0000d0170d660f6bUL;
   tf->codes[2982] = 0x0000d01747f51530UL;
   tf->codes[2983] = 0x0000d01782841af5UL;
   tf->codes[2984] = 0x0000d017bd1320baUL;
   tf->codes[2985] = 0x0000d017f7a2267fUL;
   tf->codes[2986] = 0x0000d018e1de3d93UL;
   tf->codes[2987] = 0x0000d019cc1a54a7UL;
   tf->codes[2988] = 0x0000d01a06a95a6cUL;
   tf->codes[2989] = 0x0000d01ab6566bbbUL;
   tf->codes[2990] = 0x0000d01af0e57180UL;
   tf->codes[2991] = 0x0000d01ba09282cfUL;
   tf->codes[2992] = 0x0000d01cc55d9fa8UL;
   tf->codes[2993] = 0x0000d01cffeca56dUL;
   tf->codes[2994] = 0x0000d01d750ab0f7UL;
   tf->codes[2995] = 0x0000d01daf99b6bcUL;
   tf->codes[2996] = 0x0000d01e5f46c80bUL;
   tf->codes[2997] = 0x0000d01e99d5cdd0UL;
   tf->codes[2998] = 0x0000d01f0ef3d95aUL;
   tf->codes[2999] = 0x0000d01fbea0eaa9UL;
   tf->codes[3000] = 0x0000d02033bef633UL;
   tf->codes[3001] = 0x0000d0227d552fe5UL;
   tf->codes[3002] = 0x0000d022f2733b6fUL;
   tf->codes[3003] = 0x0000d0232d024134UL;
   tf->codes[3004] = 0x0000d025017a6f5cUL;
   tf->codes[3005] = 0x0000d0253c097521UL;
   tf->codes[3006] = 0x0000d026d5f29d84UL;
   tf->codes[3007] = 0x0000d0271081a349UL;
   tf->codes[3008] = 0x0000d0274b10a90eUL;
   tf->codes[3009] = 0x0000d027859faed3UL;
   tf->codes[3010] = 0x0000d027c02eb498UL;
   tf->codes[3011] = 0x0000d027fabdba5dUL;
   tf->codes[3012] = 0x0000d028354cc022UL;
   tf->codes[3013] = 0x0000d028e4f9d171UL;
   tf->codes[3014] = 0x0000d02994a6e2c0UL;
   tf->codes[3015] = 0x0000d02af401055eUL;
   tf->codes[3016] = 0x0000d02b691f10e8UL;
   tf->codes[3017] = 0x0000d02ded44505fUL;
   tf->codes[3018] = 0x0000d02e27d35624UL;
   tf->codes[3019] = 0x0000d02f4c9e72fdUL;
   tf->codes[3020] = 0x0000d03071698fd6UL;
   tf->codes[3021] = 0x0000d0328070c3c3UL;
   tf->codes[3022] = 0x0000d032baffc988UL;
   tf->codes[3023] = 0x0000d033301dd512UL;
   tf->codes[3024] = 0x0000d034ca06fd75UL;
   tf->codes[3025] = 0x0000d0353f2508ffUL;
   tf->codes[3026] = 0x0000d03629612013UL;
   tf->codes[3027] = 0x0000d03663f025d8UL;
   tf->codes[3028] = 0x0000d036d90e3162UL;
   tf->codes[3029] = 0x0000d037139d3727UL;
   tf->codes[3030] = 0x0000d03788bb42b1UL;
   tf->codes[3031] = 0x0000d03922a46b14UL;
   tf->codes[3032] = 0x0000d0395d3370d9UL;
   tf->codes[3033] = 0x0000d03a0ce08228UL;
   tf->codes[3034] = 0x0000d03b31ab9f01UL;
   tf->codes[3035] = 0x0000d03b6c3aa4c6UL;
   tf->codes[3036] = 0x0000d03be158b050UL;
   tf->codes[3037] = 0x0000d03c1be7b615UL;
   tf->codes[3038] = 0x0000d03c5676bbdaUL;
   tf->codes[3039] = 0x0000d03db5d0de78UL;
   tf->codes[3040] = 0x0000d03df05fe43dUL;
   tf->codes[3041] = 0x0000d03f152b0116UL;
   tf->codes[3042] = 0x0000d03f4fba06dbUL;
   tf->codes[3043] = 0x0000d040e9a32f3eUL;
   tf->codes[3044] = 0x0000d04124323503UL;
   tf->codes[3045] = 0x0000d041d3df4652UL;
   tf->codes[3046] = 0x0000d042838c57a1UL;
   tf->codes[3047] = 0x0000d04542409cddUL;
   tf->codes[3048] = 0x0000d045b75ea867UL;
   tf->codes[3049] = 0x0000d045f1edae2cUL;
   tf->codes[3050] = 0x0000d046670bb9b6UL;
   tf->codes[3051] = 0x0000d046dc29c540UL;
   tf->codes[3052] = 0x0000d04716b8cb05UL;
   tf->codes[3053] = 0x0000d0487612eda3UL;
   tf->codes[3054] = 0x0000d048eb30f92dUL;
   tf->codes[3055] = 0x0000d04925bffef2UL;
   tf->codes[3056] = 0x0000d049d56d1041UL;
   tf->codes[3057] = 0x0000d04abfa92755UL;
   tf->codes[3058] = 0x0000d04ba9e53e69UL;
   tf->codes[3059] = 0x0000d04be474442eUL;
   tf->codes[3060] = 0x0000d04c1f0349f3UL;
   tf->codes[3061] = 0x0000d04e689983a5UL;
   tf->codes[3062] = 0x0000d04ea328896aUL;
   tf->codes[3063] = 0x0000d04f52d59ab9UL;
   tf->codes[3064] = 0x0000d04f8d64a07eUL;
   tf->codes[3065] = 0x0000d050ecbec31cUL;
   tf->codes[3066] = 0x0000d051274dc8e1UL;
   tf->codes[3067] = 0x0000d05161dccea6UL;
   tf->codes[3068] = 0x0000d0519c6bd46bUL;
   tf->codes[3069] = 0x0000d0524c18e5baUL;
   tf->codes[3070] = 0x0000d052c136f144UL;
   tf->codes[3071] = 0x0000d054209113e2UL;
   tf->codes[3072] = 0x0000d0545b2019a7UL;
   tf->codes[3073] = 0x0000d05495af1f6cUL;
   tf->codes[3074] = 0x0000d054d03e2531UL;
   tf->codes[3075] = 0x0000d055455c30bbUL;
   tf->codes[3076] = 0x0000d0557feb3680UL;
   tf->codes[3077] = 0x0000d0562f9847cfUL;
   tf->codes[3078] = 0x0000d05719d45ee3UL;
   tf->codes[3079] = 0x0000d057546364a8UL;
   tf->codes[3080] = 0x0000d057c9817032UL;
   tf->codes[3081] = 0x0000d058792e8181UL;
   tf->codes[3082] = 0x0000d05a1317a9e4UL;
   tf->codes[3083] = 0x0000d05a4da6afa9UL;
   tf->codes[3084] = 0x0000d05b37e2c6bdUL;
   tf->codes[3085] = 0x0000d05c221eddd1UL;
   tf->codes[3086] = 0x0000d05e6bb51783UL;
   tf->codes[3087] = 0x0000d05fcb0f3a21UL;
   tf->codes[3088] = 0x0000d061da166e0eUL;
   tf->codes[3089] = 0x0000d0624f347998UL;
   tf->codes[3090] = 0x0000d062c4528522UL;
   tf->codes[3091] = 0x0000d063397090acUL;
   tf->codes[3092] = 0x0000d067920dfe4bUL;
   tf->codes[3093] = 0x0000d067cc9d0410UL;
   tf->codes[3094] = 0x0000d069dba437fdUL;
   tf->codes[3095] = 0x0000d06b006f54d6UL;
   tf->codes[3096] = 0x0000d06bb01c6625UL;
   tf->codes[3097] = 0x0000d06beaab6beaUL;
   tf->codes[3098] = 0x0000d06f590cc275UL;
   tf->codes[3099] = 0x0000d06fce2acdffUL;
   tf->codes[3100] = 0x0000d0704348d989UL;
   tf->codes[3101] = 0x0000d070b866e513UL;
   tf->codes[3102] = 0x0000d0728cdf133bUL;
   tf->codes[3103] = 0x0000d073771b2a4fUL;
   tf->codes[3104] = 0x0000d073b1aa3014UL;
   tf->codes[3105] = 0x0000d073ec3935d9UL;
   tf->codes[3106] = 0x0000d07461574163UL;
   tf->codes[3107] = 0x0000d0749be64728UL;
   tf->codes[3108] = 0x0000d076e57c80daUL;
   tf->codes[3109] = 0x0000d0775a9a8c64UL;
   tf->codes[3110] = 0x0000d07795299229UL;
   tf->codes[3111] = 0x0000d07969a1c051UL;
   tf->codes[3112] = 0x0000d079debfcbdbUL;
   tf->codes[3113] = 0x0000d07b78a8f43eUL;
   tf->codes[3114] = 0x0000d07c2856058dUL;
   tf->codes[3115] = 0x0000d07c9d741117UL;
   tf->codes[3116] = 0x0000d07cd80316dcUL;
   tf->codes[3117] = 0x0000d07e375d397aUL;
   tf->codes[3118] = 0x0000d07ee70a4ac9UL;
   tf->codes[3119] = 0x0000d07f96b75c18UL;
   tf->codes[3120] = 0x0000d07fd14661ddUL;
   tf->codes[3121] = 0x0000d0800bd567a2UL;
   tf->codes[3122] = 0x0000d080f6117eb6UL;
   tf->codes[3123] = 0x0000d08130a0847bUL;
   tf->codes[3124] = 0x0000d0816b2f8a40UL;
   tf->codes[3125] = 0x0000d081e04d95caUL;
   tf->codes[3126] = 0x0000d082556ba154UL;
   tf->codes[3127] = 0x0000d0830518b2a3UL;
   tf->codes[3128] = 0x0000d08798452607UL;
   tf->codes[3129] = 0x0000d0880d633191UL;
   tf->codes[3130] = 0x0000d08847f23756UL;
   tf->codes[3131] = 0x0000d088bd1042e0UL;
   tf->codes[3132] = 0x0000d089322e4e6aUL;
   tf->codes[3133] = 0x0000d08b41358257UL;
   tf->codes[3134] = 0x0000d08e3a78cd58UL;
   tf->codes[3135] = 0x0000d08e7507d31dUL;
   tf->codes[3136] = 0x0000d08eaf96d8e2UL;
   tf->codes[3137] = 0x0000d09049800145UL;
   tf->codes[3138] = 0x0000d090f92d1294UL;
   tf->codes[3139] = 0x0000d09133bc1859UL;
   tf->codes[3140] = 0x0000d091e36929a8UL;
   tf->codes[3141] = 0x0000d0921df82f6dUL;
   tf->codes[3142] = 0x0000d0937d52520bUL;
   tf->codes[3143] = 0x0000d093b7e157d0UL;
   tf->codes[3144] = 0x0000d0942cff635aUL;
   tf->codes[3145] = 0x0000d09601779182UL;
   tf->codes[3146] = 0x0000d096b124a2d1UL;
   tf->codes[3147] = 0x0000d0984b0dcb34UL;
   tf->codes[3148] = 0x0000d098c02bd6beUL;
   tf->codes[3149] = 0x0000d0993549e248UL;
   tf->codes[3150] = 0x0000d0996fd8e80dUL;
   tf->codes[3151] = 0x0000d09a1f85f95cUL;
   tf->codes[3152] = 0x0000d09b44511635UL;
   tf->codes[3153] = 0x0000d09d53584a22UL;
   tf->codes[3154] = 0x0000d09e3d946136UL;
   tf->codes[3155] = 0x0000d09e782366fbUL;
   tf->codes[3156] = 0x0000d09f625f7e0fUL;
   tf->codes[3157] = 0x0000d09fd77d8999UL;
   tf->codes[3158] = 0x0000d0a0872a9ae8UL;
   tf->codes[3159] = 0x0000d0a0fc48a672UL;
   tf->codes[3160] = 0x0000d0a17166b1fcUL;
   tf->codes[3161] = 0x0000d0a1abf5b7c1UL;
   tf->codes[3162] = 0x0000d0a30b4fda5fUL;
   tf->codes[3163] = 0x0000d0a3f58bf173UL;
   tf->codes[3164] = 0x0000d0a46aa9fcfdUL;
   tf->codes[3165] = 0x0000d0a5ca041f9bUL;
   tf->codes[3166] = 0x0000d0a63f222b25UL;
   tf->codes[3167] = 0x0000d0a679b130eaUL;
   tf->codes[3168] = 0x0000d0a6eecf3c74UL;
   tf->codes[3169] = 0x0000d0a763ed47feUL;
   tf->codes[3170] = 0x0000d0a79e7c4dc3UL;
   tf->codes[3171] = 0x0000d0a7d90b5388UL;
   tf->codes[3172] = 0x0000d0a84e295f12UL;
   tf->codes[3173] = 0x0000d0a8c3476a9cUL;
   tf->codes[3174] = 0x0000d0a972f47bebUL;
   tf->codes[3175] = 0x0000d0a9e8128775UL;
   tf->codes[3176] = 0x0000d0aad24e9e89UL;
   tf->codes[3177] = 0x0000d0ab0cdda44eUL;
   tf->codes[3178] = 0x0000d0afa00a17b2UL;
   tf->codes[3179] = 0x0000d0b04fb72901UL;
   tf->codes[3180] = 0x0000d0b08a462ec6UL;
   tf->codes[3181] = 0x0000d0b1748245daUL;
   tf->codes[3182] = 0x0000d0b25ebe5ceeUL;
   tf->codes[3183] = 0x0000d0b2994d62b3UL;
   tf->codes[3184] = 0x0000d0b2d3dc6878UL;
   tf->codes[3185] = 0x0000d0b30e6b6e3dUL;
   tf->codes[3186] = 0x0000d0b3f8a78551UL;
   tf->codes[3187] = 0x0000d0b433368b16UL;
   tf->codes[3188] = 0x0000d0b51d72a22aUL;
   tf->codes[3189] = 0x0000d0b59290adb4UL;
   tf->codes[3190] = 0x0000d0b607aeb93eUL;
   tf->codes[3191] = 0x0000d0b72c79d617UL;
   tf->codes[3192] = 0x0000d0b76708dbdcUL;
   tf->codes[3193] = 0x0000d0b7a197e1a1UL;
   tf->codes[3194] = 0x0000d0b7dc26e766UL;
   tf->codes[3195] = 0x0000d0b88bd3f8b5UL;
   tf->codes[3196] = 0x0000d0b9b09f158eUL;
   tf->codes[3197] = 0x0000d0ba25bd2118UL;
   tf->codes[3198] = 0x0000d0bad56a3267UL;
   tf->codes[3199] = 0x0000d0bb4a883df1UL;
   tf->codes[3200] = 0x0000d0be093c832dUL;
   tf->codes[3201] = 0x0000d0c01843b71aUL;
   tf->codes[3202] = 0x0000d0c0c7f0c869UL;
   tf->codes[3203] = 0x0000d0c31187021bUL;
   tf->codes[3204] = 0x0000d0c34c1607e0UL;
   tf->codes[3205] = 0x0000d0c386a50da5UL;
   tf->codes[3206] = 0x0000d0c5208e3608UL;
   tf->codes[3207] = 0x0000d0c6f5066430UL;
   tf->codes[3208] = 0x0000d0c72f9569f5UL;
   tf->codes[3209] = 0x0000d0c7a4b3757fUL;
   tf->codes[3210] = 0x0000d0c7df427b44UL;
   tf->codes[3211] = 0x0000d0c8546086ceUL;
   tf->codes[3212] = 0x0000d0c9040d981dUL;
   tf->codes[3213] = 0x0000d0c9ee49af31UL;
   tf->codes[3214] = 0x0000d0ca6367babbUL;
   tf->codes[3215] = 0x0000d0cb4da3d1cfUL;
   tf->codes[3216] = 0x0000d0cbfd50e31eUL;
   tf->codes[3217] = 0x0000d0ce0c58170bUL;
   tf->codes[3218] = 0x0000d0cf312333e4UL;
   tf->codes[3219] = 0x0000d0d01b5f4af8UL;
   tf->codes[3220] = 0x0000d0d055ee50bdUL;
   tf->codes[3221] = 0x0000d0d0907d5682UL;
   tf->codes[3222] = 0x0000d0d1402a67d1UL;
   tf->codes[3223] = 0x0000d0d34f319bbeUL;
   tf->codes[3224] = 0x0000d0d55e38cfabUL;
   tf->codes[3225] = 0x0000d0d5d356db35UL;
   tf->codes[3226] = 0x0000d0d76d400398UL;
   tf->codes[3227] = 0x0000d0d7e25e0f22UL;
   tf->codes[3228] = 0x0000d0d81ced14e7UL;
   tf->codes[3229] = 0x0000d0d8920b2071UL;
   tf->codes[3230] = 0x0000d0d907292bfbUL;
   tf->codes[3231] = 0x0000d0d9b6d63d4aUL;
   tf->codes[3232] = 0x0000d0d9f165430fUL;
   tf->codes[3233] = 0x0000d0da2bf448d4UL;
   tf->codes[3234] = 0x0000d0daa112545eUL;
   tf->codes[3235] = 0x0000d0dadba15a23UL;
   tf->codes[3236] = 0x0000d0db50bf65adUL;
   tf->codes[3237] = 0x0000d0de4a02b0aeUL;
   tf->codes[3238] = 0x0000d0de8491b673UL;
   tf->codes[3239] = 0x0000d0def9afc1fdUL;
   tf->codes[3240] = 0x0000d0df343ec7c2UL;
   tf->codes[3241] = 0x0000d0dfa95cd34cUL;
   tf->codes[3242] = 0x0000d0dfe3ebd911UL;
   tf->codes[3243] = 0x0000d0e17dd50174UL;
   tf->codes[3244] = 0x0000d0e1f2f30cfeUL;
   tf->codes[3245] = 0x0000d0e2a2a01e4dUL;
   tf->codes[3246] = 0x0000d0e3524d2f9cUL;
   tf->codes[3247] = 0x0000d0e5d6726f13UL;
   tf->codes[3248] = 0x0000d0e6c0ae8627UL;
   tf->codes[3249] = 0x0000d0e6fb3d8becUL;
   tf->codes[3250] = 0x0000d0e735cc91b1UL;
   tf->codes[3251] = 0x0000d0e7aaea9d3bUL;
   tf->codes[3252] = 0x0000d0e7e579a300UL;
   tf->codes[3253] = 0x0000d0e9f480d6edUL;
   tf->codes[3254] = 0x0000d0eadebcee01UL;
   tf->codes[3255] = 0x0000d0ee87ad4a51UL;
   tf->codes[3256] = 0x0000d0ef375a5ba0UL;
   tf->codes[3257] = 0x0000d0f10bd289c8UL;
   tf->codes[3258] = 0x0000d0f180f09552UL;
   tf->codes[3259] = 0x0000d0f40515d4c9UL;
   tf->codes[3260] = 0x0000d0f47a33e053UL;
   tf->codes[3261] = 0x0000d0f59efefd2cUL;
   tf->codes[3262] = 0x0000d0f6141d08b6UL;
   tf->codes[3263] = 0x0000d0f6893b1440UL;
   tf->codes[3264] = 0x0000d0f6c3ca1a05UL;
   tf->codes[3265] = 0x0000d0f738e8258fUL;
   tf->codes[3266] = 0x0000d0f7ae063119UL;
   tf->codes[3267] = 0x0000d0f7e89536deUL;
   tf->codes[3268] = 0x0000d0f9827e5f41UL;
   tf->codes[3269] = 0x0000d0fb1c6787a4UL;
   tf->codes[3270] = 0x0000d0fb56f68d69UL;
   tf->codes[3271] = 0x0000d0fb9185932eUL;
   tf->codes[3272] = 0x0000d0fc06a39eb8UL;
   tf->codes[3273] = 0x0000d0fc4132a47dUL;
   tf->codes[3274] = 0x0000d0fc7bc1aa42UL;
   tf->codes[3275] = 0x0000d0fe5039d86aUL;
   tf->codes[3276] = 0x0000d0ff3a75ef7eUL;
   tf->codes[3277] = 0x0000d0ff7504f543UL;
   tf->codes[3278] = 0x0000d0ffaf93fb08UL;
   tf->codes[3279] = 0x0000d10099d0121cUL;
   tf->codes[3280] = 0x0000d100d45f17e1UL;
   tf->codes[3281] = 0x0000d1010eee1da6UL;
   tf->codes[3282] = 0x0000d102e3664bceUL;
   tf->codes[3283] = 0x0000d1031df55193UL;
   tf->codes[3284] = 0x0000d10393135d1dUL;
   tf->codes[3285] = 0x0000d103cda262e2UL;
   tf->codes[3286] = 0x0000d104f26d7fbbUL;
   tf->codes[3287] = 0x0000d1073c03b96dUL;
   tf->codes[3288] = 0x0000d1077692bf32UL;
   tf->codes[3289] = 0x0000d107b121c4f7UL;
   tf->codes[3290] = 0x0000d107ebb0cabcUL;
   tf->codes[3291] = 0x0000d1094b0aed5aUL;
   tf->codes[3292] = 0x0000d1098599f31fUL;
   tf->codes[3293] = 0x0000d109c028f8e4UL;
   tf->codes[3294] = 0x0000d10b5a122147UL;
   tf->codes[3295] = 0x0000d10b94a1270cUL;
   tf->codes[3296] = 0x0000d10d69195534UL;
   tf->codes[3297] = 0x0000d10f3d91835cUL;
   tf->codes[3298] = 0x0000d10fed3e94abUL;
   tf->codes[3299] = 0x0000d110625ca035UL;
   tf->codes[3300] = 0x0000d113d0bdf6c0UL;
   tf->codes[3301] = 0x0000d1140b4cfc85UL;
   tf->codes[3302] = 0x0000d114806b080fUL;
   tf->codes[3303] = 0x0000d114bafa0dd4UL;
   tf->codes[3304] = 0x0000d115dfc52aadUL;
   tf->codes[3305] = 0x0000d1161a543072UL;
   tf->codes[3306] = 0x0000d1168f723bfcUL;
   tf->codes[3307] = 0x0000d116ca0141c1UL;
   tf->codes[3308] = 0x0000d118295b645fUL;
   tf->codes[3309] = 0x0000d1189e796fe9UL;
   tf->codes[3310] = 0x0000d1194e268138UL;
   tf->codes[3311] = 0x0000d11a3862984cUL;
   tf->codes[3312] = 0x0000d11b5d2db525UL;
   tf->codes[3313] = 0x0000d11b97bcbaeaUL;
   tf->codes[3314] = 0x0000d11c0cdac674UL;
   tf->codes[3315] = 0x0000d11e56710026UL;
   tf->codes[3316] = 0x0000d11e910005ebUL;
   tf->codes[3317] = 0x0000d11ff05a2889UL;
   tf->codes[3318] = 0x0000d1202ae92e4eUL;
   tf->codes[3319] = 0x0000d120a00739d8UL;
   tf->codes[3320] = 0x0000d12115254562UL;
   tf->codes[3321] = 0x0000d1214fb44b27UL;
   tf->codes[3322] = 0x0000d1218a4350ecUL;
   tf->codes[3323] = 0x0000d121ff615c76UL;
   tf->codes[3324] = 0x0000d122747f6800UL;
   tf->codes[3325] = 0x0000d123242c794fUL;
   tf->codes[3326] = 0x0000d1235ebb7f14UL;
   tf->codes[3327] = 0x0000d12448f79628UL;
   tf->codes[3328] = 0x0000d124f8a4a777UL;
   tf->codes[3329] = 0x0000d1256dc2b301UL;
   tf->codes[3330] = 0x0000d125a851b8c6UL;
   tf->codes[3331] = 0x0000d1282c76f83dUL;
   tf->codes[3332] = 0x0000d128dc24098cUL;
   tf->codes[3333] = 0x0000d1298bd11adbUL;
   tf->codes[3334] = 0x0000d12b60494903UL;
   tf->codes[3335] = 0x0000d12bd567548dUL;
   tf->codes[3336] = 0x0000d12f7e57b0ddUL;
   tf->codes[3337] = 0x0000d12ff375bc67UL;
   tf->codes[3338] = 0x0000d130a322cdb6UL;
   tf->codes[3339] = 0x0000d130ddb1d37bUL;
   tf->codes[3340] = 0x0000d1318d5ee4caUL;
   tf->codes[3341] = 0x0000d1323d0bf619UL;
   tf->codes[3342] = 0x0000d133d6f51e7cUL;
   tf->codes[3343] = 0x0000d13411842441UL;
   tf->codes[3344] = 0x0000d134fbc03b55UL;
   tf->codes[3345] = 0x0000d135e5fc5269UL;
   tf->codes[3346] = 0x0000d13745567507UL;
   tf->codes[3347] = 0x0000d1382f928c1bUL;
   tf->codes[3348] = 0x0000d1386a2191e0UL;
   tf->codes[3349] = 0x0000d138a4b097a5UL;
   tf->codes[3350] = 0x0000d138df3f9d6aUL;
   tf->codes[3351] = 0x0000d139545da8f4UL;
   tf->codes[3352] = 0x0000d13a040aba43UL;
   tf->codes[3353] = 0x0000d13bd882e86bUL;
   tf->codes[3354] = 0x0000d13d726c10ceUL;
   tf->codes[3355] = 0x0000d13e2219221dUL;
   tf->codes[3356] = 0x0000d13e5ca827e2UL;
   tf->codes[3357] = 0x0000d13f0c553931UL;
   tf->codes[3358] = 0x0000d141cb097e6dUL;
   tf->codes[3359] = 0x0000d142402789f7UL;
   tf->codes[3360] = 0x0000d142efd49b46UL;
   tf->codes[3361] = 0x0000d14364f2a6d0UL;
   tf->codes[3362] = 0x0000d145ae88e082UL;
   tf->codes[3363] = 0x0000d145e917e647UL;
   tf->codes[3364] = 0x0000d1470de30320UL;
   tf->codes[3365] = 0x0000d149cc97485cUL;
   tf->codes[3366] = 0x0000d14a07264e21UL;
   tf->codes[3367] = 0x0000d14a41b553e6UL;
   tf->codes[3368] = 0x0000d14fbf1dde5eUL;
   tf->codes[3369] = 0x0000d150e3e8fb37UL;
   tf->codes[3370] = 0x0000d151590706c1UL;
   tf->codes[3371] = 0x0000d151ce25124bUL;
   tf->codes[3372] = 0x0000d15208b41810UL;
   tf->codes[3373] = 0x0000d153680e3aaeUL;
   tf->codes[3374] = 0x0000d153a29d4073UL;
   tf->codes[3375] = 0x0000d154524a51c2UL;
   tf->codes[3376] = 0x0000d154c7685d4cUL;
   tf->codes[3377] = 0x0000d156d66f9139UL;
   tf->codes[3378] = 0x0000d15710fe96feUL;
   tf->codes[3379] = 0x0000d157fb3aae12UL;
   tf->codes[3380] = 0x0000d1595a94d0b0UL;
   tf->codes[3381] = 0x0000d15b699c049dUL;
   tf->codes[3382] = 0x0000d15ba42b0a62UL;
   tf->codes[3383] = 0x0000d15d78a3388aUL;
   tf->codes[3384] = 0x0000d15db3323e4fUL;
   tf->codes[3385] = 0x0000d160ac758950UL;
   tf->codes[3386] = 0x0000d1615c229a9fUL;
   tf->codes[3387] = 0x0000d161d140a629UL;
   tf->codes[3388] = 0x0000d162bb7cbd3dUL;
   tf->codes[3389] = 0x0000d163a5b8d451UL;
   tf->codes[3390] = 0x0000d163e047da16UL;
   tf->codes[3391] = 0x0000d1657a310279UL;
   tf->codes[3392] = 0x0000d165ef4f0e03UL;
   tf->codes[3393] = 0x0000d16629de13c8UL;
   tf->codes[3394] = 0x0000d1674ea930a1UL;
   tf->codes[3395] = 0x0000d16923215ec9UL;
   tf->codes[3396] = 0x0000d16a0d5d75ddUL;
   tf->codes[3397] = 0x0000d16a827b8167UL;
   tf->codes[3398] = 0x0000d16abd0a872cUL;
   tf->codes[3399] = 0x0000d16b322892b6UL;
   tf->codes[3400] = 0x0000d16ba7469e40UL;
   tf->codes[3401] = 0x0000d16e2b6bddb7UL;
   tf->codes[3402] = 0x0000d16e65fae37cUL;
   tf->codes[3403] = 0x0000d17075021769UL;
   tf->codes[3404] = 0x0000d170af911d2eUL;
   tf->codes[3405] = 0x0000d172497a4591UL;
   tf->codes[3406] = 0x0000d17333b65ca5UL;
   tf->codes[3407] = 0x0000d1741df273b9UL;
   tf->codes[3408] = 0x0000d1766788ad6bUL;
   tf->codes[3409] = 0x0000d1778c53ca44UL;
   tf->codes[3410] = 0x0000d17a85971545UL;
   tf->codes[3411] = 0x0000d17ac0261b0aUL;
   tf->codes[3412] = 0x0000d17b35442694UL;
   tf->codes[3413] = 0x0000d17ccf2d4ef7UL;
   tf->codes[3414] = 0x0000d17d444b5a81UL;
   tf->codes[3415] = 0x0000d17db969660bUL;
   tf->codes[3416] = 0x0000d17ea3a57d1fUL;
   tf->codes[3417] = 0x0000d17fc87099f8UL;
   tf->codes[3418] = 0x0000d180ed3bb6d1UL;
   tf->codes[3419] = 0x0000d1816259c25bUL;
   tf->codes[3420] = 0x0000d1819ce8c820UL;
   tf->codes[3421] = 0x0000d1821206d3aaUL;
   tf->codes[3422] = 0x0000d1824c95d96fUL;
   tf->codes[3423] = 0x0000d183e67f01d2UL;
   tf->codes[3424] = 0x0000d184d0bb18e6UL;
   tf->codes[3425] = 0x0000d185f58635bfUL;
   tf->codes[3426] = 0x0000d186dfc24cd3UL;
   tf->codes[3427] = 0x0000d18754e0585dUL;
   tf->codes[3428] = 0x0000d1883f1c6f71UL;
   tf->codes[3429] = 0x0000d188b43a7afbUL;
   tf->codes[3430] = 0x0000d18929588685UL;
   tf->codes[3431] = 0x0000d18ac341aee8UL;
   tf->codes[3432] = 0x0000d18afdd0b4adUL;
   tf->codes[3433] = 0x0000d18be80ccbc1UL;
   tf->codes[3434] = 0x0000d18c5d2ad74bUL;
   tf->codes[3435] = 0x0000d18c97b9dd10UL;
   tf->codes[3436] = 0x0000d18f1bdf1c87UL;
   tf->codes[3437] = 0x0000d18f566e224cUL;
   tf->codes[3438] = 0x0000d190061b339bUL;
   tf->codes[3439] = 0x0000d1907b393f25UL;
   tf->codes[3440] = 0x0000d190f0574aafUL;
   tf->codes[3441] = 0x0000d1912ae65074UL;
   tf->codes[3442] = 0x0000d191a0045bfeUL;
   tf->codes[3443] = 0x0000d19215226788UL;
   tf->codes[3444] = 0x0000d193747c8a26UL;
   tf->codes[3445] = 0x0000d193e99a95b0UL;
   tf->codes[3446] = 0x0000d19424299b75UL;
   tf->codes[3447] = 0x0000d1949947a6ffUL;
   tf->codes[3448] = 0x0000d19548f4b84eUL;
   tf->codes[3449] = 0x0000d1958383be13UL;
   tf->codes[3450] = 0x0000d195be12c3d8UL;
   tf->codes[3451] = 0x0000d1984238034fUL;
   tf->codes[3452] = 0x0000d19b760a5415UL;
   tf->codes[3453] = 0x0000d19beb285f9fUL;
   tf->codes[3454] = 0x0000d19d85118802UL;
   tf->codes[3455] = 0x0000d19dbfa08dc7UL;
   tf->codes[3456] = 0x0000d19f1efab065UL;
   tf->codes[3457] = 0x0000d1a043c5cd3eUL;
   tf->codes[3458] = 0x0000d1a1ddaef5a1UL;
   tf->codes[3459] = 0x0000d1a28d5c06f0UL;
   tf->codes[3460] = 0x0000d1a6e5f9748fUL;
   tf->codes[3461] = 0x0000d1a8f500a87cUL;
   tf->codes[3462] = 0x0000d1ad882d1be0UL;
   tf->codes[3463] = 0x0000d1aeacf838b9UL;
   tf->codes[3464] = 0x0000d1af22164443UL;
   tf->codes[3465] = 0x0000d1af5ca54a08UL;
   tf->codes[3466] = 0x0000d1b00c525b57UL;
   tf->codes[3467] = 0x0000d1b21b598f44UL;
   tf->codes[3468] = 0x0000d1b3b542b7a7UL;
   tf->codes[3469] = 0x0000d1b42a60c331UL;
   tf->codes[3470] = 0x0000d1b464efc8f6UL;
   tf->codes[3471] = 0x0000d1b49f7ecebbUL;
   tf->codes[3472] = 0x0000d1b4da0dd480UL;
   tf->codes[3473] = 0x0000d1b75e3313f7UL;
   tf->codes[3474] = 0x0000d1ba920564bdUL;
   tf->codes[3475] = 0x0000d1bacc946a82UL;
   tf->codes[3476] = 0x0000d1bb41b2760cUL;
   tf->codes[3477] = 0x0000d1bb7c417bd1UL;
   tf->codes[3478] = 0x0000d1bbf15f875bUL;
   tf->codes[3479] = 0x0000d1bd8b48afbeUL;
   tf->codes[3480] = 0x0000d1beeaa2d25cUL;
   tf->codes[3481] = 0x0000d1c049fcf4faUL;
   tf->codes[3482] = 0x0000d1c0bf1b0084UL;
   tf->codes[3483] = 0x0000d1c0f9aa0649UL;
   tf->codes[3484] = 0x0000d1c1a9571798UL;
   tf->codes[3485] = 0x0000d1c1e3e61d5dUL;
   tf->codes[3486] = 0x0000d1c4a29a6299UL;
   tf->codes[3487] = 0x0000d1c4dd29685eUL;
   tf->codes[3488] = 0x0000d1c5c7657f72UL;
   tf->codes[3489] = 0x0000d1c601f48537UL;
   tf->codes[3490] = 0x0000d1c6ec309c4bUL;
   tf->codes[3491] = 0x0000d1c7614ea7d5UL;
   tf->codes[3492] = 0x0000d1c97055dbc2UL;
   tf->codes[3493] = 0x0000d1ca2002ed11UL;
   tf->codes[3494] = 0x0000d1ca5a91f2d6UL;
   tf->codes[3495] = 0x0000d1cb0a3f0425UL;
   tf->codes[3496] = 0x0000d1cbf47b1b39UL;
   tf->codes[3497] = 0x0000d1cdc8f34961UL;
   tf->codes[3498] = 0x0000d1ce3e1154ebUL;
   tf->codes[3499] = 0x0000d1cf284d6bffUL;
   tf->codes[3500] = 0x0000d1cf62dc71c4UL;
   tf->codes[3501] = 0x0000d1d0c2369462UL;
   tf->codes[3502] = 0x0000d1d137549fecUL;
   tf->codes[3503] = 0x0000d1d171e3a5b1UL;
   tf->codes[3504] = 0x0000d1d1ac72ab76UL;
   tf->codes[3505] = 0x0000d1d380ead99eUL;
   tf->codes[3506] = 0x0000d1d3bb79df63UL;
   tf->codes[3507] = 0x0000d1d3f608e528UL;
   tf->codes[3508] = 0x0000d1d51ad40201UL;
   tf->codes[3509] = 0x0000d1d6b4bd2a64UL;
   tf->codes[3510] = 0x0000d1d729db35eeUL;
   tf->codes[3511] = 0x0000d1d79ef94178UL;
   tf->codes[3512] = 0x0000d1d7d988473dUL;
   tf->codes[3513] = 0x0000d1da231e80efUL;
   tf->codes[3514] = 0x0000d1db47e99dc8UL;
   tf->codes[3515] = 0x0000d1dbbd07a952UL;
   tf->codes[3516] = 0x0000d1dce1d2c62bUL;
   tf->codes[3517] = 0x0000d1dd1c61cbf0UL;
   tf->codes[3518] = 0x0000d1df65f805a2UL;
   tf->codes[3519] = 0x0000d1dfdb16112cUL;
   tf->codes[3520] = 0x0000d1e08ac3227bUL;
   tf->codes[3521] = 0x0000d1e0c5522840UL;
   tf->codes[3522] = 0x0000d1e1ea1d4519UL;
   tf->codes[3523] = 0x0000d1e2d4595c2dUL;
   tf->codes[3524] = 0x0000d1e51def95dfUL;
   tf->codes[3525] = 0x0000d1e5930da169UL;
   tf->codes[3526] = 0x0000d1e5cd9ca72eUL;
   tf->codes[3527] = 0x0000d1e6b7d8be42UL;
   tf->codes[3528] = 0x0000d1e72cf6c9ccUL;
   tf->codes[3529] = 0x0000d1e81732e0e0UL;
   tf->codes[3530] = 0x0000d1e9b11c0943UL;
   tf->codes[3531] = 0x0000d1ea9b582057UL;
   tf->codes[3532] = 0x0000d1eb10762be1UL;
   tf->codes[3533] = 0x0000d1eb4b0531a6UL;
   tf->codes[3534] = 0x0000d1ebfab242f5UL;
   tf->codes[3535] = 0x0000d1ec354148baUL;
   tf->codes[3536] = 0x0000d1ed949b6b58UL;
   tf->codes[3537] = 0x0000d1ef69139980UL;
   tf->codes[3538] = 0x0000d1f0c86dbc1eUL;
   tf->codes[3539] = 0x0000d1f1ed38d8f7UL;
   tf->codes[3540] = 0x0000d1f38722015aUL;
   tf->codes[3541] = 0x0000d1f4715e186eUL;
   tf->codes[3542] = 0x0000d1f5210b29bdUL;
   tf->codes[3543] = 0x0000d1f596293547UL;
   tf->codes[3544] = 0x0000d1f5d0b83b0cUL;
   tf->codes[3545] = 0x0000d1f730125daaUL;
   tf->codes[3546] = 0x0000d1f76aa1636fUL;
   tf->codes[3547] = 0x0000d1f7a5306934UL;
   tf->codes[3548] = 0x0000d1f93f199197UL;
   tf->codes[3549] = 0x0000d1f9b4379d21UL;
   tf->codes[3550] = 0x0000d1fa63e4ae70UL;
   tf->codes[3551] = 0x0000d1fe47641085UL;
   tf->codes[3552] = 0x0000d1ffa6be3323UL;
   tf->codes[3553] = 0x0000d1ffe14d38e8UL;
   tf->codes[3554] = 0x0000d2001bdc3eadUL;
   tf->codes[3555] = 0x0000d20090fa4a37UL;
   tf->codes[3556] = 0x0000d20140a75b86UL;
   tf->codes[3557] = 0x0000d203151f89aeUL;
   tf->codes[3558] = 0x0000d2038a3d9538UL;
   tf->codes[3559] = 0x0000d203ff5ba0c2UL;
   tf->codes[3560] = 0x0000d2060e62d4afUL;
   tf->codes[3561] = 0x0000d20648f1da74UL;
   tf->codes[3562] = 0x0000d206be0fe5feUL;
   tf->codes[3563] = 0x0000d206f89eebc3UL;
   tf->codes[3564] = 0x0000d20942352575UL;
   tf->codes[3565] = 0x0000d209b75330ffUL;
   tf->codes[3566] = 0x0000d209f1e236c4UL;
   tf->codes[3567] = 0x0000d20a2c713c89UL;
   tf->codes[3568] = 0x0000d20aa18f4813UL;
   tf->codes[3569] = 0x0000d20adc1e4dd8UL;
   tf->codes[3570] = 0x0000d20b16ad539dUL;
   tf->codes[3571] = 0x0000d20b513c5962UL;
   tf->codes[3572] = 0x0000d20b8bcb5f27UL;
   tf->codes[3573] = 0x0000d20e4a7fa463UL;
   tf->codes[3574] = 0x0000d2101ef7d28bUL;
   tf->codes[3575] = 0x0000d2105986d850UL;
   tf->codes[3576] = 0x0000d2109415de15UL;
   tf->codes[3577] = 0x0000d211f37000b3UL;
   tf->codes[3578] = 0x0000d212a31d1202UL;
   tf->codes[3579] = 0x0000d212ddac17c7UL;
   tf->codes[3580] = 0x0000d2138d592916UL;
   tf->codes[3581] = 0x0000d21527425179UL;
   tf->codes[3582] = 0x0000d215d6ef62c8UL;
   tf->codes[3583] = 0x0000d217ab6790f0UL;
   tf->codes[3584] = 0x0000d2185b14a23fUL;
   tf->codes[3585] = 0x0000d218d032adc9UL;
   tf->codes[3586] = 0x0000d2197fdfbf18UL;
   tf->codes[3587] = 0x0000d219ba6ec4ddUL;
   tf->codes[3588] = 0x0000d21adf39e1b6UL;
   tf->codes[3589] = 0x0000d21bc975f8caUL;
   tf->codes[3590] = 0x0000d21dd87d2cb7UL;
   tf->codes[3591] = 0x0000d21e4d9b3841UL;
   tf->codes[3592] = 0x0000d21e882a3e06UL;
   tf->codes[3593] = 0x0000d22022136669UL;
   tf->codes[3594] = 0x0000d220d1c077b8UL;
   tf->codes[3595] = 0x0000d222311a9a56UL;
   tf->codes[3596] = 0x0000d222a638a5e0UL;
   tf->codes[3597] = 0x0000d2231b56b16aUL;
   tf->codes[3598] = 0x0000d223cb03c2b9UL;
   tf->codes[3599] = 0x0000d225da0af6a6UL;
   tf->codes[3600] = 0x0000d2264f290230UL;
   tf->codes[3601] = 0x0000d22739651944UL;
   tf->codes[3602] = 0x0000d22773f41f09UL;
   tf->codes[3603] = 0x0000d227e9122a93UL;
   tf->codes[3604] = 0x0000d228d34e41a7UL;
   tf->codes[3605] = 0x0000d229bd8a58bbUL;
   tf->codes[3606] = 0x0000d22e50b6cc1fUL;
   tf->codes[3607] = 0x0000d22f3af2e333UL;
   tf->codes[3608] = 0x0000d22f7581e8f8UL;
   tf->codes[3609] = 0x0000d23149fa1720UL;
   tf->codes[3610] = 0x0000d2331e724548UL;
   tf->codes[3611] = 0x0000d23359014b0dUL;
   tf->codes[3612] = 0x0000d233939050d2UL;
   tf->codes[3613] = 0x0000d23568087efaUL;
   tf->codes[3614] = 0x0000d235a29784bfUL;
   tf->codes[3615] = 0x0000d2365244960eUL;
   tf->codes[3616] = 0x0000d2373c80ad22UL;
   tf->codes[3617] = 0x0000d23826bcc436UL;
   tf->codes[3618] = 0x0000d238614bc9fbUL;
   tf->codes[3619] = 0x0000d23ae5710972UL;
   tf->codes[3620] = 0x0000d23b20000f37UL;
   tf->codes[3621] = 0x0000d23b951e1ac1UL;
   tf->codes[3622] = 0x0000d23da4254eaeUL;
   tf->codes[3623] = 0x0000d23e19435a38UL;
   tf->codes[3624] = 0x0000d23f037f714cUL;
   tf->codes[3625] = 0x0000d2411286a539UL;
   tf->codes[3626] = 0x0000d24396abe4b0UL;
   tf->codes[3627] = 0x0000d2456b2412d8UL;
   tf->codes[3628] = 0x0000d245a5b3189dUL;
   tf->codes[3629] = 0x0000d246556029ecUL;
   tf->codes[3630] = 0x0000d2468fef2fb1UL;
   tf->codes[3631] = 0x0000d24864675dd9UL;
   tf->codes[3632] = 0x0000d24c47e6bfeeUL;
   tf->codes[3633] = 0x0000d24cbd04cb78UL;
   tf->codes[3634] = 0x0000d24f412a0aefUL;
   tf->codes[3635] = 0x0000d25150313edcUL;
   tf->codes[3636] = 0x0000d251c54f4a66UL;
   tf->codes[3637] = 0x0000d2523a6d55f0UL;
   tf->codes[3638] = 0x0000d254497489ddUL;
   tf->codes[3639] = 0x0000d256930ac38fUL;
   tf->codes[3640] = 0x0000d257b7d5e068UL;
   tf->codes[3641] = 0x0000d25b9b55427dUL;
   tf->codes[3642] = 0x0000d25daa5c766aUL;
   tf->codes[3643] = 0x0000d2606910bba6UL;
   tf->codes[3644] = 0x0000d261534cd2baUL;
   tf->codes[3645] = 0x0000d263625406a7UL;
   tf->codes[3646] = 0x0000d264c1ae2945UL;
   tf->codes[3647] = 0x0000d265715b3a94UL;
   tf->codes[3648] = 0x0000d265abea4059UL;
   tf->codes[3649] = 0x0000d265e679461eUL;
   tf->codes[3650] = 0x0000d2669626576dUL;
   tf->codes[3651] = 0x0000d26954da9ca9UL;
   tf->codes[3652] = 0x0000d26a0487adf8UL;
   tf->codes[3653] = 0x0000d26aeec3c50cUL;
   tf->codes[3654] = 0x0000d26b63e1d096UL;
   tf->codes[3655] = 0x0000d26e97b4215cUL;
   tf->codes[3656] = 0x0000d26f81f03870UL;
   tf->codes[3657] = 0x0000d26fbc7f3e35UL;
   tf->codes[3658] = 0x0000d270319d49bfUL;
   tf->codes[3659] = 0x0000d2706c2c4f84UL;
   tf->codes[3660] = 0x0000d270a6bb5549UL;
   tf->codes[3661] = 0x0000d273656f9a85UL;
   tf->codes[3662] = 0x0000d274151cabd4UL;
   tf->codes[3663] = 0x0000d2744fabb199UL;
   tf->codes[3664] = 0x0000d2757476ce72UL;
   tf->codes[3665] = 0x0000d2762423dfc1UL;
   tf->codes[3666] = 0x0000d2765eb2e586UL;
   tf->codes[3667] = 0x0000d2770e5ff6d5UL;
   tf->codes[3668] = 0x0000d278a8491f38UL;
   tf->codes[3669] = 0x0000d27ab7505325UL;
   tf->codes[3670] = 0x0000d27d76049861UL;
   tf->codes[3671] = 0x0000d27deb22a3ebUL;
   tf->codes[3672] = 0x0000d27ed55ebaffUL;
   tf->codes[3673] = 0x0000d27fbf9ad213UL;
   tf->codes[3674] = 0x0000d27ffa29d7d8UL;
   tf->codes[3675] = 0x0000d281cea20600UL;
   tf->codes[3676] = 0x0000d28243c0118aUL;
   tf->codes[3677] = 0x0000d283a31a3428UL;
   tf->codes[3678] = 0x0000d283dda939edUL;
   tf->codes[3679] = 0x0000d28418383fb2UL;
   tf->codes[3680] = 0x0000d284c7e55101UL;
   tf->codes[3681] = 0x0000d285b2216815UL;
   tf->codes[3682] = 0x0000d28661ce7964UL;
   tf->codes[3683] = 0x0000d287117b8ab3UL;
   tf->codes[3684] = 0x0000d2874c0a9078UL;
   tf->codes[3685] = 0x0000d28aba6be703UL;
   tf->codes[3686] = 0x0000d28b6a18f852UL;
   tf->codes[3687] = 0x0000d28ba4a7fe17UL;
   tf->codes[3688] = 0x0000d28bdf3703dcUL;
   tf->codes[3689] = 0x0000d28dee3e37c9UL;
   tf->codes[3690] = 0x0000d28e28cd3d8eUL;
   tf->codes[3691] = 0x0000d28e635c4353UL;
   tf->codes[3692] = 0x0000d28f130954a2UL;
   tf->codes[3693] = 0x0000d29072637740UL;
   tf->codes[3694] = 0x0000d290e78182caUL;
   tf->codes[3695] = 0x0000d291d1bd99deUL;
   tf->codes[3696] = 0x0000d2933117bc7cUL;
   tf->codes[3697] = 0x0000d294cb00e4dfUL;
   tf->codes[3698] = 0x0000d295058feaa4UL;
   tf->codes[3699] = 0x0000d2962a5b077dUL;
   tf->codes[3700] = 0x0000d2969f791307UL;
   tf->codes[3701] = 0x0000d296da0818ccUL;
   tf->codes[3702] = 0x0000d2974f262456UL;
   tf->codes[3703] = 0x0000d29789b52a1bUL;
   tf->codes[3704] = 0x0000d29839623b6aUL;
   tf->codes[3705] = 0x0000d299239e527eUL;
   tf->codes[3706] = 0x0000d2995e2d5843UL;
   tf->codes[3707] = 0x0000d29998bc5e08UL;
   tf->codes[3708] = 0x0000d29a48696f57UL;
   tf->codes[3709] = 0x0000d29abd877ae1UL;
   tf->codes[3710] = 0x0000d29af81680a6UL;
   tf->codes[3711] = 0x0000d29d41acba58UL;
   tf->codes[3712] = 0x0000d29e6677d731UL;
   tf->codes[3713] = 0x0000d29f50b3ee45UL;
   tf->codes[3714] = 0x0000d29f8b42f40aUL;
   tf->codes[3715] = 0x0000d2a0b00e10e3UL;
   tf->codes[3716] = 0x0000d2a284863f0bUL;
   tf->codes[3717] = 0x0000d2a33433505aUL;
   tf->codes[3718] = 0x0000d2a5433a8447UL;
   tf->codes[3719] = 0x0000d2a62d769b5bUL;
   tf->codes[3720] = 0x0000d2ab35c11a49UL;
   tf->codes[3721] = 0x0000d2ab7050200eUL;
   tf->codes[3722] = 0x0000d2abe56e2b98UL;
   tf->codes[3723] = 0x0000d2b0037c9372UL;
   tf->codes[3724] = 0x0000d2b19d65bbd5UL;
   tf->codes[3725] = 0x0000d2b2c230d8aeUL;
   tf->codes[3726] = 0x0000d2b2fcbfde73UL;
   tf->codes[3727] = 0x0000d2b45c1a0111UL;
   tf->codes[3728] = 0x0000d2b496a906d6UL;
   tf->codes[3729] = 0x0000d2b5bb7423afUL;
   tf->codes[3730] = 0x0000d2b6a5b03ac3UL;
   tf->codes[3731] = 0x0000d2b6e03f4088UL;
   tf->codes[3732] = 0x0000d2bac3bea29dUL;
   tf->codes[3733] = 0x0000d2bb38dcae27UL;
   tf->codes[3734] = 0x0000d2be321ff928UL;
   tf->codes[3735] = 0x0000d2bee1cd0a77UL;
   tf->codes[3736] = 0x0000d2bfcc09218bUL;
   tf->codes[3737] = 0x0000d2c006982750UL;
   tf->codes[3738] = 0x0000d2c1a0814fb3UL;
   tf->codes[3739] = 0x0000d2c2ffdb7251UL;
   tf->codes[3740] = 0x0000d2c374f97ddbUL;
   tf->codes[3741] = 0x0000d2c3af8883a0UL;
   tf->codes[3742] = 0x0000d2c424a68f2aUL;
   tf->codes[3743] = 0x0000d2c45f3594efUL;
   tf->codes[3744] = 0x0000d2c5f91ebd52UL;
   tf->codes[3745] = 0x0000d2c633adc317UL;
   tf->codes[3746] = 0x0000d2c7cd96eb7aUL;
   tf->codes[3747] = 0x0000d2c842b4f704UL;
   tf->codes[3748] = 0x0000d2c8f2620853UL;
   tf->codes[3749] = 0x0000d2c9dc9e1f67UL;
   tf->codes[3750] = 0x0000d2ca51bc2af1UL;
   tf->codes[3751] = 0x0000d2cb3bf84205UL;
   tf->codes[3752] = 0x0000d2cf1f77a41aUL;
   tf->codes[3753] = 0x0000d2d04442c0f3UL;
   tf->codes[3754] = 0x0000d2d12e7ed807UL;
   tf->codes[3755] = 0x0000d2d218baef1bUL;
   tf->codes[3756] = 0x0000d2d28dd8faa5UL;
   tf->codes[3757] = 0x0000d2d3781511b9UL;
   tf->codes[3758] = 0x0000d2d3b2a4177eUL;
   tf->codes[3759] = 0x0000d2d5871c45a6UL;
   tf->codes[3760] = 0x0000d2d6abe7627fUL;
   tf->codes[3761] = 0x0000d2d6e6766844UL;
   tf->codes[3762] = 0x0000d2d9300ca1f6UL;
   tf->codes[3763] = 0x0000d2d96a9ba7bbUL;
   tf->codes[3764] = 0x0000d2db79a2dba8UL;
   tf->codes[3765] = 0x0000d2dbb431e16dUL;
   tf->codes[3766] = 0x0000d2ddc339155aUL;
   tf->codes[3767] = 0x0000d2dee8043233UL;
   tf->codes[3768] = 0x0000d2df5d223dbdUL;
   tf->codes[3769] = 0x0000d2df97b14382UL;
   tf->codes[3770] = 0x0000d2e0475e54d1UL;
   tf->codes[3771] = 0x0000d2e0bc7c605bUL;
   tf->codes[3772] = 0x0000d2e1319a6be5UL;
   tf->codes[3773] = 0x0000d2e1e1477d34UL;
   tf->codes[3774] = 0x0000d2e42addb6e6UL;
   tf->codes[3775] = 0x0000d2e58a37d984UL;
   tf->codes[3776] = 0x0000d2e6af02f65dUL;
   tf->codes[3777] = 0x0000d2e80e5d18fbUL;
   tf->codes[3778] = 0x0000d2ea1d644ce8UL;
   tf->codes[3779] = 0x0000d2ed51369daeUL;
   tf->codes[3780] = 0x0000d2eeb090c04cUL;
   tf->codes[3781] = 0x0000d2eeeb1fc611UL;
   tf->codes[3782] = 0x0000d2f00feae2eaUL;
   tf->codes[3783] = 0x0000d2f0fa26f9feUL;
   tf->codes[3784] = 0x0000d2f21ef216d7UL;
   tf->codes[3785] = 0x0000d2f294102261UL;
   tf->codes[3786] = 0x0000d2f343bd33b0UL;
   tf->codes[3787] = 0x0000d2f37e4c3975UL;
   tf->codes[3788] = 0x0000d2f42df94ac4UL;
   tf->codes[3789] = 0x0000d2f468885089UL;
   tf->codes[3790] = 0x0000d2f6778f8476UL;
   tf->codes[3791] = 0x0000d2f6b21e8a3bUL;
   tf->codes[3792] = 0x0000d2f7273c95c5UL;
   tf->codes[3793] = 0x0000d2f79c5aa14fUL;
   tf->codes[3794] = 0x0000d2f9e5f0db01UL;
   tf->codes[3795] = 0x0000d2fa5b0ee68bUL;
   tf->codes[3796] = 0x0000d2fc2f8714b3UL;
   tf->codes[3797] = 0x0000d2feb3ac542aUL;
   tf->codes[3798] = 0x0000d2ff63596579UL;
   tf->codes[3799] = 0x0000d2ff9de86b3eUL;
   tf->codes[3800] = 0x0000d30088248252UL;
   tf->codes[3801] = 0x0000d30137d193a1UL;
   tf->codes[3802] = 0x0000d302972bb63fUL;
   tf->codes[3803] = 0x0000d3030c49c1c9UL;
   tf->codes[3804] = 0x0000d303bbf6d318UL;
   tf->codes[3805] = 0x0000d3051b50f5b6UL;
   tf->codes[3806] = 0x0000d306401c128fUL;
   tf->codes[3807] = 0x0000d3067aab1854UL;
   tf->codes[3808] = 0x0000d3079f76352dUL;
   tf->codes[3809] = 0x0000d308149440b7UL;
   tf->codes[3810] = 0x0000d30973ee6355UL;
   tf->codes[3811] = 0x0000d30a5e2a7a69UL;
   tf->codes[3812] = 0x0000d30b82f59742UL;
   tf->codes[3813] = 0x0000d30c32a2a891UL;
   tf->codes[3814] = 0x0000d311b00b3309UL;
   tf->codes[3815] = 0x0000d31225293e93UL;
   tf->codes[3816] = 0x0000d313f9a16cbbUL;
   tf->codes[3817] = 0x0000d31558fb8f59UL;
   tf->codes[3818] = 0x0000d315ce199ae3UL;
   tf->codes[3819] = 0x0000d316f2e4b7bcUL;
   tf->codes[3820] = 0x0000d3176802c346UL;
   tf->codes[3821] = 0x0000d31901ebeba9UL;
   tf->codes[3822] = 0x0000d3197709f733UL;
   tf->codes[3823] = 0x0000d319ec2802bdUL;
   tf->codes[3824] = 0x0000d31a61460e47UL;
   tf->codes[3825] = 0x0000d31ad66419d1UL;
   tf->codes[3826] = 0x0000d31b86112b20UL;
   tf->codes[3827] = 0x0000d31bfb2f36aaUL;
   tf->codes[3828] = 0x0000d31d95185f0dUL;
   tf->codes[3829] = 0x0000d31fa41f92faUL;
   tf->codes[3830] = 0x0000d3217897c122UL;
   tf->codes[3831] = 0x0000d32471db0c23UL;
   tf->codes[3832] = 0x0000d32596a628fcUL;
   tf->codes[3833] = 0x0000d32680e24010UL;
   tf->codes[3834] = 0x0000d326f6004b9aUL;
   tf->codes[3835] = 0x0000d3288fe973fdUL;
   tf->codes[3836] = 0x0000d3297a258b11UL;
   tf->codes[3837] = 0x0000d32a29d29c60UL;
   tf->codes[3838] = 0x0000d32a6461a225UL;
   tf->codes[3839] = 0x0000d32b892cbefeUL;
   tf->codes[3840] = 0x0000d32fa73b26d8UL;
   tf->codes[3841] = 0x0000d33091773decUL;
   tf->codes[3842] = 0x0000d330cc0643b1UL;
   tf->codes[3843] = 0x0000d331b6425ac5UL;
   tf->codes[3844] = 0x0000d333ffd89477UL;
   tf->codes[3845] = 0x0000d334af85a5c6UL;
   tf->codes[3846] = 0x0000d334ea14ab8bUL;
   tf->codes[3847] = 0x0000d3355f32b715UL;
   tf->codes[3848] = 0x0000d336496ece29UL;
   tf->codes[3849] = 0x0000d33683fdd3eeUL;
   tf->codes[3850] = 0x0000d336be8cd9b3UL;
   tf->codes[3851] = 0x0000d336f91bdf78UL;
   tf->codes[3852] = 0x0000d3376e39eb02UL;
   tf->codes[3853] = 0x0000d337e357f68cUL;
   tf->codes[3854] = 0x0000d33858760216UL;
   tf->codes[3855] = 0x0000d3397d411eefUL;
   tf->codes[3856] = 0x0000d33adc9b418dUL;
   tf->codes[3857] = 0x0000d33b51b94d17UL;
   tf->codes[3858] = 0x0000d33ceba2757aUL;
   tf->codes[3859] = 0x0000d33e106d9253UL;
   tf->codes[3860] = 0x0000d33ec01aa3a2UL;
   tf->codes[3861] = 0x0000d33faa56bab6UL;
   tf->codes[3862] = 0x0000d3409492d1caUL;
   tf->codes[3863] = 0x0000d340cf21d78fUL;
   tf->codes[3864] = 0x0000d341b95deea3UL;
   tf->codes[3865] = 0x0000d342de290b7cUL;
   tf->codes[3866] = 0x0000d34402f42855UL;
   tf->codes[3867] = 0x0000d3464c8a6207UL;
   tf->codes[3868] = 0x0000d346fc377356UL;
   tf->codes[3869] = 0x0000d348d0afa17eUL;
   tf->codes[3870] = 0x0000d3490b3ea743UL;
   tf->codes[3871] = 0x0000d34a3009c41cUL;
   tf->codes[3872] = 0x0000d34ec3363780UL;
   tf->codes[3873] = 0x0000d34efdc53d45UL;
   tf->codes[3874] = 0x0000d34f72e348cfUL;
   tf->codes[3875] = 0x0000d34fad724e94UL;
   tf->codes[3876] = 0x0000d34fe8015459UL;
   tf->codes[3877] = 0x0000d3510ccc7132UL;
   tf->codes[3878] = 0x0000d354409ec1f8UL;
   tf->codes[3879] = 0x0000d3547b2dc7bdUL;
   tf->codes[3880] = 0x0000d355da87ea5bUL;
   tf->codes[3881] = 0x0000d3561516f020UL;
   tf->codes[3882] = 0x0000d3564fa5f5e5UL;
   tf->codes[3883] = 0x0000d356ff530734UL;
   tf->codes[3884] = 0x0000d357e98f1e48UL;
   tf->codes[3885] = 0x0000d3585ead29d2UL;
   tf->codes[3886] = 0x0000d35948e940e6UL;
   tf->codes[3887] = 0x0000d359837846abUL;
   tf->codes[3888] = 0x0000d35b57f074d3UL;
   tf->codes[3889] = 0x0000d35ddc15b44aUL;
   tf->codes[3890] = 0x0000d35e16a4ba0fUL;
   tf->codes[3891] = 0x0000d35feb1ce837UL;
   tf->codes[3892] = 0x0000d360603af3c1UL;
   tf->codes[3893] = 0x0000d360d558ff4bUL;
   tf->codes[3894] = 0x0000d3626f4227aeUL;
   tf->codes[3895] = 0x0000d362a9d12d73UL;
   tf->codes[3896] = 0x0000d36443ba55d6UL;
   tf->codes[3897] = 0x0000d365dda37e39UL;
   tf->codes[3898] = 0x0000d366183283feUL;
   tf->codes[3899] = 0x0000d3673cfda0d7UL;
   tf->codes[3900] = 0x0000d36861c8bdb0UL;
   tf->codes[3901] = 0x0000d3689c57c375UL;
   tf->codes[3902] = 0x0000d3691175ceffUL;
   tf->codes[3903] = 0x0000d3694c04d4c4UL;
   tf->codes[3904] = 0x0000d3698693da89UL;
   tf->codes[3905] = 0x0000d369c122e04eUL;
   tf->codes[3906] = 0x0000d36b207d02ecUL;
   tf->codes[3907] = 0x0000d36cba662b4fUL;
   tf->codes[3908] = 0x0000d370d8749329UL;
   tf->codes[3909] = 0x0000d37446d5e9b4UL;
   tf->codes[3910] = 0x0000d376906c2366UL;
   tf->codes[3911] = 0x0000d376cafb292bUL;
   tf->codes[3912] = 0x0000d377058a2ef0UL;
   tf->codes[3913] = 0x0000d377b537403fUL;
   tf->codes[3914] = 0x0000d3782a554bc9UL;
   tf->codes[3915] = 0x0000d378da025d18UL;
   tf->codes[3916] = 0x0000d3794f2068a2UL;
   tf->codes[3917] = 0x0000d379c43e742cUL;
   tf->codes[3918] = 0x0000d37a395c7fb6UL;
   tf->codes[3919] = 0x0000d37ae9099105UL;
   tf->codes[3920] = 0x0000d37bd345a819UL;
   tf->codes[3921] = 0x0000d37e576ae790UL;
   tf->codes[3922] = 0x0000d38066721b7dUL;
   tf->codes[3923] = 0x0000d38150ae3291UL;
   tf->codes[3924] = 0x0000d38275794f6aUL;
   tf->codes[3925] = 0x0000d382b008552fUL;
   tf->codes[3926] = 0x0000d382ea975af4UL;
   tf->codes[3927] = 0x0000d385342d94a6UL;
   tf->codes[3928] = 0x0000d3877dc3ce58UL;
   tf->codes[3929] = 0x0000d387f2e1d9e2UL;
   tf->codes[3930] = 0x0000d38867ffe56cUL;
   tf->codes[3931] = 0x0000d38a3c781394UL;
   tf->codes[3932] = 0x0000d38b6143306dUL;
   tf->codes[3933] = 0x0000d38b9bd23632UL;
   tf->codes[3934] = 0x0000d38cfb2c58d0UL;
   tf->codes[3935] = 0x0000d395ac67340eUL;
   tf->codes[3936] = 0x0000d3970bc156acUL;
   tf->codes[3937] = 0x0000d397f5fd6dc0UL;
   tf->codes[3938] = 0x0000d3995557905eUL;
   tf->codes[3939] = 0x0000d39d7365f838UL;
   tf->codes[3940] = 0x0000d39dadf4fdfdUL;
   tf->codes[3941] = 0x0000d39e23130987UL;
   tf->codes[3942] = 0x0000d3a0321a3d74UL;
   tf->codes[3943] = 0x0000d3a206926b9cUL;
   tf->codes[3944] = 0x0000d3a3a07b93ffUL;
   tf->codes[3945] = 0x0000d3a6d44de4c5UL;
   tf->codes[3946] = 0x0000d3a70edcea8aUL;
   tf->codes[3947] = 0x0000d3a833a80763UL;
   tf->codes[3948] = 0x0000d3a993022a01UL;
   tf->codes[3949] = 0x0000d3ab677a5829UL;
   tf->codes[3950] = 0x0000d3af4af9ba3eUL;
   tf->codes[3951] = 0x0000d3affaa6cb8dUL;
   tf->codes[3952] = 0x0000d3b11f71e866UL;
   tf->codes[3953] = 0x0000d3b2443d053fUL;
   tf->codes[3954] = 0x0000d3b2b95b10c9UL;
   tf->codes[3955] = 0x0000d3b2f3ea168eUL;
   tf->codes[3956] = 0x0000d3b418b53367UL;
   tf->codes[3957] = 0x0000d3b53d805040UL;
   tf->codes[3958] = 0x0000d3b5b29e5bcaUL;
   tf->codes[3959] = 0x0000d3b627bc6754UL;
   tf->codes[3960] = 0x0000d3b711f87e68UL;
   tf->codes[3961] = 0x0000d3b7c1a58fb7UL;
   tf->codes[3962] = 0x0000d3b920ffb255UL;
   tf->codes[3963] = 0x0000d3b9961dbddfUL;
   tf->codes[3964] = 0x0000d3ba0b3bc969UL;
   tf->codes[3965] = 0x0000d3bd3f0e1a2fUL;
   tf->codes[3966] = 0x0000d3c038516530UL;
   tf->codes[3967] = 0x0000d3c15d1c8209UL;
   tf->codes[3968] = 0x0000d3c281e79ee2UL;
   tf->codes[3969] = 0x0000d3c3e141c180UL;
   tf->codes[3970] = 0x0000d3c4565fcd0aUL;
   tf->codes[3971] = 0x0000d3c490eed2cfUL;
   tf->codes[3972] = 0x0000d3c57b2ae9e3UL;
   tf->codes[3973] = 0x0000d3c715141246UL;
   tf->codes[3974] = 0x0000d3c74fa3180bUL;
   tf->codes[3975] = 0x0000d3c9d3c85782UL;
   tf->codes[3976] = 0x0000d3cb6db17fe5UL;
   tf->codes[3977] = 0x0000d3cedc12d670UL;
   tf->codes[3978] = 0x0000d3cf16a1dc35UL;
   tf->codes[3979] = 0x0000d3cf5130e1faUL;
   tf->codes[3980] = 0x0000d3d1603815e7UL;
   tf->codes[3981] = 0x0000d3d2fa213e4aUL;
   tf->codes[3982] = 0x0000d3d4940a66adUL;
   tf->codes[3983] = 0x0000d3d5f364894bUL;
   tf->codes[3984] = 0x0000d3d6688294d5UL;
   tf->codes[3985] = 0x0000d3d752beabe9UL;
   tf->codes[3986] = 0x0000d3d7c7dcb773UL;
   tf->codes[3987] = 0x0000d3dac1200274UL;
   tf->codes[3988] = 0x0000d3dcd0273661UL;
   tf->codes[3989] = 0x0000d3df544c75d8UL;
   tf->codes[3990] = 0x0000d3dfc96a8162UL;
   tf->codes[3991] = 0x0000d3e128c4a400UL;
   tf->codes[3992] = 0x0000d3e16353a9c5UL;
   tf->codes[3993] = 0x0000d3e19de2af8aUL;
   tf->codes[3994] = 0x0000d3e2881ec69eUL;
   tf->codes[3995] = 0x0000d3e58162119fUL;
   tf->codes[3996] = 0x0000d3e6310f22eeUL;
   tf->codes[3997] = 0x0000d3e6e0bc343dUL;
   tf->codes[3998] = 0x0000d3e71b4b3a02UL;
   tf->codes[3999] = 0x0000d3e755da3fc7UL;
   tf->codes[4000] = 0x0000d3e99f707979UL;
   tf->codes[4001] = 0x0000d3eb3959a1dcUL;
   tf->codes[4002] = 0x0000d3ecd342ca3fUL;
   tf->codes[4003] = 0x0000d3ee6d2bf2a2UL;
   tf->codes[4004] = 0x0000d3ef576809b6UL;
   tf->codes[4005] = 0x0000d3f041a420caUL;
   tf->codes[4006] = 0x0000d3f12be037deUL;
   tf->codes[4007] = 0x0000d3f1666f3da3UL;
   tf->codes[4008] = 0x0000d3f250ab54b7UL;
   tf->codes[4009] = 0x0000d3f375767190UL;
   tf->codes[4010] = 0x0000d3f3b0057755UL;
   tf->codes[4011] = 0x0000d3f49a418e69UL;
   tf->codes[4012] = 0x0000d3f92d6e01cdUL;
   tf->codes[4013] = 0x0000d3f9dd1b131cUL;
   tf->codes[4014] = 0x0000d3fa17aa18e1UL;
   tf->codes[4015] = 0x0000d3fbec224709UL;
   tf->codes[4016] = 0x0000d3fc9bcf5858UL;
   tf->codes[4017] = 0x0000d3fe35b880bbUL;
   tf->codes[4018] = 0x0000d4012efbcbbcUL;
   tf->codes[4019] = 0x0000d401a419d746UL;
   tf->codes[4020] = 0x0000d403b3210b33UL;
   tf->codes[4021] = 0x0000d403edb010f8UL;
   tf->codes[4022] = 0x0000d4054d0a3396UL;
   tf->codes[4023] = 0x0000d405c2283f20UL;
   tf->codes[4024] = 0x0000d4080bbe78d2UL;
   tf->codes[4025] = 0x0000d40880dc845cUL;
   tf->codes[4026] = 0x0000d409e036a6faUL;
   tf->codes[4027] = 0x0000d40a5554b284UL;
   tf->codes[4028] = 0x0000d40a8fe3b849UL;
   tf->codes[4029] = 0x0000d40b7a1fcf5dUL;
   tf->codes[4030] = 0x0000d40bb4aed522UL;
   tf->codes[4031] = 0x0000d40bef3ddae7UL;
   tf->codes[4032] = 0x0000d40d4e97fd85UL;
   tf->codes[4033] = 0x0000d41291718238UL;
   tf->codes[4034] = 0x0000d412cc0087fdUL;
   tf->codes[4035] = 0x0000d413b63c9f11UL;
   tf->codes[4036] = 0x0000d415c543d2feUL;
   tf->codes[4037] = 0x0000d416af7fea12UL;
   tf->codes[4038] = 0x0000d4175f2cfb61UL;
   tf->codes[4039] = 0x0000d41799bc0126UL;
   tf->codes[4040] = 0x0000d41849691275UL;
   tf->codes[4041] = 0x0000d41883f8183aUL;
   tf->codes[4042] = 0x0000d418f91623c4UL;
   tf->codes[4043] = 0x0000d41933a52989UL;
   tf->codes[4044] = 0x0000d4196e342f4eUL;
   tf->codes[4045] = 0x0000d41a58704662UL;
   tf->codes[4046] = 0x0000d41acd8e51ecUL;
   tf->codes[4047] = 0x0000d41b081d57b1UL;
   tf->codes[4048] = 0x0000d41b7d3b633bUL;
   tf->codes[4049] = 0x0000d41ca2068014UL;
   tf->codes[4050] = 0x0000d41d51b39163UL;
   tf->codes[4051] = 0x0000d41e767eae3cUL;
   tf->codes[4052] = 0x0000d41eeb9cb9c6UL;
   tf->codes[4053] = 0x0000d41f262bbf8bUL;
   tf->codes[4054] = 0x0000d41f60bac550UL;
   tf->codes[4055] = 0x0000d4201067d69fUL;
   tf->codes[4056] = 0x0000d4216fc1f93dUL;
   tf->codes[4057] = 0x0000d4221f6f0a8cUL;
   tf->codes[4058] = 0x0000d42259fe1051UL;
   tf->codes[4059] = 0x0000d423443a2765UL;
   tf->codes[4060] = 0x0000d4246905443eUL;
   tf->codes[4061] = 0x0000d424de234fc8UL;
   tf->codes[4062] = 0x0000d4263d7d7266UL;
   tf->codes[4063] = 0x0000d426780c782bUL;
   tf->codes[4064] = 0x0000d42ad0a9e5caUL;
   tf->codes[4065] = 0x0000d42bf57502a3UL;
   tf->codes[4066] = 0x0000d42dc9ed30cbUL;
   tf->codes[4067] = 0x0000d42e3f0b3c55UL;
   tf->codes[4068] = 0x0000d42eeeb84da4UL;
   tf->codes[4069] = 0x0000d431ad6c92e0UL;
   tf->codes[4070] = 0x0000d43297a8a9f4UL;
   tf->codes[4071] = 0x0000d432d237afb9UL;
   tf->codes[4072] = 0x0000d433bc73c6cdUL;
   tf->codes[4073] = 0x0000d4346c20d81cUL;
   tf->codes[4074] = 0x0000d435cb7afabaUL;
   tf->codes[4075] = 0x0000d436b5b711ceUL;
   tf->codes[4076] = 0x0000d4372ad51d58UL;
   tf->codes[4077] = 0x0000d4381511346cUL;
   tf->codes[4078] = 0x0000d438ff4d4b80UL;
   tf->codes[4079] = 0x0000d439e9896294UL;
   tf->codes[4080] = 0x0000d43b83728af7UL;
   tf->codes[4081] = 0x0000d43bbe0190bcUL;
   tf->codes[4082] = 0x0000d43e4226d033UL;
   tf->codes[4083] = 0x0000d43e7cb5d5f8UL;
   tf->codes[4084] = 0x0000d4413b6a1b34UL;
   tf->codes[4085] = 0x0000d4426035380dUL;
   tf->codes[4086] = 0x0000d442d5534397UL;
   tf->codes[4087] = 0x0000d4451ee97d49UL;
   tf->codes[4088] = 0x0000d445940788d3UL;
   tf->codes[4089] = 0x0000d44643b49a22UL;
   tf->codes[4090] = 0x0000d446b8d2a5acUL;
   tf->codes[4091] = 0x0000d447dd9dc285UL;
   tf->codes[4092] = 0x0000d448182cc84aUL;
   tf->codes[4093] = 0x0000d449b215f0adUL;
   tf->codes[4094] = 0x0000d44b1170134bUL;
   tf->codes[4095] = 0x0000d450c967a388UL;
   tf->codes[4096] = 0x0000d4517914b4d7UL;
   tf->codes[4097] = 0x0000d451ee32c061UL;
   tf->codes[4098] = 0x0000d45228c1c626UL;
   tf->codes[4099] = 0x0000d452d86ed775UL;
   tf->codes[4100] = 0x0000d4534d8ce2ffUL;
   tf->codes[4101] = 0x0000d453fd39f44eUL;
   tf->codes[4102] = 0x0000d456815f33c5UL;
   tf->codes[4103] = 0x0000d456bbee398aUL;
   tf->codes[4104] = 0x0000d459b531848bUL;
   tf->codes[4105] = 0x0000d459efc08a50UL;
   tf->codes[4106] = 0x0000d45a9f6d9b9fUL;
   tf->codes[4107] = 0x0000d45b148ba729UL;
   tf->codes[4108] = 0x0000d45bfec7be3dUL;
   tf->codes[4109] = 0x0000d45c3956c402UL;
   tf->codes[4110] = 0x0000d45c73e5c9c7UL;
   tf->codes[4111] = 0x0000d45d2392db16UL;
   tf->codes[4112] = 0x0000d45e82ecfdb4UL;
   tf->codes[4113] = 0x0000d45ef80b093eUL;
   tf->codes[4114] = 0x0000d46091f431a1UL;
   tf->codes[4115] = 0x0000d4622bdd5a04UL;
   tf->codes[4116] = 0x0000d462db8a6b53UL;
   tf->codes[4117] = 0x0000d4638b377ca2UL;
   tf->codes[4118] = 0x0000d4643ae48df1UL;
   tf->codes[4119] = 0x0000d4655fafaacaUL;
   tf->codes[4120] = 0x0000d4659a3eb08fUL;
   tf->codes[4121] = 0x0000d4676eb6deb7UL;
   tf->codes[4122] = 0x0000d467e3d4ea41UL;
   tf->codes[4123] = 0x0000d4689381fb90UL;
   tf->codes[4124] = 0x0000d46908a0071aUL;
   tf->codes[4125] = 0x0000d46a2d6b23f3UL;
   tf->codes[4126] = 0x0000d46d9bcc7a7eUL;
   tf->codes[4127] = 0x0000d46fe562b430UL;
   tf->codes[4128] = 0x0000d4705a80bfbaUL;
   tf->codes[4129] = 0x0000d47144bcd6ceUL;
   tf->codes[4130] = 0x0000d471b9dae258UL;
   tf->codes[4131] = 0x0000d4726987f3a7UL;
   tf->codes[4132] = 0x0000d474edad331eUL;
   tf->codes[4133] = 0x0000d475283c38e3UL;
   tf->codes[4134] = 0x0000d477ac61785aUL;
   tf->codes[4135] = 0x0000d478969d8f6eUL;
   tf->codes[4136] = 0x0000d479464aa0bdUL;
   tf->codes[4137] = 0x0000d47980d9a682UL;
   tf->codes[4138] = 0x0000d479bb68ac47UL;
   tf->codes[4139] = 0x0000d479f5f7b20cUL;
   tf->codes[4140] = 0x0000d47aa5a4c35bUL;
   tf->codes[4141] = 0x0000d47c04fee5f9UL;
   tf->codes[4142] = 0x0000d47dd9771421UL;
   tf->codes[4143] = 0x0000d47ec3b32b35UL;
   tf->codes[4144] = 0x0000d47f73603c84UL;
   tf->codes[4145] = 0x0000d4805d9c5398UL;
   tf->codes[4146] = 0x0000d4826ca38785UL;
   tf->codes[4147] = 0x0000d4831c5098d4UL;
   tf->codes[4148] = 0x0000d484411bb5adUL;
   tf->codes[4149] = 0x0000d4847baabb72UL;
   tf->codes[4150] = 0x0000d48565e6d286UL;
   tf->codes[4151] = 0x0000d4865022e99aUL;
   tf->codes[4152] = 0x0000d487ea0c11fdUL;
   tf->codes[4153] = 0x0000d48899b9234cUL;
   tf->codes[4154] = 0x0000d489be844025UL;
   tf->codes[4155] = 0x0000d48a33a24bafUL;
   tf->codes[4156] = 0x0000d48b1dde62c3UL;
   tf->codes[4157] = 0x0000d48b92fc6e4dUL;
   tf->codes[4158] = 0x0000d48d67749c75UL;
   tf->codes[4159] = 0x0000d48f767bd062UL;
   tf->codes[4160] = 0x0000d4918583044fUL;
   tf->codes[4161] = 0x0000d491c0120a14UL;
   tf->codes[4162] = 0x0000d492aa4e2128UL;
   tf->codes[4163] = 0x0000d494b9555515UL;
   tf->codes[4164] = 0x0000d494f3e45adaUL;
   tf->codes[4165] = 0x0000d4952e73609fUL;
   tf->codes[4166] = 0x0000d495de2071eeUL;
   tf->codes[4167] = 0x0000d49827b6aba0UL;
   tf->codes[4168] = 0x0000d498d763bcefUL;
   tf->codes[4169] = 0x0000d4998710ce3eUL;
   tf->codes[4170] = 0x0000d499c19fd403UL;
   tf->codes[4171] = 0x0000d499fc2ed9c8UL;
   tf->codes[4172] = 0x0000d49ae66af0dcUL;
   tf->codes[4173] = 0x0000d49cbae31f04UL;
   tf->codes[4174] = 0x0000d49f3f085e7bUL;
   tf->codes[4175] = 0x0000d49fb4266a05UL;
   tf->codes[4176] = 0x0000d4a09e628119UL;
   tf->codes[4177] = 0x0000d4a3d234d1dfUL;
   tf->codes[4178] = 0x0000d4a5318ef47dUL;
   tf->codes[4179] = 0x0000d4a5e13c05ccUL;
   tf->codes[4180] = 0x0000d4a7060722a5UL;
   tf->codes[4181] = 0x0000d4a74096286aUL;
   tf->codes[4182] = 0x0000d4ab5ea49044UL;
   tf->codes[4183] = 0x0000d4ab99339609UL;
   tf->codes[4184] = 0x0000d4ada83ac9f6UL;
   tf->codes[4185] = 0x0000d4ae1d58d580UL;
   tf->codes[4186] = 0x0000d4afb741fde3UL;
   tf->codes[4187] = 0x0000d4b02c60096dUL;
   tf->codes[4188] = 0x0000d4b1169c2081UL;
   tf->codes[4189] = 0x0000d4b44a6e7147UL;
   tf->codes[4190] = 0x0000d4b484fd770cUL;
   tf->codes[4191] = 0x0000d4b4fa1b8296UL;
   tf->codes[4192] = 0x0000d4b743b1bc48UL;
   tf->codes[4193] = 0x0000d4b7f35ecd97UL;
   tf->codes[4194] = 0x0000d4b82dedd35cUL;
   tf->codes[4195] = 0x0000d4b8687cd921UL;
   tf->codes[4196] = 0x0000d4ba3cf50749UL;
   tf->codes[4197] = 0x0000d4ba77840d0eUL;
   tf->codes[4198] = 0x0000d4bb27311e5dUL;
   tf->codes[4199] = 0x0000d4bc116d3571UL;
   tf->codes[4200] = 0x0000d4bde5e56399UL;
   tf->codes[4201] = 0x0000d4bed0217aadUL;
   tf->codes[4202] = 0x0000d4bf0ab08072UL;
   tf->codes[4203] = 0x0000d4bfba5d91c1UL;
   tf->codes[4204] = 0x0000d4c203f3cb73UL;
   tf->codes[4205] = 0x0000d4c4fd371674UL;
   tf->codes[4206] = 0x0000d4c537c61c39UL;
   tf->codes[4207] = 0x0000d4c5725521feUL;
   tf->codes[4208] = 0x0000d4c65c913912UL;
   tf->codes[4209] = 0x0000d4c697203ed7UL;
   tf->codes[4210] = 0x0000d4c7815c55ebUL;
   tf->codes[4211] = 0x0000d4c955d48413UL;
   tf->codes[4212] = 0x0000d4ca7a9fa0ecUL;
   tf->codes[4213] = 0x0000d4cb64dbb800UL;
   tf->codes[4214] = 0x0000d4d032973129UL;
   tf->codes[4215] = 0x0000d4d0a7b53cb3UL;
   tf->codes[4216] = 0x0000d4d2070f5f51UL;
   tf->codes[4217] = 0x0000d4d48b349ec8UL;
   tf->codes[4218] = 0x0000d4d6251dc72bUL;
   tf->codes[4219] = 0x0000d4d749e8e404UL;
   tf->codes[4220] = 0x0000d4d78477e9c9UL;
   tf->codes[4221] = 0x0000d4d83424fb18UL;
   tf->codes[4222] = 0x0000d4d91e61122cUL;
   tf->codes[4223] = 0x0000d4d958f017f1UL;
   tf->codes[4224] = 0x0000d4d9937f1db6UL;
   tf->codes[4225] = 0x0000d4da089d2940UL;
   tf->codes[4226] = 0x0000d4dba28651a3UL;
   tf->codes[4227] = 0x0000d4dbdd155768UL;
   tf->codes[4228] = 0x0000d4df8605b3b8UL;
   tf->codes[4229] = 0x0000d4e035b2c507UL;
   tf->codes[4230] = 0x0000d4e20a2af32fUL;
   tf->codes[4231] = 0x0000d4e244b9f8f4UL;
   tf->codes[4232] = 0x0000d4e27f48feb9UL;
   tf->codes[4233] = 0x0000d4e3698515cdUL;
   tf->codes[4234] = 0x0000d4e5b31b4f7fUL;
   tf->codes[4235] = 0x0000d4e71275721dUL;
   tf->codes[4236] = 0x0000d4e7c222836cUL;
   tf->codes[4237] = 0x0000d4eabb65ce6dUL;
   tf->codes[4238] = 0x0000d4eb3083d9f7UL;
   tf->codes[4239] = 0x0000d4ebe030eb46UL;
   tf->codes[4240] = 0x0000d4edb4a9196eUL;
   tf->codes[4241] = 0x0000d4ee9ee53082UL;
   tf->codes[4242] = 0x0000d4f0e87b6a34UL;
   tf->codes[4243] = 0x0000d4f198287b83UL;
   tf->codes[4244] = 0x0000d4f282649297UL;
   tf->codes[4245] = 0x0000d4f57ba7dd98UL;
   tf->codes[4246] = 0x0000d4f7159105fbUL;
   tf->codes[4247] = 0x0000d4f83a5c22d4UL;
   tf->codes[4248] = 0x0000d4f874eb2899UL;
   tf->codes[4249] = 0x0000d4f8ea093423UL;
   tf->codes[4250] = 0x0000d4f999b64572UL;
   tf->codes[4251] = 0x0000d4fa496356c1UL;
   tf->codes[4252] = 0x0000d4fa83f25c86UL;
   tf->codes[4253] = 0x0000d4fabe81624bUL;
   tf->codes[4254] = 0x0000d4fb6e2e739aUL;
   tf->codes[4255] = 0x0000d4fc586a8aaeUL;
   tf->codes[4256] = 0x0000d4fd08179bfdUL;
   tf->codes[4257] = 0x0000d4fdf253b311UL;
   tf->codes[4258] = 0x0000d5007678f288UL;
   tf->codes[4259] = 0x0000d5019b440f61UL;
   tf->codes[4260] = 0x0000d503352d37c4UL;
   tf->codes[4261] = 0x0000d50544346bb1UL;
   tf->codes[4262] = 0x0000d50718ac99d9UL;
   tf->codes[4263] = 0x0000d507533b9f9eUL;
   tf->codes[4264] = 0x0000d5083d77b6b2UL;
   tf->codes[4265] = 0x0000d50927b3cdc6UL;
   tf->codes[4266] = 0x0000d509d760df15UL;
   tf->codes[4267] = 0x0000d50ac19cf629UL;
   tf->codes[4268] = 0x0000d50b36bb01b3UL;
   tf->codes[4269] = 0x0000d50c5b861e8cUL;
   tf->codes[4270] = 0x0000d50c96152451UL;
   tf->codes[4271] = 0x0000d50f8f586f52UL;
   tf->codes[4272] = 0x0000d50fc9e77517UL;
   tf->codes[4273] = 0x0000d512137daec9UL;
   tf->codes[4274] = 0x0000d5124e0cb48eUL;
   tf->codes[4275] = 0x0000d512c32ac018UL;
   tf->codes[4276] = 0x0000d513ad66d72cUL;
   tf->codes[4277] = 0x0000d514d231f405UL;
   tf->codes[4278] = 0x0000d5166c1b1c68UL;
   tf->codes[4279] = 0x0000d516e13927f2UL;
   tf->codes[4280] = 0x0000d519655e6769UL;
   tf->codes[4281] = 0x0000d519da7c72f3UL;
   tf->codes[4282] = 0x0000d51a150b78b8UL;
   tf->codes[4283] = 0x0000d51ac4b88a07UL;
   tf->codes[4284] = 0x0000d51c9930b82fUL;
   tf->codes[4285] = 0x0000d51cd3bfbdf4UL;
   tf->codes[4286] = 0x0000d51dbdfbd508UL;
   tf->codes[4287] = 0x0000d51e6da8e657UL;
   tf->codes[4288] = 0x0000d51fcd0308f5UL;
   tf->codes[4289] = 0x0000d5207cb01a44UL;
   tf->codes[4290] = 0x0000d523eb1170cfUL;
   tf->codes[4291] = 0x0000d5266f36b046UL;
   tf->codes[4292] = 0x0000d526a9c5b60bUL;
   tf->codes[4293] = 0x0000d526e454bbd0UL;
   tf->codes[4294] = 0x0000d5271ee3c195UL;
   tf->codes[4295] = 0x0000d529a309010cUL;
   tf->codes[4296] = 0x0000d529dd9806d1UL;
   tf->codes[4297] = 0x0000d52b026323aaUL;
   tf->codes[4298] = 0x0000d52d86886321UL;
   tf->codes[4299] = 0x0000d5300aada298UL;
   tf->codes[4300] = 0x0000d5312f78bf71UL;
   tf->codes[4301] = 0x0000d532c961e7d4UL;
   tf->codes[4302] = 0x0000d5333e7ff35eUL;
   tf->codes[4303] = 0x0000d535fd34389aUL;
   tf->codes[4304] = 0x0000d53721ff5573UL;
   tf->codes[4305] = 0x0000d53881597811UL;
   tf->codes[4306] = 0x0000d53eae6f13d8UL;
   tf->codes[4307] = 0x0000d53f98ab2aecUL;
   tf->codes[4308] = 0x0000d53fd33a30b1UL;
   tf->codes[4309] = 0x0000d5413294534fUL;
   tf->codes[4310] = 0x0000d541e241649eUL;
   tf->codes[4311] = 0x0000d543f148988bUL;
   tf->codes[4312] = 0x0000d5458b31c0eeUL;
   tf->codes[4313] = 0x0000d545c5c0c6b3UL;
   tf->codes[4314] = 0x0000d5463aded23dUL;
   tf->codes[4315] = 0x0000d546ea8be38cUL;
   tf->codes[4316] = 0x0000d5496eb12303UL;
   tf->codes[4317] = 0x0000d549a94028c8UL;
   tf->codes[4318] = 0x0000d54a58ed3a17UL;
   tf->codes[4319] = 0x0000d54b4329512bUL;
   tf->codes[4320] = 0x0000d55010e4ca54UL;
   tf->codes[4321] = 0x0000d551e55cf87cUL;
   tf->codes[4322] = 0x0000d552cf990f90UL;
   tf->codes[4323] = 0x0000d5530a281555UL;
   tf->codes[4324] = 0x0000d553f4642c69UL;
   tf->codes[4325] = 0x0000d556036b6056UL;
   tf->codes[4326] = 0x0000d556b31871a5UL;
   tf->codes[4327] = 0x0000d5584d019a08UL;
   tf->codes[4328] = 0x0000d559ac5bbca6UL;
   tf->codes[4329] = 0x0000d55b0bb5df44UL;
   tf->codes[4330] = 0x0000d55ca59f07a7UL;
   tf->codes[4331] = 0x0000d55e7a1735cfUL;
   tf->codes[4332] = 0x0000d560fe3c7546UL;
   tf->codes[4333] = 0x0000d564e1bbd75bUL;
   tf->codes[4334] = 0x0000d5664115f9f9UL;
   tf->codes[4335] = 0x0000d568158e2821UL;
   tf->codes[4336] = 0x0000d56974e84abfUL;
   tf->codes[4337] = 0x0000d569af775084UL;
   tf->codes[4338] = 0x0000d56e7d32c9adUL;
   tf->codes[4339] = 0x0000d57260b22bc2UL;
   tf->codes[4340] = 0x0000d5734aee42d6UL;
   tf->codes[4341] = 0x0000d573c00c4e60UL;
   tf->codes[4342] = 0x0000d574aa486574UL;
   tf->codes[4343] = 0x0000d574e4d76b39UL;
   tf->codes[4344] = 0x0000d576b94f9961UL;
   tf->codes[4345] = 0x0000d57768fcaab0UL;
   tf->codes[4346] = 0x0000d57902e5d313UL;
   tf->codes[4347] = 0x0000d57a27b0efecUL;
   tf->codes[4348] = 0x0000d57a623ff5b1UL;
   tf->codes[4349] = 0x0000d57bc19a184fUL;
   tf->codes[4350] = 0x0000d57bfc291e14UL;
   tf->codes[4351] = 0x0000d57d96124677UL;
   tf->codes[4352] = 0x0000d5801a3785eeUL;
   tf->codes[4353] = 0x0000d5808f559178UL;
   tf->codes[4354] = 0x0000d580c9e4973dUL;
   tf->codes[4355] = 0x0000d5813f02a2c7UL;
   tf->codes[4356] = 0x0000d581eeafb416UL;
   tf->codes[4357] = 0x0000d5834e09d6b4UL;
   tf->codes[4358] = 0x0000d5838898dc79UL;
   tf->codes[4359] = 0x0000d583fdb6e803UL;
   tf->codes[4360] = 0x0000d584ad63f952UL;
   tf->codes[4361] = 0x0000d585d22f162bUL;
   tf->codes[4362] = 0x0000d586f6fa3304UL;
   tf->codes[4363] = 0x0000d58a9fea8f54UL;
   tf->codes[4364] = 0x0000d58ada799519UL;
   tf->codes[4365] = 0x0000d58bff44b1f2UL;
   tf->codes[4366] = 0x0000d58caef1c341UL;
   tf->codes[4367] = 0x0000d58d992dda55UL;
   tf->codes[4368] = 0x0000d58dd3bce01aUL;
   tf->codes[4369] = 0x0000d58e0e4be5dfUL;
   tf->codes[4370] = 0x0000d59092712556UL;
   tf->codes[4371] = 0x0000d590cd002b1bUL;
   tf->codes[4372] = 0x0000d591421e36a5UL;
   tf->codes[4373] = 0x0000d591b73c422fUL;
   tf->codes[4374] = 0x0000d591f1cb47f4UL;
   tf->codes[4375] = 0x0000d5922c5a4db9UL;
   tf->codes[4376] = 0x0000d59351256a92UL;
   tf->codes[4377] = 0x0000d5938bb47057UL;
   tf->codes[4378] = 0x0000d595259d98baUL;
   tf->codes[4379] = 0x0000d5976f33d26cUL;
   tf->codes[4380] = 0x0000d5981ee0e3bbUL;
   tf->codes[4381] = 0x0000d59943ac0094UL;
   tf->codes[4382] = 0x0000d5997e3b0659UL;
   tf->codes[4383] = 0x0000d59b8d423a46UL;
   tf->codes[4384] = 0x0000d59c777e515aUL;
   tf->codes[4385] = 0x0000d59f36329696UL;
   tf->codes[4386] = 0x0000d59fab50a220UL;
   tf->codes[4387] = 0x0000d5a10aaac4beUL;
   tf->codes[4388] = 0x0000d5a14539ca83UL;
   tf->codes[4389] = 0x0000d5a22f75e197UL;
   tf->codes[4390] = 0x0000d5a35440fe70UL;
   tf->codes[4391] = 0x0000d5a38ed00435UL;
   tf->codes[4392] = 0x0000d5a403ee0fbfUL;
   tf->codes[4393] = 0x0000d5a5d8663de7UL;
   tf->codes[4394] = 0x0000d5a64d844971UL;
   tf->codes[4395] = 0x0000d5aaa621b710UL;
   tf->codes[4396] = 0x0000d5aae0b0bcd5UL;
   tf->codes[4397] = 0x0000d5ab1b3fc29aUL;
   tf->codes[4398] = 0x0000d5ac057bd9aeUL;
   tf->codes[4399] = 0x0000d5af394e2a74UL;
   tf->codes[4400] = 0x0000d5af73dd3039UL;
   tf->codes[4401] = 0x0000d5afe8fb3bc3UL;
   tf->codes[4402] = 0x0000d5b391eb9813UL;
   tf->codes[4403] = 0x0000d5b4b6b6b4ecUL;
   tf->codes[4404] = 0x0000d5b4f145bab1UL;
   tf->codes[4405] = 0x0000d5baa93d4aeeUL;
   tf->codes[4406] = 0x0000d5be179ea179UL;
   tf->codes[4407] = 0x0000d5c026a5d566UL;
   tf->codes[4408] = 0x0000d5c14b70f23fUL;
   tf->codes[4409] = 0x0000d5c31fe92067UL;
   tf->codes[4410] = 0x0000d5c40a25377bUL;
   tf->codes[4411] = 0x0000d5c47f434305UL;
   tf->codes[4412] = 0x0000d5c5697f5a19UL;
   tf->codes[4413] = 0x0000d5c6192c6b68UL;
   tf->codes[4414] = 0x0000d5c778868e06UL;
   tf->codes[4415] = 0x0000d5c89d51aadfUL;
   tf->codes[4416] = 0x0000d5c9fcabcd7dUL;
   tf->codes[4417] = 0x0000d5caac58deccUL;
   tf->codes[4418] = 0x0000d5cb5c05f01bUL;
   tf->codes[4419] = 0x0000d5cb9694f5e0UL;
   tf->codes[4420] = 0x0000d5cf3f855230UL;
   tf->codes[4421] = 0x0000d5d1891b8be2UL;
   tf->codes[4422] = 0x0000d5d1c3aa91a7UL;
   tf->codes[4423] = 0x0000d5d5320be832UL;
   tf->codes[4424] = 0x0000d5d61c47ff46UL;
   tf->codes[4425] = 0x0000d5d7b63127a9UL;
   tf->codes[4426] = 0x0000d5d82b4f3333UL;
   tf->codes[4427] = 0x0000d5d8a06d3ebdUL;
   tf->codes[4428] = 0x0000d5daaf7472aaUL;
   tf->codes[4429] = 0x0000d5de92f3d4bfUL;
   tf->codes[4430] = 0x0000d5e0a1fb08acUL;
   tf->codes[4431] = 0x0000d5e151a819fbUL;
   tf->codes[4432] = 0x0000d5e201552b4aUL;
   tf->codes[4433] = 0x0000d5e23be4310fUL;
   tf->codes[4434] = 0x0000d5e694819eaeUL;
   tf->codes[4435] = 0x0000d5e6cf10a473UL;
   tf->codes[4436] = 0x0000d5eb623d17d7UL;
   tf->codes[4437] = 0x0000d5ebd75b2361UL;
   tf->codes[4438] = 0x0000d5f02ff89100UL;
   tf->codes[4439] = 0x0000d5f18f52b39eUL;
   tf->codes[4440] = 0x0000d5f1c9e1b963UL;
   tf->codes[4441] = 0x0000d5f20470bf28UL;
   tf->codes[4442] = 0x0000d5f44e06f8daUL;
   tf->codes[4443] = 0x0000d5f4fdb40a29UL;
   tf->codes[4444] = 0x0000d5f6d22c3851UL;
   tf->codes[4445] = 0x0000d5f7bc684f65UL;
   tf->codes[4446] = 0x0000d5f86c1560b4UL;
   tf->codes[4447] = 0x0000d5fa408d8edcUL;
   tf->codes[4448] = 0x0000d5faf03aa02bUL;
   tf->codes[4449] = 0x0000d5fb6558abb5UL;
   tf->codes[4450] = 0x0000d5fd39d0d9ddUL;
   tf->codes[4451] = 0x0000d5fdaeeee567UL;
   tf->codes[4452] = 0x0000d5fe240cf0f1UL;
   tf->codes[4453] = 0x0000d5fe992afc7bUL;
   tf->codes[4454] = 0x0000d5fed3ba0240UL;
   tf->codes[4455] = 0x0000d6006da32aa3UL;
   tf->codes[4456] = 0x0000d602421b58cbUL;
   tf->codes[4457] = 0x0000d602f1c86a1aUL;
   tf->codes[4458] = 0x0000d604169386f3UL;
   tf->codes[4459] = 0x0000d6053b5ea3ccUL;
   tf->codes[4460] = 0x0000d605b07caf56UL;
   tf->codes[4461] = 0x0000d605eb0bb51bUL;
   tf->codes[4462] = 0x0000d6069ab8c66aUL;
   tf->codes[4463] = 0x0000d6070fd6d1f4UL;
   tf->codes[4464] = 0x0000d609596d0ba6UL;
   tf->codes[4465] = 0x0000d60e272884cfUL;
   tf->codes[4466] = 0x0000d60e61b78a94UL;
   tf->codes[4467] = 0x0000d610362fb8bcUL;
   tf->codes[4468] = 0x0000d6115afad595UL;
   tf->codes[4469] = 0x0000d611d018e11fUL;
   tf->codes[4470] = 0x0000d6127fc5f26eUL;
   tf->codes[4471] = 0x0000d613df20150cUL;
   tf->codes[4472] = 0x0000d614543e2096UL;
   tf->codes[4473] = 0x0000d61503eb31e5UL;
   tf->codes[4474] = 0x0000d6153e7a37aaUL;
   tf->codes[4475] = 0x0000d61663455483UL;
   tf->codes[4476] = 0x0000d616d863600dUL;
   tf->codes[4477] = 0x0000d617fd2e7ce6UL;
   tf->codes[4478] = 0x0000d619d1a6ab0eUL;
   tf->codes[4479] = 0x0000d61abbe2c222UL;
   tf->codes[4480] = 0x0000d61af671c7e7UL;
   tf->codes[4481] = 0x0000d61b6b8fd371UL;
   tf->codes[4482] = 0x0000d61be0addefbUL;
   tf->codes[4483] = 0x0000d61c905af04aUL;
   tf->codes[4484] = 0x0000d61e2a4418adUL;
   tf->codes[4485] = 0x0000d61e9f622437UL;
   tf->codes[4486] = 0x0000d61f14802fc1UL;
   tf->codes[4487] = 0x0000d61fc42d4110UL;
   tf->codes[4488] = 0x0000d620ae695824UL;
   tf->codes[4489] = 0x0000d6215e166973UL;
   tf->codes[4490] = 0x0000d623328e979bUL;
   tf->codes[4491] = 0x0000d62491e8ba39UL;
   tf->codes[4492] = 0x0000d624cc77bffeUL;
   tf->codes[4493] = 0x0000d6250706c5c3UL;
   tf->codes[4494] = 0x0000d6254195cb88UL;
   tf->codes[4495] = 0x0000d6262bd1e29cUL;
   tf->codes[4496] = 0x0000d628aff72213UL;
   tf->codes[4497] = 0x0000d62a0f5144b1UL;
   tf->codes[4498] = 0x0000d62abefe5600UL;
   tf->codes[4499] = 0x0000d62db841a101UL;
   tf->codes[4500] = 0x0000d630ec13f1c7UL;
   tf->codes[4501] = 0x0000d63126a2f78cUL;
   tf->codes[4502] = 0x0000d6316131fd51UL;
   tf->codes[4503] = 0x0000d634cf9353dcUL;
   tf->codes[4504] = 0x0000d6350a2259a1UL;
   tf->codes[4505] = 0x0000d6399d4ecd05UL;
   tf->codes[4506] = 0x0000d639d7ddd2caUL;
   tf->codes[4507] = 0x0000d63bac5600f2UL;
   tf->codes[4508] = 0x0000d63c96921806UL;
   tf->codes[4509] = 0x0000d63d0bb02390UL;
   tf->codes[4510] = 0x0000d63df5ec3aa4UL;
   tf->codes[4511] = 0x0000d63f1ab7577dUL;
   tf->codes[4512] = 0x0000d640ef2f85a5UL;
   tf->codes[4513] = 0x0000d64213faa27eUL;
   tf->codes[4514] = 0x0000d6428918ae08UL;
   tf->codes[4515] = 0x0000d644d2aee7baUL;
   tf->codes[4516] = 0x0000d645bceafeceUL;
   tf->codes[4517] = 0x0000d64632090a58UL;
   tf->codes[4518] = 0x0000d648b62e49cfUL;
   tf->codes[4519] = 0x0000d64a8aa677f7UL;
   tf->codes[4520] = 0x0000d64c248fa05aUL;
   tf->codes[4521] = 0x0000d64d83e9c2f8UL;
   tf->codes[4522] = 0x0000d64f92f0f6e5UL;
   tf->codes[4523] = 0x0000d650080f026fUL;
   tf->codes[4524] = 0x0000d6516769250dUL;
   tf->codes[4525] = 0x0000d651a1f82ad2UL;
   tf->codes[4526] = 0x0000d6521716365cUL;
   tf->codes[4527] = 0x0000d6528c3441e6UL;
   tf->codes[4528] = 0x0000d65635249e36UL;
   tf->codes[4529] = 0x0000d658442bd223UL;
   tf->codes[4530] = 0x0000d6587ebad7e8UL;
   tf->codes[4531] = 0x0000d658f3d8e372UL;
   tf->codes[4532] = 0x0000d65c623a39fdUL;
   tf->codes[4533] = 0x0000d6612ff5b326UL;
   tf->codes[4534] = 0x0000d662c9dedb89UL;
   tf->codes[4535] = 0x0000d663b41af29dUL;
   tf->codes[4536] = 0x0000d666ad5e3d9eUL;
   tf->codes[4537] = 0x0000d66bf037c251UL;
   tf->codes[4538] = 0x0000d66e745d01c8UL;
   tf->codes[4539] = 0x0000d66f5e9918dcUL;
   tf->codes[4540] = 0x0000d671e2be5853UL;
   tf->codes[4541] = 0x0000d6737ca780b6UL;
   tf->codes[4542] = 0x0000d6742c549205UL;
   tf->codes[4543] = 0x0000d67675eacbb7UL;
   tf->codes[4544] = 0x0000d676b079d17cUL;
   tf->codes[4545] = 0x0000d6779ab5e890UL;
   tf->codes[4546] = 0x0000d679e44c2242UL;
   tf->codes[4547] = 0x0000d67b09173f1bUL;
   tf->codes[4548] = 0x0000d67b7e354aa5UL;
   tf->codes[4549] = 0x0000d67f2725a6f5UL;
   tf->codes[4550] = 0x0000d68170bbe0a7UL;
   tf->codes[4551] = 0x0000d6822068f1f6UL;
   tf->codes[4552] = 0x0000d6830aa5090aUL;
   tf->codes[4553] = 0x0000d6837fc31494UL;
   tf->codes[4554] = 0x0000d686ee246b1fUL;
   tf->codes[4555] = 0x0000d68812ef87f8UL;
   tf->codes[4556] = 0x0000d6897249aa96UL;
   tf->codes[4557] = 0x0000d68a5c85c1aaUL;
   tf->codes[4558] = 0x0000d68e400523bfUL;
   tf->codes[4559] = 0x0000d68eefb2350eUL;
   tf->codes[4560] = 0x0000d690feb968fbUL;
   tf->codes[4561] = 0x0000d69298a2915eUL;
   tf->codes[4562] = 0x0000d694e238cb10UL;
   tf->codes[4563] = 0x0000d695cc74e224UL;
   tf->codes[4564] = 0x0000d6960703e7e9UL;
   tf->codes[4565] = 0x0000d697a0ed104cUL;
   tf->codes[4566] = 0x0000d698c5b82d25UL;
   tf->codes[4567] = 0x0000d69a9a305b4dUL;
   tf->codes[4568] = 0x0000d69b846c7261UL;
   tf->codes[4569] = 0x0000d69bbefb7826UL;
   tf->codes[4570] = 0x0000d69dce02ac13UL;
   tf->codes[4571] = 0x0000d6a226a019b2UL;
   tf->codes[4572] = 0x0000d6a3fb1847daUL;
   tf->codes[4573] = 0x0000d6a470365364UL;
   tf->codes[4574] = 0x0000d6a4e5545eeeUL;
   tf->codes[4575] = 0x0000d6a644ae818cUL;
   tf->codes[4576] = 0x0000d6a88e44bb3eUL;
   tf->codes[4577] = 0x0000d6aa282de3a1UL;
   tf->codes[4578] = 0x0000d6add11e3ff1UL;
   tf->codes[4579] = 0x0000d6b0ca618af2UL;
   tf->codes[4580] = 0x0000d6b229bbad90UL;
   tf->codes[4581] = 0x0000d6b2644ab355UL;
   tf->codes[4582] = 0x0000d6b2d968bedfUL;
   tf->codes[4583] = 0x0000d6b5981d041bUL;
   tf->codes[4584] = 0x0000d6b5d2ac09e0UL;
   tf->codes[4585] = 0x0000d6b81c424392UL;
   tf->codes[4586] = 0x0000d6b9410d606bUL;
   tf->codes[4587] = 0x0000d6bb50149458UL;
   tf->codes[4588] = 0x0000d6bc3a50ab6cUL;
   tf->codes[4589] = 0x0000d6bef904f0a8UL;
   tf->codes[4590] = 0x0000d6c1b7b935e4UL;
   tf->codes[4591] = 0x0000d6c2a1f54cf8UL;
   tf->codes[4592] = 0x0000d6c351a25e47UL;
   tf->codes[4593] = 0x0000d6c3c6c069d1UL;
   tf->codes[4594] = 0x0000d6c4014f6f96UL;
   tf->codes[4595] = 0x0000d6c61056a383UL;
   tf->codes[4596] = 0x0000d6c6c003b4d2UL;
   tf->codes[4597] = 0x0000d6ce4c737337UL;
   tf->codes[4598] = 0x0000d6d0d098b2aeUL;
   tf->codes[4599] = 0x0000d6d10b27b873UL;
   tf->codes[4600] = 0x0000d6d18045c3fdUL;
   tf->codes[4601] = 0x0000d6d43efa0939UL;
   tf->codes[4602] = 0x0000d6d4eea71a88UL;
   tf->codes[4603] = 0x0000d6d52936204dUL;
   tf->codes[4604] = 0x0000d6d563c52612UL;
   tf->codes[4605] = 0x0000d6d613723761UL;
   tf->codes[4606] = 0x0000d6d85d087113UL;
   tf->codes[4607] = 0x0000d6daa69eaac5UL;
   tf->codes[4608] = 0x0000d6db1bbcb64fUL;
   tf->codes[4609] = 0x0000d6dd9fe1f5c6UL;
   tf->codes[4610] = 0x0000d6e0992540c7UL;
   tf->codes[4611] = 0x0000d6e0d3b4468cUL;
   tf->codes[4612] = 0x0000d6e442159d17UL;
   tf->codes[4613] = 0x0000d6e47ca4a2dcUL;
   tf->codes[4614] = 0x0000d6e4b733a8a1UL;
   tf->codes[4615] = 0x0000d6e7eb05f967UL;
   tf->codes[4616] = 0x0000d6ea6f2b38deUL;
   tf->codes[4617] = 0x0000d6ebce855b7cUL;
   tf->codes[4618] = 0x0000d6ee181b952eUL;
   tf->codes[4619] = 0x0000d6f1fb9af743UL;
   tf->codes[4620] = 0x0000d6f270b902cdUL;
   tf->codes[4621] = 0x0000d6f2ab480892UL;
   tf->codes[4622] = 0x0000d6f52f6d4809UL;
   tf->codes[4623] = 0x0000d6f94d7bafe3UL;
   tf->codes[4624] = 0x0000d6f9880ab5a8UL;
   tf->codes[4625] = 0x0000d6fe1b37290cUL;
   tf->codes[4626] = 0x0000d6ff05734020UL;
   tf->codes[4627] = 0x0000d6ff400245e5UL;
   tf->codes[4628] = 0x0000d7002a3e5cf9UL;
   tf->codes[4629] = 0x0000d70064cd62beUL;
   tf->codes[4630] = 0x0000d701147a740dUL;
   tf->codes[4631] = 0x0000d7032381a7faUL;
   tf->codes[4632] = 0x0000d70741900fd4UL;
   tf->codes[4633] = 0x0000d707b6ae1b5eUL;
   tf->codes[4634] = 0x0000d7098b264986UL;
   tf->codes[4635] = 0x0000d7118cb41375UL;
   tf->codes[4636] = 0x0000d711c743193aUL;
   tf->codes[4637] = 0x0000d714c086643bUL;
   tf->codes[4638] = 0x0000d714fb156a00UL;
   tf->codes[4639] = 0x0000d715aac27b4fUL;
   tf->codes[4640] = 0x0000d7161fe086d9UL;
   tf->codes[4641] = 0x0000d717f458b501UL;
   tf->codes[4642] = 0x0000d7198e41dd64UL;
   tf->codes[4643] = 0x0000d71b62ba0b8cUL;
   tf->codes[4644] = 0x0000d71dac50453eUL;
   tf->codes[4645] = 0x0000d71e216e50c8UL;
   tf->codes[4646] = 0x0000d7227a0bbe67UL;
   tf->codes[4647] = 0x0000d72329b8cfb6UL;
   tf->codes[4648] = 0x0000d726981a2641UL;
   tf->codes[4649] = 0x0000d727bce5431aUL;
   tf->codes[4650] = 0x0000d72f4955017fUL;
   tf->codes[4651] = 0x0000d72ff90212ceUL;
   tf->codes[4652] = 0x0000d734519f806dUL;
   tf->codes[4653] = 0x0000d738aa3cee0cUL;
   tf->codes[4654] = 0x0000d73994790520UL;
   tf->codes[4655] = 0x0000d73ab94421f9UL;
   tf->codes[4656] = 0x0000d73ffc1da6acUL;
   tf->codes[4657] = 0x0000d743a50e02fcUL;
   tf->codes[4658] = 0x0000d74454bb144bUL;
   tf->codes[4659] = 0x0000d7448f4a1a10UL;
   tf->codes[4660] = 0x0000d7450468259aUL;
   tf->codes[4661] = 0x0000d74663c24838UL;
   tf->codes[4662] = 0x0000d7474dfe5f4cUL;
   tf->codes[4663] = 0x0000d749d2239ec3UL;
   tf->codes[4664] = 0x0000d74abc5fb5d7UL;
   tf->codes[4665] = 0x0000d74b317dc161UL;
   tf->codes[4666] = 0x0000d74c5648de3aUL;
   tf->codes[4667] = 0x0000d74e65501227UL;
   tf->codes[4668] = 0x0000d74fc4aa34c5UL;
   tf->codes[4669] = 0x0000d757c637feb4UL;
   tf->codes[4670] = 0x0000d758b07415c8UL;
   tf->codes[4671] = 0x0000d75abf7b49b5UL;
   tf->codes[4672] = 0x0000d75c59647218UL;
   tf->codes[4673] = 0x0000d75e2ddca040UL;
   tf->codes[4674] = 0x0000d75f52a7bd19UL;
   tf->codes[4675] = 0x0000d7607772d9f2UL;
   tf->codes[4676] = 0x0000d7619c3df6cbUL;
   tf->codes[4677] = 0x0000d762fb981969UL;
   tf->codes[4678] = 0x0000d76420633642UL;
   tf->codes[4679] = 0x0000d764d0104791UL;
   tf->codes[4680] = 0x0000d765452e531bUL;
   tf->codes[4681] = 0x0000d7657fbd58e0UL;
   tf->codes[4682] = 0x0000d76754358708UL;
   tf->codes[4683] = 0x0000d768b38fa9a6UL;
   tf->codes[4684] = 0x0000d76f1b344b32UL;
   tf->codes[4685] = 0x0000d76fcae15c81UL;
   tf->codes[4686] = 0x0000d773e8efc45bUL;
   tf->codes[4687] = 0x0000d774d32bdb6fUL;
   tf->codes[4688] = 0x0000d7750dbae134UL;
   tf->codes[4689] = 0x0000d7766d1503d2UL;
   tf->codes[4690] = 0x0000d77757511ae6UL;
   tf->codes[4691] = 0x0000d77966584ed3UL;
   tf->codes[4692] = 0x0000d77ac5b27171UL;
   tf->codes[4693] = 0x0000d77ee3c0d94bUL;
   tf->codes[4694] = 0x0000d7807daa01aeUL;
   tf->codes[4695] = 0x0000d783b17c5274UL;
   tf->codes[4696] = 0x0000d78635a191ebUL;
   tf->codes[4697] = 0x0000d786e54ea33aUL;
   tf->codes[4698] = 0x0000d789de91ee3bUL;
   tf->codes[4699] = 0x0000d78a53aff9c5UL;
   tf->codes[4700] = 0x0000d78b035d0b14UL;
   tf->codes[4701] = 0x0000d78bed992228UL;
   tf->codes[4702] = 0x0000d78fd118843dUL;
   tf->codes[4703] = 0x0000d79046368fc7UL;
   tf->codes[4704] = 0x0000d792ca5bcf3eUL;
   tf->codes[4705] = 0x0000d79304ead503UL;
   tf->codes[4706] = 0x0000d79513f208f0UL;
   tf->codes[4707] = 0x0000d7975d8842a2UL;
   tf->codes[4708] = 0x0000d79798174867UL;
   tf->codes[4709] = 0x0000d798bce26540UL;
   tf->codes[4710] = 0x0000d799320070caUL;
   tf->codes[4711] = 0x0000d79d500ed8a4UL;
   tf->codes[4712] = 0x0000d79ee9f80107UL;
   tf->codes[4713] = 0x0000d7a342956ea6UL;
   tf->codes[4714] = 0x0000d7a760a3d680UL;
   tf->codes[4715] = 0x0000d7a8856ef359UL;
   tf->codes[4716] = 0x0000d7b6046547c0UL;
   tf->codes[4717] = 0x0000d7b8136c7badUL;
   tf->codes[4718] = 0x0000d7bb81cdd238UL;
   tf->codes[4719] = 0x0000d7c1e97273c4UL;
   tf->codes[4720] = 0x0000d7c2d3ae8ad8UL;
   tf->codes[4721] = 0x0000d7c3835b9c27UL;
   tf->codes[4722] = 0x0000d7c3f879a7b1UL;
   tf->codes[4723] = 0x0000d7c6420fe163UL;
   tf->codes[4724] = 0x0000d7c7dbf909c6UL;
   tf->codes[4725] = 0x0000d7c851171550UL;
   tf->codes[4726] = 0x0000d7c93b532c64UL;
   tf->codes[4727] = 0x0000d7cad53c54c7UL;
   tf->codes[4728] = 0x0000d7cb84e96616UL;
   tf->codes[4729] = 0x0000d7cca9b482efUL;
   tf->codes[4730] = 0x0000d7cf6868c82bUL;
   tf->codes[4731] = 0x0000d7d3fb953b8fUL;
   tf->codes[4732] = 0x0000d7d5957e63f2UL;
   tf->codes[4733] = 0x0000d7d72f678c55UL;
   tf->codes[4734] = 0x0000d7d7a48597dfUL;
   tf->codes[4735] = 0x0000d7d819a3a369UL;
   tf->codes[4736] = 0x0000d7d9b38ccbccUL;
   tf->codes[4737] = 0x0000d7db8804f9f4UL;
   tf->codes[4738] = 0x0000d7e1056d846cUL;
   tf->codes[4739] = 0x0000d7e1b51a95bbUL;
   tf->codes[4740] = 0x0000d7e22a38a145UL;
   tf->codes[4741] = 0x0000d7e2d9e5b294UL;
   tf->codes[4742] = 0x0000d7e5d328fd95UL;
   tf->codes[4743] = 0x0000d7e6bd6514a9UL;
   tf->codes[4744] = 0x0000d7e891dd42d1UL;
   tf->codes[4745] = 0x0000d7e8cc6c4896UL;
   tf->codes[4746] = 0x0000d7e9418a5420UL;
   tf->codes[4747] = 0x0000d7eb16028248UL;
   tf->codes[4748] = 0x0000d7eb5091880dUL;
   tf->codes[4749] = 0x0000d7ebc5af9397UL;
   tf->codes[4750] = 0x0000d7ec003e995cUL;
   tf->codes[4751] = 0x0000d7ed9a27c1bfUL;
   tf->codes[4752] = 0x0000d7ef3410ea22UL;
   tf->codes[4753] = 0x0000d7f01e4d0136UL;
   tf->codes[4754] = 0x0000d7f058dc06fbUL;
   tf->codes[4755] = 0x0000d7f0cdfa1285UL;
   tf->codes[4756] = 0x0000d7f3521f51fcUL;
   tf->codes[4757] = 0x0000d7f476ea6ed5UL;
   tf->codes[4758] = 0x0000d7f7aabcbf9bUL;
   tf->codes[4759] = 0x0000d7f944a5e7feUL;
   tf->codes[4760] = 0x0000d7f9f452f94dUL;
   tf->codes[4761] = 0x0000d7faa4000a9cUL;
   tf->codes[4762] = 0x0000d7fb8e3c21b0UL;
   tf->codes[4763] = 0x0000d7fec20e7276UL;
   tf->codes[4764] = 0x0000d7fefc9d783bUL;
   tf->codes[4765] = 0x0000d7ffac4a898aUL;
   tf->codes[4766] = 0x0000d800d115a663UL;
   tf->codes[4767] = 0x0000d80180c2b7b2UL;
   tf->codes[4768] = 0x0000d8026afecec6UL;
   tf->codes[4769] = 0x0000d802e01cda50UL;
   tf->codes[4770] = 0x0000d805d9602551UL;
   tf->codes[4771] = 0x0000d80773494db4UL;
   tf->codes[4772] = 0x0000d80ae1aaa43fUL;
   tf->codes[4773] = 0x0000d81099a2347cUL;
   tf->codes[4774] = 0x0000d81183de4b90UL;
   tf->codes[4775] = 0x0000d8126e1a62a4UL;
   tf->codes[4776] = 0x0000d814429290ccUL;
   tf->codes[4777] = 0x0000d814b7b09c56UL;
   tf->codes[4778] = 0x0000d816c6b7d043UL;
   tf->codes[4779] = 0x0000d8182611f2e1UL;
   tf->codes[4780] = 0x0000d81c099154f6UL;
   tf->codes[4781] = 0x0000d81c44205abbUL;
   tf->codes[4782] = 0x0000d81e189888e3UL;
   tf->codes[4783] = 0x0000d81fed10b70bUL;
   tf->codes[4784] = 0x0000d820622ec295UL;
   tf->codes[4785] = 0x0000d820d74cce1fUL;
   tf->codes[4786] = 0x0000d8240b1f1ee5UL;
   tf->codes[4787] = 0x0000d825a5084748UL;
   tf->codes[4788] = 0x0000d82bd21de30fUL;
   tf->codes[4789] = 0x0000d830da6861fdUL;
   tf->codes[4790] = 0x0000d8318a15734cUL;
   tf->codes[4791] = 0x0000d83274518a60UL;
   tf->codes[4792] = 0x0000d83323fe9bafUL;
   tf->codes[4793] = 0x0000d8348358be4dUL;
   tf->codes[4794] = 0x0000d8356d94d561UL;
   tf->codes[4795] = 0x0000d835a823db26UL;
   tf->codes[4796] = 0x0000d83951143776UL;
   tf->codes[4797] = 0x0000d83ab06e5a14UL;
   tf->codes[4798] = 0x0000d83c4a578277UL;
   tf->codes[4799] = 0x0000d83cfa0493c6UL;
   tf->codes[4800] = 0x0000d8406865ea51UL;
   tf->codes[4801] = 0x0000d840dd83f5dbUL;
   tf->codes[4802] = 0x0000d8418d31072aUL;
   tf->codes[4803] = 0x0000d842024f12b4UL;
   tf->codes[4804] = 0x0000d842776d1e3eUL;
   tf->codes[4805] = 0x0000d84361a93552UL;
   tf->codes[4806] = 0x0000d8444be54c66UL;
   tf->codes[4807] = 0x0000d8453621637aUL;
   tf->codes[4808] = 0x0000d846205d7a8eUL;
   tf->codes[4809] = 0x0000d84869f3b440UL;
   tf->codes[4810] = 0x0000d84b6336ff41UL;
   tf->codes[4811] = 0x0000d84ed19855ccUL;
   tf->codes[4812] = 0x0000d85030f2786aUL;
   tf->codes[4813] = 0x0000d851904c9b08UL;
   tf->codes[4814] = 0x0000d852056aa692UL;
   tf->codes[4815] = 0x0000d854898fe609UL;
   tf->codes[4816] = 0x0000d854c41eebceUL;
   tf->codes[4817] = 0x0000d854feadf193UL;
   tf->codes[4818] = 0x0000d85a7c167c0bUL;
   tf->codes[4819] = 0x0000d85c508eaa33UL;
   tf->codes[4820] = 0x0000d85e5f95de20UL;
   tf->codes[4821] = 0x0000d85e9a24e3e5UL;
   tf->codes[4822] = 0x0000d863dcfe6898UL;
   tf->codes[4823] = 0x0000d864521c7422UL;
   tf->codes[4824] = 0x0000d864c73a7facUL;
   tf->codes[4825] = 0x0000d869cf84fe9aUL;
   tf->codes[4826] = 0x0000d86a44a30a24UL;
   tf->codes[4827] = 0x0000d86e9d4077c3UL;
   tf->codes[4828] = 0x0000d873306ceb27UL;
   tf->codes[4829] = 0x0000d8736afbf0ecUL;
   tf->codes[4830] = 0x0000d875b4922a9eUL;
   tf->codes[4831] = 0x0000d876d95d4777UL;
   tf->codes[4832] = 0x0000d877c3995e8bUL;
   tf->codes[4833] = 0x0000d878e8647b64UL;
   tf->codes[4834] = 0x0000d886dc78db55UL;
   tf->codes[4835] = 0x0000d88db93b886bUL;
   tf->codes[4836] = 0x0000d88ea3779f7fUL;
   tf->codes[4837] = 0x0000d8a005ed55fbUL;
   tf->codes[4838] = 0x0000d8a45e8ac39aUL;
   tf->codes[4839] = 0x0000d8a4d3a8cf24UL;
   tf->codes[4840] = 0x0000d8a7925d1460UL;
   tf->codes[4841] = 0x0000d8a7ccec1a25UL;
   tf->codes[4842] = 0x0000d8a8420a25afUL;
   tf->codes[4843] = 0x0000d8a8f1b736feUL;
   tf->codes[4844] = 0x0000d8af93eade4fUL;
   tf->codes[4845] = 0x0000d8afce79e414UL;
   tf->codes[4846] = 0x0000d8b1dd811801UL;
   tf->codes[4847] = 0x0000d8b218101dc6UL;
   tf->codes[4848] = 0x0000d8b3b1f94629UL;
   tf->codes[4849] = 0x0000d8b6361e85a0UL;
   tf->codes[4850] = 0x0000d8bac94af904UL;
   tf->codes[4851] = 0x0000d8bbb3871018UL;
   tf->codes[4852] = 0x0000d8bd4d70387bUL;
   tf->codes[4853] = 0x0000d8c1a60da61aUL;
   tf->codes[4854] = 0x0000d8c49f50f11bUL;
   tf->codes[4855] = 0x0000d8c4d9dff6e0UL;
   tf->codes[4856] = 0x0000d8c5feab13b9UL;
   tf->codes[4857] = 0x0000d8cf2503fa81UL;
   tf->codes[4858] = 0x0000d8cf5f930046UL;
   tf->codes[4859] = 0x0000d8cf9a22060bUL;
   tf->codes[4860] = 0x0000d8d2cdf456d1UL;
   tf->codes[4861] = 0x0000d8d34312625bUL;
   tf->codes[4862] = 0x0000d8d5178a9083UL;
   tf->codes[4863] = 0x0000d8d76120ca35UL;
   tf->codes[4864] = 0x0000d8d79bafcffaUL;
   tf->codes[4865] = 0x0000d8d9aab703e7UL;
   tf->codes[4866] = 0x0000d8d9e54609acUL;
   tf->codes[4867] = 0x0000d8dbb9be37d4UL;
   tf->codes[4868] = 0x0000d8e0c208b6c2UL;
   tf->codes[4869] = 0x0000d8e22162d960UL;
   tf->codes[4870] = 0x0000d8ead29db49eUL;
   tf->codes[4871] = 0x0000d8ec31f7d73cUL;
   tf->codes[4872] = 0x0000d8f0c5244aa0UL;
   tf->codes[4873] = 0x0000d8f1e9ef6779UL;
   tf->codes[4874] = 0x0000d8f2247e6d3eUL;
   tf->codes[4875] = 0x0000d8f46e14a6f0UL;
   tf->codes[4876] = 0x0000d8f7a1e6f7b6UL;
   tf->codes[4877] = 0x0000d8f817050340UL;
   tf->codes[4878] = 0x0000d8f88c230ecaUL;
   tf->codes[4879] = 0x0000d8fa260c372dUL;
   tf->codes[4880] = 0x0000d8fb4ad75406UL;
   tf->codes[4881] = 0x0000d8fd59de87f3UL;
   tf->codes[4882] = 0x0000d902279a011cUL;
   tf->codes[4883] = 0x0000d902622906e1UL;
   tf->codes[4884] = 0x0000d90386f423baUL;
   tf->codes[4885] = 0x0000d903c183297fUL;
   tf->codes[4886] = 0x0000d90595fb57a7UL;
   tf->codes[4887] = 0x0000d9076a7385cfUL;
   tf->codes[4888] = 0x0000d907a5028b94UL;
   tf->codes[4889] = 0x0000d9081a20971eUL;
   tf->codes[4890] = 0x0000d90854af9ce3UL;
   tf->codes[4891] = 0x0000d90a2927cb0bUL;
   tf->codes[4892] = 0x0000d90b1363e21fUL;
   tf->codes[4893] = 0x0000d90d97892196UL;
   tf->codes[4894] = 0x0000d90dd218275bUL;
   tf->codes[4895] = 0x0000d90f6c014fbeUL;
   tf->codes[4896] = 0x0000d90fa6905583UL;
   tf->codes[4897] = 0x0000d9101bae610dUL;
   tf->codes[4898] = 0x0000d911f0268f35UL;
   tf->codes[4899] = 0x0000d91265449abfUL;
   tf->codes[4900] = 0x0000d9134f80b1d3UL;
   tf->codes[4901] = 0x0000d913ff2dc322UL;
   tf->codes[4902] = 0x0000d9159916eb85UL;
   tf->codes[4903] = 0x0000d9176d8f19adUL;
   tf->codes[4904] = 0x0000d9181d3c2afcUL;
   tf->codes[4905] = 0x0000d918925a3686UL;
   tf->codes[4906] = 0x0000d919f1b45924UL;
   tf->codes[4907] = 0x0000d91a2c435ee9UL;
   tf->codes[4908] = 0x0000d91aa1616a73UL;
   tf->codes[4909] = 0x0000d91b167f75fdUL;
   tf->codes[4910] = 0x0000d91f348dddd7UL;
   tf->codes[4911] = 0x0000d921439511c4UL;
   tf->codes[4912] = 0x0000d923c7ba513bUL;
   tf->codes[4913] = 0x0000d92561a3799eUL;
   tf->codes[4914] = 0x0000d92611508aedUL;
   tf->codes[4915] = 0x0000d92b8eb91565UL;
   tf->codes[4916] = 0x0000d93146b0a5a2UL;
   tf->codes[4917] = 0x0000d9331b28d3caUL;
   tf->codes[4918] = 0x0000d93355b7d98fUL;
   tf->codes[4919] = 0x0000d9340564eadeUL;
   tf->codes[4920] = 0x0000d9364efb2490UL;
   tf->codes[4921] = 0x0000d93773c64169UL;
   tf->codes[4922] = 0x0000d93982cd7556UL;
   tf->codes[4923] = 0x0000d939bd5c7b1bUL;
   tf->codes[4924] = 0x0000d93c4181ba92UL;
   tf->codes[4925] = 0x0000d93cf12ecbe1UL;
   tf->codes[4926] = 0x0000d93e8b17f444UL;
   tf->codes[4927] = 0x0000d93fea7216e2UL;
   tf->codes[4928] = 0x0000d94149cc3980UL;
   tf->codes[4929] = 0x0000d943cdf178f7UL;
   tf->codes[4930] = 0x0000d946c734c3f8UL;
   tf->codes[4931] = 0x0000d948268ee696UL;
   tf->codes[4932] = 0x0000d9489bacf220UL;
   tf->codes[4933] = 0x0000d94a35961a83UL;
   tf->codes[4934] = 0x0000d94da3f7710eUL;
   tf->codes[4935] = 0x0000d94f786f9f36UL;
   tf->codes[4936] = 0x0000d951c205d8e8UL;
   tf->codes[4937] = 0x0000d9540b9c129aUL;
   tf->codes[4938] = 0x0000d9556af63538UL;
   tf->codes[4939] = 0x0000d9568fc15211UL;
   tf->codes[4940] = 0x0000d95779fd6925UL;
   tf->codes[4941] = 0x0000d95989049d12UL;
   tf->codes[4942] = 0x0000d959c393a2d7UL;
   tf->codes[4943] = 0x0000d95a7340b426UL;
   tf->codes[4944] = 0x0000d95aadcfb9ebUL;
   tf->codes[4945] = 0x0000d95ae85ebfb0UL;
   tf->codes[4946] = 0x0000d95da71304ecUL;
   tf->codes[4947] = 0x0000d95f7b8b3314UL;
   tf->codes[4948] = 0x0000d960dae555b2UL;
   tf->codes[4949] = 0x0000d967f237088dUL;
   tf->codes[4950] = 0x0000d96867551417UL;
   tf->codes[4951] = 0x0000d96daa2e98caUL;
   tf->codes[4952] = 0x0000d97068e2de06UL;
   tf->codes[4953] = 0x0000d97695f879cdUL;
   tf->codes[4954] = 0x0000d976d0877f92UL;
   tf->codes[4955] = 0x0000d979c9caca93UL;
   tf->codes[4956] = 0x0000d97ab406e1a7UL;
   tf->codes[4957] = 0x0000d97ff6e0665aUL;
   tf->codes[4958] = 0x0000d9811bab8333UL;
   tf->codes[4959] = 0x0000d986d3a31370UL;
   tf->codes[4960] = 0x0000d9886d8c3bd3UL;
   tf->codes[4961] = 0x0000d98af1b17b4aUL;
   tf->codes[4962] = 0x0000d9906f1a05c2UL;
   tf->codes[4963] = 0x0000d991ce742860UL;
   tf->codes[4964] = 0x0000d9932dce4afeUL;
   tf->codes[4965] = 0x0000d993685d50c3UL;
   tf->codes[4966] = 0x0000d996271195ffUL;
   tf->codes[4967] = 0x0000d99661a09bc4UL;
   tf->codes[4968] = 0x0000d999d001f24fUL;
   tf->codes[4969] = 0x0000d99a451ffdd9UL;
   tf->codes[4970] = 0x0000d99a7faf039eUL;
   tf->codes[4971] = 0x0000d99aba3e0963UL;
   tf->codes[4972] = 0x0000d99d78f24e9fUL;
   tf->codes[4973] = 0x0000d99e632e65b3UL;
   tf->codes[4974] = 0x0000d9a037a693dbUL;
   tf->codes[4975] = 0x0000d9a0acc49f65UL;
   tf->codes[4976] = 0x0000d9a3a607ea66UL;
   tf->codes[4977] = 0x0000d9a41b25f5f0UL;
   tf->codes[4978] = 0x0000d9a7c4165240UL;
   tf->codes[4979] = 0x0000d9aa483b91b7UL;
   tf->codes[4980] = 0x0000d9abe224ba1aUL;
   tf->codes[4981] = 0x0000d9b19a1c4a57UL;
   tf->codes[4982] = 0x0000d9b2bee76730UL;
   tf->codes[4983] = 0x0000d9b3e3b28409UL;
   tf->codes[4984] = 0x0000d9b6a266c945UL;
   tf->codes[4985] = 0x0000d9bb7022426eUL;
   tf->codes[4986] = 0x0000d9c28773f549UL;
   tf->codes[4987] = 0x0000d9c337210698UL;
   tf->codes[4988] = 0x0000d9ca4e72b973UL;
   tf->codes[4989] = 0x0000d9cac390c4fdUL;
   tf->codes[4990] = 0x0000d9cafe1fcac2UL;
   tf->codes[4991] = 0x0000d9cea7102712UL;
   tf->codes[4992] = 0x0000d9d07b88553aUL;
   tf->codes[4993] = 0x0000d9d0f0a660c4UL;
   tf->codes[4994] = 0x0000d9d165c46c4eUL;
   tf->codes[4995] = 0x0000d9d1dae277d8UL;
   tf->codes[4996] = 0x0000d9d50eb4c89eUL;
   tf->codes[4997] = 0x0000d9d54943ce63UL;
   tf->codes[4998] = 0x0000d9d8f2342ab3UL;
   tf->codes[4999] = 0x0000d9deaa2bbaf0UL;
   tf->codes[5000] = 0x0000d9df9467d204UL;
   tf->codes[5001] = 0x0000d9e3b27639deUL;
   tf->codes[5002] = 0x0000d9e6369b7955UL;
   tf->codes[5003] = 0x0000d9e6abb984dfUL;
   tf->codes[5004] = 0x0000d9e8bac0b8ccUL;
   tf->codes[5005] = 0x0000d9e9a4fccfe0UL;
   tf->codes[5006] = 0x0000d9ea54a9e12fUL;
   tf->codes[5007] = 0x0000d9eac9c7ecb9UL;
   tf->codes[5008] = 0x0000d9eb0456f27eUL;
   tf->codes[5009] = 0x0000d9eb3ee5f843UL;
   tf->codes[5010] = 0x0000d9ee72b84909UL;
   tf->codes[5011] = 0x0000d9f21ba8a559UL;
   tf->codes[5012] = 0x0000d9f34073c232UL;
   tf->codes[5013] = 0x0000d9f37b02c7f7UL;
   tf->codes[5014] = 0x0000d9f7d3a03596UL;
   tf->codes[5015] = 0x0000d9f848be4120UL;
   tf->codes[5016] = 0x0000d9fd1679ba49UL;
   tf->codes[5017] = 0x0000d9fdc626cb98UL;
   tf->codes[5018] = 0x0000d9feeaf1e871UL;
   tf->codes[5019] = 0x0000da030900504bUL;
   tf->codes[5020] = 0x0000da05c7b49587UL;
   tf->codes[5021] = 0x0000da0602439b4cUL;
   tf->codes[5022] = 0x0000da130c1be429UL;
   tf->codes[5023] = 0x0000da1346aae9eeUL;
   tf->codes[5024] = 0x0000da151b231816UL;
   tf->codes[5025] = 0x0000da1764b951c8UL;
   tf->codes[5026] = 0x0000da1939317ff0UL;
   tf->codes[5027] = 0x0000da1b4838b3ddUL;
   tf->codes[5028] = 0x0000da20508332cbUL;
   tf->codes[5029] = 0x0000da25cdebbd43UL;
   tf->codes[5030] = 0x0000da26087ac308UL;
   tf->codes[5031] = 0x0000da2ef444a40bUL;
   tf->codes[5032] = 0x0000da2f2ed3a9d0UL;
   tf->codes[5033] = 0x0000da31034bd7f8UL;
   tf->codes[5034] = 0x0000da32d7c40620UL;
   tf->codes[5035] = 0x0000da36f5d26dfaUL;
   tf->codes[5036] = 0x0000da38ca4a9c22UL;
   tf->codes[5037] = 0x0000da3a29a4bec0UL;
   tf->codes[5038] = 0x0000da3b4e6fdb99UL;
   tf->codes[5039] = 0x0000da3c733af872UL;
   tf->codes[5040] = 0x0000da3dd2951b10UL;
   tf->codes[5041] = 0x0000da3e0d2420d5UL;
   tf->codes[5042] = 0x0000da3f6c7e4373UL;
   tf->codes[5043] = 0x0000da409149604cUL;
   tf->codes[5044] = 0x0000da41b6147d25UL;
   tf->codes[5045] = 0x0000da42dadf99feUL;
   tf->codes[5046] = 0x0000da438a8cab4dUL;
   tf->codes[5047] = 0x0000da46be5efc13UL;
   tf->codes[5048] = 0x0000da47337d079dUL;
   tf->codes[5049] = 0x0000da49b7a24714UL;
   tf->codes[5050] = 0x0000da4f350ad18cUL;
   tf->codes[5051] = 0x0000da5144120579UL;
   tf->codes[5052] = 0x0000da52ddfb2ddcUL;
   tf->codes[5053] = 0x0000da53188a33a1UL;
   tf->codes[5054] = 0x0000da55d73e78ddUL;
   tf->codes[5055] = 0x0000da577127a140UL;
   tf->codes[5056] = 0x0000da58d081c3deUL;
   tf->codes[5057] = 0x0000da59babddaf2UL;
   tf->codes[5058] = 0x0000da5cb40125f3UL;
   tf->codes[5059] = 0x0000da5e8879541bUL;
   tf->codes[5060] = 0x0000da61472d9957UL;
   tf->codes[5061] = 0x0000da6181bc9f1cUL;
   tf->codes[5062] = 0x0000da623169b06bUL;
   tf->codes[5063] = 0x0000da626bf8b630UL;
   tf->codes[5064] = 0x0000da62e116c1baUL;
   tf->codes[5065] = 0x0000da6405e1de93UL;
   tf->codes[5066] = 0x0000da65653c0131UL;
   tf->codes[5067] = 0x0000da668a071e0aUL;
   tf->codes[5068] = 0x0000da67aed23ae3UL;
   tf->codes[5069] = 0x0000da6948bb6346UL;
   tf->codes[5070] = 0x0000da6ddbe7d6aaUL;
   tf->codes[5071] = 0x0000da70600d1621UL;
   tf->codes[5072] = 0x0000da75a2e69ad4UL;
   tf->codes[5073] = 0x0000da75dd75a099UL;
   tf->codes[5074] = 0x0000da768d22b1e8UL;
   tf->codes[5075] = 0x0000da77ec7cd486UL;
   tf->codes[5076] = 0x0000da7b5ade2b11UL;
   tf->codes[5077] = 0x0000da7c451a4225UL;
   tf->codes[5078] = 0x0000da7cba384dafUL;
   tf->codes[5079] = 0x0000da7ddf036a88UL;
   tf->codes[5080] = 0x0000da7ec93f819cUL;
   tf->codes[5081] = 0x0000da7fee0a9e75UL;
   tf->codes[5082] = 0x0000da806328a9ffUL;
   tf->codes[5083] = 0x0000da8237a0d827UL;
   tf->codes[5084] = 0x0000da82722fddecUL;
   tf->codes[5085] = 0x0000da85a6022eb2UL;
   tf->codes[5086] = 0x0000da86903e45c6UL;
   tf->codes[5087] = 0x0000da87b509629fUL;
   tf->codes[5088] = 0x0000da89c410968cUL;
   tf->codes[5089] = 0x0000da89fe9f9c51UL;
   tf->codes[5090] = 0x0000da8ae8dbb365UL;
   tf->codes[5091] = 0x0000da95a91dc290UL;
   tf->codes[5092] = 0x0000da969359d9a4UL;
   tf->codes[5093] = 0x0000da9a01bb302fUL;
   tf->codes[5094] = 0x0000da9aebf74743UL;
   tf->codes[5095] = 0x0000daa0a3eed780UL;
   tf->codes[5096] = 0x0000daa746227ed1UL;
   tf->codes[5097] = 0x0000daaaef12db21UL;
   tf->codes[5098] = 0x0000daab6430e6abUL;
   tf->codes[5099] = 0x0000daac88fc0384UL;
   tf->codes[5100] = 0x0000daae98033771UL;
   tf->codes[5101] = 0x0000dab365beb09aUL;
   tf->codes[5102] = 0x0000dab4156bc1e9UL;
   tf->codes[5103] = 0x0000dab5e9e3f011UL;
   tf->codes[5104] = 0x0000dab7f8eb23feUL;
   tf->codes[5105] = 0x0000daba07f257ebUL;
   tf->codes[5106] = 0x0000dabbdc6a8613UL;
   tf->codes[5107] = 0x0000dabf855ae263UL;
   tf->codes[5108] = 0x0000dac03507f3b2UL;
   tf->codes[5109] = 0x0000dac711caa0c8UL;
   tf->codes[5110] = 0x0000dac74c59a68dUL;
   tf->codes[5111] = 0x0000dac7fc06b7dcUL;
   tf->codes[5112] = 0x0000dac995efe03fUL;
   tf->codes[5113] = 0x0000daca459cf18eUL;
   tf->codes[5114] = 0x0000dacb6a680e67UL;
   tf->codes[5115] = 0x0000dacd3ee03c8fUL;
   tf->codes[5116] = 0x0000dacd796f4254UL;
   tf->codes[5117] = 0x0000dad072b28d55UL;
   tf->codes[5118] = 0x0000dad281b9c142UL;
   tf->codes[5119] = 0x0000dad490c0f52fUL;
   tf->codes[5120] = 0x0000dad62aaa1d92UL;
   tf->codes[5121] = 0x0000dad923ed6893UL;
   tf->codes[5122] = 0x0000dad9d39a79e2UL;
   tf->codes[5123] = 0x0000dadb6d83a245UL;
   tf->codes[5124] = 0x0000dadc924ebf1eUL;
   tf->codes[5125] = 0x0000dae0b05d26f8UL;
   tf->codes[5126] = 0x0000dae20fb74996UL;
   tf->codes[5127] = 0x0000dae75290ce49UL;
   tf->codes[5128] = 0x0000daebe5bd41adUL;
   tf->codes[5129] = 0x0000daec956a52fcUL;
   tf->codes[5130] = 0x0000daefc93ca3c2UL;
   tf->codes[5131] = 0x0000daf19db4d1eaUL;
   tf->codes[5132] = 0x0000daf805597376UL;
   tf->codes[5133] = 0x0000daf92a24904fUL;
   tf->codes[5134] = 0x0000dafac40db8b2UL;
   tf->codes[5135] = 0x0000db033ab98e2bUL;
   tf->codes[5136] = 0x0000db04d4a2b68eUL;
   tf->codes[5137] = 0x0000db0b01b85255UL;
   tf->codes[5138] = 0x0000db0bb16563a4UL;
   tf->codes[5139] = 0x0000db0fcf73cb7eUL;
   tf->codes[5140] = 0x0000db107f20dccdUL;
   tf->codes[5141] = 0x0000db1253990af5UL;
   tf->codes[5142] = 0x0000db128e2810baUL;
   tf->codes[5143] = 0x0000db12c8b7167fUL;
   tf->codes[5144] = 0x0000db13786427ceUL;
   tf->codes[5145] = 0x0000db13b2f32d93UL;
   tf->codes[5146] = 0x0000db142811391dUL;
   tf->codes[5147] = 0x0000db15fc896745UL;
   tf->codes[5148] = 0x0000db172154841eUL;
   tf->codes[5149] = 0x0000db1880aea6bcUL;
   tf->codes[5150] = 0x0000db19a579c395UL;
   tf->codes[5151] = 0x0000db1a8fb5daa9UL;
   tf->codes[5152] = 0x0000db1aca44e06eUL;
   tf->codes[5153] = 0x0000db1b3f62ebf8UL;
   tf->codes[5154] = 0x0000db1c299f030cUL;
   tf->codes[5155] = 0x0000db1ee8534848UL;
   tf->codes[5156] = 0x0000db2047ad6ae6UL;
   tf->codes[5157] = 0x0000db2256b49ed3UL;
   tf->codes[5158] = 0x0000db25c515f55eUL;
   tf->codes[5159] = 0x0000db26e9e11237UL;
   tf->codes[5160] = 0x0000db296e0651aeUL;
   tf->codes[5161] = 0x0000db2bb79c8b60UL;
   tf->codes[5162] = 0x0000db2f25fde1ebUL;
   tf->codes[5163] = 0x0000db30bfe70a4eUL;
   tf->codes[5164] = 0x0000db31350515d8UL;
   tf->codes[5165] = 0x0000db316f941b9dUL;
   tf->codes[5166] = 0x0000db36ecfca615UL;
   tf->codes[5167] = 0x0000db3a5b5dfca0UL;
   tf->codes[5168] = 0x0000db3b80291979UL;
   tf->codes[5169] = 0x0000db3eb3fb6a3fUL;
   tf->codes[5170] = 0x0000db3f9e378153UL;
   tf->codes[5171] = 0x0000db404de492a2UL;
   tf->codes[5172] = 0x0000db434727dda3UL;
   tf->codes[5173] = 0x0000db451ba00bcbUL;
   tf->codes[5174] = 0x0000db46b589342eUL;
   tf->codes[5175] = 0x0000db49e95b84f4UL;
   tf->codes[5176] = 0x0000db4a23ea8ab9UL;
   tf->codes[5177] = 0x0000db4a99089643UL;
   tf->codes[5178] = 0x0000db50167120bbUL;
   tf->codes[5179] = 0x0000db50c61e320aUL;
   tf->codes[5180] = 0x0000db54e42c99e4UL;
   tf->codes[5181] = 0x0000db5593d9ab33UL;
   tf->codes[5182] = 0x0000db567e15c247UL;
   tf->codes[5183] = 0x0000db56b8a4c80cUL;
   tf->codes[5184] = 0x0000db57a2e0df20UL;
   tf->codes[5185] = 0x0000db5b86604135UL;
   tf->codes[5186] = 0x0000db5ce5ba63d3UL;
   tf->codes[5187] = 0x0000db5e45148671UL;
   tf->codes[5188] = 0x0000db5fdefdaed4UL;
   tf->codes[5189] = 0x0000db60c939c5e8UL;
   tf->codes[5190] = 0x0000db69b503a6ebUL;
   tf->codes[5191] = 0x0000db6e0da1148aUL;
   tf->codes[5192] = 0x0000db6fe21942b2UL;
   tf->codes[5193] = 0x0000db701ca84877UL;
   tf->codes[5194] = 0x0000db70cc5559c6UL;
   tf->codes[5195] = 0x0000db73c598a4c7UL;
   tf->codes[5196] = 0x0000db7649bde43eUL;
   tf->codes[5197] = 0x0000db76f96af58dUL;
   tf->codes[5198] = 0x0000db77a91806dcUL;
   tf->codes[5199] = 0x0000db790872297aUL;
   tf->codes[5200] = 0x0000db7a2d3d4653UL;
   tf->codes[5201] = 0x0000db7dd62da2a3UL;
   tf->codes[5202] = 0x0000db81b9ad04b8UL;
   tf->codes[5203] = 0x0000db84786149f4UL;
   tf->codes[5204] = 0x0000db84b2f04fb9UL;
   tf->codes[5205] = 0x0000db8b8fb2fccfUL;
   tf->codes[5206] = 0x0000db8c79ef13e3UL;
   tf->codes[5207] = 0x0000db8f38a3591fUL;
   tf->codes[5208] = 0x0000db931c22bb34UL;
   tf->codes[5209] = 0x0000db9356b1c0f9UL;
   tf->codes[5210] = 0x0000db9615660635UL;
   tf->codes[5211] = 0x0000db96c5131784UL;
   tf->codes[5212] = 0x0000db97af4f2e98UL;
   tf->codes[5213] = 0x0000db97e9de345dUL;
   tf->codes[5214] = 0x0000db9b1db08523UL;
   tf->codes[5215] = 0x0000db9b92ce90adUL;
   tf->codes[5216] = 0x0000db9f012fe738UL;
   tf->codes[5217] = 0x0000dba1855526afUL;
   tf->codes[5218] = 0x0000dba4097a6626UL;
   tf->codes[5219] = 0x0000dba618819a13UL;
   tf->codes[5220] = 0x0000dba73d4cb6ecUL;
   tf->codes[5221] = 0x0000dba7b26ac276UL;
   tf->codes[5222] = 0x0000dba82788ce00UL;
   tf->codes[5223] = 0x0000dbaa711f07b2UL;
   tf->codes[5224] = 0x0000dbaf044b7b16UL;
   tf->codes[5225] = 0x0000dbb0291697efUL;
   tf->codes[5226] = 0x0000dbb14de1b4c8UL;
   tf->codes[5227] = 0x0000dbb18870ba8dUL;
   tf->codes[5228] = 0x0000dbb4f6d21118UL;
   tf->codes[5229] = 0x0000dbb5a67f2267UL;
   tf->codes[5230] = 0x0000dbb6562c33b6UL;
   tf->codes[5231] = 0x0000dbb705d94505UL;
   tf->codes[5232] = 0x0000dbb740684acaUL;
   tf->codes[5233] = 0x0000dbbbd394be2eUL;
   tf->codes[5234] = 0x0000dbbcf85fdb07UL;
   tf->codes[5235] = 0x0000dbbde29bf21bUL;
   tf->codes[5236] = 0x0000dbc1166e42e1UL;
   tf->codes[5237] = 0x0000dbc2b0576b44UL;
   tf->codes[5238] = 0x0000dbc3d522881dUL;
   tf->codes[5239] = 0x0000dbc61eb8c1cfUL;
   tf->codes[5240] = 0x0000dbcab1e53533UL;
   tf->codes[5241] = 0x0000dbcaec743af8UL;
   tf->codes[5242] = 0x0000dbcf0a82a2d2UL;
   tf->codes[5243] = 0x0000dbd11989d6bfUL;
   tf->codes[5244] = 0x0000dbd7bbbd7e10UL;
   tf->codes[5245] = 0x0000dbdb2a1ed49bUL;
   tf->codes[5246] = 0x0000dbdb64adda60UL;
   tf->codes[5247] = 0x0000dbdfbd4b47ffUL;
   tf->codes[5248] = 0x0000dbe6d49cfadaUL;
   tf->codes[5249] = 0x0000dbe7844a0c29UL;
   tf->codes[5250] = 0x0000dbe9cde045dbUL;
   tf->codes[5251] = 0x0000dbf209fd158fUL;
   tf->codes[5252] = 0x0000dbf41904497cUL;
   tf->codes[5253] = 0x0000dbf9214ec86aUL;
   tf->codes[5254] = 0x0000dbfa0b8adf7eUL;
   tf->codes[5255] = 0x0000dbfa80a8eb08UL;
   tf->codes[5256] = 0x0000dbfaf5c6f692UL;
   tf->codes[5257] = 0x0000dbfe9eb752e2UL;
   tf->codes[5258] = 0x0000dbffc3826fbbUL;
   tf->codes[5259] = 0x0000dc03e190d795UL;
   tf->codes[5260] = 0x0000dc04913de8e4UL;
   tf->codes[5261] = 0x0000dc071563285bUL;
   tf->codes[5262] = 0x0000dc0b33719035UL;
   tf->codes[5263] = 0x0000dc0e6743e0fbUL;
   tf->codes[5264] = 0x0000dc0ea1d2e6c0UL;
   tf->codes[5265] = 0x0000dc0fc69e0399UL;
   tf->codes[5266] = 0x0000dc10012d095eUL;
   tf->codes[5267] = 0x0000dc1125f82637UL;
   tf->codes[5268] = 0x0000dc13e4ac6b73UL;
   tf->codes[5269] = 0x0000dc16a360b0afUL;
   tf->codes[5270] = 0x0000dc183d49d912UL;
   tf->codes[5271] = 0x0000dc1877d8ded7UL;
   tf->codes[5272] = 0x0000dc192785f026UL;
   tf->codes[5273] = 0x0000dc1ac16f1889UL;
   tf->codes[5274] = 0x0000dc1babab2f9dUL;
   tf->codes[5275] = 0x0000dc1be63a3562UL;
   tf->codes[5276] = 0x0000dc23ad38f98cUL;
   tf->codes[5277] = 0x0000dc24d2041665UL;
   tf->codes[5278] = 0x0000dc29da4e9553UL;
   tf->codes[5279] = 0x0000dc2b7437bdb6UL;
   tf->codes[5280] = 0x0000dc2c9902da8fUL;
   tf->codes[5281] = 0x0000dc2e32ec02f2UL;
   tf->codes[5282] = 0x0000dc2ea80a0e7cUL;
   tf->codes[5283] = 0x0000dc2ee2991441UL;
   tf->codes[5284] = 0x0000dc312c2f4df3UL;
   tf->codes[5285] = 0x0000dc3250fa6accUL;
   tf->codes[5286] = 0x0000dc32c6187656UL;
   tf->codes[5287] = 0x0000dc3300a77c1bUL;
   tf->codes[5288] = 0x0000dc34257298f4UL;
   tf->codes[5289] = 0x0000dc350faeb008UL;
   tf->codes[5290] = 0x0000dc35bf5bc157UL;
   tf->codes[5291] = 0x0000dc36a997d86bUL;
   tf->codes[5292] = 0x0000dc39dd6a2931UL;
   tf->codes[5293] = 0x0000dc3ee5b4a81fUL;
   tf->codes[5294] = 0x0000dc43edff270dUL;
   tf->codes[5295] = 0x0000dc45fd065afaUL;
   tf->codes[5296] = 0x0000dc4a55a3c899UL;
   tf->codes[5297] = 0x0000dc51326675afUL;
   tf->codes[5298] = 0x0000dc5306dea3d7UL;
   tf->codes[5299] = 0x0000dc542ba9c0b0UL;
   tf->codes[5300] = 0x0000dc5b42fb738bUL;
   tf->codes[5301] = 0x0000dc5cdce49beeUL;
   tf->codes[5302] = 0x0000dc6728089f8fUL;
   tf->codes[5303] = 0x0000dc676297a554UL;
   tf->codes[5304] = 0x0000dc681244b6a3UL;
   tf->codes[5305] = 0x0000dc6a9669f61aUL;
   tf->codes[5306] = 0x0000dc6dca3c46e0UL;
   tf->codes[5307] = 0x0000dc7013d28092UL;
   tf->codes[5308] = 0x0000dc71732ca330UL;
   tf->codes[5309] = 0x0000dc72d286c5ceUL;
   tf->codes[5310] = 0x0000dc738233d71dUL;
   tf->codes[5311] = 0x0000dc7765b33932UL;
   tf->codes[5312] = 0x0000dc7d5839cf34UL;
   tf->codes[5313] = 0x0000dc7e4275e648UL;
   tf->codes[5314] = 0x0000dc7eb793f1d2UL;
   tf->codes[5315] = 0x0000dc7fa1d008e6UL;
   tf->codes[5316] = 0x0000dc7fdc5f0eabUL;
   tf->codes[5317] = 0x0000dc829b1353e7UL;
   tf->codes[5318] = 0x0000dc8977d600fdUL;
   tf->codes[5319] = 0x0000dc8ad730239bUL;
   tf->codes[5320] = 0x0000dc8e0b027461UL;
   tf->codes[5321] = 0x0000dc8e45917a26UL;
   tf->codes[5322] = 0x0000dc93134cf34fUL;
   tf->codes[5323] = 0x0000dc94e7c52177UL;
   tf->codes[5324] = 0x0000dc95977232c6UL;
   tf->codes[5325] = 0x0000dc9890b57dc7UL;
   tf->codes[5326] = 0x0000dca266bb75deUL;
   tf->codes[5327] = 0x0000dca2a14a7ba3UL;
   tf->codes[5328] = 0x0000dca859420be0UL;
   tf->codes[5329] = 0x0000dca8ce60176aUL;
   tf->codes[5330] = 0x0000dca97e0d28b9UL;
   tf->codes[5331] = 0x0000dcaa68493fcdUL;
   tf->codes[5332] = 0x0000dcb02040d00aUL;
   tf->codes[5333] = 0x0000dcb2def51546UL;
   tf->codes[5334] = 0x0000dcb3541320d0UL;
   tf->codes[5335] = 0x0000dcb43e4f37e4UL;
   tf->codes[5336] = 0x0000dcb478de3da9UL;
   tf->codes[5337] = 0x0000dcbcef8a1322UL;
   tf->codes[5338] = 0x0000dcbfae3e585eUL;
   tf->codes[5339] = 0x0000dcc0d3097537UL;
   tf->codes[5340] = 0x0000dcc10d987afcUL;
   tf->codes[5341] = 0x0000dcc1bd458c4bUL;
   tf->codes[5342] = 0x0000dcc2326397d5UL;
   tf->codes[5343] = 0x0000dcc4416acbc2UL;
   tf->codes[5344] = 0x0000dcc90f2644ebUL;
   tf->codes[5345] = 0x0000dccae39e7313UL;
   tf->codes[5346] = 0x0000dccbcdda8a27UL;
   tf->codes[5347] = 0x0000dccda252b84fUL;
   tf->codes[5348] = 0x0000dcce8c8ecf63UL;
   tf->codes[5349] = 0x0000dcd110b40edaUL;
   tf->codes[5350] = 0x0000dcd14b43149fUL;
   tf->codes[5351] = 0x0000dcd394d94e51UL;
   tf->codes[5352] = 0x0000dcd409f759dbUL;
   tf->codes[5353] = 0x0000dcd73dc9aaa1UL;
   tf->codes[5354] = 0x0000dcda370cf5a2UL;
   tf->codes[5355] = 0x0000dcdbd0f61e05UL;
   tf->codes[5356] = 0x0000dcde1a8c57b7UL;
   tf->codes[5357] = 0x0000dcdeca396906UL;
   tf->codes[5358] = 0x0000dcdf3f577490UL;
   tf->codes[5359] = 0x0000dce4f74f04cdUL;
   tf->codes[5360] = 0x0000dcea3a288980UL;
   tf->codes[5361] = 0x0000dcef7d020e33UL;
   tf->codes[5362] = 0x0000dcf325f26a83UL;
   tf->codes[5363] = 0x0000dcf4102e8197UL;
   tf->codes[5364] = 0x0000dcf44abd875cUL;
   tf->codes[5365] = 0x0000dcf8a35af4fbUL;
   tf->codes[5366] = 0x0000dcf8dde9fac0UL;
   tf->codes[5367] = 0x0000dcfe95e18afdUL;
   tf->codes[5368] = 0x0000dd01c9b3dbc3UL;
   tf->codes[5369] = 0x0000dd06976f54ecUL;
   tf->codes[5370] = 0x0000dd06d1fe5ab1UL;
   tf->codes[5371] = 0x0000dd07471c663bUL;
   tf->codes[5372] = 0x0000dd0990b29fedUL;
   tf->codes[5373] = 0x0000dd0a405fb13cUL;
   tf->codes[5374] = 0x0000dd13dbd6a38eUL;
   tf->codes[5375] = 0x0000dd174a37fa19UL;
   tf->codes[5376] = 0x0000dd1ab89950a4UL;
   tf->codes[5377] = 0x0000dd1cc7a08491UL;
   tf->codes[5378] = 0x0000dd1dec6ba16aUL;
   tf->codes[5379] = 0x0000dd21203df230UL;
   tf->codes[5380] = 0x0000dd2419813d31UL;
   tf->codes[5381] = 0x0000dd24541042f6UL;
   tf->codes[5382] = 0x0000dd2abbb4e482UL;
   tf->codes[5383] = 0x0000dd2f4ee157e6UL;
   tf->codes[5384] = 0x0000dd3073ac74bfUL;
   tf->codes[5385] = 0x0000dd36db51164bUL;
   tf->codes[5386] = 0x0000dd3715e01c10UL;
   tf->codes[5387] = 0x0000dd3b6e7d89afUL;
   tf->codes[5388] = 0x0000dd40ebe61427UL;
   tf->codes[5389] = 0x0000dd4494d67077UL;
   tf->codes[5390] = 0x0000dd45f4309315UL;
   tf->codes[5391] = 0x0000dd47538ab5b3UL;
   tf->codes[5392] = 0x0000dd492802e3dbUL;
   tf->codes[5393] = 0x0000dd4a875d0679UL;
   tf->codes[5394] = 0x0000dd50b472a240UL;
   tf->codes[5395] = 0x0000dd51d93dbf19UL;
   tf->codes[5396] = 0x0000dd54d2810a1aUL;
   tf->codes[5397] = 0x0000dd55f74c26f3UL;
   tf->codes[5398] = 0x0000dd566c6a327dUL;
   tf->codes[5399] = 0x0000dd56a6f93842UL;
   tf->codes[5400] = 0x0000dd5791354f56UL;
   tf->codes[5401] = 0x0000dd5b3a25aba6UL;
   tf->codes[5402] = 0x0000dd5baf43b730UL;
   tf->codes[5403] = 0x0000dd5c5ef0c87fUL;
   tf->codes[5404] = 0x0000dd5d83bbe558UL;
   tf->codes[5405] = 0x0000dd6376427b5aUL;
   tf->codes[5406] = 0x0000dd63eb6086e4UL;
   tf->codes[5407] = 0x0000dd658549af47UL;
   tf->codes[5408] = 0x0000dd666f85c65bUL;
   tf->codes[5409] = 0x0000dd69a3581721UL;
   tf->codes[5410] = 0x0000dd6a53052870UL;
   tf->codes[5411] = 0x0000dd700afcb8adUL;
   tf->codes[5412] = 0x0000dd71df74e6d5UL;
   tf->codes[5413] = 0x0000dd74639a264cUL;
   tf->codes[5414] = 0x0000dd75fd834eafUL;
   tf->codes[5415] = 0x0000dd7638125474UL;
   tf->codes[5416] = 0x0000dd7e39a01e63UL;
   tf->codes[5417] = 0x0000dd7e742f2428UL;
   tf->codes[5418] = 0x0000dd7eaebe29edUL;
   tf->codes[5419] = 0x0000dd8048a75250UL;
   tf->codes[5420] = 0x0000dd8550f1d13eUL;
   tf->codes[5421] = 0x0000dd8b08e9617bUL;
   tf->codes[5422] = 0x0000dd92203b1456UL;
   tf->codes[5423] = 0x0000dd96b36787baUL;
   tf->codes[5424] = 0x0000dd97d832a493UL;
   tf->codes[5425] = 0x0000dd9f2a135d33UL;
   tf->codes[5426] = 0x0000dd9f9f3168bdUL;
   tf->codes[5427] = 0x0000dda29874b3beUL;
   tf->codes[5428] = 0x0000dda30d92bf48UL;
   tf->codes[5429] = 0x0000dda34821c50dUL;
   tf->codes[5430] = 0x0000dda382b0cad2UL;
   tf->codes[5431] = 0x0000dda67bf415d3UL;
   tf->codes[5432] = 0x0000ddab0f208937UL;
   tf->codes[5433] = 0x0000ddae0863d438UL;
   tf->codes[5434] = 0x0000ddae7d81dfc2UL;
   tf->codes[5435] = 0x0000ddaef29feb4cUL;
   tf->codes[5436] = 0x0000ddb0c7181974UL;
   tf->codes[5437] = 0x0000ddb7de69cc4fUL;
   tf->codes[5438] = 0x0000ddb818f8d214UL;
   tf->codes[5439] = 0x0000ddb90334e928UL;
   tf->codes[5440] = 0x0000ddba28000601UL;
   tf->codes[5441] = 0x0000ddbfa5689079UL;
   tf->codes[5442] = 0x0000ddc2298dcff0UL;
   tf->codes[5443] = 0x0000ddc522d11af1UL;
   tf->codes[5444] = 0x0000ddcf336618cdUL;
   tf->codes[5445] = 0x0000ddd0583135a6UL;
   tf->codes[5446] = 0x0000ddd1f21a5e09UL;
   tf->codes[5447] = 0x0000ddd38c03866cUL;
   tf->codes[5448] = 0x0000ddd59b0aba59UL;
   tf->codes[5449] = 0x0000ddd68546d16dUL;
   tf->codes[5450] = 0x0000ddd7aa11ee46UL;
   tf->codes[5451] = 0x0000dddaa3553947UL;
   tf->codes[5452] = 0x0000dddc3d3e61aaUL;
   tf->codes[5453] = 0x0000dde0d06ad50eUL;
   tf->codes[5454] = 0x0000dde22fc4f7acUL;
   tf->codes[5455] = 0x0000dde38f1f1a4aUL;
   tf->codes[5456] = 0x0000dde5290842adUL;
   tf->codes[5457] = 0x0000dde981a5b04cUL;
   tf->codes[5458] = 0x0000ddeae0ffd2eaUL;
   tf->codes[5459] = 0x0000ddeec47f34ffUL;
   tf->codes[5460] = 0x0000ddeeff0e3ac4UL;
   tf->codes[5461] = 0x0000ddefe94a51d8UL;
   tf->codes[5462] = 0x0000ddf148a47476UL;
   tf->codes[5463] = 0x0000ddfa346e5579UL;
   tf->codes[5464] = 0x0000ddfddd5eb1c9UL;
   tf->codes[5465] = 0x0000ddfe17edb78eUL;
   tf->codes[5466] = 0x0000ddfe8d0bc318UL;
   tf->codes[5467] = 0x0000ddffec65e5b6UL;
   tf->codes[5468] = 0x0000de0026f4eb7bUL;
   tf->codes[5469] = 0x0000de032038367cUL;
   tf->codes[5470] = 0x0000de04f4b064a4UL;
   tf->codes[5471] = 0x0000de068e998d07UL;
   tf->codes[5472] = 0x0000de07b364a9e0UL;
   tf->codes[5473] = 0x0000de0cbbaf28ceUL;
   tf->codes[5474] = 0x0000de0e55985131UL;
   tf->codes[5475] = 0x0000de0f7a636e0aUL;
   tf->codes[5476] = 0x0000de0fef817994UL;
   tf->codes[5477] = 0x0000de109f2e8ae3UL;
   tf->codes[5478] = 0x0000de13d300dba9UL;
   tf->codes[5479] = 0x0000de1741623234UL;
   tf->codes[5480] = 0x0000de177bf137f9UL;
   tf->codes[5481] = 0x0000de17b6803dbeUL;
   tf->codes[5482] = 0x0000de198af86be6UL;
   tf->codes[5483] = 0x0000de1a753482faUL;
   tf->codes[5484] = 0x0000de1c49acb122UL;
   tf->codes[5485] = 0x0000de1c843bb6e7UL;
   tf->codes[5486] = 0x0000de21c7153b9aUL;
   tf->codes[5487] = 0x0000de223c334724UL;
   tf->codes[5488] = 0x0000de25700597eaUL;
   tf->codes[5489] = 0x0000de265a41aefeUL;
   tf->codes[5490] = 0x0000de277f0ccbd7UL;
   tf->codes[5491] = 0x0000de295384f9ffUL;
   tf->codes[5492] = 0x0000de2b628c2decUL;
   tf->codes[5493] = 0x0000de31ca30cf78UL;
   tf->codes[5494] = 0x0000de32b46ce68cUL;
   tf->codes[5495] = 0x0000de33298af216UL;
   tf->codes[5496] = 0x0000de37f7466b3fUL;
   tf->codes[5497] = 0x0000de39912f93a2UL;
   tf->codes[5498] = 0x0000de3b2b18bc05UL;
   tf->codes[5499] = 0x0000de3b65a7c1caUL;
   tf->codes[5500] = 0x0000de3c1554d319UL;
   tf->codes[5501] = 0x0000de3ed4091855UL;
   tf->codes[5502] = 0x0000de3fbe452f69UL;
   tf->codes[5503] = 0x0000de42f217802fUL;
   tf->codes[5504] = 0x0000de45763cbfa6UL;
   tf->codes[5505] = 0x0000de466078d6baUL;
   tf->codes[5506] = 0x0000de471025e809UL;
   tf->codes[5507] = 0x0000de4ab9164459UL;
   tf->codes[5508] = 0x0000de4dece8951fUL;
   tf->codes[5509] = 0x0000de53a4e0255cUL;
   tf->codes[5510] = 0x0000de55ee765f0eUL;
   tf->codes[5511] = 0x0000de56d8b27622UL;
   tf->codes[5512] = 0x0000de574dd081acUL;
   tf->codes[5513] = 0x0000de58ad2aa44aUL;
   tf->codes[5514] = 0x0000de5abc31d837UL;
   tf->codes[5515] = 0x0000de5c1b8bfad5UL;
   tf->codes[5516] = 0x0000de5db5752338UL;
   tf->codes[5517] = 0x0000de5df00428fdUL;
   tf->codes[5518] = 0x0000de615e657f88UL;
   tf->codes[5519] = 0x0000de662c20f8b1UL;
   tf->codes[5520] = 0x0000de700226f0c8UL;
   tf->codes[5521] = 0x0000de71d69f1ef0UL;
   tf->codes[5522] = 0x0000de7335f9418eUL;
   tf->codes[5523] = 0x0000de74cfe269f1UL;
   tf->codes[5524] = 0x0000de7baca51707UL;
   tf->codes[5525] = 0x0000de7c21c32291UL;
   tf->codes[5526] = 0x0000de7d468e3f6aUL;
   tf->codes[5527] = 0x0000de80ef7e9bbaUL;
   tf->codes[5528] = 0x0000de821449b893UL;
   tf->codes[5529] = 0x0000de83ae32e0f6UL;
   tf->codes[5530] = 0x0000de8b00139996UL;
   tf->codes[5531] = 0x0000de8bafc0aae5UL;
   tf->codes[5532] = 0x0000de8fcdcf12bfUL;
   tf->codes[5533] = 0x0000de907d7c240eUL;
   tf->codes[5534] = 0x0000de90f29a2f98UL;
   tf->codes[5535] = 0x0000de928c8357fbUL;
   tf->codes[5536] = 0x0000de9301a16385UL;
   tf->codes[5537] = 0x0000de95fae4ae86UL;
   tf->codes[5538] = 0x0000de96aa91bfd5UL;
   tf->codes[5539] = 0x0000de98447ae838UL;
   tf->codes[5540] = 0x0000de9a8e1121eaUL;
   tf->codes[5541] = 0x0000de9b784d38feUL;
   tf->codes[5542] = 0x0000de9c27fa4a4dUL;
   tf->codes[5543] = 0x0000dea49ea61fc6UL;
   tf->codes[5544] = 0x0000dea6adad53b3UL;
   tf->codes[5545] = 0x0000dea7d278708cUL;
   tf->codes[5546] = 0x0000deae74ac17ddUL;
   tf->codes[5547] = 0x0000deb083b34bcaUL;
   tf->codes[5548] = 0x0000deb342679106UL;
   tf->codes[5549] = 0x0000deb3f214a255UL;
   tf->codes[5550] = 0x0000deb4a1c1b3a4UL;
   tf->codes[5551] = 0x0000deb810230a2fUL;
   tf->codes[5552] = 0x0000deb8854115b9UL;
   tf->codes[5553] = 0x0000debbb913667fUL;
   tf->codes[5554] = 0x0000debdc81a9a6cUL;
   tf->codes[5555] = 0x0000dec04c3fd9e3UL;
   tf->codes[5556] = 0x0000dec1e6290246UL;
   tf->codes[5557] = 0x0000deca9763dd84UL;
   tf->codes[5558] = 0x0000dece405439d4UL;
   tf->codes[5559] = 0x0000ded3489eb8c2UL;
   tf->codes[5560] = 0x0000dedb4a2c82b1UL;
   tf->codes[5561] = 0x0000dedce415ab14UL;
   tf->codes[5562] = 0x0000dedd1ea4b0d9UL;
   tf->codes[5563] = 0x0000dee08d060764UL;
   tf->codes[5564] = 0x0000dee13cb318b3UL;
   tf->codes[5565] = 0x0000dee3c0d8582aUL;
   tf->codes[5566] = 0x0000dee595508652UL;
   tf->codes[5567] = 0x0000dee644fd97a1UL;
   tf->codes[5568] = 0x0000deeb87d71c54UL;
   tf->codes[5569] = 0x0000def090219b42UL;
   tf->codes[5570] = 0x0000def1b4ecb81bUL;
   tf->codes[5571] = 0x0000def38964e643UL;
   tf->codes[5572] = 0x0000def682a83144UL;
   tf->codes[5573] = 0x0000def857205f6cUL;
   tf->codes[5574] = 0x0000defadb459ee3UL;
   tf->codes[5575] = 0x0000defd5f6ade5aUL;
   tf->codes[5576] = 0x0000df01b8084bf9UL;
   tf->codes[5577] = 0x0000df085a3bf34aUL;
   tf->codes[5578] = 0x0000df08cf59fed4UL;
   tf->codes[5579] = 0x0000df09f4251badUL;
   tf->codes[5580] = 0x0000df0a69432737UL;
   tf->codes[5581] = 0x0000df0ced6866aeUL;
   tf->codes[5582] = 0x0000df131a7e0275UL;
   tf->codes[5583] = 0x0000df1529853662UL;
   tf->codes[5584] = 0x0000df164e50533bUL;
   tf->codes[5585] = 0x0000df17adaa75d9UL;
   tf->codes[5586] = 0x0000df19bcb1a9c6UL;
   tf->codes[5587] = 0x0000df1da0310bdbUL;
   tf->codes[5588] = 0x0000df1e4fde1d2aUL;
   tf->codes[5589] = 0x0000df1ec4fc28b4UL;
   tf->codes[5590] = 0x0000df210e926266UL;
   tf->codes[5591] = 0x0000df21be3f73b5UL;
   tf->codes[5592] = 0x0000df2358289c18UL;
   tf->codes[5593] = 0x0000df273ba7fe2dUL;
   tf->codes[5594] = 0x0000df2825e41541UL;
   tf->codes[5595] = 0x0000df2b1f276042UL;
   tf->codes[5596] = 0x0000df2f3d35c81cUL;
   tf->codes[5597] = 0x0000df32ab971ea7UL;
   tf->codes[5598] = 0x0000df344580470aUL;
   tf->codes[5599] = 0x0000df3619f87532UL;
   tf->codes[5600] = 0x0000df37795297d0UL;
   tf->codes[5601] = 0x0000df39133bc033UL;
   tf->codes[5602] = 0x0000df3c819d16beUL;
   tf->codes[5603] = 0x0000df3da6683397UL;
   tf->codes[5604] = 0x0000df414f588fe7UL;
   tf->codes[5605] = 0x0000df4189e795acUL;
   tf->codes[5606] = 0x0000df44bdb9e672UL;
   tf->codes[5607] = 0x0000df469232149aUL;
   tf->codes[5608] = 0x0000df4e5930d8c4UL;
   tf->codes[5609] = 0x0000df53d699633cUL;
   tf->codes[5610] = 0x0000df5535f385daUL;
   tf->codes[5611] = 0x0000df5570828b9fUL;
   tf->codes[5612] = 0x0000df591972e7efUL;
   tf->codes[5613] = 0x0000df59c91ff93eUL;
   tf->codes[5614] = 0x0000df5a03aeff03UL;
   tf->codes[5615] = 0x0000df5b9d982766UL;
   tf->codes[5616] = 0x0000df5c87d43e7aUL;
   tf->codes[5617] = 0x0000df61901ebd68UL;
   tf->codes[5618] = 0x0000df62053cc8f2UL;
   tf->codes[5619] = 0x0000df636496eb90UL;
   tf->codes[5620] = 0x0000df6698693c56UL;
   tf->codes[5621] = 0x0000df6b6624b57fUL;
   tf->codes[5622] = 0x0000df6bdb42c109UL;
   tf->codes[5623] = 0x0000df6e99f70645UL;
   tf->codes[5624] = 0x0000df71933a5146UL;
   tf->codes[5625] = 0x0000df7576b9b35bUL;
   tf->codes[5626] = 0x0000df7ab993380eUL;
   tf->codes[5627] = 0x0000df7b2eb14398UL;
   tf->codes[5628] = 0x0000df82f5b007c2UL;
   tf->codes[5629] = 0x0000df83dfec1ed6UL;
   tf->codes[5630] = 0x0000df848f993025UL;
   tf->codes[5631] = 0x0000df8504b73bafUL;
   tf->codes[5632] = 0x0000df869ea06412UL;
   tf->codes[5633] = 0x0000df8713be6f9cUL;
   tf->codes[5634] = 0x0000df87c36b80ebUL;
   tf->codes[5635] = 0x0000df8af73dd1b1UL;
   tf->codes[5636] = 0x0000df92be3c95dbUL;
   tf->codes[5637] = 0x0000df945825be3eUL;
   tf->codes[5638] = 0x0000df95b77fe0dcUL;
   tf->codes[5639] = 0x0000df96dc4afdb5UL;
   tf->codes[5640] = 0x0000df975169093fUL;
   tf->codes[5641] = 0x0000df9c1f248268UL;
   tf->codes[5642] = 0x0000df9db90daacbUL;
   tf->codes[5643] = 0x0000df9f8d85d8f3UL;
   tf->codes[5644] = 0x0000dfa211ab186aUL;
   tf->codes[5645] = 0x0000dfb07add83e5UL;
   tf->codes[5646] = 0x0000dfb2ff02c35cUL;
   tf->codes[5647] = 0x0000dfb3aeafd4abUL;
   tf->codes[5648] = 0x0000dfb45e5ce5faUL;
   tf->codes[5649] = 0x0000dfb66d6419e7UL;
   tf->codes[5650] = 0x0000dfb6e2822571UL;
   tf->codes[5651] = 0x0000dfb8f189595eUL;
   tf->codes[5652] = 0x0000dfbc9a79b5aeUL;
   tf->codes[5653] = 0x0000dfbcd508bb73UL;
   tf->codes[5654] = 0x0000dfbdbf44d287UL;
   tf->codes[5655] = 0x0000dfbe3462de11UL;
   tf->codes[5656] = 0x0000dfc8ba15e777UL;
   tf->codes[5657] = 0x0000dfc9dee10450UL;
   tf->codes[5658] = 0x0000dfcac91d1b64UL;
   tf->codes[5659] = 0x0000dfcb3e3b26eeUL;
   tf->codes[5660] = 0x0000dfcf21ba8903UL;
   tf->codes[5661] = 0x0000dfd2558cd9c9UL;
   tf->codes[5662] = 0x0000dfd4d9b21940UL;
   tf->codes[5663] = 0x0000dfd514411f05UL;
   tf->codes[5664] = 0x0000dfd6ae2a4768UL;
   tf->codes[5665] = 0x0000dfd798665e7cUL;
   tf->codes[5666] = 0x0000dfd848136fcbUL;
   tf->codes[5667] = 0x0000dfd9324f86dfUL;
   tf->codes[5668] = 0x0000dfd9e1fc982eUL;
   tf->codes[5669] = 0x0000dfda571aa3b8UL;
   tf->codes[5670] = 0x0000dfdf99f4286bUL;
   tf->codes[5671] = 0x0000dfe342e484bbUL;
   tf->codes[5672] = 0x0000dfe37d738a80UL;
   tf->codes[5673] = 0x0000dfe79b81f25aUL;
   tf->codes[5674] = 0x0000dfe96ffa2082UL;
   tf->codes[5675] = 0x0000dfea5a363796UL;
   tf->codes[5676] = 0x0000dff0fc69dee7UL;
   tf->codes[5677] = 0x0000dff17187ea71UL;
   tf->codes[5678] = 0x0000dff30b7112d4UL;
   tf->codes[5679] = 0x0000dff3bb1e2423UL;
   tf->codes[5680] = 0x0000dff4dfe940fcUL;
   tf->codes[5681] = 0x0000dff63f43639aUL;
   tf->codes[5682] = 0x0000dff679d2695fUL;
   tf->codes[5683] = 0x0000dff8c368a311UL;
   tf->codes[5684] = 0x0000dffa5d51cb74UL;
   tf->codes[5685] = 0x0000e00015495bb1UL;
   tf->codes[5686] = 0x0000e002996e9b28UL;
   tf->codes[5687] = 0x0000e002d3fda0edUL;
   tf->codes[5688] = 0x0000e0030e8ca6b2UL;
   tf->codes[5689] = 0x0000e00383aab23cUL;
   tf->codes[5690] = 0x0000e003be39b801UL;
   tf->codes[5691] = 0x0000e005cd40ebeeUL;
   tf->codes[5692] = 0x0000e006425ef778UL;
   tf->codes[5693] = 0x0000e007672a1451UL;
   tf->codes[5694] = 0x0000e007a1b91a16UL;
   tf->codes[5695] = 0x0000e007dc481fdbUL;
   tf->codes[5696] = 0x0000e0088bf5312aUL;
   tf->codes[5697] = 0x0000e0097631483eUL;
   tf->codes[5698] = 0x0000e00a606d5f52UL;
   tf->codes[5699] = 0x0000e00a9afc6517UL;
   tf->codes[5700] = 0x0000e00b4aa97666UL;
   tf->codes[5701] = 0x0000e00f68b7de40UL;
   tf->codes[5702] = 0x0000e0101864ef8fUL;
   tf->codes[5703] = 0x0000e0108d82fb19UL;
   tf->codes[5704] = 0x0000e010c81200deUL;
   tf->codes[5705] = 0x0000e01102a106a3UL;
   tf->codes[5706] = 0x0000e01177bf122dUL;
   tf->codes[5707] = 0x0000e012276c237cUL;
   tf->codes[5708] = 0x0000e01261fb2941UL;
   tf->codes[5709] = 0x0000e0134c374055UL;
   tf->codes[5710] = 0x0000e013c1554bdfUL;
   tf->codes[5711] = 0x0000e014ab9162f3UL;
   tf->codes[5712] = 0x0000e015d05c7fccUL;
   tf->codes[5713] = 0x0000e016457a8b56UL;
   tf->codes[5714] = 0x0000e016ba9896e0UL;
   tf->codes[5715] = 0x0000e017df63b3b9UL;
   tf->codes[5716] = 0x0000e018c99fcacdUL;
   tf->codes[5717] = 0x0000e0193ebdd657UL;
   tf->codes[5718] = 0x0000e019b3dbe1e1UL;
   tf->codes[5719] = 0x0000e019ee6ae7a6UL;
   tf->codes[5720] = 0x0000e01b4dc50a44UL;
   tf->codes[5721] = 0x0000e01bc2e315ceUL;
   tf->codes[5722] = 0x0000e01dd1ea49bbUL;
   tf->codes[5723] = 0x0000e0201b80836dUL;
   tf->codes[5724] = 0x0000e020cb2d94bcUL;
   tf->codes[5725] = 0x0000e021eff8b195UL;
   tf->codes[5726] = 0x0000e022da34c8a9UL;
   tf->codes[5727] = 0x0000e0234f52d433UL;
   tf->codes[5728] = 0x0000e02389e1d9f8UL;
   tf->codes[5729] = 0x0000e023c470dfbdUL;
   tf->codes[5730] = 0x0000e0276d613c0dUL;
   tf->codes[5731] = 0x0000e027a7f041d2UL;
   tf->codes[5732] = 0x0000e027e27f4797UL;
   tf->codes[5733] = 0x0000e028922c58e6UL;
   tf->codes[5734] = 0x0000e028ccbb5eabUL;
   tf->codes[5735] = 0x0000e02941d96a35UL;
   tf->codes[5736] = 0x0000e02aa1338cd3UL;
   tf->codes[5737] = 0x0000e02c008daf71UL;
   tf->codes[5738] = 0x0000e02e4a23e923UL;
   tf->codes[5739] = 0x0000e02ebf41f4adUL;
   tf->codes[5740] = 0x0000e02fa97e0bc1UL;
   tf->codes[5741] = 0x0000e0301e9c174bUL;
   tf->codes[5742] = 0x0000e030592b1d10UL;
   tf->codes[5743] = 0x0000e03093ba22d5UL;
   tf->codes[5744] = 0x0000e03108d82e5fUL;
   tf->codes[5745] = 0x0000e03143673424UL;
   tf->codes[5746] = 0x0000e031b8853faeUL;
   tf->codes[5747] = 0x0000e032a2c156c2UL;
   tf->codes[5748] = 0x0000e032dd505c87UL;
   tf->codes[5749] = 0x0000e033526e6811UL;
   tf->codes[5750] = 0x0000e034773984eaUL;
   tf->codes[5751] = 0x0000e03526e69639UL;
   tf->codes[5752] = 0x0000e0364bb1b312UL;
   tf->codes[5753] = 0x0000e037ab0bd5b0UL;
   tf->codes[5754] = 0x0000e037e59adb75UL;
   tf->codes[5755] = 0x0000e0385ab8e6ffUL;
   tf->codes[5756] = 0x0000e0397f8403d8UL;
   tf->codes[5757] = 0x0000e03a2f311527UL;
   tf->codes[5758] = 0x0000e03aa44f20b1UL;
   tf->codes[5759] = 0x0000e03b8e8b37c5UL;
   tf->codes[5760] = 0x0000e03bc91a3d8aUL;
   tf->codes[5761] = 0x0000e03d9d926bb2UL;
   tf->codes[5762] = 0x0000e03dd8217177UL;
   tf->codes[5763] = 0x0000e03e12b0773cUL;
   tf->codes[5764] = 0x0000e04021b7ab29UL;
   tf->codes[5765] = 0x0000e042e06bf065UL;
   tf->codes[5766] = 0x0000e0431afaf62aUL;
   tf->codes[5767] = 0x0000e043901901b4UL;
   tf->codes[5768] = 0x0000e046fe7a583fUL;
   tf->codes[5769] = 0x0000e0485dd47addUL;
   tf->codes[5770] = 0x0000e049481091f1UL;
   tf->codes[5771] = 0x0000e04aa76ab48fUL;
   tf->codes[5772] = 0x0000e04b1c88c019UL;
   tf->codes[5773] = 0x0000e04da0adff90UL;
   tf->codes[5774] = 0x0000e052e3878443UL;
   tf->codes[5775] = 0x0000e0531e168a08UL;
   tf->codes[5776] = 0x0000e05393349592UL;
   tf->codes[5777] = 0x0000e0552d1dbdf5UL;
   tf->codes[5778] = 0x0000e05567acc3baUL;
   tf->codes[5779] = 0x0000e0573c24f1e2UL;
   tf->codes[5780] = 0x0000e05776b3f7a7UL;
   tf->codes[5781] = 0x0000e0594b2c25cfUL;
   tf->codes[5782] = 0x0000e05985bb2b94UL;
   tf->codes[5783] = 0x0000e05a6ff742a8UL;
   tf->codes[5784] = 0x0000e05ae5154e32UL;
   tf->codes[5785] = 0x0000e05ec894b047UL;
   tf->codes[5786] = 0x0000e062ac14125cUL;
   tf->codes[5787] = 0x0000e0635bc123abUL;
   tf->codes[5788] = 0x0000e0640b6e34faUL;
   tf->codes[5789] = 0x0000e0656ac85798UL;
   tf->codes[5790] = 0x0000e0668f937471UL;
   tf->codes[5791] = 0x0000e067eeed970fUL;
   tf->codes[5792] = 0x0000e06913b8b3e8UL;
   tf->codes[5793] = 0x0000e069c365c537UL;
   tf->codes[5794] = 0x0000e06a7312d686UL;
   tf->codes[5795] = 0x0000e06ae830e210UL;
   tf->codes[5796] = 0x0000e06b5d4eed9aUL;
   tf->codes[5797] = 0x0000e07065996c88UL;
   tf->codes[5798] = 0x0000e071ff8294ebUL;
   tf->codes[5799] = 0x0000e072af2fa63aUL;
   tf->codes[5800] = 0x0000e072e9beabffUL;
   tf->codes[5801] = 0x0000e073244db1c4UL;
   tf->codes[5802] = 0x0000e073d3fac313UL;
   tf->codes[5803] = 0x0000e0765820028aUL;
   tf->codes[5804] = 0x0000e077425c199eUL;
   tf->codes[5805] = 0x0000e078a1b63c3cUL;
   tf->codes[5806] = 0x0000e07ab0bd7029UL;
   tf->codes[5807] = 0x0000e07c4aa6988cUL;
   tf->codes[5808] = 0x0000e07c85359e51UL;
   tf->codes[5809] = 0x0000e07e1f1ec6b4UL;
   tf->codes[5810] = 0x0000e08068b50066UL;
   tf->codes[5811] = 0x0000e08152f1177aUL;
   tf->codes[5812] = 0x0000e0818d801d3fUL;
   tf->codes[5813] = 0x0000e082029e28c9UL;
   tf->codes[5814] = 0x0000e083276945a2UL;
   tf->codes[5815] = 0x0000e0844c34627bUL;
   tf->codes[5816] = 0x0000e0865b3b9668UL;
   tf->codes[5817] = 0x0000e0878006b341UL;
   tf->codes[5818] = 0x0000e0882fb3c490UL;
   tf->codes[5819] = 0x0000e0898f0de72eUL;
   tf->codes[5820] = 0x0000e08a3ebaf87dUL;
   tf->codes[5821] = 0x0000e08b63861556UL;
   tf->codes[5822] = 0x0000e08f81947d30UL;
   tf->codes[5823] = 0x0000e08fbc2382f5UL;
   tf->codes[5824] = 0x0000e090a65f9a09UL;
   tf->codes[5825] = 0x0000e094fefd07a8UL;
   tf->codes[5826] = 0x0000e095741b1332UL;
   tf->codes[5827] = 0x0000e095aeaa18f7UL;
   tf->codes[5828] = 0x0000e0965e572a46UL;
   tf->codes[5829] = 0x0000e0978322471fUL;
   tf->codes[5830] = 0x0000e09832cf586eUL;
   tf->codes[5831] = 0x0000e09992297b0cUL;
   tf->codes[5832] = 0x0000e09a7c659220UL;
   tf->codes[5833] = 0x0000e09bdbbfb4beUL;
   tf->codes[5834] = 0x0000e09c8b6cc60dUL;
   tf->codes[5835] = 0x0000e09d75a8dd21UL;
   tf->codes[5836] = 0x0000e09e5fe4f435UL;
   tf->codes[5837] = 0x0000e0a0e40a33acUL;
   tf->codes[5838] = 0x0000e0a193b744fbUL;
   tf->codes[5839] = 0x0000e0a24364564aUL;
   tf->codes[5840] = 0x0000e0a2b88261d4UL;
   tf->codes[5841] = 0x0000e0a3682f7323UL;
   tf->codes[5842] = 0x0000e0a3dd4d7eadUL;
   tf->codes[5843] = 0x0000e0a4c78995c1UL;
   tf->codes[5844] = 0x0000e0a66172be24UL;
   tf->codes[5845] = 0x0000e0aa0a631a74UL;
   tf->codes[5846] = 0x0000e0aba44c42d7UL;
   tf->codes[5847] = 0x0000e0b196d2d8d9UL;
   tf->codes[5848] = 0x0000e0b2f62cfb77UL;
   tf->codes[5849] = 0x0000e0b36b4b0701UL;
   tf->codes[5850] = 0x0000e0b3e069128bUL;
   tf->codes[5851] = 0x0000e0b5ef704678UL;
   tf->codes[5852] = 0x0000e0b6648e5202UL;
   tf->codes[5853] = 0x0000e0b6d9ac5d8cUL;
   tf->codes[5854] = 0x0000e0b7143b6351UL;
   tf->codes[5855] = 0x0000e0baf7bac566UL;
   tf->codes[5856] = 0x0000e0bba767d6b5UL;
   tf->codes[5857] = 0x0000e0bccc32f38eUL;
   tf->codes[5858] = 0x0000e0bd4150ff18UL;
   tf->codes[5859] = 0x0000e0bdb66f0aa2UL;
   tf->codes[5860] = 0x0000e0bdf0fe1067UL;
   tf->codes[5861] = 0x0000e0be2b8d162cUL;
   tf->codes[5862] = 0x0000e0be661c1bf1UL;
   tf->codes[5863] = 0x0000e0bedb3a277bUL;
   tf->codes[5864] = 0x0000e0bfc5763e8fUL;
   tf->codes[5865] = 0x0000e0c1d47d727cUL;
   tf->codes[5866] = 0x0000e0c2f9488f55UL;
   tf->codes[5867] = 0x0000e0c5f28bda56UL;
   tf->codes[5868] = 0x0000e0c6a238eba5UL;
   tf->codes[5869] = 0x0000e0c78c7502b9UL;
   tf->codes[5870] = 0x0000e0c7c704087eUL;
   tf->codes[5871] = 0x0000e0c9d60b3c6bUL;
   tf->codes[5872] = 0x0000e0ca4b2947f5UL;
   tf->codes[5873] = 0x0000e0cb35655f09UL;
   tf->codes[5874] = 0x0000e0cbaa836a93UL;
   tf->codes[5875] = 0x0000e0d371822ebdUL;
   tf->codes[5876] = 0x0000e0d45bbe45d1UL;
   tf->codes[5877] = 0x0000e0d6303673f9UL;
   tf->codes[5878] = 0x0000e0d66ac579beUL;
   tf->codes[5879] = 0x0000e0d7ca1f9c5cUL;
   tf->codes[5880] = 0x0000e0d804aea221UL;
   tf->codes[5881] = 0x0000e0d83f3da7e6UL;
   tf->codes[5882] = 0x0000e0d92979befaUL;
   tf->codes[5883] = 0x0000e0d96408c4bfUL;
   tf->codes[5884] = 0x0000e0da13b5d60eUL;
   tf->codes[5885] = 0x0000e0da4e44dbd3UL;
   tf->codes[5886] = 0x0000e0db730ff8acUL;
   tf->codes[5887] = 0x0000e0dbad9efe71UL;
   tf->codes[5888] = 0x0000e0dbe82e0436UL;
   tf->codes[5889] = 0x0000e0dc22bd09fbUL;
   tf->codes[5890] = 0x0000e0df568f5ac1UL;
   tf->codes[5891] = 0x0000e0e0b5e97d5fUL;
   tf->codes[5892] = 0x0000e0e0f0788324UL;
   tf->codes[5893] = 0x0000e0e2c4f0b14cUL;
   tf->codes[5894] = 0x0000e0e33a0ebcd6UL;
   tf->codes[5895] = 0x0000e0e3749dc29bUL;
   tf->codes[5896] = 0x0000e0e3e9bbce25UL;
   tf->codes[5897] = 0x0000e0e583a4f688UL;
   tf->codes[5898] = 0x0000e0e7cd3b303aUL;
   tf->codes[5899] = 0x0000e0e87ce84189UL;
   tf->codes[5900] = 0x0000e0e96724589dUL;
   tf->codes[5901] = 0x0000e0eac67e7b3bUL;
   tf->codes[5902] = 0x0000e0eb3b9c86c5UL;
   tf->codes[5903] = 0x0000e0f0b905113dUL;
   tf->codes[5904] = 0x0000e0f0f3941702UL;
   tf->codes[5905] = 0x0000e0f3029b4aefUL;
   tf->codes[5906] = 0x0000e0f5c14f902bUL;
   tf->codes[5907] = 0x0000e0f8ba92db2cUL;
   tf->codes[5908] = 0x0000e0fb79472068UL;
   tf->codes[5909] = 0x0000e10047029991UL;
   tf->codes[5910] = 0x0000e100f6afaae0UL;
   tf->codes[5911] = 0x0000e101313eb0a5UL;
   tf->codes[5912] = 0x0000e1016bcdb66aUL;
   tf->codes[5913] = 0x0000e101a65cbc2fUL;
   tf->codes[5914] = 0x0000e1042a81fba6UL;
   tf->codes[5915] = 0x0000e10589dc1e44UL;
   tf->codes[5916] = 0x0000e107d37257f6UL;
   tf->codes[5917] = 0x0000e10a5797976dUL;
   tf->codes[5918] = 0x0000e10accb5a2f7UL;
   tf->codes[5919] = 0x0000e10b0744a8bcUL;
   tf->codes[5920] = 0x0000e10b41d3ae81UL;
   tf->codes[5921] = 0x0000e10e3b16f982UL;
   tf->codes[5922] = 0x0000e11084ad3334UL;
   tf->codes[5923] = 0x0000e111345a4483UL;
   tf->codes[5924] = 0x0000e111a978500dUL;
   tf->codes[5925] = 0x0000e1137df07e35UL;
   tf->codes[5926] = 0x0000e113b87f83faUL;
   tf->codes[5927] = 0x0000e114682c9549UL;
   tf->codes[5928] = 0x0000e114dd4aa0d3UL;
   tf->codes[5929] = 0x0000e11726e0da85UL;
   tf->codes[5930] = 0x0000e117616fe04aUL;
   tf->codes[5931] = 0x0000e118863afd23UL;
   tf->codes[5932] = 0x0000e11b0a603c9aUL;
   tf->codes[5933] = 0x0000e11b7f7e4824UL;
   tf->codes[5934] = 0x0000e11bf49c53aeUL;
   tf->codes[5935] = 0x0000e11c69ba5f38UL;
   tf->codes[5936] = 0x0000e11d8e857c11UL;
   tf->codes[5937] = 0x0000e11eb35098eaUL;
   tf->codes[5938] = 0x0000e1204d39c14dUL;
   tf->codes[5939] = 0x0000e1213775d861UL;
   tf->codes[5940] = 0x0000e1217204de26UL;
   tf->codes[5941] = 0x0000e1230bee0689UL;
   tf->codes[5942] = 0x0000e123f62a1d9dUL;
   tf->codes[5943] = 0x0000e12430b92362UL;
   tf->codes[5944] = 0x0000e1260531518aUL;
   tf->codes[5945] = 0x0000e1279f1a79edUL;
   tf->codes[5946] = 0x0000e128c3e596c6UL;
   tf->codes[5947] = 0x0000e1297392a815UL;
   tf->codes[5948] = 0x0000e12a233fb964UL;
   tf->codes[5949] = 0x0000e12bbd28e1c7UL;
   tf->codes[5950] = 0x0000e1305055552bUL;
   tf->codes[5951] = 0x0000e130c57360b5UL;
   tf->codes[5952] = 0x0000e13299eb8eddUL;
   tf->codes[5953] = 0x0000e1330f099a67UL;
   tf->codes[5954] = 0x0000e1334998a02cUL;
   tf->codes[5955] = 0x0000e133f945b17bUL;
   tf->codes[5956] = 0x0000e135589fd419UL;
   tf->codes[5957] = 0x0000e135932ed9deUL;
   tf->codes[5958] = 0x0000e139b13d41b8UL;
   tf->codes[5959] = 0x0000e13a9b7958ccUL;
   tf->codes[5960] = 0x0000e13bc04475a5UL;
   tf->codes[5961] = 0x0000e13c3562812fUL;
   tf->codes[5962] = 0x0000e13d1f9e9843UL;
   tf->codes[5963] = 0x0000e13d94bca3cdUL;
   tf->codes[5964] = 0x0000e13e7ef8bae1UL;
   tf->codes[5965] = 0x0000e13eb987c0a6UL;
   tf->codes[5966] = 0x0000e13ef416c66bUL;
   tf->codes[5967] = 0x0000e13f6934d1f5UL;
   tf->codes[5968] = 0x0000e140c88ef493UL;
   tf->codes[5969] = 0x0000e141031dfa58UL;
   tf->codes[5970] = 0x0000e14227e91731UL;
   tf->codes[5971] = 0x0000e147a551a1a9UL;
   tf->codes[5972] = 0x0000e14854feb2f8UL;
   tf->codes[5973] = 0x0000e14bfdef0f48UL;
   tf->codes[5974] = 0x0000e14d5d4931e6UL;
   tf->codes[5975] = 0x0000e150cbaa8871UL;
   tf->codes[5976] = 0x0000e151b5e69f85UL;
   tf->codes[5977] = 0x0000e151f075a54aUL;
   tf->codes[5978] = 0x0000e1526593b0d4UL;
   tf->codes[5979] = 0x0000e152a022b699UL;
   tf->codes[5980] = 0x0000e1543a0bdefcUL;
   tf->codes[5981] = 0x0000e1559966019aUL;
   tf->codes[5982] = 0x0000e156491312e9UL;
   tf->codes[5983] = 0x0000e156f8c02438UL;
   tf->codes[5984] = 0x0000e15942565deaUL;
   tf->codes[5985] = 0x0000e15adc3f864dUL;
   tf->codes[5986] = 0x0000e15b515d91d7UL;
   tf->codes[5987] = 0x0000e15c7628aeb0UL;
   tf->codes[5988] = 0x0000e15ceb46ba3aUL;
   tf->codes[5989] = 0x0000e15e852fe29dUL;
   tf->codes[5990] = 0x0000e15efa4dee27UL;
   tf->codes[5991] = 0x0000e16109552214UL;
   tf->codes[5992] = 0x0000e161b9023363UL;
   tf->codes[5993] = 0x0000e161f3913928UL;
   tf->codes[5994] = 0x0000e162ddcd503cUL;
   tf->codes[5995] = 0x0000e163185c5601UL;
   tf->codes[5996] = 0x0000e16561f28fb3UL;
   tf->codes[5997] = 0x0000e1659c819578UL;
   tf->codes[5998] = 0x0000e166fbdbb816UL;
   tf->codes[5999] = 0x0000e16820a6d4efUL;
   tf->codes[6000] = 0x0000e1685b35dab4UL;
   tf->codes[6001] = 0x0000e169f51f0317UL;
   tf->codes[6002] = 0x0000e16a2fae08dcUL;
   tf->codes[6003] = 0x0000e16adf5b1a2bUL;
   tf->codes[6004] = 0x0000e16b8f082b7aUL;
   tf->codes[6005] = 0x0000e16bc997313fUL;
   tf->codes[6006] = 0x0000e16fe7a59919UL;
   tf->codes[6007] = 0x0000e17146ffbbb7UL;
   tf->codes[6008] = 0x0000e172313bd2cbUL;
   tf->codes[6009] = 0x0000e172a659de55UL;
   tf->codes[6010] = 0x0000e1731b77e9dfUL;
   tf->codes[6011] = 0x0000e174b5611242UL;
   tf->codes[6012] = 0x0000e175da2c2f1bUL;
   tf->codes[6013] = 0x0000e17614bb34e0UL;
   tf->codes[6014] = 0x0000e177398651b9UL;
   tf->codes[6015] = 0x0000e1777415577eUL;
   tf->codes[6016] = 0x0000e177aea45d43UL;
   tf->codes[6017] = 0x0000e179f83a96f5UL;
   tf->codes[6018] = 0x0000e17a6d58a27fUL;
   tf->codes[6019] = 0x0000e17b9223bf58UL;
   tf->codes[6020] = 0x0000e17e8b670a59UL;
   tf->codes[6021] = 0x0000e17f008515e3UL;
   tf->codes[6022] = 0x0000e1805fdf3881UL;
   tf->codes[6023] = 0x0000e181bf395b1fUL;
   tf->codes[6024] = 0x0000e181f9c860e4UL;
   tf->codes[6025] = 0x0000e182a9757233UL;
   tf->codes[6026] = 0x0000e18359228382UL;
   tf->codes[6027] = 0x0000e186c783da0dUL;
   tf->codes[6028] = 0x0000e187ec4ef6e6UL;
   tf->codes[6029] = 0x0000e189111a13bfUL;
   tf->codes[6030] = 0x0000e18a35e53098UL;
   tf->codes[6031] = 0x0000e18aab033c22UL;
   tf->codes[6032] = 0x0000e18b5ab04d71UL;
   tf->codes[6033] = 0x0000e18f3e2faf86UL;
   tf->codes[6034] = 0x0000e190286bc69aUL;
   tf->codes[6035] = 0x0000e190d818d7e9UL;
   tf->codes[6036] = 0x0000e19112a7ddaeUL;
   tf->codes[6037] = 0x0000e19321af119bUL;
   tf->codes[6038] = 0x0000e193d15c22eaUL;
   tf->codes[6039] = 0x0000e19481093439UL;
   tf->codes[6040] = 0x0000e195e06356d7UL;
   tf->codes[6041] = 0x0000e19655816261UL;
   tf->codes[6042] = 0x0000e197052e73b0UL;
   tf->codes[6043] = 0x0000e197ef6a8ac4UL;
   tf->codes[6044] = 0x0000e198d9a6a1d8UL;
   tf->codes[6045] = 0x0000e1998953b327UL;
   tf->codes[6046] = 0x0000e199c3e2b8ecUL;
   tf->codes[6047] = 0x0000e199fe71beb1UL;
   tf->codes[6048] = 0x0000e19a738fca3bUL;
   tf->codes[6049] = 0x0000e19b233cdb8aUL;
   tf->codes[6050] = 0x0000e19b985ae714UL;
   tf->codes[6051] = 0x0000e19bd2e9ecd9UL;
   tf->codes[6052] = 0x0000e19e1c80268bUL;
   tf->codes[6053] = 0x0000e19f414b4364UL;
   tf->codes[6054] = 0x0000e1a2afac99efUL;
   tf->codes[6055] = 0x0000e1a2ea3b9fb4UL;
   tf->codes[6056] = 0x0000e1a35f59ab3eUL;
   tf->codes[6057] = 0x0000e1a44995c252UL;
   tf->codes[6058] = 0x0000e1a4beb3cddcUL;
   tf->codes[6059] = 0x0000e1a4f942d3a1UL;
   tf->codes[6060] = 0x0000e1a5e37eeab5UL;
   tf->codes[6061] = 0x0000e1a61e0df07aUL;
   tf->codes[6062] = 0x0000e1aa018d528fUL;
   tf->codes[6063] = 0x0000e1ab9b767af2UL;
   tf->codes[6064] = 0x0000e1abd60580b7UL;
   tf->codes[6065] = 0x0000e1ad6feea91aUL;
   tf->codes[6066] = 0x0000e1aecf48cbb8UL;
   tf->codes[6067] = 0x0000e1b02ea2ee56UL;
   tf->codes[6068] = 0x0000e1b06931f41bUL;
   tf->codes[6069] = 0x0000e1b2031b1c7eUL;
   tf->codes[6070] = 0x0000e1b362753f1cUL;
   tf->codes[6071] = 0x0000e1b41222506bUL;
   tf->codes[6072] = 0x0000e1b4c1cf61baUL;
   tf->codes[6073] = 0x0000e1b536ed6d44UL;
   tf->codes[6074] = 0x0000e1b65bb88a1dUL;
   tf->codes[6075] = 0x0000e1b78083a6f6UL;
   tf->codes[6076] = 0x0000e1b86abfbe0aUL;
   tf->codes[6077] = 0x0000e1b91a6ccf59UL;
   tf->codes[6078] = 0x0000e1ba3f37ec32UL;
   tf->codes[6079] = 0x0000e1bab455f7bcUL;
   tf->codes[6080] = 0x0000e1bb29740346UL;
   tf->codes[6081] = 0x0000e1bb9e920ed0UL;
   tf->codes[6082] = 0x0000e1bbd9211495UL;
   tf->codes[6083] = 0x0000e1be5d46540cUL;
   tf->codes[6084] = 0x0000e1c3a01fd8bfUL;
   tf->codes[6085] = 0x0000e1c5e9b61271UL;
   tf->codes[6086] = 0x0000e1c7be2e4099UL;
   tf->codes[6087] = 0x0000e1c7f8bd465eUL;
   tf->codes[6088] = 0x0000e1c8a86a57adUL;
   tf->codes[6089] = 0x0000e1caf200915fUL;
   tf->codes[6090] = 0x0000e1cb2c8f9724UL;
   tf->codes[6091] = 0x0000e1cd7625d0d6UL;
   tf->codes[6092] = 0x0000e1cf852d04c3UL;
   tf->codes[6093] = 0x0000e1d06f691bd7UL;
   tf->codes[6094] = 0x0000e1d20952443aUL;
   tf->codes[6095] = 0x0000e1d2f38e5b4eUL;
   tf->codes[6096] = 0x0000e1d418597827UL;
   tf->codes[6097] = 0x0000e1d69c7eb79eUL;
   tf->codes[6098] = 0x0000e1d74c2bc8edUL;
   tf->codes[6099] = 0x0000e1d786baceb2UL;
   tf->codes[6100] = 0x0000e1d8e614f150UL;
   tf->codes[6101] = 0x0000e1daba8d1f78UL;
   tf->codes[6102] = 0x0000e1db6a3a30c7UL;
   tf->codes[6103] = 0x0000e1dc8f054da0UL;
   tf->codes[6104] = 0x0000e1dd0423592aUL;
   tf->codes[6105] = 0x0000e1dd3eb25eefUL;
   tf->codes[6106] = 0x0000e1df4db992dcUL;
   tf->codes[6107] = 0x0000e1e246fcddddUL;
   tf->codes[6108] = 0x0000e1e3e0e60640UL;
   tf->codes[6109] = 0x0000e1e4560411caUL;
   tf->codes[6110] = 0x0000e1e505b12319UL;
   tf->codes[6111] = 0x0000e1e6650b45b7UL;
   tf->codes[6112] = 0x0000e1e8398373dfUL;
   tf->codes[6113] = 0x0000e1eba7e4ca6aUL;
   tf->codes[6114] = 0x0000e1f1d4fa6631UL;
   tf->codes[6115] = 0x0000e1f3345488cfUL;
   tf->codes[6116] = 0x0000e1f9d6883020UL;
   tf->codes[6117] = 0x0000e1fa8635416fUL;
   tf->codes[6118] = 0x0000e1fc953c755cUL;
   tf->codes[6119] = 0x0000e2003e2cd1acUL;
   tf->codes[6120] = 0x0000e2012868e8c0UL;
   tf->codes[6121] = 0x0000e20212a4ffd4UL;
   tf->codes[6122] = 0x0000e2024d340599UL;
   tf->codes[6123] = 0x0000e20371ff2272UL;
   tf->codes[6124] = 0x0000e205f62461e9UL;
   tf->codes[6125] = 0x0000e208ef67aceaUL;
   tf->codes[6126] = 0x0000e2112b847c9eUL;
   tf->codes[6127] = 0x0000e211db318dedUL;
   tf->codes[6128] = 0x0000e2145f56cd64UL;
   tf->codes[6129] = 0x0000e214d474d8eeUL;
   tf->codes[6130] = 0x0000e2154992e478UL;
   tf->codes[6131] = 0x0000e2158421ea3dUL;
   tf->codes[6132] = 0x0000e215f93ff5c7UL;
   tf->codes[6133] = 0x0000e21633cefb8cUL;
   tf->codes[6134] = 0x0000e2171e0b12a0UL;
   tf->codes[6135] = 0x0000e2187d65353eUL;
   tf->codes[6136] = 0x0000e218f28340c8UL;
   tf->codes[6137] = 0x0000e21b018a74b5UL;
   tf->codes[6138] = 0x0000e21b3c197a7aUL;
   tf->codes[6139] = 0x0000e21c9b739d18UL;
   tf->codes[6140] = 0x0000e21dc03eb9f1UL;
   tf->codes[6141] = 0x0000e21e355cc57bUL;
   tf->codes[6142] = 0x0000e21e6febcb40UL;
   tf->codes[6143] = 0x0000e21eaa7ad105UL;
   tf->codes[6144] = 0x0000e2207ef2ff2dUL;
   tf->codes[6145] = 0x0000e22303183ea4UL;
   tf->codes[6146] = 0x0000e22378364a2eUL;
   tf->codes[6147] = 0x0000e225fc5b89a5UL;
   tf->codes[6148] = 0x0000e2272126a67eUL;
   tf->codes[6149] = 0x0000e227d0d3b7cdUL;
   tf->codes[6150] = 0x0000e22b04a60893UL;
   tf->codes[6151] = 0x0000e22b3f350e58UL;
   tf->codes[6152] = 0x0000e22fd26181bcUL;
   tf->codes[6153] = 0x0000e230f72c9e95UL;
   tf->codes[6154] = 0x0000e231e168b5a9UL;
   tf->codes[6155] = 0x0000e234a01cfae5UL;
   tf->codes[6156] = 0x0000e236e9b33497UL;
   tf->codes[6157] = 0x0000e23a92a390e7UL;
   tf->codes[6158] = 0x0000e23b4250a236UL;
   tf->codes[6159] = 0x0000e23cdc39ca99UL;
   tf->codes[6160] = 0x0000e23fd57d159aUL;
   tf->codes[6161] = 0x0000e2416f663dfdUL;
   tf->codes[6162] = 0x0000e241e4844987UL;
   tf->codes[6163] = 0x0000e243094f6660UL;
   tf->codes[6164] = 0x0000e244ddc79488UL;
   tf->codes[6165] = 0x0000e247275dce3aUL;
   tf->codes[6166] = 0x0000e24a5b301f00UL;
   tf->codes[6167] = 0x0000e24ad04e2a8aUL;
   tf->codes[6168] = 0x0000e24b7ffb3bd9UL;
   tf->codes[6169] = 0x0000e2504db6b502UL;
   tf->codes[6170] = 0x0000e2525cbde8efUL;
   tf->codes[6171] = 0x0000e252d1dbf479UL;
   tf->codes[6172] = 0x0000e254a65422a1UL;
   tf->codes[6173] = 0x0000e254e0e32866UL;
   tf->codes[6174] = 0x0000e257650867ddUL;
   tf->codes[6175] = 0x0000e259740f9bcaUL;
   tf->codes[6176] = 0x0000e25d578efddfUL;
   tf->codes[6177] = 0x0000e25f669631ccUL;
   tf->codes[6178] = 0x0000e2608b614ea5UL;
   tf->codes[6179] = 0x0000e261b02c6b7eUL;
   tf->codes[6180] = 0x0000e265ce3ad358UL;
   tf->codes[6181] = 0x0000e266f305f031UL;
   tf->codes[6182] = 0x0000e267dd420745UL;
   tf->codes[6183] = 0x0000e269772b2fa8UL;
   tf->codes[6184] = 0x0000e26b1114580bUL;
   tf->codes[6185] = 0x0000e26b4ba35dd0UL;
   tf->codes[6186] = 0x0000e26e7f75ae96UL;
   tf->codes[6187] = 0x0000e27178b8f997UL;
   tf->codes[6188] = 0x0000e275d1566736UL;
   tf->codes[6189] = 0x0000e278900aac72UL;
   tf->codes[6190] = 0x0000e27cae19144cUL;
   tf->codes[6191] = 0x0000e27ce8a81a11UL;
   tf->codes[6192] = 0x0000e27d98552b60UL;
   tf->codes[6193] = 0x0000e27dd2e43125UL;
   tf->codes[6194] = 0x0000e27ebd204839UL;
   tf->codes[6195] = 0x0000e27ef7af4dfeUL;
   tf->codes[6196] = 0x0000e27fa75c5f4dUL;
   tf->codes[6197] = 0x0000e28091987661UL;
   tf->codes[6198] = 0x0000e28106b681ebUL;
   tf->codes[6199] = 0x0000e281414587b0UL;
   tf->codes[6200] = 0x0000e284ea35e400UL;
   tf->codes[6201] = 0x0000e2855f53ef8aUL;
   tf->codes[6202] = 0x0000e288cdb54615UL;
   tf->codes[6203] = 0x0000e2897d625764UL;
   tf->codes[6204] = 0x0000e28aa22d743dUL;
   tf->codes[6205] = 0x0000e28b8c698b51UL;
   tf->codes[6206] = 0x0000e28bc6f89116UL;
   tf->codes[6207] = 0x0000e28fe506f8f0UL;
   tf->codes[6208] = 0x0000e291b97f2718UL;
   tf->codes[6209] = 0x0000e292692c3867UL;
   tf->codes[6210] = 0x0000e2938df75540UL;
   tf->codes[6211] = 0x0000e293c8865b05UL;
   tf->codes[6212] = 0x0000e294ed5177deUL;
   tf->codes[6213] = 0x0000e295626f8368UL;
   tf->codes[6214] = 0x0000e296121c94b7UL;
   tf->codes[6215] = 0x0000e296873aa041UL;
   tf->codes[6216] = 0x0000e29736e7b190UL;
   tf->codes[6217] = 0x0000e2977176b755UL;
   tf->codes[6218] = 0x0000e2982123c8a4UL;
   tf->codes[6219] = 0x0000e2989641d42eUL;
   tf->codes[6220] = 0x0000e299bb0cf107UL;
   tf->codes[6221] = 0x0000e299f59bf6ccUL;
   tf->codes[6222] = 0x0000e29fad938709UL;
   tf->codes[6223] = 0x0000e2a10ceda9a7UL;
   tf->codes[6224] = 0x0000e2a1477caf6cUL;
   tf->codes[6225] = 0x0000e2a1820bb531UL;
   tf->codes[6226] = 0x0000e2a1bc9abaf6UL;
   tf->codes[6227] = 0x0000e2a5658b1746UL;
   tf->codes[6228] = 0x0000e2a5a01a1d0bUL;
   tf->codes[6229] = 0x0000e2a8995d680cUL;
   tf->codes[6230] = 0x0000e2a90e7b7396UL;
   tf->codes[6231] = 0x0000e2afeb3e20acUL;
   tf->codes[6232] = 0x0000e2b0d57a37c0UL;
   tf->codes[6233] = 0x0000e2b26f636023UL;
   tf->codes[6234] = 0x0000e2b3cebd82c1UL;
   tf->codes[6235] = 0x0000e2b4094c8886UL;
   tf->codes[6236] = 0x0000e2b47e6a9410UL;
   tf->codes[6237] = 0x0000e2b5ddc4b6aeUL;
   tf->codes[6238] = 0x0000e2b61853bc73UL;
   tf->codes[6239] = 0x0000e2b73d1ed94cUL;
   tf->codes[6240] = 0x0000e2bb5b2d4126UL;
   tf->codes[6241] = 0x0000e2bc4569583aUL;
   tf->codes[6242] = 0x0000e2bcf5166989UL;
   tf->codes[6243] = 0x0000e2bd6a347513UL;
   tf->codes[6244] = 0x0000e2bec98e97b1UL;
   tf->codes[6245] = 0x0000e2bf793ba900UL;
   tf->codes[6246] = 0x0000e2c3222c0550UL;
   tf->codes[6247] = 0x0000e2c3974a10daUL;
   tf->codes[6248] = 0x0000e2c655fe5616UL;
   tf->codes[6249] = 0x0000e2c7b55878b4UL;
   tf->codes[6250] = 0x0000e2c865058a03UL;
   tf->codes[6251] = 0x0000e2cb98d7dac9UL;
   tf->codes[6252] = 0x0000e2cc4884ec18UL;
   tf->codes[6253] = 0x0000e2cde26e147bUL;
   tf->codes[6254] = 0x0000e2ce1cfd1a40UL;
   tf->codes[6255] = 0x0000e2cff1754868UL;
   tf->codes[6256] = 0x0000e2d2eab89369UL;
   tf->codes[6257] = 0x0000e2d484a1bbccUL;
   tf->codes[6258] = 0x0000e2d7b8740c92UL;
   tf->codes[6259] = 0x0000e2d8a2b023a6UL;
   tf->codes[6260] = 0x0000e2d9525d34f5UL;
   tf->codes[6261] = 0x0000e2d9c77b407fUL;
   tf->codes[6262] = 0x0000e2da020a4644UL;
   tf->codes[6263] = 0x0000e2da772851ceUL;
   tf->codes[6264] = 0x0000e2dde589a859UL;
   tf->codes[6265] = 0x0000e2de5aa7b3e3UL;
   tf->codes[6266] = 0x0000e2decfc5bf6dUL;
   tf->codes[6267] = 0x0000e2df0a54c532UL;
   tf->codes[6268] = 0x0000e2df7f72d0bcUL;
   tf->codes[6269] = 0x0000e2e069aee7d0UL;
   tf->codes[6270] = 0x0000e2e153eafee4UL;
   tf->codes[6271] = 0x0000e2e1c9090a6eUL;
   tf->codes[6272] = 0x0000e2e3d8103e5bUL;
   tf->codes[6273] = 0x0000e2e91ae9c30eUL;
   tf->codes[6274] = 0x0000e2e95578c8d3UL;
   tf->codes[6275] = 0x0000e2e9ca96d45dUL;
   tf->codes[6276] = 0x0000e2ef0d705910UL;
   tf->codes[6277] = 0x0000e2ef828e649aUL;
   tf->codes[6278] = 0x0000e2efbd1d6a5fUL;
   tf->codes[6279] = 0x0000e2f0a7598173UL;
   tf->codes[6280] = 0x0000e2f415bad7feUL;
   tf->codes[6281] = 0x0000e2f5ea330626UL;
   tf->codes[6282] = 0x0000e2f65f5111b0UL;
   tf->codes[6283] = 0x0000e2f8e3765127UL;
   tf->codes[6284] = 0x0000e2f91e0556ecUL;
   tf->codes[6285] = 0x0000e2fbdcb99c28UL;
   tf->codes[6286] = 0x0000e2ffc038fe3dUL;
   tf->codes[6287] = 0x0000e3053da188b5UL;
   tf->codes[6288] = 0x0000e30578308e7aUL;
   tf->codes[6289] = 0x0000e30627dd9fc9UL;
   tf->codes[6290] = 0x0000e306626ca58eUL;
   tf->codes[6291] = 0x0000e3078737c267UL;
   tf->codes[6292] = 0x0000e30af59918f2UL;
   tf->codes[6293] = 0x0000e30e9e897542UL;
   tf->codes[6294] = 0x0000e31038729da5UL;
   tf->codes[6295] = 0x0000e3107301a36aUL;
   tf->codes[6296] = 0x0000e310e81faef4UL;
   tf->codes[6297] = 0x0000e31331b5e8a6UL;
   tf->codes[6298] = 0x0000e313e162f9f5UL;
   tf->codes[6299] = 0x0000e3145681057fUL;
   tf->codes[6300] = 0x0000e314cb9f1109UL;
   tf->codes[6301] = 0x0000e316a0173f31UL;
   tf->codes[6302] = 0x0000e3178a535645UL;
   tf->codes[6303] = 0x0000e318af1e731eUL;
   tf->codes[6304] = 0x0000e319243c7ea8UL;
   tf->codes[6305] = 0x0000e31abe25a70bUL;
   tf->codes[6306] = 0x0000e31be2f0c3e4UL;
   tf->codes[6307] = 0x0000e31f51521a6fUL;
   tf->codes[6308] = 0x0000e31fc67025f9UL;
   tf->codes[6309] = 0x0000e3203b8e3183UL;
   tf->codes[6310] = 0x0000e32285246b35UL;
   tf->codes[6311] = 0x0000e3236f608249UL;
   tf->codes[6312] = 0x0000e324942b9f22UL;
   tf->codes[6313] = 0x0000e3257e67b636UL;
   tf->codes[6314] = 0x0000e325b8f6bbfbUL;
   tf->codes[6315] = 0x0000e32a86b23524UL;
   tf->codes[6316] = 0x0000e32f546dae4dUL;
   tf->codes[6317] = 0x0000e32fc98bb9d7UL;
   tf->codes[6318] = 0x0000e33128e5dc75UL;
   tf->codes[6319] = 0x0000e332fd5e0a9dUL;
   tf->codes[6320] = 0x0000e334d1d638c5UL;
   tf->codes[6321] = 0x0000e33581834a14UL;
   tf->codes[6322] = 0x0000e33631305b63UL;
   tf->codes[6323] = 0x0000e336a64e66edUL;
   tf->codes[6324] = 0x0000e3371b6c7277UL;
   tf->codes[6325] = 0x0000e33755fb783cUL;
   tf->codes[6326] = 0x0000e337cb1983c6UL;
   tf->codes[6327] = 0x0000e33840378f50UL;
   tf->codes[6328] = 0x0000e338efe4a09fUL;
   tf->codes[6329] = 0x0000e3399f91b1eeUL;
   tf->codes[6330] = 0x0000e33a89cdc902UL;
   tf->codes[6331] = 0x0000e33ac45ccec7UL;
   tf->codes[6332] = 0x0000e33e6d4d2b17UL;
   tf->codes[6333] = 0x0000e33ea7dc30dcUL;
   tf->codes[6334] = 0x0000e3400736537aUL;
   tf->codes[6335] = 0x0000e3412c017053UL;
   tf->codes[6336] = 0x0000e3449a62c6deUL;
   tf->codes[6337] = 0x0000e347ce3517a4UL;
   tf->codes[6338] = 0x0000e349681e4007UL;
   tf->codes[6339] = 0x0000e34a525a571bUL;
   tf->codes[6340] = 0x0000e34ac77862a5UL;
   tf->codes[6341] = 0x0000e34b0207686aUL;
   tf->codes[6342] = 0x0000e34f2015d044UL;
   tf->codes[6343] = 0x0000e3507f6ff2e2UL;
   tf->codes[6344] = 0x0000e3512f1d0431UL;
   tf->codes[6345] = 0x0000e35253e8210aUL;
   tf->codes[6346] = 0x0000e35378b33de3UL;
   tf->codes[6347] = 0x0000e353b34243a8UL;
   tf->codes[6348] = 0x0000e3554d2b6c0bUL;
   tf->codes[6349] = 0x0000e35587ba71d0UL;
   tf->codes[6350] = 0x0000e355c2497795UL;
   tf->codes[6351] = 0x0000e356e714946eUL;
   tf->codes[6352] = 0x0000e35721a39a33UL;
   tf->codes[6353] = 0x0000e358f61bc85bUL;
   tf->codes[6354] = 0x0000e359a5c8d9aaUL;
   tf->codes[6355] = 0x0000e35a9004f0beUL;
   tf->codes[6356] = 0x0000e35c29ee1921UL;
   tf->codes[6357] = 0x0000e35eae135898UL;
   tf->codes[6358] = 0x0000e35f23316422UL;
   tf->codes[6359] = 0x0000e3629192baadUL;
   tf->codes[6360] = 0x0000e362cc21c072UL;
   tf->codes[6361] = 0x0000e364a099ee9aUL;
   tf->codes[6362] = 0x0000e3655046ffe9UL;
   tf->codes[6363] = 0x0000e36675121cc2UL;
   tf->codes[6364] = 0x0000e36bb7eba175UL;
   tf->codes[6365] = 0x0000e36e769fe6b1UL;
   tf->codes[6366] = 0x0000e37727dac1efUL;
   tf->codes[6367] = 0x0000e379e68f072bUL;
   tf->codes[6368] = 0x0000e37a963c187aUL;
   tf->codes[6369] = 0x0000e37bf5963b18UL;
   tf->codes[6370] = 0x0000e37c302540ddUL;
   tf->codes[6371] = 0x0000e37c6ab446a2UL;
   tf->codes[6372] = 0x0000e37cdfd2522cUL;
   tf->codes[6373] = 0x0000e37dca0e6940UL;
   tf->codes[6374] = 0x0000e37fd9159d2dUL;
   tf->codes[6375] = 0x0000e3804e33a8b7UL;
   tf->codes[6376] = 0x0000e380c351b441UL;
   tf->codes[6377] = 0x0000e381e81cd11aUL;
   tf->codes[6378] = 0x0000e385567e27a5UL;
   tf->codes[6379] = 0x0000e38765855b92UL;
   tf->codes[6380] = 0x0000e38eb7661432UL;
   tf->codes[6381] = 0x0000e39016c036d0UL;
   tf->codes[6382] = 0x0000e393100381d1UL;
   tf->codes[6383] = 0x0000e394a9ecaa34UL;
   tf->codes[6384] = 0x0000e3955999bb83UL;
   tf->codes[6385] = 0x0000e3959428c148UL;
   tf->codes[6386] = 0x0000e39643d5d297UL;
   tf->codes[6387] = 0x0000e3967e64d85cUL;
   tf->codes[6388] = 0x0000e39a9c734036UL;
   tf->codes[6389] = 0x0000e39ce60979e8UL;
   tf->codes[6390] = 0x0000e39d95b68b37UL;
   tf->codes[6391] = 0x0000e3a019dbcaaeUL;
   tf->codes[6392] = 0x0000e3a08ef9d638UL;
   tf->codes[6393] = 0x0000e3a4e79743d7UL;
   tf->codes[6394] = 0x0000e3a646f16675UL;
   tf->codes[6395] = 0x0000e3a9b552bd00UL;
   tf->codes[6396] = 0x0000e3aada1dd9d9UL;
   tf->codes[6397] = 0x0000e3ab14acdf9eUL;
   tf->codes[6398] = 0x0000e3abc459f0edUL;
   tf->codes[6399] = 0x0000e3b1073375a0UL;
   tf->codes[6400] = 0x0000e3b3163aa98dUL;
   tf->codes[6401] = 0x0000e3b40076c0a1UL;
   tf->codes[6402] = 0x0000e3b43b05c666UL;
   tf->codes[6403] = 0x0000e3b60f7df48eUL;
   tf->codes[6404] = 0x0000e3b6f9ba0ba2UL;
   tf->codes[6405] = 0x0000e3b76ed8172cUL;
   tf->codes[6406] = 0x0000e3b943504554UL;
   tf->codes[6407] = 0x0000e3ba681b622dUL;
   tf->codes[6408] = 0x0000e3baa2aa67f2UL;
   tf->codes[6409] = 0x0000e3bdd67cb8b8UL;
   tf->codes[6410] = 0x0000e3be4b9ac442UL;
   tf->codes[6411] = 0x0000e3c17f6d1508UL;
   tf->codes[6412] = 0x0000e3c4edce6b93UL;
   tf->codes[6413] = 0x0000e3c5d80a82a7UL;
   tf->codes[6414] = 0x0000e3c771f3ab0aUL;
   tf->codes[6415] = 0x0000e3c90bdcd36dUL;
   tf->codes[6416] = 0x0000e3c9bb89e4bcUL;
   tf->codes[6417] = 0x0000e3ca6b36f60bUL;
   tf->codes[6418] = 0x0000e3d147f9a321UL;
   tf->codes[6419] = 0x0000e3d23235ba35UL;
   tf->codes[6420] = 0x0000e3d3918fdcd3UL;
   tf->codes[6421] = 0x0000e3d4f0e9ff71UL;
   tf->codes[6422] = 0x0000e3d566080afbUL;
   tf->codes[6423] = 0x0000e3d65044220fUL;
   tf->codes[6424] = 0x0000e3d85f4b55fcUL;
   tf->codes[6425] = 0x0000e3d8d4696186UL;
   tf->codes[6426] = 0x0000e3d9bea5789aUL;
   tf->codes[6427] = 0x0000e3da33c38424UL;
   tf->codes[6428] = 0x0000e3dda224daafUL;
   tf->codes[6429] = 0x0000e3df3c0e0312UL;
   tf->codes[6430] = 0x0000e3e0d5f72b75UL;
   tf->codes[6431] = 0x0000e3e1c0334289UL;
   tf->codes[6432] = 0x0000e3e5a3b2a49eUL;
   tf->codes[6433] = 0x0000e3e7030cc73cUL;
   tf->codes[6434] = 0x0000e3e7ed48de50UL;
   tf->codes[6435] = 0x0000e3ea716e1dc7UL;
   tf->codes[6436] = 0x0000e3eb5baa34dbUL;
   tf->codes[6437] = 0x0000e3ee8f7c85a1UL;
   tf->codes[6438] = 0x0000e3ef3f2996f0UL;
   tf->codes[6439] = 0x0000e3f188bfd0a2UL;
   tf->codes[6440] = 0x0000e3f35d37fecaUL;
   tf->codes[6441] = 0x0000e3f3d2560a54UL;
   tf->codes[6442] = 0x0000e3f40ce51019UL;
   tf->codes[6443] = 0x0000e3f482031ba3UL;
   tf->codes[6444] = 0x0000e3f5e15d3e41UL;
   tf->codes[6445] = 0x0000e3f6567b49cbUL;
   tf->codes[6446] = 0x0000e3f6910a4f90UL;
   tf->codes[6447] = 0x0000e3f6cb995555UL;
   tf->codes[6448] = 0x0000e3f740b760dfUL;
   tf->codes[6449] = 0x0000e3fcf8aef11cUL;
   tf->codes[6450] = 0x0000e402b0a68159UL;
   tf->codes[6451] = 0x0000e403605392a8UL;
   tf->codes[6452] = 0x0000e404851eaf81UL;
   tf->codes[6453] = 0x0000e404bfadb546UL;
   tf->codes[6454] = 0x0000e4061f07d7e4UL;
   tf->codes[6455] = 0x0000e4098d692e6fUL;
   tf->codes[6456] = 0x0000e4102f9cd5c0UL;
   tf->codes[6457] = 0x0000e4106a2bdb85UL;
   tf->codes[6458] = 0x0000e410a4bae14aUL;
   tf->codes[6459] = 0x0000e4118ef6f85eUL;
   tf->codes[6460] = 0x0000e411c985fe23UL;
   tf->codes[6461] = 0x0000e412041503e8UL;
   tf->codes[6462] = 0x0000e4139dfe2c4bUL;
   tf->codes[6463] = 0x0000e41572765a73UL;
   tf->codes[6464] = 0x0000e417f69b99eaUL;
   tf->codes[6465] = 0x0000e418312a9fafUL;
   tf->codes[6466] = 0x0000e4191b66b6c3UL;
   tf->codes[6467] = 0x0000e41955f5bc88UL;
   tf->codes[6468] = 0x0000e4199084c24dUL;
   tf->codes[6469] = 0x0000e41a4031d39cUL;
   tf->codes[6470] = 0x0000e41aefdee4ebUL;
   tf->codes[6471] = 0x0000e41b2a6deab0UL;
   tf->codes[6472] = 0x0000e41bda1afbffUL;
   tf->codes[6473] = 0x0000e41cc4571313UL;
   tf->codes[6474] = 0x0000e41d74042462UL;
   tf->codes[6475] = 0x0000e41dae932a27UL;
   tf->codes[6476] = 0x0000e41ed35e4700UL;
   tf->codes[6477] = 0x0000e41f487c528aUL;
   tf->codes[6478] = 0x0000e41f830b584fUL;
   tf->codes[6479] = 0x0000e41fbd9a5e14UL;
   tf->codes[6480] = 0x0000e420e2657aedUL;
   tf->codes[6481] = 0x0000e423668aba64UL;
   tf->codes[6482] = 0x0000e4241637cbb3UL;
   tf->codes[6483] = 0x0000e425b020f416UL;
   tf->codes[6484] = 0x0000e425eaaff9dbUL;
   tf->codes[6485] = 0x0000e4270f7b16b4UL;
   tf->codes[6486] = 0x0000e429ce2f5bf0UL;
   tf->codes[6487] = 0x0000e42ab86b7304UL;
   tf->codes[6488] = 0x0000e42bdd368fddUL;
   tf->codes[6489] = 0x0000e43035d3fd7cUL;
   tf->codes[6490] = 0x0000e434c90070e0UL;
   tf->codes[6491] = 0x0000e43578ad822fUL;
   tf->codes[6492] = 0x0000e435b33c87f4UL;
   tf->codes[6493] = 0x0000e438e70ed8baUL;
   tf->codes[6494] = 0x0000e43996bbea09UL;
   tf->codes[6495] = 0x0000e43a0bd9f593UL;
   tf->codes[6496] = 0x0000e43a4668fb58UL;
   tf->codes[6497] = 0x0000e43a80f8011dUL;
   tf->codes[6498] = 0x0000e43be05223bbUL;
   tf->codes[6499] = 0x0000e43e29e85d6dUL;
   tf->codes[6500] = 0x0000e43ed9956ebcUL;
   tf->codes[6501] = 0x0000e43f14247481UL;
   tf->codes[6502] = 0x0000e43f8942800bUL;
   tf->codes[6503] = 0x0000e43ffe608b95UL;
   tf->codes[6504] = 0x0000e440737e971fUL;
   tf->codes[6505] = 0x0000e4428285cb0cUL;
   tf->codes[6506] = 0x0000e4433232dc5bUL;
   tf->codes[6507] = 0x0000e44715b23e70UL;
   tf->codes[6508] = 0x0000e44a49848f36UL;
   tf->codes[6509] = 0x0000e44abea29ac0UL;
   tf->codes[6510] = 0x0000e450ebb83687UL;
   tf->codes[6511] = 0x0000e4524b125925UL;
   tf->codes[6512] = 0x0000e45285a15eeaUL;
   tf->codes[6513] = 0x0000e453354e7039UL;
   tf->codes[6514] = 0x0000e455b973afb0UL;
   tf->codes[6515] = 0x0000e455f402b575UL;
   tf->codes[6516] = 0x0000e45babfa45b2UL;
   tf->codes[6517] = 0x0000e45d0b546850UL;
   tf->codes[6518] = 0x0000e45d807273daUL;
   tf->codes[6519] = 0x0000e45ea53d90b3UL;
   tf->codes[6520] = 0x0000e45f8f79a7c7UL;
   tf->codes[6521] = 0x0000e4600497b351UL;
   tf->codes[6522] = 0x0000e46288bcf2c8UL;
   tf->codes[6523] = 0x0000e46372f909dcUL;
   tf->codes[6524] = 0x0000e463e8171566UL;
   tf->codes[6525] = 0x0000e464d2532c7aUL;
   tf->codes[6526] = 0x0000e46756786bf1UL;
   tf->codes[6527] = 0x0000e467910771b6UL;
   tf->codes[6528] = 0x0000e469a00ea5a3UL;
   tf->codes[6529] = 0x0000e46a152cb12dUL;
   tf->codes[6530] = 0x0000e46baf15d990UL;
   tf->codes[6531] = 0x0000e46e6dca1eccUL;
   tf->codes[6532] = 0x0000e46f92953ba5UL;
   tf->codes[6533] = 0x0000e46fcd24416aUL;
   tf->codes[6534] = 0x0000e4712c7e6408UL;
   tf->codes[6535] = 0x0000e4746050b4ceUL;
   tf->codes[6536] = 0x0000e4766f57e8bbUL;
   tf->codes[6537] = 0x0000e478f37d2832UL;
   tf->codes[6538] = 0x0000e479689b33bcUL;
   tf->codes[6539] = 0x0000e47a8d665095UL;
   tf->codes[6540] = 0x0000e47b3d1361e4UL;
   tf->codes[6541] = 0x0000e47d118b900cUL;
   tf->codes[6542] = 0x0000e47e70e5b2aaUL;
   tf->codes[6543] = 0x0000e47f95b0cf83UL;
   tf->codes[6544] = 0x0000e47fd03fd548UL;
   tf->codes[6545] = 0x0000e480455de0d2UL;
   tf->codes[6546] = 0x0000e4816a28fdabUL;
   tf->codes[6547] = 0x0000e481a4b80370UL;
   tf->codes[6548] = 0x0000e482546514bfUL;
   tf->codes[6549] = 0x0000e483b3bf375dUL;
   tf->codes[6550] = 0x0000e486e7918823UL;
   tf->codes[6551] = 0x0000e487d1cd9f37UL;
   tf->codes[6552] = 0x0000e488f698bc10UL;
   tf->codes[6553] = 0x0000e489e0d4d324UL;
   tf->codes[6554] = 0x0000e48a55f2deaeUL;
   tf->codes[6555] = 0x0000e48b402ef5c2UL;
   tf->codes[6556] = 0x0000e48bb54d014cUL;
   tf->codes[6557] = 0x0000e48fd35b6926UL;
   tf->codes[6558] = 0x0000e490487974b0UL;
   tf->codes[6559] = 0x0000e490bd97803aUL;
   tf->codes[6560] = 0x0000e4916d449189UL;
   tf->codes[6561] = 0x0000e492920fae62UL;
   tf->codes[6562] = 0x0000e493072db9ecUL;
   tf->codes[6563] = 0x0000e493f169d100UL;
   tf->codes[6564] = 0x0000e4963b000ab2UL;
   tf->codes[6565] = 0x0000e496eaad1c01UL;
   tf->codes[6566] = 0x0000e4984a073e9fUL;
   tf->codes[6567] = 0x0000e499e3f06702UL;
   tf->codes[6568] = 0x0000e49b08bb83dbUL;
   tf->codes[6569] = 0x0000e4a086240e53UL;
   tf->codes[6570] = 0x0000e4a2200d36b6UL;
   tf->codes[6571] = 0x0000e4a37f675954UL;
   tf->codes[6572] = 0x0000e4a7d804c6f3UL;
   tf->codes[6573] = 0x0000e4a887b1d842UL;
   tf->codes[6574] = 0x0000e4aa219b00a5UL;
   tf->codes[6575] = 0x0000e4abf6132ecdUL;
   tf->codes[6576] = 0x0000e4af29e57f93UL;
   tf->codes[6577] = 0x0000e4af64748558UL;
   tf->codes[6578] = 0x0000e4b0893fa231UL;
   tf->codes[6579] = 0x0000e4b0c3cea7f6UL;
   tf->codes[6580] = 0x0000e4b138ecb380UL;
   tf->codes[6581] = 0x0000e4b347f3e76dUL;
   tf->codes[6582] = 0x0000e4b3f7a0f8bcUL;
   tf->codes[6583] = 0x0000e4b5918a211fUL;
   tf->codes[6584] = 0x0000e4b64137326eUL;
   tf->codes[6585] = 0x0000e4b6f0e443bdUL;
   tf->codes[6586] = 0x0000e4b7a091550cUL;
   tf->codes[6587] = 0x0000e4b815af6096UL;
   tf->codes[6588] = 0x0000e4b8ffeb77aaUL;
   tf->codes[6589] = 0x0000e4b93a7a7d6fUL;
   tf->codes[6590] = 0x0000e4bb8410b721UL;
   tf->codes[6591] = 0x0000e4bbf92ec2abUL;
   tf->codes[6592] = 0x0000e4beb7e307e7UL;
   tf->codes[6593] = 0x0000e4bf2d011371UL;
   tf->codes[6594] = 0x0000e4bf67901936UL;
   tf->codes[6595] = 0x0000e4c0c6ea3bd4UL;
   tf->codes[6596] = 0x0000e4c1b12652e8UL;
   tf->codes[6597] = 0x0000e4c88de8fffeUL;
   tf->codes[6598] = 0x0000e4c93d96114dUL;
   tf->codes[6599] = 0x0000e4cb120e3f75UL;
   tf->codes[6600] = 0x0000e4cbc1bb50c4UL;
   tf->codes[6601] = 0x0000e4cf301ca74fUL;
   tf->codes[6602] = 0x0000e4d08f76c9edUL;
   tf->codes[6603] = 0x0000e4d179b2e101UL;
   tf->codes[6604] = 0x0000e4d263eef815UL;
   tf->codes[6605] = 0x0000e4d43867263dUL;
   tf->codes[6606] = 0x0000e4d6476e5a2aUL;
   tf->codes[6607] = 0x0000e4d906229f66UL;
   tf->codes[6608] = 0x0000e4db4fb8d918UL;
   tf->codes[6609] = 0x0000e4dc39f4f02cUL;
   tf->codes[6610] = 0x0000e4dd994f12caUL;
   tf->codes[6611] = 0x0000e4e0cd216390UL;
   tf->codes[6612] = 0x0000e4e1f1ec8069UL;
   tf->codes[6613] = 0x0000e4e22c7b862eUL;
   tf->codes[6614] = 0x0000e4e316b79d42UL;
   tf->codes[6615] = 0x0000e4e943cd3909UL;
   tf->codes[6616] = 0x0000e4e97e5c3eceUL;
   tf->codes[6617] = 0x0000e4e9f37a4a58UL;
   tf->codes[6618] = 0x0000e4eb18456731UL;
   tf->codes[6619] = 0x0000e4eefbc4c946UL;
   tf->codes[6620] = 0x0000e4f05b1eebe4UL;
   tf->codes[6621] = 0x0000e4f0d03cf76eUL;
   tf->codes[6622] = 0x0000e4f1455b02f8UL;
   tf->codes[6623] = 0x0000e4f26a261fd1UL;
   tf->codes[6624] = 0x0000e4f3546236e5UL;
   tf->codes[6625] = 0x0000e4f64da581e6UL;
   tf->codes[6626] = 0x0000e4fdda15404bUL;
   tf->codes[6627] = 0x0000e4ffe91c7438UL;
   tf->codes[6628] = 0x0000e50023ab79fdUL;
   tf->codes[6629] = 0x0000e5005e3a7fc2UL;
   tf->codes[6630] = 0x0000e501f823a825UL;
   tf->codes[6631] = 0x0000e5026d41b3afUL;
   tf->codes[6632] = 0x0000e503920cd088UL;
   tf->codes[6633] = 0x0000e50650c115c4UL;
   tf->codes[6634] = 0x0000e5068b501b89UL;
   tf->codes[6635] = 0x0000e508d4e6553bUL;
   tf->codes[6636] = 0x0000e5090f755b00UL;
   tf->codes[6637] = 0x0000e50bce29a03cUL;
   tf->codes[6638] = 0x0000e5114b922ab4UL;
   tf->codes[6639] = 0x0000e511c0b0363eUL;
   tf->codes[6640] = 0x0000e513200a58dcUL;
   tf->codes[6641] = 0x0000e516194da3ddUL;
   tf->codes[6642] = 0x0000e51653dca9a2UL;
   tf->codes[6643] = 0x0000e518d801e919UL;
   tf->codes[6644] = 0x0000e51a375c0bb7UL;
   tf->codes[6645] = 0x0000e51aac7a1741UL;
   tf->codes[6646] = 0x0000e51ae7091d06UL;
   tf->codes[6647] = 0x0000e51c0bd439dfUL;
   tf->codes[6648] = 0x0000e51da5bd6242UL;
   tf->codes[6649] = 0x0000e51f7a35906aUL;
   tf->codes[6650] = 0x0000e5206471a77eUL;
   tf->codes[6651] = 0x0000e521893cc457UL;
   tf->codes[6652] = 0x0000e522ae07e130UL;
   tf->codes[6653] = 0x0000e5235db4f27fUL;
   tf->codes[6654] = 0x0000e523d2d2fe09UL;
   tf->codes[6655] = 0x0000e52447f10993UL;
   tf->codes[6656] = 0x0000e525e1da31f6UL;
   tf->codes[6657] = 0x0000e5277bc35a59UL;
   tf->codes[6658] = 0x0000e52a7506a55aUL;
   tf->codes[6659] = 0x0000e52aaf95ab1fUL;
   tf->codes[6660] = 0x0000e52e5886076fUL;
   tf->codes[6661] = 0x0000e530678d3b5cUL;
   tf->codes[6662] = 0x0000e530a21c4121UL;
   tf->codes[6663] = 0x0000e533d5ee91e7UL;
   tf->codes[6664] = 0x0000e5361f84cb99UL;
   tf->codes[6665] = 0x0000e5365a13d15eUL;
   tf->codes[6666] = 0x0000e5398de62224UL;
   tf->codes[6667] = 0x0000e53a78223938UL;
   tf->codes[6668] = 0x0000e53ab2b13efdUL;
   tf->codes[6669] = 0x0000e53e9630a112UL;
   tf->codes[6670] = 0x0000e53f806cb826UL;
   tf->codes[6671] = 0x0000e5403019c975UL;
   tf->codes[6672] = 0x0000e5418f73ec13UL;
   tf->codes[6673] = 0x0000e541ca02f1d8UL;
   tf->codes[6674] = 0x0000e54279b00327UL;
   tf->codes[6675] = 0x0000e5444e28314fUL;
   tf->codes[6676] = 0x0000e545ad8253edUL;
   tf->codes[6677] = 0x0000e545e81159b2UL;
   tf->codes[6678] = 0x0000e54622a05f77UL;
   tf->codes[6679] = 0x0000e5486c369929UL;
   tf->codes[6680] = 0x0000e5499101b602UL;
   tf->codes[6681] = 0x0000e54a40aec751UL;
   tf->codes[6682] = 0x0000e54a7b3dcd16UL;
   tf->codes[6683] = 0x0000e54ab5ccd2dbUL;
   tf->codes[6684] = 0x0000e54f0e6a407aUL;
   tf->codes[6685] = 0x0000e5506dc46318UL;
   tf->codes[6686] = 0x0000e550a85368ddUL;
   tf->codes[6687] = 0x0000e55207ad8b7bUL;
   tf->codes[6688] = 0x0000e55416b4bf68UL;
   tf->codes[6689] = 0x0000e557bfa51bb8UL;
   tf->codes[6690] = 0x0000e557fa34217dUL;
   tf->codes[6691] = 0x0000e55b68957808UL;
   tf->codes[6692] = 0x0000e55ba3247dcdUL;
   tf->codes[6693] = 0x0000e55c18428957UL;
   tf->codes[6694] = 0x0000e562ba7630a8UL;
   tf->codes[6695] = 0x0000e5632f943c32UL;
   tf->codes[6696] = 0x0000e565792a75e4UL;
   tf->codes[6697] = 0x0000e566d8849882UL;
   tf->codes[6698] = 0x0000e57123a89c23UL;
   tf->codes[6699] = 0x0000e574cc98f873UL;
   tf->codes[6700] = 0x0000e5750727fe38UL;
   tf->codes[6701] = 0x0000e578758954c3UL;
   tf->codes[6702] = 0x0000e578b0185a88UL;
   tf->codes[6703] = 0x0000e578eaa7604dUL;
   tf->codes[6704] = 0x0000e5795fc56bd7UL;
   tf->codes[6705] = 0x0000e57af9ae943aUL;
   tf->codes[6706] = 0x0000e57be3eaab4eUL;
   tf->codes[6707] = 0x0000e57c5908b6d8UL;
   tf->codes[6708] = 0x0000e57d08b5c827UL;
   tf->codes[6709] = 0x0000e57ea29ef08aUL;
   tf->codes[6710] = 0x0000e58001f91328UL;
   tf->codes[6711] = 0x0000e58211004715UL;
   tf->codes[6712] = 0x0000e58335cb63eeUL;
   tf->codes[6713] = 0x0000e583e578753dUL;
   tf->codes[6714] = 0x0000e5845a9680c7UL;
   tf->codes[6715] = 0x0000e585b9f0a365UL;
   tf->codes[6716] = 0x0000e5883e15e2dcUL;
   tf->codes[6717] = 0x0000e58a128e1104UL;
   tf->codes[6718] = 0x0000e58be7063f2cUL;
   tf->codes[6719] = 0x0000e591646ec9a4UL;
   tf->codes[6720] = 0x0000e591d98cd52eUL;
   tf->codes[6721] = 0x0000e593ae050356UL;
   tf->codes[6722] = 0x0000e595bd0c3743UL;
   tf->codes[6723] = 0x0000e5971c6659e1UL;
   tf->codes[6724] = 0x0000e59cd45dea1eUL;
   tf->codes[6725] = 0x0000e59d840afb6dUL;
   tf->codes[6726] = 0x0000e59f58832995UL;
   tf->codes[6727] = 0x0000e5a0f26c51f8UL;
   tf->codes[6728] = 0x0000e5a9a3a72d36UL;
   tf->codes[6729] = 0x0000e5aa8de3444aUL;
   tf->codes[6730] = 0x0000e5af962dc338UL;
   tf->codes[6731] = 0x0000e5afd0bcc8fdUL;
   tf->codes[6732] = 0x0000e5b045dad487UL;
   tf->codes[6733] = 0x0000e5b0baf8e011UL;
   tf->codes[6734] = 0x0000e5b13016eb9bUL;
   tf->codes[6735] = 0x0000e5b28f710e39UL;
   tf->codes[6736] = 0x0000e5b33f1e1f88UL;
   tf->codes[6737] = 0x0000e5b4295a369cUL;
   tf->codes[6738] = 0x0000e5b49e784226UL;
   tf->codes[6739] = 0x0000e5b672f0704eUL;
   tf->codes[6740] = 0x0000e5b6e80e7bd8UL;
   tf->codes[6741] = 0x0000e5b7229d819dUL;
   tf->codes[6742] = 0x0000e5ba90fed828UL;
   tf->codes[6743] = 0x0000e5bf242b4b8cUL;
   tf->codes[6744] = 0x0000e5c00e6762a0UL;
   tf->codes[6745] = 0x0000e5c2928ca217UL;
   tf->codes[6746] = 0x0000e5c2cd1ba7dcUL;
   tf->codes[6747] = 0x0000e5c34239b366UL;
   tf->codes[6748] = 0x0000e5c600edf8a2UL;
   tf->codes[6749] = 0x0000e5c63b7cfe67UL;
   tf->codes[6750] = 0x0000e5d01182f67eUL;
   tf->codes[6751] = 0x0000e5d0c13007cdUL;
   tf->codes[6752] = 0x0000e5d1e5fb24a6UL;
   tf->codes[6753] = 0x0000e5d3f5025893UL;
   tf->codes[6754] = 0x0000e5d42f915e58UL;
   tf->codes[6755] = 0x0000e5d81310c06dUL;
   tf->codes[6756] = 0x0000e5d84d9fc632UL;
   tf->codes[6757] = 0x0000e5dd90794ae5UL;
   tf->codes[6758] = 0x0000e5ddcb0850aaUL;
   tf->codes[6759] = 0x0000e5de40265c34UL;
   tf->codes[6760] = 0x0000e5e1ae87b2bfUL;
   tf->codes[6761] = 0x0000e5e1e916b884UL;
   tf->codes[6762] = 0x0000e5e30de1d55dUL;
   tf->codes[6763] = 0x0000e5e3bd8ee6acUL;
   tf->codes[6764] = 0x0000e5e557780f0fUL;
   tf->codes[6765] = 0x0000e5e67c432be8UL;
   tf->codes[6766] = 0x0000e5e7a10e48c1UL;
   tf->codes[6767] = 0x0000e5e93af77124UL;
   tf->codes[6768] = 0x0000e5ea25338838UL;
   tf->codes[6769] = 0x0000e5ebbf1cb09bUL;
   tf->codes[6770] = 0x0000e5ee4341f012UL;
   tf->codes[6771] = 0x0000e5f101f6354eUL;
   tf->codes[6772] = 0x0000e5f644cfba01UL;
   tf->codes[6773] = 0x0000e5f93e130502UL;
   tf->codes[6774] = 0x0000e5fa284f1c16UL;
   tf->codes[6775] = 0x0000e5fa9d6d27a0UL;
   tf->codes[6776] = 0x0000e5fad7fc2d65UL;
   tf->codes[6777] = 0x0000e5fcac745b8dUL;
   tf->codes[6778] = 0x0000e6029efaf18fUL;
   tf->codes[6779] = 0x0000e607a745707dUL;
   tf->codes[6780] = 0x0000e60adb17c143UL;
   tf->codes[6781] = 0x0000e61058804bbbUL;
   tf->codes[6782] = 0x0000e61142bc62cfUL;
   tf->codes[6783] = 0x0000e6117d4b6894UL;
   tf->codes[6784] = 0x0000e6164b06e1bdUL;
   tf->codes[6785] = 0x0000e616fab3f30cUL;
   tf->codes[6786] = 0x0000e6181f7f0fe5UL;
   tf->codes[6787] = 0x0000e6185a0e15aaUL;
   tf->codes[6788] = 0x0000e61b535160abUL;
   tf->codes[6789] = 0x0000e61efc41bcfbUL;
   tf->codes[6790] = 0x0000e61fe67dd40fUL;
   tf->codes[6791] = 0x0000e620210cd9d4UL;
   tf->codes[6792] = 0x0000e623c9fd3624UL;
   tf->codes[6793] = 0x0000e6243f1b41aeUL;
   tf->codes[6794] = 0x0000e6264e22759bUL;
   tf->codes[6795] = 0x0000e62772ed9274UL;
   tf->codes[6796] = 0x0000e62bcb8b0013UL;
   tf->codes[6797] = 0x0000e6309946793cUL;
   tf->codes[6798] = 0x0000e6326dbea764UL;
   tf->codes[6799] = 0x0000e6331d6bb8b3UL;
   tf->codes[6800] = 0x0000e633cd18ca02UL;
   tf->codes[6801] = 0x0000e634f1e3e6dbUL;
   tf->codes[6802] = 0x0000e635a190f82aUL;
   tf->codes[6803] = 0x0000e637eb2731dcUL;
   tf->codes[6804] = 0x0000e63c093599b6UL;
   tf->codes[6805] = 0x0000e63c43c49f7bUL;
   tf->codes[6806] = 0x0000e63da31ec219UL;
   tf->codes[6807] = 0x0000e63e52cbd368UL;
   tf->codes[6808] = 0x0000e63ec7e9def2UL;
   tf->codes[6809] = 0x0000e641fbbc2fb8UL;
   tf->codes[6810] = 0x0000e642364b357dUL;
   tf->codes[6811] = 0x0000e642e5f846ccUL;
   tf->codes[6812] = 0x0000e6486360d144UL;
   tf->codes[6813] = 0x0000e64f40237e5aUL;
   tf->codes[6814] = 0x0000e6502a5f956eUL;
   tf->codes[6815] = 0x0000e65064ee9b33UL;
   tf->codes[6816] = 0x0000e6509f7da0f8UL;
   tf->codes[6817] = 0x0000e65189b9b80cUL;
   tf->codes[6818] = 0x0000e65273f5cf20UL;
   tf->codes[6819] = 0x0000e65323a2e06fUL;
   tf->codes[6820] = 0x0000e6535e31e634UL;
   tf->codes[6821] = 0x0000e658667c6522UL;
   tf->codes[6822] = 0x0000e65b2530aa5eUL;
   tf->codes[6823] = 0x0000e6602d7b294cUL;
   tf->codes[6824] = 0x0000e660dd283a9bUL;
   tf->codes[6825] = 0x0000e662b1a068c3UL;
   tf->codes[6826] = 0x0000e663614d7a12UL;
   tf->codes[6827] = 0x0000e664861896ebUL;
   tf->codes[6828] = 0x0000e664fb36a275UL;
   tf->codes[6829] = 0x0000e66aedbd3877UL;
   tf->codes[6830] = 0x0000e6706b25c2efUL;
   tf->codes[6831] = 0x0000e670a5b4c8b4UL;
   tf->codes[6832] = 0x0000e672050eeb52UL;
   tf->codes[6833] = 0x0000e672ef4b0266UL;
   tf->codes[6834] = 0x0000e67414161f3fUL;
   tf->codes[6835] = 0x0000e674fe523653UL;
   tf->codes[6836] = 0x0000e6765dac58f1UL;
   tf->codes[6837] = 0x0000e678a74292a3UL;
   tf->codes[6838] = 0x0000e67ab649c690UL;
   tf->codes[6839] = 0x0000e67c8ac1f4b8UL;
   tf->codes[6840] = 0x0000e67d74fe0bccUL;
   tf->codes[6841] = 0x0000e67e5f3a22e0UL;
   tf->codes[6842] = 0x0000e6806e4156cdUL;
   tf->codes[6843] = 0x0000e6836784a1ceUL;
   tf->codes[6844] = 0x0000e687859309a8UL;
   tf->codes[6845] = 0x0000e68b2e8365f8UL;
   tf->codes[6846] = 0x0000e68b69126bbdUL;
   tf->codes[6847] = 0x0000e68ed773c248UL;
   tf->codes[6848] = 0x0000e690715ceaabUL;
   tf->codes[6849] = 0x0000e6920b46130eUL;
   tf->codes[6850] = 0x0000e693a52f3b71UL;
   tf->codes[6851] = 0x0000e69788ae9d86UL;
   tf->codes[6852] = 0x0000e69af70ff411UL;
   tf->codes[6853] = 0x0000e69b319ef9d6UL;
   tf->codes[6854] = 0x0000e69ea0005061UL;
   tf->codes[6855] = 0x0000e69eda8f5626UL;
   tf->codes[6856] = 0x0000e69f151e5bebUL;
   tf->codes[6857] = 0x0000e6a15eb4959dUL;
   tf->codes[6858] = 0x0000e6a199439b62UL;
   tf->codes[6859] = 0x0000e6a36dbbc98aUL;
   tf->codes[6860] = 0x0000e6a62c700ec6UL;
   tf->codes[6861] = 0x0000e6a666ff148bUL;
   tf->codes[6862] = 0x0000e6aa0fef70dbUL;
   tf->codes[6863] = 0x0000e6aafa2b87efUL;
   tf->codes[6864] = 0x0000e6ae2dfdd8b5UL;
   tf->codes[6865] = 0x0000e6b0027606ddUL;
   tf->codes[6866] = 0x0000e6b1274123b6UL;
   tf->codes[6867] = 0x0000e6b161d0297bUL;
   tf->codes[6868] = 0x0000e6b62f8ba2a4UL;
   tf->codes[6869] = 0x0000e6b87921dc56UL;
   tf->codes[6870] = 0x0000e6b9d87bfef4UL;
   tf->codes[6871] = 0x0000e6ba4d9a0a7eUL;
   tf->codes[6872] = 0x0000e6bac2b81608UL;
   tf->codes[6873] = 0x0000e6bbe78332e1UL;
   tf->codes[6874] = 0x0000e6bdbbfb6109UL;
   tf->codes[6875] = 0x0000e6bf55e4896cUL;
   tf->codes[6876] = 0x0000e6bfcb0294f6UL;
   tf->codes[6877] = 0x0000e6c005919abbUL;
   tf->codes[6878] = 0x0000e6c12a5cb794UL;
   tf->codes[6879] = 0x0000e6c3ae81f70bUL;
   tf->codes[6880] = 0x0000e6c45e2f085aUL;
   tf->codes[6881] = 0x0000e6c632a73682UL;
   tf->codes[6882] = 0x0000e6c792015920UL;
   tf->codes[6883] = 0x0000e6cb3af1b570UL;
   tf->codes[6884] = 0x0000e6d0433c345eUL;
   tf->codes[6885] = 0x0000e6d168075137UL;
   tf->codes[6886] = 0x0000e6d1dd255cc1UL;
   tf->codes[6887] = 0x0000e6d58615b911UL;
   tf->codes[6888] = 0x0000e6d5fb33c49bUL;
   tf->codes[6889] = 0x0000e6d75a8de739UL;
   tf->codes[6890] = 0x0000e6db037e4389UL;
   tf->codes[6891] = 0x0000e6ddfcc18e8aUL;
   tf->codes[6892] = 0x0000e6deac6e9fd9UL;
   tf->codes[6893] = 0x0000e6e2555efc29UL;
   tf->codes[6894] = 0x0000e6e33f9b133dUL;
   tf->codes[6895] = 0x0000e6e37a2a1902UL;
   tf->codes[6896] = 0x0000e6e3b4b91ec7UL;
   tf->codes[6897] = 0x0000e6e6736d6403UL;
   tf->codes[6898] = 0x0000e6e75da97b17UL;
   tf->codes[6899] = 0x0000e6e7983880dcUL;
   tf->codes[6900] = 0x0000e6ea917bcbddUL;
   tf->codes[6901] = 0x0000e6eca082ffcaUL;
   tf->codes[6902] = 0x0000e6f21deb8a42UL;
   tf->codes[6903] = 0x0000e6f342b6a71bUL;
   tf->codes[6904] = 0x0000e6f58c4ce0cdUL;
   tf->codes[6905] = 0x0000e6f726360930UL;
   tf->codes[6906] = 0x0000e6f9353d3d1dUL;
   tf->codes[6907] = 0x0000e6f9aa5b48a7UL;
   tf->codes[6908] = 0x0000e6fb09b56b45UL;
   tf->codes[6909] = 0x0000e6fb4444710aUL;
   tf->codes[6910] = 0x0000e6fcde2d996dUL;
   tf->codes[6911] = 0x0000e6fe3d87bc0bUL;
   tf->codes[6912] = 0x0000e7004c8eeff8UL;
   tf->codes[6913] = 0x0000e700c1acfb82UL;
   tf->codes[6914] = 0x0000e701e678185bUL;
   tf->codes[6915] = 0x0000e7051a4a6921UL;
   tf->codes[6916] = 0x0000e7058f6874abUL;
   tf->codes[6917] = 0x0000e70604868035UL;
   tf->codes[6918] = 0x0000e7079e6fa898UL;
   tf->codes[6919] = 0x0000e70888abbfacUL;
   tf->codes[6920] = 0x0000e7093858d0fbUL;
   tf->codes[6921] = 0x0000e709e805e24aUL;
   tf->codes[6922] = 0x0000e7108a39899bUL;
   tf->codes[6923] = 0x0000e714a847f175UL;
   tf->codes[6924] = 0x0000e71b850a9e8bUL;
   tf->codes[6925] = 0x0000e7255b1096a2UL;
   tf->codes[6926] = 0x0000e725d02ea22cUL;
   tf->codes[6927] = 0x0000e727df35d619UL;
   tf->codes[6928] = 0x0000e729791efe7cUL;
   tf->codes[6929] = 0x0000e72bc2b5382eUL;
   tf->codes[6930] = 0x0000e72e0c4b71e0UL;
   tf->codes[6931] = 0x0000e731401dc2a6UL;
   tf->codes[6932] = 0x0000e73598bb3045UL;
   tf->codes[6933] = 0x0000e73732a458a8UL;
   tf->codes[6934] = 0x0000e738576f7581UL;
   tf->codes[6935] = 0x0000e73891fe7b46UL;
   tf->codes[6936] = 0x0000e73a6676a96eUL;
   tf->codes[6937] = 0x0000e74143395684UL;
   tf->codes[6938] = 0x0000e747aaddf810UL;
   tf->codes[6939] = 0x0000e748cfa914e9UL;
   tf->codes[6940] = 0x0000e74adeb048d6UL;
   tf->codes[6941] = 0x0000e74cb32876feUL;
   tf->codes[6942] = 0x0000e7505c18d34eUL;
   tf->codes[6943] = 0x0000e75096a7d913UL;
   tf->codes[6944] = 0x0000e751f601fbb1UL;
   tf->codes[6945] = 0x0000e75d2b621666UL;
   tf->codes[6946] = 0x0000e75d65f11c2bUL;
   tf->codes[6947] = 0x0000e761f91d8f8fUL;
   tf->codes[6948] = 0x0000e766172bf769UL;
   tf->codes[6949] = 0x0000e76651bafd2eUL;
   tf->codes[6950] = 0x0000e7668c4a02f3UL;
   tf->codes[6951] = 0x0000e76701680e7dUL;
   tf->codes[6952] = 0x0000e767eba42591UL;
   tf->codes[6953] = 0x0000e769c01c53b9UL;
   tf->codes[6954] = 0x0000e76fed31ef80UL;
   tf->codes[6955] = 0x0000e77271572ef7UL;
   tf->codes[6956] = 0x0000e773d0b15195UL;
   tf->codes[6957] = 0x0000e7740b40575aUL;
   tf->codes[6958] = 0x0000e775a5297fbdUL;
   tf->codes[6959] = 0x0000e7770483a25bUL;
   tf->codes[6960] = 0x0000e777eebfb96fUL;
   tf->codes[6961] = 0x0000e77aad73feabUL;
   tf->codes[6962] = 0x0000e77b22920a35UL;
   tf->codes[6963] = 0x0000e77d6c2843e7UL;
   tf->codes[6964] = 0x0000e77da6b749acUL;
   tf->codes[6965] = 0x0000e78448eaf0fdUL;
   tf->codes[6966] = 0x0000e7861d631f25UL;
   tf->codes[6967] = 0x0000e78692812aafUL;
   tf->codes[6968] = 0x0000e786cd103074UL;
   tf->codes[6969] = 0x0000e787079f3639UL;
   tf->codes[6970] = 0x0000e78aeb1e984eUL;
   tf->codes[6971] = 0x0000e78e597feed9UL;
   tf->codes[6972] = 0x0000e79118343415UL;
   tf->codes[6973] = 0x0000e7923cff50eeUL;
   tf->codes[6974] = 0x0000e79536429befUL;
   tf->codes[6975] = 0x0000e796d02bc452UL;
   tf->codes[6976] = 0x0000e798a4a3f27aUL;
   tf->codes[6977] = 0x0000e7a11b4fc7f3UL;
   tf->codes[6978] = 0x0000e7a2b538f056UL;
   tf->codes[6979] = 0x0000e7a32a56fbe0UL;
   tf->codes[6980] = 0x0000e7a5e90b411cUL;
   tf->codes[6981] = 0x0000e7aa0719a8f6UL;
   tf->codes[6982] = 0x0000e7aa7c37b480UL;
   tf->codes[6983] = 0x0000e7b0a94d5047UL;
   tf->codes[6984] = 0x0000e7b3a2909b48UL;
   tf->codes[6985] = 0x0000e7b417aea6d2UL;
   tf->codes[6986] = 0x0000e7b53c79c3abUL;
   tf->codes[6987] = 0x0000e7b57708c970UL;
   tf->codes[6988] = 0x0000e7b5ec26d4faUL;
   tf->codes[6989] = 0x0000e7b9cfa6370fUL;
   tf->codes[6990] = 0x0000e7bb2f0059adUL;
   tf->codes[6991] = 0x0000e7bf4d0ec187UL;
   tf->codes[6992] = 0x0000e7c0e6f7e9eaUL;
   tf->codes[6993] = 0x0000e7c36b1d2961UL;
   tf->codes[6994] = 0x0000e7c7fe499cc5UL;
   tf->codes[6995] = 0x0000e7d1d44f94dcUL;
   tf->codes[6996] = 0x0000e7d283fca62bUL;
   tf->codes[6997] = 0x0000e7d2f91ab1b5UL;
   tf->codes[6998] = 0x0000e7d49303da18UL;
   tf->codes[6999] = 0x0000e7d5f25dfcb6UL;
   tf->codes[7000] = 0x0000e7da106c6490UL;
   tf->codes[7001] = 0x0000e7db6fc6872eUL;
   tf->codes[7002] = 0x0000e7dc1f73987dUL;
   tf->codes[7003] = 0x0000e7e002f2fa92UL;
   tf->codes[7004] = 0x0000e7e2c1a73fceUL;
   tf->codes[7005] = 0x0000e7e37154511dUL;
   tf->codes[7006] = 0x0000e7e6a526a1e3UL;
   tf->codes[7007] = 0x0000e7eac33509bdUL;
   tf->codes[7008] = 0x0000e7f0409d9435UL;
   tf->codes[7009] = 0x0000e7f2c4c2d3acUL;
   tf->codes[7010] = 0x0000e7f5837718e8UL;
   tf->codes[7011] = 0x0000e7f9a18580c2UL;
   tf->codes[7012] = 0x0000e80427388a28UL;
   tf->codes[7013] = 0x0000e8054c03a701UL;
   tf->codes[7014] = 0x0000e8075b0adaeeUL;
   tf->codes[7015] = 0x0000e80dfd3e823fUL;
   tf->codes[7016] = 0x0000e811e0bde454UL;
   tf->codes[7017] = 0x0000e8130589012dUL;
   tf->codes[7018] = 0x0000e8175e266eccUL;
   tf->codes[7019] = 0x0000e81b41a5d0e1UL;
   tf->codes[7020] = 0x0000e81d8b3c0a93UL;
   tf->codes[7021] = 0x0000e81e757821a7UL;
   tf->codes[7022] = 0x0000e82258f783bcUL;
   tf->codes[7023] = 0x0000e82343339ad0UL;
   tf->codes[7024] = 0x0000e82e0375a9fbUL;
   tf->codes[7025] = 0x0000e83171d70086UL;
   tf->codes[7026] = 0x0000e8325c13179aUL;
   tf->codes[7027] = 0x0000e832d1312324UL;
   tf->codes[7028] = 0x0000e834308b45c2UL;
   tf->codes[7029] = 0x0000e8397364ca75UL;
   tf->codes[7030] = 0x0000e83b826bfe62UL;
   tf->codes[7031] = 0x0000e83eb63e4f28UL;
   tf->codes[7032] = 0x0000e8405027778bUL;
   tf->codes[7033] = 0x0000e8408ab67d50UL;
   tf->codes[7034] = 0x0000e840c5458315UL;
   tf->codes[7035] = 0x0000e843f917d3dbUL;
   tf->codes[7036] = 0x0000e845cd900203UL;
   tf->codes[7037] = 0x0000e84976805e53UL;
   tf->codes[7038] = 0x0000e84a60bc7567UL;
   tf->codes[7039] = 0x0000e84ef3e8e8cbUL;
   tf->codes[7040] = 0x0000e85018b405a4UL;
   tf->codes[7041] = 0x0000e8508dd2112eUL;
   tf->codes[7042] = 0x0000e8534c86566aUL;
   tf->codes[7043] = 0x0000e863c4bff5d2UL;
   tf->codes[7044] = 0x0000e86aa182a2e8UL;
   tf->codes[7045] = 0x0000e86b512fb437UL;
   tf->codes[7046] = 0x0000e86f34af164cUL;
   tf->codes[7047] = 0x0000e87143b64a39UL;
   tf->codes[7048] = 0x0000e873c7db89b0UL;
   tf->codes[7049] = 0x0000e876fbadda76UL;
   tf->codes[7050] = 0x0000e877e5e9f18aUL;
   tf->codes[7051] = 0x0000e87a6a0f3101UL;
   tf->codes[7052] = 0x0000e87b19bc4250UL;
   tf->codes[7053] = 0x0000e8802206c13eUL;
   tf->codes[7054] = 0x0000e882310df52bUL;
   tf->codes[7055] = 0x0000e889485fa806UL;
   tf->codes[7056] = 0x0000e88e50aa26f4UL;
   tf->codes[7057] = 0x0000e8905fb15ae1UL;
   tf->codes[7058] = 0x0000e8931e65a01dUL;
   tf->codes[7059] = 0x0000e8952d6cd40aUL;
   tf->codes[7060] = 0x0000e89567fbd9cfUL;
   tf->codes[7061] = 0x0000e897ec211946UL;
   tf->codes[7062] = 0x0000e89826b01f0bUL;
   tf->codes[7063] = 0x0000e899c099476eUL;
   tf->codes[7064] = 0x0000e8a09d5bf484UL;
   tf->codes[7065] = 0x0000e8a0d7eafa49UL;
   tf->codes[7066] = 0x0000e8a1127a000eUL;
   tf->codes[7067] = 0x0000e8a1c227115dUL;
   tf->codes[7068] = 0x0000e8a705009610UL;
   tf->codes[7069] = 0x0000e8a77a1ea19aUL;
   tf->codes[7070] = 0x0000e8a9c3b4db4cUL;
   tf->codes[7071] = 0x0000e8ae56e14eb0UL;
   tf->codes[7072] = 0x0000e8b1159593ecUL;
   tf->codes[7073] = 0x0000e8b6586f189fUL;
   tf->codes[7074] = 0x0000e8b82ce746c7UL;
   tf->codes[7075] = 0x0000e8b8a2055251UL;
   tf->codes[7076] = 0x0000e8b8dc945816UL;
   tf->codes[7077] = 0x0000e8bbd5d7a317UL;
   tf->codes[7078] = 0x0000e8bcc013ba2bUL;
   tf->codes[7079] = 0x0000e8bdaa4fd13fUL;
   tf->codes[7080] = 0x0000e8be1f6ddcc9UL;
   tf->codes[7081] = 0x0000e8c411f472cbUL;
   tf->codes[7082] = 0x0000e8c44c837890UL;
   tf->codes[7083] = 0x0000e8c4c1a1841aUL;
   tf->codes[7084] = 0x0000e8c69619b242UL;
   tf->codes[7085] = 0x0000e8c8a520e62fUL;
   tf->codes[7086] = 0x0000e8ca047b08cdUL;
   tf->codes[7087] = 0x0000e8cab4281a1cUL;
   tf->codes[7088] = 0x0000e8ced23681f6UL;
   tf->codes[7089] = 0x0000e8d0a6aeb01eUL;
   tf->codes[7090] = 0x0000e8d0e13db5e3UL;
   tf->codes[7091] = 0x0000e8d20608d2bcUL;
   tf->codes[7092] = 0x0000e8d36562f55aUL;
   tf->codes[7093] = 0x0000e8d5e98834d1UL;
   tf->codes[7094] = 0x0000e8d957e98b5cUL;
   tf->codes[7095] = 0x0000e8dc8bbbdc22UL;
   tf->codes[7096] = 0x0000e8e194065b10UL;
   tf->codes[7097] = 0x0000e8e32def8373UL;
   tf->codes[7098] = 0x0000e8e8ab580debUL;
   tf->codes[7099] = 0x0000e8ec54486a3bUL;
   tf->codes[7100] = 0x0000e8ef12fcaf77UL;
   tf->codes[7101] = 0x0000e8f1d1b0f4b3UL;
   tf->codes[7102] = 0x0000e8f2815e0602UL;
   tf->codes[7103] = 0x0000e8f2f67c118cUL;
   tf->codes[7104] = 0x0000e8f57aa15103UL;
   tf->codes[7105] = 0x0000e8f6d9fb73a1UL;
   tf->codes[7106] = 0x0000e8f7148a7966UL;
   tf->codes[7107] = 0x0000e8f873e49c04UL;
   tf->codes[7108] = 0x0000e8f95e20b318UL;
   tf->codes[7109] = 0x0000e8fccc8209a3UL;
   tf->codes[7110] = 0x0000e8fedb893d90UL;
   tf->codes[7111] = 0x0000e9019a3d82ccUL;
   tf->codes[7112] = 0x0000e902847999e0UL;
   tf->codes[7113] = 0x0000e90458f1c808UL;
   tf->codes[7114] = 0x0000e90926ad4131UL;
   tf->codes[7115] = 0x0000e90a10e95845UL;
   tf->codes[7116] = 0x0000e911283b0b20UL;
   tf->codes[7117] = 0x0000e9119d5916aaUL;
   tf->codes[7118] = 0x0000e914217e5621UL;
   tf->codes[7119] = 0x0000e916e0329b5dUL;
   tf->codes[7120] = 0x0000e91c230c2010UL;
   tf->codes[7121] = 0x0000e91f916d769bUL;
   tf->codes[7122] = 0x0000e920068b8225UL;
   tf->codes[7123] = 0x0000e92165e5a4c3UL;
   tf->codes[7124] = 0x0000e927cd8a464fUL;
   tf->codes[7125] = 0x0000e931a3903e66UL;
   tf->codes[7126] = 0x0000e9333d7966c9UL;
   tf->codes[7127] = 0x0000e93427b57dddUL;
   tf->codes[7128] = 0x0000e935870fa07bUL;
   tf->codes[7129] = 0x0000e93636bcb1caUL;
   tf->codes[7130] = 0x0000e936e669c319UL;
   tf->codes[7131] = 0x0000e93720f8c8deUL;
   tf->codes[7132] = 0x0000e93a54cb19a4UL;
   tf->codes[7133] = 0x0000e93beeb44207UL;
   tf->codes[7134] = 0x0000e93c294347ccUL;
   tf->codes[7135] = 0x0000e93f228692cdUL;
   tf->codes[7136] = 0x0000e93f97a49e57UL;
   tf->codes[7137] = 0x0000e94465601780UL;
   tf->codes[7138] = 0x0000e9449fef1d45UL;
   tf->codes[7139] = 0x0000e94724145cbcUL;
   tf->codes[7140] = 0x0000e94b4222c496UL;
   tf->codes[7141] = 0x0000e951e4566be7UL;
   tf->codes[7142] = 0x0000e952ce9282fbUL;
   tf->codes[7143] = 0x0000e954a30ab123UL;
   tf->codes[7144] = 0x0000e95761bef65fUL;
   tf->codes[7145] = 0x0000e95936372487UL;
   tf->codes[7146] = 0x0000e95b0aaf52afUL;
   tf->codes[7147] = 0x0000e95d19b6869cUL;
   tf->codes[7148] = 0x0000e95eee2eb4c4UL;
   tf->codes[7149] = 0x0000e9651b44508bUL;
   tf->codes[7150] = 0x0000e967d9f895c7UL;
   tf->codes[7151] = 0x0000e96889a5a716UL;
   tf->codes[7152] = 0x0000e968fec3b2a0UL;
   tf->codes[7153] = 0x0000e96b82e8f217UL;
   tf->codes[7154] = 0x0000e96f2bd94e67UL;
   tf->codes[7155] = 0x0000e970c5c276caUL;
   tf->codes[7156] = 0x0000e972251c9968UL;
   tf->codes[7157] = 0x0000e97e0a29c56cUL;
   tf->codes[7158] = 0x0000e9801930f959UL;
   tf->codes[7159] = 0x0000e98053bfff1eUL;
   tf->codes[7160] = 0x0000e983c22155a9UL;
   tf->codes[7161] = 0x0000e985969983d1UL;
   tf->codes[7162] = 0x0000e98fe1bd8772UL;
   tf->codes[7163] = 0x0000e9917ba6afd5UL;
   tf->codes[7164] = 0x0000e992db00d273UL;
   tf->codes[7165] = 0x0000e9938aade3c2UL;
   tf->codes[7166] = 0x0000e99858695cebUL;
   tf->codes[7167] = 0x0000e99a677090d8UL;
   tf->codes[7168] = 0x0000e99aa1ff969dUL;
   tf->codes[7169] = 0x0000e99b8c3badb1UL;
   tf->codes[7170] = 0x0000e99c3be8bf00UL;
   tf->codes[7171] = 0x0000e9a109a43829UL;
   tf->codes[7172] = 0x0000e9a402e7832aUL;
   tf->codes[7173] = 0x0000e9a611eeb717UL;
   tf->codes[7174] = 0x0000e9a7abd7df7aUL;
   tf->codes[7175] = 0x0000e9ab1a393605UL;
   tf->codes[7176] = 0x0000e9b9836ba180UL;
   tf->codes[7177] = 0x0000e9bf75f23782UL;
   tf->codes[7178] = 0x0000e9c0259f48d1UL;
   tf->codes[7179] = 0x0000e9c184f96b6fUL;
   tf->codes[7180] = 0x0000e9c5dd96d90eUL;
   tf->codes[7181] = 0x0000e9cd6a069773UL;
   tf->codes[7182] = 0x0000e9d06349e274UL;
   tf->codes[7183] = 0x0000e9d18814ff4dUL;
   tf->codes[7184] = 0x0000e9d8d9f5b7edUL;
   tf->codes[7185] = 0x0000e9d94f13c377UL;
   tf->codes[7186] = 0x0000e9de91ed482aUL;
   tf->codes[7187] = 0x0000e9df419a5979UL;
   tf->codes[7188] = 0x0000e9e1161287a1UL;
   tf->codes[7189] = 0x0000e9e39a37c718UL;
   tf->codes[7190] = 0x0000e9e48473de2cUL;
   tf->codes[7191] = 0x0000e9e6937b1219UL;
   tf->codes[7192] = 0x0000e9e7f2d534b7UL;
   tf->codes[7193] = 0x0000e9f412716680UL;
   tf->codes[7194] = 0x0000e9f5373c8359UL;
   tf->codes[7195] = 0x0000e9f70bb4b181UL;
   tf->codes[7196] = 0x0000e9fa04f7fc82UL;
   tf->codes[7197] = 0x0000e9fc13ff306fUL;
   tf->codes[7198] = 0x0000e9ff826086faUL;
   tf->codes[7199] = 0x0000ea00320d9849UL;
   tf->codes[7200] = 0x0000ea00a72ba3d3UL;
   tf->codes[7201] = 0x0000ea019167bae7UL;
   tf->codes[7202] = 0x0000ea0699b239d5UL;
   tf->codes[7203] = 0x0000ea0a08139060UL;
   tf->codes[7204] = 0x0000ea0b676db2feUL;
   tf->codes[7205] = 0x0000ea0f105e0f4eUL;
   tf->codes[7206] = 0x0000ea1453379401UL;
   tf->codes[7207] = 0x0000ea19961118b4UL;
   tf->codes[7208] = 0x0000ea1deeae8653UL;
   tf->codes[7209] = 0x0000ea1f1379a32cUL;
   tf->codes[7210] = 0x0000ea274f9672e0UL;
   tf->codes[7211] = 0x0000ea2a0e4ab81cUL;
   tf->codes[7212] = 0x0000ea2b3315d4f5UL;
   tf->codes[7213] = 0x0000ea31602b70bcUL;
   tf->codes[7214] = 0x0000ea31d5497c46UL;
   tf->codes[7215] = 0x0000ea32bf85935aUL;
   tf->codes[7216] = 0x0000ea3493fdc182UL;
   tf->codes[7217] = 0x0000ea3752b206beUL;
   tf->codes[7218] = 0x0000ea3a4bf551bfUL;
   tf->codes[7219] = 0x0000ea3f543fd0adUL;
   tf->codes[7220] = 0x0000ea40ee28f910UL;
   tf->codes[7221] = 0x0000ea42c2a12738UL;
   tf->codes[7222] = 0x0000ea4421fb49d6UL;
   tf->codes[7223] = 0x0000ea4a899feb62UL;
   tf->codes[7224] = 0x0000ea4b394cfcb1UL;
   tf->codes[7225] = 0x0000ea4f91ea6a50UL;
   tf->codes[7226] = 0x0000ea51db80a402UL;
   tf->codes[7227] = 0x0000ea58b8435118UL;
   tf->codes[7228] = 0x0000ea5b01d98acaUL;
   tf->codes[7229] = 0x0000ea5b3c68908fUL;
   tf->codes[7230] = 0x0000ea5b76f79654UL;
   tf->codes[7231] = 0x0000ea63b3146608UL;
   tf->codes[7232] = 0x0000ea679693c81dUL;
   tf->codes[7233] = 0x0000ea68f5edeabbUL;
   tf->codes[7234] = 0x0000ea696b0bf645UL;
   tf->codes[7235] = 0x0000ea6bb4a22ff7UL;
   tf->codes[7236] = 0x0000ea70bcecaee5UL;
   tf->codes[7237] = 0x0000ea76ea024aacUL;
   tf->codes[7238] = 0x0000ea7cdc88e0aeUL;
   tf->codes[7239] = 0x0000ea8085793cfeUL;
   tf->codes[7240] = 0x0000ea84a387a4d8UL;
   tf->codes[7241] = 0x0000ea86ed1dde8aUL;
   tf->codes[7242] = 0x0000ea8a5b7f3515UL;
   tf->codes[7243] = 0x0000ea92d22b0a8eUL;
   tf->codes[7244] = 0x0000ea9556504a05UL;
   tf->codes[7245] = 0x0000ea95cb6e558fUL;
   tf->codes[7246] = 0x0000ea9b8365e5ccUL;
   tf->codes[7247] = 0x0000ea9bf883f156UL;
   tf->codes[7248] = 0x0000ea9f2c56421cUL;
   tf->codes[7249] = 0x0000eaa2602892e2UL;
   tf->codes[7250] = 0x0000eaa6f3550646UL;
   tf->codes[7251] = 0x0000eaa7687311d0UL;
   tf->codes[7252] = 0x0000eaa9025c3a33UL;
   tf->codes[7253] = 0x0000eaaa2727570cUL;
   tf->codes[7254] = 0x0000eab019aded0eUL;
   tf->codes[7255] = 0x0000eab179080facUL;
   tf->codes[7256] = 0x0000eab3880f4399UL;
   tf->codes[7257] = 0x0000eaba2a42eaeaUL;
   tf->codes[7258] = 0x0000eabb147f01feUL;
   tf->codes[7259] = 0x0000eabc394a1ed7UL;
   tf->codes[7260] = 0x0000eabf328d69d8UL;
   tf->codes[7261] = 0x0000eac38b2ad777UL;
   tf->codes[7262] = 0x0000eac60f5016eeUL;
   tf->codes[7263] = 0x0000eac893755665UL;
   tf->codes[7264] = 0x0000eacbc747a72bUL;
   tf->codes[7265] = 0x0000eace4b6ce6a2UL;
   tf->codes[7266] = 0x0000ead01fe514caUL;
   tf->codes[7267] = 0x0000ead319285fcbUL;
   tf->codes[7268] = 0x0000ead43df37ca4UL;
   tf->codes[7269] = 0x0000ead4b311882eUL;
   tf->codes[7270] = 0x0000ead9463dfb92UL;
   tf->codes[7271] = 0x0000eadd29bd5da7UL;
   tf->codes[7272] = 0x0000eae31c43f3a9UL;
   tf->codes[7273] = 0x0000eae4f0bc21d1UL;
   tf->codes[7274] = 0x0000eaf09b3a4810UL;
   tf->codes[7275] = 0x0000eaf31f5f8787UL;
   tf->codes[7276] = 0x0000eaf4442aa460UL;
   tf->codes[7277] = 0x0000eaf568f5c139UL;
   tf->codes[7278] = 0x0000eaf777fcf526UL;
   tf->codes[7279] = 0x0000eaf94c75234eUL;
   tf->codes[7280] = 0x0000eafbd09a62c5UL;
   tf->codes[7281] = 0x0000eafec9ddadc6UL;
   tf->codes[7282] = 0x0000eb035d0a212aUL;
   tf->codes[7283] = 0x0000eb044746383eUL;
   tf->codes[7284] = 0x0000eb0531824f52UL;
   tf->codes[7285] = 0x0000eb10dc007591UL;
   tf->codes[7286] = 0x0000eb15349de330UL;
   tf->codes[7287] = 0x0000eb161ed9fa44UL;
   tf->codes[7288] = 0x0000eb1c11609046UL;
   tf->codes[7289] = 0x0000eb1dab49b8a9UL;
   tf->codes[7290] = 0x0000eb1f4532e10cUL;
   tf->codes[7291] = 0x0000eb21543a14f9UL;
   tf->codes[7292] = 0x0000eb24c29b6b84UL;
   tf->codes[7293] = 0x0000eb2537b9770eUL;
   tf->codes[7294] = 0x0000eb2aefb1074bUL;
   tf->codes[7295] = 0x0000eb345098f3d8UL;
   tf->codes[7296] = 0x0000eb34c5b6ff62UL;
   tf->codes[7297] = 0x0000eb365fa027c5UL;
   tf->codes[7298] = 0x0000eb386ea75bb2UL;
   tf->codes[7299] = 0x0000eb38e3c5673cUL;
   tf->codes[7300] = 0x0000eb391e546d01UL;
   tf->codes[7301] = 0x0000eb3bdd08b23dUL;
   tf->codes[7302] = 0x0000eb4244ad53c9UL;
   tf->codes[7303] = 0x0000eb46d7d9c72dUL;
   tf->codes[7304] = 0x0000eb50addfbf44UL;
   tf->codes[7305] = 0x0000eb53a7230a45UL;
   tf->codes[7306] = 0x0000eb57158460d0UL;
   tf->codes[7307] = 0x0000eb57c531721fUL;
   tf->codes[7308] = 0x0000eb595f1a9a82UL;
   tf->codes[7309] = 0x0000eb5af903c2e5UL;
   tf->codes[7310] = 0x0000eb5be33fd9f9UL;
   tf->codes[7311] = 0x0000eb6160a86471UL;
   tf->codes[7312] = 0x0000eb628573814aUL;
   tf->codes[7313] = 0x0000eb6df562a1c4UL;
   tf->codes[7314] = 0x0000eb6f54bcc462UL;
   tf->codes[7315] = 0x0000eb712934f28aUL;
   tf->codes[7316] = 0x0000eb72fdad20b2UL;
   tf->codes[7317] = 0x0000eb73ad5a3201UL;
   tf->codes[7318] = 0x0000eb745d074350UL;
   tf->codes[7319] = 0x0000eb7ac4abe4dcUL;
   tf->codes[7320] = 0x0000eb7b39c9f066UL;
   tf->codes[7321] = 0x0000eb80f1c180a3UL;
   tf->codes[7322] = 0x0000eb86a9b910e0UL;
   tf->codes[7323] = 0x0000eb8e70b7d50aUL;
   tf->codes[7324] = 0x0000eb8f2064e659UL;
   tf->codes[7325] = 0x0000eb9045300332UL;
   tf->codes[7326] = 0x0000eb92c95542a9UL;
   tf->codes[7327] = 0x0000eb93b39159bdUL;
   tf->codes[7328] = 0x0000eb9b40011822UL;
   tf->codes[7329] = 0x0000eb9bb51f23acUL;
   tf->codes[7330] = 0x0000eb9c2a3d2f36UL;
   tf->codes[7331] = 0x0000eb9d899751d4UL;
   tf->codes[7332] = 0x0000eba3f13bf360UL;
   tf->codes[7333] = 0x0000eba4db780a74UL;
   tf->codes[7334] = 0x0000eba75f9d49ebUL;
   tf->codes[7335] = 0x0000eba849d960ffUL;
   tf->codes[7336] = 0x0000eba8846866c4UL;
   tf->codes[7337] = 0x0000ebadc741eb77UL;
   tf->codes[7338] = 0x0000ebaeec0d0850UL;
   tf->codes[7339] = 0x0000ebb0fb143c3dUL;
   tf->codes[7340] = 0x0000ebb135a34202UL;
   tf->codes[7341] = 0x0000ebb37f397bb4UL;
   tf->codes[7342] = 0x0000ebb6035ebb2bUL;
   tf->codes[7343] = 0x0000ebb762b8ddc9UL;
   tf->codes[7344] = 0x0000ebb88783faa2UL;
   tf->codes[7345] = 0x0000ebbc307456f2UL;
   tf->codes[7346] = 0x0000ebbe7a0a90a4UL;
   tf->codes[7347] = 0x0000ebc04e82beccUL;
   tf->codes[7348] = 0x0000ebc72b456be2UL;
   tf->codes[7349] = 0x0000ebc7a063776cUL;
   tf->codes[7350] = 0x0000ebc8158182f6UL;
   tf->codes[7351] = 0x0000ebc88a9f8e80UL;
   tf->codes[7352] = 0x0000ebc8ffbd9a0aUL;
   tf->codes[7353] = 0x0000ebcb4953d3bcUL;
   tf->codes[7354] = 0x0000ebcb83e2d981UL;
   tf->codes[7355] = 0x0000ebd1014b63f9UL;
   tf->codes[7356] = 0x0000ebd13bda69beUL;
   tf->codes[7357] = 0x0000ebd29b348c5cUL;
   tf->codes[7358] = 0x0000ebd559e8d198UL;
   tf->codes[7359] = 0x0000ebd67eb3ee71UL;
   tf->codes[7360] = 0x0000ebd7a37f0b4aUL;
   tf->codes[7361] = 0x0000ebdad7515c10UL;
   tf->codes[7362] = 0x0000ebddd094a711UL;
   tf->codes[7363] = 0x0000ebdfa50cd539UL;
   tf->codes[7364] = 0x0000ebe179850361UL;
   tf->codes[7365] = 0x0000ebe5d2227100UL;
   tf->codes[7366] = 0x0000ebe9b5a1d315UL;
   tf->codes[7367] = 0x0000ebebc4a90702UL;
   tf->codes[7368] = 0x0000ebeef87b57c8UL;
   tf->codes[7369] = 0x0000ebef6d996352UL;
   tf->codes[7370] = 0x0000ebf01d4674a1UL;
   tf->codes[7371] = 0x0000ebf09264802bUL;
   tf->codes[7372] = 0x0000ebf5601ff954UL;
   tf->codes[7373] = 0x0000ebfadd8883ccUL;
   tf->codes[7374] = 0x0000ebfec107e5e1UL;
   tf->codes[7375] = 0x0000ec00d00f19ceUL;
   tf->codes[7376] = 0x0000ec0319a55380UL;
   tf->codes[7377] = 0x0000ec08970dddf8UL;
   tf->codes[7378] = 0x0000ec08d19ce3bdUL;
   tf->codes[7379] = 0x0000ec114848b936UL;
   tf->codes[7380] = 0x0000ec126d13d60fUL;
   tf->codes[7381] = 0x0000ec14418c0437UL;
   tf->codes[7382] = 0x0000ec19846588eaUL;
   tf->codes[7383] = 0x0000ec2185f352d9UL;
   tf->codes[7384] = 0x0000ec231fdc7b3cUL;
   tf->codes[7385] = 0x0000ec240a189250UL;
   tf->codes[7386] = 0x0000ec2a71bd33dcUL;
   tf->codes[7387] = 0x0000ec2b968850b5UL;
   tf->codes[7388] = 0x0000ec2c0ba65c3fUL;
   tf->codes[7389] = 0x0000ec30d961d568UL;
   tf->codes[7390] = 0x0000ec31fe2cf241UL;
   tf->codes[7391] = 0x0000ec32adda0390UL;
   tf->codes[7392] = 0x0000ec36cbe86b6aUL;
   tf->codes[7393] = 0x0000ec370677712fUL;
   tf->codes[7394] = 0x0000ec3b2485d909UL;
   tf->codes[7395] = 0x0000ec3b99a3e493UL;
   tf->codes[7396] = 0x0000ec3cf8fe0731UL;
   tf->codes[7397] = 0x0000ec3ecd763559UL;
   tf->codes[7398] = 0x0000ec40a1ee6381UL;
   tf->codes[7399] = 0x0000ec418c2a7a95UL;
   tf->codes[7400] = 0x0000ec444adebfd1UL;
   tf->codes[7401] = 0x0000ec44fa8bd120UL;
   tf->codes[7402] = 0x0000ec477eb11097UL;
   tf->codes[7403] = 0x0000ec47b940165cUL;
   tf->codes[7404] = 0x0000ec49c8474a49UL;
   tf->codes[7405] = 0x0000ec4b623072acUL;
   tf->codes[7406] = 0x0000ec4cfc199b0fUL;
   tf->codes[7407] = 0x0000ec50a509f75fUL;
   tf->codes[7408] = 0x0000ec511a2802e9UL;
   tf->codes[7409] = 0x0000ec53292f36d6UL;
   tf->codes[7410] = 0x0000ec57473d9eb0UL;
   tf->codes[7411] = 0x0000ec5fbde97429UL;
   tf->codes[7412] = 0x0000ec606d968578UL;
   tf->codes[7413] = 0x0000ec611d4396c7UL;
   tf->codes[7414] = 0x0000ec63dbf7dc03UL;
   tf->codes[7415] = 0x0000ec68349549a2UL;
   tf->codes[7416] = 0x0000ec7578fc9844UL;
   tf->codes[7417] = 0x0000ec7628a9a993UL;
   tf->codes[7418] = 0x0000ec77fd21d7bbUL;
   tf->codes[7419] = 0x0000ec815e09c448UL;
   tf->codes[7420] = 0x0000ec820db6d597UL;
   tf->codes[7421] = 0x0000ec84574d0f49UL;
   tf->codes[7422] = 0x0000ec84cc6b1ad3UL;
   tf->codes[7423] = 0x0000ec899a2693fcUL;
   tf->codes[7424] = 0x0000ec903c5a3b4dUL;
   tf->codes[7425] = 0x0000ec90b17846d7UL;
   tf->codes[7426] = 0x0000ec9928241c50UL;
   tf->codes[7427] = 0x0000ec999d4227daUL;
   tf->codes[7428] = 0x0000eca0b493dab5UL;
   tf->codes[7429] = 0x0000eca24e7d0318UL;
   tf->codes[7430] = 0x0000eca3add725b6UL;
   tf->codes[7431] = 0x0000eca84103991aUL;
   tf->codes[7432] = 0x0000eca87b929edfUL;
   tf->codes[7433] = 0x0000ecaee337406bUL;
   tf->codes[7434] = 0x0000ecb042916309UL;
   tf->codes[7435] = 0x0000ecb1675c7fe2UL;
   tf->codes[7436] = 0x0000ecb217099131UL;
   tf->codes[7437] = 0x0000ecb2519896f6UL;
   tf->codes[7438] = 0x0000ecbbb2808383UL;
   tf->codes[7439] = 0x0000ecbdc187b770UL;
   tf->codes[7440] = 0x0000ecbf95ffe598UL;
   tf->codes[7441] = 0x0000ecc045acf6e7UL;
   tf->codes[7442] = 0x0000ecc1a5071985UL;
   tf->codes[7443] = 0x0000ecc28f433099UL;
   tf->codes[7444] = 0x0000ecc3ee9d5337UL;
   tf->codes[7445] = 0x0000ecc463bb5ec1UL;
   tf->codes[7446] = 0x0000ecc513687010UL;
   tf->codes[7447] = 0x0000ecc7226fa3fdUL;
   tf->codes[7448] = 0x0000ecd37c9adb8bUL;
   tf->codes[7449] = 0x0000ecd675de268cUL;
   tf->codes[7450] = 0x0000ecd7601a3da0UL;
   tf->codes[7451] = 0x0000ece0115518deUL;
   tf->codes[7452] = 0x0000ece1e5cd4706UL;
   tf->codes[7453] = 0x0000ece812e2e2cdUL;
   tf->codes[7454] = 0x0000ece937adffa6UL;
   tf->codes[7455] = 0x0000ecead1972809UL;
   tf->codes[7456] = 0x0000ecebf66244e2UL;
   tf->codes[7457] = 0x0000ecef2a3495a8UL;
   tf->codes[7458] = 0x0000ecf3f7f00ed1UL;
   tf->codes[7459] = 0x0000ecf4327f1496UL;
   tf->codes[7460] = 0x0000ecf7db6f70e6UL;
   tf->codes[7461] = 0x0000ecf9003a8dbfUL;
   tf->codes[7462] = 0x0000ecf9afe79f0eUL;
   tf->codes[7463] = 0x0000ecfa5f94b05dUL;
   tf->codes[7464] = 0x0000ed04359aa874UL;
   tf->codes[7465] = 0x0000ed0644a1dc61UL;
   tf->codes[7466] = 0x0000ed07a3fbfeffUL;
   tf->codes[7467] = 0x0000ed08191a0a89UL;
   tf->codes[7468] = 0x0000ed09b30332ecUL;
   tf->codes[7469] = 0x0000ed0d5bf38f3cUL;
   tf->codes[7470] = 0x0000ed105536da3dUL;
   tf->codes[7471] = 0x0000ed1229af0865UL;
   tf->codes[7472] = 0x0000ed12643e0e2aUL;
   tf->codes[7473] = 0x0000ed12d95c19b4UL;
   tf->codes[7474] = 0x0000ed1313eb1f79UL;
   tf->codes[7475] = 0x0000ed13c39830c8UL;
   tf->codes[7476] = 0x0000ed1473454217UL;
   tf->codes[7477] = 0x0000ed155d81592bUL;
   tf->codes[7478] = 0x0000ed16f76a818eUL;
   tf->codes[7479] = 0x0000ed181c359e67UL;
   tf->codes[7480] = 0x0000ed1856c4a42cUL;
   tf->codes[7481] = 0x0000ed197b8fc105UL;
   tf->codes[7482] = 0x0000ed1d5f0f231aUL;
   tf->codes[7483] = 0x0000ed231706b357UL;
   tf->codes[7484] = 0x0000ed2f7131eae5UL;
   tf->codes[7485] = 0x0000ed32df934170UL;
   tf->codes[7486] = 0x0000ed338f4052bfUL;
   tf->codes[7487] = 0x0000ed36c312a385UL;
   tf->codes[7488] = 0x0000ed36fda1a94aUL;
   tf->codes[7489] = 0x0000ed3a3173fa10UL;
   tf->codes[7490] = 0x0000ed3e8a1167afUL;
   tf->codes[7491] = 0x0000ed410e36a726UL;
   tf->codes[7492] = 0x0000ed431d3ddb13UL;
   tf->codes[7493] = 0x0000ed4616812614UL;
   tf->codes[7494] = 0x0000ed4775db48b2UL;
   tf->codes[7495] = 0x0000ed47eaf9543cUL;
   tf->codes[7496] = 0x0000ed4a6f1e93b3UL;
   tf->codes[7497] = 0x0000ed4e180ef003UL;
   tf->codes[7498] = 0x0000ed4f024b0717UL;
   tf->codes[7499] = 0x0000ed52361d57ddUL;
   tf->codes[7500] = 0x0000ed5270ac5da2UL;
   tf->codes[7501] = 0x0000ed57ee14e81aUL;
   tf->codes[7502] = 0x0000ed5987fe107dUL;
   tf->codes[7503] = 0x0000ed59fd1c1c07UL;
   tf->codes[7504] = 0x0000ed5cbbd06143UL;
   tf->codes[7505] = 0x0000ed5f05669af5UL;
   tf->codes[7506] = 0x0000ed5fefa2b209UL;
   tf->codes[7507] = 0x0000ed63237502cfUL;
   tf->codes[7508] = 0x0000ed64bd5e2b32UL;
   tf->codes[7509] = 0x0000ed65e229480bUL;
   tf->codes[7510] = 0x0000ed66cc655f1fUL;
   tf->codes[7511] = 0x0000ed682bbf81bdUL;
   tf->codes[7512] = 0x0000ed68db6c930cUL;
   tf->codes[7513] = 0x0000ed69c5a8aa20UL;
   tf->codes[7514] = 0x0000ed6b5f91d283UL;
   tf->codes[7515] = 0x0000ed702d4d4bacUL;
   tf->codes[7516] = 0x0000ed72ec0190e8UL;
   tf->codes[7517] = 0x0000ed73d63da7fcUL;
   tf->codes[7518] = 0x0000ed74c079bf10UL;
   tf->codes[7519] = 0x0000ed75e544dbe9UL;
   tf->codes[7520] = 0x0000ed7953a63274UL;
   tf->codes[7521] = 0x0000ed7a78714f4dUL;
   tf->codes[7522] = 0x0000ed7aed8f5ad7UL;
   tf->codes[7523] = 0x0000ed7bd7cb71ebUL;
   tf->codes[7524] = 0x0000ed7cc20788ffUL;
   tf->codes[7525] = 0x0000ed7e967fb727UL;
   tf->codes[7526] = 0x0000ed80e015f0d9UL;
   tf->codes[7527] = 0x0000ed82ef1d24c6UL;
   tf->codes[7528] = 0x0000ed84fe2458b3UL;
   tf->codes[7529] = 0x0000ed857342643dUL;
   tf->codes[7530] = 0x0000ed8622ef758cUL;
   tf->codes[7531] = 0x0000ed8747ba9265UL;
   tf->codes[7532] = 0x0000ed92b7a9b2dfUL;
   tf->codes[7533] = 0x0000ed94c6b0e6ccUL;
   tf->codes[7534] = 0x0000ed953bcef256UL;
   tf->codes[7535] = 0x0000ed95eb7c03a5UL;
   tf->codes[7536] = 0x0000ed98aa3048e1UL;
   tf->codes[7537] = 0x0000ed9ab9377cceUL;
   tf->codes[7538] = 0x0000eda0abbe12d0UL;
   tf->codes[7539] = 0x0000eda0e64d1895UL;
   tf->codes[7540] = 0x0000eda245a73b33UL;
   tf->codes[7541] = 0x0000eda3df906396UL;
   tf->codes[7542] = 0x0000eda53eea8634UL;
   tf->codes[7543] = 0x0000eda5b40891beUL;
   tf->codes[7544] = 0x0000eda5ee979783UL;
   tf->codes[7545] = 0x0000edb0744aa0e9UL;
   tf->codes[7546] = 0x0000edb36d8debeaUL;
   tf->codes[7547] = 0x0000edb542061a12UL;
   tf->codes[7548] = 0x0000edb7167e483aUL;
   tf->codes[7549] = 0x0000edb875d86ad8UL;
   tf->codes[7550] = 0x0000edbbe439c163UL;
   tf->codes[7551] = 0x0000edbd0904de3cUL;
   tf->codes[7552] = 0x0000edbdf340f550UL;
   tf->codes[7553] = 0x0000edbe685f00daUL;
   tf->codes[7554] = 0x0000edc62f5dc504UL;
   tf->codes[7555] = 0x0000edc71999dc18UL;
   tf->codes[7556] = 0x0000edc75428e1ddUL;
   tf->codes[7557] = 0x0000edc928a11005UL;
   tf->codes[7558] = 0x0000edc9633015caUL;
   tf->codes[7559] = 0x0000edc99dbf1b8fUL;
   tf->codes[7560] = 0x0000edca87fb32a3UL;
   tf->codes[7561] = 0x0000edcbe7555541UL;
   tf->codes[7562] = 0x0000edd03ff2c2e0UL;
   tf->codes[7563] = 0x0000edd07a81c8a5UL;
   tf->codes[7564] = 0x0000edd164bddfb9UL;
   tf->codes[7565] = 0x0000edd2146af108UL;
   tf->codes[7566] = 0x0000edd2c4180257UL;
   tf->codes[7567] = 0x0000edd3ae54196bUL;
   tf->codes[7568] = 0x0000edd7574475bbUL;
   tf->codes[7569] = 0x0000edd9db69b532UL;
   tf->codes[7570] = 0x0000ede0430e56beUL;
   tf->codes[7571] = 0x0000ede376e0a784UL;
   tf->codes[7572] = 0x0000ede80a0d1ae8UL;
   tf->codes[7573] = 0x0000edec62aa8887UL;
   tf->codes[7574] = 0x0000edf1e01312ffUL;
   tf->codes[7575] = 0x0000edf255311e89UL;
   tf->codes[7576] = 0x0000edf304de2fd8UL;
   tf->codes[7577] = 0x0000edfa1c2fe2b3UL;
   tf->codes[7578] = 0x0000edfb7b8a0551UL;
   tf->codes[7579] = 0x0000edfd8a91393eUL;
   tf->codes[7580] = 0x0000edff247a61a1UL;
   tf->codes[7581] = 0x0000ee00be638a04UL;
   tf->codes[7582] = 0x0000ee0307f9c3b6UL;
   tf->codes[7583] = 0x0000ee05c6ae08f2UL;
   tf->codes[7584] = 0x0000ee08bff153f3UL;
   tf->codes[7585] = 0x0000ee10fc0e23a7UL;
   tf->codes[7586] = 0x0000ee125b684645UL;
   tf->codes[7587] = 0x0000ee16b405b3e4UL;
   tf->codes[7588] = 0x0000ee1763b2c533UL;
   tf->codes[7589] = 0x0000ee18135fd682UL;
   tf->codes[7590] = 0x0000ee1c6bfd4421UL;
   tf->codes[7591] = 0x0000ee1ef0228398UL;
   tf->codes[7592] = 0x0000ee1f65408f22UL;
   tf->codes[7593] = 0x0000ee229912dfe8UL;
   tf->codes[7594] = 0x0000ee22d3a1e5adUL;
   tf->codes[7595] = 0x0000ee23bdddfcc1UL;
   tf->codes[7596] = 0x0000ee2592562ae9UL;
   tf->codes[7597] = 0x0000ee2607743673UL;
   tf->codes[7598] = 0x0000ee293b468739UL;
   tf->codes[7599] = 0x0000ee29eaf39888UL;
   tf->codes[7600] = 0x0000ee2a6011a412UL;
   tf->codes[7601] = 0x0000ee301809344fUL;
   tf->codes[7602] = 0x0000ee3052983a14UL;
   tf->codes[7603] = 0x0000ee33866a8adaUL;
   tf->codes[7604] = 0x0000ee352053b33dUL;
   tf->codes[7605] = 0x0000ee36451ed016UL;
   tf->codes[7606] = 0x0000ee37df07f879UL;
   tf->codes[7607] = 0x0000ee3a9dbc3db5UL;
   tf->codes[7608] = 0x0000ee3bfd166053UL;
   tf->codes[7609] = 0x0000ee3c37a56618UL;
   tf->codes[7610] = 0x0000ee3fe095c268UL;
   tf->codes[7611] = 0x0000ee460dab5e2fUL;
   tf->codes[7612] = 0x0000ee481cb2921cUL;
   tf->codes[7613] = 0x0000ee4fa9225081UL;
   tf->codes[7614] = 0x0000ee51087c731fUL;
   tf->codes[7615] = 0x0000ee522d478ff8UL;
   tf->codes[7616] = 0x0000ee5267d695bdUL;
   tf->codes[7617] = 0x0000ee52a2659b82UL;
   tf->codes[7618] = 0x0000ee564b55f7d2UL;
   tf->codes[7619] = 0x0000ee57aab01a70UL;
   tf->codes[7620] = 0x0000ee57e53f2035UL;
   tf->codes[7621] = 0x0000ee5bc8be824aUL;
   tf->codes[7622] = 0x0000ee5c034d880fUL;
   tf->codes[7623] = 0x0000ee60215befe9UL;
   tf->codes[7624] = 0x0000ee609679fb73UL;
   tf->codes[7625] = 0x0000ee65d9538026UL;
   tf->codes[7626] = 0x0000ee6822e9b9d8UL;
   tf->codes[7627] = 0x0000ee6b56bc0a9eUL;
   tf->codes[7628] = 0x0000ee6f3a3b6cb3UL;
   tf->codes[7629] = 0x0000ee70247783c7UL;
   tf->codes[7630] = 0x0000ee76518d1f8eUL;
   tf->codes[7631] = 0x0000ee77013a30ddUL;
   tf->codes[7632] = 0x0000ee77eb7647f1UL;
   tf->codes[7633] = 0x0000ee7b9466a441UL;
   tf->codes[7634] = 0x0000ee7c7ea2bb55UL;
   tf->codes[7635] = 0x0000ee7e531ae97dUL;
   tf->codes[7636] = 0x0000ee80279317a5UL;
   tf->codes[7637] = 0x0000ee80d74028f4UL;
   tf->codes[7638] = 0x0000ee8271295157UL;
   tf->codes[7639] = 0x0000ee82abb8571cUL;
   tf->codes[7640] = 0x0000ee870455c4bbUL;
   tf->codes[7641] = 0x0000ee87b402d60aUL;
   tf->codes[7642] = 0x0000ee8a72b71b46UL;
   tf->codes[7643] = 0x0000ee8f7b019a34UL;
   tf->codes[7644] = 0x0000ee95a81735fbUL;
   tf->codes[7645] = 0x0000ee995107924bUL;
   tf->codes[7646] = 0x0000ee998b969810UL;
   tf->codes[7647] = 0x0000ee9f438e284dUL;
   tf->codes[7648] = 0x0000eea118065675UL;
   tf->codes[7649] = 0x0000eea18d2461ffUL;
   tf->codes[7650] = 0x0000eea2ec7e849dUL;
   tf->codes[7651] = 0x0000eea3619c9027UL;
   tf->codes[7652] = 0x0000eea3d6ba9bb1UL;
   tf->codes[7653] = 0x0000eea4fb85b88aUL;
   tf->codes[7654] = 0x0000eea77faaf801UL;
   tf->codes[7655] = 0x0000eeb1903ff5ddUL;
   tf->codes[7656] = 0x0000eeb4c41246a3UL;
   tf->codes[7657] = 0x0000eeb86d02a2f3UL;
   tf->codes[7658] = 0x0000eeb991cdbfccUL;
   tf->codes[7659] = 0x0000eebf49c55009UL;
   tf->codes[7660] = 0x0000eebfbee35b93UL;
   tf->codes[7661] = 0x0000eec0e3ae786cUL;
   tf->codes[7662] = 0x0000eec2b826a694UL;
   tf->codes[7663] = 0x0000eec785e21fbdUL;
   tf->codes[7664] = 0x0000eecba3f08797UL;
   tf->codes[7665] = 0x0000eed3a57e5186UL;
   tf->codes[7666] = 0x0000eed3e00d574bUL;
   tf->codes[7667] = 0x0000eed4552b62d5UL;
   tf->codes[7668] = 0x0000eed629a390fdUL;
   tf->codes[7669] = 0x0000eed99804e788UL;
   tf->codes[7670] = 0x0000eedb6c7d15b0UL;
   tf->codes[7671] = 0x0000eedbe19b213aUL;
   tf->codes[7672] = 0x0000eedccbd7384eUL;
   tf->codes[7673] = 0x0000eedf4ffc77c5UL;
   tf->codes[7674] = 0x0000eee15f03abb2UL;
   tf->codes[7675] = 0x0000eee57d12138cUL;
   tf->codes[7676] = 0x0000eee78c194779UL;
   tf->codes[7677] = 0x0000eeeafa7a9e04UL;
   tf->codes[7678] = 0x0000eeedf3bde905UL;
   tf->codes[7679] = 0x0000eef24c5b56a4UL;
   tf->codes[7680] = 0x0000eef286ea5c69UL;
   tf->codes[7681] = 0x0000eef5459ea1a5UL;
   tf->codes[7682] = 0x0000eef78f34db57UL;
   tf->codes[7683] = 0x0000eefe316882a8UL;
   tf->codes[7684] = 0x0000eefee11593f7UL;
   tf->codes[7685] = 0x0000eeffcb51ab0bUL;
   tf->codes[7686] = 0x0000ef0339b30196UL;
   tf->codes[7687] = 0x0000ef04990d2434UL;
   tf->codes[7688] = 0x0000ef0757c16970UL;
   tf->codes[7689] = 0x0000ef08b71b8c0eUL;
   tf->codes[7690] = 0x0000ef107e1a5038UL;
   tf->codes[7691] = 0x0000ef112dc76187UL;
   tf->codes[7692] = 0x0000ef12c7b089eaUL;
   tf->codes[7693] = 0x0000ef163611e075UL;
   tf->codes[7694] = 0x0000ef17204df789UL;
   tf->codes[7695] = 0x0000ef1a5420484fUL;
   tf->codes[7696] = 0x0000ef1bb37a6aedUL;
   tf->codes[7697] = 0x0000ef23055b238dUL;
   tf->codes[7698] = 0x0000ef2464b5462bUL;
   tf->codes[7699] = 0x0000ef249f444bf0UL;
   tf->codes[7700] = 0x0000ef28bd52b3caUL;
   tf->codes[7701] = 0x0000ef2f9a1560e0UL;
   tf->codes[7702] = 0x0000ef334305bd30UL;
   tf->codes[7703] = 0x0000ef34a25fdfceUL;
   tf->codes[7704] = 0x0000ef363c490831UL;
   tf->codes[7705] = 0x0000ef3676d80df6UL;
   tf->codes[7706] = 0x0000ef36ebf61980UL;
   tf->codes[7707] = 0x0000ef38c06e47a8UL;
   tf->codes[7708] = 0x0000ef3bb9b192a9UL;
   tf->codes[7709] = 0x0000ef3dc8b8c696UL;
   tf->codes[7710] = 0x0000ef3f2812e934UL;
   tf->codes[7711] = 0x0000ef3f9d30f4beUL;
   tf->codes[7712] = 0x0000ef430b924b49UL;
   tf->codes[7713] = 0x0000ef4a5d7303e9UL;
   tf->codes[7714] = 0x0000ef4b0d201538UL;
   tf->codes[7715] = 0x0000ef53493ce4ecUL;
   tf->codes[7716] = 0x0000ef551db51314UL;
   tf->codes[7717] = 0x0000ef56b79e3b77UL;
   tf->codes[7718] = 0x0000ef5a25ff9202UL;
   tf->codes[7719] = 0x0000ef5b103ba916UL;
   tf->codes[7720] = 0x0000ef5d59d1e2c8UL;
   tf->codes[7721] = 0x0000ef6102c23f18UL;
   tf->codes[7722] = 0x0000ef6854a2f7b8UL;
   tf->codes[7723] = 0x0000ef776d827482UL;
   tf->codes[7724] = 0x0000ef77e2a0800cUL;
   tf->codes[7725] = 0x0000ef7dd527160eUL;
   tf->codes[7726] = 0x0000ef94ef945cc7UL;
   tf->codes[7727] = 0x0000ef952a23628cUL;
   tf->codes[7728] = 0x0000ef985df5b352UL;
   tf->codes[7729] = 0x0000efa09a128306UL;
   tf->codes[7730] = 0x0000efa6520a1343UL;
   tf->codes[7731] = 0x0000efa6c7281ecdUL;
   tf->codes[7732] = 0x0000efbda7065fc1UL;
   tf->codes[7733] = 0x0000efbecbd17c9aUL;
   tf->codes[7734] = 0x0000efbff09c9973UL;
   tf->codes[7735] = 0x0000efcb9b1abfb2UL;
   tf->codes[7736] = 0x0000efd153124fefUL;
   tf->codes[7737] = 0x0000efd44c559af0UL;
   tf->codes[7738] = 0x0000efd78027ebb6UL;
   tf->codes[7739] = 0x0000efdf4726afe0UL;
   tf->codes[7740] = 0x0000efe32aa611f5UL;
   tf->codes[7741] = 0x0000efe5aecb516cUL;
   tf->codes[7742] = 0x0000efe70e25740aUL;
   tf->codes[7743] = 0x0000eff32dc1a5d3UL;
   tf->codes[7744] = 0x0000eff7fb7d1efcUL;
   tf->codes[7745] = 0x0000eff920483bd5UL;
   tf->codes[7746] = 0x0000effffd0ae8ebUL;
   tf->codes[7747] = 0x0000f000acb7fa3aUL;
   tf->codes[7748] = 0x0000f00196f4114eUL;
   tf->codes[7749] = 0x0000f00246a1229dUL;
   tf->codes[7750] = 0x0000f00455a8568aUL;
   tf->codes[7751] = 0x0000f0083927b89fUL;
   tf->codes[7752] = 0x0000f0141e34e4a3UL;
   tf->codes[7753] = 0x0000f01801b446b8UL;
   tf->codes[7754] = 0x0000f019267f6391UL;
   tf->codes[7755] = 0x0000f0233714616dUL;
   tf->codes[7756] = 0x0000f0278fb1cf0cUL;
   tf->codes[7757] = 0x0000f0296429fd34UL;
   tf->codes[7758] = 0x0000f02badc036e6UL;
   tf->codes[7759] = 0x0000f02e6c747c22UL;
   tf->codes[7760] = 0x0000f0307b7bb00fUL;
   tf->codes[7761] = 0x0000f030b60ab5d4UL;
   tf->codes[7762] = 0x0000f030f099bb99UL;
   tf->codes[7763] = 0x0000f034998a17e9UL;
   tf->codes[7764] = 0x0000f0350ea82373UL;
   tf->codes[7765] = 0x0000f036e320519bUL;
   tf->codes[7766] = 0x0000f037583e5d25UL;
   tf->codes[7767] = 0x0000f0387d0979feUL;
   tf->codes[7768] = 0x0000f03ac69fb3b0UL;
   tf->codes[7769] = 0x0000f0407e9743edUL;
   tf->codes[7770] = 0x0000f041ddf1668bUL;
   tf->codes[7771] = 0x0000f042c82d7d9fUL;
   tf->codes[7772] = 0x0000f0446216a602UL;
   tf->codes[7773] = 0x0000f0475b59f103UL;
   tf->codes[7774] = 0x0000f0480b070252UL;
   tf->codes[7775] = 0x0000f04a8f2c41c9UL;
   tf->codes[7776] = 0x0000f051a67df4a4UL;
   tf->codes[7777] = 0x0000f052562b05f3UL;
   tf->codes[7778] = 0x0000f05305d81742UL;
   tf->codes[7779] = 0x0000f054653239e0UL;
   tf->codes[7780] = 0x0000f05a9247d5a7UL;
   tf->codes[7781] = 0x0000f05dc61a266dUL;
   tf->codes[7782] = 0x0000f05f9a925495UL;
   tf->codes[7783] = 0x0000f0604a3f65e4UL;
   tf->codes[7784] = 0x0000f061a9998882UL;
   tf->codes[7785] = 0x0000f067270212faUL;
   tf->codes[7786] = 0x0000f067d6af2449UL;
   tf->codes[7787] = 0x0000f0717226169bUL;
   tf->codes[7788] = 0x0000f071acb51c60UL;
   tf->codes[7789] = 0x0000f0746b69619cUL;
   tf->codes[7790] = 0x0000f0767a709589UL;
   tf->codes[7791] = 0x0000f0788977c976UL;
   tf->codes[7792] = 0x0000f07973b3e08aUL;
   tf->codes[7793] = 0x0000f08050768da0UL;
   tf->codes[7794] = 0x0000f08593501253UL;
   tf->codes[7795] = 0x0000f089b15e7a2dUL;
   tf->codes[7796] = 0x0000f08fde7415f4UL;
   tf->codes[7797] = 0x0000f0926299556bUL;
   tf->codes[7798] = 0x0000f096f5c5c8cfUL;
   tf->codes[7799] = 0x0000f097a572da1eUL;
   tf->codes[7800] = 0x0000f097e001dfe3UL;
   tf->codes[7801] = 0x0000f09bc38141f8UL;
   tf->codes[7802] = 0x0000f09bfe1047bdUL;
   tf->codes[7803] = 0x0000f09e82358734UL;
   tf->codes[7804] = 0x0000f0a1b607d7faUL;
   tf->codes[7805] = 0x0000f0a7e31d73c1UL;
   tf->codes[7806] = 0x0000f0b109765a89UL;
   tf->codes[7807] = 0x0000f0b1b9236bd8UL;
   tf->codes[7808] = 0x0000f0b5d731d3b2UL;
   tf->codes[7809] = 0x0000f0b64c4fdf3cUL;
   tf->codes[7810] = 0x0000f0b85b571329UL;
   tf->codes[7811] = 0x0000f0b895e618eeUL;
   tf->codes[7812] = 0x0000f0b90b042478UL;
   tf->codes[7813] = 0x0000f0b980223002UL;
   tf->codes[7814] = 0x0000f0ba6a5e4716UL;
   tf->codes[7815] = 0x0000f0badf7c52a0UL;
   tf->codes[7816] = 0x0000f0bbc9b869b4UL;
   tf->codes[7817] = 0x0000f0be4ddda92bUL;
   tf->codes[7818] = 0x0000f0bf72a8c604UL;
   tf->codes[7819] = 0x0000f0c181aff9f1UL;
   tf->codes[7820] = 0x0000f0c405d53968UL;
   tf->codes[7821] = 0x0000f0c4b5824ab7UL;
   tf->codes[7822] = 0x0000f0c689fa78dfUL;
   tf->codes[7823] = 0x0000f0d025716b31UL;
   tf->codes[7824] = 0x0000f0d4f32ce45aUL;
   tf->codes[7825] = 0x0000f0d8618e3ae5UL;
   tf->codes[7826] = 0x0000f0daab247497UL;
   tf->codes[7827] = 0x0000f0db20428021UL;
   tf->codes[7828] = 0x0000f0dfb36ef385UL;
   tf->codes[7829] = 0x0000f0e2722338c1UL;
   tf->codes[7830] = 0x0000f0e655a29ad6UL;
   tf->codes[7831] = 0x0000f0eb5ded19c4UL;
   tf->codes[7832] = 0x0000f0f0663798b2UL;
   tf->codes[7833] = 0x0000f0f0db55a43cUL;
   tf->codes[7834] = 0x0000f0f1c591bb50UL;
   tf->codes[7835] = 0x0000f0f39a09e978UL;
   tf->codes[7836] = 0x0000f0f8a2546866UL;
   tf->codes[7837] = 0x0000f0f9520179b5UL;
   tf->codes[7838] = 0x0000f0fb2679a7ddUL;
   tf->codes[7839] = 0x0000f0fd3580dbcaUL;
   tf->codes[7840] = 0x0000f100de71381aUL;
   tf->codes[7841] = 0x0000f101538f43a4UL;
   tf->codes[7842] = 0x0000f10362967791UL;
   tf->codes[7843] = 0x0000f104124388e0UL;
   tf->codes[7844] = 0x0000f112b604fa20UL;
   tf->codes[7845] = 0x0000f114155f1cbeUL;
   tf->codes[7846] = 0x0000f115af484521UL;
   tf->codes[7847] = 0x0000f11af221c9d4UL;
   tf->codes[7848] = 0x0000f11b673fd55eUL;
   tf->codes[7849] = 0x0000f1206f8a544cUL;
   tf->codes[7850] = 0x0000f120e4a85fd6UL;
   tf->codes[7851] = 0x0000f123a35ca512UL;
   tf->codes[7852] = 0x0000f12a801f5228UL;
   tf->codes[7853] = 0x0000f1303816e265UL;
   tf->codes[7854] = 0x0000f131d2000ac8UL;
   tf->codes[7855] = 0x0000f132bc3c21dcUL;
   tf->codes[7856] = 0x0000f1341b96447aUL;
   tf->codes[7857] = 0x0000f13505d25b8eUL;
   tf->codes[7858] = 0x0000f136652c7e2cUL;
   tf->codes[7859] = 0x0000f13789f79b05UL;
   tf->codes[7860] = 0x0000f13d41ef2b42UL;
   tf->codes[7861] = 0x0000f1424a39aa30UL;
   tf->codes[7862] = 0x0000f14802313a6dUL;
   tf->codes[7863] = 0x0000f14a865679e4UL;
   tf->codes[7864] = 0x0000f150b36c15abUL;
   tf->codes[7865] = 0x0000f150edfb1b70UL;
   tf->codes[7866] = 0x0000f153acaf60acUL;
   tf->codes[7867] = 0x0000f155f6459a5eUL;
   tf->codes[7868] = 0x0000f1607bf8a3c4UL;
   tf->codes[7869] = 0x0000f1628affd7b1UL;
   tf->codes[7870] = 0x0000f163001de33bUL;
   tf->codes[7871] = 0x0000f16549b41cedUL;
   tf->codes[7872] = 0x0000f16a176f9616UL;
   tf->codes[7873] = 0x0000f173785782a3UL;
   tf->codes[7874] = 0x0000f173ed758e2dUL;
   tf->codes[7875] = 0x0000f174d7b1a541UL;
   tf->codes[7876] = 0x0000f175875eb690UL;
   tf->codes[7877] = 0x0000f176e6b8d92eUL;
   tf->codes[7878] = 0x0000f17880a20191UL;
   tf->codes[7879] = 0x0000f17c29925de1UL;
   tf->codes[7880] = 0x0000f17fd282ba31UL;
   tf->codes[7881] = 0x0000f180bcbed145UL;
   tf->codes[7882] = 0x0000f1829136ff6dUL;
   tf->codes[7883] = 0x0000f183b6021c46UL;
   tf->codes[7884] = 0x0000f185ff9855f8UL;
   tf->codes[7885] = 0x0000f191aa167c37UL;
   tf->codes[7886] = 0x0000f1921f3487c1UL;
   tf->codes[7887] = 0x0000f1929452934bUL;
   tf->codes[7888] = 0x0000f1937e8eaa5fUL;
   tf->codes[7889] = 0x0000f196ecf000eaUL;
   tf->codes[7890] = 0x0000f197277f06afUL;
   tf->codes[7891] = 0x0000f19971154061UL;
   tf->codes[7892] = 0x0000f199e6334bebUL;
   tf->codes[7893] = 0x0000f1a3bc394402UL;
   tf->codes[7894] = 0x0000f1a4a6755b16UL;
   tf->codes[7895] = 0x0000f1abf85613b6UL;
   tf->codes[7896] = 0x0000f1ad923f3c19UL;
   tf->codes[7897] = 0x0000f1b3f9e3dda5UL;
   tf->codes[7898] = 0x0000f1b5ce5c0bcdUL;
   tf->codes[7899] = 0x0000f1b88d105109UL;
   tf->codes[7900] = 0x0000f1bb4bc49645UL;
   tf->codes[7901] = 0x0000f1c08e9e1af8UL;
   tf->codes[7902] = 0x0000f1c103bc2682UL;
   tf->codes[7903] = 0x0000f1c2d83454aaUL;
   tf->codes[7904] = 0x0000f1c7e07ed398UL;
   tf->codes[7905] = 0x0000f1c93fd8f636UL;
   tf->codes[7906] = 0x0000f1c9ef860785UL;
   tf->codes[7907] = 0x0000f1d01c9ba34cUL;
   tf->codes[7908] = 0x0000f1d22ba2d739UL;
   tf->codes[7909] = 0x0000f1d55f7527ffUL;
   tf->codes[7910] = 0x0000f1d7e39a6776UL;
   tf->codes[7911] = 0x0000f1db8c8ac3c6UL;
   tf->codes[7912] = 0x0000f1e3c8a7937aUL;
   tf->codes[7913] = 0x0000f1e56290bbddUL;
   tf->codes[7914] = 0x0000f1e7ac26f58fUL;
   tf->codes[7915] = 0x0000f1f2a6f80a7fUL;
   tf->codes[7916] = 0x0000f1f774b383a8UL;
   tf->codes[7917] = 0x0000f1fddc582534UL;
   tf->codes[7918] = 0x0000f201102a75faUL;
   tf->codes[7919] = 0x0000f2014ab97bbfUL;
   tf->codes[7920] = 0x0000f2026f849898UL;
   tf->codes[7921] = 0x0000f204f3a9d80fUL;
   tf->codes[7922] = 0x0000f20aaba1684cUL;
   tf->codes[7923] = 0x0000f2109e27fe4eUL;
   tf->codes[7924] = 0x0000f21188641562UL;
   tf->codes[7925] = 0x0000f2156be37777UL;
   tf->codes[7926] = 0x0000f215e1018301UL;
   tf->codes[7927] = 0x0000f216cb3d9a15UL;
   tf->codes[7928] = 0x0000f21989f1df51UL;
   tf->codes[7929] = 0x0000f21b23db07b4UL;
   tf->codes[7930] = 0x0000f21f41e96f8eUL;
   tf->codes[7931] = 0x0000f2202c2586a2UL;
   tf->codes[7932] = 0x0000f220a143922cUL;
   tf->codes[7933] = 0x0000f221c60eaf05UL;
   tf->codes[7934] = 0x0000f22534700590UL;
   tf->codes[7935] = 0x0000f2256eff0b55UL;
   tf->codes[7936] = 0x0000f22b9c14a71cUL;
   tf->codes[7937] = 0x0000f2302f411a80UL;
   tf->codes[7938] = 0x0000f23203b948a8UL;
   tf->codes[7939] = 0x0000f232edf55fbcUL;
   tf->codes[7940] = 0x0000f2339da2710bUL;
   tf->codes[7941] = 0x0000f235aca9a4f8UL;
   tf->codes[7942] = 0x0000f239559a0148UL;
   tf->codes[7943] = 0x0000f23aef8329abUL;
   tf->codes[7944] = 0x0000f23c4edd4c49UL;
   tf->codes[7945] = 0x0000f23e23557a71UL;
   tf->codes[7946] = 0x0000f23f4820974aUL;
   tf->codes[7947] = 0x0000f2432b9ff95fUL;
   tf->codes[7948] = 0x0000f243a0be04e9UL;
   tf->codes[7949] = 0x0000f244c58921c2UL;
   tf->codes[7950] = 0x0000f247843d66feUL;
   tf->codes[7951] = 0x0000f24958b59526UL;
   tf->codes[7952] = 0x0000f24a7d80b1ffUL;
   tf->codes[7953] = 0x0000f24b2d2dc34eUL;
   tf->codes[7954] = 0x0000f25070074801UL;
   tf->codes[7955] = 0x0000f252447f7629UL;
   tf->codes[7956] = 0x0000f255ed6fd279UL;
   tf->codes[7957] = 0x0000f25a0b7e3a53UL;
   tf->codes[7958] = 0x0000f25bdff6687bUL;
   tf->codes[7959] = 0x0000f25d3f508b19UL;
   tf->codes[7960] = 0x0000f25db46e96a3UL;
   tf->codes[7961] = 0x0000f25f4e57bf06UL;
   tf->codes[7962] = 0x0000f263e184326aUL;
   tf->codes[7963] = 0x0000f267ff929a44UL;
   tf->codes[7964] = 0x0000f26ba882f694UL;
   tf->codes[7965] = 0x0000f275b917f470UL;
   tf->codes[7966] = 0x0000f279d7265c4aUL;
   tf->codes[7967] = 0x0000f27be62d9037UL;
   tf->codes[7968] = 0x0000f27d8016b89aUL;
   tf->codes[7969] = 0x0000f284224a5febUL;
   tf->codes[7970] = 0x0000f28a4f5ffbb2UL;
   tf->codes[7971] = 0x0000f2942565f3c9UL;
   tf->codes[7972] = 0x0000f295f9de21f1UL;
   tf->codes[7973] = 0x0000f29808e555deUL;
   tf->codes[7974] = 0x0000f29a8d0a9555UL;
   tf->codes[7975] = 0x0000f29bec64b7f3UL;
   tf->codes[7976] = 0x0000f2a2197a53baUL;
   tf->codes[7977] = 0x0000f2a2c9276509UL;
   tf->codes[7978] = 0x0000f2a33e457093UL;
   tf->codes[7979] = 0x0000f2a75c53d86dUL;
   tf->codes[7980] = 0x0000f2a9e07917e4UL;
   tf->codes[7981] = 0x0000f2aa5597236eUL;
   tf->codes[7982] = 0x0000f2aacab52ef8UL;
   tf->codes[7983] = 0x0000f2af5de1a25cUL;
   tf->codes[7984] = 0x0000f2afd2ffade6UL;
   tf->codes[7985] = 0x0000f2b1e206e1d3UL;
   tf->codes[7986] = 0x0000f2b4662c214aUL;
   tf->codes[7987] = 0x0000f2b58af73e23UL;
   tf->codes[7988] = 0x0000f2b6afc25afcUL;
   tf->codes[7989] = 0x0000f2b80f1c7d9aUL;
   tf->codes[7990] = 0x0000f2b933e79a73UL;
   tf->codes[7991] = 0x0000f2bc67b9eb39UL;
   tf->codes[7992] = 0x0000f2c21fb17b76UL;
   tf->codes[7993] = 0x0000f2c309ed928aUL;
   tf->codes[7994] = 0x0000f2c4a3d6baedUL;
   tf->codes[7995] = 0x0000f2c7628b0029UL;
   tf->codes[7996] = 0x0000f2c812381178UL;
   tf->codes[7997] = 0x0000f2d0fe01f27bUL;
   tf->codes[7998] = 0x0000f2d1e83e098fUL;
   tf->codes[7999] = 0x0000f2d5569f601aUL;
   tf->codes[8000] = 0x0000f2d88a71b0e0UL;
   tf->codes[8001] = 0x0000f2e05170750aUL;
   tf->codes[8002] = 0x0000f2e3fa60d15aUL;
   tf->codes[8003] = 0x0000f2e609680547UL;
   tf->codes[8004] = 0x0000f2ead7237e70UL;
   tf->codes[8005] = 0x0000f2f104391a37UL;
   tf->codes[8006] = 0x0000f2f229043710UL;
   tf->codes[8007] = 0x0000f2f34dcf53e9UL;
   tf->codes[8008] = 0x0000f2f681a1a4afUL;
   tf->codes[8009] = 0x0000f2f7e0fbc74dUL;
   tf->codes[8010] = 0x0000f2f85619d2d7UL;
   tf->codes[8011] = 0x0000f2fd98f3578aUL;
   tf->codes[8012] = 0x0000f303c608f351UL;
   tf->codes[8013] = 0x0000f305256315efUL;
   tf->codes[8014] = 0x0000f3055ff21bb4UL;
   tf->codes[8015] = 0x0000f30b8d07b77bUL;
   tf->codes[8016] = 0x0000f315630daf92UL;
   tf->codes[8017] = 0x0000f3185c50fa93UL;
   tf->codes[8018] = 0x0000f31b1b053fcfUL;
   tf->codes[8019] = 0x0000f32391b11548UL;
   tf->codes[8020] = 0x0000f32899fb9436UL;
   tf->codes[8021] = 0x0000f332e51f97d7UL;
   tf->codes[8022] = 0x0000f33ae6ad61c6UL;
   tf->codes[8023] = 0x0000f33eca2cc3dbUL;
   tf->codes[8024] = 0x0000f341fdff14a1UL;
   tf->codes[8025] = 0x0000f3506731801cUL;
   tf->codes[8026] = 0x0000f3536074cb1dUL;
   tf->codes[8027] = 0x0000f3561f291059UL;
   tf->codes[8028] = 0x0000f357f3a13e81UL;
   tf->codes[8029] = 0x0000f35b6202950cUL;
   tf->codes[8030] = 0x0000f36363905efbUL;
   tf->codes[8031] = 0x0000f36c14cb3a39UL;
   tf->codes[8032] = 0x0000f376d50d4964UL;
   tf->codes[8033] = 0x0000f3770f9c4f29UL;
   tf->codes[8034] = 0x0000f3774a2b54eeUL;
   tf->codes[8035] = 0x0000f37af31bb13eUL;
   tf->codes[8036] = 0x0000f380ab13417bUL;
   tf->codes[8037] = 0x0000f381954f588fUL;
   tf->codes[8038] = 0x0000f38454039dcbUL;
   tf->codes[8039] = 0x0000f386630ad1b8UL;
   tf->codes[8040] = 0x0000f387c264f456UL;
   tf->codes[8041] = 0x0000f38a468a33cdUL;
   tf->codes[8042] = 0x0000f38be0735c30UL;
   tf->codes[8043] = 0x0000f391d2f9f232UL;
   tf->codes[8044] = 0x0000f393e201261fUL;
   tf->codes[8045] = 0x0000f396db447120UL;
   tf->codes[8046] = 0x0000f39e2d2529c0UL;
   tf->codes[8047] = 0x0000f3a0b14a6937UL;
   tf->codes[8048] = 0x0000f3a19b86804bUL;
   tf->codes[8049] = 0x0000f3a1d6158610UL;
   tf->codes[8050] = 0x0000f3aa8750614eUL;
   tf->codes[8051] = 0x0000f3aac1df6713UL;
   tf->codes[8052] = 0x0000f3aedfedceedUL;
   tf->codes[8053] = 0x0000f3b213c01fb3UL;
   tf->codes[8054] = 0x0000f3b3388b3c8cUL;
   tf->codes[8055] = 0x0000f3b3731a4251UL;
   tf->codes[8056] = 0x0000f3b497e55f2aUL;
   tf->codes[8057] = 0x0000f3b8b5f3c704UL;
   tf->codes[8058] = 0x0000f3b9a02fde18UL;
   tf->codes[8059] = 0x0000f3bbaf371205UL;
   tf->codes[8060] = 0x0000f3bbe9c617caUL;
   tf->codes[8061] = 0x0000f3bdbe3e45f2UL;
   tf->codes[8062] = 0x0000f3c9a34b71f6UL;
   tf->codes[8063] = 0x0000f3da56141723UL;
   tf->codes[8064] = 0x0000f3db05c12872UL;
   tf->codes[8065] = 0x0000f3dd4f576224UL;
   tf->codes[8066] = 0x0000f3e257a1e112UL;
   tf->codes[8067] = 0x0000f3e8bf46829eUL;
   tf->codes[8068] = 0x0000f3e96ef393edUL;
   tf->codes[8069] = 0x0000f3eb7dfac7daUL;
   tf->codes[8070] = 0x0000f3f135f25817UL;
   tf->codes[8071] = 0x0000f3f1ab1063a1UL;
   tf->codes[8072] = 0x0000f3f3ba17978eUL;
   tf->codes[8073] = 0x0000f3f79d96f9a3UL;
   tf->codes[8074] = 0x0000f3fad1694a69UL;
   tf->codes[8075] = 0x0000f3fbbba5617dUL;
   tf->codes[8076] = 0x0000f4008960daa6UL;
   tf->codes[8077] = 0x0000f4025dd908ceUL;
   tf->codes[8078] = 0x0000f403f7c23131UL;
   tf->codes[8079] = 0x0000f40591ab5994UL;
   tf->codes[8080] = 0x0000f40a5f66d2bdUL;
   tf->codes[8081] = 0x0000f410c70b7449UL;
   tf->codes[8082] = 0x0000f411ebd69122UL;
   tf->codes[8083] = 0x0000f4129b83a271UL;
   tf->codes[8084] = 0x0000f415cf55f337UL;
   tf->codes[8085] = 0x0000f41d2136abd7UL;
   tf->codes[8086] = 0x0000f4208f980262UL;
   tf->codes[8087] = 0x0000f423c36a5328UL;
   tf->codes[8088] = 0x0000f425d2718715UL;
   tf->codes[8089] = 0x0000f426bcad9e29UL;
   tf->codes[8090] = 0x0000f428cbb4d216UL;
   tf->codes[8091] = 0x0000f42b4fda118dUL;
   tf->codes[8092] = 0x0000f432dc49cff2UL;
   tf->codes[8093] = 0x0000f4338bf6e141UL;
   tf->codes[8094] = 0x0000f435d58d1af3UL;
   tf->codes[8095] = 0x0000f44a6bd52235UL;
   tf->codes[8096] = 0x0000f450d379c3c1UL;
   tf->codes[8097] = 0x0000f451bdb5dad5UL;
   tf->codes[8098] = 0x0000f45232d3e65fUL;
   tf->codes[8099] = 0x0000f452a7f1f1e9UL;
   tf->codes[8100] = 0x0000f45441db1a4cUL;
   tf->codes[8101] = 0x0000f45f773b3501UL;
   tf->codes[8102] = 0x0000f463202b9151UL;
   tf->codes[8103] = 0x0000f464ba14b9b4UL;
   tf->codes[8104] = 0x0000f472739a13e0UL;
   tf->codes[8105] = 0x0000f47482a147cdUL;
   tf->codes[8106] = 0x0000f475e1fb6a6bUL;
   tf->codes[8107] = 0x0000f4761c8a7030UL;
   tf->codes[8108] = 0x0000f47691a87bbaUL;
   tf->codes[8109] = 0x0000f4798aebc6bbUL;
   tf->codes[8110] = 0x0000f47a7527ddcfUL;
   tf->codes[8111] = 0x0000f47aafb6e394UL;
   tf->codes[8112] = 0x0000f47b99f2faa8UL;
   tf->codes[8113] = 0x0000f4818c7990aaUL;
   tf->codes[8114] = 0x0000f48276b5a7beUL;
   tf->codes[8115] = 0x0000f482ebd3b348UL;
   tf->codes[8116] = 0x0000f485e516fe49UL;
   tf->codes[8117] = 0x0000f4861fa6040eUL;
   tf->codes[8118] = 0x0000f4865a3509d3UL;
   tf->codes[8119] = 0x0000f488693c3dc0UL;
   tf->codes[8120] = 0x0000f4944e4969c4UL;
   tf->codes[8121] = 0x0000f494fdf67b13UL;
   tf->codes[8122] = 0x0000f4986c57d19eUL;
   tf->codes[8123] = 0x0000f4a0e303a717UL;
   tf->codes[8124] = 0x0000f4a53ba114b6UL;
   tf->codes[8125] = 0x0000f4aaf398a4f3UL;
   tf->codes[8126] = 0x0000f4b15b3d467fUL;
   tf->codes[8127] = 0x0000f4b245795d93UL;
   tf->codes[8128] = 0x0000f4b5794bae59UL;
   tf->codes[8129] = 0x0000f4b8e7ad04e4UL;
   tf->codes[8130] = 0x0000f4ba47072782UL;
   tf->codes[8131] = 0x0000f4c1d376e5e7UL;
   tf->codes[8132] = 0x0000f4c5b6f647fcUL;
   tf->codes[8133] = 0x0000f4c78b6e7624UL;
   tf->codes[8134] = 0x0000f4c8008c81aeUL;
   tf->codes[8135] = 0x0000f4d0021a4b9dUL;
   tf->codes[8136] = 0x0000f4d3ab0aa7edUL;
   tf->codes[8137] = 0x0000f4dc21b67d66UL;
   tf->codes[8138] = 0x0000f4dea5dbbcddUL;
   tf->codes[8139] = 0x0000f4e806c3a96aUL;
   tf->codes[8140] = 0x0000f4e8b670bab9UL;
   tf->codes[8141] = 0x0000f4f5109bf247UL;
   tf->codes[8142] = 0x0000f4f8446e430dUL;
   tf->codes[8143] = 0x0000f4fc27eda522UL;
   tf->codes[8144] = 0x0000f4fd8747c7c0UL;
   tf->codes[8145] = 0x0000f4feac12e499UL;
   tf->codes[8146] = 0x0000f504d9288060UL;
   tf->codes[8147] = 0x0000f50797dcc59cUL;
   tf->codes[8148] = 0x0000f5100e889b15UL;
   tf->codes[8149] = 0x0000f5158bf1258dUL;
   tf->codes[8150] = 0x0000f517606953b5UL;
   tf->codes[8151] = 0x0000f51a1f1d98f1UL;
   tf->codes[8152] = 0x0000f51bf395c719UL;
   tf->codes[8153] = 0x0000f51c68b3d2a3UL;
   tf->codes[8154] = 0x0000f528c2df0a31UL;
   tf->codes[8155] = 0x0000f528fd6e0ff6UL;
   tf->codes[8156] = 0x0000f529728c1b80UL;
   tf->codes[8157] = 0x0000f52ad1e63e1eUL;
   tf->codes[8158] = 0x0000f530c46cd420UL;
   tf->codes[8159] = 0x0000f532d374080dUL;
   tf->codes[8160] = 0x0000f5346d5d3070UL;
   tf->codes[8161] = 0x0000f534a7ec3635UL;
   tf->codes[8162] = 0x0000f536074658d3UL;
   tf->codes[8163] = 0x0000f5367c64645dUL;
   tf->codes[8164] = 0x0000f5393b18a999UL;
   tf->codes[8165] = 0x0000f53a2554c0adUL;
   tf->codes[8166] = 0x0000f5413ca67388UL;
   tf->codes[8167] = 0x0000f541b1c47f12UL;
   tf->codes[8168] = 0x0000f5434bada775UL;
   tf->codes[8169] = 0x0000f545cfd2e6ecUL;
   tf->codes[8170] = 0x0000f5505585f052UL;
   tf->codes[8171] = 0x0000f5547394582cUL;
   tf->codes[8172] = 0x0000f554ae235df1UL;
   tf->codes[8173] = 0x0000f55bc57510ccUL;
   tf->codes[8174] = 0x0000f55d24cf336aUL;
   tf->codes[8175] = 0x0000f55d99ed3ef4UL;
   tf->codes[8176] = 0x0000f560cdbf8fbaUL;
   tf->codes[8177] = 0x0000f561b7fba6ceUL;
   tf->codes[8178] = 0x0000f56aa3c587d1UL;
   tf->codes[8179] = 0x0000f57529789137UL;
   tf->codes[8180] = 0x0000f575d925a286UL;
   tf->codes[8181] = 0x0000f576fdf0bf5fUL;
   tf->codes[8182] = 0x0000f57d659560ebUL;
   tf->codes[8183] = 0x0000f57da02466b0UL;
   tf->codes[8184] = 0x0000f57faf2b9a9dUL;
   tf->codes[8185] = 0x0000f581f8c1d44fUL;
   tf->codes[8186] = 0x0000f584f2051f50UL;
   tf->codes[8187] = 0x0000f58b9438c6a1UL;
   tf->codes[8188] = 0x0000f594f520b32eUL;
   tf->codes[8189] = 0x0000f59828f303f4UL;
   tf->codes[8190] = 0x0000f598d8a01543UL;
   tf->codes[8191] = 0x0000f59ae7a74930UL;
   tf->codes[8192] = 0x0000f59c0c726609UL;
   tf->codes[8193] = 0x0000f59f05b5b10aUL;
   tf->codes[8194] = 0x0000f5a35e531ea9UL;
   tf->codes[8195] = 0x0000f5a7f17f920dUL;
   tf->codes[8196] = 0x0000f5ac4a1cffacUL;
   tf->codes[8197] = 0x0000f5b4fb57daeaUL;
   tf->codes[8198] = 0x0000f5b57075e674UL;
   tf->codes[8199] = 0x0000f5ba03a259d8UL;
   tf->codes[8200] = 0x0000f5bcc2569f14UL;
   tf->codes[8201] = 0x0000f5bd7203b063UL;
   tf->codes[8202] = 0x0000f5be5c3fc777UL;
   tf->codes[8203] = 0x0000f5bf810ae450UL;
   tf->codes[8204] = 0x0000f5c030b7f59fUL;
   tf->codes[8205] = 0x0000f5c0e06506eeUL;
   tf->codes[8206] = 0x0000f5c7f7b6b9c9UL;
   tf->codes[8207] = 0x0000f5ca414cf37bUL;
   tf->codes[8208] = 0x0000f5d1cdbcb1e0UL;
   tf->codes[8209] = 0x0000f5d41752eb92UL;
   tf->codes[8210] = 0x0000f5d4c6fffce1UL;
   tf->codes[8211] = 0x0000f5d710963693UL;
   tf->codes[8212] = 0x0000f5d785b4421dUL;
   tf->codes[8213] = 0x0000f5db6933a432UL;
   tf->codes[8214] = 0x0000f5dd783ad81fUL;
   tf->codes[8215] = 0x0000f5ded794fabdUL;
   tf->codes[8216] = 0x0000f5e1212b346fUL;
   tf->codes[8217] = 0x0000f5e33032685cUL;
   tf->codes[8218] = 0x0000f5e53f399c49UL;
   tf->codes[8219] = 0x0000f5ea821320fcUL;
   tf->codes[8220] = 0x0000f5eba6de3dd5UL;
   tf->codes[8221] = 0x0000f5ec1bfc495fUL;
   tf->codes[8222] = 0x0000f5ee2b037d4cUL;
   tf->codes[8223] = 0x0000f5f3e2fb0d89UL;
   tf->codes[8224] = 0x0000f5f507c62a62UL;
   tf->codes[8225] = 0x0000f5fbe488d778UL;
   tf->codes[8226] = 0x0000f6066a3be0deUL;
   tf->codes[8227] = 0x0000f61005b2d330UL;
   tf->codes[8228] = 0x0000f6112a7df009UL;
   tf->codes[8229] = 0x0000f611da2b0158UL;
   tf->codes[8230] = 0x0000f6145e5040cfUL;
   tf->codes[8231] = 0x0000f6171d04860bUL;
   tf->codes[8232] = 0x0000f61792229195UL;
   tf->codes[8233] = 0x0000f623b1bec35eUL;
   tf->codes[8234] = 0x0000f62b3e2e81c3UL;
   tf->codes[8235] = 0x0000f6325580349eUL;
   tf->codes[8236] = 0x0000f63a1c7ef8c8UL;
   tf->codes[8237] = 0x0000f63a570dfe8dUL;
   tf->codes[8238] = 0x0000f63bb668212bUL;
   tf->codes[8239] = 0x0000f63cdb333e04UL;
   tf->codes[8240] = 0x0000f640f941a5deUL;
   tf->codes[8241] = 0x0000f6437d66e555UL;
   tf->codes[8242] = 0x0000f64467a2fc69UL;
   tf->codes[8243] = 0x0000f646b139361bUL;
   tf->codes[8244] = 0x0000f647d60452f4UL;
   tf->codes[8245] = 0x0000f64885b16443UL;
   tf->codes[8246] = 0x0000f651717b4546UL;
   tf->codes[8247] = 0x0000f6584e3df25cUL;
   tf->codes[8248] = 0x0000f669eb42ae9dUL;
   tf->codes[8249] = 0x0000f66b852bd700UL;
   tf->codes[8250] = 0x0000f67102946178UL;
   tf->codes[8251] = 0x0000f673119b9565UL;
   tf->codes[8252] = 0x0000f67595c0d4dcUL;
   tf->codes[8253] = 0x0000f6788f041fddUL;
   tf->codes[8254] = 0x0000f67b88476adeUL;
   tf->codes[8255] = 0x0000f683c4643a92UL;
   tf->codes[8256] = 0x0000f68474114be1UL;
   tf->codes[8257] = 0x0000f694ec4aeb49UL;
   tf->codes[8258] = 0x0000f69a2f246ffcUL;
   tf->codes[8259] = 0x0000f69cb349af73UL;
   tf->codes[8260] = 0x0000f69e4d32d7d6UL;
   tf->codes[8261] = 0x0000f6a3557d56c4UL;
   tf->codes[8262] = 0x0000f6a3ca9b624eUL;
   tf->codes[8263] = 0x0000f6a4052a6813UL;
   tf->codes[8264] = 0x0000f6a47a48739dUL;
   tf->codes[8265] = 0x0000f6a4b4d77962UL;
   tf->codes[8266] = 0x0000f6a6894fa78aUL;
   tf->codes[8267] = 0x0000f6a7ae1ac463UL;
   tf->codes[8268] = 0x0000f6b18420bc7aUL;
   tf->codes[8269] = 0x0000f6b31e09e4ddUL;
   tf->codes[8270] = 0x0000f6b985ae8669UL;
   tf->codes[8271] = 0x0000f6c0d78f3f09UL;
   tf->codes[8272] = 0x0000f6c3212578bbUL;
   tf->codes[8273] = 0x0000f6c5dfd9bdf7UL;
   tf->codes[8274] = 0x0000f6c94e3b1482UL;
   tf->codes[8275] = 0x0000f6cb22b342aaUL;
   tf->codes[8276] = 0x0000f6d14fc8de71UL;
   tf->codes[8277] = 0x0000f6d6cd3168e9UL;
   tf->codes[8278] = 0x0000f6d8dc389cd6UL;
   tf->codes[8279] = 0x0000f6da0103b9afUL;
   tf->codes[8280] = 0x0000f6dcbfb7feebUL;
   tf->codes[8281] = 0x0000f6dcfa4704b0UL;
   tf->codes[8282] = 0x0000f6dd6f65103aUL;
   tf->codes[8283] = 0x0000f6de59a1274eUL;
   tf->codes[8284] = 0x0000f6e02e195576UL;
   tf->codes[8285] = 0x0000f6e361eba63cUL;
   tf->codes[8286] = 0x0000f6e3d709b1c6UL;
   tf->codes[8287] = 0x0000f6e44c27bd50UL;
   tf->codes[8288] = 0x0000f6e570f2da29UL;
   tf->codes[8289] = 0x0000f6e6209feb78UL;
   tf->codes[8290] = 0x0000f6ee5cbcbb2cUL;
   tf->codes[8291] = 0x0000f6ef8187d805UL;
   tf->codes[8292] = 0x0000f6f15600062dUL;
   tf->codes[8293] = 0x0000f6f205ad177cUL;
   tf->codes[8294] = 0x0000f6f489d256f3UL;
   tf->codes[8295] = 0x0000f6f78315a1f4UL;
   tf->codes[8296] = 0x0000f6f7bda4a7b9UL;
   tf->codes[8297] = 0x0000f6f9ccabdba6UL;
   tf->codes[8298] = 0x0000f6fb2c05fe44UL;
   tf->codes[8299] = 0x0000f6fc16421558UL;
   tf->codes[8300] = 0x0000f6fd759c37f6UL;
   tf->codes[8301] = 0x0000f6fdeaba4380UL;
   tf->codes[8302] = 0x0000f7032d93c833UL;
   tf->codes[8303] = 0x0000f707863135d2UL;
   tf->codes[8304] = 0x0000f70f4d2ff9fcUL;
   tf->codes[8305] = 0x0000f710376c1110UL;
   tf->codes[8306] = 0x0000f71071fb16d5UL;
   tf->codes[8307] = 0x0000f7169f10b29cUL;
   tf->codes[8308] = 0x0000f717894cc9b0UL;
   tf->codes[8309] = 0x0000f717fe6ad53aUL;
   tf->codes[8310] = 0x0000f7187388e0c4UL;
   tf->codes[8311] = 0x0000f7195dc4f7d8UL;
   tf->codes[8312] = 0x0000f71a0d720927UL;
   tf->codes[8313] = 0x0000f71a829014b1UL;
   tf->codes[8314] = 0x0000f71ba75b318aUL;
   tf->codes[8315] = 0x0000f71d06b55428UL;
   tf->codes[8316] = 0x0000f71d414459edUL;
   tf->codes[8317] = 0x0000f7249325128dUL;
   tf->codes[8318] = 0x0000f72baa76c568UL;
   tf->codes[8319] = 0x0000f73545edb7baUL;
   tf->codes[8320] = 0x0000f73bad925946UL;
   tf->codes[8321] = 0x0000f73df72892f8UL;
   tf->codes[8322] = 0x0000f745be275722UL;
   tf->codes[8323] = 0x0000f7496717b372UL;
   tf->codes[8324] = 0x0000f74a16c4c4c1UL;
   tf->codes[8325] = 0x0000f753028ea5c4UL;
   tf->codes[8326] = 0x0000f7551195d9b1UL;
   tf->codes[8327] = 0x0000f7554c24df76UL;
   tf->codes[8328] = 0x0000f756e60e07d9UL;
   tf->codes[8329] = 0x0000f758ba863601UL;
   tf->codes[8330] = 0x0000f7592fa4418bUL;
   tf->codes[8331] = 0x0000f75a19e0589fUL;
   tf->codes[8332] = 0x0000f75c63769251UL;
   tf->codes[8333] = 0x0000f75e37eec079UL;
   tf->codes[8334] = 0x0000f75ead0ccc03UL;
   tf->codes[8335] = 0x0000f760bc13fff0UL;
   tf->codes[8336] = 0x0000f766740b902dUL;
   tf->codes[8337] = 0x0000f7684883be55UL;
   tf->codes[8338] = 0x0000f768bda1c9dfUL;
   tf->codes[8339] = 0x0000f76a578af242UL;
   tf->codes[8340] = 0x0000f76eb0285fe1UL;
   tf->codes[8341] = 0x0000f7721e89b66cUL;
   tf->codes[8342] = 0x0000f77293a7c1f6UL;
   tf->codes[8343] = 0x0000f77761633b1fUL;
   tf->codes[8344] = 0x0000f77a95358be5UL;
   tf->codes[8345] = 0x0000f77d8e78d6e6UL;
   tf->codes[8346] = 0x0000f77fd80f1098UL;
   tf->codes[8347] = 0x0000f7867a42b7e9UL;
   tf->codes[8348] = 0x0000f788c3d8f19bUL;
   tf->codes[8349] = 0x0000f78fa09b9eb1UL;
   tf->codes[8350] = 0x0000f7967d5e4bc7UL;
   tf->codes[8351] = 0x0000f79c3555dc04UL;
   tf->codes[8352] = 0x0000f7a31218891aUL;
   tf->codes[8353] = 0x0000f7a3873694a4UL;
   tf->codes[8354] = 0x0000f7a81a630808UL;
   tf->codes[8355] = 0x0000f7b01bf0d1f7UL;
   tf->codes[8356] = 0x0000f7b1b5d9fa5aUL;
   tf->codes[8357] = 0x0000f7b2a016116eUL;
   tf->codes[8358] = 0x0000f7b34fc322bdUL;
   tf->codes[8359] = 0x0000f7b5243b50e5UL;
   tf->codes[8360] = 0x0000f7bc3b8d03c0UL;
   tf->codes[8361] = 0x0000f7bdd5762c23UL;
   tf->codes[8362] = 0x0000f7be100531e8UL;
   tf->codes[8363] = 0x0000f7bebfb24337UL;
   tf->codes[8364] = 0x0000f7c0599b6b9aUL;
   tf->codes[8365] = 0x0000f7c22e1399c2UL;
   tf->codes[8366] = 0x0000f7c477a9d374UL;
   tf->codes[8367] = 0x0000f7c90ad646d8UL;
   tf->codes[8368] = 0x0000f7ca2fa163b1UL;
   tf->codes[8369] = 0x0000f7ce4dafcb8bUL;
   tf->codes[8370] = 0x0000f7cf37ebe29fUL;
   tf->codes[8371] = 0x0000f7d10c6410c7UL;
   tf->codes[8372] = 0x0000f7d1f6a027dbUL;
   tf->codes[8373] = 0x0000f7d64f3d957aUL;
   tf->codes[8374] = 0x0000f7d689cc9b3fUL;
   tf->codes[8375] = 0x0000f7d6c45ba104UL;
   tf->codes[8376] = 0x0000f7d8d362d4f1UL;
   tf->codes[8377] = 0x0000f7d94880e07bUL;
   tf->codes[8378] = 0x0000f7da6d4bfd54UL;
   tf->codes[8379] = 0x0000f7db92171a2dUL;
   tf->codes[8380] = 0x0000f7dddbad53dfUL;
   tf->codes[8381] = 0x0000f7de8b5a652eUL;
   tf->codes[8382] = 0x0000f7dfeab487ccUL;
   tf->codes[8383] = 0x0000f7e0d4f09ee0UL;
   tf->codes[8384] = 0x0000f7e14a0eaa6aUL;
   tf->codes[8385] = 0x0000f7e4f2ff06baUL;
   tf->codes[8386] = 0x0000f7e5681d1244UL;
   tf->codes[8387] = 0x0000f7ea70679132UL;
   tf->codes[8388] = 0x0000f7f3d14f7dbfUL;
   tf->codes[8389] = 0x0000f7f4bb8b94d3UL;
   tf->codes[8390] = 0x0000f7f7ef5de599UL;
   tf->codes[8391] = 0x0000f7fae8a1309aUL;
   tf->codes[8392] = 0x0000f7fbd2dd47aeUL;
   tf->codes[8393] = 0x0000f808dcb5908bUL;
   tf->codes[8394] = 0x0000f80b9b69d5c7UL;
   tf->codes[8395] = 0x0000f80daa7109b4UL;
   tf->codes[8396] = 0x0000f8141215ab40UL;
   tf->codes[8397] = 0x0000f816963aeab7UL;
   tf->codes[8398] = 0x0000f81d72fd97cdUL;
   tf->codes[8399] = 0x0000f81f8204cbbaUL;
   tf->codes[8400] = 0x0000f829580ac3d1UL;
   tf->codes[8401] = 0x0000f8332e10bbe8UL;
   tf->codes[8402] = 0x0000f836d7011838UL;
   tf->codes[8403] = 0x0000f8374c1f23c2UL;
   tf->codes[8404] = 0x0000f83b2f9e85d7UL;
   tf->codes[8405] = 0x0000f83bdf4b9726UL;
   tf->codes[8406] = 0x0000f84a487e02a1UL;
   tf->codes[8407] = 0x0000f84ba7d8253fUL;
   tf->codes[8408] = 0x0000f8536ed6e969UL;
   tf->codes[8409] = 0x0000f8557dde1d56UL;
   tf->codes[8410] = 0x0000f859d67b8af5UL;
   tf->codes[8411] = 0x0000f85ea437041eUL;
   tf->codes[8412] = 0x0000f860b33e380bUL;
   tf->codes[8413] = 0x0000f861285c4395UL;
   tf->codes[8414] = 0x0000f8666b35c848UL;
   tf->codes[8415] = 0x0000f86a89443022UL;
   tf->codes[8416] = 0x0000f8712b77d773UL;
   tf->codes[8417] = 0x0000f871a095e2fdUL;
   tf->codes[8418] = 0x0000f8725042f44cUL;
   tf->codes[8419] = 0x0000f873750e1125UL;
   tf->codes[8420] = 0x0000f87424bb2274UL;
   tf->codes[8421] = 0x0000f875f933509cUL;
   tf->codes[8422] = 0x0000f8792d05a162UL;
   tf->codes[8423] = 0x0000f8875ba90718UL;
   tf->codes[8424] = 0x0000f890f71ff96aUL;
   tf->codes[8425] = 0x0000f8937b4538e1UL;
   tf->codes[8426] = 0x0000f895152e6144UL;
   tf->codes[8427] = 0x0000f895ff6a7858UL;
   tf->codes[8428] = 0x0000f898838fb7cfUL;
   tf->codes[8429] = 0x0000f89a1d78e032UL;
   tf->codes[8430] = 0x0000f8a16f5998d2UL;
   tf->codes[8431] = 0x0000f8a7d6fe3a5eUL;
   tf->codes[8432] = 0x0000f8b04daa0fd7UL;
   tf->codes[8433] = 0x0000f8b1ad043275UL;
   tf->codes[8434] = 0x0000f8b3817c609dUL;
   tf->codes[8435] = 0x0000f8b46bb877b1UL;
   tf->codes[8436] = 0x0000f8b8fee4eb15UL;
   tf->codes[8437] = 0x0000f8bb830a2a8cUL;
   tf->codes[8438] = 0x0000f8be41be6fc8UL;
   tf->codes[8439] = 0x0000f8bfdba7982bUL;
   tf->codes[8440] = 0x0000f8c17590c08eUL;
   tf->codes[8441] = 0x0000f8c608bd33f2UL;
   tf->codes[8442] = 0x0000f8d6f614dee4UL;
   tf->codes[8443] = 0x0000f8d9051c12d1UL;
   tf->codes[8444] = 0x0000f8db142346beUL;
   tf->codes[8445] = 0x0000f8dbc3d0580dUL;
   tf->codes[8446] = 0x0000f8de0d6691bfUL;
   tf->codes[8447] = 0x0000f8e0cc1ad6fbUL;
   tf->codes[8448] = 0x0000f8e60ef45baeUL;
   tf->codes[8449] = 0x0000f8e76e4e7e4cUL;
   tf->codes[8450] = 0x0000f8e8588a9560UL;
   tf->codes[8451] = 0x0000f8e893199b25UL;
   tf->codes[8452] = 0x0000f8e97d55b239UL;
   tf->codes[8453] = 0x0000f8eb173eda9cUL;
   tf->codes[8454] = 0x0000f8f47826c729UL;
   tf->codes[8455] = 0x0000f8f64c9ef551UL;
   tf->codes[8456] = 0x0000f8fc79b49118UL;
   tf->codes[8457] = 0x0000f901bc8e15cbUL;
   tf->codes[8458] = 0x0000f902e15932a4UL;
   tf->codes[8459] = 0x0000f903910643f3UL;
   tf->codes[8460] = 0x0000f90bcd2313a7UL;
   tf->codes[8461] = 0x0000f9173d123421UL;
   tf->codes[8462] = 0x0000f91777a139e6UL;
   tf->codes[8463] = 0x0000f9209dfa20aeUL;
   tf->codes[8464] = 0x0000f921883637c2UL;
   tf->codes[8465] = 0x0000f928da16f062UL;
   tf->codes[8466] = 0x0000f92ecc9d8664UL;
   tf->codes[8467] = 0x0000f935a960337aUL;
   tf->codes[8468] = 0x0000f939c76e9b54UL;
   tf->codes[8469] = 0x0000f93aec39b82dUL;
   tf->codes[8470] = 0x0000f93ecfb91a42UL;
   tf->codes[8471] = 0x0000f9423e1a70cdUL;
   tf->codes[8472] = 0x0000f943d8039930UL;
   tf->codes[8473] = 0x0000f94412929ef5UL;
   tf->codes[8474] = 0x0000f94b9f025d5aUL;
   tf->codes[8475] = 0x0000f94dae099147UL;
   tf->codes[8476] = 0x0000f9519188f35cUL;
   tf->codes[8477] = 0x0000f95415ae32d3UL;
   tf->codes[8478] = 0x0000f956d462780fUL;
   tf->codes[8479] = 0x0000f957840f895eUL;
   tf->codes[8480] = 0x0000f957f92d94e8UL;
   tf->codes[8481] = 0x0000f95af270dfe9UL;
   tf->codes[8482] = 0x0000f95bdcacf6fdUL;
   tf->codes[8483] = 0x0000f95c51cb0287UL;
   tf->codes[8484] = 0x0000f95debb42aeaUL;
   tf->codes[8485] = 0x0000f95e9b613c39UL;
   tf->codes[8486] = 0x0000f95ed5f041feUL;
   tf->codes[8487] = 0x0000f95f4b0e4d88UL;
   tf->codes[8488] = 0x0000f963a3abbb27UL;
   tf->codes[8489] = 0x0000f9648de7d23bUL;
   tf->codes[8490] = 0x0000f9657823e94fUL;
   tf->codes[8491] = 0x0000f965ed41f4d9UL;
   tf->codes[8492] = 0x0000f967120d11b2UL;
   tf->codes[8493] = 0x0000f967872b1d3cUL;
   tf->codes[8494] = 0x0000f96ffdd6f2b5UL;
   tf->codes[8495] = 0x0000f9715d311553UL;
   tf->codes[8496] = 0x0000f97331a9437bUL;
   tf->codes[8497] = 0x0000f9736c384940UL;
   tf->codes[8498] = 0x0000f976a00a9a06UL;
   tf->codes[8499] = 0x0000f979242fd97dUL;
   tf->codes[8500] = 0x0000f97ccd2035cdUL;
   tf->codes[8501] = 0x0000f9803b818c58UL;
   tf->codes[8502] = 0x0000f981d56ab4bbUL;
   tf->codes[8503] = 0x0000f985f3791c95UL;
   tf->codes[8504] = 0x0000f9862e08225aUL;
   tf->codes[8505] = 0x0000f9866897281fUL;
   tf->codes[8506] = 0x0000f9871844396eUL;
   tf->codes[8507] = 0x0000f98a4c168a34UL;
   tf->codes[8508] = 0x0000f9903e9d2036UL;
   tf->codes[8509] = 0x0000f990b3bb2bc0UL;
   tf->codes[8510] = 0x0000f99163683d0fUL;
   tf->codes[8511] = 0x0000f9924da45423UL;
   tf->codes[8512] = 0x0000f995f694b073UL;
   tf->codes[8513] = 0x0000f998059be460UL;
   tf->codes[8514] = 0x0000f99a89c123d7UL;
   tf->codes[8515] = 0x0000f99ac450299cUL;
   tf->codes[8516] = 0x0000f99b396e3526UL;
   tf->codes[8517] = 0x0000f99dbd93749dUL;
   tf->codes[8518] = 0x0000f9a041b8b414UL;
   tf->codes[8519] = 0x0000f9aa17beac2bUL;
   tf->codes[8520] = 0x0000f9aac76bbd7aUL;
   tf->codes[8521] = 0x0000f9b2c8f98769UL;
   tf->codes[8522] = 0x0000f9b5c23cd26aUL;
   tf->codes[8523] = 0x0000f9ba8ff84b93UL;
   tf->codes[8524] = 0x0000f9bd893b9694UL;
   tf->codes[8525] = 0x0000f9c047efdbd0UL;
   tf->codes[8526] = 0x0000f9c1322bf2e4UL;
   tf->codes[8527] = 0x0000f9c6ea238321UL;
   tf->codes[8528] = 0x0000f9cacda2e536UL;
   tf->codes[8529] = 0x0000f9cdc6e63037UL;
   tf->codes[8530] = 0x0000f9d4de37e312UL;
   tf->codes[8531] = 0x0000f9d887283f62UL;
   tf->codes[8532] = 0x0000f9dad0be7914UL;
   tf->codes[8533] = 0x0000f9e04e27038cUL;
   tf->codes[8534] = 0x0000f9e25d2e3779UL;
   tf->codes[8535] = 0x0000f9e3476a4e8dUL;
   tf->codes[8536] = 0x0000f9e3bc885a17UL;
   tf->codes[8537] = 0x0000f9e3f7175fdcUL;
   tf->codes[8538] = 0x0000f9e6b5cba518UL;
   tf->codes[8539] = 0x0000f9e76578b667UL;
   tf->codes[8540] = 0x0000f9ea242cfba3UL;
   tf->codes[8541] = 0x0000f9f2d567d6e1UL;
   tf->codes[8542] = 0x0000f9f3fa32f3baUL;
   tf->codes[8543] = 0x0000f9f5ceab21e2UL;
   tf->codes[8544] = 0x0000f9f88d5f671eUL;
   tf->codes[8545] = 0x0000f9fdd038ebd1UL;
   tf->codes[8546] = 0x0000fa04726c9322UL;
   tf->codes[8547] = 0x0000fa04acfb98e7UL;
   tf->codes[8548] = 0x0000fa04e78a9eacUL;
   tf->codes[8549] = 0x0000fa08cb0a00c1UL;
   tf->codes[8550] = 0x0000fa0a2a64235fUL;
   tf->codes[8551] = 0x0000fa0f6d3da812UL;
   tf->codes[8552] = 0x0000fa0fe25bb39cUL;
   tf->codes[8553] = 0x0000fa105779bf26UL;
   tf->codes[8554] = 0x0000fa12a10ff8d8UL;
   tf->codes[8555] = 0x0000fa138b4c0fecUL;
   tf->codes[8556] = 0x0000fa1893968edaUL;
   tf->codes[8557] = 0x0000fa1a2d7fb73dUL;
   tf->codes[8558] = 0x0000fa2896b222b8UL;
   tf->codes[8559] = 0x0000fa2b8ff56db9UL;
   tf->codes[8560] = 0x0000fa2c05137943UL;
   tf->codes[8561] = 0x0000fa305db0e6e2UL;
   tf->codes[8562] = 0x0000fa310d5df831UL;
   tf->codes[8563] = 0x0000fa326cb81acfUL;
   tf->codes[8564] = 0x0000fa34b64e5481UL;
   tf->codes[8565] = 0x0000fa3ddca73b49UL;
   tf->codes[8566] = 0x0000fa40d5ea864aUL;
   tf->codes[8567] = 0x0000fa42aa62b472UL;
   tf->codes[8568] = 0x0000fa47b2ad3360UL;
   tf->codes[8569] = 0x0000fa4b5b9d8fb0UL;
   tf->codes[8570] = 0x0000fa4fb43afd4fUL;
   tf->codes[8571] = 0x0000fa5397ba5f64UL;
   tf->codes[8572] = 0x0000fa54bc857c3dUL;
   tf->codes[8573] = 0x0000fa57061bb5efUL;
   tf->codes[8574] = 0x0000fa577b39c179UL;
   tf->codes[8575] = 0x0000fa586575d88dUL;
   tf->codes[8576] = 0x0000fa5d333151b6UL;
   tf->codes[8577] = 0x0000fa63d564f907UL;
   tf->codes[8578] = 0x0000fa6534bf1ba5UL;
   tf->codes[8579] = 0x0000fa66cea84408UL;
   tf->codes[8580] = 0x0000fa677e555557UL;
   tf->codes[8581] = 0x0000fa67f37360e1UL;
   tf->codes[8582] = 0x0000fa6868916c6bUL;
   tf->codes[8583] = 0x0000fa68a3207230UL;
   tf->codes[8584] = 0x0000fa6a7798a058UL;
   tf->codes[8585] = 0x0000fa74fd4ba9beUL;
   tf->codes[8586] = 0x0000fa791b5a1198UL;
   tf->codes[8587] = 0x0000fa83667e1539UL;
   tf->codes[8588] = 0x0000fa92f47b9d8dUL;
   tf->codes[8589] = 0x0000fa9453d5c02bUL;
   tf->codes[8590] = 0x0000fa9921913954UL;
   tf->codes[8591] = 0x0000fa99d13e4aa3UL;
   tf->codes[8592] = 0x0000fa9f4ea6d51bUL;
   tf->codes[8593] = 0x0000fa9ffe53e66aUL;
   tf->codes[8594] = 0x0000faa1231f0343UL;
   tf->codes[8595] = 0x0000faae678651e5UL;
   tf->codes[8596] = 0x0000fab0ebab915cUL;
   tf->codes[8597] = 0x0000fab28594b9bfUL;
   tf->codes[8598] = 0x0000fab5b9670a85UL;
   tf->codes[8599] = 0x0000fab7535032e8UL;
   tf->codes[8600] = 0x0000fab9625766d5UL;
   tf->codes[8601] = 0x0000fabedfbff14dUL;
   tf->codes[8602] = 0x0000fac03f1a13ebUL;
   tf->codes[8603] = 0x0000facbaf093465UL;
   tf->codes[8604] = 0x0000fad04235a7c9UL;
   tf->codes[8605] = 0x0000fad1dc1ed02cUL;
   tf->codes[8606] = 0x0000fad2513cdbb6UL;
   tf->codes[8607] = 0x0000fad5bf9e3241UL;
   tf->codes[8608] = 0x0000fad87e52777dUL;
   tf->codes[8609] = 0x0000fada183b9fe0UL;
   tf->codes[8610] = 0x0000fae219c969cfUL;
   tf->codes[8611] = 0x0000fae3b3b29232UL;
   tf->codes[8612] = 0x0000fae846df0596UL;
   tf->codes[8613] = 0x0000faf0f819e0d4UL;
   tf->codes[8614] = 0x0000faf21ce4fdadUL;
   tf->codes[8615] = 0x0000faf37c3f204bUL;
   tf->codes[8616] = 0x0000faf3f15d2bd5UL;
   tf->codes[8617] = 0x0000faf4a10a3d24UL;
   tf->codes[8618] = 0x0000faf5162848aeUL;
   tf->codes[8619] = 0x0000faf58b465438UL;
   tf->codes[8620] = 0x0000faf5c5d559fdUL;
   tf->codes[8621] = 0x0000faf8f9a7aac3UL;
   tf->codes[8622] = 0x0000fb004b886363UL;
   tf->codes[8623] = 0x0000fb02cfada2daUL;
   tf->codes[8624] = 0x0000fb0a218e5b7aUL;
   tf->codes[8625] = 0x0000fb0d8fefb205UL;
   tf->codes[8626] = 0x0000fb0fd985ebb7UL;
   tf->codes[8627] = 0x0000fb101414f17cUL;
   tf->codes[8628] = 0x0000fb151c5f706aUL;
   tf->codes[8629] = 0x0000fb1b0ee6066cUL;
   tf->codes[8630] = 0x0000fb1b840411f6UL;
   tf->codes[8631] = 0x0000fb1bbe9317bbUL;
   tf->codes[8632] = 0x0000fb1bf9221d80UL;
   tf->codes[8633] = 0x0000fb208c4e90e4UL;
   tf->codes[8634] = 0x0000fb23c020e1aaUL;
   tf->codes[8635] = 0x0000fb23faafe76fUL;
   tf->codes[8636] = 0x0000fb2769113dfaUL;
   tf->codes[8637] = 0x0000fb29781871e7UL;
   tf->codes[8638] = 0x0000fb30c9f92a87UL;
   tf->codes[8639] = 0x0000fb33138f6439UL;
   tf->codes[8640] = 0x0000fb37e14add62UL;
   tf->codes[8641] = 0x0000fb385668e8ecUL;
   tf->codes[8642] = 0x0000fb397b3405c5UL;
   tf->codes[8643] = 0x0000fb3bff59453cUL;
   tf->codes[8644] = 0x0000fb3ce9955c50UL;
   tf->codes[8645] = 0x0000fb3d5eb367daUL;
   tf->codes[8646] = 0x0000fb40cd14be65UL;
   tf->codes[8647] = 0x0000fb41b750d579UL;
   tf->codes[8648] = 0x0000fb422c6ee103UL;
   tf->codes[8649] = 0x0000fb443b7614f0UL;
   tf->codes[8650] = 0x0000fb4fab65356aUL;
   tf->codes[8651] = 0x0000fb56fd45ee0aUL;
   tf->codes[8652] = 0x0000fb5c401f72bdUL;
   tf->codes[8653] = 0x0000fb5cefcc840cUL;
   tf->codes[8654] = 0x0000fb5e1497a0e5UL;
   tf->codes[8655] = 0x0000fb6a3433d2aeUL;
   tf->codes[8656] = 0x0000fb6fb19c5d26UL;
   tf->codes[8657] = 0x0000fb714b858589UL;
   tf->codes[8658] = 0x0000fb7235c19c9dUL;
   tf->codes[8659] = 0x0000fb7cbb74a603UL;
   tf->codes[8660] = 0x0000fb8029d5fc8eUL;
   tf->codes[8661] = 0x0000fb82736c3640UL;
   tf->codes[8662] = 0x0000fb82adfb3c05UL;
   tf->codes[8663] = 0x0000fb94faad0995UL;
   tf->codes[8664] = 0x0000fb96cf2537bdUL;
   tf->codes[8665] = 0x0000fb9c11febc70UL;
   tf->codes[8666] = 0x0000fb9ed0b301acUL;
   tf->codes[8667] = 0x0000fb9f0b420771UL;
   tf->codes[8668] = 0x0000fba0dfba3599UL;
   tf->codes[8669] = 0x0000fba18f6746e8UL;
   tf->codes[8670] = 0x0000fba2b43263c1UL;
   tf->codes[8671] = 0x0000fba7475ed725UL;
   tf->codes[8672] = 0x0000fba9cb84169cUL;
   tf->codes[8673] = 0x0000fbab9ffc44c4UL;
   tf->codes[8674] = 0x0000fbb03328b828UL;
   tf->codes[8675] = 0x0000fbb1cd11e08bUL;
   tf->codes[8676] = 0x0000fbb99410a4b5UL;
   tf->codes[8677] = 0x0000fbbc1835e42cUL;
   tf->codes[8678] = 0x0000fbbe273d1819UL;
   tf->codes[8679] = 0x0000fbc15b0f68dfUL;
   tf->codes[8680] = 0x0000fbc3a4a5a291UL;
   tf->codes[8681] = 0x0000fbc9972c3893UL;
   tf->codes[8682] = 0x0000fbcaf6865b31UL;
   tf->codes[8683] = 0x0000fbd2486713d1UL;
   tf->codes[8684] = 0x0000fbd62be675e6UL;
   tf->codes[8685] = 0x0000fbd78b409884UL;
   tf->codes[8686] = 0x0000fbd8b00bb55dUL;
   tf->codes[8687] = 0x0000fbd95fb8c6acUL;
   tf->codes[8688] = 0x0000fbe126b78ad6UL;
   tf->codes[8689] = 0x0000fbe3e56bd012UL;
   tf->codes[8690] = 0x0000fbeac22e7d28UL;
   tf->codes[8691] = 0x0000fbf03f9707a0UL;
   tf->codes[8692] = 0x0000fbf5bcff9218UL;
   tf->codes[8693] = 0x0000fbf5f78e97ddUL;
   tf->codes[8694] = 0x0000fbfb3a681c90UL;
   tf->codes[8695] = 0x0000fbfc24a433a4UL;
   tf->codes[8696] = 0x0000fbffcd948ff4UL;
   tf->codes[8697] = 0x0000fc0042b29b7eUL;
   tf->codes[8698] = 0x0000fc030166e0baUL;
   tf->codes[8699] = 0x0000fc03eba2f7ceUL;
   tf->codes[8700] = 0x0000fc0f96211e0dUL;
   tf->codes[8701] = 0x0000fc11dfb757bfUL;
   tf->codes[8702] = 0x0000fc1dff538988UL;
   tf->codes[8703] = 0x0000fc1f993cb1ebUL;
   tf->codes[8704] = 0x0000fc27d559819fUL;
   tf->codes[8705] = 0x0000fc2a597ec116UL;
   tf->codes[8706] = 0x0000fc31ab5f79b6UL;
   tf->codes[8707] = 0x0000fc32207d8540UL;
   tf->codes[8708] = 0x0000fc325b0c8b05UL;
   tf->codes[8709] = 0x0000fc32d02a968fUL;
   tf->codes[8710] = 0x0000fc330ab99c54UL;
   tf->codes[8711] = 0x0000fc36791af2dfUL;
   tf->codes[8712] = 0x0000fc3dcafbab7fUL;
   tf->codes[8713] = 0x0000fc3f9f73d9a7UL;
   tf->codes[8714] = 0x0000fc41395d020aUL;
   tf->codes[8715] = 0x0000fc41e90a1359UL;
   tf->codes[8716] = 0x0000fc4b848105abUL;
   tf->codes[8717] = 0x0000fc513c7895e8UL;
   tf->codes[8718] = 0x0000fc526143b2c1UL;
   tf->codes[8719] = 0x0000fc55cfa5094cUL;
   tf->codes[8720] = 0x0000fc567f521a9bUL;
   tf->codes[8721] = 0x0000fc5b4d0d93c4UL;
   tf->codes[8722] = 0x0000fc5bfcbaa513UL;
   tf->codes[8723] = 0x0000fc5ef5fdf014UL;
   tf->codes[8724] = 0x0000fc634e9b5db3UL;
   tf->codes[8725] = 0x0000fc660d4fa2efUL;
   tf->codes[8726] = 0x0000fc6a65ed108eUL;
   tf->codes[8727] = 0x0000fc731727ebccUL;
   tf->codes[8728] = 0x0000fc77e4e364f5UL;
   tf->codes[8729] = 0x0000fc79f3ea98e2UL;
   tf->codes[8730] = 0x0000fc805b8f3a6eUL;
   tf->codes[8731] = 0x0000fc80961e4033UL;
   tf->codes[8732] = 0x0000fc82a5257420UL;
   tf->codes[8733] = 0x0000fc864e15d070UL;
   tf->codes[8734] = 0x0000fc87ad6ff30eUL;
   tf->codes[8735] = 0x0000fc95dc1358c4UL;
   tf->codes[8736] = 0x0000fc9e18302878UL;
   tf->codes[8737] = 0x0000fc9fb21950dbUL;
   tf->codes[8738] = 0x0000fca2e5eba1a1UL;
   tf->codes[8739] = 0x0000fca52f81db53UL;
   tf->codes[8740] = 0x0000fca6c96b03b6UL;
   tf->codes[8741] = 0x0000fca779181505UL;
   tf->codes[8742] = 0x0000fcb0da000192UL;
   tf->codes[8743] = 0x0000fcb4bd7f63a7UL;
   tf->codes[8744] = 0x0000fcb7f151b46dUL;
   tf->codes[8745] = 0x0000fcb9161cd146UL;
   tf->codes[8746] = 0x0000fcba7576f3e4UL;
   tf->codes[8747] = 0x0000fcbd342b3920UL;
   tf->codes[8748] = 0x0000fcc02d6e8421UL;
   tf->codes[8749] = 0x0000fcc36140d4e7UL;
   tf->codes[8750] = 0x0000fcca03747c38UL;
   tf->codes[8751] = 0x0000fcd0308a17ffUL;
   tf->codes[8752] = 0x0000fcd747dbcadaUL;
   tf->codes[8753] = 0x0000fcdbdb083e3eUL;
   tf->codes[8754] = 0x0000fce2f259f119UL;
   tf->codes[8755] = 0x0000fce417250df2UL;
   tf->codes[8756] = 0x0000fce451b413b7UL;
   tf->codes[8757] = 0x0000fcedb29c0044UL;
   tf->codes[8758] = 0x0000fcf36a939081UL;
   tf->codes[8759] = 0x0000fcf5799ac46eUL;
   tf->codes[8760] = 0x0000fcf5b429ca33UL;
   tf->codes[8761] = 0x0000fcf74e12f296UL;
   tf->codes[8762] = 0x0000fd00746bd95eUL;
   tf->codes[8763] = 0x0000fd02be021310UL;
   tf->codes[8764] = 0x0000fd0925a6b49cUL;
   tf->codes[8765] = 0x0000fd0f8d4b5628UL;
   tf->codes[8766] = 0x0000fd10026961b2UL;
   tf->codes[8767] = 0x0000fd121170959fUL;
   tf->codes[8768] = 0x0000fd166a0e033eUL;
   tf->codes[8769] = 0x0000fd1afd3a76a2UL;
   tf->codes[8770] = 0x0000fd2164df182eUL;
   tf->codes[8771] = 0x0000fd2423935d6aUL;
   tf->codes[8772] = 0x0000fd26a7b89ce1UL;
   tf->codes[8773] = 0x0000fd325236c320UL;
   tf->codes[8774] = 0x0000fd35860913e6UL;
   tf->codes[8775] = 0x0000fd380a2e535dUL;
   tf->codes[8776] = 0x0000fd3bedadb572UL;
   tf->codes[8777] = 0x0000fd41e0344b74UL;
   tf->codes[8778] = 0x0000fd4464598aebUL;
   tf->codes[8779] = 0x0000fd47230dd027UL;
   tf->codes[8780] = 0x0000fd4dffd07d3dUL;
   tf->codes[8781] = 0x0000fd51e34fdf52UL;
   tf->codes[8782] = 0x0000fd537d3907b5UL;
   tf->codes[8783] = 0x0000fd56b10b587bUL;
   tf->codes[8784] = 0x0000fd5a59fbb4cbUL;
   tf->codes[8785] = 0x0000fd5d8dce0591UL;
   tf->codes[8786] = 0x0000fd5fd7643f43UL;
   tf->codes[8787] = 0x0000fd6136be61e1UL;
   tf->codes[8788] = 0x0000fd679e63036dUL;
   tf->codes[8789] = 0x0000fd6eb5b4b648UL;
   tf->codes[8790] = 0x0000fd72d3c31e22UL;
   tf->codes[8791] = 0x0000fd75cd066923UL;
   tf->codes[8792] = 0x0000fd76b7428037UL;
   tf->codes[8793] = 0x0000fd7bfa1c04eaUL;
   tf->codes[8794] = 0x0000fd7e092338d7UL;
   tf->codes[8795] = 0x0000fd7fa30c613aUL;
   tf->codes[8796] = 0x0000fd81b2139527UL;
   tf->codes[8797] = 0x0000fd876a0b2564UL;
   tf->codes[8798] = 0x0000fd8a28bf6aa0UL;
   tf->codes[8799] = 0x0000fd9055d50667UL;
   tf->codes[8800] = 0x0000fd98cc80dbe0UL;
   tf->codes[8801] = 0x0000fd99b6bcf2f4UL;
   tf->codes[8802] = 0x0000fd9d9a3c5509UL;
   tf->codes[8803] = 0x0000fd9f6eb48331UL;
   tf->codes[8804] = 0x0000fda1089dab94UL;
   tf->codes[8805] = 0x0000fda68606360cUL;
   tf->codes[8806] = 0x0000fda90a2b7583UL;
   tf->codes[8807] = 0x0000fdb0d12a39adUL;
   tf->codes[8808] = 0x0000fdb1bb6650c1UL;
   tf->codes[8809] = 0x0000fdb38fde7ee9UL;
   tf->codes[8810] = 0x0000fdb6c3b0cfafUL;
   tf->codes[8811] = 0x0000fdba3212263aUL;
   tf->codes[8812] = 0x0000fdbaa73031c4UL;
   tf->codes[8813] = 0x0000fdbec53e999eUL;
   tf->codes[8814] = 0x0000fdc14963d915UL;
   tf->codes[8815] = 0x0000fdc26e2ef5eeUL;
   tf->codes[8816] = 0x0000fdc3cd89188cUL;
   tf->codes[8817] = 0x0000fdd0d7616169UL;
   tf->codes[8818] = 0x0000fdd320f79b1bUL;
   tf->codes[8819] = 0x0000fdd35b86a0e0UL;
   tf->codes[8820] = 0x0000fdd445c2b7f4UL;
   tf->codes[8821] = 0x0000fdd56a8dd4cdUL;
   tf->codes[8822] = 0x0000fddb97a37094UL;
   tf->codes[8823] = 0x0000fddff040de33UL;
   tf->codes[8824] = 0x0000fde1c4b90c5bUL;
   tf->codes[8825] = 0x0000fde35ea234beUL;
   tf->codes[8826] = 0x0000fde8a17bb971UL;
   tf->codes[8827] = 0x0000fdf1c7d4a039UL;
   tf->codes[8828] = 0x0000fdf27781b188UL;
   tf->codes[8829] = 0x0000fdf86a08478aUL;
   tf->codes[8830] = 0x0000fdfb9dda9850UL;
   tf->codes[8831] = 0x0000fdfc4d87a99fUL;
   tf->codes[8832] = 0x0000fdfdace1cc3dUL;
   tf->codes[8833] = 0x0000fe02400e3fa1UL;
   tf->codes[8834] = 0x0000fe027a9d4566UL;
   tf->codes[8835] = 0x0000fe06238da1b6UL;
   tf->codes[8836] = 0x0000fe086d23db68UL;
   tf->codes[8837] = 0x0000fe127db8d944UL;
   tf->codes[8838] = 0x0000fe1367f4f058UL;
   tf->codes[8839] = 0x0000fe1417a201a7UL;
   tf->codes[8840] = 0x0000fe1576fc2445UL;
   tf->codes[8841] = 0x0000fe15b18b2a0aUL;
   tf->codes[8842] = 0x0000fe191fec8095UL;
   tf->codes[8843] = 0x0000fe1bdea0c5d1UL;
   tf->codes[8844] = 0x0000fe23a59f89fbUL;
   tf->codes[8845] = 0x0000fe24ca6aa6d4UL;
   tf->codes[8846] = 0x0000fe2ba72d53eaUL;
   tf->codes[8847] = 0x0000fe2ea0709eebUL;
   tf->codes[8848] = 0x0000fe3199b3e9ecUL;
   tf->codes[8849] = 0x0000fe324960fb3bUL;
   tf->codes[8850] = 0x0000fe378c3a7feeUL;
   tf->codes[8851] = 0x0000fe3801588b78UL;
   tf->codes[8852] = 0x0000fe38eb94a28cUL;
   tf->codes[8853] = 0x0000fe392623a851UL;
   tf->codes[8854] = 0x0000fe3afa9bd679UL;
   tf->codes[8855] = 0x0000fe3b352adc3eUL;
   tf->codes[8856] = 0x0000fe3d4432102bUL;
   tf->codes[8857] = 0x0000fe3d7ec115f0UL;
   tf->codes[8858] = 0x0000fe3db9501bb5UL;
   tf->codes[8859] = 0x0000fe4be7f3816bUL;
   tf->codes[8860] = 0x0000fe4f90e3ddbbUL;
   tf->codes[8861] = 0x0000fe5374633fd0UL;
   tf->codes[8862] = 0x0000fe58078fb334UL;
   tf->codes[8863] = 0x0000fe5c602d20d3UL;
   tf->codes[8864] = 0x0000fe5dbf874371UL;
   tf->codes[8865] = 0x0000fe5e6f3454c0UL;
   tf->codes[8866] = 0x0000fe6043ac82e8UL;
   tf->codes[8867] = 0x0000fe61dd95ab4bUL;
   tf->codes[8868] = 0x0000fe633cefcde9UL;
   tf->codes[8869] = 0x0000fe69df23753aUL;
   tf->codes[8870] = 0x0000fe70bbe62250UL;
   tf->codes[8871] = 0x0000fe737a9a678cUL;
   tf->codes[8872] = 0x0000fe7464d67ea0UL;
   tf->codes[8873] = 0x0000fe7589a19b79UL;
   tf->codes[8874] = 0x0000fe780dc6daf0UL;
   tf->codes[8875] = 0x0000fe7a91ec1a67UL;
   tf->codes[8876] = 0x0000fe7d50a05fa3UL;
   tf->codes[8877] = 0x0000fe7eaffa8241UL;
   tf->codes[8878] = 0x0000fe808472b069UL;
   tf->codes[8879] = 0x0000fe80bf01b62eUL;
   tf->codes[8880] = 0x0000fe863c6a40a6UL;
   tf->codes[8881] = 0x0000fe88fb1e85e2UL;
   tf->codes[8882] = 0x0000fe925c06726fUL;
   tf->codes[8883] = 0x0000fe92d1247df9UL;
   tf->codes[8884] = 0x0000fe967a14da49UL;
   tf->codes[8885] = 0x0000fe9813fe02acUL;
   tf->codes[8886] = 0x0000fe9b47d05372UL;
   tf->codes[8887] = 0x0000fe9dcbf592e9UL;
   tf->codes[8888] = 0x0000fea55865514eUL;
   tf->codes[8889] = 0x0000feb4e662d9a2UL;
   tf->codes[8890] = 0x0000feb5d09ef0b6UL;
   tf->codes[8891] = 0x0000feb60b2df67bUL;
   tf->codes[8892] = 0x0000feb6804c0205UL;
   tf->codes[8893] = 0x0000febc38439242UL;
   tf->codes[8894] = 0x0000febfa6a4e8cdUL;
   tf->codes[8895] = 0x0000febfe133ee92UL;
   tf->codes[8896] = 0x0000fec05651fa1cUL;
   tf->codes[8897] = 0x0000fec29fe833ceUL;
   tf->codes[8898] = 0x0000fec34f95451dUL;
   tf->codes[8899] = 0x0000fec73314a732UL;
   tf->codes[8900] = 0x0000fece84f55fd2UL;
   tf->codes[8901] = 0x0000fed0596d8dfaUL;
   tf->codes[8902] = 0x0000fedf724d0ac4UL;
   tf->codes[8903] = 0x0000fee7ae69da78UL;
   tf->codes[8904] = 0x0000fef2341ce3deUL;
   tf->codes[8905] = 0x0000feff78843280UL;
   tf->codes[8906] = 0x0000feffb3133845UL;
   tf->codes[8907] = 0x0000ff123a540b9aUL;
   tf->codes[8908] = 0x0000ff14f90850d6UL;
   tf->codes[8909] = 0x0000ff153397569bUL;
   tf->codes[8910] = 0x0000ff16cd807efeUL;
   tf->codes[8911] = 0x0000ff17080f84c3UL;
   tf->codes[8912] = 0x0000ff1a3be1d589UL;
   tf->codes[8913] = 0x0000ff1bd5cafdecUL;
   tf->codes[8914] = 0x0000ff1d3525208aUL;
   tf->codes[8915] = 0x0000ff20a3867715UL;
   tf->codes[8916] = 0x0000ff2153338864UL;
   tf->codes[8917] = 0x0000ff3a7ca8030aUL;
   tf->codes[8918] = 0x0000ff3c16912b6dUL;
   tf->codes[8919] = 0x0000ff3d3b5c4846UL;
   tf->codes[8920] = 0x0000ff420917c16fUL;
   tf->codes[8921] = 0x0000ff47c10f51acUL;
   tf->codes[8922] = 0x0000ff515c8643feUL;
   tf->codes[8923] = 0x0000ff5330fe7226UL;
   tf->codes[8924] = 0x0000ff54905894c4UL;
   tf->codes[8925] = 0x0000ff5b6d1b41daUL;
   tf->codes[8926] = 0x0000ff5fc5b8af79UL;
   tf->codes[8927] = 0x0000ff607565c0c8UL;
   tf->codes[8928] = 0x0000ff64937428a2UL;
   tf->codes[8929] = 0x0000ff763078e4e3UL;
   tf->codes[8930] = 0x0000ff787a0f1e95UL;
   tf->codes[8931] = 0x0000ff78ef2d2a1fUL;
   tf->codes[8932] = 0x0000ff7a89165282UL;
   tf->codes[8933] = 0x0000ff7f1c42c5e6UL;
   tf->codes[8934] = 0x0000ff7f9160d170UL;
   tf->codes[8935] = 0x0000ff88080ca6e9UL;
   tf->codes[8936] = 0x0000ff8cd5c82012UL;
   tf->codes[8937] = 0x0000ff90099a70d8UL;
   tf->codes[8938] = 0x0000ff933d6cc19eUL;
   tf->codes[8939] = 0x0000ff9720ec23b3UL;
   tf->codes[8940] = 0x0000ff996a825d65UL;
   tf->codes[8941] = 0x0000ff9a8f4d7a3eUL;
   tf->codes[8942] = 0x0000ff9b046b85c8UL;
   tf->codes[8943] = 0x0000ff9bb4189717UL;
   tf->codes[8944] = 0x0000ff9f9797f92cUL;
   tf->codes[8945] = 0x0000ffa047450a7bUL;
   tf->codes[8946] = 0x0000ffa16c102754UL;
   tf->codes[8947] = 0x0000ffa1e12e32deUL;
   tf->codes[8948] = 0x0000ffa465537255UL;
   tf->codes[8949] = 0x0000ffb04a609e59UL;
   tf->codes[8950] = 0x0000ffb084efa41eUL;
   tf->codes[8951] = 0x0000ffb1e449c6bcUL;
   tf->codes[8952] = 0x0000ffb37e32ef1fUL;
   tf->codes[8953] = 0x0000ffb727234b6fUL;
   tf->codes[8954] = 0x0000ffb84bee6848UL;
   tf->codes[8955] = 0x0000ffc137b8494bUL;
   tf->codes[8956] = 0x0000ffc8899901ebUL;
   tf->codes[8957] = 0x0000ffcb0dbe4162UL;
   tf->codes[8958] = 0x0000ffd0c5b5d19fUL;
   tf->codes[8959] = 0x0000ffd29a2dffc7UL;
   tf->codes[8960] = 0x0000ffd852259004UL;
   tf->codes[8961] = 0x0000ffddcf8e1a7cUL;
   tf->codes[8962] = 0x0000ffe9b49b4680UL;
   tf->codes[8963] = 0x0000ffebfe318032UL;
   tf->codes[8964] = 0x0000fff1f0b81634UL;
   tf->codes[8965] = 0x0000fff7a8afa671UL;
   tf->codes[8966] = 0x0000fff97d27d499UL;
   tf->codes[8967] = 0x00010001b944a44dUL;
   tf->codes[8968] = 0x00010002a380bb61UL;
   tf->codes[8969] = 0x000100038dbcd275UL;
   tf->codes[8970] = 0x00010003c84bd83aUL;
   tf->codes[8971] = 0x0001000f383af8b4UL;
   tf->codes[8972] = 0x00010012317e43b5UL;
   tf->codes[8973] = 0x000100131bba5ac9UL;
   tf->codes[8974] = 0x00010014408577a2UL;
   tf->codes[8975] = 0x00010014b5a3832cUL;
   tf->codes[8976] = 0x00010016ff39bcdeUL;
   tf->codes[8977] = 0x00010017e975d3f2UL;
   tf->codes[8978] = 0x0001001b1d4824b8UL;
   tf->codes[8979] = 0x0001001b57d72a7dUL;
   tf->codes[8980] = 0x0001001e511a757eUL;
   tf->codes[8981] = 0x0001001e8ba97b43UL;
   tf->codes[8982] = 0x000100210fcebabaUL;
   tf->codes[8983] = 0x000100214a5dc07fUL;
   tf->codes[8984] = 0x00010021fa0ad1ceUL;
   tf->codes[8985] = 0x00010022a9b7e31dUL;
   tf->codes[8986] = 0x00010024b8bf170aUL;
   tf->codes[8987] = 0x00010026181939a8UL;
   tf->codes[8988] = 0x0001002861af735aUL;
   tf->codes[8989] = 0x0001002bd010c9e5UL;
   tf->codes[8990] = 0x0001003237b56b71UL;
   tf->codes[8991] = 0x0001003272447136UL;
   tf->codes[8992] = 0x00010033d19e93d4UL;
   tf->codes[8993] = 0x000100340c2d9999UL;
   tf->codes[8994] = 0x000100356b87bc37UL;
   tf->codes[8995] = 0x00010035a616c1fcUL;
   tf->codes[8996] = 0x0001003655c3d34bUL;
   tf->codes[8997] = 0x00010037efacfbaeUL;
   tf->codes[8998] = 0x0001003989962411UL;
   tf->codes[8999] = 0x0001003a39433560UL;
   tf->codes[9000] = 0x0001003b5e0e5239UL;
   tf->codes[9001] = 0x00010040db76dcb1UL;
   tf->codes[9002] = 0x00010041c5b2f3c5UL;
   tf->codes[9003] = 0x00010043250d1663UL;
   tf->codes[9004] = 0x000100439a2b21edUL;
   tf->codes[9005] = 0x00010043d4ba27b2UL;
   tf->codes[9006] = 0x00010045a93255daUL;
   tf->codes[9007] = 0x000100482d579551UL;
   tf->codes[9008] = 0x0001004b9bb8ebdcUL;
   tf->codes[9009] = 0x0001004ff456597bUL;
   tf->codes[9010] = 0x0001005119217654UL;
   tf->codes[9011] = 0x00010052b30a9eb7UL;
   tf->codes[9012] = 0x000100532828aa41UL;
   tf->codes[9013] = 0x00010053d7d5bb90UL;
   tf->codes[9014] = 0x00010056216bf542UL;
   tf->codes[9015] = 0x00010056968a00ccUL;
   tf->codes[9016] = 0x0001005b644579f5UL;
   tf->codes[9017] = 0x00010060a71efea8UL;
   tf->codes[9018] = 0x00010061915b15bcUL;
   tf->codes[9019] = 0x00010065e9f8835bUL;
   tf->codes[9020] = 0x00010070aa3a9286UL;
   tf->codes[9021] = 0x000100724423bae9UL;
   tf->codes[9022] = 0x00010072b941c673UL;
   tf->codes[9023] = 0x000100774c6e39d7UL;
   tf->codes[9024] = 0x0001007bdf9aad3bUL;
   tf->codes[9025] = 0x0001008197923d78UL;
   tf->codes[9026] = 0x00010081d221433dUL;
   tf->codes[9027] = 0x00010082bc5d5a51UL;
   tf->codes[9028] = 0x00010085b5a0a552UL;
   tf->codes[9029] = 0x000100878a18d37aUL;
   tf->codes[9030] = 0x00010087ff36df04UL;
   tf->codes[9031] = 0x0001008ba8273b54UL;
   tf->codes[9032] = 0x0001008c92635268UL;
   tf->codes[9033] = 0x0001009075e2b47dUL;
   tf->codes[9034] = 0x00010091d53cd71bUL;
   tf->codes[9035] = 0x00010092fa07f3f4UL;
   tf->codes[9036] = 0x0001009459621692UL;
   tf->codes[9037] = 0x00010095090f27e1UL;
   tf->codes[9038] = 0x000100957e2d336bUL;
   tf->codes[9039] = 0x00010095f34b3ef5UL;
   tf->codes[9040] = 0x000100978d346758UL;
   tf->codes[9041] = 0x0001009961ac9580UL;
   tf->codes[9042] = 0x000100999c3b9b45UL;
   tf->codes[9043] = 0x0001009a1159a6cfUL;
   tf->codes[9044] = 0x0001009b3624c3a8UL;
   tf->codes[9045] = 0x0001009d7fbafd5aUL;
   tf->codes[9046] = 0x0001009dba4a031fUL;
   tf->codes[9047] = 0x0001009f54332b82UL;
   tf->codes[9048] = 0x000100a0b38d4e20UL;
   tf->codes[9049] = 0x000100a0ee1c53e5UL;
   tf->codes[9050] = 0x000100a1633a5f6fUL;
   tf->codes[9051] = 0x000100a24d767683UL;
   tf->codes[9052] = 0x000100a5f666d2d3UL;
   tf->codes[9053] = 0x000100a755c0f571UL;
   tf->codes[9054] = 0x000100a8b51b180fUL;
   tf->codes[9055] = 0x000100a92a392399UL;
   tf->codes[9056] = 0x000100abae5e6310UL;
   tf->codes[9057] = 0x000100b0418ad674UL;
   tf->codes[9058] = 0x000100b0b6a8e1feUL;
   tf->codes[9059] = 0x000100b2c5b015ebUL;
   tf->codes[9060] = 0x000100b92d54b777UL;
   tf->codes[9061] = 0x000100bdfb1030a0UL;
   tf->codes[9062] = 0x000100beaabd41efUL;
   tf->codes[9063] = 0x000100c2191e987aUL;
   tf->codes[9064] = 0x000100c37878bb18UL;
   tf->codes[9065] = 0x000100c3b307c0ddUL;
   tf->codes[9066] = 0x000100c49d43d7f1UL;
   tf->codes[9067] = 0x000100c7d11628b7UL;
   tf->codes[9068] = 0x000100ca1aac6269UL;
   tf->codes[9069] = 0x000100ca553b682eUL;
   tf->codes[9070] = 0x000100cbef249091UL;
   tf->codes[9071] = 0x000100d1e1ab2693UL;
   tf->codes[9072] = 0x000100d75f13b10bUL;
   tf->codes[9073] = 0x000100d7d431bc95UL;
   tf->codes[9074] = 0x000100d96e1ae4f8UL;
   tf->codes[9075] = 0x000100dacd750796UL;
   tf->codes[9076] = 0x000100db7d2218e5UL;
   tf->codes[9077] = 0x000100dbb7b11eaaUL;
   tf->codes[9078] = 0x000100dd170b4148UL;
   tf->codes[9079] = 0x000100dfd5bf8684UL;
   tf->codes[9080] = 0x000100e0856c97d3UL;
   tf->codes[9081] = 0x000100e1aa37b4acUL;
   tf->codes[9082] = 0x000100e37eafe2d4UL;
   tf->codes[9083] = 0x000100e6b282339aUL;
   tf->codes[9084] = 0x000100e6ed11395fUL;
   tf->codes[9085] = 0x000100e79cbe4aaeUL;
   tf->codes[9086] = 0x000100eb45aea6feUL;
   tf->codes[9087] = 0x000100ec2feabe12UL;
   tf->codes[9088] = 0x000100f30cad6b28UL;
   tf->codes[9089] = 0x000100f5cb61b064UL;
   tf->codes[9090] = 0x000100f67b0ec1b3UL;
   tf->codes[9091] = 0x000100f79fd9de8cUL;
   tf->codes[9092] = 0x000100f8ff34012aUL;
   tf->codes[9093] = 0x000100fb835940a1UL;
   tf->codes[9094] = 0x000100ffa167a87bUL;
   tf->codes[9095] = 0x000101067e2a5591UL;
   tf->codes[9096] = 0x000101088d31897eUL;
   tf->codes[9097] = 0x0001010c70b0eb93UL;
   tf->codes[9098] = 0x0001010ce5cef71dUL;
   tf->codes[9099] = 0x00010111b38a7046UL;
   tf->codes[9100] = 0x00010111ee19760bUL;
   tf->codes[9101] = 0x00010113c291a433UL;
   tf->codes[9102] = 0x00010113fd20a9f8UL;
   tf->codes[9103] = 0x000101159709d25bUL;
   tf->codes[9104] = 0x00010115d198d820UL;
   tf->codes[9105] = 0x0001011646b6e3aaUL;
   tf->codes[9106] = 0x000101176b820083UL;
   tf->codes[9107] = 0x000101181b2f11d2UL;
   tf->codes[9108] = 0x00010119b5183a35UL;
   tf->codes[9109] = 0x0001011b14725cd3UL;
   tf->codes[9110] = 0x0001011bfeae73e7UL;
   tf->codes[9111] = 0x0001011ebd62b923UL;
   tf->codes[9112] = 0x00010121f13509e9UL;
   tf->codes[9113] = 0x00010122db7120fdUL;
   tf->codes[9114] = 0x000101238b1e324cUL;
   tf->codes[9115] = 0x00010123c5ad3811UL;
   tf->codes[9116] = 0x00010125d4b46bfeUL;
   tf->codes[9117] = 0x0001012684617d4dUL;
   tf->codes[9118] = 0x000101276e9d9461UL;
   tf->codes[9119] = 0x000101294315c289UL;
   tf->codes[9120] = 0x0001012a2d51d99dUL;
   tf->codes[9121] = 0x0001012b521cf676UL;
   tf->codes[9122] = 0x000101317f32923dUL;
   tf->codes[9123] = 0x00010131f4509dc7UL;
   tf->codes[9124] = 0x000101343de6d779UL;
   tf->codes[9125] = 0x000101347875dd3eUL;
   tf->codes[9126] = 0x00010136877d112bUL;
   tf->codes[9127] = 0x00010136c20c16f0UL;
   tf->codes[9128] = 0x0001013771b9283fUL;
   tf->codes[9129] = 0x000101382166398eUL;
   tf->codes[9130] = 0x0001013d643fbe41UL;
   tf->codes[9131] = 0x00010141f76c31a5UL;
   tf->codes[9132] = 0x0001014391555a08UL;
   tf->codes[9133] = 0x00010147af63c1e2UL;
   tf->codes[9134] = 0x00010150d5bca8aaUL;
   tf->codes[9135] = 0x000101523516cb48UL;
   tf->codes[9136] = 0x000101526fa5d10dUL;
   tf->codes[9137] = 0x00010154098ef970UL;
   tf->codes[9138] = 0x00010154b93c0abfUL;
   tf->codes[9139] = 0x00010155a37821d3UL;
   tf->codes[9140] = 0x00010157b27f55c0UL;
   tf->codes[9141] = 0x00010157ed0e5b85UL;
   tf->codes[9142] = 0x00010158d74a7299UL;
   tf->codes[9143] = 0x000101594c687e23UL;
   tf->codes[9144] = 0x0001015b5b6fb210UL;
   tf->codes[9145] = 0x0001015bd08dbd9aUL;
   tf->codes[9146] = 0x0001015da505ebc2UL;
   tf->codes[9147] = 0x00010160292b2b39UL;
   tf->codes[9148] = 0x0001016063ba30feUL;
   tf->codes[9149] = 0x00010162ad506ab0UL;
   tf->codes[9150] = 0x00010163226e763aUL;
   tf->codes[9151] = 0x00010166cb5ed28aUL;
   tf->codes[9152] = 0x000101677b0be3d9UL;
   tf->codes[9153] = 0x000101698a1317c6UL;
   tf->codes[9154] = 0x0001016b991a4bb3UL;
   tf->codes[9155] = 0x0001016ff1b7b952UL;
   tf->codes[9156] = 0x000101739aa815a2UL;
   tf->codes[9157] = 0x00010173d5371b67UL;
   tf->codes[9158] = 0x00010174bf73327bUL;
   tf->codes[9159] = 0x00010176ce7a6668UL;
   tf->codes[9160] = 0x00010179c7bdb169UL;
   tf->codes[9161] = 0x0001017ab1f9c87dUL;
   tf->codes[9162] = 0x0001017b9c35df91UL;
   tf->codes[9163] = 0x0001017dab3d137eUL;
   tf->codes[9164] = 0x0001017e95792a92UL;
   tf->codes[9165] = 0x0001017f7fb541a6UL;
   tf->codes[9166] = 0x0001017fba44476bUL;
   tf->codes[9167] = 0x000101823e6986e2UL;
   tf->codes[9168] = 0x00010183d852af45UL;
   tf->codes[9169] = 0x000101844d70bacfUL;
   tf->codes[9170] = 0x00010184c28ec659UL;
   tf->codes[9171] = 0x0001018781430b95UL;
   tf->codes[9172] = 0x00010191574903acUL;
   tf->codes[9173] = 0x00010193db6e4323UL;
   tf->codes[9174] = 0x00010194c5aa5a37UL;
   tf->codes[9175] = 0x000101970f4093e9UL;
   tf->codes[9176] = 0x0001019749cf99aeUL;
   tf->codes[9177] = 0x00010198340bb0c2UL;
   tf->codes[9178] = 0x000101986e9ab687UL;
   tf->codes[9179] = 0x00010198a929bc4cUL;
   tf->codes[9180] = 0x0001019a4312e4afUL;
   tf->codes[9181] = 0x0001019b2d4efbc3UL;
   tf->codes[9182] = 0x0001019f85ec6962UL;
   tf->codes[9183] = 0x000101a1cf82a314UL;
   tf->codes[9184] = 0x000101a2b9beba28UL;
   tf->codes[9185] = 0x000101a3696bcb77UL;
   tf->codes[9186] = 0x000101af13e9f1b6UL;
   tf->codes[9187] = 0x000101b0add31a19UL;
   tf->codes[9188] = 0x000101b1980f312dUL;
   tf->codes[9189] = 0x000101b75006c16aUL;
   tf->codes[9190] = 0x000101b95f0df557UL;
   tf->codes[9191] = 0x000101b9999cfb1cUL;
   tf->codes[9192] = 0x000101b9d42c00e1UL;
   tf->codes[9193] = 0x000101bb3386237fUL;
   tf->codes[9194] = 0x000101bbe33334ceUL;
   tf->codes[9195] = 0x000101bd428d576cUL;
   tf->codes[9196] = 0x000101bf8c23911eUL;
   tf->codes[9197] = 0x000101c0765fa832UL;
   tf->codes[9198] = 0x000101c0eb7db3bcUL;
   tf->codes[9199] = 0x000101c28566dc1fUL;
   tf->codes[9200] = 0x000101c36fa2f333UL;
   tf->codes[9201] = 0x000101c6de0449beUL;
   tf->codes[9202] = 0x000101c9279a8370UL;
   tf->codes[9203] = 0x000101cafc12b198UL;
   tf->codes[9204] = 0x000101cbabbfc2e7UL;
   tf->codes[9205] = 0x000101cf54b01f37UL;
   tf->codes[9206] = 0x000101d163b75324UL;
   tf->codes[9207] = 0x000101d19e4658e9UL;
   tf->codes[9208] = 0x000101d49789a3eaUL;
   tf->codes[9209] = 0x000101d5f6e3c688UL;
   tf->codes[9210] = 0x000101d6a690d7d7UL;
   tf->codes[9211] = 0x000101d7563de926UL;
   tf->codes[9212] = 0x000101d7cb5bf4b0UL;
   tf->codes[9213] = 0x000101d8b5980bc4UL;
   tf->codes[9214] = 0x000101d8f0271189UL;
   tf->codes[9215] = 0x000101d99fd422d8UL;
   tf->codes[9216] = 0x000101da8a1039ecUL;
   tf->codes[9217] = 0x000101daff2e4576UL;
   tf->codes[9218] = 0x000101ddf8719077UL;
   tf->codes[9219] = 0x000101df925ab8daUL;
   tf->codes[9220] = 0x000101e33b4b152aUL;
   tf->codes[9221] = 0x000101e759597d04UL;
   tf->codes[9222] = 0x000101e793e882c9UL;
   tf->codes[9223] = 0x000101ebec85f068UL;
   tf->codes[9224] = 0x000101f0ba416991UL;
   tf->codes[9225] = 0x000101f2542a91f4UL;
   tf->codes[9226] = 0x000101f6e7570558UL;
   tf->codes[9227] = 0x000101f8bbcf3380UL;
   tf->codes[9228] = 0x000101f96b7c44cfUL;
   tf->codes[9229] = 0x000101f9e09a5059UL;
   tf->codes[9230] = 0x000101fa1b29561eUL;
   tf->codes[9231] = 0x000101fbb5127e81UL;
   tf->codes[9232] = 0x000101fe3937bdf8UL;
   tf->codes[9233] = 0x000101ff5e02dad1UL;
   tf->codes[9234] = 0x00010200483ef1e5UL;
   tf->codes[9235] = 0x000102037c1142abUL;
   tf->codes[9236] = 0x00010204664d59bfUL;
   tf->codes[9237] = 0x00010206ea729936UL;
   tf->codes[9238] = 0x00010209a926de72UL;
   tf->codes[9239] = 0x0001020a9362f586UL;
   tf->codes[9240] = 0x00010210fb079712UL;
   tf->codes[9241] = 0x000102117025a29cUL;
   tf->codes[9242] = 0x00010212cf7fc53aUL;
   tf->codes[9243] = 0x000102130a0ecaffUL;
   tf->codes[9244] = 0x000102137f2cd689UL;
   tf->codes[9245] = 0x00010213b9bbdc4eUL;
   tf->codes[9246] = 0x00010213f44ae213UL;
   tf->codes[9247] = 0x000102158e340a76UL;
   tf->codes[9248] = 0x000102179d3b3e63UL;
   tf->codes[9249] = 0x00010219372466c6UL;
   tf->codes[9250] = 0x0001021a5bef839fUL;
   tf->codes[9251] = 0x0001021a967e8964UL;
   tf->codes[9252] = 0x0001021b462b9ab3UL;
   tf->codes[9253] = 0x0001021eb48cf13eUL;
   tf->codes[9254] = 0x00010223f76675f1UL;
   tf->codes[9255] = 0x00010231765cca58UL;
   tf->codes[9256] = 0x000102331045f2bbUL;
   tf->codes[9257] = 0x000102346fa01559UL;
   tf->codes[9258] = 0x00010234e4be20e3UL;
   tf->codes[9259] = 0x00010235cefa37f7UL;
   tf->codes[9260] = 0x0001023644184381UL;
   tf->codes[9261] = 0x00010236f3c554d0UL;
   tf->codes[9262] = 0x00010239b2799a0cUL;
   tf->codes[9263] = 0x0001023ad744b6e5UL;
   tf->codes[9264] = 0x0001023b4c62c26fUL;
   tf->codes[9265] = 0x0001023c369ed983UL;
   tf->codes[9266] = 0x0001023cabbce50dUL;
   tf->codes[9267] = 0x0001024229256f85UL;
   tf->codes[9268] = 0x00010243887f9223UL;
   tf->codes[9269] = 0x00010243c30e97e8UL;
   tf->codes[9270] = 0x00010245d215cbd5UL;
   tf->codes[9271] = 0x000102460ca4d19aUL;
   tf->codes[9272] = 0x000102464733d75fUL;
   tf->codes[9273] = 0x0001024940772260UL;
   tf->codes[9274] = 0x0001024bff2b679cUL;
   tf->codes[9275] = 0x0001025057c8d53bUL;
   tf->codes[9276] = 0x00010253c62a2bc6UL;
   tf->codes[9277] = 0x00010254b06642daUL;
   tf->codes[9278] = 0x000102559aa259eeUL;
   tf->codes[9279] = 0x000102576f1a8816UL;
   tf->codes[9280] = 0x000102590903b079UL;
   tf->codes[9281] = 0x00010259b8b0c1c8UL;
   tf->codes[9282] = 0x0001025a685dd317UL;
   tf->codes[9283] = 0x0001025bc7b7f5b5UL;
   tf->codes[9284] = 0x0001025e4bdd352cUL;
   tf->codes[9285] = 0x000102659dbdedccUL;
   tf->codes[9286] = 0x00010266fd18106aUL;
   tf->codes[9287] = 0x000102685c723308UL;
   tf->codes[9288] = 0x000102690c1f4457UL;
   tf->codes[9289] = 0x000102702370f732UL;
   tf->codes[9290] = 0x00010270988f02bcUL;
   tf->codes[9291] = 0x000102726d0730e4UL;
   tf->codes[9292] = 0x00010274b69d6a96UL;
   tf->codes[9293] = 0x000102752bbb7620UL;
   tf->codes[9294] = 0x000102768b1598beUL;
   tf->codes[9295] = 0x00010276c5a49e83UL;
   tf->codes[9296] = 0x000102790f3ad835UL;
   tf->codes[9297] = 0x0001027c430d28fbUL;
   tf->codes[9298] = 0x00010280611b90d5UL;
   tf->codes[9299] = 0x00010284449af2eaUL;
   tf->codes[9300] = 0x0001028862a95ac4UL;
   tf->codes[9301] = 0x000102894ce571d8UL;
   tf->codes[9302] = 0x0001028bd10ab14fUL;
   tf->codes[9303] = 0x0001028c4628bcd9UL;
   tf->codes[9304] = 0x0001029029a81eeeUL;
   tf->codes[9305] = 0x00010293d2987b3eUL;
   tf->codes[9306] = 0x00010297066acc04UL;
   tf->codes[9307] = 0x0001029b5f0839a3UL;
   tf->codes[9308] = 0x000102a2eb77f808UL;
   tf->codes[9309] = 0x000102a3d5b40f1cUL;
   tf->codes[9310] = 0x000102a48561206bUL;
   tf->codes[9311] = 0x000102a9531c9994UL;
   tf->codes[9312] = 0x000102a9c83aa51eUL;
   tf->codes[9313] = 0x000102abd741d90bUL;
   tf->codes[9314] = 0x000102b11a1b5dbeUL;
   tf->codes[9315] = 0x000102b18f396948UL;
   tf->codes[9316] = 0x000102b2b4048621UL;
   tf->codes[9317] = 0x000102b363b19770UL;
   tf->codes[9318] = 0x000102b4887cb449UL;
   tf->codes[9319] = 0x000102b5ad47d122UL;
   tf->codes[9320] = 0x000102b69783e836UL;
   tf->codes[9321] = 0x000102b70ca1f3c0UL;
   tf->codes[9322] = 0x000102b8316d1099UL;
   tf->codes[9323] = 0x000102b8e11a21e8UL;
   tf->codes[9324] = 0x000102b9cb5638fcUL;
   tf->codes[9325] = 0x000102baf02155d5UL;
   tf->codes[9326] = 0x000102bb2ab05b9aUL;
   tf->codes[9327] = 0x000102bb653f615fUL;
   tf->codes[9328] = 0x000102c2b72019ffUL;
   tf->codes[9329] = 0x000102c2f1af1fc4UL;
   tf->codes[9330] = 0x000102c32c3e2589UL;
   tf->codes[9331] = 0x000102ca7e1ede29UL;
   tf->codes[9332] = 0x000102cb685af53dUL;
   tf->codes[9333] = 0x000102d070a5742bUL;
   tf->codes[9334] = 0x000102d0ab3479f0UL;
   tf->codes[9335] = 0x000102d0e5c37fb5UL;
   tf->codes[9336] = 0x000102d195709104UL;
   tf->codes[9337] = 0x000102d1cfff96c9UL;
   tf->codes[9338] = 0x000102d2451da253UL;
   tf->codes[9339] = 0x000102d27faca818UL;
   tf->codes[9340] = 0x000102d32f59b967UL;
   tf->codes[9341] = 0x000102d48eb3dc05UL;
   tf->codes[9342] = 0x000102d5ee0dfea3UL;
   tf->codes[9343] = 0x000102d6289d0468UL;
   tf->codes[9344] = 0x000102d74d682141UL;
   tf->codes[9345] = 0x000102d872333e1aUL;
   tf->codes[9346] = 0x000102d996fe5af3UL;
   tf->codes[9347] = 0x000102dbe09494a5UL;
   tf->codes[9348] = 0x000102dc9041a5f4UL;
   tf->codes[9349] = 0x000102de64b9d41cUL;
   tf->codes[9350] = 0x000102df1466e56bUL;
   tf->codes[9351] = 0x000102dfc413f6baUL;
   tf->codes[9352] = 0x000102e039320244UL;
   tf->codes[9353] = 0x000102e248393631UL;
   tf->codes[9354] = 0x000102e2bd5741bbUL;
   tf->codes[9355] = 0x000102e36d04530aUL;
   tf->codes[9356] = 0x000102e62bb89846UL;
   tf->codes[9357] = 0x000102e78b12bae4UL;
   tf->codes[9358] = 0x000102f0ebfaa771UL;
   tf->codes[9359] = 0x000102f19ba7b8c0UL;
   tf->codes[9360] = 0x000102f24b54ca0fUL;
   tf->codes[9361] = 0x000102f33590e123UL;
   tf->codes[9362] = 0x000102f3701fe6e8UL;
   tf->codes[9363] = 0x000102f5b9b6209aUL;
   tf->codes[9364] = 0x000102f7c8bd5487UL;
   tf->codes[9365] = 0x000102f99d3582afUL;
   tf->codes[9366] = 0x000102fafc8fa54dUL;
   tf->codes[9367] = 0x000102fb371eab12UL;
   tf->codes[9368] = 0x000102fb71adb0d7UL;
   tf->codes[9369] = 0x000102fc5be9c7ebUL;
   tf->codes[9370] = 0x000102fd0b96d93aUL;
   tf->codes[9371] = 0x000102fdbb43ea89UL;
   tf->codes[9372] = 0x00010301d9525263UL;
   tf->codes[9373] = 0x000103024e705dedUL;
   tf->codes[9374] = 0x00010303733b7ac6UL;
   tf->codes[9375] = 0x0001030baf584a7aUL;
   tf->codes[9376] = 0x0001031007f5b819UL;
   tf->codes[9377] = 0x000103128c1af790UL;
   tf->codes[9378] = 0x000103149b222b7dUL;
   tf->codes[9379] = 0x00010315855e4291UL;
   tf->codes[9380] = 0x00010316350b53e0UL;
   tf->codes[9381] = 0x000103171f476af4UL;
   tf->codes[9382] = 0x00010318b9309357UL;
   tf->codes[9383] = 0x00010319a36caa6bUL;
   tf->codes[9384] = 0x0001031b3d55d2ceUL;
   tf->codes[9385] = 0x0001031b77e4d893UL;
   tf->codes[9386] = 0x0001031f95f3406dUL;
   tf->codes[9387] = 0x00010320802f5781UL;
   tf->codes[9388] = 0x00010320f54d630bUL;
   tf->codes[9389] = 0x000103237972a282UL;
   tf->codes[9390] = 0x00010325fd97e1f9UL;
   tf->codes[9391] = 0x00010327d2101021UL;
   tf->codes[9392] = 0x000103321d3413c2UL;
   tf->codes[9393] = 0x0001033257c31987UL;
   tf->codes[9394] = 0x0001033307702ad6UL;
   tf->codes[9395] = 0x000103358b956a4dUL;
   tf->codes[9396] = 0x0001033b438cfa8aUL;
   tf->codes[9397] = 0x0001033b7e1c004fUL;
   tf->codes[9398] = 0x0001033eec7d56daUL;
   tf->codes[9399] = 0x0001033f9c2a6829UL;
   tf->codes[9400] = 0x000103413613908cUL;
   tf->codes[9401] = 0x00010346ee0b20c9UL;
   tf->codes[9402] = 0x00010348fd1254b6UL;
   tf->codes[9403] = 0x0001034a5c6c7754UL;
   tf->codes[9404] = 0x0001034ad18a82deUL;
   tf->codes[9405] = 0x0001034b0c1988a3UL;
   tf->codes[9406] = 0x0001034bbbc699f2UL;
   tf->codes[9407] = 0x0001034e3febd969UL;
   tf->codes[9408] = 0x0001035348365857UL;
   tf->codes[9409] = 0x000103546d017530UL;
   tf->codes[9410] = 0x0001035a9a1710f7UL;
   tf->codes[9411] = 0x0001035c6e8f3f1fUL;
   tf->codes[9412] = 0x000103608c9da6f9UL;
   tf->codes[9413] = 0x000103613c4ab848UL;
   tf->codes[9414] = 0x0001036176d9be0dUL;
   tf->codes[9415] = 0x000103626115d521UL;
   tf->codes[9416] = 0x000103629ba4dae6UL;
   tf->codes[9417] = 0x00010362d633e0abUL;
   tf->codes[9418] = 0x00010364358e0349UL;
   tf->codes[9419] = 0x00010364e53b1498UL;
   tf->codes[9420] = 0x000103660a063171UL;
   tf->codes[9421] = 0x0001036644953736UL;
   tf->codes[9422] = 0x000103676960540fUL;
   tf->codes[9423] = 0x0001036c371bcd38UL;
   tf->codes[9424] = 0x00010370552a3512UL;
   tf->codes[9425] = 0x000103734e6d8013UL;
   tf->codes[9426] = 0x000103755d74b400UL;
   tf->codes[9427] = 0x0001037647b0cb14UL;
   tf->codes[9428] = 0x000103797b831bdaUL;
   tf->codes[9429] = 0x0001037aa04e38b3UL;
   tf->codes[9430] = 0x0001038107f2da3fUL;
   tf->codes[9431] = 0x00010383518913f1UL;
   tf->codes[9432] = 0x00010386103d592dUL;
   tf->codes[9433] = 0x00010386fa797041UL;
   tf->codes[9434] = 0x000103876f977bcbUL;
   tf->codes[9435] = 0x00010387e4b58755UL;
   tf->codes[9436] = 0x00010389f3bcbb42UL;
   tf->codes[9437] = 0x0001038addf8d256UL;
   tf->codes[9438] = 0x0001038efc073a30UL;
   tf->codes[9439] = 0x00010392df869c45UL;
   tf->codes[9440] = 0x00010395291cd5f7UL;
   tf->codes[9441] = 0x00010398d20d3247UL;
   tf->codes[9442] = 0x0001039981ba4396UL;
   tf->codes[9443] = 0x00010399bc49495bUL;
   tf->codes[9444] = 0x0001039aa685606fUL;
   tf->codes[9445] = 0x0001039d6539a5abUL;
   tf->codes[9446] = 0x0001039e8a04c284UL;
   tf->codes[9447] = 0x000103a05e7cf0acUL;
   tf->codes[9448] = 0x000103a10e2a01fbUL;
   tf->codes[9449] = 0x000103a6c6219238UL;
   tf->codes[9450] = 0x000103a73b3f9dc2UL;
   tf->codes[9451] = 0x000103a7b05da94cUL;
   tf->codes[9452] = 0x000103a8d528c625UL;
   tf->codes[9453] = 0x000103a9f9f3e2feUL;
   tf->codes[9454] = 0x000103b3956ad550UL;
   tf->codes[9455] = 0x000103b6c93d2616UL;
   tf->codes[9456] = 0x000103b8289748b4UL;
   tf->codes[9457] = 0x000103b89db5543eUL;
   tf->codes[9458] = 0x000103b94d62658dUL;
   tf->codes[9459] = 0x000103b9fd0f76dcUL;
   tf->codes[9460] = 0x000103baacbc882bUL;
   tf->codes[9461] = 0x000103bc46a5b08eUL;
   tf->codes[9462] = 0x000103be903bea40UL;
   tf->codes[9463] = 0x000103c02a2512a3UL;
   tf->codes[9464] = 0x000103c1897f3541UL;
   tf->codes[9465] = 0x000103c35df76369UL;
   tf->codes[9466] = 0x000103c5e21ca2e0UL;
   tf->codes[9467] = 0x000103c915eef3a6UL;
   tf->codes[9468] = 0x000103caea6721ceUL;
   tf->codes[9469] = 0x000103cda91b670aUL;
   tf->codes[9470] = 0x000103d0a25eb20bUL;
   tf->codes[9471] = 0x000103db62a0c136UL;
   tf->codes[9472] = 0x000103ddac36fae8UL;
   tf->codes[9473] = 0x000103e155275738UL;
   tf->codes[9474] = 0x000103e279f27411UL;
   tf->codes[9475] = 0x000103e65d71d626UL;
   tf->codes[9476] = 0x000103eab60f43c5UL;
   tf->codes[9477] = 0x000103f0a895d9c7UL;
   tf->codes[9478] = 0x000103f11db3e551UL;
   tf->codes[9479] = 0x000103f2f22c1379UL;
   tf->codes[9480] = 0x000103f83505982cUL;
   tf->codes[9481] = 0x000103f8aa23a3b6UL;
   tf->codes[9482] = 0x000103fba366eeb7UL;
   tf->codes[9483] = 0x000103fe621b33f3UL;
   tf->codes[9484] = 0x000103ff4c574b07UL;
   tf->codes[9485] = 0x00010402459a9608UL;
   tf->codes[9486] = 0x0001040454a1c9f5UL;
   tf->codes[9487] = 0x00010405ee8af258UL;
   tf->codes[9488] = 0x000104069e3803a7UL;
   tf->codes[9489] = 0x0001040ba6828295UL;
   tf->codes[9490] = 0x00010410743dfbbeUL;
   tf->codes[9491] = 0x00010412f8633b35UL;
   tf->codes[9492] = 0x00010418b05acb72UL;
   tf->codes[9493] = 0x0001041b6f0f10aeUL;
   tf->codes[9494] = 0x0001041d7e16449bUL;
   tf->codes[9495] = 0x00010423709cda9dUL;
   tf->codes[9496] = 0x00010424cff6fd3bUL;
   tf->codes[9497] = 0x00010427c93a483cUL;
   tf->codes[9498] = 0x000104296323709fUL;
   tf->codes[9499] = 0x0001042a4d5f87b3UL;
   tf->codes[9500] = 0x0001042b722aa48cUL;
   tf->codes[9501] = 0x00010430b504293fUL;
   tf->codes[9502] = 0x000104312a2234c9UL;
   tf->codes[9503] = 0x00010432897c5767UL;
   tf->codes[9504] = 0x0001043423657fcaUL;
   tf->codes[9505] = 0x000104375737d090UL;
   tf->codes[9506] = 0x0001043ac599271bUL;
   tf->codes[9507] = 0x0001043b7546386aUL;
   tf->codes[9508] = 0x0001044301b5f6cfUL;
   tf->codes[9509] = 0x000104433c44fc94UL;
   tf->codes[9510] = 0x00010446e53558e4UL;
   tf->codes[9511] = 0x00010447cf716ff8UL;
   tf->codes[9512] = 0x00010449a3e99e20UL;
   tf->codes[9513] = 0x0001044a8e25b534UL;
   tf->codes[9514] = 0x0001044b7861cc48UL;
   tf->codes[9515] = 0x00010450461d4571UL;
   tf->codes[9516] = 0x0001045080ac4b36UL;
   tf->codes[9517] = 0x00010453b47e9bfcUL;
   tf->codes[9518] = 0x00010453ef0da1c1UL;
   tf->codes[9519] = 0x00010454d949b8d5UL;
   tf->codes[9520] = 0x0001045638a3db73UL;
   tf->codes[9521] = 0x000104567332e138UL;
   tf->codes[9522] = 0x000104575d6ef84cUL;
   tf->codes[9523] = 0x00010458823a1525UL;
   tf->codes[9524] = 0x00010459e19437c3UL;
   tf->codes[9525] = 0x0001045b065f549cUL;
   tf->codes[9526] = 0x0001045f998bc800UL;
   tf->codes[9527] = 0x0001046725fb8665UL;
   tf->codes[9528] = 0x0001047011c56768UL;
   tf->codes[9529] = 0x00010471e63d9590UL;
   tf->codes[9530] = 0x000104738026bdf3UL;
   tf->codes[9531] = 0x00010475c9bcf7a5UL;
   tf->codes[9532] = 0x00010478fd8f486bUL;
   tf->codes[9533] = 0x0001047c31619931UL;
   tf->codes[9534] = 0x0001047ce10eaa80UL;
   tf->codes[9535] = 0x00010488166ec535UL;
   tf->codes[9536] = 0x00010488c61bd684UL;
   tf->codes[9537] = 0x0001048bf9ee274aUL;
   tf->codes[9538] = 0x0001048dce665572UL;
   tf->codes[9539] = 0x000104917756b1c2UL;
   tf->codes[9540] = 0x000104926192c8d6UL;
   tf->codes[9541] = 0x00010492d6b0d460UL;
   tf->codes[9542] = 0x00010495cff41f61UL;
   tf->codes[9543] = 0x000104967fa130b0UL;
   tf->codes[9544] = 0x00010496ba303675UL;
   tf->codes[9545] = 0x00010496f4bf3c3aUL;
   tf->codes[9546] = 0x000104972f4e41ffUL;
   tf->codes[9547] = 0x00010498c9376a62UL;
   tf->codes[9548] = 0x0001049a632092c5UL;
   tf->codes[9549] = 0x0001049c3798c0edUL;
   tf->codes[9550] = 0x0001049ce745d23cUL;
   tf->codes[9551] = 0x000104a055a728c7UL;
   tf->codes[9552] = 0x000104a38979798dUL;
   tf->codes[9553] = 0x000104a55df1a7b5UL;
   tf->codes[9554] = 0x000104a7e216e72cUL;
   tf->codes[9555] = 0x000104a85734f2b6UL;
   tf->codes[9556] = 0x000104aa663c26a3UL;
   tf->codes[9557] = 0x000104af33f79fccUL;
   tf->codes[9558] = 0x000104afe3a4b11bUL;
   tf->codes[9559] = 0x000104b3177701e1UL;
   tf->codes[9560] = 0x000104b3520607a6UL;
   tf->codes[9561] = 0x000104b401b318f5UL;
   tf->codes[9562] = 0x000104b4b1602a44UL;
   tf->codes[9563] = 0x000104b5610d3b93UL;
   tf->codes[9564] = 0x000104b685d8586cUL;
   tf->codes[9565] = 0x000104b97f1ba36dUL;
   tf->codes[9566] = 0x000104ba6957ba81UL;
   tf->codes[9567] = 0x000104c0214f4abeUL;
   tf->codes[9568] = 0x000104c10b8b61d2UL;
   tf->codes[9569] = 0x000104c1bb387321UL;
   tf->codes[9570] = 0x000104c355219b84UL;
   tf->codes[9571] = 0x000104c77330035eUL;
   tf->codes[9572] = 0x000104c897fb2037UL;
   tf->codes[9573] = 0x000104cb913e6b38UL;
   tf->codes[9574] = 0x000104d26e01184eUL;
   tf->codes[9575] = 0x000104d3cd5b3aecUL;
   tf->codes[9576] = 0x000104d4b7975200UL;
   tf->codes[9577] = 0x000104d616f1749eUL;
   tf->codes[9578] = 0x000104d651807a63UL;
   tf->codes[9579] = 0x000104daaa1de802UL;
   tf->codes[9580] = 0x000104db1f3bf38cUL;
   tf->codes[9581] = 0x000104dcf3b421b4UL;
   tf->codes[9582] = 0x000104dda3613303UL;
   tf->codes[9583] = 0x000104df3d4a5b66UL;
   tf->codes[9584] = 0x000104e0d73383c9UL;
   tf->codes[9585] = 0x000104e111c2898eUL;
   tf->codes[9586] = 0x000104e14c518f53UL;
   tf->codes[9587] = 0x000104e5df7e02b7UL;
   tf->codes[9588] = 0x000104efb583faceUL;
   tf->codes[9589] = 0x000104f2e9564b94UL;
   tf->codes[9590] = 0x000104f35e74571eUL;
   tf->codes[9591] = 0x000104f5a80a90d0UL;
   tf->codes[9592] = 0x000104f657b7a21fUL;
   tf->codes[9593] = 0x000104f98b89f2e5UL;
   tf->codes[9594] = 0x000104fa3b370434UL;
   tf->codes[9595] = 0x000104fc4a3e3821UL;
   tf->codes[9596] = 0x000105077f9e52d6UL;
   tf->codes[9597] = 0x0001050869da69eaUL;
   tf->codes[9598] = 0x0001050919877b39UL;
   tf->codes[9599] = 0x00010509541680feUL;
   tf->codes[9600] = 0x000105132a1c7915UL;
   tf->codes[9601] = 0x0001051489769bb3UL;
   tf->codes[9602] = 0x0001051573b2b2c7UL;
   tf->codes[9603] = 0x00010518a785038dUL;
   tf->codes[9604] = 0x0001051b2baa4304UL;
   tf->codes[9605] = 0x0001051ed49a9f54UL;
   tf->codes[9606] = 0x0001051f0f29a519UL;
   tf->codes[9607] = 0x0001051f49b8aadeUL;
   tf->codes[9608] = 0x0001052033f4c1f2UL;
   tf->codes[9609] = 0x000105227d8afba4UL;
   tf->codes[9610] = 0x00010522b81a0169UL;
   tf->codes[9611] = 0x0001052367c712b8UL;
   tf->codes[9612] = 0x00010525ebec522fUL;
   tf->codes[9613] = 0x00010526d6286943UL;
   tf->codes[9614] = 0x000105315bdb72a9UL;
   tf->codes[9615] = 0x000105341a8fb7e5UL;
   tf->codes[9616] = 0x00010535ef07e60dUL;
   tf->codes[9617] = 0x000105366425f197UL;
   tf->codes[9618] = 0x00010538adbc2b49UL;
   tf->codes[9619] = 0x0001053a82345971UL;
   tf->codes[9620] = 0x0001053b6c707085UL;
   tf->codes[9621] = 0x0001053c56ac8799UL;
   tf->codes[9622] = 0x0001053ccbca9323UL;
   tf->codes[9623] = 0x00010540e9d8fafdUL;
   tf->codes[9624] = 0x000105420ea417d6UL;
   tf->codes[9625] = 0x000105436dfe3a74UL;
   tf->codes[9626] = 0x00010545f22379ebUL;
   tf->codes[9627] = 0x00010547517d9c89UL;
   tf->codes[9628] = 0x0001054abfdef314UL;
   tf->codes[9629] = 0x0001054afa6df8d9UL;
   tf->codes[9630] = 0x0001055211bfabb4UL;
   tf->codes[9631] = 0x000105562fce138eUL;
   tf->codes[9632] = 0x000105578f28362cUL;
   tf->codes[9633] = 0x0001055963a06454UL;
   tf->codes[9634] = 0x0001055f90b6001bUL;
   tf->codes[9635] = 0x000105624f6a4557UL;
   tf->codes[9636] = 0x0001056339a65c6bUL;
   tf->codes[9637] = 0x0001056374356230UL;
   tf->codes[9638] = 0x00010565833c961dUL;
   tf->codes[9639] = 0x00010565f85aa1a7UL;
   tf->codes[9640] = 0x00010569a14afdf7UL;
   tf->codes[9641] = 0x000105725285d935UL;
   tf->codes[9642] = 0x000105728d14defaUL;
   tf->codes[9643] = 0x00010573b1dffbd3UL;
   tf->codes[9644] = 0x00010578f4b98086UL;
   tf->codes[9645] = 0x0001057a19849d5fUL;
   tf->codes[9646] = 0x0001057bedfccb87UL;
   tf->codes[9647] = 0x0001057dc274f9afUL;
   tf->codes[9648] = 0x0001057f21cf1c4dUL;
   tf->codes[9649] = 0x000105816b6555ffUL;
   tf->codes[9650] = 0x00010581e0836189UL;
   tf->codes[9651] = 0x00010582903072d8UL;
   tf->codes[9652] = 0x00010582cabf789dUL;
   tf->codes[9653] = 0x00010583ef8a9576UL;
   tf->codes[9654] = 0x00010585c402c39eUL;
   tf->codes[9655] = 0x000105896cf31feeUL;
   tf->codes[9656] = 0x00010589a78225b3UL;
   tf->codes[9657] = 0x000105937d881dcaUL;
   tf->codes[9658] = 0x000105958c8f51b7UL;
   tf->codes[9659] = 0x0001059cde700a57UL;
   tf->codes[9660] = 0x000105a1ac2b8380UL;
   tf->codes[9661] = 0x000105a296679a94UL;
   tf->codes[9662] = 0x000105a4dffdd446UL;
   tf->codes[9663] = 0x000105a63f57f6e4UL;
   tf->codes[9664] = 0x000105a8c37d365bUL;
   tf->codes[9665] = 0x000105a8fe0c3c20UL;
   tf->codes[9666] = 0x000105b0c50b004aUL;
   tf->codes[9667] = 0x000105b4e3196824UL;
   tf->codes[9668] = 0x000105b51da86de9UL;
   tf->codes[9669] = 0x000105b5583773aeUL;
   tf->codes[9670] = 0x000105ba6081f29cUL;
   tf->codes[9671] = 0x000105bf2e3d6bc5UL;
   tf->codes[9672] = 0x000105c3fbf8e4eeUL;
   tf->codes[9673] = 0x000105c85496528dUL;
   tf->codes[9674] = 0x000105d1b57e3f1aUL;
   tf->codes[9675] = 0x000105d1f00d44dfUL;
   tf->codes[9676] = 0x000105d7a804d51cUL;
   tf->codes[9677] = 0x000105da2c2a1493UL;
   tf->codes[9678] = 0x000105e22db7de82UL;
   tf->codes[9679] = 0x000105e7e5af6ebfUL;
   tf->codes[9680] = 0x000105ea2f45a871UL;
   tf->codes[9681] = 0x000105ebc92ed0d4UL;
   tf->codes[9682] = 0x000105f26b627825UL;
   tf->codes[9683] = 0x000105f6fe8eeb89UL;
   tf->codes[9684] = 0x000105f7ae3bfcd8UL;
   tf->codes[9685] = 0x000105f94825253bUL;
   tf->codes[9686] = 0x000105fe15e09e64UL;
   tf->codes[9687] = 0x000105ff001cb578UL;
   tf->codes[9688] = 0x000105ff3aabbb3dUL;
   tf->codes[9689] = 0x000105ff753ac102UL;
   tf->codes[9690] = 0x0001060aaa9adbb7UL;
   tf->codes[9691] = 0x00010611875d88cdUL;
   tf->codes[9692] = 0x000106140b82c844UL;
   tf->codes[9693] = 0x00010615a56bf0a7UL;
   tf->codes[9694] = 0x000106161a89fc31UL;
   tf->codes[9695] = 0x00010616551901f6UL;
   tf->codes[9696] = 0x00010617b4732494UL;
   tf->codes[9697] = 0x0001061ae845755aUL;
   tf->codes[9698] = 0x0001061b97f286a9UL;
   tf->codes[9699] = 0x000106218a791cabUL;
   tf->codes[9700] = 0x00010625336978fbUL;
   tf->codes[9701] = 0x00010626cd52a15eUL;
   tf->codes[9702] = 0x00010627f21dbe37UL;
   tf->codes[9703] = 0x00010628673bc9c1UL;
   tf->codes[9704] = 0x000106295177e0d5UL;
   tf->codes[9705] = 0x0001062b9b0e1a87UL;
   tf->codes[9706] = 0x0001062d34f742eaUL;
   tf->codes[9707] = 0x00010631c823b64eUL;
   tf->codes[9708] = 0x000106323d41c1d8UL;
   tf->codes[9709] = 0x000106339c9be476UL;
   tf->codes[9710] = 0x000106344c48f5c5UL;
   tf->codes[9711] = 0x00010636d06e353cUL;
   tf->codes[9712] = 0x00010638df756929UL;
   tf->codes[9713] = 0x00010639c9b1803dUL;
   tf->codes[9714] = 0x0001063a795e918cUL;
   tf->codes[9715] = 0x0001063bd8b8b42aUL;
   tf->codes[9716] = 0x0001063d72a1dc8dUL;
   tf->codes[9717] = 0x00010644c482952dUL;
   tf->codes[9718] = 0x0001064539a0a0b7UL;
   tf->codes[9719] = 0x0001064d75bd706bUL;
   tf->codes[9720] = 0x00010652f325fae3UL;
   tf->codes[9721] = 0x00010655774b3a5aUL;
   tf->codes[9722] = 0x00010655b1da401fUL;
   tf->codes[9723] = 0x000106566187516eUL;
   tf->codes[9724] = 0x0001065cc92bf2faUL;
   tf->codes[9725] = 0x000106636b5f9a4bUL;
   tf->codes[9726] = 0x00010663a5eea010UL;
   tf->codes[9727] = 0x0001066a48224761UL;
   tf->codes[9728] = 0x00010670afc6e8edUL;
   tf->codes[9729] = 0x00010672f95d229fUL;
   tf->codes[9730] = 0x0001067333ec2864UL;
   tf->codes[9731] = 0x00010673e39939b3UL;
   tf->codes[9732] = 0x00010675b81167dbUL;
   tf->codes[9733] = 0x0001067801a7a18dUL;
   tf->codes[9734] = 0x0001067b3579f253UL;
   tf->codes[9735] = 0x0001067b7008f818UL;
   tf->codes[9736] = 0x0001067f53885a2dUL;
   tf->codes[9737] = 0x0001067f8e175ff2UL;
   tf->codes[9738] = 0x000106819d1e93dfUL;
   tf->codes[9739] = 0x000106842143d356UL;
   tf->codes[9740] = 0x0001068804c3356bUL;
   tf->codes[9741] = 0x0001068afe06806cUL;
   tf->codes[9742] = 0x0001068badb391bbUL;
   tf->codes[9743] = 0x0001069583b989d2UL;
   tf->codes[9744] = 0x000106975831b7faUL;
   tf->codes[9745] = 0x00010698f21ae05dUL;
   tf->codes[9746] = 0x00010699dc56f771UL;
   tf->codes[9747] = 0x0001069b76401fd4UL;
   tf->codes[9748] = 0x0001069dbfd65986UL;
   tf->codes[9749] = 0x000106a12e37b011UL;
   tf->codes[9750] = 0x000106a6aba03a89UL;
   tf->codes[9751] = 0x000106b9a7ff1968UL;
   tf->codes[9752] = 0x000106bb7c774790UL;
   tf->codes[9753] = 0x000106bbb7064d55UL;
   tf->codes[9754] = 0x000106bbf195531aUL;
   tf->codes[9755] = 0x000106be75ba9291UL;
   tf->codes[9756] = 0x000106c4dd5f341dUL;
   tf->codes[9757] = 0x000106c79c137959UL;
   tf->codes[9758] = 0x000106ca9556c45aUL;
   tf->codes[9759] = 0x000106cc2f3fecbdUL;
   tf->codes[9760] = 0x000106ccdeecfe0cUL;
   tf->codes[9761] = 0x000106d3bbafab22UL;
   tf->codes[9762] = 0x000106d3f63eb0e7UL;
   tf->codes[9763] = 0x000106d430cdb6acUL;
   tf->codes[9764] = 0x000106d6ef81fbe8UL;
   tf->codes[9765] = 0x000106d8c3fa2a10UL;
   tf->codes[9766] = 0x000106d9ae364124UL;
   tf->codes[9767] = 0x000106dbbd3d7511UL;
   tf->codes[9768] = 0x000106de4162b488UL;
   tf->codes[9769] = 0x000106de7bf1ba4dUL;
   tf->codes[9770] = 0x000106df662dd161UL;
   tf->codes[9771] = 0x000106dfdb4bdcebUL;
   tf->codes[9772] = 0x000106e3843c393bUL;
   tf->codes[9773] = 0x000106e8c715bdeeUL;
   tf->codes[9774] = 0x000106e9ebe0dac7UL;
   tf->codes[9775] = 0x000106ead61cf1dbUL;
   tf->codes[9776] = 0x000106eb85ca032aUL;
   tf->codes[9777] = 0x000106f17850992cUL;
   tf->codes[9778] = 0x000106f31239c18fUL;
   tf->codes[9779] = 0x000106f6460c1255UL;
   tf->codes[9780] = 0x000107034fe45b32UL;
   tf->codes[9781] = 0x0001070a2ca70848UL;
   tf->codes[9782] = 0x0001070f34f18736UL;
   tf->codes[9783] = 0x0001071059bca40fUL;
   tf->codes[9784] = 0x00010717e62c6274UL;
   tf->codes[9785] = 0x0001071e886009c5UL;
   tf->codes[9786] = 0x0001071efd7e154fUL;
   tf->codes[9787] = 0x00010721bc325a8bUL;
   tf->codes[9788] = 0x00010724f004ab51UL;
   tf->codes[9789] = 0x000107285e6601dcUL;
   tf->codes[9790] = 0x0001072a32de3004UL;
   tf->codes[9791] = 0x00010730d511d755UL;
   tf->codes[9792] = 0x000107370227731cUL;
   tf->codes[9793] = 0x000107373cb678e1UL;
   tf->codes[9794] = 0x00010739864cb293UL;
   tf->codes[9795] = 0x0001073ae5a6d531UL;
   tf->codes[9796] = 0x0001073e8e973181UL;
   tf->codes[9797] = 0x000107414d4b76bdUL;
   tf->codes[9798] = 0x00010741c2698247UL;
   tf->codes[9799] = 0x00010743d170b634UL;
   tf->codes[9800] = 0x000107456b59de97UL;
   tf->codes[9801] = 0x00010746cab40135UL;
   tf->codes[9802] = 0x00010748d9bb3522UL;
   tf->codes[9803] = 0x000107561e2283c4UL;
   tf->codes[9804] = 0x0001075867b8bd76UL;
   tf->codes[9805] = 0x000107598c83da4fUL;
   tf->codes[9806] = 0x0001075daa924229UL;
   tf->codes[9807] = 0x0001075e1fb04db3UL;
   tf->codes[9808] = 0x0001075e5a3f5378UL;
   tf->codes[9809] = 0x000107602eb781a0UL;
   tf->codes[9810] = 0x0001076153829e79UL;
   tf->codes[9811] = 0x00010762032fafc8UL;
   tf->codes[9812] = 0x00010766d0eb28f1UL;
   tf->codes[9813] = 0x000107674609347bUL;
   tf->codes[9814] = 0x0001076955106868UL;
   tf->codes[9815] = 0x0001076ab46a8b06UL;
   tf->codes[9816] = 0x0001076b9ea6a21aUL;
   tf->codes[9817] = 0x00010771912d381cUL;
   tf->codes[9818] = 0x0001077574ac9a31UL;
   tf->codes[9819] = 0x000107762459ab80UL;
   tf->codes[9820] = 0x0001077af21524a9UL;
   tf->codes[9821] = 0x0001077ba1c235f8UL;
   tf->codes[9822] = 0x00010788367c734bUL;
   tf->codes[9823] = 0x0001078920b88a5fUL;
   tf->codes[9824] = 0x00010794cb36b09eUL;
   tf->codes[9825] = 0x0001079505c5b663UL;
   tf->codes[9826] = 0x00010797c479fb9fUL;
   tf->codes[9827] = 0x0001079839980729UL;
   tf->codes[9828] = 0x0001079a832e40dbUL;
   tf->codes[9829] = 0x000107a1d50ef97bUL;
   tf->codes[9830] = 0x000107a4593438f2UL;
   tf->codes[9831] = 0x000107a78d0689b8UL;
   tf->codes[9832] = 0x000107a8ec60ac56UL;
   tf->codes[9833] = 0x000107aa4bbacef4UL;
   tf->codes[9834] = 0x000107b1630c81cfUL;
   tf->codes[9835] = 0x000107b287d79ea8UL;
   tf->codes[9836] = 0x000107b3e731c146UL;
   tf->codes[9837] = 0x000107b4d16dd85aUL;
   tf->codes[9838] = 0x000107b5468be3e4UL;
   tf->codes[9839] = 0x000107b790221d96UL;
   tf->codes[9840] = 0x000107b8b4ed3a6fUL;
   tf->codes[9841] = 0x000107b99f295183UL;
   tf->codes[9842] = 0x000107bb73a17fabUL;
   tf->codes[9843] = 0x000107bc986c9c84UL;
   tf->codes[9844] = 0x000107bea773d071UL;
   tf->codes[9845] = 0x000107bee202d636UL;
   tf->codes[9846] = 0x000107bf91afe785UL;
   tf->codes[9847] = 0x000107c1a0b71b72UL;
   tf->codes[9848] = 0x000107c28af33286UL;
   tf->codes[9849] = 0x000107c92d26d9d7UL;
   tf->codes[9850] = 0x000107d12eb4a3c6UL;
   tf->codes[9851] = 0x000107d80b7750dcUL;
   tf->codes[9852] = 0x000107d8f5b367f0UL;
   tf->codes[9853] = 0x000107d96ad1737aUL;
   tf->codes[9854] = 0x000107df5d58097cUL;
   tf->codes[9855] = 0x000107e047942090UL;
   tf->codes[9856] = 0x000107e2912a5a42UL;
   tf->codes[9857] = 0x000107e37b667156UL;
   tf->codes[9858] = 0x000107e465a2886aUL;
   tf->codes[9859] = 0x000107f552fa335cUL;
   tf->codes[9860] = 0x000107f7d71f72d3UL;
   tf->codes[9861] = 0x000107f8c15b89e7UL;
   tf->codes[9862] = 0x000107f9ab97a0fbUL;
   tf->codes[9863] = 0x0001080d923296eeUL;
   tf->codes[9864] = 0x0001081175b1f903UL;
   tf->codes[9865] = 0x0001081559315b18UL;
   tf->codes[9866] = 0x000108185274a619UL;
   tf->codes[9867] = 0x0001081a9c0adfcbUL;
   tf->codes[9868] = 0x00010821b35c92a6UL;
   tf->codes[9869] = 0x000108226309a3f5UL;
   tf->codes[9870] = 0x000108234d45bb09UL;
   tf->codes[9871] = 0x00010823c263c693UL;
   tf->codes[9872] = 0x0001082681180bcfUL;
   tf->codes[9873] = 0x0001083106cb1535UL;
   tf->codes[9874] = 0x000108355f6882d4UL;
   tf->codes[9875] = 0x00010838933ad39aUL;
   tf->codes[9876] = 0x00010838cdc9d95fUL;
   tf->codes[9877] = 0x000108390858df24UL;
   tf->codes[9878] = 0x0001083a67b301c2UL;
   tf->codes[9879] = 0x0001083e4b3263d7UL;
   tf->codes[9880] = 0x0001083faa8c8675UL;
   tf->codes[9881] = 0x000108401faa91ffUL;
   tf->codes[9882] = 0x00010845d7a2223cUL;
   tf->codes[9883] = 0x00010846c1de3950UL;
   tf->codes[9884] = 0x00010852e17a6b19UL;
   tf->codes[9885] = 0x0001085391277c68UL;
   tf->codes[9886] = 0x000108552b10a4cbUL;
   tf->codes[9887] = 0x00010856154cbbdfUL;
   tf->codes[9888] = 0x0001085ddc4b8009UL;
   tf->codes[9889] = 0x000108614aacd694UL;
   tf->codes[9890] = 0x000108626f77f36dUL;
   tf->codes[9891] = 0x00010862aa06f932UL;
   tf->codes[9892] = 0x0001086bd05fdffaUL;
   tf->codes[9893] = 0x00010873d1eda9e9UL;
   tf->codes[9894] = 0x0001087de282a7c5UL;
   tf->codes[9895] = 0x0001088275af1b29UL;
   tf->codes[9896] = 0x000108882da6ab66UL;
   tf->codes[9897] = 0x00010893d824d1a5UL;
   tf->codes[9898] = 0x000108970bf7226bUL;
   tf->codes[9899] = 0x000108991afe5658UL;
   tf->codes[9900] = 0x000108a27be642e5UL;
   tf->codes[9901] = 0x000108a4505e710dUL;
   tf->codes[9902] = 0x000108a65f65a4faUL;
   tf->codes[9903] = 0x000108a78430c1d3UL;
   tf->codes[9904] = 0x000108a91e19ea36UL;
   tf->codes[9905] = 0x000108a99337f5c0UL;
   tf->codes[9906] = 0x000108adb1465d9aUL;
   tf->codes[9907] = 0x000108b27f01d6c3UL;
   tf->codes[9908] = 0x000108b53db61bffUL;
   tf->codes[9909] = 0x000108bd3f43e5eeUL;
   tf->codes[9910] = 0x000108bf13bc1416UL;
   tf->codes[9911] = 0x000108c0ada53c79UL;
   tf->codes[9912] = 0x000108c0e834423eUL;
   tf->codes[9913] = 0x000108c331ca7bf0UL;
   tf->codes[9914] = 0x000108c7ff85f519UL;
   tf->codes[9915] = 0x000108cabe3a3a55UL;
   tf->codes[9916] = 0x000108cb6de74ba4UL;
   tf->codes[9917] = 0x000108d2101af2f5UL;
   tf->codes[9918] = 0x000108d49440326cUL;
   tf->codes[9919] = 0x000108d5095e3df6UL;
   tf->codes[9920] = 0x000108d543ed43bbUL;
   tf->codes[9921] = 0x000108d5f39a550aUL;
   tf->codes[9922] = 0x000108d8b24e9a46UL;
   tf->codes[9923] = 0x000108da4c37c2a9UL;
   tf->codes[9924] = 0x000108dbab91e547UL;
   tf->codes[9925] = 0x000108dc20aff0d1UL;
   tf->codes[9926] = 0x000108dc5b3ef696UL;
   tf->codes[9927] = 0x000108e2fd729de7UL;
   tf->codes[9928] = 0x000108e33801a3acUL;
   tf->codes[9929] = 0x000108e5f6b5e8e8UL;
   tf->codes[9930] = 0x000108e7909f114bUL;
   tf->codes[9931] = 0x000108f28b70263bUL;
   tf->codes[9932] = 0x000108f375ac3d4fUL;
   tf->codes[9933] = 0x000108f3b03b4314UL;
   tf->codes[9934] = 0x000108f6e40d93daUL;
   tf->codes[9935] = 0x000108fe707d523fUL;
   tf->codes[9936] = 0x0001090044f58067UL;
   tf->codes[9937] = 0x000109012f31977bUL;
   tf->codes[9938] = 0x0001090253fcb454UL;
   tf->codes[9939] = 0x000109033e38cb68UL;
   tf->codes[9940] = 0x00010903ede5dcb7UL;
   tf->codes[9941] = 0x00010904d821f3cbUL;
   tf->codes[9942] = 0x00010906720b1c2eUL;
   tf->codes[9943] = 0x00010906e72927b8UL;
   tf->codes[9944] = 0x0001090846834a56UL;
   tf->codes[9945] = 0x00010909e06c72b9UL;
   tf->codes[9946] = 0x00010911a76b36e3UL;
   tf->codes[9947] = 0x00010912cc3653bcUL;
   tf->codes[9948] = 0x000109163a97aa47UL;
   tf->codes[9949] = 0x00010916afb5b5d1UL;
   tf->codes[9950] = 0x00010916ea44bb96UL;
   tf->codes[9951] = 0x0001091d175a575dUL;
   tf->codes[9952] = 0x000109204b2ca823UL;
   tf->codes[9953] = 0x00010924a3ca15c2UL;
   tf->codes[9954] = 0x00010925c895329bUL;
   tf->codes[9955] = 0x00010933f7389851UL;
   tf->codes[9956] = 0x000109351c03b52aUL;
   tf->codes[9957] = 0x000109359121c0b4UL;
   tf->codes[9958] = 0x000109367b5dd7c8UL;
   tf->codes[9959] = 0x00010936b5ecdd8dUL;
   tf->codes[9960] = 0x00010938ff83173fUL;
   tf->codes[9961] = 0x0001093b491950f1UL;
   tf->codes[9962] = 0x0001093bbe375c7bUL;
   tf->codes[9963] = 0x00010941eb4cf842UL;
   tf->codes[9964] = 0x00010942606b03ccUL;
   tf->codes[9965] = 0x00010946f3977730UL;
   tf->codes[9966] = 0x00010948c80fa558UL;
   tf->codes[9967] = 0x0001094ad716d945UL;
   tf->codes[9968] = 0x0001094bfbe1f61eUL;
   tf->codes[9969] = 0x00010951794a8096UL;
   tf->codes[9970] = 0x000109529e159d6fUL;
   tf->codes[9971] = 0x00010958cb2b3936UL;
   tf->codes[9972] = 0x0001095905ba3efbUL;
   tf->codes[9973] = 0x00010959eff6560fUL;
   tf->codes[9974] = 0x0001095b89df7e72UL;
   tf->codes[9975] = 0x00010967e40ab600UL;
   tf->codes[9976] = 0x00010973c917e204UL;
   tf->codes[9977] = 0x0001097403a6e7c9UL;
   tf->codes[9978] = 0x00010974b353f918UL;
   tf->codes[9979] = 0x00010974ede2feddUL;
   tf->codes[9980] = 0x00010977ac974419UL;
   tf->codes[9981] = 0x00010977e72649deUL;
   tf->codes[9982] = 0x000109805dd21f57UL;
   tf->codes[9983] = 0x00010981480e366bUL;
   tf->codes[9984] = 0x00010981bd2c41f5UL;
   tf->codes[9985] = 0x00010982a7685909UL;
   tf->codes[9986] = 0x000109831c866493UL;
   tf->codes[9987] = 0x00010985a0aba40aUL;
   tf->codes[9988] = 0x0001098aa8f622f8UL;
   tf->codes[9989] = 0x0001098febcfa7abUL;
   tf->codes[9990] = 0x000109923565e15dUL;
   tf->codes[9991] = 0x00010994f41a2699UL;
   tf->codes[9992] = 0x00010997ed5d719aUL;
   tf->codes[9993] = 0x0001099b212fc260UL;
   tf->codes[9994] = 0x000109a0d927529dUL;
   tf->codes[9995] = 0x000109a14e455e27UL;
   tf->codes[9996] = 0x000109a273107b00UL;
   tf->codes[9997] = 0x000109a322bd8c4fUL;
   tf->codes[9998] = 0x000109a6911ee2daUL;
   tf->codes[9999] = 0x000109b06724daf1UL;
   tf->codes[10000] = 0x000109b23b9d0919UL;
   tf->codes[10001] = 0x000109b410153741UL;
   tf->codes[10002] = 0x000109ba3d2ad308UL;
   tf->codes[10003] = 0x000109bed057466cUL;
   tf->codes[10004] = 0x000109c204299732UL;
   tf->codes[10005] = 0x000109cab5647270UL;
   tf->codes[10006] = 0x000109cb2a827dfaUL;
   tf->codes[10007] = 0x000109d1ccb6254bUL;
   tf->codes[10008] = 0x000109d207452b10UL;
   tf->codes[10009] = 0x000109d32c1047e9UL;
   tf->codes[10010] = 0x000109d6255392eaUL;
   tf->codes[10011] = 0x000109d7bf3cbb4dUL;
   tf->codes[10012] = 0x000109d993b4e975UL;
   tf->codes[10013] = 0x000109dffb598b01UL;
   tf->codes[10014] = 0x000109e369bae18cUL;
   tf->codes[10015] = 0x000109e3a449e751UL;
   tf->codes[10016] = 0x000109f0390424a4UL;
   tf->codes[10017] = 0x000109f20d7c52ccUL;
   tf->codes[10018] = 0x000109f3a7657b2fUL;
   tf->codes[10019] = 0x000109f3e1f480f4UL;
   tf->codes[10020] = 0x000109f41c8386b9UL;
   tf->codes[10021] = 0x000109f62b8abaa6UL;
   tf->codes[10022] = 0x000109fa49992280UL;
   tf->codes[10023] = 0x000109fd084d67bcUL;
   tf->codes[10024] = 0x000109fdf2897ed0UL;
   tf->codes[10025] = 0x00010a00ebccc9d1UL;
   tf->codes[10026] = 0x00010a01d608e0e5UL;
   tf->codes[10027] = 0x00010a045a2e205cUL;
   tf->codes[10028] = 0x00010a06a3c45a0eUL;
   tf->codes[10029] = 0x00010a0927e99985UL;
   tf->codes[10030] = 0x00010a09d796aad4UL;
   tf->codes[10031] = 0x00010a0a4cb4b65eUL;
   tf->codes[10032] = 0x00010a1631c1e262UL;
   tf->codes[10033] = 0x00010a187b581c14UL;
   tf->codes[10034] = 0x00010a19dab23eb2UL;
   tf->codes[10035] = 0x00010a1be9b9729fUL;
   tf->codes[10036] = 0x00010a22c67c1fb5UL;
   tf->codes[10037] = 0x00010a2425d64253UL;
   tf->codes[10038] = 0x00010a27943798deUL;
   tf->codes[10039] = 0x00010a28b902b5b7UL;
   tf->codes[10040] = 0x00010a3637f90a1eUL;
   tf->codes[10041] = 0x00010a36e7a61b6dUL;
   tf->codes[10042] = 0x00010a3acb257d82UL;
   tf->codes[10043] = 0x00010a3b05b48347UL;
   tf->codes[10044] = 0x00010a3bb5619496UL;
   tf->codes[10045] = 0x00010a3cda2cb16fUL;
   tf->codes[10046] = 0x00010a3d89d9c2beUL;
   tf->codes[10047] = 0x00010a3e3986d40dUL;
   tf->codes[10048] = 0x00010a40488e07faUL;
   tf->codes[10049] = 0x00010a4675a3a3c1UL;
   tf->codes[10050] = 0x00010a46b032a986UL;
   tf->codes[10051] = 0x00010a49a975f487UL;
   tf->codes[10052] = 0x00010a504ba99bd8UL;
   tf->codes[10053] = 0x00010a51e592c43bUL;
   tf->codes[10054] = 0x00010a5dca9ff03fUL;
   tf->codes[10055] = 0x00010a61e8ae5819UL;
   tf->codes[10056] = 0x00010a630d7974f2UL;
   tf->codes[10057] = 0x00010a64a7629d55UL;
   tf->codes[10058] = 0x00010a69afad1c43UL;
   tf->codes[10059] = 0x00010a722658f1bcUL;
   tf->codes[10060] = 0x00010a73109508d0UL;
   tf->codes[10061] = 0x00010a755a2b4282UL;
   tf->codes[10062] = 0x00010a77de5081f9UL;
   tf->codes[10063] = 0x00010a79031b9ed2UL;
   tf->codes[10064] = 0x00010a7a6275c170UL;
   tf->codes[10065] = 0x00010a7fdfde4be8UL;
   tf->codes[10066] = 0x00010a808f8b5d37UL;
   tf->codes[10067] = 0x00010a822974859aUL;
   tf->codes[10068] = 0x00010a829e929124UL;
   tf->codes[10069] = 0x00010a82d92196e9UL;
   tf->codes[10070] = 0x00010a922c901978UL;
   tf->codes[10071] = 0x00010a92dc3d2ac7UL;
   tf->codes[10072] = 0x00010a94b0b558efUL;
   tf->codes[10073] = 0x00010a9fe61573a4UL;
   tf->codes[10074] = 0x00010aa319e7c46aUL;
   tf->codes[10075] = 0x00010aa772853209UL;
   tf->codes[10076] = 0x00010aadda29d395UL;
   tf->codes[10077] = 0x00010ab0d36d1e96UL;
   tf->codes[10078] = 0x00010ab3922163d2UL;
   tf->codes[10079] = 0x00010ab984a7f9d4UL;
   tf->codes[10080] = 0x00010ab9f9c6055eUL;
   tf->codes[10081] = 0x00010abe526372fdUL;
   tf->codes[10082] = 0x00010abfec4c9b60UL;
   tf->codes[10083] = 0x00010ac73e2d5400UL;
   tf->codes[10084] = 0x00010ac828696b14UL;
   tf->codes[10085] = 0x00010ac89d87769eUL;
   tf->codes[10086] = 0x00010ad2ae1c747aUL;
   tf->codes[10087] = 0x00010ad398588b8eUL;
   tf->codes[10088] = 0x00010ad61c7dcb05UL;
   tf->codes[10089] = 0x00010ad9c56e2755UL;
   tf->codes[10090] = 0x00010ada3a8c32dfUL;
   tf->codes[10091] = 0x00010adbd4755b42UL;
   tf->codes[10092] = 0x00010adcbeb17256UL;
   tf->codes[10093] = 0x00010ae1174edff5UL;
   tf->codes[10094] = 0x00010ae3265613e2UL;
   tf->codes[10095] = 0x00010ae39b741f6cUL;
   tf->codes[10096] = 0x00010ae4face420aUL;
   tf->codes[10097] = 0x00010ae82ea092d0UL;
   tf->codes[10098] = 0x00010af44e3cc499UL;
   tf->codes[10099] = 0x00010af4c35ad023UL;
   tf->codes[10100] = 0x00010af65d43f886UL;
   tf->codes[10101] = 0x00010af91bf83dc2UL;
   tf->codes[10102] = 0x00010afab5e16625UL;
   tf->codes[10103] = 0x00010b006dd8f662UL;
   tf->codes[10104] = 0x00010b03a1ab4728UL;
   tf->codes[10105] = 0x00010b06d57d97eeUL;
   tf->codes[10106] = 0x00010b0b68aa0b52UL;
   tf->codes[10107] = 0x00010b136a37d541UL;
   tf->codes[10108] = 0x00010b15793f092eUL;
   tf->codes[10109] = 0x00010b19222f657eUL;
   tf->codes[10110] = 0x00010b1b3136996bUL;
   tf->codes[10111] = 0x00010b1ba654a4f5UL;
   tf->codes[10112] = 0x00010b26a125b9e5UL;
   tf->codes[10113] = 0x00010b2abf3421bfUL;
   tf->codes[10114] = 0x00010b30b1bab7c1UL;
   tf->codes[10115] = 0x00010b32fb50f173UL;
   tf->codes[10116] = 0x00010b357f7630eaUL;
   tf->codes[10117] = 0x00010b362f234239UL;
   tf->codes[10118] = 0x00010b37c90c6a9cUL;
   tf->codes[10119] = 0x00010b383e2a7626UL;
   tf->codes[10120] = 0x00010b3878b97bebUL;
   tf->codes[10121] = 0x00010b3a12a2a44eUL;
   tf->codes[10122] = 0x00010b3b376dc127UL;
   tf->codes[10123] = 0x00010b4005293a50UL;
   tf->codes[10124] = 0x00010b4129f45729UL;
   tf->codes[10125] = 0x00010b450d73b93eUL;
   tf->codes[10126] = 0x00010b48b664158eUL;
   tf->codes[10127] = 0x00010b4a504d3df1UL;
   tf->codes[10128] = 0x00010b4d0f01832dUL;
   tf->codes[10129] = 0x00010b500844ce2eUL;
   tf->codes[10130] = 0x00010b507d62d9b8UL;
   tf->codes[10131] = 0x00010b512d0feb07UL;
   tf->codes[10132] = 0x00010b51679ef0ccUL;
   tf->codes[10133] = 0x00010b5251db07e0UL;
   tf->codes[10134] = 0x00010b549b714192UL;
   tf->codes[10135] = 0x00010b54d6004757UL;
   tf->codes[10136] = 0x00010b55c03c5e6bUL;
   tf->codes[10137] = 0x00010b56355a69f5UL;
   tf->codes[10138] = 0x00010b5a5368d1cfUL;
   tf->codes[10139] = 0x00010b6254f69bbeUL;
   tf->codes[10140] = 0x00010b64296ec9e6UL;
   tf->codes[10141] = 0x00010b64d91bdb35UL;
   tf->codes[10142] = 0x00010b69a6d7545eUL;
   tf->codes[10143] = 0x00010b6ee9b0d911UL;
   tf->codes[10144] = 0x00010b71334712c3UL;
   tf->codes[10145] = 0x00010b76b0af9d3bUL;
   tf->codes[10146] = 0x00010b788527cb63UL;
   tf->codes[10147] = 0x00010b82209ebdb5UL;
   tf->codes[10148] = 0x00010b858f001440UL;
   tf->codes[10149] = 0x00010b86793c2b54UL;
   tf->codes[10150] = 0x00010b86ee5a36deUL;
   tf->codes[10151] = 0x00010b91740d4044UL;
   tf->codes[10152] = 0x00010b925e495758UL;
   tf->codes[10153] = 0x00010b96b6e6c4f7UL;
   tf->codes[10154] = 0x00010b9ca96d5af9UL;
   tf->codes[10155] = 0x00010b9d93a9720dUL;
   tf->codes[10156] = 0x00010b9dce3877d2UL;
   tf->codes[10157] = 0x00010b9e4356835cUL;
   tf->codes[10158] = 0x00010ba3fb4e1399UL;
   tf->codes[10159] = 0x00010ba769af6a24UL;
   tf->codes[10160] = 0x00010baa9d81baeaUL;
   tf->codes[10161] = 0x00010bab87bdd1feUL;
   tf->codes[10162] = 0x00010bb0900850ecUL;
   tf->codes[10163] = 0x00010bb105265c76UL;
   tf->codes[10164] = 0x00010bb229f1794fUL;
   tf->codes[10165] = 0x00010bb3fe69a777UL;
   tf->codes[10166] = 0x00010bb7a75a03c7UL;
   tf->codes[10167] = 0x00010bb7e1e9098cUL;
   tf->codes[10168] = 0x00010bba660e4903UL;
   tf->codes[10169] = 0x00010bc2dcba1e7cUL;
   tf->codes[10170] = 0x00010bc59b6e63b8UL;
   tf->codes[10171] = 0x00010bc8cf40b47eUL;
   tf->codes[10172] = 0x00010bd0963f78a8UL;
   tf->codes[10173] = 0x00010bd23028a10bUL;
   tf->codes[10174] = 0x00010bd26ab7a6d0UL;
   tf->codes[10175] = 0x00010be18397239aUL;
   tf->codes[10176] = 0x00010be3580f51c2UL;
   tf->codes[10177] = 0x00010be700ffae12UL;
   tf->codes[10178] = 0x00010be7eb3bc526UL;
   tf->codes[10179] = 0x00010be94a95e7c4UL;
   tf->codes[10180] = 0x00010bf14c23b1b3UL;
   tf->codes[10181] = 0x00010bf2ab7dd451UL;
   tf->codes[10182] = 0x00010bf6c98c3c2bUL;
   tf->codes[10183] = 0x00010bf988408167UL;
   tf->codes[10184] = 0x00010bff403811a4UL;
   tf->codes[10185] = 0x00010c0323b773b9UL;
   tf->codes[10186] = 0x00010c04f82fa1e1UL;
   tf->codes[10187] = 0x00010c1117cbd3aaUL;
   tf->codes[10188] = 0x00010c11c778e4f9UL;
   tf->codes[10189] = 0x00010c1695345e22UL;
   tf->codes[10190] = 0x00010c177f707536UL;
   tf->codes[10191] = 0x00010c1a0395b4adUL;
   tf->codes[10192] = 0x00010c1ab342c5fcUL;
   tf->codes[10193] = 0x00010c223fb28461UL;
   tf->codes[10194] = 0x00010c24142ab289UL;
   tf->codes[10195] = 0x00010c2ed46cc1b4UL;
   tf->codes[10196] = 0x00010c32f27b298eUL;
   tf->codes[10197] = 0x00010c37c036a2b7UL;
   tf->codes[10198] = 0x00010c3b6926ff07UL;
   tf->codes[10199] = 0x00010c3d782e32f4UL;
   tf->codes[10200] = 0x00010c3db2bd38b9UL;
   tf->codes[10201] = 0x00010c3f873566e1UL;
   tf->codes[10202] = 0x00010c415bad9509UL;
   tf->codes[10203] = 0x00010c41d0cba093UL;
   tf->codes[10204] = 0x00010c453f2cf71eUL;
   tf->codes[10205] = 0x00010c50e9ab1d5dUL;
   tf->codes[10206] = 0x00010c52be234b85UL;
   tf->codes[10207] = 0x00010c533341570fUL;
   tf->codes[10208] = 0x00010c57c66dca73UL;
   tf->codes[10209] = 0x00010c5d7e655ab0UL;
   tf->codes[10210] = 0x00010c5ea3307789UL;
   tf->codes[10211] = 0x00010c5fc7fb9462UL;
   tf->codes[10212] = 0x00010c624c20d3d9UL;
   tf->codes[10213] = 0x00010c666a2f3bb3UL;
   tf->codes[10214] = 0x00010c719f8f5668UL;
   tf->codes[10215] = 0x00010c7339787ecbUL;
   tf->codes[10216] = 0x00010c745e439ba4UL;
   tf->codes[10217] = 0x00010c74d361a72eUL;
   tf->codes[10218] = 0x00010c775786e6a5UL;
   tf->codes[10219] = 0x00010c79668e1a92UL;
   tf->codes[10220] = 0x00010c79dbac261cUL;
   tf->codes[10221] = 0x00010c7b007742f5UL;
   tf->codes[10222] = 0x00010c7bb0245444UL;
   tf->codes[10223] = 0x00010c7f93a3b659UL;
   tf->codes[10224] = 0x00010c8635d75daaUL;
   tf->codes[10225] = 0x00010c867066636fUL;
   tf->codes[10226] = 0x00010c8ac903d10eUL;
   tf->codes[10227] = 0x00010c95fe63ebc3UL;
   tf->codes[10228] = 0x00010c97984d1426UL;
   tf->codes[10229] = 0x00010c980d6b1fb0UL;
   tf->codes[10230] = 0x00010c9acc1f64ecUL;
   tf->codes[10231] = 0x00010c9bb65b7c00UL;
   tf->codes[10232] = 0x00010c9f5f4bd850UL;
   tf->codes[10233] = 0x00010ca16e530c3dUL;
   tf->codes[10234] = 0x00010ca46796573eUL;
   tf->codes[10235] = 0x00010ca6b12c90f0UL;
   tf->codes[10236] = 0x00010ca6ebbb96b5UL;
   tf->codes[10237] = 0x00010caa1f8de77bUL;
   tf->codes[10238] = 0x00010cb25baab72fUL;
   tf->codes[10239] = 0x00010cb38075d408UL;
   tf->codes[10240] = 0x00010cb51a5efc6bUL;
   tf->codes[10241] = 0x00010cba5d38811eUL;
   tf->codes[10242] = 0x00010cbb47749832UL;
   tf->codes[10243] = 0x00010cbe7b46e8f8UL;
   tf->codes[10244] = 0x00010cc0ff6c286fUL;
   tf->codes[10245] = 0x00010ccb851f31d5UL;
   tf->codes[10246] = 0x00010ccbfa3d3d5fUL;
   tf->codes[10247] = 0x00010cd90415863cUL;
   tf->codes[10248] = 0x00010cda9dfeae9fUL;
   tf->codes[10249] = 0x00010cdce794e851UL;
   tf->codes[10250] = 0x00010cdd5cb2f3dbUL;
   tf->codes[10251] = 0x00010ce055f63edcUL;
   tf->codes[10252] = 0x00010ce314aa8418UL;
   tf->codes[10253] = 0x00010ce34f3989ddUL;
   tf->codes[10254] = 0x00010ce5d35ec954UL;
   tf->codes[10255] = 0x00010ce8cca21455UL;
   tf->codes[10256] = 0x00010cea668b3cb8UL;
   tf->codes[10257] = 0x00010cf22d8a00e2UL;
   tf->codes[10258] = 0x00010cf2dd371231UL;
   tf->codes[10259] = 0x00010cf64b9868bcUL;
   tf->codes[10260] = 0x00010cf6c0b67446UL;
   tf->codes[10261] = 0x00010cfec2443e35UL;
   tf->codes[10262] = 0x00010d07ae0e1f38UL;
   tf->codes[10263] = 0x00010d09f7a458eaUL;
   tf->codes[10264] = 0x00010d0b1c6f75c3UL;
   tf->codes[10265] = 0x00010d0bcc1c8712UL;
   tf->codes[10266] = 0x00010d12e36e39edUL;
   tf->codes[10267] = 0x00010d17b129b316UL;
   tf->codes[10268] = 0x00010d1f3d99717bUL;
   tf->codes[10269] = 0x00010d232118d390UL;
   tf->codes[10270] = 0x00010d239636df1aUL;
   tf->codes[10271] = 0x00010d253020077dUL;
   tf->codes[10272] = 0x00010d25a53e1307UL;
   tf->codes[10273] = 0x00010d25dfcd18ccUL;
   tf->codes[10274] = 0x00010d314fbc3946UL;
   tf->codes[10275] = 0x00010d35a859a6e5UL;
   tf->codes[10276] = 0x00010d39514a0335UL;
   tf->codes[10277] = 0x00010d3b60513722UL;
   tf->codes[10278] = 0x00010d3cfa3a5f85UL;
   tf->codes[10279] = 0x00010d3da9e770d4UL;
   tf->codes[10280] = 0x00010d3e942387e8UL;
   tf->codes[10281] = 0x00010d3eceb28dadUL;
   tf->codes[10282] = 0x00010d43274ffb4cUL;
   tf->codes[10283] = 0x00010d45ab753ac3UL;
   tf->codes[10284] = 0x00010d46d040579cUL;
   tf->codes[10285] = 0x00010d4954659713UL;
   tf->codes[10286] = 0x00010d4a7930b3ecUL;
   tf->codes[10287] = 0x00010d4aee4ebf76UL;
   tf->codes[10288] = 0x00010d5ba11764a3UL;
   tf->codes[10289] = 0x00010d5e5fcba9dfUL;
   tf->codes[10290] = 0x00010d5f4a07c0f3UL;
   tf->codes[10291] = 0x00010d61590ef4e0UL;
   tf->codes[10292] = 0x00010d63dd343457UL;
   tf->codes[10293] = 0x00010d65771d5cbaUL;
   tf->codes[10294] = 0x00010d736b31bcabUL;
   tf->codes[10295] = 0x00010d7af7a17b10UL;
   tf->codes[10296] = 0x00010d82498233b0UL;
   tf->codes[10297] = 0x00010d880179c3edUL;
   tf->codes[10298] = 0x00010d8b354c14b3UL;
   tf->codes[10299] = 0x00010d945ba4fb7bUL;
   tf->codes[10300] = 0x00010d96a53b352dUL;
   tf->codes[10301] = 0x00010d96dfca3af2UL;
   tf->codes[10302] = 0x00010d9afdd8a2ccUL;
   tf->codes[10303] = 0x00010d9c5d32c56aUL;
   tf->codes[10304] = 0x00010d9ee15804e1UL;
   tf->codes[10305] = 0x00010da2152a55a7UL;
   tf->codes[10306] = 0x00010da3af137e0aUL;
   tf->codes[10307] = 0x00010da71d74d495UL;
   tf->codes[10308] = 0x00010daa16b81f96UL;
   tf->codes[10309] = 0x00010db33d11065eUL;
   tf->codes[10310] = 0x00010db96a26a225UL;
   tf->codes[10311] = 0x00010dba5462b939UL;
   tf->codes[10312] = 0x00010dbdfd531589UL;
   tf->codes[10313] = 0x00010dc3402c9a3cUL;
   tf->codes[10314] = 0x00010dc6e91cf68cUL;
   tf->codes[10315] = 0x00010dd37dd733dfUL;
   tf->codes[10316] = 0x00010ddb7f64fdceUL;
   tf->codes[10317] = 0x00010ddc69a114e2UL;
   tf->codes[10318] = 0x00010ddfd8026b6dUL;
   tf->codes[10319] = 0x00010de58ff9fbaaUL;
   tf->codes[10320] = 0x00010debbd0f9771UL;
   tf->codes[10321] = 0x00010dec322da2fbUL;
   tf->codes[10322] = 0x00010ded9187c599UL;
   tf->codes[10323] = 0x00010df3840e5b9bUL;
   tf->codes[10324] = 0x00010df3f92c6725UL;
   tf->codes[10325] = 0x00010df5588689c3UL;
   tf->codes[10326] = 0x00010df8173aceffUL;
   tf->codes[10327] = 0x00010df851c9d4c4UL;
   tf->codes[10328] = 0x00010dfa264202ecUL;
   tf->codes[10329] = 0x00010dfb859c258aUL;
   tf->codes[10330] = 0x00010dfc354936d9UL;
   tf->codes[10331] = 0x00010e013d93b5c7UL;
   tf->codes[10332] = 0x00010e02625ed2a0UL;
   tf->codes[10333] = 0x00010e029cedd865UL;
   tf->codes[10334] = 0x00010e0979b0857bUL;
   tf->codes[10335] = 0x00010e15242eabbaUL;
   tf->codes[10336] = 0x00010e173335dfa7UL;
   tf->codes[10337] = 0x00010e176dc4e56cUL;
   tf->codes[10338] = 0x00010e19423d1394UL;
   tf->codes[10339] = 0x00010e1c00f158d0UL;
   tf->codes[10340] = 0x00010e1ebfa59e0cUL;
   tf->codes[10341] = 0x00010e238d611735UL;
   tf->codes[10342] = 0x00010e259c684b22UL;
   tf->codes[10343] = 0x00010e26c13367fbUL;
   tf->codes[10344] = 0x00010e27ab6f7f0fUL;
   tf->codes[10345] = 0x00010e28d03a9be8UL;
   tf->codes[10346] = 0x00010e2a2f94be86UL;
   tf->codes[10347] = 0x00010e2f37df3d74UL;
   tf->codes[10348] = 0x00010e31bc047cebUL;
   tf->codes[10349] = 0x00010e33907cab13UL;
   tf->codes[10350] = 0x00010e347ab8c227UL;
   tf->codes[10351] = 0x00010e3e50beba3eUL;
   tf->codes[10352] = 0x00010e409a54f3f0UL;
   tf->codes[10353] = 0x00010e43ce2744b6UL;
   tf->codes[10354] = 0x00010e45a29f72deUL;
   tf->codes[10355] = 0x00010e45dd2e78a3UL;
   tf->codes[10356] = 0x00010e486153b81aUL;
   tf->codes[10357] = 0x00010e4fb33470baUL;
   tf->codes[10358] = 0x00010e4fedc3767fUL;
   tf->codes[10359] = 0x00010e54f60df56dUL;
   tf->codes[10360] = 0x00010e55a5bb06bcUL;
   tf->codes[10361] = 0x00010e577a3334e4UL;
   tf->codes[10362] = 0x00010e57ef51406eUL;
   tf->codes[10363] = 0x00010e5a73767fe5UL;
   tf->codes[10364] = 0x00010e5c0d5fa848UL;
   tf->codes[10365] = 0x00010e5de1d7d670UL;
   tf->codes[10366] = 0x00010e5e1c66dc35UL;
   tf->codes[10367] = 0x00010e5e9184e7bfUL;
   tf->codes[10368] = 0x00010e60a08c1bacUL;
   tf->codes[10369] = 0x00010e6324b15b23UL;
   tf->codes[10370] = 0x00010e72781fddb2UL;
   tf->codes[10371] = 0x00010e72ed3de93cUL;
   tf->codes[10372] = 0x00010e7621103a02UL;
   tf->codes[10373] = 0x00010e77f588682aUL;
   tf->codes[10374] = 0x00010e7c88b4db8eUL;
   tf->codes[10375] = 0x00010e7e97bc0f7bUL;
   tf->codes[10376] = 0x00010e844fb39fb8UL;
   tf->codes[10377] = 0x00010e88333301cdUL;
   tf->codes[10378] = 0x00010e8b2c764cceUL;
   tf->codes[10379] = 0x00010e92f37510f8UL;
   tf->codes[10380] = 0x00010e932e0416bdUL;
   tf->codes[10381] = 0x00010e93ddb1280cUL;
   tf->codes[10382] = 0x00010e95027c44e5UL;
   tf->codes[10383] = 0x00010e98ab6ca135UL;
   tf->codes[10384] = 0x00010e9995a8b849UL;
   tf->codes[10385] = 0x00010e9dee4625e8UL;
   tf->codes[10386] = 0x00010ea0e78970e9UL;
   tf->codes[10387] = 0x00010ea1d1c587fdUL;
   tf->codes[10388] = 0x00010ea28172994cUL;
   tf->codes[10389] = 0x00010ea8ae883513UL;
   tf->codes[10390] = 0x00010ea95e354662UL;
   tf->codes[10391] = 0x00010eaabd8f6900UL;
   tf->codes[10392] = 0x00010eb249ff2765UL;
   tf->codes[10393] = 0x00010eb62d7e897aUL;
   tf->codes[10394] = 0x00010eb717baa08eUL;
   tf->codes[10395] = 0x00010eb83c85bd67UL;
   tf->codes[10396] = 0x00010eb8b1a3c8f1UL;
   tf->codes[10397] = 0x00010ec19d6da9f4UL;
   tf->codes[10398] = 0x00010ec33756d257UL;
   tf->codes[10399] = 0x00010ec5bb7c11ceUL;
   tf->codes[10400] = 0x00010ed2c5545aabUL;
   tf->codes[10401] = 0x00010ed3af9071bfUL;
   tf->codes[10402] = 0x00010ed7cd9ed999UL;
   tf->codes[10403] = 0x00010ed9a21707c1UL;
   tf->codes[10404] = 0x00010edfcf2ca388UL;
   tf->codes[10405] = 0x00010ee0b968ba9cUL;
   tf->codes[10406] = 0x00010ee1de33d775UL;
   tf->codes[10407] = 0x00010ee33d8dfa13UL;
   tf->codes[10408] = 0x00010ee3ed3b0b62UL;
   tf->codes[10409] = 0x00010ee671604ad9UL;
   tf->codes[10410] = 0x00010eeb3f1bc402UL;
   tf->codes[10411] = 0x00010ef58a3fc7a3UL;
   tf->codes[10412] = 0x00010ef8be121869UL;
   tf->codes[10413] = 0x00010ef9e2dd3542UL;
   tf->codes[10414] = 0x00010efe7609a8a6UL;
   tf->codes[10415] = 0x00010f1137d981c0UL;
   tf->codes[10416] = 0x00010f1172688785UL;
   tf->codes[10417] = 0x00010f12d1c2aa23UL;
   tf->codes[10418] = 0x00010f17da0d2911UL;
   tf->codes[10419] = 0x00010f1b486e7f9cUL;
   tf->codes[10420] = 0x00010f1ce257a7ffUL;
   tf->codes[10421] = 0x00010f230f6d43c6UL;
   tf->codes[10422] = 0x00010f29b1a0eb17UL;
   tf->codes[10423] = 0x00010f2a614dfc66UL;
   tf->codes[10424] = 0x00010f313e10a97cUL;
   tf->codes[10425] = 0x00010f3387a6e32eUL;
   tf->codes[10426] = 0x00010f36bb7933f4UL;
   tf->codes[10427] = 0x00010f37a5b54b08UL;
   tf->codes[10428] = 0x00010f3bfe52b8a7UL;
   tf->codes[10429] = 0x00010f4315a46b82UL;
   tf->codes[10430] = 0x00010f4524ab9f6fUL;
   tf->codes[10431] = 0x00010f4efab19786UL;
   tf->codes[10432] = 0x00010f5109b8cb73UL;
   tf->codes[10433] = 0x00010f5a3011b23bUL;
   tf->codes[10434] = 0x00010f5b8f6bd4d9UL;
   tf->codes[10435] = 0x00010f5d63e40301UL;
   tf->codes[10436] = 0x00010f5d9e7308c6UL;
   tf->codes[10437] = 0x00010f5ec33e259fUL;
   tf->codes[10438] = 0x00010f63cb88a48dUL;
   tf->codes[10439] = 0x00010f690e622940UL;
   tf->codes[10440] = 0x00010f6f7606caccUL;
   tf->codes[10441] = 0x00010f71fa2c0a43UL;
   tf->codes[10442] = 0x00010f75a31c6693UL;
   tf->codes[10443] = 0x00010f7702768931UL;
   tf->codes[10444] = 0x00010f77b2239a80UL;
   tf->codes[10445] = 0x00010f782741a60aUL;
   tf->codes[10446] = 0x00010f7b95a2fc95UL;
   tf->codes[10447] = 0x00010f8237d6a3e6UL;
   tf->codes[10448] = 0x00010f839730c684UL;
   tf->codes[10449] = 0x00010f840c4ed20eUL;
   tf->codes[10450] = 0x00010f8989b75c86UL;
   tf->codes[10451] = 0x00010f92006331ffUL;
   tf->codes[10452] = 0x00010f9449f96bb1UL;
   tf->codes[10453] = 0x00010f961e7199d9UL;
   tf->codes[10454] = 0x00010f986807d38bUL;
   tf->codes[10455] = 0x00010f99c761f629UL;
   tf->codes[10456] = 0x00010f9b9bda2451UL;
   tf->codes[10457] = 0x00010fa2789cd167UL;
   tf->codes[10458] = 0x00010fa41285f9caUL;
   tf->codes[10459] = 0x00010fa7f6055bdfUL;
   tf->codes[10460] = 0x00010fb3db1287e3UL;
   tf->codes[10461] = 0x00010fbc51be5d5cUL;
   tf->codes[10462] = 0x00010fbed5e39cd3UL;
   tf->codes[10463] = 0x00010fbf8590ae22UL;
   tf->codes[10464] = 0x00010fc418bd2186UL;
   tf->codes[10465] = 0x00010fc662535b38UL;
   tf->codes[10466] = 0x00010fc7fc3c839bUL;
   tf->codes[10467] = 0x00010fcb6a9dda26UL;
   tf->codes[10468] = 0x00010fce29521f62UL;
   tf->codes[10469] = 0x00010fd03859534fUL;
   tf->codes[10470] = 0x00010fd197b375edUL;
   tf->codes[10471] = 0x00010fd24760873cUL;
   tf->codes[10472] = 0x00010fd3319c9e50UL;
   tf->codes[10473] = 0x00010fd57b32d802UL;
   tf->codes[10474] = 0x00010fd5b5c1ddc7UL;
   tf->codes[10475] = 0x00010fd74fab062aUL;
   tf->codes[10476] = 0x00010fd78a3a0befUL;
   tf->codes[10477] = 0x00010fd839e71d3eUL;
   tf->codes[10478] = 0x00010fd8e9942e8dUL;
   tf->codes[10479] = 0x00010fd999413fdcUL;
   tf->codes[10480] = 0x00010fde66fcb905UL;
   tf->codes[10481] = 0x00010fdea18bbecaUL;
   tf->codes[10482] = 0x00010fe125b0fe41UL;
   tf->codes[10483] = 0x00010fe5f36c776aUL;
   tf->codes[10484] = 0x00010fea4c09e509UL;
   tf->codes[10485] = 0x00010ff1635b97e4UL;
   tf->codes[10486] = 0x00010ff28826b4bdUL;
   tf->codes[10487] = 0x00010ff2fd44c047UL;
   tf->codes[10488] = 0x00010ff8401e44faUL;
   tf->codes[10489] = 0x00010ff964e961d3UL;
   tf->codes[10490] = 0x00010ffbe90ea14aUL;
   tf->codes[10491] = 0x000110007c3b14aeUL;
   tf->codes[10492] = 0x0001100250b342d6UL;
   tf->codes[10493] = 0x000110028b42489bUL;
   tf->codes[10494] = 0x000110045fba76c3UL;
   tf->codes[10495] = 0x00011006e3dfb63aUL;
   tf->codes[10496] = 0x000110096804f5b1UL;
   tf->codes[10497] = 0x00011010f474b416UL;
   tf->codes[10498] = 0x00011011deb0cb2aUL;
   tf->codes[10499] = 0x00011016ac6c4453UL;
   tf->codes[10500] = 0x0001101a555ca0a3UL;
   tf->codes[10501] = 0x0001101a8feba668UL;
   tf->codes[10502] = 0x0001101dc3bdf72eUL;
   tf->codes[10503] = 0x0001101f231819ccUL;
   tf->codes[10504] = 0x0001102291797057UL;
   tf->codes[10505] = 0x000110237bb5876bUL;
   tf->codes[10506] = 0x0001102bb7d2571fUL;
   tf->codes[10507] = 0x0001103a5b93c85fUL;
   tf->codes[10508] = 0x0001103b0b40d9aeUL;
   tf->codes[10509] = 0x00011044e146d1c5UL;
   tf->codes[10510] = 0x00011051eb1f1aa2UL;
   tf->codes[10511] = 0x000110534a793d40UL;
   tf->codes[10512] = 0x000110546f445a19UL;
   tf->codes[10513] = 0x00011056f3699990UL;
   tf->codes[10514] = 0x000110590270cd7dUL;
   tf->codes[10515] = 0x0001105a273bea56UL;
   tf->codes[10516] = 0x0001105d207f3557UL;
   tf->codes[10517] = 0x0001105e7fd957f5UL;
   tf->codes[10518] = 0x0001106103fe976cUL;
   tf->codes[10519] = 0x00011061791ca2f6UL;
   tf->codes[10520] = 0x00011066816721e4UL;
   tf->codes[10521] = 0x0001106b14939548UL;
   tf->codes[10522] = 0x0001106e82f4ebd3UL;
   tf->codes[10523] = 0x000110755fb798e9UL;
   tf->codes[10524] = 0x0001107649f3affdUL;
   tf->codes[10525] = 0x000110768482b5c2UL;
   tf->codes[10526] = 0x00011076f9a0c14cUL;
   tf->codes[10527] = 0x000110794336fafeUL;
   tf->codes[10528] = 0x0001107a2d731212UL;
   tf->codes[10529] = 0x0001107a680217d7UL;
   tf->codes[10530] = 0x0001107cec27574eUL;
   tf->codes[10531] = 0x0001107f704c96c5UL;
   tf->codes[10532] = 0x00011082698fe1c6UL;
   tf->codes[10533] = 0x00011089bb709a66UL;
   tf->codes[10534] = 0x0001108f38d924deUL;
   tf->codes[10535] = 0x000110947bb2a991UL;
   tf->codes[10536] = 0x00011097af84fa57UL;
   tf->codes[10537] = 0x0001109983fd287fUL;
   tf->codes[10538] = 0x0001109a6e393f93UL;
   tf->codes[10539] = 0x000110a1106ce6e4UL;
   tf->codes[10540] = 0x000110a35a032096UL;
   tf->codes[10541] = 0x000110a4b95d4334UL;
   tf->codes[10542] = 0x000110a653466b97UL;
   tf->codes[10543] = 0x000110a827be99bfUL;
   tf->codes[10544] = 0x000110a98718bc5dUL;
   tf->codes[10545] = 0x000110aaabe3d936UL;
   tf->codes[10546] = 0x000110aae672defbUL;
   tf->codes[10547] = 0x000110b4475acb88UL;
   tf->codes[10548] = 0x000110b6cb800affUL;
   tf->codes[10549] = 0x000110b7b5bc2213UL;
   tf->codes[10550] = 0x000110b9ff525bc5UL;
   tf->codes[10551] = 0x000110bb241d789eUL;
   tf->codes[10552] = 0x000110be1d60c39fUL;
   tf->codes[10553] = 0x000110c18bc21a2aUL;
   tf->codes[10554] = 0x000110c6ce9b9eddUL;
   tf->codes[10555] = 0x000110d0a4a196f4UL;
   tf->codes[10556] = 0x000110d70c463880UL;
   tf->codes[10557] = 0x000110d78164440aUL;
   tf->codes[10558] = 0x000110e191f941e6UL;
   tf->codes[10559] = 0x000110e8342ce937UL;
   tf->codes[10560] = 0x000110e9ce16119aUL;
   tf->codes[10561] = 0x000110eba28e3fc2UL;
   tf->codes[10562] = 0x000110ebdd1d4587UL;
   tf->codes[10563] = 0x000110f035bab326UL;
   tf->codes[10564] = 0x000110f27f50ecd8UL;
   tf->codes[10565] = 0x000110f5edb24363UL;
   tf->codes[10566] = 0x000110f7c22a718bUL;
   tf->codes[10567] = 0x000110f7fcb97750UL;
   tf->codes[10568] = 0x000110f95c1399eeUL;
   tf->codes[10569] = 0x000110fb308bc816UL;
   tf->codes[10570] = 0x0001110123125e18UL;
   tf->codes[10571] = 0x000111015da163ddUL;
   tf->codes[10572] = 0x000111054120c5f2UL;
   tf->codes[10573] = 0x000111075027f9dfUL;
   tf->codes[10574] = 0x000111078ab6ffa4UL;
   tf->codes[10575] = 0x0001110a496b44e0UL;
   tf->codes[10576] = 0x000111141f713cf7UL;
   tf->codes[10577] = 0x0001111509ad540bUL;
   tf->codes[10578] = 0x00011119624ac1aaUL;
   tf->codes[10579] = 0x0001111b7151f597UL;
   tf->codes[10580] = 0x0001111edfb34c22UL;
   tf->codes[10581] = 0x0001112163d88b99UL;
   tf->codes[10582] = 0x00011129da846112UL;
   tf->codes[10583] = 0x0001113375fb5364UL;
   tf->codes[10584] = 0x0001113634af98a0UL;
   tf->codes[10585] = 0x00011137597ab579UL;
   tf->codes[10586] = 0x00011137ce98c103UL;
   tf->codes[10587] = 0x00011138f363dddcUL;
   tf->codes[10588] = 0x000111392df2e3a1UL;
   tf->codes[10589] = 0x0001113a52be007aUL;
   tf->codes[10590] = 0x0001113fd0268af2UL;
   tf->codes[10591] = 0x000111404544967cUL;
   tf->codes[10592] = 0x00011141df2dbedfUL;
   tf->codes[10593] = 0x000111433e87e17dUL;
   tf->codes[10594] = 0x00011143ee34f2ccUL;
   tf->codes[10595] = 0x00011148f67f71baUL;
   tf->codes[10596] = 0x00011149a62c8309UL;
   tf->codes[10597] = 0x0001114bb533b6f6UL;
   tf->codes[10598] = 0x0001114befc2bcbbUL;
   tf->codes[10599] = 0x0001115341a3755bUL;
   tf->codes[10600] = 0x000111537c327b20UL;
   tf->codes[10601] = 0x000111567575c621UL;
   tf->codes[10602] = 0x00011159a94816e7UL;
   tf->codes[10603] = 0x00011160c099c9c2UL;
   tf->codes[10604] = 0x00011163f46c1a88UL;
   tf->codes[10605] = 0x00011164dea8319cUL;
   tf->codes[10606] = 0x000111679d5c76d8UL;
   tf->codes[10607] = 0x00011173bcf8a8a1UL;
   tf->codes[10608] = 0x00011174a734bfb5UL;
   tf->codes[10609] = 0x00011176b63bf3a2UL;
   tf->codes[10610] = 0x00011183c0143c7fUL;
   tf->codes[10611] = 0x0001118435324809UL;
   tf->codes[10612] = 0x0001118b4c83fae4UL;
   tf->codes[10613] = 0x0001118dd0a93a5bUL;
   tf->codes[10614] = 0x000111922946a7faUL;
   tf->codes[10615] = 0x000111931382bf0eUL;
   tf->codes[10616] = 0x00011193fdbed622UL;
   tf->codes[10617] = 0x00011195d237044aUL;
   tf->codes[10618] = 0x000111b2a49bdb40UL;
   tf->codes[10619] = 0x000111b319b9e6caUL;
   tf->codes[10620] = 0x000111b4ee3214f2UL;
   tf->codes[10621] = 0x000111b8d1b17707UL;
   tf->codes[10622] = 0x000111ba6b9a9f6aUL;
   tf->codes[10623] = 0x000111bc7aa1d357UL;
   tf->codes[10624] = 0x000111c68b36d133UL;
   tf->codes[10625] = 0x000111d0d65ad4d4UL;
   tf->codes[10626] = 0x000111d8d7e89ec3UL;
   tf->codes[10627] = 0x000111da3742c161UL;
   tf->codes[10628] = 0x000111db5c0dde3aUL;
   tf->codes[10629] = 0x000111dcbb6800d8UL;
   tf->codes[10630] = 0x000111df7a1c4614UL;
   tf->codes[10631] = 0x000111e35d9ba829UL;
   tf->codes[10632] = 0x000111e3d2b9b3b3UL;
   tf->codes[10633] = 0x000111e447d7bf3dUL;
   tf->codes[10634] = 0x000111f9c85bdd93UL;
   tf->codes[10635] = 0x000111fbd7631180UL;
   tf->codes[10636] = 0x000111ff0b356246UL;
   tf->codes[10637] = 0x00011201c9e9a782UL;
   tf->codes[10638] = 0x0001120fbdfe0773UL;
   tf->codes[10639] = 0x00011215b0849d75UL;
   tf->codes[10640] = 0x00011220ab55b265UL;
   tf->codes[10641] = 0x00011222453edac8UL;
   tf->codes[10642] = 0x00011224c9641a3fUL;
   tf->codes[10643] = 0x00011225ee2f3718UL;
   tf->codes[10644] = 0x00011229971f9368UL;
   tf->codes[10645] = 0x00011229d1ae992dUL;
   tf->codes[10646] = 0x0001122a0c3d9ef2UL;
   tf->codes[10647] = 0x00011233e2439709UL;
   tf->codes[10648] = 0x000112378b33f359UL;
   tf->codes[10649] = 0x0001123875700a6dUL;
   tf->codes[10650] = 0x0001123b6eb3556eUL;
   tf->codes[10651] = 0x000112424b760284UL;
   tf->codes[10652] = 0x0001124753c08172UL;
   tf->codes[10653] = 0x0001124b71cee94cUL;
   tf->codes[10654] = 0x00011255f781f2b2UL;
   tf->codes[10655] = 0x0001125a8aae6616UL;
   tf->codes[10656] = 0x0001125fcd87eac9UL;
   tf->codes[10657] = 0x0001126042a5f653UL;
   tf->codes[10658] = 0x00011260f25307a2UL;
   tf->codes[10659] = 0x000112721a39b859UL;
   tf->codes[10660] = 0x00011273b422e0bcUL;
   tf->codes[10661] = 0x00011273eeb1e681UL;
   tf->codes[10662] = 0x00011275137d035aUL;
   tf->codes[10663] = 0x00011276ad662bbdUL;
   tf->codes[10664] = 0x0001127797a242d1UL;
   tf->codes[10665] = 0x0001127a1bc78248UL;
   tf->codes[10666] = 0x0001127b40929f21UL;
   tf->codes[10667] = 0x0001127bf03fb070UL;
   tf->codes[10668] = 0x0001127d8a28d8d3UL;
   tf->codes[10669] = 0x0001128133193523UL;
   tf->codes[10670] = 0x0001128257e451fcUL;
   tf->codes[10671] = 0x0001128342206910UL;
   tf->codes[10672] = 0x0001128b7e3d38c4UL;
   tf->codes[10673] = 0x00011296b39d5379UL;
   tf->codes[10674] = 0x00011297634a64c8UL;
   tf->codes[10675] = 0x0001129a971cb58eUL;
   tf->codes[10676] = 0x000112a1ae6e6869UL;
   tf->codes[10677] = 0x000112a67c29e192UL;
   tf->codes[10678] = 0x000112b1ec19020cUL;
   tf->codes[10679] = 0x000112bbc21efa23UL;
   tf->codes[10680] = 0x000112bbfcadffe8UL;
   tf->codes[10681] = 0x000112bc373d05adUL;
   tf->codes[10682] = 0x000112be4644399aUL;
   tf->codes[10683] = 0x000112bf6b0f5673UL;
   tf->codes[10684] = 0x000112c104f87ed6UL;
   tf->codes[10685] = 0x000112c1ef3495eaUL;
   tf->codes[10686] = 0x000112ca2b51659eUL;
   tf->codes[10687] = 0x000112ccea05aadaUL;
   tf->codes[10688] = 0x000112cf6e2aea51UL;
   tf->codes[10689] = 0x000112d5d5cf8bddUL;
   tf->codes[10690] = 0x000112d97ebfe82dUL;
   tf->codes[10691] = 0x000112e0d0a0a0cdUL;
   tf->codes[10692] = 0x000112e2dfa7d4baUL;
   tf->codes[10693] = 0x000112e3c9e3ebceUL;
   tf->codes[10694] = 0x000112e563cd1431UL;
   tf->codes[10695] = 0x000112e6fdb63c94UL;
   tf->codes[10696] = 0x000112e9474c7646UL;
   tf->codes[10697] = 0x000112eae1359ea9UL;
   tf->codes[10698] = 0x000112f0240f235cUL;
   tf->codes[10699] = 0x000112f2a83462d3UL;
   tf->codes[10700] = 0x000112f357e17422UL;
   tf->codes[10701] = 0x000112f73b60d637UL;
   tf->codes[10702] = 0x000112f7b07ee1c1UL;
   tf->codes[10703] = 0x000112fae4513287UL;
   tf->codes[10704] = 0x000113056a043bedUL;
   tf->codes[10705] = 0x0001131398a7a1a3UL;
   tf->codes[10706] = 0x000113198b2e37a5UL;
   tf->codes[10707] = 0x0001131b25176008UL;
   tf->codes[10708] = 0x0001131bd4c47157UL;
   tf->codes[10709] = 0x0001131ece07bc58UL;
   tf->codes[10710] = 0x00011322b1871e6dUL;
   tf->codes[10711] = 0x00011323d6523b46UL;
   tf->codes[10712] = 0x000113244b7046d0UL;
   tf->codes[10713] = 0x0001132744b391d1UL;
   tf->codes[10714] = 0x0001132b2832f3e6UL;
   tf->codes[10715] = 0x0001132b9d50ff70UL;
   tf->codes[10716] = 0x00011338a729484dUL;
   tf->codes[10717] = 0x0001133daf73c73bUL;
   tf->codes[10718] = 0x000113415864238bUL;
   tf->codes[10719] = 0x000113478579bf52UL;
   tf->codes[10720] = 0x00011352f568dfccUL;
   tf->codes[10721] = 0x0001135d05fddda8UL;
   tf->codes[10722] = 0x0001135f4f94175aUL;
   tf->codes[10723] = 0x00011362f88473aaUL;
   tf->codes[10724] = 0x000113721163f074UL;
   tf->codes[10725] = 0x000113783e798c3bUL;
   tf->codes[10726] = 0x0001137a880fc5edUL;
   tf->codes[10727] = 0x0001137b37bcd73cUL;
   tf->codes[10728] = 0x0001137c9716f9daUL;
   tf->codes[10729] = 0x00011382febb9b66UL;
   tf->codes[10730] = 0x0001138966603cf2UL;
   tf->codes[10731] = 0x0001138d846ea4ccUL;
   tf->codes[10732] = 0x000113949bc057a7UL;
   tf->codes[10733] = 0x0001139eac555583UL;
   tf->codes[10734] = 0x0001139ee6e45b48UL;
   tf->codes[10735] = 0x000113a16b099abfUL;
   tf->codes[10736] = 0x000113a1e027a649UL;
   tf->codes[10737] = 0x000113a3b49fd471UL;
   tf->codes[10738] = 0x000113a6ade31f72UL;
   tf->codes[10739] = 0x000113b517158aedUL;
   tf->codes[10740] = 0x000113b6eb8db915UL;
   tf->codes[10741] = 0x000113b760abc49fUL;
   tf->codes[10742] = 0x000113bd8dc16066UL;
   tf->codes[10743] = 0x000113be77fd777aUL;
   tf->codes[10744] = 0x000113c79e565e42UL;
   tf->codes[10745] = 0x000113c8137469ccUL;
   tf->codes[10746] = 0x000113c8fdb080e0UL;
   tf->codes[10747] = 0x000113cbf6f3cbe1UL;
   tf->codes[10748] = 0x000113d4a82ea71fUL;
   tf->codes[10749] = 0x000113d557dbb86eUL;
   tf->codes[10750] = 0x000113da9ab53d21UL;
   tf->codes[10751] = 0x000113db84f15435UL;
   tf->codes[10752] = 0x000113e29c430710UL;
   tf->codes[10753] = 0x000113e34bf0185fUL;
   tf->codes[10754] = 0x000113e3867f1e24UL;
   tf->codes[10755] = 0x000113ed21f61076UL;
   tf->codes[10756] = 0x000113f3899ab202UL;
   tf->codes[10757] = 0x000113f94192423fUL;
   tf->codes[10758] = 0x000113f9f13f538eUL;
   tf->codes[10759] = 0x000113fa2bce5953UL;
   tf->codes[10760] = 0x000113fb5099762cUL;
   tf->codes[10761] = 0x000113fd5fa0aa19UL;
   tf->codes[10762] = 0x00011400ce0200a4UL;
   tf->codes[10763] = 0x000114035227401bUL;
   tf->codes[10764] = 0x000114110bac9a47UL;
   tf->codes[10765] = 0x000114123077b720UL;
   tf->codes[10766] = 0x00011412a595c2aaUL;
   tf->codes[10767] = 0x00011413ca60df83UL;
   tf->codes[10768] = 0x00011416c3a42a84UL;
   tf->codes[10769] = 0x000114185d8d52e7UL;
   tf->codes[10770] = 0x00011418981c58acUL;
   tf->codes[10771] = 0x0001141b915fa3adUL;
   tf->codes[10772] = 0x0001141cb62ac086UL;
   tf->codes[10773] = 0x00011421be753f74UL;
   tf->codes[10774] = 0x000114231dcf6212UL;
   tf->codes[10775] = 0x0001142a6fb01ab2UL;
   tf->codes[10776] = 0x000114314c72c7c8UL;
   tf->codes[10777] = 0x000114339609017aUL;
   tf->codes[10778] = 0x00011436c9db5240UL;
   tf->codes[10779] = 0x00011439888f977cUL;
   tf->codes[10780] = 0x0001143b5d07c5a4UL;
   tf->codes[10781] = 0x0001143cbc61e842UL;
   tf->codes[10782] = 0x0001143da69dff56UL;
   tf->codes[10783] = 0x0001143f05f821f4UL;
   tf->codes[10784] = 0x0001143ff0343908UL;
   tf->codes[10785] = 0x00011440da70501cUL;
   tf->codes[10786] = 0x00011443d3b39b1dUL;
   tf->codes[10787] = 0x000114461d49d4cfUL;
   tf->codes[10788] = 0x00011448dbfe1a0bUL;
   tf->codes[10789] = 0x0001144a75e7426eUL;
   tf->codes[10790] = 0x0001144b9ab25f47UL;
   tf->codes[10791] = 0x00011454115e34c0UL;
   tf->codes[10792] = 0x00011454fb9a4bd4UL;
   tf->codes[10793] = 0x0001145695837437UL;
   tf->codes[10794] = 0x000114595437b973UL;
   tf->codes[10795] = 0x00011459c955c4fdUL;
   tf->codes[10796] = 0x0001146573d3eb3cUL;
   tf->codes[10797] = 0x00011469cc7158dbUL;
   tf->codes[10798] = 0x0001146af13c75b4UL;
   tf->codes[10799] = 0x00011470a93405f1UL;
   tf->codes[10800] = 0x0001147417955c7cUL;
   tf->codes[10801] = 0x00011477fb14be91UL;
   tf->codes[10802] = 0x00011478e550d5a5UL;
   tf->codes[10803] = 0x0001147ab9c903cdUL;
   tf->codes[10804] = 0x0001147af4580992UL;
   tf->codes[10805] = 0x0001147ba4051ae1UL;
   tf->codes[10806] = 0x0001147ded9b5493UL;
   tf->codes[10807] = 0x0001147e282a5a58UL;
   tf->codes[10808] = 0x0001148071c0940aUL;
   tf->codes[10809] = 0x00011480ac4f99cfUL;
   tf->codes[10810] = 0x00011481216da559UL;
   tf->codes[10811] = 0x000114820ba9bc6dUL;
   tf->codes[10812] = 0x000114824638c232UL;
   tf->codes[10813] = 0x00011482f5e5d381UL;
   tf->codes[10814] = 0x00011485b49a18bdUL;
   tf->codes[10815] = 0x00011488e86c6983UL;
   tf->codes[10816] = 0x000114957d26a6d6UL;
   tf->codes[10817] = 0x00011499d5c41475UL;
   tf->codes[10818] = 0x0001149a10531a3aUL;
   tf->codes[10819] = 0x0001149e2e618214UL;
   tf->codes[10820] = 0x0001149fc84aaa77UL;
   tf->codes[10821] = 0x000114a03d68b601UL;
   tf->codes[10822] = 0x000114a2c18df578UL;
   tf->codes[10823] = 0x000114a3713b06c7UL;
   tf->codes[10824] = 0x000114abe7e6dc40UL;
   tf->codes[10825] = 0x000114b8f1bf251dUL;
   tf->codes[10826] = 0x000114b9a16c366cUL;
   tf->codes[10827] = 0x000114bbb0736a59UL;
   tf->codes[10828] = 0x000114c1686afa96UL;
   tf->codes[10829] = 0x000114c4271f3fd2UL;
   tf->codes[10830] = 0x000114c461ae4597UL;
   tf->codes[10831] = 0x000114c6ab447f49UL;
   tf->codes[10832] = 0x000114c79580965dUL;
   tf->codes[10833] = 0x000114d29051ab4dUL;
   tf->codes[10834] = 0x000114d3056fb6d7UL;
   tf->codes[10835] = 0x000114d6e8ef18ecUL;
   tf->codes[10836] = 0x000114db06fd80c6UL;
   tf->codes[10837] = 0x000114dbf13997daUL;
   tf->codes[10838] = 0x000114df9a29f42aUL;
   tf->codes[10839] = 0x000114dfd4b8f9efUL;
   tf->codes[10840] = 0x000114e049d70579UL;
   tf->codes[10841] = 0x000114e42d56678eUL;
   tf->codes[10842] = 0x000114e8c082daf2UL;
   tf->codes[10843] = 0x000114e935a0e67cUL;
   tf->codes[10844] = 0x000114ebb9c625f3UL;
   tf->codes[10845] = 0x000114ef9d458808UL;
   tf->codes[10846] = 0x000114f0fc9faaa6UL;
   tf->codes[10847] = 0x000114f1ac4cbbf5UL;
   tf->codes[10848] = 0x000114f63f792f59UL;
   tf->codes[10849] = 0x000114f6ef2640a8UL;
   tf->codes[10850] = 0x000114feb62504d2UL;
   tf->codes[10851] = 0x000115025f156122UL;
   tf->codes[10852] = 0x000115051dc9a65eUL;
   tf->codes[10853] = 0x00011507a1eee5d5UL;
   tf->codes[10854] = 0x0001150a9b3230d6UL;
   tf->codes[10855] = 0x000115108db8c6d8UL;
   tf->codes[10856] = 0x000115155b744001UL;
   tf->codes[10857] = 0x0001151a292fb92aUL;
   tf->codes[10858] = 0x0001151b8889dbc8UL;
   tf->codes[10859] = 0x0001151e473e2104UL;
   tf->codes[10860] = 0x0001151e81cd26c9UL;
   tf->codes[10861] = 0x0001152ceaff9244UL;
   tf->codes[10862] = 0x000115322dd916f7UL;
   tf->codes[10863] = 0x0001153352a433d0UL;
   tf->codes[10864] = 0x00011536fb949020UL;
   tf->codes[10865] = 0x00011537ab41a16fUL;
   tf->codes[10866] = 0x0001153f37b15fd4UL;
   tf->codes[10867] = 0x00011542a612b65fUL;
   tf->codes[10868] = 0x00011547393f29c3UL;
   tf->codes[10869] = 0x0001154b91dc9762UL;
   tf->codes[10870] = 0x00011550d4b61c15UL;
   tf->codes[10871] = 0x000115510f4521daUL;
   tf->codes[10872] = 0x00011551f98138eeUL;
   tf->codes[10873] = 0x000115586125da7aUL;
   tf->codes[10874] = 0x0001155b1fda1fb6UL;
   tf->codes[10875] = 0x000115611260b5b8UL;
   tf->codes[10876] = 0x00011561877ec142UL;
   tf->codes[10877] = 0x00011562372bd291UL;
   tf->codes[10878] = 0x0001157324837d83UL;
   tf->codes[10879] = 0x000115740ebf9497UL;
   tf->codes[10880] = 0x000115756e19b735UL;
   tf->codes[10881] = 0x00011575e337c2bfUL;
   tf->codes[10882] = 0x00011579c6b724d4UL;
   tf->codes[10883] = 0x0001157e1f549273UL;
   tf->codes[10884] = 0x0001157f7eaeb511UL;
   tf->codes[10885] = 0x000115811897dd74UL;
   tf->codes[10886] = 0x00011583d74c22b0UL;
   tf->codes[10887] = 0x0001158571354b13UL;
   tf->codes[10888] = 0x00011585e653569dUL;
   tf->codes[10889] = 0x00011587f55a8a8aUL;
   tf->codes[10890] = 0x0001158b63bbe115UL;
   tf->codes[10891] = 0x0001159156427717UL;
   tf->codes[10892] = 0x000115957450def1UL;
   tf->codes[10893] = 0x000115970e3a0754UL;
   tf->codes[10894] = 0x00011597bde718a3UL;
   tf->codes[10895] = 0x0001159d75dea8e0UL;
   tf->codes[10896] = 0x000115a0a9b0f9a6UL;
   tf->codes[10897] = 0x000115a9d009e06eUL;
   tf->codes[10898] = 0x000115abdf11145bUL;
   tf->codes[10899] = 0x000115b246b5b5e7UL;
   tf->codes[10900] = 0x000115b3a60fd885UL;
   tf->codes[10901] = 0x000115b50569fb23UL;
   tf->codes[10902] = 0x000115b62a3517fcUL;
   tf->codes[10903] = 0x000115b6d9e2294bUL;
   tf->codes[10904] = 0x000115b7fead4624UL;
   tf->codes[10905] = 0x000115b8ae5a5773UL;
   tf->codes[10906] = 0x000115bb327f96eaUL;
   tf->codes[10907] = 0x000115c075591b9dUL;
   tf->codes[10908] = 0x000115c19a243876UL;
   tf->codes[10909] = 0x000115c5431494c6UL;
   tf->codes[10910] = 0x000115cac07d1f3eUL;
   tf->codes[10911] = 0x000115cb359b2ac8UL;
   tf->codes[10912] = 0x000115d2c20ae92dUL;
   tf->codes[10913] = 0x000115d4d1121d1aUL;
   tf->codes[10914] = 0x000115edfa8697c0UL;
   tf->codes[10915] = 0x000115f6abc172feUL;
   tf->codes[10916] = 0x000115f845aa9b61UL;
   tf->codes[10917] = 0x000115fa1a22c989UL;
   tf->codes[10918] = 0x000115fc63b9033bUL;
   tf->codes[10919] = 0x000115fd88842014UL;
   tf->codes[10920] = 0x000115fdfda22b9eUL;
   tf->codes[10921] = 0x000115ff978b5401UL;
   tf->codes[10922] = 0x00011602cb5da4c7UL;
   tf->codes[10923] = 0x0001160639befb52UL;
   tf->codes[10924] = 0x00011609a82051ddUL;
   tf->codes[10925] = 0x0001161134901042UL;
   tf->codes[10926] = 0x00011615180f7257UL;
   tf->codes[10927] = 0x00011619361dda31UL;
   tf->codes[10928] = 0x0001161ad0070294UL;
   tf->codes[10929] = 0x0001161bba4319a8UL;
   tf->codes[10930] = 0x00011620c28d9896UL;
   tf->codes[10931] = 0x0001162555ba0bfaUL;
   tf->codes[10932] = 0x00011629ae577999UL;
   tf->codes[10933] = 0x0001163349ce6bebUL;
   tf->codes[10934] = 0x00011633f97b7d3aUL;
   tf->codes[10935] = 0x00011635cdf3ab62UL;
   tf->codes[10936] = 0x000116360882b127UL;
   tf->codes[10937] = 0x000116413de2cbdcUL;
   tf->codes[10938] = 0x00011641ed8fdd2bUL;
   tf->codes[10939] = 0x00011643125afa04UL;
   tf->codes[10940] = 0x0001164471b51ca2UL;
   tf->codes[10941] = 0x000116522b3a76ceUL;
   tf->codes[10942] = 0x00011652a0588258UL;
   tf->codes[10943] = 0x00011654e9eebc0aUL;
   tf->codes[10944] = 0x00011655247dc1cfUL;
   tf->codes[10945] = 0x00011657e332070bUL;
   tf->codes[10946] = 0x0001165a67574682UL;
   tf->codes[10947] = 0x0001165d609a9183UL;
   tf->codes[10948] = 0x00011662de031bfbUL;
   tf->codes[10949] = 0x00011663189221c0UL;
   tf->codes[10950] = 0x000116698036c34cUL;
   tf->codes[10951] = 0x00011672e11eafd9UL;
   tf->codes[10952] = 0x000116731badb59eUL;
   tf->codes[10953] = 0x000116759fd2f515UL;
   tf->codes[10954] = 0x00011676ff2d17b3UL;
   tf->codes[10955] = 0x0001167739bc1d78UL;
   tf->codes[10956] = 0x00011677744b233dUL;
   tf->codes[10957] = 0x00011679f87062b4UL;
   tf->codes[10958] = 0x0001167a6d8e6e3eUL;
   tf->codes[10959] = 0x0001167c077796a1UL;
   tf->codes[10960] = 0x000116868d2aa007UL;
   tf->codes[10961] = 0x0001168d2f5e4758UL;
   tf->codes[10962] = 0x00011690d84ea3a8UL;
   tf->codes[10963] = 0x00011694813efff8UL;
   tf->codes[10964] = 0x00011694f65d0b82UL;
   tf->codes[10965] = 0x000116989f4d67d2UL;
   tf->codes[10966] = 0x0001169e91d3fdd4UL;
   tf->codes[10967] = 0x000116a91787073aUL;
   tf->codes[10968] = 0x000116b70b9b672bUL;
   tf->codes[10969] = 0x000116bb29a9cf05UL;
   tf->codes[10970] = 0x000116bb6438d4caUL;
   tf->codes[10971] = 0x000116c365c69eb9UL;
   tf->codes[10972] = 0x000116caf2365d1eUL;
   tf->codes[10973] = 0x000116d2441715beUL;
   tf->codes[10974] = 0x000116d2b9352148UL;
   tf->codes[10975] = 0x000116d2f3c4270dUL;
   tf->codes[10976] = 0x000116d6d7438922UL;
   tf->codes[10977] = 0x000116d7c17fa036UL;
   tf->codes[10978] = 0x000116e1d2149e12UL;
   tf->codes[10979] = 0x000116e3e11bd1ffUL;
   tf->codes[10980] = 0x000116e5b5940027UL;
   tf->codes[10981] = 0x000116e62ab20bb1UL;
   tf->codes[10982] = 0x000116e839b93f9eUL;
   tf->codes[10983] = 0x000116ed4203be8cUL;
   tf->codes[10984] = 0x000116f24a4e3d7aUL;
   tf->codes[10985] = 0x000116f459557167UL;
   tf->codes[10986] = 0x000116f7c7b6c7f2UL;
   tf->codes[10987] = 0x000116fb70a72442UL;
   tf->codes[10988] = 0x000116fbab362a07UL;
   tf->codes[10989] = 0x000116fdba3d5df4UL;
   tf->codes[10990] = 0x00011702fd16e2a7UL;
   tf->codes[10991] = 0x000117045c710545UL;
   tf->codes[10992] = 0x00011704d18f10cfUL;
   tf->codes[10993] = 0x00011705bbcb27e3UL;
   tf->codes[10994] = 0x000117079043560bUL;
   tf->codes[10995] = 0x0001170ac415a6d1UL;
   tf->codes[10996] = 0x0001170be8e0c3aaUL;
   tf->codes[10997] = 0x0001171215f65f71UL;
   tf->codes[10998] = 0x000117149a1b9ee8UL;
   tf->codes[10999] = 0x000117163404c74bUL;
   tf->codes[11000] = 0x00011716e3b1d89aUL;
   tf->codes[11001] = 0x0001171d4b567a26UL;
   tf->codes[11002] = 0x00011720b9b7d0b1UL;
   tf->codes[11003] = 0x0001172a1a9fbd3eUL;
   tf->codes[11004] = 0x0001172a8fbdc8c8UL;
   tf->codes[11005] = 0x0001172ee85b3667UL;
   tf->codes[11006] = 0x00011732914b92b7UL;
   tf->codes[11007] = 0x0001173306699e41UL;
   tf->codes[11008] = 0x00011741e4ba1546UL;
   tf->codes[11009] = 0x000117437ea33da9UL;
   tf->codes[11010] = 0x0001174762229fbeUL;
   tf->codes[11011] = 0x0001174a5b65eabfUL;
   tf->codes[11012] = 0x00011750135d7afcUL;
   tf->codes[11013] = 0x0001175814eb44ebUL;
   tf->codes[11014] = 0x0001175ef1adf201UL;
   tf->codes[11015] = 0x00011769ec7f06f1UL;
   tf->codes[11016] = 0x000117729db9e22fUL;
   tf->codes[11017] = 0x0001177437a30a92UL;
   tf->codes[11018] = 0x0001177472321057UL;
   tf->codes[11019] = 0x00011776bbc84a09UL;
   tf->codes[11020] = 0x0001177ad9d6b1e3UL;
   tf->codes[11021] = 0x0001177d236ceb95UL;
   tf->codes[11022] = 0x00011784754da435UL;
   tf->codes[11023] = 0x0001178b8c9f5710UL;
   tf->codes[11024] = 0x0001179269620426UL;
   tf->codes[11025] = 0x00011793c8bc26c4UL;
   tf->codes[11026] = 0x00011796c1ff71c5UL;
   tf->codes[11027] = 0x0001179771ac8314UL;
   tf->codes[11028] = 0x0001179d64331916UL;
   tf->codes[11029] = 0x000117a0980569dcUL;
   tf->codes[11030] = 0x000117a2e19ba38eUL;
   tf->codes[11031] = 0x000117a4f0a2d77bUL;
   tf->codes[11032] = 0x000117a5dadeee8fUL;
   tf->codes[11033] = 0x000117b26f992be2UL;
   tf->codes[11034] = 0x000117b3946448bbUL;
   tf->codes[11035] = 0x000117b5a36b7ca8UL;
   tf->codes[11036] = 0x000117b5ddfa826dUL;
   tf->codes[11037] = 0x000117b6c8369981UL;
   tf->codes[11038] = 0x000117b94c5bd8f8UL;
   tf->codes[11039] = 0x000117c23825b9fbUL;
   tf->codes[11040] = 0x000117c3d20ee25eUL;
   tf->codes[11041] = 0x000117c61ba51c10UL;
   tf->codes[11042] = 0x000117c7407038e9UL;
   tf->codes[11043] = 0x000117c77aff3eaeUL;
   tf->codes[11044] = 0x000117d77e1ad28cUL;
   tf->codes[11045] = 0x000117d86856e9a0UL;
   tf->codes[11046] = 0x000117d8dd74f52aUL;
   tf->codes[11047] = 0x000117d98d220679UL;
   tf->codes[11048] = 0x000117de204e79ddUL;
   tf->codes[11049] = 0x000117de956c8567UL;
   tf->codes[11050] = 0x000117df7fa89c7bUL;
   tf->codes[11051] = 0x000117ebd9d3d409UL;
   tf->codes[11052] = 0x000117f1573c5e81UL;
   tf->codes[11053] = 0x000117f7f97005d2UL;
   tf->codes[11054] = 0x000117fb2d425698UL;
   tf->codes[11055] = 0x000117ff10c1b8adUL;
   tf->codes[11056] = 0x000118092156b689UL;
   tf->codes[11057] = 0x00011812bccda8dbUL;
   tf->codes[11058] = 0x000118149145d703UL;
   tf->codes[11059] = 0x000118183a363353UL;
   tf->codes[11060] = 0x00011819d41f5bb6UL;
   tf->codes[11061] = 0x0001181a0eae617bUL;
   tf->codes[11062] = 0x0001181ba89789deUL;
   tf->codes[11063] = 0x0001181e2cbcc955UL;
   tf->codes[11064] = 0x00011825b92c87baUL;
   tf->codes[11065] = 0x00011829621ce40aUL;
   tf->codes[11066] = 0x00011830ee8ca26fUL;
   tf->codes[11067] = 0x00011832fd93d65cUL;
   tf->codes[11068] = 0x000118371ba23e36UL;
   tf->codes[11069] = 0x00011837563143fbUL;
   tf->codes[11070] = 0x00011838406d5b0fUL;
   tf->codes[11071] = 0x000118450fb69e27UL;
   tf->codes[11072] = 0x0001184bec794b3dUL;
   tf->codes[11073] = 0x00011851a470db7aUL;
   tf->codes[11074] = 0x000118533e5a03ddUL;
   tf->codes[11075] = 0x0001185378e909a2UL;
   tf->codes[11076] = 0x00011855c27f4354UL;
   tf->codes[11077] = 0x0001185a55abb6b8UL;
   tf->codes[11078] = 0x00011861e21b751dUL;
   tf->codes[11079] = 0x0001186933fc2dbdUL;
   tf->codes[11080] = 0x0001186fd62fd50eUL;
   tf->codes[11081] = 0x0001187344912b99UL;
   tf->codes[11082] = 0x000118779d2e9938UL;
   tf->codes[11083] = 0x0001187971a6c760UL;
   tf->codes[11084] = 0x0001187bbb3d0112UL;
   tf->codes[11085] = 0x0001188b0eab83a1UL;
   tf->codes[11086] = 0x0001189225fd367cUL;
   tf->codes[11087] = 0x000118929b1b4206UL;
   tf->codes[11088] = 0x0001189c36923458UL;
   tf->codes[11089] = 0x0001189dd07b5cbbUL;
   tf->codes[11090] = 0x000118a0c9bea7bcUL;
   tf->codes[11091] = 0x000118a3fd90f882UL;
   tf->codes[11092] = 0x000118b5d524ba88UL;
   tf->codes[11093] = 0x000118b9f3332262UL;
   tf->codes[11094] = 0x000118badd6f3976UL;
   tf->codes[11095] = 0x000118bb528d4500UL;
   tf->codes[11096] = 0x000118bb8d1c4ac5UL;
   tf->codes[11097] = 0x000118c14513db02UL;
   tf->codes[11098] = 0x000118c9bbbfb07bUL;
   tf->codes[11099] = 0x000118ca6b6cc1caUL;
   tf->codes[11100] = 0x000118cb9037dea3UL;
   tf->codes[11101] = 0x000118cefe99352eUL;
   tf->codes[11102] = 0x000118d5663dd6baUL;
   tf->codes[11103] = 0x000118d615eae809UL;
   tf->codes[11104] = 0x000118dae3a66132UL;
   tf->codes[11105] = 0x000118db1e3566f7UL;
   tf->codes[11106] = 0x000118dd67cba0a9UL;
   tf->codes[11107] = 0x000118e2358719d2UL;
   tf->codes[11108] = 0x000118e5de777622UL;
   tf->codes[11109] = 0x000118e7ed7eaa0fUL;
   tf->codes[11110] = 0x000118ea3714e3c1UL;
   tf->codes[11111] = 0x000118f0642a7f88UL;
   tf->codes[11112] = 0x000118f322dec4c4UL;
   tf->codes[11113] = 0x000118f4f756f2ecUL;
   tf->codes[11114] = 0x000118f56c74fe76UL;
   tf->codes[11115] = 0x000118fa74bf7d64UL;
   tf->codes[11116] = 0x000118faaf4e8329UL;
   tf->codes[11117] = 0x000118fff22807dcUL;
   tf->codes[11118] = 0x00011905e4ae9ddeUL;
   tf->codes[11119] = 0x000119074408c07cUL;
   tf->codes[11120] = 0x00011908a362e31aUL;
   tf->codes[11121] = 0x000119098d9efa2eUL;
   tf->codes[11122] = 0x0001190bd73533e0UL;
   tf->codes[11123] = 0x0001191363a4f245UL;
   tf->codes[11124] = 0x00011919cb4993d1UL;
   tf->codes[11125] = 0x00011933defa258bUL;
   tf->codes[11126] = 0x000119348ea736daUL;
   tf->codes[11127] = 0x000119369dae6ac7UL;
   tf->codes[11128] = 0x0001193d3fe21218UL;
   tf->codes[11129] = 0x0001193f145a4040UL;
   tf->codes[11130] = 0x000119412361742dUL;
   tf->codes[11131] = 0x000119420d9d8b41UL;
   tf->codes[11132] = 0x0001194875422ccdUL;
   tf->codes[11133] = 0x00011966a7012661UL;
   tf->codes[11134] = 0x0001196a4ff182b1UL;
   tf->codes[11135] = 0x0001196b3a2d99c5UL;
   tf->codes[11136] = 0x00011970b796243dUL;
   tf->codes[11137] = 0x00011973eb687503UL;
   tf->codes[11138] = 0x00011975bfe0a32bUL;
   tf->codes[11139] = 0x00011976aa1cba3fUL;
   tf->codes[11140] = 0x00011976e4abc004UL;
   tf->codes[11141] = 0x000119771f3ac5c9UL;
   tf->codes[11142] = 0x0001197759c9cb8eUL;
   tf->codes[11143] = 0x0001197a8d9c1c54UL;
   tf->codes[11144] = 0x0001197ac82b2219UL;
   tf->codes[11145] = 0x0001197b02ba27deUL;
   tf->codes[11146] = 0x0001197ee63989f3UL;
   tf->codes[11147] = 0x0001197f95e69b42UL;
   tf->codes[11148] = 0x0001198797746531UL;
   tf->codes[11149] = 0x00011989a67b991eUL;
   tf->codes[11150] = 0x0001199341f28b70UL;
   tf->codes[11151] = 0x00011993f19f9cbfUL;
   tf->codes[11152] = 0x000119942c2ea284UL;
   tf->codes[11153] = 0x0001199a59443e4bUL;
   tf->codes[11154] = 0x0001199cdd697dc2UL;
   tf->codes[11155] = 0x0001199e3cc3a060UL;
   tf->codes[11156] = 0x000119a295610dffUL;
   tf->codes[11157] = 0x000119a2cff013c4UL;
   tf->codes[11158] = 0x000119a30a7f1989UL;
   tf->codes[11159] = 0x000119a469d93c27UL;
   tf->codes[11160] = 0x000119aad17dddb3UL;
   tf->codes[11161] = 0x000119b173b18504UL;
   tf->codes[11162] = 0x000119b72ba91541UL;
   tf->codes[11163] = 0x000119b766381b06UL;
   tf->codes[11164] = 0x000119ba9a0a6bccUL;
   tf->codes[11165] = 0x000119bc33f3942fUL;
   tf->codes[11166] = 0x000119bd934db6cdUL;
   tf->codes[11167] = 0x000119beb818d3a6UL;
   tf->codes[11168] = 0x000119c3c0635294UL;
   tf->codes[11169] = 0x000119c55a4c7af7UL;
   tf->codes[11170] = 0x000119cd5bda44e6UL;
   tf->codes[11171] = 0x000119d731e03cfdUL;
   tf->codes[11172] = 0x000119ee4c4d83b6UL;
   tf->codes[11173] = 0x000119f2df79f71aUL;
   tf->codes[11174] = 0x000119f3c9b60e2eUL;
   tf->codes[11175] = 0x000119f6886a536aUL;
   tf->codes[11176] = 0x000119f897718757UL;
   tf->codes[11177] = 0x000119fbcb43d81dUL;
   tf->codes[11178] = 0x00011a1654127561UL;
   tf->codes[11179] = 0x00011a1bd17affd9UL;
   tf->codes[11180] = 0x00011a2189729016UL;
   tf->codes[11181] = 0x00011a261c9f037aUL;
   tf->codes[11182] = 0x00011a27f11731a2UL;
   tf->codes[11183] = 0x00011a38de6edc94UL;
   tf->codes[11184] = 0x00011a444e5dfd0eUL;
   tf->codes[11185] = 0x00011a53673d79d8UL;
   tf->codes[11186] = 0x00011a53a1cc7f9dUL;
   tf->codes[11187] = 0x00011a553bb5a800UL;
   tf->codes[11188] = 0x00011a55eb62b94fUL;
   tf->codes[11189] = 0x00011a57854be1b2UL;
   tf->codes[11190] = 0x00011a5ffbf7b72bUL;
   tf->codes[11191] = 0x00011a6195e0df8eUL;
   tf->codes[11192] = 0x00011a61d06fe553UL;
   tf->codes[11193] = 0x00011a62801cf6a2UL;
   tf->codes[11194] = 0x00011a62f53b022cUL;
   tf->codes[11195] = 0x00011a66639c58b7UL;
   tf->codes[11196] = 0x00011a68e7c1982eUL;
   tf->codes[11197] = 0x00011a6abc39c656UL;
   tf->codes[11198] = 0x00011a741d21b2e3UL;
   tf->codes[11199] = 0x00011a757c7bd581UL;
   tf->codes[11200] = 0x00011a771664fde4UL;
   tf->codes[11201] = 0x00011a7db898a535UL;
   tf->codes[11202] = 0x00011a83ab1f3b37UL;
   tf->codes[11203] = 0x00011a8803bca8d6UL;
   tf->codes[11204] = 0x00011a892887c5afUL;
   tf->codes[11205] = 0x00011a907a687e4fUL;
   tf->codes[11206] = 0x00011a9841674279UL;
   tf->codes[11207] = 0x00011a9d49b1c167UL;
   tf->codes[11208] = 0x00011aa4d6217fccUL;
   tf->codes[11209] = 0x00011aa6700aa82fUL;
   tf->codes[11210] = 0x00011aaac8a815ceUL;
   tf->codes[11211] = 0x00011ab513cc196fUL;
   tf->codes[11212] = 0x00011aba1c16985dUL;
   tf->codes[11213] = 0x00011abd8a77eee8UL;
   tf->codes[11214] = 0x00011ac0492c3424UL;
   tf->codes[11215] = 0x00011acbf3aa5a63UL;
   tf->codes[11216] = 0x00011acc2e396028UL;
   tf->codes[11217] = 0x00011ad6795d63c9UL;
   tf->codes[11218] = 0x00011aed593ba4bdUL;
   tf->codes[11219] = 0x00011aefdd60e434UL;
   tf->codes[11220] = 0x00011af2618623abUL;
   tf->codes[11221] = 0x00011afa9da2f35fUL;
   tf->codes[11222] = 0x00011afad831f924UL;
   tf->codes[11223] = 0x00011b02d9bfc313UL;
   tf->codes[11224] = 0x00011b064821199eUL;
   tf->codes[11225] = 0x00011b076cec3677UL;
   tf->codes[11226] = 0x00011b094164649fUL;
   tf->codes[11227] = 0x00011b1351f9627bUL;
   tf->codes[11228] = 0x00011b138c886840UL;
   tf->codes[11229] = 0x00011b15d61ea1f2UL;
   tf->codes[11230] = 0x00011b173578c490UL;
   tf->codes[11231] = 0x00011b185a43e169UL;
   tf->codes[11232] = 0x00011b1b18f826a5UL;
   tf->codes[11233] = 0x00011b1ec1e882f5UL;
   tf->codes[11234] = 0x00011b1fac249a09UL;
   tf->codes[11235] = 0x00011b238fa3fc1eUL;
   tf->codes[11236] = 0x00011b35dc55c9aeUL;
   tf->codes[11237] = 0x00011b3910281a74UL;
   tf->codes[11238] = 0x00011b3f77ccbc00UL;
   tf->codes[11239] = 0x00011b4111b5e463UL;
   tf->codes[11240] = 0x00011b4863969d03UL;
   tf->codes[11241] = 0x00011b4aad2cd6b5UL;
   tf->codes[11242] = 0x00011b56923a02b9UL;
   tf->codes[11243] = 0x00011b5741e71408UL;
   tf->codes[11244] = 0x00011b577c7619cdUL;
   tf->codes[11245] = 0x00011b5f4374ddf7UL;
   tf->codes[11246] = 0x00011b6411305720UL;
   tf->codes[11247] = 0x00011b6aedf30436UL;
   tf->codes[11248] = 0x00011b748969f688UL;
   tf->codes[11249] = 0x00011b765de224b0UL;
   tf->codes[11250] = 0x00011b786ce9589dUL;
   tf->codes[11251] = 0x00011b79cc437b3bUL;
   tf->codes[11252] = 0x00011b82f29c6203UL;
   tf->codes[11253] = 0x00011b8a447d1aa3UL;
   tf->codes[11254] = 0x00011b8b6948377cUL;
   tf->codes[11255] = 0x00011b928099ea57UL;
   tf->codes[11256] = 0x00011b933046fba6UL;
   tf->codes[11257] = 0x00011b93a5650730UL;
   tf->codes[11258] = 0x00011b9af745bfd0UL;
   tf->codes[11259] = 0x00011ba199796721UL;
   tf->codes[11260] = 0x00011ba507dabdacUL;
   tf->codes[11261] = 0x00011ba6dc52ebd4UL;
   tf->codes[11262] = 0x00011ba78bfffd23UL;
   tf->codes[11263] = 0x00011bb66a507428UL;
   tf->codes[11264] = 0x00011bb719fd8577UL;
   tf->codes[11265] = 0x00011bba4dcfd63dUL;
   tf->codes[11266] = 0x00011bbbad29f8dbUL;
   tf->codes[11267] = 0x00011bbbe7b8fea0UL;
   tf->codes[11268] = 0x00011bbfcb3860b5UL;
   tf->codes[11269] = 0x00011bc24f5da02cUL;
   tf->codes[11270] = 0x00011bc757a81f1aUL;
   tf->codes[11271] = 0x00011bd635f8961fUL;
   tf->codes[11272] = 0x00011bd8ba1dd596UL;
   tf->codes[11273] = 0x00011bd8f4acdb5bUL;
   tf->codes[11274] = 0x00011bd969cae6e5UL;
   tf->codes[11275] = 0x00011bdc9d9d37abUL;
   tf->codes[11276] = 0x00011be0bbab9f85UL;
   tf->codes[11277] = 0x00011be25594c7e8UL;
   tf->codes[11278] = 0x00011be42a0cf610UL;
   tf->codes[11279] = 0x00011bf7d618e63eUL;
   tf->codes[11280] = 0x00011bf8c054fd52UL;
   tf->codes[11281] = 0x00011bfa1faf1ff0UL;
   tf->codes[11282] = 0x00011bff6288a4a3UL;
   tf->codes[11283] = 0x00011c00c1e2c741UL;
   tf->codes[11284] = 0x00011c051a8034e0UL;
   tf->codes[11285] = 0x00011c08c3709130UL;
   tf->codes[11286] = 0x00011c146deeb76fUL;
   tf->codes[11287] = 0x00011c14a87dbd34UL;
   tf->codes[11288] = 0x00011c1ad59358fbUL;
   tf->codes[11289] = 0x00011c1d1f2992adUL;
   tf->codes[11290] = 0x00011c1e7e83b54bUL;
   tf->codes[11291] = 0x00011c222774119bUL;
   tf->codes[11292] = 0x00011c24710a4b4dUL;
   tf->codes[11293] = 0x00011c24e62856d7UL;
   tf->codes[11294] = 0x00011c2bc2eb03edUL;
   tf->codes[11295] = 0x00011c3aa13b7af2UL;
   tf->codes[11296] = 0x00011c3bc60697cbUL;
   tf->codes[11297] = 0x00011c3e4a2bd742UL;
   tf->codes[11298] = 0x00011c4a69c8090bUL;
   tf->codes[11299] = 0x00011c552a0a1836UL;
   tf->codes[11300] = 0x00011c63933c83b1UL;
   tf->codes[11301] = 0x00011c70d7a3d253UL;
   tf->codes[11302] = 0x00011c840e91b6f7UL;
   tf->codes[11303] = 0x00011c861d98eae4UL;
   tf->codes[11304] = 0x00011c89c6894734UL;
   tf->codes[11305] = 0x00011c8a76365883UL;
   tf->codes[11306] = 0x00011c8ff39ee2fbUL;
   tf->codes[11307] = 0x00011c9b28fefdb0UL;
   tf->codes[11308] = 0x00011c9e224248b1UL;
   tf->codes[11309] = 0x00011ca0a6678828UL;
   tf->codes[11310] = 0x00011ca7832a353eUL;
   tf->codes[11311] = 0x00011caa41de7a7aUL;
   tf->codes[11312] = 0x00011cab66a99753UL;
   tf->codes[11313] = 0x00011caff9d60ab7UL;
   tf->codes[11314] = 0x00011cb32da85b7dUL;
   tf->codes[11315] = 0x00011cb5022089a5UL;
   tf->codes[11316] = 0x00011cb6d698b7cdUL;
   tf->codes[11317] = 0x00011cbb69c52b31UL;
   tf->codes[11318] = 0x00011cbdedea6aa8UL;
   tf->codes[11319] = 0x00011cc3e07100aaUL;
   tf->codes[11320] = 0x00011cc789615cfaUL;
   tf->codes[11321] = 0x00011cc7c3f062bfUL;
   tf->codes[11322] = 0x00011cd199f65ad6UL;
   tf->codes[11323] = 0x00011cd333df8339UL;
   tf->codes[11324] = 0x00011cd57d75bcebUL;
   tf->codes[11325] = 0x00011cd6a240d9c4UL;
   tf->codes[11326] = 0x00011cd7c70bf69dUL;
   tf->codes[11327] = 0x00011cd8019afc62UL;
   tf->codes[11328] = 0x00011cd83c2a0227UL;
   tf->codes[11329] = 0x00011cd8ebd71376UL;
   tf->codes[11330] = 0x00011ce3ac1922a1UL;
   tf->codes[11331] = 0x00011ce3e6a82866UL;
   tf->codes[11332] = 0x00011ce421372e2bUL;
   tf->codes[11333] = 0x00011cec5d53fddfUL;
   tf->codes[11334] = 0x00011cf0f0807143UL;
   tf->codes[11335] = 0x00011d054c3972c0UL;
   tf->codes[11336] = 0x00011d08457cbdc1UL;
   tf->codes[11337] = 0x00011d08800bc386UL;
   tf->codes[11338] = 0x00011d0a5483f1aeUL;
   tf->codes[11339] = 0x00011d0fd1ec7c26UL;
   tf->codes[11340] = 0x00011d1639911db2UL;
   tf->codes[11341] = 0x00011d18bdb65d29UL;
   tf->codes[11342] = 0x00011d18f84562eeUL;
   tf->codes[11343] = 0x00011d19e2817a02UL;
   tf->codes[11344] = 0x00011d1a922e8b51UL;
   tf->codes[11345] = 0x00011d22ce4b5b05UL;
   tf->codes[11346] = 0x00011d2517e194b7UL;
   tf->codes[11347] = 0x00011d2552709a7cUL;
   tf->codes[11348] = 0x00011d33f6320bbcUL;
   tf->codes[11349] = 0x00011d346b501746UL;
   tf->codes[11350] = 0x00011d3eb6741ae7UL;
   tf->codes[11351] = 0x00011d4349a08e4bUL;
   tf->codes[11352] = 0x00011d44e389b6aeUL;
   tf->codes[11353] = 0x00011d50c896e2b2UL;
   tf->codes[11354] = 0x00011d555bc35616UL;
   tf->codes[11355] = 0x00011d59eeefc97aUL;
   tf->codes[11356] = 0x00011d5bc367f7a2UL;
   tf->codes[11357] = 0x00011d5c731508f1UL;
   tf->codes[11358] = 0x00011d5dd26f2b8fUL;
   tf->codes[11359] = 0x00011d66491b0108UL;
   tf->codes[11360] = 0x00011d676de61de1UL;
   tf->codes[11361] = 0x00011d6bc6838b80UL;
   tf->codes[11362] = 0x00011d722e282d0cUL;
   tf->codes[11363] = 0x00011d7561fa7dd2UL;
   tf->codes[11364] = 0x00011d7adf63084aUL;
   tf->codes[11365] = 0x00011d7dd8a6534bUL;
   tf->codes[11366] = 0x00011d7f380075e9UL;
   tf->codes[11367] = 0x00011d87741d459dUL;
   tf->codes[11368] = 0x00011d926eee5a8dUL;
   tf->codes[11369] = 0x00011d9393b97766UL;
   tf->codes[11370] = 0x00011d968cfcc267UL;
   tf->codes[11371] = 0x00011d9b202935cbUL;
   tf->codes[11372] = 0x00011da7ef7278e3UL;
   tf->codes[11373] = 0x00011dab9862d533UL;
   tf->codes[11374] = 0x00011db4842cb636UL;
   tf->codes[11375] = 0x00011dbcc04985eaUL;
   tf->codes[11376] = 0x00011dbf09dfbf9cUL;
   tf->codes[11377] = 0x00011dbff41bd6b0UL;
   tf->codes[11378] = 0x00011dcb640af72aUL;
   tf->codes[11379] = 0x00011dd8a87245ccUL;
   tf->codes[11380] = 0x00011dd91d905156UL;
   tf->codes[11381] = 0x00011ddab77979b9UL;
   tf->codes[11382] = 0x00011dde6069d609UL;
   tf->codes[11383] = 0x00011ddf8534f2e2UL;
   tf->codes[11384] = 0x00011de2b90743a8UL;
   tf->codes[11385] = 0x00011de4c80e7795UL;
   tf->codes[11386] = 0x00011df2f6b1dd4bUL;
   tf->codes[11387] = 0x00011df6da313f60UL;
   tf->codes[11388] = 0x00011dfaf83fa73aUL;
   tf->codes[11389] = 0x00011e06682ec7b4UL;
   tf->codes[11390] = 0x00011e06a2bdcd79UL;
   tf->codes[11391] = 0x00011e07c788ea52UL;
   tf->codes[11392] = 0x00011e083ca6f5dcUL;
   tf->codes[11393] = 0x00011e0afb5b3b18UL;
   tf->codes[11394] = 0x00011e1630bb55cdUL;
   tf->codes[11395] = 0x00011e1b7394da80UL;
   tf->codes[11396] = 0x00011e1dbd2b1432UL;
   tf->codes[11397] = 0x00011e21db397c0cUL;
   tf->codes[11398] = 0x00011e245f5ebb83UL;
   tf->codes[11399] = 0x00011e24d47cc70dUL;
   tf->codes[11400] = 0x00011e287d6d235dUL;
   tf->codes[11401] = 0x00011e29a2384036UL;
   tf->codes[11402] = 0x00011e333daf3288UL;
   tf->codes[11403] = 0x00011e37212e949dUL;
   tf->codes[11404] = 0x00011e393035c88aUL;
   tf->codes[11405] = 0x00011e3dfdf141b3UL;
   tf->codes[11406] = 0x00011e3ee82d58c7UL;
   tf->codes[11407] = 0x00011e41e170a3c8UL;
   tf->codes[11408] = 0x00011e421bffa98dUL;
   tf->codes[11409] = 0x00011e43b5e8d1f0UL;
   tf->codes[11410] = 0x00011e4a581c7941UL;
   tf->codes[11411] = 0x00011e5259aa4330UL;
   tf->codes[11412] = 0x00011e572765bc59UL;
   tf->codes[11413] = 0x00011e5eee648083UL;
   tf->codes[11414] = 0x00011e5f9e1191d2UL;
   tf->codes[11415] = 0x00011e6605b6335eUL;
   tf->codes[11416] = 0x00011e6889db72d5UL;
   tf->codes[11417] = 0x00011e69741789e9UL;
   tf->codes[11418] = 0x00011e6b488fb811UL;
   tf->codes[11419] = 0x00011e6c32cbcf25UL;
   tf->codes[11420] = 0x00011e74e406aa63UL;
   tf->codes[11421] = 0x00011e755924b5edUL;
   tf->codes[11422] = 0x00011e7593b3bbb2UL;
   tf->codes[11423] = 0x00011e767defd2c6UL;
   tf->codes[11424] = 0x00011e76b87ed88bUL;
   tf->codes[11425] = 0x00011e7817d8fb29UL;
   tf->codes[11426] = 0x00011e7ad68d4065UL;
   tf->codes[11427] = 0x00011e87e0658942UL;
   tf->codes[11428] = 0x00011e88558394ccUL;
   tf->codes[11429] = 0x00011e9106be700aUL;
   tf->codes[11430] = 0x00011e935054a9bcUL;
   tf->codes[11431] = 0x00011e96beb60047UL;
   tf->codes[11432] = 0x00011e97a8f2175bUL;
   tf->codes[11433] = 0x00011e9aa235625cUL;
   tf->codes[11434] = 0x00011e9d265aa1d3UL;
   tf->codes[11435] = 0x00011ea109da03e8UL;
   tf->codes[11436] = 0x00011ea43dac54aeUL;
   tf->codes[11437] = 0x00011ea562777187UL;
   tf->codes[11438] = 0x00011eb3911ad73dUL;
   tf->codes[11439] = 0x00011eba334e7e8eUL;
   tf->codes[11440] = 0x00011ec2e48959ccUL;
   tf->codes[11441] = 0x00011ecaab881df6UL;
   tf->codes[11442] = 0x00011ed5a65932e6UL;
   tf->codes[11443] = 0x00011ed740425b49UL;
   tf->codes[11444] = 0x00011ed8650d7822UL;
   tf->codes[11445] = 0x00011edf41d02538UL;
   tf->codes[11446] = 0x00011ee39a6d92d7UL;
   tf->codes[11447] = 0x00011ee53456bb3aUL;
   tf->codes[11448] = 0x00011ee6ce3fe39dUL;
   tf->codes[11449] = 0x00011eeb616c5701UL;
   tf->codes[11450] = 0x00011ef3286b1b2bUL;
   tf->codes[11451] = 0x00011ef5ac905aa2UL;
   tf->codes[11452] = 0x00011effbd25587eUL;
   tf->codes[11453] = 0x00011f132ea242e7UL;
   tf->codes[11454] = 0x00011f1e297357d7UL;
   tf->codes[11455] = 0x00011f1ffdeb85ffUL;
   tf->codes[11456] = 0x00011f224781bfb1UL;
   tf->codes[11457] = 0x00011f30010719ddUL;
   tf->codes[11458] = 0x00011f33a9f7762dUL;
   tf->codes[11459] = 0x00011f357e6fa455UL;
   tf->codes[11460] = 0x00011f3c95c15730UL;
   tf->codes[11461] = 0x00011f4ac464bce6UL;
   tf->codes[11462] = 0x00011f57591efa39UL;
   tf->codes[11463] = 0x00011f5a5262453aUL;
   tf->codes[11464] = 0x00011f6512a45465UL;
   tf->codes[11465] = 0x00011f675c3a8e17UL;
   tf->codes[11466] = 0x00011f746612d6f4UL;
   tf->codes[11467] = 0x00011f7849923909UL;
   tf->codes[11468] = 0x00011f7dc6fac381UL;
   tf->codes[11469] = 0x00011f7eebc5e05aUL;
   tf->codes[11470] = 0x00011f83b9815983UL;
   tf->codes[11471] = 0x00011f83f4105f48UL;
   tf->codes[11472] = 0x00011f88c1cbd871UL;
   tf->codes[11473] = 0x00011f8d1a694610UL;
   tf->codes[11474] = 0x00011f90fde8a825UL;
   tf->codes[11475] = 0x00011f91ad95b974UL;
   tf->codes[11476] = 0x00011f95568615c4UL;
   tf->codes[11477] = 0x00011f95cba4214eUL;
   tf->codes[11478] = 0x00011f98ff767214UL;
   tf->codes[11479] = 0x00011f993a0577d9UL;
   tf->codes[11480] = 0x00011f9974947d9eUL;
   tf->codes[11481] = 0x00011f9bbe2ab750UL;
   tf->codes[11482] = 0x00011f9d5813dfb3UL;
   tf->codes[11483] = 0x00011fa4e4839e18UL;
   tf->codes[11484] = 0x00011faa61ec2890UL;
   tf->codes[11485] = 0x00011fb97acba55aUL;
   tf->codes[11486] = 0x00011fbada25c7f8UL;
   tf->codes[11487] = 0x00011fbb4f43d382UL;
   tf->codes[11488] = 0x00011fc0921d5835UL;
   tf->codes[11489] = 0x00011fc4759cba4aUL;
   tf->codes[11490] = 0x00011fc4eabac5d4UL;
   tf->codes[11491] = 0x00011fc64a14e872UL;
   tf->codes[11492] = 0x00011fc9b8763efdUL;
   tf->codes[11493] = 0x00011fd0cfc7f1d8UL;
   tf->codes[11494] = 0x00011fd4b34753edUL;
   tf->codes[11495] = 0x00011fd59d836b01UL;
   tf->codes[11496] = 0x00011fda30afde65UL;
   tf->codes[11497] = 0x00011fde894d4c04UL;
   tf->codes[11498] = 0x00011fe05dc57a2cUL;
   tf->codes[11499] = 0x00011fe1f7aea28fUL;
   tf->codes[11500] = 0x00011fe7ea353891UL;
   tf->codes[11501] = 0x00011fe9bead66b9UL;
   tf->codes[11502] = 0x00011ffe1a666836UL;
   tf->codes[11503] = 0x00012006cba14374UL;
   tf->codes[11504] = 0x0001200a3a0299ffUL;
   tf->codes[11505] = 0x0001200f424d18edUL;
   tf->codes[11506] = 0x00012016cebcd752UL;
   tf->codes[11507] = 0x0001201dab7f8468UL;
   tf->codes[11508] = 0x00012021546fe0b8UL;
   tf->codes[11509] = 0x00012032f1749cf9UL;
   tf->codes[11510] = 0x000120374a120a98UL;
   tf->codes[11511] = 0x0001203f862eda4cUL;
   tf->codes[11512] = 0x000120453e266a89UL;
   tf->codes[11513] = 0x000120462862819dUL;
   tf->codes[11514] = 0x00012046d80f92ecUL;
   tf->codes[11515] = 0x00012047c24baa00UL;
   tf->codes[11516] = 0x0001205be375a5b8UL;
   tf->codes[11517] = 0x0001206160de3030UL;
   tf->codes[11518] = 0x00012066a3b7b4e3UL;
   tf->codes[11519] = 0x000120678df3cbf7UL;
   tf->codes[11520] = 0x00012082c66f7a8aUL;
   tf->codes[11521] = 0x000120871f0ce829UL;
   tf->codes[11522] = 0x000120892e141c16UL;
   tf->codes[11523] = 0x00012094d8924255UL;
   tf->codes[11524] = 0x000120954db04ddfUL;
   tf->codes[11525] = 0x00012095fd5d5f2eUL;
   tf->codes[11526] = 0x0001209a55facccdUL;
   tf->codes[11527] = 0x0001209a9089d292UL;
   tf->codes[11528] = 0x0001209c2a72faf5UL;
   tf->codes[11529] = 0x0001209d89cd1d93UL;
   tf->codes[11530] = 0x000120a1e26a8b32UL;
   tf->codes[11531] = 0x000120a3f171bf1fUL;
   tf->codes[11532] = 0x000120a58b5ae782UL;
   tf->codes[11533] = 0x000120a6b026045bUL;
   tf->codes[11534] = 0x000120b553e7759bUL;
   tf->codes[11535] = 0x000120b6039486eaUL;
   tf->codes[11536] = 0x000120b7d80cb512UL;
   tf->codes[11537] = 0x000120ba5c31f489UL;
   tf->codes[11538] = 0x000120bb0bdf05d8UL;
   tf->codes[11539] = 0x000120bc30aa22b1UL;
   tf->codes[11540] = 0x000120bce0573400UL;
   tf->codes[11541] = 0x000120bf9f0b793cUL;
   tf->codes[11542] = 0x000120c0fe659bdaUL;
   tf->codes[11543] = 0x000120c3828adb51UL;
   tf->codes[11544] = 0x000120c67bce2652UL;
   tf->codes[11545] = 0x000120c8fff365c9UL;
   tf->codes[11546] = 0x000120ca5f4d8867UL;
   tf->codes[11547] = 0x000120d2d5f95de0UL;
   tf->codes[11548] = 0x000120d5cf3ca8e1UL;
   tf->codes[11549] = 0x000120d6f407c5baUL;
   tf->codes[11550] = 0x000120dad78727cfUL;
   tf->codes[11551] = 0x000120de45e87e5aUL;
   tf->codes[11552] = 0x000120dfdfd1a6bdUL;
   tf->codes[11553] = 0x000120e4e81c25abUL;
   tf->codes[11554] = 0x000120e97b48990fUL;
   tf->codes[11555] = 0x000120edd3e606aeUL;
   tf->codes[11556] = 0x000120f7e47b048aUL;
   tf->codes[11557] = 0x000120f97e642cedUL;
   tf->codes[11558] = 0x000120fd61e38f02UL;
   tf->codes[11559] = 0x00012101ba80fca1UL;
   tf->codes[11560] = 0x000121022f9f082bUL;
   tf->codes[11561] = 0x0001211ec774d95cUL;
   tf->codes[11562] = 0x0001212778afb49aUL;
   tf->codes[11563] = 0x0001212e90016775UL;
   tf->codes[11564] = 0x00012139c561822aUL;
   tf->codes[11565] = 0x0001213cf933d2f0UL;
   tf->codes[11566] = 0x00012146cf39cb07UL;
   tf->codes[11567] = 0x000121520499e5bcUL;
   tf->codes[11568] = 0x0001215329650295UL;
   tf->codes[11569] = 0x0001215363f4085aUL;
   tf->codes[11570] = 0x00012156d2555ee5UL;
   tf->codes[11571] = 0x0001215747736a6fUL;
   tf->codes[11572] = 0x0001215d74890636UL;
   tf->codes[11573] = 0x0001215e24361785UL;
   tf->codes[11574] = 0x0001215e9954230fUL;
   tf->codes[11575] = 0x0001215ed3e328d4UL;
   tf->codes[11576] = 0x00012164c669bed6UL;
   tf->codes[11577] = 0x000121686f5a1b26UL;
   tf->codes[11578] = 0x000121792222c053UL;
   tf->codes[11579] = 0x0001217b6bb8fa05UL;
   tf->codes[11580] = 0x000121803974732eUL;
   tf->codes[11581] = 0x0001218abf277c94UL;
   tf->codes[11582] = 0x00012194200f6921UL;
   tf->codes[11583] = 0x000121999d77f399UL;
   tf->codes[11584] = 0x0001219cd14a445fUL;
   tf->codes[11585] = 0x0001219f556f83d6UL;
   tf->codes[11586] = 0x000121a129e7b1feUL;
   tf->codes[11587] = 0x000121a3e89bf73aUL;
   tf->codes[11588] = 0x000121af588b17b4UL;
   tf->codes[11589] = 0x000121b0b7e53a52UL;
   tf->codes[11590] = 0x000121b6354dc4caUL;
   tf->codes[11591] = 0x000121c3b4441931UL;
   tf->codes[11592] = 0x000121ca5677c082UL;
   tf->codes[11593] = 0x000121d307b29bc0UL;
   tf->codes[11594] = 0x000121d7d56e14e9UL;
   tf->codes[11595] = 0x000121d80ffd1aaeUL;
   tf->codes[11596] = 0x000121da94225a25UL;
   tf->codes[11597] = 0x000121dd8d65a526UL;
   tf->codes[11598] = 0x000121e4a4b75801UL;
   tf->codes[11599] = 0x000121e6792f8629UL;
   tf->codes[11600] = 0x000121e8c2c5bfdbUL;
   tf->codes[11601] = 0x000121f298cbb7f2UL;
   tf->codes[11602] = 0x000121f3bd96d4cbUL;
   tf->codes[11603] = 0x000121f8c5e153b9UL;
   tf->codes[11604] = 0x000121f9b01d6acdUL;
   tf->codes[11605] = 0x000121fb0f778d6bUL;
   tf->codes[11606] = 0x000121fb4a069330UL;
   tf->codes[11607] = 0x000121fe4349de31UL;
   tf->codes[11608] = 0x00012205200c8b47UL;
   tf->codes[11609] = 0x00012209038bed5cUL;
   tf->codes[11610] = 0x00012214e8991960UL;
   tf->codes[11611] = 0x00012217a74d5e9cUL;
   tf->codes[11612] = 0x0001221b15aeb527UL;
   tf->codes[11613] = 0x000122238c5a8aa0UL;
   tf->codes[11614] = 0x000122259b61be8dUL;
   tf->codes[11615] = 0x00012226107fca17UL;
   tf->codes[11616] = 0x00012229b9702667UL;
   tf->codes[11617] = 0x000122331a5812f4UL;
   tf->codes[11618] = 0x000122359e7d526bUL;
   tf->codes[11619] = 0x00012236139b5df5UL;
   tf->codes[11620] = 0x00012236fdd77509UL;
   tf->codes[11621] = 0x0001223a31a9c5cfUL;
   tf->codes[11622] = 0x0001223ae156d71eUL;
   tf->codes[11623] = 0x0001224148fb78aaUL;
   tf->codes[11624] = 0x00012242a8559b48UL;
   tf->codes[11625] = 0x0001224ae4726afcUL;
   tf->codes[11626] = 0x0001224b941f7c4bUL;
   tf->codes[11627] = 0x0001224fb22de425UL;
   tf->codes[11628] = 0x00012257040e9cc5UL;
   tf->codes[11629] = 0x0001225ae78dfedaUL;
   tf->codes[11630] = 0x000122644875eb67UL;
   tf->codes[11631] = 0x00012264f822fcb6UL;
   tf->codes[11632] = 0x00012266577d1f54UL;
   tf->codes[11633] = 0x0001226f7dd6061cUL;
   tf->codes[11634] = 0x00012272b1a856e2UL;
   tf->codes[11635] = 0x00012274c0af8acfUL;
   tf->codes[11636] = 0x00012277f481db95UL;
   tf->codes[11637] = 0x0001227a78a71b0cUL;
   tf->codes[11638] = 0x0001227ed14488abUL;
   tf->codes[11639] = 0x00012293a21b95b2UL;
   tf->codes[11640] = 0x00012297859af7c7UL;
   tf->codes[11641] = 0x0001229835480916UL;
   tf->codes[11642] = 0x0001229994a22bb4UL;
   tf->codes[11643] = 0x0001229b2e8b5417UL;
   tf->codes[11644] = 0x0001229db2b0938eUL;
   tf->codes[11645] = 0x000122a330191e06UL;
   tf->codes[11646] = 0x000122a3a5372990UL;
   tf->codes[11647] = 0x000122b36dc3b7a9UL;
   tf->codes[11648] = 0x000122b8eb2c4221UL;
   tf->codes[11649] = 0x000122bcceaba436UL;
   tf->codes[11650] = 0x000122bf1841dde8UL;
   tf->codes[11651] = 0x000122c0027df4fcUL;
   tf->codes[11652] = 0x000122c286a33473UL;
   tf->codes[11653] = 0x000122c5455779afUL;
   tf->codes[11654] = 0x000122d7577a417aUL;
   tf->codes[11655] = 0x000122da8b4c9240UL;
   tf->codes[11656] = 0x000122e54b8ea16bUL;
   tf->codes[11657] = 0x000122ea194a1a94UL;
   tf->codes[11658] = 0x000122f1a5b9d8f9UL;
   tf->codes[11659] = 0x000122f847ed804aUL;
   tf->codes[11660] = 0x000122facc12bfc1UL;
   tf->codes[11661] = 0x000122fc2b6ce25fUL;
   tf->codes[11662] = 0x000122ffd45d3eafUL;
   tf->codes[11663] = 0x0001230551c5c927UL;
   tf->codes[11664] = 0x00012307d5eb089eUL;
   tf->codes[11665] = 0x0001230f625ac703UL;
   tf->codes[11666] = 0x000123179e7796b7UL;
   tf->codes[11667] = 0x0001231e7b3a43cdUL;
   tf->codes[11668] = 0x00012322242aa01dUL;
   tf->codes[11669] = 0x00012325928bf6a8UL;
   tf->codes[11670] = 0x0001233261d539c0UL;
   tf->codes[11671] = 0x000123376a1fb8aeUL;
   tf->codes[11672] = 0x00012338545bcfc2UL;
   tf->codes[11673] = 0x000123388eead587UL;
   tf->codes[11674] = 0x00012339b3b5f260UL;
   tf->codes[11675] = 0x000123401b5a93ecUL;
   tf->codes[11676] = 0x0001234090789f76UL;
   tf->codes[11677] = 0x00012354ec31a0f3UL;
   tf->codes[11678] = 0x0001235b19473cbaUL;
   tf->codes[11679] = 0x0001235b8e654844UL;
   tf->codes[11680] = 0x00012361bb7ae40bUL;
   tf->codes[11681] = 0x0001236689365d34UL;
   tf->codes[11682] = 0x0001236c7bbcf336UL;
   tf->codes[11683] = 0x00012377768e0826UL;
   tf->codes[11684] = 0x00012379fab3479dUL;
   tf->codes[11685] = 0x0001237bcf2b75c5UL;
   tf->codes[11686] = 0x0001237dde32a9b2UL;
   tf->codes[11687] = 0x0001238530136252UL;
   tf->codes[11688] = 0x0001238e566c491aUL;
   tf->codes[11689] = 0x00012391ff5ca56aUL;
   tf->codes[11690] = 0x00012392e998bc7eUL;
   tf->codes[11691] = 0x0001239c4a80a90bUL;
   tf->codes[11692] = 0x000123a2779644d2UL;
   tf->codes[11693] = 0x000123a2b2254a97UL;
   tf->codes[11694] = 0x000123a62086a122UL;
   tf->codes[11695] = 0x000123a82f8dd50fUL;
   tf->codes[11696] = 0x000123b9577485c6UL;
   tf->codes[11697] = 0x000123ba7c3fa29fUL;
   tf->codes[11698] = 0x000123bf0f6c1603UL;
   tf->codes[11699] = 0x000123c78617eb7cUL;
   tf->codes[11700] = 0x000123c9cfae252eUL;
   tf->codes[11701] = 0x000123d1218eddceUL;
   tf->codes[11702] = 0x000123d57a2c4b6dUL;
   tf->codes[11703] = 0x000123e57d47df4bUL;
   tf->codes[11704] = 0x000123eea3a0c613UL;
   tf->codes[11705] = 0x000123f580637329UL;
   tf->codes[11706] = 0x0001240040a58254UL;
   tf->codes[11707] = 0x00012402ff59c790UL;
   tf->codes[11708] = 0x0001240e34b9e245UL;
   tf->codes[11709] = 0x00012416ab65b7beUL;
   tf->codes[11710] = 0x000124172083c348UL;
   tf->codes[11711] = 0x0001241f5ca092fcUL;
   tf->codes[11712] = 0x00012420f689bb5fUL;
   tf->codes[11713] = 0x00012421e0c5d273UL;
   tf->codes[11714] = 0x0001242589b62ec3UL;
   tf->codes[11715] = 0x0001242798bd62b0UL;
   tf->codes[11716] = 0x0001242932a68b13UL;
   tf->codes[11717] = 0x00012435c760c866UL;
   tf->codes[11718] = 0x0001243726baeb04UL;
   tf->codes[11719] = 0x0001243bf476642dUL;
   tf->codes[11720] = 0x0001243f2848b4f3UL;
   tf->codes[11721] = 0x00012440fcc0e31bUL;
   tf->codes[11722] = 0x00012455cd97f022UL;
   tf->codes[11723] = 0x0001245bfaad8be9UL;
   tf->codes[11724] = 0x0001245fde2cedfeUL;
   tf->codes[11725] = 0x00012466f57ea0d9UL;
   tf->codes[11726] = 0x0001247140a2a47aUL;
   tf->codes[11727] = 0x000124760e5e1da3UL;
   tf->codes[11728] = 0x0001247857f45755UL;
   tf->codes[11729] = 0x0001247b16a89c91UL;
   tf->codes[11730] = 0x0001248094112709UL;
   tf->codes[11731] = 0x0001248143be3858UL;
   tf->codes[11732] = 0x0001248b19c4306fUL;
   tf->codes[11733] = 0x0001248f72619e0eUL;
   tf->codes[11734] = 0x00012491f686dd85UL;
   tf->codes[11735] = 0x000124959f7739d5UL;
   tf->codes[11736] = 0x0001249f005f2662UL;
   tf->codes[11737] = 0x000124a09a484ec5UL;
   tf->codes[11738] = 0x000124a8614712efUL;
   tf->codes[11739] = 0x000124b35c1827dfUL;
   tf->codes[11740] = 0x000124b9140fb81cUL;
   tf->codes[11741] = 0x000124bb5da5f1ceUL;
   tf->codes[11742] = 0x000124bcf78f1a31UL;
   tf->codes[11743] = 0x000124be91784294UL;
   tf->codes[11744] = 0x000124cab114745dUL;
   tf->codes[11745] = 0x000124d69621a061UL;
   tf->codes[11746] = 0x000124da0482f6ecUL;
   tf->codes[11747] = 0x000124e5e99022f0UL;
   tf->codes[11748] = 0x000124e957f1797bUL;
   tf->codes[11749] = 0x000124ea7cbc9654UL;
   tf->codes[11750] = 0x000124f32df77192UL;
   tf->codes[11751] = 0x000124f3dda482e1UL;
   tf->codes[11752] = 0x00012505058b3398UL;
   tf->codes[11753] = 0x0001250714926785UL;
   tf->codes[11754] = 0x00012517523d0128UL;
   tf->codes[11755] = 0x0001251b35bc633dUL;
   tf->codes[11756] = 0x0001251ea41db9c8UL;
   tf->codes[11757] = 0x000125207895e7f0UL;
   tf->codes[11758] = 0x000125245c154a05UL;
   tf->codes[11759] = 0x00012528ef41bd69UL;
   tf->codes[11760] = 0x0001252ac3b9eb91UL;
   tf->codes[11761] = 0x0001253842b03ff8UL;
   tf->codes[11762] = 0x0001253a8c4679aaUL;
   tf->codes[11763] = 0x0001253d8589c4abUL;
   tf->codes[11764] = 0x000125554fa41cb3UL;
   tf->codes[11765] = 0x00012555c4c2283dUL;
   tf->codes[11766] = 0x00012557241c4adbUL;
   tf->codes[11767] = 0x0001255b7cb9b87aUL;
   tf->codes[11768] = 0x0001256134b148b7UL;
   tf->codes[11769] = 0x000125684c02fb92UL;
   tf->codes[11770] = 0x0001256ad0283b09UL;
   tf->codes[11771] = 0x0001257381631647UL;
   tf->codes[11772] = 0x00012574a62e3320UL;
   tf->codes[11773] = 0x0001257640175b83UL;
   tf->codes[11774] = 0x0001257bbd7fe5fbUL;
   tf->codes[11775] = 0x00012581b0067bfdUL;
   tf->codes[11776] = 0x00012587dd1c17c4UL;
   tf->codes[11777] = 0x0001258b860c7414UL;
   tf->codes[11778] = 0x00012595d13077b5UL;
   tf->codes[11779] = 0x00012597308a9a53UL;
   tf->codes[11780] = 0x000125a7e3533f80UL;
   tf->codes[11781] = 0x000125aaa20784bcUL;
   tf->codes[11782] = 0x000125ab51b4960bUL;
   tf->codes[11783] = 0x000125b38dd165bfUL;
   tf->codes[11784] = 0x000125b8961be4adUL;
   tf->codes[11785] = 0x000125be13846f25UL;
   tf->codes[11786] = 0x000125c4b5b81676UL;
   tf->codes[11787] = 0x000125c5da83334fUL;
   tf->codes[11788] = 0x000125c64fa13ed9UL;
   tf->codes[11789] = 0x000125c85ea872c6UL;
   tf->codes[11790] = 0x000125ca6dafa6b3UL;
   tf->codes[11791] = 0x000125d1bf905f53UL;
   tf->codes[11792] = 0x000125d47e44a48fUL;
   tf->codes[11793] = 0x000125d652bcd2b7UL;
   tf->codes[11794] = 0x000125da363c34ccUL;
   tf->codes[11795] = 0x000125de19bb96e1UL;
   tf->codes[11796] = 0x000125e09de0d658UL;
   tf->codes[11797] = 0x000125e89f6ea047UL;
   tf->codes[11798] = 0x000125f39a3fb537UL;
   tf->codes[11799] = 0x00012604fcb56bb3UL;
   tf->codes[11800] = 0x000126083087bc79UL;
   tf->codes[11801] = 0x000126098fe1df17UL;
   tf->codes[11802] = 0x000126191ddf676bUL;
   tf->codes[11803] = 0x00012624533f8220UL;
   tf->codes[11804] = 0x00012627fc2fde70UL;
   tf->codes[11805] = 0x00012628714de9faUL;
   tf->codes[11806] = 0x00012636656249ebUL;
   tf->codes[11807] = 0x0001263999349ab1UL;
   tf->codes[11808] = 0x0001263abdffb78aUL;
   tf->codes[11809] = 0x0001263f512c2aeeUL;
   tf->codes[11810] = 0x00012643a9c9988dUL;
   tf->codes[11811] = 0x00012648778511b6UL;
   tf->codes[11812] = 0x0001264b363956f2UL;
   tf->codes[11813] = 0x00012651634ef2b9UL;
   tf->codes[11814] = 0x00012658b52fab59UL;
   tf->codes[11815] = 0x0001265e329835d1UL;
   tf->codes[11816] = 0x000126628b35a370UL;
   tf->codes[11817] = 0x0001266b01e178e9UL;
   tf->codes[11818] = 0x00012673036f42d8UL;
   tf->codes[11819] = 0x000126749d586b3bUL;
   tf->codes[11820] = 0x000126837ba8e240UL;
   tf->codes[11821] = 0x0001268515920aa3UL;
   tf->codes[11822] = 0x00012694a38f92f7UL;
   tf->codes[11823] = 0x00012698fc2d0096UL;
   tf->codes[11824] = 0x00012699e66917aaUL;
   tf->codes[11825] = 0x0001269a5b872334UL;
   tf->codes[11826] = 0x0001269b8052400dUL;
   tf->codes[11827] = 0x000126a974669ffeUL;
   tf->codes[11828] = 0x000126b7dd990b79UL;
   tf->codes[11829] = 0x000126bce5e38a67UL;
   tf->codes[11830] = 0x000126bf6a08c9deUL;
   tf->codes[11831] = 0x000126bfa497cfa3UL;
   tf->codes[11832] = 0x000126c34d882bf3UL;
   tf->codes[11833] = 0x000126c5d1ad6b6aUL;
   tf->codes[11834] = 0x000126c9057fbc30UL;
   tf->codes[11835] = 0x000126ca9f68e493UL;
   tf->codes[11836] = 0x000126cfa7b36381UL;
   tf->codes[11837] = 0x000126dc01de9b0fUL;
   tf->codes[11838] = 0x000126defb21e610UL;
   tf->codes[11839] = 0x000126e5283781d7UL;
   tf->codes[11840] = 0x000126ea6b11068aUL;
   tf->codes[11841] = 0x000126f52b5315b5UL;
   tf->codes[11842] = 0x0001270394858130UL;
   tf->codes[11843] = 0x00012706c857d1f6UL;
   tf->codes[11844] = 0x0001270827b1f494UL;
   tf->codes[11845] = 0x00012719ff45b69aUL;
   tf->codes[11846] = 0x0001271a7463c224UL;
   tf->codes[11847] = 0x000127223b62864eUL;
   tf->codes[11848] = 0x00012723259e9d62UL;
   tf->codes[11849] = 0x000127282de91c50UL;
   tf->codes[11850] = 0x0001272aec9d618cUL;
   tf->codes[11851] = 0x00012732b39c25b6UL;
   tf->codes[11852] = 0x0001273572506af2UL;
   tf->codes[11853] = 0x00012739905ed2ccUL;
   tf->codes[11854] = 0x0001273b2a47fb2fUL;
   tf->codes[11855] = 0x0001273ed338577fUL;
   tf->codes[11856] = 0x000127465fa815e4UL;
   tf->codes[11857] = 0x000127470f552733UL;
   tf->codes[11858] = 0x0001274b67f294d2UL;
   tf->codes[11859] = 0x00012751cf97365eUL;
   tf->codes[11860] = 0x00012755788792aeUL;
   tf->codes[11861] = 0x00012755b3169873UL;
   tf->codes[11862] = 0x000127562834a3fdUL;
   tf->codes[11863] = 0x00012757878ec69bUL;
   tf->codes[11864] = 0x00012758e6e8e939UL;
   tf->codes[11865] = 0x000127599695fa88UL;
   tf->codes[11866] = 0x0001275b307f22ebUL;
   tf->codes[11867] = 0x00012763e1b9fe29UL;
   tf->codes[11868] = 0x00012766a06e4365UL;
   tf->codes[11869] = 0x00012768af757752UL;
   tf->codes[11870] = 0x00012771d5ce5e1aUL;
   tf->codes[11871] = 0x0001277babd45631UL;
   tf->codes[11872] = 0x0001277d45bd7e94UL;
   tf->codes[11873] = 0x0001277fc9e2be0bUL;
   tf->codes[11874] = 0x0001278163cbe66eUL;
   tf->codes[11875] = 0x000127850cbc42beUL;
   tf->codes[11876] = 0x000127866c16655cUL;
   tf->codes[11877] = 0x00012788b5ac9f0eUL;
   tf->codes[11878] = 0x0001278b39d1de85UL;
   tf->codes[11879] = 0x0001278c5e9cfb5eUL;
   tf->codes[11880] = 0x000127950fd7d69cUL;
   tf->codes[11881] = 0x000127a219b01f79UL;
   tf->codes[11882] = 0x000127abb52711cbUL;
   tf->codes[11883] = 0x000127b291e9bee1UL;
   tf->codes[11884] = 0x000127b6aff826bbUL;
   tf->codes[11885] = 0x000127bc67efb6f8UL;
   tf->codes[11886] = 0x000127beec14f66fUL;
   tf->codes[11887] = 0x000127bf26a3fc34UL;
   tf->codes[11888] = 0x000127c79d4fd1adUL;
   tf->codes[11889] = 0x000127cce0295660UL;
   tf->codes[11890] = 0x000127d51c462614UL;
   tf->codes[11891] = 0x000127dfdc88353fUL;
   tf->codes[11892] = 0x000127e3c0079754UL;
   tf->codes[11893] = 0x000127e768f7f3a4UL;
   tf->codes[11894] = 0x000127e818a504f3UL;
   tf->codes[11895] = 0x000127e8c8521642UL;
   tf->codes[11896] = 0x000127e977ff2791UL;
   tf->codes[11897] = 0x000127eb11e84ff4UL;
   tf->codes[11898] = 0x000127ebfc246708UL;
   tf->codes[11899] = 0x000127fc745e0670UL;
   tf->codes[11900] = 0x000127fdd3b8290eUL;
   tf->codes[11901] = 0x000127fe0e472ed3UL;
   tf->codes[11902] = 0x000128052598e1aeUL;
   tf->codes[11903] = 0x0001280b52ae7d75UL;
   tf->codes[11904] = 0x000128117fc4193cUL;
   tf->codes[11905] = 0x000128126a003050UL;
   tf->codes[11906] = 0x00012812df1e3bdaUL;
   tf->codes[11907] = 0x00012819f66feeb5UL;
   tf->codes[11908] = 0x0001282949de7144UL;
   tf->codes[11909] = 0x0001282fec121895UL;
   tf->codes[11910] = 0x00012833cf917aaaUL;
   tf->codes[11911] = 0x0001283b2172334aUL;
   tf->codes[11912] = 0x00012840644bb7fdUL;
   tf->codes[11913] = 0x0001284532073126UL;
   tf->codes[11914] = 0x00012850a1f651a0UL;
   tf->codes[11915] = 0x0001285360aa96dcUL;
   tf->codes[11916] = 0x00012856947ce7a2UL;
   tf->codes[11917] = 0x00012858de132154UL;
   tf->codes[11918] = 0x0001285c4c7477dfUL;
   tf->codes[11919] = 0x000128606a82dfb9UL;
   tf->codes[11920] = 0x00012865383e58e2UL;
   tf->codes[11921] = 0x000128691bbdbaf7UL;
   tf->codes[11922] = 0x00012874511dd5acUL;
   tf->codes[11923] = 0x00012876d5431523UL;
   tf->codes[11924] = 0x00012878a9bb434bUL;
   tf->codes[11925] = 0x0001287c181c99d6UL;
   tf->codes[11926] = 0x000128895c83e878UL;
   tf->codes[11927] = 0x000128957c201a41UL;
   tf->codes[11928] = 0x000128978b274e2eUL;
   tf->codes[11929] = 0x0001289875636542UL;
   tf->codes[11930] = 0x0001289c1e53c192UL;
   tf->codes[11931] = 0x0001289ea2790109UL;
   tf->codes[11932] = 0x000128a753b3dc47UL;
   tf->codes[11933] = 0x000128b547c83c38UL;
   tf->codes[11934] = 0x000128b6e1b1649bUL;
   tf->codes[11935] = 0x000128b8f0b89888UL;
   tf->codes[11936] = 0x000128ba5012bb26UL;
   tf->codes[11937] = 0x000128c66faeecefUL;
   tf->codes[11938] = 0x000128c7947a09c8UL;
   tf->codes[11939] = 0x000128cb3d6a6618UL;
   tf->codes[11940] = 0x000128d16a8001dfUL;
   tf->codes[11941] = 0x000128d513705e2fUL;
   tf->codes[11942] = 0x000128d6ad598692UL;
   tf->codes[11943] = 0x000128e0bdee846eUL;
   tf->codes[11944] = 0x000128f5c954973aUL;
   tf->codes[11945] = 0x000128f63e72a2c4UL;
   tf->codes[11946] = 0x000128f6ee1fb413UL;
   tf->codes[11947] = 0x000128f7633dbf9dUL;
   tf->codes[11948] = 0x000128fad19f1628UL;
   tf->codes[11949] = 0x000128fb0c2e1bedUL;
   tf->codes[11950] = 0x00012908160664caUL;
   tf->codes[11951] = 0x00012916f456dbcfUL;
   tf->codes[11952] = 0x00012919787c1b46UL;
   tf->codes[11953] = 0x00012922d96407d3UL;
   tf->codes[11954] = 0x00012924addc35fbUL;
   tf->codes[11955] = 0x0001292aa062cbfdUL;
   tf->codes[11956] = 0x00012931f243849dUL;
   tf->codes[11957] = 0x00012935d5c2e6b2UL;
   tf->codes[11958] = 0x0001293ade0d65a0UL;
   tf->codes[11959] = 0x0001293e4c6ebc2bUL;
   tf->codes[11960] = 0x0001293fabc8dec9UL;
   tf->codes[11961] = 0x00012944798457f2UL;
   tf->codes[11962] = 0x0001294ae128f97eUL;
   tf->codes[11963] = 0x0001294d654e38f5UL;
   tf->codes[11964] = 0x0001294fe973786cUL;
   tf->codes[11965] = 0x00012954b72ef195UL;
   tf->codes[11966] = 0x00012955a16b08a9UL;
   tf->codes[11967] = 0x00012957eb01425bUL;
   tf->codes[11968] = 0x0001295825904820UL;
   tf->codes[11969] = 0x0001296320615d10UL;
   tf->codes[11970] = 0x00012964452c79e9UL;
   tf->codes[11971] = 0x0001297273cfdf9fUL;
   tf->codes[11972] = 0x0001297691de4779UL;
   tf->codes[11973] = 0x0001297a003f9e04UL;
   tf->codes[11974] = 0x0001297aea7bb518UL;
   tf->codes[11975] = 0x000129844b63a1a5UL;
   tf->codes[11976] = 0x0001298485f2a76aUL;
   tf->codes[11977] = 0x000129886972097fUL;
   tf->codes[11978] = 0x0001298bd7d3600aUL;
   tf->codes[11979] = 0x0001299f49504a73UL;
   tf->codes[11980] = 0x000129aded11bbb3UL;
   tf->codes[11981] = 0x000129b7fda6b98fUL;
   tf->codes[11982] = 0x000129b9d21ee7b7UL;
   tf->codes[11983] = 0x000129ba473cf341UL;
   tf->codes[11984] = 0x000129bb31790a55UL;
   tf->codes[11985] = 0x000129be9fda60e0UL;
   tf->codes[11986] = 0x000129c78ba441e3UL;
   tf->codes[11987] = 0x000129c9d53a7b95UL;
   tf->codes[11988] = 0x000129cabf7692a9UL;
   tf->codes[11989] = 0x000129d57fb8a1d4UL;
   tf->codes[11990] = 0x000129d99dc709aeUL;
   tf->codes[11991] = 0x000129db723f37d6UL;
   tf->codes[11992] = 0x000129df1b2f9426UL;
   tf->codes[11993] = 0x000129e1d9e3d962UL;
   tf->codes[11994] = 0x000129e87c1780b3UL;
   tf->codes[11995] = 0x000129f54b60c3cbUL;
   tf->codes[11996] = 0x000129f75a67f7b8UL;
   tf->codes[11997] = 0x000129f844a40eccUL;
   tf->codes[11998] = 0x00012a0847bfa2aaUL;
   tf->codes[11999] = 0x00012a0931fbb9beUL;
   tf->codes[12000] = 0x00012a0d8a99275dUL;
   tf->codes[12001] = 0x00012a0f5f115585UL;
   tf->codes[12002] = 0x00012a1676630860UL;
   tf->codes[12003] = 0x00012a1b441e8189UL;
   tf->codes[12004] = 0x00012a2345ac4b78UL;
   tf->codes[12005] = 0x00012a23baca5702UL;
   tf->codes[12006] = 0x00012a26797e9c3eUL;
   tf->codes[12007] = 0x00012a37a1654cf5UL;
   tf->codes[12008] = 0x00012a393b4e7558UL;
   tf->codes[12009] = 0x00012a3b0fc6a380UL;
   tf->codes[12010] = 0x00012a57327e6927UL;
   tf->codes[12011] = 0x00012a581cba803bUL;
   tf->codes[12012] = 0x00012a63178b952bUL;
   tf->codes[12013] = 0x00012a71f5dc0c30UL;
   tf->codes[12014] = 0x00012a77734496a8UL;
   tf->codes[12015] = 0x00012a7bcbe20447UL;
   tf->codes[12016] = 0x00012a80999d7d70UL;
   tf->codes[12017] = 0x00012a8b1f5086d6UL;
   tf->codes[12018] = 0x00012aa14f81b67bUL;
   tf->codes[12019] = 0x00012aa1ff2ec7caUL;
   tf->codes[12020] = 0x00012aa916807aa5UL;
   tf->codes[12021] = 0x00012aab9aa5ba1cUL;
   tf->codes[12022] = 0x00012ab4866f9b1fUL;
   tf->codes[12023] = 0x00012ab7ba41ebe5UL;
   tf->codes[12024] = 0x00012ac06b7cc723UL;
   tf->codes[12025] = 0x00012ac4fea93a87UL;
   tf->codes[12026] = 0x00012ac7bd5d7fc3UL;
   tf->codes[12027] = 0x00012adbde877b7bUL;
   tf->codes[12028] = 0x00012add7870a3deUL;
   tf->codes[12029] = 0x00012ae12161002eUL;
   tf->codes[12030] = 0x00012ae74e769bf5UL;
   tf->codes[12031] = 0x00012aeb31f5fe0aUL;
   tf->codes[12032] = 0x00012af4584ee4d2UL;
   tf->codes[12033] = 0x00012af78c213598UL;
   tf->codes[12034] = 0x00012afc946bb486UL;
   tf->codes[12035] = 0x00012b03369f5bd7UL;
   tf->codes[12036] = 0x00012b0a88801477UL;
   tf->codes[12037] = 0x00012b19dbee9706UL;
   tf->codes[12038] = 0x00012b1b3b48b9a4UL;
   tf->codes[12039] = 0x00012b1beaf5caf3UL;
   tf->codes[12040] = 0x00012b1c6013d67dUL;
   tf->codes[12041] = 0x00012b20b8b1441cUL;
   tf->codes[12042] = 0x00012b23ec8394e2UL;
   tf->codes[12043] = 0x00012b39e225bec2UL;
   tf->codes[12044] = 0x00012b4b7f2a7b03UL;
   tf->codes[12045] = 0x00012b563f6c8a2eUL;
   tf->codes[12046] = 0x00012b5e7b8959e2UL;
   tf->codes[12047] = 0x00012b66f2352f5bUL;
   tf->codes[12048] = 0x00012b688c1e57beUL;
   tf->codes[12049] = 0x00012b6bbff0a884UL;
   tf->codes[12050] = 0x00012b6d59d9d0e7UL;
   tf->codes[12051] = 0x00012b7311d16124UL;
   tf->codes[12052] = 0x00012b73fc0d7838UL;
   tf->codes[12053] = 0x00012b75d085a660UL;
   tf->codes[12054] = 0x00012b76bac1bd74UL;
   tf->codes[12055] = 0x00012b77df8cda4dUL;
   tf->codes[12056] = 0x00012b7ce7d7593bUL;
   tf->codes[12057] = 0x00012b8adbebb92cUL;
   tf->codes[12058] = 0x00012b8c75d4e18fUL;
   tf->codes[12059] = 0x00012b97ab34fc44UL;
   tf->codes[12060] = 0x00012ba021e0d1bdUL;
   tf->codes[12061] = 0x00012ba390422848UL;
   tf->codes[12062] = 0x00012ba689857349UL;
   tf->codes[12063] = 0x00012ba6c414790eUL;
   tf->codes[12064] = 0x00012ba8988ca736UL;
   tf->codes[12065] = 0x00012bb05f8b6b60UL;
   tf->codes[12066] = 0x00012bb26e929f4dUL;
   tf->codes[12067] = 0x00012bb567d5ea4eUL;
   tf->codes[12068] = 0x00012bb776dd1e3bUL;
   tf->codes[12069] = 0x00012bb8268a2f8aUL;
   tf->codes[12070] = 0x00012bbdde81bfc7UL;
   tf->codes[12071] = 0x00012bc2ac3d38f0UL;
   tf->codes[12072] = 0x00012bdbd5b1b396UL;
   tf->codes[12073] = 0x00012bdfb93115abUL;
   tf->codes[12074] = 0x00012be4fc0a9a5eUL;
   tf->codes[12075] = 0x00012be6d082c886UL;
   tf->codes[12076] = 0x00012beab4022a9bUL;
   tf->codes[12077] = 0x00012bef0c9f983aUL;
   tf->codes[12078] = 0x00012bf44f791cedUL;
   tf->codes[12079] = 0x00012bf48a0822b2UL;
   tf->codes[12080] = 0x00012bfdb061097aUL;
   tf->codes[12081] = 0x00012bffbf683d67UL;
   tf->codes[12082] = 0x00012c0870a318a5UL;
   tf->codes[12083] = 0x00012c12bbc71c46UL;
   tf->codes[12084] = 0x00012c1a0da7d4e6UL;
   tf->codes[12085] = 0x00012c1abd54e635UL;
   tf->codes[12086] = 0x00012c1af7e3ebfaUL;
   tf->codes[12087] = 0x00012c1d417a25acUL;
   tf->codes[12088] = 0x00012c228453aa5fUL;
   tf->codes[12089] = 0x00012c254307ef9bUL;
   tf->codes[12090] = 0x00012c2801bc34d7UL;
   tf->codes[12091] = 0x00012c2ac0707a13UL;
   tf->codes[12092] = 0x00012c40066592a4UL;
   tf->codes[12093] = 0x00012c40b612a3f3UL;
   tf->codes[12094] = 0x00012c528da665f9UL;
   tf->codes[12095] = 0x00012c54621e9421UL;
   tf->codes[12096] = 0x00012c567125c80eUL;
   tf->codes[12097] = 0x00012c56e643d398UL;
   tf->codes[12098] = 0x00012c58802cfbfbUL;
   tf->codes[12099] = 0x00012c5e72b391fdUL;
   tf->codes[12100] = 0x00012c613167d739UL;
   tf->codes[12101] = 0x00012c621ba3ee4dUL;
   tf->codes[12102] = 0x00012c6639b25627UL;
   tf->codes[12103] = 0x00012c746855bbddUL;
   tf->codes[12104] = 0x00012c76ec7afb54UL;
   tf->codes[12105] = 0x00012c7d8eaea2a5UL;
   tf->codes[12106] = 0x00012c7f6326d0cdUL;
   tf->codes[12107] = 0x00012c7fd844dc57UL;
   tf->codes[12108] = 0x00012c81acbd0a7fUL;
   tf->codes[12109] = 0x00012c8a2368dff8UL;
   tf->codes[12110] = 0x00012c91ea67a422UL;
   tf->codes[12111] = 0x00012c993c485cc2UL;
   tf->codes[12112] = 0x00012c9e4492dbb0UL;
   tf->codes[12113] = 0x00012c9e7f21e175UL;
   tf->codes[12114] = 0x00012c9eb9b0e73aUL;
   tf->codes[12115] = 0x00012ca5d1029a15UL;
   tf->codes[12116] = 0x00012ca81a98d3c7UL;
   tf->codes[12117] = 0x00012cbc0133c9baUL;
   tf->codes[12118] = 0x00012cbd25fee693UL;
   tf->codes[12119] = 0x00012cc477df9f33UL;
   tf->codes[12120] = 0x00012ccbc9c057d3UL;
   tf->codes[12121] = 0x00012cd26bf3ff24UL;
   tf->codes[12122] = 0x00012cd5da5555afUL;
   tf->codes[12123] = 0x00012cd9f863bd89UL;
   tf->codes[12124] = 0x00012cda6d81c913UL;
   tf->codes[12125] = 0x00012ce10fb57064UL;
   tf->codes[12126] = 0x00012ce3ce69b5a0UL;
   tf->codes[12127] = 0x00012ce47e16c6efUL;
   tf->codes[12128] = 0x00012ce56852de03UL;
   tf->codes[12129] = 0x00012ce9fb7f5167UL;
   tf->codes[12130] = 0x00012cf396f643b9UL;
   tf->codes[12131] = 0x00012cf446a35508UL;
   tf->codes[12132] = 0x00012cffb6927582UL;
   tf->codes[12133] = 0x00012d061e37170eUL;
   tf->codes[12134] = 0x00012d09520967d4UL;
   tf->codes[12135] = 0x00012d1571a5999dUL;
   tf->codes[12136] = 0x00012d1cc386523dUL;
   tf->codes[12137] = 0x00012d2af229b7f3UL;
   tf->codes[12138] = 0x00012d33ddf398f6UL;
   tf->codes[12139] = 0x00012d362789d2a8UL;
   tf->codes[12140] = 0x00012d3b6a63575bUL;
   tf->codes[12141] = 0x00012d3e29179c97UL;
   tf->codes[12142] = 0x00012d57528c173dUL;
   tf->codes[12143] = 0x00012d5a4bcf623eUL;
   tf->codes[12144] = 0x00012d5df4bfbe8eUL;
   tf->codes[12145] = 0x00012d6337994341UL;
   tf->codes[12146] = 0x00012d6372284906UL;
   tf->codes[12147] = 0x00012d65812f7cf3UL;
   tf->codes[12148] = 0x00012d65bbbe82b8UL;
   tf->codes[12149] = 0x00012d6afe98076bUL;
   tf->codes[12150] = 0x00012d75f9691c5bUL;
   tf->codes[12151] = 0x00012d771e343934UL;
   tf->codes[12152] = 0x00012d79a25978abUL;
   tf->codes[12153] = 0x00012d7ac7249584UL;
   tf->codes[12154] = 0x00012d88bb38f575UL;
   tf->codes[12155] = 0x00012d99337294ddUL;
   tf->codes[12156] = 0x00012d9bb797d454UL;
   tf->codes[12157] = 0x00012d9bf226da19UL;
   tf->codes[12158] = 0x00012d9e3bbd13cbUL;
   tf->codes[12159] = 0x00012daeb3f6b333UL;
   tf->codes[12160] = 0x00012db4a67d4935UL;
   tf->codes[12161] = 0x00012db5562a5a84UL;
   tf->codes[12162] = 0x00012db605d76bd3UL;
   tf->codes[12163] = 0x00012db939a9bc99UL;
   tf->codes[12164] = 0x00012dbfa14e5e25UL;
   tf->codes[12165] = 0x00012dc55945ee62UL;
   tf->codes[12166] = 0x00012dc7684d224fUL;
   tf->codes[12167] = 0x00012dcc36089b78UL;
   tf->codes[12168] = 0x00012dd29dad3d04UL;
   tf->codes[12169] = 0x00012ddf32677a57UL;
   tf->codes[12170] = 0x00012df01fbf2549UL;
   tf->codes[12171] = 0x00012e04f0963250UL;
   tf->codes[12172] = 0x00012e0f76493bb6UL;
   tf->codes[12173] = 0x00012e131f399806UL;
   tf->codes[12174] = 0x00012e173d47ffe0UL;
   tf->codes[12175] = 0x00012e1f0446c40aUL;
   tf->codes[12176] = 0x00012e1fee82db1eUL;
   tf->codes[12177] = 0x00012e239773376eUL;
   tf->codes[12178] = 0x00012e24bc3e5447UL;
   tf->codes[12179] = 0x00012e26cb458834UL;
   tf->codes[12180] = 0x00012e340facd6d6UL;
   tf->codes[12181] = 0x00012e3fba2afd15UL;
   tf->codes[12182] = 0x00012e3ff4ba02daUL;
   tf->codes[12183] = 0x00012e48e083e3ddUL;
   tf->codes[12184] = 0x00012e491b12e9a2UL;
   tf->codes[12185] = 0x00012e4955a1ef67UL;
   tf->codes[12186] = 0x00012e4b9f382919UL;
   tf->codes[12187] = 0x00012e66d7b3d7acUL;
   tf->codes[12188] = 0x00012e778a7c7cd9UL;
   tf->codes[12189] = 0x00012e78af4799b2UL;
   tf->codes[12190] = 0x00012e7be319ea78UL;
   tf->codes[12191] = 0x00012e7edc5d3579UL;
   tf->codes[12192] = 0x00012e9a14d8e40cUL;
   tf->codes[12193] = 0x00012eb49da78150UL;
   tf->codes[12194] = 0x00012eb5c2729e29UL;
   tf->codes[12195] = 0x00012ebb3fdb28a1UL;
   tf->codes[12196] = 0x00012ebd145356c9UL;
   tf->codes[12197] = 0x00012ebe73ad7967UL;
   tf->codes[12198] = 0x00012ebeae3c7f2cUL;
   tf->codes[12199] = 0x00012ec8bed17d08UL;
   tf->codes[12200] = 0x00012edbbb305be7UL;
   tf->codes[12201] = 0x00012edd5519844aUL;
   tf->codes[12202] = 0x00012ee347a01a4cUL;
   tf->codes[12203] = 0x00012ee4a6fa3ceaUL;
   tf->codes[12204] = 0x00012ef2607f9716UL;
   tf->codes[12205] = 0x00012ef3854ab3efUL;
   tf->codes[12206] = 0x00012ef6096ff366UL;
   tf->codes[12207] = 0x00012efce632a07cUL;
   tf->codes[12208] = 0x00012efebaaacea4UL;
   tf->codes[12209] = 0x00012effdf75eb7dUL;
   tf->codes[12210] = 0x00012f03886647cdUL;
   tf->codes[12211] = 0x00012f03fd845357UL;
   tf->codes[12212] = 0x00012f073156a41dUL;
   tf->codes[12213] = 0x00012f0d23dd3a1fUL;
   tf->codes[12214] = 0x00012f122c27b90dUL;
   tf->codes[12215] = 0x00012f15256b040eUL;
   tf->codes[12216] = 0x00012f1943796be8UL;
   tf->codes[12217] = 0x00012f19f3267d37UL;
   tf->codes[12218] = 0x00012f20203c18feUL;
   tf->codes[12219] = 0x00012f2a6b601c9fUL;
   tf->codes[12220] = 0x00012f2ae07e2829UL;
   tf->codes[12221] = 0x00012f3d67befb7eUL;
   tf->codes[12222] = 0x00012f40267340baUL;
   tf->codes[12223] = 0x00012f43cf639d0aUL;
   tf->codes[12224] = 0x00012f47ed7204e4UL;
   tf->codes[12225] = 0x00012f49123d21bdUL;
   tf->codes[12226] = 0x00012f4f04c3b7bfUL;
   tf->codes[12227] = 0x00012f5bd40cfad7UL;
   tf->codes[12228] = 0x00012f5c0e9c009cUL;
   tf->codes[12229] = 0x00012f5d6df6233aUL;
   tf->codes[12230] = 0x00012f66cede0fc7UL;
   tf->codes[12231] = 0x00012f68dde543b4UL;
   tf->codes[12232] = 0x00012f6ab25d71dcUL;
   tf->codes[12233] = 0x00012f6de62fc2a2UL;
   tf->codes[12234] = 0x00012f715491192dUL;
   tf->codes[12235] = 0x00012f744dd4642eUL;
   tf->codes[12236] = 0x00012f81923bb2d0UL;
   tf->codes[12237] = 0x00012f87f9e0545cUL;
   tf->codes[12238] = 0x00012f8993c97cbfUL;
   tf->codes[12239] = 0x00012f953e47a2feUL;
   tf->codes[12240] = 0x00012f96d830cb61UL;
   tf->codes[12241] = 0x00012f9af63f333bUL;
   tf->codes[12242] = 0x00012f9f896ba69fUL;
   tf->codes[12243] = 0x00012fa3e209143eUL;
   tf->codes[12244] = 0x00012fa6662e53b5UL;
   tf->codes[12245] = 0x00012fa800177c18UL;
   tf->codes[12246] = 0x00012faccdd2f541UL;
   tf->codes[12247] = 0x00012fb3aa95a257UL;
   tf->codes[12248] = 0x00012fbf1a84c2d1UL;
   tf->codes[12249] = 0x00012fc19eaa0248UL;
   tf->codes[12250] = 0x00012fcb3a20f49aUL;
   tf->codes[12251] = 0x00012fd87e88433cUL;
   tf->codes[12252] = 0x00012ff4a14008e3UL;
   tf->codes[12253] = 0x00012ff6b0473cd0UL;
   tf->codes[12254] = 0x00012ffd17ebde5cUL;
   tf->codes[12255] = 0x00012ffeb1d506bfUL;
   tf->codes[12256] = 0x00013000112f295dUL;
   tf->codes[12257] = 0x00013000fb6b4071UL;
   tf->codes[12258] = 0x0001300170894bfbUL;
   tf->codes[12259] = 0x0001301173a4dfd9UL;
   tf->codes[12260] = 0x000130146ce82adaUL;
   tf->codes[12261] = 0x0001301591b347b3UL;
   tf->codes[12262] = 0x0001301641605902UL;
   tf->codes[12263] = 0x000130193aa3a403UL;
   tf->codes[12264] = 0x000130293dbf37e1UL;
   tf->codes[12265] = 0x0001303388e33b82UL;
   tf->codes[12266] = 0x000130355d5b69aaUL;
   tf->codes[12267] = 0x0001303c3a1e16c0UL;
   tf->codes[12268] = 0x0001303d9978395eUL;
   tf->codes[12269] = 0x000130577299c553UL;
   tf->codes[12270] = 0x0001305d9faf611aUL;
   tf->codes[12271] = 0x0001305dda3e66dfUL;
   tf->codes[12272] = 0x000130626d6ada43UL;
   tf->codes[12273] = 0x000130639235f71cUL;
   tf->codes[12274] = 0x00013070d69d45beUL;
   tf->codes[12275] = 0x00013076c923dbc0UL;
   tf->codes[12276] = 0x00013078287dfe5eUL;
   tf->codes[12277] = 0x00013082ae3107c4UL;
   tf->codes[12278] = 0x00013085e203588aUL;
   tf->codes[12279] = 0x00013089c582ba9fUL;
   tf->codes[12280] = 0x000130957000e0deUL;
   tf->codes[12281] = 0x0001309fbb24e47fUL;
   tf->codes[12282] = 0x000130a11a7f071dUL;
   tf->codes[12283] = 0x000130b24265b7d4UL;
   tf->codes[12284] = 0x000130b53ba902d5UL;
   tf->codes[12285] = 0x000130b8e4995f25UL;
   tf->codes[12286] = 0x000130c0ab98234fUL;
   tf->codes[12287] = 0x000130cba669383fUL;
   tf->codes[12288] = 0x000130cf89e89a54UL;
   tf->codes[12289] = 0x000130d0aeb3b72dUL;
   tf->codes[12290] = 0x000130d3a7f7022eUL;
   tf->codes[12291] = 0x000130d62c1c41a5UL;
   tf->codes[12292] = 0x000130de2daa0b94UL;
   tf->codes[12293] = 0x000130e57f8ac434UL;
   tf->codes[12294] = 0x000130fa15d2cb76UL;
   tf->codes[12295] = 0x000130fb000ee28aUL;
   tf->codes[12296] = 0x000130fc99f80aedUL;
   tf->codes[12297] = 0x00013100f295788cUL;
   tf->codes[12298] = 0x00013110809300e0UL;
   tf->codes[12299] = 0x000131128f9a34cdUL;
   tf->codes[12300] = 0x0001311304b84057UL;
   tf->codes[12301] = 0x00013116ada89ca7UL;
   tf->codes[12302] = 0x000131180d02bf45UL;
   tf->codes[12303] = 0x0001311fd401836fUL;
   tf->codes[12304] = 0x000131355485a1c5UL;
   tf->codes[12305] = 0x000131367950be9eUL;
   tf->codes[12306] = 0x0001314b4a27cba5UL;
   tf->codes[12307] = 0x0001315b4d435f83UL;
   tf->codes[12308] = 0x0001316bc57cfeebUL;
   tf->codes[12309] = 0x00013174ebd5e5b3UL;
   tf->codes[12310] = 0x0001317ade5c7bb5UL;
   tf->codes[12311] = 0x0001317f36f9e954UL;
   tf->codes[12312] = 0x00013182dfea45a4UL;
   tf->codes[12313] = 0x00013185640f851bUL;
   tf->codes[12314] = 0x00013195a1ba1ebeUL;
   tf->codes[12315] = 0x00013196c6853b97UL;
   tf->codes[12316] = 0x0001319ae493a371UL;
   tf->codes[12317] = 0x000131a236745c11UL;
   tf->codes[12318] = 0x000131a3d05d8474UL;
   tf->codes[12319] = 0x000131a9fd73203bUL;
   tf->codes[12320] = 0x000131b06517c1c7UL;
   tf->codes[12321] = 0x000131b114c4d316UL;
   tf->codes[12322] = 0x000131b77c6974a2UL;
   tf->codes[12323] = 0x000131ba75acbfa3UL;
   tf->codes[12324] = 0x000131bab03bc568UL;
   tf->codes[12325] = 0x000131be592c21b8UL;
   tf->codes[12326] = 0x000131cbd822761fUL;
   tf->codes[12327] = 0x000131d364923484UL;
   tf->codes[12328] = 0x000131ddea453deaUL;
   tf->codes[12329] = 0x000131e2b800b713UL;
   tf->codes[12330] = 0x000131e451e9df76UL;
   tf->codes[12331] = 0x000131e86ff84750UL;
   tf->codes[12332] = 0x000131ee27efd78dUL;
   tf->codes[12333] = 0x000131f6297da17cUL;
   tf->codes[12334] = 0x000131f83884d569UL;
   tf->codes[12335] = 0x000131ffc4f493ceUL;
   tf->codes[12336] = 0x0001320a4aa79d34UL;
   tf->codes[12337] = 0x0001320be490c597UL;
   tf->codes[12338] = 0x00013217c99df19bUL;
   tf->codes[12339] = 0x0001321e6bd198ecUL;
   tf->codes[12340] = 0x0001322005bac14fUL;
   tf->codes[12341] = 0x00013223741c17daUL;
   tf->codes[12342] = 0x00013223aeab1d9fUL;
   tf->codes[12343] = 0x000132387f822aa6UL;
   tf->codes[12344] = 0x0001323969be41baUL;
   tf->codes[12345] = 0x00013240810ff495UL;
   tf->codes[12346] = 0x00013245fe787f0dUL;
   tf->codes[12347] = 0x0001324723439be6UL;
   tf->codes[12348] = 0x000132537d6ed374UL;
   tf->codes[12349] = 0x000132584b2a4c9dUL;
   tf->codes[12350] = 0x0001325b446d979eUL;
   tf->codes[12351] = 0x00013269e82f08deUL;
   tf->codes[12352] = 0x0001326b82183141UL;
   tf->codes[12353] = 0x00013270ff80bbb9UL;
   tf->codes[12354] = 0x000132772c965780UL;
   tf->codes[12355] = 0x0001327851617459UL;
   tf->codes[12356] = 0x000132793b9d8b6dUL;
   tf->codes[12357] = 0x000132981d099650UL;
   tf->codes[12358] = 0x0001329d2554153eUL;
   tf->codes[12359] = 0x0001329e84ae37dcUL;
   tf->codes[12360] = 0x0001329f345b492bUL;
   tf->codes[12361] = 0x000132a093b56bc9UL;
   tf->codes[12362] = 0x000132a90a614142UL;
   tf->codes[12363] = 0x000132ab53f77af4UL;
   tf->codes[12364] = 0x000132b529fd730bUL;
   tf->codes[12365] = 0x000132b6895795a9UL;
   tf->codes[12366] = 0x000132b8d2edcf5bUL;
   tf->codes[12367] = 0x000132bae1f50348UL;
   tf->codes[12368] = 0x000132c3cdbee44bUL;
   tf->codes[12369] = 0x000132dc82155367UL;
   tf->codes[12370] = 0x000132de1bfe7bcaUL;
   tf->codes[12371] = 0x000132eab0b8b91dUL;
   tf->codes[12372] = 0x000132eaeb47bee2UL;
   tf->codes[12373] = 0x000132eb6065ca6cUL;
   tf->codes[12374] = 0x000132f068b0495aUL;
   tf->codes[12375] = 0x000132f620a7d997UL;
   tf->codes[12376] = 0x000132fab3d44cfbUL;
   tf->codes[12377] = 0x000132fdad1797fcUL;
   tf->codes[12378] = 0x0001330ab6efe0d9UL;
   tf->codes[12379] = 0x0001330c50d9093cUL;
   tf->codes[12380] = 0x00013313dd48c7a1UL;
   tf->codes[12381] = 0x000133145266d32bUL;
   tf->codes[12382] = 0x00013316616e0718UL;
   tf->codes[12383] = 0x0001332121b01643UL;
   tf->codes[12384] = 0x00013325b4dc89a7UL;
   tf->codes[12385] = 0x0001332ea0a66aaaUL;
   tf->codes[12386] = 0x0001333a10958b24UL;
   tf->codes[12387] = 0x0001333c1f9cbf11UL;
   tf->codes[12388] = 0x00013343ac0c7d76UL;
   tf->codes[12389] = 0x000133449648948aUL;
   tf->codes[12390] = 0x00013352ff7b0005UL;
   tf->codes[12391] = 0x000133550e8233f2UL;
   tf->codes[12392] = 0x00013356e2fa621aUL;
   tf->codes[12393] = 0x000133592c909bccUL;
   tf->codes[12394] = 0x0001335a515bb8a5UL;
   tf->codes[12395] = 0x0001335bb0b5db43UL;
   tf->codes[12396] = 0x0001335beb44e108UL;
   tf->codes[12397] = 0x000133607e71546cUL;
   tf->codes[12398] = 0x000133687fff1e5bUL;
   tf->codes[12399] = 0x0001336ac995580dUL;
   tf->codes[12400] = 0x0001336ead14ba22UL;
   tf->codes[12401] = 0x000133796d56c94dUL;
   tf->codes[12402] = 0x0001337accb0ebebUL;
   tf->codes[12403] = 0x0001337c669a144eUL;
   tf->codes[12404] = 0x000133804a197663UL;
   tf->codes[12405] = 0x0001338084a87c28UL;
   tf->codes[12406] = 0x0001338886364617UL;
   tf->codes[12407] = 0x0001338acfcc7fc9UL;
   tf->codes[12408] = 0x0001339346785542UL;
   tf->codes[12409] = 0x0001339d919c58e3UL;
   tf->codes[12410] = 0x000133a0c56ea9a9UL;
   tf->codes[12411] = 0x000133a46e5f05f9UL;
   tf->codes[12412] = 0x000133b4ac099f9cUL;
   tf->codes[12413] = 0x000133bb4e3d46edUL;
   tf->codes[12414] = 0x000133bbfdea583cUL;
   tf->codes[12415] = 0x000133bf31bca902UL;
   tf->codes[12416] = 0x000133c60e7f5618UL;
   tf->codes[12417] = 0x000133c6839d61a2UL;
   tf->codes[12418] = 0x000133d1b8fd7c57UL;
   tf->codes[12419] = 0x000133d820a21de3UL;
   tf->codes[12420] = 0x000133de8846bf6fUL;
   tf->codes[12421] = 0x000133e231371bbfUL;
   tf->codes[12422] = 0x000133e2a6552749UL;
   tf->codes[12423] = 0x000133e4efeb60fbUL;
   tf->codes[12424] = 0x000133e59f98724aUL;
   tf->codes[12425] = 0x000133f408caddc5UL;
   tf->codes[12426] = 0x000133f47de8e94fUL;
   tf->codes[12427] = 0x000133f4b877ef14UL;
   tf->codes[12428] = 0x000133f5a2b40628UL;
   tf->codes[12429] = 0x000133f7ec4a3fdaUL;
   tf->codes[12430] = 0x000134009d851b18UL;
   tf->codes[12431] = 0x0001340446757768UL;
   tf->codes[12432] = 0x00013405e05e9fcbUL;
   tf->codes[12433] = 0x00013406557cab55UL;
   tf->codes[12434] = 0x000134094ebff656UL;
   tf->codes[12435] = 0x0001341449910b46UL;
   tf->codes[12436] = 0x00013418679f7320UL;
   tf->codes[12437] = 0x000134244cac9f24UL;
   tf->codes[12438] = 0x00013425ac06c1c2UL;
   tf->codes[12439] = 0x0001342745efea25UL;
   tf->codes[12440] = 0x00013428302c0139UL;
   tf->codes[12441] = 0x00013441cebe8769UL;
   tf->codes[12442] = 0x0001344243dc92f3UL;
   tf->codes[12443] = 0x00013445b23de97eUL;
   tf->codes[12444] = 0x00013448ab81347fUL;
   tf->codes[12445] = 0x00013449209f4009UL;
   tf->codes[12446] = 0x0001344995bd4b93UL;
   tf->codes[12447] = 0x0001344b2fa673f6UL;
   tf->codes[12448] = 0x0001345331343de5UL;
   tf->codes[12449] = 0x000134595e49d9acUL;
   tf->codes[12450] = 0x0001345e6694589aUL;
   tf->codes[12451] = 0x00013472c24d5a17UL;
   tf->codes[12452] = 0x000134754672998eUL;
   tf->codes[12453] = 0x000134845f521658UL;
   tf->codes[12454] = 0x000134887d607e32UL;
   tf->codes[12455] = 0x00013488f27e89bcUL;
   tf->codes[12456] = 0x000134980b5e0686UL;
   tf->codes[12457] = 0x00013499dfd634aeUL;
   tf->codes[12458] = 0x000134a0bc98e1c4UL;
   tf->codes[12459] = 0x000134a4a01843d9UL;
   tf->codes[12460] = 0x000134b2942ca3caUL;
   tf->codes[12461] = 0x000134bf6375e6e2UL;
   tf->codes[12462] = 0x000134bfd893f26cUL;
   tf->codes[12463] = 0x000134c1e79b2659UL;
   tf->codes[12464] = 0x000134c6efe5a547UL;
   tf->codes[12465] = 0x000134c9397bdef9UL;
   tf->codes[12466] = 0x000134cbbda11e70UL;
   tf->codes[12467] = 0x000134d1eab6ba37UL;
   tf->codes[12468] = 0x000134d593a71687UL;
   tf->codes[12469] = 0x000134de7f70f78aUL;
   tf->codes[12470] = 0x000134e053e925b2UL;
   tf->codes[12471] = 0x000134e7a5c9de52UL;
   tf->codes[12472] = 0x000134ebc3d8462cUL;
   tf->codes[12473] = 0x000135026927815bUL;
   tf->codes[12474] = 0x00013506fc53f4bfUL;
   tf->codes[12475] = 0x0001350aa544510fUL;
   tf->codes[12476] = 0x00013518d3e7b6c5UL;
   tf->codes[12477] = 0x000135356bbd87f6UL;
   tf->codes[12478] = 0x000135389f8fd8bcUL;
   tf->codes[12479] = 0x000135394f3cea0bUL;
   tf->codes[12480] = 0x0001353b5e441df8UL;
   tf->codes[12481] = 0x0001353da7da57aaUL;
   tf->codes[12482] = 0x0001354bd67dbd60UL;
   tf->codes[12483] = 0x0001354e2013f712UL;
   tf->codes[12484] = 0x00013558a5c70078UL;
   tf->codes[12485] = 0x000135599003178cUL;
   tf->codes[12486] = 0x0001355c14285703UL;
   tf->codes[12487] = 0x0001355d738279a1UL;
   tf->codes[12488] = 0x00013564fff23806UL;
   tf->codes[12489] = 0x00013567498871b8UL;
   tf->codes[12490] = 0x000135857b476b4cUL;
   tf->codes[12491] = 0x00013597c7f938dcUL;
   tf->codes[12492] = 0x0001359927535b7aUL;
   tf->codes[12493] = 0x000135a6a649afe1UL;
   tf->codes[12494] = 0x000135a964fdf51dUL;
   tf->codes[12495] = 0x000135a99f8cfae2UL;
   tf->codes[12496] = 0x000135aa4f3a0c31UL;
   tf->codes[12497] = 0x000135b1668bbf0cUL;
   tf->codes[12498] = 0x000135b634473835UL;
   tf->codes[12499] = 0x000135b8f2fb7d71UL;
   tf->codes[12500] = 0x000135b92d8a8336UL;
   tf->codes[12501] = 0x000135bb0202b15eUL;
   tf->codes[12502] = 0x000135bbec3ec872UL;
   tf->codes[12503] = 0x000135c80bdafa3bUL;
   tf->codes[12504] = 0x000135c96b351cd9UL;
   tf->codes[12505] = 0x000135d6af9c6b7bUL;
   tf->codes[12506] = 0x000135d7d4678854UL;
   tf->codes[12507] = 0x000135d8498593deUL;
   tf->codes[12508] = 0x000135e294a9977fUL;
   tf->codes[12509] = 0x000135e3f403ba1dUL;
   tf->codes[12510] = 0x000135e8fc4e390bUL;
   tf->codes[12511] = 0x000135fa2434e9c2UL;
   tf->codes[12512] = 0x00013603fa3ae1d9UL;
   tf->codes[12513] = 0x0001360977a36c51UL;
   tf->codes[12514] = 0x00013615973f9e1aUL;
   tf->codes[12515] = 0x00013616bc0abaf3UL;
   tf->codes[12516] = 0x00013623c5e303d0UL;
   tf->codes[12517] = 0x000136352858ba4cUL;
   tf->codes[12518] = 0x00013635d805cb9bUL;
   tf->codes[12519] = 0x00013654f400dc43UL;
   tf->codes[12520] = 0x0001365cf58ea632UL;
   tf->codes[12521] = 0x00013671c665b339UL;
   tf->codes[12522] = 0x00013676ceb03227UL;
   tf->codes[12523] = 0x0001367b61dca58bUL;
   tf->codes[12524] = 0x000136806a272479UL;
   tf->codes[12525] = 0x0001368119d435c8UL;
   tf->codes[12526] = 0x0001368955f1057cUL;
   tf->codes[12527] = 0x00013695eaab42cfUL;
   tf->codes[12528] = 0x0001369d3c8bfb6fUL;
   tf->codes[12529] = 0x000136a0e57c57bfUL;
   tf->codes[12530] = 0x000136a787afff10UL;
   tf->codes[12531] = 0x000136aba5be66eaUL;
   tf->codes[12532] = 0x000136c78de726ccUL;
   tf->codes[12533] = 0x000136d6e155a95bUL;
   tf->codes[12534] = 0x000136d9657ae8d2UL;
   tf->codes[12535] = 0x000136dc994d3998UL;
   tf->codes[12536] = 0x000136f16a24469fUL;
   tf->codes[12537] = 0x000136fcda136719UL;
   tf->codes[12538] = 0x000136feae8b9541UL;
   tf->codes[12539] = 0x00013703072902e0UL;
   tf->codes[12540] = 0x00013705163036cdUL;
   tf->codes[12541] = 0x000137080f7381ceUL;
   tf->codes[12542] = 0x0001370884918d58UL;
   tf->codes[12543] = 0x00013718c23c26fbUL;
   tf->codes[12544] = 0x0001371ad1435ae8UL;
   tf->codes[12545] = 0x0001371b46616672UL;
   tf->codes[12546] = 0x00013736b96c1acaUL;
   tf->codes[12547] = 0x00013737a3a831deUL;
   tf->codes[12548] = 0x000137388de448f2UL;
   tf->codes[12549] = 0x00013744e80f8080UL;
   tf->codes[12550] = 0x00013751f1e7c95dUL;
   tf->codes[12551] = 0x000137564a8536fcUL;
   tf->codes[12552] = 0x0001375bc7edc174UL;
   tf->codes[12553] = 0x000137656364b3c6UL;
   tf->codes[12554] = 0x0001376f73f9b1a2UL;
   tf->codes[12555] = 0x000137705e35c8b6UL;
   tf->codes[12556] = 0x00013789c2394921UL;
   tf->codes[12557] = 0x00013790d98afbfcUL;
   tf->codes[12558] = 0x0001379ff26a78c6UL;
   tf->codes[12559] = 0x000137a65a0f1a52UL;
   tf->codes[12560] = 0x000137a709bc2ba1UL;
   tf->codes[12561] = 0x000137ca43c5a423UL;
   tf->codes[12562] = 0x000137d8726909d9UL;
   tf->codes[12563] = 0x000137deda0dab65UL;
   tf->codes[12564] = 0x000137df89babcb4UL;
   tf->codes[12565] = 0x000137e282fe07b5UL;
   tf->codes[12566] = 0x000137e3e2582a53UL;
   tf->codes[12567] = 0x000137e4577635ddUL;
   tf->codes[12568] = 0x000137e80066922dUL;
   tf->codes[12569] = 0x000137e8b013a37cUL;
   tf->codes[12570] = 0x000137ea49fccbdfUL;
   tf->codes[12571] = 0x000137eabf1ad769UL;
   tf->codes[12572] = 0x000137f83e112bd0UL;
   tf->codes[12573] = 0x000138045dad5d99UL;
   tf->codes[12574] = 0x000138092b68d6c2UL;
   tf->codes[12575] = 0x0001380f587e7289UL;
   tf->codes[12576] = 0x00013810b7d89527UL;
   tf->codes[12577] = 0x00013813768cda63UL;
   tf->codes[12578] = 0x000138142639ebb2UL;
   tf->codes[12579] = 0x0001381ee67bfaddUL;
   tf->codes[12580] = 0x00013843ba6e9bc2UL;
   tf->codes[12581] = 0x00013853bd8a2fa0UL;
   tf->codes[12582] = 0x000138567c3e74dcUL;
   tf->codes[12583] = 0x00013862d669ac6aUL;
   tf->codes[12584] = 0x0001386769961fceUL;
   tf->codes[12585] = 0x0001386a9d687094UL;
   tf->codes[12586] = 0x0001386ad7f77659UL;
   tf->codes[12587] = 0x0001386d96abbb95UL;
   tf->codes[12588] = 0x00013876f793a822UL;
   tf->codes[12589] = 0x0001387b503115c1UL;
   tf->codes[12590] = 0x000138810828a5feUL;
   tf->codes[12591] = 0x0001388142b7abc3UL;
   tf->codes[12592] = 0x00013883172fd9ebUL;
   tf->codes[12593] = 0x0001388909b66fedUL;
   tf->codes[12594] = 0x00013897e806e6f2UL;
   tf->codes[12595] = 0x0001389897b3f841UL;
   tf->codes[12596] = 0x0001389a6c2c2669UL;
   tf->codes[12597] = 0x0001389eff5899cdUL;
   tf->codes[12598] = 0x0001389f39e79f92UL;
   tf->codes[12599] = 0x000138a616aa4ca8UL;
   tf->codes[12600] = 0x000138c8a106b3dbUL;
   tf->codes[12601] = 0x000138d410f5d455UL;
   tf->codes[12602] = 0x000138db9d6592baUL;
   tf->codes[12603] = 0x000138df80e4f4cfUL;
   tf->codes[12604] = 0x000138e0e03f176dUL;
   tf->codes[12605] = 0x000138e4c3be7982UL;
   tf->codes[12606] = 0x000138e747e3b8f9UL;
   tf->codes[12607] = 0x000138ecffdb4936UL;
   tf->codes[12608] = 0x000138fb690db4b1UL;
   tf->codes[12609] = 0x00013907138bdaf0UL;
   tf->codes[12610] = 0x00013909d240202cUL;
   tf->codes[12611] = 0x0001390abc7c3740UL;
   tf->codes[12612] = 0x00013914cd11351cUL;
   tf->codes[12613] = 0x00013925454ad484UL;
   tf->codes[12614] = 0x00013926a4a4f722UL;
   tf->codes[12615] = 0x0001392ac2b35efcUL;
   tf->codes[12616] = 0x000139321494179cUL;
   tf->codes[12617] = 0x00013935f81379b1UL;
   tf->codes[12618] = 0x0001393bb00b09eeUL;
   tf->codes[12619] = 0x000139407dc68317UL;
   tf->codes[12620] = 0x000139471ffa2a68UL;
   tf->codes[12621] = 0x0001395dc5496597UL;
   tf->codes[12622] = 0x0001395fd4509984UL;
   tf->codes[12623] = 0x00013966eba24c5fUL;
   tf->codes[12624] = 0x0001396a1f749d25UL;
   tf->codes[12625] = 0x0001396e3d8304ffUL;
   tf->codes[12626] = 0x00013977294ce602UL;
   tf->codes[12627] = 0x00013988513396b9UL;
   tf->codes[12628] = 0x00013989b08db957UL;
   tf->codes[12629] = 0x00013997a4a21948UL;
   tf->codes[12630] = 0x0001399fa62fe337UL;
   tf->codes[12631] = 0x000139a3c43e4b11UL;
   tf->codes[12632] = 0x000139a55e277374UL;
   tf->codes[12633] = 0x000139b7e56846c9UL;
   tf->codes[12634] = 0x000139bfac670af3UL;
   tf->codes[12635] = 0x000139c7e883daa7UL;
   tf->codes[12636] = 0x000139cbcc033cbcUL;
   tf->codes[12637] = 0x000139d5a20934d3UL;
   tf->codes[12638] = 0x000139d7eb9f6e85UL;
   tf->codes[12639] = 0x000139e09cda49c3UL;
   tf->codes[12640] = 0x000139e6c9efe58aUL;
   tf->codes[12641] = 0x000139e913861f3cUL;
   tf->codes[12642] = 0x000139e9fdc23650UL;
   tf->codes[12643] = 0x00013a0695980781UL;
   tf->codes[12644] = 0x00013a1155da16acUL;
   tf->codes[12645] = 0x00013a1c8b3a3161UL;
   tf->codes[12646] = 0x00013a1dea9453ffUL;
   tf->codes[12647] = 0x00013a2a0a3085c8UL;
   tf->codes[12648] = 0x00013a2a7f4e9152UL;
   tf->codes[12649] = 0x00013a2c1937b9b5UL;
   tf->codes[12650] = 0x00013a35ef3db1ccUL;
   tf->codes[12651] = 0x00013a3b6ca63c44UL;
   tf->codes[12652] = 0x00013a4b3532ca5dUL;
   tf->codes[12653] = 0x00013a53714f9a11UL;
   tf->codes[12654] = 0x00013a578f5e01ebUL;
   tf->codes[12655] = 0x00013a5a4e124727UL;
   tf->codes[12656] = 0x00013a742733d31cUL;
   tf->codes[12657] = 0x00013a77959529a7UL;
   tf->codes[12658] = 0x00013a7b03f68032UL;
   tf->codes[12659] = 0x00013a7c6350a2d0UL;
   tf->codes[12660] = 0x00013a7dc2aac56eUL;
   tf->codes[12661] = 0x00013a916eb6b59cUL;
   tf->codes[12662] = 0x00013a91e3d4c126UL;
   tf->codes[12663] = 0x00013a95523617b1UL;
   tf->codes[12664] = 0x00013aa25c0e608eUL;
   tf->codes[12665] = 0x00013aab0d493bccUL;
   tf->codes[12666] = 0x00013ab2d447fff6UL;
   tf->codes[12667] = 0x00013ab6b7c7620bUL;
   tf->codes[12668] = 0x00013ac6f571fbaeUL;
   tf->codes[12669] = 0x00013ac730010173UL;
   tf->codes[12670] = 0x00013acfa6acd6ecUL;
   tf->codes[12671] = 0x00013ad439d94a50UL;
   tf->codes[12672] = 0x00013ada2c5fe052UL;
   tf->codes[12673] = 0x00013ade0fdf4267UL;
   tf->codes[12674] = 0x00013ae0940481deUL;
   tf->codes[12675] = 0x00013aebc9649c93UL;
   tf->codes[12676] = 0x00013afae244195dUL;
   tf->codes[12677] = 0x00013b0d6984ecb2UL;
   tf->codes[12678] = 0x00013b19c3b02440UL;
   tf->codes[12679] = 0x00013b1bd2b7582dUL;
   tf->codes[12680] = 0x00013b261ddb5bceUL;
   tf->codes[12681] = 0x00013b3e97a2c525UL;
   tf->codes[12682] = 0x00013b3ed231caeaUL;
   tf->codes[12683] = 0x00013b3ff6fce7c3UL;
   tf->codes[12684] = 0x00013b44150b4f9dUL;
   tf->codes[12685] = 0x00013b457465723bUL;
   tf->codes[12686] = 0x00013b45e9837dc5UL;
   tf->codes[12687] = 0x00013b5aba5a8accUL;
   tf->codes[12688] = 0x00013b615c8e321dUL;
   tf->codes[12689] = 0x00013b671485c25aUL;
   tf->codes[12690] = 0x00013b741e5e0b37UL;
   tf->codes[12691] = 0x00013b78ec198460UL;
   tf->codes[12692] = 0x00013b7b35afbe12UL;
   tf->codes[12693] = 0x00013b95be7e5b56UL;
   tf->codes[12694] = 0x00013b9beb93f71dUL;
   tf->codes[12695] = 0x00013b9dfa9b2b0aUL;
   tf->codes[12696] = 0x00013b9e6fb93694UL;
   tf->codes[12697] = 0x00013ba6abd60648UL;
   tf->codes[12698] = 0x00013baac9e46e22UL;
   tf->codes[12699] = 0x00013bbbf1cb1ed9UL;
   tf->codes[12700] = 0x00013bbe3b61588bUL;
   tf->codes[12701] = 0x00013bc134a4a38cUL;
   tf->codes[12702] = 0x00013bc343abd779UL;
   tf->codes[12703] = 0x00013bc4dd94ffdcUL;
   tf->codes[12704] = 0x00013bcad01b95deUL;
   tf->codes[12705] = 0x00013bd51b3f997fUL;
   tf->codes[12706] = 0x00013bd6057bb093UL;
   tf->codes[12707] = 0x00013bdeb6b68bd1UL;
   tf->codes[12708] = 0x00013be5937938e7UL;
   tf->codes[12709] = 0x00013be72d62614aUL;
   tf->codes[12710] = 0x00013bebc08ed4aeUL;
   tf->codes[12711] = 0x00013bf7a59c00b2UL;
   tf->codes[12712] = 0x00013c00cbf4e77aUL;
   tf->codes[12713] = 0x00013c0b8c36f6a5UL;
   tf->codes[12714] = 0x00013c0bc6c5fc6aUL;
   tf->codes[12715] = 0x00013c15d75afa46UL;
   tf->codes[12716] = 0x00013c1c0470960dUL;
   tf->codes[12717] = 0x00013c489f61fb1cUL;
   tf->codes[12718] = 0x00013c5de55713adUL;
   tf->codes[12719] = 0x00013c662173e361UL;
   tf->codes[12720] = 0x00013c68e028289dUL;
   tf->codes[12721] = 0x00013c71cbf209a0UL;
   tf->codes[12722] = 0x00013c7783e999ddUL;
   tf->codes[12723] = 0x00013c78a8b4b6b6UL;
   tf->codes[12724] = 0x00013c7d01522455UL;
   tf->codes[12725] = 0x00013c7fc0066991UL;
   tf->codes[12726] = 0x00013c848dc1e2baUL;
   tf->codes[12727] = 0x00013c8bdfa29b5aUL;
   tf->codes[12728] = 0x00013c962ac69efbUL;
   tf->codes[12729] = 0x00013c9a48d506d5UL;
   tf->codes[12730] = 0x00013c9ea1727474UL;
   tf->codes[12731] = 0x00013cabab4abd51UL;
   tf->codes[12732] = 0x00013cbea7a99c30UL;
   tf->codes[12733] = 0x00013cc4d4bf37f7UL;
   tf->codes[12734] = 0x00013cd5c216e2e9UL;
   tf->codes[12735] = 0x00013cd880cb2825UL;
   tf->codes[12736] = 0x00013cda8fd25c12UL;
   tf->codes[12737] = 0x00013cdd13f79b89UL;
   tf->codes[12738] = 0x00013ce0f776fd9eUL;
   tf->codes[12739] = 0x00013ce16c950928UL;
   tf->codes[12740] = 0x00013ce7d439aab4UL;
   tf->codes[12741] = 0x00013ce9e340dea1UL;
   tf->codes[12742] = 0x00013cf602dd106aUL;
   tf->codes[12743] = 0x00013cf9713e66f5UL;
   tf->codes[12744] = 0x00013d00c31f1f95UL;
   tf->codes[12745] = 0x00013d097459fad3UL;
   tf->codes[12746] = 0x00013d0c6d9d45d4UL;
   tf->codes[12747] = 0x00013d122594d611UL;
   tf->codes[12748] = 0x00013d1f69fc24b3UL;
   tf->codes[12749] = 0x00013d260c2fcc04UL;
   tf->codes[12750] = 0x00013d2890550b7bUL;
   tf->codes[12751] = 0x00013d2bc4275c41UL;
   tf->codes[12752] = 0x00013d490baa3ec1UL;
   tf->codes[12753] = 0x00013d49f5e655d5UL;
   tf->codes[12754] = 0x00013d4bca5e83fdUL;
   tf->codes[12755] = 0x00013d5cf24534b4UL;
   tf->codes[12756] = 0x00013d652e620468UL;
   tf->codes[12757] = 0x00013d844a5d1510UL;
   tf->codes[12758] = 0x00013d882ddc7725UL;
   tf->codes[12759] = 0x00013d9537b4c002UL;
   tf->codes[12760] = 0x00013da8a931aa6bUL;
   tf->codes[12761] = 0x00013dbfc39ef124UL;
   tf->codes[12762] = 0x00013dc62b4392b0UL;
   tf->codes[12763] = 0x00013dd49475fe2bUL;
   tf->codes[12764] = 0x00013ddafc1a9fb7UL;
   tf->codes[12765] = 0x00013de2136c5292UL;
   tf->codes[12766] = 0x00013de42273867fUL;
   tf->codes[12767] = 0x00013de9da6b16bcUL;
   tf->codes[12768] = 0x00013df6a9b459d4UL;
   tf->codes[12769] = 0x00013df7ce7f76adUL;
   tf->codes[12770] = 0x00013e116d11fcddUL;
   tf->codes[12771] = 0x00013e14db735368UL;
   tf->codes[12772] = 0x00013e225a69a7cfUL;
   tf->codes[12773] = 0x00013e38ffb8e2feUL;
   tf->codes[12774] = 0x00013e3e429267b1UL;
   tf->codes[12775] = 0x00013e429b2fd550UL;
   tf->codes[12776] = 0x00013e45cf022616UL;
   tf->codes[12777] = 0x00013e56bc59d108UL;
   tf->codes[12778] = 0x00013e61420cda6eUL;
   tf->codes[12779] = 0x00013e7aa6105ad9UL;
   tf->codes[12780] = 0x00013e7d2a359a50UL;
   tf->codes[12781] = 0x00013e814844022aUL;
   tf->codes[12782] = 0x00013e92aab9b8a6UL;
   tf->codes[12783] = 0x00013e99877c65bcUL;
   tf->codes[12784] = 0x00013e9de019d35bUL;
   tf->codes[12785] = 0x00013ea0d95d1e5cUL;
   tf->codes[12786] = 0x00013ea113ec2421UL;
   tf->codes[12787] = 0x00013ea8daeae84bUL;
   tf->codes[12788] = 0x00013eaa3a450ae9UL;
   tf->codes[12789] = 0x00013eaae9f21c38UL;
   tf->codes[12790] = 0x00013eab248121fdUL;
   tf->codes[12791] = 0x00013ebf45ab1db5UL;
   tf->codes[12792] = 0x00013ec11a234bddUL;
   tf->codes[12793] = 0x00013ec8a6930a42UL;
   tf->codes[12794] = 0x00013ecaf02943f4UL;
   tf->codes[12795] = 0x00013ecc8a126c57UL;
   tf->codes[12796] = 0x00013ece23fb94baUL;
   tf->codes[12797] = 0x00013ed7bf72870cUL;
   tf->codes[12798] = 0x00013ed8a9ae9e20UL;
   tf->codes[12799] = 0x00013ede9c353422UL;
   tf->codes[12800] = 0x00013ef5b6a27adbUL;
   tf->codes[12801] = 0x00013efd0883337bUL;
   tf->codes[12802] = 0x00013f145d7f7ff9UL;
   tf->codes[12803] = 0x00013f1547bb970dUL;
   tf->codes[12804] = 0x00013f15f768a85cUL;
   tf->codes[12805] = 0x00013f1c247e4423UL;
   tf->codes[12806] = 0x00013f1f585094e9UL;
   tf->codes[12807] = 0x00013f249b2a199cUL;
   tf->codes[12808] = 0x00013f2a1892a414UL;
   tf->codes[12809] = 0x00013f32c9cd7f52UL;
   tf->codes[12810] = 0x00013f33045c8517UL;
   tf->codes[12811] = 0x00013f53ba40be22UL;
   tf->codes[12812] = 0x00013f61ae551e13UL;
   tf->codes[12813] = 0x00013f697553e23dUL;
   tf->codes[12814] = 0x00013f743595f168UL;
   tf->codes[12815] = 0x00013f7e462aef44UL;
   tf->codes[12816] = 0x00013f8a65c7210dUL;
   tf->codes[12817] = 0x00013f97e4bd7574UL;
   tf->codes[12818] = 0x00013fa6fd9cf23eUL;
   tf->codes[12819] = 0x00013fa9bc51377aUL;
   tf->codes[12820] = 0x00013fb1bddf0169UL;
   tf->codes[12821] = 0x00013fb7b065976bUL;
   tf->codes[12822] = 0x00013fbbce73ff45UL;
   tf->codes[12823] = 0x00013fc6542708abUL;
   tf->codes[12824] = 0x00013fda0032f8d9UL;
   tf->codes[12825] = 0x00013fe61fcf2aa2UL;
   tf->codes[12826] = 0x00013ff91c2e0981UL;
   tf->codes[12827] = 0x00013ff9914c150bUL;
   tf->codes[12828] = 0x000140053bca3b4aUL;
   tf->codes[12829] = 0x00014007fa7e8086UL;
   tf->codes[12830] = 0x0001400bddfde29bUL;
   tf->codes[12831] = 0x0001400f4c5f3926UL;
   tf->codes[12832] = 0x000140141a1ab24fUL;
   tf->codes[12833] = 0x00014017887c08daUL;
   tf->codes[12834] = 0x000140207445e9ddUL;
   tf->codes[12835] = 0x00014027510896f3UL;
   tf->codes[12836] = 0x00014029d52dd66aUL;
   tf->codes[12837] = 0x0001403cd18cb549UL;
   tf->codes[12838] = 0x00014049db64fe26UL;
   tf->codes[12839] = 0x0001404ac5a1153aUL;
   tf->codes[12840] = 0x0001405c2816cbb6UL;
   tf->codes[12841] = 0x00014060f5d244dfUL;
   tf->codes[12842] = 0x00014061e00e5bf3UL;
   tf->codes[12843] = 0x000140696c7e1a58UL;
   tf->codes[12844] = 0x0001406bf0a359cfUL;
   tf->codes[12845] = 0x00014073f23123beUL;
   tf->codes[12846] = 0x00014085c9c4e5c4UL;
   tf->codes[12847] = 0x000140884dea253bUL;
   tf->codes[12848] = 0x000140967c8d8af1UL;
   tf->codes[12849] = 0x000140a1ec7cab6bUL;
   tf->codes[12850] = 0x000140a31147c844UL;
   tf->codes[12851] = 0x000140a4e5bff66cUL;
   tf->codes[12852] = 0x000140a769e535e3UL;
   tf->codes[12853] = 0x000140b94178f7e9UL;
   tf->codes[12854] = 0x000140c10877bc13UL;
   tf->codes[12855] = 0x000140d7adc6f742UL;
   tf->codes[12856] = 0x000140e9bfe9bf0dUL;
   tf->codes[12857] = 0x000140f4babad3fdUL;
   tf->codes[12858] = 0x000140f6c9c207eaUL;
   tf->codes[12859] = 0x000141018a041715UL;
   tf->codes[12860] = 0x000141091673d57aUL;
   tf->codes[12861] = 0x0001410de42f4ea3UL;
   tf->codes[12862] = 0x000141144bd3f02fUL;
   tf->codes[12863] = 0x0001411f81340ae4UL;
   tf->codes[12864] = 0x0001411ff652166eUL;
   tf->codes[12865] = 0x0001412991c908c0UL;
   tf->codes[12866] = 0x0001413a0a02a828UL;
   tf->codes[12867] = 0x0001413e28111002UL;
   tf->codes[12868] = 0x000141436aea94b5UL;
   tf->codes[12869] = 0x00014148adc41968UL;
   tf->codes[12870] = 0x0001414f1568baf4UL;
   tf->codes[12871] = 0x000141515efef4a6UL;
   tf->codes[12872] = 0x0001415751858aa8UL;
   tf->codes[12873] = 0x0001415925fdb8d0UL;
   tf->codes[12874] = 0x0001415b6f93f282UL;
   tf->codes[12875] = 0x000141654599ea99UL;
   tf->codes[12876] = 0x0001416a135563c2UL;
   tf->codes[12877] = 0x0001417ee42c70c9UL;
   tf->codes[12878] = 0x00014181dd6fbbcaUL;
   tf->codes[12879] = 0x00014182c7abd2deUL;
   tf->codes[12880] = 0x000141a79b9e73c3UL;
   tf->codes[12881] = 0x000141af9d2c3db2UL;
   tf->codes[12882] = 0x000141b4e005c265UL;
   tf->codes[12883] = 0x000141b679eeeac8UL;
   tf->codes[12884] = 0x000141b84e6718f0UL;
   tf->codes[12885] = 0x000141b938a33004UL;
   tf->codes[12886] = 0x000141beb60bba7cUL;
   tf->codes[12887] = 0x000141bfdad6d755UL;
   tf->codes[12888] = 0x000141c1af4f057dUL;
   tf->codes[12889] = 0x000141c5cd5d6d57UL;
   tf->codes[12890] = 0x000141c88c11b293UL;
   tf->codes[12891] = 0x000141cb1036f20aUL;
   tf->codes[12892] = 0x000141e01b9d04d6UL;
   tf->codes[12893] = 0x000141e857b9d48aUL;
   tf->codes[12894] = 0x000141fa2f4d9690UL;
   tf->codes[12895] = 0x00014201469f496bUL;
   tf->codes[12896] = 0x000142110f2bd784UL;
   tf->codes[12897] = 0x00014214b81c33d4UL;
   tf->codes[12898] = 0x00014218267d8a5fUL;
   tf->codes[12899] = 0x000142189b9b95e9UL;
   tf->codes[12900] = 0x0001421b5a4fdb25UL;
   tf->codes[12901] = 0x0001422112476b62UL;
   tf->codes[12902] = 0x00014221876576ecUL;
   tf->codes[12903] = 0x000142244619bc28UL;
   tf->codes[12904] = 0x00014225a573dec6UL;
   tf->codes[12905] = 0x000142261a91ea50UL;
   tf->codes[12906] = 0x0001423399883eb7UL;
   tf->codes[12907] = 0x000142361dad7e2eUL;
   tf->codes[12908] = 0x0001423f09775f31UL;
   tf->codes[12909] = 0x00014241530d98e3UL;
   tf->codes[12910] = 0x000142465b5817d1UL;
   tf->codes[12911] = 0x0001424695e71d96UL;
   tf->codes[12912] = 0x00014247f5414034UL;
   tf->codes[12913] = 0x00014248df7d5748UL;
   tf->codes[12914] = 0x000142749032a543UL;
   tf->codes[12915] = 0x000142769f39d930UL;
   tf->codes[12916] = 0x0001427d7bfc8646UL;
   tf->codes[12917] = 0x000142815f7be85bUL;
   tf->codes[12918] = 0x0001428e2ec52b73UL;
   tf->codes[12919] = 0x00014297551e123bUL;
   tf->codes[12920] = 0x0001429badbb7fdaUL;
   tf->codes[12921] = 0x000142a6a88c94caUL;
   tf->codes[12922] = 0x000142b49ca0f4bbUL;
   tf->codes[12923] = 0x000142b511bf0045UL;
   tf->codes[12924] = 0x000142ca92431e9bUL;
   tf->codes[12925] = 0x000142d0f9e7c027UL;
   tf->codes[12926] = 0x000142e04d5642b6UL;
   tf->codes[12927] = 0x000142e63fdcd8b8UL;
   tf->codes[12928] = 0x000142e973af297eUL;
   tf->codes[12929] = 0x000142f817709abeUL;
   tf->codes[12930] = 0x000142fa9b95da35UL;
   tf->codes[12931] = 0x000142fad624dffaUL;
   tf->codes[12932] = 0x000142fc700e085dUL;
   tf->codes[12933] = 0x0001430262949e5fUL;
   tf->codes[12934] = 0x000143031241afaeUL;
   tf->codes[12935] = 0x0001431140e51564UL;
   tf->codes[12936] = 0x0001431599828303UL;
   tf->codes[12937] = 0x0001431bc6981ecaUL;
   tf->codes[12938] = 0x0001433898fcf5c0UL;
   tf->codes[12939] = 0x00014338d38bfb85UL;
   tf->codes[12940] = 0x0001433948aa070fUL;
   tf->codes[12941] = 0x00014347022f613bUL;
   tf->codes[12942] = 0x0001434b203dc915UL;
   tf->codes[12943] = 0x000143561b0ede05UL;
   tf->codes[12944] = 0x0001435b23595cf3UL;
   tf->codes[12945] = 0x0001435d326090e0UL;
   tf->codes[12946] = 0x00014362ea58211dUL;
   tf->codes[12947] = 0x0001436324e726e2UL;
   tf->codes[12948] = 0x0001436449b243bbUL;
   tf->codes[12949] = 0x0001437f0d0fe6c4UL;
   tf->codes[12950] = 0x00014384155a65b2UL;
   tf->codes[12951] = 0x000143891da4e4a0UL;
   tf->codes[12952] = 0x0001438b2cac188dUL;
   tf->codes[12953] = 0x0001438ba1ca2417UL;
   tf->codes[12954] = 0x0001439ffd832594UL;
   tf->codes[12955] = 0x000143a4cb3e9ebdUL;
   tf->codes[12956] = 0x000143ac1d1f575dUL;
   tf->codes[12957] = 0x000143b15ff8dc10UL;
   tf->codes[12958] = 0x000143b334710a38UL;
   tf->codes[12959] = 0x000143b668435afeUL;
   tf->codes[12960] = 0x000143b7c79d7d9cUL;
   tf->codes[12961] = 0x000143b8022c8361UL;
   tf->codes[12962] = 0x000143bbab1cdfb1UL;
   tf->codes[12963] = 0x000143be2f421f28UL;
   tf->codes[12964] = 0x000143c4d175c679UL;
   tf->codes[12965] = 0x000143da176adf0aUL;
   tf->codes[12966] = 0x000143df5a4463bdUL;
   tf->codes[12967] = 0x000143e6ac251c5dUL;
   tf->codes[12968] = 0x000143eaca338437UL;
   tf->codes[12969] = 0x000143efd27e0325UL;
   tf->codes[12970] = 0x000143f3f08c6affUL;
   tf->codes[12971] = 0x000143f9e3130101UL;
   tf->codes[12972] = 0x00014400bfd5ae17UL;
   tf->codes[12973] = 0x000144063d3e388fUL;
   tf->codes[12974] = 0x0001440677cd3e54UL;
   tf->codes[12975] = 0x00014415cb3bc0e3UL;
   tf->codes[12976] = 0x0001442175b9e722UL;
   tf->codes[12977] = 0x0001442b864ee4feUL;
   tf->codes[12978] = 0x0001443bc3f97ea1UL;
   tf->codes[12979] = 0x00014444ea526569UL;
   tf->codes[12980] = 0x0001445b1a83950eUL;
   tf->codes[12981] = 0x0001445bca30a65dUL;
   tf->codes[12982] = 0x0001445d6419cec0UL;
   tf->codes[12983] = 0x0001445fadb00872UL;
   tf->codes[12984] = 0x00014464f0898d25UL;
   tf->codes[12985] = 0x0001446565a798afUL;
   tf->codes[12986] = 0x0001446bcd4c3a3bUL;
   tf->codes[12987] = 0x00014481885f5e56UL;
   tf->codes[12988] = 0x00014484f6c0b4e1UL;
   tf->codes[12989] = 0x0001448bd38361f7UL;
   tf->codes[12990] = 0x0001449659366b5dUL;
   tf->codes[12991] = 0x000144995279b65eUL;
   tf->codes[12992] = 0x00014499c797c1e8UL;
   tf->codes[12993] = 0x000144a53786e262UL;
   tf->codes[12994] = 0x000144b15723142bUL;
   tf->codes[12995] = 0x000144b3662a4818UL;
   tf->codes[12996] = 0x000144bf4b37741cUL;
   tf->codes[12997] = 0x000144c871905ae4UL;
   tf->codes[12998] = 0x000144c9965b77bdUL;
   tf->codes[12999] = 0x000144ca0b798347UL;
   tf->codes[13000] = 0x000144caf5b59a5bUL;
   tf->codes[13001] = 0x000144ce2987eb21UL;
   tf->codes[13002] = 0x000144ced934fc70UL;
   tf->codes[13003] = 0x000144d0731e24d3UL;
   tf->codes[13004] = 0x000144d62b15b510UL;
   tf->codes[13005] = 0x000144d6a033c09aUL;
   tf->codes[13006] = 0x000144d924590011UL;
   tf->codes[13007] = 0x000144dc1d9c4b12UL;
   tf->codes[13008] = 0x000144ddb7857375UL;
   tf->codes[13009] = 0x000144ddf214793aUL;
   tf->codes[13010] = 0x000144dfc68ca762UL;
   tf->codes[13011] = 0x000144e07639b8b1UL;
   tf->codes[13012] = 0x000144ebe628d92bUL;
   tf->codes[13013] = 0x000144f4d1f2ba2eUL;
   tf->codes[13014] = 0x000144f8b5721c43UL;
   tf->codes[13015] = 0x00014514287cd09bUL;
   tf->codes[13016] = 0x00014515fcf4fec3UL;
   tf->codes[13017] = 0x000145358e0e1af5UL;
   tf->codes[13018] = 0x00014541388c4134UL;
   tf->codes[13019] = 0x0001455e45801defUL;
   tf->codes[13020] = 0x0001456b4f5866ccUL;
   tf->codes[13021] = 0x0001456ebdb9bd57UL;
   tf->codes[13022] = 0x0001456fe284da30UL;
   tf->codes[13023] = 0x0001457f70826284UL;
   tf->codes[13024] = 0x00014581ba189c36UL;
   tf->codes[13025] = 0x00014582a454b34aUL;
   tf->codes[13026] = 0x0001459391ac5e3cUL;
   tf->codes[13027] = 0x00014595db4297eeUL;
   tf->codes[13028] = 0x0001459a33e0058dUL;
   tf->codes[13029] = 0x000145a09b84a719UL;
   tf->codes[13030] = 0x000145a185c0be2dUL;
   tf->codes[13031] = 0x000145aae6a8aabaUL;
   tf->codes[13032] = 0x000145b1c36b57d0UL;
   tf->codes[13033] = 0x000145b8dabd0aabUL;
   tf->codes[13034] = 0x000145cbd71be98aUL;
   tf->codes[13035] = 0x000145d70c7c043fUL;
   tf->codes[13036] = 0x000145da404e5505UL;
   tf->codes[13037] = 0x000145e241dc1ef4UL;
   tf->codes[13038] = 0x000145e27c6b24b9UL;
   tf->codes[13039] = 0x000145e366a73bcdUL;
   tf->codes[13040] = 0x000145e3dbc54757UL;
   tf->codes[13041] = 0x000145ea4369e8e3UL;
   tf->codes[13042] = 0x000145f6287714e7UL;
   tf->codes[13043] = 0x000145f712b32bfbUL;
   tf->codes[13044] = 0x000145f7fcef430fUL;
   tf->codes[13045] = 0x000145f8377e48d4UL;
   tf->codes[13046] = 0x000145fb6b50999aUL;
   tf->codes[13047] = 0x00014615b9903119UL;
   tf->codes[13048] = 0x000146178e085f41UL;
   tf->codes[13049] = 0x0001461bac16c71bUL;
   tf->codes[13050] = 0x00014620b4614609UL;
   tf->codes[13051] = 0x00014622c36879f6UL;
   tf->codes[13052] = 0x00014641df638a9eUL;
   tf->codes[13053] = 0x00014643794cb301UL;
   tf->codes[13054] = 0x0001464b404b772bUL;
   tf->codes[13055] = 0x000146637f83dabdUL;
   tf->codes[13056] = 0x0001466763033cd2UL;
   tf->codes[13057] = 0x0001466b0bf39922UL;
   tf->codes[13058] = 0x0001467eb7ff8950UL;
   tf->codes[13059] = 0x00014688c894872cUL;
   tf->codes[13060] = 0x0001469856920f80UL;
   tf->codes[13061] = 0x000146a38bf22a35UL;
   tf->codes[13062] = 0x000146a3c6812ffaUL;
   tf->codes[13063] = 0x000146a76f718c4aUL;
   tf->codes[13064] = 0x000146a97e78c037UL;
   tf->codes[13065] = 0x000146b59e14f200UL;
   tf->codes[13066] = 0x000146c2a7ed3addUL;
   tf->codes[13067] = 0x000146c4f183748fUL;
   tf->codes[13068] = 0x000146cbce4621a5UL;
   tf->codes[13069] = 0x000146dde068e970UL;
   tf->codes[13070] = 0x000146e61c85b924UL;
   tf->codes[13071] = 0x000146f2b13ff677UL;
   tf->codes[13072] = 0x000146f56ff43bb3UL;
   tf->codes[13073] = 0x000146fc4cb6e8c9UL;
   tf->codes[13074] = 0x000146fe5bbe1cb6UL;
   tf->codes[13075] = 0x000146ff45fa33caUL;
   tf->codes[13076] = 0x00014705e82ddb1bUL;
   tf->codes[13077] = 0x00014715eb496ef9UL;
   tf->codes[13078] = 0x0001471710148bd2UL;
   tf->codes[13079] = 0x00014718e48cb9faUL;
   tf->codes[13080] = 0x000147191f1bbfbfUL;
   tf->codes[13081] = 0x0001471f11a255c1UL;
   tf->codes[13082] = 0x0001472e2a81d28bUL;
   tf->codes[13083] = 0x00014731d3722edbUL;
   tf->codes[13084] = 0x0001473492267417UL;
   tf->codes[13085] = 0x000147499d8c86e3UL;
   tf->codes[13086] = 0x00014752c3e56dabUL;
   tf->codes[13087] = 0x0001476251e2f5ffUL;
   tf->codes[13088] = 0x0001476585b546c5UL;
   tf->codes[13089] = 0x0001476bed59e851UL;
   tf->codes[13090] = 0x00014772ca1c9567UL;
   tf->codes[13091] = 0x00014775c35fe068UL;
   tf->codes[13092] = 0x00014780be30f558UL;
   tf->codes[13093] = 0x00014784a1b0576dUL;
   tf->codes[13094] = 0x000147979e0f364cUL;
   tf->codes[13095] = 0x000147a88b66e13eUL;
   tf->codes[13096] = 0x000147abbf393204UL;
   tf->codes[13097] = 0x000147ac34573d8eUL;
   tf->codes[13098] = 0x000147bf6b452232UL;
   tf->codes[13099] = 0x000147c229f9676eUL;
   tf->codes[13100] = 0x000147cbc57059c0UL;
   tf->codes[13101] = 0x000147d9f413bf76UL;
   tf->codes[13102] = 0x000147db8dfce7d9UL;
   tf->codes[13103] = 0x000147dec1cf389fUL;
   tf->codes[13104] = 0x000147dfac0b4fb3UL;
   tf->codes[13105] = 0x000147e6fdec0853UL;
   tf->codes[13106] = 0x000147f9fa4ae732UL;
   tf->codes[13107] = 0x000147fe52e854d1UL;
   tf->codes[13108] = 0x0001480186baa597UL;
   tf->codes[13109] = 0x00014808d89b5e37UL;
   tf->codes[13110] = 0x00014815a7e4a14fUL;
   tf->codes[13111] = 0x00014817b6ebd53cUL;
   tf->codes[13112] = 0x0001482117d3c1c9UL;
   tf->codes[13113] = 0x00014835e8aaced0UL;
   tf->codes[13114] = 0x0001483e99e5aa0eUL;
   tf->codes[13115] = 0x0001484033ced271UL;
   tf->codes[13116] = 0x0001484660e46e38UL;
   tf->codes[13117] = 0x00014847facd969bUL;
   tf->codes[13118] = 0x0001485504a5df78UL;
   tf->codes[13119] = 0x0001485f153add54UL;
   tf->codes[13120] = 0x000148607494fff2UL;
   tf->codes[13121] = 0x00014867c675b892UL;
   tf->codes[13122] = 0x00014869605ee0f5UL;
   tf->codes[13123] = 0x00014871d70ab66eUL;
   tf->codes[13124] = 0x00014873ab82e496UL;
   tf->codes[13125] = 0x0001487719e43b21UL;
   tf->codes[13126] = 0x0001487a13278622UL;
   tf->codes[13127] = 0x0001487ac2d49771UL;
   tf->codes[13128] = 0x0001487c974cc599UL;
   tf->codes[13129] = 0x0001488841caebd8UL;
   tf->codes[13130] = 0x0001489461671da1UL;
   tf->codes[13131] = 0x000148975aaa68a2UL;
   tf->codes[13132] = 0x0001489bb347d641UL;
   tf->codes[13133] = 0x000148a130b060b9UL;
   tf->codes[13134] = 0x000148b58c696236UL;
   tf->codes[13135] = 0x000148be3da43d74UL;
   tf->codes[13136] = 0x000148c171768e3aUL;
   tf->codes[13137] = 0x000148c25bb2a54eUL;
   tf->codes[13138] = 0x000148c4302ad376UL;
   tf->codes[13139] = 0x000148c5ca13fbd9UL;
   tf->codes[13140] = 0x000148d51d827e68UL;
   tf->codes[13141] = 0x000148dce4814292UL;
   tf->codes[13142] = 0x000148e72fa54633UL;
   tf->codes[13143] = 0x000148eb8842b3d2UL;
   tf->codes[13144] = 0x000148f34f4177fcUL;
   tf->codes[13145] = 0x000148f76d4fdfd6UL;
   tf->codes[13146] = 0x0001490a2f1fb8f0UL;
   tf->codes[13147] = 0x00014911f61e7d1aUL;
   tf->codes[13148] = 0x000149139007a57dUL;
   tf->codes[13149] = 0x00014921498cffa9UL;
   tf->codes[13150] = 0x000149289b6db849UL;
   tf->codes[13151] = 0x0001492e8df44e4bUL;
   tf->codes[13152] = 0x00014934f598efd7UL;
   tf->codes[13153] = 0x00014937b44d3513UL;
   tf->codes[13154] = 0x0001493ecb9ee7eeUL;
   tf->codes[13155] = 0x0001493ff06a04c7UL;
   tf->codes[13156] = 0x00014957ba845ccfUL;
   tf->codes[13157] = 0x000149606bbf380dUL;
   tf->codes[13158] = 0x000149639f9188d3UL;
   tf->codes[13159] = 0x0001496c8b5b69d6UL;
   tf->codes[13160] = 0x0001497417cb283bUL;
   tf->codes[13161] = 0x00014975ec435663UL;
   tf->codes[13162] = 0x0001497db3421a8dUL;
   tf->codes[13163] = 0x0001497dedd12052UL;
   tf->codes[13164] = 0x00014988738429b8UL;
   tf->codes[13165] = 0x000149978c63a682UL;
   tf->codes[13166] = 0x00014999d5f9e034UL;
   tf->codes[13167] = 0x0001499c1f9019e6UL;
   tf->codes[13168] = 0x000149a0782d8785UL;
   tf->codes[13169] = 0x000149aac3518b26UL;
   tf->codes[13170] = 0x000149b040ba159eUL;
   tf->codes[13171] = 0x000149d9a7d929e7UL;
   tf->codes[13172] = 0x000149e0bf2adcc2UL;
   tf->codes[13173] = 0x000149e1e3f5f99bUL;
   tf->codes[13174] = 0x000149e7615e8413UL;
   tf->codes[13175] = 0x000149f221a0933eUL;
   tf->codes[13176] = 0x000149f84eb62f05UL;
   tf->codes[13177] = 0x000149fd1c71a82eUL;
   tf->codes[13178] = 0x00014a0eb976646fUL;
   tf->codes[13179] = 0x00014a14abfcfa71UL;
   tf->codes[13180] = 0x00014a1fe15d1526UL;
   tf->codes[13181] = 0x00014a201bec1aebUL;
   tf->codes[13182] = 0x00014a268390bc77UL;
   tf->codes[13183] = 0x00014a36fbca5bdfUL;
   tf->codes[13184] = 0x00014a4a6d474648UL;
   tf->codes[13185] = 0x00014a4b92126321UL;
   tf->codes[13186] = 0x00014a5234460a72UL;
   tf->codes[13187] = 0x00014a591108b788UL;
   tf->codes[13188] = 0x00014a609d7875edUL;
   tf->codes[13189] = 0x00014a69fe60627aUL;
   tf->codes[13190] = 0x00014a6a38ef683fUL;
   tf->codes[13191] = 0x00014a827827cbd1UL;
   tf->codes[13192] = 0x00014a8780724abfUL;
   tf->codes[13193] = 0x00014a969951c789UL;
   tf->codes[13194] = 0x00014a9c16ba5201UL;
   tf->codes[13195] = 0x00014a9ffa39b416UL;
   tf->codes[13196] = 0x00014aa11f04d0efUL;
   tf->codes[13197] = 0x00014aa995b0a668UL;
   tf->codes[13198] = 0x00014ab037e44db9UL;
   tf->codes[13199] = 0x00014ab62a6ae3bbUL;
   tf->codes[13200] = 0x00014ac83c8dab86UL;
   tf->codes[13201] = 0x00014ad6e04f1cc6UL;
   tf->codes[13202] = 0x00014adbae0a95efUL;
   tf->codes[13203] = 0x00014aee6fda6f09UL;
   tf->codes[13204] = 0x00014af009c3976cUL;
   tf->codes[13205] = 0x00014af5120e165aUL;
   tf->codes[13206] = 0x00014af80b51615bUL;
   tf->codes[13207] = 0x00014b037b4081d5UL;
   tf->codes[13208] = 0x00014b072430de25UL;
   tf->codes[13209] = 0x00014b16779f60b4UL;
   tf->codes[13210] = 0x00014b184c178edcUL;
   tf->codes[13211] = 0x00014b18fbc4a02bUL;
   tf->codes[13212] = 0x00014b22221d86f3UL;
   tf->codes[13213] = 0x00014b25cb0de343UL;
   tf->codes[13214] = 0x00014b37a2a1a549UL;
   tf->codes[13215] = 0x00014b41edc5a8eaUL;
   tf->codes[13216] = 0x00014b455c26ff75UL;
   tf->codes[13217] = 0x00014b52a08e4e17UL;
   tf->codes[13218] = 0x00014b7b928f56d6UL;
   tf->codes[13219] = 0x00014b7da1968ac3UL;
   tf->codes[13220] = 0x00014b82a9e109b1UL;
   tf->codes[13221] = 0x00014b83598e1b00UL;
   tf->codes[13222] = 0x00014b97059a0b2eUL;
   tf->codes[13223] = 0x00014b9914a13f1bUL;
   tf->codes[13224] = 0x00014ba1c5dc1a59UL;
   tf->codes[13225] = 0x00014baa01f8ea0dUL;
   tf->codes[13226] = 0x00014baa7716f597UL;
   tf->codes[13227] = 0x00014baaec350121UL;
   tf->codes[13228] = 0x00014babd6711835UL;
   tf->codes[13229] = 0x00014bb7bb7e4439UL;
   tf->codes[13230] = 0x00014bbd7375d476UL;
   tf->codes[13231] = 0x00014bbf47ee029eUL;
   tf->codes[13232] = 0x00014bc27bc05364UL;
   tf->codes[13233] = 0x00014bc86e46e966UL;
   tf->codes[13234] = 0x00014bd45354156aUL;
   tf->codes[13235] = 0x00014be74fb2f449UL;
   tf->codes[13236] = 0x00014be8747e1122UL;
   tf->codes[13237] = 0x00014befc65ec9c2UL;
   tf->codes[13238] = 0x00014bfa86a0d8edUL;
   tf->codes[13239] = 0x00014c02882ea2dcUL;
   tf->codes[13240] = 0x00014c0b73f883dfUL;
   tf->codes[13241] = 0x00014c1f5a9379d2UL;
   tf->codes[13242] = 0x00014c2a8ff39487UL;
   tf->codes[13243] = 0x00014c2aca829a4cUL;
   tf->codes[13244] = 0x00014c42949cf254UL;
   tf->codes[13245] = 0x00014c4309bafddeUL;
   tf->codes[13246] = 0x00014c43b9680f2dUL;
   tf->codes[13247] = 0x00014c4602fe48dfUL;
   tf->codes[13248] = 0x00014c47d7767707UL;
   tf->codes[13249] = 0x00014c48c1b28e1bUL;
   tf->codes[13250] = 0x00014c57a0030520UL;
   tf->codes[13251] = 0x00014c690278bb9cUL;
   tf->codes[13252] = 0x00014c6b4c0ef54eUL;
   tf->codes[13253] = 0x00014c7646e00a3eUL;
   tf->codes[13254] = 0x00014c77311c2152UL;
   tf->codes[13255] = 0x00014c7b149b8367UL;
   tf->codes[13256] = 0x00014c9f737018c2UL;
   tf->codes[13257] = 0x00014ca7ea1bee3bUL;
   tf->codes[13258] = 0x00014cbddfbe181bUL;
   tf->codes[13259] = 0x00014cbfb4364643UL;
   tf->codes[13260] = 0x00014ccf07a4c8d2UL;
   tf->codes[13261] = 0x00014cd4fa2b5ed4UL;
   tf->codes[13262] = 0x00014cdc117d11afUL;
   tf->codes[13263] = 0x00014ce5e78309c6UL;
   tf->codes[13264] = 0x00014cf958fff42fUL;
   tf->codes[13265] = 0x00014cfab85a16cdUL;
   tf->codes[13266] = 0x00014d015a8dbe1eUL;
   tf->codes[13267] = 0x00014d05789c25f8UL;
   tf->codes[13268] = 0x00014d14917ba2c2UL;
   tf->codes[13269] = 0x00014d16a082d6afUL;
   tf->codes[13270] = 0x00014d195f371bebUL;
   tf->codes[13271] = 0x00014d24949736a0UL;
   tf->codes[13272] = 0x00014d41dc1a1920UL;
   tf->codes[13273] = 0x00014d45fa2880faUL;
   tf->codes[13274] = 0x00014d49dda7e30fUL;
   tf->codes[13275] = 0x00014d58f6875fd9UL;
   tf->codes[13276] = 0x00014d5dc442d902UL;
   tf->codes[13277] = 0x00014d5e73efea51UL;
   tf->codes[13278] = 0x00014d5f5e2c0165UL;
   tf->codes[13279] = 0x00014d69a9500506UL;
   tf->codes[13280] = 0x00014d6bf2e63eb8UL;
   tf->codes[13281] = 0x00014d6d8ccf671bUL;
   tf->codes[13282] = 0x00014d7469921431UL;
   tf->codes[13283] = 0x00014d7eef451d97UL;
   tf->codes[13284] = 0x00014d8bbe8e60afUL;
   tf->codes[13285] = 0x00014d908c49d9d8UL;
   tf->codes[13286] = 0x00014d99ed31c665UL;
   tf->codes[13287] = 0x00014d9f6a9a50ddUL;
   tf->codes[13288] = 0x00014da054d667f1UL;
   tf->codes[13289] = 0x00014da179a184caUL;
   tf->codes[13290] = 0x00014da3c337be7cUL;
   tf->codes[13291] = 0x00014da681ec03b8UL;
   tf->codes[13292] = 0x00014db057f1fbcfUL;
   tf->codes[13293] = 0x00014db1079f0d1eUL;
   tf->codes[13294] = 0x00014db43b715de4UL;
   tf->codes[13295] = 0x00014dc10abaa0fcUL;
   tf->codes[13296] = 0x00014dc26a14c39aUL;
   tf->codes[13297] = 0x00014ddd2d7266a3UL;
   tf->codes[13298] = 0x00014ddf3c799a90UL;
   tf->codes[13299] = 0x00014df70693f298UL;
   tf->codes[13300] = 0x00014dfc496d774bUL;
   tf->codes[13301] = 0x00014dfd6e389424UL;
   tf->codes[13302] = 0x00014dff42b0c24cUL;
   tf->codes[13303] = 0x00014e04faa85289UL;
   tf->codes[13304] = 0x00014e1781e925deUL;
   tf->codes[13305] = 0x00014e1956615406UL;
   tf->codes[13306] = 0x00014e1a060e6555UL;
   tf->codes[13307] = 0x00014e2b2df5160cUL;
   tf->codes[13308] = 0x00014e320ab7c322UL;
   tf->codes[13309] = 0x00014e32f4f3da36UL;
   tf->codes[13310] = 0x00014e524b7df0a3UL;
   tf->codes[13311] = 0x00014e5d464f0593UL;
   tf->codes[13312] = 0x00014e642311b2a9UL;
   tf->codes[13313] = 0x00014e6a159848abUL;
   tf->codes[13314] = 0x00014e70b7cbeffcUL;
   tf->codes[13315] = 0x00014e7f20fe5b77UL;
   tf->codes[13316] = 0x00014e83047dbd8cUL;
   tf->codes[13317] = 0x00014e8a565e762cUL;
   tf->codes[13318] = 0x00014e984a72d61dUL;
   tf->codes[13319] = 0x00014ea1363cb720UL;
   tf->codes[13320] = 0x00014ea937ca810fUL;
   tf->codes[13321] = 0x00014eab46d1b4fcUL;
   tf->codes[13322] = 0x00014eb30dd07926UL;
   tf->codes[13323] = 0x00014eb4329b95ffUL;
   tf->codes[13324] = 0x00014eb591f5b89dUL;
   tf->codes[13325] = 0x00014ebce3d6713dUL;
   tf->codes[13326] = 0x00014ed08fe2616bUL;
   tf->codes[13327] = 0x00014ed97bac426eUL;
   tf->codes[13328] = 0x00014edb8ab3765bUL;
   tf->codes[13329] = 0x00014ef3c9ebd9edUL;
   tf->codes[13330] = 0x00014ef59e640815UL;
   tf->codes[13331] = 0x00014ef897a75316UL;
   tf->codes[13332] = 0x00014ef9bc726fefUL;
   tf->codes[13333] = 0x00014f0775f7ca1bUL;
   tf->codes[13334] = 0x00014f0ae45920a6UL;
   tf->codes[13335] = 0x00014f13d02301a9UL;
   tf->codes[13336] = 0x00014f14f4ee1e82UL;
   tf->codes[13337] = 0x00014f17ee316983UL;
   tf->codes[13338] = 0x00014f1b2203ba49UL;
   tf->codes[13339] = 0x00014f28db891475UL;
   tf->codes[13340] = 0x00014f2916181a3aUL;
   tf->codes[13341] = 0x00014f2a75723cd8UL;
   tf->codes[13342] = 0x00014f3869869cc9UL;
   tf->codes[13343] = 0x00014f3a3dfecaf1UL;
   tf->codes[13344] = 0x00014f3cc2240a68UL;
   tf->codes[13345] = 0x00014f3de6ef2741UL;
   tf->codes[13346] = 0x00014f3e5c0d32cbUL;
   tf->codes[13347] = 0x00014f4ba074816dUL;
   tf->codes[13348] = 0x00014f5660b69098UL;
   tf->codes[13349] = 0x00014f628052c261UL;
   tf->codes[13350] = 0x00014f67fdbb4cd9UL;
   tf->codes[13351] = 0x00014f82116bde93UL;
   tf->codes[13352] = 0x00014f97cc7f02aeUL;
   tf->codes[13353] = 0x00014f9a50a44225UL;
   tf->codes[13354] = 0x00014fa426aa3a3cUL;
   tf->codes[13355] = 0x00014fa9a412c4b4UL;
   tf->codes[13356] = 0x00014fb54e90eaf3UL;
   tf->codes[13357] = 0x00014fc84aefc9d2UL;
   tf->codes[13358] = 0x00014fca94860384UL;
   tf->codes[13359] = 0x00014fd29613cd73UL;
   tf->codes[13360] = 0x00014fdb474ea8b1UL;
   tf->codes[13361] = 0x00014fe0150a21daUL;
   tf->codes[13362] = 0x00014fe2d3be6716UL;
   tf->codes[13363] = 0x00014febbf884819UL;
   tf->codes[13364] = 0x00014ff85442856cUL;
   tf->codes[13365] = 0x0001500314849497UL;
   tf->codes[13366] = 0x00015005d338d9d3UL;
   tf->codes[13367] = 0x00015014ec18569dUL;
   tf->codes[13368] = 0x0001501561366227UL;
   tf->codes[13369] = 0x0001501b53bcf829UL;
   tf->codes[13370] = 0x0001501e878f48efUL;
   tf->codes[13371] = 0x0001501fac5a65c8UL;
   tf->codes[13372] = 0x00015027e877357cUL;
   tf->codes[13373] = 0x0001503392f55bbbUL;
   tf->codes[13374] = 0x0001503b1f651a20UL;
   tf->codes[13375] = 0x0001503dde195f5cUL;
   tf->codes[13376] = 0x00015041fc27c736UL;
   tf->codes[13377] = 0x00015053992c8377UL;
   tf->codes[13378] = 0x000150556da4b19fUL;
   tf->codes[13379] = 0x00015057421cdfc7UL;
   tf->codes[13380] = 0x000150602de6c0caUL;
   tf->codes[13381] = 0x00015062777cfa7cUL;
   tf->codes[13382] = 0x0001506bd864e709UL;
   tf->codes[13383] = 0x00015072efb699e4UL;
   tf->codes[13384] = 0x000150765e17f06fUL;
   tf->codes[13385] = 0x000150770dc501beUL;
   tf->codes[13386] = 0x00015077bd72130dUL;
   tf->codes[13387] = 0x0001507e9a34c023UL;
   tf->codes[13388] = 0x0001508367f0394cUL;
   tf->codes[13389] = 0x000150a41dd47257UL;
   tf->codes[13390] = 0x000150ae2e697033UL;
   tf->codes[13391] = 0x000150b077ffa9e5UL;
   tf->codes[13392] = 0x000150c50e47b127UL;
   tf->codes[13393] = 0x000150c7ccfbf663UL;
   tf->codes[13394] = 0x000150ca8bb03b9fUL;
   tf->codes[13395] = 0x000150d7d0178a41UL;
   tf->codes[13396] = 0x000150dd880f1a7eUL;
   tf->codes[13397] = 0x000150ddc29e2043UL;
   tf->codes[13398] = 0x000150e130ff76ceUL;
   tf->codes[13399] = 0x000150f726a1a0aeUL;
   tf->codes[13400] = 0x00015100fca798c5UL;
   tf->codes[13401] = 0x0001510813f94ba0UL;
   tf->codes[13402] = 0x0001510b825aa22bUL;
   tf->codes[13403] = 0x0001511e7eb9810aUL;
   tf->codes[13404] = 0x0001513140895a24UL;
   tf->codes[13405] = 0x00015134745baaeaUL;
   tf->codes[13406] = 0x0001513d25968628UL;
   tf->codes[13407] = 0x0001514820679b18UL;
   tf->codes[13408] = 0x0001514e12ee311aUL;
   tf->codes[13409] = 0x00015168d64bd423UL;
   tf->codes[13410] = 0x00015169c087eb37UL;
   tf->codes[13411] = 0x0001516a7034fc86UL;
   tf->codes[13412] = 0x0001516bcf8f1f24UL;
   tf->codes[13413] = 0x0001517cf775cfdbUL;
   tf->codes[13414] = 0x000151823a4f548eUL;
   tf->codes[13415] = 0x000151844956887bUL;
   tf->codes[13416] = 0x0001518bd5c646e0UL;
   tf->codes[13417] = 0x000151afbf7cd0b1UL;
   tf->codes[13418] = 0x000151b4181a3e50UL;
   tf->codes[13419] = 0x000151b53ce55b29UL;
   tf->codes[13420] = 0x000151b83628a62aUL;
   tf->codes[13421] = 0x000151c3a617c6a4UL;
   tf->codes[13422] = 0x000151c41b35d22eUL;
   tf->codes[13423] = 0x000151d1250e1b0bUL;
   tf->codes[13424] = 0x000151d4cdfe775bUL;
   tf->codes[13425] = 0x000151d75223b6d2UL;
   tf->codes[13426] = 0x000151dccf8c414aUL;
   tf->codes[13427] = 0x000151de2ee663e8UL;
   tf->codes[13428] = 0x000151e2c212d74cUL;
   tf->codes[13429] = 0x000151e78fce5075UL;
   tf->codes[13430] = 0x000151f66e1ec77aUL;
   tf->codes[13431] = 0x000151f8f24406f1UL;
   tf->codes[13432] = 0x000151fd10526ecbUL;
   tf->codes[13433] = 0x000152075b76726cUL;
   tf->codes[13434] = 0x000152180e3f1799UL;
   tf->codes[13435] = 0x0001522677718314UL;
   tf->codes[13436] = 0x000152284be9b13cUL;
   tf->codes[13437] = 0x0001522a957feaeeUL;
   tf->codes[13438] = 0x0001524384655fcfUL;
   tf->codes[13439] = 0x000152493c5cf00cUL;
   tf->codes[13440] = 0x0001524ad646186fUL;
   tf->codes[13441] = 0x0001525f6c8e1fb1UL;
   tf->codes[13442] = 0x000152655f14b5b3UL;
   tf->codes[13443] = 0x00015269429417c8UL;
   tf->codes[13444] = 0x0001526a675f34a1UL;
   tf->codes[13445] = 0x0001527562304991UL;
   tf->codes[13446] = 0x000152759cbf4f56UL;
   tf->codes[13447] = 0x0001527f383641a8UL;
   tf->codes[13448] = 0x00015287e9711ce6UL;
   tf->codes[13449] = 0x0001529234952087UL;
   tf->codes[13450] = 0x000152947e2b5a39UL;
   tf->codes[13451] = 0x000152a028a98078UL;
   tf->codes[13452] = 0x000152abd327a6b7UL;
   tf->codes[13453] = 0x000152bd359d5d33UL;
   tf->codes[13454] = 0x000152c8e01b8372UL;
   tf->codes[13455] = 0x000152ddeb81963eUL;
   tf->codes[13456] = 0x000152dfbff9c466UL;
   tf->codes[13457] = 0x000152e7fc16941aUL;
   tf->codes[13458] = 0x000152e9d08ec242UL;
   tf->codes[13459] = 0x000152f505eedcf7UL;
   tf->codes[13460] = 0x000152f6da670b1fUL;
   tf->codes[13461] = 0x000152f7c4a32233UL;
   tf->codes[13462] = 0x000152f8e96e3f0cUL;
   tf->codes[13463] = 0x000152fa0e395be5UL;
   tf->codes[13464] = 0x000152fea165cf49UL;
   tf->codes[13465] = 0x0001530075ddfd71UL;
   tf->codes[13466] = 0x00015306dd829efdUL;
   tf->codes[13467] = 0x00015307c7beb611UL;
   tf->codes[13468] = 0x00015309d6c5e9feUL;
   tf->codes[13469] = 0x00015327cdf5ddcdUL;
   tf->codes[13470] = 0x00015329a26e0bf5UL;
   tf->codes[13471] = 0x00015339306b9449UL;
   tf->codes[13472] = 0x0001533a1aa7ab5dUL;
   tf->codes[13473] = 0x00015345c525d19cUL;
   tf->codes[13474] = 0x00015356b27d7c8eUL;
   tf->codes[13475] = 0x00015359abc0c78fUL;
   tf->codes[13476] = 0x0001535e045e352eUL;
   tf->codes[13477] = 0x0001537e0a955ceaUL;
   tf->codes[13478] = 0x0001537e452462afUL;
   tf->codes[13479] = 0x00015385d1942114UL;
   tf->codes[13480] = 0x000153a319170394UL;
   tf->codes[13481] = 0x000153a353a60959UL;
   tf->codes[13482] = 0x000153a9462c9f5bUL;
   tf->codes[13483] = 0x000153aaa586c1f9UL;
   tf->codes[13484] = 0x000153be5192b227UL;
   tf->codes[13485] = 0x000153c09b28ebd9UL;
   tf->codes[13486] = 0x000153c3cefb3c9fUL;
   tf->codes[13487] = 0x000153c8d745bb8dUL;
   tf->codes[13488] = 0x000153cae64cef7aUL;
   tf->codes[13489] = 0x000153dff1b30246UL;
   tf->codes[13490] = 0x000153e275d841bdUL;
   tf->codes[13491] = 0x0001540c52156190UL;
   tf->codes[13492] = 0x0001543877e8bb15UL;
   tf->codes[13493] = 0x00015452167b4145UL;
   tf->codes[13494] = 0x00015452c6285294UL;
   tf->codes[13495] = 0x000154587e1fe2d1UL;
   tf->codes[13496] = 0x0001545e3617730eUL;
   tf->codes[13497] = 0x000154600a8fa136UL;
   tf->codes[13498] = 0x000154654d6925e9UL;
   tf->codes[13499] = 0x000154680c1d6b25UL;
   tf->codes[13500] = 0x000154760031cb16UL;
   tf->codes[13501] = 0x0001547884570a8dUL;
   tf->codes[13502] = 0x0001547eb16ca654UL;
   tf->codes[13503] = 0x0001547fd637c32dUL;
   tf->codes[13504] = 0x0001549640f7f897UL;
   tf->codes[13505] = 0x000154b3887adb17UL;
   tf->codes[13506] = 0x000154bd23f1cd69UL;
   tf->codes[13507] = 0x000154cf36149534UL;
   tf->codes[13508] = 0x000154d17faacee6UL;
   tf->codes[13509] = 0x000154dc3fecde11UL;
   tf->codes[13510] = 0x000154e406eba23bUL;
   tf->codes[13511] = 0x000154e4f127b94fUL;
   tf->codes[13512] = 0x000154f9876fc091UL;
   tf->codes[13513] = 0x000154ff79f65693UL;
   tf->codes[13514] = 0x0001550865c03796UL;
   tf->codes[13515] = 0x000155098a8b546fUL;
   tf->codes[13516] = 0x00015511518a1899UL;
   tf->codes[13517] = 0x0001553db1ec77e3UL;
   tf->codes[13518] = 0x0001553fc0f3abd0UL;
   tf->codes[13519] = 0x0001554d7a7905fcUL;
   tf->codes[13520] = 0x00015556db60f289UL;
   tf->codes[13521] = 0x00015557c59d099dUL;
   tf->codes[13522] = 0x00015589ddf6f924UL;
   tf->codes[13523] = 0x00015596e7cf4201UL;
   tf->codes[13524] = 0x00015599a683873dUL;
   tf->codes[13525] = 0x000155a9a99f1b1bUL;
   tf->codes[13526] = 0x000155ac68536057UL;
   tf->codes[13527] = 0x000155cad4a15fb0UL;
   tf->codes[13528] = 0x000155d226821850UL;
   tf->codes[13529] = 0x000155e3fe15da56UL;
   tf->codes[13530] = 0x000155e4adc2eba5UL;
   tf->codes[13531] = 0x000155e6f7592557UL;
   tf->codes[13532] = 0x000155fc3d4e3de8UL;
   tf->codes[13533] = 0x000155fe86e4779aUL;
   tf->codes[13534] = 0x0001561c7e146b69UL;
   tf->codes[13535] = 0x000156209c22d343UL;
   tf->codes[13536] = 0x00015621865eea57UL;
   tf->codes[13537] = 0x000156332363a698UL;
   tf->codes[13538] = 0x0001563691c4fd23UL;
   tf->codes[13539] = 0x0001564b629c0a2aUL;
   tf->codes[13540] = 0x0001564ed0fd60b5UL;
   tf->codes[13541] = 0x00015651ca40abb6UL;
   tf->codes[13542] = 0x000156539eb8d9deUL;
   tf->codes[13543] = 0x00015655adc00dcbUL;
   tf->codes[13544] = 0x0001565e5efae909UL;
   tf->codes[13545] = 0x0001565f83c605e2UL;
   tf->codes[13546] = 0x0001566ba36237abUL;
   tf->codes[13547] = 0x000156819904618bUL;
   tf->codes[13548] = 0x000156a3e8d1c2f9UL;
   tf->codes[13549] = 0x000156a42360c8beUL;
   tf->codes[13550] = 0x000156a50d9cdfd2UL;
   tf->codes[13551] = 0x000156a66cf70270UL;
   tf->codes[13552] = 0x000156b0f2aa0bd6UL;
   tf->codes[13553] = 0x000156beac2f6602UL;
   tf->codes[13554] = 0x000156ca913c9206UL;
   tf->codes[13555] = 0x000156cc2b25ba69UL;
   tf->codes[13556] = 0x000156e84ddd8010UL;
   tf->codes[13557] = 0x000156fdce619e66UL;
   tf->codes[13558] = 0x0001570e469b3dceUL;
   tf->codes[13559] = 0x000157201e2effd4UL;
   tf->codes[13560] = 0x000157243c3d67aeUL;
   tf->codes[13561] = 0x000157285a4bcf88UL;
   tf->codes[13562] = 0x000157323051c79fUL;
   tf->codes[13563] = 0x00015734b4770716UL;
   tf->codes[13564] = 0x000157385d676366UL;
   tf->codes[13565] = 0x000157452cb0a67eUL;
   tf->codes[13566] = 0x00015755df794babUL;
   tf->codes[13567] = 0x0001575b5ce1d623UL;
   tf->codes[13568] = 0x0001577152840003UL;
   tf->codes[13569] = 0x00015780a5f28292UL;
   tf->codes[13570] = 0x000157823fdbaaf5UL;
   tf->codes[13571] = 0x0001578e5f77dcbeUL;
   tf->codes[13572] = 0x000157927d864498UL;
   tf->codes[13573] = 0x00015794c71c7e4aUL;
   tf->codes[13574] = 0x0001579a448508c2UL;
   tf->codes[13575] = 0x000157ad0654e1dcUL;
   tf->codes[13576] = 0x000157b20e9f60caUL;
   tf->codes[13577] = 0x000157b96080196aUL;
   tf->codes[13578] = 0x000157d58337df11UL;
   tf->codes[13579] = 0x000157d6e29201afUL;
   tf->codes[13580] = 0x000157f8f7d05d58UL;
   tf->codes[13581] = 0x000157fa572a7ff6UL;
   tf->codes[13582] = 0x000157ff5f74fee4UL;
   tf->codes[13583] = 0x0001580308655b34UL;
   tf->codes[13584] = 0x00015809e528084aUL;
   tf->codes[13585] = 0x00015814dff91d3aUL;
   tf->codes[13586] = 0x000158163f533fd8UL;
   tf->codes[13587] = 0x0001581f65ac26a0UL;
   tf->codes[13588] = 0x0001582174b35a8dUL;
   tf->codes[13589] = 0x00015821af426052UL;
   tf->codes[13590] = 0x00015827dc57fc19UL;
   tf->codes[13591] = 0x0001582a25ee35cbUL;
   tf->codes[13592] = 0x00015837df738ff7UL;
   tf->codes[13593] = 0x0001583fe10159e6UL;
   tf->codes[13594] = 0x00015847e28f23d5UL;
   tf->codes[13595] = 0x0001584f6efee23aUL;
   tf->codes[13596] = 0x000158559c147e01UL;
   tf->codes[13597] = 0x0001585c03b91f8dUL;
   tf->codes[13598] = 0x00015860d17498b6UL;
   tf->codes[13599] = 0x00015862e07bcca3UL;
   tf->codes[13600] = 0x00015866c3fb2eb8UL;
   tf->codes[13601] = 0x0001586b5727a21cUL;
   tf->codes[13602] = 0x0001587dde687571UL;
   tf->codes[13603] = 0x0001587e538680fbUL;
   tf->codes[13604] = 0x0001588f40de2bedUL;
   tf->codes[13605] = 0x0001589483b7b0a0UL;
   tf->codes[13606] = 0x00015896582fdec8UL;
   tf->codes[13607] = 0x000158977cfafba1UL;
   tf->codes[13608] = 0x00015899517329c9UL;
   tf->codes[13609] = 0x000158a02e35d6dfUL;
   tf->codes[13610] = 0x000158a780168f7fUL;
   tf->codes[13611] = 0x000158a8df70b21dUL;
   tf->codes[13612] = 0x000158aa7959da80UL;
   tf->codes[13613] = 0x000158b44f5fd297UL;
   tf->codes[13614] = 0x000158b65e670684UL;
   tf->codes[13615] = 0x000158b8e28c45fbUL;
   tf->codes[13616] = 0x000158c159381b74UL;
   tf->codes[13617] = 0x000158ce63106451UL;
   tf->codes[13618] = 0x000158d62a0f287bUL;
   tf->codes[13619] = 0x000158dba777b2f3UL;
   tf->codes[13620] = 0x000158ee2eb88648UL;
   tf->codes[13621] = 0x000158f2c1e4f9acUL;
   tf->codes[13622] = 0x000158f879dc89e9UL;
   tf->codes[13623] = 0x00015904d407c177UL;
   tf->codes[13624] = 0x000159050e96c73cUL;
   tf->codes[13625] = 0x0001591795d79a91UL;
   tf->codes[13626] = 0x000159225619a9bcUL;
   tf->codes[13627] = 0x00015923b573cc5aUL;
   tf->codes[13628] = 0x000159367743a574UL;
   tf->codes[13629] = 0x0001593c69ca3b76UL;
   tf->codes[13630] = 0x00015947649b5066UL;
   tf->codes[13631] = 0x00015948144861b5UL;
   tf->codes[13632] = 0x00015950c5833cf3UL;
   tf->codes[13633] = 0x00015964ac1e32e6UL;
   tf->codes[13634] = 0x00015981b9120fa1UL;
   tf->codes[13635] = 0x000159822e301b2bUL;
   tf->codes[13636] = 0x00015982dddd2c7aUL;
   tf->codes[13637] = 0x0001598402a84953UL;
   tf->codes[13638] = 0x00015986c15c8e8fUL;
   tf->codes[13639] = 0x000159aae5a21e25UL;
   tf->codes[13640] = 0x000159b112b7b9ecUL;
   tf->codes[13641] = 0x000159b3d16bff28UL;
   tf->codes[13642] = 0x000159d362851b5aUL;
   tf->codes[13643] = 0x000159e3dabebac2UL;
   tf->codes[13644] = 0x000159e783af1712UL;
   tf->codes[13645] = 0x000159eba1bd7eecUL;
   tf->codes[13646] = 0x000159f0e497039fUL;
   tf->codes[13647] = 0x000159fa0aefea67UL;
   tf->codes[13648] = 0x000159ff885874dfUL;
   tf->codes[13649] = 0x00015a03a666dcb9UL;
   tf->codes[13650] = 0x00015a07c4754493UL;
   tf->codes[13651] = 0x00015a0a832989cfUL;
   tf->codes[13652] = 0x00015a12bf465983UL;
   tf->codes[13653] = 0x00015a15436b98faUL;
   tf->codes[13654] = 0x00015a1717e3c722UL;
   tf->codes[13655] = 0x00015a1c202e4610UL;
   tf->codes[13656] = 0x00015a3a8c7c4569UL;
   tf->codes[13657] = 0x00015a3b3c2956b8UL;
   tf->codes[13658] = 0x00015a3cd6127f1bUL;
   tf->codes[13659] = 0x00015a404473d5a6UL;
   tf->codes[13660] = 0x00015a42537b0993UL;
   tf->codes[13661] = 0x00015a43ed6431f6UL;
   tf->codes[13662] = 0x00015a580e8e2daeUL;
   tf->codes[13663] = 0x00015a5933594a87UL;
   tf->codes[13664] = 0x00015a68c156d2dbUL;
   tf->codes[13665] = 0x00015a69ab92e9efUL;
   tf->codes[13666] = 0x00015a6a95cf0103UL;
   tf->codes[13667] = 0x00015a82255a5346UL;
   tf->codes[13668] = 0x00015a8384b475e4UL;
   tf->codes[13669] = 0x00015a89773b0be6UL;
   tf->codes[13670] = 0x00015a908e8cbec1UL;
   tf->codes[13671] = 0x00015a997a569fc4UL;
   tf->codes[13672] = 0x00015a9a9f21bc9dUL;
   tf->codes[13673] = 0x00015ab3c8963743UL;
   tf->codes[13674] = 0x00015ab43db442cdUL;
   tf->codes[13675] = 0x00015ab90b6fbbf6UL;
   tf->codes[13676] = 0x00015ac3cbb1cb21UL;
   tf->codes[13677] = 0x00015af65929c632UL;
   tf->codes[13678] = 0x00015afa77382e0cUL;
   tf->codes[13679] = 0x00015b032873094aUL;
   tf->codes[13680] = 0x00015b157524d6daUL;
   tf->codes[13681] = 0x00015b16d47ef978UL;
   tf->codes[13682] = 0x00015b1d76b2a0c9UL;
   tf->codes[13683] = 0x00015b1f85b9d4b6UL;
   tf->codes[13684] = 0x00015b23693936cbUL;
   tf->codes[13685] = 0x00015b3331c5c4e4UL;
   tf->codes[13686] = 0x00015b4752efc09cUL;
   tf->codes[13687] = 0x00015b5f9228242eUL;
   tf->codes[13688] = 0x00015b5fccb729f3UL;
   tf->codes[13689] = 0x00015b75c25953d3UL;
   tf->codes[13690] = 0x00015b7a5585c737UL;
   tf->codes[13691] = 0x00015b7c29fdf55fUL;
   tf->codes[13692] = 0x00015b80f7b96e88UL;
   tf->codes[13693] = 0x00015b95c8907b8fUL;
   tf->codes[13694] = 0x00015b99ac0fdda4UL;
   tf->codes[13695] = 0x00015ba04e4384f5UL;
   tf->codes[13696] = 0x00015ba88a6054a9UL;
   tf->codes[13697] = 0x00015bab83a39faaUL;
   tf->codes[13698] = 0x00015bba276510eaUL;
   tf->codes[13699] = 0x00015bbb4c302dc3UL;
   tf->codes[13700] = 0x00015bbbfbdd3f12UL;
   tf->codes[13701] = 0x00015bcfe2783505UL;
   tf->codes[13702] = 0x00015bdcb1c1781dUL;
   tf->codes[13703] = 0x00015bfa33d36062UL;
   tf->codes[13704] = 0x00015c0b5bba1119UL;
   tf->codes[13705] = 0x00015c15a6de14baUL;
   tf->codes[13706] = 0x00015c1e1d89ea33UL;
   tf->codes[13707] = 0x00015c261f17b422UL;
   tf->codes[13708] = 0x00015c2b27623310UL;
   tf->codes[13709] = 0x00015c32ee60f73aUL;
   tf->codes[13710] = 0x00015c35728636b1UL;
   tf->codes[13711] = 0x00015c369751538aUL;
   tf->codes[13712] = 0x00015c43a1299c67UL;
   tf->codes[13713] = 0x00015c4ab87b4f42UL;
   tf->codes[13714] = 0x00015c587200a96eUL;
   tf->codes[13715] = 0x00015c64cc2be0fcUL;
   tf->codes[13716] = 0x00015c6999e75a25UL;
   tf->codes[13717] = 0x00015c7d45f34a53UL;
   tf->codes[13718] = 0x00015c8213aec37cUL;
   tf->codes[13719] = 0x00015c845d44fd2eUL;
   tf->codes[13720] = 0x00015c88b5e26acdUL;
   tf->codes[13721] = 0x00015c88f0717092UL;
   tf->codes[13722] = 0x00015c8ee2f80694UL;
   tf->codes[13723] = 0x00015c96a9f6cabeUL;
   tf->codes[13724] = 0x00015c9c275f5536UL;
   tf->codes[13725] = 0x00015ca30422024cUL;
   tf->codes[13726] = 0x00015cba93ad548fUL;
   tf->codes[13727] = 0x00015cbc2d967cf2UL;
   tf->codes[13728] = 0x00015cc2cfca2443UL;
   tf->codes[13729] = 0x00015cd88add485eUL;
   tf->codes[13730] = 0x00015cd9afa86537UL;
   tf->codes[13731] = 0x00015ce72e9eb99eUL;
   tf->codes[13732] = 0x00015ce8c887e201UL;
   tf->codes[13733] = 0x00015cea62710a64UL;
   tf->codes[13734] = 0x00015cf08f86a62bUL;
   tf->codes[13735] = 0x00015cf3fde7fcb6UL;
   tf->codes[13736] = 0x00015cfe839b061cUL;
   tf->codes[13737] = 0x00015cfebe2a0be1UL;
   tf->codes[13738] = 0x00015d00cd313fceUL;
   tf->codes[13739] = 0x00015d05d57bbebcUL;
   tf->codes[13740] = 0x00015d12df540799UL;
   tf->codes[13741] = 0x00015d14041f2472UL;
   tf->codes[13742] = 0x00015d16884463e9UL;
   tf->codes[13743] = 0x00015d24073ab850UL;
   tf->codes[13744] = 0x00015d273b0d0916UL;
   tf->codes[13745] = 0x00015d27eaba1a65UL;
   tf->codes[13746] = 0x00015d3f7a456ca8UL;
   tf->codes[13747] = 0x00015d50a22c1d5fUL;
   tf->codes[13748] = 0x00015d595366f89dUL;
   tf->codes[13749] = 0x00015d60a547b13dUL;
   tf->codes[13750] = 0x00015d7207bd67b9UL;
   tf->codes[13751] = 0x00015d7a7e693d32UL;
   tf->codes[13752] = 0x00015d978b5d19edUL;
   tf->codes[13753] = 0x00015d999a644ddaUL;
   tf->codes[13754] = 0x00015d9a84a064eeUL;
   tf->codes[13755] = 0x00015d9db872b5b4UL;
   tf->codes[13756] = 0x00015da1d6811d8eUL;
   tf->codes[13757] = 0x00015da211102353UL;
   tf->codes[13758] = 0x00015da3706a45f1UL;
   tf->codes[13759] = 0x00015db92b7d6a0cUL;
   tf->codes[13760] = 0x00015dd54e352fb3UL;
   tf->codes[13761] = 0x00015dd847787ab4UL;
   tf->codes[13762] = 0x00015dde748e167bUL;
   tf->codes[13763] = 0x00015ddfd3e83919UL;
   tf->codes[13764] = 0x00015df0c13fe40bUL;
   tf->codes[13765] = 0x00015e0641c40261UL;
   tf->codes[13766] = 0x00015e0b0f7f7b8aUL;
   tf->codes[13767] = 0x00015e105259003dUL;
   tf->codes[13768] = 0x00015e15953284f0UL;
   tf->codes[13769] = 0x00015e24ae1201baUL;
   tf->codes[13770] = 0x00015e24e8a1077fUL;
   tf->codes[13771] = 0x00015e37aa70e099UL;
   tf->codes[13772] = 0x00015e3dd7867c60UL;
   tf->codes[13773] = 0x00015e3f36e09efeUL;
   tf->codes[13774] = 0x00015e5616bedff2UL;
   tf->codes[13775] = 0x00015e5f0288c0f5UL;
   tf->codes[13776] = 0x00015e5f3d17c6baUL;
   tf->codes[13777] = 0x00015e6061e2e393UL;
   tf->codes[13778] = 0x00015e6654697995UL;
   tf->codes[13779] = 0x00015e6d312c26abUL;
   tf->codes[13780] = 0x00015e7ab0227b12UL;
   tf->codes[13781] = 0x00015e7de3f4cbd8UL;
   tf->codes[13782] = 0x00015e97f7a55d92UL;
   tf->codes[13783] = 0x00015e9f49861632UL;
   tf->codes[13784] = 0x00015ea367947e0cUL;
   tf->codes[13785] = 0x00015ea48c5f9ae5UL;
   tf->codes[13786] = 0x00015ebd0627043cUL;
   tf->codes[13787] = 0x00015ecd43d19ddfUL;
   tf->codes[13788] = 0x00015ed495b2567fUL;
   tf->codes[13789] = 0x00015eda8838ec81UL;
   tf->codes[13790] = 0x00015edc222214e4UL;
   tf->codes[13791] = 0x00015edd817c3782UL;
   tf->codes[13792] = 0x00015edfcb127134UL;
   tf->codes[13793] = 0x00015ee19f8a9f5cUL;
   tf->codes[13794] = 0x00015ee5487afbacUL;
   tf->codes[13795] = 0x00015ef33c8f5b9dUL;
   tf->codes[13796] = 0x00015f0130a3bb8eUL;
   tf->codes[13797] = 0x00015f0514231da3UL;
   tf->codes[13798] = 0x00015f075db95755UL;
   tf->codes[13799] = 0x00015f2604965c73UL;
   tf->codes[13800] = 0x00015f28fdd9a774UL;
   tf->codes[13801] = 0x00015f36b75f01a0UL;
   tf->codes[13802] = 0x00015f36f1ee0765UL;
   tf->codes[13803] = 0x00015f37a19b18b4UL;
   tf->codes[13804] = 0x00015f3ef37bd154UL;
   tf->codes[13805] = 0x00015f4177a110cbUL;
   tf->codes[13806] = 0x00015f476a27a6cdUL;
   tf->codes[13807] = 0x00015f4d973d4294UL;
   tf->codes[13808] = 0x00015f576d433aabUL;
   tf->codes[13809] = 0x00015f581cf04bfaUL;
   tf->codes[13810] = 0x00015f5b8b51a285UL;
   tf->codes[13811] = 0x00015f5ebf23f34bUL;
   tf->codes[13812] = 0x00015f738ffb0052UL;
   tf->codes[13813] = 0x00015f7529e428b5UL;
   tf->codes[13814] = 0x00015f7da08ffe2eUL;
   tf->codes[13815] = 0x00015f84f270b6ceUL;
   tf->codes[13816] = 0x00015f8b5a15585aUL;
   tf->codes[13817] = 0x00015fa2af11a4d8UL;
   tf->codes[13818] = 0x00015fa61d72fb63UL;
   tf->codes[13819] = 0x00015fbe221c5930UL;
   tf->codes[13820] = 0x00015fc06bb292e2UL;
   tf->codes[13821] = 0x00015fc32a66d81eUL;
   tf->codes[13822] = 0x00015fc832b1570cUL;
   tf->codes[13823] = 0x00015fda7f63249cUL;
   tf->codes[13824] = 0x00015fdfc23ca94fUL;
   tf->codes[13825] = 0x00015fe3309dffdaUL;
   tf->codes[13826] = 0x00015ff99b5e3544UL;
   tf->codes[13827] = 0x00015ffb35475da7UL;
   tf->codes[13828] = 0x00015ffdf3fba2e3UL;
   tf->codes[13829] = 0x00016004962f4a34UL;
   tf->codes[13830] = 0x0001601757ff234eUL;
   tf->codes[13831] = 0x00016018423b3a62UL;
   tf->codes[13832] = 0x00016019dc2462c5UL;
   tf->codes[13833] = 0x0001601cd567adc6UL;
   tf->codes[13834] = 0x0001601d4a85b950UL;
   tf->codes[13835] = 0x00016022c7ee43c8UL;
   tf->codes[13836] = 0x0001602a545e022dUL;
   tf->codes[13837] = 0x0001602d4da14d2eUL;
   tf->codes[13838] = 0x0001603081739df4UL;
   tf->codes[13839] = 0x0001603b41b5ad1fUL;
   tf->codes[13840] = 0x0001603eb01703aaUL;
   tf->codes[13841] = 0x000160558ff5449eUL;
   tf->codes[13842] = 0x0001605a2321b802UL;
   tf->codes[13843] = 0x0001605b47ecd4dbUL;
   tf->codes[13844] = 0x00016097ab6ac803UL;
   tf->codes[13845] = 0x000160a09734a906UL;
   tf->codes[13846] = 0x000160a26bacd72eUL;
   tf->codes[13847] = 0x000160a40595ff91UL;
   tf->codes[13848] = 0x000160a7ae865be1UL;
   tf->codes[13849] = 0x000160bbcfb05799UL;
   tf->codes[13850] = 0x000160bddeb78b86UL;
   tf->codes[13851] = 0x000160c187a7e7d6UL;
   tf->codes[13852] = 0x000160d324aca417UL;
   tf->codes[13853] = 0x000160da3bfe56f2UL;
   tf->codes[13854] = 0x000160daebab6841UL;
   tf->codes[13855] = 0x000160e2781b26a6UL;
   tf->codes[13856] = 0x000160f783813972UL;
   tf->codes[13857] = 0x000160fa7cc48473UL;
   tf->codes[13858] = 0x00016104183b76c5UL;
   tf->codes[13859] = 0x0001610fc2b99d04UL;
   tf->codes[13860] = 0x0001611923a18991UL;
   tf->codes[13861] = 0x000161195e308f56UL;
   tf->codes[13862] = 0x0001611e667b0e44UL;
   tf->codes[13863] = 0x000161266808d833UL;
   tf->codes[13864] = 0x00016142ffdea964UL;
   tf->codes[13865] = 0x00016143ea1ac078UL;
   tf->codes[13866] = 0x00016155c1ae827eUL;
   tf->codes[13867] = 0x0001616799424484UL;
   tf->codes[13868] = 0x00016168f89c6722UL;
   tf->codes[13869] = 0x0001616b7cc1a699UL;
   tf->codes[13870] = 0x0001617294135974UL;
   tf->codes[13871] = 0x00016177d6ecde27UL;
   tf->codes[13872] = 0x00016180c2b6bf2aUL;
   tf->codes[13873] = 0x0001618137d4cab4UL;
   tf->codes[13874] = 0x000161825c9fe78dUL;
   tf->codes[13875] = 0x0001618b82f8ce55UL;
   tf->codes[13876] = 0x000161b3ffdbcb8aUL;
   tf->codes[13877] = 0x000161bc3bf89b3eUL;
   tf->codes[13878] = 0x000161bcb116a6c8UL;
   tf->codes[13879] = 0x000161cbc9f62392UL;
   tf->codes[13880] = 0x000161d739e5440cUL;
   tf->codes[13881] = 0x000161d9f8998948UL;
   tf->codes[13882] = 0x000161db9282b1abUL;
   tf->codes[13883] = 0x000161e3ce9f815fUL;
   tf->codes[13884] = 0x000161ea364422ebUL;
   tf->codes[13885] = 0x0001620b61466780UL;
   tf->codes[13886] = 0x0001620bd664730aUL;
   tf->codes[13887] = 0x00016219ca78d2fbUL;
   tf->codes[13888] = 0x000162206cac7a4cUL;
   tf->codes[13889] = 0x0001622f4afcf151UL;
   tf->codes[13890] = 0x0001623ed8fa79a5UL;
   tf->codes[13891] = 0x0001625be5ee5660UL;
   tf->codes[13892] = 0x0001628378953c81UL;
   tf->codes[13893] = 0x00016285fcba7bf8UL;
   tf->codes[13894] = 0x0001628671d88782UL;
   tf->codes[13895] = 0x0001629bb7cda013UL;
   tf->codes[13896] = 0x000162b7da8565baUL;
   tf->codes[13897] = 0x000162b9e98c99a7UL;
   tf->codes[13898] = 0x000162bbbe04c7cfUL;
   tf->codes[13899] = 0x000162bd1d5eea6dUL;
   tf->codes[13900] = 0x000162c5597bba21UL;
   tf->codes[13901] = 0x000162c67e46d6faUL;
   tf->codes[13902] = 0x000162de0dd2293dUL;
   tf->codes[13903] = 0x000162ef35b8d9f4UL;
   tf->codes[13904] = 0x000162fe4e9856beUL;
   tf->codes[13905] = 0x00016304068fe6fbUL;
   tf->codes[13906] = 0x0001630a33a582c2UL;
   tf->codes[13907] = 0x0001631c45c84a8dUL;
   tf->codes[13908] = 0x0001631e54cf7e7aUL;
   tf->codes[13909] = 0x00016326cb7b53f3UL;
   tf->codes[13910] = 0x0001632740995f7dUL;
   tf->codes[13911] = 0x00016329c4be9ef4UL;
   tf->codes[13912] = 0x000163370925ed96UL;
   tf->codes[13913] = 0x0001633a02693897UL;
   tf->codes[13914] = 0x0001633b27345570UL;
   tf->codes[13915] = 0x000163439de02ae9UL;
   tf->codes[13916] = 0x0001636195101eb8UL;
   tf->codes[13917] = 0x00016363dea6586aUL;
   tf->codes[13918] = 0x0001636ba5a51c94UL;
   tf->codes[13919] = 0x00016371d2bab85bUL;
   tf->codes[13920] = 0x0001637999b97c85UL;
   tf->codes[13921] = 0x0001638126293aeaUL;
   tf->codes[13922] = 0x00016382faa16912UL;
   tf->codes[13923] = 0x0001638c20fa4fdaUL;
   tf->codes[13924] = 0x00016398409681a3UL;
   tf->codes[13925] = 0x0001639b7468d269UL;
   tf->codes[13926] = 0x0001639df88e11e0UL;
   tf->codes[13927] = 0x000163a75975fe6dUL;
   tf->codes[13928] = 0x000163b54d8a5e5eUL;
   tf->codes[13929] = 0x000163ca1e616b65UL;
   tf->codes[13930] = 0x000163d0c09512b6UL;
   tf->codes[13931] = 0x000163d553c1861aUL;
   tf->codes[13932] = 0x000163e51c4e1433UL;
   tf->codes[13933] = 0x000163eb4963affaUL;
   tf->codes[13934] = 0x0001641c3cf282a8UL;
   tf->codes[13935] = 0x0001642e148644aeUL;
   tf->codes[13936] = 0x0001643a34227677UL;
   tf->codes[13937] = 0x00016442703f462bUL;
   tf->codes[13938] = 0x00016454f7801980UL;
   tf->codes[13939] = 0x0001645c0ed1cc5bUL;
   tf->codes[13940] = 0x0001646709a2e14bUL;
   tf->codes[13941] = 0x0001646ab2933d9bUL;
   tf->codes[13942] = 0x0001647ed3bd3953UL;
   tf->codes[13943] = 0x00016482078f8a19UL;
   tf->codes[13944] = 0x00016494544157a9UL;
   tf->codes[13945] = 0x000164974d84a2aaUL;
   tf->codes[13946] = 0x0001649abbe5f935UL;
   tf->codes[13947] = 0x000164a7c5be4212UL;
   tf->codes[13948] = 0x000164b8eda4f2c9UL;
   tf->codes[13949] = 0x000164bac21d20f1UL;
   tf->codes[13950] = 0x000164bee02b88cbUL;
   tf->codes[13951] = 0x000164c129c1c27dUL;
   tf->codes[13952] = 0x000164cbea03d1a8UL;
   tf->codes[13953] = 0x000164cee3471ca9UL;
   tf->codes[13954] = 0x000164d809a00371UL;
   tf->codes[13955] = 0x000164e2c9e2129cUL;
   tf->codes[13956] = 0x000164f58bb1ebb6UL;
   tf->codes[13957] = 0x000165037fc64ba7UL;
   tf->codes[13958] = 0x0001651975687587UL;
   tf->codes[13959] = 0x0001651a9a339260UL;
   tf->codes[13960] = 0x000165293df503a0UL;
   tf->codes[13961] = 0x0001652a28311ab4UL;
   tf->codes[13962] = 0x000165305546b67bUL;
   tf->codes[13963] = 0x0001653313fafbb7UL;
   tf->codes[13964] = 0x0001653e495b166cUL;
   tf->codes[13965] = 0x00016544b0ffb7f8UL;
   tf->codes[13966] = 0x00016548cf0e1fd2UL;
   tf->codes[13967] = 0x0001655dda74329eUL;
   tf->codes[13968] = 0x0001655e4f923e28UL;
   tf->codes[13969] = 0x000165673b5c1f2bUL;
   tf->codes[13970] = 0x00016573958756b9UL;
   tf->codes[13971] = 0x0001657ae7680f59UL;
   tf->codes[13972] = 0x0001657b5c861ae3UL;
   tf->codes[13973] = 0x00016581feb9c234UL;
   tf->codes[13974] = 0x00016586cc753b5dUL;
   tf->codes[13975] = 0x00016592b1826761UL;
   tf->codes[13976] = 0x00016595e554b827UL;
   tf->codes[13977] = 0x000165986979f79eUL;
   tf->codes[13978] = 0x0001659b62bd429fUL;
   tf->codes[13979] = 0x0001659f0bad9eefUL;
   tf->codes[13980] = 0x000165a03078bbc8UL;
   tf->codes[13981] = 0x000165aa067eb3dfUL;
   tf->codes[13982] = 0x000165bffc20ddbfUL;
   tf->codes[13983] = 0x000165c579896837UL;
   tf->codes[13984] = 0x000165dd0914ba7aUL;
   tf->codes[13985] = 0x000165f2feb6e45aUL;
   tf->codes[13986] = 0x000165fac5b5a884UL;
   tf->codes[13987] = 0x000166075a6fe5d7UL;
   tf->codes[13988] = 0x00016609697719c4UL;
   tf->codes[13989] = 0x0001661589134b8dUL;
   tf->codes[13990] = 0x0001661ee9fb381aUL;
   tf->codes[13991] = 0x00016621a8af7d56UL;
   tf->codes[13992] = 0x0001662292eb946aUL;
   tf->codes[13993] = 0x00016625c6bde530UL;
   tf->codes[13994] = 0x0001662b099769e3UL;
   tf->codes[13995] = 0x000166346a7f5670UL;
   tf->codes[13996] = 0x0001663d1bba31aeUL;
   tf->codes[13997] = 0x000166560a9fa68fUL;
   tf->codes[13998] = 0x0001665a28ae0e69UL;
   tf->codes[13999] = 0x000166697c1c90f8UL;
   tf->codes[14000] = 0x0001666b1605b95bUL;
   tf->codes[14001] = 0x00016673c7409499UL;
   tf->codes[14002] = 0x000166759bb8c2c1UL;
   tf->codes[14003] = 0x000166790a1a194cUL;
   tf->codes[14004] = 0x0001667a69743beaUL;
   tf->codes[14005] = 0x00016683553e1cedUL;
   tf->codes[14006] = 0x0001668aa71ed58dUL;
   tf->codes[14007] = 0x0001669d68eeaea7UL;
   tf->codes[14008] = 0x000166b9c6357a13UL;
   tf->codes[14009] = 0x000166c2b1ff5b16UL;
   tf->codes[14010] = 0x000166c48677893eUL;
   tf->codes[14011] = 0x000166cb9dc93c19UL;
   tf->codes[14012] = 0x000166cbd85841deUL;
   tf->codes[14013] = 0x000166cfbbd7a3f3UL;
   tf->codes[14014] = 0x000166d86d127f31UL;
   tf->codes[14015] = 0x000166de9a281af8UL;
   tf->codes[14016] = 0x000166e27da77d0dUL;
   tf->codes[14017] = 0x000166e6d644eaacUL;
   tf->codes[14018] = 0x000166e7c08101c0UL;
   tf->codes[14019] = 0x000166e8702e130fUL;
   tf->codes[14020] = 0x000166f15bf7f412UL;
   tf->codes[14021] = 0x00016701d431937aUL;
   tf->codes[14022] = 0x00016705f23ffb54UL;
   tf->codes[14023] = 0x000167099b3057a4UL;
   tf->codes[14024] = 0x0001670a104e632eUL;
   tf->codes[14025] = 0x000167183ef1c8e4UL;
   tf->codes[14026] = 0x000167245e8dfaadUL;
   tf->codes[14027] = 0x00016726330628d5UL;
   tf->codes[14028] = 0x00016729a1677f60UL;
   tf->codes[14029] = 0x00016742904cf441UL;
   tf->codes[14030] = 0x000167480db57eb9UL;
   tf->codes[14031] = 0x0001676296841bfdUL;
   tf->codes[14032] = 0x0001677b856990deUL;
   tf->codes[14033] = 0x00016796bde53f71UL;
   tf->codes[14034] = 0x0001679f349114eaUL;
   tf->codes[14035] = 0x000167ab542d46b3UL;
   tf->codes[14036] = 0x000167b6feab6cf2UL;
   tf->codes[14037] = 0x000167d0281fe798UL;
   tf->codes[14038] = 0x000167d14ceb0471UL;
   tf->codes[14039] = 0x000167d7b48fa5fdUL;
   tf->codes[14040] = 0x000167d913e9c89bUL;
   tf->codes[14041] = 0x000167e483d8e915UL;
   tf->codes[14042] = 0x000167e6cd6f22c7UL;
   tf->codes[14043] = 0x000167ea765f7f17UL;
   tf->codes[14044] = 0x000167f620dda556UL;
   tf->codes[14045] = 0x000167f65b6cab1bUL;
   tf->codes[14046] = 0x000167f7bac6cdb9UL;
   tf->codes[14047] = 0x000167f86a73df08UL;
   tf->codes[14048] = 0x00016801cb5bcb95UL;
   tf->codes[14049] = 0x00016808a81e78abUL;
   tf->codes[14050] = 0x00016815ec85c74dUL;
   tf->codes[14051] = 0x00016836dcf9061dUL;
   tf->codes[14052] = 0x0001683e6968c482UL;
   tf->codes[14053] = 0x00016846a5859436UL;
   tf->codes[14054] = 0x0001685633831c8aUL;
   tf->codes[14055] = 0x00016863ed0876b6UL;
   tf->codes[14056] = 0x0001686845a5e455UL;
   tf->codes[14057] = 0x0001687cdbedeb97UL;
   tf->codes[14058] = 0x0001688b7faf5cd7UL;
   tf->codes[14059] = 0x0001689764bc88dbUL;
   tf->codes[14060] = 0x0001689b483beaf0UL;
   tf->codes[14061] = 0x000168a0508669deUL;
   tf->codes[14062] = 0x000168b387744e82UL;
   tf->codes[14063] = 0x000168bce85c3b0fUL;
   tf->codes[14064] = 0x000168da6a6e2354UL;
   tf->codes[14065] = 0x000168db1a1b34a3UL;
   tf->codes[14066] = 0x000168e31ba8fe92UL;
   tf->codes[14067] = 0x000168e89911890aUL;
   tf->codes[14068] = 0x00016901c28603b0UL;
   tf->codes[14069] = 0x0001690b988bfbc7UL;
   tf->codes[14070] = 0x0001691867d53edfUL;
   tf->codes[14071] = 0x0001691f7f26f1baUL;
   tf->codes[14072] = 0x00016922034c3131UL;
   tf->codes[14073] = 0x0001693ba1deb761UL;
   tf->codes[14074] = 0x00016940aa29364fUL;
   tf->codes[14075] = 0x0001695be2a4e4e2UL;
   tf->codes[14076] = 0x0001696493dfc020UL;
   tf->codes[14077] = 0x000169699c2a3f0eUL;
   tf->codes[14078] = 0x0001698a8c9d7ddeUL;
   tf->codes[14079] = 0x000169928e2b47cdUL;
   tf->codes[14080] = 0x0001699b3f66230bUL;
   tf->codes[14081] = 0x000169a0f75db348UL;
   tf->codes[14082] = 0x000169a1e199ca5cUL;
   tf->codes[14083] = 0x000169a63a3737fbUL;
   tf->codes[14084] = 0x000169a6af554385UL;
   tf->codes[14085] = 0x000169b55316b4c5UL;
   tf->codes[14086] = 0x000169b63d52cbd9UL;
   tf->codes[14087] = 0x000169bdc9c28a3eUL;
   tf->codes[14088] = 0x000169cb0e29d8e0UL;
   tf->codes[14089] = 0x000169d9023e38d1UL;
   tf->codes[14090] = 0x000169dbfb8183d2UL;
   tf->codes[14091] = 0x000169f141769c63UL;
   tf->codes[14092] = 0x000169f9f2b177a1UL;
   tf->codes[14093] = 0x000169fb520b9a3fUL;
   tf->codes[14094] = 0x000169fc3c47b153UL;
   tf->codes[14095] = 0x00016a01f43f4190UL;
   tf->codes[14096] = 0x00016a035399642eUL;
   tf->codes[14097] = 0x00016a0562a0981bUL;
   tf->codes[14098] = 0x00016a32382102efUL;
   tf->codes[14099] = 0x00016a7453968654UL;
   tf->codes[14100] = 0x00016a85065f2b81UL;
   tf->codes[14101] = 0x00016a954409c524UL;
   tf->codes[14102] = 0x00016aa0ee87eb63UL;
   tf->codes[14103] = 0x00016aa3e7cb3664UL;
   tf->codes[14104] = 0x00016aa71b9d872aUL;
   tf->codes[14105] = 0x00016ab8438437e1UL;
   tf->codes[14106] = 0x00016acbef90280fUL;
   tf->codes[14107] = 0x00016ad6ea613cffUL;
   tf->codes[14108] = 0x00016adbb81cb628UL;
   tf->codes[14109] = 0x00016ade76d0fb64UL;
   tf->codes[14110] = 0x00016af2d289fce1UL;
   tf->codes[14111] = 0x00016af6b6095ef6UL;
   tf->codes[14112] = 0x00016afad417c6d0UL;
   tf->codes[14113] = 0x00016b00c69e5cd2UL;
   tf->codes[14114] = 0x00016b013bbc685cUL;
   tf->codes[14115] = 0x00016b072e42fe5eUL;
   tf->codes[14116] = 0x00016b0c368d7d4cUL;
   tf->codes[14117] = 0x00016b1f6d7b61f0UL;
   tf->codes[14118] = 0x00016b217c8295ddUL;
   tf->codes[14119] = 0x00016b2943815a07UL;
   tf->codes[14120] = 0x00016b33541657e3UL;
   tf->codes[14121] = 0x00016b34b3707a81UL;
   tf->codes[14122] = 0x00016b56c8aed62aUL;
   tf->codes[14123] = 0x00016b5ae6bd3e04UL;
   tf->codes[14124] = 0x00016b5cbb356c2cUL;
   tf->codes[14125] = 0x00016b7659c7f25cUL;
   tf->codes[14126] = 0x00016b84134d4c88UL;
   tf->codes[14127] = 0x00016b84886b5812UL;
   tf->codes[14128] = 0x00016b84fd89639cUL;
   tf->codes[14129] = 0x00016b8990b5d700UL;
   tf->codes[14130] = 0x00016b93dbd9daa1UL;
   tf->codes[14131] = 0x00016b9834774840UL;
   tf->codes[14132] = 0x00016bb03920a60dUL;
   tf->codes[14133] = 0x00016bb7507258e8UL;
   tf->codes[14134] = 0x00016bbb6e80c0c2UL;
   tf->codes[14135] = 0x00016bbdb816fa74UL;
   tf->codes[14136] = 0x00016bc6de6fe13cUL;
   tf->codes[14137] = 0x00016bca12423202UL;
   tf->codes[14138] = 0x00016bce305099dcUL;
   tf->codes[14139] = 0x00016bcf8faabc7aUL;
   tf->codes[14140] = 0x00016bdaff99dcf4UL;
   tf->codes[14141] = 0x00016be07d02676cUL;
   tf->codes[14142] = 0x00016be0f22072f6UL;
   tf->codes[14143] = 0x00016be3b0d4b832UL;
   tf->codes[14144] = 0x00016bf9a676e212UL;
   tf->codes[14145] = 0x00016bfd4f673e62UL;
   tf->codes[14146] = 0x00016c0048aa8963UL;
   tf->codes[14147] = 0x00016c1086552306UL;
   tf->codes[14148] = 0x00016c1469d4851bUL;
   tf->codes[14149] = 0x00016c481c179d05UL;
   tf->codes[14150] = 0x00016c497b71bfa3UL;
   tf->codes[14151] = 0x00016c6981a8e75fUL;
   tf->codes[14152] = 0x00016c747c79fc4fUL;
   tf->codes[14153] = 0x00016c789a886429UL;
   tf->codes[14154] = 0x00016c818652452cUL;
   tf->codes[14155] = 0x00016c98a0bf8be5UL;
   tf->codes[14156] = 0x00016cab28005f3aUL;
   tf->codes[14157] = 0x00016cb0304ade28UL;
   tf->codes[14158] = 0x00016ccab9197b6cUL;
   tf->codes[14159] = 0x00016ccaf3a88131UL;
   tf->codes[14160] = 0x00016cd74dd3b8bfUL;
   tf->codes[14161] = 0x00016ce5f19529ffUL;
   tf->codes[14162] = 0x00016cf0022a27dbUL;
   tf->codes[14163] = 0x00016cfc96e4652eUL;
   tf->codes[14164] = 0x00016cffcab6b5f4UL;
   tf->codes[14165] = 0x00016d01d9bde9e1UL;
   tf->codes[14166] = 0x00016d02c3fa00f5UL;
   tf->codes[14167] = 0x00016d06a779630aUL;
   tf->codes[14168] = 0x00016d092b9ea281UL;
   tf->codes[14169] = 0x00016d09662da846UL;
   tf->codes[14170] = 0x00016d1809ef1986UL;
   tf->codes[14171] = 0x00016d192eba365fUL;
   tf->codes[14172] = 0x00016d19de6747aeUL;
   tf->codes[14173] = 0x00016d1d12399874UL;
   tf->codes[14174] = 0x00016d1eac22c0d7UL;
   tf->codes[14175] = 0x00016d27d27ba79fUL;
   tf->codes[14176] = 0x00016d3a59bc7af4UL;
   tf->codes[14177] = 0x00016d3b09698c43UL;
   tf->codes[14178] = 0x00016d5592382987UL;
   tf->codes[14179] = 0x00016d79b67db91dUL;
   tf->codes[14180] = 0x00016d843c30c283UL;
   tf->codes[14181] = 0x00016d8685c6fc35UL;
   tf->codes[14182] = 0x00016d87aa92190eUL;
   tf->codes[14183] = 0x00016d93ca2e4ad7UL;
   tf->codes[14184] = 0x00016d97388fa162UL;
   tf->codes[14185] = 0x00016d990d07cf8aUL;
   tf->codes[14186] = 0x00016da183b3a503UL;
   tf->codes[14187] = 0x00016da407d8e47aUL;
   tf->codes[14188] = 0x00016da5dc5112a2UL;
   tf->codes[14189] = 0x00016daddddedc91UL;
   tf->codes[14190] = 0x00016db89e20ebbcUL;
   tf->codes[14191] = 0x00016dc8a13c7f9aUL;
   tf->codes[14192] = 0x00016dc950e990e9UL;
   tf->codes[14193] = 0x00016dca3b25a7fdUL;
   tf->codes[14194] = 0x00016dcda986fe88UL;
   tf->codes[14195] = 0x00016de782a88a7dUL;
   tf->codes[14196] = 0x00016df158ae8294UL;
   tf->codes[14197] = 0x00016dff8751e84aUL;
   tf->codes[14198] = 0x00016e0788dfb239UL;
   tf->codes[14199] = 0x00016e08388cc388UL;
   tf->codes[14200] = 0x00016e3f593131fdUL;
   tf->codes[14201] = 0x00016e46e5a0f062UL;
   tf->codes[14202] = 0x00016e49dee43b63UL;
   tf->codes[14203] = 0x00016e537a5b2db5UL;
   tf->codes[14204] = 0x00016e637d76c193UL;
   tf->codes[14205] = 0x00016e6e7847d683UL;
   tf->codes[14206] = 0x00016e70874f0a70UL;
   tf->codes[14207] = 0x00016e7a97e4084cUL;
   tf->codes[14208] = 0x00016e8bfa59bec8UL;
   tf->codes[14209] = 0x00016e9ce7b169baUL;
   tf->codes[14210] = 0x00016e9f6bd6a931UL;
   tf->codes[14211] = 0x00016ea34f560b46UL;
   tf->codes[14212] = 0x00016ea598ec44f8UL;
   tf->codes[14213] = 0x00016ebb8e8e6ed8UL;
   tf->codes[14214] = 0x00016ecb91aa02b6UL;
   tf->codes[14215] = 0x00016ee5a55a9470UL;
   tf->codes[14216] = 0x00016ee7b461c85dUL;
   tf->codes[14217] = 0x00016eec0cff35fcUL;
   tf->codes[14218] = 0x00016ef95166849eUL;
   tf->codes[14219] = 0x00016f01c8125a17UL;
   tf->codes[14220] = 0x00016f0411a893c9UL;
   tf->codes[14221] = 0x00016f186d619546UL;
   tf->codes[14222] = 0x00016f1bdbc2ebd1UL;
   tf->codes[14223] = 0x00016f22b88598e7UL;
   tf->codes[14224] = 0x00016f23dd50b5c0UL;
   tf->codes[14225] = 0x00016f2aba1362d6UL;
   tf->codes[14226] = 0x00016f395dd4d416UL;
   tf->codes[14227] = 0x00016f3af7bdfc79UL;
   tf->codes[14228] = 0x00016f42499eb519UL;
   tf->codes[14229] = 0x00016f483c254b1bUL;
   tf->codes[14230] = 0x00016f5d0cfc5822UL;
   tf->codes[14231] = 0x00016f6374a0f9aeUL;
   tf->codes[14232] = 0x00016f6792af6188UL;
   tf->codes[14233] = 0x00016f80bc23dc2eUL;
   tf->codes[14234] = 0x00016f9517dcddabUL;
   tf->codes[14235] = 0x00016fb015c98679UL;
   tf->codes[14236] = 0x00016fb6b7fd2dcaUL;
   tf->codes[14237] = 0x00016fecb3d67f66UL;
   tf->codes[14238] = 0x00016ff7e9369a1bUL;
   tf->codes[14239] = 0x00016ffbccb5fc30UL;
   tf->codes[14240] = 0x0001701c0d7c29b1UL;
   tf->codes[14241] = 0x0001702533d51079UL;
   tf->codes[14242] = 0x0001702e94bcfd06UL;
   tf->codes[14243] = 0x00017032783c5f1bUL;
   tf->codes[14244] = 0x0001703a3f3b2345UL;
   tf->codes[14245] = 0x0001703b9e9545e3UL;
   tf->codes[14246] = 0x0001703c13b3516dUL;
   tf->codes[14247] = 0x00017045af2a43bfUL;
   tf->codes[14248] = 0x0001705db3d3a18cUL;
   tf->codes[14249] = 0x00017062818f1ab5UL;
   tf->codes[14250] = 0x00017079d68b6733UL;
   tf->codes[14251] = 0x0001707d0a5db7f9UL;
   tf->codes[14252] = 0x0001708bae1f2939UL;
   tf->codes[14253] = 0x0001708f919e8b4eUL;
   tf->codes[14254] = 0x000170a9a54f1d08UL;
   tf->codes[14255] = 0x000170ac29745c7fUL;
   tf->codes[14256] = 0x000170ba5817c235UL;
   tf->codes[14257] = 0x000170d5cb22768dUL;
   tf->codes[14258] = 0x000170e7a2b63893UL;
   tf->codes[14259] = 0x000170eef496f133UL;
   tf->codes[14260] = 0x000170f55c3b92bfUL;
   tf->codes[14261] = 0x000170fbfe6f3a10UL;
   tf->codes[14262] = 0x00017100570ca7afUL;
   tf->codes[14263] = 0x000171022b84d5d7UL;
   tf->codes[14264] = 0x000171076e5e5a8aUL;
   tf->codes[14265] = 0x000171081e0b6bd9UL;
   tf->codes[14266] = 0x0001710b8c6cc264UL;
   tf->codes[14267] = 0x00017111f41163f0UL;
   tf->codes[14268] = 0x00017115d790c605UL;
   tf->codes[14269] = 0x0001711ceee278e0UL;
   tf->codes[14270] = 0x00017125a01d541eUL;
   tf->codes[14271] = 0x0001712f76234c35UL;
   tf->codes[14272] = 0x0001713b95bf7dfeUL;
   tf->codes[14273] = 0x000171440c6b5377UL;
   tf->codes[14274] = 0x0001715917d16643UL;
   tf->codes[14275] = 0x00017166d156c06fUL;
   tf->codes[14276] = 0x0001716aef652849UL;
   tf->codes[14277] = 0x00017183a3bb9765UL;
   tf->codes[14278] = 0x0001718a45ef3eb6UL;
   tf->codes[14279] = 0x000171a877ae384aUL;
   tf->codes[14280] = 0x000171adba87bcfdUL;
   tf->codes[14281] = 0x000171b546f77b62UL;
   tf->codes[14282] = 0x000171bbae9c1ceeUL;
   tf->codes[14283] = 0x000171bea7df67efUL;
   tf->codes[14284] = 0x000171c1a122b2f0UL;
   tf->codes[14285] = 0x000171c1dbb1b8b5UL;
   tf->codes[14286] = 0x000171c50f84097bUL;
   tf->codes[14287] = 0x000171d9a5cc10bdUL;
   tf->codes[14288] = 0x000171e0bd1dc398UL;
   tf->codes[14289] = 0x000171e9a8e7a49bUL;
   tf->codes[14290] = 0x000171ffd918d440UL;
   tf->codes[14291] = 0x00017200c354eb54UL;
   tf->codes[14292] = 0x00017207daa69e2fUL;
   tf->codes[14293] = 0x0001722437ed699bUL;
   tf->codes[14294] = 0x0001723a681e9940UL;
   tf->codes[14295] = 0x0001723fe58723b8UL;
   tf->codes[14296] = 0x00017240cfc33accUL;
   tf->codes[14297] = 0x0001724771f6e21dUL;
   tf->codes[14298] = 0x00017252e1e60297UL;
   tf->codes[14299] = 0x000172590efb9e5eUL;
   tf->codes[14300] = 0x0001725f3c113a25UL;
   tf->codes[14301] = 0x0001727a39fde2f3UL;
   tf->codes[14302] = 0x00017289c7fb6b47UL;
   tf->codes[14303] = 0x00017292ee54520fUL;
   tf->codes[14304] = 0x00017295e7979d10UL;
   tf->codes[14305] = 0x000172965cb5a89aUL;
   tf->codes[14306] = 0x0001729d74075b75UL;
   tf->codes[14307] = 0x000172b3a4388b1aUL;
   tf->codes[14308] = 0x000172c0ae10d3f7UL;
   tf->codes[14309] = 0x000172df1a5ed350UL;
   tf->codes[14310] = 0x000172f794263ca7UL;
   tf->codes[14311] = 0x000172fd118ec71fUL;
   tf->codes[14312] = 0x00017300ba7f236fUL;
   tf->codes[14313] = 0x00017302c986575cUL;
   tf->codes[14314] = 0x000173049dfe8584UL;
   tf->codes[14315] = 0x00017305131c910eUL;
   tf->codes[14316] = 0x000173137c4efc89UL;
   tf->codes[14317] = 0x0001731b08bebaeeUL;
   tf->codes[14318] = 0x00017331e89cfbe2UL;
   tf->codes[14319] = 0x0001733347f71e80UL;
   tf->codes[14320] = 0x00017341017c78acUL;
   tf->codes[14321] = 0x0001734385a1b823UL;
   tf->codes[14322] = 0x0001735bff69217aUL;
   tf->codes[14323] = 0x0001735e838e60f1UL;
   tf->codes[14324] = 0x00017365d56f1991UL;
   tf->codes[14325] = 0x00017379817b09bfUL;
   tf->codes[14326] = 0x0001737a31281b0eUL;
   tf->codes[14327] = 0x00017385a1173b88UL;
   tf->codes[14328] = 0x000173973e1bf7c9UL;
   tf->codes[14329] = 0x00017399129425f1UL;
   tf->codes[14330] = 0x0001739c80f57c7cUL;
   tf->codes[14331] = 0x000173a2e89a1e08UL;
   tf->codes[14332] = 0x000173a6918a7a58UL;
   tf->codes[14333] = 0x000173a8a091ae45UL;
   tf->codes[14334] = 0x000173a9c55ccb1eUL;
   tf->codes[14335] = 0x000173aa3a7ad6a8UL;
   tf->codes[14336] = 0x000173b61f8802acUL;
   tf->codes[14337] = 0x000173bff58dfac3UL;
   tf->codes[14338] = 0x000173d576121919UL;
   tf->codes[14339] = 0x000173e53e9ea732UL;
   tf->codes[14340] = 0x000173e8e78f0382UL;
   tf->codes[14341] = 0x000173ea0c5a205bUL;
   tf->codes[14342] = 0x000173eaf696376fUL;
   tf->codes[14343] = 0x000173fa0f75b439UL;
   tf->codes[14344] = 0x0001740001fc4a3bUL;
   tf->codes[14345] = 0x0001740544d5ceeeUL;
   tf->codes[14346] = 0x0001740ac23e5966UL;
   tf->codes[14347] = 0x0001741b3a77f8ceUL;
   tf->codes[14348] = 0x000174207d517d81UL;
   tf->codes[14349] = 0x0001742ac8758122UL;
   tf->codes[14350] = 0x0001742ee683e8fcUL;
   tf->codes[14351] = 0x0001743379b05c60UL;
   tf->codes[14352] = 0x000174349e7b7939UL;
   tf->codes[14353] = 0x000174425800d365UL;
   tf->codes[14354] = 0x00017446b09e4104UL;
   tf->codes[14355] = 0x00017455c97dbdceUL;
   tf->codes[14356] = 0x00017458fd500e94UL;
   tf->codes[14357] = 0x000174625e37fb21UL;
   tf->codes[14358] = 0x00017465920a4be7UL;
   tf->codes[14359] = 0x00017469eaa7b986UL;
   tf->codes[14360] = 0x0001747978a541daUL;
   tf->codes[14361] = 0x0001747bc23b7b8cUL;
   tf->codes[14362] = 0x0001748906a2ca2eUL;
   tf->codes[14363] = 0x000174997edc6996UL;
   tf->codes[14364] = 0x0001749ced3dc021UL;
   tf->codes[14365] = 0x000174ac40ac42b0UL;
   tf->codes[14366] = 0x000174bb598bbf7aUL;
   tf->codes[14367] = 0x000174c44555a07dUL;
   tf->codes[14368] = 0x000174df08b34386UL;
   tf->codes[14369] = 0x000174e953d74727UL;
   tf->codes[14370] = 0x000174f44ea85c17UL;
   tf->codes[14371] = 0x000174fa069fec54UL;
   tf->codes[14372] = 0x000174fd3a723d1aUL;
   tf->codes[14373] = 0x000175171393c90fUL;
   tf->codes[14374] = 0x0001751ccb8b594cUL;
   tf->codes[14375] = 0x00017538040707dfUL;
   tf->codes[14376] = 0x0001753c5ca4757eUL;
   tf->codes[14377] = 0x00017541da0cfff6UL;
   tf->codes[14378] = 0x0001755c9d6aa2ffUL;
   tf->codes[14379] = 0x0001755d1288ae89UL;
   tf->codes[14380] = 0x0001756847e8c93eUL;
   tf->codes[14381] = 0x0001756d15a44267UL;
   tf->codes[14382] = 0x0001756eaf8d6acaUL;
   tf->codes[14383] = 0x0001757a949a96ceUL;
   tf->codes[14384] = 0x0001758a22981f22UL;
   tf->codes[14385] = 0x000175aa9ded5268UL;
   tf->codes[14386] = 0x000175b7a7c59b45UL;
   tf->codes[14387] = 0x000175c610f806c0UL;
   tf->codes[14388] = 0x000175d180e7273aUL;
   tf->codes[14389] = 0x000175ee8ddb03f5UL;
   tf->codes[14390] = 0x000175ef78171b09UL;
   tf->codes[14391] = 0x000175f4f57fa581UL;
   tf->codes[14392] = 0x000175f779a4e4f8UL;
   tf->codes[14393] = 0x00017606928461c2UL;
   tf->codes[14394] = 0x0001760aeb21cf61UL;
   tf->codes[14395] = 0x0001761919c53517UL;
   tf->codes[14396] = 0x0001761a3e9051f0UL;
   tf->codes[14397] = 0x0001761c88268ba2UL;
   tf->codes[14398] = 0x00017626d34a8f43UL;
   tf->codes[14399] = 0x0001763b69929685UL;
   tf->codes[14400] = 0x00017644ca7a8312UL;
   tf->codes[14401] = 0x00017647892ec84eUL;
   tf->codes[14402] = 0x00017652be8ee303UL;
   tf->codes[14403] = 0x00017658b1157905UL;
   tf->codes[14404] = 0x000176619cdf5a08UL;
   tf->codes[14405] = 0x0001766545cfb658UL;
   tf->codes[14406] = 0x000176880abb2350UL;
   tf->codes[14407] = 0x0001768bb3ab7fa0UL;
   tf->codes[14408] = 0x000176a29389c094UL;
   tf->codes[14409] = 0x000176a601eb171fUL;
   tf->codes[14410] = 0x000176abb9e2a75cUL;
   tf->codes[14411] = 0x000176ca2630a6b5UL;
   tf->codes[14412] = 0x000176cb106cbdc9UL;
   tf->codes[14413] = 0x000176e55eac5548UL;
   tf->codes[14414] = 0x000176ec75fe0823UL;
   tf->codes[14415] = 0x000176f17e488711UL;
   tf->codes[14416] = 0x00017705da01888eUL;
   tf->codes[14417] = 0x0001771c0a32b833UL;
   tf->codes[14418] = 0x0001771c7f50c3bdUL;
   tf->codes[14419] = 0x0001771f03760334UL;
   tf->codes[14420] = 0x0001771fedb21a48UL;
   tf->codes[14421] = 0x00017724464f87e7UL;
   tf->codes[14422] = 0x0001773658724fb2UL;
   tf->codes[14423] = 0x0001773c8587eb79UL;
   tf->codes[14424] = 0x00017752f04820e3UL;
   tf->codes[14425] = 0x0001775539de5a95UL;
   tf->codes[14426] = 0x0001779d47da73fcUL;
   tf->codes[14427] = 0x000177a12b59d611UL;
   tf->codes[14428] = 0x000177b636bfe8ddUL;
   tf->codes[14429] = 0x000177bcd8f3902eUL;
   tf->codes[14430] = 0x000177bf97a7d56aUL;
   tf->codes[14431] = 0x000177c4da815a1dUL;
   tf->codes[14432] = 0x000177c9e2cbd90bUL;
   tf->codes[14433] = 0x000177de3e84da88UL;
   tf->codes[14434] = 0x000177e4a6297c14UL;
   tf->codes[14435] = 0x0001780bc3b256abUL;
   tf->codes[14436] = 0x00017817a8bf82afUL;
   tf->codes[14437] = 0x000178264c80f3efUL;
   tf->codes[14438] = 0x00017826fc2e053eUL;
   tf->codes[14439] = 0x00017827abdb168dUL;
   tf->codes[14440] = 0x00017841bf8ba847UL;
   tf->codes[14441] = 0x0001784b9591a05eUL;
   tf->codes[14442] = 0x0001784fb3a00838UL;
   tf->codes[14443] = 0x0001785b238f28b2UL;
   tf->codes[14444] = 0x000178656eb32c53UL;
   tf->codes[14445] = 0x000178732838867fUL;
   tf->codes[14446] = 0x00017875373fba6cUL;
   tf->codes[14447] = 0x0001787a3f8a395aUL;
   tf->codes[14448] = 0x0001788574ea540fUL;
   tf->codes[14449] = 0x000178995b854a02UL;
   tf->codes[14450] = 0x000178aa836bfab9UL;
   tf->codes[14451] = 0x000178b8b20f606fUL;
   tf->codes[14452] = 0x000178cac432283aUL;
   tf->codes[14453] = 0x000178eb7a166145UL;
   tf->codes[14454] = 0x000178fbb7c0fae8UL;
   tf->codes[14455] = 0x0001791606009267UL;
   tf->codes[14456] = 0x0001792a61b993e4UL;
   tf->codes[14457] = 0x0001793437bf8bfbUL;
   tf->codes[14458] = 0x0001793c73dc5bafUL;
   tf->codes[14459] = 0x000179459a354277UL;
   tf->codes[14460] = 0x000179538e49a268UL;
   tf->codes[14461] = 0x00017971fa97a1c1UL;
   tf->codes[14462] = 0x0001797e1a33d38aUL;
   tf->codes[14463] = 0x00017989ff40ff8eUL;
   tf->codes[14464] = 0x0001799ab209a4bbUL;
   tf->codes[14465] = 0x000179aaefb43e5eUL;
   tf->codes[14466] = 0x000179ba7db1c6b2UL;
   tf->codes[14467] = 0x000179bed64f3451UL;
   tf->codes[14468] = 0x000179c453b7bec9UL;
   tf->codes[14469] = 0x000179c99691437cUL;
   tf->codes[14470] = 0x000179cd04f29a07UL;
   tf->codes[14471] = 0x000179dd7d2c396fUL;
   tf->codes[14472] = 0x000179eafc228dd6UL;
   tf->codes[14473] = 0x00017a012c53bd7bUL;
   tf->codes[14474] = 0x00017a1fd330c299UL;
   tf->codes[14475] = 0x00017a280f4d924dUL;
   tf->codes[14476] = 0x00017a29e3c5c075UL;
   tf->codes[14477] = 0x00017a3010db5c3cUL;
   tf->codes[14478] = 0x00017a346978c9dbUL;
   tf->codes[14479] = 0x00017a3937344304UL;
   tf->codes[14480] = 0x00017a3a5bff5fddUL;
   tf->codes[14481] = 0x00017a3d5542aadeUL;
   tf->codes[14482] = 0x00017a46b62a976bUL;
   tf->codes[14483] = 0x00017a472b48a2f5UL;
   tf->codes[14484] = 0x00017a4a99a9f980UL;
   tf->codes[14485] = 0x00017a5a27a781d4UL;
   tf->codes[14486] = 0x00017a7560233067UL;
   tf->codes[14487] = 0x00017a86c298e6e3UL;
   tf->codes[14488] = 0x00017a9bcdfef9afUL;
   tf->codes[14489] = 0x00017a9cb83b10c3UL;
   tf->codes[14490] = 0x00017a9e52243926UL;
   tf->codes[14491] = 0x00017aa0269c674eUL;
   tf->codes[14492] = 0x00017aa27032a100UL;
   tf->codes[14493] = 0x00017aa89d483cc7UL;
   tf->codes[14494] = 0x00017aaa3731652aUL;
   tf->codes[14495] = 0x00017ac77eb447aaUL;
   tf->codes[14496] = 0x00017ac82e6158f9UL;
   tf->codes[14497] = 0x00017ad781cfdb88UL;
   tf->codes[14498] = 0x00017aded3b09428UL;
   tf->codes[14499] = 0x00017ae157d5d39fUL;
   tf->codes[14500] = 0x00017ae48ba82465UL;
   tf->codes[14501] = 0x00017afdefaba4d0UL;
   tf->codes[14502] = 0x00017b01989c0120UL;
   tf->codes[14503] = 0x00017b08ea7cb9c0UL;
   tf->codes[14504] = 0x00017b1001ce6c9bUL;
   tf->codes[14505] = 0x00017b15b9c5fcd8UL;
   tf->codes[14506] = 0x00017b1928275363UL;
   tf->codes[14507] = 0x00017b1d4635bb3dUL;
   tf->codes[14508] = 0x00017b3e7137ffd2UL;
   tf->codes[14509] = 0x00017b4b408142eaUL;
   tf->codes[14510] = 0x00017b5f271c38ddUL;
   tf->codes[14511] = 0x00017b62d00c952dUL;
   tf->codes[14512] = 0x00017b63452aa0b7UL;
   tf->codes[14513] = 0x00017ba64adc3b30UL;
   tf->codes[14514] = 0x00017bb73833e622UL;
   tf->codes[14515] = 0x00017bbbcb605986UL;
   tf->codes[14516] = 0x00017bc26d9400d7UL;
   tf->codes[14517] = 0x00017bc47c9b34c4UL;
   tf->codes[14518] = 0x00017bcc4399f8eeUL;
   tf->codes[14519] = 0x00017bd09c37668dUL;
   tf->codes[14520] = 0x00017bde904bc67eUL;
   tf->codes[14521] = 0x00017bf8a3fc5838UL;
   tf->codes[14522] = 0x00017bfbd7cea8feUL;
   tf->codes[14523] = 0x00017c186fa47a2fUL;
   tf->codes[14524] = 0x00017c2be1216498UL;
   tf->codes[14525] = 0x00017c320e37005fUL;
   tf->codes[14526] = 0x00017c55484078e1UL;
   tf->codes[14527] = 0x00017c5cd4b03746UL;
   tf->codes[14528] = 0x00017c66aab62f5dUL;
   tf->codes[14529] = 0x00017c6a53a68badUL;
   tf->codes[14530] = 0x00017c6b7871a886UL;
   tf->codes[14531] = 0x00017c74643b8989UL;
   tf->codes[14532] = 0x00017c76add1c33bUL;
   tf->codes[14533] = 0x00017c84dc7528f1UL;
   tf->codes[14534] = 0x00017c8acefbbef3UL;
   tf->codes[14535] = 0x00017c8b098ac4b8UL;
   tf->codes[14536] = 0x00017c951a1fc294UL;
   tf->codes[14537] = 0x00017c988881191fUL;
   tf->codes[14538] = 0x00017c9e05e9a397UL;
   tf->codes[14539] = 0x00017caa6014db25UL;
   tf->codes[14540] = 0x00017cbc7237a2f0UL;
   tf->codes[14541] = 0x00017cc29f4d3eb7UL;
   tf->codes[14542] = 0x00017cc6483d9b07UL;
   tf->codes[14543] = 0x00017ccd5f8f4de2UL;
   tf->codes[14544] = 0x00017cdb1914a80eUL;
   tf->codes[14545] = 0x00017ceaa7123062UL;
   tf->codes[14546] = 0x00017cf68c1f5c66UL;
   tf->codes[14547] = 0x00017cfe8dad2655UL;
   tf->codes[14548] = 0x00017d0de11ba8e4UL;
   tf->codes[14549] = 0x00017d1692568422UL;
   tf->codes[14550] = 0x00017d17f1b0a6c0UL;
   tf->codes[14551] = 0x00017d29c94468c6UL;
   tf->codes[14552] = 0x00017d34c4157db6UL;
   tf->codes[14553] = 0x00017d3d755058f4UL;
   tf->codes[14554] = 0x00017d3dea6e647eUL;
   tf->codes[14555] = 0x00017d48aab073a9UL;
   tf->codes[14556] = 0x00017d6e68df2ba2UL;
   tf->codes[14557] = 0x00017d7963b04092UL;
   tf->codes[14558] = 0x00017d8dbf69420fUL;
   tf->codes[14559] = 0x00017d98451c4b75UL;
   tf->codes[14560] = 0x00017db51781226bUL;
   tf->codes[14561] = 0x00017dbdc8bbfda9UL;
   tf->codes[14562] = 0x00017dc5ca49c798UL;
   tf->codes[14563] = 0x00017dc76432effbUL;
   tf->codes[14564] = 0x00017dc9733a23e8UL;
   tf->codes[14565] = 0x00017ddbfa7af73dUL;
   tf->codes[14566] = 0x00017de595f1e98fUL;
   tf->codes[14567] = 0x00017df97c8cdf82UL;
   tf->codes[14568] = 0x00017dfc00b21ef9UL;
   tf->codes[14569] = 0x00017dffa9a27b49UL;
   tf->codes[14570] = 0x00017e01f338b4fbUL;
   tf->codes[14571] = 0x00017e0cb37ac426UL;
   tf->codes[14572] = 0x00017e1564b59f64UL;
   tf->codes[14573] = 0x00017e159f44a529UL;
   tf->codes[14574] = 0x00017e1ae21e29dcUL;
   tf->codes[14575] = 0x00017e210f33c5a3UL;
   tf->codes[14576] = 0x00017e289ba38408UL;
   tf->codes[14577] = 0x00017e5fbc47f27dUL;
   tf->codes[14578] = 0x00017e62f01a4343UL;
   tf->codes[14579] = 0x00017e7661972dacUL;
   tf->codes[14580] = 0x00017e79204b72e8UL;
   tf->codes[14581] = 0x00017e7995697e72UL;
   tf->codes[14582] = 0x00017e7aba349b4bUL;
   tf->codes[14583] = 0x00017e99d62fabf3UL;
   tf->codes[14584] = 0x00017e9a85dcbd42UL;
   tf->codes[14585] = 0x00017ea2876a8731UL;
   tf->codes[14586] = 0x00017ea45be2b559UL;
   tf->codes[14587] = 0x00017ea5bb3cd7f7UL;
   tf->codes[14588] = 0x00017ea78fb5061fUL;
   tf->codes[14589] = 0x00017eaa4e694b5bUL;
   tf->codes[14590] = 0x00017ebb764ffc12UL;
   tf->codes[14591] = 0x00017ec5fc030578UL;
   tf->codes[14592] = 0x00017eddc61d5d80UL;
   tf->codes[14593] = 0x00017eef9db11f86UL;
   tf->codes[14594] = 0x00017ef25c6564c2UL;
   tf->codes[14595] = 0x00017ef973b7179dUL;
   tf->codes[14596] = 0x00017efc6cfa629eUL;
   tf->codes[14597] = 0x00017f0976d2ab7bUL;
   tf->codes[14598] = 0x00017f0b85d9df68UL;
   tf->codes[14599] = 0x00017f4bccd734a5UL;
   tf->codes[14600] = 0x00017f54f3301b6dUL;
   tf->codes[14601] = 0x00017f6321d38123UL;
   tf->codes[14602] = 0x00017f77b81b8865UL;
   tf->codes[14603] = 0x00017fa19458a838UL;
   tf->codes[14604] = 0x00017fa95b576c62UL;
   tf->codes[14605] = 0x00017faa8022893bUL;
   tf->codes[14606] = 0x00017fb20c9247a0UL;
   tf->codes[14607] = 0x00017fb7c489d7ddUL;
   tf->codes[14608] = 0x00017fbbe2983fb7UL;
   tf->codes[14609] = 0x00017fbedbdb8ab8UL;
   tf->codes[14610] = 0x00017fc20faddb7eUL;
   tf->codes[14611] = 0x00017fc9d6ac9fa8UL;
   tf->codes[14612] = 0x00017fcf1986245bUL;
   tf->codes[14613] = 0x00017fd5469bc022UL;
   tf->codes[14614] = 0x00017fd6e084e885UL;
   tf->codes[14615] = 0x00017fdbae4061aeUL;
   tf->codes[14616] = 0x00017fe215e5033aUL;
   tf->codes[14617] = 0x00018015187b09d5UL;
   tf->codes[14618] = 0x000180163d4626aeUL;
   tf->codes[14619] = 0x000180246be98c64UL;
   tf->codes[14620] = 0x0001804178dd691fUL;
   tf->codes[14621] = 0x000180656293f2f0UL;
   tf->codes[14622] = 0x0001806b8fa98eb7UL;
   tf->codes[14623] = 0x0001806efe0ae542UL;
   tf->codes[14624] = 0x0001807f01267920UL;
   tf->codes[14625] = 0x00018087b261545eUL;
   tf->codes[14626] = 0x00018088277f5fe8UL;
   tf->codes[14627] = 0x000180977aede277UL;
   tf->codes[14628] = 0x0001809b5e6d448cUL;
   tf->codes[14629] = 0x000180b5e73be1d0UL;
   tf->codes[14630] = 0x000180dd79e2c7f1UL;
   tf->codes[14631] = 0x000180edf21c6759UL;
   tf->codes[14632] = 0x000180f9620b87d3UL;
   tf->codes[14633] = 0x000180fd458ae9e8UL;
   tf->codes[14634] = 0x00018107561fe7c4UL;
   tf->codes[14635] = 0x0001811375bc198dUL;
   tf->codes[14636] = 0x0001811e35fe28b8UL;
   tf->codes[14637] = 0x00018121a45f7f43UL;
   tf->codes[14638] = 0x0001812bef8382e4UL;
   tf->codes[14639] = 0x0001812e73a8c25bUL;
   tf->codes[14640] = 0x000181593a21f942UL;
   tf->codes[14641] = 0x0001815d1da15b57UL;
   tf->codes[14642] = 0x00018167dde36a82UL;
   tf->codes[14643] = 0x000181776be0f2d6UL;
   tf->codes[14644] = 0x000181881ea99803UL;
   tf->codes[14645] = 0x00018198d1723d30UL;
   tf->codes[14646] = 0x0001819d2a0faacfUL;
   tf->codes[14647] = 0x000181a3cc435220UL;
   tf->codes[14648] = 0x000181a441615daaUL;
   tf->codes[14649] = 0x000181a4f10e6ef9UL;
   tf->codes[14650] = 0x000181b23575bd9bUL;
   tf->codes[14651] = 0x000181c5a6f2a804UL;
   tf->codes[14652] = 0x000181c7f088e1b6UL;
   tf->codes[14653] = 0x000181dde62b0b96UL;
   tf->codes[14654] = 0x000181e62247db4aUL;
   tf->codes[14655] = 0x000181eb9fb065c2UL;
   tf->codes[14656] = 0x000181fdb1d32d8dUL;
   tf->codes[14657] = 0x00018202ba1dac7bUL;
   tf->codes[14658] = 0x0001820369cabdcaUL;
   tf->codes[14659] = 0x000182141c9362f7UL;
   tf->codes[14660] = 0x00018216a0b8a26eUL;
   tf->codes[14661] = 0x00018216db47a833UL;
   tf->codes[14662] = 0x0001821e67b76698UL;
   tf->codes[14663] = 0x00018225447a13aeUL;
   tf->codes[14664] = 0x0001823c5ee75a67UL;
   tf->codes[14665] = 0x000182433baa077dUL;
   tf->codes[14666] = 0x0001824a52fbba58UL;
   tf->codes[14667] = 0x00018257d1f20ebfUL;
   tf->codes[14668] = 0x0001825dff07aa86UL;
   tf->codes[14669] = 0x0001826257a51825UL;
   tf->codes[14670] = 0x0001826bb88d04b2UL;
   tf->codes[14671] = 0x0001827ca5e4afa4UL;
   tf->codes[14672] = 0x000182b81f268bb8UL;
   tf->codes[14673] = 0x000182df3caf664fUL;
   tf->codes[14674] = 0x000182f1fe7f3f69UL;
   tf->codes[14675] = 0x000182faea49206cUL;
   tf->codes[14676] = 0x000182fbd4853780UL;
   tf->codes[14677] = 0x000182fc49a3430aUL;
   tf->codes[14678] = 0x0001830a7846a8c0UL;
   tf->codes[14679] = 0x0001831831cc02ecUL;
   tf->codes[14680] = 0x0001833a470a5e95UL;
   tf->codes[14681] = 0x00018343e28150e7UL;
   tf->codes[14682] = 0x000183562f331e77UL;
   tf->codes[14683] = 0x00018367cc37dab8UL;
   tf->codes[14684] = 0x0001837167aecd0aUL;
   tf->codes[14685] = 0x00018399e491ca3fUL;
   tf->codes[14686] = 0x000183a38008bc91UL;
   tf->codes[14687] = 0x000183a6042dfc08UL;
   tf->codes[14688] = 0x000183b25e593396UL;
   tf->codes[14689] = 0x000183b93b1be0acUL;
   tf->codes[14690] = 0x000183d891a5f719UL;
   tf->codes[14691] = 0x000183db8ae9421aUL;
   tf->codes[14692] = 0x000183f3ca21a5acUL;
   tf->codes[14693] = 0x00018423d3746146UL;
   tf->codes[14694] = 0x000184265799a0bdUL;
   tf->codes[14695] = 0x00018430dd4caa23UL;
   tf->codes[14696] = 0x0001843ff62c26edUL;
   tf->codes[14697] = 0x000184406b4a3277UL;
   tf->codes[14698] = 0x00018446d2eed403UL;
   tf->codes[14699] = 0x000184511e12d7a4UL;
   tf->codes[14700] = 0x00018456d60a67e1UL;
   tf->codes[14701] = 0x00018461212e6b82UL;
   tf->codes[14702] = 0x00018465eee9e4abUL;
   tf->codes[14703] = 0x00018478b0b9bdc5UL;
   tf->codes[14704] = 0x0001847b34defd3cUL;
   tf->codes[14705] = 0x00018482fbddc166UL;
   tf->codes[14706] = 0x00018499a12cfc95UL;
   tf->codes[14707] = 0x000184a8ba0c795fUL;
   tf->codes[14708] = 0x000184b9a7642451UL;
   tf->codes[14709] = 0x000184d9ad9b4c0dUL;
   tf->codes[14710] = 0x000184e6f2029aafUL;
   tf->codes[14711] = 0x000184eb10110289UL;
   tf->codes[14712] = 0x000184ed1f183676UL;
   tf->codes[14713] = 0x000184fc7286b905UL;
   tf->codes[14714] = 0x0001850a2c0c1331UL;
   tf->codes[14715] = 0x0001851402120b48UL;
   tf->codes[14716] = 0x00018514ec4e225cUL;
   tf->codes[14717] = 0x0001851686374abfUL;
   tf->codes[14718] = 0x0001851f377225fdUL;
   tf->codes[14719] = 0x0001852021ae3d11UL;
   tf->codes[14720] = 0x0001852230b570feUL;
   tf->codes[14721] = 0x00018527e8ad013bUL;
   tf->codes[14722] = 0x0001852b919d5d8bUL;
   tf->codes[14723] = 0x0001853826579adeUL;
   tf->codes[14724] = 0x0001853ec88b422fUL;
   tf->codes[14725] = 0x0001854062746a92UL;
   tf->codes[14726] = 0x00018553244443acUL;
   tf->codes[14727] = 0x0001857d759f6f09UL;
   tf->codes[14728] = 0x000185971431f539UL;
   tf->codes[14729] = 0x0001859af7b1574eUL;
   tf->codes[14730] = 0x000185b8b4524558UL;
   tf->codes[14731] = 0x000185cc25cf2fc1UL;
   tf->codes[14732] = 0x000185d5c1462213UL;
   tf->codes[14733] = 0x000185e4da259eddUL;
   tf->codes[14734] = 0x000185e6397fc17bUL;
   tf->codes[14735] = 0x000185ff9d8341e6UL;
   tf->codes[14736] = 0x000186060527e372UL;
   tf->codes[14737] = 0x00018629b44f677eUL;
   tf->codes[14738] = 0x00018639b76afb5cUL;
   tf->codes[14739] = 0x0001863c3b903ad3UL;
   tf->codes[14740] = 0x000186431852e7e9UL;
   tf->codes[14741] = 0x00018647e60e6112UL;
   tf->codes[14742] = 0x00018657740be966UL;
   tf->codes[14743] = 0x00018675a5cae2faUL;
   tf->codes[14744] = 0x0001867f7bd0db11UL;
   tf->codes[14745] = 0x0001869aeedb8f69UL;
   tf->codes[14746] = 0x000186a44fc37bf6UL;
   tf->codes[14747] = 0x000186a5748e98cfUL;
   tf->codes[14748] = 0x000186da862bd357UL;
   tf->codes[14749] = 0x000186e50bdedcbdUL;
   tf->codes[14750] = 0x00018701a3b4adeeUL;
   tf->codes[14751] = 0x00018702c87fcac7UL;
   tf->codes[14752] = 0x0001871a929a22cfUL;
   tf->codes[14753] = 0x0001873fdbaacf3eUL;
   tf->codes[14754] = 0x00018755219fe7cfUL;
   tf->codes[14755] = 0x000187638ad2534aUL;
   tf->codes[14756] = 0x00018769f276f4d6UL;
   tf->codes[14757] = 0x0001876e85a3683aUL;
   tf->codes[14758] = 0x0001877f386c0d67UL;
   tf->codes[14759] = 0x0001877fe8191eb6UL;
   tf->codes[14760] = 0x0001878f7616a70aUL;
   tf->codes[14761] = 0x00018799c13aaaabUL;
   tf->codes[14762] = 0x0001879a3658b635UL;
   tf->codes[14763] = 0x000187ade264a663UL;
   tf->codes[14764] = 0x000187cbd9949a32UL;
   tf->codes[14765] = 0x000187dd76995673UL;
   tf->codes[14766] = 0x000187e4c87a0f13UL;
   tf->codes[14767] = 0x000187e95ba68277UL;
   tf->codes[14768] = 0x000187f5b5d1ba05UL;
   tf->codes[14769] = 0x000187fb6dc94a42UL;
   tf->codes[14770] = 0x0001880a118abb82UL;
   tf->codes[14771] = 0x00018822c5e12a9eUL;
   tf->codes[14772] = 0x000188250f776450UL;
   tf->codes[14773] = 0x00018839e04e7157UL;
   tf->codes[14774] = 0x0001883b7a3799baUL;
   tf->codes[14775] = 0x0001883e38ebdef6UL;
   tf->codes[14776] = 0x000188463a79a8e5UL;
   tf->codes[14777] = 0x00018848be9ee85cUL;
   tf->codes[14778] = 0x0001884bf2713922UL;
   tf->codes[14779] = 0x0001885bbafdc73bUL;
   tf->codes[14780] = 0x0001886ef1ebabdfUL;
   tf->codes[14781] = 0x00018887a6421afbUL;
   tf->codes[14782] = 0x00018892a1132febUL;
   tf->codes[14783] = 0x00018897e3ecb49eUL;
   tf->codes[14784] = 0x0001889d26c63951UL;
   tf->codes[14785] = 0x000188bd2cfd610dUL;
   tf->codes[14786] = 0x000188d8da971b2aUL;
   tf->codes[14787] = 0x000188d98a442c79UL;
   tf->codes[14788] = 0x000188e5a9e05e42UL;
   tf->codes[14789] = 0x000188e6ceab7b1bUL;
   tf->codes[14790] = 0x000188e7f37697f4UL;
   tf->codes[14791] = 0x000188ef45575094UL;
   tf->codes[14792] = 0x000188f3d883c3f8UL;
   tf->codes[14793] = 0x000188f41312c9bdUL;
   tf->codes[14794] = 0x000188f86bb0375cUL;
   tf->codes[14795] = 0x000188ff0de3deadUL;
   tf->codes[14796] = 0x000188ff4872e472UL;
   tf->codes[14797] = 0x00018905006a74afUL;
   tf->codes[14798] = 0x00018913debaebb4UL;
   tf->codes[14799] = 0x00018915edc21fa1UL;
   tf->codes[14800] = 0x0001891b309ba454UL;
   tf->codes[14801] = 0x0001892247ed572fUL;
   tf->codes[14802] = 0x0001893a8725bac1UL;
   tf->codes[14803] = 0x0001894163e867d7UL;
   tf->codes[14804] = 0x00018942c3428a75UL;
   tf->codes[14805] = 0x000189454767c9ecUL;
   tf->codes[14806] = 0x000189466c32e6c5UL;
   tf->codes[14807] = 0x00018949a005378bUL;
   tf->codes[14808] = 0x00018956e46c862dUL;
   tf->codes[14809] = 0x0001895d4c1127b9UL;
   tf->codes[14810] = 0x0001896f98c2f549UL;
   tf->codes[14811] = 0x000189779a50bf38UL;
   tf->codes[14812] = 0x000189842f0afc8bUL;
   tf->codes[14813] = 0x000189a67ed85df9UL;
   tf->codes[14814] = 0x000189a88ddf91e6UL;
   tf->codes[14815] = 0x000189b5d246e088UL;
   tf->codes[14816] = 0x000189bfa84cd89fUL;
   tf->codes[14817] = 0x000189c6fa2d913fUL;
   tf->codes[14818] = 0x000189d90c50590aUL;
   tf->codes[14819] = 0x000189e1f81a3a0dUL;
   tf->codes[14820] = 0x000189e357745cabUL;
   tf->codes[14821] = 0x000189e3cc926835UL;
   tf->codes[14822] = 0x00018a02e88d78ddUL;
   tf->codes[14823] = 0x00018a035dab8467UL;
   tf->codes[14824] = 0x00018a04bd05a705UL;
   tf->codes[14825] = 0x00018a12016cf5a7UL;
   tf->codes[14826] = 0x00018a14c0213ae3UL;
   tf->codes[14827] = 0x00018a24fdcbd486UL;
   tf->codes[14828] = 0x00018a2956694225UL;
   tf->codes[14829] = 0x00018a2990f847eaUL;
   tf->codes[14830] = 0x00018a2ab5c364c3UL;
   tf->codes[14831] = 0x00018a2b65707612UL;
   tf->codes[14832] = 0x00018a311d68064fUL;
   tf->codes[14833] = 0x00018a327cc228edUL;
   tf->codes[14834] = 0x00018a3d02753253UL;
   tf->codes[14835] = 0x00018a3d3d043818UL;
   tf->codes[14836] = 0x00018a3e9c5e5ab6UL;
   tf->codes[14837] = 0x00018a40e5f49468UL;
   tf->codes[14838] = 0x00018a469dec24a5UL;
   tf->codes[14839] = 0x00018a59252cf7faUL;
   tf->codes[14840] = 0x00018a5d7dca6599UL;
   tf->codes[14841] = 0x00018a766cafda7aUL;
   tf->codes[14842] = 0x00018a7a502f3c8fUL;
   tf->codes[14843] = 0x00018a8042b5d291UL;
   tf->codes[14844] = 0x00018a80f262e3e0UL;
   tf->codes[14845] = 0x00018a83eba62ee1UL;
   tf->codes[14846] = 0x00018a8ac868dbf7UL;
   tf->codes[14847] = 0x00018a99e14858c1UL;
   tf->codes[14848] = 0x00018aa8bf98cfc6UL;
   tf->codes[14849] = 0x00018aaf9c5b7cdcUL;
   tf->codes[14850] = 0x00018ac089b327ceUL;
   tf->codes[14851] = 0x00018ae34e9e94c6UL;
   tf->codes[14852] = 0x00018af6c01b7f2fUL;
   tf->codes[14853] = 0x00018af94440bea6UL;
   tf->codes[14854] = 0x00018afbc865fe1dUL;
   tf->codes[14855] = 0x00018afefc384ee3UL;
   tf->codes[14856] = 0x00018b07e8022fe6UL;
   tf->codes[14857] = 0x00018b18d559dad8UL;
   tf->codes[14858] = 0x00018b1fb21c87eeUL;
   tf->codes[14859] = 0x00018b2619c1297aUL;
   tf->codes[14860] = 0x00018b2aaced9cdeUL;
   tf->codes[14861] = 0x00018b2fefc72191UL;
   tf->codes[14862] = 0x00018b3c84815ee4UL;
   tf->codes[14863] = 0x00018b45e5694b71UL;
   tf->codes[14864] = 0x00018b4f80e03dc3UL;
   tf->codes[14865] = 0x00018b54c3b9c276UL;
   tf->codes[14866] = 0x00018b5e24a1af03UL;
   tf->codes[14867] = 0x00018b63dc993f40UL;
   tf->codes[14868] = 0x00018b6bde27092fUL;
   tf->codes[14869] = 0x00018b6ffc357109UL;
   tf->codes[14870] = 0x00018b7d060db9e6UL;
   tf->codes[14871] = 0x00018b828376445eUL;
   tf->codes[14872] = 0x00018b8925a9ebafUL;
   tf->codes[14873] = 0x00018b9f906a2119UL;
   tf->codes[14874] = 0x00018ba75768e543UL;
   tf->codes[14875] = 0x00018bad847e810aUL;
   tf->codes[14876] = 0x00018bb87f4f95faUL;
   tf->codes[14877] = 0x00018bba1938be5dUL;
   tf->codes[14878] = 0x00018bbf96a148d5UL;
   tf->codes[14879] = 0x00018bc1e0378287UL;
   tf->codes[14880] = 0x00018bd8faa4c940UL;
   tf->codes[14881] = 0x00018be58f5f0693UL;
   tf->codes[14882] = 0x00018be79e663a80UL;
   tf->codes[14883] = 0x00018bf557eb94acUL;
   tf->codes[14884] = 0x00018bf5cd09a036UL;
   tf->codes[14885] = 0x00018c05d0253414UL;
   tf->codes[14886] = 0x00018c060ab439d9UL;
   tf->codes[14887] = 0x00018c1ebf0aa8f5UL;
   tf->codes[14888] = 0x00018c3e5023c527UL;
   tf->codes[14889] = 0x00018c57eeb64b57UL;
   tf->codes[14890] = 0x00018c5b5d17a1e2UL;
   tf->codes[14891] = 0x00018c635ea56bd1UL;
   tf->codes[14892] = 0x00018c865e1fde8eUL;
   tf->codes[14893] = 0x00018c87bd7a012cUL;
   tf->codes[14894] = 0x00018c99cf9cc8f7UL;
   tf->codes[14895] = 0x00018c9ffcb264beUL;
   tf->codes[14896] = 0x00018cb1d44626c4UL;
   tf->codes[14897] = 0x00018cc16243af18UL;
   tf->codes[14898] = 0x00018cc62fff2841UL;
   tf->codes[14899] = 0x00018ce1dd98e25eUL;
   tf->codes[14900] = 0x00018ce54bfa38e9UL;
   tf->codes[14901] = 0x00018ce8f4ea9539UL;
   tf->codes[14902] = 0x00018cf798ac0679UL;
   tf->codes[14903] = 0x00018d042d6643ccUL;
   tf->codes[14904] = 0x00018d0935b0c2baUL;
   tf->codes[14905] = 0x00018d125c09a982UL;
   tf->codes[14906] = 0x00018d225f253d60UL;
   tf->codes[14907] = 0x00018d6bcc7b7965UL;
   tf->codes[14908] = 0x00018d83d124d732UL;
   tf->codes[14909] = 0x00018da3d75bfeeeUL;
   tf->codes[14910] = 0x00018da8dfa67ddcUL;
   tf->codes[14911] = 0x00018db4c4b3a9e0UL;
   tf->codes[14912] = 0x00018dbb2c584b6cUL;
   tf->codes[14913] = 0x00018dd36b90aefeUL;
   tf->codes[14914] = 0x00018dda48535c14UL;
   tf->codes[14915] = 0x00018de508956b3fUL;
   tf->codes[14916] = 0x00018dfee1b6f734UL;
   tf->codes[14917] = 0x00018e075862ccadUL;
   tf->codes[14918] = 0x00018e14623b158aUL;
   tf->codes[14919] = 0x00018e1b046ebcdbUL;
   tf->codes[14920] = 0x00018e22564f757bUL;
   tf->codes[14921] = 0x00018e2305fc86caUL;
   tf->codes[14922] = 0x00018e3eb39640e7UL;
   tf->codes[14923] = 0x00018e4939494a4dUL;
   tf->codes[14924] = 0x00018e567db098efUL;
   tf->codes[14925] = 0x00018e5bfb192367UL;
   tf->codes[14926] = 0x00018e613df2a81aUL;
   tf->codes[14927] = 0x00018e63126ad642UL;
   tf->codes[14928] = 0x00018e65969015b9UL;
   tf->codes[14929] = 0x00018e6a29bc891dUL;
   tf->codes[14930] = 0x00018e7091612aa9UL;
   tf->codes[14931] = 0x00018e72a0685e96UL;
   tf->codes[14932] = 0x00018e7b8c323f99UL;
   tf->codes[14933] = 0x00018e8945b799c5UL;
   tf->codes[14934] = 0x00018ea06024e07eUL;
   tf->codes[14935] = 0x00018eafee2268d2UL;
   tf->codes[14936] = 0x00018eca01d2fa8cUL;
   tf->codes[14937] = 0x00018ecab1800bdbUL;
   tf->codes[14938] = 0x00018ecff459908eUL;
   tf->codes[14939] = 0x00018ee032042a31UL;
   tf->codes[14940] = 0x00018eedb0fa7e98UL;
   tf->codes[14941] = 0x00018efc8f4af59dUL;
   tf->codes[14942] = 0x00018f0281d18b9fUL;
   tf->codes[14943] = 0x00018f041bbab402UL;
   tf->codes[14944] = 0x00018f0edbfcc32dUL;
   tf->codes[14945] = 0x00018f35f9859dc4UL;
   tf->codes[14946] = 0x00018f47968a5a05UL;
   tf->codes[14947] = 0x00018f663d675f23UL;
   tf->codes[14948] = 0x00018f78c4a83278UL;
   tf->codes[14949] = 0x00018f85ce807b55UL;
   tf->codes[14950] = 0x00018f91b38da759UL;
   tf->codes[14951] = 0x00018f9a2a397cd2UL;
   tf->codes[14952] = 0x00018faefb1089d9UL;
   tf->codes[14953] = 0x00018fb8d11681f0UL;
   tf->codes[14954] = 0x00018fbae01db5ddUL;
   tf->codes[14955] = 0x00018fdc45af0037UL;
   tf->codes[14956] = 0x00018fe9c4a5549eUL;
   tf->codes[14957] = 0x00018ffc1157222eUL;
   tf->codes[14958] = 0x0001900b2a369ef8UL;
   tf->codes[14959] = 0x0001900bd9e3b047UL;
   tf->codes[14960] = 0x0001901db177724dUL;
   tf->codes[14961] = 0x0001901dec067812UL;
   tf->codes[14962] = 0x00019026282347c6UL;
   tf->codes[14963] = 0x0001903a494d437eUL;
   tf->codes[14964] = 0x0001903fc6b5cdf6UL;
   tf->codes[14965] = 0x00019047c84397e5UL;
   tf->codes[14966] = 0x000190483d61a36fUL;
   tf->codes[14967] = 0x0001904877f0a934UL;
   tf->codes[14968] = 0x00019053e7dfc9aeUL;
   tf->codes[14969] = 0x000190649aa86edbUL;
   tf->codes[14970] = 0x0001906bec89277bUL;
   tf->codes[14971] = 0x0001908291d862aaUL;
   tf->codes[14972] = 0x00019083b6a37f83UL;
   tf->codes[14973] = 0x000190937f300d9cUL;
   tf->codes[14974] = 0x000190967873589dUL;
   tf->codes[14975] = 0x00019097282069ecUL;
   tf->codes[14976] = 0x00019099ac45a963UL;
   tf->codes[14977] = 0x0001909bbb4cdd50UL;
   tf->codes[14978] = 0x0001909fd95b452aUL;
   tf->codes[14979] = 0x000190b05194e492UL;
   tf->codes[14980] = 0x000190c38882c936UL;
   tf->codes[14981] = 0x000190d59aa59101UL;
   tf->codes[14982] = 0x000190da2dd20465UL;
   tf->codes[14983] = 0x0001911c83d68d8fUL;
   tf->codes[14984] = 0x0001912744189cbaUL;
   tf->codes[14985] = 0x0001912dabbd3e46UL;
   tf->codes[14986] = 0x000191391bac5ec0UL;
   tf->codes[14987] = 0x000191587236752dUL;
   tf->codes[14988] = 0x0001917962a9b3fdUL;
   tf->codes[14989] = 0x0001917ac203d69bUL;
   tf->codes[14990] = 0x0001917c215df939UL;
   tf->codes[14991] = 0x00019186a711029fUL;
   tf->codes[14992] = 0x0001918756be13eeUL;
   tf->codes[14993] = 0x0001918d0eb5a42bUL;
   tf->codes[14994] = 0x0001918dbe62b57aUL;
   tf->codes[14995] = 0x00019192c6ad3468UL;
   tf->codes[14996] = 0x000191a79784416fUL;
   tf->codes[14997] = 0x000191a8bc4f5e48UL;
   tf->codes[14998] = 0x000191a9e11a7b21UL;
   tf->codes[14999] = 0x000191ab05e597faUL;
   tf->codes[15000] = 0x000191abb592a949UL;
   tf->codes[15001] = 0x000191bace722613UL;
   tf->codes[15002] = 0x000191bf619e9977UL;
   tf->codes[15003] = 0x000191d139325b7dUL;
   tf->codes[15004] = 0x000191e2268a066fUL;
   tf->codes[15005] = 0x000191f229a59a4dUL;
   tf->codes[15006] = 0x000192122fdcc209UL;
   tf->codes[15007] = 0x00019216fd983b32UL;
   tf->codes[15008] = 0x0001921aa6889782UL;
   tf->codes[15009] = 0x0001921d653cdcbeUL;
   tf->codes[15010] = 0x0001921e14e9ee0dUL;
   tf->codes[15011] = 0x0001925a7867e135UL;
   tf->codes[15012] = 0x000192670d221e88UL;
   tf->codes[15013] = 0x0001927a7e9f08f1UL;
   tf->codes[15014] = 0x0001927f4c5a821aUL;
   tf->codes[15015] = 0x0001927fc1788da4UL;
   tf->codes[15016] = 0x00019287fd955d58UL;
   tf->codes[15017] = 0x000192b791ca0d68UL;
   tf->codes[15018] = 0x000192bbafd87542UL;
   tf->codes[15019] = 0x000192c426844abbUL;
   tf->codes[15020] = 0x000192d8823d4c38UL;
   tf->codes[15021] = 0x000192d931ea5d87UL;
   tf->codes[15022] = 0x000192e0be5a1becUL;
   tf->codes[15023] = 0x000192e3427f5b63UL;
   tf->codes[15024] = 0x000192e9e4b302b4UL;
   tf->codes[15025] = 0x000192f0fc04b58fUL;
   tf->codes[15026] = 0x000192f51a131d69UL;
   tf->codes[15027] = 0x000192fe05dcfe6cUL;
   tf->codes[15028] = 0x000192fe406c0431UL;
   tf->codes[15029] = 0x00019307dbe2f683UL;
   tf->codes[15030] = 0x000193126195ffe9UL;
   tf->codes[15031] = 0x000193160a865c39UL;
   tf->codes[15032] = 0x00019318541c95ebUL;
   tf->codes[15033] = 0x0001931c722afdc5UL;
   tf->codes[15034] = 0x00019325d312ea52UL;
   tf->codes[15035] = 0x000193423059b5beUL;
   tf->codes[15036] = 0x00019361fc01d7b5UL;
   tf->codes[15037] = 0x0001936f40692657UL;
   tf->codes[15038] = 0x00019372743b771dUL;
   tf->codes[15039] = 0x000193748342ab0aUL;
   tf->codes[15040] = 0x0001937ece66aeabUL;
   tf->codes[15041] = 0x0001937fb8a2c5bfUL;
   tf->codes[15042] = 0x000193820238ff71UL;
   tf->codes[15043] = 0x000193939f3dbbb2UL;
   tf->codes[15044] = 0x00019398326a2f16UL;
   tf->codes[15045] = 0x0001939dea61bf53UL;
   tf->codes[15046] = 0x000193a6267e8f07UL;
   tf->codes[15047] = 0x000193aaf43a0830UL;
   tf->codes[15048] = 0x000193af4cd775cfUL;
   tf->codes[15049] = 0x000193affc84871eUL;
   tf->codes[15050] = 0x000193b15bdea9bcUL;
   tf->codes[15051] = 0x000193bdb609e14aUL;
   tf->codes[15052] = 0x000193c1d4184924UL;
   tf->codes[15053] = 0x000193c6a1d3c24dUL;
   tf->codes[15054] = 0x000193c6dc62c812UL;
   tf->codes[15055] = 0x000193c925f901c4UL;
   tf->codes[15056] = 0x000193c99b170d4eUL;
   tf->codes[15057] = 0x000193cabfe22a27UL;
   tf->codes[15058] = 0x000193d9d8c1a6f1UL;
   tf->codes[15059] = 0x000193dfcb483cf3UL;
   tf->codes[15060] = 0x000193e2c48b87f4UL;
   tf->codes[15061] = 0x000193f92f4bbd5eUL;
   tf->codes[15062] = 0x0001940255a4a426UL;
   tf->codes[15063] = 0x000194051458e962UL;
   tf->codes[15064] = 0x00019411a91326b5UL;
   tf->codes[15065] = 0x00019421ac2eba93UL;
   tf->codes[15066] = 0x000194246ae2ffcfUL;
   tf->codes[15067] = 0x0001942764264ad0UL;
   tf->codes[15068] = 0x00019428fe0f7333UL;
   tf->codes[15069] = 0x00019429adbc8482UL;
   tf->codes[15070] = 0x0001942b8234b2aaUL;
   tf->codes[15071] = 0x0001945a2c2d4ba6UL;
   tf->codes[15072] = 0x0001945c75c38558UL;
   tf->codes[15073] = 0x0001945fa995d61eUL;
   tf->codes[15074] = 0x0001947fea5c039fUL;
   tf->codes[15075] = 0x000194809a0914eeUL;
   tf->codes[15076] = 0x00019484086a6b79UL;
   tf->codes[15077] = 0x00019489faf1017bUL;
   tf->codes[15078] = 0x0001949b97f5bdbcUL;
   tf->codes[15079] = 0x000194a61da8c722UL;
   tf->codes[15080] = 0x000194af4401adeaUL;
   tf->codes[15081] = 0x000194bc4dd9f6c7UL;
   tf->codes[15082] = 0x000194bf0c8e3c03UL;
   tf->codes[15083] = 0x000194c44f67c0b6UL;
   tf->codes[15084] = 0x000194eaf7d28fc3UL;
   tf->codes[15085] = 0x000194f5b8149eeeUL;
   tf->codes[15086] = 0x0001951424629e47UL;
   tf->codes[15087] = 0x0001951583bcc0e5UL;
   tf->codes[15088] = 0x0001951b3bb45122UL;
   tf->codes[15089] = 0x0001951c25f06836UL;
   tf->codes[15090] = 0x0001951d854a8ad4UL;
   tf->codes[15091] = 0x0001952377d120d6UL;
   tf->codes[15092] = 0x0001953a1d205c05UL;
   tf->codes[15093] = 0x000195546b5ff384UL;
   tf->codes[15094] = 0x00019558c3fd6123UL;
   tf->codes[15095] = 0x000195693c37008bUL;
   tf->codes[15096] = 0x0001956a9b912329UL;
   tf->codes[15097] = 0x0001956b10af2eb3UL;
   tf->codes[15098] = 0x00019576f5bc5ab7UL;
   tf->codes[15099] = 0x0001957f31d92a6bUL;
   tf->codes[15100] = 0x000195943d3f3d37UL;
   tf->codes[15101] = 0x000195a390adbfc6UL;
   tf->codes[15102] = 0x000195bc7f9334a7UL;
   tf->codes[15103] = 0x000195c112bfa80bUL;
   tf->codes[15104] = 0x000195c4f63f0a20UL;
   tf->codes[15105] = 0x000195c705463e0dUL;
   tf->codes[15106] = 0x000195de1fb384c6UL;
   tf->codes[15107] = 0x00019619d384669fUL;
   tf->codes[15108] = 0x0001961edbcee58dUL;
   tf->codes[15109] = 0x00019625f3209868UL;
   tf->codes[15110] = 0x0001962a4bbe0607UL;
   tf->codes[15111] = 0x00019639649d82d1UL;
   tf->codes[15112] = 0x0001963bae33bc83UL;
   tf->codes[15113] = 0x0001964424df91fcUL;
   tf->codes[15114] = 0x00019663f087b3f3UL;
   tf->codes[15115] = 0x00019665c4ffe21bUL;
   tf->codes[15116] = 0x00019666e9cafef4UL;
   tf->codes[15117] = 0x0001967762049e5cUL;
   tf->codes[15118] = 0x000196784c40b570UL;
   tf->codes[15119] = 0x0001967dc9a93fe8UL;
   tf->codes[15120] = 0x00019681e7b7a7c2UL;
   tf->codes[15121] = 0x000196a521c12044UL;
   tf->codes[15122] = 0x000196abfe83cd5aUL;
   tf->codes[15123] = 0x000196b1b67b5d97UL;
   tf->codes[15124] = 0x000196b7e390f95eUL;
   tf->codes[15125] = 0x000196c38e0f1f9dUL;
   tf->codes[15126] = 0x000196e1102107e2UL;
   tf->codes[15127] = 0x000196e777c5a96eUL;
   tf->codes[15128] = 0x000196eb20b605beUL;
   tf->codes[15129] = 0x000196f7b5704311UL;
   tf->codes[15130] = 0x000197002c1c188aUL;
   tf->codes[15131] = 0x0001970917e5f98dUL;
   tf->codes[15132] = 0x0001970b9c0b3904UL;
   tf->codes[15133] = 0x0001971830c57657UL;
   tf->codes[15134] = 0x00019718a5e381e1UL;
   tf->codes[15135] = 0x00019719901f98f5UL;
   tf->codes[15136] = 0x000197245061a820UL;
   tf->codes[15137] = 0x0001972ba24260c0UL;
   tf->codes[15138] = 0x00019738e6a9af62UL;
   tf->codes[15139] = 0x0001973fc36c5c78UL;
   tf->codes[15140] = 0x00019746a02f098eUL;
   tf->codes[15141] = 0x0001974b6dea82b7UL;
   tf->codes[15142] = 0x0001974ba879887cUL;
   tf->codes[15143] = 0x0001975668bb97a7UL;
   tf->codes[15144] = 0x0001975f8f147e6fUL;
   tf->codes[15145] = 0x000197633804dabfUL;
   tf->codes[15146] = 0x00019776a981c528UL;
   tf->codes[15147] = 0x00019777592ed677UL;
   tf->codes[15148] = 0x00019796000bdb95UL;
   tf->codes[15149] = 0x000197aa9653e2d7UL;
   tf->codes[15150] = 0x000197ba24516b2bUL;
   tf->codes[15151] = 0x000197c6b90ba87eUL;
   tf->codes[15152] = 0x000197d29e18d482UL;
   tf->codes[15153] = 0x000197d7e0f25935UL;
   tf->codes[15154] = 0x000197d81b815efaUL;
   tf->codes[15155] = 0x000197db14c4a9fbUL;
   tf->codes[15156] = 0x000197debdb5064bUL;
   tf->codes[15157] = 0x000197e4b03b9c4dUL;
   tf->codes[15158] = 0x0001980148116d7eUL;
   tf->codes[15159] = 0x000198361f1fa241UL;
   tf->codes[15160] = 0x00019842794ad9cfUL;
   tf->codes[15161] = 0x0001984537ff1f0bUL;
   tf->codes[15162] = 0x00019849560d86e5UL;
   tf->codes[15163] = 0x0001986921b5a8dcUL;
   tf->codes[15164] = 0x0001986c1af8f3ddUL;
   tf->codes[15165] = 0x00019881d60c17f8UL;
   tf->codes[15166] = 0x0001988bac12100fUL;
   tf->codes[15167] = 0x000198a54aa4963fUL;
   tf->codes[15168] = 0x000198bb05b7ba5aUL;
   tf->codes[15169] = 0x000198bee9371c6fUL;
   tf->codes[15170] = 0x000198d6b3517477UL;
   tf->codes[15171] = 0x000198f72ea6a7bdUL;
   tf->codes[15172] = 0x000198f93daddbaaUL;
   tf->codes[15173] = 0x000198fe8087605dUL;
   tf->codes[15174] = 0x000198fef5a56be7UL;
   tf->codes[15175] = 0x000199034e42d986UL;
   tf->codes[15176] = 0x0001990522bb07aeUL;
   tf->codes[15177] = 0x0001990bc4eeaeffUL;
   tf->codes[15178] = 0x000199226a3dea2eUL;
   tf->codes[15179] = 0x000199370085f170UL;
   tf->codes[15180] = 0x000199468e8379c4UL;
   tf->codes[15181] = 0x000199656fef84a7UL;
   tf->codes[15182] = 0x0001996694baa180UL;
   tf->codes[15183] = 0x0001998ba33c482aUL;
   tf->codes[15184] = 0x0001999120a4d2a2UL;
   tf->codes[15185] = 0x000199aa0f8a4783UL;
   tf->codes[15186] = 0x000199ba12a5db61UL;
   tf->codes[15187] = 0x000199be30b4433bUL;
   tf->codes[15188] = 0x000199f3b76f894dUL;
   tf->codes[15189] = 0x00019a15ccade4f6UL;
   tf->codes[15190] = 0x00019a193b0f3b81UL;
   tf->codes[15191] = 0x00019a1fa2b3dd0dUL;
   tf->codes[15192] = 0x00019a23fb514aacUL;
   tf->codes[15193] = 0x00019a3bc56ba2b4UL;
   tf->codes[15194] = 0x00019a422d104440UL;
   tf->codes[15195] = 0x00019a464b1eac1aUL;
   tf->codes[15196] = 0x00019a564e3a3ff8UL;
   tf->codes[15197] = 0x00019a6392a18e9aUL;
   tf->codes[15198] = 0x00019a714c26e8c6UL;
   tf->codes[15199] = 0x00019a7b222ce0ddUL;
   tf->codes[15200] = 0x00019a7f05ac42f2UL;
   tf->codes[15201] = 0x00019a8fb874e81fUL;
   tf->codes[15202] = 0x00019a99c909e5fbUL;
   tf->codes[15203] = 0x00019a9a78b6f74aUL;
   tf->codes[15204] = 0x00019aa698532913UL;
   tf->codes[15205] = 0x00019aaba09da801UL;
   tf->codes[15206] = 0x00019ab4c6f68ec9UL;
   tf->codes[15207] = 0x00019ab6d5fdc2b6UL;
   tf->codes[15208] = 0x00019ac997cd9bd0UL;
   tf->codes[15209] = 0x00019ad78be1fbc1UL;
   tf->codes[15210] = 0x00019ae19c76f99dUL;
   tf->codes[15211] = 0x00019ae83eaaa0eeUL;
   tf->codes[15212] = 0x00019aea8840daa0UL;
   tf->codes[15213] = 0x00019af632bf00dfUL;
   tf->codes[15214] = 0x00019b180d6e56c3UL;
   tf->codes[15215] = 0x00019b2a5a202453UL;
   tf->codes[15216] = 0x00019b2d18d4698fUL;
   tf->codes[15217] = 0x00019b3554f13943UL;
   tf->codes[15218] = 0x00019b35ca0f44cdUL;
   tf->codes[15219] = 0x00019b46b766efbfUL;
   tf->codes[15220] = 0x00019b5a9e01e5b2UL;
   tf->codes[15221] = 0x00019b5d5cb62aeeUL;
   tf->codes[15222] = 0x00019b65d3620067UL;
   tf->codes[15223] = 0x00019b73525854ceUL;
   tf->codes[15224] = 0x00019b76110c9a0aUL;
   tf->codes[15225] = 0x00019b89f7a78ffdUL;
   tf->codes[15226] = 0x00019b9b1f8e40b4UL;
   tf->codes[15227] = 0x00019ba530233e90UL;
   tf->codes[15228] = 0x00019bc2b23526d5UL;
   tf->codes[15229] = 0x00019bd57404ffefUL;
   tf->codes[15230] = 0x00019bdc8b56b2caUL;
   tf->codes[15231] = 0x00019bdf8499fdcbUL;
   tf->codes[15232] = 0x00019be2f2fb5456UL;
   tf->codes[15233] = 0x00019c02bea3764dUL;
   tf->codes[15234] = 0x00019c0a85a23a77UL;
   tf->codes[15235] = 0x00019c14d0c63e18UL;
   tf->codes[15236] = 0x00019c21a00f8130UL;
   tf->codes[15237] = 0x00019c46ae9127daUL;
   tf->codes[15238] = 0x00019c48f827618cUL;
   tf->codes[15239] = 0x00019c4b072e9579UL;
   tf->codes[15240] = 0x00019c537dda6af2UL;
   tf->codes[15241] = 0x00019c7e4453a1d9UL;
   tf->codes[15242] = 0x00019c8e476f35b7UL;
   tf->codes[15243] = 0x00019c90567669a4UL;
   tf->codes[15244] = 0x00019c9adc29730aUL;
   tf->codes[15245] = 0x00019cae131757aeUL;
   tf->codes[15246] = 0x00019cb0973c9725UL;
   tf->codes[15247] = 0x00019cb26bb4c54dUL;
   tf->codes[15248] = 0x00019cdf06a62a5cUL;
   tf->codes[15249] = 0x00019ce4be9dba99UL;
   tf->codes[15250] = 0x00019ce742c2fa10UL;
   tf->codes[15251] = 0x00019ceb9b6067afUL;
   tf->codes[15252] = 0x00019d0539f2eddfUL;
   tf->codes[15253] = 0x00019d50b6505dd1UL;
   tf->codes[15254] = 0x00019d5250398634UL;
   tf->codes[15255] = 0x00019d533a759d48UL;
   tf->codes[15256] = 0x00019d59a21a3ed4UL;
   tf->codes[15257] = 0x00019d6512095f4eUL;
   tf->codes[15258] = 0x00019d68806ab5d9UL;
   tf->codes[15259] = 0x00019d7b07ab892eUL;
   tf->codes[15260] = 0x00019d89364eeee4UL;
   tf->codes[15261] = 0x00019d9fdb9e2a13UL;
   tf->codes[15262] = 0x00019da51e77aec6UL;
   tf->codes[15263] = 0x00019da9b1a4222aUL;
   tf->codes[15264] = 0x00019dd9f585e389UL;
   tf->codes[15265] = 0x00019ddbc9fe11b1UL;
   tf->codes[15266] = 0x00019de9f8a17767UL;
   tf->codes[15267] = 0x00019dfbd035396dUL;
   tf->codes[15268] = 0x00019dfcba715081UL;
   tf->codes[15269] = 0x00019e12b0137a61UL;
   tf->codes[15270] = 0x00019e42f3f53bc0UL;
   tf->codes[15271] = 0x00019e49d0b7e8d6UL;
   tf->codes[15272] = 0x00019e5874795a16UL;
   tf->codes[15273] = 0x00019ea3b647c443UL;
   tf->codes[15274] = 0x00019ea75f382093UL;
   tf->codes[15275] = 0x00019eb42e8163abUL;
   tf->codes[15276] = 0x00019ebe04875bc2UL;
   tf->codes[15277] = 0x00019ebfd8ff89eaUL;
   tf->codes[15278] = 0x00019ec0138e8fafUL;
   tf->codes[15279] = 0x00019ec2d242d4ebUL;
   tf->codes[15280] = 0x00019ed434b88b67UL;
   tf->codes[15281] = 0x00019eda273f2169UL;
   tf->codes[15282] = 0x00019edfa4a7abe1UL;
   tf->codes[15283] = 0x00019eeebd8728abUL;
   tf->codes[15284] = 0x00019ef55fbacffcUL;
   tf->codes[15285] = 0x00019efb524165feUL;
   tf->codes[15286] = 0x00019f0aa5afe88dUL;
   tf->codes[15287] = 0x00019f1b58788dbaUL;
   tf->codes[15288] = 0x00019f1c42b4a4ceUL;
   tf->codes[15289] = 0x00019f32e803dffdUL;
   tf->codes[15290] = 0x00019f37f04e5eebUL;
   tf->codes[15291] = 0x00019f3d6db6e963UL;
   tf->codes[15292] = 0x00019f5b64e6dd32UL;
   tf->codes[15293] = 0x00019f87c5493c7cUL;
   tf->codes[15294] = 0x00019faa15169deaUL;
   tf->codes[15295] = 0x00019fac241dd1d7UL;
   tf->codes[15296] = 0x00019fb3eb1c9601UL;
   tf->codes[15297] = 0x00019fc3ee3829dfUL;
   tf->codes[15298] = 0x00019fc4d87440f3UL;
   tf->codes[15299] = 0x00019fe37f514611UL;
   tf->codes[15300] = 0x00019fe4deab68afUL;
   tf->codes[15301] = 0x00019ffca8c5c0b7UL;
   tf->codes[15302] = 0x00019fff677a05f3UL;
   tf->codes[15303] = 0x0001a02316a189ffUL;
   tf->codes[15304] = 0x0001a02943b725c6UL;
   tf->codes[15305] = 0x0001a03737cb85b7UL;
   tf->codes[15306] = 0x0001a037725a8b7cUL;
   tf->codes[15307] = 0x0001a0489a413c33UL;
   tf->codes[15308] = 0x0001a04cf2dea9d2UL;
   tf->codes[15309] = 0x0001a0677bad4716UL;
   tf->codes[15310] = 0x0001a068a07863efUL;
   tf->codes[15311] = 0x0001a07410678469UL;
   tf->codes[15312] = 0x0001a077f3e6e67eUL;
   tf->codes[15313] = 0x0001a08488a123d1UL;
   tf->codes[15314] = 0x0001a084fdbf2f5bUL;
   tf->codes[15315] = 0x0001a08a4098b40eUL;
   tf->codes[15316] = 0x0001a099597830d8UL;
   tf->codes[15317] = 0x0001a0a12076f502UL;
   tf->codes[15318] = 0x0001a0a5b3a36866UL;
   tf->codes[15319] = 0x0001a0ba0f5c69e3UL;
   tf->codes[15320] = 0x0001a0ca1277fdc1UL;
   tf->codes[15321] = 0x0001a0cb71d2205fUL;
   tf->codes[15322] = 0x0001a0d4982b0727UL;
   tf->codes[15323] = 0x0001a0e3767b7e2cUL;
   tf->codes[15324] = 0x0001a0e51064a68fUL;
   tf->codes[15325] = 0x0001a0e84436f755UL;
   tf->codes[15326] = 0x0001a0eac85c36ccUL;
   tf->codes[15327] = 0x0001a0ffd3c24998UL;
   tf->codes[15328] = 0x0001a1080fdf194cUL;
   tf->codes[15329] = 0x0001a113ba5d3f8bUL;
   tf->codes[15330] = 0x0001a1163e827f02UL;
   tf->codes[15331] = 0x0001a1481c4d68c4UL;
   tf->codes[15332] = 0x0001a1bdaf76fe4eUL;
   tf->codes[15333] = 0x0001a1fcd1a936b2UL;
   tf->codes[15334] = 0x0001a200efb79e8cUL;
   tf->codes[15335] = 0x0001a203ae6be3c8UL;
   tf->codes[15336] = 0x0001a21ac8d92a81UL;
   tf->codes[15337] = 0x0001a2275d9367d4UL;
   tf->codes[15338] = 0x0001a227d2b1735eUL;
   tf->codes[15339] = 0x0001a22bf0bfdb38UL;
   tf->codes[15340] = 0x0001a23ca3888065UL;
   tf->codes[15341] = 0x0001a240c196e83fUL;
   tf->codes[15342] = 0x0001a2446a87448fUL;
   tf->codes[15343] = 0x0001a24b0cbaebe0UL;
   tf->codes[15344] = 0x0001a24f9fe75f44UL;
   tf->codes[15345] = 0x0001a27055cb984fUL;
   tf->codes[15346] = 0x0001a27fa93a1adeUL;
   tf->codes[15347] = 0x0001a296c3a76197UL;
   tf->codes[15348] = 0x0001a2bc0cb80e06UL;
   tf->codes[15349] = 0x0001a2c32409c0e1UL;
   tf->codes[15350] = 0x0001a2c82c543fcfUL;
   tf->codes[15351] = 0x0001a2ded1a37afeUL;
   tf->codes[15352] = 0x0001a30280caff0aUL;
   tf->codes[15353] = 0x0001a3103a505936UL;
   tf->codes[15354] = 0x0001a3271a2e9a2aUL;
   tf->codes[15355] = 0x0001a335836105a5UL;
   tf->codes[15356] = 0x0001a33f93f60381UL;
   tf->codes[15357] = 0x0001a34670b8b097UL;
   tf->codes[15358] = 0x0001a3534001f3afUL;
   tf->codes[15359] = 0x0001a363088e81c8UL;
   tf->codes[15360] = 0x0001a364dd06aff0UL;
   tf->codes[15361] = 0x0001a38299a79dfaUL;
   tf->codes[15362] = 0x0001a38bc00084c2UL;
   tf->codes[15363] = 0x0001a38bfa8f8a87UL;
   tf->codes[15364] = 0x0001a38f68f0e112UL;
   tf->codes[15365] = 0x0001a3a01bb9863fUL;
   tf->codes[15366] = 0x0001a3b4777287bcUL;
   tf->codes[15367] = 0x0001a3b97fbd06aaUL;
   tf->codes[15368] = 0x0001a3cbcc6ed43aUL;
   tf->codes[15369] = 0x0001a3d7b17c003eUL;
   tf->codes[15370] = 0x0001a3da35a13fb5UL;
   tf->codes[15371] = 0x0001a3fbd5c18fd4UL;
   tf->codes[15372] = 0x0001a40a3ef3fb4fUL;
   tf->codes[15373] = 0x0001a40f473e7a3dUL;
   tf->codes[15374] = 0x0001a417835b49f1UL;
   tf->codes[15375] = 0x0001a41a07808968UL;
   tf->codes[15376] = 0x0001a449d6443f3dUL;
   tf->codes[15377] = 0x0001a452fc9d2605UL;
   tf->codes[15378] = 0x0001a453ac4a3754UL;
   tf->codes[15379] = 0x0001a45a13eed8e0UL;
   tf->codes[15380] = 0x0001a46f1f54ebacUL;
   tf->codes[15381] = 0x0001a49b7fb74af6UL;
   tf->codes[15382] = 0x0001a4a5904c48d2UL;
   tf->codes[15383] = 0x0001a4bc359b8401UL;
   tf->codes[15384] = 0x0001a4cb13ebfb06UL;
   tf->codes[15385] = 0x0001a4ccadd52369UL;
   tf->codes[15386] = 0x0001a4d2a05bb96bUL;
   tf->codes[15387] = 0x0001a4e1f3ca3bfaUL;
   tf->codes[15388] = 0x0001a5047e26a32dUL;
   tf->codes[15389] = 0x0001a50aab3c3ef4UL;
   tf->codes[15390] = 0x0001a519146eaa6fUL;
   tf->codes[15391] = 0x0001a519c41bbbbeUL;
   tf->codes[15392] = 0x0001a533281f3c29UL;
   tf->codes[15393] = 0x0001a5411c339c1aUL;
   tf->codes[15394] = 0x0001a542f0abca42UL;
   tf->codes[15395] = 0x0001a55418927af9UL;
   tf->codes[15396] = 0x0001a565b597373aUL;
   tf->codes[15397] = 0x0001a57a866e4441UL;
   tf->codes[15398] = 0x0001a57f8eb8c32fUL;
   tf->codes[15399] = 0x0001a5de7c931d8aUL;
   tf->codes[15400] = 0x0001a5e9024626f0UL;
   tf->codes[15401] = 0x0001a5ead6be5518UL;
   tf->codes[15402] = 0x0001a5f437a641a5UL;
   tf->codes[15403] = 0x0001a5f60c1e6fcdUL;
   tf->codes[15404] = 0x0001a61562a8863aUL;
   tf->codes[15405] = 0x0001a61b8fbe2201UL;
   tf->codes[15406] = 0x0001a61bca4d27c6UL;
   tf->codes[15407] = 0x0001a61e4e72673dUL;
   tf->codes[15408] = 0x0001a62022ea9565UL;
   tf->codes[15409] = 0x0001a62147b5b23eUL;
   tf->codes[15410] = 0x0001a6373d57dc1eUL;
   tf->codes[15411] = 0x0001a6402921bd21UL;
   tf->codes[15412] = 0x0001a65bd6bb773eUL;
   tf->codes[15413] = 0x0001a65dab33a566UL;
   tf->codes[15414] = 0x0001a662ee0d2a19UL;
   tf->codes[15415] = 0x0001a670327478bbUL;
   tf->codes[15416] = 0x0001a6770f3725d1UL;
   tf->codes[15417] = 0x0001a691d294c8daUL;
   tf->codes[15418] = 0x0001a69f518b1d41UL;
   tf->codes[15419] = 0x0001a6a99caf20e2UL;
   tf->codes[15420] = 0x0001a6b163ade50cUL;
   tf->codes[15421] = 0x0001a6b19e3cead1UL;
   tf->codes[15422] = 0x0001a6bb39b3dd23UL;
   tf->codes[15423] = 0x0001a6c4d52acf75UL;
   tf->codes[15424] = 0x0001a6db3feb04dfUL;
   tf->codes[15425] = 0x0001a6e3b696da58UL;
   tf->codes[15426] = 0x0001a6ebf2b3aa0cUL;
   tf->codes[15427] = 0x0001a71818870391UL;
   tf->codes[15428] = 0x0001a71a621d3d43UL;
   tf->codes[15429] = 0x0001a7208f32d90aUL;
   tf->codes[15430] = 0x0001a72472b23b1fUL;
   tf->codes[15431] = 0x0001a72856319d34UL;
   tf->codes[15432] = 0x0001a7485c68c4f0UL;
   tf->codes[15433] = 0x0001a76b5be337adUL;
   tf->codes[15434] = 0x0001a76f3f6299c2UL;
   tf->codes[15435] = 0x0001a775e1964113UL;
   tf->codes[15436] = 0x0001a7818c146752UL;
   tf->codes[15437] = 0x0001a7991b9fb995UL;
   tf->codes[15438] = 0x0001a79ab588e1f8UL;
   tf->codes[15439] = 0x0001a79f48b5555cUL;
   tf->codes[15440] = 0x0001a7b6d840a79fUL;
   tf->codes[15441] = 0x0001a7c9d49f867eUL;
   tf->codes[15442] = 0x0001a7cea25affa7UL;
   tf->codes[15443] = 0x0001a7eb74bfd69dUL;
   tf->codes[15444] = 0x0001a7f6aa1ff152UL;
   tf->codes[15445] = 0x0001a80c2aa40fa8UL;
   tf->codes[15446] = 0x0001a81a93d67b23UL;
   tf->codes[15447] = 0x0001a81f9c20fa11UL;
   tf->codes[15448] = 0x0001a828c279e0d9UL;
   tf->codes[15449] = 0x0001a829acb5f7edUL;
   tf->codes[15450] = 0x0001a844aaa2a0bbUL;
   tf->codes[15451] = 0x0001a856f7546e4bUL;
   tf->codes[15452] = 0x0001a861b7967d76UL;
   tf->codes[15453] = 0x0001a866fa700229UL;
   tf->codes[15454] = 0x0001a89de0856ad9UL;
   tf->codes[15455] = 0x0001a8ab9a0ac505UL;
   tf->codes[15456] = 0x0001a8abd499cacaUL;
   tf->codes[15457] = 0x0001a8b5aa9fc2e1UL;
   tf->codes[15458] = 0x0001a8b98e1f24f6UL;
   tf->codes[15459] = 0x0001a8ca40e7ca23UL;
   tf->codes[15460] = 0x0001a8e120c60b17UL;
   tf->codes[15461] = 0x0001a8ff17f5fee6UL;
   tf->codes[15462] = 0x0001a91c9a07e72bUL;
   tf->codes[15463] = 0x0001a936e8477eaaUL;
   tf->codes[15464] = 0x0001a9463bb60139UL;
   tf->codes[15465] = 0x0001a95136871629UL;
   tf->codes[15466] = 0x0001a95a2250f72cUL;
   tf->codes[15467] = 0x0001a95b81ab19caUL;
   tf->codes[15468] = 0x0001a9667c7c2ebaUL;
   tf->codes[15469] = 0x0001a969b04e7f80UL;
   tf->codes[15470] = 0x0001a97a28881ee8UL;
   tf->codes[15471] = 0x0001a981b4f7dd4dUL;
   tf->codes[15472] = 0x0001a987326067c5UL;
   tf->codes[15473] = 0x0001a98ef95f2befUL;
   tf->codes[15474] = 0x0001a9ab1c16f196UL;
   tf->codes[15475] = 0x0001a9c5df74949fUL;
   tf->codes[15476] = 0x0001a9e6203ac220UL;
   tf->codes[15477] = 0x0001a9ea03ba2435UL;
   tf->codes[15478] = 0x0001a9fdafc61463UL;
   tf->codes[15479] = 0x0001aa3be7bc35b3UL;
   tf->codes[15480] = 0x0001aa42c47ee2c9UL;
   tf->codes[15481] = 0x0001aa4548a42240UL;
   tf->codes[15482] = 0x0001aa5bedf35d6fUL;
   tf->codes[15483] = 0x0001aa9fa3520937UL;
   tf->codes[15484] = 0x0001aaab885f353bUL;
   tf->codes[15485] = 0x0001aace87d9a7f8UL;
   tf->codes[15486] = 0x0001aacec268adbdUL;
   tf->codes[15487] = 0x0001aadb1c93e54bUL;
   tf->codes[15488] = 0x0001aae61764fa3bUL;
   tf->codes[15489] = 0x0001aaf4809765b6UL;
   tf->codes[15490] = 0x0001ab00dac29d44UL;
   tf->codes[15491] = 0x0001ab0a3baa89d1UL;
   tf->codes[15492] = 0x0001ab0b6075a6aaUL;
   tf->codes[15493] = 0x0001ab2205c4e1d9UL;
   tf->codes[15494] = 0x0001ab3cc92284e2UL;
   tf->codes[15495] = 0x0001ab441b033d82UL;
   tf->codes[15496] = 0x0001ab5458add725UL;
   tf->codes[15497] = 0x0001ab645bc96b03UL;
   tf->codes[15498] = 0x0001ab66dfeeaa7aUL;
   tf->codes[15499] = 0x0001ab70f083a856UL;
   tf->codes[15500] = 0x0001ab766dec32ceUL;
   tf->codes[15501] = 0x0001ab9674235a8aUL;
   tf->codes[15502] = 0x0001ab99e284b115UL;
   tf->codes[15503] = 0x0001ab9f255e35c8UL;
   tf->codes[15504] = 0x0001abb76496995aUL;
   tf->codes[15505] = 0x0001abbdcc3b3ae6UL;
   tf->codes[15506] = 0x0001abe683ad3de0UL;
   tf->codes[15507] = 0x0001abe81d966643UL;
   tf->codes[15508] = 0x0001abf477c19dd1UL;
   tf->codes[15509] = 0x0001ac0ae281d33bUL;
   tf->codes[15510] = 0x0001ac1e8e8dc369UL;
   tf->codes[15511] = 0x0001ac318aeca248UL;
   tf->codes[15512] = 0x0001ac3658a81b71UL;
   tf->codes[15513] = 0x0001ac74560f36fcUL;
   tf->codes[15514] = 0x0001ac762a876524UL;
   tf->codes[15515] = 0x0001ac7abdb3d888UL;
   tf->codes[15516] = 0x0001ac9f91a6796dUL;
   tf->codes[15517] = 0x0001acba8f93223bUL;
   tf->codes[15518] = 0x0001acbb79cf394fUL;
   tf->codes[15519] = 0x0001acc4dab725dcUL;
   tf->codes[15520] = 0x0001acc7244d5f8eUL;
   tf->codes[15521] = 0x0001accb425bc768UL;
   tf->codes[15522] = 0x0001acd552f0c544UL;
   tf->codes[15523] = 0x0001acfa9c0171b3UL;
   tf->codes[15524] = 0x0001ad0a29fefa07UL;
   tf->codes[15525] = 0x0001ad14afb2036dUL;
   tf->codes[15526] = 0x0001ad19084f710cUL;
   tf->codes[15527] = 0x0001ad1aa238996fUL;
   tf->codes[15528] = 0x0001ad261227b9e9UL;
   tf->codes[15529] = 0x0001ad439439a22eUL;
   tf->codes[15530] = 0x0001ad4b20a96093UL;
   tf->codes[15531] = 0x0001ad78e065e27bUL;
   tf->codes[15532] = 0x0001ad81cc2fc37eUL;
   tf->codes[15533] = 0x0001ad9e9e949a74UL;
   tf->codes[15534] = 0x0001ada15d48dfb0UL;
   tf->codes[15535] = 0x0001ada78a5e7b77UL;
   tf->codes[15536] = 0x0001adb24aa08aa2UL;
   tf->codes[15537] = 0x0001adb668aef27cUL;
   tf->codes[15538] = 0x0001addbec4ea4b0UL;
   tf->codes[15539] = 0x0001addfcfce06c5UL;
   tf->codes[15540] = 0x0001ade49d897feeUL;
   tf->codes[15541] = 0x0001ade5fce3a28cUL;
   tf->codes[15542] = 0x0001ae00fad04b5aUL;
   tf->codes[15543] = 0x0001ae084cb103faUL;
   tf->codes[15544] = 0x0001ae0a96473dacUL;
   tf->codes[15545] = 0x0001ae51f49645c4UL;
   tf->codes[15546] = 0x0001ae66fffc5890UL;
   tf->codes[15547] = 0x0001ae731f988a59UL;
   tf->codes[15548] = 0x0001ae9cfbd5aa2cUL;
   tf->codes[15549] = 0x0001aea5e79f8b2fUL;
   tf->codes[15550] = 0x0001aeacc4623845UL;
   tf->codes[15551] = 0x0001aece64828864UL;
   tf->codes[15552] = 0x0001aee3e506a6baUL;
   tf->codes[15553] = 0x0001aee509d1c393UL;
   tf->codes[15554] = 0x0001aee83da41459UL;
   tf->codes[15555] = 0x0001aef6e1658599UL;
   tf->codes[15556] = 0x0001aef7cba19cadUL;
   tf->codes[15557] = 0x0001aeff58115b12UL;
   tf->codes[15558] = 0x0001af07942e2ac6UL;
   tf->codes[15559] = 0x0001af1bb558267eUL;
   tf->codes[15560] = 0x0001af3d90077c62UL;
   tf->codes[15561] = 0x0001af3dca968227UL;
   tf->codes[15562] = 0x0001af4850498b8dUL;
   tf->codes[15563] = 0x0001af4e08411bcaUL;
   tf->codes[15564] = 0x0001af5bfc557bbbUL;
   tf->codes[15565] = 0x0001af5ef598c6bcUL;
   tf->codes[15566] = 0x0001af61049ffaa9UL;
   tf->codes[15567] = 0x0001af68910fb90eUL;
   tf->codes[15568] = 0x0001af7a2e14754fUL;
   tf->codes[15569] = 0x0001af7fab7cffc7UL;
   tf->codes[15570] = 0x0001af990f808032UL;
   tf->codes[15571] = 0x0001afbc0efaf2efUL;
   tf->codes[15572] = 0x0001afc61f8ff0cbUL;
   tf->codes[15573] = 0x0001afd279bb2859UL;
   tf->codes[15574] = 0x0001afd5e81c7ee4UL;
   tf->codes[15575] = 0x0001afdb6585095cUL;
   tf->codes[15576] = 0x0001b0103c933e1fUL;
   tf->codes[15577] = 0x0001b0149530abbeUL;
   tf->codes[15578] = 0x0001b01f5572bae9UL;
   tf->codes[15579] = 0x0001b03e36dec5ccUL;
   tf->codes[15580] = 0x0001b03f5ba9e2a5UL;
   tf->codes[15581] = 0x0001b054a19efb36UL;
   tf->codes[15582] = 0x0001b05c2e0eb99bUL;
   tf->codes[15583] = 0x0001b06136593889UL;
   tf->codes[15584] = 0x0001b07eb86b20ceUL;
   tf->codes[15585] = 0x0001b083c0b59fbcUL;
   tf->codes[15586] = 0x0001b09906aab84dUL;
   tf->codes[15587] = 0x0001b0a5d5f3fb65UL;
   tf->codes[15588] = 0x0001b0c4b7600648UL;
   tf->codes[15589] = 0x0001b0c860506298UL;
   tf->codes[15590] = 0x0001b0d3d03f8312UL;
   tf->codes[15591] = 0x0001b0d619d5bcc4UL;
   tf->codes[15592] = 0x0001b0e40dea1cb5UL;
   tf->codes[15593] = 0x0001b123a53a60a3UL;
   tf->codes[15594] = 0x0001b1248f7677b7UL;
   tf->codes[15595] = 0x0001b131994ec094UL;
   tf->codes[15596] = 0x0001b139604d84beUL;
   tf->codes[15597] = 0x0001b13df379f822UL;
   tf->codes[15598] = 0x0001b179e1d9dfc0UL;
   tf->codes[15599] = 0x0001b17a9186f10fUL;
   tf->codes[15600] = 0x0001b17acc15f6d4UL;
   tf->codes[15601] = 0x0001b1930b4e5a66UL;
   tf->codes[15602] = 0x0001b1a17480c5e1UL;
   tf->codes[15603] = 0x0001b1b595aac199UL;
   tf->codes[15604] = 0x0001b1c4e9194428UL;
   tf->codes[15605] = 0x0001b1db53d97992UL;
   tf->codes[15606] = 0x0001b1e4ef506be4UL;
   tf->codes[15607] = 0x0001b2156dc13308UL;
   tf->codes[15608] = 0x0001b2218d5d64d1UL;
   tf->codes[15609] = 0x0001b229545c28fbUL;
   tf->codes[15610] = 0x0001b22b63635ce8UL;
   tf->codes[15611] = 0x0001b2411e768103UL;
   tf->codes[15612] = 0x0001b242b85fa966UL;
   tf->codes[15613] = 0x0001b2469bdf0b7bUL;
   tf->codes[15614] = 0x0001b2574ea7b0a8UL;
   tf->codes[15615] = 0x0001b25ea0886948UL;
   tf->codes[15616] = 0x0001b278b438fb02UL;
   tf->codes[15617] = 0x0001b28a16aeb17eUL;
   tf->codes[15618] = 0x0001b291688f6a1eUL;
   tf->codes[15619] = 0x0001b29795a505e5UL;
   tf->codes[15620] = 0x0001b29fd1c1d599UL;
   tf->codes[15621] = 0x0001b2abf15e0762UL;
   tf->codes[15622] = 0x0001b2d7dca25b22UL;
   tf->codes[15623] = 0x0001b2ea295428b2UL;
   tf->codes[15624] = 0x0001b2f1b5c3e717UL;
   tf->codes[15625] = 0x0001b2f60e6154b6UL;
   tf->codes[15626] = 0x0001b2f9f1e0b6cbUL;
   tf->codes[15627] = 0x0001b2fb513ad969UL;
   tf->codes[15628] = 0x0001b2fbc658e4f3UL;
   tf->codes[15629] = 0x0001b30318399d93UL;
   tf->codes[15630] = 0x0001b3073648056dUL;
   tf->codes[15631] = 0x0001b355abe8c060UL;
   tf->codes[15632] = 0x0001b35b9e6f5662UL;
   tf->codes[15633] = 0x0001b39508a9fe89UL;
   tf->codes[15634] = 0x0001b3a371dc6a04UL;
   tf->codes[15635] = 0x0001b3b33a68f81dUL;
   tf->codes[15636] = 0x0001b3bc2632d920UL;
   tf->codes[15637] = 0x0001b3bf5a0529e6UL;
   tf->codes[15638] = 0x0001b3d7241f81eeUL;
   tf->codes[15639] = 0x0001b3e42df7cacbUL;
   tf->codes[15640] = 0x0001b3e9364249b9UL;
   tf->codes[15641] = 0x0001b3f2d1b93c0bUL;
   tf->codes[15642] = 0x0001b3fbbd831d0eUL;
   tf->codes[15643] = 0x0001b413879d7516UL;
   tf->codes[15644] = 0x0001b4201c57b269UL;
   tf->codes[15645] = 0x0001b42aa20abbcfUL;
   tf->codes[15646] = 0x0001b458d6e54941UL;
   tf->codes[15647] = 0x0001b45bd0289442UL;
   tf->codes[15648] = 0x0001b461c2af2a44UL;
   tf->codes[15649] = 0x0001b46864e2d195UL;
   tf->codes[15650] = 0x0001b474847f035eUL;
   tf->codes[15651] = 0x0001b475342c14adUL;
   tf->codes[15652] = 0x0001b4823e045d8aUL;
   tf->codes[15653] = 0x0001b496d44c64ccUL;
   tf->codes[15654] = 0x0001b4a45342b933UL;
   tf->codes[15655] = 0x0001b4af1384c85eUL;
   tf->codes[15656] = 0x0001b4bdf1d53f63UL;
   tf->codes[15657] = 0x0001b4bf8bbe67c6UL;
   tf->codes[15658] = 0x0001b4c3e45bd565UL;
   tf->codes[15659] = 0x0001b4d964dff3bbUL;
   tf->codes[15660] = 0x0001b4f3edae90ffUL;
   tf->codes[15661] = 0x0001b4f9a5a6213cUL;
   tf->codes[15662] = 0x0001b50acd8cd1f3UL;
   tf->codes[15663] = 0x0001b515533fdb59UL;
   tf->codes[15664] = 0x0001b51a20fb5482UL;
   tf->codes[15665] = 0x0001b51dc9ebb0d2UL;
   tf->codes[15666] = 0x0001b52bbe0010c3UL;
   tf->codes[15667] = 0x0001b53434abe63cUL;
   tf->codes[15668] = 0x0001b54bfec63e44UL;
   tf->codes[15669] = 0x0001b55d9bcafa85UL;
   tf->codes[15670] = 0x0001b5643dfea1d6UL;
   tf->codes[15671] = 0x0001b564788da79bUL;
   tf->codes[15672] = 0x0001b571f783fc02UL;
   tf->codes[15673] = 0x0001b586533cfd7fUL;
   tf->codes[15674] = 0x0001b5b7f678e17cUL;
   tf->codes[15675] = 0x0001b5bed33b8e92UL;
   tf->codes[15676] = 0x0001b5c958ee97f8UL;
   tf->codes[15677] = 0x0001b5e7501e8bc7UL;
   tf->codes[15678] = 0x0001b5f509a3e5f3UL;
   tf->codes[15679] = 0x0001b6050cbf79d1UL;
   tf->codes[15680] = 0x0001b60ac4b70a0eUL;
   tf->codes[15681] = 0x0001b6233e7e7365UL;
   tf->codes[15682] = 0x0001b63291ecf5f4UL;
   tf->codes[15683] = 0x0001b65fa1fc668dUL;
   tf->codes[15684] = 0x0001b66a27af6ff3UL;
   tf->codes[15685] = 0x0001b6835123ea99UL;
   tf->codes[15686] = 0x0001b689091b7ad6UL;
   tf->codes[15687] = 0x0001b6959dd5b829UL;
   tf->codes[15688] = 0x0001b69f394caa7bUL;
   tf->codes[15689] = 0x0001b6a05e17c754UL;
   tf->codes[15690] = 0x0001b6a1bd71e9f2UL;
   tf->codes[15691] = 0x0001b6b778850e0dUL;
   tf->codes[15692] = 0x0001b6d02cdb7d29UL;
   tf->codes[15693] = 0x0001b6e06a8616ccUL;
   tf->codes[15694] = 0x0001b6e0dfa42256UL;
   tf->codes[15695] = 0x0001b6fc52aed6aeUL;
   tf->codes[15696] = 0x0001b6fe61b60a9bUL;
   tf->codes[15697] = 0x0001b6fffb9f32feUL;
   tf->codes[15698] = 0x0001b70195885b61UL;
   tf->codes[15699] = 0x0001b7224b6c946cUL;
   tf->codes[15700] = 0x0001b73d83e842ffUL;
   tf->codes[15701] = 0x0001b754d8e48f7dUL;
   tf->codes[15702] = 0x0001b759a6a008a6UL;
   tf->codes[15703] = 0x0001b760f880c146UL;
   tf->codes[15704] = 0x0001b7897563be7bUL;
   tf->codes[15705] = 0x0001b79d216faea9UL;
   tf->codes[15706] = 0x0001b7ba2e638b64UL;
   tf->codes[15707] = 0x0001b7e09c3f54acUL;
   tf->codes[15708] = 0x0001b7e1115d6036UL;
   tf->codes[15709] = 0x0001b7e912eb2a25UL;
   tf->codes[15710] = 0x0001b7fa0042d517UL;
   tf->codes[15711] = 0x0001b7fecdfe4e40UL;
   tf->codes[15712] = 0x0001b812ef2849f8UL;
   tf->codes[15713] = 0x0001b825eb8728d7UL;
   tf->codes[15714] = 0x0001b82626162e9cUL;
   tf->codes[15715] = 0x0001b828351d6289UL;
   tf->codes[15716] = 0x0001b8332fee7779UL;
   tf->codes[15717] = 0x0001b834c9d79fdcUL;
   tf->codes[15718] = 0x0001b838e7e607b6UL;
   tf->codes[15719] = 0x0001b843330a0b57UL;
   tf->codes[15720] = 0x0001b84be444e695UL;
   tf->codes[15721] = 0x0001b85d0c2b974cUL;
   tf->codes[15722] = 0x0001b8619f580ab0UL;
   tf->codes[15723] = 0x0001b866a7a2899eUL;
   tf->codes[15724] = 0x0001b881a58f326cUL;
   tf->codes[15725] = 0x0001b898fa8b7eeaUL;
   tf->codes[15726] = 0x0001b89a1f569bc3UL;
   tf->codes[15727] = 0x0001b89a9474a74dUL;
   tf->codes[15728] = 0x0001b8a0fc1948d9UL;
   tf->codes[15729] = 0x0001b8afda69bfdeUL;
   tf->codes[15730] = 0x0001b8b3f87827b8UL;
   tf->codes[15731] = 0x0001b8bef3493ca8UL;
   tf->codes[15732] = 0x0001b8c5957ce3f9UL;
   tf->codes[15733] = 0x0001b8dd9a2641c6UL;
   tf->codes[15734] = 0x0001b90f77f12b88UL;
   tf->codes[15735] = 0x0001b91c0cab68dbUL;
   tf->codes[15736] = 0x0001b91d6c058b79UL;
   tf->codes[15737] = 0x0001b93ff661f2acUL;
   tf->codes[15738] = 0x0001b95db302e0b6UL;
   tf->codes[15739] = 0x0001b9641aa78242UL;
   tf->codes[15740] = 0x0001b97f18942b10UL;
   tf->codes[15741] = 0x0001b97f8db2369aUL;
   tf->codes[15742] = 0x0001b9a9a47e5c32UL;
   tf->codes[15743] = 0x0001b9b00c22fdbeUL;
   tf->codes[15744] = 0x0001b9b3efa25fd3UL;
   tf->codes[15745] = 0x0001b9b6e8e5aad4UL;
   tf->codes[15746] = 0x0001b9c1e3b6bfc4UL;
   tf->codes[15747] = 0x0001b9d4e0159ea3UL;
   tf->codes[15748] = 0x0001b9e93bcea020UL;
   tf->codes[15749] = 0x0001ba05d3a47151UL;
   tf->codes[15750] = 0x0001ba06bde08865UL;
   tf->codes[15751] = 0x0001ba2405636ae5UL;
   tf->codes[15752] = 0x0001ba3f786e1f3dUL;
   tf->codes[15753] = 0x0001ba40281b308cUL;
   tf->codes[15754] = 0x0001ba4fb618b8e0UL;
   tf->codes[15755] = 0x0001ba5399981af5UL;
   tf->codes[15756] = 0x0001ba5742887745UL;
   tf->codes[15757] = 0x0001ba5aeb78d395UL;
   tf->codes[15758] = 0x0001ba85b1f20a7cUL;
   tf->codes[15759] = 0x0001baca16fdc793UL;
   tf->codes[15760] = 0x0001bafbba39ab90UL;
   tf->codes[15761] = 0x0001bb146e901aacUL;
   tf->codes[15762] = 0x0001bb27e00d0515UL;
   tf->codes[15763] = 0x0001bb2a6432448cUL;
   tf->codes[15764] = 0x0001bb2bfe1b6cefUL;
   tf->codes[15765] = 0x0001bb338a8b2b54UL;
   tf->codes[15766] = 0x0001bb3d6091236bUL;
   tf->codes[15767] = 0x0001bb422e4c9c94UL;
   tf->codes[15768] = 0x0001bba4ffa65904UL;
   tf->codes[15769] = 0x0001bba783cb987bUL;
   tf->codes[15770] = 0x0001bbb194609657UL;
   tf->codes[15771] = 0x0001bbb995ee6046UL;
   tf->codes[15772] = 0x0001bbcfc61f8febUL;
   tf->codes[15773] = 0x0001bbdf541d183fUL;
   tf->codes[15774] = 0x0001bbe128954667UL;
   tf->codes[15775] = 0x0001bbe755aae22eUL;
   tf->codes[15776] = 0x0001bbfa5209c10dUL;
   tf->codes[15777] = 0x0001bbfa8c98c6d2UL;
   tf->codes[15778] = 0x0001bc154ff669dbUL;
   tf->codes[15779] = 0x0001bc330c9757e5UL;
   tf->codes[15780] = 0x0001bc3a23e90ac0UL;
   tf->codes[15781] = 0x0001bc3b48b42799UL;
   tf->codes[15782] = 0x0001bc3fa1519538UL;
   tf->codes[15783] = 0x0001bc74785fc9fbUL;
   tf->codes[15784] = 0x0001bc77ac321ac1UL;
   tf->codes[15785] = 0x0001bc7e13d6bc4dUL;
   tf->codes[15786] = 0x0001bc84f0996963UL;
   tf->codes[15787] = 0x0001bca09e332380UL;
   tf->codes[15788] = 0x0001bca35ce768bcUL;
   tf->codes[15789] = 0x0001bcac0e2243faUL;
   tf->codes[15790] = 0x0001bcb77e116474UL;
   tf->codes[15791] = 0x0001bcbfba2e3428UL;
   tf->codes[15792] = 0x0001bcdc52040559UL;
   tf->codes[15793] = 0x0001bd5887614234UL;
   tf->codes[15794] = 0x0001bd81b3f150b8UL;
   tf->codes[15795] = 0x0001bd8b14d93d45UL;
   tf->codes[15796] = 0x0001bda7722008b1UL;
   tf->codes[15797] = 0x0001bdba33efe1cbUL;
   tf->codes[15798] = 0x0001bdbcb8152142UL;
   tf->codes[15799] = 0x0001bddd6df95a4dUL;
   tf->codes[15800] = 0x0001be065ffa630cUL;
   tf->codes[15801] = 0x0001be1ccaba9876UL;
   tf->codes[15802] = 0x0001be52c693ea12UL;
   tf->codes[15803] = 0x0001be7725687f6dUL;
   tf->codes[15804] = 0x0001be8678d701fcUL;
   tf->codes[15805] = 0x0001be9e7d805fc9UL;
   tf->codes[15806] = 0x0001bea6b99d2f7dUL;
   tf->codes[15807] = 0x0001befe1b07cb73UL;
   tf->codes[15808] = 0x0001bf07f10dc38aUL;
   tf->codes[15809] = 0x0001bf153575122cUL;
   tf->codes[15810] = 0x0001bf198e127fcbUL;
   tf->codes[15811] = 0x0001bf31cd4ae35dUL;
   tf->codes[15812] = 0x0001bf466392ea9fUL;
   tf->codes[15813] = 0x0001bf48729a1e8cUL;
   tf->codes[15814] = 0x0001bf4fff09dcf1UL;
   tf->codes[15815] = 0x0001bf56a13d8442UL;
   tf->codes[15816] = 0x0001bf65ba1d010cUL;
   tf->codes[15817] = 0x0001bf67197723aaUL;
   tf->codes[15818] = 0x0001bf7df955649eUL;
   tf->codes[15819] = 0x0001bf9e74aa97e4UL;
   tf->codes[15820] = 0x0001bfd55ac00094UL;
   tf->codes[15821] = 0x0001bfd60a6d11e3UL;
   tf->codes[15822] = 0x0001bfe4ae2e8323UL;
   tf->codes[15823] = 0x0001bfeb15d324afUL;
   tf->codes[15824] = 0x0001bff560f72850UL;
   tf->codes[15825] = 0x0001bff9b99495efUL;
   tf->codes[15826] = 0x0001bffe87500f18UL;
   tf->codes[15827] = 0x0001c01616db615bUL;
   tf->codes[15828] = 0x0001c01a6f78cefaUL;
   tf->codes[15829] = 0x0001c06451ed1689UL;
   tf->codes[15830] = 0x0001c09211a99871UL;
   tf->codes[15831] = 0x0001c09f909fecd8UL;
   tf->codes[15832] = 0x0001c0b16833aedeUL;
   tf->codes[15833] = 0x0001c0ca91a82984UL;
   tf->codes[15834] = 0x0001c1072fb52271UL;
   tf->codes[15835] = 0x0001c12b53fab207UL;
   tf->codes[15836] = 0x0001c13e8ae896abUL;
   tf->codes[15837] = 0x0001c14b94c0df88UL;
   tf->codes[15838] = 0x0001c154808ac08bUL;
   tf->codes[15839] = 0x0001c169c67fd91cUL;
   tf->codes[15840] = 0x0001c1844f4e7660UL;
   tf->codes[15841] = 0x0001c19dede0fc90UL;
   tf->codes[15842] = 0x0001c19e62ff081aUL;
   tf->codes[15843] = 0x0001c19ed81d13a4UL;
   tf->codes[15844] = 0x0001c1a8e8b21180UL;
   tf->codes[15845] = 0x0001c1aea0a9a1bdUL;
   tf->codes[15846] = 0x0001c1bd7efa18c2UL;
   tf->codes[15847] = 0x0001c1bf537246eaUL;
   tf->codes[15848] = 0x0001c1e670fb2181UL;
   tf->codes[15849] = 0x0001c20517d8269fUL;
   tf->codes[15850] = 0x0001c21bbd2761ceUL;
   tf->codes[15851] = 0x0001c223beb52bbdUL;
   tf->codes[15852] = 0x0001c2334cb2b411UL;
   tf->codes[15853] = 0x0001c236808504d7UL;
   tf->codes[15854] = 0x0001c24ebfbd6869UL;
   tf->codes[15855] = 0x0001c25b5477a5bcUL;
   tf->codes[15856] = 0x0001c263cb237b35UL;
   tf->codes[15857] = 0x0001c265650ca398UL;
   tf->codes[15858] = 0x0001c2705fddb888UL;
   tf->codes[15859] = 0x0001c27393b0094eUL;
   tf->codes[15860] = 0x0001c27aab01bc29UL;
   tf->codes[15861] = 0x0001c280d81757f0UL;
   tf->codes[15862] = 0x0001c28237717a8eUL;
   tf->codes[15863] = 0x0001c290a0a3e609UL;
   tf->codes[15864] = 0x0001c294beb24de3UL;
   tf->codes[15865] = 0x0001c29cc04017d2UL;
   tf->codes[15866] = 0x0001c2a8dfdc499bUL;
   tf->codes[15867] = 0x0001c2de2c0889e8UL;
   tf->codes[15868] = 0x0001c2e19a69e073UL;
   tf->codes[15869] = 0x0001c3016612026aUL;
   tf->codes[15870] = 0x0001c310b98084f9UL;
   tf->codes[15871] = 0x0001c3146270e149UL;
   tf->codes[15872] = 0x0001c3154cacf85dUL;
   tf->codes[15873] = 0x0001c3196abb6037UL;
   tf->codes[15874] = 0x0001c3216c492a26UL;
   tf->codes[15875] = 0x0001c331a9f3c3c9UL;
   tf->codes[15876] = 0x0001c343818785cfUL;
   tf->codes[15877] = 0x0001c34e7c589abfUL;
   tf->codes[15878] = 0x0001c34fdbb2bd5dUL;
   tf->codes[15879] = 0x0001c37d9b6f3f45UL;
   tf->codes[15880] = 0x0001c389807c6b49UL;
   tf->codes[15881] = 0x0001c38dd919d8e8UL;
   tf->codes[15882] = 0x0001c394f06b8bc3UL;
   tf->codes[15883] = 0x0001c398995be813UL;
   tf->codes[15884] = 0x0001c3ab95bac6f2UL;
   tf->codes[15885] = 0x0001c3c35fd51efaUL;
   tf->codes[15886] = 0x0001c3d990064e9fUL;
   tf->codes[15887] = 0x0001c3dcfe67a52aUL;
   tf->codes[15888] = 0x0001c3f3a3b6e059UL;
   tf->codes[15889] = 0x0001c40df1f677d8UL;
   tf->codes[15890] = 0x0001c4162e13478cUL;
   tf->codes[15891] = 0x0001c41c5b28e353UL;
   tf->codes[15892] = 0x0001c42965012c30UL;
   tf->codes[15893] = 0x0001c43eaaf644c1UL;
   tf->codes[15894] = 0x0001c4475c311fffUL;
   tf->codes[15895] = 0x0001c451e1e42965UL;
   tf->codes[15896] = 0x0001c466b2bb366cUL;
   tf->codes[15897] = 0x0001c4893d179d9fUL;
   tf->codes[15898] = 0x0001c48b118fcbc7UL;
   tf->codes[15899] = 0x0001c4913ea5678eUL;
   tf->codes[15900] = 0x0001c493883ba140UL;
   tf->codes[15901] = 0x0001c4b980f95efeUL;
   tf->codes[15902] = 0x0001c4e397c58496UL;
   tf->codes[15903] = 0x0001c5023ea289b4UL;
   tf->codes[15904] = 0x0001c509cb124819UL;
   tf->codes[15905] = 0x0001c50bda197c06UL;
   tf->codes[15906] = 0x0001c520aaf0890dUL;
   tf->codes[15907] = 0x0001c5587b4208d1UL;
   tf->codes[15908] = 0x0001c57a9080647aUL;
   tf->codes[15909] = 0x0001c58bf2f61af6UL;
   tf->codes[15910] = 0x0001c593f483e4e5UL;
   tf->codes[15911] = 0x0001c598c23f5e0eUL;
   tf->codes[15912] = 0x0001c59e0518e2c1UL;
   tf->codes[15913] = 0x0001c5a1e89844d6UL;
   tf->codes[15914] = 0x0001c5aa99d32014UL;
   tf->codes[15915] = 0x0001c5d7e4719672UL;
   tf->codes[15916] = 0x0001c5eaa6416f8cUL;
   tf->codes[15917] = 0x0001c5fe524d5fbaUL;
   tf->codes[15918] = 0x0001c5fec76b6b44UL;
   tf->codes[15919] = 0x0001c60eca86ff22UL;
   tf->codes[15920] = 0x0001c61a3a761f9cUL;
   tf->codes[15921] = 0x0001c653df3fcd88UL;
   tf->codes[15922] = 0x0001c67878a368a8UL;
   tf->codes[15923] = 0x0001c68373747d98UL;
   tf->codes[15924] = 0x0001c68b3a7341c2UL;
   tf->codes[15925] = 0x0001c68c99cd6460UL;
   tf->codes[15926] = 0x0001c69f5b9d3d7aUL;
   tf->codes[15927] = 0x0001c6a0baf76018UL;
   tf->codes[15928] = 0x0001c6beecb659acUL;
   tf->codes[15929] = 0x0001c7110b4770efUL;
   tf->codes[15930] = 0x0001c7748c4e3eaeUL;
   tf->codes[15931] = 0x0001c7791f7ab212UL;
   tf->codes[15932] = 0x0001c77d3d8919ecUL;
   tf->codes[15933] = 0x0001c7a78ee44549UL;
   tf->codes[15934] = 0x0001c7b841acea76UL;
   tf->codes[15935] = 0x0001c7bbb00e4101UL;
   tf->codes[15936] = 0x0001c7c635c14a67UL;
   tf->codes[15937] = 0x0001c7dbb64568bdUL;
   tf->codes[15938] = 0x0001c7e8858eabd5UL;
   tf->codes[15939] = 0x0001c7e9e4e8ce73UL;
   tf->codes[15940] = 0x0001c7eeb2a4479cUL;
   tf->codes[15941] = 0x0001c83cedb5fccaUL;
   tf->codes[15942] = 0x0001c86de144cf78UL;
   tf->codes[15943] = 0x0001c8a06ebcca89UL;
   tf->codes[15944] = 0x0001c8b99831452fUL;
   tf->codes[15945] = 0x0001c8c4cd915fe4UL;
   tf->codes[15946] = 0x0001c8dc228dac62UL;
   tf->codes[15947] = 0x0001c8ddbc76d4c5UL;
   tf->codes[15948] = 0x0001c92087996979UL;
   tf->codes[15949] = 0x0001c96d9de001ceUL;
   tf->codes[15950] = 0x0001c97f7573c3d4UL;
   tf->codes[15951] = 0x0001c99c47d89acaUL;
   tf->codes[15952] = 0x0001c99de1c1c32dUL;
   tf->codes[15953] = 0x0001c9c62415ba9dUL;
   tf->codes[15954] = 0x0001c9c91d59059eUL;
   tf->codes[15955] = 0x0001c9e998ae38e4UL;
   tf->codes[15956] = 0x0001ca559060dc1cUL;
   tf->codes[15957] = 0x0001ca6bfb211186UL;
   tf->codes[15958] = 0x0001cab35970199eUL;
   tf->codes[15959] = 0x0001cac09dd76840UL;
   tf->codes[15960] = 0x0001caca73dd6057UL;
   tf->codes[15961] = 0x0001cadaec16ffbfUL;
   tf->codes[15962] = 0x0001cae39d51dafdUL;
   tf->codes[15963] = 0x0001caf27ba25202UL;
   tf->codes[15964] = 0x0001cb027ebde5e0UL;
   tf->codes[15965] = 0x0001cb0b2ff8c11eUL;
   tf->codes[15966] = 0x0001cb0c1a34d832UL;
   tf->codes[15967] = 0x0001cb257e38589dUL;
   tf->codes[15968] = 0x0001cb4f95047e35UL;
   tf->codes[15969] = 0x0001cb53eda1ebd4UL;
   tf->codes[15970] = 0x0001cb58463f5973UL;
   tf->codes[15971] = 0x0001cb658aa6a815UL;
   tf->codes[15972] = 0x0001cb73442c0241UL;
   tf->codes[15973] = 0x0001cb99ec96d14eUL;
   tf->codes[15974] = 0x0001cba0543b72daUL;
   tf->codes[15975] = 0x0001cba4acd8e079UL;
   tf->codes[15976] = 0x0001cbc5282e13bfUL;
   tf->codes[15977] = 0x0001cbd9f90520c6UL;
   tf->codes[15978] = 0x0001cbe0d5c7cddcUL;
   tf->codes[15979] = 0x0001cbf7b5a60ed0UL;
   tf->codes[15980] = 0x0001cc06ce858b9aUL;
   tf->codes[15981] = 0x0001cc08dd8cbf87UL;
   tf->codes[15982] = 0x0001cc299370f892UL;
   tf->codes[15983] = 0x0001cc3035a49fe3UL;
   tf->codes[15984] = 0x0001cc3194fec281UL;
   tf->codes[15985] = 0x0001cc369d49416fUL;
   tf->codes[15986] = 0x0001cc3d3f7ce8c0UL;
   tf->codes[15987] = 0x0001cc93418d6218UL;
   tf->codes[15988] = 0x0001ccab4636bfe5UL;
   tf->codes[15989] = 0x0001ccab80c5c5aaUL;
   tf->codes[15990] = 0x0001ccbca8ac7661UL;
   tf->codes[15991] = 0x0001ccc51f584bdaUL;
   tf->codes[15992] = 0x0001ccc9b284bf3eUL;
   tf->codes[15993] = 0x0001cccef55e43f1UL;
   tf->codes[15994] = 0x0001cce2dbf939e4UL;
   tf->codes[15995] = 0x0001ccf59dc912feUL;
   tf->codes[15996] = 0x0001ccfcefa9cb9eUL;
   tf->codes[15997] = 0x0001cd07003ec97aUL;
   tf->codes[15998] = 0x0001cd0ddd017690UL;
   tf->codes[15999] = 0x0001cd189d4385bbUL;
   tf->codes[16000] = 0x0001cd1d306ff91fUL;
   tf->codes[16001] = 0x0001cd1fb4953896UL;
   tf->codes[16002] = 0x0001cd22e867895cUL;
   tf->codes[16003] = 0x0001cd3c4c6b09c7UL;
   tf->codes[16004] = 0x0001cd42b40fab53UL;
   tf->codes[16005] = 0x0001cd5d776d4e5cUL;
   tf->codes[16006] = 0x0001cd624528c785UL;
   tf->codes[16007] = 0x0001cd63a482ea23UL;
   tf->codes[16008] = 0x0001cd73e22d83c6UL;
   tf->codes[16009] = 0x0001cd741cbc898bUL;
   tf->codes[16010] = 0x0001cd862edf5156UL;
   tf->codes[16011] = 0x0001cd8ac20bc4baUL;
   tf->codes[16012] = 0x0001cda5104b5c39UL;
   tf->codes[16013] = 0x0001cdab3d60f800UL;
   tf->codes[16014] = 0x0001cdc7d536c931UL;
   tf->codes[16015] = 0x0001cdde7a860460UL;
   tf->codes[16016] = 0x0001cde0feab43d7UL;
   tf->codes[16017] = 0x0001cdfa9d3dca07UL;
   tf->codes[16018] = 0x0001ce06bcd9fbd0UL;
   tf->codes[16019] = 0x0001ce0b1577696fUL;
   tf->codes[16020] = 0x0001ce1610487e5fUL;
   tf->codes[16021] = 0x0001ce19441acf25UL;
   tf->codes[16022] = 0x0001ce1efc125f62UL;
   tf->codes[16023] = 0x0001ce24b409ef9fUL;
   tf->codes[16024] = 0x0001ce540daf99eaUL;
   tf->codes[16025] = 0x0001ce63611e1c79UL;
   tf->codes[16026] = 0x0001ce6b9d3aec2dUL;
   tf->codes[16027] = 0x0001ce73d957bbe1UL;
   tf->codes[16028] = 0x0001ceb9632e95d1UL;
   tf->codes[16029] = 0x0001cecbea6f6926UL;
   tf->codes[16030] = 0x0001cf04df8c05c3UL;
   tf->codes[16031] = 0x0001cf058f391712UL;
   tf->codes[16032] = 0x0001cf1348be713eUL;
   tf->codes[16033] = 0x0001cf1f685aa307UL;
   tf->codes[16034] = 0x0001cf3fe3afd64dUL;
   tf->codes[16035] = 0x0001cf4e8771478dUL;
   tf->codes[16036] = 0x0001cf7c0c9ec3b0UL;
   tf->codes[16037] = 0x0001cf8657c2c751UL;
   tf->codes[16038] = 0x0001cfb367d237eaUL;
   tf->codes[16039] = 0x0001cfba7f23eac5UL;
   tf->codes[16040] = 0x0001cfc95d7461caUL;
   tf->codes[16041] = 0x0001cfd5b79f9958UL;
   tf->codes[16042] = 0x0001cfdabfea1846UL;
   tf->codes[16043] = 0x0001cfdc1f443ae4UL;
   tf->codes[16044] = 0x0001cfe420d204d3UL;
   tf->codes[16045] = 0x0001cff5bdd6c114UL;
   tf->codes[16046] = 0x0001d0004389ca7aUL;
   tf->codes[16047] = 0x0001d01d15eea170UL;
   tf->codes[16048] = 0x0001d0485185e3e1UL;
   tf->codes[16049] = 0x0001d04a9b1c1d93UL;
   tf->codes[16050] = 0x0001d0759c245a3fUL;
   tf->codes[16051] = 0x0001d079ba32c219UL;
   tf->codes[16052] = 0x0001d0b115663653UL;
   tf->codes[16053] = 0x0001d0d70e23f411UL;
   tf->codes[16054] = 0x0001d0de2575a6ecUL;
   tf->codes[16055] = 0x0001d0ef87eb5d68UL;
   tf->codes[16056] = 0x0001d0fa0d9e66ceUL;
   tf->codes[16057] = 0x0001d105b81c8d0dUL;
   tf->codes[16058] = 0x0001d123af4c80dcUL;
   tf->codes[16059] = 0x0001d17ad628170dUL;
   tf->codes[16060] = 0x0001d194e9d8a8c7UL;
   tf->codes[16061] = 0x0001d1a22e3ff769UL;
   tf->codes[16062] = 0x0001d1dfb689076aUL;
   tf->codes[16063] = 0x0001d1e4f9628c1dUL;
   tf->codes[16064] = 0x0001d1f9ca399924UL;
   tf->codes[16065] = 0x0001d2295e6e4934UL;
   tf->codes[16066] = 0x0001d22e2c29c25dUL;
   tf->codes[16067] = 0x0001d2399c18e2d7UL;
   tf->codes[16068] = 0x0001d25758b9d0e1UL;
   tf->codes[16069] = 0x0001d29a23dc6595UL;
   tf->codes[16070] = 0x0001d2a2d51740d3UL;
   tf->codes[16071] = 0x0001d2a67e079d23UL;
   tf->codes[16072] = 0x0001d2abc0e121d6UL;
   tf->codes[16073] = 0x0001d2afa46083ebUL;
   tf->codes[16074] = 0x0001d2c0cc4734a2UL;
   tf->codes[16075] = 0x0001d2c17bf445f1UL;
   tf->codes[16076] = 0x0001d2c22ba15740UL;
   tf->codes[16077] = 0x0001d2e68a75ec9bUL;
   tf->codes[16078] = 0x0001d324fcfb13b0UL;
   tf->codes[16079] = 0x0001d345b2df4cbbUL;
   tf->codes[16080] = 0x0001d34f88e544d2UL;
   tf->codes[16081] = 0x0001d3678d8ea29fUL;
   tf->codes[16082] = 0x0001d37dbdbfd244UL;
   tf->codes[16083] = 0x0001d3884372dbaaUL;
   tf->codes[16084] = 0x0001d39c9f2bdd27UL;
   tf->codes[16085] = 0x0001d3a4a0b9a716UL;
   tf->codes[16086] = 0x0001d3aa1e22318eUL;
   tf->codes[16087] = 0x0001d3abb80b59f1UL;
   tf->codes[16088] = 0x0001d3b553824c43UL;
   tf->codes[16089] = 0x0001d3c4e17fd497UL;
   tf->codes[16090] = 0x0001d3d1eb581d74UL;
   tf->codes[16091] = 0x0001d3e2d8afc866UL;
   tf->codes[16092] = 0x0001d3e522460218UL;
   tf->codes[16093] = 0x0001d41615d4d4c6UL;
   tf->codes[16094] = 0x0001d442eb553f9aUL;
   tf->codes[16095] = 0x0001d4a631cd0794UL;
   tf->codes[16096] = 0x0001d4d4dbc5a090UL;
   tf->codes[16097] = 0x0001d4fd9337a38aUL;
   tf->codes[16098] = 0x0001d51d2450bfbcUL;
   tf->codes[16099] = 0x0001d54bce4958b8UL;
   tf->codes[16100] = 0x0001d557ede58a81UL;
   tf->codes[16101] = 0x0001d5a195cacc4bUL;
   tf->codes[16102] = 0x0001d5a28006e35fUL;
   tf->codes[16103] = 0x0001d5ab3141be9dUL;
   tf->codes[16104] = 0x0001d5c126e3e87dUL;
   tf->codes[16105] = 0x0001d5d8b66f3ac0UL;
   tf->codes[16106] = 0x0001d5f638812305UL;
   tf->codes[16107] = 0x0001d6163eb84ac1UL;
   tf->codes[16108] = 0x0001d636ba0d7e07UL;
   tf->codes[16109] = 0x0001d65e12255e63UL;
   tf->codes[16110] = 0x0001d6618086b4eeUL;
   tf->codes[16111] = 0x0001d67fb245ae82UL;
   tf->codes[16112] = 0x0001d699c5f6403cUL;
   tf->codes[16113] = 0x0001d6a6cfce8919UL;
   tf->codes[16114] = 0x0001d6bc15c3a1aaUL;
   tf->codes[16115] = 0x0001d6d2f5a1e29eUL;
   tf->codes[16116] = 0x0001d6e074983705UL;
   tf->codes[16117] = 0x0001d6f495c232bdUL;
   tf->codes[16118] = 0x0001d7180a5ab104UL;
   tf->codes[16119] = 0x0001d720bb958c42UL;
   tf->codes[16120] = 0x0001d72d15c0c3d0UL;
   tf->codes[16121] = 0x0001d731a8ed3734UL;
   tf->codes[16122] = 0x0001d7551d85b57bUL;
   tf->codes[16123] = 0x0001d767a4c688d0UL;
   tf->codes[16124] = 0x0001d782dd423763UL;
   tf->codes[16125] = 0x0001d78a69b1f5c8UL;
   tf->codes[16126] = 0x0001d79898555b7eUL;
   tf->codes[16127] = 0x0001d799bd207857UL;
   tf->codes[16128] = 0x0001d79f75180894UL;
   tf->codes[16129] = 0x0001d7aa6fe91d84UL;
   tf->codes[16130] = 0x0001d7ac09d245e7UL;
   tf->codes[16131] = 0x0001d7af78339c72UL;
   tf->codes[16132] = 0x0001d7c3d3ec9defUL;
   tf->codes[16133] = 0x0001d7c692a0e32bUL;
   tf->codes[16134] = 0x0001d7c8dc371cddUL;
   tf->codes[16135] = 0x0001d7e414b2cb70UL;
   tf->codes[16136] = 0x0001d7f4525d6513UL;
   tf->codes[16137] = 0x0001d7fdedd45765UL;
   tf->codes[16138] = 0x0001d8266ab7549aUL;
   tf->codes[16139] = 0x0001d84218510eb7UL;
   tf->codes[16140] = 0x0001d84252e0147cUL;
   tf->codes[16141] = 0x0001d843b23a371aUL;
   tf->codes[16142] = 0x0001d8534037bf6eUL;
   tf->codes[16143] = 0x0001d85932be5570UL;
   tf->codes[16144] = 0x0001d86bb9ff28c5UL;
   tf->codes[16145] = 0x0001d883bea88692UL;
   tf->codes[16146] = 0x0001d88a264d281eUL;
   tf->codes[16147] = 0x0001d895211e3d0eUL;
   tf->codes[16148] = 0x0001d8a1f0678026UL;
   tf->codes[16149] = 0x0001d8a315329cffUL;
   tf->codes[16150] = 0x0001d8aa2c844fdaUL;
   tf->codes[16151] = 0x0001d8b1b8f40e3fUL;
   tf->codes[16152] = 0x0001d8c355f8ca80UL;
   tf->codes[16153] = 0x0001d8c44034e194UL;
   tf->codes[16154] = 0x0001d8cbcca49ff9UL;
   tf->codes[16155] = 0x0001d8d98629fa25UL;
   tf->codes[16156] = 0x0001d8e062eca73bUL;
   tf->codes[16157] = 0x0001d903626719f8UL;
   tf->codes[16158] = 0x0001d935403203baUL;
   tf->codes[16159] = 0x0001d95580f8313bUL;
   tf->codes[16160] = 0x0001d95a1424a49fUL;
   tf->codes[16161] = 0x0001d9a013198a19UL;
   tf->codes[16162] = 0x0001d9c5219b30c3UL;
   tf->codes[16163] = 0x0001d9cf32302e9fUL;
   tf->codes[16164] = 0x0001da0234c6353aUL;
   tf->codes[16165] = 0x0001da406cbc568aUL;
   tf->codes[16166] = 0x0001da4833bb1ab4UL;
   tf->codes[16167] = 0x0001da50aa66f02dUL;
   tf->codes[16168] = 0x0001da5a806ce844UL;
   tf->codes[16169] = 0x0001da5b3019f993UL;
   tf->codes[16170] = 0x0001da5db43f390aUL;
   tf->codes[16171] = 0x0001da6af8a687acUL;
   tf->codes[16172] = 0x0001da9dc0ad8882UL;
   tf->codes[16173] = 0x0001daa3edc32449UL;
   tf->codes[16174] = 0x0001daab3fa3dce9UL;
   tf->codes[16175] = 0x0001daaf5db244c3UL;
   tf->codes[16176] = 0x0001dac63d9085b7UL;
   tf->codes[16177] = 0x0001dad30cd9c8cfUL;
   tf->codes[16178] = 0x0001db2cb7da9e77UL;
   tf->codes[16179] = 0x0001db2cf269a43cUL;
   tf->codes[16180] = 0x0001db477b384180UL;
   tf->codes[16181] = 0x0001db540ff27ed3UL;
   tf->codes[16182] = 0x0001db83deb634a8UL;
   tf->codes[16183] = 0x0001dba509b8793dUL;
   tf->codes[16184] = 0x0001dbb45d26fbccUL;
   tf->codes[16185] = 0x0001dbb8b5c4696bUL;
   tf->codes[16186] = 0x0001dbc2c6596747UL;
   tf->codes[16187] = 0x0001dbd07fdec173UL;
   tf->codes[16188] = 0x0001dbd588294061UL;
   tf->codes[16189] = 0x0001dbe1a7c5722aUL;
   tf->codes[16190] = 0x0001dbe42beab1a1UL;
   tf->codes[16191] = 0x0001dc05cc0b01c0UL;
   tf->codes[16192] = 0x0001dc1818bccf50UL;
   tf->codes[16193] = 0x0001dc19b2a5f7b3UL;
   tf->codes[16194] = 0x0001dc27319c4c1aUL;
   tf->codes[16195] = 0x0001dc2a9ffda2a5UL;
   tf->codes[16196] = 0x0001dc42df360637UL;
   tf->codes[16197] = 0x0001dc4319c50bfcUL;
   tf->codes[16198] = 0x0001dc5098bb6063UL;
   tf->codes[16199] = 0x0001dc57ea9c1903UL;
   tf->codes[16200] = 0x0001dc62704f2269UL;
   tf->codes[16201] = 0x0001dc7f42b3f95fUL;
   tf->codes[16202] = 0x0001dc81c6d938d6UL;
   tf->codes[16203] = 0x0001dca78507f0cfUL;
   tf->codes[16204] = 0x0001dcae61ca9de5UL;
   tf->codes[16205] = 0x0001dcbc1b4ff811UL;
   tf->codes[16206] = 0x0001dcdafcbc02f4UL;
   tf->codes[16207] = 0x0001dcddbb704830UL;
   tf->codes[16208] = 0x0001dce129d19ebbUL;
   tf->codes[16209] = 0x0001dd0a90f0b304UL;
   tf->codes[16210] = 0x0001dd3b49f07fedUL;
   tf->codes[16211] = 0x0001dd46b9dfa067UL;
   tf->codes[16212] = 0x0001dd4ad7ee0841UL;
   tf->codes[16213] = 0x0001dd873b6bfb69UL;
   tf->codes[16214] = 0x0001dda8666e3ffeUL;
   tf->codes[16215] = 0x0001dde28055f974UL;
   tf->codes[16216] = 0x0001dde6d8f36713UL;
   tf->codes[16217] = 0x0001de0a4d8be55aUL;
   tf->codes[16218] = 0x0001de304649a318UL;
   tf->codes[16219] = 0x0001de3a1c4f9b2fUL;
   tf->codes[16220] = 0x0001de46b109d882UL;
   tf->codes[16221] = 0x0001de484af300e5UL;
   tf->codes[16222] = 0x0001de688bb92e66UL;
   tf->codes[16223] = 0x0001de6bbf8b7f2cUL;
   tf->codes[16224] = 0x0001de6fa30ae141UL;
   tf->codes[16225] = 0x0001de7c37c51e94UL;
   tf->codes[16226] = 0x0001de8b16159599UL;
   tf->codes[16227] = 0x0001de98cf9aefc5UL;
   tf->codes[16228] = 0x0001dea180d5cb03UL;
   tf->codes[16229] = 0x0001dec236ba040eUL;
   tf->codes[16230] = 0x0001decc0cbffc25UL;
   tf->codes[16231] = 0x0001dee5e5e1881aUL;
   tf->codes[16232] = 0x0001dee86a06c791UL;
   tf->codes[16233] = 0x0001def748573e96UL;
   tf->codes[16234] = 0x0001defd004eced3UL;
   tf->codes[16235] = 0x0001df06d654c6eaUL;
   tf->codes[16236] = 0x0001df0f4d009c63UL;
   tf->codes[16237] = 0x0001df1ea06f1ef2UL;
   tf->codes[16238] = 0x0001df307802e0f8UL;
   tf->codes[16239] = 0x0001df55868487a2UL;
   tf->codes[16240] = 0x0001df943398b47cUL;
   tf->codes[16241] = 0x0001dfc0596c0e01UL;
   tf->codes[16242] = 0x0001dfc352af5902UL;
   tf->codes[16243] = 0x0001dfc9ba53fa8eUL;
   tf->codes[16244] = 0x0001dfe5a27cba70UL;
   tf->codes[16245] = 0x0001dfeda40a845fUL;
   tf->codes[16246] = 0x0001dff8644c938aUL;
   tf->codes[16247] = 0x0001dff913f9a4d9UL;
   tf->codes[16248] = 0x0001e01536b16a80UL;
   tf->codes[16249] = 0x0001e017bad6a9f7UL;
   tf->codes[16250] = 0x0001e024c4aef2d4UL;
   tf->codes[16251] = 0x0001e02539ccfe5eUL;
   tf->codes[16252] = 0x0001e03ed85f848eUL;
   tf->codes[16253] = 0x0001e0550890b433UL;
   tf->codes[16254] = 0x0001e07bb0fb8340UL;
   tf->codes[16255] = 0x0001e0d55bfc58e8UL;
   tf->codes[16256] = 0x0001e0e474dbd5b2UL;
   tf->codes[16257] = 0x0001e0efaa3bf067UL;
   tf->codes[16258] = 0x0001e11cba4b6100UL;
   tf->codes[16259] = 0x0001e124bbd92aefUL;
   tf->codes[16260] = 0x0001e1444cf24721UL;
   tf->codes[16261] = 0x0001e144fc9f5870UL;
   tf->codes[16262] = 0x0001e163a37c5d8eUL;
   tf->codes[16263] = 0x0001e19e6d112853UL;
   tf->codes[16264] = 0x0001e1c131fc954bUL;
   tf->codes[16265] = 0x0001e1c2cbe5bdaeUL;
   tf->codes[16266] = 0x0001e1cf609ffb01UL;
   tf->codes[16267] = 0x0001e1d3441f5d16UL;
   tf->codes[16268] = 0x0001e1e51bb31f1cUL;
   tf->codes[16269] = 0x0001e1fc70af6b9aUL;
   tf->codes[16270] = 0x0001e1fe7fb69f87UL;
   tf->codes[16271] = 0x0001e216845ffd54UL;
   tf->codes[16272] = 0x0001e22478745d45UL;
   tf->codes[16273] = 0x0001e2264cec8b6dUL;
   tf->codes[16274] = 0x0001e240d5bb28b1UL;
   tf->codes[16275] = 0x0001e26e20599f0fUL;
   tf->codes[16276] = 0x0001e28a7da06a7bUL;
   tf->codes[16277] = 0x0001e2903597fab8UL;
   tf->codes[16278] = 0x0001e2d2167e7858UL;
   tf->codes[16279] = 0x0001e2e12f5df522UL;
   tf->codes[16280] = 0x0001e2f8845a41a0UL;
   tf->codes[16281] = 0x0001e30b80b9207fUL;
   tf->codes[16282] = 0x0001e3773ddcbdf2UL;
   tf->codes[16283] = 0x0001e3894fff85bdUL;
   tf->codes[16284] = 0x0001e390a1e03e5dUL;
   tf->codes[16285] = 0x0001e399c8392525UL;
   tf->codes[16286] = 0x0001e39c4c5e649cUL;
   tf->codes[16287] = 0x0001e3d5b6990cc3UL;
   tf->codes[16288] = 0x0001e3d715f32f61UL;
   tf->codes[16289] = 0x0001e3dabee38bb1UL;
   tf->codes[16290] = 0x0001e3e1d6353e8cUL;
   tf->codes[16291] = 0x0001e4046091a5bfUL;
   tf->codes[16292] = 0x0001e43bbbc519f9UL;
   tf->codes[16293] = 0x0001e46b156ac444UL;
   tf->codes[16294] = 0x0001e475608ec7e5UL;
   tf->codes[16295] = 0x0001e49fec78f907UL;
   tf->codes[16296] = 0x0001e4c18c994926UL;
   tf->codes[16297] = 0x0001e4c36111774eUL;
   tf->codes[16298] = 0x0001e4cab2f22feeUL;
   tf->codes[16299] = 0x0001e4cff5cbb4a1UL;
   tf->codes[16300] = 0x0001e4f8ad3db79bUL;
   tf->codes[16301] = 0x0001e4fdf0173c4eUL;
   tf->codes[16302] = 0x0001e525f7dc2df9UL;
   tf->codes[16303] = 0x0001e566796888fbUL;
   tf->codes[16304] = 0x0001e56b47240224UL;
   tf->codes[16305] = 0x0001e57014df7b4dUL;
   tf->codes[16306] = 0x0001e5746d7ce8ecUL;
   tf->codes[16307] = 0x0001e5810237263fUL;
   tf->codes[16308] = 0x0001e5867f9fb0b7UL;
   tf->codes[16309] = 0x0001e5b98235b752UL;
   tf->codes[16310] = 0x0001e5bc7b790253UL;
   tf->codes[16311] = 0x0001e5c024695ea3UL;
   tf->codes[16312] = 0x0001e5cdddeeb8cfUL;
   tf->codes[16313] = 0x0001e5f570959ef0UL;
   tf->codes[16314] = 0x0001e5fbd83a407cUL;
   tf->codes[16315] = 0x0001e612f2a78735UL;
   tf->codes[16316] = 0x0001e65c9a8cc8ffUL;
   tf->codes[16317] = 0x0001e65df9e6eb9dUL;
   tf->codes[16318] = 0x0001e665fb74b58cUL;
   tf->codes[16319] = 0x0001e6784826831cUL;
   tf->codes[16320] = 0x0001e67e001e1359UL;
   tf->codes[16321] = 0x0001e68258bb80f8UL;
   tf->codes[16322] = 0x0001e6863c3ae30dUL;
   tf->codes[16323] = 0x0001e6884b4216faUL;
   tf->codes[16324] = 0x0001e6a72cae21ddUL;
   tf->codes[16325] = 0x0001e6b1b2612b43UL;
   tf->codes[16326] = 0x0001e6c439a1fe98UL;
   tf->codes[16327] = 0x0001e6db19803f8cUL;
   tf->codes[16328] = 0x0001e7132460c515UL;
   tf->codes[16329] = 0x0001e714492be1eeUL;
   tf->codes[16330] = 0x0001e714be49ed78UL;
   tf->codes[16331] = 0x0001e71de4a2d440UL;
   tf->codes[16332] = 0x0001e71e944fe58fUL;
   tf->codes[16333] = 0x0001e759d302bbdeUL;
   tf->codes[16334] = 0x0001e783e9cee176UL;
   tf->codes[16335] = 0x0001e7a5c47e375aUL;
   tf->codes[16336] = 0x0001e7ad165eeffaUL;
   tf->codes[16337] = 0x0001e7b04a3140c0UL;
   tf->codes[16338] = 0x0001e7c5cab55f16UL;
   tf->codes[16339] = 0x0001e7ffe49d188cUL;
   tf->codes[16340] = 0x0001e80109683565UL;
   tf->codes[16341] = 0x0001e812314ee61cUL;
   tf->codes[16342] = 0x0001e814f0032b58UL;
   tf->codes[16343] = 0x0001e8382a0ca3daUL;
   tf->codes[16344] = 0x0001e85cfdff44bfUL;
   tf->codes[16345] = 0x0001e8648a6f0324UL;
   tf->codes[16346] = 0x0001e86bdc4fbbc4UL;
   tf->codes[16347] = 0x0001e88839968730UL;
   tf->codes[16348] = 0x0001e893e414ad6fUL;
   tf->codes[16349] = 0x0001e8a19d9a079bUL;
   tf->codes[16350] = 0x0001e8c12eb323cdUL;
   tf->codes[16351] = 0x0001e8f46bd8302dUL;
   tf->codes[16352] = 0x0001e906436bf233UL;
   tf->codes[16353] = 0x0001e929f293763fUL;
   tf->codes[16354] = 0x0001e92aa240878eUL;
   tf->codes[16355] = 0x0001e963975d242bUL;
   tf->codes[16356] = 0x0001e97952704846UL;
   tf->codes[16357] = 0x0001e97a021d5995UL;
   tf->codes[16358] = 0x0001e989901ae1e9UL;
   tf->codes[16359] = 0x0001e9a2f41e6254UL;
   tf->codes[16360] = 0x0001e9b4cbb2245aUL;
   tf->codes[16361] = 0x0001e9b83a137ae5UL;
   tf->codes[16362] = 0x0001e9d6e0f08003UL;
   tf->codes[16363] = 0x0001e9e1a1328f2eUL;
   tf->codes[16364] = 0x0001e9ea526d6a6cUL;
   tf->codes[16365] = 0x0001e9fd143d4386UL;
   tf->codes[16366] = 0x0001ea19e6a21a7cUL;
   tf->codes[16367] = 0x0001ea1f640aa4f4UL;
   tf->codes[16368] = 0x0001ea3c366f7beaUL;
   tf->codes[16369] = 0x0001ea4522395cedUL;
   tf->codes[16370] = 0x0001ea46bc228550UL;
   tf->codes[16371] = 0x0001ea62a44b4532UL;
   tf->codes[16372] = 0x0001ea71480cb672UL;
   tf->codes[16373] = 0x0001ea76c57540eaUL;
   tf->codes[16374] = 0x0001ea9ecd3a3295UL;
   tf->codes[16375] = 0x0001eaa4fa4fce5cUL;
   tf->codes[16376] = 0x0001eaba4044e6edUL;
   tf->codes[16377] = 0x0001eabb2a80fe01UL;
   tf->codes[16378] = 0x0001eac1579699c8UL;
   tf->codes[16379] = 0x0001eaca08d17506UL;
   tf->codes[16380] = 0x0001ead8ac92e646UL;
   tf->codes[16381] = 0x0001eb128beb99f7UL;
   tf->codes[16382] = 0x0001eb180954246fUL;
   tf->codes[16383] = 0x0001eb28f6abcf61UL;
   tf->codes[16384] = 0x0001eb49720102a7UL;
   tf->codes[16385] = 0x0001eb91ba8c21d3UL;
   tf->codes[16386] = 0x0001eba7b02e4bb3UL;
   tf->codes[16387] = 0x0001ebb82867eb1bUL;
   tf->codes[16388] = 0x0001ec1b3450ad50UL;
   tf->codes[16389] = 0x0001ec2f1aeba343UL;
   tf->codes[16390] = 0x0001ec2f9009aecdUL;
   tf->codes[16391] = 0x0001ec2fca98b492UL;
   tf->codes[16392] = 0x0001ec3548013f0aUL;
   tf->codes[16393] = 0x0001ec3a504bbdf8UL;
   tf->codes[16394] = 0x0001ec4809d11824UL;
   tf->codes[16395] = 0x0001ec52ca13274fUL;
   tf->codes[16396] = 0x0001ec554e3866c6UL;
   tf->codes[16397] = 0x0001ec66eb3d2307UL;
   tf->codes[16398] = 0x0001ecb6108aef49UL;
   tf->codes[16399] = 0x0001ecbade466872UL;
   tf->codes[16400] = 0x0001ecbbc8827f86UL;
   tf->codes[16401] = 0x0001ecbe4ca7befdUL;
   tf->codes[16402] = 0x0001eccc40bc1eeeUL;
   tf->codes[16403] = 0x0001ece9883f016eUL;
   tf->codes[16404] = 0x0001eceecb188621UL;
   tf->codes[16405] = 0x0001ecf40df20ad4UL;
   tf->codes[16406] = 0x0001ed253c0fe347UL;
   tf->codes[16407] = 0x0001ed26d5f90baaUL;
   tf->codes[16408] = 0x0001ed2bde438a98UL;
   tf->codes[16409] = 0x0001ed3872fdc7ebUL;
   tf->codes[16410] = 0x0001ed449299f9b4UL;
   tf->codes[16411] = 0x0001ed5a883c2394UL;
   tf->codes[16412] = 0x0001ed6374060497UL;
   tf->codes[16413] = 0x0001ed8080f9e152UL;
   tf->codes[16414] = 0x0001ed849f08492cUL;
   tf->codes[16415] = 0x0001eda46ab06b23UL;
   tf->codes[16416] = 0x0001edaeb5d46ec4UL;
   tf->codes[16417] = 0x0001edb8c6696ca0UL;
   tf->codes[16418] = 0x0001edc0184a2540UL;
   tf->codes[16419] = 0x0001edd09083c4a8UL;
   tf->codes[16420] = 0x0001edd34f3809e4UL;
   tf->codes[16421] = 0x0001ede5d678dd39UL;
   tf->codes[16422] = 0x0001ee03cda8d108UL;
   tf->codes[16423] = 0x0001ee0d691fc35aUL;
   tf->codes[16424] = 0x0001ee135ba6595cUL;
   tf->codes[16425] = 0x0001ee1480717635UL;
   tf->codes[16426] = 0x0001ee1988bbf523UL;
   tf->codes[16427] = 0x0001ee3e5cae9608UL;
   tf->codes[16428] = 0x0001ee3fbc08b8a6UL;
   tf->codes[16429] = 0x0001ee47bd968295UL;
   tf->codes[16430] = 0x0001ee4c8b51fbbeUL;
   tf->codes[16431] = 0x0001ee5417c1ba23UL;
   tf->codes[16432] = 0x0001ee5af4846739UL;
   tf->codes[16433] = 0x0001ee5d78a9a6b0UL;
   tf->codes[16434] = 0x0001ee5e62e5bdc4UL;
   tf->codes[16435] = 0x0001ee6246651fd9UL;
   tf->codes[16436] = 0x0001ee68ae09c165UL;
   tf->codes[16437] = 0x0001ee8f1be58aadUL;
   tf->codes[16438] = 0x0001ee96a8554912UL;
   tf->codes[16439] = 0x0001eebeeaa94082UL;
   tf->codes[16440] = 0x0001eede7bc25cb4UL;
   tf->codes[16441] = 0x0001ef2440283c69UL;
   tf->codes[16442] = 0x0001ef33ce25c4bdUL;
   tf->codes[16443] = 0x0001ef3e1949c85eUL;
   tf->codes[16444] = 0x0001ef4ae8930b76UL;
   tf->codes[16445] = 0x0001ef623d8f57f4UL;
   tf->codes[16446] = 0x0001ef84c7ebbf27UL;
   tf->codes[16447] = 0x0001ef8c8eea8351UL;
   tf->codes[16448] = 0x0001efab70568e34UL;
   tf->codes[16449] = 0x0001efb162dd2436UL;
   tf->codes[16450] = 0x0001efc71df04851UL;
   tf->codes[16451] = 0x0001efcf5a0d1805UL;
   tf->codes[16452] = 0x0001efd3781b7fdfUL;
   tf->codes[16453] = 0x0001efd49ce69cb8UL;
   tf->codes[16454] = 0x0001efe54faf41e5UL;
   tf->codes[16455] = 0x0001eff8869d2689UL;
   tf->codes[16456] = 0x0001f0264659a871UL;
   tf->codes[16457] = 0x0001f067ecb1204cUL;
   tf->codes[16458] = 0x0001f071fd461e28UL;
   tf->codes[16459] = 0x0001f078da08cb3eUL;
   tf->codes[16460] = 0x0001f0840f68e5f3UL;
   tf->codes[16461] = 0x0001f0a03220ab9aUL;
   tf->codes[16462] = 0x0001f0a4ffdc24c3UL;
   tf->codes[16463] = 0x0001f0a8e35b86d8UL;
   tf->codes[16464] = 0x0001f0bb6a9c5a2dUL;
   tf->codes[16465] = 0x0001f0c2bc7d12cdUL;
   tf->codes[16466] = 0x0001f0c839e59d45UL;
   tf->codes[16467] = 0x0001f0e8401cc501UL;
   tf->codes[16468] = 0x0001f146092c0283UL;
   tf->codes[16469] = 0x0001f155220b7f4dUL;
   tf->codes[16470] = 0x0001f1ab993a042fUL;
   tf->codes[16471] = 0x0001f1b743b82a6eUL;
   tf->codes[16472] = 0x0001f1be9598e30eUL;
   tf->codes[16473] = 0x0001f1c8a62de0eaUL;
   tf->codes[16474] = 0x0001f239e0ba08d5UL;
   tf->codes[16475] = 0x0001f23fd3409ed7UL;
   tf->codes[16476] = 0x0001f264e1c24581UL;
   tf->codes[16477] = 0x0001f267a0768abdUL;
   tf->codes[16478] = 0x0001f27c36be91ffUL;
   tf->codes[16479] = 0x0001f27ce66ba34eUL;
   tf->codes[16480] = 0x0001f27f6a90e2c5UL;
   tf->codes[16481] = 0x0001f281047a0b28UL;
   tf->codes[16482] = 0x0001f2a319b866d1UL;
   tf->codes[16483] = 0x0001f2c1c0956befUL;
   tf->codes[16484] = 0x0001f2db5f27f21fUL;
   tf->codes[16485] = 0x0001f2e32626b649UL;
   tf->codes[16486] = 0x0001f2f622859528UL;
   tf->codes[16487] = 0x0001f3241cd11cd5UL;
   tf->codes[16488] = 0x0001f366e7f3b189UL;
   tf->codes[16489] = 0x0001f36a56550814UL;
   tf->codes[16490] = 0x0001f36dc4b65e9fUL;
   tf->codes[16491] = 0x0001f37f61bb1ae0UL;
   tf->codes[16492] = 0x0001f383ba58887fUL;
   tf->codes[16493] = 0x0001f3901483c00dUL;
   tf->codes[16494] = 0x0001f3c7e4d53fd1UL;
   tf->codes[16495] = 0x0001f3d4eead88aeUL;
   tf->codes[16496] = 0x0001f3ff7a97b9d0UL;
   tf->codes[16497] = 0x0001f4177f41179dUL;
   tf->codes[16498] = 0x0001f41a7884629eUL;
   tf->codes[16499] = 0x0001f4432ff66598UL;
   tf->codes[16500] = 0x0001f4800892644aUL;
   tf->codes[16501] = 0x0001f4b30b286ae5UL;
   tf->codes[16502] = 0x0001f4b84e01ef98UL;
   tf->codes[16503] = 0x0001f4be4088859aUL;
   tf->codes[16504] = 0x0001f4c6078749c4UL;
   tf->codes[16505] = 0x0001f4da9dcf5106UL;
   tf->codes[16506] = 0x0001f4fb53b38a11UL;
   tf->codes[16507] = 0x0001f501463a2013UL;
   tf->codes[16508] = 0x0001f517014d442eUL;
   tf->codes[16509] = 0x0001f53f7e304163UL;
   tf->codes[16510] = 0x0001f57280c647feUL;
   tf->codes[16511] = 0x0001f598b4130b81UL;
   tf->codes[16512] = 0x0001f5a424022bfbUL;
   tf->codes[16513] = 0x0001f5cb418b0692UL;
   tf->codes[16514] = 0x0001f6013d64582eUL;
   tf->codes[16515] = 0x0001f606f55be86bUL;
   tf->codes[16516] = 0x0001f60a292e3931UL;
   tf->codes[16517] = 0x0001f6189260a4acUL;
   tf->codes[16518] = 0x0001f624ec8bdc3aUL;
   tf->codes[16519] = 0x0001f62770b11bb1UL;
   tf->codes[16520] = 0x0001f62f723ee5a0UL;
   tf->codes[16521] = 0x0001f6389897cc68UL;
   tf->codes[16522] = 0x0001f650d7d02ffaUL;
   tf->codes[16523] = 0x0001f670de0757b6UL;
   tf->codes[16524] = 0x0001f6723d617a54UL;
   tf->codes[16525] = 0x0001f672b27f85deUL;
   tf->codes[16526] = 0x0001f6798f4232f4UL;
   tf->codes[16527] = 0x0001f67bd8d86ca6UL;
   tf->codes[16528] = 0x0001f67e978cb1e2UL;
   tf->codes[16529] = 0x0001f685e96d6a82UL;
   tf->codes[16530] = 0x0001f68e258a3a36UL;
   tf->codes[16531] = 0x0001f6a99894ee8eUL;
   tf->codes[16532] = 0x0001f6b7178b42f5UL;
   tf->codes[16533] = 0x0001f6bb3599aacfUL;
   tf->codes[16534] = 0x0001f6c7ca53e822UL;
   tf->codes[16535] = 0x0001f6cd47bc729aUL;
   tf->codes[16536] = 0x0001f6da8c23c13cUL;
   tf->codes[16537] = 0x0001f700bf7084bfUL;
   tf->codes[16538] = 0x0001f705529cf823UL;
   tf->codes[16539] = 0x0001f70bf4d09f74UL;
   tf->codes[16540] = 0x0001f70e03d7d361UL;
   tf->codes[16541] = 0x0001f741066dd9fcUL;
   tf->codes[16542] = 0x0001f7602268eaa4UL;
   tf->codes[16543] = 0x0001f7626bff2456UL;
   tf->codes[16544] = 0x0001f763cb5946f4UL;
   tf->codes[16545] = 0x0001f77ec945efc2UL;
   tf->codes[16546] = 0x0001f78bd31e389fUL;
   tf->codes[16547] = 0x0001f7a02ed73a1cUL;
   tf->codes[16548] = 0x0001f7a0de844b6bUL;
   tf->codes[16549] = 0x0001f7bbdc70f439UL;
   tf->codes[16550] = 0x0001f7bffa7f5c13UL;
   tf->codes[16551] = 0x0001f7c4188dc3edUL;
   tf->codes[16552] = 0x0001f7c53d58e0c6UL;
   tf->codes[16553] = 0x0001f7c7fc0d2602UL;
   tf->codes[16554] = 0x0001f7e9270f6a97UL;
   tf->codes[16555] = 0x0001f7f5813aa225UL;
   tf->codes[16556] = 0x0001f7f7cad0dbd7UL;
   tf->codes[16557] = 0x0001f7fbe8df43b1UL;
   tf->codes[16558] = 0x0001f8025083e53dUL;
   tf->codes[16559] = 0x0001f83c6a6b9eb3UL;
   tf->codes[16560] = 0x0001f83e0454c716UL;
   tf->codes[16561] = 0x0001f83e3ee3ccdbUL;
   tf->codes[16562] = 0x0001f8484f78cab7UL;
   tf->codes[16563] = 0x0001f85852945e95UL;
   tf->codes[16564] = 0x0001f87faaac3ef1UL;
   tf->codes[16565] = 0x0001f8909803e9e3UL;
   tf->codes[16566] = 0x0001f896ffa88b6fUL;
   tf->codes[16567] = 0x0001f8c7438a4cceUL;
   tf->codes[16568] = 0x0001f8c9529180bbUL;
   tf->codes[16569] = 0x0001f8e53aba409dUL;
   tf->codes[16570] = 0x0001f961358877b3UL;
   tf->codes[16571] = 0x0001f986f3b72facUL;
   tf->codes[16572] = 0x0001f989ecfa7aadUL;
   tf->codes[16573] = 0x0001f99313536175UL;
   tf->codes[16574] = 0x0001f9bf73b5c0bfUL;
   tf->codes[16575] = 0x0001f9c73ab484e9UL;
   tf->codes[16576] = 0x0001f9e2e84e3f06UL;
   tf->codes[16577] = 0x0001f9f325f8d8a9UL;
   tf->codes[16578] = 0x0001fa041350839bUL;
   tf->codes[16579] = 0x0001fa044ddf8960UL;
   tf->codes[16580] = 0x0001fa0f0e21988bUL;
   tf->codes[16581] = 0x0001fa2070974f07UL;
   tf->codes[16582] = 0x0001fa20e5b55a91UL;
   tf->codes[16583] = 0x0001fa22450f7d2fUL;
   tf->codes[16584] = 0x0001fa253e52c830UL;
   tf->codes[16585] = 0x0001fa3282ba16d2UL;
   tf->codes[16586] = 0x0001fa4afc818029UL;
   tf->codes[16587] = 0x0001fa5079ea0aa1UL;
   tf->codes[16588] = 0x0001fa51642621b5UL;
   tf->codes[16589] = 0x0001fa5d0ea447f4UL;
   tf->codes[16590] = 0x0001fa5d49334db9UL;
   tf->codes[16591] = 0x0001fa9e3fddb445UL;
   tf->codes[16592] = 0x0001faa25dec1c1fUL;
   tf->codes[16593] = 0x0001faa2987b21e4UL;
   tf->codes[16594] = 0x0001faa432644a47UL;
   tf->codes[16595] = 0x0001fabf3050f315UL;
   tf->codes[16596] = 0x0001fae5d8bbc222UL;
   tf->codes[16597] = 0x0001fae64dd9cdacUL;
   tf->codes[16598] = 0x0001fb2709f52e73UL;
   tf->codes[16599] = 0x0001fb548f22aa96UL;
   tf->codes[16600] = 0x0001fb5a81a94098UL;
   tf->codes[16601] = 0x0001fb6be41ef714UL;
   tf->codes[16602] = 0x0001fb74203bc6c8UL;
   tf->codes[16603] = 0x0001fb95faeb1cacUL;
   tf->codes[16604] = 0x0001fb9dfc78e69bUL;
   tf->codes[16605] = 0x0001fba25516543aUL;
   tf->codes[16606] = 0x0001fba75d60d328UL;
   tf->codes[16607] = 0x0001fbbb43fbc91bUL;
   tf->codes[16608] = 0x0001fbd3f8523837UL;
   tf->codes[16609] = 0x0001fbd67c7777aeUL;
   tf->codes[16610] = 0x0001fbe60a750002UL;
   tf->codes[16611] = 0x0001fc00cdd2a30bUL;
   tf->codes[16612] = 0x0001fc20d409cac7UL;
   tf->codes[16613] = 0x0001fc25a1c543f0UL;
   tf->codes[16614] = 0x0001fc37795905f6UL;
   tf->codes[16615] = 0x0001fc3bd1f67395UL;
   tf->codes[16616] = 0x0001fc54112ed727UL;
   tf->codes[16617] = 0x0001fc6190252b8eUL;
   tf->codes[16618] = 0x0001fc706e75a293UL;
   tf->codes[16619] = 0x0001fc869ea6d238UL;
   tf->codes[16620] = 0x0001fc86d935d7fdUL;
   tf->codes[16621] = 0x0001fc8b31d3459cUL;
   tf->codes[16622] = 0x0001fc9a4ab2c266UL;
   tf->codes[16623] = 0x0001fc9b34eed97aUL;
   tf->codes[16624] = 0x0001fc9edddf35caUL;
   tf->codes[16625] = 0x0001fce08436ada5UL;
   tf->codes[16626] = 0x0001fce8fae2831eUL;
   tf->codes[16627] = 0x0001fcf30b7780faUL;
   tf->codes[16628] = 0x0001fcfef084acfeUL;
   tf->codes[16629] = 0x0001fd1e0c7fbda6UL;
   tf->codes[16630] = 0x0001fd2389e8481eUL;
   tf->codes[16631] = 0x0001fd4096dc24d9UL;
   tf->codes[16632] = 0x0001fd5f78482fbcUL;
   tf->codes[16633] = 0x0001fd7b25e1e9d9UL;
   tf->codes[16634] = 0x0001fd823d339cb4UL;
   tf->codes[16635] = 0x0001fd87457e1ba2UL;
   tf->codes[16636] = 0x0001fd8b9e1b8941UL;
   tf->codes[16637] = 0x0001fda27df9ca35UL;
   tf->codes[16638] = 0x0001fdb9d2f616b3UL;
   tf->codes[16639] = 0x0001fdc458a92019UL;
   tf->codes[16640] = 0x0001fdebeb50063aUL;
   tf->codes[16641] = 0x0001fe05ff0097f4UL;
   tf->codes[16642] = 0x0001fe27d9afedd8UL;
   tf->codes[16643] = 0x0001fe60943d84b0UL;
   tf->codes[16644] = 0x0001fe805fe5a6a7UL;
   tf->codes[16645] = 0x0001fe8bcfd4c721UL;
   tf->codes[16646] = 0x0001fe91c25b5d23UL;
   tf->codes[16647] = 0x0001feba04af5493UL;
   tf->codes[16648] = 0x0001febd7310ab1eUL;
   tf->codes[16649] = 0x0001fec783a5a8faUL;
   tf->codes[16650] = 0x0001fed8ab8c59b1UL;
   tf->codes[16651] = 0x0001fef0eac4bd43UL;
   tf->codes[16652] = 0x0001fef15fe2c8cdUL;
   tf->codes[16653] = 0x0001ff06a5d7e15eUL;
   tf->codes[16654] = 0x0001ff1eaa813f2bUL;
   tf->codes[16655] = 0x0001ff2a8f8e6b2fUL;
   tf->codes[16656] = 0x0001ff3a92a9ff0dUL;
   tf->codes[16657] = 0x0001ff4134dda65eUL;
   tf->codes[16658] = 0x0001ff48fbdc6a88UL;
   tf->codes[16659] = 0x0001ff843a8f40d7UL;
   tf->codes[16660] = 0x0001ff9a30316ab7UL;
   tf->codes[16661] = 0x0001ff9aa54f7641UL;
   tf->codes[16662] = 0x0001ffa1f7302ee1UL;
   tf->codes[16663] = 0x0001ffbcf51cd7afUL;
   tf->codes[16664] = 0x0001ffdbd688e292UL;
   tf->codes[16665] = 0x0001fff4c56e5773UL;
   tf->codes[16666] = 0x0001fff70f049125UL;
   tf->codes[16667] = 0x0001ffff4b2160d9UL;
   tf->codes[16668] = 0x00000000aa7b8377UL;
   tf->codes[16669] = 0x0000000a45f275c9UL;
   tf->codes[16670] = 0x0000000b6abd92a2UL;
   tf->codes[16671] = 0x0000001a0e7f03e2UL;
   tf->codes[16672] = 0x0000009dd04bff22UL;
   tf->codes[16673] = 0x000000ad98d88d3bUL;
   tf->codes[16674] = 0x000000e7783140ecUL;
   tf->codes[16675] = 0x000000ea71748bedUL;
   tf->codes[16676] = 0x000000ef79bf0adbUL;
   tf->codes[16677] = 0x000001077e6868a8UL;
   tf->codes[16678] = 0x00000125b027623cUL;
   tf->codes[16679] = 0x000001495f4ee648UL;
   tf->codes[16680] = 0x0000014a841a0321UL;
   tf->codes[16681] = 0x00000154cf3e06c2UL;
   tf->codes[16682] = 0x0000017d1191fe32UL;
   tf->codes[16683] = 0x0000018379369fbeUL;
   tf->codes[16684] = 0x000001979a609b76UL;
   tf->codes[16685] = 0x000001a135d78dc8UL;
   tf->codes[16686] = 0x000001b347fa5593UL;
   tf->codes[16687] = 0x000001c9782b8538UL;
   tf->codes[16688] = 0x0000021569a700b4UL;
   tf->codes[16689] = 0x00000228a094e558UL;
   tf->codes[16690] = 0x0000022aaf9c1945UL;
   tf->codes[16691] = 0x000002365a1a3f84UL;
   tf->codes[16692] = 0x0000026419d6c16cUL;
   tf->codes[16693] = 0x000002816159a3ecUL;
   tf->codes[16694] = 0x0000028669a422daUL;
   tf->codes[16695] = 0x000002945db882cbUL;
   tf->codes[16696] = 0x000002a9de3ca121UL;
   tf->codes[16697] = 0x000002be7484a863UL;
   tf->codes[16698] = 0x000002d972715131UL;
   tf->codes[16699] = 0x000002f4aaecffc4UL;
   tf->codes[16700] = 0x000002fb4d20a715UL;
   tf->codes[16701] = 0x000002fd2198d53dUL;
   tf->codes[16702] = 0x00000303141f6b3fUL;
   tf->codes[16703] = 0x0000030fa8d9a892UL;
   tf->codes[16704] = 0x0000033f3d0e58a2UL;
   tf->codes[16705] = 0x000003456a23f469UL;
   tf->codes[16706] = 0x0000035a3afb0170UL;
   tf->codes[16707] = 0x0000037dea22857cUL;
   tf->codes[16708] = 0x0000038451c72708UL;
   tf->codes[16709] = 0x0000038f4c983bf8UL;
   tf->codes[16710] = 0x00000390abf25e96UL;
   tf->codes[16711] = 0x0000039d061d9624UL;
   tf->codes[16712] = 0x000003a96048cdb2UL;
   tf->codes[16713] = 0x000003b66a21168fUL;
   tf->codes[16714] = 0x000003f342bd1541UL;
   tf->codes[16715] = 0x000003fa5a0ec81cUL;
   tf->codes[16716] = 0x00000417a191aa9cUL;
   tf->codes[16717] = 0x0000041b4a8206ecUL;
   tf->codes[16718] = 0x00000435d350a430UL;
   tf->codes[16719] = 0x00000441433fc4aaUL;
   tf->codes[16720] = 0x000004464b8a4398UL;
   tf->codes[16721] = 0x000004e0ed357fccUL;
   tf->codes[16722] = 0x000004e3abe9c508UL;
   tf->codes[16723] = 0x000004e879a53e31UL;
   tf->codes[16724] = 0x0000051b7c3b44ccUL;
   tf->codes[16725] = 0x0000052049f6bdf5UL;
   tf->codes[16726] = 0x00000529e56db047UL;
   tf->codes[16727] = 0x00000531ac6c7471UL;
   tf->codes[16728] = 0x000005513d8590a3UL;
   tf->codes[16729] = 0x000005559622fe42UL;
   tf->codes[16730] = 0x000005676db6c048UL;
   tf->codes[16731] = 0x00000587395ee23fUL;
   tf->codes[16732] = 0x0000058c41a9612dUL;
   tf->codes[16733] = 0x000005989bd498bbUL;
   tf->codes[16734] = 0x0000059bcfa6e981UL;
   tf->codes[16735] = 0x000005a2374b8b0dUL;
   tf->codes[16736] = 0x000005a5e03be75dUL;
   tf->codes[16737] = 0x000005be94925679UL;
   tf->codes[16738] = 0x000005c327bec9ddUL;
   tf->codes[16739] = 0x000005c44c89e6b6UL;
   tf->codes[16740] = 0x000005d3da876f0aUL;
   tf->codes[16741] = 0x000006207baffbd5UL;
   tf->codes[16742] = 0x00000638805959a2UL;
   tf->codes[16743] = 0x00000656b2185336UL;
   tf->codes[16744] = 0x00000671ea9401c9UL;
   tf->codes[16745] = 0x00000677dd1a97cbUL;
   tf->codes[16746] = 0x000006801937677fUL;
   tf->codes[16747] = 0x00000698586fcb11UL;
   tf->codes[16748] = 0x000006ae4e11f4f1UL;
   tf->codes[16749] = 0x000006bcf1d36631UL;
   tf->codes[16750] = 0x000006ff47d7ef5bUL;
   tf->codes[16751] = 0x000007174c814d28UL;
   tf->codes[16752] = 0x0000071deeb4f479UL;
   tf->codes[16753] = 0x00000765fcb10de0UL;
   tf->codes[16754] = 0x0000076fd2b705f7UL;
   tf->codes[16755] = 0x00000774a0727f20UL;
   tf->codes[16756] = 0x000007a2602f0108UL;
   tf->codes[16757] = 0x000007a29abe06cdUL;
   tf->codes[16758] = 0x000007b7a6241999UL;
   tf->codes[16759] = 0x000007d6c21f2a41UL;
   tf->codes[16760] = 0x000007ddd970dd1cUL;
   tf->codes[16761] = 0x000007de4e8ee8a6UL;
   tf->codes[16762] = 0x000007f09b40b636UL;
   tf->codes[16763] = 0x000007f359f4fb72UL;
   tf->codes[16764] = 0x00000803979f9515UL;
   tf->codes[16765] = 0x00000808655b0e3eUL;
   tf->codes[16766] = 0x000008270c38135cUL;
   tf->codes[16767] = 0x000008575019d4bbUL;
   tf->codes[16768] = 0x0000086cd09df311UL;
   tf->codes[16769] = 0x00000890f4e382a7UL;
   tf->codes[16770] = 0x0000089d899dbffaUL;
   tf->codes[16771] = 0x000008a96eaaebfeUL;
   tf->codes[16772] = 0x000008bb0bafa83fUL;
   tf->codes[16773] = 0x000008c8c535026bUL;
   tf->codes[16774] = 0x000008ca99ad3093UL;
   tf->codes[16775] = 0x000008f943a5c98fUL;
   tf->codes[16776] = 0x00000900d01587f4UL;
   tf->codes[16777] = 0x000009231fe2e962UL;
   tf->codes[16778] = 0x0000092b5bffb916UL;
   tf->codes[16779] = 0x0000094151a1e2f6UL;
   tf->codes[16780] = 0x000009461f5d5c1fUL;
   tf->codes[16781] = 0x0000094a77fac9beUL;
   tf->codes[16782] = 0x00000959564b40c3UL;
   tf->codes[16783] = 0x0000095b655274b0UL;
   tf->codes[16784] = 0x0000095d7459a89dUL;
   tf->codes[16785] = 0x00000963a16f4464UL;
   tf->codes[16786] = 0x00000966259483dbUL;
   tf->codes[16787] = 0x00000971d012aa1aUL;
   tf->codes[16788] = 0x00000982484c4982UL;
   tf->codes[16789] = 0x0000098d088e58adUL;
   tf->codes[16790] = 0x000009950a1c229cUL;
   tf->codes[16791] = 0x000009d8fa09d429UL;
   tf->codes[16792] = 0x000009edcae0e130UL;
   tf->codes[16793] = 0x000009fe431a8098UL;
   tf->codes[16794] = 0x00000a19b62534f0UL;
   tf->codes[16795] = 0x00000a1ebe6fb3deUL;
   tf->codes[16796] = 0x00000a29b940c8ceUL;
   tf->codes[16797] = 0x00000a34b411ddbeUL;
   tf->codes[16798] = 0x00000a405e9003fdUL;
   tf->codes[16799] = 0x00000a41835b20d6UL;
   tf->codes[16800] = 0x00000a4a3495fc14UL;
   tf->codes[16801] = 0x00000a5654322dddUL;
   tf->codes[16802] = 0x00000a5bd19ab855UL;
   tf->codes[16803] = 0x00000a5fefa9202fUL;
   tf->codes[16804] = 0x00000a609f56317eUL;
   tf->codes[16805] = 0x00000a63d3288244UL;
   tf->codes[16806] = 0x00000a66cc6bcd45UL;
   tf->codes[16807] = 0x00000a89cbe64002UL;
   tf->codes[16808] = 0x00000a9c8db6191cUL;
   tf->codes[16809] = 0x00000a9f4c6a5e58UL;
   tf->codes[16810] = 0x00000aa50461ee95UL;
   tf->codes[16811] = 0x00000aa5ee9e05a9UL;
   tf->codes[16812] = 0x00000aab6c069021UL;
   tf->codes[16813] = 0x00000ab4925f76e9UL;
   tf->codes[16814] = 0x00000ab9601af012UL;
   tf->codes[16815] = 0x00000acbe75bc367UL;
   tf->codes[16816] = 0x00000afeaf62c43dUL;
   tf->codes[16817] = 0x00000b07260e99b6UL;
   tf->codes[16818] = 0x00000b0eed0d5de0UL;
   tf->codes[16819] = 0x00000b1938316181UL;
   tf->codes[16820] = 0x00000b2b4a54294cUL;
   tf->codes[16821] = 0x00000b856a730a7eUL;
   tf->codes[16822] = 0x00000ba98eb89a14UL;
   tf->codes[16823] = 0x00000bcab9badea9UL;
   tf->codes[16824] = 0x00000bcaf449e46eUL;
   tf->codes[16825] = 0x00000bdc914ea0afUL;
   tf->codes[16826] = 0x00000bde2b37c912UL;
   tf->codes[16827] = 0x00000be78c1fb59fUL;
   tf->codes[16828] = 0x00000c1fd18f40edUL;
   tf->codes[16829] = 0x00000c20813c523cUL;
   tf->codes[16830] = 0x00000c33087d2591UL;
   tf->codes[16831] = 0x00000c446af2dc0dUL;
   tf->codes[16832] = 0x00000c613d57b303UL;
   tf->codes[16833] = 0x00000c66f54f4340UL;
   tf->codes[16834] = 0x00000c69b403887cUL;
   tf->codes[16835] = 0x00000c994838388cUL;
   tf->codes[16836] = 0x00000cbb980599faUL;
   tf->codes[16837] = 0x00000cc74283c039UL;
   tf->codes[16838] = 0x00000d22fc8bc9ceUL;
   tf->codes[16839] = 0x00000d26305e1a94UL;
   tf->codes[16840] = 0x00000d4a1a14a465UL;
   tf->codes[16841] = 0x00000d981a9753ceUL;
   tf->codes[16842] = 0x00000da1f09d4be5UL;
   tf->codes[16843] = 0x00000dafe4b1abd6UL;
   tf->codes[16844] = 0x00000dd2a99d18ceUL;
   tf->codes[16845] = 0x00000dd7775891f7UL;
   tf->codes[16846] = 0x00000dec482f9efeUL;
   tf->codes[16847] = 0x00000df23ab63500UL;
   tf->codes[16848] = 0x00000df5a9178b8bUL;
   tf->codes[16849] = 0x00000df98c96eda0UL;
   tf->codes[16850] = 0x00000dfd358749f0UL;
   tf->codes[16851] = 0x00000e55f64c0884UL;
   tf->codes[16852] = 0x00000e599f3c64d4UL;
   tf->codes[16853] = 0x00000e7dc381f46aUL;
   tf->codes[16854] = 0x00000e83065b791dUL;
   tf->codes[16855] = 0x00000e851562ad0aUL;
   tf->codes[16856] = 0x00000eb9ec70e1cdUL;
   tf->codes[16857] = 0x00000eba9c1df31cUL;
   tf->codes[16858] = 0x00000ed01ca21172UL;
   tf->codes[16859] = 0x00000ed55f7b9625UL;
   tf->codes[16860] = 0x00000edec06382b2UL;
   tf->codes[16861] = 0x00000f009b12d896UL;
   tf->codes[16862] = 0x00000f445071845eUL;
   tf->codes[16863] = 0x00000f6edc5bb580UL;
   tf->codes[16864] = 0x00000f7fc9b36072UL;
   tf->codes[16865] = 0x00000f84976ed99bUL;
   tf->codes[16866] = 0x00000f8b39a280ecUL;
   tf->codes[16867] = 0x00000fe7a3579bd0UL;
   tf->codes[16868] = 0x00000ff7a6732faeUL;
   tf->codes[16869] = 0x00001066d1f823acUL;
   tf->codes[16870] = 0x000010a3e5232823UL;
   tf->codes[16871] = 0x000010b6a6f3013dUL;
   tf->codes[16872] = 0x000010bea880cb2cUL;
   tf->codes[16873] = 0x000010c49b07612eUL;
   tf->codes[16874] = 0x000010d2548cbb5aUL;
   tf->codes[16875] = 0x000010d6729b2334UL;
   tf->codes[16876] = 0x000010dd14ceca85UL;
   tf->codes[16877] = 0x000010e9a98907d8UL;
   tf->codes[16878] = 0x0000110382aa93cdUL;
   tf->codes[16879] = 0x00001137e49abd06UL;
   tf->codes[16880] = 0x0000113c02a924e0UL;
   tf->codes[16881] = 0x0000113f710a7b6bUL;
   tf->codes[16882] = 0x000011594a2c0760UL;
   tf->codes[16883] = 0x0000115bce5146d7UL;
   tf->codes[16884] = 0x00001172ae2f87cbUL;
   tf->codes[16885] = 0x000011740d89aa69UL;
   tf->codes[16886] = 0x00001174f7c5c17dUL;
   tf->codes[16887] = 0x00001176cc3defa5UL;
   tf->codes[16888] = 0x0000119af0837f3bUL;
   tf->codes[16889] = 0x000011a6d590ab3fUL;
   tf->codes[16890] = 0x0000125e842fc42eUL;
   tf->codes[16891] = 0x000012973ebd5b06UL;
   tf->codes[16892] = 0x0000129f05bc1f30UL;
   tf->codes[16893] = 0x000012bc12affbebUL;
   tf->codes[16894] = 0x000012d8aa85cd1cUL;
   tf->codes[16895] = 0x000012d95a32de6bUL;
   tf->codes[16896] = 0x000012e036f58b81UL;
   tf->codes[16897] = 0x000012ea0cfb8398UL;
   tf->codes[16898] = 0x000012f9d58811b1UL;
   tf->codes[16899] = 0x000013045b3b1b17UL;
   tf->codes[16900] = 0x00001313e938a36bUL;
   tf->codes[16901] = 0x0000131c2555731fUL;
   tf->codes[16902] = 0x0000131f93b6c9aaUL;
   tf->codes[16903] = 0x00001328ba0fb072UL;
   tf->codes[16904] = 0x0000133bf0fd9516UL;
   tf->codes[16905] = 0x00001346ebceaa06UL;
   tf->codes[16906] = 0x00001379b3d5aadcUL;
   tf->codes[16907] = 0x000013834f4c9d2eUL;
   tf->codes[16908] = 0x000013855e53d11bUL;
   tf->codes[16909] = 0x00001386f83cf97eUL;
   tf->codes[16910] = 0x0000138ef9cac36dUL;
   tf->codes[16911] = 0x000013b567a68cb5UL;
   tf->codes[16912] = 0x000013c530331aceUL;
   tf->codes[16913] = 0x000013e5366a428aUL;
   tf->codes[16914] = 0x000013f32a7ea27bUL;
   tf->codes[16915] = 0x0000140fc25473acUL;
   tf->codes[16916] = 0x0000143e31be06e3UL;
   tf->codes[16917] = 0x000014528d770860UL;
   tf->codes[16918] = 0x0000145586ba5361UL;
   tf->codes[16919] = 0x0000146290929c3eUL;
   tf->codes[16920] = 0x00001466aea10418UL;
   tf->codes[16921] = 0x0000147acfcaffd0UL;
   tf->codes[16922] = 0x0000148b0d759973UL;
   tf->codes[16923] = 0x00001496f282c577UL;
   tf->codes[16924] = 0x000014a3c1cc088fUL;
   tf->codes[16925] = 0x000014ebcfc821f6UL;
   tf->codes[16926] = 0x000014f77a464835UL;
   tf->codes[16927] = 0x000015035f537439UL;
   tf->codes[16928] = 0x0000151327e00252UL;
   tf->codes[16929] = 0x00001519ca13a9a3UL;
   tf->codes[16930] = 0x00001552bf304640UL;
   tf->codes[16931] = 0x0000157eaa749a00UL;
   tf->codes[16932] = 0x000015875baf753eUL;
   tf->codes[16933] = 0x00001596748ef208UL;
   tf->codes[16934] = 0x0000159cdc339394UL;
   tf->codes[16935] = 0x000015a0fa41fb6eUL;
   tf->codes[16936] = 0x000015a16f6006f8UL;
   tf->codes[16937] = 0x000015a2ceba2996UL;
   tf->codes[16938] = 0x000015ad8efc38c1UL;
   tf->codes[16939] = 0x000015b605a80e3aUL;
   tf->codes[16940] = 0x000015cdcfc26642UL;
   tf->codes[16941] = 0x000015db4eb8baa9UL;
   tf->codes[16942] = 0x000015eec035a512UL;
   tf->codes[16943] = 0x00001603cb9bb7deUL;
   tf->codes[16944] = 0x0000160e8bddc709UL;
   tf->codes[16945] = 0x0000161b95b60fe6UL;
   tf->codes[16946] = 0x000016235cb4d410UL;
   tf->codes[16947] = 0x0000162ae9249275UL;
   tf->codes[16948] = 0x00001651cc1e6747UL;
   tf->codes[16949] = 0x0000165c51d170adUL;
   tf->codes[16950] = 0x0000167874893654UL;
   tf->codes[16951] = 0x0000167f8bdae92fUL;
   tf->codes[16952] = 0x00001697908446fcUL;
   tf->codes[16953] = 0x000016b671f051dfUL;
   tf->codes[16954] = 0x000016c724b8f70cUL;
   tf->codes[16955] = 0x000016cb42c75ee6UL;
   tf->codes[16956] = 0x000016fbc138260aUL;
   tf->codes[16957] = 0x0000170bc453b9e8UL;
   tf->codes[16958] = 0x00001717e3efebb1UL;
   tf->codes[16959] = 0x00001724b3392ec9UL;
   tf->codes[16960] = 0x00001733cc18ab93UL;
   tf->codes[16961] = 0x00001736ffeafc59UL;
   tf->codes[16962] = 0x0000174b5ba3fdd6UL;
   tf->codes[16963] = 0x0000175a74837aa0UL;
   tf->codes[16964] = 0x0000175e1d73d6f0UL;
   tf->codes[16965] = 0x0000176ab22e1443UL;
   tf->codes[16966] = 0x00001777f69562e5UL;
   tf->codes[16967] = 0x00001778e0d179f9UL;
   tf->codes[16968] = 0x00001784c5dea5fdUL;
   tf->codes[16969] = 0x00001789ce2924ebUL;
   tf->codes[16970] = 0x000017bf1a556538UL;
   tf->codes[16971] = 0x000017dc274941f3UL;
   tf->codes[16972] = 0x000017e6726d4594UL;
   tf->codes[16973] = 0x000017e6acfc4b59UL;
   tf->codes[16974] = 0x000017f3072782e7UL;
   tf->codes[16975] = 0x00001808128d95b3UL;
   tf->codes[16976] = 0x000018288de2c8f9UL;
   tf->codes[16977] = 0x00001842dc226078UL;
   tf->codes[16978] = 0x00001869848d2f85UL;
   tf->codes[16979] = 0x000018ba7e5329efUL;
   tf->codes[16980] = 0x000018bf4c0ea318UL;
   tf->codes[16981] = 0x000018d95fbf34d2UL;
   tf->codes[16982] = 0x000018e2fb362724UL;
   tf->codes[16983] = 0x000018e50a3d5b11UL;
   tf->codes[16984] = 0x000019007d480f69UL;
   tf->codes[16985] = 0x00001903eba965f4UL;
   tf->codes[16986] = 0x00001925513ab04eUL;
   tf->codes[16987] = 0x0000192e77939716UL;
   tf->codes[16988] = 0x0000194432a6bb31UL;
   tf->codes[16989] = 0x00001953c0a44385UL;
   tf->codes[16990] = 0x0000195ebb755875UL;
   tf->codes[16991] = 0x00001983c9f6ff1fUL;
   tf->codes[16992] = 0x000019a94d96b153UL;
   tf->codes[16993] = 0x000019b09f7769f3UL;
   tf->codes[16994] = 0x000019bfb856e6bdUL;
   tf->codes[16995] = 0x00001a0925ad22c2UL;
   tf->codes[16996] = 0x00001a14207e37b2UL;
   tf->codes[16997] = 0x00001a162f856b9fUL;
   tf->codes[16998] = 0x00001a5b443e3a05UL;
   tf->codes[16999] = 0x00001a60c1a6c47dUL;
   tf->codes[17000] = 0x00001a64a5262692UL;
   tf->codes[17001] = 0x00001a960dd304caUL;
   tf->codes[17002] = 0x00001a99b6c3611aUL;
   tf->codes[17003] = 0x00001a9c00599accUL;
   tf->codes[17004] = 0x00001ab85da06638UL;
   tf->codes[17005] = 0x00001ac61725c064UL;
   tf->codes[17006] = 0x00001ac94af8112aUL;
   tf->codes[17007] = 0x00001ae56dafd6d1UL;
   tf->codes[17008] = 0x00001ae7422804f9UL;
   tf->codes[17009] = 0x00001ae9512f38e6UL;
   tf->codes[17010] = 0x00001af277881faeUL;
   tf->codes[17011] = 0x00001b4545c64840UL;
   tf->codes[17012] = 0x00001b5a169d5547UL;
   tf->codes[17013] = 0x00001ba050214086UL;
   tf->codes[17014] = 0x00001be898ac5fb2UL;
   tf->codes[17015] = 0x00001c6458eb9103UL;
   tf->codes[17016] = 0x00001c7df77e1733UL;
   tf->codes[17017] = 0x00001d043d7051eaUL;
   tf->codes[17018] = 0x00001d0d9e583e77UL;
   tf->codes[17019] = 0x00001d12a6a2bd65UL;
   tf->codes[17020] = 0x00001d5b29bce256UL;
   tf->codes[17021] = 0x00001d7ed8e46662UL;
   tf->codes[17022] = 0x00001d82bc63c877UL;
   tf->codes[17023] = 0x00001d9d7fc16b80UL;
   tf->codes[17024] = 0x00001dd465d6d430UL;
   tf->codes[17025] = 0x00001de3f3d45c84UL;
   tf->codes[17026] = 0x00001e1f328732d3UL;
   tf->codes[17027] = 0x00001e3144a9fa9eUL;
   tf->codes[17028] = 0x00001e55de0d95beUL;
   tf->codes[17029] = 0x00001e5e8f4870fcUL;
   tf->codes[17030] = 0x00001e77b8bceba2UL;
   tf->codes[17031] = 0x00001ed5bc5b2ee9UL;
   tf->codes[17032] = 0x00001f0bb8348085UL;
   tf->codes[17033] = 0x00001f3559e29a93UL;
   tf->codes[17034] = 0x00001f3bfc1641e4UL;
   tf->codes[17035] = 0x00001f4388860049UL;
   tf->codes[17036] = 0x00001f4856417972UL;
   tf->codes[17037] = 0x00001f789a233ad1UL;
   tf->codes[17038] = 0x00001f927344c6c6UL;
   tf->codes[17039] = 0x00001f9c0ebbb918UL;
   tf->codes[17040] = 0x00001fa151953dcbUL;
   tf->codes[17041] = 0x00001fa276605aa4UL;
   tf->codes[17042] = 0x00001fc70fc3f5c4UL;
   tf->codes[17043] = 0x00001fd32f60278dUL;
   tf->codes[17044] = 0x000020037341e8ecUL;
   tf->codes[17045] = 0x0000200b3a40ad16UL;
   tf->codes[17046] = 0x0000200d83d6e6c8UL;
   tf->codes[17047] = 0x000020530dadc0b8UL;
   tf->codes[17048] = 0x000020567c0f1743UL;
   tf->codes[17049] = 0x00002084765a9ef0UL;
   tf->codes[17050] = 0x000020861043c753UL;
   tf->codes[17051] = 0x00002094b4053893UL;
   tf->codes[17052] = 0x0000209f39b841f9UL;
   tf->codes[17053] = 0x000020ae8d26c488UL;
   tf->codes[17054] = 0x000020b7b37fab50UL;
   tf->codes[17055] = 0x000020bde0954717UL;
   tf->codes[17056] = 0x00002102803009f3UL;
   tf->codes[17057] = 0x00002123361442feUL;
   tf->codes[17058] = 0x000021299db8e48aUL;
   tf->codes[17059] = 0x00002178c306b0ccUL;
   tf->codes[17060] = 0x000021b52684a3f4UL;
   tf->codes[17061] = 0x000021c85d728898UL;
   tf->codes[17062] = 0x000021d26e078674UL;
   tf->codes[17063] = 0x000021f35e7ac544UL;
   tf->codes[17064] = 0x000021f61d2f0a80UL;
   tf->codes[17065] = 0x000021f7f1a738a8UL;
   tf->codes[17066] = 0x000022462cb8edd6UL;
   tf->codes[17067] = 0x000022503d4debb2UL;
   tf->codes[17068] = 0x0000227f21d58a73UL;
   tf->codes[17069] = 0x0000228a91c4aaedUL;
   tf->codes[17070] = 0x00002298c06810a3UL;
   tf->codes[17071] = 0x0000229d19057e42UL;
   tf->codes[17072] = 0x000022c55b5975b2UL;
   tf->codes[17073] = 0x000022cbfd8d1d03UL;
   tf->codes[17074] = 0x000022cebc41623fUL;
   tf->codes[17075] = 0x000023318d9b1eafUL;
   tf->codes[17076] = 0x00002332b2663b88UL;
   tf->codes[17077] = 0x0000233aee830b3cUL;
   tf->codes[17078] = 0x000023470e1f3d05UL;
   tf->codes[17079] = 0x0000234b66bcaaa4UL;
   tf->codes[17080] = 0x0000237f18ffc28eUL;
   tf->codes[17081] = 0x000023987d0342f9UL;
   tf->codes[17082] = 0x00002398b79248beUL;
   tf->codes[17083] = 0x000023a377d457e9UL;
   tf->codes[17084] = 0x000023a8baaddc9cUL;
   tf->codes[17085] = 0x000023d7d9c48122UL;
   tf->codes[17086] = 0x000023fef74d5bb9UL;
   tf->codes[17087] = 0x00002409b78f6ae4UL;
   tf->codes[17088] = 0x0000241b1a052160UL;
   tf->codes[17089] = 0x0000243bcfe95a6bUL;
   tf->codes[17090] = 0x00002442acac0781UL;
   tf->codes[17091] = 0x000024806f841d47UL;
   tf->codes[17092] = 0x00002482f3a95cbeUL;
   tf->codes[17093] = 0x000024b790288bbcUL;
   tf->codes[17094] = 0x000024c12b9f7e0eUL;
   tf->codes[17095] = 0x000024c793441f9aUL;
   tf->codes[17096] = 0x000024dbeefd2117UL;
   tf->codes[17097] = 0x00002504a66f2411UL;
   tf->codes[17098] = 0x0000250bbdc0d6ecUL;
   tf->codes[17099] = 0x00002519b1d536ddUL;
   tf->codes[17100] = 0x0000252d5de1270bUL;
   tf->codes[17101] = 0x000025360f1c0249UL;
   tf->codes[17102] = 0x0000253942ee530fUL;
   tf->codes[17103] = 0x000025464cc69becUL;
   tf->codes[17104] = 0x0000255feb59221cUL;
   tf->codes[17105] = 0x000025b836ffd526UL;
   tf->codes[17106] = 0x000025cbe30bc554UL;
   tf->codes[17107] = 0x000025cea1c00a90UL;
   tf->codes[17108] = 0x000025d877c602a7UL;
   tf->codes[17109] = 0x000025e19e1ee96fUL;
   tf->codes[17110] = 0x000025e3e7b52321UL;
   tf->codes[17111] = 0x000025e7561679acUL;
   tf->codes[17112] = 0x0000261515d2fb94UL;
   tf->codes[17113] = 0x000026738e8f4a65UL;
   tf->codes[17114] = 0x000026823250bba5UL;
   tf->codes[17115] = 0x000026a656964b3bUL;
   tf->codes[17116] = 0x000026cf489753faUL;
   tf->codes[17117] = 0x000026d5008ee437UL;
   tf->codes[17118] = 0x000026d7bf432973UL;
   tf->codes[17119] = 0x000026e69d93a078UL;
   tf->codes[17120] = 0x000026e7c25ebd51UL;
   tf->codes[17121] = 0x000026f5b6731d42UL;
   tf->codes[17122] = 0x000026f7505c45a5UL;
   tf->codes[17123] = 0x00002742ccb9b597UL;
   tf->codes[17124] = 0x000027572872b714UL;
   tf->codes[17125] = 0x000027855d4d4486UL;
   tf->codes[17126] = 0x000027976f700c51UL;
   tf->codes[17127] = 0x000027aa6bceeb30UL;
   tf->codes[17128] = 0x000027ba6eea7f0eUL;
   tf->codes[17129] = 0x000027c2e5965487UL;
   tf->codes[17130] = 0x000027e117554e1bUL;
   tf->codes[17131] = 0x000028124573268eUL;
   tf->codes[17132] = 0x00002822f83bcbbbUL;
   tf->codes[17133] = 0x00002843e8af0a8bUL;
   tf->codes[17134] = 0x000028592ea4231cUL;
   tf->codes[17135] = 0x0000286a568ad3d3UL;
   tf->codes[17136] = 0x000028884dbac7a2UL;
   tf->codes[17137] = 0x000028aef62596afUL;
   tf->codes[17138] = 0x000028b8570d833cUL;
   tf->codes[17139] = 0x000028b906ba948bUL;
   tf->codes[17140] = 0x000028b941499a50UL;
   tf->codes[17141] = 0x000028ba2b85b164UL;
   tf->codes[17142] = 0x000028c4b138bacaUL;
   tf->codes[17143] = 0x000028d43f36431eUL;
   tf->codes[17144] = 0x000028df74965dd3UL;
   tf->codes[17145] = 0x0000290398dbed69UL;
   tf->codes[17146] = 0x0000294a0ceede6dUL;
   tf->codes[17147] = 0x00002952839ab3e6UL;
   tf->codes[17148] = 0x0000297cd4f5df43UL;
   tf->codes[17149] = 0x000029aa94b2612bUL;
   tf->codes[17150] = 0x000029c1af1fa7e4UL;
   tf->codes[17151] = 0x000029c34908d047UL;
   tf->codes[17152] = 0x000029da63761700UL;
   tf->codes[17153] = 0x000029f97f7127a8UL;
   tf->codes[17154] = 0x00002a0b1c75e3e9UL;
   tf->codes[17155] = 0x00002a15dcb7f314UL;
   tf->codes[17156] = 0x00002a17ebbf2701UL;
   tf->codes[17157] = 0x00002a1c09cd8edbUL;
   tf->codes[17158] = 0x00002a20d7890804UL;
   tf->codes[17159] = 0x00002a3867145a47UL;
   tf->codes[17160] = 0x00002a3ab0aa93f9UL;
   tf->codes[17161] = 0x00002a83e371ca39UL;
   tf->codes[17162] = 0x00002a857d5af29cUL;
   tf->codes[17163] = 0x00002abb041638aeUL;
   tf->codes[17164] = 0x00002ac723b26a77UL;
   tf->codes[17165] = 0x00002ae087b5eae2UL;
   tf->codes[17166] = 0x00002ae5900069d0UL;
   tf->codes[17167] = 0x00002b0b88be278eUL;
   tf->codes[17168] = 0x00002b23c7f68b20UL;
   tf->codes[17169] = 0x00002b2a2f9b2cacUL;
   tf->codes[17170] = 0x00002b7f81fe94b5UL;
   tf->codes[17171] = 0x00002b8ba19ac67eUL;
   tf->codes[17172] = 0x00002baabd95d726UL;
   tf->codes[17173] = 0x00002bb961574866UL;
   tf->codes[17174] = 0x00002bc45c285d56UL;
   tf->codes[17175] = 0x00002bd8f2706498UL;
   tf->codes[17176] = 0x00002be9301afe3bUL;
   tf->codes[17177] = 0x00002c016f5361cdUL;
   tf->codes[17178] = 0x00002c3596b48541UL;
   tf->codes[17179] = 0x00002c422b6ec294UL;
   tf->codes[17180] = 0x00002c685ebb8617UL;
   tf->codes[17181] = 0x00002c77027cf757UL;
   tf->codes[17182] = 0x00002caa0512fdf2UL;
   tf->codes[17183] = 0x00002cbffab527d2UL;
   tf->codes[17184] = 0x00002ceb364c6a43UL;
   tf->codes[17185] = 0x00002cfbe9150f70UL;
   tf->codes[17186] = 0x00002d08434046feUL;
   tf->codes[17187] = 0x00002d2724ac51e1UL;
   tf->codes[17188] = 0x00002d42d2460bfeUL;
   tf->codes[17189] = 0x00002d43f71128d7UL;
   tf->codes[17190] = 0x00002d4a5eb5ca63UL;
   tf->codes[17191] = 0x00002d5bfbba86a4UL;
   tf->codes[17192] = 0x00002d69efcee695UL;
   tf->codes[17193] = 0x00002d72db98c798UL;
   tf->codes[17194] = 0x00002d8bca7e3c79UL;
   tf->codes[17195] = 0x00002dab210852e6UL;
   tf->codes[17196] = 0x00002dac0b4469faUL;
   tf->codes[17197] = 0x00002dc1c6578e15UL;
   tf->codes[17198] = 0x00002dc5e465f5efUL;
   tf->codes[17199] = 0x00002e09d453a77cUL;
   tf->codes[17200] = 0x00002e43791d5568UL;
   tf->codes[17201] = 0x00002e45fd4294dfUL;
   tf->codes[17202] = 0x00002e4fd3488cf6UL;
   tf->codes[17203] = 0x00002e6a21882475UL;
   tf->codes[17204] = 0x00002e7eb7d02bb7UL;
   tf->codes[17205] = 0x00002ea6fa242327UL;
   tf->codes[17206] = 0x00002ea97e49629eUL;
   tf->codes[17207] = 0x00002eaa2df673edUL;
   tf->codes[17208] = 0x00002ed9fcba29c2UL;
   tf->codes[17209] = 0x00002ede55579761UL;
   tf->codes[17210] = 0x00002ee18929e827UL;
   tf->codes[17211] = 0x00002f04fdc2666eUL;
   tf->codes[17212] = 0x00002f34cc861c43UL;
   tf->codes[17213] = 0x00002f5bea0ef6daUL;
   tf->codes[17214] = 0x00002f607d3b6a3eUL;
   tf->codes[17215] = 0x00002f64d5d8d7ddUL;
   tf->codes[17216] = 0x00002f666fc20040UL;
   tf->codes[17217] = 0x00002f9d1b48632bUL;
   tf->codes[17218] = 0x00002f9e05847a3fUL;
   tf->codes[17219] = 0x00002fb6f469ef20UL;
   tf->codes[17220] = 0x00002fd38c3fc051UL;
   tf->codes[17221] = 0x00002fd81f6c33b5UL;
   tf->codes[17222] = 0x00002fe479976b43UL;
   tf->codes[17223] = 0x00002fefaef785f8UL;
   tf->codes[17224] = 0x00002ff68bba330eUL;
   tf->codes[17225] = 0x00003018666988f2UL;
   tf->codes[17226] = 0x0000302e5c0bb2d2UL;
   tf->codes[17227] = 0x0000305f8a298b45UL;
   tf->codes[17228] = 0x000030615ea1b96dUL;
   tf->codes[17229] = 0x0000306492740a33UL;
   tf->codes[17230] = 0x00003065b73f270cUL;
   tf->codes[17231] = 0x0000307ea6249bedUL;
   tf->codes[17232] = 0x000030933c6ca32fUL;
   tf->codes[17233] = 0x000030971fec0544UL;
   tf->codes[17234] = 0x0000309b036b6759UL;
   tf->codes[17235] = 0x0000309c28368432UL;
   tf->codes[17236] = 0x000030a16b1008e5UL;
   tf->codes[17237] = 0x000030a75d969ee7UL;
   tf->codes[17238] = 0x000030b3f250dc3aUL;
   tf->codes[17239] = 0x000030bca38bb778UL;
   tf->codes[17240] = 0x000030ca97a01769UL;
   tf->codes[17241] = 0x000030eb88135639UL;
   tf->codes[17242] = 0x000030f5d33759daUL;
   tf->codes[17243] = 0x0000311faf7479adUL;
   tf->codes[17244] = 0x000031270155324dUL;
   tf->codes[17245] = 0x0000313e56517ecbUL;
   tf->codes[17246] = 0x00003177fb1b2cb7UL;
   tf->codes[17247] = 0x000031a71a31d13dUL;
   tf->codes[17248] = 0x00003204a8b208faUL;
   tf->codes[17249] = 0x00003232dd8c966cUL;
   tf->codes[17250] = 0x00003248d32ec04cUL;
   tf->codes[17251] = 0x00003261fca33af2UL;
   tf->codes[17252] = 0x0000326de1b066f6UL;
   tf->codes[17253] = 0x0000327d6fadef4aUL;
   tf->codes[17254] = 0x0000328fbc5fbcdaUL;
   tf->codes[17255] = 0x000032aa7fbd5fe3UL;
   tf->codes[17256] = 0x000032b3a61646abUL;
   tf->codes[17257] = 0x000032bc575121e9UL;
   tf->codes[17258] = 0x000032c28466bdb0UL;
   tf->codes[17259] = 0x000032c62d571a00UL;
   tf->codes[17260] = 0x000032f6abc7e124UL;
   tf->codes[17261] = 0x000032fb04654ec3UL;
   tf->codes[17262] = 0x0000330f9aad5605UL;
   tf->codes[17263] = 0x000033288992cae6UL;
   tf->codes[17264] = 0x000033522b40e4f4UL;
   tf->codes[17265] = 0x00003371473bf59cUL;
   tf->codes[17266] = 0x00003383ce7cc8f1UL;
   tf->codes[17267] = 0x000033c6999f5da5UL;
   tf->codes[17268] = 0x000033c91dc49d1cUL;
   tf->codes[17269] = 0x0000343340ff122cUL;
   tf->codes[17270] = 0x00003443098ba045UL;
   tf->codes[17271] = 0x0000344b803775beUL;
   tf->codes[17272] = 0x000034734d6d61a4UL;
   tf->codes[17273] = 0x00003482664cde6eUL;
   tf->codes[17274] = 0x000034838b17fb47UL;
   tf->codes[17275] = 0x0000348b8ca5c536UL;
   tf->codes[17276] = 0x000034ab1dbee168UL;
   tf->codes[17277] = 0x000034e955b502b8UL;
   tf->codes[17278] = 0x000034fd76defe70UL;
   tf->codes[17279] = 0x000034ff85e6325dUL;
   tf->codes[17280] = 0x000035141c2e399fUL;
   tf->codes[17281] = 0x00003564db652e44UL;
   tf->codes[17282] = 0x0000356515f43409UL;
   tf->codes[17283] = 0x00003569a920a76dUL;
   tf->codes[17284] = 0x000035893a39c39fUL;
   tf->codes[17285] = 0x000035b31676e372UL;
   tf->codes[17286] = 0x000035c269e56601UL;
   tf->codes[17287] = 0x000035e5de7de448UL;
   tf->codes[17288] = 0x000035ea71aa57acUL;
   tf->codes[17289] = 0x000035fecd635929UL;
   tf->codes[17290] = 0x00003613291c5aa6UL;
   tf->codes[17291] = 0x000036274a46565eUL;
   tf->codes[17292] = 0x0000365d461fa7faUL;
   tf->codes[17293] = 0x00003663733543c1UL;
   tf->codes[17294] = 0x00003695c61e390dUL;
   tf->codes[17295] = 0x00003698f9f089d3UL;
   tf->codes[17296] = 0x000036b93ab6b754UL;
   tf->codes[17297] = 0x000036f26a6259b6UL;
   tf->codes[17298] = 0x0000375ed7330878UL;
   tf->codes[17299] = 0x00003762bab26a8dUL;
   tf->codes[17300] = 0x0000377e2dbd1ee5UL;
   tf->codes[17301] = 0x000037b54e618d5aUL;
   tf->codes[17302] = 0x000037f226fd8c0cUL;
   tf->codes[17303] = 0x000037fb87e57899UL;
   tf->codes[17304] = 0x0000380264a825afUL;
   tf->codes[17305] = 0x00003804ae3e5f61UL;
   tf->codes[17306] = 0x00003822305047a6UL;
   tf->codes[17307] = 0x00003858dbd6aa91UL;
   tf->codes[17308] = 0x000038623cbe971eUL;
   tf->codes[17309] = 0x00003888aa9a6066UL;
   tf->codes[17310] = 0x00003894551886a5UL;
   tf->codes[17311] = 0x0000389be188450aUL;
   tf->codes[17312] = 0x000038b19c9b6925UL;
   tf->codes[17313] = 0x000038cbb04bfadfUL;
   tf->codes[17314] = 0x000038d33cbbb944UL;
   tf->codes[17315] = 0x000038d6e5ac1594UL;
   tf->codes[17316] = 0x000039422db1a77dUL;
   tf->codes[17317] = 0x000039a0a66df64eUL;
   tf->codes[17318] = 0x000039a86d6cba78UL;
   tf->codes[17319] = 0x000039d667b84225UL;
   tf->codes[17320] = 0x00003a06e6290949UL;
   tf->codes[17321] = 0x00003a2293c2c366UL;
   tf->codes[17322] = 0x00003a45933d3623UL;
   tf->codes[17323] = 0x00003a47a2446a10UL;
   tf->codes[17324] = 0x00003a63ff8b357cUL;
   tf->codes[17325] = 0x00003a8c41df2cecUL;
   tf->codes[17326] = 0x00003a9da454e368UL;
   tf->codes[17327] = 0x00003aabd2f8491eUL;
   tf->codes[17328] = 0x00003abaebd7c5e8UL;
   tf->codes[17329] = 0x00003acb64116550UL;
   tf->codes[17330] = 0x00003ad70e8f8b8fUL;
   tf->codes[17331] = 0x00003ae502a3eb80UL;
   tf->codes[17332] = 0x00003b1fcc38b645UL;
   tf->codes[17333] = 0x00003b21a0b0e46dUL;
   tf->codes[17334] = 0x00003b2375291295UL;
   tf->codes[17335] = 0x00003b49a875d618UL;
   tf->codes[17336] = 0x00003b5886c64d1dUL;
   tf->codes[17337] = 0x00003b7ef4a21665UL;
   tf->codes[17338] = 0x00003b893fc61a06UL;
   tf->codes[17339] = 0x00003bd3223a6195UL;
   tf->codes[17340] = 0x00003bd7eff5dabeUL;
   tf->codes[17341] = 0x00003bea0218a289UL;
   tf->codes[17342] = 0x00003c174cb718e7UL;
   tf->codes[17343] = 0x00003c37185f3adeUL;
   tf->codes[17344] = 0x00003c4ac46b2b0cUL;
   tf->codes[17345] = 0x00003c571e96629aUL;
   tf->codes[17346] = 0x00003c5bec51dbc3UL;
   tf->codes[17347] = 0x00003c5d111cf89cUL;
   tf->codes[17348] = 0x00003c6169ba663bUL;
   tf->codes[17349] = 0x00003c6c648b7b2bUL;
   tf->codes[17350] = 0x00003ca434dcfaefUL;
   tf->codes[17351] = 0x00003cac366ac4deUL;
   tf->codes[17352] = 0x00003cb2638060a5UL;
   tf->codes[17353] = 0x00003cba2a7f24cfUL;
   tf->codes[17354] = 0x00003cc5d4fd4b0eUL;
   tf->codes[17355] = 0x00003ce2e1f127c9UL;
   tf->codes[17356] = 0x00003d17f38e6251UL;
   tf->codes[17357] = 0x00003d3b6826e098UL;
   tf->codes[17358] = 0x00003d3ffb5353fcUL;
   tf->codes[17359] = 0x00003d5a8421f140UL;
   tf->codes[17360] = 0x00003d5fc6fb75f3UL;
   tf->codes[17361] = 0x00003d6076a88742UL;
   tf->codes[17362] = 0x00003d854a9b2827UL;
   tf->codes[17363] = 0x00003da21cffff1dUL;
   tf->codes[17364] = 0x00003daa1e8dc90cUL;
   tf->codes[17365] = 0x00003db58e7ce986UL;
   tf->codes[17366] = 0x00003df97e6a9b13UL;
   tf->codes[17367] = 0x00003e1b93a8f6bcUL;
   tf->codes[17368] = 0x00003e54c354991eUL;
   tf->codes[17369] = 0x00003e78e79a28b4UL;
   tf->codes[17370] = 0x00003e86dbae88a5UL;
   tf->codes[17371] = 0x00003e9126d28c46UL;
   tf->codes[17372] = 0x00003e945aa4dd0cUL;
   tf->codes[17373] = 0x00003e9719592248UL;
   tf->codes[17374] = 0x00003e9d80fdc3d4UL;
   tf->codes[17375] = 0x00003ebc27dac8f2UL;
   tf->codes[17376] = 0x00003ec0f596421bUL;
   tf->codes[17377] = 0x00003ec5fde0c109UL;
   tf->codes[17378] = 0x00003ed3b7661b35UL;
   tf->codes[17379] = 0x00003ef7dbabaacbUL;
   tf->codes[17380] = 0x00003f1d99da62c4UL;
   tf->codes[17381] = 0x00003f1f33c38b27UL;
   tf->codes[17382] = 0x00003f22dcb3e777UL;
   tf->codes[17383] = 0x00003f27aa6f60a0UL;
   tf->codes[17384] = 0x00003f46514c65beUL;
   tf->codes[17385] = 0x00003f67f16cb5ddUL;
   tf->codes[17386] = 0x00003f7e96bbf10cUL;
   tf->codes[17387] = 0x00003f891c6efa72UL;
   tf->codes[17388] = 0x00003f8b66053424UL;
   tf->codes[17389] = 0x00003f8c15b24573UL;
   tf->codes[17390] = 0x00003fd632b592c7UL;
   tf->codes[17391] = 0x00003fd6e262a416UL;
   tf->codes[17392] = 0x00004023838b30e1UL;
   tf->codes[17393] = 0x00004080d77c62d9UL;
   tf->codes[17394] = 0x000040c3a29ef78dUL;
   tf->codes[17395] = 0x000040d0375934e0UL;
   tf->codes[17396] = 0x00004104242b528fUL;
   tf->codes[17397] = 0x0000410807aab4a4UL;
   tf->codes[17398] = 0x0000410fcea978ceUL;
   tf->codes[17399] = 0x0000416ebc83d329UL;
   tf->codes[17400] = 0x000041717b381865UL;
   tf->codes[17401] = 0x00004172a003353eUL;
   tf->codes[17402] = 0x000041810935a0b9UL;
   tf->codes[17403] = 0x000041822e00bd92UL;
   tf->codes[17404] = 0x000041c951c0bfe5UL;
   tf->codes[17405] = 0x000041d7baf32b60UL;
   tf->codes[17406] = 0x000041de97b5d876UL;
   tf->codes[17407] = 0x000042041b558aaaUL;
   tf->codes[17408] = 0x00004220b32b5bdbUL;
   tf->codes[17409] = 0x00004226e040f7a2UL;
   tf->codes[17410] = 0x0000427fdb94bbfbUL;
   tf->codes[17411] = 0x000042c26c284aeaUL;
   tf->codes[17412] = 0x000042e61b4fcef6UL;
   tf->codes[17413] = 0x000043044d0ec88aUL;
   tf->codes[17414] = 0x0000432ba526a8e6UL;
   tf->codes[17415] = 0x0000434d4546f905UL;
   tf->codes[17416] = 0x00004352fd3e8942UL;
   tf->codes[17417] = 0x0000437ee882dd02UL;
   tf->codes[17418] = 0x0000438291733952UL;
   tf->codes[17419] = 0x00004393443bde7fUL;
   tf->codes[17420] = 0x0000439602f023bbUL;
   tf->codes[17421] = 0x000043a9aefc13e9UL;
   tf->codes[17422] = 0x000043d97dbfc9beUL;
   tf->codes[17423] = 0x000043da67fbe0d2UL;
   tf->codes[17424] = 0x00004457879534c1UL;
   tf->codes[17425] = 0x0000446b33a124efUL;
   tf->codes[17426] = 0x0000446edc91813fUL;
   tf->codes[17427] = 0x00004482889d716dUL;
   tf->codes[17428] = 0x0000449460313373UL;
   tf->codes[17429] = 0x000044a428bdc18cUL;
   tf->codes[17430] = 0x000044a9e0b551c9UL;
   tf->codes[17431] = 0x000044d5916a9fc4UL;
   tf->codes[17432] = 0x000044fe48dca2beUL;
   tf->codes[17433] = 0x00004504b081444aUL;
   tf->codes[17434] = 0x0000453235aec06dUL;
   tf->codes[17435] = 0x0000454064522623UL;
   tf->codes[17436] = 0x00004546cbf6c7afUL;
   tf->codes[17437] = 0x000045e84a64b0f9UL;
   tf->codes[17438] = 0x000045eeec98584aUL;
   tf->codes[17439] = 0x0000462f6e24b34cUL;
   tf->codes[17440] = 0x0000463560ab494eUL;
   tf->codes[17441] = 0x000046509926f7e1UL;
   tf->codes[17442] = 0x0000465148d40930UL;
   tf->codes[17443] = 0x000046865a7143b8UL;
   tf->codes[17444] = 0x00004687b9cb6656UL;
   tf->codes[17445] = 0x0000469030773bcfUL;
   tf->codes[17446] = 0x00004698320505beUL;
   tf->codes[17447] = 0x000046a7c0028e12UL;
   tf->codes[17448] = 0x000046aded1829d9UL;
   tf->codes[17449] = 0x000046ae27a72f9eUL;
   tf->codes[17450] = 0x000046e2c4265e9cUL;
   tf->codes[17451] = 0x000047238041bf63UL;
   tf->codes[17452] = 0x0000475bc5b14ab1UL;
   tf->codes[17453] = 0x000047a82c4ad1b7UL;
   tf->codes[17454] = 0x000047c69898d110UL;
   tf->codes[17455] = 0x00004827d009651dUL;
   tf->codes[17456] = 0x0000484343141975UL;
   tf->codes[17457] = 0x0000484726937b8aUL;
   tf->codes[17458] = 0x00004879b40b769bUL;
   tf->codes[17459] = 0x00004881407b3500UL;
   tf->codes[17460] = 0x000048990a958d08UL;
   tf->codes[17461] = 0x000048aae2294f0eUL;
   tf->codes[17462] = 0x000048e82fe3594aUL;
   tf->codes[17463] = 0x000048f539bba227UL;
   tf->codes[17464] = 0x000048f832feed28UL;
   tf->codes[17465] = 0x0000491ba7976b6fUL;
   tf->codes[17466] = 0x0000493ac3927c17UL;
   tf->codes[17467] = 0x00004948b7a6dc08UL;
   tf->codes[17468] = 0x000049716f18df02UL;
   tf->codes[17469] = 0x000049a730632ad9UL;
   tf->codes[17470] = 0x000049c3c838fc0aUL;
   tf->codes[17471] = 0x000049d31ba77e99UL;
   tf->codes[17472] = 0x000049d405e395adUL;
   tf->codes[17473] = 0x000049ffb698e3a8UL;
   tf->codes[17474] = 0x00004a6a14625e7dUL;
   tf->codes[17475] = 0x00004a89305d6f25UL;
   tf->codes[17476] = 0x00004a9e3bc381f1UL;
   tf->codes[17477] = 0x00004ac72dc48ab0UL;
   tf->codes[17478] = 0x00004ae091c80b1bUL;
   tf->codes[17479] = 0x00004ae38b0b561cUL;
   tf->codes[17480] = 0x00004b6ba575befbUL;
   tf->codes[17481] = 0x00004b74cbcea5c3UL;
   tf->codes[17482] = 0x00004b7d427a7b3cUL;
   tf->codes[17483] = 0x00004b828553ffefUL;
   tf->codes[17484] = 0x00004bc42bab77caUL;
   tf->codes[17485] = 0x00004beb83c35826UL;
   tf->codes[17486] = 0x00004c6e5b543c52UL;
   tf->codes[17487] = 0x00004cab6e7f40c9UL;
   tf->codes[17488] = 0x00004cc03f564dd0UL;
   tf->codes[17489] = 0x00004ccbe9d4740fUL;
   tf->codes[17490] = 0x00004d1c6e7c62efUL;
   tf->codes[17491] = 0x00004d22d621047bUL;
   tf->codes[17492] = 0x00004d24aa9932a3UL;
   tf->codes[17493] = 0x00004d34e843cc46UL;
   tf->codes[17494] = 0x00004d5e14d3dacaUL;
   tf->codes[17495] = 0x00004d80d9bf47c2UL;
   tf->codes[17496] = 0x00004da11a857543UL;
   tf->codes[17497] = 0x00004da18fa380cdUL;
   tf->codes[17498] = 0x00004db9944cde9aUL;
   tf->codes[17499] = 0x00004dbfc1627a61UL;
   tf->codes[17500] = 0x00004dcba66fa665UL;
   tf->codes[17501] = 0x00004dcdb576da52UL;
   tf->codes[17502] = 0x00004dde683f7f7fUL;
   tf->codes[17503] = 0x00004de6a45c4f33UL;
   tf->codes[17504] = 0x00004de83e457796UL;
   tf->codes[17505] = 0x00004dfb3aa45675UL;
   tf->codes[17506] = 0x00004e1ee9cbda81UL;
   tf->codes[17507] = 0x00004e281024c149UL;
   tf->codes[17508] = 0x00004e342fc0f312UL;
   tf->codes[17509] = 0x00004e43bdbe7b66UL;
   tf->codes[17510] = 0x00004e73176425b1UL;
   tf->codes[17511] = 0x00004ea68f1837d6UL;
   tf->codes[17512] = 0x00004ea89e1f6bc3UL;
   tf->codes[17513] = 0x00004ec15275dadfUL;
   tf->codes[17514] = 0x00004ec7f4a98230UL;
   tf->codes[17515] = 0x00004ed48963bf83UL;
   tf->codes[17516] = 0x00004eda06cc49fbUL;
   tf->codes[17517] = 0x00004f10b252ace6UL;
   tf->codes[17518] = 0x00004f2c9a7b6cc8UL;
   tf->codes[17519] = 0x00004f676410378dUL;
   tf->codes[17520] = 0x00004f764260ae92UL;
   tf->codes[17521] = 0x00004fac78c905f3UL;
   tf->codes[17522] = 0x00004fbddb3ebc6fUL;
   tf->codes[17523] = 0x00004fcd2ead3efeUL;
   tf->codes[17524] = 0x00004fe18a66407bUL;
   tf->codes[17525] = 0x000050169c037b03UL;
   tf->codes[17526] = 0x000050215c458a2eUL;
   tf->codes[17527] = 0x00005065c1514745UL;
   tf->codes[17528] = 0x0000507e75a7b661UL;
   tf->codes[17529] = 0x000050984ec94256UL;
   tf->codes[17530] = 0x000050a2d47c4bbcUL;
   tf->codes[17531] = 0x000050bd97d9eec5UL;
   tf->codes[17532] = 0x000050cdd5848868UL;
   tf->codes[17533] = 0x000050d64c305de1UL;
   tf->codes[17534] = 0x000050d9ba91b46cUL;
   tf->codes[17535] = 0x000050f5dd497a13UL;
   tf->codes[17536] = 0x000050f9fb57e1edUL;
   tf->codes[17537] = 0x0000512830326f5fUL;
   tf->codes[17538] = 0x0000515839852af9UL;
   tf->codes[17539] = 0x000051636ee545aeUL;
   tf->codes[17540] = 0x000051703e2e88c6UL;
   tf->codes[17541] = 0x0000517162f9a59fUL;
   tf->codes[17542] = 0x000051abf1ff6a9fUL;
   tf->codes[17543] = 0x000051c1728388f5UL;
   tf->codes[17544] = 0x000051cc32c59820UL;
   tf->codes[17545] = 0x000051cd5790b4f9UL;
   tf->codes[17546] = 0x000051dd5aac48d7UL;
   tf->codes[17547] = 0x000051e4376ef5edUL;
   tf->codes[17548] = 0x00005204ed532ef8UL;
   tf->codes[17549] = 0x00005207e69679f9UL;
   tf->codes[17550] = 0x00005280ad926049UL;
   tf->codes[17551] = 0x0000528a83985860UL;
   tf->codes[17552] = 0x0000528b334569afUL;
   tf->codes[17553] = 0x000052b584a0950cUL;
   tf->codes[17554] = 0x000052c80be16861UL;
   tf->codes[17555] = 0x000052d37bd088dbUL;
   tf->codes[17556] = 0x000052d515b9b13eUL;
   tf->codes[17557] = 0x000052e25a20ffe0UL;
   tf->codes[17558] = 0x000052e84ca795e2UL;
   tf->codes[17559] = 0x000052eb8079e6a8UL;
   tf->codes[17560] = 0x0000531a2a727fa4UL;
   tf->codes[17561] = 0x00005335d80c39c1UL;
   tf->codes[17562] = 0x00005342a7557cd9UL;
   tf->codes[17563] = 0x000053602967651eUL;
   tf->codes[17564] = 0x00005368a0133a97UL;
   tf->codes[17565] = 0x0000537a77a6fc9dUL;
   tf->codes[17566] = 0x00005380df4b9e29UL;
   tf->codes[17567] = 0x0000538a7ac2907bUL;
   tf->codes[17568] = 0x000053a0aaf3c020UL;
   tf->codes[17569] = 0x000053b7fff00c9eUL;
   tf->codes[17570] = 0x000053eb02861339UL;
   tf->codes[17571] = 0x000053eb3d1518feUL;
   tf->codes[17572] = 0x000053eee605754eUL;
   tf->codes[17573] = 0x000053f9a6478479UL;
   tf->codes[17574] = 0x0000540e3c8f8bbbUL;
   tf->codes[17575] = 0x000054455d33fa30UL;
   tf->codes[17576] = 0x00005454761376faUL;
   tf->codes[17577] = 0x000054560ffc9f5dUL;
   tf->codes[17578] = 0x00005482705efea7UL;
   tf->codes[17579] = 0x000054969188fa5fUL;
   tf->codes[17580] = 0x000054d2ba77e7c2UL;
   tf->codes[17581] = 0x00005586c026a461UL;
   tf->codes[17582] = 0x00005586fab5aa26UL;
   tf->codes[17583] = 0x000055af027a9bd1UL;
   tf->codes[17584] = 0x000055c1c44a74ebUL;
   tf->codes[17585] = 0x0000560245d6cfedUL;
   tf->codes[17586] = 0x0000563582fbdc4dUL;
   tf->codes[17587] = 0x000056808a3b40b5UL;
   tf->codes[17588] = 0x0000568b0fee4a1bUL;
   tf->codes[17589] = 0x00005698c973a447UL;
   tf->codes[17590] = 0x000056a2da08a223UL;
   tf->codes[17591] = 0x000056b90a39d1c8UL;
   tf->codes[17592] = 0x000056e68f674debUL;
   tf->codes[17593] = 0x000056ed6c29fb01UL;
   tf->codes[17594] = 0x000056f53328bf2bUL;
   tf->codes[17595] = 0x000056fd34b6891aUL;
   tf->codes[17596] = 0x00005701c7e2fc7eUL;
   tf->codes[17597] = 0x0000572ba4201c51UL;
   tf->codes[17598] = 0x00005772c7e01ea4UL;
   tf->codes[17599] = 0x00005777207d8c43UL;
   tf->codes[17600] = 0x0000577bee39056cUL;
   tf->codes[17601] = 0x000057a0127e9502UL;
   tf->codes[17602] = 0x000057a380dfeb8dUL;
   tf->codes[17603] = 0x000057ab0d4fa9f2UL;
   tf->codes[17604] = 0x000057cce7feffd6UL;
   tf->codes[17605] = 0x000057ce0cca1cafUL;
   tf->codes[17606] = 0x000057e8207aae69UL;
   tf->codes[17607] = 0x000057efe7797293UL;
   tf->codes[17608] = 0x0000581b982ec08eUL;
   tf->codes[17609] = 0x0000582483f8a191UL;
   tf->codes[17610] = 0x00005858ab59c505UL;
   tf->codes[17611] = 0x000058ab7997ed97UL;
   tf->codes[17612] = 0x000058bf9ac1e94fUL;
   tf->codes[17613] = 0x000058d64011247eUL;
   tf->codes[17614] = 0x000058e93c70035dUL;
   tf->codes[17615] = 0x00005905d445d48eUL;
   tf->codes[17616] = 0x00005939fba6f802UL;
   tf->codes[17617] = 0x00005946caf03b1aUL;
   tf->codes[17618] = 0x000059502bd827a7UL;
   tf->codes[17619] = 0x000059a9d6d8fd4fUL;
   tf->codes[17620] = 0x000059ba148396f2UL;
   tf->codes[17621] = 0x000059bdbd73f342UL;
   tf->codes[17622] = 0x000059d5fcac56d4UL;
   tf->codes[17623] = 0x000059fd8f533cf5UL;
   tf->codes[17624] = 0x00005a188d3fe5c3UL;
   tf->codes[17625] = 0x00005a531c45aac3UL;
   tf->codes[17626] = 0x00005a74f6f500a7UL;
   tf->codes[17627] = 0x00005a856f2ea00fUL;
   tf->codes[17628] = 0x00005ab787888f96UL;
   tf->codes[17629] = 0x00005ad6de12a603UL;
   tf->codes[17630] = 0x00005adea5116a2dUL;
   tf->codes[17631] = 0x00005b34e1b0e94aUL;
   tf->codes[17632] = 0x00005b3fdc81fe3aUL;
   tf->codes[17633] = 0x00005b5ebdee091dUL;
   tf->codes[17634] = 0x00005b7b9052e013UL;
   tf->codes[17635] = 0x00005b847c1cc116UL;
   tf->codes[17636] = 0x00005baf4295f7fdUL;
   tf->codes[17637] = 0x00005bb39b33659cUL;
   tf->codes[17638] = 0x00005bc2eea1e82bUL;
   tf->codes[17639] = 0x00005bc44dfc0ac9UL;
   tf->codes[17640] = 0x00005bf506fbd7b2UL;
   tf->codes[17641] = 0x00005c03359f3d68UL;
   tf->codes[17642] = 0x00005c166c8d220cUL;
   tf->codes[17643] = 0x00005c1c5f13b80eUL;
   tf->codes[17644] = 0x00005c5a5c7ad399UL;
   tf->codes[17645] = 0x00005c75cf8587f1UL;
   tf->codes[17646] = 0x00005c97e4c3e39aUL;
   tf->codes[17647] = 0x00005cc6c94b825bUL;
   tf->codes[17648] = 0x00005cf3643ce76aUL;
   tf->codes[17649] = 0x00005d1abc54c7c6UL;
   tf->codes[17650] = 0x00005d37199b9332UL;
   tf->codes[17651] = 0x00005d3c5c7517e5UL;
   tf->codes[17652] = 0x00005d3e30ed460dUL;
   tf->codes[17653] = 0x00005d61a585c454UL;
   tf->codes[17654] = 0x00005d6638b237b8UL;
   tf->codes[17655] = 0x00005d6fd4292a0aUL;
   tf->codes[17656] = 0x00005d8729257688UL;
   tf->codes[17657] = 0x00005d88887f9926UL;
   tf->codes[17658] = 0x00005d8bbc51e9ecUL;
   tf->codes[17659] = 0x00005d9174497a29UL;
   tf->codes[17660] = 0x00005da88eb6c0e2UL;
   tf->codes[17661] = 0x00005db264bcb8f9UL;
   tf->codes[17662] = 0x00005db9b69d7199UL;
   tf->codes[17663] = 0x00005dbc0033ab4bUL;
   tf->codes[17664] = 0x00005de6c6ace232UL;
   tf->codes[17665] = 0x00005deb59d95596UL;
   tf->codes[17666] = 0x00005debcef76120UL;
   tf->codes[17667] = 0x00005e44552d19efUL;
   tf->codes[17668] = 0x00005e70b58f7939UL;
   tf->codes[17669] = 0x00005e87956dba2dUL;
   tf->codes[17670] = 0x00005e9a573d9347UL;
   tf->codes[17671] = 0x00005edad8c9ee49UL;
   tf->codes[17672] = 0x00005f047a780857UL;
   tf->codes[17673] = 0x00005f0948338180UL;
   tf->codes[17674] = 0x00005f3a3bc2542eUL;
   tf->codes[17675] = 0x00005f4b2919ff20UL;
   tf->codes[17676] = 0x00005f8333fa84a9UL;
   tf->codes[17677] = 0x00005f8961102070UL;
   tf->codes[17678] = 0x00005fa2ffa2a6a0UL;
   tf->codes[17679] = 0x00005faa8c126505UL;
   tf->codes[17680] = 0x00005fea9880b47dUL;
   tf->codes[17681] = 0x00005ff1afd26758UL;
   tf->codes[17682] = 0x00005ffce532820dUL;
   tf->codes[17683] = 0x00006003c1f52f23UL;
   tf->codes[17684] = 0x00006027711cb32fUL;
   tf->codes[17685] = 0x0000602f72aa7d1eUL;
   tf->codes[17686] = 0x000060377438470dUL;
   tf->codes[17687] = 0x0000604443818a25UL;
   tf->codes[17688] = 0x0000604fb370aa9fUL;
   tf->codes[17689] = 0x0000607e22da3dd6UL;
   tf->codes[17690] = 0x00006088336f3bb2UL;
   tf->codes[17691] = 0x00006092f3b14addUL;
   tf->codes[17692] = 0x000060966212a168UL;
   tf->codes[17693] = 0x000060ae2c2cf970UL;
   tf->codes[17694] = 0x000060b5f32bbd9aUL;
   tf->codes[17695] = 0x000060da8c8f58baUL;
   tf->codes[17696] = 0x0000613e48252c3eUL;
   tf->codes[17697] = 0x0000616565ae06d5UL;
   tf->codes[17698] = 0x00006178620ce5b4UL;
   tf->codes[17699] = 0x0000617fee7ca419UL;
   tf->codes[17700] = 0x0000619275bd776eUL;
   tf->codes[17701] = 0x000061a3d8332deaUL;
   tf->codes[17702] = 0x000061c99661e5e3UL;
   tf->codes[17703] = 0x000061fd48a4fdcdUL;
   tf->codes[17704] = 0x000062184691a69bUL;
   tf->codes[17705] = 0x0000623727fdb17eUL;
   tf->codes[17706] = 0x0000623c3048306cUL;
   tf->codes[17707] = 0x0000624bbe45b8c0UL;
   tf->codes[17708] = 0x00006271f1927c43UL;
   tf->codes[17709] = 0x000062755ff3d2ceUL;
   tf->codes[17710] = 0x0000628e89684d74UL;
   tf->codes[17711] = 0x000062a86289d969UL;
   tf->codes[17712] = 0x000062c360768237UL;
   tf->codes[17713] = 0x000062db2a90da3fUL;
   tf->codes[17714] = 0x000062f5b35f7783UL;
   tf->codes[17715] = 0x000063196286fb8fUL;
   tf->codes[17716] = 0x00006362cfdd3794UL;
   tf->codes[17717] = 0x00006374a770f99aUL;
   tf->codes[17718] = 0x0000639388dd047dUL;
   tf->codes[17719] = 0x000063a9096122d3UL;
   tf->codes[17720] = 0x000063b90c7cb6b1UL;
   tf->codes[17721] = 0x000063e39866e7d3UL;
   tf->codes[17722] = 0x0000640de9c21330UL;
   tf->codes[17723] = 0x000064106de752a7UL;
   tf->codes[17724] = 0x000064236a463186UL;
   tf->codes[17725] = 0x0000642af6b5efebUL;
   tf->codes[17726] = 0x00006449d821faceUL;
   tf->codes[17727] = 0x0000644b377c1d6cUL;
   tf->codes[17728] = 0x0000645bea44c299UL;
   tf->codes[17729] = 0x00006475fdf55453UL;
   tf->codes[17730] = 0x0000647f244e3b1bUL;
   tf->codes[17731] = 0x00006499e7abde24UL;
   tf->codes[17732] = 0x000064a1aeaaa24eUL;
   tf->codes[17733] = 0x000064c3fe7803bcUL;
   tf->codes[17734] = 0x000064f23352912eUL;
   tf->codes[17735] = 0x0000650320aa3c20UL;
   tf->codes[17736] = 0x000065040ae65334UL;
   tf->codes[17737] = 0x00006507ee65b549UL;
   tf->codes[17738] = 0x00006523617069a1UL;
   tf->codes[17739] = 0x0000652b9d8d3955UL;
   tf->codes[17740] = 0x0000656199668af1UL;
   tf->codes[17741] = 0x00006589a12b7c9cUL;
   tf->codes[17742] = 0x000065c7d9219decUL;
   tf->codes[17743] = 0x000065d46ddbdb3fUL;
   tf->codes[17744] = 0x000065d607c503a2UL;
   tf->codes[17745] = 0x0000662b94b77170UL;
   tf->codes[17746] = 0x0000664742512b8dUL;
   tf->codes[17747] = 0x0000667c8e7d6bdaUL;
   tf->codes[17748] = 0x00006684900b35c9UL;
   tf->codes[17749] = 0x00006687c3dd868fUL;
   tf->codes[17750] = 0x00006688ae199da3UL;
   tf->codes[17751] = 0x000066b792a13c64UL;
   tf->codes[17752] = 0x000066d46506135aUL;
   tf->codes[17753] = 0x000066e1e3fc67c1UL;
   tf->codes[17754] = 0x0000670817492b44UL;
   tf->codes[17755] = 0x00006713fc565748UL;
   tf->codes[17756] = 0x000067238a53df9cUL;
   tf->codes[17757] = 0x0000673f37ed99b9UL;
   tf->codes[17758] = 0x000067602860d889UL;
   tf->codes[17759] = 0x0000677a3c116a43UL;
   tf->codes[17760] = 0x00006795748d18d6UL;
   tf->codes[17761] = 0x000067b6650057a6UL;
   tf->codes[17762] = 0x000067db38f2f88bUL;
   tf->codes[17763] = 0x000067e33a80c27aUL;
   tf->codes[17764] = 0x000067e54987f667UL;
   tf->codes[17765] = 0x000067f2c87e4aceUL;
   tf->codes[17766] = 0x000067f5c1c195cfUL;
   tf->codes[17767] = 0x00006822974200a3UL;
   tf->codes[17768] = 0x0000689ff16a5a57UL;
   tf->codes[17769] = 0x000068a0668865e1UL;
   tf->codes[17770] = 0x000068d7c1bbda1bUL;
   tf->codes[17771] = 0x000068e78a486834UL;
   tf->codes[17772] = 0x00006919681351f6UL;
   tf->codes[17773] = 0x0000693a588690c6UL;
   tf->codes[17774] = 0x0000695815277ed0UL;
   tf->codes[17775] = 0x0000696a274a469bUL;
   tf->codes[17776] = 0x0000696fa4b2d113UL;
   tf->codes[17777] = 0x0000697bc44f02dcUL;
   tf->codes[17778] = 0x000069a85f4067ebUL;
   tf->codes[17779] = 0x000069bf3f1ea8dfUL;
   tf->codes[17780] = 0x000069c8da959b31UL;
   tf->codes[17781] = 0x000069df7fe4d660UL;
   tf->codes[17782] = 0x00006a0b309a245bUL;
   tf->codes[17783] = 0x00006a1c5880d512UL;
   tf->codes[17784] = 0x00006a1d42bcec26UL;
   tf->codes[17785] = 0x00006a1f51c42013UL;
   tf->codes[17786] = 0x00006a26a3a4d8b3UL;
   tf->codes[17787] = 0x00006a2a12062f3eUL;
   tf->codes[17788] = 0x00006a3631a26107UL;
   tf->codes[17789] = 0x00006a49ddae5135UL;
   tf->codes[17790] = 0x00006a54d87f6625UL;
   tf->codes[17791] = 0x00006a68f9a961ddUL;
   tf->codes[17792] = 0x00006a8b4976c34bUL;
   tf->codes[17793] = 0x00006a9e0b469c65UL;
   tf->codes[17794] = 0x00006ab107a57b44UL;
   tf->codes[17795] = 0x00006af61c5e49aaUL;
   tf->codes[17796] = 0x00006b023bfa7b73UL;
   tf->codes[17797] = 0x00006b395c9ee9e8UL;
   tf->codes[17798] = 0x00006b66e1cc660bUL;
   tf->codes[17799] = 0x00006b707d43585dUL;
   tf->codes[17800] = 0x00006b9f61caf71eUL;
   tf->codes[17801] = 0x00006ba25b0e421fUL;
   tf->codes[17802] = 0x00006bbce3dcdf63UL;
   tf->codes[17803] = 0x00006bd17a24e6a5UL;
   tf->codes[17804] = 0x00006bdc74f5fb95UL;
   tf->codes[17805] = 0x00006c75079a03dcUL;
   tf->codes[17806] = 0x00006c95f80d42acUL;
   tf->codes[17807] = 0x00006c96a7ba53fbUL;
   tf->codes[17808] = 0x00006cb4d9794d8fUL;
   tf->codes[17809] = 0x00006cd46a9269c1UL;
   tf->codes[17810] = 0x00006cfb4d8c3e93UL;
   tf->codes[17811] = 0x00006cfdd1b17e0aUL;
   tf->codes[17812] = 0x00006d55331c1a00UL;
   tf->codes[17813] = 0x00006d6152b84bc9UL;
   tf->codes[17814] = 0x00006d6361bf7fb6UL;
   tf->codes[17815] = 0x00006d719062e56cUL;
   tf->codes[17816] = 0x00006d786d259282UL;
   tf->codes[17817] = 0x00006d7b6668dd83UL;
   tf->codes[17818] = 0x00006d80e3d167fbUL;
   tf->codes[17819] = 0x00006d82b8499623UL;
   tf->codes[17820] = 0x00006da6a2001ff4UL;
   tf->codes[17821] = 0x00006dc6a83747b0UL;
   tf->codes[17822] = 0x00006dfbf46387fdUL;
   tf->codes[17823] = 0x00006e17dc8c47dfUL;
   tf->codes[17824] = 0x00006ee8ef2ee139UL;
   tf->codes[17825] = 0x00006f012e6744cbUL;
   tf->codes[17826] = 0x00006f281161199dUL;
   tf->codes[17827] = 0x00006f425fa0b11cUL;
   tf->codes[17828] = 0x00006f508e4416d2UL;
   tf->codes[17829] = 0x00006f7d29357be1UL;
   tf->codes[17830] = 0x00006f82a69e0659UL;
   tf->codes[17831] = 0x00006f831bbc11e3UL;
   tf->codes[17832] = 0x00006fdaf244b963UL;
   tf->codes[17833] = 0x00006fe11f5a552aUL;
   tf->codes[17834] = 0x00006fe4189da02bUL;
   tf->codes[17835] = 0x00006fe8abca138fUL;
   tf->codes[17836] = 0x00006fedeea39842UL;
   tf->codes[17837] = 0x00006fff8ba85483UL;
   tf->codes[17838] = 0x000070cb5b71692aUL;
   tf->codes[17839] = 0x000070fed3257b4fUL;
   tf->codes[17840] = 0x00007131260e709bUL;
   tf->codes[17841] = 0x00007133aa33b012UL;
   tf->codes[17842] = 0x000071696b7dfbe9UL;
   tf->codes[17843] = 0x000071b60ca688b4UL;
   tf->codes[17844] = 0x000071b681c4943eUL;
   tf->codes[17845] = 0x000071d85c73ea22UL;
   tf->codes[17846] = 0x000071f56967c6ddUL;
   tf->codes[17847] = 0x0000721de64ac412UL;
   tf->codes[17848] = 0x00007232f1b0d6deUL;
   tf->codes[17849] = 0x00007266a3f3eec8UL;
   tf->codes[17850] = 0x0000727dbe613581UL;
   tf->codes[17851] = 0x000072921a1a36feUL;
   tf->codes[17852] = 0x000072abb8acbd2eUL;
   tf->codes[17853] = 0x000072c51cb03d99UL;
   tf->codes[17854] = 0x000073064de9a9eaUL;
   tf->codes[17855] = 0x0000730b1ba52313UL;
   tf->codes[17856] = 0x0000734a034855b2UL;
   tf->codes[17857] = 0x0000736b2e4a9a47UL;
   tf->codes[17858] = 0x000073b75a551b88UL;
   tf->codes[17859] = 0x0000740b87ed66b8UL;
   tf->codes[17860] = 0x000074217d8f9098UL;
   tf->codes[17861] = 0x000074281fc337e9UL;
   tf->codes[17862] = 0x00007437e84fc602UL;
   tf->codes[17863] = 0x0000746b9a92ddecUL;
   tf->codes[17864] = 0x0000748573b469e1UL;
   tf->codes[17865] = 0x00007488e215c06cUL;
   tf->codes[17866] = 0x00007495ebee0949UL;
   tf->codes[17867] = 0x000074a3a5736375UL;
   tf->codes[17868] = 0x000074b15ef8bda1UL;
   tf->codes[17869] = 0x000074ea19865479UL;
   tf->codes[17870] = 0x000074f882b8bff4UL;
   tf->codes[17871] = 0x000074feea5d6180UL;
   tf->codes[17872] = 0x0000750133f39b32UL;
   tf->codes[17873] = 0x0000751d1c1c5b14UL;
   tf->codes[17874] = 0x00007521e9d7d43dUL;
   tf->codes[17875] = 0x00007538549809a7UL;
   tf->codes[17876] = 0x0000754857b39d85UL;
   tf->codes[17877] = 0x0000755b54127c64UL;
   tf->codes[17878] = 0x0000757b1fba9e5bUL;
   tf->codes[17879] = 0x0000759de4a60b53UL;
   tf->codes[17880] = 0x000075be5ffb3e99UL;
   tf->codes[17881] = 0x000075ddb6855506UL;
   tf->codes[17882] = 0x000075f6304cbe5dUL;
   tf->codes[17883] = 0x0000760beb5fe278UL;
   tf->codes[17884] = 0x000076467a65a778UL;
   tf->codes[17885] = 0x0000765bfae9c5ceUL;
   tf->codes[17886] = 0x00007677a8837febUL;
   tf->codes[17887] = 0x00007682a35494dbUL;
   tf->codes[17888] = 0x00007692e0ff2e7eUL;
   tf->codes[17889] = 0x000076a393c7d3abUL;
   tf->codes[17890] = 0x000076a9864e69adUL;
   tf->codes[17891] = 0x000076afedf30b39UL;
   tf->codes[17892] = 0x000076d70b7be5d0UL;
   tf->codes[17893] = 0x000076dc4e556a83UL;
   tf->codes[17894] = 0x0000773006cfaa29UL;
   tf->codes[17895] = 0x00007800a45437f9UL;
   tf->codes[17896] = 0x0000782db463a892UL;
   tf->codes[17897] = 0x0000783874a5b7bdUL;
   tf->codes[17898] = 0x00007843e494d837UL;
   tf->codes[17899] = 0x0000786f954a2632UL;
   tf->codes[17900] = 0x00007888bebea0d8UL;
   tf->codes[17901] = 0x000078d4008d0b05UL;
   tf->codes[17902] = 0x000078fb1e15e59cUL;
   tf->codes[17903] = 0x00007904f41bddb3UL;
   tf->codes[17904] = 0x00007961985ffe5cUL;
   tf->codes[17905] = 0x00007962480d0fabUL;
   tf->codes[17906] = 0x00007963e1f6380eUL;
   tf->codes[17907] = 0x0000799b77b8b20dUL;
   tf->codes[17908] = 0x000079bd526807f1UL;
   tf->codes[17909] = 0x000079ca96cf5693UL;
   tf->codes[17910] = 0x00007a289a6d99daUL;
   tf->codes[17911] = 0x00007a3d30b5a11cUL;
   tf->codes[17912] = 0x00007a6c8a5b4b67UL;
   tf->codes[17913] = 0x00007a7576252c6aUL;
   tf->codes[17914] = 0x00007a7c8d76df45UL;
   tf->codes[17915] = 0x00007a85b3cfc60dUL;
   tf->codes[17916] = 0x00007a8872840b49UL;
   tf->codes[17917] = 0x00007a8922311c98UL;
   tf->codes[17918] = 0x00007a9f52624c3dUL;
   tf->codes[17919] = 0x00007a9f8cf15202UL;
   tf->codes[17920] = 0x00007aa669b3ff18UL;
   tf->codes[17921] = 0x00007ab8f0f4d26dUL;
   tf->codes[17922] = 0x00007abbafa917a9UL;
   tf->codes[17923] = 0x00007acdfc5ae539UL;
   tf->codes[17924] = 0x00007ad1dfda474eUL;
   tf->codes[17925] = 0x00007ad63877b4edUL;
   tf->codes[17926] = 0x00007ad8f72bfa29UL;
   tf->codes[17927] = 0x00007b32679dca0cUL;
   tf->codes[17928] = 0x00007b4404a2864dUL;
   tf->codes[17929] = 0x00007b51f8b6e63eUL;
   tf->codes[17930] = 0x00007b55dc364853UL;
   tf->codes[17931] = 0x00007b6b5cba66a9UL;
   tf->codes[17932] = 0x00007b95e8a497cbUL;
   tf->codes[17933] = 0x00007ba5b13125e4UL;
   tf->codes[17934] = 0x00007bc5b7684da0UL;
   tf->codes[17935] = 0x00007bca1005bb3fUL;
   tf->codes[17936] = 0x00007be04036eae4UL;
   tf->codes[17937] = 0x00007bf54b9cfdb0UL;
   tf->codes[17938] = 0x00007c1dc87ffae5UL;
   tf->codes[17939] = 0x00007c32995707ecUL;
   tf->codes[17940] = 0x00007c69f48a7c26UL;
   tf->codes[17941] = 0x00007cb1c7f78fc8UL;
   tf->codes[17942] = 0x00007cb5e605f7a2UL;
   tf->codes[17943] = 0x00007d0b38695fabUL;
   tf->codes[17944] = 0x00007d6bfabbe82eUL;
   tf->codes[17945] = 0x00007dd4497e2f16UL;
   tf->codes[17946] = 0x00007dd708327452UL;
   tf->codes[17947] = 0x00007debd9098159UL;
   tf->codes[17948] = 0x00007e0aba758c3cUL;
   tf->codes[17949] = 0x00007e48082f9678UL;
   tf->codes[17950] = 0x00007ea178a1665bUL;
   tf->codes[17951] = 0x00007ef028d12713UL;
   tf->codes[17952] = 0x00007ef74022d9eeUL;
   tf->codes[17953] = 0x00007f1bd986750eUL;
   tf->codes[17954] = 0x00007f2b6783fd62UL;
   tf->codes[17955] = 0x00007f3a45d47467UL;
   tf->codes[17956] = 0x00007f5cd030db9aUL;
   tf->codes[17957] = 0x00007f8aca7c6347UL;
   tf->codes[17958] = 0x00007fdcae7e74c5UL;
   tf->codes[17959] = 0x00007fe7a94f89b5UL;
   tf->codes[17960] = 0x00007fffadf8e782UL;
   tf->codes[17961] = 0x00008001f78f2134UL;
   tf->codes[17962] = 0x0000803f45492b70UL;
   tf->codes[17963] = 0x000080465c9ade4bUL;
   tf->codes[17964] = 0x00008070e8850f6dUL;
   tf->codes[17965] = 0x00008076a07c9faaUL;
   tf->codes[17966] = 0x00008097cb7ee43fUL;
   tf->codes[17967] = 0x000080c2cc8720ebUL;
   tf->codes[17968] = 0x000080d25a84a93fUL;
   tf->codes[17969] = 0x000081029e666a9eUL;
   tf->codes[17970] = 0x0000810e48e490ddUL;
   tf->codes[17971] = 0x00008112a181fe7cUL;
   tf->codes[17972] = 0x00008113c64d1b55UL;
   tf->codes[17973] = 0x0000811b8d4bdf7fUL;
   tf->codes[17974] = 0x00008126c2abfa34UL;
   tf->codes[17975] = 0x000081435a81cb65UL;
   tf->codes[17976] = 0x0000814b21808f8fUL;
   tf->codes[17977] = 0x0000814f7a1dfd2eUL;
   tf->codes[17978] = 0x00008153d2bb6acdUL;
   tf->codes[17979] = 0x0000815ecd8c7fbdUL;
   tf->codes[17980] = 0x0000815fb7c896d1UL;
   tf->codes[17981] = 0x0000819d4011a6d2UL;
   tf->codes[17982] = 0x000081aa49e9efafUL;
   tf->codes[17983] = 0x000081d16772ca46UL;
   tf->codes[17984] = 0x000081d66fbd4934UL;
   tf->codes[17985] = 0x000081e96c1c2813UL;
   tf->codes[17986] = 0x0000822f6b110d8dUL;
   tf->codes[17987] = 0x000082317a18417aUL;
   tf->codes[17988] = 0x000082355d97a38fUL;
   tf->codes[17989] = 0x000082359826a954UL;
   tf->codes[17990] = 0x0000823d249667b9UL;
   tf->codes[17991] = 0x0000823d5f256d7eUL;
   tf->codes[17992] = 0x00008256137bdc9aUL;
   tf->codes[17993] = 0x0000826e18253a67UL;
   tf->codes[17994] = 0x000082714bf78b2dUL;
   tf->codes[17995] = 0x000082b48c382b6bUL;
   tf->codes[17996] = 0x000082c5eeade1e7UL;
   tf->codes[17997] = 0x000082d7c641a3edUL;
   tf->codes[17998] = 0x00008305c08d2b9aUL;
   tf->codes[17999] = 0x0000833d1bc09fd4UL;
   tf->codes[18000] = 0x0000834139cf07aeUL;
   tf->codes[18001] = 0x00008344a8305e39UL;
   tf->codes[18002] = 0x00008351b208a716UL;
   tf->codes[18003] = 0x00008368cc75edcfUL;
   tf->codes[18004] = 0x00008374b18319d3UL;
   tf->codes[18005] = 0x000083785a737623UL;
   tf->codes[18006] = 0x0000837895027be8UL;
   tf->codes[18007] = 0x000083968c326fb7UL;
   tf->codes[18008] = 0x000083d9cc730ff5UL;
   tf->codes[18009] = 0x00008406a1f37ac9UL;
   tf->codes[18010] = 0x000084124c71a108UL;
   tf->codes[18011] = 0x0000843dc297e93eUL;
   tf->codes[18012] = 0x000084776761972aUL;
   tf->codes[18013] = 0x000084bd2bc776dfUL;
   tf->codes[18014] = 0x000084e9c6b8dbeeUL;
   tf->codes[18015] = 0x000084f4c189f0deUL;
   tf->codes[18016] = 0x00008500e12622a7UL;
   tf->codes[18017] = 0x000085070e3bbe6eUL;
   tf->codes[18018] = 0x0000850f0fc9885dUL;
   tf->codes[18019] = 0x0000852d7c1787b6UL;
   tf->codes[18020] = 0x00008542877d9a82UL;
   tf->codes[18021] = 0x0000855f59e27178UL;
   tf->codes[18022] = 0x00008563b27fdf17UL;
   tf->codes[18023] = 0x00008565c1871304UL;
   tf->codes[18024] = 0x00008566abc32a18UL;
   tf->codes[18025] = 0x00008580fa02c197UL;
   tf->codes[18026] = 0x000085834398fb49UL;
   tf->codes[18027] = 0x00008590fd1e5575UL;
   tf->codes[18028] = 0x000085eec62d92f7UL;
   tf->codes[18029] = 0x000085fcba41f2e8UL;
   tf->codes[18030] = 0x00008605e09ad9b0UL;
   tf->codes[18031] = 0x0000862362acc1f5UL;
   tf->codes[18032] = 0x000086453d5c17d9UL;
   tf->codes[18033] = 0x00008657c49ceb2eUL;
   tf->codes[18034] = 0x0000867dbd5aa8ecUL;
   tf->codes[18035] = 0x000086a0824615e4UL;
   tf->codes[18036] = 0x000086ab7d172ad4UL;
   tf->codes[18037] = 0x000086d4a9a73958UL;
   tf->codes[18038] = 0x000086d4e4363f1dUL;
   tf->codes[18039] = 0x000087043ddbe968UL;
   tf->codes[18040] = 0x000087085bea5142UL;
   tf->codes[18041] = 0x0000870980b56e1bUL;
   tf->codes[18042] = 0x0000872409840b5fUL;
   tf->codes[18043] = 0x0000872911ce8a4dUL;
   tf->codes[18044] = 0x00008780e85731cdUL;
   tf->codes[18045] = 0x0000878122e63792UL;
   tf->codes[18046] = 0x0000878456b88858UL;
   tf->codes[18047] = 0x000087954410334aUL;
   tf->codes[18048] = 0x000087aee2a2b97aUL;
   tf->codes[18049] = 0x000087c6722e0bbdUL;
   tf->codes[18050] = 0x000087c846a639e5UL;
   tf->codes[18051] = 0x000087d132701ae8UL;
   tf->codes[18052] = 0x000087d6ea67ab25UL;
   tf->codes[18053] = 0x000088046f952748UL;
   tf->codes[18054] = 0x00008890e29cfdc6UL;
   tf->codes[18055] = 0x0000889db1e640deUL;
   tf->codes[18056] = 0x000088accac5bda8UL;
   tf->codes[18057] = 0x000088c8785f77c5UL;
   tf->codes[18058] = 0x000088e425f931e2UL;
   tf->codes[18059] = 0x000089184d5a5556UL;
   tf->codes[18060] = 0x0000895316ef201bUL;
   tf->codes[18061] = 0x00008959b922c76cUL;
   tf->codes[18062] = 0x000089752c2d7bc4UL;
   tf->codes[18063] = 0x0000897ddd685702UL;
   tf->codes[18064] = 0x000089c06dfbe5f1UL;
   tf->codes[18065] = 0x00008a49e7c0716eUL;
   tf->codes[18066] = 0x00008a634bc3f1d9UL;
   tf->codes[18067] = 0x00008a64e5ad1a3cUL;
   tf->codes[18068] = 0x00008a67def0653dUL;
   tf->codes[18069] = 0x00008a6f6b6023a2UL;
   tf->codes[18070] = 0x00008aaae4a1ffb6UL;
   tf->codes[18071] = 0x00008ab3d06be0b9UL;
   tf->codes[18072] = 0x00008af2f29e191dUL;
   tf->codes[18073] = 0x00008b3a8b7c26faUL;
   tf->codes[18074] = 0x00008b41dd5cdf9aUL;
   tf->codes[18075] = 0x00008b98c9a97006UL;
   tf->codes[18076] = 0x00008ba29faf681dUL;
   tf->codes[18077] = 0x00008bb6fb68699aUL;
   tf->codes[18078] = 0x00008bdec89e5580UL;
   tf->codes[18079] = 0x00008c63e9c5735eUL;
   tf->codes[18080] = 0x00008c7fd1ee3340UL;
   tf->codes[18081] = 0x00008cab0d8575b1UL;
   tf->codes[18082] = 0x00008d0a707ddb96UL;
   tf->codes[18083] = 0x00008d19895d5860UL;
   tf->codes[18084] = 0x00008d3fbcaa1be3UL;
   tf->codes[18085] = 0x00008d5243eaef38UL;
   tf->codes[18086] = 0x00008d66da32f67aUL;
   tf->codes[18087] = 0x00008d883fc440d4UL;
   tf->codes[18088] = 0x00008dc42e242872UL;
   tf->codes[18089] = 0x00008dc811a38a87UL;
   tf->codes[18090] = 0x00008dcad057cfc3UL;
   tf->codes[18091] = 0x00008df97a5068bfUL;
   tf->codes[18092] = 0x00008e1b1a70b8deUL;
   tf->codes[18093] = 0x00008e435cc4b04eUL;
   tf->codes[18094] = 0x00008e4aaea568eeUL;
   tf->codes[18095] = 0x00008e56ce419ab7UL;
   tf->codes[18096] = 0x00008e5f0a5e6a6bUL;
   tf->codes[18097] = 0x00008ebc5e4f9c63UL;
   tf->codes[18098] = 0x00008ec4254e608dUL;
   tf->codes[18099] = 0x00008ec8b87ad3f1UL;
   tf->codes[18100] = 0x00008ef1aa7bdcb0UL;
   tf->codes[18101] = 0x00008f151f145af7UL;
   tf->codes[18102] = 0x00008f4946757e6bUL;
   tf->codes[18103] = 0x00008f61108fd673UL;
   tf->codes[18104] = 0x00008f965cbc16c0UL;
   tf->codes[18105] = 0x00008fa65fd7aa9eUL;
   tf->codes[18106] = 0x00008fd9d78bbcc3UL;
   tf->codes[18107] = 0x00009018bf2eef62UL;
   tf->codes[18108] = 0x000090217069caa0UL;
   tf->codes[18109] = 0x0000902469ad15a1UL;
   tf->codes[18110] = 0x00009029ac869a54UL;
   tf->codes[18111] = 0x0000902f29ef24ccUL;
   tf->codes[18112] = 0x00009058cb9d3edaUL;
   tf->codes[18113] = 0x00009081830f41d4UL;
   tf->codes[18114] = 0x00009095dec84351UL;
   tf->codes[18115] = 0x000090be963a464bUL;
   tf->codes[18116] = 0x000090d06dce0851UL;
   tf->codes[18117] = 0x000090d71001afa2UL;
   tf->codes[18118] = 0x0000912510845f0bUL;
   tf->codes[18119] = 0x00009164e263a8beUL;
   tf->codes[18120] = 0x000091831422a252UL;
   tf->codes[18121] = 0x000091bcb8ec503eUL;
   tf->codes[18122] = 0x000091d2ae8e7a1eUL;
   tf->codes[18123] = 0x0000920a4450f41dUL;
   tf->codes[18124] = 0x0000921db5cdde86UL;
   tf->codes[18125] = 0x00009233e5ff0e2bUL;
   tf->codes[18126] = 0x00009243ae8b9c44UL;
   tf->codes[18127] = 0x0000928ce152d284UL;
   tf->codes[18128] = 0x000092c17dd20182UL;
   tf->codes[18129] = 0x000092edde3460ccUL;
   tf->codes[18130] = 0x000092f56aa41f31UL;
   tf->codes[18131] = 0x0000933e9d6b5571UL;
   tf->codes[18132] = 0x0000933f128960fbUL;
   tf->codes[18133] = 0x0000936b385cba80UL;
   tf->codes[18134] = 0x00009373af088ff9UL;
   tf->codes[18135] = 0x000093ff72635528UL;
   tf->codes[18136] = 0x0000945957f33095UL;
   tf->codes[18137] = 0x0000945d00e38ce5UL;
   tf->codes[18138] = 0x0000948f193d7c6cUL;
   tf->codes[18139] = 0x000094c5c4c3df57UL;
   tf->codes[18140] = 0x000094ce75feba95UL;
   tf->codes[18141] = 0x000094f175792d52UL;
   tf->codes[18142] = 0x00009526871667daUL;
   tf->codes[18143] = 0x0000956b26b12ab6UL;
   tf->codes[18144] = 0x0000959e9e653cdbUL;
   tf->codes[18145] = 0x0000961172da8d29UL;
   tf->codes[18146] = 0x00009644ea8e9f4eUL;
   tf->codes[18147] = 0x0000965f38ce36cdUL;
   tf->codes[18148] = 0x000096661590e3e3UL;
   tf->codes[18149] = 0x0000966d67719c83UL;
   tf->codes[18150] = 0x0000967feeb26fd8UL;
   tf->codes[18151] = 0x000096a70c3b4a6fUL;
   tf->codes[18152] = 0x000096af82e71fe8UL;
   tf->codes[18153] = 0x000096bab8473a9dUL;
   tf->codes[18154] = 0x000096e4cf136035UL;
   tf->codes[18155] = 0x000096f004737aeaUL;
   tf->codes[18156] = 0x000097033b615f8eUL;
   tf->codes[18157] = 0x0000971637c03e6dUL;
   tf->codes[18158] = 0x00009720bd7347d3UL;
   tf->codes[18159] = 0x00009721a7af5ee7UL;
   tf->codes[18160] = 0x00009729341f1d4cUL;
   tf->codes[18161] = 0x0000973bf5eef666UL;
   tf->codes[18162] = 0x0000973d55491904UL;
   tf->codes[18163] = 0x000097a40a223789UL;
   tf->codes[18164] = 0x000097a7eda1999eUL;
   tf->codes[18165] = 0x0000981d463c2963UL;
   tf->codes[18166] = 0x00009829daf666b6UL;
   tf->codes[18167] = 0x000098480cb5604aUL;
   tf->codes[18168] = 0x0000987e431db7abUL;
   tf->codes[18169] = 0x000098a3519f5e55UL;
   tf->codes[18170] = 0x000098b354baf233UL;
   tf->codes[18171] = 0x000098bd9fdef5d4UL;
   tf->codes[18172] = 0x000098df7a8e4bb8UL;
   tf->codes[18173] = 0x000098eaea7d6c32UL;
   tf->codes[18174] = 0x000098eb5f9b77bcUL;
   tf->codes[18175] = 0x0000992663bf4846UL;
   tf->codes[18176] = 0x0000994c21ee003fUL;
   tf->codes[18177] = 0x0000994dbbd728a2UL;
   tf->codes[18178] = 0x0000995791dd20b9UL;
   tf->codes[18179] = 0x00009962c73d3b6eUL;
   tf->codes[18180] = 0x000099867664bf7aUL;
   tf->codes[18181] = 0x000099cef97ee46bUL;
   tf->codes[18182] = 0x000099eb9154b59cUL;
   tf->codes[18183] = 0x000099fb59e143b5UL;
   tf->codes[18184] = 0x00009a02abc1fc55UL;
   tf->codes[18185] = 0x00009a161d3ee6beUL;
   tf->codes[18186] = 0x00009a18dbf32bfaUL;
   tf->codes[18187] = 0x00009a2e21e8448bUL;
   tf->codes[18188] = 0x00009a453c558b44UL;
   tf->codes[18189] = 0x00009a4af44d1b81UL;
   tf->codes[18190] = 0x00009a53a587f6bfUL;
   tf->codes[18191] = 0x00009a6b6fa24ec7UL;
   tf->codes[18192] = 0x00009aa798913c2aUL;
   tf->codes[18193] = 0x00009ac63f6e4148UL;
   tf->codes[18194] = 0x00009aca980baee7UL;
   tf->codes[18195] = 0x00009ad1af5d61c2UL;
   tf->codes[18196] = 0x00009add59db8801UL;
   tf->codes[18197] = 0x00009af97c934da8UL;
   tf->codes[18198] = 0x00009afebf6cd25bUL;
   tf->codes[18199] = 0x00009b252d489ba3UL;
   tf->codes[18200] = 0x00009b85055f0d12UL;
   tf->codes[18201] = 0x00009bcf5cf1602bUL;
   tf->codes[18202] = 0x00009bde75d0dcf5UL;
   tf->codes[18203] = 0x00009c3611ca7eb0UL;
   tf->codes[18204] = 0x00009c51bf6438cdUL;
   tf->codes[18205] = 0x00009c556854951dUL;
   tf->codes[18206] = 0x00009c823dd4fff1UL;
   tf->codes[18207] = 0x00009cc0b05a2706UL;
   tf->codes[18208] = 0x00009cdd482ff837UL;
   tf->codes[18209] = 0x00009ce3afd499c3UL;
   tf->codes[18210] = 0x00009d4a9f3cbe0dUL;
   tf->codes[18211] = 0x00009d6b1a91f153UL;
   tf->codes[18212] = 0x00009d7b583c8af6UL;
   tf->codes[18213] = 0x00009dbfbd48480dUL;
   tf->codes[18214] = 0x00009ddf88f06a04UL;
   tf->codes[18215] = 0x00009de1d286a3b6UL;
   tf->codes[18216] = 0x00009dfdf53e695dUL;
   tf->codes[18217] = 0x00009e207f9ad090UL;
   tf->codes[18218] = 0x00009e36ea5b05faUL;
   tf->codes[18219] = 0x00009e37d4971d0eUL;
   tf->codes[18220] = 0x00009e3e3c3bbe9aUL;
   tf->codes[18221] = 0x00009e7a652aabfdUL;
   tf->codes[18222] = 0x00009ecf07e102b7UL;
   tf->codes[18223] = 0x00009f124821a2f5UL;
   tf->codes[18224] = 0x00009f25b99e8d5eUL;
   tf->codes[18225] = 0x00009f2718f8affcUL;
   tf->codes[18226] = 0x00009f43763f7b68UL;
   tf->codes[18227] = 0x00009f59a670ab0dUL;
   tf->codes[18228] = 0x00009f5fd38646d4UL;
   tf->codes[18229] = 0x00009f6bf322789dUL;
   tf->codes[18230] = 0x00009f734503313dUL;
   tf->codes[18231] = 0x00009f7a5c54e418UL;
   tf->codes[18232] = 0x00009f7a96e3e9ddUL;
   tf->codes[18233] = 0x00009f7ca5eb1dcaUL;
   tf->codes[18234] = 0x00009f9d21405110UL;
   tf->codes[18235] = 0x00009faaa036a577UL;
   tf->codes[18236] = 0x00009fbfe62bbe08UL;
   tf->codes[18237] = 0x0000a0616499a752UL;
   tf->codes[18238] = 0x0000a065f7c61ab6UL;
   tf->codes[18239] = 0x0000a069db457ccbUL;
   tf->codes[18240] = 0x0000a0d4739dfd65UL;
   tf->codes[18241] = 0x0000a0ddd485e9f2UL;
   tf->codes[18242] = 0x0000a0f59ea041faUL;
   tf->codes[18243] = 0x0000a0f947909e4aUL;
   tf->codes[18244] = 0x0000a0fcb5f1f4d5UL;
   tf->codes[18245] = 0x0000a1223991a709UL;
   tf->codes[18246] = 0x0000a188794cba04UL;
   tf->codes[18247] = 0x0000a1beea44172aUL;
   tf->codes[18248] = 0x0000a1c3f28e9618UL;
   tf->codes[18249] = 0x0000a1cc2eab65ccUL;
   tf->codes[18250] = 0x0000a1e6425bf786UL;
   tf->codes[18251] = 0x0000a1f97949dc2aUL;
   tf->codes[18252] = 0x0000a236c703e666UL;
   tf->codes[18253] = 0x0000a2739f9fe518UL;
   tf->codes[18254] = 0x0000a27b2c0fa37dUL;
   tf->codes[18255] = 0x0000a2adf416a453UL;
   tf->codes[18256] = 0x0000a2cf59a7eeadUL;
   tf->codes[18257] = 0x0000a311afac77d7UL;
   tf->codes[18258] = 0x0000a324ac0b56b6UL;
   tf->codes[18259] = 0x0000a34dd89b653aUL;
   tf->codes[18260] = 0x0000a34fad139362UL;
   tf->codes[18261] = 0x0000a37ecc2a37e8UL;
   tf->codes[18262] = 0x0000a39278362816UL;
   tf->codes[18263] = 0x0000a3ba456c13fcUL;
   tf->codes[18264] = 0x0000a3baf519254bUL;
   tf->codes[18265] = 0x0000a3c36bc4fac4UL;
   tf->codes[18266] = 0x0000a3ebae18f234UL;
   tf->codes[18267] = 0x0000a445ce37d366UL;
   tf->codes[18268] = 0x0000a4472d91f604UL;
   tf->codes[18269] = 0x0000a466beab1236UL;
   tf->codes[18270] = 0x0000a4697d5f5772UL;
   tf->codes[18271] = 0x0000a4ea0b5a01ecUL;
   tf->codes[18272] = 0x0000a4ec54f03b9eUL;
   tf->codes[18273] = 0x0000a4f8e9aa78f1UL;
   tf->codes[18274] = 0x0000a4fdb765f21aUL;
   tf->codes[18275] = 0x0000a528f2fd348bUL;
   tf->codes[18276] = 0x0000a530f48afe7aUL;
   tf->codes[18277] = 0x0000a556b2b9b673UL;
   tf->codes[18278] = 0x0000a5abca8e18b7UL;
   tf->codes[18279] = 0x0000a5df42422adcUL;
   tf->codes[18280] = 0x0000a5e116ba5904UL;
   tf->codes[18281] = 0x0000a5e9c7f53442UL;
   tf->codes[18282] = 0x0000a60fc0b2f200UL;
   tf->codes[18283] = 0x0000a6220d64bf90UL;
   tf->codes[18284] = 0x0000a627ffeb5592UL;
   tf->codes[18285] = 0x0000a63a4c9d2322UL;
   tf->codes[18286] = 0x0000a643ad850fafUL;
   tf->codes[18287] = 0x0000a679344055c1UL;
   tf->codes[18288] = 0x0000a67a590b729aUL;
   tf->codes[18289] = 0x0000a67ace297e24UL;
   tf->codes[18290] = 0x0000a6e94a0160d3UL;
   tf->codes[18291] = 0x0000a772fe54f215UL;
   tf->codes[18292] = 0x0000a77547eb2bc7UL;
   tf->codes[18293] = 0x0000a780082d3af2UL;
   tf->codes[18294] = 0x0000a78a18c238ceUL;
   tf->codes[18295] = 0x0000a7bad1c205b7UL;
   tf->codes[18296] = 0x0000a854c3c0309cUL;
   tf->codes[18297] = 0x0000a88ea318e44dUL;
   tf->codes[18298] = 0x0000a8d3f260b878UL;
   tf->codes[18299] = 0x0000a901b21d3a60UL;
   tf->codes[18300] = 0x0000a9390d50ae9aUL;
   tf->codes[18301] = 0x0000a943cd92bdc5UL;
   tf->codes[18302] = 0x0000a9a196a1fb47UL;
   tf->codes[18303] = 0x0000a9a95da0bf71UL;
   tf->codes[18304] = 0x0000a9b8eb9e47c5UL;
   tf->codes[18305] = 0x0000a9c66a949c2cUL;
   tf->codes[18306] = 0x0000a9cb38501555UL;
   tf->codes[18307] = 0x0000a9cfcb7c88b9UL;
   tf->codes[18308] = 0x0000a9eb3e873d11UL;
   tf->codes[18309] = 0x0000aa3e47546b68UL;
   tf->codes[18310] = 0x0000aa414097b669UL;
   tf->codes[18311] = 0x0000aa5aa49b36d4UL;
   tf->codes[18312] = 0x0000aab48a2b1241UL;
   tf->codes[18313] = 0x0000aacdb39f8ce7UL;
   tf->codes[18314] = 0x0000aad4906239fdUL;
   tf->codes[18315] = 0x0000ab01a071aa96UL;
   tf->codes[18316] = 0x0000ab20bc6cbb3eUL;
   tf->codes[18317] = 0x0000ab23b5b0063fUL;
   tf->codes[18318] = 0x0000ab7e857bf8c0UL;
   tf->codes[18319] = 0x0000abaec95dba1fUL;
   tf->codes[18320] = 0x0000abc1c5bc98feUL;
   tf->codes[18321] = 0x0000abe7495c4b32UL;
   tf->codes[18322] = 0x0000abeffa972670UL;
   tf->codes[18323] = 0x0000abf159f1490eUL;
   tf->codes[18324] = 0x0000abf74c77df10UL;
   tf->codes[18325] = 0x0000abfd3efe7512UL;
   tf->codes[18326] = 0x0000ac3c26a1a7b1UL;
   tf->codes[18327] = 0x0000acff7fbee6dfUL;
   tf->codes[18328] = 0x0000ad0572457ce1UL;
   tf->codes[18329] = 0x0000ad39d435a61aUL;
   tf->codes[18330] = 0x0000ad4927a428a9UL;
   tf->codes[18331] = 0x0000ad584083a573UL;
   tf->codes[18332] = 0x0000ad61a16b9200UL;
   tf->codes[18333] = 0x0000ad6b02537e8dUL;
   tf->codes[18334] = 0x0000ad7428ac6555UL;
   tf->codes[18335] = 0x0000ad9a216a2313UL;
   tf->codes[18336] = 0x0000ae270990051bUL;
   tf->codes[18337] = 0x0000ae2953263ecdUL;
   tf->codes[18338] = 0x0000ae40a8228b4bUL;
   tf->codes[18339] = 0x0000ae599708002cUL;
   tf->codes[18340] = 0x0000ae5db5166806UL;
   tf->codes[18341] = 0x0000ae928c249cc9UL;
   tf->codes[18342] = 0x0000ae9eabc0ce92UL;
   tf->codes[18343] = 0x0000aea1df931f58UL;
   tf->codes[18344] = 0x0000aecbbbd03f2bUL;
   tf->codes[18345] = 0x0000aee1b172690bUL;
   tf->codes[18346] = 0x0000af076fa12104UL;
   tf->codes[18347] = 0x0000af0d6227b706UL;
   tf->codes[18348] = 0x0000af3e1b2783efUL;
   tf->codes[18349] = 0x0000af72f235b8b2UL;
   tf->codes[18350] = 0x0000afa495719cafUL;
   tf->codes[18351] = 0x0000afe049427e88UL;
   tf->codes[18352] = 0x0000afe1a89ca126UL;
   tf->codes[18353] = 0x0000afe307f6c3c4UL;
   tf->codes[18354] = 0x0000afe9aa2a6b15UL;
   tf->codes[18355] = 0x0000b00b84d9c0f9UL;
   tf->codes[18356] = 0x0000b0229f4707b2UL;
   tf->codes[18357] = 0x0000b048d293cb35UL;
   tf->codes[18358] = 0x0000b0691359f8b6UL;
   tf->codes[18359] = 0x0000b105c40c68d7UL;
   tf->codes[18360] = 0x0000b1a39989f5d1UL;
   tf->codes[18361] = 0x0000b1a707eb4c5cUL;
   tf->codes[18362] = 0x0000b1b5368eb212UL;
   tf->codes[18363] = 0x0000b1bd72ab81c6UL;
   tf->codes[18364] = 0x0000b1c44f6e2edcUL;
   tf->codes[18365] = 0x0000b1fa10b87ab3UL;
   tf->codes[18366] = 0x0000b22795e5f6d6UL;
   tf->codes[18367] = 0x0000b22a549a3c12UL;
   tf->codes[18368] = 0x0000b238833da1c8UL;
   tf->codes[18369] = 0x0000b249ab24527fUL;
   tf->codes[18370] = 0x0000b24a95606993UL;
   tf->codes[18371] = 0x0000b25e7bfb5f86UL;
   tf->codes[18372] = 0x0000b29b54975e38UL;
   tf->codes[18373] = 0x0000b2b14a398818UL;
   tf->codes[18374] = 0x0000b2bc450a9d08UL;
   tf->codes[18375] = 0x0000b2c40c096132UL;
   tf->codes[18376] = 0x0000b2e7f5bfeb03UL;
   tf->codes[18377] = 0x0000b31a0e19da8aUL;
   tf->codes[18378] = 0x0000b339d9c1fc81UL;
   tf->codes[18379] = 0x0000b34fcf642661UL;
   tf->codes[18380] = 0x0000b3751874d2d0UL;
   tf->codes[18381] = 0x0000b3a0540c1541UL;
   tf->codes[18382] = 0x0000b3a6f63fbc92UL;
   tf->codes[18383] = 0x0000b3d565a94fc9UL;
   tf->codes[18384] = 0x0000b3de8c023691UL;
   tf->codes[18385] = 0x0000b4712c1fa8d6UL;
   tf->codes[18386] = 0x0000b473b044e84dUL;
   tf->codes[18387] = 0x0000b5156941d75cUL;
   tf->codes[18388] = 0x0000b547f6b9d26dUL;
   tf->codes[18389] = 0x0000b568720f05b3UL;
   tf->codes[18390] = 0x0000b5bf5e5b961fUL;
   tf->codes[18391] = 0x0000b5d812b2053bUL;
   tf->codes[18392] = 0x0000b606f739a3fcUL;
   tf->codes[18393] = 0x0000b619f39882dbUL;
   tf->codes[18394] = 0x0000b641c0ce6ec1UL;
   tf->codes[18395] = 0x0000b69ccb296707UL;
   tf->codes[18396] = 0x0000b6a6dbbe64e3UL;
   tf->codes[18397] = 0x0000b6c50d7d5e77UL;
   tf->codes[18398] = 0x0000b6c9a0a9d1dbUL;
   tf->codes[18399] = 0x0000b6f00e859b23UL;
   tf->codes[18400] = 0x0000b70b0c7243f1UL;
   tf->codes[18401] = 0x0000b719b033b531UL;
   tf->codes[18402] = 0x0000b737a763a900UL;
   tf->codes[18403] = 0x0000b7452659fd67UL;
   tf->codes[18404] = 0x0000b76825d47024UL;
   tf->codes[18405] = 0x0000b78a3b12cbcdUL;
   tf->codes[18406] = 0x0000b7a2052d23d5UL;
   tf->codes[18407] = 0x0000b7a7bd24b412UL;
   tf->codes[18408] = 0x0000b7d6a1ac52d3UL;
   tf->codes[18409] = 0x0000b7e2fbd78a61UL;
   tf->codes[18410] = 0x0000b81d15bf43d7UL;
   tf->codes[18411] = 0x0000b8634f432f16UL;
   tf->codes[18412] = 0x0000b86aa123e7b6UL;
   tf->codes[18413] = 0x0000b86f34505b1aUL;
   tf->codes[18414] = 0x0000b876863113baUL;
   tf->codes[18415] = 0x0000b895a22c2462UL;
   tf->codes[18416] = 0x0000b910b2be4464UL;
   tf->codes[18417] = 0x0000b924d3e8401cUL;
   tf->codes[18418] = 0x0000b976083d404bUL;
   tf->codes[18419] = 0x0000b9a6118ffbe5UL;
   tf->codes[18420] = 0x0000b9f02e934939UL;
   tf->codes[18421] = 0x0000b9f2782982ebUL;
   tf->codes[18422] = 0x0000ba85c7f4067fUL;
   tf->codes[18423] = 0x0000ba8cdf45b95aUL;
   tf->codes[18424] = 0x0000badfad83e1ecUL;
   tf->codes[18425] = 0x0000bae4b5ce60daUL;
   tf->codes[18426] = 0x0000bb18681178c4UL;
   tf->codes[18427] = 0x0000bb4ba5368524UL;
   tf->codes[18428] = 0x0000bb88b861899bUL;
   tf->codes[18429] = 0x0000bbb63d8f05beUL;
   tf->codes[18430] = 0x0000bc4a027794dcUL;
   tf->codes[18431] = 0x0000bc64c5d537e5UL;
   tf->codes[18432] = 0x0000bca24e1e47e6UL;
   tf->codes[18433] = 0x0000bcafcd149c4dUL;
   tf->codes[18434] = 0x0000bcb759845ab2UL;
   tf->codes[18435] = 0x0000bd68db0dd7daUL;
   tf->codes[18436] = 0x0000bd7c4c8ac243UL;
   tf->codes[18437] = 0x0000bd8572e3a90bUL;
   tf->codes[18438] = 0x0000bd87f708e882UL;
   tf->codes[18439] = 0x0000bd9416a51a4bUL;
   tf->codes[18440] = 0x0000bd9d778d06d8UL;
   tf->codes[18441] = 0x0000bdb92526c0f5UL;
   tf->codes[18442] = 0x0000bdd79174c04eUL;
   tf->codes[18443] = 0x0000be5b5341bb8eUL;
   tf->codes[18444] = 0x0000be5b8dd0c153UL;
   tf->codes[18445] = 0x0000be91148c0765UL;
   tf->codes[18446] = 0x0000bec5767c309eUL;
   tf->codes[18447] = 0x0000becffc2f3a04UL;
   tf->codes[18448] = 0x0000bed41a3da1deUL;
   tf->codes[18449] = 0x0000bef2c11aa6fcUL;
   tf->codes[18450] = 0x0000bef3e5e5c3d5UL;
   tf->codes[18451] = 0x0000bf22554f570cUL;
   tf->codes[18452] = 0x0000bf6261bda684UL;
   tf->codes[18453] = 0x0000bf75d33a90edUL;
   tf->codes[18454] = 0x0000bf85d65624cbUL;
   tf->codes[18455] = 0x0000bfdfbbe60038UL;
   tf->codes[18456] = 0x0000bfe3d9f46812UL;
   tf->codes[18457] = 0x0000c01a105cbf73UL;
   tf->codes[18458] = 0x0000c01b6fb6e211UL;
   tf->codes[18459] = 0x0000c055c42da14cUL;
   tf->codes[18460] = 0x0000c06b44b1bfa2UL;
   tf->codes[18461] = 0x0000c0c982df08aeUL;
   tf->codes[18462] = 0x0000c18305f64fc5UL;
   tf->codes[18463] = 0x0000c186e975b1daUL;
   tf->codes[18464] = 0x0000c1a59052b6f8UL;
   tf->codes[18465] = 0x0000c1c680c5f5c8UL;
   tf->codes[18466] = 0x0000c1f1bc5d3839UL;
   tf->codes[18467] = 0x0000c1f68a18b162UL;
   tf->codes[18468] = 0x0000c2bca1ea35ccUL;
   tf->codes[18469] = 0x0000c2fa2a3345cdUL;
   tf->codes[18470] = 0x0000c332e4c0dca5UL;
   tf->codes[18471] = 0x0000c3644d6dbaddUL;
   tf->codes[18472] = 0x0000c372f12f2c1dUL;
   tf->codes[18473] = 0x0000c3c87e2199ebUL;
   tf->codes[18474] = 0x0000c3eb7d9c0ca8UL;
   tf->codes[18475] = 0x0000c40138af30c3UL;
   tf->codes[18476] = 0x0000c43fab3457d8UL;
   tf->codes[18477] = 0x0000c46110c5a232UL;
   tf->codes[18478] = 0x0000c51600b075e5UL;
   tf->codes[18479] = 0x0000c6099daf7672UL;
   tf->codes[18480] = 0x0000c63ca0457d0dUL;
   tf->codes[18481] = 0x0000c65295e7a6edUL;
   tf->codes[18482] = 0x0000c79a25efece5UL;
   tf->codes[18483] = 0x0000c7bef9e28dcaUL;
   tf->codes[18484] = 0x0000cacfccb8e10dUL;
   tf->codes[18485] = 0x0000cc45919bb477UL;
   tf->codes[18486] = 0x0000cc7943decc61UL;
   tf->codes[18487] = 0x0000cca35aaaf1f9UL;
   tf->codes[18488] = 0x0000ccc65a2564b6UL;
   tf->codes[18489] = 0x0000cd4a91106b80UL;
   tf->codes[18490] = 0x0000cd8c3767e35bUL;
   tf->codes[18491] = 0x0000cdc6514f9cd1UL;
   tf->codes[18492] = 0x0000cdd9131f75ebUL;
   tf->codes[18493] = 0x0000cde4f82ca1efUL;
   tf->codes[18494] = 0x0000cdecf9ba6bdeUL;
   tf->codes[18495] = 0x0000ce0d3a80995fUL;
   tf->codes[18496] = 0x0000cf83e99f83ddUL;
   tf->codes[18497] = 0x0000cfc67a3312ccUL;
   tf->codes[18498] = 0x0000d0314d1a992bUL;
   tf->codes[18499] = 0x0000d31ee5e773ecUL;
   tf->codes[18500] = 0x0000d3729e61b392UL;
   tf->codes[18501] = 0x0000d3864a6da3c0UL;
   tf->codes[18502] = 0x0000d3b619315995UL;
   tf->codes[18503] = 0x0000d419251a1bcaUL;
   tf->codes[18504] = 0x0000d4cfe97d1da5UL;
   tf->codes[18505] = 0x0000d5d6bd6a02d6UL;
   tf->codes[18506] = 0x0000d5e90a1bd066UL;
   tf->codes[18507] = 0x0000d6114c6fc7d6UL;
   tf->codes[18508] = 0x0000d6e7a1ebe5e3UL;
   tf->codes[18509] = 0x0000d7389bb1e04dUL;
   tf->codes[18510] = 0x0000d73fb3039328UL;
   tf->codes[18511] = 0x0000d776d3a8019dUL;
   tf->codes[18512] = 0x0000d7f6b1f59ac8UL;
   tf->codes[18513] = 0x0000d86c0a902a8dUL;
   tf->codes[18514] = 0x0000d92727909a07UL;
   tf->codes[18515] = 0x0000d984f09fd789UL;
   tf->codes[18516] = 0x0000d9a113579d30UL;
   tf->codes[18517] = 0x0000d9bc4bd34bc3UL;
   tf->codes[18518] = 0x0000da558e246559UL;
   tf->codes[18519] = 0x0000dab7afd1107aUL;
   tf->codes[18520] = 0x0000dac52ec764e1UL;
   tf->codes[18521] = 0x0000db383dcbbaf4UL;
   tf->codes[18522] = 0x0000db3a8761f4a6UL;
   tf->codes[18523] = 0x0000db8887e4a40fUL;
   tf->codes[18524] = 0x0000dbdeff1328f1UL;
   tf->codes[18525] = 0x0000dc54923cbe7bUL;
   tf->codes[18526] = 0x0000dc692884c5bdUL;
   tf->codes[18527] = 0x0000dd3a75b664dcUL;
   tf->codes[18528] = 0x0000dd8b34ed5981UL;
   tf->codes[18529] = 0x0000dd978f18910fUL;
   tf->codes[18530] = 0x0000dddb09e83712UL;
   tf->codes[18531] = 0x0000de0520b45caaUL;
   tf->codes[18532] = 0x0000de16f8481eb0UL;
   tf->codes[18533] = 0x0000de8a7c6a804dUL;
   tf->codes[18534] = 0x0000decdf73a2650UL;
   tf->codes[18535] = 0x0000df0cdedd58efUL;
   tf->codes[18536] = 0x0000df3bfdf3fd75UL;
   tf->codes[18537] = 0x0000df49f2085d66UL;
   tf->codes[18538] = 0x0000df8e57141a7dUL;
   tf->codes[18539] = 0x0000dff9d9a8b22bUL;
   tf->codes[18540] = 0x0000e00a17534bceUL;
   tf->codes[18541] = 0x0000e03294364903UL;
   tf->codes[18542] = 0x0000e171e821bf47UL;
   tf->codes[18543] = 0x0000e19437ef20b5UL;
   tf->codes[18544] = 0x0000e1c10d6f8b89UL;
   tf->codes[18545] = 0x0000e1cfebc0028eUL;
   tf->codes[18546] = 0x0000e298fcd4d1f9UL;
   tf->codes[18547] = 0x0000e327b972e229UL;
   tf->codes[18548] = 0x0000e32c12104fc8UL;
   tf->codes[18549] = 0x0000e3e9b335feb9UL;
   tf->codes[18550] = 0x0000e48a0cd8cb2aUL;
   tf->codes[18551] = 0x0000e518c976db5aUL;
   tf->codes[18552] = 0x0000e543ca7f1806UL;
   tf->codes[18553] = 0x0000e57ecea2e890UL;
   tf->codes[18554] = 0x0000e5844c0b7308UL;
   tf->codes[18555] = 0x0000e5919072c1aaUL;
   tf->codes[18556] = 0x0000e5d6300d8486UL;
   tf->codes[18557] = 0x0000e5f1a31838deUL;
   tf->codes[18558] = 0x0000e7eb64570d4dUL;
   tf->codes[18559] = 0x0000e8a3fd323d50UL;
   tf->codes[18560] = 0x0000e8c9bb60f549UL;
   tf->codes[18561] = 0x0000e8d85f226689UL;
   tf->codes[18562] = 0x0000e901c6417ad2UL;
   tf->codes[18563] = 0x0000e90aec9a619aUL;
   tf->codes[18564] = 0x0000e924160edc40UL;
   tf->codes[18565] = 0x0000e925ea870a68UL;
   tf->codes[18566] = 0x0000e939d122005bUL;
   tf->codes[18567] = 0x0000e940e873b336UL;
   tf->codes[18568] = 0x0000eb6067e13f9eUL;
   tf->codes[18569] = 0x0000eb6aed944904UL;
   tf->codes[18570] = 0x0000eb7e99a03932UL;
   tf->codes[18571] = 0x0000eb7ed42f3ef7UL;
   tf->codes[18572] = 0x0000eb8959e2485dUL;
   tf->codes[18573] = 0x0000ebb0b1fa28b9UL;
   tf->codes[18574] = 0x0000ebd42692a700UL;
   tf->codes[18575] = 0x0000ec5e500443ccUL;
   tf->codes[18576] = 0x0000ec714c6322abUL;
   tf->codes[18577] = 0x0000ec7e90ca714dUL;
   tf->codes[18578] = 0x0000ed968c9e0735UL;
   tf->codes[18579] = 0x0000edcfbc49a997UL;
   tf->codes[18580] = 0x0000ede193dd6b9dUL;
   tf->codes[18581] = 0x0000edfba78dfd57UL;
   tf->codes[18582] = 0x0000ee3a54a22a31UL;
   tf->codes[18583] = 0x0000ee5134806b25UL;
   tf->codes[18584] = 0x0000ee6ef121592fUL;
   tf->codes[18585] = 0x0000ee9b8c12be3eUL;
   tf->codes[18586] = 0x0000ef94a67a4943UL;
   tf->codes[18587] = 0x0000efa9ec6f61d4UL;
   tf->codes[18588] = 0x0000effa711750b4UL;
   tf->codes[18589] = 0x0000f0da9c9966d8UL;
   tf->codes[18590] = 0x0000f10a6b5d1cadUL;
   tf->codes[18591] = 0x0000f10ec3fa8a4cUL;
   tf->codes[18592] = 0x0000f144fa62e1adUL;
   tf->codes[18593] = 0x0000f1583150c651UL;
   tf->codes[18594] = 0x0000f17120363b32UL;
   tf->codes[18595] = 0x0000f19be6af7219UL;
   tf->codes[18596] = 0x0000f19c5bcd7da3UL;
   tf->codes[18597] = 0x0000f2540a6c9692UL;
   tf->codes[18598] = 0x0000f2c78e8ef82fUL;
   tf->codes[18599] = 0x0000f2dcd48410c0UL;
   tf->codes[18600] = 0x0000f2f33f44462aUL;
   tf->codes[18601] = 0x0000f30083ab94ccUL;
   tf->codes[18602] = 0x0000f4ee9a6c42fcUL;
   tf->codes[18603] = 0x0000f503a5d255c8UL;
   tf->codes[18604] = 0x0000f541a3397153UL;
   tf->codes[18605] = 0x0000f54f222fc5baUL;
   tf->codes[18606] = 0x0000f5658ceffb24UL;
   tf->codes[18607] = 0x0000f587a22e56cdUL;
   tf->codes[18608] = 0x0000f5d7b1b83a23UL;
   tf->codes[18609] = 0x0000f63a0df3eb09UL;
   tf->codes[18610] = 0x0000f682567f0a35UL;
   tf->codes[18611] = 0x0000f7750941f3aeUL;
   tf->codes[18612] = 0x0000f7adfe5e904bUL;
   tf->codes[18613] = 0x0000f814edc6b495UL;
   tf->codes[18614] = 0x0000f89715aa8772UL;
   tf->codes[18615] = 0x0000f89c931311eaUL;
   tf->codes[18616] = 0x0000f8d88172f988UL;
   tf->codes[18617] = 0x0000f8fad1405af6UL;
   tf->codes[18618] = 0x0000f90223211396UL;
   tf->codes[18619] = 0x0000f936fa2f4859UL;
   tf->codes[18620] = 0x0000f93c3d08cd0cUL;
   tf->codes[18621] = 0x0000f93e4c1000f9UL;
   tf->codes[18622] = 0x0000f95c08b0ef03UL;
   tf->codes[18623] = 0x0000f97aaf8df421UL;
   tf->codes[18624] = 0x0000f9b3df399683UL;
   tf->codes[18625] = 0x0000f9cba953ee8bUL;
   tf->codes[18626] = 0x0000f9d2c0a5a166UL;
   tf->codes[18627] = 0x0000fa05138e96b2UL;
   tf->codes[18628] = 0x0000fa81837ad952UL;
   tf->codes[18629] = 0x0000fae53f10acd6UL;
   tf->codes[18630] = 0x0000fb84395956a9UL;
   tf->codes[18631] = 0x0000fb87a7baad34UL;
   tf->codes[18632] = 0x0000fb890714cfd2UL;
   tf->codes[18633] = 0x0000fbbe5341101fUL;
   tf->codes[18634] = 0x0000fbf2b5313958UL;
   tf->codes[18635] = 0x0000fc2e2e73156cUL;
   tf->codes[18636] = 0x0000fc5d12fab42dUL;
   tf->codes[18637] = 0x0000fc95cd884b05UL;
   tf->codes[18638] = 0x0000fcc2dd97bb9eUL;
   tf->codes[18639] = 0x0000fd1f474cd682UL;
   tf->codes[18640] = 0x0000fd5a4b70a70cUL;
   tf->codes[18641] = 0x0000fd5be559cf6fUL;
   tf->codes[18642] = 0x0000fd5ccf95e683UL;
   tf->codes[18643] = 0x0000fd91e133210bUL;
   tf->codes[18644] = 0x0000fde97d2cc2c6UL;
   tf->codes[18645] = 0x0000fe3cc088f6e2UL;
   tf->codes[18646] = 0x0000fe59585ec813UL;
   tf->codes[18647] = 0x0000fe7e2c5168f8UL;
   tf->codes[18648] = 0x0000fe7f511c85d1UL;
   tf->codes[18649] = 0x0000fe803b589ce5UL;
   tf->codes[18650] = 0x0000fe819ab2bf83UL;
   tf->codes[18651] = 0x0000fe87181b49fbUL;
   tf->codes[18652] = 0x0000feadc0861908UL;
   tf->codes[18653] = 0x0000feb58784dd32UL;
   tf->codes[18654] = 0x0000febd4e83a15cUL;
   tf->codes[18655] = 0x0000fee605f5a456UL;
   tf->codes[18656] = 0x0000ff3983e0de37UL;
   tf->codes[18657] = 0x0000ff3cf24234c2UL;
   tf->codes[18658] = 0x0000ff4026148588UL;
   tf->codes[18659] = 0x0000ff540caf7b7bUL;
   tf->codes[18660] = 0x0000ff556c099e19UL;
   tf->codes[18661] = 0x0000ffc1292d3b8cUL;
   tf->codes[18662] = 0x0000fffb0885ef3dUL;
   tf->codes[18663] = 0x000100251f5214d5UL;
   tf->codes[18664] = 0x0001003fe2afb7deUL;
   tf->codes[18665] = 0x0001006b936505d9UL;
   tf->codes[18666] = 0x000100956fa225acUL;
   tf->codes[18667] = 0x000100d3a79846fcUL;
   tf->codes[18668] = 0x000101501784899cUL;
   tf->codes[18669] = 0x0001016b1571326aUL;
   tf->codes[18670] = 0x000102f7ba3246c8UL;
   tf->codes[18671] = 0x0001032a8239479eUL;
   tf->codes[18672] = 0x00010383b81c11bcUL;
   tf->codes[18673] = 0x000103eb1ca24190UL;
   tf->codes[18674] = 0x0001042411bede2dUL;
   tf->codes[18675] = 0x00010425aba80690UL;
   tf->codes[18676] = 0x000104683c3b957fUL;
   tf->codes[18677] = 0x000104cc6cef748dUL;
   tf->codes[18678] = 0x00010525dd614470UL;
   tf->codes[18679] = 0x000105ea95d8a63cUL;
   tf->codes[18680] = 0x000106093cb5ab5aUL;
   tf->codes[18681] = 0x0001065fee733601UL;
   tf->codes[18682] = 0x00010669c4792e18UL;
   tf->codes[18683] = 0x0001071e04b6f07cUL;
   tf->codes[18684] = 0x00010741794f6ec3UL;
   tf->codes[18685] = 0x000107ed7d706173UL;
   tf->codes[18686] = 0x000108ae17d95b65UL;
   tf->codes[18687] = 0x000109a73240e66aUL;
   tf->codes[18688] = 0x000109b17d64ea0bUL;
   tf->codes[18689] = 0x00010a1ed471afe1UL;
   tf->codes[18690] = 0x00010a27108e7f95UL;
   tf->codes[18691] = 0x00010ad17ac649e2UL;
   tf->codes[18692] = 0x00010ae43c9622fcUL;
   tf->codes[18693] = 0x00010af9828b3b8dUL;
   tf->codes[18694] = 0x00010ba5118e22b3UL;
   tf->codes[18695] = 0x00010bc00f7acb81UL;
   tf->codes[18696] = 0x00010c5e94a569caUL;
   tf->codes[18697] = 0x00010cb8b4c44afcUL;
   tf->codes[18698] = 0x00010cceaa6674dcUL;
   tf->codes[18699] = 0x00010ce3061f7659UL;
   tf->codes[18700] = 0x00010cea58002ef9UL;
   tf->codes[18701] = 0x00010da45035819aUL;
   tf->codes[18702] = 0x00010e054d170fe2UL;
   tf->codes[18703] = 0x00010e1465f68cacUL;
   tf->codes[18704] = 0x00010e2a9627bc51UL;
   tf->codes[18705] = 0x00010e4016abdaa7UL;
   tf->codes[18706] = 0x00010e74037df856UL;
   tf->codes[18707] = 0x00010e74789c03e0UL;
   tf->codes[18708] = 0x00010e7fadfc1e95UL;
   tf->codes[18709] = 0x00010f354d940397UL;
   tf->codes[18710] = 0x00010f6b83fc5af8UL;
   tf->codes[18711] = 0x00010fdc83f97d1eUL;
   tf->codes[18712] = 0x0001101b6b9cafbdUL;
   tf->codes[18713] = 0x00011065889ffd11UL;
   tf->codes[18714] = 0x0001108519b91943UL;
   tf->codes[18715] = 0x000110a769867ab1UL;
   tf->codes[18716] = 0x000110ee52b7773fUL;
   tf->codes[18717] = 0x000110f703f2527dUL;
   tf->codes[18718] = 0x000110f9c2a697b9UL;
   tf->codes[18719] = 0x0001110d6eb287e7UL;
   tf->codes[18720] = 0x000111265d97fcc8UL;
   tf->codes[18721] = 0x000111a9aa46ec7eUL;
   tf->codes[18722] = 0x000111e52388c892UL;
   tf->codes[18723] = 0x0001122b979bb996UL;
   tf->codes[18724] = 0x00011238dc030838UL;
   tf->codes[18725] = 0x00011292c192e3a5UL;
   tf->codes[18726] = 0x00011365a8adab27UL;
   tf->codes[18727] = 0x000113a9d32a6279UL;
   tf->codes[18728] = 0x000114443a4698e8UL;
   tf->codes[18729] = 0x00011465da66e907UL;
   tf->codes[18730] = 0x000114685e8c287eUL;
   tf->codes[18731] = 0x000114e160171493UL;
   tf->codes[18732] = 0x00011502c5a85eedUL;
   tf->codes[18733] = 0x000115221c32755aUL;
   tf->codes[18734] = 0x0001156ef7ea07eaUL;
   tf->codes[18735] = 0x0001157c3c51568cUL;
   tf->codes[18736] = 0x0001159c7d17840dUL;
   tf->codes[18737] = 0x000115bcbdddb18eUL;
   tf->codes[18738] = 0x0001161d80303a11UL;
   tf->codes[18739] = 0x0001164dc411fb70UL;
   tf->codes[18740] = 0x000117227fa4f11aUL;
   tf->codes[18741] = 0x00011727fd0d7b92UL;
   tf->codes[18742] = 0x000117315df5681fUL;
   tf->codes[18743] = 0x0001173f8c98cdd5UL;
   tf->codes[18744] = 0x000117671f3fb3f6UL;
   tf->codes[18745] = 0x0001178eb1e69a17UL;
   tf->codes[18746] = 0x00011835732e0814UL;
   tf->codes[18747] = 0x0001186b347853ebUL;
   tf->codes[18748] = 0x0001189d12433dadUL;
   tf->codes[18749] = 0x0001189d87614937UL;
   tf->codes[18750] = 0x000118bf27819956UL;
   tf->codes[18751] = 0x000118ea2889d602UL;
   tf->codes[18752] = 0x00011938d8b996baUL;
   tf->codes[18753] = 0x000119d75de43503UL;
   tf->codes[18754] = 0x000119d8f7cd5d66UL;
   tf->codes[18755] = 0x00011a14e62d4504UL;
   tf->codes[18756] = 0x00011a29075740bcUL;
   tf->codes[18757] = 0x00011a3e12bd5388UL;
   tf->codes[18758] = 0x00011bb8dfeaa5e0UL;
   tf->codes[18759] = 0x00011c504dc3914eUL;
   tf->codes[18760] = 0x00011c959d0b6579UL;
   tf->codes[18761] = 0x00011d0c8f8f1da1UL;
   tf->codes[18762] = 0x00011d257e749282UL;
   tf->codes[18763] = 0x00011d6e018eb773UL;
   tf->codes[18764] = 0x00011d78c1d0c69eUL;
   tf->codes[18765] = 0x00011d8b0e82942eUL;
   tf->codes[18766] = 0x00011dc0953dda40UL;
   tf->codes[18767] = 0x00011dda6e5f6635UL;
   tf->codes[18768] = 0x00011e21579062c3UL;
   tf->codes[18769] = 0x00011e3453ef41a2UL;
   tf->codes[18770] = 0x00011e43a75dc431UL;
   tf->codes[18771] = 0x00011e5e6abb673aUL;
   tf->codes[18772] = 0x00011f5ffbcec7b8UL;
   tf->codes[18773] = 0x00011f627ff4072fUL;
   tf->codes[18774] = 0x00011f6e9f9038f8UL;
   tf->codes[18775] = 0x00011fa217444b1dUL;
   tf->codes[18776] = 0x000120477931967cUL;
   tf->codes[18777] = 0x0001207cc55dd6c9UL;
   tf->codes[18778] = 0x00012083dcaf89a4UL;
   tf->codes[18779] = 0x00012087c02eebb9UL;
   tf->codes[18780] = 0x00012092bb0000a9UL;
   tf->codes[18781] = 0x0001209838688b21UL;
   tf->codes[18782] = 0x000120df219987afUL;
   tf->codes[18783] = 0x000121c5b4c03f5fUL;
   tf->codes[18784] = 0x0001220427456674UL;
   tf->codes[18785] = 0x00012236ef4c674aUL;
   tf->codes[18786] = 0x000122c5abea777aUL;
   tf->codes[18787] = 0x00012356b21ec15cUL;
   tf->codes[18788] = 0x000123584c07e9bfUL;
   tf->codes[18789] = 0x000123b47b2dfedeUL;
   tf->codes[18790] = 0x000123b59ff91bb7UL;
   tf->codes[18791] = 0x0001240ba209950fUL;
   tf->codes[18792] = 0x000124241bd0fe66UL;
   tf->codes[18793] = 0x000124d0950ffca0UL;
   tf->codes[18794] = 0x00012537847820eaUL;
   tf->codes[18795] = 0x00012591a497021cUL;
   tf->codes[18796] = 0x000125bb0bb61665UL;
   tf->codes[18797] = 0x0001265af03ad74cUL;
   tf->codes[18798] = 0x000126669ab8fd8bUL;
   tf->codes[18799] = 0x000126ffa27b115cUL;
   tf->codes[18800] = 0x00012716f7775ddaUL;
   tf->codes[18801] = 0x000127827a0bf588UL;
   tf->codes[18802] = 0x000127e0088c2d45UL;
   tf->codes[18803] = 0x000127f1e01fef4bUL;
   tf->codes[18804] = 0x00012858cf881395UL;
   tf->codes[18805] = 0x0001285ced967b6fUL;
   tf->codes[18806] = 0x00012951af6098d5UL;
   tf->codes[18807] = 0x000129b86439b75aUL;
   tf->codes[18808] = 0x000129be56c04d5cUL;
   tf->codes[18809] = 0x000129cb60989639UL;
   tf->codes[18810] = 0x00012a3a8c1d8a37UL;
   tf->codes[18811] = 0x00012ac47b00213eUL;
   tf->codes[18812] = 0x00012b2dee8d84ffUL;
   tf->codes[18813] = 0x00012bba9c246142UL;
   tf->codes[18814] = 0x00012bd2a0cdbf0fUL;
   tf->codes[18815] = 0x00012be9f5ca0b8dUL;
   tf->codes[18816] = 0x00012bf356b1f81aUL;
   tf->codes[18817] = 0x00012c2484cfd08dUL;
   tf->codes[18818] = 0x00012c88b583af9bUL;
   tf->codes[18819] = 0x00012d402993c2c5UL;
   tf->codes[18820] = 0x00012d6d74323923UL;
   tf->codes[18821] = 0x00012dc5102bdadeUL;
   tf->codes[18822] = 0x00012ddd89f34435UL;
   tf->codes[18823] = 0x00012de16d72a64aUL;
   tf->codes[18824] = 0x00012de7256a3687UL;
   tf->codes[18825] = 0x00012e2f33664feeUL;
   tf->codes[18826] = 0x00012e32a1c7a679UL;
   tf->codes[18827] = 0x00012eb0ab9d117cUL;
   tf->codes[18828] = 0x00012eca4a2f97acUL;
   tf->codes[18829] = 0x00012efb3dbe6a5aUL;
   tf->codes[18830] = 0x00012f7da03142fcUL;
   tf->codes[18831] = 0x00012f894aaf693bUL;
   tf->codes[18832] = 0x00012f9da6686ab8UL;
   tf->codes[18833] = 0x00012fd86ffd357dUL;
   tf->codes[18834] = 0x000130b776b42ec8UL;
   tf->codes[18835] = 0x000130c9c365fc58UL;
   tf->codes[18836] = 0x0001320867a4614dUL;
   tf->codes[18837] = 0x00013230e4875e82UL;
   tf->codes[18838] = 0x00013256dd451c40UL;
   tf->codes[18839] = 0x0001328aca1739efUL;
   tf->codes[18840] = 0x000132fadfd84501UL;
   tf->codes[18841] = 0x0001338b70ee8359UL;
   tf->codes[18842] = 0x000133cbb7ebd896UL;
   tf->codes[18843] = 0x0001341c3c93c776UL;
   tf->codes[18844] = 0x0001343b1dffd259UL;
   tf->codes[18845] = 0x0001360a8de37b6bUL;
   tf->codes[18846] = 0x0001363a22182b7bUL;
   tf->codes[18847] = 0x0001363a97363705UL;
   tf->codes[18848] = 0x0001365d21929e38UL;
   tf->codes[18849] = 0x00013679f3f7752eUL;
   tf->codes[18850] = 0x000136a5a4acc329UL;
   tf->codes[18851] = 0x000136b35e321d55UL;
   tf->codes[18852] = 0x000136ba0065c4a6UL;
   tf->codes[18853] = 0x000136d7f795b875UL;
   tf->codes[18854] = 0x000136f7fdcce031UL;
   tf->codes[18855] = 0x000137428fee390fUL;
   tf->codes[18856] = 0x00013750f920a48aUL;
   tf->codes[18857] = 0x0001378bc2b56f4fUL;
   tf->codes[18858] = 0x000137c89b516e01UL;
   tf->codes[18859] = 0x000137ef7e4b42d3UL;
   tf->codes[18860] = 0x000137f5ab60de9aUL;
   tf->codes[18861] = 0x0001382edb0c80fcUL;
   tf->codes[18862] = 0x000138837dc2d7b6UL;
   tf->codes[18863] = 0x0001389ce1c65821UL;
   tf->codes[18864] = 0x000138fd6989dadfUL;
   tf->codes[18865] = 0x00013905a5a6aa93UL;
   tf->codes[18866] = 0x0001392536bfc6c5UL;
   tf->codes[18867] = 0x00013961d4ccbfb2UL;
   tf->codes[18868] = 0x00013987cd8a7d70UL;
   tf->codes[18869] = 0x000139b84bfb4494UL;
   tf->codes[18870] = 0x000139f683f165e4UL;
   tf->codes[18871] = 0x00013a159fec768cUL;
   tf->codes[18872] = 0x00013a7ba51883c2UL;
   tf->codes[18873] = 0x00013a95091c042dUL;
   tf->codes[18874] = 0x00013abfcf953b14UL;
   tf->codes[18875] = 0x00013aeb0b2c7d85UL;
   tf->codes[18876] = 0x00013b17e0ace859UL;
   tf->codes[18877] = 0x00013b1d98a47896UL;
   tf->codes[18878] = 0x00013b5feea901c0UL;
   tf->codes[18879] = 0x00013b740fd2fd78UL;
   tf->codes[18880] = 0x00013b8bd9ed5580UL;
   tf->codes[18881] = 0x00013b97f9898749UL;
   tf->codes[18882] = 0x00013b9f4b6a3fe9UL;
   tf->codes[18883] = 0x00013bfe39449a44UL;
   tf->codes[18884] = 0x00013c59f34ca3d9UL;
   tf->codes[18885] = 0x00013cfdbb50c6d5UL;
   tf->codes[18886] = 0x00013d27d21cec6dUL;
   tf->codes[18887] = 0x00013d4d904ba466UL;
   tf->codes[18888] = 0x00013d4e0569aff0UL;
   tf->codes[18889] = 0x00013d5173cb067bUL;
   tf->codes[18890] = 0x00013dc5e2297f2cUL;
   tf->codes[18891] = 0x00013e05b408c8dfUL;
   tf->codes[18892] = 0x00013e32fea73f3dUL;
   tf->codes[18893] = 0x00013e3c5f8f2bcaUL;
   tf->codes[18894] = 0x00013e69aa2da228UL;
   tf->codes[18895] = 0x00013e808a0be31cUL;
   tf->codes[18896] = 0x00013e9b87f88beaUL;
   tf->codes[18897] = 0x00013e9d21e1b44dUL;
   tf->codes[18898] = 0x00013eb770214bccUL;
   tf->codes[18899] = 0x00013ee89e3f243fUL;
   tf->codes[18900] = 0x00013eef05e3c5cbUL;
   tf->codes[18901] = 0x00013f20a91fa9c8UL;
   tf->codes[18902] = 0x00013f320b956044UL;
   tf->codes[18903] = 0x00013f478c197e9aUL;
   tf->codes[18904] = 0x00013f98c06e7ec9UL;
   tf->codes[18905] = 0x00013fde4a4558b9UL;
   tf->codes[18906] = 0x00013fe6fb8033f7UL;
   tf->codes[18907] = 0x00013ff7e8d7dee9UL;
   tf->codes[18908] = 0x0001401480adb01aUL;
   tf->codes[18909] = 0x000140323d4e9e24UL;
   tf->codes[18910] = 0x0001407ea3e8252aUL;
   tf->codes[18911] = 0x000140996745c833UL;
   tf->codes[18912] = 0x000140a3b269cbd4UL;
   tf->codes[18913] = 0x000140d3f64b8d33UL;
   tf->codes[18914] = 0x0001410b16effba8UL;
   tf->codes[18915] = 0x0001417e25f451bbUL;
   tf->codes[18916] = 0x00014187c16b440dUL;
   tf->codes[18917] = 0x000141a493d01b03UL;
   tf->codes[18918] = 0x000141af19832469UL;
   tf->codes[18919] = 0x0001421100a0c9c5UL;
   tf->codes[18920] = 0x0001421d955b0718UL;
   tf->codes[18921] = 0x0001426359c0e6cdUL;
   tf->codes[18922] = 0x000142f49a843674UL;
   tf->codes[18923] = 0x000142fbb1d5e94fUL;
   tf->codes[18924] = 0x000143007f916278UL;
   tf->codes[18925] = 0x0001432309edc9abUL;
   tf->codes[18926] = 0x0001434d95d7facdUL;
   tf->codes[18927] = 0x0001438aa902ff44UL;
   tf->codes[18928] = 0x000143b44ab11952UL;
   tf->codes[18929] = 0x000143bb9c91d1f2UL;
   tf->codes[18930] = 0x000143e0ab13789cUL;
   tf->codes[18931] = 0x000143f332544bf1UL;
   tf->codes[18932] = 0x000143fd085a4408UL;
   tf->codes[18933] = 0x00014434d8abc3ccUL;
   tf->codes[18934] = 0x000144363805e66aUL;
   tf->codes[18935] = 0x000144a05b405b7aUL;
   tf->codes[18936] = 0x000144a4ee6ccedeUL;
   tf->codes[18937] = 0x000144c52f32fc5fUL;
   tf->codes[18938] = 0x00014501cd3ff54cUL;
   tf->codes[18939] = 0x0001451f4f51dd91UL;
   tf->codes[18940] = 0x0001453a4d3e865fUL;
   tf->codes[18941] = 0x00014586b3d80d65UL;
   tf->codes[18942] = 0x000145e3cd3a3998UL;
   tf->codes[18943] = 0x00014616cfd04033UL;
   tf->codes[18944] = 0x000146291c820dc3UL;
   tf->codes[18945] = 0x0001464a47845258UL;
   tf->codes[18946] = 0x00014685c0c62e6cUL;
   tf->codes[18947] = 0x0001472445f0ccb5UL;
   tf->codes[18948] = 0x0001473b605e136eUL;
   tf->codes[18949] = 0x0001474e5cbcf24dUL;
   tf->codes[18950] = 0x000147ab761f1e80UL;
   tf->codes[18951] = 0x000147bc28e7c3adUL;
   tf->codes[18952] = 0x000147c84883f576UL;
   tf->codes[18953] = 0x000147db0a53ce90UL;
   tf->codes[18954] = 0x000147f1afa309bfUL;
   tf->codes[18955] = 0x000147f81747ab4bUL;
   tf->codes[18956] = 0x000148047172e2d9UL;
   tf->codes[18957] = 0x0001484bcfc1eaf1UL;
   tf->codes[18958] = 0x0001485ecc20c9d0UL;
   tf->codes[18959] = 0x00014868a226c1e7UL;
   tf->codes[18960] = 0x00014887be21d28fUL;
   tf->codes[18961] = 0x0001488bdc303a69UL;
   tf->codes[18962] = 0x000148974c1f5ae3UL;
   tf->codes[18963] = 0x000148cfcc1debf6UL;
   tf->codes[18964] = 0x0001492817c49f00UL;
   tf->codes[18965] = 0x0001497c455cea30UL;
   tf->codes[18966] = 0x0001498ae91e5b70UL;
   tf->codes[18967] = 0x000149e668975f40UL;
   tf->codes[18968] = 0x00014a25ffe7a32eUL;
   tf->codes[18969] = 0x00014a3bbafac749UL;
   tf->codes[18970] = 0x00014a7b8cda10fcUL;
   tf->codes[18971] = 0x00014ab6566edbc1UL;
   tf->codes[18972] = 0x00014b19d775a980UL;
   tf->codes[18973] = 0x00014b87a3a07ae0UL;
   tf->codes[18974] = 0x00014b8bfc3de87fUL;
   tf->codes[18975] = 0x00014bab1838f927UL;
   tf->codes[18976] = 0x00014c091bd73c6eUL;
   tf->codes[18977] = 0x00014c0e5eb0c121UL;
   tf->codes[18978] = 0x00014c26d8782a78UL;
   tf->codes[18979] = 0x00014c5c24a46ac5UL;
   tf->codes[18980] = 0x00014c5ee358b001UL;
   tf->codes[18981] = 0x00014c800e5af496UL;
   tf->codes[18982] = 0x00014d3747dc01fbUL;
   tf->codes[18983] = 0x00014d45eb9d733bUL;
   tf->codes[18984] = 0x00014d7f55d81b62UL;
   tf->codes[18985] = 0x00014db0f913ff5fUL;
   tf->codes[18986] = 0x00014dbc2e741a14UL;
   tf->codes[18987] = 0x00014dea28bfa1c1UL;
   tf->codes[18988] = 0x00014e0476ff3940UL;
   tf->codes[18989] = 0x00014e3da6aadba2UL;
   tf->codes[18990] = 0x00014e4f43af97e3UL;
   tf->codes[18991] = 0x00014e56d01f5648UL;
   tf->codes[18992] = 0x00014edf5fa7cab1UL;
   tf->codes[18993] = 0x00014f0f2e6b8086UL;
   tf->codes[18994] = 0x00014f1227aecb87UL;
   tf->codes[18995] = 0x00014f1c72d2cf28UL;
   tf->codes[18996] = 0x00014f5ec8d75852UL;
   tf->codes[18997] = 0x00014fe0f0bb2b2fUL;
   tf->codes[18998] = 0x0001502e7c1fcf0eUL;
   tf->codes[18999] = 0x0001507c421378b2UL;
   tf->codes[19000] = 0x000150c62487c041UL;
   tf->codes[19001] = 0x000151184318d784UL;
   tf->codes[19002] = 0x000151a5daebcadbUL;
   tf->codes[19003] = 0x000151b47ead3c1bUL;
   tf->codes[19004] = 0x000151e4c28efd7aUL;
   tf->codes[19005] = 0x000152637c1179ccUL;
   tf->codes[19006] = 0x000152730a0f0220UL;
   tf->codes[19007] = 0x0001527b462bd1d4UL;
   tf->codes[19008] = 0x000152908c20ea65UL;
   tf->codes[19009] = 0x000152b1f1b234bfUL;
   tf->codes[19010] = 0x000152b560138b4aUL;
   tf->codes[19011] = 0x000152c05ae4a03aUL;
   tf->codes[19012] = 0x000152c6fd18478bUL;
   tf->codes[19013] = 0x00015373eb75514fUL;
   tf->codes[19014] = 0x000153c6f4427fa6UL;
   tf->codes[19015] = 0x000153c8539ca244UL;
   tf->codes[19016] = 0x000153df337ae338UL;
   tf->codes[19017] = 0x000154527d0e3f10UL;
   tf->codes[19018] = 0x0001545a440d033aUL;
   tf->codes[19019] = 0x000154862f5156faUL;
   tf->codes[19020] = 0x000154c1a893330eUL;
   tf->codes[19021] = 0x0001551d629b3ca3UL;
   tf->codes[19022] = 0x0001553cf3b458d5UL;
   tf->codes[19023] = 0x0001554863a3794fUL;
   tf->codes[19024] = 0x000155540e219f8eUL;
   tf->codes[19025] = 0x000155c2ff178dc7UL;
   tf->codes[19026] = 0x000155d5fb766ca6UL;
   tf->codes[19027] = 0x0001563b166662c8UL;
   tf->codes[19028] = 0x0001566776c8c212UL;
   tf->codes[19029] = 0x00015677ef02617aUL;
   tf->codes[19030] = 0x000156cccc47bdf9UL;
   tf->codes[19031] = 0x000156ea4e59a63eUL;
   tf->codes[19032] = 0x000157bf09ec9be8UL;
   tf->codes[19033] = 0x000157e4c81b53e1UL;
   tf->codes[19034] = 0x0001587ef4a8848bUL;
   tf->codes[19035] = 0x000158c394434767UL;
   tf->codes[19036] = 0x000159dbcaa5e314UL;
   tf->codes[19037] = 0x000159dc3fc3ee9eUL;
   tf->codes[19038] = 0x000159ff79cd6720UL;
   tf->codes[19039] = 0x00015a52f7b8a101UL;
   tf->codes[19040] = 0x00015a9463811317UL;
   tf->codes[19041] = 0x00015a9722355853UL;
   tf->codes[19042] = 0x00015ac93a8f47daUL;
   tf->codes[19043] = 0x00015ae597d61346UL;
   tf->codes[19044] = 0x00015ae647832495UL;
   tf->codes[19045] = 0x00015b611d863ed2UL;
   tf->codes[19046] = 0x00015b9f557c6022UL;
   tf->codes[19047] = 0x00015bb84461d503UL;
   tf->codes[19048] = 0x00015c74862d6156UL;
   tf->codes[19049] = 0x00015cc0b237e297UL;
   tf->codes[19050] = 0x00015cf5fe6422e4UL;
   tf->codes[19051] = 0x00015cfb413da797UL;
   tf->codes[19052] = 0x00015d49f16d684fUL;
   tf->codes[19053] = 0x00015da53657665aUL;
   tf->codes[19054] = 0x00015daaee4ef697UL;
   tf->codes[19055] = 0x00015db11b64925eUL;
   tf->codes[19056] = 0x00015dfbe814f101UL;
   tf->codes[19057] = 0x00015dff1be741c7UL;
   tf->codes[19058] = 0x00015e042431c0b5UL;
   tf->codes[19059] = 0x00015e5a9b604597UL;
   tf->codes[19060] = 0x00015e98d35666e7UL;
   tf->codes[19061] = 0x00015eb5a5bb3dddUL;
   tf->codes[19062] = 0x00015ec8678b16f7UL;
   tf->codes[19063] = 0x00015ed536d45a0fUL;
   tf->codes[19064] = 0x00015f25465e3d65UL;
   tf->codes[19065] = 0x00015f3c263c7e59UL;
   tf->codes[19066] = 0x00015f5c6702abdaUL;
   tf->codes[19067] = 0x00015fa3ffe0b9b7UL;
   tf->codes[19068] = 0x0001605dbd870693UL;
   tf->codes[19069] = 0x00016101106d1e05UL;
   tf->codes[19070] = 0x0001618a4fa2a3bdUL;
   tf->codes[19071] = 0x000161a379171e63UL;
   tf->codes[19072] = 0x000161c58e557a0cUL;
   tf->codes[19073] = 0x000161e1767e39eeUL;
   tf->codes[19074] = 0x0001620400daa121UL;
   tf->codes[19075] = 0x00016207e45a0336UL;
   tf->codes[19076] = 0x000162285faf367cUL;
   tf->codes[19077] = 0x000162a3e55f6208UL;
   tf->codes[19078] = 0x000162b21402c7beUL;
   tf->codes[19079] = 0x000162d30476068eUL;
   tf->codes[19080] = 0x000162edc7d3a997UL;
   tf->codes[19081] = 0x0001631ad7e31a30UL;
   tf->codes[19082] = 0x0001634020f3c69fUL;
   tf->codes[19083] = 0x000163a208116bfbUL;
   tf->codes[19084] = 0x000163abde176412UL;
   tf->codes[19085] = 0x000163e2febbd287UL;
   tf->codes[19086] = 0x00016403ef2f1157UL;
   tf->codes[19087] = 0x0001643b4a628591UL;
   tf->codes[19088] = 0x0001643fa2fff330UL;
   tf->codes[19089] = 0x000164643c638e50UL;
   tf->codes[19090] = 0x000164710bacd168UL;
   tf->codes[19091] = 0x000164d6d649d8d9UL;
   tf->codes[19092] = 0x000164eb3202da56UL;
   tf->codes[19093] = 0x000164ed410a0e43UL;
   tf->codes[19094] = 0x000165180783452aUL;
   tf->codes[19095] = 0x00016529a488016bUL;
   tf->codes[19096] = 0x0001656bbffd84d0UL;
   tf->codes[19097] = 0x000165881d44503cUL;
   tf->codes[19098] = 0x0001658907806750UL;
   tf->codes[19099] = 0x00016615056a3244UL;
   tf->codes[19100] = 0x0001661c1cbbe51fUL;
   tf->codes[19101] = 0x0001661f8b1d3baaUL;
   tf->codes[19102] = 0x0001662a10d04510UL;
   tf->codes[19103] = 0x000166371aa88dedUL;
   tf->codes[19104] = 0x0001665f5cfc855dUL;
   tf->codes[19105] = 0x00016661a692bf0fUL;
   tf->codes[19106] = 0x00016672595b643cUL;
   tf->codes[19107] = 0x000166d3cb5afe0eUL;
   tf->codes[19108] = 0x000166ee54299b52UL;
   tf->codes[19109] = 0x000166fda7981de1UL;
   tf->codes[19110] = 0x0001676afea4e3b7UL;
   tf->codes[19111] = 0x000167beb71f235dUL;
   tf->codes[19112] = 0x000167c08b975185UL;
   tf->codes[19113] = 0x0001684f82c4677aUL;
   tf->codes[19114] = 0x00016854c59dec2dUL;
   tf->codes[19115] = 0x000168ead41cb4fdUL;
   tf->codes[19116] = 0x000168f6f3b8e6c6UL;
   tf->codes[19117] = 0x0001691141f87e45UL;
   tf->codes[19118] = 0x0001693ae3a69853UL;
   tf->codes[19119] = 0x000169c45d6b23d0UL;
   tf->codes[19120] = 0x00016a3dd4141b6fUL;
   tf->codes[19121] = 0x00016a43c69ab171UL;
   tf->codes[19122] = 0x00016a5c7af1208dUL;
   tf->codes[19123] = 0x00016ac5ee7e844eUL;
   tf->codes[19124] = 0x00016ae92887fcd0UL;
   tf->codes[19125] = 0x00016afee39b20ebUL;
   tf->codes[19126] = 0x00016b242cabcd5aUL;
   tf->codes[19127] = 0x00016b488b8062b5UL;
   tf->codes[19128] = 0x00016c0f52fef86eUL;
   tf->codes[19129] = 0x00016c421b05f944UL;
   tf->codes[19130] = 0x00016c5f9d17e189UL;
   tf->codes[19131] = 0x00016c997c70953aUL;
   tf->codes[19132] = 0x00016ca059334250UL;
   tf->codes[19133] = 0x00016cbfea4c5e82UL;
   tf->codes[19134] = 0x00016d2ba76ffbf5UL;
   tf->codes[19135] = 0x00016d2e2b953b6cUL;
   tf->codes[19136] = 0x00016d2fc57e63cfUL;
   tf->codes[19137] = 0x00016d57582549f0UL;
   tf->codes[19138] = 0x00016d9ef10357cdUL;
   tf->codes[19139] = 0x00016dde88539bbbUL;
   tf->codes[19140] = 0x00016dfddeddb228UL;
   tf->codes[19141] = 0x00016e2de8306dc2UL;
   tf->codes[19142] = 0x00016e2e22bf7387UL;
   tf->codes[19143] = 0x00016e7d829c458eUL;
   tf->codes[19144] = 0x00016ebe3eb7a655UL;
   tf->codes[19145] = 0x00016edd2023b138UL;
   tf->codes[19146] = 0x00016f17e9b87bfdUL;
   tf->codes[19147] = 0x00016f22a9fa8b28UL;
   tf->codes[19148] = 0x00016f3f7c5f621eUL;
   tf->codes[19149] = 0x00016f6032439b29UL;
   tf->codes[19150] = 0x00016fc3039d5799UL;
   tf->codes[19151] = 0x00017020ccac951bUL;
   tf->codes[19152] = 0x00017039bb9209fcUL;
   tf->codes[19153] = 0x0001706ae9afe26fUL;
   tf->codes[19154] = 0x000170f428e56827UL;
   tf->codes[19155] = 0x000171063b082ff2UL;
   tf->codes[19156] = 0x000171125aa461bbUL;
   tf->codes[19157] = 0x0001715525c6f66fUL;
   tf->codes[19158] = 0x000172166fdd01b0UL;
   tf->codes[19159] = 0x00017221dfcc222aUL;
   tf->codes[19160] = 0x0001722acb96032dUL;
   tf->codes[19161] = 0x000172396f57746dUL;
   tf->codes[19162] = 0x00017246792fbd4aUL;
   tf->codes[19163] = 0x00017246ee4dc8d4UL;
   tf->codes[19164] = 0x000172c189c1dd4cUL;
   tf->codes[19165] = 0x000173663c02175cUL;
   tf->codes[19166] = 0x000173808a41aedbUL;
   tf->codes[19167] = 0x00017483efcd3d81UL;
   tf->codes[19168] = 0x0001749bf4769b4eUL;
   tf->codes[19169] = 0x00017500252a7a5cUL;
   tf->codes[19170] = 0x0001751ae8881d65UL;
   tf->codes[19171] = 0x0001752399c2f8a3UL;
   tf->codes[19172] = 0x000175880505dd76UL;
   tf->codes[19173] = 0x000175ca5b0a66a0UL;
   tf->codes[19174] = 0x000175ddcc875109UL;
   tf->codes[19175] = 0x000175e643332682UL;
   tf->codes[19176] = 0x000175f596a1a911UL;
   tf->codes[19177] = 0x000175f7e037e2c3UL;
   tf->codes[19178] = 0x0001768418b0b37cUL;
   tf->codes[19179] = 0x000176b1634f29daUL;
   tf->codes[19180] = 0x000176b6e0b7b452UL;
   tf->codes[19181] = 0x000176c5bf082b57UL;
   tf->codes[19182] = 0x000176d12ef74bd1UL;
   tf->codes[19183] = 0x000176d3788d8583UL;
   tf->codes[19184] = 0x000176e799b7813bUL;
   tf->codes[19185] = 0x000176fb8052772eUL;
   tf->codes[19186] = 0x0001770a2413e86eUL;
   tf->codes[19187] = 0x0001771e7fcce9ebUL;
   tf->codes[19188] = 0x000177839abce00dUL;
   tf->codes[19189] = 0x00017797f675e18aUL;
   tf->codes[19190] = 0x000177f9dd9386e6UL;
   tf->codes[19191] = 0x00017815509e3b3eUL;
   tf->codes[19192] = 0x00017828fcaa2b6cUL;
   tf->codes[19193] = 0x00017839ea01d65eUL;
   tf->codes[19194] = 0x000178a8a068bed2UL;
   tf->codes[19195] = 0x00017901612d7d66UL;
   tf->codes[19196] = 0x00017934d8e18f8bUL;
   tf->codes[19197] = 0x000179542f6ba5f8UL;
   tf->codes[19198] = 0x0001797b12657acaUL;
   tf->codes[19199] = 0x000179a89792f6edUL;
   tf->codes[19200] = 0x000179c703e0f646UL;
   tf->codes[19201] = 0x000179d7b6a99b73UL;
   tf->codes[19202] = 0x000179fcffba47e2UL;
   tf->codes[19203] = 0x00017a549bb3e99dUL;
   tf->codes[19204] = 0x00017a5a8e3a7f9fUL;
   tf->codes[19205] = 0x00017a65fe29a019UL;
   tf->codes[19206] = 0x00017a78bff97933UL;
   tf->codes[19207] = 0x00017a8bbc585812UL;
   tf->codes[19208] = 0x00017ab906f6ce70UL;
   tf->codes[19209] = 0x00017b0114f2e7d7UL;
   tf->codes[19210] = 0x00017b04bde34427UL;
   tf->codes[19211] = 0x00017b056d905576UL;
   tf->codes[19212] = 0x00017b082c449ab2UL;
   tf->codes[19213] = 0x00017b7a167dd3ecUL;
   tf->codes[19214] = 0x00017b80b8b17b3dUL;
   tf->codes[19215] = 0x00017b980dadc7bbUL;
   tf->codes[19216] = 0x00017ba7d63a55d4UL;
   tf->codes[19217] = 0x00017bad53a2e04cUL;
   tf->codes[19218] = 0x00017bb380b87c13UL;
   tf->codes[19219] = 0x00017c094839efa6UL;
   tf->codes[19220] = 0x00017c16178332beUL;
   tf->codes[19221] = 0x00017c3e94662ff3UL;
   tf->codes[19222] = 0x00017c4e5cf2be0cUL;
   tf->codes[19223] = 0x00017c58a816c1adUL;
   tf->codes[19224] = 0x00017c862d443dd0UL;
   tf->codes[19225] = 0x00017cbf2260da6dUL;
   tf->codes[19226] = 0x00017d67f2af7c57UL;
   tf->codes[19227] = 0x00017df75efa9dd6UL;
   tf->codes[19228] = 0x00017e3596f0bf26UL;
   tf->codes[19229] = 0x00017e64b60763acUL;
   tf->codes[19230] = 0x00017eb5ea5c63dbUL;
   tf->codes[19231] = 0x00017f2849b3a89fUL;
   tf->codes[19232] = 0x00017f81f4b47e47UL;
   tf->codes[19233] = 0x00017f89f6424836UL;
   tf->codes[19234] = 0x00017fe4c60e3ab7UL;
   tf->codes[19235] = 0x000180015de40be8UL;
   tf->codes[19236] = 0x0001805b4373e755UL;
   tf->codes[19237] = 0x000180a76f7e6896UL;
   tf->codes[19238] = 0x000180c566ae5c65UL;
   tf->codes[19239] = 0x000180f11763aa60UL;
   tf->codes[19240] = 0x0001813c1ea30ec8UL;
   tf->codes[19241] = 0x00018156e200b1d1UL;
   tf->codes[19242] = 0x00018193800daabeUL;
   tf->codes[19243] = 0x000181a6f18a9527UL;
   tf->codes[19244] = 0x000181ab4a2802c6UL;
   tf->codes[19245] = 0x000181ac346419daUL;
   tf->codes[19246] = 0x000181de4cbe0961UL;
   tf->codes[19247] = 0x000181f2a8770adeUL;
   tf->codes[19248] = 0x0001829720283f29UL;
   tf->codes[19249] = 0x00018299dedc8465UL;
   tf->codes[19250] = 0x000182e9042a50a7UL;
   tf->codes[19251] = 0x00018354c14dee1aUL;
   tf->codes[19252] = 0x000184aa456a9403UL;
   tf->codes[19253] = 0x000184c6682259aaUL;
   tf->codes[19254] = 0x000184f0f40c8accUL;
   tf->codes[19255] = 0x00018504daa780bfUL;
   tf->codes[19256] = 0x0001850a1d810572UL;
   tf->codes[19257] = 0x00018525cb1abf8fUL;
   tf->codes[19258] = 0x0001857f00fd89adUL;
   tf->codes[19259] = 0x000185e839fbe7a9UL;
   tf->codes[19260] = 0x000185fc95b4e926UL;
   tf->codes[19261] = 0x000186042224a78bUL;
   tf->codes[19262] = 0x00018607cb1503dbUL;
   tf->codes[19263] = 0x0001860d0dee888eUL;
   tf->codes[19264] = 0x0001862b3fad8222UL;
   tf->codes[19265] = 0x0001865e07b482f8UL;
   tf->codes[19266] = 0x0001868bc77104e0UL;
   tf->codes[19267] = 0x000186d0670bc7bcUL;
   tf->codes[19268] = 0x00018723e4f7019dUL;
   tf->codes[19269] = 0x00018726a3ab46d9UL;
   tf->codes[19270] = 0x0001873c5ebe6af4UL;
   tf->codes[19271] = 0x000187492e07ae0cUL;
   tf->codes[19272] = 0x000187b943c8b91eUL;
   tf->codes[19273] = 0x000187d26d3d33c4UL;
   tf->codes[19274] = 0x000188098de1a239UL;
   tf->codes[19275] = 0x00018822b7561cdfUL;
   tf->codes[19276] = 0x0001888881f32450UL;
   tf->codes[19277] = 0x000188e2dca10b47UL;
   tf->codes[19278] = 0x000188fb1bd96ed9UL;
   tf->codes[19279] = 0x000189444ea0a519UL;
   tf->codes[19280] = 0x000189c58c4860e2UL;
   tf->codes[19281] = 0x00018a00cafb3731UL;
   tf->codes[19282] = 0x00018a0b50ae4097UL;
   tf->codes[19283] = 0x00018a2bcc0373ddUL;
   tf->codes[19284] = 0x00018a4445cadd34UL;
   tf->codes[19285] = 0x00018a948fe3c64fUL;
   tf->codes[19286] = 0x00018abb72dd9b21UL;
   tf->codes[19287] = 0x00018abfcb7b08c0UL;
   tf->codes[19288] = 0x00018acdfa1e6e76UL;
   tf->codes[19289] = 0x00018adc28c1d42cUL;
   tf->codes[19290] = 0x00018ae673e5d7cdUL;
   tf->codes[19291] = 0x00018b0a982b6763UL;
   tf->codes[19292] = 0x00018b1bfaa11ddfUL;
   tf->codes[19293] = 0x00018b39f1d111aeUL;
   tf->codes[19294] = 0x00018b410922c489UL;
   tf->codes[19295] = 0x00018b7b98288989UL;
   tf->codes[19296] = 0x00018b95714a157eUL;
   tf->codes[19297] = 0x00018bb2091fe6afUL;
   tf->codes[19298] = 0x00018bff59f584c9UL;
   tf->codes[19299] = 0x00018c0beeafc21cUL;
   tf->codes[19300] = 0x00018c1340907abcUL;
   tf->codes[19301] = 0x00018c2761ba7674UL;
   tf->codes[19302] = 0x00018c2f9dd74628UL;
   tf->codes[19303] = 0x00018c3c3291837bUL;
   tf->codes[19304] = 0x00018c5053bb7f33UL;
   tf->codes[19305] = 0x00018c55d12409abUL;
   tf->codes[19306] = 0x00018c989c469e5fUL;
   tf->codes[19307] = 0x00018cb708949db8UL;
   tf->codes[19308] = 0x00018ce53d6f2b2aUL;
   tf->codes[19309] = 0x00018d0a4bf0d1d4UL;
   tf->codes[19310] = 0x00018d0a867fd799UL;
   tf->codes[19311] = 0x00018db1f77456e5UL;
   tf->codes[19312] = 0x00018dd705f5fd8fUL;
   tf->codes[19313] = 0x00018de4bf7b57bbUL;
   tf->codes[19314] = 0x00018eabc188f339UL;
   tf->codes[19315] = 0x00018f41d007bc09UL;
   tf->codes[19316] = 0x00018f50393a2784UL;
   tf->codes[19317] = 0x00018f562bc0bd86UL;
   tf->codes[19318] = 0x00018fb812de62e2UL;
   tf->codes[19319] = 0x00019013925766b2UL;
   tf->codes[19320] = 0x0001902fef9e321eUL;
   tf->codes[19321] = 0x000190b461183eadUL;
   tf->codes[19322] = 0x000190f93b42074eUL;
   tf->codes[19323] = 0x0001911264b681f4UL;
   tf->codes[19324] = 0x0001911adb62576dUL;
   tf->codes[19325] = 0x0001912ade7deb4bUL;
   tf->codes[19326] = 0x0001913613de0600UL;
   tf->codes[19327] = 0x0001913a31ec6ddaUL;
   tf->codes[19328] = 0x000191a196729daeUL;
   tf->codes[19329] = 0x00019283214ed670UL;
   tf->codes[19330] = 0x0001928864285b23UL;
   tf->codes[19331] = 0x0001928a38a0894bUL;
   tf->codes[19332] = 0x00019293d4177b9dUL;
   tf->codes[19333] = 0x000192a620c9492dUL;
   tf->codes[19334] = 0x000192f83f5a6070UL;
   tf->codes[19335] = 0x00019319a4ebaacaUL;
   tf->codes[19336] = 0x000193688faa7147UL;
   tf->codes[19337] = 0x000193a617f38148UL;
   tf->codes[19338] = 0x000193aae5aefa71UL;
   tf->codes[19339] = 0x000193c82d31dcf1UL;
   tf->codes[19340] = 0x000193d27855e092UL;
   tf->codes[19341] = 0x000193e4155a9cd3UL;
   tf->codes[19342] = 0x000193ef4abab788UL;
   tf->codes[19343] = 0x0001941a4bc2f434UL;
   tf->codes[19344] = 0x00019425f6411a73UL;
   tf->codes[19345] = 0x000194655302589cUL;
   tf->codes[19346] = 0x000194663d3e6fb0UL;
   tf->codes[19347] = 0x0001946b8017f463UL;
   tf->codes[19348] = 0x000194a106d33a75UL;
   tf->codes[19349] = 0x000194a475349100UL;
   tf->codes[19350] = 0x000194a4afc396c5UL;
   tf->codes[19351] = 0x000194d568c363aeUL;
   tf->codes[19352] = 0x000195663468a7cbUL;
   tf->codes[19353] = 0x000195de86468291UL;
   tf->codes[19354] = 0x000195fe8c7daa4dUL;
   tf->codes[19355] = 0x0001963c4f55c013UL;
   tf->codes[19356] = 0x00019721f84060afUL;
   tf->codes[19357] = 0x000197240747949cUL;
   tf->codes[19358] = 0x00019735dedb56a2UL;
   tf->codes[19359] = 0x0001974ecdc0cb83UL;
   tf->codes[19360] = 0x000197665d4c1dc6UL;
   tf->codes[19361] = 0x000197778532ce7dUL;
   tf->codes[19362] = 0x000197b0b4de70dfUL;
   tf->codes[19363] = 0x000197fc6bcae696UL;
   tf->codes[19364] = 0x00019807a12b014bUL;
   tf->codes[19365] = 0x00019866c994616bUL;
   tf->codes[19366] = 0x00019895e8ab05f1UL;
   tf->codes[19367] = 0x000198a1cdb831f5UL;
   tf->codes[19368] = 0x000198ddf6a71f58UL;
   tf->codes[19369] = 0x000199046482e8a0UL;
   tf->codes[19370] = 0x0001993eb8f9a7dbUL;
   tf->codes[19371] = 0x00019965616476e8UL;
   tf->codes[19372] = 0x00019976142d1c15UL;
   tf->codes[19373] = 0x00019a5bf7a6c276UL;
   tf->codes[19374] = 0x00019a97e606aa14UL;
   tf->codes[19375] = 0x00019b5c9e7e0be0UL;
   tf->codes[19376] = 0x00019b8d920cde8eUL;
   tf->codes[19377] = 0x00019bc3c87535efUL;
   tf->codes[19378] = 0x00019bdec661debdUL;
   tf->codes[19379] = 0x00019c01c5dc517aUL;
   tf->codes[19380] = 0x00019c1c4eaaeebeUL;
   tf->codes[19381] = 0x00019c921c638a0dUL;
   tf->codes[19382] = 0x00019c9a1df153fcUL;
   tf->codes[19383] = 0x00019cf6fcc47a6aUL;
   tf->codes[19384] = 0x00019d318bca3f6aUL;
   tf->codes[19385] = 0x00019d47816c694aUL;
   tf->codes[19386] = 0x00019d61cfac00c9UL;
   tf->codes[19387] = 0x00019ddbbb7303f2UL;
   tf->codes[19388] = 0x00019e03fdc6fb62UL;
   tf->codes[19389] = 0x00019e0472e506ecUL;
   tf->codes[19390] = 0x00019e682e7ada70UL;
   tf->codes[19391] = 0x00019e9ffecc5a34UL;
   tf->codes[19392] = 0x00019eb19bd11675UL;
   tf->codes[19393] = 0x00019edb3d7f3083UL;
   tf->codes[19394] = 0x00019f0a2206cf44UL;
   tf->codes[19395] = 0x00019f55294633acUL;
   tf->codes[19396] = 0x00019f602417489cUL;
   tf->codes[19397] = 0x00019f96cf9dab87UL;
   tf->codes[19398] = 0x00019fa65d9b33dbUL;
   tf->codes[19399] = 0x00019fe5453e667aUL;
   tf->codes[19400] = 0x0001a0175d985601UL;
   tf->codes[19401] = 0x0001a02b44334bf4UL;
   tf->codes[19402] = 0x0001a047dc091d25UL;
   tf->codes[19403] = 0x0001a0864e8e443aUL;
   tf->codes[19404] = 0x0001a0d1905cae67UL;
   tf->codes[19405] = 0x0001a0ddea87e5f5UL;
   tf->codes[19406] = 0x0001a0e6d651c6f8UL;
   tf->codes[19407] = 0x0001a1edaa3eac29UL;
   tf->codes[19408] = 0x0001a2078360381eUL;
   tf->codes[19409] = 0x0001a26a8f48fa53UL;
   tf->codes[19410] = 0x0001a281a9b6410cUL;
   tf->codes[19411] = 0x0001a31f0a15c27cUL;
   tf->codes[19412] = 0x0001a3657e28b380UL;
   tf->codes[19413] = 0x0001a3b518948b4cUL;
   tf->codes[19414] = 0x0001a41b1dc09882UL;
   tf->codes[19415] = 0x0001a42c80364efeUL;
   tf->codes[19416] = 0x0001a4996225094aUL;
   tf->codes[19417] = 0x0001a4dd1783b512UL;
   tf->codes[19418] = 0x0001a4eb0b981503UL;
   tf->codes[19419] = 0x0001a4f9e9e88c08UL;
   tf->codes[19420] = 0x0001a59b2dc76f8dUL;
   tf->codes[19421] = 0x0001a59e9c28c618UL;
   tf->codes[19422] = 0x0001a5e2518771e0UL;
   tf->codes[19423] = 0x0001a6b538a23962UL;
   tf->codes[19424] = 0x0001a6f2865c439eUL;
   tf->codes[19425] = 0x0001a6f6a46aab78UL;
   tf->codes[19426] = 0x0001a7a47d03cc50UL;
   tf->codes[19427] = 0x0001a7a52cb0dd9fUL;
   tf->codes[19428] = 0x0001a7c40e1ce882UL;
   tf->codes[19429] = 0x0001a80c1c1901e9UL;
   tf->codes[19430] = 0x0001a8337430e245UL;
   tf->codes[19431] = 0x0001a8d910ad3369UL;
   tf->codes[19432] = 0x0001a8e40b7e4859UL;
   tf->codes[19433] = 0x0001a960f0889683UL;
   tf->codes[19434] = 0x0001a9c4ac1e6a07UL;
   tf->codes[19435] = 0x0001aa4af210a4beUL;
   tf->codes[19436] = 0x0001aa65b56e47c7UL;
   tf->codes[19437] = 0x0001ab88ac12f29fUL;
   tf->codes[19438] = 0x0001aba9d7153734UL;
   tf->codes[19439] = 0x0001abd1a44b231aUL;
   tf->codes[19440] = 0x0001abfe04ad8264UL;
   tf->codes[19441] = 0x0001ac67b2c9ebeaUL;
   tf->codes[19442] = 0x0001ac9572866dd2UL;
   tf->codes[19443] = 0x0001acb3a4456766UL;
   tf->codes[19444] = 0x0001acd41f9a9aacUL;
   tf->codes[19445] = 0x0001acdbac0a5911UL;
   tf->codes[19446] = 0x0001ad81bda4b5bfUL;
   tf->codes[19447] = 0x0001adb709d0f60cUL;
   tf->codes[19448] = 0x0001adba78324c97UL;
   tf->codes[19449] = 0x0001ae050a53a575UL;
   tf->codes[19450] = 0x0001ae207d5e59cdUL;
   tf->codes[19451] = 0x0001ae42929cb576UL;
   tf->codes[19452] = 0x0001ae45c66f063cUL;
   tf->codes[19453] = 0x0001aebec7f9f251UL;
   tf->codes[19454] = 0x0001aec56a2d99a2UL;
   tf->codes[19455] = 0x0001af5b78ac6272UL;
   tf->codes[19456] = 0x0001afcb194f61faUL;
   tf->codes[19457] = 0x0001afe9859d6153UL;
   tf->codes[19458] = 0x0001b0018a46bf20UL;
   tf->codes[19459] = 0x0001b0056dc62135UL;
   tf->codes[19460] = 0x0001b0df31a395cdUL;
   tf->codes[19461] = 0x0001b16e9deeb74cUL;
   tf->codes[19462] = 0x0001b18db9e9c7f4UL;
   tf->codes[19463] = 0x0001b1bd138f723fUL;
   tf->codes[19464] = 0x0001b1d5c7e5e15bUL;
   tf->codes[19465] = 0x0001b1deb3afc25eUL;
   tf->codes[19466] = 0x0001b1e764ea9d9cUL;
   tf->codes[19467] = 0x0001b21684014222UL;
   tf->codes[19468] = 0x0001b25b239c04feUL;
   tf->codes[19469] = 0x0001b2a6da887ab5UL;
   tf->codes[19470] = 0x0001b2af5134502eUL;
   tf->codes[19471] = 0x0001b315cb7e68eeUL;
   tf->codes[19472] = 0x0001b32b4c028744UL;
   tf->codes[19473] = 0x0001b3977e443041UL;
   tf->codes[19474] = 0x0001b3a7815fc41fUL;
   tf->codes[19475] = 0x0001b3ba432f9d39UL;
   tf->codes[19476] = 0x0001b3dc1ddef31dUL;
   tf->codes[19477] = 0x0001b3f3e7f94b25UL;
   tf->codes[19478] = 0x0001b403b085d93eUL;
   tf->codes[19479] = 0x0001b426ea8f51c0UL;
   tf->codes[19480] = 0x0001b4634e0d44e8UL;
   tf->codes[19481] = 0x0001b51878871e60UL;
   tf->codes[19482] = 0x0001b55cdd92db77UL;
   tf->codes[19483] = 0x0001b5b0d09c20e2UL;
   tf->codes[19484] = 0x0001b686eb89392aUL;
   tf->codes[19485] = 0x0001b69c6c0d5780UL;
   tf->codes[19486] = 0x0001b6dced99b282UL;
   tf->codes[19487] = 0x0001b775f55bc653UL;
   tf->codes[19488] = 0x0001b782ff340f30UL;
   tf->codes[19489] = 0x0001b7866d9565bbUL;
   tf->codes[19490] = 0x0001b7ba94f6892fUL;
   tf->codes[19491] = 0x0001b7be3de6e57fUL;
   tf->codes[19492] = 0x0001b7cb47bf2e5cUL;
   tf->codes[19493] = 0x0001b7f857ce9ef5UL;
   tf->codes[19494] = 0x0001b809452649e7UL;
   tf->codes[19495] = 0x0001b84c4ad7e460UL;
   tf->codes[19496] = 0x0001b8670e358769UL;
   tf->codes[19497] = 0x0001b88505657b38UL;
   tf->codes[19498] = 0x0001b8a2c2066942UL;
   tf->codes[19499] = 0x0001b8e1348b9057UL;
   tf->codes[19500] = 0x0001b90a9baaa4a0UL;
   tf->codes[19501] = 0x0001b9243a3d2ad0UL;
   tf->codes[19502] = 0x0001b9d5bbc6a7f8UL;
   tf->codes[19503] = 0x0001b9e4d4a624c2UL;
   tf->codes[19504] = 0x0001bb246320a0cbUL;
   tf->codes[19505] = 0x0001bb7bff1a4286UL;
   tf->codes[19506] = 0x0001bb98d17f197cUL;
   tf->codes[19507] = 0x0001bbc82b24c3c7UL;
   tf->codes[19508] = 0x0001bbd868cf5d6aUL;
   tf->codes[19509] = 0x0001bc20b15a7c96UL;
   tf->codes[19510] = 0x0001bc6bb899e0feUL;
   tf->codes[19511] = 0x0001bca3c37a6687UL;
   tf->codes[19512] = 0x0001bca4732777d6UL;
   tf->codes[19513] = 0x0001bcf482b15b2cUL;
   tf->codes[19514] = 0x0001bcfbd49213ccUL;
   tf->codes[19515] = 0x0001bd0bd7ada7aaUL;
   tf->codes[19516] = 0x0001bd4507594a0cUL;
   tf->codes[19517] = 0x0001bd7d8757db1fUL;
   tf->codes[19518] = 0x0001bd9d52fffd16UL;
   tf->codes[19519] = 0x0001bdaf9fb1caa6UL;
   tf->codes[19520] = 0x0001be474819bbd9UL;
   tf->codes[19521] = 0x0001be6713c1ddd0UL;
   tf->codes[19522] = 0x0001bec16e6fc4c7UL;
   tf->codes[19523] = 0x0001becc6940d9b7UL;
   tf->codes[19524] = 0x0001bf1c78cabd0dUL;
   tf->codes[19525] = 0x0001bf382664772aUL;
   tf->codes[19526] = 0x0001bff602192be0UL;
   tf->codes[19527] = 0x0001c0229d0a90efUL;
   tf->codes[19528] = 0x0001c0355eda6a09UL;
   tf->codes[19529] = 0x0001c15596cacfa5UL;
   tf->codes[19530] = 0x0001c179bb105f3bUL;
   tf->codes[19531] = 0x0001c1a914b60986UL;
   tf->codes[19532] = 0x0001c1c74675031aUL;
   tf->codes[19533] = 0x0001c1dab7f1ed83UL;
   tf->codes[19534] = 0x0001c206a3364143UL;
   tf->codes[19535] = 0x0001c25d1a64c625UL;
   tf->codes[19536] = 0x0001c27d95b9f96bUL;
   tf->codes[19537] = 0x0001c302f1701d0eUL;
   tf->codes[19538] = 0x0001c31d3fafb48dUL;
   tf->codes[19539] = 0x0001c33962677a34UL;
   tf->codes[19540] = 0x0001c33d8075e20eUL;
   tf->codes[19541] = 0x0001c3b08f7a3821UL;
   tf->codes[19542] = 0x0001c411173dbadfUL;
   tf->codes[19543] = 0x0001c4445462c73fUL;
   tf->codes[19544] = 0x0001c4469df900f1UL;
   tf->codes[19545] = 0x0001c44f14a4d66aUL;
   tf->codes[19546] = 0x0001c47756f8cddaUL;
   tf->codes[19547] = 0x0001c477cc16d964UL;
   tf->codes[19548] = 0x0001c49a56734097UL;
   tf->codes[19549] = 0x0001c4c7dba0bcbaUL;
   tf->codes[19550] = 0x0001c4dd2195d54bUL;
   tf->codes[19551] = 0x0001c4e2d98d6588UL;
   tf->codes[19552] = 0x0001c542ec32dcbcUL;
   tf->codes[19553] = 0x0001c544fb3a10a9UL;
   tf->codes[19554] = 0x0001c550a5b836e8UL;
   tf->codes[19555] = 0x0001c55f4979a828UL;
   tf->codes[19556] = 0x0001c5f816acb634UL;
   tf->codes[19557] = 0x0001c6468c4d7127UL;
   tf->codes[19558] = 0x0001c64bcf26f5daUL;
   tf->codes[19559] = 0x0001c680e0c43062UL;
   tf->codes[19560] = 0x0001c6f37aaa7aebUL;
   tf->codes[19561] = 0x0001c72b858b0074UL;
   tf->codes[19562] = 0x0001c750ce9bace3UL;
   tf->codes[19563] = 0x0001c7b78374cb68UL;
   tf->codes[19564] = 0x0001c7bd75fb616aUL;
   tf->codes[19565] = 0x0001c7c3a310fd31UL;
   tf->codes[19566] = 0x0001c7cf881e2935UL;
   tf->codes[19567] = 0x0001c7d455d9a25eUL;
   tf->codes[19568] = 0x0001c7de2bdf9a75UL;
   tf->codes[19569] = 0x0001c8484f1a0f85UL;
   tf->codes[19570] = 0x0001c886fc2e3c5fUL;
   tf->codes[19571] = 0x0001c8a94bfb9dcdUL;
   tf->codes[19572] = 0x0001c8b3d1aea733UL;
   tf->codes[19573] = 0x0001c8e241183a6aUL;
   tf->codes[19574] = 0x0001c8ea7d350a1eUL;
   tf->codes[19575] = 0x0001c90fc645b68dUL;
   tf->codes[19576] = 0x0001c9124a6af604UL;
   tf->codes[19577] = 0x0001c91334a70d18UL;
   tf->codes[19578] = 0x0001c95e76757745UL;
   tf->codes[19579] = 0x0001c976f03ce09cUL;
   tf->codes[19580] = 0x0001c985ce8d57a1UL;
   tf->codes[19581] = 0x0001c9cae3462607UL;
   tf->codes[19582] = 0x0001c9e7b5aafcfdUL;
   tf->codes[19583] = 0x0001caab83e647b5UL;
   tf->codes[19584] = 0x0001caf391e2611cUL;
   tf->codes[19585] = 0x0001cb08d7d779adUL;
   tf->codes[19586] = 0x0001cb2b6233e0e0UL;
   tf->codes[19587] = 0x0001cb73702ffa47UL;
   tf->codes[19588] = 0x0001cbb7d53bb75eUL;
   tf->codes[19589] = 0x0001cbc763393fb2UL;
   tf->codes[19590] = 0x0001cbe6b9c3561fUL;
   tf->codes[19591] = 0x0001cc03c6b732daUL;
   tf->codes[19592] = 0x0001cc54fb0c3309UL;
   tf->codes[19593] = 0x0001cc644e7ab598UL;
   tf->codes[19594] = 0x0001cd1854297237UL;
   tf->codes[19595] = 0x0001cd1cacc6dfd6UL;
   tf->codes[19596] = 0x0001cd1dd191fcafUL;
   tf->codes[19597] = 0x0001cd4f3a3edae7UL;
   tf->codes[19598] = 0x0001cdd8ee926c29UL;
   tf->codes[19599] = 0x0001cde28a095e7bUL;
   tf->codes[19600] = 0x0001cdfd87f60749UL;
   tf->codes[19601] = 0x0001ce3fa36b8aaeUL;
   tf->codes[19602] = 0x0001ce759f44dc4aUL;
   tf->codes[19603] = 0x0001cec4c492a88cUL;
   tf->codes[19604] = 0x0001cec623eccb2aUL;
   tf->codes[19605] = 0x0001cec6990ad6b4UL;
   tf->codes[19606] = 0x0001cedb69e1e3bbUL;
   tf->codes[19607] = 0x0001cf22c830ebd3UL;
   tf->codes[19608] = 0x0001cf64a9176973UL;
   tf->codes[19609] = 0x0001cf7bfe13b5f1UL;
   tf->codes[19610] = 0x0001cfe23dcec8ecUL;
   tf->codes[19611] = 0x0001cff2f0976e19UL;
   tf->codes[19612] = 0x0001d03964aa5f1dUL;
   tf->codes[19613] = 0x0001d045f9649c70UL;
   tf->codes[19614] = 0x0001d063b6058a7aUL;
   tf->codes[19615] = 0x0001d076b2646959UL;
   tf->codes[19616] = 0x0001d08605d2ebe8UL;
   tf->codes[19617] = 0x0001d09c36041b8dUL;
   tf->codes[19618] = 0x0001d0f2ad32a06fUL;
   tf->codes[19619] = 0x0001d180f4b2a515UL;
   tf->codes[19620] = 0x0001d1be7cfbb516UL;
   tf->codes[19621] = 0x0001d1ec3cb836feUL;
   tf->codes[19622] = 0x0001d24ab57485cfUL;
   tf->codes[19623] = 0x0001d2896288b2a9UL;
   tf->codes[19624] = 0x0001d2bb40539c6bUL;
   tf->codes[19625] = 0x0001d2eb0f175240UL;
   tf->codes[19626] = 0x0001d2f88e0da6a7UL;
   tf->codes[19627] = 0x0001d31efbe96fefUL;
   tf->codes[19628] = 0x0001d31fab96813eUL;
   tf->codes[19629] = 0x0001d35189616b00UL;
   tf->codes[19630] = 0x0001d387bfc9c261UL;
   tf->codes[19631] = 0x0001d39d7adce67cUL;
   tf->codes[19632] = 0x0001d3d426634967UL;
   tf->codes[19633] = 0x0001d415922bbb7dUL;
   tf->codes[19634] = 0x0001d4481fa3b68eUL;
   tf->codes[19635] = 0x0001d44f71846f2eUL;
   tf->codes[19636] = 0x0001d4756a422cecUL;
   tf->codes[19637] = 0x0001d47ecb2a1979UL;
   tf->codes[19638] = 0x0001d4d0749d2532UL;
   tf->codes[19639] = 0x0001d4ff1e95be2eUL;
   tf->codes[19640] = 0x0001d53eb5e6021cUL;
   tf->codes[19641] = 0x0001d5601b774c76UL;
   tf->codes[19642] = 0x0001d5717ded02f2UL;
   tf->codes[19643] = 0x0001d57fac9068a8UL;
   tf->codes[19644] = 0x0001d587738f2cd2UL;
   tf->codes[19645] = 0x0001d5ddb02eabefUL;
   tf->codes[19646] = 0x0001d5f9d2e67196UL;
   tf->codes[19647] = 0x0001d60542d59210UL;
   tf->codes[19648] = 0x0001d612c1cbe677UL;
   tf->codes[19649] = 0x0001d668142f4e80UL;
   tf->codes[19650] = 0x0001d6ac793b0b97UL;
   tf->codes[19651] = 0x0001d6c4b8736f29UL;
   tf->codes[19652] = 0x0001d6d9c3d981f5UL;
   tf->codes[19653] = 0x0001d6da73869344UL;
   tf->codes[19654] = 0x0001d784ddbe5d91UL;
   tf->codes[19655] = 0x0001d7879c72a2cdUL;
   tf->codes[19656] = 0x0001d7eaa85b6502UL;
   tf->codes[19657] = 0x0001d7fbd04215b9UL;
   tf->codes[19658] = 0x0001d824c2431e78UL;
   tf->codes[19659] = 0x0001d82b6476c5c9UL;
   tf->codes[19660] = 0x0001d8a5503dc8f2UL;
   tf->codes[19661] = 0x0001d8a933bd2b07UL;
   tf->codes[19662] = 0x0001d8dbfbc42bddUL;
   tf->codes[19663] = 0x0001d8de455a658fUL;
   tf->codes[19664] = 0x0001d9936fd43f07UL;
   tf->codes[19665] = 0x0001d9a163e89ef8UL;
   tf->codes[19666] = 0x0001d9d8848d0d6dUL;
   tf->codes[19667] = 0x0001d9e971e4b85fUL;
   tf->codes[19668] = 0x0001d9f72b6a128bUL;
   tf->codes[19669] = 0x0001da5e8ff0425fUL;
   tf->codes[19670] = 0x0001da87bc8050e3UL;
   tf->codes[19671] = 0x0001dac7c8eea05bUL;
   tf->codes[19672] = 0x0001dae8b961df2bUL;
   tf->codes[19673] = 0x0001db44e887f44aUL;
   tf->codes[19674] = 0x0001db74f1daafe4UL;
   tf->codes[19675] = 0x0001dbef52bfbe97UL;
   tf->codes[19676] = 0x0001dbf45b0a3d85UL;
   tf->codes[19677] = 0x0001dc1bedb123a6UL;
   tf->codes[19678] = 0x0001dc41abdfdb9fUL;
   tf->codes[19679] = 0x0001dc6e0c423ae9UL;
   tf->codes[19680] = 0x0001dc7941a2559eUL;
   tf->codes[19681] = 0x0001dcab59fc4525UL;
   tf->codes[19682] = 0x0001dcc0656257f1UL;
   tf->codes[19683] = 0x0001dd46e5e3986dUL;
   tf->codes[19684] = 0x0001dd5131079c0eUL;
   tf->codes[19685] = 0x0001dd6b0a292803UL;
   tf->codes[19686] = 0x0001ddf18aaa687fUL;
   tf->codes[19687] = 0x0001de57ca657b7aUL;
   tf->codes[19688] = 0x0001de663397e6f5UL;
   tf->codes[19689] = 0x0001de9468727467UL;
   tf->codes[19690] = 0x0001dec5d11f529fUL;
   tf->codes[19691] = 0x0001defe168eddedUL;
   tf->codes[19692] = 0x0001df0f3e758ea4UL;
   tf->codes[19693] = 0x0001df58e65ad06eUL;
   tf->codes[19694] = 0x0001df695e946fd6UL;
   tf->codes[19695] = 0x0001dfddccf2e887UL;
   tf->codes[19696] = 0x0001dff521ef3505UL;
   tf->codes[19697] = 0x0001e014035b3fe8UL;
   tf->codes[19698] = 0x0001e0c54a55b74bUL;
   tf->codes[19699] = 0x0001e0d8f661a779UL;
   tf->codes[19700] = 0x0001e0f3b9bf4a82UL;
   tf->codes[19701] = 0x0001e1276c02626cUL;
   tf->codes[19702] = 0x0001e133c62d99faUL;
   tf->codes[19703] = 0x0001e13c77687538UL;
   tf->codes[19704] = 0x0001e160d63d0a93UL;
   tf->codes[19705] = 0x0001e187f3c5e52aUL;
   tf->codes[19706] = 0x0001e1c5f12d00b5UL;
   tf->codes[19707] = 0x0001e1ebaf5bb8aeUL;
   tf->codes[19708] = 0x0001e2075cf572cbUL;
   tf->codes[19709] = 0x0001e27ae117d468UL;
   tf->codes[19710] = 0x0001e2e2802d0a01UL;
   tf->codes[19711] = 0x0001e365924cf3f2UL;
   tf->codes[19712] = 0x0001e3e0a2df13f4UL;
   tf->codes[19713] = 0x0001e4471d292cb4UL;
   tf->codes[19714] = 0x0001e4825bdc0303UL;
   tf->codes[19715] = 0x0001e49607e7f331UL;
   tf->codes[19716] = 0x0001e4c3c7a47519UL;
   tf->codes[19717] = 0x0001e4ea35803e61UL;
   tf->codes[19718] = 0x0001e4ef7859c314UL;
   tf->codes[19719] = 0x0001e57c607fa51cUL;
   tf->codes[19720] = 0x0001e5812e3b1e45UL;
   tf->codes[19721] = 0x0001e619fb6e2c51UL;
   tf->codes[19722] = 0x0001e6e17299d359UL;
   tf->codes[19723] = 0x0001e749fbeb2006UL;
   tf->codes[19724] = 0x0001e77d739f322bUL;
   tf->codes[19725] = 0x0001e7886e70471bUL;
   tf->codes[19726] = 0x0001e799d0e5fd97UL;
   tf->codes[19727] = 0x0001e79f13bf824aUL;
   tf->codes[19728] = 0x0001e7e219711cc3UL;
   tf->codes[19729] = 0x0001e86b1e179cb6UL;
   tf->codes[19730] = 0x0001e878d79cf6e2UL;
   tf->codes[19731] = 0x0001e8f19e98dd32UL;
   tf->codes[19732] = 0x0001e929a97962bbUL;
   tf->codes[19733] = 0x0001e937286fb722UL;
   tf->codes[19734] = 0x0001e983c99843edUL;
   tf->codes[19735] = 0x0001ea392ea1232aUL;
   tf->codes[19736] = 0x0001ea54a1abd782UL;
   tf->codes[19737] = 0x0001eabcb5df18a5UL;
   tf->codes[19738] = 0x0001eabddaaa357eUL;
   tf->codes[19739] = 0x0001eb53e928fe4eUL;
   tf->codes[19740] = 0x0001eb66aaf8d768UL;
   tf->codes[19741] = 0x0001eb9729699e8cUL;
   tf->codes[19742] = 0x0001ebb3c13f6fbdUL;
   tf->codes[19743] = 0x0001ebe6c3d57658UL;
   tf->codes[19744] = 0x0001ec132437d5a2UL;
   tf->codes[19745] = 0x0001ec73abfb5860UL;
   tf->codes[19746] = 0x0001eca42a6c1f84UL;
   tf->codes[19747] = 0x0001ecd51dfaf232UL;
   tf->codes[19748] = 0x0001ecf599502578UL;
   tf->codes[19749] = 0x0001ed34bb825ddcUL;
   tf->codes[19750] = 0x0001ed3d6cbd391aUL;
   tf->codes[19751] = 0x0001ed3e1c6a4a69UL;
   tf->codes[19752] = 0x0001ed520305405cUL;
   tf->codes[19753] = 0x0001ed9877183160UL;
   tf->codes[19754] = 0x0001ed9f8e69e43bUL;
   tf->codes[19755] = 0x0001eda546617478UL;
   tf->codes[19756] = 0x0001edadf79c4fb6UL;
   tf->codes[19757] = 0x0001ee4b1d6ccb61UL;
   tf->codes[19758] = 0x0001ef096e3f8ba1UL;
   tf->codes[19759] = 0x0001ef75a081349eUL;
   tf->codes[19760] = 0x0001efa1c6548e23UL;
   tf->codes[19761] = 0x0001efa7f36a29eaUL;
   tf->codes[19762] = 0x0001efbe98b96519UL;
   tf->codes[19763] = 0x0001efc06d319341UL;
   tf->codes[19764] = 0x0001efe2f78dfa74UL;
   tf->codes[19765] = 0x0001f007cb809b59UL;
   tf->codes[19766] = 0x0001f00baefffd6eUL;
   tf->codes[19767] = 0x0001f0154a76efc0UL;
   tf->codes[19768] = 0x0001f04eef409dacUL;
   tf->codes[19769] = 0x0001f05bbe89e0c4UL;
   tf->codes[19770] = 0x0001f09b90692a77UL;
   tf->codes[19771] = 0x0001f0b9127b12bcUL;
   tf->codes[19772] = 0x0001f0ce58702b4dUL;
   tf->codes[19773] = 0x0001f1136d28f9b3UL;
   tf->codes[19774] = 0x0001f1ae49633bacUL;
   tf->codes[19775] = 0x0001f1b0586a6f99UL;
   tf->codes[19776] = 0x0001f222f250ba22UL;
   tf->codes[19777] = 0x0001f24a4a689a7eUL;
   tf->codes[19778] = 0x0001f2b25e9bdba1UL;
   tf->codes[19779] = 0x0001f2bef35618f4UL;
   tf->codes[19780] = 0x0001f399dbfeaa65UL;
   tf->codes[19781] = 0x0001f3af5c82c8bbUL;
   tf->codes[19782] = 0x0001f3cbb9c99427UL;
   tf->codes[19783] = 0x0001f40bc637e39fUL;
   tf->codes[19784] = 0x0001f43da402cd61UL;
   tf->codes[19785] = 0x0001f467f55df8beUL;
   tf->codes[19786] = 0x0001f47a420fc64eUL;
   tf->codes[19787] = 0x0001f4a99bb57099UL;
   tf->codes[19788] = 0x0001f4ba890d1b8bUL;
   tf->codes[19789] = 0x0001f500c29106caUL;
   tf->codes[19790] = 0x0001f508feadd67eUL;
   tf->codes[19791] = 0x0001f51a9bb292bfUL;
   tf->codes[19792] = 0x0001f561bf729512UL;
   tf->codes[19793] = 0x0001f594125b8a5eUL;
   tf->codes[19794] = 0x0001f5aa428cba03UL;
   tf->codes[19795] = 0x0001f5c4563d4bbdUL;
   tf->codes[19796] = 0x0001f5d36f1cc887UL;
   tf->codes[19797] = 0x0001f5e2c28b4b16UL;
   tf->codes[19798] = 0x0001f60f980bb5eaUL;
   tf->codes[19799] = 0x0001f62eb406c692UL;
   tf->codes[19800] = 0x0001f63222681d1dUL;
   tf->codes[19801] = 0x0001f63b835009aaUL;
   tf->codes[19802] = 0x0001f67946281f70UL;
   tf->codes[19803] = 0x0001f67a6af33c49UL;
   tf->codes[19804] = 0x0001f6a5316c7330UL;
   tf->codes[19805] = 0x0001f6d27c0ae98eUL;
   tf->codes[19806] = 0x0001f70dbabdbfddUL;
   tf->codes[19807] = 0x0001f7981ebe626eUL;
   tf->codes[19808] = 0x0001f7b47c052ddaUL;
   tf->codes[19809] = 0x0001f7f990bdfc40UL;
   tf->codes[19810] = 0x0001f7fb2aa724a3UL;
   tf->codes[19811] = 0x0001f812f4c17cabUL;
   tf->codes[19812] = 0x0001f83b3715741bUL;
   tf->codes[19813] = 0x0001f83be6c2856aUL;
   tf->codes[19814] = 0x0001f85e368fe6d8UL;
   tf->codes[19815] = 0x0001f8672259c7dbUL;
   tf->codes[19816] = 0x0001f8855418c16fUL;
   tf->codes[19817] = 0x0001f8a88e2239f1UL;
   tf->codes[19818] = 0x0001f8bfe31e866fUL;
   tf->codes[19819] = 0x0001f90aea5dead7UL;
   tf->codes[19820] = 0x0001f927bcc2c1cdUL;
   tf->codes[19821] = 0x0001f93e9ca102c1UL;
   tf->codes[19822] = 0x0001f9453ed4aa12UL;
   tf->codes[19823] = 0x0001f949977217b1UL;
   tf->codes[19824] = 0x0001f95039a5bf02UL;
   tf->codes[19825] = 0x0001f975bd457136UL;
   tf->codes[19826] = 0x0001f9ab0971b183UL;
   tf->codes[19827] = 0x0001f9b972a41cfeUL;
   tf->codes[19828] = 0x0001f9e3fe8e4e20UL;
   tf->codes[19829] = 0x0001f9e9f114e422UL;
   tf->codes[19830] = 0x0001fa1a6f85ab46UL;
   tf->codes[19831] = 0x0001fa27043fe899UL;
   tf->codes[19832] = 0x0001fa32742f0913UL;
   tf->codes[19833] = 0x0001fa68357954eaUL;
   tf->codes[19834] = 0x0001fa769eabc065UL;
   tf->codes[19835] = 0x0001fa787323ee8dUL;
   tf->codes[19836] = 0x0001fab7955626f1UL;
   tf->codes[19837] = 0x0001fae76419dcc6UL;
   tf->codes[19838] = 0x0001fb50d7a74087UL;
   tf->codes[19839] = 0x0001fb67f2148740UL;
   tf->codes[19840] = 0x0001fb6daa0c177dUL;
   tf->codes[19841] = 0x0001fb7bd8af7d33UL;
   tf->codes[19842] = 0x0001fb7cfd7a9a0cUL;
   tf->codes[19843] = 0x0001fb7fbc2edf48UL;
   tf->codes[19844] = 0x0001fba1d16d3af1UL;
   tf->codes[19845] = 0x0001fbb8ebda81aaUL;
   tf->codes[19846] = 0x0001fbe511addb2fUL;
   tf->codes[19847] = 0x0001fbf7d37db449UL;
   tf->codes[19848] = 0x0001fd02505af5caUL;
   tf->codes[19849] = 0x0001fd0b76b3dc92UL;
   tf->codes[19850] = 0x0001fd3dc99cd1deUL;
   tf->codes[19851] = 0x0001fd43bc2367e0UL;
   tf->codes[19852] = 0x0001fd6e829c9ec7UL;
   tf->codes[19853] = 0x0001fdb82a81e091UL;
   tf->codes[19854] = 0x0001fdd7f62a0288UL;
   tf->codes[19855] = 0x0001fdde5dcea414UL;
   tf->codes[19856] = 0x0001fdfba5518694UL;
   tf->codes[19857] = 0x0001fe400a5d43abUL;
   tf->codes[19858] = 0x0001fe5bf286038dUL;
   tf->codes[19859] = 0x0001fe7bbe2e2584UL;
   tf->codes[19860] = 0x0001fe86f38e4039UL;
   tf->codes[19861] = 0x0001fe9646fcc2c8UL;
   tf->codes[19862] = 0x0001fe9ce9306a19UL;
   tf->codes[19863] = 0x0001fed5a3be00f1UL;
   tf->codes[19864] = 0x0001ff14c5f03955UL;
   tf->codes[19865] = 0x0001ff2a81035d70UL;
   tf->codes[19866] = 0x0001ff7f5e48b9efUL;
   tf->codes[19867] = 0x0001ffadcdb24d26UL;
   tf->codes[19868] = 0x0001ffc68208bc42UL;
   tf->codes[19869] = 0x0001ffe7727bfb12UL;
   tf->codes[19870] = 0x00000087918fc1beUL;
   tf->codes[19871] = 0x0000008a15b50135UL;
   tf->codes[19872] = 0x000000bc689df681UL;
   tf->codes[19873] = 0x000001347feccb82UL;
   tf->codes[19874] = 0x000001444879599bUL;
   tf->codes[19875] = 0x0000015570600a52UL;
   tf->codes[19876] = 0x0000016a41371759UL;
   tf->codes[19877] = 0x000001b07abb0298UL;
   tf->codes[19878] = 0x000001e1a8d8db0bUL;
   tf->codes[19879] = 0x0000025cb96afb0dUL;
   tf->codes[19880] = 0x000002a208b2cf38UL;
   tf->codes[19881] = 0x000003685b135967UL;
   tf->codes[19882] = 0x00000393d139a19dUL;
   tf->codes[19883] = 0x000003a065f3def0UL;
   tf->codes[19884] = 0x000003c44faa68c1UL;
   tf->codes[19885] = 0x000003cb2c6d15d7UL;
   tf->codes[19886] = 0x000004228dd7b1cdUL;
   tf->codes[19887] = 0x00000456401ac9b7UL;
   tf->codes[19888] = 0x000004a05d1e170bUL;
   tf->codes[19889] = 0x000005045342f054UL;
   tf->codes[19890] = 0x00000543ea933442UL;
   tf->codes[19891] = 0x000005533e01b6d1UL;
   tf->codes[19892] = 0x000005ab89a869dbUL;
   tf->codes[19893] = 0x000005e4443600b3UL;
   tf->codes[19894] = 0x00000622419d1c3eUL;
   tf->codes[19895] = 0x000006521060d213UL;
   tf->codes[19896] = 0x000006c13be5c611UL;
   tf->codes[19897] = 0x000006e6fa147e0aUL;
   tf->codes[19898] = 0x00000701f80126d8UL;
   tf->codes[19899] = 0x0000076997165c71UL;
   tf->codes[19900] = 0x0000079b3a52406eUL;
   tf->codes[19901] = 0x000007a7947d77fcUL;
   tf->codes[19902] = 0x000007c79ab49fb8UL;
   tf->codes[19903] = 0x000007f72ee94fc8UL;
   tf->codes[19904] = 0x000007f9ed9d9504UL;
   tf->codes[19905] = 0x000008fd189a1de5UL;
   tf->codes[19906] = 0x000009125e8f3676UL;
   tf->codes[19907] = 0x000009210250a7b6UL;
   tf->codes[19908] = 0x000009231157dba3UL;
   tf->codes[19909] = 0x000009497f33a4ebUL;
   tf->codes[19910] = 0x0000095a31fc4a18UL;
   tf->codes[19911] = 0x0000098323fd52d7UL;
   tf->codes[19912] = 0x000009a2efa574ceUL;
   tf->codes[19913] = 0x000009e78f4037aaUL;
   tf->codes[19914] = 0x00000a297026b54aUL;
   tf->codes[19915] = 0x00000a67e2abdc5fUL;
   tf->codes[19916] = 0x00000a852a2ebedfUL;
   tf->codes[19917] = 0x00000ac39cb3e5f4UL;
   tf->codes[19918] = 0x00000ae53cd43613UL;
   tf->codes[19919] = 0x00000bdda78eafc9UL;
   tf->codes[19920] = 0x00000c5d10be3d6aUL;
   tf->codes[19921] = 0x00000c8a5b5cb3c8UL;
   tf->codes[19922] = 0x00000cfe549d20efUL;
   tf->codes[19923] = 0x00000d039776a5a2UL;
   tf->codes[19924] = 0x00000db9719d9069UL;
   tf->codes[19925] = 0x00000dfd9c1a47bbUL;
   tf->codes[19926] = 0x00000ea3e843aa2eUL;
   tf->codes[19927] = 0x00000eb8096da5e6UL;
   tf->codes[19928] = 0x00000ee1708cba2fUL;
   tf->codes[19929] = 0x00000f682b9d0070UL;
   tf->codes[19930] = 0x00000f7f80994ceeUL;
   tf->codes[19931] = 0x00000f93dc524e6bUL;
   tf->codes[19932] = 0x00000f96d595996cUL;
   tf->codes[19933] = 0x00000fa20af5b421UL;
   tf->codes[19934] = 0x00001026f18dcc3aUL;
   tf->codes[19935] = 0x000010293b2405ecUL;
   tf->codes[19936] = 0x0000108bd1eebc97UL;
   tf->codes[19937] = 0x000010aa78cbc1b5UL;
   tf->codes[19938] = 0x0000111969c1afeeUL;
   tf->codes[19939] = 0x0000112f99f2df93UL;
   tf->codes[19940] = 0x000011530e8b5ddaUL;
   tf->codes[19941] = 0x0000119b1c877741UL;
   tf->codes[19942] = 0x000011dab3d7bb2fUL;
   tf->codes[19943] = 0x000011df81933458UL;
   tf->codes[19944] = 0x000012350e85a226UL;
   tf->codes[19945] = 0x0000128a265a046aUL;
   tf->codes[19946] = 0x000012a0cba93f99UL;
   tf->codes[19947] = 0x00001318a8690ed5UL;
   tf->codes[19948] = 0x0000135929f569d7UL;
   tf->codes[19949] = 0x000013b9020bdb46UL;
   tf->codes[19950] = 0x000013d475168f9eUL;
   tf->codes[19951] = 0x00001473a9ee3f36UL;
   tf->codes[19952] = 0x0000148bae979d03UL;
   tf->codes[19953] = 0x000015256606c223UL;
   tf->codes[19954] = 0x0000155fba7d815eUL;
   tf->codes[19955] = 0x000015a494a749ffUL;
   tf->codes[19956] = 0x000015d3792ee8c0UL;
   tf->codes[19957] = 0x000015e4a1159977UL;
   tf->codes[19958] = 0x000016459df727bfUL;
   tf->codes[19959] = 0x000016dfca845869UL;
   tf->codes[19960] = 0x000016e50d5ddd1cUL;
   tf->codes[19961] = 0x00001707d2494a14UL;
   tf->codes[19962] = 0x0000179ecb0429f8UL;
   tf->codes[19963] = 0x000017a4bd8abffaUL;
   tf->codes[19964] = 0x0000185345d0f221UL;
   tf->codes[19965] = 0x0000186b0feb4a29UL;
   tf->codes[19966] = 0x00001872d6ea0e53UL;
   tf->codes[19967] = 0x0000188598b9e76dUL;
   tf->codes[19968] = 0x000018dcbf957d9eUL;
   tf->codes[19969] = 0x0000198a982e9e76UL;
   tf->codes[19970] = 0x000019b857eb205eUL;
   tf->codes[19971] = 0x000019d90dcf5969UL;
   tf->codes[19972] = 0x000019e31e645745UL;
   tf->codes[19973] = 0x000019f2ac61df99UL;
   tf->codes[19974] = 0x00001a7beb976551UL;
   tf->codes[19975] = 0x00001a8ac9e7dc56UL;
   tf->codes[19976] = 0x00001aab0aae09d7UL;
   tf->codes[19977] = 0x00001ac901ddfda6UL;
   tf->codes[19978] = 0x00001b1234a533e6UL;
   tf->codes[19979] = 0x00001c238e45227dUL;
   tf->codes[19980] = 0x00001c35a067ea48UL;
   tf->codes[19981] = 0x00001c36ffc20ce6UL;
   tf->codes[19982] = 0x00001cee39431a4bUL;
   tf->codes[19983] = 0x00001d02cf8b218dUL;
   tf->codes[19984] = 0x00001d1fdc7efe48UL;
   tf->codes[19985] = 0x00001d28c848df4bUL;
   tf->codes[19986] = 0x00001d7394f93deeUL;
   tf->codes[19987] = 0x00001d87f0b23f6bUL;
   tf->codes[19988] = 0x00001da7bc5a6162UL;
   tf->codes[19989] = 0x00001dc20a99f8e1UL;
   tf->codes[19990] = 0x00001e940778a94fUL;
   tf->codes[19991] = 0x00001f3c281a39eaUL;
   tf->codes[19992] = 0x00001f404628a1c4UL;
   tf->codes[19993] = 0x00001f7299119710UL;
   tf->codes[19994] = 0x00001fe1c4968b0eUL;
   tf->codes[19995] = 0x0000200364b6db2dUL;
   tf->codes[19996] = 0x00002028733881d7UL;
   tf->codes[19997] = 0x000020c2da54b846UL;
   tf->codes[19998] = 0x000020c8924c4883UL;
   tf->codes[19999] = 0x000020f94b4c156cUL;
   tf->codes[20000] = 0x00002125abae74b6UL;
   tf->codes[20001] = 0x000021344f6fe5f6UL;
   tf->codes[20002] = 0x00002178b47ba30dUL;
   tf->codes[20003] = 0x00002188b79736ebUL;
   tf->codes[20004] = 0x000021e76ae28b81UL;
   tf->codes[20005] = 0x000021fceb66a9d7UL;
   tf->codes[20006] = 0x0000228f50f51657UL;
   tf->codes[20007] = 0x0000229f5410aa35UL;
   tf->codes[20008] = 0x000022a7559e7424UL;
   tf->codes[20009] = 0x000022fb0e18b3caUL;
   tf->codes[20010] = 0x000023f6378772bcUL;
   tf->codes[20011] = 0x0000244905c59b4eUL;
   tf->codes[20012] = 0x00002465287d60f5UL;
   tf->codes[20013] = 0x00002499ff8b95b8UL;
   tf->codes[20014] = 0x000024b4fd783e86UL;
   tf->codes[20015] = 0x000024eba8fea171UL;
   tf->codes[20016] = 0x0000255a99f48faaUL;
   tf->codes[20017] = 0x000025876f74fa7eUL;
   tf->codes[20018] = 0x000025b395485403UL;
   tf->codes[20019] = 0x000025b94d3fe440UL;
   tf->codes[20020] = 0x000025c5324d1044UL;
   tf->codes[20021] = 0x000025f0a873587aUL;
   tf->codes[20022] = 0x00002670c14ff76aUL;
   tf->codes[20023] = 0x000026763eb881e2UL;
   tf->codes[20024] = 0x000026804f4d7fbeUL;
   tf->codes[20025] = 0x0000268174189c97UL;
   tf->codes[20026] = 0x000026a3fe7503caUL;
   tf->codes[20027] = 0x000026bfac0ebde7UL;
   tf->codes[20028] = 0x000026e89e0fc6a6UL;
   tf->codes[20029] = 0x000026ede0e94b59UL;
   tf->codes[20030] = 0x00002719570f938fUL;
   tf->codes[20031] = 0x0000273be16bfac2UL;
   tf->codes[20032] = 0x0000281704a391f8UL;
   tf->codes[20033] = 0x000028406bc2a641UL;
   tf->codes[20034] = 0x0000285b2f20494aUL;
   tf->codes[20035] = 0x00002864ca973b9cUL;
   tf->codes[20036] = 0x0000289f599d009cUL;
   tf->codes[20037] = 0x000028a1a3333a4eUL;
   tf->codes[20038] = 0x000028d0129ccd85UL;
   tf->codes[20039] = 0x00002983689e78d5UL;
   tf->codes[20040] = 0x00002986d6ffcf60UL;
   tf->codes[20041] = 0x0000299b6d47d6a2UL;
   tf->codes[20042] = 0x0000299f163832f2UL;
   tf->codes[20043] = 0x000029b78fff9c49UL;
   tf->codes[20044] = 0x00002a3b8c5b9d4eUL;
   tf->codes[20045] = 0x00002a477168c952UL;
   tf->codes[20046] = 0x00002a7237e20039UL;
   tf->codes[20047] = 0x00002a882d842a19UL;
   tf->codes[20048] = 0x00002acb6dc4ca57UL;
   tf->codes[20049] = 0x00002aff5a96e806UL;
   tf->codes[20050] = 0x00002b121c66c120UL;
   tf->codes[20051] = 0x00002b24a3a79475UL;
   tf->codes[20052] = 0x00002b576bae954bUL;
   tf->codes[20053] = 0x00002b66bf1d17daUL;
   tf->codes[20054] = 0x00002bab5eb7dab6UL;
   tf->codes[20055] = 0x00002c64e1cf21cdUL;
   tf->codes[20056] = 0x00002c876c2b8900UL;
   tf->codes[20057] = 0x00002c9943bf4b06UL;
   tf->codes[20058] = 0x00002cca71dd2379UL;
   tf->codes[20059] = 0x00002cdde35a0de2UL;
   tf->codes[20060] = 0x00002ce98dd83421UL;
   tf->codes[20061] = 0x00002d120abb3156UL;
   tf->codes[20062] = 0x00002d257c381bbfUL;
   tf->codes[20063] = 0x00002db9b63eb667UL;
   tf->codes[20064] = 0x00002dd59e677649UL;
   tf->codes[20065] = 0x00002e2c8ab406b5UL;
   tf->codes[20066] = 0x00002e3451b2cadfUL;
   tf->codes[20067] = 0x00002ee22a4bebb7UL;
   tf->codes[20068] = 0x00002f6e2835b6abUL;
   tf->codes[20069] = 0x00002f82be7dbdedUL;
   tf->codes[20070] = 0x00002f966a89ae1bUL;
   tf->codes[20071] = 0x00002fea9821f94bUL;
   tf->codes[20072] = 0x000030252727be4bUL;
   tf->codes[20073] = 0x00003028958914d6UL;
   tf->codes[20074] = 0x0000302d63448dffUL;
   tf->codes[20075] = 0x000030d8429a63d6UL;
   tf->codes[20076] = 0x000030fb7ca3dc58UL;
   tf->codes[20077] = 0x0000313437317330UL;
   tf->codes[20078] = 0x00003168d3b0a22eUL;
   tf->codes[20079] = 0x0000317a70b55e6fUL;
   tf->codes[20080] = 0x00003183d19d4afcUL;
   tf->codes[20081] = 0x00003248ff32b852UL;
   tf->codes[20082] = 0x0000328efe279dccUL;
   tf->codes[20083] = 0x000032ce9577e1baUL;
   tf->codes[20084] = 0x000032f57871b68cUL;
   tf->codes[20085] = 0x00003345fd19a56cUL;
   tf->codes[20086] = 0x000033bb90433af6UL;
   tf->codes[20087] = 0x000033c73ac16135UL;
   tf->codes[20088] = 0x000033f1518d86cdUL;
   tf->codes[20089] = 0x000034692e4d5609UL;
   tf->codes[20090] = 0x00003472c9c4485bUL;
   tf->codes[20091] = 0x0000348fd6b82516UL;
   tf->codes[20092] = 0x000034d092d385ddUL;
   tf->codes[20093] = 0x00003500270835edUL;
   tf->codes[20094] = 0x00003557fd90dd6dUL;
   tf->codes[20095] = 0x00003569600693e9UL;
   tf->codes[20096] = 0x0000358b7544ef92UL;
   tf->codes[20097] = 0x0000358e6e883a93UL;
   tf->codes[20098] = 0x0000359dfc85c2e7UL;
   tf->codes[20099] = 0x000035d1e957e096UL;
   tf->codes[20100] = 0x0000363d6bec7844UL;
   tf->codes[20101] = 0x0000365ed17dc29eUL;
   tf->codes[20102] = 0x0000366414574751UL;
   tf->codes[20103] = 0x000036e3f2a4e07cUL;
   tf->codes[20104] = 0x000037297c7bba6cUL;
   tf->codes[20105] = 0x00003743559d4661UL;
   tf->codes[20106] = 0x0000381bf4af9e20UL;
   tf->codes[20107] = 0x000038a6933f4676UL;
   tf->codes[20108] = 0x0000395d1d13428cUL;
   tf->codes[20109] = 0x0000398aa240beafUL;
   tf->codes[20110] = 0x0000399ec36aba67UL;
   tf->codes[20111] = 0x000039a1f73d0b2dUL;
   tf->codes[20112] = 0x000039d44a260079UL;
   tf->codes[20113] = 0x00003a13e1764467UL;
   tf->codes[20114] = 0x00003a55c25cc207UL;
   tf->codes[20115] = 0x00003a767840fb12UL;
   tf->codes[20116] = 0x00003a83478a3e2aUL;
   tf->codes[20117] = 0x00003a95943c0bbaUL;
   tf->codes[20118] = 0x00003aa73140c7fbUL;
   tf->codes[20119] = 0x00003b1f831ea2c1UL;
   tf->codes[20120] = 0x00003bb93a8dc7e1UL;
   tf->codes[20121] = 0x00003bf4b3cfa3f5UL;
   tf->codes[20122] = 0x00003c4d3a055cc4UL;
   tf->codes[20123] = 0x00003cbd4fc667d6UL;
   tf->codes[20124] = 0x00003d66201509c0UL;
   tf->codes[20125] = 0x00003d9be15f5597UL;
   tf->codes[20126] = 0x00003e52a5c25772UL;
   tf->codes[20127] = 0x00003f049c69e024UL;
   tf->codes[20128] = 0x00003f6bc6610a33UL;
   tf->codes[20129] = 0x00004107be90a120UL;
   tf->codes[20130] = 0x0000412f8bc68d06UL;
   tf->codes[20131] = 0x0000414f1cdfa938UL;
   tf->codes[20132] = 0x000041e9f919eb31UL;
   tf->codes[20133] = 0x0000421485041c53UL;
   tf->codes[20134] = 0x000042182df478a3UL;
   tf->codes[20135] = 0x00004239ce14c8c2UL;
   tf->codes[20136] = 0x00004313cc81431fUL;
   tf->codes[20137] = 0x0000439be6ebabfeUL;
   tf->codes[20138] = 0x000043aaffcb28c8UL;
   tf->codes[20139] = 0x000043b7cf146be0UL;
   tf->codes[20140] = 0x00004466cc78a991UL;
   tf->codes[20141] = 0x000044cf55c9f63eUL;
   tf->codes[20142] = 0x000045da8254490eUL;
   tf->codes[20143] = 0x000045e92615ba4eUL;
   tf->codes[20144] = 0x000045f9d8de5f7bUL;
   tf->codes[20145] = 0x0000463552203b8fUL;
   tf->codes[20146] = 0x0000469d66537cb2UL;
   tf->codes[20147] = 0x000046cde4c443d6UL;
   tf->codes[20148] = 0x000046e2407d4553UL;
   tf->codes[20149] = 0x000046e9925dfdf3UL;
   tf->codes[20150] = 0x000046f9d0089796UL;
   tf->codes[20151] = 0x00004717178b7a16UL;
   tf->codes[20152] = 0x0000473ee4c165fcUL;
   tf->codes[20153] = 0x0000478b10cbe73dUL;
   tf->codes[20154] = 0x000047d443931d7dUL;
   tf->codes[20155] = 0x000047e446aeb15bUL;
   tf->codes[20156] = 0x000047e98988360eUL;
   tf->codes[20157] = 0x000048186e0fd4cfUL;
   tf->codes[20158] = 0x000048c97a7b466dUL;
   tf->codes[20159] = 0x000048e144959e75UL;
   tf->codes[20160] = 0x0000490e1a160949UL;
   tf->codes[20161] = 0x00004916cb50e487UL;
   tf->codes[20162] = 0x0000492cc0f30e67UL;
   tf->codes[20163] = 0x000049987e16abdaUL;
   tf->codes[20164] = 0x000049b933fae4e5UL;
   tf->codes[20165] = 0x00004a1020477551UL;
   tf->codes[20166] = 0x00004aafca3d3073UL;
   tf->codes[20167] = 0x00004b16b9a554bdUL;
   tf->codes[20168] = 0x00004b18538e7d20UL;
   tf->codes[20169] = 0x00004bfdfc791dbcUL;
   tf->codes[20170] = 0x00004c2a224c7741UL;
   tf->codes[20171] = 0x00004d5813c23709UL;
   tf->codes[20172] = 0x00004d6a60740499UL;
   tf->codes[20173] = 0x00004d7f6bda1765UL;
   tf->codes[20174] = 0x00004d9944fba35aUL;
   tf->codes[20175] = 0x00004da7e8bd149aUL;
   tf->codes[20176] = 0x00004dd23a183ff7UL;
   tf->codes[20177] = 0x00004de3d71cfc38UL;
   tf->codes[20178] = 0x00004e14558dc35cUL;
   tf->codes[20179] = 0x00004e1a0d855399UL;
   tf->codes[20180] = 0x00004f33a34211e4UL;
   tf->codes[20181] = 0x0000504781073ff2UL;
   tf->codes[20182] = 0x00005068e6988a4cUL;
   tf->codes[20183] = 0x000050b462f5fa3eUL;
   tf->codes[20184] = 0x0000513da22b7ff6UL;
   tf->codes[20185] = 0x00005188344cd8d4UL;
   tf->codes[20186] = 0x000051f8f9baf535UL;
   tf->codes[20187] = 0x000052b99423ef27UL;
   tf->codes[20188] = 0x000052c0e604a7c7UL;
   tf->codes[20189] = 0x000052d4cc9f9dbaUL;
   tf->codes[20190] = 0x000053313654b89eUL;
   tf->codes[20191] = 0x0000533eefda12caUL;
   tf->codes[20192] = 0x00005365d2d3e79cUL;
   tf->codes[20193] = 0x00005397760fcb99UL;
   tf->codes[20194] = 0x000054380a419dcfUL;
   tf->codes[20195] = 0x00005451a8d423ffUL;
   tf->codes[20196] = 0x0000553751bec49bUL;
   tf->codes[20197] = 0x000055aa263414e9UL;
   tf->codes[20198] = 0x00005638332513caUL;
   tf->codes[20199] = 0x00005746ce10bd25UL;
   tf->codes[20200] = 0x000057dd8c3c9744UL;
   tf->codes[20201] = 0x0000582858ecf5e7UL;
   tf->codes[20202] = 0x0000582b523040e8UL;
   tf->codes[20203] = 0x00005840d2b45f3eUL;
   tf->codes[20204] = 0x0000589c522d630eUL;
   tf->codes[20205] = 0x000059e4cc71c01aUL;
   tf->codes[20206] = 0x00005b00e653bddcUL;
   tf->codes[20207] = 0x00005b321471964fUL;
   tf->codes[20208] = 0x00005bb4ec027a7bUL;
   tf->codes[20209] = 0x00005d653feb12e5UL;
   tf->codes[20210] = 0x00005d89d94eae05UL;
   tf->codes[20211] = 0x00005dc13482223fUL;
   tf->codes[20212] = 0x00005de9b1651f74UL;
   tf->codes[20213] = 0x00005e5de5349260UL;
   tf->codes[20214] = 0x00005e618e24eeb0UL;
   tf->codes[20215] = 0x00005e969fc22938UL;
   tf->codes[20216] = 0x00005eab360a307aUL;
   tf->codes[20217] = 0x00005eeb42787ff2UL;
   tf->codes[20218] = 0x00005f2fa7843d09UL;
   tf->codes[20219] = 0x00005f7cbdcad55eUL;
   tf->codes[20220] = 0x00005f877e0ce489UL;
   tf->codes[20221] = 0x00005fe50c8d1c46UL;
   tf->codes[20222] = 0x00005fffcfeabf4fUL;
   tf->codes[20223] = 0x0000607c7a6607b4UL;
   tf->codes[20224] = 0x0000608b58b67eb9UL;
   tf->codes[20225] = 0x000061379766772eUL;
   tf->codes[20226] = 0x00006150fb69f799UL;
   tf->codes[20227] = 0x000061a4ee733d04UL;
   tf->codes[20228] = 0x000061b1f84b85e1UL;
   tf->codes[20229] = 0x000061f697e648bdUL;
   tf->codes[20230] = 0x00006222bdb9a242UL;
   tf->codes[20231] = 0x00006257cf56dccaUL;
   tf->codes[20232] = 0x000062e56729d021UL;
   tf->codes[20233] = 0x000062f9c2e2d19eUL;
   tf->codes[20234] = 0x00006359606a3d48UL;
   tf->codes[20235] = 0x0000636a1332e275UL;
   tf->codes[20236] = 0x00006370eff58f8bUL;
   tf->codes[20237] = 0x000063ef6ee90618UL;
   tf->codes[20238] = 0x0000640ae1f3ba70UL;
   tf->codes[20239] = 0x00006450e0e89feaUL;
   tf->codes[20240] = 0x000064a6334c07f3UL;
   tf->codes[20241] = 0x000064dfd815b5dfUL;
   tf->codes[20242] = 0x0000652b547325d1UL;
   tf->codes[20243] = 0x000065b9616424b2UL;
   tf->codes[20244] = 0x000065c5f61e6205UL;
   tf->codes[20245] = 0x000065c7557884a3UL;
   tf->codes[20246] = 0x000066246edab0d6UL;
   tf->codes[20247] = 0x00006649083e4bf6UL;
   tf->codes[20248] = 0x0000664b17457fe3UL;
   tf->codes[20249] = 0x000066d6a0113f4dUL;
   tf->codes[20250] = 0x000066ed45607a7cUL;
   tf->codes[20251] = 0x00006787ac7cb0ebUL;
   tf->codes[20252] = 0x0000679aa8db8fcaUL;
   tf->codes[20253] = 0x000068885353fa55UL;
   tf->codes[20254] = 0x0000689313960980UL;
   tf->codes[20255] = 0x0000689b1523d36fUL;
   tf->codes[20256] = 0x0000690329571492UL;
   tf->codes[20257] = 0x0000697bb5c3f51dUL;
   tf->codes[20258] = 0x000069b3861574e1UL;
   tf->codes[20259] = 0x000069c1ef47e05cUL;
   tf->codes[20260] = 0x00006a1f08aa0c8fUL;
   tf->codes[20261] = 0x00006a52f57c2a3eUL;
   tf->codes[20262] = 0x00006a5abc7aee68UL;
   tf->codes[20263] = 0x00006a97cfa5f2dfUL;
   tf->codes[20264] = 0x00006a9f2186ab7fUL;
   tf->codes[20265] = 0x00006ae72f82c4e6UL;
   tf->codes[20266] = 0x00006af1efc4d411UL;
   tf->codes[20267] = 0x00006b090a321acaUL;
   tf->codes[20268] = 0x00006b147a213b44UL;
   tf->codes[20269] = 0x00006b4b9ac5a9b9UL;
   tf->codes[20270] = 0x00006ba0780b0638UL;
   tf->codes[20271] = 0x00006bf2217e11f1UL;
   tf->codes[20272] = 0x00006bf6ef398b1aUL;
   tf->codes[20273] = 0x00006c1e0cc265b1UL;
   tf->codes[20274] = 0x00006c3477829b1bUL;
   tf->codes[20275] = 0x00006c8fbc6c9926UL;
   tf->codes[20276] = 0x00006d07992c6862UL;
   tf->codes[20277] = 0x00006d30160f6597UL;
   tf->codes[20278] = 0x00006d6e4e0586e7UL;
   tf->codes[20279] = 0x00006dcd0150db7dUL;
   tf->codes[20280] = 0x00006df99c42408cUL;
   tf->codes[20281] = 0x00006e293076f09cUL;
   tf->codes[20282] = 0x00006e484c720144UL;
   tf->codes[20283] = 0x00006e655965ddffUL;
   tf->codes[20284] = 0x00006e86f9862e1eUL;
   tf->codes[20285] = 0x00006e9bca5d3b25UL;
   tf->codes[20286] = 0x00006ee955c1df04UL;
   tf->codes[20287] = 0x00006f20014841efUL;
   tf->codes[20288] = 0x00006f78c20d0083UL;
   tf->codes[20289] = 0x00006fbaa2f37e23UL;
   tf->codes[20290] = 0x00006ff61c355a37UL;
   tf->codes[20291] = 0x000070a3f4ce7b0fUL;
   tf->codes[20292] = 0x000071571041209aUL;
   tf->codes[20293] = 0x000071ea9a9aa9f3UL;
   tf->codes[20294] = 0x000071fa6327380cUL;
   tf->codes[20295] = 0x00007247b3fcd626UL;
   tf->codes[20296] = 0x0000725114e4c2b3UL;
   tf->codes[20297] = 0x0000732fe10cb639UL;
   tf->codes[20298] = 0x00007336f85e6914UL;
   tf->codes[20299] = 0x000073c2812a287eUL;
   tf->codes[20300] = 0x000073d5086afbd3UL;
   tf->codes[20301] = 0x0000742a203f5e17UL;
   tf->codes[20302] = 0x0000745f6c6b9e64UL;
   tf->codes[20303] = 0x00007464af452317UL;
   tf->codes[20304] = 0x000074c02ebe26e7UL;
   tf->codes[20305] = 0x000074d44fe8229fUL;
   tf->codes[20306] = 0x0000751ee2097b7dUL;
   tf->codes[20307] = 0x000075793cb76274UL;
   tf->codes[20308] = 0x0000760d019ff192UL;
   tf->codes[20309] = 0x0000767cdcd1f6dfUL;
   tf->codes[20310] = 0x000076972b118e5eUL;
   tf->codes[20311] = 0x000076a67e8010edUL;
   tf->codes[20312] = 0x000076c6bf463e6eUL;
   tf->codes[20313] = 0x000077bc6b4c72e8UL;
   tf->codes[20314] = 0x00007879d1e31c14UL;
   tf->codes[20315] = 0x0000788123c3d4b4UL;
   tf->codes[20316] = 0x00007882bdacfd17UL;
   tf->codes[20317] = 0x000078978e840a1eUL;
   tf->codes[20318] = 0x000078abea3d0b9bUL;
   tf->codes[20319] = 0x000078f17413e58bUL;
   tf->codes[20320] = 0x000078fd93b01754UL;
   tf->codes[20321] = 0x0000791229f81e96UL;
   tf->codes[20322] = 0x00007936c35bb9b6UL;
   tf->codes[20323] = 0x000079a15bb43a50UL;
   tf->codes[20324] = 0x00007a293b8f9d6aUL;
   tf->codes[20325] = 0x00007a789b6c6f71UL;
   tf->codes[20326] = 0x00007af83f2b02d7UL;
   tf->codes[20327] = 0x00007b187ff13058UL;
   tf->codes[20328] = 0x00007bc399d60bf4UL;
   tf->codes[20329] = 0x00007be32aef2826UL;
   tf->codes[20330] = 0x00007c91edc46012UL;
   tf->codes[20331] = 0x00007ca5d45f5605UL;
   tf->codes[20332] = 0x00007cc31be23885UL;
   tf->codes[20333] = 0x00007d0278a376aeUL;
   tf->codes[20334] = 0x00007d2c8f6f9c46UL;
   tf->codes[20335] = 0x00007d8933b3bcefUL;
   tf->codes[20336] = 0x00007da297b73d5aUL;
   tf->codes[20337] = 0x00007dccae8362f2UL;
   tf->codes[20338] = 0x00007ddefb353082UL;
   tf->codes[20339] = 0x00007e3a059028c8UL;
   tf->codes[20340] = 0x00007e615da80924UL;
   tf->codes[20341] = 0x00007f31c09d912fUL;
   tf->codes[20342] = 0x00007f340a33cae1UL;
   tf->codes[20343] = 0x00007f34f46fe1f5UL;
   tf->codes[20344] = 0x00007f3e1ac8c8bdUL;
   tf->codes[20345] = 0x00007f544af9f862UL;
   tf->codes[20346] = 0x00007f68e141ffa4UL;
   tf->codes[20347] = 0x00007fa45a83dbb8UL;
   tf->codes[20348] = 0x00007fe675f95f1dUL;
   tf->codes[20349] = 0x00007ffca62a8ec2UL;
   tf->codes[20350] = 0x000080273214bfe4UL;
   tf->codes[20351] = 0x0000806912fb3d84UL;
   tf->codes[20352] = 0x0000808919326540UL;
   tf->codes[20353] = 0x0000808dac5ed8a4UL;
   tf->codes[20354] = 0x000080b9d2323229UL;
   tf->codes[20355] = 0x000080e7575fae4cUL;
   tf->codes[20356] = 0x00008108f77ffe6bUL;
   tf->codes[20357] = 0x000081163be74d0dUL;
   tf->codes[20358] = 0x0000812bf6fa7128UL;
   tf->codes[20359] = 0x0000816944b47b64UL;
   tf->codes[20360] = 0x00008191c1977899UL;
   tf->codes[20361] = 0x000081f3e34423baUL;
   tf->codes[20362] = 0x00008231a61c3980UL;
   tf->codes[20363] = 0x0000829945316f19UL;
   tf->codes[20364] = 0x000082d9519fbe91UL;
   tf->codes[20365] = 0x000082ef81d0ee36UL;
   tf->codes[20366] = 0x0000831a0dbb1f58UL;
   tf->codes[20367] = 0x0000832e2ee51b10UL;
   tf->codes[20368] = 0x000083654f898985UL;
   tf->codes[20369] = 0x0000838e7c199809UL;
   tf->codes[20370] = 0x000083a60ba4ea4cUL;
   tf->codes[20371] = 0x00008416d11306adUL;
   tf->codes[20372] = 0x00008422b62032b1UL;
   tf->codes[20373] = 0x000084395b6f6de0UL;
   tf->codes[20374] = 0x00008469d9e03504UL;
   tf->codes[20375] = 0x000084c8529c83d5UL;
   tf->codes[20376] = 0x000084cb1150c911UL;
   tf->codes[20377] = 0x000084f0cf7f810aUL;
   tf->codes[20378] = 0x000085090eb7e49cUL;
   tf->codes[20379] = 0x0000857ea1e17a26UL;
   tf->codes[20380] = 0x00008588b2767802UL;
   tf->codes[20381] = 0x000085e0fe1d2b0cUL;
   tf->codes[20382] = 0x000086256328e823UL;
   tf->codes[20383] = 0x0000865398037595UL;
   tf->codes[20384] = 0x00008689594dc16cUL;
   tf->codes[20385] = 0x000087a32999857cUL;
   tf->codes[20386] = 0x000087a6d289e1ccUL;
   tf->codes[20387] = 0x00008826b0d77af7UL;
   tf->codes[20388] = 0x0000885b87e5afbaUL;
   tf->codes[20389] = 0x00008874b15a2a60UL;
   tf->codes[20390] = 0x000088af7aeef525UL;
   tf->codes[20391] = 0x00008932527fd951UL;
   tf->codes[20392] = 0x0000893795595e04UL;
   tf->codes[20393] = 0x000089651a86da27UL;
   tf->codes[20394] = 0x00008a5f1f2a7c40UL;
   tf->codes[20395] = 0x00008a837dff119bUL;
   tf->codes[20396] = 0x00008b866e6c94b7UL;
   tf->codes[20397] = 0x00008bbeb3dc2005UL;
   tf->codes[20398] = 0x00008bde44f53c37UL;
   tf->codes[20399] = 0x00008c27029e66edUL;
   tf->codes[20400] = 0x00008c33223a98b6UL;
   tf->codes[20401] = 0x00008d6397d597f5UL;
   tf->codes[20402] = 0x00008d92073f2b2cUL;
   tf->codes[20403] = 0x00008e204ebf2fd2UL;
   tf->codes[20404] = 0x00008e95323bb40dUL;
   tf->codes[20405] = 0x00008f2130257f01UL;
   tf->codes[20406] = 0x00008f97ad8b2b9fUL;
   tf->codes[20407] = 0x00009034d35ba74aUL;
   tf->codes[20408] = 0x00009117f821086fUL;
   tf->codes[20409] = 0x00009166a850c927UL;
   tf->codes[20410] = 0x0000921f7bbafeefUL;
   tf->codes[20411] = 0x00009304af879401UL;
   tf->codes[20412] = 0x0000931e138b146cUL;
   tf->codes[20413] = 0x000093c71e68bc1bUL;
   tf->codes[20414] = 0x000093c92d6ff008UL;
   tf->codes[20415] = 0x000093dd4e99ebc0UL;
   tf->codes[20416] = 0x00009446879849bcUL;
   tf->codes[20417] = 0x000094bba5a3d3bcUL;
   tf->codes[20418] = 0x000095743e7f03bfUL;
   tf->codes[20419] = 0x0000964675ecb9f2UL;
   tf->codes[20420] = 0x000096a8227b5989UL;
   tf->codes[20421] = 0x000096f39ed8c97bUL;
   tf->codes[20422] = 0x0000970af3d515f9UL;
   tf->codes[20423] = 0x0000979c349865a0UL;
   tf->codes[20424] = 0x000097b055c26158UL;
   tf->codes[20425] = 0x000097c64b648b38UL;
   tf->codes[20426] = 0x000098495d847529UL;
   tf->codes[20427] = 0x0000985db93d76a6UL;
   tf->codes[20428] = 0x000098a0beef111fUL;
   tf->codes[20429] = 0x000098e29fd58ebfUL;
   tf->codes[20430] = 0x000098e59918d9c0UL;
   tf->codes[20431] = 0x000098ec75db86d6UL;
   tf->codes[20432] = 0x0000999c980ae160UL;
   tf->codes[20433] = 0x000099b0b934dd18UL;
   tf->codes[20434] = 0x00009a489c2bd410UL;
   tf->codes[20435] = 0x00009a6ff443b46cUL;
   tf->codes[20436] = 0x00009a7e5d761fe7UL;
   tf->codes[20437] = 0x00009a811c2a6523UL;
   tf->codes[20438] = 0x00009aa8e9605109UL;
   tf->codes[20439] = 0x00009b07621c9fdaUL;
   tf->codes[20440] = 0x00009b0f9e396f8eUL;
   tf->codes[20441] = 0x00009b2b86622f70UL;
   tf->codes[20442] = 0x00009bf63160273eUL;
   tf->codes[20443] = 0x00009c0a8d1928bbUL;
   tf->codes[20444] = 0x00009c1796f17198UL;
   tf->codes[20445] = 0x00009c1b0552c823UL;
   tf->codes[20446] = 0x00009ccf801f904cUL;
   tf->codes[20447] = 0x00009ce241ef6966UL;
   tf->codes[20448] = 0x00009ce7f9e6f9a3UL;
   tf->codes[20449] = 0x00009d216421a1caUL;
   tf->codes[20450] = 0x00009d287b7354a5UL;
   tf->codes[20451] = 0x00009d5257b07478UL;
   tf->codes[20452] = 0x00009d7c33ed944bUL;
   tf->codes[20453] = 0x00009dd0d6a3eb05UL;
   tf->codes[20454] = 0x00009dde559a3f6cUL;
   tf->codes[20455] = 0x00009de40d91cfa9UL;
   tf->codes[20456] = 0x00009f1189e983e7UL;
   tf->codes[20457] = 0x00009f2277412ed9UL;
   tf->codes[20458] = 0x00009f812a8c836fUL;
   tf->codes[20459] = 0x00009f97954cb8d9UL;
   tf->codes[20460] = 0x00009f9cd8263d8cUL;
   tf->codes[20461] = 0x00009fa2558ec804UL;
   tf->codes[20462] = 0x00009fa33fcadf18UL;
   tf->codes[20463] = 0x00009fb551eda6e3UL;
   tf->codes[20464] = 0x00009fd8c686252aUL;
   tf->codes[20465] = 0x00009fde7e7db567UL;
   tf->codes[20466] = 0x0000a0820bf2d29eUL;
   tf->codes[20467] = 0x0000a087c3ea62dbUL;
   tf->codes[20468] = 0x0000a0a2c1d70ba9UL;
   tf->codes[20469] = 0x0000a0fd1c84f2a0UL;
   tf->codes[20470] = 0x0000a16ae8afc400UL;
   tf->codes[20471] = 0x0000a246f623724aUL;
   tf->codes[20472] = 0x0000a24730b2780fUL;
   tf->codes[20473] = 0x0000a261446309c9UL;
   tf->codes[20474] = 0x0000a2efc6721434UL;
   tf->codes[20475] = 0x0000a31f9535ca09UL;
   tf->codes[20476] = 0x0000a3263769715aUL;
   tf->codes[20477] = 0x0000a341aa7425b2UL;
   tf->codes[20478] = 0x0000a37cae97f63cUL;
   tf->codes[20479] = 0x0000a39b9004011fUL;
   tf->codes[20480] = 0x0000a3a949895b4bUL;
   tf->codes[20481] = 0x0000a3ac42cca64cUL;
   tf->codes[20482] = 0x0000a425b9759debUL;
   tf->codes[20483] = 0x0000a42edfce84b3UL;
   tf->codes[20484] = 0x0000a4e2705f35c8UL;
   tf->codes[20485] = 0x0000a54b6ece8dffUL;
   tf->codes[20486] = 0x0000a5b72bf22b72UL;
   tf->codes[20487] = 0x0000a5d55db12506UL;
   tf->codes[20488] = 0x0000a689635fe1a5UL;
   tf->codes[20489] = 0x0000a68a130cf2f4UL;
   tf->codes[20490] = 0x0000a6d2962717e5UL;
   tf->codes[20491] = 0x0000a72cf0d4fedcUL;
   tf->codes[20492] = 0x0000a742abe822f7UL;
   tf->codes[20493] = 0x0000a763273d563dUL;
   tf->codes[20494] = 0x0000a822624c2d91UL;
   tf->codes[20495] = 0x0000a829799de06cUL;
   tf->codes[20496] = 0x0000a8585e257f2dUL;
   tf->codes[20497] = 0x0000a90845c5d3f2UL;
   tf->codes[20498] = 0x0000a90ead6a757eUL;
   tf->codes[20499] = 0x0000a951edab15bcUL;
   tf->codes[20500] = 0x0000a96683f31cfeUL;
   tf->codes[20501] = 0x0000a9edeeb0748eUL;
   tf->codes[20502] = 0x0000aa0493ffafbdUL;
   tf->codes[20503] = 0x0000aa27ce09283fUL;
   tf->codes[20504] = 0x0000ab12f45c5353UL;
   tf->codes[20505] = 0x0000ab48408893a0UL;
   tf->codes[20506] = 0x0000ac56db743cfbUL;
   tf->codes[20507] = 0x0000ac928f451ed4UL;
   tf->codes[20508] = 0x0000acb603dd9d1bUL;
   tf->codes[20509] = 0x0000acf59b2de109UL;
   tf->codes[20510] = 0x0000ad21fb904053UL;
   tf->codes[20511] = 0x0000ad3d340beee6UL;
   tf->codes[20512] = 0x0000ad7d407a3e5eUL;
   tf->codes[20513] = 0x0000ada12a30c82fUL;
   tf->codes[20514] = 0x0000adc0f5d8ea26UL;
   tf->codes[20515] = 0x0000ae0a632f262bUL;
   tf->codes[20516] = 0x0000ae656d8a1e71UL;
   tf->codes[20517] = 0x0000aea579f86de9UL;
   tf->codes[20518] = 0x0000aea8e859c474UL;
   tf->codes[20519] = 0x0000aeaf156f603bUL;
   tf->codes[20520] = 0x0000aee4619ba088UL;
   tf->codes[20521] = 0x0000af522dc671e8UL;
   tf->codes[20522] = 0x0000afa44c57892bUL;
   tf->codes[20523] = 0x0000afb2406be91cUL;
   tf->codes[20524] = 0x0000afed7f1ebf6bUL;
   tf->codes[20525] = 0x0000b01c29175867UL;
   tf->codes[20526] = 0x0000b087e63af5daUL;
   tf->codes[20527] = 0x0000b09c0764f192UL;
   tf->codes[20528] = 0x0000b0e53a2c27d2UL;
   tf->codes[20529] = 0x0000b0fd79648b64UL;
   tf->codes[20530] = 0x0000b194e73d76d2UL;
   tf->codes[20531] = 0x0000b1bcb47362b8UL;
   tf->codes[20532] = 0x0000b1fcfb70b7f5UL;
   tf->codes[20533] = 0x0000b2654a32feddUL;
   tf->codes[20534] = 0x0000b265bf510a67UL;
   tf->codes[20535] = 0x0000b34b683bab03UL;
   tf->codes[20536] = 0x0000b35d05406744UL;
   tf->codes[20537] = 0x0000b371266a62fcUL;
   tf->codes[20538] = 0x0000b37285c4859aUL;
   tf->codes[20539] = 0x0000b46697e191b1UL;
   tf->codes[20540] = 0x0000b49a0f95a3d6UL;
   tf->codes[20541] = 0x0000b4d638849139UL;
   tf->codes[20542] = 0x0000b4dd8a6549d9UL;
   tf->codes[20543] = 0x0000b540964e0c0eUL;
   tf->codes[20544] = 0x0000b544b45c73e8UL;
   tf->codes[20545] = 0x0000b557eb4a588cUL;
   tf->codes[20546] = 0x0000b58aede05f27UL;
   tf->codes[20547] = 0x0000b5a576aefc6bUL;
   tf->codes[20548] = 0x0000b5dc5cc4651bUL;
   tf->codes[20549] = 0x0000b5eac5f6d096UL;
   tf->codes[20550] = 0x0000b5f844ed24fdUL;
   tf->codes[20551] = 0x0000b61f6275ff94UL;
   tf->codes[20552] = 0x0000b6276403c983UL;
   tf->codes[20553] = 0x0000b7300c68dcdcUL;
   tf->codes[20554] = 0x0000b743f303d2cfUL;
   tf->codes[20555] = 0x0000b77e820997cfUL;
   tf->codes[20556] = 0x0000b79c3eaa85d9UL;
   tf->codes[20557] = 0x0000b7f1567ee81dUL;
   tf->codes[20558] = 0x0000b8407bccb45fUL;
   tf->codes[20559] = 0x0000b87e3ea4ca25UL;
   tf->codes[20560] = 0x0000b88e41c05e03UL;
   tf->codes[20561] = 0x0000b8c7e68a0befUL;
   tf->codes[20562] = 0x0000b8dc42430d6cUL;
   tf->codes[20563] = 0x0000b903253ce23eUL;
   tf->codes[20564] = 0x0000b91ed2d69c5bUL;
   tf->codes[20565] = 0x0000b9c3bfa5dc30UL;
   tf->codes[20566] = 0x0000ba3cc130c845UL;
   tf->codes[20567] = 0x0000bb07319fba4eUL;
   tf->codes[20568] = 0x0000bb3fec2d5126UL;
   tf->codes[20569] = 0x0000bbad433a16fcUL;
   tf->codes[20570] = 0x0000bbfb092dc0a0UL;
   tf->codes[20571] = 0x0000bc86cc8885cfUL;
   tf->codes[20572] = 0x0000bcc788a3e696UL;
   tf->codes[20573] = 0x0000bd4975f8b3aeUL;
   tf->codes[20574] = 0x0000bd4bfa1df325UL;
   tf->codes[20575] = 0x0000bd97767b6317UL;
   tf->codes[20576] = 0x0000bdd573e27ea2UL;
   tf->codes[20577] = 0x0000bdd5ae718467UL;
   tf->codes[20578] = 0x0000be30f35b8272UL;
   tf->codes[20579] = 0x0000be49a7b1f18eUL;
   tf->codes[20580] = 0x0000beb7394dbd29UL;
   tf->codes[20581] = 0x0000bf1d3e79ca5fUL;
   tf->codes[20582] = 0x0000c0520cb2373dUL;
   tf->codes[20583] = 0x0000c09d4e80a16aUL;
   tf->codes[20584] = 0x0000c0b4a37cede8UL;
   tf->codes[20585] = 0x0000c0da9c3aaba6UL;
   tf->codes[20586] = 0x0000c1f4a715757bUL;
   tf->codes[20587] = 0x0000c240d31ff6bcUL;
   tf->codes[20588] = 0x0000c2d4980885daUL;
   tf->codes[20589] = 0x0000c32ad4a804f7UL;
   tf->codes[20590] = 0x0000c3408fbb2912UL;
   tf->codes[20591] = 0x0000c3abd7c0bafbUL;
   tf->codes[20592] = 0x0000c3e123ecfb48UL;
   tf->codes[20593] = 0x0000c3fe6b6fddc8UL;
   tf->codes[20594] = 0x0000c4484de42557UL;
   tf->codes[20595] = 0x0000c4c4bdd067f7UL;
   tf->codes[20596] = 0x0000c4df812e0b00UL;
   tf->codes[20597] = 0x0000c4ea7bff1ff0UL;
   tf->codes[20598] = 0x0000c52c5ce59d90UL;
   tf->codes[20599] = 0x0000c58a25f4db12UL;
   tf->codes[20600] = 0x0000c5bc03bfc4d4UL;
   tf->codes[20601] = 0x0000c5d73c3b7367UL;
   tf->codes[20602] = 0x0000c64249b1ff8bUL;
   tf->codes[20603] = 0x0000c65a4e5b5d58UL;
   tf->codes[20604] = 0x0000c747f8d3c7e3UL;
   tf->codes[20605] = 0x0000c7c9ab998f36UL;
   tf->codes[20606] = 0x0000ca2ad15e9379UL;
   tf->codes[20607] = 0x0000cdfd28d9f7c2UL;
   tf->codes[20608] = 0x0000ce5539f1a507UL;
   tf->codes[20609] = 0x0000d1a47f4d1f5fUL;
   tf->codes[20610] = 0x0000d230f254f5ddUL;
   tf->codes[20611] = 0x0000d4845e949ff4UL;
   tf->codes[20612] = 0x0000d4d4a8ad890fUL;
   tf->codes[20613] = 0x0000d5a929b178f4UL;
   tf->codes[20614] = 0x0000d5e468644f43UL;
   tf->codes[20615] = 0x0000d6dcd31ec8f9UL;
   tf->codes[20616] = 0x0000d72814ed3326UL;
   tf->codes[20617] = 0x0000d7413e61adccUL;
   tf->codes[20618] = 0x0000d7e9d42149f1UL;
   tf->codes[20619] = 0x0000d845190b47fcUL;
   tf->codes[20620] = 0x0000d8ab1e375532UL;
   tf->codes[20621] = 0x0000dac93e4abefcUL;
   tf->codes[20622] = 0x0000db9df9ddb4a6UL;
   tf->codes[20623] = 0x0000dbba1c957a4dUL;
   tf->codes[20624] = 0x0000dbe3492588d1UL;
   tf->codes[20625] = 0x0000dc6b9e1ef775UL;
   tf->codes[20626] = 0x0000dc98739f6249UL;
   tf->codes[20627] = 0x0000dca8ebd901b1UL;
   tf->codes[20628] = 0x0000dd226281f950UL;
   tf->codes[20629] = 0x0000dd8ff41dc4ebUL;
   tf->codes[20630] = 0x0000dda031c85e8eUL;
   tf->codes[20631] = 0x0000de44a97992d9UL;
   tf->codes[20632] = 0x0000de76c1d38260UL;
   tf->codes[20633] = 0x0000deb917d80b8aUL;
   tf->codes[20634] = 0x0000df1d488bea98UL;
   tf->codes[20635] = 0x0000df48f9413893UL;
   tf->codes[20636] = 0x0000df6fa1ac07a0UL;
   tf->codes[20637] = 0x0000dfaefe6d45c9UL;
   tf->codes[20638] = 0x0000dfe2eb3f6378UL;
   tf->codes[20639] = 0x0000e00f1112bcfdUL;
   tf->codes[20640] = 0x0000e23950c25890UL;
   tf->codes[20641] = 0x0000e267107eda78UL;
   tf->codes[20642] = 0x0000e2d7d5ecf6d9UL;
   tf->codes[20643] = 0x0000e3698bce520aUL;
   tf->codes[20644] = 0x0000e3aba743d56fUL;
   tf->codes[20645] = 0x0000e3ec28d03071UL;
   tf->codes[20646] = 0x0000e50165ef811dUL;
   tf->codes[20647] = 0x0000e72b30811126UL;
   tf->codes[20648] = 0x0000e7dec111c23bUL;
   tf->codes[20649] = 0x0000e8082830d684UL;
   tf->codes[20650] = 0x0000e80de02866c1UL;
   tf->codes[20651] = 0x0000e9423942c815UL;
   tf->codes[20652] = 0x0000e9611aaed2f8UL;
   tf->codes[20653] = 0x0000e99800c43ba8UL;
   tf->codes[20654] = 0x0000ea297c169114UL;
   tf->codes[20655] = 0x0000eaa994f33004UL;
   tf->codes[20656] = 0x0000eb137d9e9f4fUL;
   tf->codes[20657] = 0x0000eb204ce7e267UL;
   tf->codes[20658] = 0x0000eb24a5855006UL;
   tf->codes[20659] = 0x0000ebf36e91afaeUL;
   tf->codes[20660] = 0x0000ec809146977bUL;
   tf->codes[20661] = 0x0000edd47b7a1501UL;
   tf->codes[20662] = 0x0000ede7b267f9a5UL;
   tf->codes[20663] = 0x0000ee733b33b90fUL;
   tf->codes[20664] = 0x0000eea0c0613532UL;
   tf->codes[20665] = 0x0000eed10442f691UL;
   tf->codes[20666] = 0x0000eee4b04ee6bfUL;
   tf->codes[20667] = 0x0000ef06506f36deUL;
   tf->codes[20668] = 0x0000ef62ba2451c2UL;
   tf->codes[20669] = 0x0000f19cc2607b6eUL;
   tf->codes[20670] = 0x0000f1ebad1f41ebUL;
   tf->codes[20671] = 0x0000f261eff5e8c4UL;
   tf->codes[20672] = 0x0000f29358a2c6fcUL;
   tf->codes[20673] = 0x0000f31c22ba412aUL;
   tf->codes[20674] = 0x0000f3c0254d69ebUL;
   tf->codes[20675] = 0x0000f40574953e16UL;
   tf->codes[20676] = 0x0000f4450be58204UL;
   tf->codes[20677] = 0x0000f451a09fbf57UL;
   tf->codes[20678] = 0x0000f45758974f94UL;
   tf->codes[20679] = 0x0000f5c25d3813d3UL;
   tf->codes[20680] = 0x0000f6db4347c0cfUL;
   tf->codes[20681] = 0x0000f6f3f79e2febUL;
   tf->codes[20682] = 0x0000f760d98cea37UL;
   tf->codes[20683] = 0x0000f79c52cec64bUL;
   tf->codes[20684] = 0x0000f7a8726af814UL;
   tf->codes[20685] = 0x0000f7db7500feafUL;
   tf->codes[20686] = 0x0000f7e042bc77d8UL;
   tf->codes[20687] = 0x0000f801e2dcc7f7UL;
   tf->codes[20688] = 0x0000f83c37538732UL;
   tf->codes[20689] = 0x0000f864b4368467UL;
   tf->codes[20690] = 0x0000f87b9414c55bUL;
   tf->codes[20691] = 0x0000f89398be2328UL;
   tf->codes[20692] = 0x0000f89532a74b8bUL;
   tf->codes[20693] = 0x0000f8a44b86c855UL;
   tf->codes[20694] = 0x0000f956079f4b42UL;
   tf->codes[20695] = 0x0000f9597600a1cdUL;
   tf->codes[20696] = 0x0000fa21d7685fe9UL;
   tf->codes[20697] = 0x0000fa3a16a0c37bUL;
   tf->codes[20698] = 0x0000fa9a9e644639UL;
   tf->codes[20699] = 0x0000fb4a10e68f74UL;
   tf->codes[20700] = 0x0000fb6ac6cac87fUL;
   tf->codes[20701] = 0x0000fb8e3b6346c6UL;
   tf->codes[20702] = 0x0000fc4f85795207UL;
   tf->codes[20703] = 0x0000fce13b5aad38UL;
   tf->codes[20704] = 0x0000fcf0c958358cUL;
   tf->codes[20705] = 0x0000fde516044768UL;
   tf->codes[20706] = 0x0000fe1fdf99122dUL;
   tf->codes[20707] = 0x0000fe3a6867af71UL;
   tf->codes[20708] = 0x0000fe8f45ad0bf0UL;
   tf->codes[20709] = 0x0000ff4101c58eddUL;
   tf->codes[20710] = 0x0000ff4ad7cb86f4UL;
   tf->codes[20711] = 0x000100cbd20e7513UL;
   tf->codes[20712] = 0x000102c51e2f3df8UL;
   tf->codes[20713] = 0x00010301f6cb3caaUL;
   tf->codes[20714] = 0x0001037d7c7b6836UL;
   tf->codes[20715] = 0x000104589fb2ff6cUL;
   tf->codes[20716] = 0x000104a4569f7523UL;
   tf->codes[20717] = 0x00010641739a28e9UL;
   tf->codes[20718] = 0x000106fffefbeeeeUL;
   tf->codes[20719] = 0x00010700aea9003dUL;
   tf->codes[20720] = 0x0001075e029a3235UL;
   tf->codes[20721] = 0x000107b43f39b152UL;
   tf->codes[20722] = 0x000107c47ce44af5UL;
   tf->codes[20723] = 0x000109c63fb0e953UL;
   tf->codes[20724] = 0x00010a1aa7d83a48UL;
   tf->codes[20725] = 0x00010ac07ee39131UL;
   tf->codes[20726] = 0x00010acaca0794d2UL;
   tf->codes[20727] = 0x00010aeb455cc818UL;
   tf->codes[20728] = 0x00010c1c6aa4d8a6UL;
   tf->codes[20729] = 0x00010ce3e1d07faeUL;
   tf->codes[20730] = 0x00010d393433e7b7UL;
   tf->codes[20731] = 0x00010da1486728daUL;
   tf->codes[20732] = 0x00010daf3c7b88cbUL;
   tf->codes[20733] = 0x00010e42172800d5UL;
   tf->codes[20734] = 0x00010e4a18b5cac4UL;
   tf->codes[20735] = 0x00010e521a4394b3UL;
   tf->codes[20736] = 0x00010e960a314640UL;
   tf->codes[20737] = 0x00010ecc40999da1UL;
   tf->codes[20738] = 0x00010f170d49fc44UL;
   tf->codes[20739] = 0x00010fe1b847f412UL;
   tf->codes[20740] = 0x00010ff529c4de7bUL;
   tf->codes[20741] = 0x00010ff5d971efcaUL;
   tf->codes[20742] = 0x00010fff3a59dc57UL;
   tf->codes[20743] = 0x000110082623bd5aUL;
   tf->codes[20744] = 0x000110c37db33299UL;
   tf->codes[20745] = 0x000110c7d650a038UL;
   tf->codes[20746] = 0x000110d137388cc5UL;
   tf->codes[20747] = 0x0001110857dcfb3aUL;
   tf->codes[20748] = 0x00011230915b2ac5UL;
   tf->codes[20749] = 0x0001123683e1c0c7UL;
   tf->codes[20750] = 0x000112552abec5e5UL;
   tf->codes[20751] = 0x000112f5bef0981bUL;
   tf->codes[20752] = 0x000113622bc146ddUL;
   tf->codes[20753] = 0x00011431df09bd99UL;
   tf->codes[20754] = 0x00011447d4abe779UL;
   tf->codes[20755] = 0x000114581256811cUL;
   tf->codes[20756] = 0x00011561df86b14eUL;
   tf->codes[20757] = 0x00011625adc1fc06UL;
   tf->codes[20758] = 0x0001179fcb423d0fUL;
   tf->codes[20759] = 0x00011864f8d7aa65UL;
   tf->codes[20760] = 0x000118c28757e222UL;
   tf->codes[20761] = 0x0001191c3258b7caUL;
   tf->codes[20762] = 0x000119d998ef60f6UL;
   tf->codes[20763] = 0x00011a07933ae8a3UL;
   tf->codes[20764] = 0x00011acf7f849b35UL;
   tf->codes[20765] = 0x00011b05f07bf85bUL;
   tf->codes[20766] = 0x00011b96819236b3UL;
   tf->codes[20767] = 0x00011cb6446490c5UL;
   tf->codes[20768] = 0x00011cb9ed54ed15UL;
   tf->codes[20769] = 0x00011db58be1b791UL;
   tf->codes[20770] = 0x00011e231d7d832cUL;
   tf->codes[20771] = 0x00011e247cd7a5caUL;
   tf->codes[20772] = 0x00011e38d890a747UL;
   tf->codes[20773] = 0x00011e8ea0121adaUL;
   tf->codes[20774] = 0x00011ed0f616a404UL;
   tf->codes[20775] = 0x00011ee551cfa581UL;
   tf->codes[20776] = 0x00011efa97c4be12UL;
   tf->codes[20777] = 0x00011f9ff9b20971UL;
   tf->codes[20778] = 0x0001207f006902bcUL;
   tf->codes[20779] = 0x000120c11bde8621UL;
   tf->codes[20780] = 0x0001216050b635b9UL;
   tf->codes[20781] = 0x000121a10cd19680UL;
   tf->codes[20782] = 0x000121a440a3e746UL;
   tf->codes[20783] = 0x000121f3a080b94dUL;
   tf->codes[20784] = 0x00012221603d3b35UL;
   tf->codes[20785] = 0x0001224c9bd47da6UL;
   tf->codes[20786] = 0x0001232191f67915UL;
   tf->codes[20787] = 0x00012333698a3b1bUL;
   tf->codes[20788] = 0x0001239e3c71c17aUL;
   tf->codes[20789] = 0x000123dcaef6e88fUL;
   tf->codes[20790] = 0x000123dd2414f419UL;
   tf->codes[20791] = 0x0001241e1abf5aa5UL;
   tf->codes[20792] = 0x000124eb49e291eaUL;
   tf->codes[20793] = 0x0001255a756785e8UL;
   tf->codes[20794] = 0x00012579cbf19c55UL;
   tf->codes[20795] = 0x00012587c005fc46UL;
   tf->codes[20796] = 0x00012626ba4ea619UL;
   tf->codes[20797] = 0x0001273a9813d427UL;
   tf->codes[20798] = 0x000129274f7a5fb9UL;
   tf->codes[20799] = 0x000129faabb332c5UL;
   tf->codes[20800] = 0x00012a0272b1f6efUL;
   tf->codes[20801] = 0x00012a31cc57a13aUL;
   tf->codes[20802] = 0x00012a45034585deUL;
   tf->codes[20803] = 0x00012ae6bc4274edUL;
   tf->codes[20804] = 0x00012b394ff197baUL;
   tf->codes[20805] = 0x00012b9afc803751UL;
   tf->codes[20806] = 0x00012cebed7069d6UL;
   tf->codes[20807] = 0x00012d1bf6c32570UL;
   tf->codes[20808] = 0x00012d6ddac536eeUL;
   tf->codes[20809] = 0x00012dd997e8d461UL;
   tf->codes[20810] = 0x00012e07ccc361d3UL;
   tf->codes[20811] = 0x00012ea3cdc8c0a5UL;
   tf->codes[20812] = 0x00012ea4b804d7b9UL;
   tf->codes[20813] = 0x00012f1b6ff98a1cUL;
   tf->codes[20814] = 0x00012fa4e9be1599UL;
   tf->codes[20815] = 0x00012fe4467f53c2UL;
   tf->codes[20816] = 0x00013065beb61550UL;
   tf->codes[20817] = 0x000131bca22cddd7UL;
   tf->codes[20818] = 0x000131def1fa3f45UL;
   tf->codes[20819] = 0x00013270a7db9a76UL;
   tf->codes[20820] = 0x000132869d7dc456UL;
   tf->codes[20821] = 0x000133297b45d03eUL;
   tf->codes[20822] = 0x0001335b939fbfc5UL;
   tf->codes[20823] = 0x000133e9db1fc46bUL;
   tf->codes[20824] = 0x00013469b96d5d96UL;
   tf->codes[20825] = 0x000134aff2f148d5UL;
   tf->codes[20826] = 0x0001358b50b7e5d0UL;
   tf->codes[20827] = 0x000135e1c7e66ab2UL;
   tf->codes[20828] = 0x000135e39c5e98daUL;
   tf->codes[20829] = 0x000137dc73615635UL;
   tf->codes[20830] = 0x000138f9b20e70d0UL;
   tf->codes[20831] = 0x000139df206a0ba7UL;
   tf->codes[20832] = 0x00013a941054df5aUL;
   tf->codes[20833] = 0x00013aba43a1a2ddUL;
   tf->codes[20834] = 0x00013ac5b390c357UL;
   tf->codes[20835] = 0x00013ad0e8f0de0cUL;
   tf->codes[20836] = 0x00013b5853ae359cUL;
   tf->codes[20837] = 0x00013b6ef8fd70cbUL;
   tf->codes[20838] = 0x00013bd18fc82776UL;
   tf->codes[20839] = 0x00013c3585ed00bfUL;
   tf->codes[20840] = 0x00013ca5611f060cUL;
   tf->codes[20841] = 0x00013d2b31f33539UL;
   tf->codes[20842] = 0x00013deda0d45d53UL;
   tf->codes[20843] = 0x00013ebe3e58eb23UL;
   tf->codes[20844] = 0x00013ebfd8421386UL;
   tf->codes[20845] = 0x00013ed25f82e6dbUL;
   tf->codes[20846] = 0x00013f5ab47c557fUL;
   tf->codes[20847] = 0x00013fc93054382eUL;
   tf->codes[20848] = 0x000140c1d59db7a9UL;
   tf->codes[20849] = 0x00014109a90acb4bUL;
   tf->codes[20850] = 0x0001411c304b9ea0UL;
   tf->codes[20851] = 0x0001413c3682c65cUL;
   tf->codes[20852] = 0x0001415e865027caUL;
   tf->codes[20853] = 0x000142087b69e68dUL;
   tf->codes[20854] = 0x000142316d6aef4cUL;
   tf->codes[20855] = 0x0001423d52781b50UL;
   tf->codes[20856] = 0x0001429c405275abUL;
   tf->codes[20857] = 0x000142d709e74070UL;
   tf->codes[20858] = 0x000143071339fc0aUL;
   tf->codes[20859] = 0x000143ad99f26442UL;
   tf->codes[20860] = 0x00014452fbdfafa1UL;
   tf->codes[20861] = 0x000145c9e58d9fe4UL;
   tf->codes[20862] = 0x0001461aa4c49489UL;
   tf->codes[20863] = 0x00014664121ad08eUL;
   tf->codes[20864] = 0x000146753a018145UL;
   tf->codes[20865] = 0x000146871195434bUL;
   tf->codes[20866] = 0x0001471c7066faccUL;
   tf->codes[20867] = 0x00014748211c48c7UL;
   tf->codes[20868] = 0x000147c0386b1dc8UL;
   tf->codes[20869] = 0x0001485a2a6948adUL;
   tf->codes[20870] = 0x000148f83a75db6cUL;
   tf->codes[20871] = 0x0001490753555836UL;
   tf->codes[20872] = 0x00014949a959e160UL;
   tf->codes[20873] = 0x00014a487bb8fca2UL;
   tf->codes[20874] = 0x00014a5844458abbUL;
   tf->codes[20875] = 0x00014af5a4a50c2bUL;
   tf->codes[20876] = 0x00014b27f78e0177UL;
   tf->codes[20877] = 0x00014b2c502b6f16UL;
   tf->codes[20878] = 0x00014b871ff76197UL;
   tf->codes[20879] = 0x00014bb58f60f4ceUL;
   tf->codes[20880] = 0x00014bbef048e15bUL;
   tf->codes[20881] = 0x00014c00d12f5efbUL;
   tf->codes[20882] = 0x00014c0ae1c45cd7UL;
   tf->codes[20883] = 0x00014c31c4be31a9UL;
   tf->codes[20884] = 0x00014c757a1cdd71UL;
   tf->codes[20885] = 0x00014cc340108715UL;
   tf->codes[20886] = 0x00014cf592f97c61UL;
   tf->codes[20887] = 0x00014cfd59f8408bUL;
   tf->codes[20888] = 0x00014ee99c40c093UL;
   tf->codes[20889] = 0x00014f1044ab8fa0UL;
   tf->codes[20890] = 0x00014f69efac6548UL;
   tf->codes[20891] = 0x00015021292d72adUL;
   tf->codes[20892] = 0x000150496b816a1dUL;
   tf->codes[20893] = 0x00015050f7f12882UL;
   tf->codes[20894] = 0x0001509f3302ddb0UL;
   tf->codes[20895] = 0x000150a560187977UL;
   tf->codes[20896] = 0x000150fff5556633UL;
   tf->codes[20897] = 0x0001513f5216a45cUL;
   tf->codes[20898] = 0x000151780ca43b34UL;
   tf->codes[20899] = 0x000151e2df8bc193UL;
   tf->codes[20900] = 0x000152cb81b9ad30UL;
   tf->codes[20901] = 0x000153409fc53730UL;
   tf->codes[20902] = 0x00015364897bc101UL;
   tf->codes[20903] = 0x00015388adc15097UL;
   tf->codes[20904] = 0x000153b5f85fc6f5UL;
   tf->codes[20905] = 0x00015455a2558217UL;
   tf->codes[20906] = 0x000154d5f5c126ccUL;
   tf->codes[20907] = 0x000154e4d4119dd1UL;
   tf->codes[20908] = 0x0001550bf19a7868UL;
   tf->codes[20909] = 0x00015521e73ca248UL;
   tf->codes[20910] = 0x000155b20334d516UL;
   tf->codes[20911] = 0x000155cd763f896eUL;
   tf->codes[20912] = 0x0001562721405f16UL;
   tf->codes[20913] = 0x0001566225642fa0UL;
   tf->codes[20914] = 0x00015679ef7e87a8UL;
   tf->codes[20915] = 0x0001569c79daeedbUL;
   tf->codes[20916] = 0x000156e70bfc47b9UL;
   tf->codes[20917] = 0x000156f1cc3e56e4UL;
   tf->codes[20918] = 0x000157a5975e0dbeUL;
   tf->codes[20919] = 0x000157b8ce4bf262UL;
   tf->codes[20920] = 0x00015802011328a2UL;
   tf->codes[20921] = 0x0001587bb24b2606UL;
   tf->codes[20922] = 0x000158aa5c43bf02UL;
   tf->codes[20923] = 0x000158eaa341143fUL;
   tf->codes[20924] = 0x00015960ab88b553UL;
   tf->codes[20925] = 0x0001597a4a1b3b83UL;
   tf->codes[20926] = 0x00015a452fa83916UL;
   tf->codes[20927] = 0x00015a78323e3fb1UL;
   tf->codes[20928] = 0x00015af676a2b079UL;
   tf->codes[20929] = 0x00015b08fde383ceUL;
   tf->codes[20930] = 0x00015b96d0457ceaUL;
   tf->codes[20931] = 0x00015bfd4a8f95aaUL;
   tf->codes[20932] = 0x00015bfea9e9b848UL;
   tf->codes[20933] = 0x00015c2fd80790bbUL;
   tf->codes[20934] = 0x00015c3938ef7d48UL;
   tf->codes[20935] = 0x00015cd031aa5d2cUL;
   tf->codes[20936] = 0x00015d42cb90a7b5UL;
   tf->codes[20937] = 0x00015de325337426UL;
   tf->codes[20938] = 0x00015e1a45d7e29bUL;
   tf->codes[20939] = 0x00015e65fcc45852UL;
   tf->codes[20940] = 0x00015ee7ea19256aUL;
   tf->codes[20941] = 0x00015f645a05680aUL;
   tf->codes[20942] = 0x00015f7b39e3a8feUL;
   tf->codes[20943] = 0x00015f80b74c3376UL;
   tf->codes[20944] = 0x00015f84d55a9b50UL;
   tf->codes[20945] = 0x00015fbeef4254c6UL;
   tf->codes[20946] = 0x0001600ae0bdd042UL;
   tf->codes[20947] = 0x0001606d778886edUL;
   tf->codes[20948] = 0x0001611682662e9cUL;
   tf->codes[20949] = 0x0001613f39d83196UL;
   tf->codes[20950] = 0x00016160d9f881b5UL;
   tf->codes[20951] = 0x000161e5fb1f9f93UL;
   tf->codes[20952] = 0x0001623ad864fc12UL;
   tf->codes[20953] = 0x000162452388ffb3UL;
   tf->codes[20954] = 0x0001627183eb5efdUL;
   tf->codes[20955] = 0x000162bab6b2953dUL;
   tf->codes[20956] = 0x000162c45229878fUL;
   tf->codes[20957] = 0x0001631a19aafb22UL;
   tf->codes[20958] = 0x0001634bf775e4e4UL;
   tf->codes[20959] = 0x000163a1bef75877UL;
   tf->codes[20960] = 0x000163be56cd29a8UL;
   tf->codes[20961] = 0x0001646eb38b89f7UL;
   tf->codes[20962] = 0x000164846e9eae12UL;
   tf->codes[20963] = 0x000164917876f6efUL;
   tf->codes[20964] = 0x000164b2de084149UL;
   tf->codes[20965] = 0x000164bd292c44eaUL;
   tf->codes[20966] = 0x000164e481442546UL;
   tf->codes[20967] = 0x0001652f888389aeUL;
   tf->codes[20968] = 0x00016568f2be31d5UL;
   tf->codes[20969] = 0x0001659f9e4494c0UL;
   tf->codes[20970] = 0x000165f4066be5b5UL;
   tf->codes[20971] = 0x00016739124eec36UL;
   tf->codes[20972] = 0x000168b15b56ff17UL;
   tf->codes[20973] = 0x0001696b18fd4bf3UL;
   tf->codes[20974] = 0x000169fabfd77337UL;
   tf->codes[20975] = 0x000169fdf3a9c3fdUL;
   tf->codes[20976] = 0x00016a990a730bbbUL;
   tf->codes[20977] = 0x00016b77617cf3b7UL;
   tf->codes[20978] = 0x00016bdd2c19fb28UL;
   tf->codes[20979] = 0x00016bef3e3cc2f3UL;
   tf->codes[20980] = 0x00016c02752aa797UL;
   tf->codes[20981] = 0x00016c58773b20efUL;
   tf->codes[20982] = 0x00016d899c83317dUL;
   tf->codes[20983] = 0x00016d9fccb46122UL;
   tf->codes[20984] = 0x00016daac7857612UL;
   tf->codes[20985] = 0x00016de431c01e39UL;
   tf->codes[20986] = 0x00016e24eddb7f00UL;
   tf->codes[20987] = 0x00016e81921f9fa9UL;
   tf->codes[20988] = 0x00016eab33cdb9b7UL;
   tf->codes[20989] = 0x00016ed794301901UL;
   tf->codes[20990] = 0x00016f5c05aa2590UL;
   tf->codes[20991] = 0x00016fbcc7fcae13UL;
   tf->codes[20992] = 0x0001704ce3f4e0e1UL;
   tf->codes[20993] = 0x0001707267949315UL;
   tf->codes[20994] = 0x000170b1fee4d703UL;
   tf->codes[20995] = 0x0001719a6683bcdbUL;
   tf->codes[20996] = 0x00017218705927deUL;
   tf->codes[20997] = 0x0001724287254d76UL;
   tf->codes[20998] = 0x000172cd6043fb91UL;
   tf->codes[20999] = 0x00017351972f025bUL;
   tf->codes[21000] = 0x0001735be25305fcUL;
   tf->codes[21001] = 0x000173b3f36ab341UL;
   tf->codes[21002] = 0x000173e1edb63aeeUL;
   tf->codes[21003] = 0x000174427579bdacUL;
   tf->codes[21004] = 0x000174d16ca6d3a1UL;
   tf->codes[21005] = 0x00017510544a0640UL;
   tf->codes[21006] = 0x00017525d4ce2496UL;
   tf->codes[21007] = 0x00017562ad6a2348UL;
   tf->codes[21008] = 0x0001769029c1d786UL;
   tf->codes[21009] = 0x000176970684849cUL;
   tf->codes[21010] = 0x0001771f960cf905UL;
   tf->codes[21011] = 0x00017835484a553bUL;
   tf->codes[21012] = 0x000178a55e0b604dUL;
   tf->codes[21013] = 0x0001792576e7ff3dUL;
   tf->codes[21014] = 0x00017937fe28d292UL;
   tf->codes[21015] = 0x0001799b7f2fa051UL;
   tf->codes[21016] = 0x000179bcaa31e4e6UL;
   tf->codes[21017] = 0x00017a3cc30e83d6UL;
   tf->codes[21018] = 0x00017a83ac3f8064UL;
   tf->codes[21019] = 0x00017ab80e2fa99dUL;
   tf->codes[21020] = 0x00017b2390c4414bUL;
   tf->codes[21021] = 0x00017b4864b6e230UL;
   tf->codes[21022] = 0x00017b64c1fdad9cUL;
   tf->codes[21023] = 0x00017c23c27d7f2bUL;
   tf->codes[21024] = 0x00017c6777dc2af3UL;
   tf->codes[21025] = 0x00017d23b9a7b746UL;
   tf->codes[21026] = 0x00017d258e1fe56eUL;
   tf->codes[21027] = 0x00017d3e07e74ec5UL;
   tf->codes[21028] = 0x00017d41eb66b0daUL;
   tf->codes[21029] = 0x00017d426084bc64UL;
   tf->codes[21030] = 0x00017d6734775d49UL;
   tf->codes[21031] = 0x00017da5e18b8a23UL;
   tf->codes[21032] = 0x00017dba3d448ba0UL;
   tf->codes[21033] = 0x00017dd65ffc5147UL;
   tf->codes[21034] = 0x00017de8acae1ed7UL;
   tf->codes[21035] = 0x00017e1aff971423UL;
   tf->codes[21036] = 0x00017e24d59d0c3aUL;
   tf->codes[21037] = 0x00017e83fe066c5aUL;
   tf->codes[21038] = 0x00017e9d277ae700UL;
   tf->codes[21039] = 0x00017f10e62c4e62UL;
   tf->codes[21040] = 0x00017f21d383f954UL;
   tf->codes[21041] = 0x00017f2f17eb47f6UL;
   tf->codes[21042] = 0x00018068ee6e33c2UL;
   tf->codes[21043] = 0x00018158e27cd7ffUL;
   tf->codes[21044] = 0x00018189d60baaadUL;
   tf->codes[21045] = 0x0001825a7390387dUL;
   tf->codes[21046] = 0x000182a87412e7e6UL;
   tf->codes[21047] = 0x000182d87d65a380UL;
   tf->codes[21048] = 0x0001831c6d53550dUL;
   tf->codes[21049] = 0x0001837443dbfc8dUL;
   tf->codes[21050] = 0x00018385a651b309UL;
   tf->codes[21051] = 0x000183f965031a6bUL;
   tf->codes[21052] = 0x0001844d580c5fd6UL;
   tf->codes[21053] = 0x0001848144de7d85UL;
   tf->codes[21054] = 0x0001849cb7e931ddUL;
   tf->codes[21055] = 0x000184e91e82b8e3UL;
   tf->codes[21056] = 0x0001854e7401b4caUL;
   tf->codes[21057] = 0x0001861c8d610323UL;
   tf->codes[21058] = 0x00018621208d7687UL;
   tf->codes[21059] = 0x0001865f588397d7UL;
   tf->codes[21060] = 0x000186937fe4bb4bUL;
   tf->codes[21061] = 0x00018760af07f290UL;
   tf->codes[21062] = 0x00018765423465f4UL;
   tf->codes[21063] = 0x0001877f55e4f7aeUL;
   tf->codes[21064] = 0x000187a080e73c43UL;
   tf->codes[21065] = 0x00018865ae7ca999UL;
   tf->codes[21066] = 0x0001887f4d0f2fc9UL;
   tf->codes[21067] = 0x000188b50e597ba0UL;
   tf->codes[21068] = 0x000188ebf46ee450UL;
   tf->codes[21069] = 0x00018946148dc582UL;
   tf->codes[21070] = 0x000189a4182c08c9UL;
   tf->codes[21071] = 0x000189f5c19f1482UL;
   tf->codes[21072] = 0x00018a01318e34fcUL;
   tf->codes[21073] = 0x00018afa8684c5c6UL;
   tf->codes[21074] = 0x00018bcfb735c6faUL;
   tf->codes[21075] = 0x00018c0921706f21UL;
   tf->codes[21076] = 0x00018c0ffe331c37UL;
   tf->codes[21077] = 0x00018c241f5d17efUL;
   tf->codes[21078] = 0x00018ca13ef66bdeUL;
   tf->codes[21079] = 0x00018cc6c2961e12UL;
   tf->codes[21080] = 0x00018d86ad5206b5UL;
   tf->codes[21081] = 0x00018e8e6b7b02faUL;
   tf->codes[21082] = 0x00018ebb7b8a7393UL;
   tf->codes[21083] = 0x00018ee8c628e9f1UL;
   tf->codes[21084] = 0x00018f82b82714d6UL;
   tf->codes[21085] = 0x00018f92f5d1ae79UL;
   tf->codes[21086] = 0x0001903f6f10acb3UL;
   tf->codes[21087] = 0x00019122ce65139dUL;
   tf->codes[21088] = 0x000191413ab312f6UL;
   tf->codes[21089] = 0x0001916d25f766b6UL;
   tf->codes[21090] = 0x0001917611c147b9UL;
   tf->codes[21091] = 0x000191eba4eadd43UL;
   tf->codes[21092] = 0x000192271e2cb957UL;
   tf->codes[21093] = 0x00019284378ee58aUL;
   tf->codes[21094] = 0x000192ea7749f885UL;
   tf->codes[21095] = 0x0001933e6a533df0UL;
   tf->codes[21096] = 0x00019356e41aa747UL;
   tf->codes[21097] = 0x0001935c26f42bfaUL;
   tf->codes[21098] = 0x0001935f203776fbUL;
   tf->codes[21099] = 0x0001936a559791b0UL;
   tf->codes[21100] = 0x00019389ac21a81dUL;
   tf->codes[21101] = 0x000193bce946b47dUL;
   tf->codes[21102] = 0x000193ecb80a6a52UL;
   tf->codes[21103] = 0x00019453a7728e9cUL;
   tf->codes[21104] = 0x00019475bcb0ea45UL;
   tf->codes[21105] = 0x000194c1739d5ffcUL;
   tf->codes[21106] = 0x000195ab3a966872UL;
   tf->codes[21107] = 0x000195d58bf193cfUL;
   tf->codes[21108] = 0x00019643581c652fUL;
   tf->codes[21109] = 0x00019656547b440eUL;
   tf->codes[21110] = 0x00019674863a3da2UL;
   tf->codes[21111] = 0x000196a3a550e228UL;
   tf->codes[21112] = 0x000196d6a7e6e8c3UL;
   tf->codes[21113] = 0x00019768d2e64f7eUL;
   tf->codes[21114] = 0x000197791090e921UL;
   tf->codes[21115] = 0x000197ad7281125aUL;
   tf->codes[21116] = 0x000197e1d4713b93UL;
   tf->codes[21117] = 0x000197e6679daef7UL;
   tf->codes[21118] = 0x0001985b4b1a3332UL;
   tf->codes[21119] = 0x000198cfb978abe3UL;
   tf->codes[21120] = 0x000198e74903fe26UL;
   tf->codes[21121] = 0x000199157dde8b98UL;
   tf->codes[21122] = 0x00019920039194feUL;
   tf->codes[21123] = 0x000199829a5c4ba9UL;
   tf->codes[21124] = 0x00019a01c8fcd385UL;
   tf->codes[21125] = 0x00019a170ef1ec16UL;
   tf->codes[21126] = 0x00019a942e8b4005UL;
   tf->codes[21127] = 0x00019add9be17c0aUL;
   tf->codes[21128] = 0x00019b469a50d441UL;
   tf->codes[21129] = 0x00019b757ed87302UL;
   tf->codes[21130] = 0x00019bdd1deda89bUL;
   tf->codes[21131] = 0x00019d3a2e7a0ce9UL;
   tf->codes[21132] = 0x00019d95e882167eUL;
   tf->codes[21133] = 0x00019db454d015d7UL;
   tf->codes[21134] = 0x00019dcabf904b41UL;
   tf->codes[21135] = 0x00019e48c965b644UL;
   tf->codes[21136] = 0x00019e9320f8095dUL;
   tf->codes[21137] = 0x00019ef24961697dUL;
   tf->codes[21138] = 0x00019f6851a90a91UL;
   tf->codes[21139] = 0x00019f6a60b03e7eUL;
   tf->codes[21140] = 0x00019f897cab4f26UL;
   tf->codes[21141] = 0x00019fdd35258eccUL;
   tf->codes[21142] = 0x0001a0241e568b5aUL;
   tf->codes[21143] = 0x0001a05b7989ff94UL;
   tf->codes[21144] = 0x0001a127be711fc5UL;
   tf->codes[21145] = 0x0001a1763411dab8UL;
   tf->codes[21146] = 0x0001a20824823baeUL;
   tf->codes[21147] = 0x0001a2c34182ab28UL;
   tf->codes[21148] = 0x0001a34b967c19ccUL;
   tf->codes[21149] = 0x0001a3a5f12a00c3UL;
   tf->codes[21150] = 0x0001a3cac51ca1a8UL;
   tf->codes[21151] = 0x0001a3ce6e0cfdf8UL;
   tf->codes[21152] = 0x0001a3d12cc14334UL;
   tf->codes[21153] = 0x0001a4334e6dee55UL;
   tf->codes[21154] = 0x0001a4fe6e89f1adUL;
   tf->codes[21155] = 0x0001a502c7275f4cUL;
   tf->codes[21156] = 0x0001a529aa21341eUL;
   tf->codes[21157] = 0x0001a53345982670UL;
   tf->codes[21158] = 0x0001a5c77f9ec118UL;
   tf->codes[21159] = 0x0001a5ce96f073f3UL;
   tf->codes[21160] = 0x0001a62040637facUL;
   tf->codes[21161] = 0x0001a67b102f722dUL;
   tf->codes[21162] = 0x0001a6bb1c9dc1a5UL;
   tf->codes[21163] = 0x0001a722f641fd03UL;
   tf->codes[21164] = 0x0001a803d1712476UL;
   tf->codes[21165] = 0x0001a8223dbf23cfUL;
   tf->codes[21166] = 0x0001a864ce52b2beUL;
   tf->codes[21167] = 0x0001a869d69d31acUL;
   tf->codes[21168] = 0x0001a876a5e674c4UL;
   tf->codes[21169] = 0x0001a959558dca5fUL;
   tf->codes[21170] = 0x0001aa35287272e4UL;
   tf->codes[21171] = 0x0001aa36fceaa10cUL;
   tf->codes[21172] = 0x0001aa447be0f573UL;
   tf->codes[21173] = 0x0001aa55a3c7a62aUL;
   tf->codes[21174] = 0x0001ab13ba0b60a5UL;
   tf->codes[21175] = 0x0001ab8912a5f06aUL;
   tf->codes[21176] = 0x0001abb6d2627252UL;
   tf->codes[21177] = 0x0001abddb55c4724UL;
   tf->codes[21178] = 0x0001ac13ebc49e85UL;
   tf->codes[21179] = 0x0001ac19de4b3487UL;
   tf->codes[21180] = 0x0001ac1b78345ceaUL;
   tf->codes[21181] = 0x0001ac221a68043bUL;
   tf->codes[21182] = 0x0001ac8142d1645bUL;
   tf->codes[21183] = 0x0001ace3d99c1b06UL;
   tf->codes[21184] = 0x0001ad0330263173UL;
   tf->codes[21185] = 0x0001ad58f7a7a506UL;
   tf->codes[21186] = 0x0001ad5b7bcce47dUL;
   tf->codes[21187] = 0x0001ad876711383dUL;
   tf->codes[21188] = 0x0001addc445694bcUL;
   tf->codes[21189] = 0x0001ae29cfbb389bUL;
   tf->codes[21190] = 0x0001ae76ab72cb2bUL;
   tf->codes[21191] = 0x0001aec227d03b1dUL;
   tf->codes[21192] = 0x0001aeca9e7c1096UL;
   tf->codes[21193] = 0x0001aed60e6b3110UL;
   tf->codes[21194] = 0x0001af0ae57965d3UL;
   tf->codes[21195] = 0x0001af2399cfd4efUL;
   tf->codes[21196] = 0x0001af25e3660ea1UL;
   tf->codes[21197] = 0x0001af33625c6308UL;
   tf->codes[21198] = 0x0001af9584090e29UL;
   tf->codes[21199] = 0x0001afa302ff6290UL;
   tf->codes[21200] = 0x0001b003c551eb13UL;
   tf->codes[21201] = 0x0001b0827ed46765UL;
   tf->codes[21202] = 0x0001b09ccd13fee4UL;
   tf->codes[21203] = 0x0001b0c1db95a58eUL;
   tf->codes[21204] = 0x0001b0eb42b4b9d7UL;
   tf->codes[21205] = 0x0001b147ac69d4bbUL;
   tf->codes[21206] = 0x0001b15c7d40e1c2UL;
   tf->codes[21207] = 0x0001b162aa567d89UL;
   tf->codes[21208] = 0x0001b25bff4d0e53UL;
   tf->codes[21209] = 0x0001b27cb531475eUL;
   tf->codes[21210] = 0x0001b3876c9d8ea4UL;
   tf->codes[21211] = 0x0001b3abcb7223ffUL;
   tf->codes[21212] = 0x0001b3c7b39ae3e1UL;
   tf->codes[21213] = 0x0001b41663caa499UL;
   tf->codes[21214] = 0x0001b4e7766d3df3UL;
   tf->codes[21215] = 0x0001b52a7c1ed86cUL;
   tf->codes[21216] = 0x0001b5369bbb0a35UL;
   tf->codes[21217] = 0x0001b5a3431abebcUL;
   tf->codes[21218] = 0x0001b5a970305a83UL;
   tf->codes[21219] = 0x0001b5b7d962c5feUL;
   tf->codes[21220] = 0x0001b5d97983161dUL;
   tf->codes[21221] = 0x0001b678e8e9cb7aUL;
   tf->codes[21222] = 0x0001b6903de617f8UL;
   tf->codes[21223] = 0x0001b6afceff342aUL;
   tf->codes[21224] = 0x0001b72b8f3e657bUL;
   tf->codes[21225] = 0x0001b7535c745161UL;
   tf->codes[21226] = 0x0001b7bd7faec671UL;
   tf->codes[21227] = 0x0001b85a30613692UL;
   tf->codes[21228] = 0x0001b8b3db620c3aUL;
   tf->codes[21229] = 0x0001b901a155b5deUL;
   tf->codes[21230] = 0x0001b92724f56812UL;
   tf->codes[21231] = 0x0001b9c6945c1d6fUL;
   tf->codes[21232] = 0x0001b9e32c31eea0UL;
   tf->codes[21233] = 0x0001ba124b489326UL;
   tf->codes[21234] = 0x0001ba746cf53e47UL;
   tf->codes[21235] = 0x0001ba934e61492aUL;
   tf->codes[21236] = 0x0001ba9aa04201caUL;
   tf->codes[21237] = 0x0001baa94403730aUL;
   tf->codes[21238] = 0x0001bab772a6d8c0UL;
   tf->codes[21239] = 0x0001bab9bc3d1272UL;
   tf->codes[21240] = 0x0001bad236047bc9UL;
   tf->codes[21241] = 0x0001bb825833d653UL;
   tf->codes[21242] = 0x0001bb955492b532UL;
   tf->codes[21243] = 0x0001bbd610ae15f9UL;
   tf->codes[21244] = 0x0001bbfc096bd3b7UL;
   tf->codes[21245] = 0x0001bc3ed48e686bUL;
   tf->codes[21246] = 0x0001bc98ba1e43d8UL;
   tf->codes[21247] = 0x0001bca42a0d6452UL;
   tf->codes[21248] = 0x0001bcbc6945c7e4UL;
   tf->codes[21249] = 0x0001bdbac686d79cUL;
   tf->codes[21250] = 0x0001be364c370328UL;
   tf->codes[21251] = 0x0001beb037fe0651UL;
   tf->codes[21252] = 0x0001bed33778790eUL;
   tf->codes[21253] = 0x0001bf5b1753dc28UL;
   tf->codes[21254] = 0x0001bf8ddf5adcfeUL;
   tf->codes[21255] = 0x0001bf94bc1d8a14UL;
   tf->codes[21256] = 0x0001c034a0a24afbUL;
   tf->codes[21257] = 0x0001c0baac057fedUL;
   tf->codes[21258] = 0x0001c10921a63ae0UL;
   tf->codes[21259] = 0x0001c12be691a7d8UL;
   tf->codes[21260] = 0x0001c1433b8df456UL;
   tf->codes[21261] = 0x0001c1684a0f9b00UL;
   tf->codes[21262] = 0x0001c1e27065a3eeUL;
   tf->codes[21263] = 0x0001c1e4f48ae365UL;
   tf->codes[21264] = 0x0001c222b762f92bUL;
   tf->codes[21265] = 0x0001c268b657dea5UL;
   tf->codes[21266] = 0x0001c2b93affcd85UL;
   tf->codes[21267] = 0x0001c2c5cfba0ad8UL;
   tf->codes[21268] = 0x0001c2c978aa6728UL;
   tf->codes[21269] = 0x0001c2d4e89987a2UL;
   tf->codes[21270] = 0x0001c2e142c4bf30UL;
   tf->codes[21271] = 0x0001c300994ed59dUL;
   tf->codes[21272] = 0x0001c30358031ad9UL;
   tf->codes[21273] = 0x0001c3bf24b09ba2UL;
   tf->codes[21274] = 0x0001c47ba10b2dbaUL;
   tf->codes[21275] = 0x0001c51851bd9ddbUL;
   tf->codes[21276] = 0x0001c545d6eb19feUL;
   tf->codes[21277] = 0x0001c59ff709fb30UL;
   tf->codes[21278] = 0x0001c63137cd4ad7UL;
   tf->codes[21279] = 0x0001c6c3d7eabd1cUL;
   tf->codes[21280] = 0x0001c6c5ac62eb44UL;
   tf->codes[21281] = 0x0001c73f230be2e3UL;
   tf->codes[21282] = 0x0001c786815aeafbUL;
   tf->codes[21283] = 0x0001c8120a26aa65UL;
   tf->codes[21284] = 0x0001c86d1481a2abUL;
   tf->codes[21285] = 0x0001c922b41987adUL;
   tf->codes[21286] = 0x0001c93f867e5ea3UL;
   tf->codes[21287] = 0x0001c948e7664b30UL;
   tf->codes[21288] = 0x0001c999e12c459aUL;
   tf->codes[21289] = 0x0001c99c65518511UL;
   tf->codes[21290] = 0x0001c9aace83f08cUL;
   tf->codes[21291] = 0x0001c9e1b499593cUL;
   tf->codes[21292] = 0x0001c9e5d2a7c116UL;
   tf->codes[21293] = 0x0001ca28d8595b8fUL;
   tf->codes[21294] = 0x0001ca53d961983bUL;
   tf->codes[21295] = 0x0001ca65014848f2UL;
   tf->codes[21296] = 0x0001caa0056c197cUL;
   tf->codes[21297] = 0x0001cb48d5babb66UL;
   tf->codes[21298] = 0x0001cbb0af5ef6c4UL;
   tf->codes[21299] = 0x0001cbc3abbdd5a3UL;
   tf->codes[21300] = 0x0001cbe9a47b9361UL;
   tf->codes[21301] = 0x0001cc1087756833UL;
   tf->codes[21302] = 0x0001cc5bc943d260UL;
   tf->codes[21303] = 0x0001cc643fefa7d9UL;
   tf->codes[21304] = 0x0001cc9daa2a5000UL;
   tf->codes[21305] = 0x0001cda7ec788bbcUL;
   tf->codes[21306] = 0x0001cde27b7e50bcUL;
   tf->codes[21307] = 0x0001ce0abdd2482cUL;
   tf->codes[21308] = 0x0001ce6ca4efed88UL;
   tf->codes[21309] = 0x0001cecb583b421eUL;
   tf->codes[21310] = 0x0001cf2abb33a803UL;
   tf->codes[21311] = 0x0001cf879a06ce71UL;
   tf->codes[21312] = 0x0001d001faebdd24UL;
   tf->codes[21313] = 0x0001d012389676c7UL;
   tf->codes[21314] = 0x0001d081641b6ac5UL;
   tf->codes[21315] = 0x0001d0845d5eb5c6UL;
   tf->codes[21316] = 0x0001d09d11b524e2UL;
   tf->codes[21317] = 0x0001d19332d964e6UL;
   tf->codes[21318] = 0x0001d1df9972ebecUL;
   tf->codes[21319] = 0x0001d33d59ac6189UL;
   tf->codes[21320] = 0x0001d34470fe1464UL;
   tf->codes[21321] = 0x0001d349ee669edcUL;
   tf->codes[21322] = 0x0001d350560b4068UL;
   tf->codes[21323] = 0x0001d376c3e709b0UL;
   tf->codes[21324] = 0x0001d3eabd2776d7UL;
   tf->codes[21325] = 0x0001d4b8d686c530UL;
   tf->codes[21326] = 0x0001d5287729c4b8UL;
   tf->codes[21327] = 0x0001d53f570805acUL;
   tf->codes[21328] = 0x0001d5596ab89766UL;
   tf->codes[21329] = 0x0001d698841507e5UL;
   tf->codes[21330] = 0x0001d6d9403068acUL;
   tf->codes[21331] = 0x0001d6fdd99403ccUL;
   tf->codes[21332] = 0x0001d8043862dd73UL;
   tf->codes[21333] = 0x0001d8695352d395UL;
   tf->codes[21334] = 0x0001d8c547e9e2efUL;
   tf->codes[21335] = 0x0001d909e784a5cbUL;
   tf->codes[21336] = 0x0001d91f6808c421UL;
   tf->codes[21337] = 0x0001d939069b4a51UL;
   tf->codes[21338] = 0x0001d944768a6acbUL;
   tf->codes[21339] = 0x0001d952300fc4f7UL;
   tf->codes[21340] = 0x0001da137a25d038UL;
   tf->codes[21341] = 0x0001da4bfa24614bUL;
   tf->codes[21342] = 0x0001da97eb9fdcc7UL;
   tf->codes[21343] = 0x0001da9cf3ea5bb5UL;
   tf->codes[21344] = 0x0001daf071d59596UL;
   tf->codes[21345] = 0x0001dafb3217a4c1UL;
   tf->codes[21346] = 0x0001db56b190a891UL;
   tf->codes[21347] = 0x0001db9942243780UL;
   tf->codes[21348] = 0x0001dc3667f4b32bUL;
   tf->codes[21349] = 0x0001dc5b767659d5UL;
   tf->codes[21350] = 0x0001dc6dfdb72d2aUL;
   tf->codes[21351] = 0x0001dcb34cff0155UL;
   tf->codes[21352] = 0x0001dce390e0c2b4UL;
   tf->codes[21353] = 0x0001dcf2a9c03f7eUL;
   tf->codes[21354] = 0x0001dd56da741e8cUL;
   tf->codes[21355] = 0x0001ddd9b20502b8UL;
   tf->codes[21356] = 0x0001de81d2a69353UL;
   tf->codes[21357] = 0x0001de9459e766a8UL;
   tf->codes[21358] = 0x0001dee1e54c0a87UL;
   tf->codes[21359] = 0x0001df573de69a4cUL;
   tf->codes[21360] = 0x0001dfae2a332ab8UL;
   tf->codes[21361] = 0x0001dfd6a71627edUL;
   tf->codes[21362] = 0x0001dfe510489368UL;
   tf->codes[21363] = 0x0001e0ddf02118a8UL;
   tf->codes[21364] = 0x0001e105f7e60a53UL;
   tf->codes[21365] = 0x0001e290c82ef089UL;
   tf->codes[21366] = 0x0001e2d39351853dUL;
   tf->codes[21367] = 0x0001e2fc4ac38837UL;
   tf->codes[21368] = 0x0001e32193d434a6UL;
   tf->codes[21369] = 0x0001e349d6282c16UL;
   tf->codes[21370] = 0x0001e37b3ed50a4eUL;
   tf->codes[21371] = 0x0001e42ecf65bb63UL;
   tf->codes[21372] = 0x0001e447f8da3609UL;
   tf->codes[21373] = 0x0001e5915d5aaa29UL;
   tf->codes[21374] = 0x0001e5c3b0439f75UL;
   tf->codes[21375] = 0x0001e5d512b955f1UL;
   tf->codes[21376] = 0x0001e5fb80951f39UL;
   tf->codes[21377] = 0x0001e60222c8c68aUL;
   tf->codes[21378] = 0x0001e62ebdba2b99UL;
   tf->codes[21379] = 0x0001e6338b75a4c2UL;
   tf->codes[21380] = 0x0001e64478cd4fb4UL;
   tf->codes[21381] = 0x0001e66060f60f96UL;
   tf->codes[21382] = 0x0001e68e5b419743UL;
   tf->codes[21383] = 0x0001e6e4d2701c25UL;
   tf->codes[21384] = 0x0001e72812b0bc63UL;
   tf->codes[21385] = 0x0001e773547f2690UL;
   tf->codes[21386] = 0x0001e7889a743f21UL;
   tf->codes[21387] = 0x0001e78a345d6784UL;
   tf->codes[21388] = 0x0001e7ee2a8240cdUL;
   tf->codes[21389] = 0x0001e7fc1e96a0beUL;
   tf->codes[21390] = 0x0001ea0867164882UL;
   tf->codes[21391] = 0x0001ea30a96a3ff2UL;
   tf->codes[21392] = 0x0001eadad913047aUL;
   tf->codes[21393] = 0x0001eb12344678b4UL;
   tf->codes[21394] = 0x0001eb13ce2fa117UL;
   tf->codes[21395] = 0x0001eb5958067b07UL;
   tf->codes[21396] = 0x0001eb8801ff1403UL;
   tf->codes[21397] = 0x0001eb8ac0b3593fUL;
   tf->codes[21398] = 0x0001ebe2d1cb0684UL;
   tf->codes[21399] = 0x0001ec61c5dc889bUL;
   tf->codes[21400] = 0x0001ec6bd6718677UL;
   tf->codes[21401] = 0x0001ec7278a52dc8UL;
   tf->codes[21402] = 0x0001ece378a24feeUL;
   tf->codes[21403] = 0x0001ecebef4e2567UL;
   tf->codes[21404] = 0x0001ed9b9c5f7467UL;
   tf->codes[21405] = 0x0001edb157729882UL;
   tf->codes[21406] = 0x0001edf8b5c1a09aUL;
   tf->codes[21407] = 0x0001ee422317dc9fUL;
   tf->codes[21408] = 0x0001ee97757b44a8UL;
   tf->codes[21409] = 0x0001eefdefc55d68UL;
   tf->codes[21410] = 0x0001ef6519bc8777UL;
   tf->codes[21411] = 0x0001ef6fd9fe96a2UL;
   tf->codes[21412] = 0x0001efb31a3f36e0UL;
   tf->codes[21413] = 0x0001efd912fcf49eUL;
   tf->codes[21414] = 0x0001f030e9859c1eUL;
   tf->codes[21415] = 0x0001f06a8e4f4a0aUL;
   tf->codes[21416] = 0x0001f0bfa623ac4eUL;
   tf->codes[21417] = 0x0001f1306b91c8afUL;
   tf->codes[21418] = 0x0001f1762ff7a864UL;
   tf->codes[21419] = 0x0001f232e6e14041UL;
   tf->codes[21420] = 0x0001f23fb62a8359UL;
   tf->codes[21421] = 0x0001f29c94fda9c7UL;
   tf->codes[21422] = 0x0001f316f5e2b87aUL;
   tf->codes[21423] = 0x0001f3a836a60821UL;
   tf->codes[21424] = 0x0001f4308b9f76c5UL;
   tf->codes[21425] = 0x0001f4831f4e9992UL;
   tf->codes[21426] = 0x0001f49447354a49UL;
   tf->codes[21427] = 0x0001f538bee67e94UL;
   tf->codes[21428] = 0x0001f5425a5d70e6UL;
   tf->codes[21429] = 0x0001f572292126bbUL;
   tf->codes[21430] = 0x0001f5bf3f67bf10UL;
   tf->codes[21431] = 0x0001f5eb653b1895UL;
   tf->codes[21432] = 0x0001f6178b0e721aUL;
   tf->codes[21433] = 0x0001f6c772aec6dfUL;
   tf->codes[21434] = 0x0001f6d5dbe1325aUL;
   tf->codes[21435] = 0x0001f728e4ae60b1UL;
   tf->codes[21436] = 0x0001f777cf6d272eUL;
   tf->codes[21437] = 0x0001f77e71a0ce7fUL;
   tf->codes[21438] = 0x0001f78a1c1ef4beUL;
   tf->codes[21439] = 0x0001f7a5c9b8aedbUL;
   tf->codes[21440] = 0x0001f7e1f2a79c3eUL;
   tf->codes[21441] = 0x0001f7f947a3e8bcUL;
   tf->codes[21442] = 0x0001f98c54099ea6UL;
   tf->codes[21443] = 0x0001f9a751f64774UL;
   tf->codes[21444] = 0x0001f9ffd82c0043UL;
   tf->codes[21445] = 0x0001faf5bec13a82UL;
   tf->codes[21446] = 0x0001fb39741fe64aUL;
   tf->codes[21447] = 0x0001fb57a5dedfdeUL;
   tf->codes[21448] = 0x0001fb9aab907a57UL;
   tf->codes[21449] = 0x0001fc2b3ca6b8afUL;
   tf->codes[21450] = 0x0001fc4799ed841bUL;
   tf->codes[21451] = 0x0001fcffbdaaa894UL;
   tf->codes[21452] = 0x0001fd03dbb9106eUL;
   tf->codes[21453] = 0x0001fd3e6abed56eUL;
   tf->codes[21454] = 0x0001fd8971fe39d6UL;
   tf->codes[21455] = 0x0001fde73b0d7758UL;
   tf->codes[21456] = 0x0001ff48a4374945UL;
   tf->codes[21457] = 0x0001ff4a03916be3UL;
   tf->codes[21458] = 0x0001ff8a4a8ec120UL;
   tf->codes[21459] = 0x0001ff99d88c4974UL;
   tf->codes[21460] = 0x0000006f093d4aa8UL;
   tf->codes[21461] = 0x000001c2b8e1c269UL;
   tf->codes[21462] = 0x000001e5433e299cUL;
   tf->codes[21463] = 0x000001f964682554UL;
   tf->codes[21464] = 0x00000253bf160c4bUL;
   tf->codes[21465] = 0x0000034f5da2d6c7UL;
   tf->codes[21466] = 0x00000353f0cf4a2bUL;
   tf->codes[21467] = 0x00000381b08bcc13UL;
   tf->codes[21468] = 0x00000383fa2205c5UL;
   tf->codes[21469] = 0x000003e86564ea98UL;
   tf->codes[21470] = 0x000003f7f36272ecUL;
   tf->codes[21471] = 0x000004a51c4e8275UL;
   tf->codes[21472] = 0x000004ba62439b06UL;
   tf->codes[21473] = 0x000004f1f8061505UL;
   tf->codes[21474] = 0x00000502703fb46dUL;
   tf->codes[21475] = 0x00000595fa993dc6UL;
   tf->codes[21476] = 0x000005c6790a04eaUL;
   tf->codes[21477] = 0x000006686c95f9beUL;
   tf->codes[21478] = 0x0000068788910a66UL;
   tf->codes[21479] = 0x000006f5c9d9e750UL;
   tf->codes[21480] = 0x00000796237cb3c1UL;
   tf->codes[21481] = 0x0000081a1fd8b4c6UL;
   tf->codes[21482] = 0x000008313a45fb7fUL;
   tf->codes[21483] = 0x000008a86758b96cUL;
   tf->codes[21484] = 0x00000a0c54a7cad0UL;
   tf->codes[21485] = 0x00000a13e1178935UL;
   tf->codes[21486] = 0x00000afc0e276948UL;
   tf->codes[21487] = 0x00000b3def0de6e8UL;
   tf->codes[21488] = 0x00000b5fc9bd3cccUL;
   tf->codes[21489] = 0x00000bdb4f6d6858UL;
   tf->codes[21490] = 0x00000bec02360d85UL;
   tf->codes[21491] = 0x00000ca8f3aeab27UL;
   tf->codes[21492] = 0x00000d49fcfe88e7UL;
   tf->codes[21493] = 0x00000edd7e824a5bUL;
   tf->codes[21494] = 0x00000f02c792f6caUL;
   tf->codes[21495] = 0x00000f6c75af6050UL;
   tf->codes[21496] = 0x000010145bc1eb26UL;
   tf->codes[21497] = 0x000010df414ee8b9UL;
   tf->codes[21498] = 0x00001181e487eedcUL;
   tf->codes[21499] = 0x00001252bc9b8271UL;
   tf->codes[21500] = 0x000012812c0515a8UL;
   tf->codes[21501] = 0x000013231f910a7cUL;
   tf->codes[21502] = 0x0000148ff8a9fce3UL;
   tf->codes[21503] = 0x00001567e80f4353UL;
   tf->codes[21504] = 0x000015c367884723UL;
   tf->codes[21505] = 0x000015d15b9ca714UL;
   tf->codes[21506] = 0x000015f42088140cUL;
   tf->codes[21507] = 0x000015f62f8f47f9UL;
   tf->codes[21508] = 0x000016d27791fc08UL;
   tf->codes[21509] = 0x000017224c8cd999UL;
   tf->codes[21510] = 0x00001726300c3baeUL;
   tf->codes[21511] = 0x00001736a845db16UL;
   tf->codes[21512] = 0x0000176bb9e3159eUL;
   tf->codes[21513] = 0x000018148a31b788UL;
   tf->codes[21514] = 0x000018d9081a138fUL;
   tf->codes[21515] = 0x0000191e91f0ed7fUL;
   tf->codes[21516] = 0x0000193b9ee4ca3aUL;
   tf->codes[21517] = 0x00001960e7f576a9UL;
   tf->codes[21518] = 0x00001985f6771d53UL;
   tf->codes[21519] = 0x000019e4a9c271e9UL;
   tf->codes[21520] = 0x00001a74509c992dUL;
   tf->codes[21521] = 0x00001a811fe5dc45UL;
   tf->codes[21522] = 0x00001aa3aa424378UL;
   tf->codes[21523] = 0x00001ac460267c83UL;
   tf->codes[21524] = 0x00001b2905f8671bUL;
   tf->codes[21525] = 0x00001b51bd6a6a15UL;
   tf->codes[21526] = 0x00001b689d48ab09UL;
   tf->codes[21527] = 0x00001ba83498eef7UL;
   tf->codes[21528] = 0x00001c05c31926b4UL;
   tf->codes[21529] = 0x00001c1b7e2c4acfUL;
   tf->codes[21530] = 0x00001c8f3cddb231UL;
   tf->codes[21531] = 0x00001ce9978b9928UL;
   tf->codes[21532] = 0x00001da1462ab217UL;
   tf->codes[21533] = 0x00001e967d12db07UL;
   tf->codes[21534] = 0x00001f1dad412cd2UL;
   tf->codes[21535] = 0x00001fb1acb8c1b5UL;
   tf->codes[21536] = 0x00001ff1440905a3UL;
   tf->codes[21537] = 0x0000200ae29b8bd3UL;
   tf->codes[21538] = 0x0000201f78e39315UL;
   tf->codes[21539] = 0x0000209ee21320b6UL;
   tf->codes[21540] = 0x000020c63a2b0112UL;
   tf->codes[21541] = 0x0000212269511631UL;
   tf->codes[21542] = 0x000021d66effd2d0UL;
   tf->codes[21543] = 0x0000226ddcd8be3eUL;
   tf->codes[21544] = 0x00002329a9863f07UL;
   tf->codes[21545] = 0x0000235b875128c9UL;
   tf->codes[21546] = 0x000023b02a077f83UL;
   tf->codes[21547] = 0x000024ba6c55bb3fUL;
   tf->codes[21548] = 0x000024e0651378fdUL;
   tf->codes[21549] = 0x00002547547b9d47UL;
   tf->codes[21550] = 0x000025c6488d1f5eUL;
   tf->codes[21551] = 0x0000274275149454UL;
   tf->codes[21552] = 0x0000275e5d3d5436UL;
   tf->codes[21553] = 0x0000277a7ff519ddUL;
   tf->codes[21554] = 0x000027a03e23d1d6UL;
   tf->codes[21555] = 0x000027d8f8b168aeUL;
   tf->codes[21556] = 0x000028568d68c827UL;
   tf->codes[21557] = 0x0000289784132eb3UL;
   tf->codes[21558] = 0x00002a82dc1f97a7UL;
   tf->codes[21559] = 0x00002a99bbfdd89bUL;
   tf->codes[21560] = 0x00002a9cefd02961UL;
   tf->codes[21561] = 0x00002ab6c8f1b556UL;
   tf->codes[21562] = 0x00002ac6917e436fUL;
   tf->codes[21563] = 0x00002ba29ef1f1b9UL;
   tf->codes[21564] = 0x00002bde8d51d957UL;
   tf->codes[21565] = 0x00002d047d39cf30UL;
   tf->codes[21566] = 0x00002d34fbaa9654UL;
   tf->codes[21567] = 0x00002da043b0283dUL;
   tf->codes[21568] = 0x00002dd6b4a78563UL;
   tf->codes[21569] = 0x00002dde7ba6498dUL;
   tf->codes[21570] = 0x00002e5fb94e0556UL;
   tf->codes[21571] = 0x00002ec07ba08dd9UL;
   tf->codes[21572] = 0x00002f66181cdefdUL;
   tf->codes[21573] = 0x00002f8f0a1de7bcUL;
   tf->codes[21574] = 0x00002f92787f3e47UL;
   tf->codes[21575] = 0x0000307478798293UL;
   tf->codes[21576] = 0x0000310e2fe8a7b3UL;
   tf->codes[21577] = 0x0000311ea822471bUL;
   tf->codes[21578] = 0x00003124258ad193UL;
   tf->codes[21579] = 0x000031dcf8f5075bUL;
   tf->codes[21580] = 0x000032257c0f2c4cUL;
   tf->codes[21581] = 0x0000322a8459ab3aUL;
   tf->codes[21582] = 0x0000325c622494fcUL;
   tf->codes[21583] = 0x0000328c6b775096UL;
   tf->codes[21584] = 0x0000331c876f8364UL;
   tf->codes[21585] = 0x00003322ef1424f0UL;
   tf->codes[21586] = 0x000033db4d604f2eUL;
   tf->codes[21587] = 0x0000341b59ce9ea6UL;
   tf->codes[21588] = 0x0000342b97793849UL;
   tf->codes[21589] = 0x00003441c7aa67eeUL;
   tf->codes[21590] = 0x0000347db60a4f8cUL;
   tf->codes[21591] = 0x000034c3ef8e3acbUL;
   tf->codes[21592] = 0x00003559fe0d039bUL;
   tf->codes[21593] = 0x000035f0471ad230UL;
   tf->codes[21594] = 0x0000369e5a42f8cdUL;
   tf->codes[21595] = 0x000036a23dc25ae2UL;
   tf->codes[21596] = 0x000036ff1c958150UL;
   tf->codes[21597] = 0x0000370ac713a78fUL;
   tf->codes[21598] = 0x00003714628a99e1UL;
   tf->codes[21599] = 0x0000376b4ed72a4dUL;
   tf->codes[21600] = 0x0000377858af732aUL;
   tf->codes[21601] = 0x000037d487d58849UL;
   tf->codes[21602] = 0x000037de5ddb8060UL;
   tf->codes[21603] = 0x0000381752f81cfdUL;
   tf->codes[21604] = 0x0000381802a52e4cUL;
   tf->codes[21605] = 0x000038500d85b3d5UL;
   tf->codes[21606] = 0x000038a7a97f5590UL;
   tf->codes[21607] = 0x0000391bdd4ec87cUL;
   tf->codes[21608] = 0x00003963762cd659UL;
   tf->codes[21609] = 0x0000396a52ef836fUL;
   tf->codes[21610] = 0x000039e737f9d199UL;
   tf->codes[21611] = 0x000039f441d21a76UL;
   tf->codes[21612] = 0x00003a25e50dfe73UL;
   tf->codes[21613] = 0x00003a427ce3cfa4UL;
   tf->codes[21614] = 0x00003a4f86bc1881UL;
   tf->codes[21615] = 0x00003ab3f1fefd54UL;
   tf->codes[21616] = 0x00003ae9edd84ef0UL;
   tf->codes[21617] = 0x00003b3236636e1cUL;
   tf->codes[21618] = 0x00003cb490007ed9UL;
   tf->codes[21619] = 0x00003cdfcb97c14aUL;
   tf->codes[21620] = 0x00003d5d25c01afeUL;
   tf->codes[21621] = 0x00003d5e0ffc3212UL;
   tf->codes[21622] = 0x00003d9e56f9874fUL;
   tf->codes[21623] = 0x00003d9f06a6989eUL;
   tf->codes[21624] = 0x00003de789c0bd8fUL;
   tf->codes[21625] = 0x00003e1e6fd6263fUL;
   tf->codes[21626] = 0x00003e63f9ad002fUL;
   tf->codes[21627] = 0x00003e88cd9fa114UL;
   tf->codes[21628] = 0x00003ec69077b6daUL;
   tf->codes[21629] = 0x00003f07c1b1232bUL;
   tf->codes[21630] = 0x00003f220ff0baaaUL;
   tf->codes[21631] = 0x000041194d0a4fa2UL;
   tf->codes[21632] = 0x000041c42c602579UL;
   tf->codes[21633] = 0x000041efdd157374UL;
   tf->codes[21634] = 0x0000424d6b95ab31UL;
   tf->codes[21635] = 0x00004280e349bd56UL;
   tf->codes[21636] = 0x00004292badd7f5cUL;
   tf->codes[21637] = 0x0000433c004a2cd0UL;
   tf->codes[21638] = 0x000043422d5fc897UL;
   tf->codes[21639] = 0x00004367b0ff7acbUL;
   tf->codes[21640] = 0x000043bc53b5d185UL;
   tf->codes[21641] = 0x0000444a2617caa1UL;
   tf->codes[21642] = 0x0000444ad5c4dbf0UL;
   tf->codes[21643] = 0x000044d539c57e81UL;
   tf->codes[21644] = 0x000044f1d19b4fb2UL;
   tf->codes[21645] = 0x000044faf7f4367aUL;
   tf->codes[21646] = 0x000045493305eba8UL;
   tf->codes[21647] = 0x0000456221eb6089UL;
   tf->codes[21648] = 0x000045a17eac9eb2UL;
   tf->codes[21649] = 0x000046241bae7d19UL;
   tf->codes[21650] = 0x0000468f9e4314c7UL;
   tf->codes[21651] = 0x000046db552f8a7eUL;
   tf->codes[21652] = 0x000047595f04f581UL;
   tf->codes[21653] = 0x000047771ba5e38bUL;
   tf->codes[21654] = 0x000047775634e950UL;
   tf->codes[21655] = 0x000047a42bb55424UL;
   tf->codes[21656] = 0x000047d88da57d5dUL;
   tf->codes[21657] = 0x000047f4b05d4304UL;
   tf->codes[21658] = 0x00004819844fe3e9UL;
   tf->codes[21659] = 0x00004835a707a990UL;
   tf->codes[21660] = 0x0000488a844d060fUL;
   tf->codes[21661] = 0x000048b8440987f7UL;
   tf->codes[21662] = 0x000049343ed7bf0dUL;
   tf->codes[21663] = 0x0000499367411f2dUL;
   tf->codes[21664] = 0x000049d7cc4cdc44UL;
   tf->codes[21665] = 0x000049d92ba6fee2UL;
   tf->codes[21666] = 0x00004a2139a31849UL;
   tf->codes[21667] = 0x00004a25924085e8UL;
   tf->codes[21668] = 0x00004a2975bfe7fdUL;
   tf->codes[21669] = 0x00004b4b82287bc1UL;
   tf->codes[21670] = 0x00004bec50e953bcUL;
   tf->codes[21671] = 0x00004bf0a986c15bUL;
   tf->codes[21672] = 0x00004c9e821fe233UL;
   tf->codes[21673] = 0x00004cbe885709efUL;
   tf->codes[21674] = 0x00004ced6cdea8b0UL;
   tf->codes[21675] = 0x00004d7dfdf4e708UL;
   tf->codes[21676] = 0x00004dd76e66b6ebUL;
   tf->codes[21677] = 0x00004e0b5b38d49aUL;
   tf->codes[21678] = 0x00004e4c17543561UL;
   tf->codes[21679] = 0x00004e6edc3fa259UL;
   tf->codes[21680] = 0x00004e8b7415738aUL;
   tf->codes[21681] = 0x00004f783451c701UL;
   tf->codes[21682] = 0x00004fd51324ed6fUL;
   tf->codes[21683] = 0x00004fd58842f8f9UL;
   tf->codes[21684] = 0x00005069c24993a1UL;
   tf->codes[21685] = 0x000050c2bd9d57faUL;
   tf->codes[21686] = 0x000051f2838b45eaUL;
   tf->codes[21687] = 0x000053654f2ace53UL;
   tf->codes[21688] = 0x00005477cd95d9c3UL;
   tf->codes[21689] = 0x000054ec3bf45274UL;
   tf->codes[21690] = 0x00005519fbb0d45cUL;
   tf->codes[21691] = 0x00005583e45c43a7UL;
   tf->codes[21692] = 0x000055c8f915120dUL;
   tf->codes[21693] = 0x00005688a941f4ebUL;
   tf->codes[21694] = 0x000056cbe9829529UL;
   tf->codes[21695] = 0x00005738565343ebUL;
   tf->codes[21696] = 0x0000579c4c781d34UL;
   tf->codes[21697] = 0x000058216d9f3b12UL;
   tf->codes[21698] = 0x000058840469f1bdUL;
   tf->codes[21699] = 0x0000588897966521UL;
   tf->codes[21700] = 0x0000588947437670UL;
   tf->codes[21701] = 0x00005a2af76a9d9aUL;
   tf->codes[21702] = 0x00005a5966d430d1UL;
   tf->codes[21703] = 0x00005ac76d8e07f6UL;
   tf->codes[21704] = 0x00005ac7a81d0dbbUL;
   tf->codes[21705] = 0x00005b6afb03252dUL;
   tf->codes[21706] = 0x00005baf600ee244UL;
   tf->codes[21707] = 0x00005bd7dcf1df79UL;
   tf->codes[21708] = 0x00005c895e7b5ca1UL;
   tf->codes[21709] = 0x00005c95f33599f4UL;
   tf->codes[21710] = 0x00005c98023ccde1UL;
   tf->codes[21711] = 0x00005ce1e4b11570UL;
   tf->codes[21712] = 0x00005ce259cf20faUL;
   tf->codes[21713] = 0x00005db0389f698eUL;
   tf->codes[21714] = 0x00005dcac16e06d2UL;
   tf->codes[21715] = 0x00005e03416c97e5UL;
   tf->codes[21716] = 0x00005e847f1453aeUL;
   tf->codes[21717] = 0x00005ebab57cab0fUL;
   tf->codes[21718] = 0x00005ed2ba2608dcUL;
   tf->codes[21719] = 0x00005ee7c58c1ba8UL;
   tf->codes[21720] = 0x00005f372568edafUL;
   tf->codes[21721] = 0x00005f4603b964b4UL;
   tf->codes[21722] = 0x00005f59afc554e2UL;
   tf->codes[21723] = 0x00006079e7b5ba7eUL;
   tf->codes[21724] = 0x000060f91656425aUL;
   tf->codes[21725] = 0x000060fe93beccd2UL;
   tf->codes[21726] = 0x0000613b6c5acb84UL;
   tf->codes[21727] = 0x000061ad1c04fef9UL;
   tf->codes[21728] = 0x000061ef377a825eUL;
   tf->codes[21729] = 0x000062fd97d725f4UL;
   tf->codes[21730] = 0x000063370211ce1bUL;
   tf->codes[21731] = 0x00006339fb55191cUL;
   tf->codes[21732] = 0x00006380a9f70fe5UL;
   tf->codes[21733] = 0x000063853d238349UL;
   tf->codes[21734] = 0x000063f468a87747UL;
   tf->codes[21735] = 0x00006427e05c896cUL;
   tf->codes[21736] = 0x0000647cbda1e5ebUL;
   tf->codes[21737] = 0x000064b9211fd913UL;
   tf->codes[21738] = 0x00006524de437686UL;
   tf->codes[21739] = 0x00006531ad8cb99eUL;
   tf->codes[21740] = 0x0000655019dab8f7UL;
   tf->codes[21741] = 0x00006555222537e5UL;
   tf->codes[21742] = 0x0000659d3021514cUL;
   tf->codes[21743] = 0x00006628093fff67UL;
   tf->codes[21744] = 0x0000668597c03724UL;
   tf->codes[21745] = 0x0000669d61da8f2cUL;
   tf->codes[21746] = 0x00006740b4c0a69eUL;
   tf->codes[21747] = 0x000067c6fab2e155UL;
   tf->codes[21748] = 0x000067e6513cf7c2UL;
   tf->codes[21749] = 0x000067f2364a23c6UL;
   tf->codes[21750] = 0x000067f77923a879UL;
   tf->codes[21751] = 0x0000682a7bb9af14UL;
   tf->codes[21752] = 0x0000687d49f7d7a6UL;
   tf->codes[21753] = 0x00006888f475fde5UL;
   tf->codes[21754] = 0x000068c2993fabd1UL;
   tf->codes[21755] = 0x0000690ddb0e15feUL;
   tf->codes[21756] = 0x0000695f0f63162dUL;
   tf->codes[21757] = 0x0000698baa547b3cUL;
   tf->codes[21758] = 0x00006a806c1e98a2UL;
   tf->codes[21759] = 0x00006af3f040fa3fUL;
   tf->codes[21760] = 0x00006b16057f55e8UL;
   tf->codes[21761] = 0x00006b1a238dbdc2UL;
   tf->codes[21762] = 0x00006b272d66069fUL;
   tf->codes[21763] = 0x00006b4683f01d0cUL;
   tf->codes[21764] = 0x00006ba9ca67e506UL;
   tf->codes[21765] = 0x00006c0549e0e8d6UL;
   tf->codes[21766] = 0x00006c567e35e905UL;
   tf->codes[21767] = 0x00006c6a9f5fe4bdUL;
   tf->codes[21768] = 0x00006c7b522889eaUL;
   tf->codes[21769] = 0x00006cdaefaff594UL;
   tf->codes[21770] = 0x00006d1fc9d9be35UL;
   tf->codes[21771] = 0x00006d73f7720965UL;
   tf->codes[21772] = 0x00006d872e5fee09UL;
   tf->codes[21773] = 0x00006e37c5ad541dUL;
   tf->codes[21774] = 0x00006e800e387349UL;
   tf->codes[21775] = 0x00006f05a47d9cb1UL;
   tf->codes[21776] = 0x00006f7f1b269450UL;
   tf->codes[21777] = 0x00006f992ed7260aUL;
   tf->codes[21778] = 0x00006fb6eb781414UL;
   tf->codes[21779] = 0x00006fbc68e09e8cUL;
   tf->codes[21780] = 0x0000706fbee249dcUL;
   tf->codes[21781] = 0x000070e8fafc3bb6UL;
   tf->codes[21782] = 0x000070e9e53852caUL;
   tf->codes[21783] = 0x000071226536e3ddUL;
   tf->codes[21784] = 0x000071489883a760UL;
   tf->codes[21785] = 0x000071756e041234UL;
   tf->codes[21786] = 0x00007199ccd8a78fUL;
   tf->codes[21787] = 0x000072116f097106UL;
   tf->codes[21788] = 0x0000723d94dcca8bUL;
   tf->codes[21789] = 0x00007272a67a0513UL;
   tf->codes[21790] = 0x000072c3dacf0542UL;
   tf->codes[21791] = 0x000072ec57b20277UL;
   tf->codes[21792] = 0x0000731dc05ee0afUL;
   tf->codes[21793] = 0x00007366b897112aUL;
   tf->codes[21794] = 0x000073a10d0dd065UL;
   tf->codes[21795] = 0x000073dab1d77e51UL;
   tf->codes[21796] = 0x000073e78120c169UL;
   tf->codes[21797] = 0x0000741665a8602aUL;
   tf->codes[21798] = 0x0000743f92386eaeUL;
   tf->codes[21799] = 0x00007488ff8eaab3UL;
   tf->codes[21800] = 0x000074bcb1d1c29dUL;
   tf->codes[21801] = 0x000074c3540569eeUL;
   tf->codes[21802] = 0x000074de8c811881UL;
   tf->codes[21803] = 0x00007502011996c8UL;
   tf->codes[21804] = 0x0000751697619e0aUL;
   tf->codes[21805] = 0x000075ab81154a01UL;
   tf->codes[21806] = 0x000075df6de767b0UL;
   tf->codes[21807] = 0x000075e058237ec4UL;
   tf->codes[21808] = 0x0000762f42e24541UL;
   tf->codes[21809] = 0x00007654c681f775UL;
   tf->codes[21810] = 0x000076ce3d2aef14UL;
   tf->codes[21811] = 0x000076e51d093008UL;
   tf->codes[21812] = 0x000076f55ab3c9abUL;
   tf->codes[21813] = 0x0000776202137e32UL;
   tf->codes[21814] = 0x00007788356041b5UL;
   tf->codes[21815] = 0x0000778bde509e05UL;
   tf->codes[21816] = 0x000077a41d890197UL;
   tf->codes[21817] = 0x000077be6bc89916UL;
   tf->codes[21818] = 0x000078c15c361c32UL;
   tf->codes[21819] = 0x000078cabd1e08bfUL;
   tf->codes[21820] = 0x0000790586b2d384UL;
   tf->codes[21821] = 0x00007906ab7df05dUL;
   tf->codes[21822] = 0x0000793b47fd1f5bUL;
   tf->codes[21823] = 0x000079568078cdeeUL;
   tf->codes[21824] = 0x0000796bc66de67fUL;
   tf->codes[21825] = 0x00007a9c3c08e5beUL;
   tf->codes[21826] = 0x00007af39d7381b4UL;
   tf->codes[21827] = 0x00007b55f9af329aUL;
   tf->codes[21828] = 0x00007b73b65020a4UL;
   tf->codes[21829] = 0x00007b9939efd2d8UL;
   tf->codes[21830] = 0x00007bb0545d1991UL;
   tf->codes[21831] = 0x00007beec6e240a6UL;
   tf->codes[21832] = 0x00007bf6c8700a95UL;
   tf->codes[21833] = 0x00007c035d2a47e8UL;
   tf->codes[21834] = 0x00007c223e9652cbUL;
   tf->codes[21835] = 0x00007caf9bda405dUL;
   tf->codes[21836] = 0x00007d2a71dd5a9aUL;
   tf->codes[21837] = 0x00007d68a9d37beaUL;
   tf->codes[21838] = 0x00007e12d97c4072UL;
   tf->codes[21839] = 0x00007e385d1bf2a6UL;
   tf->codes[21840] = 0x00007e3d9ff57759UL;
   tf->codes[21841] = 0x00007e93a205f0b1UL;
   tf->codes[21842] = 0x00007ebf182c38e7UL;
   tf->codes[21843] = 0x00007ecee0b8c700UL;
   tf->codes[21844] = 0x00007f6230834a94UL;
   tf->codes[21845] = 0x00007fb8a7b1cf76UL;
   tf->codes[21846] = 0x00007fda47d21f95UL;
   tf->codes[21847] = 0x00007fde2b5181aaUL;
   tf->codes[21848] = 0x000080254f1183fdUL;
   tf->codes[21849] = 0x000080d1c8508237UL;
   tf->codes[21850] = 0x000080fcc958bee3UL;
   tf->codes[21851] = 0x0000812a4e863b06UL;
   tf->codes[21852] = 0x000081558a1d7d77UL;
   tf->codes[21853] = 0x000081e530f7a4bbUL;
   tf->codes[21854] = 0x000082abbde734afUL;
   tf->codes[21855] = 0x000082da2d50c7e6UL;
   tf->codes[21856] = 0x0000834af2bee447UL;
   tf->codes[21857] = 0x00008391dbefe0d5UL;
   tf->codes[21858] = 0x0000844a3a3c0b13UL;
   tf->codes[21859] = 0x00008579507ce7b4UL;
   tf->codes[21860] = 0x00008587f43e58f4UL;
   tf->codes[21861] = 0x0000858b9d2eb544UL;
   tf->codes[21862] = 0x000085a6d5aa63d7UL;
   tf->codes[21863] = 0x000085c750ff971dUL;
   tf->codes[21864] = 0x000088db923740ebUL;
   tf->codes[21865] = 0x00008930aa0ba32fUL;
   tf->codes[21866] = 0x0000895c5ac0f12aUL;
   tf->codes[21867] = 0x0000898218efa923UL;
   tf->codes[21868] = 0x00008a72f73a6474UL;
   tf->codes[21869] = 0x00008af1b0bce0c6UL;
   tf->codes[21870] = 0x00008bb99d069358UL;
   tf->codes[21871] = 0x00008bba4cb3a4a7UL;
   tf->codes[21872] = 0x00008bbb36efbbbbUL;
   tf->codes[21873] = 0x00008beb40427755UL;
   tf->codes[21874] = 0x00008c9bd78fdd69UL;
   tf->codes[21875] = 0x00008ce9d8128cd2UL;
   tf->codes[21876] = 0x00008e0db8f34ebeUL;
   tf->codes[21877] = 0x00008f05ae8fbceaUL;
   tf->codes[21878] = 0x00008f9a5db4631cUL;
   tf->codes[21879] = 0x00008f9f65fee20aUL;
   tf->codes[21880] = 0x00008fc907acfc18UL;
   tf->codes[21881] = 0x00008fde4da214a9UL;
   tf->codes[21882] = 0x000090536bad9ea9UL;
   tf->codes[21883] = 0x000091be704e62e8UL;
   tf->codes[21884] = 0x00009295b0069809UL;
   tf->codes[21885] = 0x000093e20dca572aUL;
   tf->codes[21886] = 0x00009442d01cdfadUL;
   tf->codes[21887] = 0x00009482a1fc2960UL;
   tf->codes[21888] = 0x000094a6c641b8f6UL;
   tf->codes[21889] = 0x000094bfb5272dd7UL;
   tf->codes[21890] = 0x000095960aa34be4UL;
   tf->codes[21891] = 0x000095cc067c9d80UL;
   tf->codes[21892] = 0x000095d3cd7b61aaUL;
   tf->codes[21893] = 0x0000962ba404092aUL;
   tf->codes[21894] = 0x00009670f34bdd55UL;
   tf->codes[21895] = 0x000096b8c6b8f0f7UL;
   tf->codes[21896] = 0x00009707ec06bd39UL;
   tf->codes[21897] = 0x000097089bb3ce88UL;
   tf->codes[21898] = 0x0000979ac6b33543UL;
   tf->codes[21899] = 0x00009858a267e9f9UL;
   tf->codes[21900] = 0x00009887fc0d9444UL;
   tf->codes[21901] = 0x000099b2f440090bUL;
   tf->codes[21902] = 0x000099fcd6b4509aUL;
   tf->codes[21903] = 0x00009b8b4fed9320UL;
   tf->codes[21904] = 0x00009baaa677a98dUL;
   tf->codes[21905] = 0x00009c16639b4700UL;
   tf->codes[21906] = 0x00009c22f8558453UL;
   tf->codes[21907] = 0x00009c424edf9ac0UL;
   tf->codes[21908] = 0x00009c43391bb1d4UL;
   tf->codes[21909] = 0x00009c5dfc7954ddUL;
   tf->codes[21910] = 0x00009c846a551e25UL;
   tf->codes[21911] = 0x00009c93f852a679UL;
   tf->codes[21912] = 0x00009ca3fb6e3a57UL;
   tf->codes[21913] = 0x00009cc9447ee6c6UL;
   tf->codes[21914] = 0x00009d0b25656466UL;
   tf->codes[21915] = 0x00009d31cdd03373UL;
   tf->codes[21916] = 0x00009da3f2987272UL;
   tf->codes[21917] = 0x00009e6dede958f1UL;
   tf->codes[21918] = 0x00009eb4d71a557fUL;
   tf->codes[21919] = 0x00009ec0bc278183UL;
   tf->codes[21920] = 0x00009f34b567eeaaUL;
   tf->codes[21921] = 0x00009fc80532723eUL;
   tf->codes[21922] = 0x0000a31416bb9bd0UL;
   tf->codes[21923] = 0x0000a38b7e5d5f82UL;
   tf->codes[21924] = 0x0000a3c9f0e28697UL;
   tf->codes[21925] = 0x0000a4f1b542aa98UL;
   tf->codes[21926] = 0x0000a52dde3197fbUL;
   tf->codes[21927] = 0x0000a57bdeb44764UL;
   tf->codes[21928] = 0x0000a5bc6040a266UL;
   tf->codes[21929] = 0x0000a6a5026e8e03UL;
   tf->codes[21930] = 0x0000a6c07579425bUL;
   tf->codes[21931] = 0x0000a6df1c564779UL;
   tf->codes[21932] = 0x0000a72b4860c8baUL;
   tf->codes[21933] = 0x0000a746464d7188UL;
   tf->codes[21934] = 0x0000a7ec57e7ce36UL;
   tf->codes[21935] = 0x0000a8463d77a9a3UL;
   tf->codes[21936] = 0x0000a866f35be2aeUL;
   tf->codes[21937] = 0x0000a878caefa4b4UL;
   tf->codes[21938] = 0x0000a973b9cf5de1UL;
   tf->codes[21939] = 0x0000ab00d3ae7dc9UL;
   tf->codes[21940] = 0x0000ab4e99a2276dUL;
   tf->codes[21941] = 0x0000abe51d3efbc7UL;
   tf->codes[21942] = 0x0000ac644bdf83a3UL;
   tf->codes[21943] = 0x0000ac6869edeb7dUL;
   tf->codes[21944] = 0x0000ac9713e68479UL;
   tf->codes[21945] = 0x0000acaafa817a6cUL;
   tf->codes[21946] = 0x0000ad647d98c183UL;
   tf->codes[21947] = 0x0000ada24070d749UL;
   tf->codes[21948] = 0x0000adbc54216903UL;
   tf->codes[21949] = 0x0000add9611545beUL;
   tf->codes[21950] = 0x0000aea94eecc23fUL;
   tf->codes[21951] = 0x0000aed32b29e212UL;
   tf->codes[21952] = 0x0000aef6da51661eUL;
   tf->codes[21953] = 0x0000af15f64c76c6UL;
   tf->codes[21954] = 0x0000af855c607089UL;
   tf->codes[21955] = 0x0000af99086c60b7UL;
   tf->codes[21956] = 0x0000afbd2cb1f04dUL;
   tf->codes[21957] = 0x0000b0ace6318ec5UL;
   tf->codes[21958] = 0x0000b102adb30258UL;
   tf->codes[21959] = 0x0000b1239e264128UL;
   tf->codes[21960] = 0x0000b12ab577f403UL;
   tf->codes[21961] = 0x0000b156662d41feUL;
   tf->codes[21962] = 0x0000b1858543e684UL;
   tf->codes[21963] = 0x0000b238db4591d4UL;
   tf->codes[21964] = 0x0000b2f7dbc56363UL;
   tf->codes[21965] = 0x0000b3661d0e404dUL;
   tf->codes[21966] = 0x0000b3e0b88254c5UL;
   tf->codes[21967] = 0x0000b3ef96d2cbcaUL;
   tf->codes[21968] = 0x0000b4f7ca19d399UL;
   tf->codes[21969] = 0x0000b5d69641c71fUL;
   tf->codes[21970] = 0x0000b616dd3f1c5cUL;
   tf->codes[21971] = 0x0000b67b4882012fUL;
   tf->codes[21972] = 0x0000b71e9b6818a1UL;
   tf->codes[21973] = 0x0000b783413a0339UL;
   tf->codes[21974] = 0x0000b79e3f26ac07UL;
   tf->codes[21975] = 0x0000b7c5222080d9UL;
   tf->codes[21976] = 0x0000b8344da574d7UL;
   tf->codes[21977] = 0x0000b84ba2a1c155UL;
   tf->codes[21978] = 0x0000b867503b7b72UL;
   tf->codes[21979] = 0x0000b87df58ab6a1UL;
   tf->codes[21980] = 0x0000b90057fd8f43UL;
   tf->codes[21981] = 0x0000b989d1c21ac0UL;
   tf->codes[21982] = 0x0000b99be3e4e28bUL;
   tf->codes[21983] = 0x0000b9a9284c312dUL;
   tf->codes[21984] = 0x0000b9e84a7e6991UL;
   tf->codes[21985] = 0x0000ba1a9d675eddUL;
   tf->codes[21986] = 0x0000bad62f85d9e1UL;
   tf->codes[21987] = 0x0000bb251a44a05eUL;
   tf->codes[21988] = 0x0000bb590716be0dUL;
   tf->codes[21989] = 0x0000bb60ce158237UL;
   tf->codes[21990] = 0x0000bb935b8d7d48UL;
   tf->codes[21991] = 0x0000bbdab9dc8560UL;
   tf->codes[21992] = 0x0000bd79e5de6d13UL;
   tf->codes[21993] = 0x0000bdb5d43e54b1UL;
   tf->codes[21994] = 0x0000bdd05d0cf1f5UL;
   tf->codes[21995] = 0x0000be7d10daf5f4UL;
   tf->codes[21996] = 0x0000bead54bcb753UL;
   tf->codes[21997] = 0x0000bf950cae8bdcUL;
   tf->codes[21998] = 0x0000bfe8c528cb82UL;
   tf->codes[21999] = 0x0000c199191163ecUL;
   tf->codes[22000] = 0x0000c255956bf604UL;
   tf->codes[22001] = 0x0000c2bb2579f7b0UL;
   tf->codes[22002] = 0x0000c2e501b71783UL;
   tf->codes[22003] = 0x0000c318044d1e1eUL;
   tf->codes[22004] = 0x0000c3813d4b7c1aUL;
   tf->codes[22005] = 0x0000c4a51e2c3e06UL;
   tf->codes[22006] = 0x0000c4c76df99f74UL;
   tf->codes[22007] = 0x0000c69d4581ea12UL;
   tf->codes[22008] = 0x0000c93810109c41UL;
   tf->codes[22009] = 0x0000c9fe27e220abUL;
   tf->codes[22010] = 0x0000caad5fd56421UL;
   tf->codes[22011] = 0x0000cb0b28e4a1a3UL;
   tf->codes[22012] = 0x0000cbed28dee5efUL;
   tf->codes[22013] = 0x0000ccc761da6611UL;
   tf->codes[22014] = 0x0000cd5c10ff0c43UL;
   tf->codes[22015] = 0x0000cd971522dccdUL;
   tf->codes[22016] = 0x0000ce81c657fc57UL;
   tf->codes[22017] = 0x0000ced78dd96feaUL;
   tf->codes[22018] = 0x0000cfb694906935UL;
   tf->codes[22019] = 0x0000cfdd026c327dUL;
   tf->codes[22020] = 0x0000d228e23c1e2fUL;
   tf->codes[22021] = 0x0000d3b5fc1b3e17UL;
   tf->codes[22022] = 0x0000d497c1867c9eUL;
   tf->codes[22023] = 0x0000d4f7d42bf3d2UL;
   tf->codes[22024] = 0x0000d5360c221522UL;
   tf->codes[22025] = 0x0000d64c337d7ce2UL;
   tf->codes[22026] = 0x0000d6c02cbdea09UL;
   tf->codes[22027] = 0x0000d9edd1f91442UL;
   tf->codes[22028] = 0x0000da39fe039583UL;
   tf->codes[22029] = 0x0000da3d31d5e649UL;
   tf->codes[22030] = 0x0000db2c76377937UL;
   tf->codes[22031] = 0x0000db6ae8bca04cUL;
   tf->codes[22032] = 0x0000dba7fbe7a4c3UL;
   tf->codes[22033] = 0x0000dbde6cdf01e9UL;
   tf->codes[22034] = 0x0000dc2605bd0fc6UL;
   tf->codes[22035] = 0x0000ddd7b8ffcaceUL;
   tf->codes[22036] = 0x0000de2a121fe7d6UL;
   tf->codes[22037] = 0x0000debe11977cb9UL;
   tf->codes[22038] = 0x0000df981003f716UL;
   tf->codes[22039] = 0x0000e0298b564c82UL;
   tf->codes[22040] = 0x0000e1bea6c33659UL;
   tf->codes[22041] = 0x0000e2510c51a2d9UL;
   tf->codes[22042] = 0x0000e26e8e638b1eUL;
   tf->codes[22043] = 0x0000e29c13910741UL;
   tf->codes[22044] = 0x0000e3970270c06eUL;
   tf->codes[22045] = 0x0000e4b6ffd22045UL;
   tf->codes[22046] = 0x0000e5bb4f99c5ffUL;
   tf->codes[22047] = 0x0000e5d8d1abae44UL;
   tf->codes[22048] = 0x0000e61d36b76b5bUL;
   tf->codes[22049] = 0x0000e66f8fd78863UL;
   tf->codes[22050] = 0x0000e6c6f1422459UL;
   tf->codes[22051] = 0x0000e882056ccbeeUL;
   tf->codes[22052] = 0x0000e8a19685e820UL;
   tf->codes[22053] = 0x0000e9b4c49e04dfUL;
   tf->codes[22054] = 0x0000e9eea3f6b890UL;
   tf->codes[22055] = 0x0000ea33f33e8cbbUL;
   tf->codes[22056] = 0x0000eb55ffa7207fUL;
   tf->codes[22057] = 0x0000eb6a20d11c37UL;
   tf->codes[22058] = 0x0000ebf708f6fe3fUL;
   tf->codes[22059] = 0x0000edda5f759d44UL;
   tf->codes[22060] = 0x0000edf1b471e9c2UL;
   tf->codes[22061] = 0x0000ee67479b7f4cUL;
   tf->codes[22062] = 0x0000ef15cfe1b173UL;
   tf->codes[22063] = 0x0000ef23fe851729UL;
   tf->codes[22064] = 0x0000efc4cd45ef24UL;
   tf->codes[22065] = 0x0000f13bb6f3df67UL;
   tf->codes[22066] = 0x0000f1530bf02be5UL;
   tf->codes[22067] = 0x0000f30484a3e128UL;
   tf->codes[22068] = 0x0000f31c4ebe3930UL;
   tf->codes[22069] = 0x0000f4a4d570e5b4UL;
   tf->codes[22070] = 0x0000f5770cde9be7UL;
   tf->codes[22071] = 0x0000f5bd0bd38161UL;
   tf->codes[22072] = 0x0000f64a2e88692eUL;
   tf->codes[22073] = 0x0000f87caa54d475UL;
   tf->codes[22074] = 0x0000f984a30cd67fUL;
   tf->codes[22075] = 0x0000fa9b3f8649c9UL;
   tf->codes[22076] = 0x0000fac97460d73bUL;
   tf->codes[22077] = 0x0000fc0d9607c6a8UL;
   tf->codes[22078] = 0x0000fc297e30868aUL;
   tf->codes[22079] = 0x0000fc547f38c336UL;
   tf->codes[22080] = 0x0000fc7c11dfa957UL;
   tf->codes[22081] = 0x0000fcff991d9ed2UL;
   tf->codes[22082] = 0x0000fdc41705fad9UL;
   tf->codes[22083] = 0x0000fecda9a72546UL;
   tf->codes[22084] = 0x0000ff120eb2e25dUL;
   tf->codes[22085] = 0x0000ff12f8eef971UL;
   tf->codes[22086] = 0x0000ff3e6f1541a7UL;
   tf->codes[22087] = 0x0000ffa8ccdebc7cUL;
   tf->codes[22088] = 0x0000ffefb60fb90aUL;
   tf->codes[22089] = 0x000100395df4fad4UL;
   tf->codes[22090] = 0x000103d5f4261346UL;
   tf->codes[22091] = 0x000104805e5ddd93UL;
   tf->codes[22092] = 0x0001048098ece358UL;
   tf->codes[22093] = 0x000105bfecd8599cUL;
   tf->codes[22094] = 0x0001063ee0e9dbb3UL;
   tf->codes[22095] = 0x0001063f1b78e178UL;
   tf->codes[22096] = 0x00010733dd42fedeUL;
   tf->codes[22097] = 0x000107a084a2b365UL;
   tf->codes[22098] = 0x00010826ca94ee1cUL;
   tf->codes[22099] = 0x00010857f8b2c68fUL;
   tf->codes[22100] = 0x00010b985fbdc9e2UL;
   tf->codes[22101] = 0x00010e9cd868e597UL;
   tf->codes[22102] = 0x00010fa8ef2f4f7bUL;
   tf->codes[22103] = 0x00010fbfcf0d906fUL;
   tf->codes[22104] = 0x0001106ecc71ce20UL;
   tf->codes[22105] = 0x0001111dc9d60bd1UL;
   tf->codes[22106] = 0x00011128ff362686UL;
   tf->codes[22107] = 0x0001120581c7e05aUL;
   tf->codes[22108] = 0x000114875d711da8UL;
   tf->codes[22109] = 0x000115ae37952a95UL;
   tf->codes[22110] = 0x000116c45ef09255UL;
   tf->codes[22111] = 0x000116ea1d1f4a4eUL;
   tf->codes[22112] = 0x000117293f5182b2UL;
   tf->codes[22113] = 0x000117f45f6d860aUL;
   tf->codes[22114] = 0x000119b26cdb78a0UL;
   tf->codes[22115] = 0x00011a97661907edUL;
   tf->codes[22116] = 0x00011ba8100be535UL;
   tf->codes[22117] = 0x00011de0b8edec43UL;
   tf->codes[22118] = 0x00011e225f45641eUL;
   tf->codes[22119] = 0x00011e71bf223625UL;
   tf->codes[22120] = 0x00011e97f26ef9a8UL;
   tf->codes[22121] = 0x00011f2848f6323bUL;
   tf->codes[22122] = 0x0001203d861582e7UL;
   tf->codes[22123] = 0x00012074e148f721UL;
   tf->codes[22124] = 0x0001207939e664c0UL;
   tf->codes[22125] = 0x000120de1a47551dUL;
   tf->codes[22126] = 0x000122949b45894eUL;
   tf->codes[22127] = 0x0001237b68fb46c3UL;
   tf->codes[22128] = 0x000123bc9a34b314UL;
   tf->codes[22129] = 0x000124ed84edbdddUL;
   tf->codes[22130] = 0x0001259c8251fb8eUL;
   tf->codes[22131] = 0x000125af7eb0da6dUL;
   tf->codes[22132] = 0x000125b3d74e480cUL;
   tf->codes[22133] = 0x000125ef50902420UL;
   tf->codes[22134] = 0x0001265fdb6f3abcUL;
   tf->codes[22135] = 0x000126964c6697e2UL;
   tf->codes[22136] = 0x0001269b1a22110bUL;
   tf->codes[22137] = 0x0001278b48bfbb0dUL;
   tf->codes[22138] = 0x000127a1ee0ef63cUL;
   tf->codes[22139] = 0x00012818e092ae64UL;
   tf->codes[22140] = 0x00012886e74c8589UL;
   tf->codes[22141] = 0x000128e56008d45aUL;
   tf->codes[22142] = 0x000129b1df7efa50UL;
   tf->codes[22143] = 0x000129e97541744fUL;
   tf->codes[22144] = 0x00012a008faebb08UL;
   tf->codes[22145] = 0x00012a1944052a24UL;
   tf->codes[22146] = 0x00012a7ba040db0aUL;
   tf->codes[22147] = 0x00012a932fcc2d4dUL;
   tf->codes[22148] = 0x00012b33896ef9beUL;
   tf->codes[22149] = 0x00012b71fbf420d3UL;
   tf->codes[22150] = 0x00012b95e5aaaaa4UL;
   tf->codes[22151] = 0x00012c434925bff2UL;
   tf->codes[22152] = 0x00012cfa0d88c1cdUL;
   tf->codes[22153] = 0x00012d23e9c5e1a0UL;
   tf->codes[22154] = 0x00012d2beb53ab8fUL;
   tf->codes[22155] = 0x00012e64d79a8047UL;
   tf->codes[22156] = 0x00012edc3f3c43f9UL;
   tf->codes[22157] = 0x00012f8a17d564d1UL;
   tf->codes[22158] = 0x00012f8dfb54c6e6UL;
   tf->codes[22159] = 0x000130c80c66b877UL;
   tf->codes[22160] = 0x000131eb3d9a6914UL;
   tf->codes[22161] = 0x000132638f7843daUL;
   tf->codes[22162] = 0x000133fdb32fac9fUL;
   tf->codes[22163] = 0x000134f35f35e119UL;
   tf->codes[22164] = 0x00013562159cc98dUL;
   tf->codes[22165] = 0x000135af667267a7UL;
   tf->codes[22166] = 0x0001364ab7cab52aUL;
   tf->codes[22167] = 0x00013685f67d8b79UL;
   tf->codes[22168] = 0x0001373e54c9b5b7UL;
   tf->codes[22169] = 0x0001379f51ab43ffUL;
   tf->codes[22170] = 0x000137ba8a26f292UL;
   tf->codes[22171] = 0x0001383a2de585f8UL;
   tf->codes[22172] = 0x000138cea27b2665UL;
   tf->codes[22173] = 0x00013a3bb6231e91UL;
   tf->codes[22174] = 0x00013a68c6328f2aUL;
   tf->codes[22175] = 0x00013a755aeccc7dUL;
   tf->codes[22176] = 0x00013a897c16c835UL;
   tf->codes[22177] = 0x00013a8adb70ead3UL;
   tf->codes[22178] = 0x00013afba0df0734UL;
   tf->codes[22179] = 0x00013c1411d0a8a6UL;
   tf->codes[22180] = 0x00013ddca4f1a4a2UL;
   tf->codes[22181] = 0x00013e770c0ddb11UL;
   tf->codes[22182] = 0x00013f104e5ef4a7UL;
   tf->codes[22183] = 0x0001429f6599b8b2UL;
   tf->codes[22184] = 0x000142b7df612209UL;
   tf->codes[22185] = 0x000142e82342e368UL;
   tf->codes[22186] = 0x000142f5a23937cfUL;
   tf->codes[22187] = 0x000143424361c49aUL;
   tf->codes[22188] = 0x00014379d9243e99UL;
   tf->codes[22189] = 0x0001437d0cf68f5fUL;
   tf->codes[22190] = 0x000143b84ba965aeUL;
   tf->codes[22191] = 0x00014484cb1f8ba4UL;
   tf->codes[22192] = 0x00014522db2c1e63UL;
   tf->codes[22193] = 0x00014576ce3563ceUL;
   tf->codes[22194] = 0x0001466c7a3b9848UL;
   tf->codes[22195] = 0x000146e2f7a144e6UL;
   tf->codes[22196] = 0x0001479946e63b37UL;
   tf->codes[22197] = 0x000147a8d4e3c38bUL;
   tf->codes[22198] = 0x000148466fd24ac0UL;
   tf->codes[22199] = 0x000148a01ad32068UL;
   tf->codes[22200] = 0x000148c8d2452362UL;
   tf->codes[22201] = 0x000148fde3e25deaUL;
   tf->codes[22202] = 0x0001497bedb7c8edUL;
   tf->codes[22203] = 0x000149da667417beUL;
   tf->codes[22204] = 0x00014a4f49f09bf9UL;
   tf->codes[22205] = 0x00014a78eb9eb607UL;
   tf->codes[22206] = 0x00014aa720794379UL;
   tf->codes[22207] = 0x00014ad0fcb6634cUL;
   tf->codes[22208] = 0x00014afd5d18c296UL;
   tf->codes[22209] = 0x00014ba83c6e986dUL;
   tf->codes[22210] = 0x00014d472de17a5bUL;
   tf->codes[22211] = 0x00014d705a7188dfUL;
   tf->codes[22212] = 0x00014deabb569792UL;
   tf->codes[22213] = 0x00014e521fdcc766UL;
   tf->codes[22214] = 0x00014e6ad4333682UL;
   tf->codes[22215] = 0x00014ee8a3799bc0UL;
   tf->codes[22216] = 0x00014f7bb8b5198fUL;
   tf->codes[22217] = 0x00014fbb50055d7dUL;
   tf->codes[22218] = 0x000150745dfe990aUL;
   tf->codes[22219] = 0x000150896964abd6UL;
   tf->codes[22220] = 0x0001515d002c84a7UL;
   tf->codes[22221] = 0x0001519e6bf4f6bdUL;
   tf->codes[22222] = 0x000151a66d82c0acUL;
   tf->codes[22223] = 0x000151cf24f4c3a6UL;
   tf->codes[22224] = 0x0001521090bd35bcUL;
   tf->codes[22225] = 0x00015211f017585aUL;
   tf->codes[22226] = 0x0001530b450de924UL;
   tf->codes[22227] = 0x000153b53a27a7e7UL;
   tf->codes[22228] = 0x00015415123e1956UL;
   tf->codes[22229] = 0x000154c44a315cccUL;
   tf->codes[22230] = 0x00015552cc406737UL;
   tf->codes[22231] = 0x0001557e07d7a9a8UL;
   tf->codes[22232] = 0x000155e40d03b6deUL;
   tf->codes[22233] = 0x000156015486995eUL;
   tf->codes[22234] = 0x0001561e9c097bdeUL;
   tf->codes[22235] = 0x00015642c04f0b74UL;
   tf->codes[22236] = 0x0001572d36f52539UL;
   tf->codes[22237] = 0x000158786fedc781UL;
   tf->codes[22238] = 0x000158c586345fd6UL;
   tf->codes[22239] = 0x0001599205aa85ccUL;
   tf->codes[22240] = 0x000159e6a860dc86UL;
   tf->codes[22241] = 0x00015ca1b3b5bc36UL;
   tf->codes[22242] = 0x00015ccaa5b6c4f5UL;
   tf->codes[22243] = 0x00015cdb1df0645dUL;
   tf->codes[22244] = 0x00015d916d355aaeUL;
   tf->codes[22245] = 0x00015e02a7c18299UL;
   tf->codes[22246] = 0x00015e1bd135fd3fUL;
   tf->codes[22247] = 0x00015e491bd4739dUL;
   tf->codes[22248] = 0x00015eba90efa14dUL;
   tf->codes[22249] = 0x00015f19443af5e3UL;
   tf->codes[22250] = 0x00015f623c73265eUL;
   tf->codes[22251] = 0x0001605b1c4bab9eUL;
   tf->codes[22252] = 0x000161af7b9d34aeUL;
   tf->codes[22253] = 0x0001629c3bd98825UL;
   tf->codes[22254] = 0x000162fde86827bcUL;
   tf->codes[22255] = 0x0001634128a8c7faUL;
   tf->codes[22256] = 0x0001636044a3d8a2UL;
   tf->codes[22257] = 0x0001636a1aa9d0b9UL;
   tf->codes[22258] = 0x000163755009eb6eUL;
   tf->codes[22259] = 0x000163b2d852fb6fUL;
   tf->codes[22260] = 0x000163caa26d5377UL;
   tf->codes[22261] = 0x000163f9c183f7fdUL;
   tf->codes[22262] = 0x0001646df5536ae9UL;
   tf->codes[22263] = 0x0001653740f74019UL;
   tf->codes[22264] = 0x000165669a9cea64UL;
   tf->codes[22265] = 0x000165f9002b56e4UL;
   tf->codes[22266] = 0x000166891c2389b2UL;
   tf->codes[22267] = 0x000167aaedfd17b1UL;
   tf->codes[22268] = 0x00016806e294270bUL;
   tf->codes[22269] = 0x0001682bb686c7f0UL;
   tf->codes[22270] = 0x00016876bdc62c58UL;
   tf->codes[22271] = 0x00016a612b967e38UL;
   tf->codes[22272] = 0x00016afcf20cd745UL;
   tf->codes[22273] = 0x00016b3412b145baUL;
   tf->codes[22274] = 0x00016b933b1aa5daUL;
   tf->codes[22275] = 0x00016c21480ba4bbUL;
   tf->codes[22276] = 0x00016c2e1754e7d3UL;
   tf->codes[22277] = 0x00016c88ac91d48fUL;
   tf->codes[22278] = 0x00016cf42f266c3dUL;
   tf->codes[22279] = 0x00016e04296c3836UL;
   tf->codes[22280] = 0x00016ea7f1705b32UL;
   tf->codes[22281] = 0x00016ee7fddeaaaaUL;
   tf->codes[22282] = 0x00016f6b851ca025UL;
   tf->codes[22283] = 0x00016f7fa6469bddUL;
   tf->codes[22284] = 0x00016fb910814404UL;
   tf->codes[22285] = 0x00016fc5301d75cdUL;
   tf->codes[22286] = 0x00017106cd9f25c3UL;
   tf->codes[22287] = 0x0001717dc022ddebUL;
   tf->codes[22288] = 0x000171ba98bedc9dUL;
   tf->codes[22289] = 0x000171f05a092874UL;
   tf->codes[22290] = 0x000171fb8f694329UL;
   tf->codes[22291] = 0x0001720bcd13dcccUL;
   tf->codes[22292] = 0x000172f67e48fc56UL;
   tf->codes[22293] = 0x000173a5411e3442UL;
   tf->codes[22294] = 0x000173c84098a6ffUL;
   tf->codes[22295] = 0x000174376c1d9afdUL;
   tf->codes[22296] = 0x000175926da2cb5eUL;
   tf->codes[22297] = 0x000176c3585bd627UL;
   tf->codes[22298] = 0x0001770af139e404UL;
   tf->codes[22299] = 0x000177834317becaUL;
   tf->codes[22300] = 0x0001783957cdaf56UL;
   tf->codes[22301] = 0x00017852814229fcUL;
   tf->codes[22302] = 0x000178d08b1794ffUL;
   tf->codes[22303] = 0x000178d0c5a69ac4UL;
   tf->codes[22304] = 0x000178dad63b98a0UL;
   tf->codes[22305] = 0x000178f140fbce0aUL;
   tf->codes[22306] = 0x00017924f33ee5f4UL;
   tf->codes[22307] = 0x0001795ab48931cbUL;
   tf->codes[22308] = 0x000179fb48bb0401UL;
   tf->codes[22309] = 0x00017a61887616fcUL;
   tf->codes[22310] = 0x00017ad0ee8a10bfUL;
   tf->codes[22311] = 0x00017aef956715ddUL;
   tf->codes[22312] = 0x00017b8a71a157d6UL;
   tf->codes[22313] = 0x00017b9531e36701UL;
   tf->codes[22314] = 0x00017c045d685affUL;
   tf->codes[22315] = 0x00017c89f3ad8467UL;
   tf->codes[22316] = 0x00017d4ac8a5841eUL;
   tf->codes[22317] = 0x00017e5495d5b450UL;
   tf->codes[22318] = 0x00017ea1e6ab526aUL;
   tf->codes[22319] = 0x00017f3c88568e9eUL;
   tf->codes[22320] = 0x00017fe299f0eb4cUL;
   tf->codes[22321] = 0x0001801945774e37UL;
   tf->codes[22322] = 0x00018043d1617f59UL;
   tf->codes[22323] = 0x000180848d7ce020UL;
   tf->codes[22324] = 0x0001808995c75f0eUL;
   tf->codes[22325] = 0x000180b1286e452fUL;
   tf->codes[22326] = 0x000180d2c88e954eUL;
   tf->codes[22327] = 0x0001819de8aa98a6UL;
   tf->codes[22328] = 0x00018208bb921f05UL;
   tf->codes[22329] = 0x000182ebe057802aUL;
   tf->codes[22330] = 0x0001847725be71eaUL;
   tf->codes[22331] = 0x000184f6545ef9c6UL;
   tf->codes[22332] = 0x000185086681c191UL;
   tf->codes[22333] = 0x000185536dc125f9UL;
   tf->codes[22334] = 0x00018621fc3e7fdcUL;
   tf->codes[22335] = 0x000186c8f814f39eUL;
   tf->codes[22336] = 0x00018703fc38c428UL;
   tf->codes[22337] = 0x0001873b91fb3e27UL;
   tf->codes[22338] = 0x000187bb7048d752UL;
   tf->codes[22339] = 0x000187ddfaa53e85UL;
   tf->codes[22340] = 0x000187e6715113feUL;
   tf->codes[22341] = 0x000188497d39d633UL;
   tf->codes[22342] = 0x0001884d60b93848UL;
   tf->codes[22343] = 0x00018898a287a275UL;
   tf->codes[22344] = 0x000189175c0a1ec7UL;
   tf->codes[22345] = 0x00018989f5f06950UL;
   tf->codes[22346] = 0x00018ac73ad4aba7UL;
   tf->codes[22347] = 0x00018b07bc6106a9UL;
   tf->codes[22348] = 0x00018b59a0631827UL;
   tf->codes[22349] = 0x00018c7f1b2d0276UL;
   tf->codes[22350] = 0x00018d2d2e552913UL;
   tf->codes[22351] = 0x00018d9afa7ffa73UL;
   tf->codes[22352] = 0x00018e134c5dd539UL;
   tf->codes[22353] = 0x00018e16babf2bc4UL;
   tf->codes[22354] = 0x00018e2b51073306UL;
   tf->codes[22355] = 0x00018e397faa98bcUL;
   tf->codes[22356] = 0x00018e75a899861fUL;
   tf->codes[22357] = 0x00018e811888a699UL;
   tf->codes[22358] = 0x00018e95e95fb3a0UL;
   tf->codes[22359] = 0x00018e9fbf65abb7UL;
   tf->codes[22360] = 0x00018ec6dcee864eUL;
   tf->codes[22361] = 0x0001906f69d85a8eUL;
   tf->codes[22362] = 0x00019106d7b145fcUL;
   tf->codes[22363] = 0x0001910ba56cbf25UL;
   tf->codes[22364] = 0x000191178a79eb29UL;
   tf->codes[22365] = 0x0001912543ff4555UL;
   tf->codes[22366] = 0x0001917f9ead2c4cUL;
   tf->codes[22367] = 0x000191972e387e8fUL;
   tf->codes[22368] = 0x000191cb9028a7c8UL;
   tf->codes[22369] = 0x000191cfae370fa2UL;
   tf->codes[22370] = 0x000191da33ea1908UL;
   tf->codes[22371] = 0x0001928ee945e6f6UL;
   tf->codes[22372] = 0x000194bfcb2929daUL;
   tf->codes[22373] = 0x00019537e277fedbUL;
   tf->codes[22374] = 0x000195a0a658514dUL;
   tf->codes[22375] = 0x000196213452fbc7UL;
   tf->codes[22376] = 0x0001967e13262235UL;
   tf->codes[22377] = 0x0001967f37f13f0eUL;
   tf->codes[22378] = 0x0001968898d92b9bUL;
   tf->codes[22379] = 0x0001969d69b038a2UL;
   tf->codes[22380] = 0x000196c65bb14161UL;
   tf->codes[22381] = 0x000197183fb352dfUL;
   tf->codes[22382] = 0x0001971f91940b7fUL;
   tf->codes[22383] = 0x000197876b3846ddUL;
   tf->codes[22384] = 0x000197a2a3b3f570UL;
   tf->codes[22385] = 0x00019805ea2bbd6aUL;
   tf->codes[22386] = 0x000198078414e5cdUL;
   tf->codes[22387] = 0x000198696b328b29UL;
   tf->codes[22388] = 0x000198a100f50528UL;
   tf->codes[22389] = 0x000199144a886100UL;
   tf->codes[22390] = 0x0001992955ee73ccUL;
   tf->codes[22391] = 0x0001997d8386befcUL;
   tf->codes[22392] = 0x000199916a21b4efUL;
   tf->codes[22393] = 0x000199954da11704UL;
   tf->codes[22394] = 0x000199e7a6c1340cUL;
   tf->codes[22395] = 0x00019a28284d8f0eUL;
   tf->codes[22396] = 0x00019a2d30980dfcUL;
   tf->codes[22397] = 0x00019aa8069b2839UL;
   tf->codes[22398] = 0x00019acb06159af6UL;
   tf->codes[22399] = 0x00019ae08699b94cUL;
   tf->codes[22400] = 0x00019b23172d483bUL;
   tf->codes[22401] = 0x00019b3ae147a043UL;
   tf->codes[22402] = 0x00019be71ff798b8UL;
   tf->codes[22403] = 0x00019c1e409c072dUL;
   tf->codes[22404] = 0x00019c7aaa512211UL;
   tf->codes[22405] = 0x00019c9da9cb94ceUL;
   tf->codes[22406] = 0x00019d697994a975UL;
   tf->codes[22407] = 0x00019dd91a37a8fdUL;
   tf->codes[22408] = 0x00019ef1160b3ee5UL;
   tf->codes[22409] = 0x00019f111c4266a1UL;
   tf->codes[22410] = 0x00019f6a8cb43684UL;
   tf->codes[22411] = 0x0001a00110510adeUL;
   tf->codes[22412] = 0x0001a01c0e3db3acUL;
   tf->codes[22413] = 0x0001a08b39c2a7aaUL;
   tf->codes[22414] = 0x0001a0d3824dc6d6UL;
   tf->codes[22415] = 0x0001a0d88a9845c4UL;
   tf->codes[22416] = 0x0001a1c3765c6b13UL;
   tf->codes[22417] = 0x0001a1dd4f7df708UL;
   tf->codes[22418] = 0x0001a2bfc49646deUL;
   tf->codes[22419] = 0x0001a2e6a7901bb0UL;
   tf->codes[22420] = 0x0001a32554a4488aUL;
   tf->codes[22421] = 0x0001a366c06cbaa0UL;
   tf->codes[22422] = 0x0001a380d41d4c5aUL;
   tf->codes[22423] = 0x0001a3e8adc187b8UL;
   tf->codes[22424] = 0x0001a410f0157f28UL;
   tf->codes[22425] = 0x0001a4584e648740UL;
   tf->codes[22426] = 0x0001a51a82b6a995UL;
   tf->codes[22427] = 0x0001a586ef875857UL;
   tf->codes[22428] = 0x0001a59a9b934885UL;
   tf->codes[22429] = 0x0001a5b55ef0eb8eUL;
   tf->codes[22430] = 0x0001a7340f9d9ffbUL;
   tf->codes[22431] = 0x0001a7fe457d8c3fUL;
   tf->codes[22432] = 0x0001a807a66578ccUL;
   tf->codes[22433] = 0x0001a969bf3c5c08UL;
   tf->codes[22434] = 0x0001a9918c7247eeUL;
   tf->codes[22435] = 0x0001a9e78e82c146UL;
   tf->codes[22436] = 0x0001aa722d12699cUL;
   tf->codes[22437] = 0x0001aafedaa945dfUL;
   tf->codes[22438] = 0x0001ab41a5cbda93UL;
   tf->codes[22439] = 0x0001abc5dcb6e15dUL;
   tf->codes[22440] = 0x0001ac649c70856bUL;
   tf->codes[22441] = 0x0001ac76397541acUL;
   tf->codes[22442] = 0x0001ac7f5fce2874UL;
   tf->codes[22443] = 0x0001ad0a737bdc54UL;
   tf->codes[22444] = 0x0001ad45b22eb2a3UL;
   tf->codes[22445] = 0x0001add3f9aeb749UL;
   tf->codes[22446] = 0x0001add8c76a3072UL;
   tf->codes[22447] = 0x0001ae5a3fa0f200UL;
   tf->codes[22448] = 0x0001b008bf115c42UL;
   tf->codes[22449] = 0x0001b03e0b3d9c8fUL;
   tf->codes[22450] = 0x0001b2a6485453adUL;
   tf->codes[22451] = 0x0001b562ed925bc0UL;
   tf->codes[22452] = 0x0001b5d7d10edffbUL;
   tf->codes[22453] = 0x0001b68bd6bd9c9aUL;
   tf->codes[22454] = 0x0001b69f483a8703UL;
   tf->codes[22455] = 0x0001b6bd3f6a7ad2UL;
   tf->codes[22456] = 0x0001b6ef1d356494UL;
   tf->codes[22457] = 0x0001b6efcce275e3UL;
   tf->codes[22458] = 0x0001b78bcde7d4b5UL;
   tf->codes[22459] = 0x0001b79e5528a80aUL;
   tf->codes[22460] = 0x0001b7e5ee06b5e7UL;
   tf->codes[22461] = 0x0001b8479a95557eUL;
   tf->codes[22462] = 0x0001b8917d099d0dUL;
   tf->codes[22463] = 0x0001b9cfe6b8fc3dUL;
   tf->codes[22464] = 0x0001b9ef3d4312aaUL;
   tf->codes[22465] = 0x0001baa7d61e42adUL;
   tf->codes[22466] = 0x0001bae5d3855e38UL;
   tf->codes[22467] = 0x0001bca41b825693UL;
   tf->codes[22468] = 0x0001bd272da24084UL;
   tf->codes[22469] = 0x0001bd610cfaf435UL;
   tf->codes[22470] = 0x0001be53bfbdddaeUL;
   tf->codes[22471] = 0x0001bef453efafe4UL;
   tf->codes[22472] = 0x0001bf813c1591ecUL;
   tf->codes[22473] = 0x0001bfe323333748UL;
   tf->codes[22474] = 0x0001c061dcb5b39aUL;
   tf->codes[22475] = 0x0001c0b60a4dfecaUL;
   tf->codes[22476] = 0x0001c122b1adb351UL;
   tf->codes[22477] = 0x0001c1cbf71a60c5UL;
   tf->codes[22478] = 0x0001c1d6b75c6ff0UL;
   tf->codes[22479] = 0x0001c287fe56e753UL;
   tf->codes[22480] = 0x0001c3c752425d97UL;
   tf->codes[22481] = 0x0001c3c7c7606921UL;
   tf->codes[22482] = 0x0001c400bc7d05beUL;
   tf->codes[22483] = 0x0001c45a2ceed5a1UL;
   tf->codes[22484] = 0x0001c4818506b5fdUL;
   tf->codes[22485] = 0x0001c4e0ad70161dUL;
   tf->codes[22486] = 0x0001c4f4ce9a11d5UL;
   tf->codes[22487] = 0x0001c55ef1d486e5UL;
   tf->codes[22488] = 0x0001c562d553e8faUL;
   tf->codes[22489] = 0x0001c59562cbe40bUL;
   tf->codes[22490] = 0x0001c5dfba5e3724UL;
   tf->codes[22491] = 0x0001c63c5ea257cdUL;
   tf->codes[22492] = 0x0001c6f61c48a4a9UL;
   tf->codes[22493] = 0x0001c797d54593b8UL;
   tf->codes[22494] = 0x0001c7e0cd7dc433UL;
   tf->codes[22495] = 0x0001c7e5261b31d2UL;
   tf->codes[22496] = 0x0001c7f2dfa08bfeUL;
   tf->codes[22497] = 0x0001c851585cdacfUL;
   tf->codes[22498] = 0x0001c997890afe29UL;
   tf->codes[22499] = 0x0001ca23c183cee2UL;
   tf->codes[22500] = 0x0001ca43529ceb14UL;
   tf->codes[22501] = 0x0001ca5e8b1899a7UL;
   tf->codes[22502] = 0x0001ca81ffb117eeUL;
   tf->codes[22503] = 0x0001ca861dbf7fc8UL;
   tf->codes[22504] = 0x0001cad33406181dUL;
   tf->codes[22505] = 0x0001cb76fc0a3b19UL;
   tf->codes[22506] = 0x0001cbcd38a9ba36UL;
   tf->codes[22507] = 0x0001cc07c7af7f36UL;
   tf->codes[22508] = 0x0001cc0ea4722c4cUL;
   tf->codes[22509] = 0x0001cc54a36711c6UL;
   tf->codes[22510] = 0x0001cc9a67ccf17bUL;
   tf->codes[22511] = 0x0001ccfb64ae7fc3UL;
   tf->codes[22512] = 0x0001cdcfab2369e3UL;
   tf->codes[22513] = 0x0001cf771342214aUL;
   tf->codes[22514] = 0x0001cffef31d8464UL;
   tf->codes[22515] = 0x0001d097fadf9835UL;
   tf->codes[22516] = 0x0001d09d032a1723UL;
   tf->codes[22517] = 0x0001d0bf186872ccUL;
   tf->codes[22518] = 0x0001d0c495d0fd44UL;
   tf->codes[22519] = 0x0001d0d5bdb7adfbUL;
   tf->codes[22520] = 0x0001d1923a124013UL;
   tf->codes[22521] = 0x0001d565b658c135UL;
   tf->codes[22522] = 0x0001d6a5b9f148c8UL;
   tf->codes[22523] = 0x0001d769fd4a9f0aUL;
   tf->codes[22524] = 0x0001d78953d4b577UL;
   tf->codes[22525] = 0x0001d80b7bb88854UL;
   tf->codes[22526] = 0x0001d811a8ce241bUL;
   tf->codes[22527] = 0x0001d835cd13b3b1UL;
   tf->codes[22528] = 0x0001d864b19b5272UL;
   tf->codes[22529] = 0x0001d8f57d40968fUL;
   tf->codes[22530] = 0x0001d95c6ca8bad9UL;
   tf->codes[22531] = 0x0001da43ea0b899dUL;
   tf->codes[22532] = 0x0001db1a3f87a7aaUL;
   tf->codes[22533] = 0x0001db784325eaf1UL;
   tf->codes[22534] = 0x0001dc1ddfa23c15UL;
   tf->codes[22535] = 0x0001dd0d5e92d4c8UL;
   tf->codes[22536] = 0x0001dd56915a0b08UL;
   tf->codes[22537] = 0x0001dd5a74d96d1dUL;
   tf->codes[22538] = 0x0001ddd426116a81UL;
   tf->codes[22539] = 0x0001df45cce5d611UL;
   tf->codes[22540] = 0x0001df4766cefe74UL;
   tf->codes[22541] = 0x0001df4a9aa14f3aUL;
   tf->codes[22542] = 0x0001df7f71af83fdUL;
   tf->codes[22543] = 0x0001df83ca4cf19cUL;
   tf->codes[22544] = 0x0001df88d297708aUL;
   tf->codes[22545] = 0x0001df9e188c891bUL;
   tf->codes[22546] = 0x0001dfc77fab9d64UL;
   tf->codes[22547] = 0x0001dfced18c5604UL;
   tf->codes[22548] = 0x0001dfd6988b1a2eUL;
   tf->codes[22549] = 0x0001e03d12d532eeUL;
   tf->codes[22550] = 0x0001e05b0a0526bdUL;
   tf->codes[22551] = 0x0001e0ef7e9ac72aUL;
   tf->codes[22552] = 0x0001e13e69598da7UL;
   tf->codes[22553] = 0x0001e172562bab56UL;
   tf->codes[22554] = 0x0001e273e73f0bd4UL;
   tf->codes[22555] = 0x0001e2c1ad32b578UL;
   tf->codes[22556] = 0x0001e2fe4b3fae65UL;
   tf->codes[22557] = 0x0001e335a673229fUL;
   tf->codes[22558] = 0x0001e43ae076df6dUL;
   tf->codes[22559] = 0x0001e4d2c36dd665UL;
   tf->codes[22560] = 0x0001e569bc28b649UL;
   tf->codes[22561] = 0x0001e5a23c27475cUL;
   tf->codes[22562] = 0x0001e6e0a5d6a68cUL;
   tf->codes[22563] = 0x0001e6efbeb62356UL;
   tf->codes[22564] = 0x0001e80695be9c65UL;
   tf->codes[22565] = 0x0001e80a793dfe7aUL;
   tf->codes[22566] = 0x0001e90aaaf73c5aUL;
   tf->codes[22567] = 0x0001ea02db22b04bUL;
   tf->codes[22568] = 0x0001eac54a03d865UL;
   tf->codes[22569] = 0x0001ead96b2dd41dUL;
   tf->codes[22570] = 0x0001eb025d2edcdcUL;
   tf->codes[22571] = 0x0001eb665353b625UL;
   tf->codes[22572] = 0x0001eb8ff501d033UL;
   tf->codes[22573] = 0x0001ebf28bcc86deUL;
   tf->codes[22574] = 0x0001ec24deb57c2aUL;
   tf->codes[22575] = 0x0001ed89b640a4a2UL;
   tf->codes[22576] = 0x0001ee2be45b9f3bUL;
   tf->codes[22577] = 0x0001ef26d33b5868UL;
   tf->codes[22578] = 0x0001ef2d756effb9UL;
   tf->codes[22579] = 0x0001ef58b106422aUL;
   tf->codes[22580] = 0x0001ef9b7c28d6deUL;
   tf->codes[22581] = 0x0001efb22178120dUL;
   tf->codes[22582] = 0x0001f03c8578b49eUL;
   tf->codes[22583] = 0x0001f08b70377b1bUL;
   tf->codes[22584] = 0x0001f101ed9d27b9UL;
   tf->codes[22585] = 0x0001f16a76ee7466UL;
   tf->codes[22586] = 0x0001f18ba1f0b8fbUL;
   tf->codes[22587] = 0x0001f248cdf85c62UL;
   tf->codes[22588] = 0x0001f2b27c14c5e8UL;
   tf->codes[22589] = 0x0001f475573e31a7UL;
   tf->codes[22590] = 0x0001f56b786271abUL;
   tf->codes[22591] = 0x0001f5ea6c73f3c2UL;
   tf->codes[22592] = 0x0001f6177c83645bUL;
   tf->codes[22593] = 0x0001f625e5b5cfd6UL;
   tf->codes[22594] = 0x0001f636987e7503UL;
   tf->codes[22595] = 0x0001f6745b568ac9UL;
   tf->codes[22596] = 0x0001f6871d2663e3UL;
   tf->codes[22597] = 0x0001f6a3b4fc3514UL;
   tf->codes[22598] = 0x0001f6ad50732766UL;
   tf->codes[22599] = 0x0001f71b91bc0450UL;
   tf->codes[22600] = 0x0001f951415ac05dUL;
   tf->codes[22601] = 0x0001fa06a6639f9aUL;
   tf->codes[22602] = 0x0001fa087adbcdc2UL;
   tf->codes[22603] = 0x0001fa2a901a296bUL;
   tf->codes[22604] = 0x0001fa5c33560d68UL;
   tf->codes[22605] = 0x0001fb048e86a3c8UL;
   tf->codes[22606] = 0x0001fb843245372eUL;
   tf->codes[22607] = 0x0001fbff42d75730UL;
   tf->codes[22608] = 0x0001fc28a9f66b79UL;
   tf->codes[22609] = 0x0001fd15df50ca7aUL;
   tf->codes[22610] = 0x0001fd406b3afb9cUL;
   tf->codes[22611] = 0x0001fdc37d5ae58dUL;
   tf->codes[22612] = 0x0001fe290d68e739UL;
   tf->codes[22613] = 0x0001fecb3b83e1d2UL;
   tf->codes[22614] = 0x0001ff5d6683488dUL;
   tf->codes[22615] = 0x0001ff72375a5594UL;
   tf->codes[22616] = 0x0001ff74f60e9ad0UL;
   tf->codes[22617] = 0x000000968d59230aUL;
   tf->codes[22618] = 0x00000107c7e54af5UL;
   tf->codes[22619] = 0x000001ff0dd4a7d2UL;
   tf->codes[22620] = 0x00000213698da94fUL;
   tf->codes[22621] = 0x000002cec11d1e8eUL;
   tf->codes[22622] = 0x0000031709a83dbaUL;
   tf->codes[22623] = 0x0000039f5ea1ac5eUL;
   tf->codes[22624] = 0x0000040ae136440cUL;
   tf->codes[22625] = 0x0000046c5335dddeUL;
   tf->codes[22626] = 0x000005bc1f5af38aUL;
   tf->codes[22627] = 0x00000609703091a4UL;
   tf->codes[22628] = 0x000006455e907942UL;
   tf->codes[22629] = 0x0000072514f483dcUL;
   tf->codes[22630] = 0x0000075ce54603a0UL;
   tf->codes[22631] = 0x000007709151f3ceUL;
   tf->codes[22632] = 0x000007a9115084e1UL;
   tf->codes[22633] = 0x000007cde54325c6UL;
   tf->codes[22634] = 0x00000809d3a30d64UL;
   tf->codes[22635] = 0x0000080b6d8c35c7UL;
   tf->codes[22636] = 0x000008349a1c444bUL;
   tf->codes[22637] = 0x0000083bebfcfcebUL;
   tf->codes[22638] = 0x000008822580e82aUL;
   tf->codes[22639] = 0x00000897a6050680UL;
   tf->codes[22640] = 0x000008a43abf43d3UL;
   tf->codes[22641] = 0x000008befe1ce6dcUL;
   tf->codes[22642] = 0x000008c68a8ca541UL;
   tf->codes[22643] = 0x000009462e4b38a7UL;
   tf->codes[22644] = 0x00000ae67f183d33UL;
   tf->codes[22645] = 0x00000b3b5c5d99b2UL;
   tf->codes[22646] = 0x00000caded6e1c56UL;
   tf->codes[22647] = 0x00000cba0d0a4e1fUL;
   tf->codes[22648] = 0x00000d4b133e9801UL;
   tf->codes[22649] = 0x00000d5090a72279UL;
   tf->codes[22650] = 0x00000d90d7a477b6UL;
   tf->codes[22651] = 0x00000da5335d7933UL;
   tf->codes[22652] = 0x00000e0be83697b8UL;
   tf->codes[22653] = 0x00000ee0a3c98d62UL;
   tf->codes[22654] = 0x00000f57964d458aUL;
   tf->codes[22655] = 0x00000f6cdc425e1bUL;
   tf->codes[22656] = 0x00000f7c2fb0e0aaUL;
   tf->codes[22657] = 0x00000f94e4074fc6UL;
   tf->codes[22658] = 0x00000fa1eddf98a3UL;
   tf->codes[22659] = 0x00000ffcbdab8b24UL;
   tf->codes[22660] = 0x0000100a3ca1df8bUL;
   tf->codes[22661] = 0x0000109082941a42UL;
   tf->codes[22662] = 0x00001111108ec4bcUL;
   tf->codes[22663] = 0x00001233cca469cfUL;
   tf->codes[22664] = 0x0000125de3708f67UL;
   tf->codes[22665] = 0x0000127a7b466098UL;
   tf->codes[22666] = 0x000012c92b762150UL;
   tf->codes[22667] = 0x000012dc27d5002fUL;
   tf->codes[22668] = 0x00001346859e7b04UL;
   tf->codes[22669] = 0x000013fcd4e37155UL;
   tf->codes[22670] = 0x000013fd849082a4UL;
   tf->codes[22671] = 0x00001415141bd4e7UL;
   tf->codes[22672] = 0x000014c39c62070eUL;
   tf->codes[22673] = 0x000015279286e057UL;
   tf->codes[22674] = 0x0000154b41ae6463UL;
   tf->codes[22675] = 0x0000158ad8fea851UL;
   tf->codes[22676] = 0x000015fdad73f89fUL;
   tf->codes[22677] = 0x00001655496d9a5aUL;
   tf->codes[22678] = 0x000016e1f704769dUL;
   tf->codes[22679] = 0x000016e6c4bfefc6UL;
   tf->codes[22680] = 0x000016fd6a0f2af5UL;
   tf->codes[22681] = 0x00001722b31fd764UL;
   tf->codes[22682] = 0x0000173c8c416359UL;
   tf->codes[22683] = 0x0000175fc64adbdbUL;
   tf->codes[22684] = 0x0000182a36b9cde4UL;
   tf->codes[22685] = 0x0000183aaef36d4cUL;
   tf->codes[22686] = 0x000018857ba3cbefUL;
   tf->codes[22687] = 0x000018a6a6a61084UL;
   tf->codes[22688] = 0x000018f7a06c0aeeUL;
   tf->codes[22689] = 0x000019a6634142daUL;
   tf->codes[22690] = 0x000019afc4292f67UL;
   tf->codes[22691] = 0x000019fd4f8dd346UL;
   tf->codes[22692] = 0x00001a6c05f4bbbaUL;
   tf->codes[22693] = 0x00001beb2bbf7bb1UL;
   tf->codes[22694] = 0x00001c2754ae6914UL;
   tf->codes[22695] = 0x00001ccfea6e0539UL;
   tf->codes[22696] = 0x00001d2a451bec30UL;
   tf->codes[22697] = 0x00001db60876b15fUL;
   tf->codes[22698] = 0x00001e4d764f9ccdUL;
   tf->codes[22699] = 0x00001e4deb6da857UL;
   tf->codes[22700] = 0x00001f2182358128UL;
   tf->codes[22701] = 0x00001fc3eadf8186UL;
   tf->codes[22702] = 0x000020d75386a40aUL;
   tf->codes[22703] = 0x00002257638d7b15UL;
   tf->codes[22704] = 0x0000237eed5e9951UL;
   tf->codes[22705] = 0x000023b76d5d2a64UL;
   tf->codes[22706] = 0x0000245df415929cUL;
   tf->codes[22707] = 0x00002530db305a1eUL;
   tf->codes[22708] = 0x00002558a8664604UL;
   tf->codes[22709] = 0x00002569209fe56cUL;
   tf->codes[22710] = 0x00002583e3fd8875UL;
   tf->codes[22711] = 0x0000265de26a02d2UL;
   tf->codes[22712] = 0x0000269ffddf8637UL;
   tf->codes[22713] = 0x00002763918bcb2aUL;
   tf->codes[22714] = 0x000028ff149d568dUL;
   tf->codes[22715] = 0x00002a5ea94efa52UL;
   tf->codes[22716] = 0x00002af47d3ebd5dUL;
   tf->codes[22717] = 0x00002b553f9145e0UL;
   tf->codes[22718] = 0x00002c6b2c5da7dbUL;
   tf->codes[22719] = 0x00002c836b960b6dUL;
   tf->codes[22720] = 0x00002da8e65ff5bcUL;
   tf->codes[22721] = 0x00002f7fa824576eUL;
   tf->codes[22722] = 0x0000313e653f5b53UL;
   tf->codes[22723] = 0x000032370a88daceUL;
   tf->codes[22724] = 0x000032c1e3a788e9UL;
   tf->codes[22725] = 0x000032fb887136d5UL;
   tf->codes[22726] = 0x000033a3e3a1cd35UL;
   tf->codes[22727] = 0x000034264614a5d7UL;
   tf->codes[22728] = 0x00003479c3ffdfb8UL;
   tf->codes[22729] = 0x00003479fe8ee57dUL;
   tf->codes[22730] = 0x00003579bb2a17d3UL;
   tf->codes[22731] = 0x000035e5ed6bc0d0UL;
   tf->codes[22732] = 0x0000367dd062b7c8UL;
   tf->codes[22733] = 0x0000370ed69701aaUL;
   tf->codes[22734] = 0x0000375f20afeac5UL;
   tf->codes[22735] = 0x0000389c65942d1cUL;
   tf->codes[22736] = 0x000038d819650ef5UL;
   tf->codes[22737] = 0x00003993ab8389f9UL;
   tf->codes[22738] = 0x0000399f5601b038UL;
   tf->codes[22739] = 0x000039da94b48687UL;
   tf->codes[22740] = 0x00003a53963f729cUL;
   tf->codes[22741] = 0x00003af0bc0fee47UL;
   tf->codes[22742] = 0x00003b85a5c39a3eUL;
   tf->codes[22743] = 0x00003b977d575c44UL;
   tf->codes[22744] = 0x00003bd57abe77cfUL;
   tf->codes[22745] = 0x00003e1e26bc12bbUL;
   tf->codes[22746] = 0x00003e42faaeb3a0UL;
   tf->codes[22747] = 0x00003e9bf60277f9UL;
   tf->codes[22748] = 0x000040aafd3664f9UL;
   tf->codes[22749] = 0x000040d54e919056UL;
   tf->codes[22750] = 0x000040f938481a27UL;
   tf->codes[22751] = 0x00004123148539faUL;
   tf->codes[22752] = 0x000041490d42f7b8UL;
   tf->codes[22753] = 0x000041a27db4c79bUL;
   tf->codes[22754] = 0x000041d3abd2a00eUL;
   tf->codes[22755] = 0x000041d9293b2a86UL;
   tf->codes[22756] = 0x00004224307a8eeeUL;
   tf->codes[22757] = 0x0000424b88926f4aUL;
   tf->codes[22758] = 0x000042ab2619daf4UL;
   tf->codes[22759] = 0x000042ad35210ee1UL;
   tf->codes[22760] = 0x00004394b283dda5UL;
   tf->codes[22761] = 0x000043e5e6d8ddd4UL;
   tf->codes[22762] = 0x000044b55f924ecbUL;
   tf->codes[22763] = 0x000044c8216227e5UL;
   tf->codes[22764] = 0x000045854d69cb4cUL;
   tf->codes[22765] = 0x000045cbfc0bc215UL;
   tf->codes[22766] = 0x00004616190f0f69UL;
   tf->codes[22767] = 0x000046d763251aaaUL;
   tf->codes[22768] = 0x000047210b0a5c74UL;
   tf->codes[22769] = 0x000047368b8e7acaUL;
   tf->codes[22770] = 0x0000488f7e0c773eUL;
   tf->codes[22771] = 0x000048c8adb819a0UL;
   tf->codes[22772] = 0x000048ea88676f84UL;
   tf->codes[22773] = 0x0000492d8e1909fdUL;
   tf->codes[22774] = 0x000049fea0bba357UL;
   tf->codes[22775] = 0x00004b1bdf68bdf2UL;
   tf->codes[22776] = 0x00004b487a5a2301UL;
   tf->codes[22777] = 0x00004b65874dffbcUL;
   tf->codes[22778] = 0x00004b793359efeaUL;
   tf->codes[22779] = 0x00004bdf731502e5UL;
   tf->codes[22780] = 0x00004beda1b8689bUL;
   tf->codes[22781] = 0x00004c6125daca38UL;
   tf->codes[22782] = 0x00004cc25d4b5e45UL;
   tf->codes[22783] = 0x00004d5ff839e57aUL;
   tf->codes[22784] = 0x00004d912657bdedUL;
   tf->codes[22785] = 0x00004dcacb216bd9UL;
   tf->codes[22786] = 0x00004dd9e400e8a3UL;
   tf->codes[22787] = 0x00004df30d756349UL;
   tf->codes[22788] = 0x00004e6323366e5bUL;
   tf->codes[22789] = 0x00004efe39ffb619UL;
   tf->codes[22790] = 0x00004fabd809d12cUL;
   tf->codes[22791] = 0x000051a140ab37fcUL;
   tf->codes[22792] = 0x00005230acf6597bUL;
   tf->codes[22793] = 0x00005313220ea951UL;
   tf->codes[22794] = 0x000053135c9daf16UL;
   tf->codes[22795] = 0x000053cc6a96eaa3UL;
   tf->codes[22796] = 0x000054dbefbeab12UL;
   tf->codes[22797] = 0x000054eace0f2217UL;
   tf->codes[22798] = 0x0000553aa309ffa8UL;
   tf->codes[22799] = 0x0000553c02642246UL;
   tf->codes[22800] = 0x0000557da8bb9a21UL;
   tf->codes[22801] = 0x00005620fba1b193UL;
   tf->codes[22802] = 0x000056a1feba6797UL;
   tf->codes[22803] = 0x000056c0e026727aUL;
   tf->codes[22804] = 0x0000576c349a53dbUL;
   tf->codes[22805] = 0x000057c27139d2f8UL;
   tf->codes[22806] = 0x00005945efa2008eUL;
   tf->codes[22807] = 0x000059621259c635UL;
   tf->codes[22808] = 0x0000598dfd9e19f5UL;
   tf->codes[22809] = 0x00005a23d18ddd00UL;
   tf->codes[22810] = 0x00005a240c1ce2c5UL;
   tf->codes[22811] = 0x00005a269042223cUL;
   tf->codes[22812] = 0x00005a6836999a17UL;
   tf->codes[22813] = 0x00005a7a0e2d5c1dUL;
   tf->codes[22814] = 0x00005b25d7bf4908UL;
   tf->codes[22815] = 0x00005b674387bb1eUL;
   tf->codes[22816] = 0x00005b8ab8203965UL;
   tf->codes[22817] = 0x00005ba1d28d801eUL;
   tf->codes[22818] = 0x00005c66c593e7afUL;
   tf->codes[22819] = 0x00005d313602d9b8UL;
   tf->codes[22820] = 0x00005d443261b897UL;
   tf->codes[22821] = 0x00005e58fa62fdb9UL;
   tf->codes[22822] = 0x00005fef3a9b0469UL;
   tf->codes[22823] = 0x0000606199f2492dUL;
   tf->codes[22824] = 0x0000609bee690868UL;
   tf->codes[22825] = 0x000060c8143c61edUL;
   tf->codes[22826] = 0x000060fc762c8b26UL;
   tf->codes[22827] = 0x00006288a5cf93faUL;
   tf->codes[22828] = 0x000063fc211c2db2UL;
   tf->codes[22829] = 0x00006479b5d38d2bUL;
   tf->codes[22830] = 0x000064c39847d4baUL;
   tf->codes[22831] = 0x00006537cc1747a6UL;
   tf->codes[22832] = 0x000065c10b4ccd5eUL;
   tf->codes[22833] = 0x000065c3ca01129aUL;
   tf->codes[22834] = 0x000065e4455645e0UL;
   tf->codes[22835] = 0x000066619f7e9f94UL;
   tf->codes[22836] = 0x000067a3778f554fUL;
   tf->codes[22837] = 0x000068205c99a379UL;
   tf->codes[22838] = 0x00006975e0b64962UL;
   tf->codes[22839] = 0x000069ea1485bc4eUL;
   tf->codes[22840] = 0x00006a676eae1602UL;
   tf->codes[22841] = 0x00006aa5a6a43752UL;
   tf->codes[22842] = 0x00006aa98a239967UL;
   tf->codes[22843] = 0x00006b25bf80d642UL;
   tf->codes[22844] = 0x00006c127fbd29b9UL;
   tf->codes[22845] = 0x00006cdc7b0e1038UL;
   tf->codes[22846] = 0x00006dd0529c168aUL;
   tf->codes[22847] = 0x00006e477faed477UL;
   tf->codes[22848] = 0x00006f389888958dUL;
   tf->codes[22849] = 0x00006fefd209a2f2UL;
   tf->codes[22850] = 0x00007023844cbadcUL;
   tf->codes[22851] = 0x000070388fb2cda8UL;
   tf->codes[22852] = 0x000070bd764ae5c1UL;
   tf->codes[22853] = 0x000070cdb3f57f64UL;
   tf->codes[22854] = 0x000070d62aa154ddUL;
   tf->codes[22855] = 0x000071c5a991ed90UL;
   tf->codes[22856] = 0x000071dd391d3fd3UL;
   tf->codes[22857] = 0x000071fd79e36d54UL;
   tf->codes[22858] = 0x00007336a0b947d1UL;
   tf->codes[22859] = 0x000073bf3041bc3aUL;
   tf->codes[22860] = 0x000074a8478db361UL;
   tf->codes[22861] = 0x00007523581fd363UL;
   tf->codes[22862] = 0x0000757367a9b6b9UL;
   tf->codes[22863] = 0x0000757e27ebc5e4UL;
   tf->codes[22864] = 0x000075c0b87f54d3UL;
   tf->codes[22865] = 0x0000772ad2e401feUL;
   tf->codes[22866] = 0x0000776bc98e688aUL;
   tf->codes[22867] = 0x0000780d0d6d4c0fUL;
   tf->codes[22868] = 0x000078e412967b6bUL;
   tf->codes[22869] = 0x000079d2e1da02cfUL;
   tf->codes[22870] = 0x00007a0ed039ea6dUL;
   tf->codes[22871] = 0x00007a36d7fedc18UL;
   tf->codes[22872] = 0x00007a48af929e1eUL;
   tf->codes[22873] = 0x00007a54949fca22UL;
   tf->codes[22874] = 0x00007abd1df116cfUL;
   tf->codes[22875] = 0x00007bbd8a395a74UL;
   tf->codes[22876] = 0x00007c285d20e0d3UL;
   tf->codes[22877] = 0x00007c3bce9dcb3cUL;
   tf->codes[22878] = 0x00007d08c331fcbcUL;
   tf->codes[22879] = 0x00007d19b089a7aeUL;
   tf->codes[22880] = 0x00007d252078c828UL;
   tf->codes[22881] = 0x00007d7cbc7269e3UL;
   tf->codes[22882] = 0x00007d923cf68839UL;
   tf->codes[22883] = 0x00007e381401df22UL;
   tf->codes[22884] = 0x00007ef7c42ec200UL;
   tf->codes[22885] = 0x00007f584bf244beUL;
   tf->codes[22886] = 0x000080a34a5be141UL;
   tf->codes[22887] = 0x00008114bf770ef1UL;
   tf->codes[22888] = 0x0000822da586bbedUL;
   tf->codes[22889] = 0x00008278acc62055UL;
   tf->codes[22890] = 0x000082a004de00b1UL;
   tf->codes[22891] = 0x000082b809875e7eUL;
   tf->codes[22892] = 0x000082c30458736eUL;
   tf->codes[22893] = 0x000083a32fda8992UL;
   tf->codes[22894] = 0x000083d3e8da567bUL;
   tf->codes[22895] = 0x0000840292d2ef77UL;
   tf->codes[22896] = 0x00008424a8114b20UL;
   tf->codes[22897] = 0x000084293b3dbe84UL;
   tf->codes[22898] = 0x00008653405e5452UL;
   tf->codes[22899] = 0x0000865a923f0cf2UL;
   tf->codes[22900] = 0x0000872243f9b9bfUL;
   tf->codes[22901] = 0x00008901074be560UL;
   tf->codes[22902] = 0x000089c12c96d3c8UL;
   tf->codes[22903] = 0x00008bc4142e8effUL;
   tf->codes[22904] = 0x00008c4b7eebe68fUL;
   tf->codes[22905] = 0x00008c8439797d67UL;
   tf->codes[22906] = 0x00008c9aa439b2d1UL;
   tf->codes[22907] = 0x00008d3afddc7f42UL;
   tf->codes[22908] = 0x00008d69e2641e03UL;
   tf->codes[22909] = 0x00008e53a95d2679UL;
   tf->codes[22910] = 0x00008e6f1c67dad1UL;
   tf->codes[22911] = 0x00008e8d88b5da2aUL;
   tf->codes[22912] = 0x00008effad7e1929UL;
   tf->codes[22913] = 0x00008fbd4ea3c81aUL;
   tf->codes[22914] = 0x00008fe939e81bdaUL;
   tf->codes[22915] = 0x00008fff6a194b7fUL;
   tf->codes[22916] = 0x000090cee2d2bc76UL;
   tf->codes[22917] = 0x0000922725a3a79bUL;
   tf->codes[22918] = 0x0000923728bf3b79UL;
   tf->codes[22919] = 0x0000928b565786a9UL;
   tf->codes[22920] = 0x000092a0d6dba4ffUL;
   tf->codes[22921] = 0x000093c5dc8783c4UL;
   tf->codes[22922] = 0x00009468ba4f8facUL;
   tf->codes[22923] = 0x000095f9b7ae11a9UL;
   tf->codes[22924] = 0x0000967871308dfbUL;
   tf->codes[22925] = 0x0000979cc72f5b71UL;
   tf->codes[22926] = 0x000097d5f6dafdd3UL;
   tf->codes[22927] = 0x0000983977e1cb92UL;
   tf->codes[22928] = 0x0000983a278edce1UL;
   tf->codes[22929] = 0x000098fb71a4e822UL;
   tf->codes[22930] = 0x0000999b1b9aa344UL;
   tf->codes[22931] = 0x000099b47f9e23afUL;
   tf->codes[22932] = 0x00009a3e6e80bab6UL;
   tf