const tests = [
  // ==== Date only ====

  // dd-MMM-yyyy
  ["24-Apr-2023", "2023-04-24T00:00:00"],
  ["24-apr-2023", "2023-04-24T00:00:00"],
  ["24-April-2023", "2023-04-24T00:00:00"],
  ["24-APRIL-2023", "2023-04-24T00:00:00"],
  ["24-Apr-2033", "2033-04-24T00:00:00"],

  ["24-Apr-0023", "0023-04-24T00:00:00"],

  // dd-MMM-yy
  ["24-Apr-23", "2023-04-24T00:00:00"],
  ["24-Apr-33", "2033-04-24T00:00:00"],

  // dd-MMM-yyy
  ["24-Apr-023", "2023-04-24T00:00:00"],

  // yyyy-MM-dd
  ["2023-Apr-24", "2023-04-24T00:00:00"],
  ["2033-Apr-24", "2033-04-24T00:00:00"],

  // yy-MM-dd
  ["33-Apr-24", "2033-04-24T00:00:00"],

  // yyy-MM-dd
  ["033-Apr-24", "2033-04-24T00:00:00"],

  // ==== Date followed by hour and TZ ====

  ["24-Apr-2023 12:34:56", "2023-04-24T12:34:56"],
  ["24-Apr-2023 Mon 12:34:56", "2023-04-24T12:34:56"],
  ["24-Apr-2023 (Mon) 12:34:56", "2023-04-24T12:34:56"],
  ["24-Apr-2023(Mon)12:34:56", "2023-04-24T12:34:56"],

  ["24-Apr-2023,12:34:56", "2023-04-24T12:34:56"],
  ["24-Apr-2023,Mon 12:34:56", "2023-04-24T12:34:56"],

  ["24-Apr-2023 12:34:56 GMT", "2023-04-24T12:34:56Z"],
  ["24-Apr-2023 12:34:56 +04", "2023-04-24T12:34:56+04:00"],
  ["24-Apr-2023 12:34:56 +04:30", "2023-04-24T12:34:56+04:30"],
  ["24-Apr-2023 12:34:56 -04", "2023-04-24T12:34:56-04:00"],
  ["24-Apr-2023 12:34:56 -04:30", "2023-04-24T12:34:56-04:30"],

  ["24-Apr-2023 GMT", "2023-04-24T00:00:00Z"],
  ["24-Apr-2023 +04", "2023-04-24T00:00:00+04:00"],
  ["24-Apr-2023 +04:30", "2023-04-24T00:00:00+04:30"],
  ["24-Apr-2023 -04", "2023-04-24T00:00:00-04:00"],
  ["24-Apr-2023 -04:30", "2023-04-24T00:00:00-04:30"],

  ["24-Apr-2023GMT", "2023-04-24T00:00:00Z"],
  ["24-Apr-2023+04", "2023-04-24T00:00:00+04:00"],
  ["24-Apr-2023+04:30", "2023-04-24T00:00:00+04:30"],
  ["24-Apr-2023-04", "2023-04-24T00:00:00-04:00"],
  ["24-Apr-2023-04:30", "2023-04-24T00:00:00-04:30"],

  ["24-Apr-2023,GMT", "2023-04-24T00:00:00Z"],
  ["24-Apr-2023,+04", "2023-04-24T00:00:00+04:00"],
  ["24-Apr-2023,+04:30", "2023-04-24T00:00:00+04:30"],
  ["24-Apr-2023,-04", "2023-04-24T00:00:00-04:00"],
  ["24-Apr-2023,-04:30", "2023-04-24T00:00:00-04:30"],

  ["24-Apr-2023/12:34:56", "2023-04-24T12:34:56"],
  ["24-Apr-2023/GMT", "2023-04-24T00:00:00Z"],

  // ==== non dd-MMM-yyyy. Uses fallback path ====

  // Missing space.
  ["24-Apr-202312:13:14", "-202312-04-24T13:14:00"],

  // Extra delimiter.
  ["24-Apr- 2023", "2023-04-24T00:00:00"],
  ["24-Apr -2023", "-002023-04-24T00:00:00"],
  ["24- Apr-2023", "-002023-04-24T00:00:00"],
  ["24 -Apr-2023", "-002023-04-24T00:00:00"],

  ["24-Apr-/2023", "2023-04-24T00:00:00"],
  ["24-Apr/-2023", "-002023-04-24T00:00:00"],
  ["24-/Apr-2023", "-002023-04-24T00:00:00"],
  ["24/-Apr-2023", "-002023-04-24T00:00:00"],

  ["24-Apr-()2023", "2023-04-24T00:00:00"],
  ["24-Apr()-2023", "-002023-04-24T00:00:00"],
  ["24-()Apr-2023", "-002023-04-24T00:00:00"],
  ["24()-Apr-2023", "-002023-04-24T00:00:00"],

  // mday being 3+ digits
  ["024-Apr-2023", "-002023-04-24T00:00:00"],
  ["0024-Apr-2023", "-002023-04-24T00:00:00"],
];

for (const [testString, isoString] of tests) {
  const testDate = new Date(testString);
  const isoDate = new Date(isoString);

  assertEq(testDate.getTime(), isoDate.getTime(),
           testString);
}

const invalidTests = [
  // mday being out of range.
  "32-01-32",

  // mday being 3+ digits, while year being 2-3 digits.
  "024-Apr-22",
  "024-Apr-023",

  // Duplicate date.
  "2012-Apr-08 12/12/12",
];

for (const testString of invalidTests) {
  assertEq(Number.isNaN(new Date(testString).getTime()), true, testString);
}

if (typeof reportCompare === "function")
    reportCompare(true, true);
