#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Kyn
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250909.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='kyn-game'
GAME_NAME='Kyn'

## This DRM-free installer is no longer available for sale from gog.com.
ARCHIVE_BASE_0_NAME='setup_kyn_update_4_(17655).exe'
ARCHIVE_BASE_0_MD5='ca2a665c27ef02f0bfa4e72dc368952c'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_kyn_update_4_(17655)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='8c6c13b15a4d39ac9389c7c4f9ce6760'
ARCHIVE_BASE_0_SIZE='7900000'
ARCHIVE_BASE_0_VERSION='1.0.4-gog17655'

ARCHIVE_BASE_RAR_0_NAME='setup_kyn_2.1.0.4.exe'
ARCHIVE_BASE_RAR_0_MD5='a40cb85cdd40b7464eec92b2b9166f84'
ARCHIVE_BASE_RAR_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_RAR_0_EXTRACTOR_OPTIONS='--gog'
ARCHIVE_BASE_RAR_0_PART1_NAME='setup_kyn_2.1.0.4-1.bin'
ARCHIVE_BASE_RAR_0_PART1_MD5='4cfdca351969f2570a3657c772fd492e'
ARCHIVE_BASE_RAR_0_PART1_EXTRACTOR='unar'
ARCHIVE_BASE_RAR_0_SIZE='7900000'
ARCHIVE_BASE_RAR_0_VERSION='1.0-gog2.1.0.4'

UNITY3D_NAME='kyn'

CONTENT_PATH_DEFAULT='app'
CONTENT_PATH_DEFAULT_RAR='game'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Tangrin Entertainment/Kyn'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
