(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require Reals.Rbasic_fun.
Require Reals.Rtrigo_def.
Require Reals.Rpower.
Require Reals.R_sqrt.
Require Reals.Rtrigo_def.
Require Reals.Rtrigo1.
Require Reals.Ratan.
Require BuiltIn.
Require HighOrd.
Require int.Int.
Require real.Real.
Require real.RealInfix.
Require real.Abs.
Require real.FromInt.
Require real.Square.
Require real.ExpLog.
Require real.Trigonometry.

Axiom usingle : Type.
Parameter usingle_WhyType : WhyType usingle.
Existing Instance usingle_WhyType.

(* Why3 assumption *)
Definition eps : Reals.Rdefinitions.R :=
  ((1 / 16777216)%R / (1%R + (1 / 16777216)%R)%R)%R.

(* Why3 assumption *)
Definition eta : Reals.Rdefinitions.R :=
  (1 / 1427247692705959881058285969449495136382746624)%R.

(* Why3 assumption *)
Inductive mode :=
  | RNE : mode
  | RNA : mode
  | RTP : mode
  | RTN : mode
  | RTZ : mode.
Axiom mode_WhyType : WhyType mode.
Existing Instance mode_WhyType.

(* Why3 assumption *)
Definition to_nearest (m:mode) : Prop := (m = RNE) \/ (m = RNA).

Parameter uround: mode -> Reals.Rdefinitions.R -> usingle.

Parameter to_real: usingle -> Reals.Rdefinitions.R.

Parameter of_int: Numbers.BinNums.Z -> usingle.

Axiom to_real_of_int :
  forall (x:Numbers.BinNums.Z), ((to_real (of_int x)) = (BuiltIn.IZR x)).

Axiom eps_bounds : (0%R < eps)%R /\ (eps < 1%R)%R.

Axiom eta_bounds : (0%R < eta)%R /\ (eta < 1%R)%R.

(* Why3 assumption *)
Definition uadd (x:usingle) (y:usingle) : usingle :=
  uround RNE ((to_real x) + (to_real y))%R.

Axiom uadd'spec'1 :
  forall (x:usingle) (y:usingle),
  ((Reals.Rbasic_fun.Rabs
    ((to_real (uadd x y)) - ((to_real x) + (to_real y))%R)%R)
   <= (Reals.Rbasic_fun.Rabs (to_real x)))%R.

Axiom uadd'spec'0 :
  forall (x:usingle) (y:usingle),
  ((Reals.Rbasic_fun.Rabs
    ((to_real (uadd x y)) - ((to_real x) + (to_real y))%R)%R)
   <= (Reals.Rbasic_fun.Rabs (to_real y)))%R.

Axiom uadd'spec :
  forall (x:usingle) (y:usingle),
  ((Reals.Rbasic_fun.Rabs
    ((to_real (uadd x y)) - ((to_real x) + (to_real y))%R)%R)
   <= ((Reals.Rbasic_fun.Rabs ((to_real x) + (to_real y))%R) * eps)%R)%R.

(* Why3 assumption *)
Definition usub (x:usingle) (y:usingle) : usingle :=
  uround RNE ((to_real x) - (to_real y))%R.

Axiom usub'spec'1 :
  forall (x:usingle) (y:usingle),
  ((Reals.Rbasic_fun.Rabs
    ((to_real (usub x y)) - ((to_real x) - (to_real y))%R)%R)
   <= (Reals.Rbasic_fun.Rabs (to_real x)))%R.

Axiom usub'spec'0 :
  forall (x:usingle) (y:usingle),
  ((Reals.Rbasic_fun.Rabs
    ((to_real (usub x y)) - ((to_real x) - (to_real y))%R)%R)
   <= (Reals.Rbasic_fun.Rabs (to_real y)))%R.

Axiom usub'spec :
  forall (x:usingle) (y:usingle),
  ((Reals.Rbasic_fun.Rabs
    ((to_real (usub x y)) - ((to_real x) - (to_real y))%R)%R)
   <= ((Reals.Rbasic_fun.Rabs ((to_real x) - (to_real y))%R) * eps)%R)%R.

(* Why3 assumption *)
Definition umul (x:usingle) (y:usingle) : usingle :=
  uround RNE ((to_real x) * (to_real y))%R.

Axiom umul'spec :
  forall (x:usingle) (y:usingle),
  ((Reals.Rbasic_fun.Rabs
    ((to_real (umul x y)) - ((to_real x) * (to_real y))%R)%R)
   <=
   (((Reals.Rbasic_fun.Rabs ((to_real x) * (to_real y))%R) * eps)%R + eta)%R)%R.

Parameter udiv: usingle -> usingle -> usingle.

Axiom udiv'def :
  forall (x:usingle) (y:usingle), ~ ((to_real y) = 0%R) ->
  ((udiv x y) = (uround RNE ((to_real x) / (to_real y))%R)).

Axiom udiv'spec :
  forall (x:usingle) (y:usingle), ~ ((to_real y) = 0%R) ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real (udiv x y)) - ((to_real x) / (to_real y))%R)%R)
   <=
   (((Reals.Rbasic_fun.Rabs ((to_real x) / (to_real y))%R) * eps)%R + eta)%R)%R.

(* Why3 assumption *)
Definition uminus (x:usingle) : usingle := uround RNE (-(to_real x))%R.

Axiom uminus'spec :
  forall (x:usingle), ((to_real (uminus x)) = (-(to_real x))%R).

Parameter is_exact:
  (usingle -> usingle -> usingle) -> usingle -> usingle -> Prop.

Parameter udiv_exact: usingle -> usingle -> usingle.

Axiom udiv_exact'def :
  forall (x:usingle) (y:usingle), ~ ((to_real y) = 0%R) ->
  is_exact (fun (y0:usingle) (y1:usingle) => udiv y0 y1) x y ->
  ((udiv_exact x y) = (uround RNE ((to_real x) / (to_real y))%R)).

Axiom udiv_exact'spec :
  forall (x:usingle) (y:usingle), ~ ((to_real y) = 0%R) ->
  is_exact (fun (y0:usingle) (y1:usingle) => udiv y0 y1) x y ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real (udiv_exact x y)) - ((to_real x) / (to_real y))%R)%R)
   <= eta)%R.

Parameter infix_slsldt: usingle -> usingle -> usingle.

Axiom infix_slsldt'def :
  forall (x:usingle) (y:usingle), ~ ((to_real y) = 0%R) ->
  ((infix_slsldt x y) = (udiv x y)).

Parameter infix_slslsldt: usingle -> usingle -> usingle.

Axiom infix_slslsldt'def :
  forall (x:usingle) (y:usingle), ~ ((to_real y) = 0%R) ->
  is_exact (fun (y0:usingle) (y1:usingle) => udiv y0 y1) x y ->
  ((infix_slslsldt x y) = (udiv_exact x y)).

Parameter u0: usingle.

Axiom to_real_u0 : ((to_real u0) = 0%R).

Parameter u1: usingle.

Axiom to_real_u1 : ((to_real u1) = 1%R).

Parameter u2: usingle.

Axiom to_real_u2 : ((to_real u2) = 2%R).

Parameter u4: usingle.

Axiom to_real_u4 : ((to_real u4) = 4%R).

Parameter u8: usingle.

Axiom to_real_u8 : ((to_real u8) = 8%R).

Parameter u16: usingle.

Axiom to_real_u16 : ((to_real u16) = 16%R).

Parameter u32: usingle.

Axiom to_real_u32 : ((to_real u32) = 32%R).

Parameter u64: usingle.

Axiom to_real_u64 : ((to_real u64) = 64%R).

Parameter u128: usingle.

Axiom to_real_u128 : ((to_real u128) = 128%R).

Parameter u256: usingle.

Axiom to_real_u256 : ((to_real u256) = 256%R).

Parameter u512: usingle.

Axiom to_real_u512 : ((to_real u512) = 512%R).

Parameter u1024: usingle.

Axiom to_real_u1024 : ((to_real u1024) = 1024%R).

Parameter u2048: usingle.

Axiom to_real_u2048 : ((to_real u2048) = 2048%R).

Parameter u4096: usingle.

Axiom to_real_u4096 : ((to_real u4096) = 4096%R).

Parameter u8192: usingle.

Axiom to_real_u8192 : ((to_real u8192) = 8192%R).

Parameter u16384: usingle.

Axiom to_real_u16384 : ((to_real u16384) = 16384%R).

Parameter u32768: usingle.

Axiom to_real_u32768 : ((to_real u32768) = 32768%R).

Parameter u65536: usingle.

Axiom to_real_u65536 : ((to_real u65536) = 65536%R).

(* Why3 assumption *)
Definition is_positive_power_of_2 (x:usingle) : Prop :=
  (x = u1) \/
  (x = u2) \/
  (x = u4) \/
  (x = u8) \/
  (x = u16) \/
  (x = u32) \/
  (x = u64) \/
  (x = u128) \/
  (x = u256) \/
  (x = u4096) \/ (x = u8192) \/ (x = u16384) \/ (x = u32768) \/ (x = u65536).

Axiom div_by_positive_power_of_2_is_exact :
  forall (x:usingle) (y:usingle), is_positive_power_of_2 y ->
  is_exact (fun (y0:usingle) (y1:usingle) => udiv y0 y1) x y.

Axiom uadd_single_error_propagation :
  forall (x_uf:usingle) (y_uf:usingle) (r:usingle) (x:Reals.Rdefinitions.R)
    (x':Reals.Rdefinitions.R) (x_rel_err:Reals.Rdefinitions.R)
    (x_cst_err:Reals.Rdefinitions.R) (y:Reals.Rdefinitions.R)
    (y':Reals.Rdefinitions.R) (y_rel_err:Reals.Rdefinitions.R)
    (y_cst_err:Reals.Rdefinitions.R),
  ((Reals.Rbasic_fun.Rabs ((to_real x_uf) - x)%R) <=
   ((x_rel_err * x')%R + x_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs ((to_real y_uf) - y)%R) <=
   ((y_rel_err * y')%R + y_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs x) <= x')%R ->
  ((Reals.Rbasic_fun.Rabs y) <= y')%R -> (0%R <= x_rel_err)%R ->
  (0%R <= y_rel_err)%R -> (0%R <= x_cst_err)%R -> (0%R <= y_cst_err)%R ->
  (r = (uadd x_uf y_uf)) ->
  ((Reals.Rbasic_fun.Rabs ((to_real r) - (x + y)%R)%R) <=
   ((((x_rel_err + y_rel_err)%R + eps)%R * (x' + y')%R)%R +
    ((((1%R + eps)%R + y_rel_err)%R * x_cst_err)%R +
     (((1%R + eps)%R + x_rel_err)%R * y_cst_err)%R)%R)%R)%R.

Axiom usub_single_error_propagation :
  forall (x_uf:usingle) (y_uf:usingle) (r:usingle) (x:Reals.Rdefinitions.R)
    (x':Reals.Rdefinitions.R) (x_rel_err:Reals.Rdefinitions.R)
    (x_cst_err:Reals.Rdefinitions.R) (y:Reals.Rdefinitions.R)
    (y':Reals.Rdefinitions.R) (y_rel_err:Reals.Rdefinitions.R)
    (y_cst_err:Reals.Rdefinitions.R),
  ((Reals.Rbasic_fun.Rabs ((to_real x_uf) - x)%R) <=
   ((x_rel_err * x')%R + x_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs ((to_real y_uf) - y)%R) <=
   ((y_rel_err * y')%R + y_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs x) <= x')%R ->
  ((Reals.Rbasic_fun.Rabs y) <= y')%R -> (0%R <= x_cst_err)%R ->
  (0%R <= y_cst_err)%R -> (0%R <= x_rel_err)%R -> (0%R <= y_rel_err)%R ->
  (r = (usub x_uf y_uf)) ->
  ((Reals.Rbasic_fun.Rabs ((to_real r) - (x - y)%R)%R) <=
   ((((x_rel_err + y_rel_err)%R + eps)%R * (x' + y')%R)%R +
    ((((1%R + eps)%R + y_rel_err)%R * x_cst_err)%R +
     (((1%R + eps)%R + x_rel_err)%R * y_cst_err)%R)%R)%R)%R.

Axiom log_1_minus_x :
  forall (x:Reals.Rdefinitions.R),
  (0%R <= (Reals.Rbasic_fun.Rabs x))%R /\ ((Reals.Rbasic_fun.Rabs x) < 1%R)%R ->
  ((Reals.Rpower.ln (1%R + x)%R) <= (-(Reals.Rpower.ln (1%R - x)%R))%R)%R.

Axiom log2_1_minus_x :
  forall (x:Reals.Rdefinitions.R),
  (0%R <= (Reals.Rbasic_fun.Rabs x))%R /\ ((Reals.Rbasic_fun.Rabs x) < 1%R)%R ->
  ((real.ExpLog.log2 (1%R + x)%R) <= (-(real.ExpLog.log2 (1%R - x)%R))%R)%R.

Axiom log10_1_minus_x :
  forall (x:Reals.Rdefinitions.R),
  (0%R <= (Reals.Rbasic_fun.Rabs x))%R /\ ((Reals.Rbasic_fun.Rabs x) < 1%R)%R ->
  ((real.ExpLog.log10 (1%R + x)%R) <= (-(real.ExpLog.log10 (1%R - x)%R))%R)%R.

Axiom sin_of_approx :
  forall (x:Reals.Rdefinitions.R) (y:Reals.Rdefinitions.R),
  ((Reals.Rbasic_fun.Rabs
    ((Reals.Rtrigo_def.sin x) - (Reals.Rtrigo_def.sin y))%R)
   <= (Reals.Rbasic_fun.Rabs (x - y)%R))%R.

Axiom cos_of_approx :
  forall (x:Reals.Rdefinitions.R) (y:Reals.Rdefinitions.R),
  ((Reals.Rbasic_fun.Rabs
    ((Reals.Rtrigo_def.cos x) - (Reals.Rtrigo_def.cos y))%R)
   <= (Reals.Rbasic_fun.Rabs (x - y)%R))%R.

Parameter sum:
  (Numbers.BinNums.Z -> Reals.Rdefinitions.R) -> Numbers.BinNums.Z ->
  Numbers.BinNums.Z -> Reals.Rdefinitions.R.

Axiom sum'def :
  forall (f:Numbers.BinNums.Z -> Reals.Rdefinitions.R) (a:Numbers.BinNums.Z)
    (b:Numbers.BinNums.Z),
  ((b <= a)%Z -> ((sum f a b) = 0%R)) /\
  (~ (b <= a)%Z ->
   ((sum f a b) = ((sum f a (b - 1%Z)%Z) + (f (b - 1%Z)%Z))%R)).

Axiom umul_single_error_propagation :
  forall (x_uf:usingle) (y_uf:usingle) (r:usingle) (x:Reals.Rdefinitions.R)
    (x':Reals.Rdefinitions.R) (x_rel_err:Reals.Rdefinitions.R)
    (x_cst_err:Reals.Rdefinitions.R) (y:Reals.Rdefinitions.R)
    (y':Reals.Rdefinitions.R) (y_rel_err:Reals.Rdefinitions.R)
    (y_cst_err:Reals.Rdefinitions.R),
  ((Reals.Rbasic_fun.Rabs ((to_real x_uf) - x)%R) <=
   ((x_rel_err * x')%R + x_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs ((to_real y_uf) - y)%R) <=
   ((y_rel_err * y')%R + y_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs x) <= x')%R ->
  ((Reals.Rbasic_fun.Rabs y) <= y')%R -> (0%R <= x_rel_err)%R ->
  (0%R <= y_rel_err)%R -> (0%R <= x_cst_err)%R -> (0%R <= y_cst_err)%R ->
  (r = (umul x_uf y_uf)) ->
  ((Reals.Rbasic_fun.Rabs ((to_real r) - (x * y)%R)%R) <=
   (((eps +
      (((x_rel_err + y_rel_err)%R + (x_rel_err * y_rel_err)%R)%R *
       (1%R + eps)%R)%R)%R
     * (x' * y')%R)%R
    +
    ((((((y_cst_err + (y_cst_err * x_rel_err)%R)%R * x')%R +
        ((x_cst_err + (x_cst_err * y_rel_err)%R)%R * y')%R)%R
       + (x_cst_err * y_cst_err)%R)%R
      * (1%R + eps)%R)%R
     + eta)%R)%R)%R.

Axiom log_single_error_propagation :
  forall (logx_uf:usingle) (x_uf:usingle) (exact_x:Reals.Rdefinitions.R)
    (x':Reals.Rdefinitions.R) (log_rel_err:Reals.Rdefinitions.R)
    (log_cst_err:Reals.Rdefinitions.R) (x_rel_err:Reals.Rdefinitions.R)
    (x_cst_err:Reals.Rdefinitions.R),
  ((Reals.Rbasic_fun.Rabs ((to_real x_uf) - exact_x)%R) <=
   ((x_rel_err * x')%R + x_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real logx_uf) - (Reals.Rpower.ln (to_real x_uf)))%R)
   <=
   ((log_rel_err *
     (Reals.Rbasic_fun.Rabs (Reals.Rpower.ln (to_real x_uf))))%R
    + log_cst_err)%R)%R ->
  (0%R < exact_x)%R /\ (exact_x <= x')%R ->
  (0%R < ((exact_x - (x_rel_err * x')%R)%R - x_cst_err)%R)%R ->
  (0%R <= log_rel_err)%R ->
  ((Reals.Rbasic_fun.Rabs ((to_real logx_uf) - (Reals.Rpower.ln exact_x))%R)
   <=
   ((log_rel_err * (Reals.Rbasic_fun.Rabs (Reals.Rpower.ln exact_x)))%R +
    (((-(Reals.Rpower.ln
         (1%R - (((x_rel_err * x')%R + x_cst_err)%R / exact_x)%R)%R))%R
      * (1%R + log_rel_err)%R)%R
     + log_cst_err)%R)%R)%R.

Axiom log2_single_error_propagation :
  forall (log2x_uf:usingle) (x_uf:usingle) (exact_x:Reals.Rdefinitions.R)
    (x':Reals.Rdefinitions.R) (log_rel_err:Reals.Rdefinitions.R)
    (log_cst_err:Reals.Rdefinitions.R) (x_rel_err:Reals.Rdefinitions.R)
    (x_cst_err:Reals.Rdefinitions.R),
  ((Reals.Rbasic_fun.Rabs ((to_real x_uf) - exact_x)%R) <=
   ((x_rel_err * x')%R + x_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real log2x_uf) - (real.ExpLog.log2 (to_real x_uf)))%R)
   <=
   ((log_rel_err *
     (Reals.Rbasic_fun.Rabs (real.ExpLog.log2 (to_real x_uf))))%R
    + log_cst_err)%R)%R ->
  (0%R < exact_x)%R /\ (exact_x <= x')%R ->
  (0%R < ((exact_x - (x_rel_err * x')%R)%R - x_cst_err)%R)%R ->
  (0%R <= log_rel_err)%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real log2x_uf) - (real.ExpLog.log2 exact_x))%R)
   <=
   ((log_rel_err * (Reals.Rbasic_fun.Rabs (real.ExpLog.log2 exact_x)))%R +
    (((-(real.ExpLog.log2
         (1%R - (((x_rel_err * x')%R + x_cst_err)%R / exact_x)%R)%R))%R
      * (1%R + log_rel_err)%R)%R
     + log_cst_err)%R)%R)%R.

Axiom log10_single_error_propagation :
  forall (log10x_uf:usingle) (x_uf:usingle) (exact_x:Reals.Rdefinitions.R)
    (x':Reals.Rdefinitions.R) (log_rel_err:Reals.Rdefinitions.R)
    (log_cst_err:Reals.Rdefinitions.R) (x_rel_err:Reals.Rdefinitions.R)
    (x_cst_err:Reals.Rdefinitions.R),
  ((Reals.Rbasic_fun.Rabs ((to_real x_uf) - exact_x)%R) <=
   ((x_rel_err * x')%R + x_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real log10x_uf) - (real.ExpLog.log10 (to_real x_uf)))%R)
   <=
   ((log_rel_err *
     (Reals.Rbasic_fun.Rabs (real.ExpLog.log10 (to_real x_uf))))%R
    + log_cst_err)%R)%R ->
  (0%R < exact_x)%R /\ (exact_x <= x')%R ->
  (0%R < ((exact_x - (x_rel_err * x')%R)%R - x_cst_err)%R)%R ->
  (0%R <= log_rel_err)%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real log10x_uf) - (real.ExpLog.log10 exact_x))%R)
   <=
   ((log_rel_err * (Reals.Rbasic_fun.Rabs (real.ExpLog.log10 exact_x)))%R +
    (((-(real.ExpLog.log10
         (1%R - (((x_rel_err * x')%R + x_cst_err)%R / exact_x)%R)%R))%R
      * (1%R + log_rel_err)%R)%R
     + log_cst_err)%R)%R)%R.

Axiom exp_single_error_propagation :
  forall (expx_uf:usingle) (x_uf:usingle) (exact_x:Reals.Rdefinitions.R)
    (x':Reals.Rdefinitions.R) (exp_rel_err:Reals.Rdefinitions.R)
    (exp_cst_err:Reals.Rdefinitions.R) (x_rel_err:Reals.Rdefinitions.R)
    (x_cst_err:Reals.Rdefinitions.R),
  ((Reals.Rbasic_fun.Rabs ((to_real x_uf) - exact_x)%R) <=
   ((x_rel_err * x')%R + x_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real expx_uf) - (Reals.Rtrigo_def.exp (to_real x_uf)))%R)
   <=
   ((exp_rel_err * (Reals.Rtrigo_def.exp (to_real x_uf)))%R + exp_cst_err)%R)%R ->
  (exact_x <= x')%R -> (0%R <= exp_rel_err)%R /\ (exp_rel_err <= 1%R)%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real expx_uf) - (Reals.Rtrigo_def.exp exact_x))%R)
   <=
   (((exp_rel_err +
      (((Reals.Rtrigo_def.exp ((x_rel_err * x')%R + x_cst_err)%R) - 1%R)%R *
       (1%R + exp_rel_err)%R)%R)%R
     * (Reals.Rtrigo_def.exp exact_x))%R
    + exp_cst_err)%R)%R.

Axiom sin_single_error_propagation :
  forall (sinx_uf:usingle) (x_uf:usingle) (exact_x:Reals.Rdefinitions.R)
    (x':Reals.Rdefinitions.R) (sin_rel_err:Reals.Rdefinitions.R)
    (sin_cst_err:Reals.Rdefinitions.R) (x_rel_err:Reals.Rdefinitions.R)
    (x_cst_err:Reals.Rdefinitions.R),
  ((Reals.Rbasic_fun.Rabs ((to_real x_uf) - exact_x)%R) <=
   ((x_rel_err * x')%R + x_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real sinx_uf) - (Reals.Rtrigo_def.sin (to_real x_uf)))%R)
   <=
   ((sin_rel_err *
     (Reals.Rbasic_fun.Rabs (Reals.Rtrigo_def.sin (to_real x_uf))))%R
    + sin_cst_err)%R)%R ->
  (exact_x <= x')%R -> (0%R <= sin_rel_err)%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real sinx_uf) - (Reals.Rtrigo_def.sin exact_x))%R)
   <=
   ((sin_rel_err * (Reals.Rbasic_fun.Rabs (Reals.Rtrigo_def.sin exact_x)))%R
    +
    ((((x_rel_err * x')%R + x_cst_err)%R * (1%R + sin_rel_err)%R)%R +
     sin_cst_err)%R)%R)%R.

Axiom cos_single_error_propagation :
  forall (cosx_uf:usingle) (x_uf:usingle) (exact_x:Reals.Rdefinitions.R)
    (x':Reals.Rdefinitions.R) (cos_rel_err:Reals.Rdefinitions.R)
    (cos_cst_err:Reals.Rdefinitions.R) (x_rel_err:Reals.Rdefinitions.R)
    (x_cst_err:Reals.Rdefinitions.R),
  ((Reals.Rbasic_fun.Rabs ((to_real x_uf) - exact_x)%R) <=
   ((x_rel_err * x')%R + x_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real cosx_uf) - (Reals.Rtrigo_def.cos (to_real x_uf)))%R)
   <=
   ((cos_rel_err *
     (Reals.Rbasic_fun.Rabs (Reals.Rtrigo_def.cos (to_real x_uf))))%R
    + cos_cst_err)%R)%R ->
  (exact_x <= x')%R -> (0%R <= cos_rel_err)%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real cosx_uf) - (Reals.Rtrigo_def.cos exact_x))%R)
   <=
   ((cos_rel_err * (Reals.Rbasic_fun.Rabs (Reals.Rtrigo_def.cos exact_x)))%R
    +
    ((((x_rel_err * x')%R + x_cst_err)%R * (1%R + cos_rel_err)%R)%R +
     cos_cst_err)%R)%R)%R.

(* Why3 assumption *)
Definition real_fun (f:Numbers.BinNums.Z -> usingle) :
    Numbers.BinNums.Z -> Reals.Rdefinitions.R :=
  fun (i:Numbers.BinNums.Z) => to_real (f i).

Axiom sum_single_error_propagation :
  forall (x:usingle) (f:Numbers.BinNums.Z -> usingle)
    (exact_f:Numbers.BinNums.Z -> Reals.Rdefinitions.R)
    (f':Numbers.BinNums.Z -> Reals.Rdefinitions.R)
    (f'':Numbers.BinNums.Z -> Reals.Rdefinitions.R) (n:Numbers.BinNums.Z)
    (sum_rel_err:Reals.Rdefinitions.R) (sum_cst_err:Reals.Rdefinitions.R)
    (f_rel_err:Reals.Rdefinitions.R) (f_cst_err:Reals.Rdefinitions.R),
  (forall (i:Numbers.BinNums.Z), (0%Z <= i)%Z /\ (i < n)%Z ->
   ((Reals.Rbasic_fun.Rabs ((real_fun f i) - (exact_f i))%R) <=
    ((f_rel_err * (f' i))%R + f_cst_err)%R)%R) ->
  (forall (i:Numbers.BinNums.Z), (0%Z <= i)%Z /\ (i < n)%Z ->
   ((((f' i) - (f_rel_err * (f' i))%R)%R - f_cst_err)%R <= (f'' i))%R /\
   ((f'' i) <= (((f' i) + (f_rel_err * (f' i))%R)%R + f_cst_err)%R)%R) ->
  ((Reals.Rbasic_fun.Rabs ((to_real x) - (sum (real_fun f) 0%Z n))%R) <=
   ((sum_rel_err * (sum f'' 0%Z n))%R + sum_cst_err)%R)%R ->
  (0%R <= sum_rel_err)%R -> (0%Z <= n)%Z ->
  ((Reals.Rbasic_fun.Rabs ((to_real x) - (sum exact_f 0%Z n))%R) <=
   (((f_rel_err + (sum_rel_err * (1%R + f_rel_err)%R)%R)%R *
     (sum f' 0%Z n))%R
    +
    (((f_cst_err * (BuiltIn.IZR n))%R * (1%R + sum_rel_err)%R)%R +
     sum_cst_err)%R)%R)%R.

Axiom udiv_exact_single_error_propagation :
  forall (x_uf:usingle) (y_uf:usingle) (r:usingle) (x:Reals.Rdefinitions.R)
    (x':Reals.Rdefinitions.R) (x_rel_err:Reals.Rdefinitions.R)
    (x_cst_err:Reals.Rdefinitions.R),
  ((Reals.Rbasic_fun.Rabs ((to_real x_uf) - x)%R) <=
   ((x_rel_err * x')%R + x_cst_err)%R)%R ->
  ((Reals.Rbasic_fun.Rabs x) <= x')%R -> (0%R <= x_rel_err)%R ->
  (0%R <= x_cst_err)%R -> (r = (infix_slslsldt x_uf y_uf)) ->
  ((Reals.Rbasic_fun.Rabs ((to_real r) - (x / (to_real y_uf))%R)%R) <=
   ((x_rel_err * (x' / (to_real y_uf))%R)%R +
    ((x_cst_err / (to_real y_uf))%R + eta)%R)%R)%R.

(* Why3 assumption *)
Definition abs_fun (f:Numbers.BinNums.Z -> Reals.Rdefinitions.R) :
    Numbers.BinNums.Z -> Reals.Rdefinitions.R :=
  fun (i:Numbers.BinNums.Z) => Reals.Rbasic_fun.Rabs (f i).

(* Why3 assumption *)
Definition abs_real_fun (f:Numbers.BinNums.Z -> usingle) :
    Numbers.BinNums.Z -> Reals.Rdefinitions.R :=
  fun (i:Numbers.BinNums.Z) => abs_fun (real_fun f) i.

Axiom sum_of_fun_le_sum_of_abs_fun :
  forall (f:Numbers.BinNums.Z -> usingle) (a:Numbers.BinNums.Z)
    (b:Numbers.BinNums.Z),
  (0%Z <= (b - a)%Z)%Z ->
  ((Reals.Rbasic_fun.Rabs (sum (real_fun f) a b)) <=
   (sum (abs_real_fun f) a b))%R.

Parameter usum_rec:
  (Numbers.BinNums.Z -> usingle) -> Numbers.BinNums.Z -> Numbers.BinNums.Z ->
  usingle.

Axiom usum_rec'def :
  forall (f:Numbers.BinNums.Z -> usingle) (a:Numbers.BinNums.Z)
    (b:Numbers.BinNums.Z),
  (0%Z <= (b - a)%Z)%Z ->
  (((b - a)%Z = 0%Z) -> ((usum_rec f a b) = u0)) /\
  (~ ((b - a)%Z = 0%Z) ->
   (((b - a)%Z = 1%Z) -> ((usum_rec f a b) = (f (b - 1%Z)%Z))) /\
   (~ ((b - a)%Z = 1%Z) ->
    ((usum_rec f a b) = (uadd (usum_rec f a (b - 1%Z)%Z) (f (b - 1%Z)%Z))))).

Axiom usum_rec'spec :
  forall (f:Numbers.BinNums.Z -> usingle) (a:Numbers.BinNums.Z)
    (b:Numbers.BinNums.Z),
  (0%Z <= (b - a)%Z)%Z ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real (usum_rec f a b)) - (sum (real_fun f) a b))%R)
   <= ((sum (abs_real_fun f) a b) * (eps * (BuiltIn.IZR (b - a)%Z))%R)%R)%R.

Parameter log_error: Reals.Rdefinitions.R.

Axiom log_error_bounds : (0%R <= log_error)%R /\ (log_error <= 1%R)%R.

Parameter log_approx: usingle -> usingle.

Axiom log_approx'spec :
  forall (x:usingle), (0%R < (to_real x))%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real (log_approx x)) - (Reals.Rpower.ln (to_real x)))%R)
   <=
   ((Reals.Rbasic_fun.Rabs (Reals.Rpower.ln (to_real x))) * log_error)%R)%R.

Parameter log2_error: Reals.Rdefinitions.R.

Axiom log2_error_bounds : (0%R <= log2_error)%R /\ (log2_error <= 1%R)%R.

Parameter log2_approx: usingle -> usingle.

Axiom log2_approx'spec :
  forall (x:usingle), (0%R < (to_real x))%R ->
  ((Reals.Rbasic_fun.Rabs
    ((to_real (log2_approx x)) - (real.ExpLog.log2 (to_real x)))%R)
   <=
   ((Reals.Rbasic_fun.Rabs (real.ExpLog.log2 (to_real x))) * log2_error)%R)%R.

Parameter exp_error: Reals.Rdefinitions.R.

Axiom exp_error_bounds : (0%R <= exp_error)%R /\ (exp_error <= (1 / 8)%R)%R.

Parameter exp_approx: usingle -> usingle.

Axiom exp_approx'spec :
  forall (x:usingle),
  ((Reals.Rbasic_fun.Rabs
    ((to_real (exp_approx x)) - (Reals.Rtrigo_def.exp (to_real x)))%R)
   <= (exp_error * (Reals.Rtrigo_def.exp (to_real x)))%R)%R.

Axiom exp_approx_pos :
  forall (x:usingle), (0%R < (to_real (exp_approx x)))%R.

(* Why3 goal *)
Theorem lt_compat_order_mult_l :
  forall (x:Reals.Rdefinitions.R) (y:Reals.Rdefinitions.R)
    (z:Reals.Rdefinitions.R),
  (0%R < z)%R -> (x < y)%R -> ((z * x)%R < (z * y)%R)%R.
Proof.
intros x y z h1 h2.
apply Rmult_lt_compat_l.
auto.
auto.
Qed.

