# Ecosystem

```{tags} audience:all
```

Tango Controls offers a rich ecosystem for developers and users alike.

Since Tango is a also a developer's framework there are many libraries and tools for existing devices and clients. Refer to the [overview for developers](#developers-overview) for more information.

Tango is designed to run small and large systems. To support managing large installations a number of administration tools are provided.

% New link to find?
% The [overview for administrators](#administrators-overview) is a good starting point.

All control systems need to be able to archive data so that one can look at past data when needed. Tango comes with a number of archiving solutions and the [archiving overview](#archiving-overview) is our starting point for them.

In addition to the Python, C++ and Java APIs for Tango, a number of other languages and tools can be used together with Tango. Please have a look at our [bindings overview](#bindings-overview) where we list the currently known ones.

Here is the official list of the active Tango Ecosystem software:

| Software                  | Maintainer / Institute            | Description                                                  |
| ------------------------- | --------------------------------- | ------------------------------------------------------------ |
| Taranta                   | Yimeng Li / MAX IV Laboratory     | Web Front End to Tango with no-code Dashboard, synoptic, ... |
|                           | Matteo Canzari / INAF             |                                                              |
| Pogo                      | Damien Lacoste / ESRF             | Code generator for tango device server, to help get started  |
|                           |                                   | when writing device servers                                  |
| TangoDatabase             | Thomas Braun / byte physics       | The database server using MariaDB/MySQL                      |
|                           | Graziano Scalamera / Elettra      |                                                              |
| TangoTest                 | Thomas Braun / byte physics       | Famous device server for testing                             |
| cppTango                  | Reynald Bourtembourg / ESRF       | C++ implementation of Tango                                  |
|                           | Damien Lacoste / ESRF             |                                                              |
|                           | Thomas Juerges / SKAO             |                                                              |
|                           | Thomas Braun / byte physics       |                                                              |
|                           | Thomas Ives / OSL                 |                                                              |
| PyTango                   | Anton Joubert / MAX IV Laboratory | Python binding for Tango                                     |
|                           | Yury Matveyev / DESY              |                                                              |
| ITango                    | Benjamin Bertrand / MAX IV Laboratory | IPython extension for PyTango                            |
| dsconfig                  | Johan Forsberg / MAX IV Laboratory | Tango configuration management tools                        |
|                           | Benjamin Bertrand / MAX IV Laboratory |                                                          |
| tango-admin               | Thomas Braun / byte physics       | Commandline tool for various tango admin tasks               |
|                           | Thomas Juerges / SKAO             |                                                              |
| TangoSourceDistribution   | Thomas Braun / byte physics       | Integrated package of various tango tools                    |
| ATK                       | Jean-Luc Pons / ESRF              | Java Application Toolkit                                     |
| Jive                      | Jean-Luc Pons / ESRF              | Tango Database Browser GUI                                   |
| Starter                   | Nicolas Tappret / ESRF            | device server to start/stop Tango device servers             |
| Astor                     | Nicolas Tappret / ESRF            | Graphical Tango control system administration tool           |
| ATKPanel                  | Jean-Luc Pons / ESRF              | Generic Java GUI to interact with a Tango device             |
|                           | Nicolas Tappret / ESRF            |                                                              |
| jdraw                     | Jean-Luc Pons / ESRF              | Synoptic drawing tool (part of ATK project)                  |
| Tango Access Control      | Nicolas Tappret / ESRF            | Access control device server for Tango                       |
| C Language binding        | Jens Meyer / ESRF                 | Tango C binding                                              |
| Taurus                    | Oriol Vallcorba / ALBA            | Python Qt GUI framework based on PyTango for device          |
|                           | Benjamin Bertrand / MAX IV Laboratory | monitoring and control                                   |
|                           | Arturo Hoffstadt / ESO            |                                                              |
| Sardana                   | Oriol Vallcorba / ALBA            | Experiment control toolkit based on PyTango and Taurus for   |
|                           | Johan Forsberg / MAX IV Laboratory | device orchestration and data acquisition                   |
|                           | Teresa Nuñez / DESY               |                                                              |
|                           | Michal Piekarski / SOLARIS        |                                                              |
| fandango                  | Sergi Rubio Manrique / ALBA       | Python Device Servers and CLI utilities library              |
| panic                     | Sergi Rubio Manrique / ALBA       | Alarm System based on PyTango (Device Server and Qt GUI)     |
| HDB++                     | Damien Lacoste / ESRF             | High Performance Archiving System for Tango                  |
|                           | Reynald Bourtembourg / ESRF       |                                                              |
|                           | Graziano Scalamera / Elettra      |                                                              |
|                           | Sergi Rubio Manrique / ALBA       |                                                              |
|                           | Johan Forsberg / MAX IV Laboratory |                                                             |
| pyhdbpp                   | Sergi Rubio Manrique / ALBA       | python client for hdb++ (backend agnostic)                   |
|                           | Jose Ramos / ALBA                 |                                                              |
|                           | Damien Lacoste / ESRF             |                                                              |
