/* Copyright (C) 2019 Open Information Security Foundation
*
* You can copy, redistribute or modify this Program under the terms of
* the GNU General Public License version 2 as published by the Free
* Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* version 2 along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
* 02110-1301, USA.
*/

#ifndef __RUST_BINDINGS_GEN_H_
#define __RUST_BINDINGS_GEN_H_

/* Generated with cbindgen:0.26.0 */

/* DO NOT EDIT This file is autogenerated by cbindgen. Don't modify this manually. */

#include "stdint.h"
#include "stdbool.h"

#define STREAM_START 1

#define STREAM_EOF 2

#define STREAM_TOSERVER 4

#define STREAM_TOCLIENT 8

#define STREAM_GAP 16

#define STREAM_DEPTH 32

#define STREAM_MIDSTREAM 64

#define DETECT_BYTE_EXTRACT_FLAG_RELATIVE 1

#define DETECT_BYTE_EXTRACT_FLAG_STRING 2

#define DETECT_BYTE_EXTRACT_FLAG_ALIGN 4

#define DETECT_BYTE_EXTRACT_FLAG_ENDIAN 8

#define DETECT_BYTE_EXTRACT_FLAG_SLICE 16

#define DETECT_BYTE_EXTRACT_FLAG_MULTIPLIER 32

#define DETECT_BYTE_EXTRACT_FLAG_NBYTES 64

#define DETECT_BYTE_EXTRACT_FLAG_OFFSET 128

#define DETECT_BYTE_EXTRACT_FLAG_BASE 256

#define DETECT_BYTE_EXTRACT_MULTIPLIER_DEFAULT 1

#define DETECT_BYTEMATH_FLAG_RELATIVE 1

#define DETECT_BYTEMATH_FLAG_STRING 2

#define DETECT_BYTEMATH_FLAG_BITMASK 4

#define DETECT_BYTEMATH_FLAG_ENDIAN 8

#define DETECT_BYTEMATH_FLAG_RVALUE_VAR 16

#define DETECT_BYTEMATH_FLAG_NBYTES_VAR 32

#define DETECT_BYTEMATH_FIXED_PARAM_COUNT 5

#define DETECT_BYTEMATH_MAX_PARAM_COUNT 10

#define DETECT_ENTROPY_FLAG_BYTES 1

#define DETECT_ENTROPY_FLAG_OFFSET 2

#define DETECT_ENTROPY_FLAG_VALUE 4

#define DETECT_VLAN_ID_ANY INT8_MIN

#define DETECT_VLAN_ID_ALL INT8_MAX

#define JA4_HEX_LEN 36

#define SSL_VERSION_MAX_STRLEN 20

#define TLS_VERSION_UNKNOWN 0

#define SSL_VERSION_2 512

#define SSL_VERSION_3 768

#define TLS_VERSION_10 769

#define TLS_VERSION_11 770

#define TLS_VERSION_12 771

#define TLS_VERSION_13 772

#define TLS_VERSION_13_DRAFT28 32540

#define TLS_VERSION_13_DRAFT27 32539

#define TLS_VERSION_13_DRAFT26 32538

#define TLS_VERSION_13_DRAFT25 32537

#define TLS_VERSION_13_DRAFT24 32536

#define TLS_VERSION_13_DRAFT23 32535

#define TLS_VERSION_13_DRAFT22 32534

#define TLS_VERSION_13_DRAFT21 32533

#define TLS_VERSION_13_DRAFT20 32532

#define TLS_VERSION_13_DRAFT19 32531

#define TLS_VERSION_13_DRAFT18 32530

#define TLS_VERSION_13_DRAFT17 32529

#define TLS_VERSION_13_DRAFT16 32528

#define TLS_VERSION_13_PRE_DRAFT16 32513

#define TLS_VERSION_13_DRAFT20_FB 64276

#define TLS_VERSION_13_DRAFT21_FB 64277

#define TLS_VERSION_13_DRAFT22_FB 64278

#define TLS_VERSION_13_DRAFT23_FB 64279

#define TLS_VERSION_13_DRAFT26_FB 64282

#define DNS_LOG_VERSION_1 1

#define DNS_LOG_VERSION_2 2

#define DNS_LOG_VERSION_3 3

#define DNS_LOG_VERSION_DEFAULT DNS_LOG_VERSION_3

#define NFS_MIN_FRAME_LEN 32

#define RPC_TCP_PRE_CREDS 28

#define RPC_UDP_PRE_CREDS 24

#define RPC_MAX_MACHINE_SIZE 256

#define RPC_MAX_CREDS_SIZE 4096

#define RPC_MAX_VERIFIER_SIZE 4096

#define NFSPROC3_NULL 0

#define NFSPROC3_GETATTR 1

#define NFSPROC3_SETATTR 2

#define NFSPROC3_LOOKUP 3

#define NFSPROC3_ACCESS 4

#define NFSPROC3_READLINK 5

#define NFSPROC3_READ 6

#define NFSPROC3_WRITE 7

#define NFSPROC3_CREATE 8

#define NFSPROC3_MKDIR 9

#define NFSPROC3_SYMLINK 10

#define NFSPROC3_MKNOD 11

#define NFSPROC3_REMOVE 12

#define NFSPROC3_RMDIR 13

#define NFSPROC3_RENAME 14

#define NFSPROC3_LINK 15

#define NFSPROC3_READDIR 16

#define NFSPROC3_READDIRPLUS 17

#define NFSPROC3_FSSTAT 18

#define NFSPROC3_FSINFO 19

#define NFSPROC3_PATHCONF 20

#define NFSPROC3_COMMIT 21

#define NFS3_OK 0

#define NFS3ERR_PERM 1

#define NFS3ERR_NOENT 2

#define NFS3ERR_IO 5

#define NFS3ERR_NXIO 6

#define NFS3ERR_ACCES 13

#define NFS3ERR_EXIST 17

#define NFS3ERR_XDEV 18

#define NFS3ERR_NODEV 19

#define NFS3ERR_NOTDIR 20

#define NFS3ERR_ISDIR 21

#define NFS3ERR_INVAL 22

#define NFS3ERR_FBIG 27

#define NFS3ERR_NOSPC 28

#define NFS3ERR_ROFS 30

#define NFS3ERR_MLINK 31

#define NFS3ERR_NAMETOOLONG 63

#define NFS3ERR_NOTEMPTY 66

#define NFS3ERR_DQUOT 69

#define NFS3ERR_STALE 70

#define NFS3ERR_REMOTE 71

#define NFS3ERR_BADHANDLE 10001

#define NFS3ERR_NOT_SYNC 10002

#define NFS3ERR_BAD_COOKIE 10003

#define NFS3ERR_NOTSUPP 10004

#define NFS3ERR_TOOSMALL 10005

#define NFS3ERR_SERVERFAULT 10006

#define NFS3ERR_BADTYPE 10007

#define NFS3ERR_JUKEBOX 10008

#define RPCMSG_ACCEPTED 0

#define RPCMSG_DENIED 1

#define RPCAUTH_NULL 0

#define RPCAUTH_UNIX 1

#define RPCAUTH_SHORT 2

#define RPCAUTH_DH 3

#define RPCAUTH_KERB 4

#define RPCAUTH_RSA 5

#define RPCAUTH_GSS 6

#define NFSPROC4_NULL 0

#define NFSPROC4_COMPOUND 1

#define NFSPROC4_ACCESS 3

#define NFSPROC4_CLOSE 4

#define NFSPROC4_COMMIT 5

#define NFSPROC4_CREATE 6

#define NFSPROC4_DELEGPURGE 7

#define NFSPROC4_DELEGRETURN 8

#define NFSPROC4_GETATTR 9

#define NFSPROC4_GETFH 10

#define NFSPROC4_LINK 11

#define NFSPROC4_LOCK 12

#define NFSPROC4_LOCKT 13

#define NFSPROC4_LOCKU 14

#define NFSPROC4_LOOKUP 15

#define NFSPROC4_LOOKUPP 16

#define NFSPROC4_NVERIFY 17

#define NFSPROC4_OPEN 18

#define NFSPROC4_OPENATTR 19

#define NFSPROC4_OPEN_CONFIRM 20

#define NFSPROC4_OPEN_DOWNGRADE 21

#define NFSPROC4_PUTFH 22

#define NFSPROC4_PUTPUBFH 23

#define NFSPROC4_PUTROOTFH 24

#define NFSPROC4_READ 25

#define NFSPROC4_READDIR 26

#define NFSPROC4_READLINK 27

#define NFSPROC4_REMOVE 28

#define NFSPROC4_RENAME 29

#define NFSPROC4_RENEW 30

#define NFSPROC4_RESTOREFH 31

#define NFSPROC4_SAVEFH 32

#define NFSPROC4_SECINFO 33

#define NFSPROC4_SETATTR 34

#define NFSPROC4_SETCLIENTID 35

#define NFSPROC4_SETCLIENTID_CONFIRM 36

#define NFSPROC4_VERIFY 37

#define NFSPROC4_WRITE 38

#define NFSPROC4_RELEASE_LOCKOWNER 39

#define NFSPROC4_EXCHANGE_ID 42

#define NFSPROC4_CREATE_SESSION 43

#define NFSPROC4_DESTROY_SESSION 44

#define NFSPROC4_GETDEVINFO 47

#define NFSPROC4_LAYOUTGET 50

#define NFSPROC4_LAYOUTRETURN 51

#define NFSPROC4_SECINFO_NO_NAME 52

#define NFSPROC4_SEQUENCE 53

#define NFSPROC4_DESTROY_CLIENTID 57

#define NFSPROC4_RECLAIM_COMPLETE 58

#define NFSPROC4_ILLEGAL 10044

#define NFS4_OK 0

#define SMB_NTSTATUS_SUCCESS 0

#define SMB_NTSTATUS_WAIT_1 1

#define SMB_NTSTATUS_WAIT_2 2

#define SMB_NTSTATUS_WAIT_3 3

#define SMB_NTSTATUS_WAIT_63 63

#define SMB_NTSTATUS_ABANDONED 128

#define SMB_NTSTATUS_ABANDONED_WAIT_63 191

#define SMB_NTSTATUS_USER_APC 192

#define SMB_NTSTATUS_ALERTED 257

#define SMB_NTSTATUS_TIMEOUT 258

#define SMB_NTSTATUS_PENDING 259

#define SMB_NTSTATUS_REPARSE 260

#define SMB_NTSTATUS_MORE_ENTRIES 261

#define SMB_NTSTATUS_NOT_ALL_ASSIGNED 262

#define SMB_NTSTATUS_SOME_NOT_MAPPED 263

#define SMB_NTSTATUS_OPLOCK_BREAK_IN_PROGRESS 264

#define SMB_NTSTATUS_VOLUME_MOUNTED 265

#define SMB_NTSTATUS_RXACT_COMMITTED 266

#define SMB_NTSTATUS_NOTIFY_CLEANUP 267

#define SMB_NTSTATUS_NOTIFY_ENUM_DIR 268

#define SMB_NTSTATUS_NO_QUOTAS_FOR_ACCOUNT 269

#define SMB_NTSTATUS_PRIMARY_TRANSPORT_CONNECT_FAILED 270

#define SMB_NTSTATUS_PAGE_FAULT_TRANSITION 272

#define SMB_NTSTATUS_PAGE_FAULT_DEMAND_ZERO 273

#define SMB_NTSTATUS_PAGE_FAULT_COPY_ON_WRITE 274

#define SMB_NTSTATUS_PAGE_FAULT_GUARD_PAGE 275

#define SMB_NTSTATUS_PAGE_FAULT_PAGING_FILE 276

#define SMB_NTSTATUS_CACHE_PAGE_LOCKED 277

#define SMB_NTSTATUS_CRASH_DUMP 278

#define SMB_NTSTATUS_BUFFER_ALL_ZEROS 279

#define SMB_NTSTATUS_REPARSE_OBJECT 280

#define SMB_NTSTATUS_RESOURCE_REQUIREMENTS_CHANGED 281

#define SMB_NTSTATUS_TRANSLATION_COMPLETE 288

#define SMB_NTSTATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY 289

#define SMB_NTSTATUS_NOTHING_TO_TERMINATE 290

#define SMB_NTSTATUS_PROCESS_NOT_IN_JOB 291

#define SMB_NTSTATUS_PROCESS_IN_JOB 292

#define SMB_NTSTATUS_VOLSNAP_HIBERNATE_READY 293

#define SMB_NTSTATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY 294

#define SMB_NTSTATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED 295

#define SMB_NTSTATUS_INTERRUPT_STILL_CONNECTED 296

#define SMB_NTSTATUS_PROCESS_CLONED 297

#define SMB_NTSTATUS_FILE_LOCKED_WITH_ONLY_READERS 298

#define SMB_NTSTATUS_FILE_LOCKED_WITH_WRITERS 299

#define SMB_NTSTATUS_RESOURCEMANAGER_READ_ONLY 514

#define SMB_NTSTATUS_WAIT_FOR_OPLOCK 871

#define SMB_NTDBG_EXCEPTION_HANDLED 65537

#define SMB_NTDBG_CONTINUE 65538

#define SMB_NTSTATUS_FLT_IO_COMPLETE 1835009

#define SMB_NTSTATUS_FILE_NOT_AVAILABLE 3221226599

#define SMB_NTSTATUS_SHARE_UNAVAILABLE 3221226624

#define SMB_NTSTATUS_CALLBACK_RETURNED_THREAD_AFFINITY 3221227297

#define SMB_NTSTATUS_OBJECT_NAME_EXISTS 1073741824

#define SMB_NTSTATUS_THREAD_WAS_SUSPENDED 1073741825

#define SMB_NTSTATUS_WORKING_SET_LIMIT_RANGE 1073741826

#define SMB_NTSTATUS_IMAGE_NOT_AT_BASE 1073741827

#define SMB_NTSTATUS_RXACT_STATE_CREATED 1073741828

#define SMB_NTSTATUS_SEGMENT_NOTIFICATION 1073741829

#define SMB_NTSTATUS_LOCAL_USER_SESSION_KEY 1073741830

#define SMB_NTSTATUS_BAD_CURRENT_DIRECTORY 1073741831

#define SMB_NTSTATUS_SERIAL_MORE_WRITES 1073741832

#define SMB_NTSTATUS_REGISTRY_RECOVERED 1073741833

#define SMB_NTSTATUS_FT_READ_RECOVERY_FROM_BACKUP 1073741834

#define SMB_NTSTATUS_FT_WRITE_RECOVERY 1073741835

#define SMB_NTSTATUS_SERIAL_COUNTER_TIMEOUT 1073741836

#define SMB_NTSTATUS_NULL_LM_PASSWORD 1073741837

#define SMB_NTSTATUS_IMAGE_MACHINE_TYPE_MISMATCH 1073741838

#define SMB_NTSTATUS_RECEIVE_PARTIAL 1073741839

#define SMB_NTSTATUS_RECEIVE_EXPEDITED 1073741840

#define SMB_NTSTATUS_RECEIVE_PARTIAL_EXPEDITED 1073741841

#define SMB_NTSTATUS_EVENT_DONE 1073741842

#define SMB_NTSTATUS_EVENT_PENDING 1073741843

#define SMB_NTSTATUS_CHECKING_FILE_SYSTEM 1073741844

#define SMB_NTSTATUS_FATAL_APP_EXIT 1073741845

#define SMB_NTSTATUS_PREDEFINED_HANDLE 1073741846

#define SMB_NTSTATUS_WAS_UNLOCKED 1073741847

#define SMB_NTSTATUS_SERVICE_NOTIFICATION 1073741848

#define SMB_NTSTATUS_WAS_LOCKED 1073741849

#define SMB_NTSTATUS_LOG_HARD_ERROR 1073741850

#define SMB_NTSTATUS_ALREADY_WIN32 1073741851

#define SMB_NTSTATUS_WX86_UNSIMULATE 1073741852

#define SMB_NTSTATUS_WX86_CONTINUE 1073741853

#define SMB_NTSTATUS_WX86_SINGLE_STEP 1073741854

#define SMB_NTSTATUS_WX86_BREAKPOINT 1073741855

#define SMB_NTSTATUS_WX86_EXCEPTION_CONTINUE 1073741856

#define SMB_NTSTATUS_WX86_EXCEPTION_LASTCHANCE 1073741857

#define SMB_NTSTATUS_WX86_EXCEPTION_CHAIN 1073741858

#define SMB_NTSTATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE 1073741859

#define SMB_NTSTATUS_NO_YIELD_PERFORMED 1073741860

#define SMB_NTSTATUS_TIMER_RESUME_IGNORED 1073741861

#define SMB_NTSTATUS_ARBITRATION_UNHANDLED 1073741862

#define SMB_NTSTATUS_CARDBUS_NOT_SUPPORTED 1073741863

#define SMB_NTSTATUS_WX86_CREATEWX86TIB 1073741864

#define SMB_NTSTATUS_MP_PROCESSOR_MISMATCH 1073741865

#define SMB_NTSTATUS_HIBERNATED 1073741866

#define SMB_NTSTATUS_RESUME_HIBERNATION 1073741867

#define SMB_NTSTATUS_FIRMWARE_UPDATED 1073741868

#define SMB_NTSTATUS_DRIVERS_LEAKING_LOCKED_PAGES 1073741869

#define SMB_NTSTATUS_MESSAGE_RETRIEVED 1073741870

#define SMB_NTSTATUS_SYSTEM_POWERSTATE_TRANSITION 1073741871

#define SMB_NTSTATUS_ALPC_CHECK_COMPLETION_LIST 1073741872

#define SMB_NTSTATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION 1073741873

#define SMB_NTSTATUS_ACCESS_AUDIT_BY_POLICY 1073741874

#define SMB_NTSTATUS_ABANDON_HIBERFILE 1073741875

#define SMB_NTSTATUS_BIZRULES_NOT_ENABLED 1073741876

#define SMB_NTSTATUS_WAKE_SYSTEM 1073742484

#define SMB_NTSTATUS_DS_SHUTTING_DOWN 1073742704

#define SMB_NTDBG_REPLY_LATER 1073807361

#define SMB_NTDBG_UNABLE_TO_PROVIDE_HANDLE 1073807362

#define SMB_NTDBG_TERMINATE_THREAD 1073807363

#define SMB_NTDBG_TERMINATE_PROCESS 1073807364

#define SMB_NTDBG_CONTROL_C 1073807365

#define SMB_NTDBG_PRINTEXCEPTION_C 1073807366

#define SMB_NTDBG_RIPEXCEPTION 1073807367

#define SMB_NTDBG_CONTROL_BREAK 1073807368

#define SMB_NTDBG_COMMAND_EXCEPTION 1073807369

#define SMB_NTRPC_NT_UUID_LOCAL_ONLY 1073872982

#define SMB_NTRPC_NT_SEND_INCOMPLETE 1073873071

#define SMB_NTSTATUS_CTX_CDM_CONNECT 1074397188

#define SMB_NTSTATUS_CTX_CDM_DISCONNECT 1074397189

#define SMB_NTSTATUS_SXS_RELEASE_ACTIVATION_CONTEXT 1075118093

#define SMB_NTSTATUS_RECOVERY_NOT_NEEDED 1075380276

#define SMB_NTSTATUS_RM_ALREADY_STARTED 1075380277

#define SMB_NTSTATUS_LOG_NO_RESTART 1075445772

#define SMB_NTSTATUS_VIDEO_DRIVER_DEBUG_REPORT_REQUEST 1075511532

#define SMB_NTSTATUS_GRAPHICS_PARTIAL_DATA_POPULATED 1075707914

#define SMB_NTSTATUS_GRAPHICS_DRIVER_MISMATCH 1075708183

#define SMB_NTSTATUS_GRAPHICS_MODE_NOT_PINNED 1075708679

#define SMB_NTSTATUS_GRAPHICS_NO_PREFERRED_MODE 1075708702

#define SMB_NTSTATUS_GRAPHICS_DATASET_IS_EMPTY 1075708747

#define SMB_NTSTATUS_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET 1075708748

#define SMB_NTSTATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED 1075708753

#define SMB_NTSTATUS_GRAPHICS_UNKNOWN_CHILD_STATUS 1075708975

#define SMB_NTSTATUS_GRAPHICS_LEADLINK_START_DEFERRED 1075708983

#define SMB_NTSTATUS_GRAPHICS_POLLING_TOO_FREQUENTLY 1075708985

#define SMB_NTSTATUS_GRAPHICS_START_DEFERRED 1075708986

#define SMB_NTSTATUS_NDIS_INDICATION_REQUIRED 1076035585

#define SMB_NTSTATUS_GUARD_PAGE_VIOLATION 2147483649

#define SMB_NTSTATUS_DATATYPE_MISALIGNMENT 2147483650

#define SMB_NTSTATUS_BREAKPOINT 2147483651

#define SMB_NTSTATUS_SINGLE_STEP 2147483652

#define SMB_NTSTATUS_BUFFER_OVERFLOW 2147483653

#define SMB_NTSTATUS_NO_MORE_FILES 2147483654

#define SMB_NTSTATUS_WAKE_SYSTEM_DEBUGGER 2147483655

#define SMB_NTSTATUS_HANDLES_CLOSED 2147483658

#define SMB_NTSTATUS_NO_INHERITANCE 2147483659

#define SMB_NTSTATUS_GUID_SUBSTITUTION_MADE 2147483660

#define SMB_NTSTATUS_PARTIAL_COPY 2147483661

#define SMB_NTSTATUS_DEVICE_PAPER_EMPTY 2147483662

#define SMB_NTSTATUS_DEVICE_POWERED_OFF 2147483663

#define SMB_NTSTATUS_DEVICE_OFF_LINE 2147483664

#define SMB_NTSTATUS_DEVICE_BUSY 2147483665

#define SMB_NTSTATUS_NO_MORE_EAS 2147483666

#define SMB_NTSTATUS_INVALID_EA_NAME 2147483667

#define SMB_NTSTATUS_EA_LIST_INCONSISTENT 2147483668

#define SMB_NTSTATUS_INVALID_EA_FLAG 2147483669

#define SMB_NTSTATUS_VERIFY_REQUIRED 2147483670

#define SMB_NTSTATUS_EXTRANEOUS_INFORMATION 2147483671

#define SMB_NTSTATUS_RXACT_COMMIT_NECESSARY 2147483672

#define SMB_NTSTATUS_NO_MORE_ENTRIES 2147483674

#define SMB_NTSTATUS_FILEMARK_DETECTED 2147483675

#define SMB_NTSTATUS_MEDIA_CHANGED 2147483676

#define SMB_NTSTATUS_BUS_RESET 2147483677

#define SMB_NTSTATUS_END_OF_MEDIA 2147483678

#define SMB_NTSTATUS_BEGINNING_OF_MEDIA 2147483679

#define SMB_NTSTATUS_MEDIA_CHECK 2147483680

#define SMB_NTSTATUS_SETMARK_DETECTED 2147483681

#define SMB_NTSTATUS_NO_DATA_DETECTED 2147483682

#define SMB_NTSTATUS_REDIRECTOR_HAS_OPEN_HANDLES 2147483683

#define SMB_NTSTATUS_SERVER_HAS_OPEN_HANDLES 2147483684

#define SMB_NTSTATUS_ALREADY_DISCONNECTED 2147483685

#define SMB_NTSTATUS_LONGJUMP 2147483686

#define SMB_NTSTATUS_CLEANER_CARTRIDGE_INSTALLED 2147483687

#define SMB_NTSTATUS_PLUGPLAY_QUERY_VETOED 2147483688

#define SMB_NTSTATUS_UNWIND_CONSOLIDATE 2147483689

#define SMB_NTSTATUS_REGISTRY_HIVE_RECOVERED 2147483690

#define SMB_NTSTATUS_DLL_MIGHT_BE_INSECURE 2147483691

#define SMB_NTSTATUS_DLL_MIGHT_BE_INCOMPATIBLE 2147483692

#define SMB_NTSTATUS_STOPPED_ON_SYMLINK 2147483693

#define SMB_NTSTATUS_DEVICE_REQUIRES_CLEANING 2147484296

#define SMB_NTSTATUS_DEVICE_DOOR_OPEN 2147484297

#define SMB_NTSTATUS_DATA_LOST_REPAIR 2147485699

#define SMB_NTDBG_EXCEPTION_NOT_HANDLED 2147549185

#define SMB_NTSTATUS_CLUSTER_NODE_ALREADY_UP 2148728833

#define SMB_NTSTATUS_CLUSTER_NODE_ALREADY_DOWN 2148728834

#define SMB_NTSTATUS_CLUSTER_NETWORK_ALREADY_ONLINE 2148728835

#define SMB_NTSTATUS_CLUSTER_NETWORK_ALREADY_OFFLINE 2148728836

#define SMB_NTSTATUS_CLUSTER_NODE_ALREADY_MEMBER 2148728837

#define SMB_NTSTATUS_COULD_NOT_RESIZE_LOG 2149122057

#define SMB_NTSTATUS_NO_TXF_METADATA 2149122089

#define SMB_NTSTATUS_CANT_RECOVER_WITH_HANDLE_OPEN 2149122097

#define SMB_NTSTATUS_TXF_METADATA_ALREADY_PRESENT 2149122113

#define SMB_NTSTATUS_TRANSACTION_SCOPE_CALLBACKS_NOT_SET 2149122114

#define SMB_NTSTATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED 2149253355

#define SMB_NTSTATUS_FLT_BUFFER_TOO_SMALL 2149318657

#define SMB_NTSTATUS_FVE_PARTIAL_METADATA 2149646337

#define SMB_NTSTATUS_FVE_TRANSIENT_STATE 2149646338

#define SMB_NTSTATUS_UNSUCCESSFUL 3221225473

#define SMB_NTSTATUS_NOT_IMPLEMENTED 3221225474

#define SMB_NTSTATUS_INVALID_INFO_CLASS 3221225475

#define SMB_NTSTATUS_INFO_LENGTH_MISMATCH 3221225476

#define SMB_NTSTATUS_ACCESS_VIOLATION 3221225477

#define SMB_NTSTATUS_IN_PAGE_ERROR 3221225478

#define SMB_NTSTATUS_PAGEFILE_QUOTA 3221225479

#define SMB_NTSTATUS_INVALID_HANDLE 3221225480

#define SMB_NTSTATUS_BAD_INITIAL_STACK 3221225481

#define SMB_NTSTATUS_BAD_INITIAL_PC 3221225482

#define SMB_NTSTATUS_INVALID_CID 3221225483

#define SMB_NTSTATUS_TIMER_NOT_CANCELED 3221225484

#define SMB_NTSTATUS_INVALID_PARAMETER 3221225485

#define SMB_NTSTATUS_NO_SUCH_DEVICE 3221225486

#define SMB_NTSTATUS_NO_SUCH_FILE 3221225487

#define SMB_NTSTATUS_INVALID_DEVICE_REQUEST 3221225488

#define SMB_NTSTATUS_END_OF_FILE 3221225489

#define SMB_NTSTATUS_WRONG_VOLUME 3221225490

#define SMB_NTSTATUS_NO_MEDIA_IN_DEVICE 3221225491

#define SMB_NTSTATUS_UNRECOGNIZED_MEDIA 3221225492

#define SMB_NTSTATUS_NONEXISTENT_SECTOR 3221225493

#define SMB_NTSTATUS_MORE_PROCESSING_REQUIRED 3221225494

#define SMB_NTSTATUS_NO_MEMORY 3221225495

#define SMB_NTSTATUS_CONFLICTING_ADDRESSES 3221225496

#define SMB_NTSTATUS_NOT_MAPPED_VIEW 3221225497

#define SMB_NTSTATUS_UNABLE_TO_FREE_VM 3221225498

#define SMB_NTSTATUS_UNABLE_TO_DELETE_SECTION 3221225499

#define SMB_NTSTATUS_INVALID_SYSTEM_SERVICE 3221225500

#define SMB_NTSTATUS_ILLEGAL_INSTRUCTION 3221225501

#define SMB_NTSTATUS_INVALID_LOCK_SEQUENCE 3221225502

#define SMB_NTSTATUS_INVALID_VIEW_SIZE 3221225503

#define SMB_NTSTATUS_INVALID_FILE_FOR_SECTION 3221225504

#define SMB_NTSTATUS_ALREADY_COMMITTED 3221225505

#define SMB_NTSTATUS_ACCESS_DENIED 3221225506

#define SMB_NTSTATUS_BUFFER_TOO_SMALL 3221225507

#define SMB_NTSTATUS_OBJECT_TYPE_MISMATCH 3221225508

#define SMB_NTSTATUS_NONCONTINUABLE_EXCEPTION 3221225509

#define SMB_NTSTATUS_INVALID_DISPOSITION 3221225510

#define SMB_NTSTATUS_UNWIND 3221225511

#define SMB_NTSTATUS_BAD_STACK 3221225512

#define SMB_NTSTATUS_INVALID_UNWIND_TARGET 3221225513

#define SMB_NTSTATUS_NOT_LOCKED 3221225514

#define SMB_NTSTATUS_PARITY_ERROR 3221225515

#define SMB_NTSTATUS_UNABLE_TO_DECOMMIT_VM 3221225516

#define SMB_NTSTATUS_NOT_COMMITTED 3221225517

#define SMB_NTSTATUS_INVALID_PORT_ATTRIBUTES 3221225518

#define SMB_NTSTATUS_PORT_MESSAGE_TOO_LONG 3221225519

#define SMB_NTSTATUS_INVALID_PARAMETER_MIX 3221225520

#define SMB_NTSTATUS_INVALID_QUOTA_LOWER 3221225521

#define SMB_NTSTATUS_DISK_CORRUPT_ERROR 3221225522

#define SMB_NTSTATUS_OBJECT_NAME_INVALID 3221225523

#define SMB_NTSTATUS_OBJECT_NAME_NOT_FOUND 3221225524

#define SMB_NTSTATUS_OBJECT_NAME_COLLISION 3221225525

#define SMB_NTSTATUS_PORT_DISCONNECTED 3221225527

#define SMB_NTSTATUS_DEVICE_ALREADY_ATTACHED 3221225528

#define SMB_NTSTATUS_OBJECT_PATH_INVALID 3221225529

#define SMB_NTSTATUS_OBJECT_PATH_NOT_FOUND 3221225530

#define SMB_NTSTATUS_OBJECT_PATH_SYNTAX_BAD 3221225531

#define SMB_NTSTATUS_DATA_OVERRUN 3221225532

#define SMB_NTSTATUS_DATA_LATE_ERROR 3221225533

#define SMB_NTSTATUS_DATA_ERROR 3221225534

#define SMB_NTSTATUS_CRC_ERROR 3221225535

#define SMB_NTSTATUS_SECTION_TOO_BIG 3221225536

#define SMB_NTSTATUS_PORT_CONNECTION_REFUSED 3221225537

#define SMB_NTSTATUS_INVALID_PORT_HANDLE 3221225538

#define SMB_NTSTATUS_SHARING_VIOLATION 3221225539

#define SMB_NTSTATUS_QUOTA_EXCEEDED 3221225540

#define SMB_NTSTATUS_INVALID_PAGE_PROTECTION 3221225541

#define SMB_NTSTATUS_MUTANT_NOT_OWNED 3221225542

#define SMB_NTSTATUS_SEMAPHORE_LIMIT_EXCEEDED 3221225543

#define SMB_NTSTATUS_PORT_ALREADY_SET 3221225544

#define SMB_NTSTATUS_SECTION_NOT_IMAGE 3221225545

#define SMB_NTSTATUS_SUSPEND_COUNT_EXCEEDED 3221225546

#define SMB_NTSTATUS_THREAD_IS_TERMINATING 3221225547

#define SMB_NTSTATUS_BAD_WORKING_SET_LIMIT 3221225548

#define SMB_NTSTATUS_INCOMPATIBLE_FILE_MAP 3221225549

#define SMB_NTSTATUS_SECTION_PROTECTION 3221225550

#define SMB_NTSTATUS_EAS_NOT_SUPPORTED 3221225551

#define SMB_NTSTATUS_EA_TOO_LARGE 3221225552

#define SMB_NTSTATUS_NONEXISTENT_EA_ENTRY 3221225553

#define SMB_NTSTATUS_NO_EAS_ON_FILE 3221225554

#define SMB_NTSTATUS_EA_CORRUPT_ERROR 3221225555

#define SMB_NTSTATUS_FILE_LOCK_CONFLICT 3221225556

#define SMB_NTSTATUS_LOCK_NOT_GRANTED 3221225557

#define SMB_NTSTATUS_DELETE_PENDING 3221225558

#define SMB_NTSTATUS_CTL_FILE_NOT_SUPPORTED 3221225559

#define SMB_NTSTATUS_UNKNOWN_REVISION 3221225560

#define SMB_NTSTATUS_REVISION_MISMATCH 3221225561

#define SMB_NTSTATUS_INVALID_OWNER 3221225562

#define SMB_NTSTATUS_INVALID_PRIMARY_GROUP 3221225563

#define SMB_NTSTATUS_NO_IMPERSONATION_TOKEN 3221225564

#define SMB_NTSTATUS_CANT_DISABLE_MANDATORY 3221225565

#define SMB_NTSTATUS_NO_LOGON_SERVERS 3221225566

#define SMB_NTSTATUS_NO_SUCH_LOGON_SESSION 3221225567

#define SMB_NTSTATUS_NO_SUCH_PRIVILEGE 3221225568

#define SMB_NTSTATUS_PRIVILEGE_NOT_HELD 3221225569

#define SMB_NTSTATUS_INVALID_ACCOUNT_NAME 3221225570

#define SMB_NTSTATUS_USER_EXISTS 3221225571

#define SMB_NTSTATUS_NO_SUCH_USER 3221225572

#define SMB_NTSTATUS_GROUP_EXISTS 3221225573

#define SMB_NTSTATUS_NO_SUCH_GROUP 3221225574

#define SMB_NTSTATUS_MEMBER_IN_GROUP 3221225575

#define SMB_NTSTATUS_MEMBER_NOT_IN_GROUP 3221225576

#define SMB_NTSTATUS_LAST_ADMIN 3221225577

#define SMB_NTSTATUS_WRONG_PASSWORD 3221225578

#define SMB_NTSTATUS_ILL_FORMED_PASSWORD 3221225579

#define SMB_NTSTATUS_PASSWORD_RESTRICTION 3221225580

#define SMB_NTSTATUS_LOGON_FAILURE 3221225581

#define SMB_NTSTATUS_ACCOUNT_RESTRICTION 3221225582

#define SMB_NTSTATUS_INVALID_LOGON_HOURS 3221225583

#define SMB_NTSTATUS_INVALID_WORKSTATION 3221225584

#define SMB_NTSTATUS_PASSWORD_EXPIRED 3221225585

#define SMB_NTSTATUS_ACCOUNT_DISABLED 3221225586

#define SMB_NTSTATUS_NONE_MAPPED 3221225587

#define SMB_NTSTATUS_TOO_MANY_LUIDS_REQUESTED 3221225588

#define SMB_NTSTATUS_LUIDS_EXHAUSTED 3221225589

#define SMB_NTSTATUS_INVALID_SUB_AUTHORITY 3221225590

#define SMB_NTSTATUS_INVALID_ACL 3221225591

#define SMB_NTSTATUS_INVALID_SID 3221225592

#define SMB_NTSTATUS_INVALID_SECURITY_DESCR 3221225593

#define SMB_NTSTATUS_PROCEDURE_NOT_FOUND 3221225594

#define SMB_NTSTATUS_INVALID_IMAGE_FORMAT 3221225595

#define SMB_NTSTATUS_NO_TOKEN 3221225596

#define SMB_NTSTATUS_BAD_INHERITANCE_ACL 3221225597

#define SMB_NTSTATUS_RANGE_NOT_LOCKED 3221225598

#define SMB_NTSTATUS_DISK_FULL 3221225599

#define SMB_NTSTATUS_SERVER_DISABLED 3221225600

#define SMB_NTSTATUS_SERVER_NOT_DISABLED 3221225601

#define SMB_NTSTATUS_TOO_MANY_GUIDS_REQUESTED 3221225602

#define SMB_NTSTATUS_GUIDS_EXHAUSTED 3221225603

#define SMB_NTSTATUS_INVALID_ID_AUTHORITY 3221225604

#define SMB_NTSTATUS_AGENTS_EXHAUSTED 3221225605

#define SMB_NTSTATUS_INVALID_VOLUME_LABEL 3221225606

#define SMB_NTSTATUS_SECTION_NOT_EXTENDED 3221225607

#define SMB_NTSTATUS_NOT_MAPPED_DATA 3221225608

#define SMB_NTSTATUS_RESOURCE_DATA_NOT_FOUND 3221225609

#define SMB_NTSTATUS_RESOURCE_TYPE_NOT_FOUND 3221225610

#define SMB_NTSTATUS_RESOURCE_NAME_NOT_FOUND 3221225611

#define SMB_NTSTATUS_ARRAY_BOUNDS_EXCEEDED 3221225612

#define SMB_NTSTATUS_FLOAT_DENORMAL_OPERAND 3221225613

#define SMB_NTSTATUS_FLOAT_DIVIDE_BY_ZERO 3221225614

#define SMB_NTSTATUS_FLOAT_INEXACT_RESULT 3221225615

#define SMB_NTSTATUS_FLOAT_INVALID_OPERATION 3221225616

#define SMB_NTSTATUS_FLOAT_OVERFLOW 3221225617

#define SMB_NTSTATUS_FLOAT_STACK_CHECK 3221225618

#define SMB_NTSTATUS_FLOAT_UNDERFLOW 3221225619

#define SMB_NTSTATUS_INTEGER_DIVIDE_BY_ZERO 3221225620

#define SMB_NTSTATUS_INTEGER_OVERFLOW 3221225621

#define SMB_NTSTATUS_PRIVILEGED_INSTRUCTION 3221225622

#define SMB_NTSTATUS_TOO_MANY_PAGING_FILES 3221225623

#define SMB_NTSTATUS_FILE_INVALID 3221225624

#define SMB_NTSTATUS_ALLOTTED_SPACE_EXCEEDED 3221225625

#define SMB_NTSTATUS_INSUFFICIENT_RESOURCES 3221225626

#define SMB_NTSTATUS_DFS_EXIT_PATH_FOUND 3221225627

#define SMB_NTSTATUS_DEVICE_DATA_ERROR 3221225628

#define SMB_NTSTATUS_DEVICE_NOT_CONNECTED 3221225629

#define SMB_NTSTATUS_FREE_VM_NOT_AT_BASE 3221225631

#define SMB_NTSTATUS_MEMORY_NOT_ALLOCATED 3221225632

#define SMB_NTSTATUS_WORKING_SET_QUOTA 3221225633

#define SMB_NTSTATUS_MEDIA_WRITE_PROTECTED 3221225634

#define SMB_NTSTATUS_DEVICE_NOT_READY 3221225635

#define SMB_NTSTATUS_INVALID_GROUP_ATTRIBUTES 3221225636

#define SMB_NTSTATUS_BAD_IMPERSONATION_LEVEL 3221225637

#define SMB_NTSTATUS_CANT_OPEN_ANONYMOUS 3221225638

#define SMB_NTSTATUS_BAD_VALIDATION_CLASS 3221225639

#define SMB_NTSTATUS_BAD_TOKEN_TYPE 3221225640

#define SMB_NTSTATUS_BAD_MASTER_BOOT_RECORD 3221225641

#define SMB_NTSTATUS_INSTRUCTION_MISALIGNMENT 3221225642

#define SMB_NTSTATUS_INSTANCE_NOT_AVAILABLE 3221225643

#define SMB_NTSTATUS_PIPE_NOT_AVAILABLE 3221225644

#define SMB_NTSTATUS_INVALID_PIPE_STATE 3221225645

#define SMB_NTSTATUS_PIPE_BUSY 3221225646

#define SMB_NTSTATUS_ILLEGAL_FUNCTION 3221225647

#define SMB_NTSTATUS_PIPE_DISCONNECTED 3221225648

#define SMB_NTSTATUS_PIPE_CLOSING 3221225649

#define SMB_NTSTATUS_PIPE_CONNECTED 3221225650

#define SMB_NTSTATUS_PIPE_LISTENING 3221225651

#define SMB_NTSTATUS_INVALID_READ_MODE 3221225652

#define SMB_NTSTATUS_IO_TIMEOUT 3221225653

#define SMB_NTSTATUS_FILE_FORCED_CLOSED 3221225654

#define SMB_NTSTATUS_PROFILING_NOT_STARTED 3221225655

#define SMB_NTSTATUS_PROFILING_NOT_STOPPED 3221225656

#define SMB_NTSTATUS_COULD_NOT_INTERPRET 3221225657

#define SMB_NTSTATUS_FILE_IS_A_DIRECTORY 3221225658

#define SMB_NTSTATUS_NOT_SUPPORTED 3221225659

#define SMB_NTSTATUS_REMOTE_NOT_LISTENING 3221225660

#define SMB_NTSTATUS_DUPLICATE_NAME 3221225661

#define SMB_NTSTATUS_BAD_NETWORK_PATH 3221225662

#define SMB_NTSTATUS_NETWORK_BUSY 3221225663

#define SMB_NTSTATUS_DEVICE_DOES_NOT_EXIST 3221225664

#define SMB_NTSTATUS_TOO_MANY_COMMANDS 3221225665

#define SMB_NTSTATUS_ADAPTER_HARDWARE_ERROR 3221225666

#define SMB_NTSTATUS_INVALID_NETWORK_RESPONSE 3221225667

#define SMB_NTSTATUS_UNEXPECTED_NETWORK_ERROR 3221225668

#define SMB_NTSTATUS_BAD_REMOTE_ADAPTER 3221225669

#define SMB_NTSTATUS_PRINT_QUEUE_FULL 3221225670

#define SMB_NTSTATUS_NO_SPOOL_SPACE 3221225671

#define SMB_NTSTATUS_PRINT_CANCELLED 3221225672

#define SMB_NTSTATUS_NETWORK_NAME_DELETED 3221225673

#define SMB_NTSTATUS_NETWORK_ACCESS_DENIED 3221225674

#define SMB_NTSTATUS_BAD_DEVICE_TYPE 3221225675

#define SMB_NTSTATUS_BAD_NETWORK_NAME 3221225676

#define SMB_NTSTATUS_TOO_MANY_NAMES 3221225677

#define SMB_NTSTATUS_TOO_MANY_SESSIONS 3221225678

#define SMB_NTSTATUS_SHARING_PAUSED 3221225679

#define SMB_NTSTATUS_REQUEST_NOT_ACCEPTED 3221225680

#define SMB_NTSTATUS_REDIRECTOR_PAUSED 3221225681

#define SMB_NTSTATUS_NET_WRITE_FAULT 3221225682

#define SMB_NTSTATUS_PROFILING_AT_LIMIT 3221225683

#define SMB_NTSTATUS_NOT_SAME_DEVICE 3221225684

#define SMB_NTSTATUS_FILE_RENAMED 3221225685

#define SMB_NTSTATUS_VIRTUAL_CIRCUIT_CLOSED 3221225686

#define SMB_NTSTATUS_NO_SECURITY_ON_OBJECT 3221225687

#define SMB_NTSTATUS_CANT_WAIT 3221225688

#define SMB_NTSTATUS_PIPE_EMPTY 3221225689

#define SMB_NTSTATUS_CANT_ACCESS_DOMAIN_INFO 3221225690

#define SMB_NTSTATUS_CANT_TERMINATE_SELF 3221225691

#define SMB_NTSTATUS_INVALID_SERVER_STATE 3221225692

#define SMB_NTSTATUS_INVALID_DOMAIN_STATE 3221225693

#define SMB_NTSTATUS_INVALID_DOMAIN_ROLE 3221225694

#define SMB_NTSTATUS_NO_SUCH_DOMAIN 3221225695

#define SMB_NTSTATUS_DOMAIN_EXISTS 3221225696

#define SMB_NTSTATUS_DOMAIN_LIMIT_EXCEEDED 3221225697

#define SMB_NTSTATUS_OPLOCK_NOT_GRANTED 3221225698

#define SMB_NTSTATUS_INVALID_OPLOCK_PROTOCOL 3221225699

#define SMB_NTSTATUS_INTERNAL_DB_CORRUPTION 3221225700

#define SMB_NTSTATUS_INTERNAL_ERROR 3221225701

#define SMB_NTSTATUS_GENERIC_NOT_MAPPED 3221225702

#define SMB_NTSTATUS_BAD_DESCRIPTOR_FORMAT 3221225703

#define SMB_NTSTATUS_INVALID_USER_BUFFER 3221225704

#define SMB_NTSTATUS_UNEXPECTED_IO_ERROR 3221225705

#define SMB_NTSTATUS_UNEXPECTED_MM_CREATE_ERR 3221225706

#define SMB_NTSTATUS_UNEXPECTED_MM_MAP_ERROR 3221225707

#define SMB_NTSTATUS_UNEXPECTED_MM_EXTEND_ERR 3221225708

#define SMB_NTSTATUS_NOT_LOGON_PROCESS 3221225709

#define SMB_NTSTATUS_LOGON_SESSION_EXISTS 3221225710

#define SMB_NTSTATUS_INVALID_PARAMETER_1 3221225711

#define SMB_NTSTATUS_INVALID_PARAMETER_2 3221225712

#define SMB_NTSTATUS_INVALID_PARAMETER_3 3221225713

#define SMB_NTSTATUS_INVALID_PARAMETER_4 3221225714

#define SMB_NTSTATUS_INVALID_PARAMETER_5 3221225715

#define SMB_NTSTATUS_INVALID_PARAMETER_6 3221225716

#define SMB_NTSTATUS_INVALID_PARAMETER_7 3221225717

#define SMB_NTSTATUS_INVALID_PARAMETER_8 3221225718

#define SMB_NTSTATUS_INVALID_PARAMETER_9 3221225719

#define SMB_NTSTATUS_INVALID_PARAMETER_10 3221225720

#define SMB_NTSTATUS_INVALID_PARAMETER_11 3221225721

#define SMB_NTSTATUS_INVALID_PARAMETER_12 3221225722

#define SMB_NTSTATUS_REDIRECTOR_NOT_STARTED 3221225723

#define SMB_NTSTATUS_REDIRECTOR_STARTED 3221225724

#define SMB_NTSTATUS_STACK_OVERFLOW 3221225725

#define SMB_NTSTATUS_NO_SUCH_PACKAGE 3221225726

#define SMB_NTSTATUS_BAD_FUNCTION_TABLE 3221225727

#define SMB_NTSTATUS_VARIABLE_NOT_FOUND 3221225728

#define SMB_NTSTATUS_DIRECTORY_NOT_EMPTY 3221225729

#define SMB_NTSTATUS_FILE_CORRUPT_ERROR 3221225730

#define SMB_NTSTATUS_NOT_A_DIRECTORY 3221225731

#define SMB_NTSTATUS_BAD_LOGON_SESSION_STATE 3221225732

#define SMB_NTSTATUS_LOGON_SESSION_COLLISION 3221225733

#define SMB_NTSTATUS_NAME_TOO_LONG 3221225734

#define SMB_NTSTATUS_FILES_OPEN 3221225735

#define SMB_NTSTATUS_CONNECTION_IN_USE 3221225736

#define SMB_NTSTATUS_MESSAGE_NOT_FOUND 3221225737

#define SMB_NTSTATUS_PROCESS_IS_TERMINATING 3221225738

#define SMB_NTSTATUS_INVALID_LOGON_TYPE 3221225739

#define SMB_NTSTATUS_NO_GUID_TRANSLATION 3221225740

#define SMB_NTSTATUS_CANNOT_IMPERSONATE 3221225741

#define SMB_NTSTATUS_IMAGE_ALREADY_LOADED 3221225742

#define SMB_NTSTATUS_NO_LDT 3221225751

#define SMB_NTSTATUS_INVALID_LDT_SIZE 3221225752

#define SMB_NTSTATUS_INVALID_LDT_OFFSET 3221225753

#define SMB_NTSTATUS_INVALID_LDT_DESCRIPTOR 3221225754

#define SMB_NTSTATUS_INVALID_IMAGE_NE_FORMAT 3221225755

#define SMB_NTSTATUS_RXACT_INVALID_STATE 3221225756

#define SMB_NTSTATUS_RXACT_COMMIT_FAILURE 3221225757

#define SMB_NTSTATUS_MAPPED_FILE_SIZE_ZERO 3221225758

#define SMB_NTSTATUS_TOO_MANY_OPENED_FILES 3221225759

#define SMB_NTSTATUS_CANCELLED 3221225760

#define SMB_NTSTATUS_CANNOT_DELETE 3221225761

#define SMB_NTSTATUS_INVALID_COMPUTER_NAME 3221225762

#define SMB_NTSTATUS_FILE_DELETED 3221225763

#define SMB_NTSTATUS_SPECIAL_ACCOUNT 3221225764

#define SMB_NTSTATUS_SPECIAL_GROUP 3221225765

#define SMB_NTSTATUS_SPECIAL_USER 3221225766

#define SMB_NTSTATUS_MEMBERS_PRIMARY_GROUP 3221225767

#define SMB_NTSTATUS_FILE_CLOSED 3221225768

#define SMB_NTSTATUS_TOO_MANY_THREADS 3221225769

#define SMB_NTSTATUS_THREAD_NOT_IN_PROCESS 3221225770

#define SMB_NTSTATUS_TOKEN_ALREADY_IN_USE 3221225771

#define SMB_NTSTATUS_PAGEFILE_QUOTA_EXCEEDED 3221225772

#define SMB_NTSTATUS_COMMITMENT_LIMIT 3221225773

#define SMB_NTSTATUS_INVALID_IMAGE_LE_FORMAT 3221225774

#define SMB_NTSTATUS_INVALID_IMAGE_NOT_MZ 3221225775

#define SMB_NTSTATUS_INVALID_IMAGE_PROTECT 3221225776

#define SMB_NTSTATUS_INVALID_IMAGE_WIN_16 3221225777

#define SMB_NTSTATUS_LOGON_SERVER_CONFLICT 3221225778

#define SMB_NTSTATUS_TIME_DIFFERENCE_AT_DC 3221225779

#define SMB_NTSTATUS_SYNCHRONIZATION_REQUIRED 3221225780

#define SMB_NTSTATUS_DLL_NOT_FOUND 3221225781

#define SMB_NTSTATUS_OPEN_FAILED 3221225782

#define SMB_NTSTATUS_IO_PRIVILEGE_FAILED 3221225783

#define SMB_NTSTATUS_ORDINAL_NOT_FOUND 3221225784

#define SMB_NTSTATUS_ENTRYPOINT_NOT_FOUND 3221225785

#define SMB_NTSTATUS_CONTROL_C_EXIT 3221225786

#define SMB_NTSTATUS_LOCAL_DISCONNECT 3221225787

#define SMB_NTSTATUS_REMOTE_DISCONNECT 3221225788

#define SMB_NTSTATUS_REMOTE_RESOURCES 3221225789

#define SMB_NTSTATUS_LINK_FAILED 3221225790

#define SMB_NTSTATUS_LINK_TIMEOUT 3221225791

#define SMB_NTSTATUS_INVALID_CONNECTION 3221225792

#define SMB_NTSTATUS_INVALID_ADDRESS 3221225793

#define SMB_NTSTATUS_DLL_INIT_FAILED 3221225794

#define SMB_NTSTATUS_MISSING_SYSTEMFILE 3221225795

#define SMB_NTSTATUS_UNHANDLED_EXCEPTION 3221225796

#define SMB_NTSTATUS_APP_INIT_FAILURE 3221225797

#define SMB_NTSTATUS_PAGEFILE_CREATE_FAILED 3221225798

#define SMB_NTSTATUS_NO_PAGEFILE 3221225799

#define SMB_NTSTATUS_INVALID_LEVEL 3221225800

#define SMB_NTSTATUS_WRONG_PASSWORD_CORE 3221225801

#define SMB_NTSTATUS_ILLEGAL_FLOAT_CONTEXT 3221225802

#define SMB_NTSTATUS_PIPE_BROKEN 3221225803

#define SMB_NTSTATUS_REGISTRY_CORRUPT 3221225804

#define SMB_NTSTATUS_REGISTRY_IO_FAILED 3221225805

#define SMB_NTSTATUS_NO_EVENT_PAIR 3221225806

#define SMB_NTSTATUS_UNRECOGNIZED_VOLUME 3221225807

#define SMB_NTSTATUS_SERIAL_NO_DEVICE_INITED 3221225808

#define SMB_NTSTATUS_NO_SUCH_ALIAS 3221225809

#define SMB_NTSTATUS_MEMBER_NOT_IN_ALIAS 3221225810

#define SMB_NTSTATUS_MEMBER_IN_ALIAS 3221225811

#define SMB_NTSTATUS_ALIAS_EXISTS 3221225812

#define SMB_NTSTATUS_LOGON_NOT_GRANTED 3221225813

#define SMB_NTSTATUS_TOO_MANY_SECRETS 3221225814

#define SMB_NTSTATUS_SECRET_TOO_LONG 3221225815

#define SMB_NTSTATUS_INTERNAL_DB_ERROR 3221225816

#define SMB_NTSTATUS_FULLSCREEN_MODE 3221225817

#define SMB_NTSTATUS_TOO_MANY_CONTEXT_IDS 3221225818

#define SMB_NTSTATUS_LOGON_TYPE_NOT_GRANTED 3221225819

#define SMB_NTSTATUS_NOT_REGISTRY_FILE 3221225820

#define SMB_NTSTATUS_NT_CROSS_ENCRYPTION_REQUIRED 3221225821

#define SMB_NTSTATUS_DOMAIN_CTRLR_CONFIG_ERROR 3221225822

#define SMB_NTSTATUS_FT_MISSING_MEMBER 3221225823

#define SMB_NTSTATUS_ILL_FORMED_SERVICE_ENTRY 3221225824

#define SMB_NTSTATUS_ILLEGAL_CHARACTER 3221225825

#define SMB_NTSTATUS_UNMAPPABLE_CHARACTER 3221225826

#define SMB_NTSTATUS_UNDEFINED_CHARACTER 3221225827

#define SMB_NTSTATUS_FLOPPY_VOLUME 3221225828

#define SMB_NTSTATUS_FLOPPY_ID_MARK_NOT_FOUND 3221225829

#define SMB_NTSTATUS_FLOPPY_WRONG_CYLINDER 3221225830

#define SMB_NTSTATUS_FLOPPY_UNKNOWN_ERROR 3221225831

#define SMB_NTSTATUS_FLOPPY_BAD_REGISTERS 3221225832

#define SMB_NTSTATUS_DISK_RECALIBRATE_FAILED 3221225833

#define SMB_NTSTATUS_DISK_OPERATION_FAILED 3221225834

#define SMB_NTSTATUS_DISK_RESET_FAILED 3221225835

#define SMB_NTSTATUS_SHARED_IRQ_BUSY 3221225836

#define SMB_NTSTATUS_FT_ORPHANING 3221225837

#define SMB_NTSTATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT 3221225838

#define SMB_NTSTATUS_PARTITION_FAILURE 3221225842

#define SMB_NTSTATUS_INVALID_BLOCK_LENGTH 3221225843

#define SMB_NTSTATUS_DEVICE_NOT_PARTITIONED 3221225844

#define SMB_NTSTATUS_UNABLE_TO_LOCK_MEDIA 3221225845

#define SMB_NTSTATUS_UNABLE_TO_UNLOAD_MEDIA 3221225846

#define SMB_NTSTATUS_EOM_OVERFLOW 3221225847

#define SMB_NTSTATUS_NO_MEDIA 3221225848

#define SMB_NTSTATUS_NO_SUCH_MEMBER 3221225850

#define SMB_NTSTATUS_INVALID_MEMBER 3221225851

#define SMB_NTSTATUS_KEY_DELETED 3221225852

#define SMB_NTSTATUS_NO_LOG_SPACE 3221225853

#define SMB_NTSTATUS_TOO_MANY_SIDS 3221225854

#define SMB_NTSTATUS_LM_CROSS_ENCRYPTION_REQUIRED 3221225855

#define SMB_NTSTATUS_KEY_HAS_CHILDREN 3221225856

#define SMB_NTSTATUS_CHILD_MUST_BE_VOLATILE 3221225857

#define SMB_NTSTATUS_DEVICE_CONFIGURATION_ERROR 3221225858

#define SMB_NTSTATUS_DRIVER_INTERNAL_ERROR 3221225859

#define SMB_NTSTATUS_INVALID_DEVICE_STATE 3221225860

#define SMB_NTSTATUS_IO_DEVICE_ERROR 3221225861

#define SMB_NTSTATUS_DEVICE_PROTOCOL_ERROR 3221225862

#define SMB_NTSTATUS_BACKUP_CONTROLLER 3221225863

#define SMB_NTSTATUS_LOG_FILE_FULL 3221225864

#define SMB_NTSTATUS_TOO_LATE 3221225865

#define SMB_NTSTATUS_NO_TRUST_LSA_SECRET 3221225866

#define SMB_NTSTATUS_NO_TRUST_SAM_ACCOUNT 3221225867

#define SMB_NTSTATUS_TRUSTED_DOMAIN_FAILURE 3221225868

#define SMB_NTSTATUS_TRUSTED_RELATIONSHIP_FAILURE 3221225869

#define SMB_NTSTATUS_EVENTLOG_FILE_CORRUPT 3221225870

#define SMB_NTSTATUS_EVENTLOG_CANT_START 3221225871

#define SMB_NTSTATUS_TRUST_FAILURE 3221225872

#define SMB_NTSTATUS_MUTANT_LIMIT_EXCEEDED 3221225873

#define SMB_NTSTATUS_NETLOGON_NOT_STARTED 3221225874

#define SMB_NTSTATUS_ACCOUNT_EXPIRED 3221225875

#define SMB_NTSTATUS_POSSIBLE_DEADLOCK 3221225876

#define SMB_NTSTATUS_NETWORK_CREDENTIAL_CONFLICT 3221225877

#define SMB_NTSTATUS_REMOTE_SESSION_LIMIT 3221225878

#define SMB_NTSTATUS_EVENTLOG_FILE_CHANGED 3221225879

#define SMB_NTSTATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT 3221225880

#define SMB_NTSTATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT 3221225881

#define SMB_NTSTATUS_NOLOGON_SERVER_TRUST_ACCOUNT 3221225882

#define SMB_NTSTATUS_DOMAIN_TRUST_INCONSISTENT 3221225883

#define SMB_NTSTATUS_FS_DRIVER_REQUIRED 3221225884

#define SMB_NTSTATUS_IMAGE_ALREADY_LOADED_AS_DLL 3221225885

#define SMB_NTSTATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING 3221225886

#define SMB_NTSTATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME 3221225887

#define SMB_NTSTATUS_SECURITY_STREAM_IS_INCONSISTENT 3221225888

#define SMB_NTSTATUS_INVALID_LOCK_RANGE 3221225889

#define SMB_NTSTATUS_INVALID_ACE_CONDITION 3221225890

#define SMB_NTSTATUS_IMAGE_SUBSYSTEM_NOT_PRESENT 3221225891

#define SMB_NTSTATUS_NOTIFICATION_GUID_ALREADY_DEFINED 3221225892

#define SMB_NTSTATUS_NETWORK_OPEN_RESTRICTION 3221225985

#define SMB_NTSTATUS_NO_USER_SESSION_KEY 3221225986

#define SMB_NTSTATUS_USER_SESSION_DELETED 3221225987

#define SMB_NTSTATUS_RESOURCE_LANG_NOT_FOUND 3221225988

#define SMB_NTSTATUS_INSUFF_SERVER_RESOURCES 3221225989

#define SMB_NTSTATUS_INVALID_BUFFER_SIZE 3221225990

#define SMB_NTSTATUS_INVALID_ADDRESS_COMPONENT 3221225991

#define SMB_NTSTATUS_INVALID_ADDRESS_WILDCARD 3221225992

#define SMB_NTSTATUS_TOO_MANY_ADDRESSES 3221225993

#define SMB_NTSTATUS_ADDRESS_ALREADY_EXISTS 3221225994

#define SMB_NTSTATUS_ADDRESS_CLOSED 3221225995

#define SMB_NTSTATUS_CONNECTION_DISCONNECTED 3221225996

#define SMB_NTSTATUS_CONNECTION_RESET 3221225997

#define SMB_NTSTATUS_TOO_MANY_NODES 3221225998

#define SMB_NTSTATUS_TRANSACTION_ABORTED 3221225999

#define SMB_NTSTATUS_TRANSACTION_TIMED_OUT 3221226000

#define SMB_NTSTATUS_TRANSACTION_NO_RELEASE 3221226001

#define SMB_NTSTATUS_TRANSACTION_NO_MATCH 3221226002

#define SMB_NTSTATUS_TRANSACTION_RESPONDED 3221226003

#define SMB_NTSTATUS_TRANSACTION_INVALID_ID 3221226004

#define SMB_NTSTATUS_TRANSACTION_INVALID_TYPE 3221226005

#define SMB_NTSTATUS_NOT_SERVER_SESSION 3221226006

#define SMB_NTSTATUS_NOT_CLIENT_SESSION 3221226007

#define SMB_NTSTATUS_CANNOT_LOAD_REGISTRY_FILE 3221226008

#define SMB_NTSTATUS_DEBUG_ATTACH_FAILED 3221226009

#define SMB_NTSTATUS_SYSTEM_PROCESS_TERMINATED 3221226010

#define SMB_NTSTATUS_DATA_NOT_ACCEPTED 3221226011

#define SMB_NTSTATUS_NO_BROWSER_SERVERS_FOUND 3221226012

#define SMB_NTSTATUS_VDM_HARD_ERROR 3221226013

#define SMB_NTSTATUS_DRIVER_CANCEL_TIMEOUT 3221226014

#define SMB_NTSTATUS_REPLY_MESSAGE_MISMATCH 3221226015

#define SMB_NTSTATUS_MAPPED_ALIGNMENT 3221226016

#define SMB_NTSTATUS_IMAGE_CHECKSUM_MISMATCH 3221226017

#define SMB_NTSTATUS_LOST_WRITEBEHIND_DATA 3221226018

#define SMB_NTSTATUS_CLIENT_SERVER_PARAMETERS_INVALID 3221226019

#define SMB_NTSTATUS_PASSWORD_MUST_CHANGE 3221226020

#define SMB_NTSTATUS_NOT_FOUND 3221226021

#define SMB_NTSTATUS_NOT_TINY_STREAM 3221226022

#define SMB_NTSTATUS_RECOVERY_FAILURE 3221226023

#define SMB_NTSTATUS_STACK_OVERFLOW_READ 3221226024

#define SMB_NTSTATUS_FAIL_CHECK 3221226025

#define SMB_NTSTATUS_DUPLICATE_OBJECTID 3221226026

#define SMB_NTSTATUS_OBJECTID_EXISTS 3221226027

#define SMB_NTSTATUS_CONVERT_TO_LARGE 3221226028

#define SMB_NTSTATUS_RETRY 3221226029

#define SMB_NTSTATUS_FOUND_OUT_OF_SCOPE 3221226030

#define SMB_NTSTATUS_ALLOCATE_BUCKET 3221226031

#define SMB_NTSTATUS_PROPSET_NOT_FOUND 3221226032

#define SMB_NTSTATUS_MARSHALL_OVERFLOW 3221226033

#define SMB_NTSTATUS_INVALID_VARIANT 3221226034

#define SMB_NTSTATUS_DOMAIN_CONTROLLER_NOT_FOUND 3221226035

#define SMB_NTSTATUS_ACCOUNT_LOCKED_OUT 3221226036

#define SMB_NTSTATUS_HANDLE_NOT_CLOSABLE 3221226037

#define SMB_NTSTATUS_CONNECTION_REFUSED 3221226038

#define SMB_NTSTATUS_GRACEFUL_DISCONNECT 3221226039

#define SMB_NTSTATUS_ADDRESS_ALREADY_ASSOCIATED 3221226040

#define SMB_NTSTATUS_ADDRESS_NOT_ASSOCIATED 3221226041

#define SMB_NTSTATUS_CONNECTION_INVALID 3221226042

#define SMB_NTSTATUS_CONNECTION_ACTIVE 3221226043

#define SMB_NTSTATUS_NETWORK_UNREACHABLE 3221226044

#define SMB_NTSTATUS_HOST_UNREACHABLE 3221226045

#define SMB_NTSTATUS_PROTOCOL_UNREACHABLE 3221226046

#define SMB_NTSTATUS_PORT_UNREACHABLE 3221226047

#define SMB_NTSTATUS_REQUEST_ABORTED 3221226048

#define SMB_NTSTATUS_CONNECTION_ABORTED 3221226049

#define SMB_NTSTATUS_BAD_COMPRESSION_BUFFER 3221226050

#define SMB_NTSTATUS_USER_MAPPED_FILE 3221226051

#define SMB_NTSTATUS_AUDIT_FAILED 3221226052

#define SMB_NTSTATUS_TIMER_RESOLUTION_NOT_SET 3221226053

#define SMB_NTSTATUS_CONNECTION_COUNT_LIMIT 3221226054

#define SMB_NTSTATUS_LOGIN_TIME_RESTRICTION 3221226055

#define SMB_NTSTATUS_LOGIN_WKSTA_RESTRICTION 3221226056

#define SMB_NTSTATUS_IMAGE_MP_UP_MISMATCH 3221226057

#define SMB_NTSTATUS_INSUFFICIENT_LOGON_INFO 3221226064

#define SMB_NTSTATUS_BAD_DLL_ENTRYPOINT 3221226065

#define SMB_NTSTATUS_BAD_SERVICE_ENTRYPOINT 3221226066

#define SMB_NTSTATUS_LPC_REPLY_LOST 3221226067

#define SMB_NTSTATUS_IP_ADDRESS_CONFLICT1 3221226068

#define SMB_NTSTATUS_IP_ADDRESS_CONFLICT2 3221226069

#define SMB_NTSTATUS_REGISTRY_QUOTA_LIMIT 3221226070

#define SMB_NTSTATUS_PATH_NOT_COVERED 3221226071

#define SMB_NTSTATUS_NO_CALLBACK_ACTIVE 3221226072

#define SMB_NTSTATUS_LICENSE_QUOTA_EXCEEDED 3221226073

#define SMB_NTSTATUS_PWD_TOO_SHORT 3221226074

#define SMB_NTSTATUS_PWD_TOO_RECENT 3221226075

#define SMB_NTSTATUS_PWD_HISTORY_CONFLICT 3221226076

#define SMB_NTSTATUS_PLUGPLAY_NO_DEVICE 3221226078

#define SMB_NTSTATUS_UNSUPPORTED_COMPRESSION 3221226079

#define SMB_NTSTATUS_INVALID_HW_PROFILE 3221226080

#define SMB_NTSTATUS_INVALID_PLUGPLAY_DEVICE_PATH 3221226081

#define SMB_NTSTATUS_DRIVER_ORDINAL_NOT_FOUND 3221226082

#define SMB_NTSTATUS_DRIVER_ENTRYPOINT_NOT_FOUND 3221226083

#define SMB_NTSTATUS_RESOURCE_NOT_OWNED 3221226084

#define SMB_NTSTATUS_TOO_MANY_LINKS 3221226085

#define SMB_NTSTATUS_QUOTA_LIST_INCONSISTENT 3221226086

#define SMB_NTSTATUS_FILE_IS_OFFLINE 3221226087

#define SMB_NTSTATUS_EVALUATION_EXPIRATION 3221226088

#define SMB_NTSTATUS_ILLEGAL_DLL_RELOCATION 3221226089

#define SMB_NTSTATUS_LICENSE_VIOLATION 3221226090

#define SMB_NTSTATUS_DLL_INIT_FAILED_LOGOFF 3221226091

#define SMB_NTSTATUS_DRIVER_UNABLE_TO_LOAD 3221226092

#define SMB_NTSTATUS_DFS_UNAVAILABLE 3221226093

#define SMB_NTSTATUS_VOLUME_DISMOUNTED 3221226094

#define SMB_NTSTATUS_WX86_INTERNAL_ERROR 3221226095

#define SMB_NTSTATUS_WX86_FLOAT_STACK_CHECK 3221226096

#define SMB_NTSTATUS_VALIDATE_CONTINUE 3221226097

#define SMB_NTSTATUS_NO_MATCH 3221226098

#define SMB_NTSTATUS_NO_MORE_MATCHES 3221226099

#define SMB_NTSTATUS_NOT_A_REPARSE_POINT 3221226101

#define SMB_NTSTATUS_IO_REPARSE_TAG_INVALID 3221226102

#define SMB_NTSTATUS_IO_REPARSE_TAG_MISMATCH 3221226103

#define SMB_NTSTATUS_IO_REPARSE_DATA_INVALID 3221226104

#define SMB_NTSTATUS_IO_REPARSE_TAG_NOT_HANDLED 3221226105

#define SMB_NTSTATUS_REPARSE_POINT_NOT_RESOLVED 3221226112

#define SMB_NTSTATUS_DIRECTORY_IS_A_REPARSE_POINT 3221226113

#define SMB_NTSTATUS_RANGE_LIST_CONFLICT 3221226114

#define SMB_NTSTATUS_SOURCE_ELEMENT_EMPTY 3221226115

#define SMB_NTSTATUS_DESTINATION_ELEMENT_FULL 3221226116

#define SMB_NTSTATUS_ILLEGAL_ELEMENT_ADDRESS 3221226117

#define SMB_NTSTATUS_MAGAZINE_NOT_PRESENT 3221226118

#define SMB_NTSTATUS_REINITIALIZATION_NEEDED 3221226119

#define SMB_NTSTATUS_ENCRYPTION_FAILED 3221226122

#define SMB_NTSTATUS_DECRYPTION_FAILED 3221226123

#define SMB_NTSTATUS_RANGE_NOT_FOUND 3221226124

#define SMB_NTSTATUS_NO_RECOVERY_POLICY 3221226125

#define SMB_NTSTATUS_NO_EFS 3221226126

#define SMB_NTSTATUS_WRONG_EFS 3221226127

#define SMB_NTSTATUS_NO_USER_KEYS 3221226128

#define SMB_NTSTATUS_FILE_NOT_ENCRYPTED 3221226129

#define SMB_NTSTATUS_NOT_EXPORT_FORMAT 3221226130

#define SMB_NTSTATUS_FILE_ENCRYPTED 3221226131

#define SMB_NTSTATUS_WMI_GUID_NOT_FOUND 3221226133

#define SMB_NTSTATUS_WMI_INSTANCE_NOT_FOUND 3221226134

#define SMB_NTSTATUS_WMI_ITEMID_NOT_FOUND 3221226135

#define SMB_NTSTATUS_WMI_TRY_AGAIN 3221226136

#define SMB_NTSTATUS_SHARED_POLICY 3221226137

#define SMB_NTSTATUS_POLICY_OBJECT_NOT_FOUND 3221226138

#define SMB_NTSTATUS_POLICY_ONLY_IN_DS 3221226139

#define SMB_NTSTATUS_VOLUME_NOT_UPGRADED 3221226140

#define SMB_NTSTATUS_REMOTE_STORAGE_NOT_ACTIVE 3221226141

#define SMB_NTSTATUS_REMOTE_STORAGE_MEDIA_ERROR 3221226142

#define SMB_NTSTATUS_NO_TRACKING_SERVICE 3221226143

#define SMB_NTSTATUS_SERVER_SID_MISMATCH 3221226144

#define SMB_NTSTATUS_DS_NO_ATTRIBUTE_OR_VALUE 3221226145

#define SMB_NTSTATUS_DS_INVALID_ATTRIBUTE_SYNTAX 3221226146

#define SMB_NTSTATUS_DS_ATTRIBUTE_TYPE_UNDEFINED 3221226147

#define SMB_NTSTATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS 3221226148

#define SMB_NTSTATUS_DS_BUSY 3221226149

#define SMB_NTSTATUS_DS_UNAVAILABLE 3221226150

#define SMB_NTSTATUS_DS_NO_RIDS_ALLOCATED 3221226151

#define SMB_NTSTATUS_DS_NO_MORE_RIDS 3221226152

#define SMB_NTSTATUS_DS_INCORRECT_ROLE_OWNER 3221226153

#define SMB_NTSTATUS_DS_RIDMGR_INIT_ERROR 3221226154

#define SMB_NTSTATUS_DS_OBJ_CLASS_VIOLATION 3221226155

#define SMB_NTSTATUS_DS_CANT_ON_NON_LEAF 3221226156

#define SMB_NTSTATUS_DS_CANT_ON_RDN 3221226157

#define SMB_NTSTATUS_DS_CANT_MOD_OBJ_CLASS 3221226158

#define SMB_NTSTATUS_DS_CROSS_DOM_MOVE_FAILED 3221226159

#define SMB_NTSTATUS_DS_GC_NOT_AVAILABLE 3221226160

#define SMB_NTSTATUS_DIRECTORY_SERVICE_REQUIRED 3221226161

#define SMB_NTSTATUS_REPARSE_ATTRIBUTE_CONFLICT 3221226162

#define SMB_NTSTATUS_CANT_ENABLE_DENY_ONLY 3221226163

#define SMB_NTSTATUS_FLOAT_MULTIPLE_FAULTS 3221226164

#define SMB_NTSTATUS_FLOAT_MULTIPLE_TRAPS 3221226165

#define SMB_NTSTATUS_DEVICE_REMOVED 3221226166

#define SMB_NTSTATUS_JOURNAL_DELETE_IN_PROGRESS 3221226167

#define SMB_NTSTATUS_JOURNAL_NOT_ACTIVE 3221226168

#define SMB_NTSTATUS_NOINTERFACE 3221226169

#define SMB_NTSTATUS_DS_ADMIN_LIMIT_EXCEEDED 3221226177

#define SMB_NTSTATUS_DRIVER_FAILED_SLEEP 3221226178

#define SMB_NTSTATUS_MUTUAL_AUTHENTICATION_FAILED 3221226179

#define SMB_NTSTATUS_CORRUPT_SYSTEM_FILE 3221226180

#define SMB_NTSTATUS_DATATYPE_MISALIGNMENT_ERROR 3221226181

#define SMB_NTSTATUS_WMI_READ_ONLY 3221226182

#define SMB_NTSTATUS_WMI_SET_FAILURE 3221226183

#define SMB_NTSTATUS_COMMITMENT_MINIMUM 3221226184

#define SMB_NTSTATUS_REG_NAT_CONSUMPTION 3221226185

#define SMB_NTSTATUS_TRANSPORT_FULL 3221226186

#define SMB_NTSTATUS_DS_SAM_INIT_FAILURE 3221226187

#define SMB_NTSTATUS_ONLY_IF_CONNECTED 3221226188

#define SMB_NTSTATUS_DS_SENSITIVE_GROUP_VIOLATION 3221226189

#define SMB_NTSTATUS_PNP_RESTART_ENUMERATION 3221226190

#define SMB_NTSTATUS_JOURNAL_ENTRY_DELETED 3221226191

#define SMB_NTSTATUS_DS_CANT_MOD_PRIMARYGROUPID 3221226192

#define SMB_NTSTATUS_SYSTEM_IMAGE_BAD_SIGNATURE 3221226193

#define SMB_NTSTATUS_PNP_REBOOT_REQUIRED 3221226194

#define SMB_NTSTATUS_POWER_STATE_INVALID 3221226195

#define SMB_NTSTATUS_DS_INVALID_GROUP_TYPE 3221226196

#define SMB_NTSTATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN 3221226197

#define SMB_NTSTATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN 3221226198

#define SMB_NTSTATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER 3221226199

#define SMB_NTSTATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER 3221226200

#define SMB_NTSTATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER 3221226201

#define SMB_NTSTATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER 3221226202

#define SMB_NTSTATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER 3221226203

#define SMB_NTSTATUS_DS_HAVE_PRIMARY_MEMBERS 3221226204

#define SMB_NTSTATUS_WMI_NOT_SUPPORTED 3221226205

#define SMB_NTSTATUS_INSUFFICIENT_POWER 3221226206

#define SMB_NTSTATUS_SAM_NEED_BOOTKEY_PASSWORD 3221226207

#define SMB_NTSTATUS_SAM_NEED_BOOTKEY_FLOPPY 3221226208

#define SMB_NTSTATUS_DS_CANT_START 3221226209

#define SMB_NTSTATUS_DS_INIT_FAILURE 3221226210

#define SMB_NTSTATUS_SAM_INIT_FAILURE 3221226211

#define SMB_NTSTATUS_DS_GC_REQUIRED 3221226212

#define SMB_NTSTATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY 3221226213

#define SMB_NTSTATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS 3221226214

#define SMB_NTSTATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED 3221226215

#define SMB_NTSTATUS_CURRENT_DOMAIN_NOT_ALLOWED 3221226217

#define SMB_NTSTATUS_CANNOT_MAKE 3221226218

#define SMB_NTSTATUS_SYSTEM_SHUTDOWN 3221226219

#define SMB_NTSTATUS_DS_INIT_FAILURE_CONSOLE 3221226220

#define SMB_NTSTATUS_DS_SAM_INIT_FAILURE_CONSOLE 3221226221

#define SMB_NTSTATUS_UNFINISHED_CONTEXT_DELETED 3221226222

#define SMB_NTSTATUS_NO_TGT_REPLY 3221226223

#define SMB_NTSTATUS_OBJECTID_NOT_FOUND 3221226224

#define SMB_NTSTATUS_NO_IP_ADDRESSES 3221226225

#define SMB_NTSTATUS_WRONG_CREDENTIAL_HANDLE 3221226226

#define SMB_NTSTATUS_CRYPTO_SYSTEM_INVALID 3221226227

#define SMB_NTSTATUS_MAX_REFERRALS_EXCEEDED 3221226228

#define SMB_NTSTATUS_MUST_BE_KDC 3221226229

#define SMB_NTSTATUS_STRONG_CRYPTO_NOT_SUPPORTED 3221226230

#define SMB_NTSTATUS_TOO_MANY_PRINCIPALS 3221226231

#define SMB_NTSTATUS_NO_PA_DATA 3221226232

#define SMB_NTSTATUS_PKINIT_NAME_MISMATCH 3221226233

#define SMB_NTSTATUS_SMARTCARD_LOGON_REQUIRED 3221226234

#define SMB_NTSTATUS_KDC_INVALID_REQUEST 3221226235

#define SMB_NTSTATUS_KDC_UNABLE_TO_REFER 3221226236

#define SMB_NTSTATUS_KDC_UNKNOWN_ETYPE 3221226237

#define SMB_NTSTATUS_SHUTDOWN_IN_PROGRESS 3221226238

#define SMB_NTSTATUS_SERVER_SHUTDOWN_IN_PROGRESS 3221226239

#define SMB_NTSTATUS_NOT_SUPPORTED_ON_SBS 3221226240

#define SMB_NTSTATUS_WMI_GUID_DISCONNECTED 3221226241

#define SMB_NTSTATUS_WMI_ALREADY_DISABLED 3221226242

#define SMB_NTSTATUS_WMI_ALREADY_ENABLED 3221226243

#define SMB_NTSTATUS_MFT_TOO_FRAGMENTED 3221226244

#define SMB_NTSTATUS_COPY_PROTECTION_FAILURE 3221226245

#define SMB_NTSTATUS_CSS_AUTHENTICATION_FAILURE 3221226246

#define SMB_NTSTATUS_CSS_KEY_NOT_PRESENT 3221226247

#define SMB_NTSTATUS_CSS_KEY_NOT_ESTABLISHED 3221226248

#define SMB_NTSTATUS_CSS_SCRAMBLED_SECTOR 3221226249

#define SMB_NTSTATUS_CSS_REGION_MISMATCH 3221226250

#define SMB_NTSTATUS_CSS_RESETS_EXHAUSTED 3221226251

#define SMB_NTSTATUS_PKINIT_FAILURE 3221226272

#define SMB_NTSTATUS_SMARTCARD_SUBSYSTEM_FAILURE 3221226273

#define SMB_NTSTATUS_NO_KERB_KEY 3221226274

#define SMB_NTSTATUS_HOST_DOWN 3221226320

#define SMB_NTSTATUS_UNSUPPORTED_PREAUTH 3221226321

#define SMB_NTSTATUS_EFS_ALG_BLOB_TOO_BIG 3221226322

#define SMB_NTSTATUS_PORT_NOT_SET 3221226323

#define SMB_NTSTATUS_DEBUGGER_INACTIVE 3221226324

#define SMB_NTSTATUS_DS_VERSION_CHECK_FAILURE 3221226325

#define SMB_NTSTATUS_AUDITING_DISABLED 3221226326

#define SMB_NTSTATUS_PRENT4_MACHINE_ACCOUNT 3221226327

#define SMB_NTSTATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER 3221226328

#define SMB_NTSTATUS_INVALID_IMAGE_WIN_32 3221226329

#define SMB_NTSTATUS_INVALID_IMAGE_WIN_64 3221226330

#define SMB_NTSTATUS_BAD_BINDINGS 3221226331

#define SMB_NTSTATUS_NETWORK_SESSION_EXPIRED 3221226332

#define SMB_NTSTATUS_APPHELP_BLOCK 3221226333

#define SMB_NTSTATUS_ALL_SIDS_FILTERED 3221226334

#define SMB_NTSTATUS_NOT_SAFE_MODE_DRIVER 3221226335

#define SMB_NTSTATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT 3221226337

#define SMB_NTSTATUS_ACCESS_DISABLED_BY_POLICY_PATH 3221226338

#define SMB_NTSTATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER 3221226339

#define SMB_NTSTATUS_ACCESS_DISABLED_BY_POLICY_OTHER 3221226340

#define SMB_NTSTATUS_FAILED_DRIVER_ENTRY 3221226341

#define SMB_NTSTATUS_DEVICE_ENUMERATION_ERROR 3221226342

#define SMB_NTSTATUS_MOUNT_POINT_NOT_RESOLVED 3221226344

#define SMB_NTSTATUS_INVALID_DEVICE_OBJECT_PARAMETER 3221226345

#define SMB_NTSTATUS_MCA_OCCURED 3221226346

#define SMB_NTSTATUS_DRIVER_BLOCKED_CRITICAL 3221226347

#define SMB_NTSTATUS_DRIVER_BLOCKED 3221226348

#define SMB_NTSTATUS_DRIVER_DATABASE_ERROR 3221226349

#define SMB_NTSTATUS_SYSTEM_HIVE_TOO_LARGE 3221226350

#define SMB_NTSTATUS_INVALID_IMPORT_OF_NON_DLL 3221226351

#define SMB_NTSTATUS_NO_SECRETS 3221226353

#define SMB_NTSTATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY 3221226354

#define SMB_NTSTATUS_FAILED_STACK_SWITCH 3221226355

#define SMB_NTSTATUS_HEAP_CORRUPTION 3221226356

#define SMB_NTSTATUS_SMARTCARD_WRONG_PIN 3221226368

#define SMB_NTSTATUS_SMARTCARD_CARD_BLOCKED 3221226369

#define SMB_NTSTATUS_SMARTCARD_CARD_NOT_AUTHENTICATED 3221226370

#define SMB_NTSTATUS_SMARTCARD_NO_CARD 3221226371

#define SMB_NTSTATUS_SMARTCARD_NO_KEY_CONTAINER 3221226372

#define SMB_NTSTATUS_SMARTCARD_NO_CERTIFICATE 3221226373

#define SMB_NTSTATUS_SMARTCARD_NO_KEYSET 3221226374

#define SMB_NTSTATUS_SMARTCARD_IO_ERROR 3221226375

#define SMB_NTSTATUS_DOWNGRADE_DETECTED 3221226376

#define SMB_NTSTATUS_SMARTCARD_CERT_REVOKED 3221226377

#define SMB_NTSTATUS_ISSUING_CA_UNTRUSTED 3221226378

#define SMB_NTSTATUS_REVOCATION_OFFLINE_C 3221226379

#define SMB_NTSTATUS_PKINIT_CLIENT_FAILURE 3221226380

#define SMB_NTSTATUS_SMARTCARD_CERT_EXPIRED 3221226381

#define SMB_NTSTATUS_DRIVER_FAILED_PRIOR_UNLOAD 3221226382

#define SMB_NTSTATUS_SMARTCARD_SILENT_CONTEXT 3221226383

#define SMB_NTSTATUS_PER_USER_TRUST_QUOTA_EXCEEDED 3221226497

#define SMB_NTSTATUS_ALL_USER_TRUST_QUOTA_EXCEEDED 3221226498

#define SMB_NTSTATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED 3221226499

#define SMB_NTSTATUS_DS_NAME_NOT_UNIQUE 3221226500

#define SMB_NTSTATUS_DS_DUPLICATE_ID_FOUND 3221226501

#define SMB_NTSTATUS_DS_GROUP_CONVERSION_ERROR 3221226502

#define SMB_NTSTATUS_VOLSNAP_PREPARE_HIBERNATE 3221226503

#define SMB_NTSTATUS_USER2USER_REQUIRED 3221226504

#define SMB_NTSTATUS_STACK_BUFFER_OVERRUN 3221226505

#define SMB_NTSTATUS_NO_S4U_PROT_SUPPORT 3221226506

#define SMB_NTSTATUS_CROSSREALM_DELEGATION_FAILURE 3221226507

#define SMB_NTSTATUS_REVOCATION_OFFLINE_KDC 3221226508

#define SMB_NTSTATUS_ISSUING_CA_UNTRUSTED_KDC 3221226509

#define SMB_NTSTATUS_KDC_CERT_EXPIRED 3221226510

#define SMB_NTSTATUS_KDC_CERT_REVOKED 3221226511

#define SMB_NTSTATUS_PARAMETER_QUOTA_EXCEEDED 3221226512

#define SMB_NTSTATUS_HIBERNATION_FAILURE 3221226513

#define SMB_NTSTATUS_DELAY_LOAD_FAILED 3221226514

#define SMB_NTSTATUS_AUTHENTICATION_FIREWALL_FAILED 3221226515

#define SMB_NTSTATUS_VDM_DISALLOWED 3221226516

#define SMB_NTSTATUS_HUNG_DISPLAY_DRIVER_THREAD 3221226517

#define SMB_NTSTATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE 3221226518

#define SMB_NTSTATUS_INVALID_CRUNTIME_PARAMETER 3221226519

#define SMB_NTSTATUS_NTLM_BLOCKED 3221226520

#define SMB_NTSTATUS_DS_SRC_SID_EXISTS_IN_FOREST 3221226521

#define SMB_NTSTATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST 3221226522

#define SMB_NTSTATUS_DS_FLAT_NAME_EXISTS_IN_FOREST 3221226523

#define SMB_NTSTATUS_INVALID_USER_PRINCIPAL_NAME 3221226524

#define SMB_NTSTATUS_ASSERTION_FAILURE 3221226528

#define SMB_NTSTATUS_VERIFIER_STOP 3221226529

#define SMB_NTSTATUS_CALLBACK_POP_STACK 3221226531

#define SMB_NTSTATUS_INCOMPATIBLE_DRIVER_BLOCKED 3221226532

#define SMB_NTSTATUS_HIVE_UNLOADED 3221226533

#define SMB_NTSTATUS_COMPRESSION_DISABLED 3221226534

#define SMB_NTSTATUS_FILE_SYSTEM_LIMITATION 3221226535

#define SMB_NTSTATUS_INVALID_IMAGE_HASH 3221226536

#define SMB_NTSTATUS_NOT_CAPABLE 3221226537

#define SMB_NTSTATUS_REQUEST_OUT_OF_SEQUENCE 3221226538

#define SMB_NTSTATUS_IMPLEMENTATION_LIMIT 3221226539

#define SMB_NTSTATUS_ELEVATION_REQUIRED 3221226540

#define SMB_NTSTATUS_NO_SECURITY_CONTEXT 3221226541

#define SMB_NTSTATUS_PKU2U_CERT_FAILURE 3221226542

#define SMB_NTSTATUS_BEYOND_VDL 3221226546

#define SMB_NTSTATUS_ENCOUNTERED_WRITE_IN_PROGRESS 3221226547

#define SMB_NTSTATUS_PTE_CHANGED 3221226548

#define SMB_NTSTATUS_PURGE_FAILED 3221226549

#define SMB_NTSTATUS_CRED_REQUIRES_CONFIRMATION 3221226560

#define SMB_NTSTATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE 3221226561

#define SMB_NTSTATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER 3221226562

#define SMB_NTSTATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE 3221226563

#define SMB_NTSTATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE 3221226564

#define SMB_NTSTATUS_CS_ENCRYPTION_FILE_NOT_CSE 3221226565

#define SMB_NTSTATUS_INVALID_LABEL 3221226566

#define SMB_NTSTATUS_DRIVER_PROCESS_TERMINATED 3221226576

#define SMB_NTSTATUS_AMBIGUOUS_SYSTEM_DEVICE 3221226577

#define SMB_NTSTATUS_SYSTEM_DEVICE_NOT_FOUND 3221226578

#define SMB_NTSTATUS_RESTART_BOOT_APPLICATION 3221226579

#define SMB_NTSTATUS_INSUFFICIENT_NVRAM_RESOURCES 3221226580

#define SMB_NTSTATUS_NO_RANGES_PROCESSED 3221226592

#define SMB_NTSTATUS_DEVICE_FEATURE_NOT_SUPPORTED 3221226595

#define SMB_NTSTATUS_DEVICE_UNREACHABLE 3221226596

#define SMB_NTSTATUS_INVALID_TOKEN 3221226597

#define SMB_NTSTATUS_SERVER_UNAVAILABLE 3221226598

#define SMB_NTSTATUS_INVALID_TASK_NAME 3221226752

#define SMB_NTSTATUS_INVALID_TASK_INDEX 3221226753

#define SMB_NTSTATUS_THREAD_ALREADY_IN_TASK 3221226754

#define SMB_NTSTATUS_CALLBACK_BYPASS 3221226755

#define SMB_NTSTATUS_FAIL_FAST_EXCEPTION 3221227010

#define SMB_NTSTATUS_IMAGE_CERT_REVOKED 3221227011

#define SMB_NTSTATUS_PORT_CLOSED 3221227264

#define SMB_NTSTATUS_MESSAGE_LOST 3221227265

#define SMB_NTSTATUS_INVALID_MESSAGE 3221227266

#define SMB_NTSTATUS_REQUEST_CANCELED 3221227267

#define SMB_NTSTATUS_RECURSIVE_DISPATCH 3221227268

#define SMB_NTSTATUS_LPC_RECEIVE_BUFFER_EXPECTED 3221227269

#define SMB_NTSTATUS_LPC_INVALID_CONNECTION_USAGE 3221227270

#define SMB_NTSTATUS_LPC_REQUESTS_NOT_ALLOWED 3221227271

#define SMB_NTSTATUS_RESOURCE_IN_USE 3221227272

#define SMB_NTSTATUS_HARDWARE_MEMORY_ERROR 3221227273

#define SMB_NTSTATUS_THREADPOOL_HANDLE_EXCEPTION 3221227274

#define SMB_NTSTATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED 3221227275

#define SMB_NTSTATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED 3221227276

#define SMB_NTSTATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED 3221227277

#define SMB_NTSTATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED 3221227278

#define SMB_NTSTATUS_THREADPOOL_RELEASED_DURING_OPERATION 3221227279

#define SMB_NTSTATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING 3221227280

#define SMB_NTSTATUS_APC_RETURNED_WHILE_IMPERSONATING 3221227281

#define SMB_NTSTATUS_PROCESS_IS_PROTECTED 3221227282

#define SMB_NTSTATUS_MCA_EXCEPTION 3221227283

#define SMB_NTSTATUS_CERTIFICATE_MAPPING_NOT_UNIQUE 3221227284

#define SMB_NTSTATUS_SYMLINK_CLASS_DISABLED 3221227285

#define SMB_NTSTATUS_INVALID_IDN_NORMALIZATION 3221227286

#define SMB_NTSTATUS_NO_UNICODE_TRANSLATION 3221227287

#define SMB_NTSTATUS_ALREADY_REGISTERED 3221227288

#define SMB_NTSTATUS_CONTEXT_MISMATCH 3221227289

#define SMB_NTSTATUS_PORT_ALREADY_HAS_COMPLETION_LIST 3221227290

#define SMB_NTSTATUS_CALLBACK_RETURNED_THREAD_PRIORITY 3221227291

#define SMB_NTSTATUS_INVALID_THREAD 3221227292

#define SMB_NTSTATUS_CALLBACK_RETURNED_TRANSACTION 3221227293

#define SMB_NTSTATUS_CALLBACK_RETURNED_LDR_LOCK 3221227294

#define SMB_NTSTATUS_CALLBACK_RETURNED_LANG 3221227295

#define SMB_NTSTATUS_CALLBACK_RETURNED_PRI_BACK 3221227296

#define SMB_NTSTATUS_DISK_REPAIR_DISABLED 3221227520

#define SMB_NTSTATUS_DS_DOMAIN_RENAME_IN_PROGRESS 3221227521

#define SMB_NTSTATUS_DISK_QUOTA_EXCEEDED 3221227522

#define SMB_NTSTATUS_CONTENT_BLOCKED 3221227524

#define SMB_NTSTATUS_BAD_CLUSTERS 3221227525

#define SMB_NTSTATUS_VOLUME_DIRTY 3221227526

#define SMB_NTSTATUS_FILE_CHECKED_OUT 3221227777

#define SMB_NTSTATUS_CHECKOUT_REQUIRED 3221227778

#define SMB_NTSTATUS_BAD_FILE_TYPE 3221227779

#define SMB_NTSTATUS_FILE_TOO_LARGE 3221227780

#define SMB_NTSTATUS_FORMS_AUTH_REQUIRED 3221227781

#define SMB_NTSTATUS_VIRUS_INFECTED 3221227782

#define SMB_NTSTATUS_VIRUS_DELETED 3221227783

#define SMB_NTSTATUS_BAD_MCFG_TABLE 3221227784

#define SMB_NTSTATUS_CANNOT_BREAK_OPLOCK 3221227785

#define SMB_NTSTATUS_WOW_ASSERTION 3221264536

#define SMB_NTSTATUS_INVALID_SIGNATURE 3221266432

#define SMB_NTSTATUS_HMAC_NOT_SUPPORTED 3221266433

#define SMB_NTSTATUS_IPSEC_QUEUE_OVERFLOW 3221266448

#define SMB_NTSTATUS_ND_QUEUE_OVERFLOW 3221266449

#define SMB_NTSTATUS_HOPLIMIT_EXCEEDED 3221266450

#define SMB_NTSTATUS_PROTOCOL_NOT_SUPPORTED 3221266451

#define SMB_NTSTATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED 3221266560

#define SMB_NTSTATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR 3221266561

#define SMB_NTSTATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR 3221266562

#define SMB_NTSTATUS_XML_PARSE_ERROR 3221266563

#define SMB_NTSTATUS_XMLDSIG_ERROR 3221266564

#define SMB_NTSTATUS_WRONG_COMPARTMENT 3221266565

#define SMB_NTSTATUS_AUTHIP_FAILURE 3221266566

#define SMB_NTSTATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS 3221266567

#define SMB_NTSTATUS_DS_OID_NOT_FOUND 3221266568

#define SMB_NTSTATUS_HASH_NOT_SUPPORTED 3221266688

#define SMB_NTSTATUS_HASH_NOT_PRESENT 3221266689

#define SMB_NTSTATUS_OFFLOAD_READ_FLT_NOT_SUPPORTED 3221267105

#define SMB_NTSTATUS_OFFLOAD_WRITE_FLT_NOT_SUPPORTED 3221267106

#define SMB_NTSTATUS_OFFLOAD_READ_FILE_NOT_SUPPORTED 3221267107

#define SMB_NTSTATUS_OFFLOAD_WRITE_FILE_NOT_SUPPORTED 3221267108

#define SMB_NTDBG_NO_STATE_CHANGE 3221291009

#define SMB_NTDBG_APP_NOT_IDLE 3221291010

#define SMB_NTRPC_NT_INVALID_STRING_BINDING 3221356545

#define SMB_NTRPC_NT_WRONG_KIND_OF_BINDING 3221356546

#define SMB_NTRPC_NT_INVALID_BINDING 3221356547

#define SMB_NTRPC_NT_PROTSEQ_NOT_SUPPORTED 3221356548

#define SMB_NTRPC_NT_INVALID_RPC_PROTSEQ 3221356549

#define SMB_NTRPC_NT_INVALID_STRING_UUID 3221356550

#define SMB_NTRPC_NT_INVALID_ENDPOINT_FORMAT 3221356551

#define SMB_NTRPC_NT_INVALID_NET_ADDR 3221356552

#define SMB_NTRPC_NT_NO_ENDPOINT_FOUND 3221356553

#define SMB_NTRPC_NT_INVALID_TIMEOUT 3221356554

#define SMB_NTRPC_NT_OBJECT_NOT_FOUND 3221356555

#define SMB_NTRPC_NT_ALREADY_REGISTERED 3221356556

#define SMB_NTRPC_NT_TYPE_ALREADY_REGISTERED 3221356557

#define SMB_NTRPC_NT_ALREADY_LISTENING 3221356558

#define SMB_NTRPC_NT_NO_PROTSEQS_REGISTERED 3221356559

#define SMB_NTRPC_NT_NOT_LISTENING 3221356560

#define SMB_NTRPC_NT_UNKNOWN_MGR_TYPE 3221356561

#define SMB_NTRPC_NT_UNKNOWN_IF 3221356562

#define SMB_NTRPC_NT_NO_BINDINGS 3221356563

#define SMB_NTRPC_NT_NO_PROTSEQS 3221356564

#define SMB_NTRPC_NT_CANT_CREATE_ENDPOINT 3221356565

#define SMB_NTRPC_NT_OUT_OF_RESOURCES 3221356566

#define SMB_NTRPC_NT_SERVER_UNAVAILABLE 3221356567

#define SMB_NTRPC_NT_SERVER_TOO_BUSY 3221356568

#define SMB_NTRPC_NT_INVALID_NETWORK_OPTIONS 3221356569

#define SMB_NTRPC_NT_NO_CALL_ACTIVE 3221356570

#define SMB_NTRPC_NT_CALL_FAILED 3221356571

#define SMB_NTRPC_NT_CALL_FAILED_DNE 3221356572

#define SMB_NTRPC_NT_PROTOCOL_ERROR 3221356573

#define SMB_NTRPC_NT_UNSUPPORTED_TRANS_SYN 3221356575

#define SMB_NTRPC_NT_UNSUPPORTED_TYPE 3221356577

#define SMB_NTRPC_NT_INVALID_TAG 3221356578

#define SMB_NTRPC_NT_INVALID_BOUND 3221356579

#define SMB_NTRPC_NT_NO_ENTRY_NAME 3221356580

#define SMB_NTRPC_NT_INVALID_NAME_SYNTAX 3221356581

#define SMB_NTRPC_NT_UNSUPPORTED_NAME_SYNTAX 3221356582

#define SMB_NTRPC_NT_UUID_NO_ADDRESS 3221356584

#define SMB_NTRPC_NT_DUPLICATE_ENDPOINT 3221356585

#define SMB_NTRPC_NT_UNKNOWN_AUTHN_TYPE 3221356586

#define SMB_NTRPC_NT_MAX_CALLS_TOO_SMALL 3221356587

#define SMB_NTRPC_NT_STRING_TOO_LONG 3221356588

#define SMB_NTRPC_NT_PROTSEQ_NOT_FOUND 3221356589

#define SMB_NTRPC_NT_PROCNUM_OUT_OF_RANGE 3221356590

#define SMB_NTRPC_NT_BINDING_HAS_NO_AUTH 3221356591

#define SMB_NTRPC_NT_UNKNOWN_AUTHN_SERVICE 3221356592

#define SMB_NTRPC_NT_UNKNOWN_AUTHN_LEVEL 3221356593

#define SMB_NTRPC_NT_INVALID_AUTH_IDENTITY 3221356594

#define SMB_NTRPC_NT_UNKNOWN_AUTHZ_SERVICE 3221356595

#define SMB_NTEPT_NT_INVALID_ENTRY 3221356596

#define SMB_NTEPT_NT_CANT_PERFORM_OP 3221356597

#define SMB_NTEPT_NT_NOT_REGISTERED 3221356598

#define SMB_NTRPC_NT_NOTHING_TO_EXPORT 3221356599

#define SMB_NTRPC_NT_INCOMPLETE_NAME 3221356600

#define SMB_NTRPC_NT_INVALID_VERS_OPTION 3221356601

#define SMB_NTRPC_NT_NO_MORE_MEMBERS 3221356602

#define SMB_NTRPC_NT_NOT_ALL_OBJS_UNEXPORTED 3221356603

#define SMB_NTRPC_NT_INTERFACE_NOT_FOUND 3221356604

#define SMB_NTRPC_NT_ENTRY_ALREADY_EXISTS 3221356605

#define SMB_NTRPC_NT_ENTRY_NOT_FOUND 3221356606

#define SMB_NTRPC_NT_NAME_SERVICE_UNAVAILABLE 3221356607

#define SMB_NTRPC_NT_INVALID_NAF_ID 3221356608

#define SMB_NTRPC_NT_CANNOT_SUPPORT 3221356609

#define SMB_NTRPC_NT_NO_CONTEXT_AVAILABLE 3221356610

#define SMB_NTRPC_NT_INTERNAL_ERROR 3221356611

#define SMB_NTRPC_NT_ZERO_DIVIDE 3221356612

#define SMB_NTRPC_NT_ADDRESS_ERROR 3221356613

#define SMB_NTRPC_NT_FP_DIV_ZERO 3221356614

#define SMB_NTRPC_NT_FP_UNDERFLOW 3221356615

#define SMB_NTRPC_NT_FP_OVERFLOW 3221356616

#define SMB_NTRPC_NT_CALL_IN_PROGRESS 3221356617

#define SMB_NTRPC_NT_NO_MORE_BINDINGS 3221356618

#define SMB_NTRPC_NT_GROUP_MEMBER_NOT_FOUND 3221356619

#define SMB_NTEPT_NT_CANT_CREATE 3221356620

#define SMB_NTRPC_NT_INVALID_OBJECT 3221356621

#define SMB_NTRPC_NT_NO_INTERFACES 3221356623

#define SMB_NTRPC_NT_CALL_CANCELLED 3221356624

#define SMB_NTRPC_NT_BINDING_INCOMPLETE 3221356625

#define SMB_NTRPC_NT_COMM_FAILURE 3221356626

#define SMB_NTRPC_NT_UNSUPPORTED_AUTHN_LEVEL 3221356627

#define SMB_NTRPC_NT_NO_PRINC_NAME 3221356628

#define SMB_NTRPC_NT_NOT_RPC_ERROR 3221356629

#define SMB_NTRPC_NT_SEC_PKG_ERROR 3221356631

#define SMB_NTRPC_NT_NOT_CANCELLED 3221356632

#define SMB_NTRPC_NT_INVALID_ASYNC_HANDLE 3221356642

#define SMB_NTRPC_NT_INVALID_ASYNC_CALL 3221356643

#define SMB_NTRPC_NT_PROXY_ACCESS_DENIED 3221356644

#define SMB_NTRPC_NT_NO_MORE_ENTRIES 3221422081

#define SMB_NTRPC_NT_SS_CHAR_TRANS_OPEN_FAIL 3221422082

#define SMB_NTRPC_NT_SS_CHAR_TRANS_SHORT_FILE 3221422083

#define SMB_NTRPC_NT_SS_IN_NULL_CONTEXT 3221422084

#define SMB_NTRPC_NT_SS_CONTEXT_MISMATCH 3221422085

#define SMB_NTRPC_NT_SS_CONTEXT_DAMAGED 3221422086

#define SMB_NTRPC_NT_SS_HANDLES_MISMATCH 3221422087

#define SMB_NTRPC_NT_SS_CANNOT_GET_CALL_HANDLE 3221422088

#define SMB_NTRPC_NT_NULL_REF_POINTER 3221422089

#define SMB_NTRPC_NT_ENUM_VALUE_OUT_OF_RANGE 3221422090

#define SMB_NTRPC_NT_BYTE_COUNT_TOO_SMALL 3221422091

#define SMB_NTRPC_NT_BAD_STUB_DATA 3221422092

#define SMB_NTRPC_NT_INVALID_ES_ACTION 3221422169

#define SMB_NTRPC_NT_WRONG_ES_VERSION 3221422170

#define SMB_NTRPC_NT_WRONG_STUB_VERSION 3221422171

#define SMB_NTRPC_NT_INVALID_PIPE_OBJECT 3221422172

#define SMB_NTRPC_NT_INVALID_PIPE_OPERATION 3221422173

#define SMB_NTRPC_NT_WRONG_PIPE_VERSION 3221422174

#define SMB_NTRPC_NT_PIPE_CLOSED 3221422175

#define SMB_NTRPC_NT_PIPE_DISCIPLINE_ERROR 3221422176

#define SMB_NTRPC_NT_PIPE_EMPTY 3221422177

#define SMB_NTSTATUS_PNP_BAD_MPS_TABLE 3221487669

#define SMB_NTSTATUS_PNP_TRANSLATION_FAILED 3221487670

#define SMB_NTSTATUS_PNP_IRQ_TRANSLATION_FAILED 3221487671

#define SMB_NTSTATUS_PNP_INVALID_ID 3221487672

#define SMB_NTSTATUS_IO_REISSUE_AS_CACHED 3221487673

#define SMB_NTSTATUS_CTX_WINSTATION_NAME_INVALID 3221880833

#define SMB_NTSTATUS_CTX_INVALID_PD 3221880834

#define SMB_NTSTATUS_CTX_PD_NOT_FOUND 3221880835

#define SMB_NTSTATUS_CTX_CLOSE_PENDING 3221880838

#define SMB_NTSTATUS_CTX_NO_OUTBUF 3221880839

#define SMB_NTSTATUS_CTX_MODEM_INF_NOT_FOUND 3221880840

#define SMB_NTSTATUS_CTX_INVALID_MODEMNAME 3221880841

#define SMB_NTSTATUS_CTX_RESPONSE_ERROR 3221880842

#define SMB_NTSTATUS_CTX_MODEM_RESPONSE_TIMEOUT 3221880843

#define SMB_NTSTATUS_CTX_MODEM_RESPONSE_NO_CARRIER 3221880844

#define SMB_NTSTATUS_CTX_MODEM_RESPONSE_NO_DIALTONE 3221880845

#define SMB_NTSTATUS_CTX_MODEM_RESPONSE_BUSY 3221880846

#define SMB_NTSTATUS_CTX_MODEM_RESPONSE_VOICE 3221880847

#define SMB_NTSTATUS_CTX_TD_ERROR 3221880848

#define SMB_NTSTATUS_CTX_LICENSE_CLIENT_INVALID 3221880850

#define SMB_NTSTATUS_CTX_LICENSE_NOT_AVAILABLE 3221880851

#define SMB_NTSTATUS_CTX_LICENSE_EXPIRED 3221880852

#define SMB_NTSTATUS_CTX_WINSTATION_NOT_FOUND 3221880853

#define SMB_NTSTATUS_CTX_WINSTATION_NAME_COLLISION 3221880854

#define SMB_NTSTATUS_CTX_WINSTATION_BUSY 3221880855

#define SMB_NTSTATUS_CTX_BAD_VIDEO_MODE 3221880856

#define SMB_NTSTATUS_CTX_GRAPHICS_INVALID 3221880866

#define SMB_NTSTATUS_CTX_NOT_CONSOLE 3221880868

#define SMB_NTSTATUS_CTX_CLIENT_QUERY_TIMEOUT 3221880870

#define SMB_NTSTATUS_CTX_CONSOLE_DISCONNECT 3221880871

#define SMB_NTSTATUS_CTX_CONSOLE_CONNECT 3221880872

#define SMB_NTSTATUS_CTX_SHADOW_DENIED 3221880874

#define SMB_NTSTATUS_CTX_WINSTATION_ACCESS_DENIED 3221880875

#define SMB_NTSTATUS_CTX_INVALID_WD 3221880878

#define SMB_NTSTATUS_CTX_WD_NOT_FOUND 3221880879

#define SMB_NTSTATUS_CTX_SHADOW_INVALID 3221880880

#define SMB_NTSTATUS_CTX_SHADOW_DISABLED 3221880881

#define SMB_NTSTATUS_RDP_PROTOCOL_ERROR 3221880882

#define SMB_NTSTATUS_CTX_CLIENT_LICENSE_NOT_SET 3221880883

#define SMB_NTSTATUS_CTX_CLIENT_LICENSE_IN_USE 3221880884

#define SMB_NTSTATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE 3221880885

#define SMB_NTSTATUS_CTX_SHADOW_NOT_RUNNING 3221880886

#define SMB_NTSTATUS_CTX_LOGON_DISABLED 3221880887

#define SMB_NTSTATUS_CTX_SECURITY_LAYER_ERROR 3221880888

#define SMB_NTSTATUS_TS_INCOMPATIBLE_SESSIONS 3221880889

#define SMB_NTSTATUS_MUI_FILE_NOT_FOUND 3221946369

#define SMB_NTSTATUS_MUI_INVALID_FILE 3221946370

#define SMB_NTSTATUS_MUI_INVALID_RC_CONFIG 3221946371

#define SMB_NTSTATUS_MUI_INVALID_LOCALE_NAME 3221946372

#define SMB_NTSTATUS_MUI_INVALID_ULTIMATEFALLBACK_NAME 3221946373

#define SMB_NTSTATUS_MUI_FILE_NOT_LOADED 3221946374

#define SMB_NTSTATUS_RESOURCE_ENUM_USER_STOP 3221946375

#define SMB_NTSTATUS_CLUSTER_INVALID_NODE 3222470657

#define SMB_NTSTATUS_CLUSTER_NODE_EXISTS 3222470658

#define SMB_NTSTATUS_CLUSTER_JOIN_IN_PROGRESS 3222470659

#define SMB_NTSTATUS_CLUSTER_NODE_NOT_FOUND 3222470660

#define SMB_NTSTATUS_CLUSTER_LOCAL_NODE_NOT_FOUND 3222470661

#define SMB_NTSTATUS_CLUSTER_NETWORK_EXISTS 3222470662

#define SMB_NTSTATUS_CLUSTER_NETWORK_NOT_FOUND 3222470663

#define SMB_NTSTATUS_CLUSTER_NETINTERFACE_EXISTS 3222470664

#define SMB_NTSTATUS_CLUSTER_NETINTERFACE_NOT_FOUND 3222470665

#define SMB_NTSTATUS_CLUSTER_INVALID_REQUEST 3222470666

#define SMB_NTSTATUS_CLUSTER_INVALID_NETWORK_PROVIDER 3222470667

#define SMB_NTSTATUS_CLUSTER_NODE_DOWN 3222470668

#define SMB_NTSTATUS_CLUSTER_NODE_UNREACHABLE 3222470669

#define SMB_NTSTATUS_CLUSTER_NODE_NOT_MEMBER 3222470670

#define SMB_NTSTATUS_CLUSTER_JOIN_NOT_IN_PROGRESS 3222470671

#define SMB_NTSTATUS_CLUSTER_INVALID_NETWORK 3222470672

#define SMB_NTSTATUS_CLUSTER_NO_NET_ADAPTERS 3222470673

#define SMB_NTSTATUS_CLUSTER_NODE_UP 3222470674

#define SMB_NTSTATUS_CLUSTER_NODE_PAUSED 3222470675

#define SMB_NTSTATUS_CLUSTER_NODE_NOT_PAUSED 3222470676

#define SMB_NTSTATUS_CLUSTER_NO_SECURITY_CONTEXT 3222470677

#define SMB_NTSTATUS_CLUSTER_NETWORK_NOT_INTERNAL 3222470678

#define SMB_NTSTATUS_CLUSTER_POISONED 3222470679

#define SMB_NTSTATUS_ACPI_INVALID_OPCODE 3222536193

#define SMB_NTSTATUS_ACPI_STACK_OVERFLOW 3222536194

#define SMB_NTSTATUS_ACPI_ASSERT_FAILED 3222536195

#define SMB_NTSTATUS_ACPI_INVALID_INDEX 3222536196

#define SMB_NTSTATUS_ACPI_INVALID_ARGUMENT 3222536197

#define SMB_NTSTATUS_ACPI_FATAL 3222536198

#define SMB_NTSTATUS_ACPI_INVALID_SUPERNAME 3222536199

#define SMB_NTSTATUS_ACPI_INVALID_ARGTYPE 3222536200

#define SMB_NTSTATUS_ACPI_INVALID_OBJTYPE 3222536201

#define SMB_NTSTATUS_ACPI_INVALID_TARGETTYPE 3222536202

#define SMB_NTSTATUS_ACPI_INCORRECT_ARGUMENT_COUNT 3222536203

#define SMB_NTSTATUS_ACPI_ADDRESS_NOT_MAPPED 3222536204

#define SMB_NTSTATUS_ACPI_INVALID_EVENTTYPE 3222536205

#define SMB_NTSTATUS_ACPI_HANDLER_COLLISION 3222536206

#define SMB_NTSTATUS_ACPI_INVALID_DATA 3222536207

#define SMB_NTSTATUS_ACPI_INVALID_REGION 3222536208

#define SMB_NTSTATUS_ACPI_INVALID_ACCESS_SIZE 3222536209

#define SMB_NTSTATUS_ACPI_ACQUIRE_GLOBAL_LOCK 3222536210

#define SMB_NTSTATUS_ACPI_ALREADY_INITIALIZED 3222536211

#define SMB_NTSTATUS_ACPI_NOT_INITIALIZED 3222536212

#define SMB_NTSTATUS_ACPI_INVALID_MUTEX_LEVEL 3222536213

#define SMB_NTSTATUS_ACPI_MUTEX_NOT_OWNED 3222536214

#define SMB_NTSTATUS_ACPI_MUTEX_NOT_OWNER 3222536215

#define SMB_NTSTATUS_ACPI_RS_ACCESS 3222536216

#define SMB_NTSTATUS_ACPI_INVALID_TABLE 3222536217

#define SMB_NTSTATUS_ACPI_REG_HANDLER_FAILED 3222536224

#define SMB_NTSTATUS_ACPI_POWER_REQUEST_FAILED 3222536225

#define SMB_NTSTATUS_SXS_SECTION_NOT_FOUND 3222601729

#define SMB_NTSTATUS_SXS_CANT_GEN_ACTCTX 3222601730

#define SMB_NTSTATUS_SXS_INVALID_ACTCTXDATA_FORMAT 3222601731

#define SMB_NTSTATUS_SXS_ASSEMBLY_NOT_FOUND 3222601732

#define SMB_NTSTATUS_SXS_MANIFEST_FORMAT_ERROR 3222601733

#define SMB_NTSTATUS_SXS_MANIFEST_PARSE_ERROR 3222601734

#define SMB_NTSTATUS_SXS_ACTIVATION_CONTEXT_DISABLED 3222601735

#define SMB_NTSTATUS_SXS_KEY_NOT_FOUND 3222601736

#define SMB_NTSTATUS_SXS_VERSION_CONFLICT 3222601737

#define SMB_NTSTATUS_SXS_WRONG_SECTION_TYPE 3222601738

#define SMB_NTSTATUS_SXS_THREAD_QUERIES_DISABLED 3222601739

#define SMB_NTSTATUS_SXS_ASSEMBLY_MISSING 3222601740

#define SMB_NTSTATUS_SXS_PROCESS_DEFAULT_ALREADY_SET 3222601742

#define SMB_NTSTATUS_SXS_EARLY_DEACTIVATION 3222601743

#define SMB_NTSTATUS_SXS_INVALID_DEACTIVATION 3222601744

#define SMB_NTSTATUS_SXS_MULTIPLE_DEACTIVATION 3222601745

#define SMB_NTSTATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY 3222601746

#define SMB_NTSTATUS_SXS_PROCESS_TERMINATION_REQUESTED 3222601747

#define SMB_NTSTATUS_SXS_CORRUPT_ACTIVATION_STACK 3222601748

#define SMB_NTSTATUS_SXS_CORRUPTION 3222601749

#define SMB_NTSTATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE 3222601750

#define SMB_NTSTATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME 3222601751

#define SMB_NTSTATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE 3222601752

#define SMB_NTSTATUS_SXS_IDENTITY_PARSE_ERROR 3222601753

#define SMB_NTSTATUS_SXS_COMPONENT_STORE_CORRUPT 3222601754

#define SMB_NTSTATUS_SXS_FILE_HASH_MISMATCH 3222601755

#define SMB_NTSTATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT 3222601756

#define SMB_NTSTATUS_SXS_IDENTITIES_DIFFERENT 3222601757

#define SMB_NTSTATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT 3222601758

#define SMB_NTSTATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY 3222601759

#define SMB_NTSTATUS_ADVANCED_INSTALLER_FAILED 3222601760

#define SMB_NTSTATUS_XML_ENCODING_MISMATCH 3222601761

#define SMB_NTSTATUS_SXS_MANIFEST_TOO_BIG 3222601762

#define SMB_NTSTATUS_SXS_SETTING_NOT_REGISTERED 3222601763

#define SMB_NTSTATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE 3222601764

#define SMB_NTSTATUS_SMI_PRIMITIVE_INSTALLER_FAILED 3222601765

#define SMB_NTSTATUS_GENERIC_COMMAND_FAILED 3222601766

#define SMB_NTSTATUS_SXS_FILE_HASH_MISSING 3222601767

#define SMB_NTSTATUS_TRANSACTIONAL_CONFLICT 3222863873

#define SMB_NTSTATUS_INVALID_TRANSACTION 3222863874

#define SMB_NTSTATUS_TRANSACTION_NOT_ACTIVE 3222863875

#define SMB_NTSTATUS_TM_INITIALIZATION_FAILED 3222863876

#define SMB_NTSTATUS_RM_NOT_ACTIVE 3222863877

#define SMB_NTSTATUS_RM_METADATA_CORRUPT 3222863878

#define SMB_NTSTATUS_TRANSACTION_NOT_JOINED 3222863879

#define SMB_NTSTATUS_DIRECTORY_NOT_RM 3222863880

#define SMB_NTSTATUS_TRANSACTIONS_UNSUPPORTED_REMOTE 3222863882

#define SMB_NTSTATUS_LOG_RESIZE_INVALID_SIZE 3222863883

#define SMB_NTSTATUS_REMOTE_FILE_VERSION_MISMATCH 3222863884

#define SMB_NTSTATUS_CRM_PROTOCOL_ALREADY_EXISTS 3222863887

#define SMB_NTSTATUS_TRANSACTION_PROPAGATION_FAILED 3222863888

#define SMB_NTSTATUS_CRM_PROTOCOL_NOT_FOUND 3222863889

#define SMB_NTSTATUS_TRANSACTION_SUPERIOR_EXISTS 3222863890

#define SMB_NTSTATUS_TRANSACTION_REQUEST_NOT_VALID 3222863891

#define SMB_NTSTATUS_TRANSACTION_NOT_REQUESTED 3222863892

#define SMB_NTSTATUS_TRANSACTION_ALREADY_ABORTED 3222863893

#define SMB_NTSTATUS_TRANSACTION_ALREADY_COMMITTED 3222863894

#define SMB_NTSTATUS_TRANSACTION_INVALID_MARSHALL_BUFFER 3222863895

#define SMB_NTSTATUS_CURRENT_TRANSACTION_NOT_VALID 3222863896

#define SMB_NTSTATUS_LOG_GROWTH_FAILED 3222863897

#define SMB_NTSTATUS_OBJECT_NO_LONGER_EXISTS 3222863905

#define SMB_NTSTATUS_STREAM_MINIVERSION_NOT_FOUND 3222863906

#define SMB_NTSTATUS_STREAM_MINIVERSION_NOT_VALID 3222863907

#define SMB_NTSTATUS_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION 3222863908

#define SMB_NTSTATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT 3222863909

#define SMB_NTSTATUS_CANT_CREATE_MORE_STREAM_MINIVERSIONS 3222863910

#define SMB_NTSTATUS_HANDLE_NO_LONGER_VALID 3222863912

#define SMB_NTSTATUS_LOG_CORRUPTION_DETECTED 3222863920

#define SMB_NTSTATUS_RM_DISCONNECTED 3222863922

#define SMB_NTSTATUS_ENLISTMENT_NOT_SUPERIOR 3222863923

#define SMB_NTSTATUS_FILE_IDENTITY_NOT_PERSISTENT 3222863926

#define SMB_NTSTATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY 3222863927

#define SMB_NTSTATUS_CANT_CROSS_RM_BOUNDARY 3222863928

#define SMB_NTSTATUS_TXF_DIR_NOT_EMPTY 3222863929

#define SMB_NTSTATUS_INDOUBT_TRANSACTIONS_EXIST 3222863930

#define SMB_NTSTATUS_TM_VOLATILE 3222863931

#define SMB_NTSTATUS_ROLLBACK_TIMER_EXPIRED 3222863932

#define SMB_NTSTATUS_TXF_ATTRIBUTE_CORRUPT 3222863933

#define SMB_NTSTATUS_EFS_NOT_ALLOWED_IN_TRANSACTION 3222863934

#define SMB_NTSTATUS_TRANSACTIONAL_OPEN_NOT_ALLOWED 3222863935

#define SMB_NTSTATUS_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE 3222863936

#define SMB_NTSTATUS_TRANSACTION_REQUIRED_PROMOTION 3222863939

#define SMB_NTSTATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION 3222863940

#define SMB_NTSTATUS_TRANSACTIONS_NOT_FROZEN 3222863941

#define SMB_NTSTATUS_TRANSACTION_FREEZE_IN_PROGRESS 3222863942

#define SMB_NTSTATUS_NOT_SNAPSHOT_VOLUME 3222863943

#define SMB_NTSTATUS_NO_SAVEPOINT_WITH_OPEN_FILES 3222863944

#define SMB_NTSTATUS_SPARSE_NOT_ALLOWED_IN_TRANSACTION 3222863945

#define SMB_NTSTATUS_TM_IDENTITY_MISMATCH 3222863946

#define SMB_NTSTATUS_FLOATED_SECTION 3222863947

#define SMB_NTSTATUS_CANNOT_ACCEPT_TRANSACTED_WORK 3222863948

#define SMB_NTSTATUS_CANNOT_ABORT_TRANSACTIONS 3222863949

#define SMB_NTSTATUS_TRANSACTION_NOT_FOUND 3222863950

#define SMB_NTSTATUS_RESOURCEMANAGER_NOT_FOUND 3222863951

#define SMB_NTSTATUS_ENLISTMENT_NOT_FOUND 3222863952

#define SMB_NTSTATUS_TRANSACTIONMANAGER_NOT_FOUND 3222863953

#define SMB_NTSTATUS_TRANSACTIONMANAGER_NOT_ONLINE 3222863954

#define SMB_NTSTATUS_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION 3222863955

#define SMB_NTSTATUS_TRANSACTION_NOT_ROOT 3222863956

#define SMB_NTSTATUS_TRANSACTION_OBJECT_EXPIRED 3222863957

#define SMB_NTSTATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION 3222863958

#define SMB_NTSTATUS_TRANSACTION_RESPONSE_NOT_ENLISTED 3222863959

#define SMB_NTSTATUS_TRANSACTION_RECORD_TOO_LONG 3222863960

#define SMB_NTSTATUS_NO_LINK_TRACKING_IN_TRANSACTION 3222863961

#define SMB_NTSTATUS_OPERATION_NOT_SUPPORTED_IN_TRANSACTION 3222863962

#define SMB_NTSTATUS_TRANSACTION_INTEGRITY_VIOLATED 3222863963

#define SMB_NTSTATUS_EXPIRED_HANDLE 3222863968

#define SMB_NTSTATUS_TRANSACTION_NOT_ENLISTED 3222863969

#define SMB_NTSTATUS_LOG_SECTOR_INVALID 3222929409

#define SMB_NTSTATUS_LOG_SECTOR_PARITY_INVALID 3222929410

#define SMB_NTSTATUS_LOG_SECTOR_REMAPPED 3222929411

#define SMB_NTSTATUS_LOG_BLOCK_INCOMPLETE 3222929412

#define SMB_NTSTATUS_LOG_INVALID_RANGE 3222929413

#define SMB_NTSTATUS_LOG_BLOCKS_EXHAUSTED 3222929414

#define SMB_NTSTATUS_LOG_READ_CONTEXT_INVALID 3222929415

#define SMB_NTSTATUS_LOG_RESTART_INVALID 3222929416

#define SMB_NTSTATUS_LOG_BLOCK_VERSION 3222929417

#define SMB_NTSTATUS_LOG_BLOCK_INVALID 3222929418

#define SMB_NTSTATUS_LOG_READ_MODE_INVALID 3222929419

#define SMB_NTSTATUS_LOG_METADATA_CORRUPT 3222929421

#define SMB_NTSTATUS_LOG_METADATA_INVALID 3222929422

#define SMB_NTSTATUS_LOG_METADATA_INCONSISTENT 3222929423

#define SMB_NTSTATUS_LOG_RESERVATION_INVALID 3222929424

#define SMB_NTSTATUS_LOG_CANT_DELETE 3222929425

#define SMB_NTSTATUS_LOG_CONTAINER_LIMIT_EXCEEDED 3222929426

#define SMB_NTSTATUS_LOG_START_OF_LOG 3222929427

#define SMB_NTSTATUS_LOG_POLICY_ALREADY_INSTALLED 3222929428

#define SMB_NTSTATUS_LOG_POLICY_NOT_INSTALLED 3222929429

#define SMB_NTSTATUS_LOG_POLICY_INVALID 3222929430

#define SMB_NTSTATUS_LOG_POLICY_CONFLICT 3222929431

#define SMB_NTSTATUS_LOG_PINNED_ARCHIVE_TAIL 3222929432

#define SMB_NTSTATUS_LOG_RECORD_NONEXISTENT 3222929433

#define SMB_NTSTATUS_LOG_RECORDS_RESERVED_INVALID 3222929434

#define SMB_NTSTATUS_LOG_SPACE_RESERVED_INVALID 3222929435

#define SMB_NTSTATUS_LOG_TAIL_INVALID 3222929436

#define SMB_NTSTATUS_LOG_FULL 3222929437

#define SMB_NTSTATUS_LOG_MULTIPLEXED 3222929438

#define SMB_NTSTATUS_LOG_DEDICATED 3222929439

#define SMB_NTSTATUS_LOG_ARCHIVE_NOT_IN_PROGRESS 3222929440

#define SMB_NTSTATUS_LOG_ARCHIVE_IN_PROGRESS 3222929441

#define SMB_NTSTATUS_LOG_EPHEMERAL 3222929442

#define SMB_NTSTATUS_LOG_NOT_ENOUGH_CONTAINERS 3222929443

#define SMB_NTSTATUS_LOG_CLIENT_ALREADY_REGISTERED 3222929444

#define SMB_NTSTATUS_LOG_CLIENT_NOT_REGISTERED 3222929445

#define SMB_NTSTATUS_LOG_FULL_HANDLER_IN_PROGRESS 3222929446

#define SMB_NTSTATUS_LOG_CONTAINER_READ_FAILED 3222929447

#define SMB_NTSTATUS_LOG_CONTAINER_WRITE_FAILED 3222929448

#define SMB_NTSTATUS_LOG_CONTAINER_OPEN_FAILED 3222929449

#define SMB_NTSTATUS_LOG_CONTAINER_STATE_INVALID 3222929450

#define SMB_NTSTATUS_LOG_STATE_INVALID 3222929451

#define SMB_NTSTATUS_LOG_PINNED 3222929452

#define SMB_NTSTATUS_LOG_METADATA_FLUSH_FAILED 3222929453

#define SMB_NTSTATUS_LOG_INCONSISTENT_SECURITY 3222929454

#define SMB_NTSTATUS_LOG_APPENDED_FLUSH_FAILED 3222929455

#define SMB_NTSTATUS_LOG_PINNED_RESERVATION 3222929456

#define SMB_NTSTATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD 3222995178

#define SMB_NTSTATUS_FLT_NO_HANDLER_DEFINED 3223060481

#define SMB_NTSTATUS_FLT_CONTEXT_ALREADY_DEFINED 3223060482

#define SMB_NTSTATUS_FLT_INVALID_ASYNCHRONOUS_REQUEST 3223060483

#define SMB_NTSTATUS_FLT_DISALLOW_FAST_IO 3223060484

#define SMB_NTSTATUS_FLT_INVALID_NAME_REQUEST 3223060485

#define SMB_NTSTATUS_FLT_NOT_SAFE_TO_POST_OPERATION 3223060486

#define SMB_NTSTATUS_FLT_NOT_INITIALIZED 3223060487

#define SMB_NTSTATUS_FLT_FILTER_NOT_READY 3223060488

#define SMB_NTSTATUS_FLT_POST_OPERATION_CLEANUP 3223060489

#define SMB_NTSTATUS_FLT_INTERNAL_ERROR 3223060490

#define SMB_NTSTATUS_FLT_DELETING_OBJECT 3223060491

#define SMB_NTSTATUS_FLT_MUST_BE_NONPAGED_POOL 3223060492

#define SMB_NTSTATUS_FLT_DUPLICATE_ENTRY 3223060493

#define SMB_NTSTATUS_FLT_CBDQ_DISABLED 3223060494

#define SMB_NTSTATUS_FLT_DO_NOT_ATTACH 3223060495

#define SMB_NTSTATUS_FLT_DO_NOT_DETACH 3223060496

#define SMB_NTSTATUS_FLT_INSTANCE_ALTITUDE_COLLISION 3223060497

#define SMB_NTSTATUS_FLT_INSTANCE_NAME_COLLISION 3223060498

#define SMB_NTSTATUS_FLT_FILTER_NOT_FOUND 3223060499

#define SMB_NTSTATUS_FLT_VOLUME_NOT_FOUND 3223060500

#define SMB_NTSTATUS_FLT_INSTANCE_NOT_FOUND 3223060501

#define SMB_NTSTATUS_FLT_CONTEXT_ALLOCATION_NOT_FOUND 3223060502

#define SMB_NTSTATUS_FLT_INVALID_CONTEXT_REGISTRATION 3223060503

#define SMB_NTSTATUS_FLT_NAME_CACHE_MISS 3223060504

#define SMB_NTSTATUS_FLT_NO_DEVICE_OBJECT 3223060505

#define SMB_NTSTATUS_FLT_VOLUME_ALREADY_MOUNTED 3223060506

#define SMB_NTSTATUS_FLT_ALREADY_ENLISTED 3223060507

#define SMB_NTSTATUS_FLT_CONTEXT_ALREADY_LINKED 3223060508

#define SMB_NTSTATUS_FLT_NO_WAITER_FOR_REPLY 3223060512

#define SMB_NTSTATUS_MONITOR_NO_DESCRIPTOR 3223126017

#define SMB_NTSTATUS_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT 3223126018

#define SMB_NTSTATUS_MONITOR_INVALID_DESCRIPTOR_CHECKSUM 3223126019

#define SMB_NTSTATUS_MONITOR_INVALID_STANDARD_TIMING_BLOCK 3223126020

#define SMB_NTSTATUS_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED 3223126021

#define SMB_NTSTATUS_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK 3223126022

#define SMB_NTSTATUS_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK 3223126023

#define SMB_NTSTATUS_MONITOR_NO_MORE_DESCRIPTOR_DATA 3223126024

#define SMB_NTSTATUS_MONITOR_INVALID_DETAILED_TIMING_BLOCK 3223126025

#define SMB_NTSTATUS_MONITOR_INVALID_MANUFACTURE_DATE 3223126026

#define SMB_NTSTATUS_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER 3223191552

#define SMB_NTSTATUS_GRAPHICS_INSUFFICIENT_DMA_BUFFER 3223191553

#define SMB_NTSTATUS_GRAPHICS_INVALID_DISPLAY_ADAPTER 3223191554

#define SMB_NTSTATUS_GRAPHICS_ADAPTER_WAS_RESET 3223191555

#define SMB_NTSTATUS_GRAPHICS_INVALID_DRIVER_MODEL 3223191556

#define SMB_NTSTATUS_GRAPHICS_PRESENT_MODE_CHANGED 3223191557

#define SMB_NTSTATUS_GRAPHICS_PRESENT_OCCLUDED 3223191558

#define SMB_NTSTATUS_GRAPHICS_PRESENT_DENIED 3223191559

#define SMB_NTSTATUS_GRAPHICS_CANNOTCOLORCONVERT 3223191560

#define SMB_NTSTATUS_GRAPHICS_PRESENT_REDIRECTION_DISABLED 3223191563

#define SMB_NTSTATUS_GRAPHICS_PRESENT_UNOCCLUDED 3223191564

#define SMB_NTSTATUS_GRAPHICS_NO_VIDEO_MEMORY 3223191808

#define SMB_NTSTATUS_GRAPHICS_CANT_LOCK_MEMORY 3223191809

#define SMB_NTSTATUS_GRAPHICS_ALLOCATION_BUSY 3223191810

#define SMB_NTSTATUS_GRAPHICS_TOO_MANY_REFERENCES 3223191811

#define SMB_NTSTATUS_GRAPHICS_TRY_AGAIN_LATER 3223191812

#define SMB_NTSTATUS_GRAPHICS_TRY_AGAIN_NOW 3223191813

#define SMB_NTSTATUS_GRAPHICS_ALLOCATION_INVALID 3223191814

#define SMB_NTSTATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE 3223191815

#define SMB_NTSTATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED 3223191816

#define SMB_NTSTATUS_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION 3223191817

#define SMB_NTSTATUS_GRAPHICS_INVALID_ALLOCATION_USAGE 3223191824

#define SMB_NTSTATUS_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION 3223191825

#define SMB_NTSTATUS_GRAPHICS_ALLOCATION_CLOSED 3223191826

#define SMB_NTSTATUS_GRAPHICS_INVALID_ALLOCATION_INSTANCE 3223191827

#define SMB_NTSTATUS_GRAPHICS_INVALID_ALLOCATION_HANDLE 3223191828

#define SMB_NTSTATUS_GRAPHICS_WRONG_ALLOCATION_DEVICE 3223191829

#define SMB_NTSTATUS_GRAPHICS_ALLOCATION_CONTENT_LOST 3223191830

#define SMB_NTSTATUS_GRAPHICS_GPU_EXCEPTION_ON_DEVICE 3223192064

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY 3223192320

#define SMB_NTSTATUS_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED 3223192321

#define SMB_NTSTATUS_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED 3223192322

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDPN 3223192323

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE 3223192324

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET 3223192325

#define SMB_NTSTATUS_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED 3223192326

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDPN_SOURCEMODESET 3223192328

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDPN_TARGETMODESET 3223192329

#define SMB_NTSTATUS_GRAPHICS_INVALID_FREQUENCY 3223192330

#define SMB_NTSTATUS_GRAPHICS_INVALID_ACTIVE_REGION 3223192331

#define SMB_NTSTATUS_GRAPHICS_INVALID_TOTAL_REGION 3223192332

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE 3223192336

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE 3223192337

#define SMB_NTSTATUS_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET 3223192338

#define SMB_NTSTATUS_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY 3223192339

#define SMB_NTSTATUS_GRAPHICS_MODE_ALREADY_IN_MODESET 3223192340

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET 3223192341

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET 3223192342

#define SMB_NTSTATUS_GRAPHICS_SOURCE_ALREADY_IN_SET 3223192343

#define SMB_NTSTATUS_GRAPHICS_TARGET_ALREADY_IN_SET 3223192344

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDPN_PRESENT_PATH 3223192345

#define SMB_NTSTATUS_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY 3223192346

#define SMB_NTSTATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET 3223192347

#define SMB_NTSTATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE 3223192348

#define SMB_NTSTATUS_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET 3223192349

#define SMB_NTSTATUS_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET 3223192351

#define SMB_NTSTATUS_GRAPHICS_STALE_MODESET 3223192352

#define SMB_NTSTATUS_GRAPHICS_INVALID_MONITOR_SOURCEMODESET 3223192353

#define SMB_NTSTATUS_GRAPHICS_INVALID_MONITOR_SOURCE_MODE 3223192354

#define SMB_NTSTATUS_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN 3223192355

#define SMB_NTSTATUS_GRAPHICS_MODE_ID_MUST_BE_UNIQUE 3223192356

#define SMB_NTSTATUS_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION 3223192357

#define SMB_NTSTATUS_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES 3223192358

#define SMB_NTSTATUS_GRAPHICS_PATH_NOT_IN_TOPOLOGY 3223192359

#define SMB_NTSTATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE 3223192360

#define SMB_NTSTATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET 3223192361

#define SMB_NTSTATUS_GRAPHICS_INVALID_MONITORDESCRIPTORSET 3223192362

#define SMB_NTSTATUS_GRAPHICS_INVALID_MONITORDESCRIPTOR 3223192363

#define SMB_NTSTATUS_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET 3223192364

#define SMB_NTSTATUS_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET 3223192365

#define SMB_NTSTATUS_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE 3223192366

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE 3223192367

#define SMB_NTSTATUS_GRAPHICS_RESOURCES_NOT_RELATED 3223192368

#define SMB_NTSTATUS_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE 3223192369

#define SMB_NTSTATUS_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE 3223192370

#define SMB_NTSTATUS_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET 3223192371

#define SMB_NTSTATUS_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER 3223192372

#define SMB_NTSTATUS_GRAPHICS_NO_VIDPNMGR 3223192373

#define SMB_NTSTATUS_GRAPHICS_NO_ACTIVE_VIDPN 3223192374

#define SMB_NTSTATUS_GRAPHICS_STALE_VIDPN_TOPOLOGY 3223192375

#define SMB_NTSTATUS_GRAPHICS_MONITOR_NOT_CONNECTED 3223192376

#define SMB_NTSTATUS_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY 3223192377

#define SMB_NTSTATUS_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE 3223192378

#define SMB_NTSTATUS_GRAPHICS_INVALID_VISIBLEREGION_SIZE 3223192379

#define SMB_NTSTATUS_GRAPHICS_INVALID_STRIDE 3223192380

#define SMB_NTSTATUS_GRAPHICS_INVALID_PIXELFORMAT 3223192381

#define SMB_NTSTATUS_GRAPHICS_INVALID_COLORBASIS 3223192382

#define SMB_NTSTATUS_GRAPHICS_INVALID_PIXELVALUEACCESSMODE 3223192383

#define SMB_NTSTATUS_GRAPHICS_TARGET_NOT_IN_TOPOLOGY 3223192384

#define SMB_NTSTATUS_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT 3223192385

#define SMB_NTSTATUS_GRAPHICS_VIDPN_SOURCE_IN_USE 3223192386

#define SMB_NTSTATUS_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN 3223192387

#define SMB_NTSTATUS_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL 3223192388

#define SMB_NTSTATUS_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION 3223192389

#define SMB_NTSTATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED 3223192390

#define SMB_NTSTATUS_GRAPHICS_INVALID_GAMMA_RAMP 3223192391

#define SMB_NTSTATUS_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED 3223192392

#define SMB_NTSTATUS_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED 3223192393

#define SMB_NTSTATUS_GRAPHICS_MODE_NOT_IN_MODESET 3223192394

#define SMB_NTSTATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON 3223192397

#define SMB_NTSTATUS_GRAPHICS_INVALID_PATH_CONTENT_TYPE 3223192398

#define SMB_NTSTATUS_GRAPHICS_INVALID_COPYPROTECTION_TYPE 3223192399

#define SMB_NTSTATUS_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS 3223192400

#define SMB_NTSTATUS_GRAPHICS_INVALID_SCANLINE_ORDERING 3223192402

#define SMB_NTSTATUS_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED 3223192403

#define SMB_NTSTATUS_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS 3223192404

#define SMB_NTSTATUS_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT 3223192405

#define SMB_NTSTATUS_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM 3223192406

#define SMB_NTSTATUS_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN 3223192407

#define SMB_NTSTATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT 3223192408

#define SMB_NTSTATUS_GRAPHICS_MAX_NUM_PATHS_REACHED 3223192409

#define SMB_NTSTATUS_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION 3223192410

#define SMB_NTSTATUS_GRAPHICS_INVALID_CLIENT_TYPE 3223192411

#define SMB_NTSTATUS_GRAPHICS_CLIENTVIDPN_NOT_SET 3223192412

#define SMB_NTSTATUS_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED 3223192576

#define SMB_NTSTATUS_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED 3223192577

#define SMB_NTSTATUS_GRAPHICS_NOT_A_LINKED_ADAPTER 3223192624

#define SMB_NTSTATUS_GRAPHICS_LEADLINK_NOT_ENUMERATED 3223192625

#define SMB_NTSTATUS_GRAPHICS_CHAINLINKS_NOT_ENUMERATED 3223192626

#define SMB_NTSTATUS_GRAPHICS_ADAPTER_CHAIN_NOT_READY 3223192627

#define SMB_NTSTATUS_GRAPHICS_CHAINLINKS_NOT_STARTED 3223192628

#define SMB_NTSTATUS_GRAPHICS_CHAINLINKS_NOT_POWERED_ON 3223192629

#define SMB_NTSTATUS_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE 3223192630

#define SMB_NTSTATUS_GRAPHICS_NOT_POST_DEVICE_DRIVER 3223192632

#define SMB_NTSTATUS_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED 3223192635

#define SMB_NTSTATUS_GRAPHICS_OPM_NOT_SUPPORTED 3223192832

#define SMB_NTSTATUS_GRAPHICS_COPP_NOT_SUPPORTED 3223192833

#define SMB_NTSTATUS_GRAPHICS_UAB_NOT_SUPPORTED 3223192834

#define SMB_NTSTATUS_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS 3223192835

#define SMB_NTSTATUS_GRAPHICS_OPM_PARAMETER_ARRAY_TOO_SMALL 3223192836

#define SMB_NTSTATUS_GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST 3223192837

#define SMB_NTSTATUS_GRAPHICS_PVP_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME 3223192838

#define SMB_NTSTATUS_GRAPHICS_PVP_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP 3223192839

#define SMB_NTSTATUS_GRAPHICS_PVP_MIRRORING_DEVICES_NOT_SUPPORTED 3223192840

#define SMB_NTSTATUS_GRAPHICS_OPM_INVALID_POINTER 3223192842

#define SMB_NTSTATUS_GRAPHICS_OPM_INTERNAL_ERROR 3223192843

#define SMB_NTSTATUS_GRAPHICS_OPM_INVALID_HANDLE 3223192844

#define SMB_NTSTATUS_GRAPHICS_PVP_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE 3223192845

#define SMB_NTSTATUS_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH 3223192846

#define SMB_NTSTATUS_GRAPHICS_OPM_SPANNING_MODE_ENABLED 3223192847

#define SMB_NTSTATUS_GRAPHICS_OPM_THEATER_MODE_ENABLED 3223192848

#define SMB_NTSTATUS_GRAPHICS_PVP_HFS_FAILED 3223192849

#define SMB_NTSTATUS_GRAPHICS_OPM_INVALID_SRM 3223192850

#define SMB_NTSTATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP 3223192851

#define SMB_NTSTATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP 3223192852

#define SMB_NTSTATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA 3223192853

#define SMB_NTSTATUS_GRAPHICS_OPM_HDCP_SRM_NEVER_SET 3223192854

#define SMB_NTSTATUS_GRAPHICS_OPM_RESOLUTION_TOO_HIGH 3223192855

#define SMB_NTSTATUS_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE 3223192856

#define SMB_NTSTATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS 3223192858

#define SMB_NTSTATUS_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS 3223192859

#define SMB_NTSTATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS 3223192860

#define SMB_NTSTATUS_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST 3223192861

#define SMB_NTSTATUS_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR 3223192862

#define SMB_NTSTATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS 3223192863

#define SMB_NTSTATUS_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED 3223192864

#define SMB_NTSTATUS_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST 3223192865

#define SMB_NTSTATUS_GRAPHICS_I2C_NOT_SUPPORTED 3223192960

#define SMB_NTSTATUS_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST 3223192961

#define SMB_NTSTATUS_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA 3223192962

#define SMB_NTSTATUS_GRAPHICS_I2C_ERROR_RECEIVING_DATA 3223192963

#define SMB_NTSTATUS_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED 3223192964

#define SMB_NTSTATUS_GRAPHICS_DDCCI_INVALID_DATA 3223192965

#define SMB_NTSTATUS_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE 3223192966

#define SMB_NTSTATUS_GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING 3223192967

#define SMB_NTSTATUS_GRAPHICS_MCA_INTERNAL_ERROR 3223192968

#define SMB_NTSTATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND 3223192969

#define SMB_NTSTATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH 3223192970

#define SMB_NTSTATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM 3223192971

#define SMB_NTSTATUS_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE 3223192972

#define SMB_NTSTATUS_GRAPHICS_MONITOR_NO_LONGER_EXISTS 3223192973

#define SMB_NTSTATUS_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED 3223193056

#define SMB_NTSTATUS_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME 3223193057

#define SMB_NTSTATUS_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP 3223193058

#define SMB_NTSTATUS_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED 3223193059

#define SMB_NTSTATUS_GRAPHICS_INVALID_POINTER 3223193060

#define SMB_NTSTATUS_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE 3223193061

#define SMB_NTSTATUS_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL 3223193062

#define SMB_NTSTATUS_GRAPHICS_INTERNAL_ERROR 3223193063

#define SMB_NTSTATUS_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS 3223193064

#define SMB_NTSTATUS_FVE_LOCKED_VOLUME 3223388160

#define SMB_NTSTATUS_FVE_NOT_ENCRYPTED 3223388161

#define SMB_NTSTATUS_FVE_BAD_INFORMATION 3223388162

#define SMB_NTSTATUS_FVE_TOO_SMALL 3223388163

#define SMB_NTSTATUS_FVE_FAILED_WRONG_FS 3223388164

#define SMB_NTSTATUS_FVE_FAILED_BAD_FS 3223388165

#define SMB_NTSTATUS_FVE_FS_NOT_EXTENDED 3223388166

#define SMB_NTSTATUS_FVE_FS_MOUNTED 3223388167

#define SMB_NTSTATUS_FVE_NO_LICENSE 3223388168

#define SMB_NTSTATUS_FVE_ACTION_NOT_ALLOWED 3223388169

#define SMB_NTSTATUS_FVE_BAD_DATA 3223388170

#define SMB_NTSTATUS_FVE_VOLUME_NOT_BOUND 3223388171

#define SMB_NTSTATUS_FVE_NOT_DATA_VOLUME 3223388172

#define SMB_NTSTATUS_FVE_CONV_READ_ERROR 3223388173

#define SMB_NTSTATUS_FVE_CONV_WRITE_ERROR 3223388174

#define SMB_NTSTATUS_FVE_OVERLAPPED_UPDATE 3223388175

#define SMB_NTSTATUS_FVE_FAILED_SECTOR_SIZE 3223388176

#define SMB_NTSTATUS_FVE_FAILED_AUTHENTICATION 3223388177

#define SMB_NTSTATUS_FVE_NOT_OS_VOLUME 3223388178

#define SMB_NTSTATUS_FVE_KEYFILE_NOT_FOUND 3223388179

#define SMB_NTSTATUS_FVE_KEYFILE_INVALID 3223388180

#define SMB_NTSTATUS_FVE_KEYFILE_NO_VMK 3223388181

#define SMB_NTSTATUS_FVE_TPM_DISABLED 3223388182

#define SMB_NTSTATUS_FVE_TPM_SRK_AUTH_NOT_ZERO 3223388183

#define SMB_NTSTATUS_FVE_TPM_INVALID_PCR 3223388184

#define SMB_NTSTATUS_FVE_TPM_NO_VMK 3223388185

#define SMB_NTSTATUS_FVE_PIN_INVALID 3223388186

#define SMB_NTSTATUS_FVE_AUTH_INVALID_APPLICATION 3223388187

#define SMB_NTSTATUS_FVE_AUTH_INVALID_CONFIG 3223388188

#define SMB_NTSTATUS_FVE_DEBUGGER_ENABLED 3223388189

#define SMB_NTSTATUS_FVE_DRY_RUN_FAILED 3223388190

#define SMB_NTSTATUS_FVE_BAD_METADATA_POINTER 3223388191

#define SMB_NTSTATUS_FVE_OLD_METADATA_COPY 3223388192

#define SMB_NTSTATUS_FVE_REBOOT_REQUIRED 3223388193

#define SMB_NTSTATUS_FVE_RAW_ACCESS 3223388194

#define SMB_NTSTATUS_FVE_RAW_BLOCKED 3223388195

#define SMB_NTSTATUS_FVE_NO_FEATURE_LICENSE 3223388198

#define SMB_NTSTATUS_FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED 3223388199

#define SMB_NTSTATUS_FVE_CONV_RECOVERY_FAILED 3223388200

#define SMB_NTSTATUS_FVE_VIRTUALIZED_SPACE_TOO_BIG 3223388201

#define SMB_NTSTATUS_FVE_VOLUME_TOO_SMALL 3223388208

#define SMB_NTSTATUS_FWP_CALLOUT_NOT_FOUND 3223453697

#define SMB_NTSTATUS_FWP_CONDITION_NOT_FOUND 3223453698

#define SMB_NTSTATUS_FWP_FILTER_NOT_FOUND 3223453699

#define SMB_NTSTATUS_FWP_LAYER_NOT_FOUND 3223453700

#define SMB_NTSTATUS_FWP_PROVIDER_NOT_FOUND 3223453701

#define SMB_NTSTATUS_FWP_PROVIDER_CONTEXT_NOT_FOUND 3223453702

#define SMB_NTSTATUS_FWP_SUBLAYER_NOT_FOUND 3223453703

#define SMB_NTSTATUS_FWP_NOT_FOUND 3223453704

#define SMB_NTSTATUS_FWP_ALREADY_EXISTS 3223453705

#define SMB_NTSTATUS_FWP_IN_USE 3223453706

#define SMB_NTSTATUS_FWP_DYNAMIC_SESSION_IN_PROGRESS 3223453707

#define SMB_NTSTATUS_FWP_WRONG_SESSION 3223453708

#define SMB_NTSTATUS_FWP_NO_TXN_IN_PROGRESS 3223453709

#define SMB_NTSTATUS_FWP_TXN_IN_PROGRESS 3223453710

#define SMB_NTSTATUS_FWP_TXN_ABORTED 3223453711

#define SMB_NTSTATUS_FWP_SESSION_ABORTED 3223453712

#define SMB_NTSTATUS_FWP_INCOMPATIBLE_TXN 3223453713

#define SMB_NTSTATUS_FWP_TIMEOUT 3223453714

#define SMB_NTSTATUS_FWP_NET_EVENTS_DISABLED 3223453715

#define SMB_NTSTATUS_FWP_INCOMPATIBLE_LAYER 3223453716

#define SMB_NTSTATUS_FWP_KM_CLIENTS_ONLY 3223453717

#define SMB_NTSTATUS_FWP_LIFETIME_MISMATCH 3223453718

#define SMB_NTSTATUS_FWP_BUILTIN_OBJECT 3223453719

#define SMB_NTSTATUS_FWP_TOO_MANY_BOOTTIME_FILTERS 3223453720

#define SMB_NTSTATUS_FWP_NOTIFICATION_DROPPED 3223453721

#define SMB_NTSTATUS_FWP_TRAFFIC_MISMATCH 3223453722

#define SMB_NTSTATUS_FWP_INCOMPATIBLE_SA_STATE 3223453723

#define SMB_NTSTATUS_FWP_NULL_POINTER 3223453724

#define SMB_NTSTATUS_FWP_INVALID_ENUMERATOR 3223453725

#define SMB_NTSTATUS_FWP_INVALID_FLAGS 3223453726

#define SMB_NTSTATUS_FWP_INVALID_NET_MASK 3223453727

#define SMB_NTSTATUS_FWP_INVALID_RANGE 3223453728

#define SMB_NTSTATUS_FWP_INVALID_INTERVAL 3223453729

#define SMB_NTSTATUS_FWP_ZERO_LENGTH_ARRAY 3223453730

#define SMB_NTSTATUS_FWP_NULL_DISPLAY_NAME 3223453731

#define SMB_NTSTATUS_FWP_INVALID_ACTION_TYPE 3223453732

#define SMB_NTSTATUS_FWP_INVALID_WEIGHT 3223453733

#define SMB_NTSTATUS_FWP_MATCH_TYPE_MISMATCH 3223453734

#define SMB_NTSTATUS_FWP_TYPE_MISMATCH 3223453735

#define SMB_NTSTATUS_FWP_OUT_OF_BOUNDS 3223453736

#define SMB_NTSTATUS_FWP_RESERVED 3223453737

#define SMB_NTSTATUS_FWP_DUPLICATE_CONDITION 3223453738

#define SMB_NTSTATUS_FWP_DUPLICATE_KEYMOD 3223453739

#define SMB_NTSTATUS_FWP_ACTION_INCOMPATIBLE_WITH_LAYER 3223453740

#define SMB_NTSTATUS_FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER 3223453741

#define SMB_NTSTATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER 3223453742

#define SMB_NTSTATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT 3223453743

#define SMB_NTSTATUS_FWP_INCOMPATIBLE_AUTH_METHOD 3223453744

#define SMB_NTSTATUS_FWP_INCOMPATIBLE_DH_GROUP 3223453745

#define SMB_NTSTATUS_FWP_EM_NOT_SUPPORTED 3223453746

#define SMB_NTSTATUS_FWP_NEVER_MATCH 3223453747

#define SMB_NTSTATUS_FWP_PROVIDER_CONTEXT_MISMATCH 3223453748

#define SMB_NTSTATUS_FWP_INVALID_PARAMETER 3223453749

#define SMB_NTSTATUS_FWP_TOO_MANY_SUBLAYERS 3223453750

#define SMB_NTSTATUS_FWP_CALLOUT_NOTIFICATION_FAILED 3223453751

#define SMB_NTSTATUS_FWP_INCOMPATIBLE_AUTH_CONFIG 3223453752

#define SMB_NTSTATUS_FWP_INCOMPATIBLE_CIPHER_CONFIG 3223453753

#define SMB_NTSTATUS_FWP_DUPLICATE_AUTH_METHOD 3223453756

#define SMB_NTSTATUS_FWP_TCPIP_NOT_READY 3223453952

#define SMB_NTSTATUS_FWP_INJECT_HANDLE_CLOSING 3223453953

#define SMB_NTSTATUS_FWP_INJECT_HANDLE_STALE 3223453954

#define SMB_NTSTATUS_FWP_CANNOT_PEND 3223453955

#define SMB_NTSTATUS_NDIS_CLOSING 3223519234

#define SMB_NTSTATUS_NDIS_BAD_VERSION 3223519236

#define SMB_NTSTATUS_NDIS_BAD_CHARACTERISTICS 3223519237

#define SMB_NTSTATUS_NDIS_ADAPTER_NOT_FOUND 3223519238

#define SMB_NTSTATUS_NDIS_OPEN_FAILED 3223519239

#define SMB_NTSTATUS_NDIS_DEVICE_FAILED 3223519240

#define SMB_NTSTATUS_NDIS_MULTICAST_FULL 3223519241

#define SMB_NTSTATUS_NDIS_MULTICAST_EXISTS 3223519242

#define SMB_NTSTATUS_NDIS_MULTICAST_NOT_FOUND 3223519243

#define SMB_NTSTATUS_NDIS_REQUEST_ABORTED 3223519244

#define SMB_NTSTATUS_NDIS_RESET_IN_PROGRESS 3223519245

#define SMB_NTSTATUS_NDIS_INVALID_PACKET 3223519247

#define SMB_NTSTATUS_NDIS_INVALID_DEVICE_REQUEST 3223519248

#define SMB_NTSTATUS_NDIS_ADAPTER_NOT_READY 3223519249

#define SMB_NTSTATUS_NDIS_INVALID_LENGTH 3223519252

#define SMB_NTSTATUS_NDIS_INVALID_DATA 3223519253

#define SMB_NTSTATUS_NDIS_BUFFER_TOO_SHORT 3223519254

#define SMB_NTSTATUS_NDIS_INVALID_OID 3223519255

#define SMB_NTSTATUS_NDIS_ADAPTER_REMOVED 3223519256

#define SMB_NTSTATUS_NDIS_UNSUPPORTED_MEDIA 3223519257

#define SMB_NTSTATUS_NDIS_GROUP_ADDRESS_IN_USE 3223519258

#define SMB_NTSTATUS_NDIS_FILE_NOT_FOUND 3223519259

#define SMB_NTSTATUS_NDIS_ERROR_READING_FILE 3223519260

#define SMB_NTSTATUS_NDIS_ALREADY_MAPPED 3223519261

#define SMB_NTSTATUS_NDIS_RESOURCE_CONFLICT 3223519262

#define SMB_NTSTATUS_NDIS_MEDIA_DISCONNECTED 3223519263

#define SMB_NTSTATUS_NDIS_INVALID_ADDRESS 3223519266

#define SMB_NTSTATUS_NDIS_PAUSED 3223519274

#define SMB_NTSTATUS_NDIS_INTERFACE_NOT_FOUND 3223519275

#define SMB_NTSTATUS_NDIS_UNSUPPORTED_REVISION 3223519276

#define SMB_NTSTATUS_NDIS_INVALID_PORT 3223519277

#define SMB_NTSTATUS_NDIS_INVALID_PORT_STATE 3223519278

#define SMB_NTSTATUS_NDIS_LOW_POWER_STATE 3223519279

#define SMB_NTSTATUS_NDIS_NOT_SUPPORTED 3223519419

#define SMB_NTSTATUS_NDIS_OFFLOAD_POLICY 3223523343

#define SMB_NTSTATUS_NDIS_OFFLOAD_CONNECTION_REJECTED 3223523346

#define SMB_NTSTATUS_NDIS_OFFLOAD_PATH_REJECTED 3223523347

#define SMB_NTSTATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED 3223527424

#define SMB_NTSTATUS_NDIS_DOT11_MEDIA_IN_USE 3223527425

#define SMB_NTSTATUS_NDIS_DOT11_POWER_STATE_INVALID 3223527426

#define SMB_NTSTATUS_NDIS_PM_WOL_PATTERN_LIST_FULL 3223527427

#define SMB_NTSTATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL 3223527428

#define SMB_NTSTATUS_IPSEC_BAD_SPI 3224764417

#define SMB_NTSTATUS_IPSEC_SA_LIFETIME_EXPIRED 3224764418

#define SMB_NTSTATUS_IPSEC_WRONG_SA 3224764419

#define SMB_NTSTATUS_IPSEC_REPLAY_CHECK_FAILED 3224764420

#define SMB_NTSTATUS_IPSEC_INVALID_PACKET 3224764421

#define SMB_NTSTATUS_IPSEC_INTEGRITY_CHECK_FAILED 3224764422

#define SMB_NTSTATUS_IPSEC_CLEAR_TEXT_DROP 3224764423

#define SMB_NTSTATUS_IPSEC_AUTH_FIREWALL_DROP 3224764424

#define SMB_NTSTATUS_IPSEC_THROTTLE_DROP 3224764425

#define SMB_NTSTATUS_IPSEC_DOSP_BLOCK 3224797184

#define SMB_NTSTATUS_IPSEC_DOSP_RECEIVED_MULTICAST 3224797185

#define SMB_NTSTATUS_IPSEC_DOSP_INVALID_PACKET 3224797186

#define SMB_NTSTATUS_IPSEC_DOSP_STATE_LOOKUP_FAILED 3224797187

#define SMB_NTSTATUS_IPSEC_DOSP_MAX_ENTRIES 3224797188

#define SMB_NTSTATUS_IPSEC_DOSP_KEYMOD_NOT_ALLOWED 3224797189

#define SMB_NTSTATUS_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES 3224797190

#define SMB_NTSTATUS_VOLMGR_MIRROR_NOT_SUPPORTED 3224895579

#define SMB_NTSTATUS_VOLMGR_RAID5_NOT_SUPPORTED 3224895580

#define SMB_NTSTATUS_VIRTDISK_PROVIDER_NOT_FOUND 3225026580

#define SMB_NTSTATUS_VIRTDISK_NOT_VIRTUAL_DISK 3225026581

#define SMB_NTSTATUS_VHD_PARENT_VHD_ACCESS_DENIED 3225026582

#define SMB_NTSTATUS_VHD_CHILD_PARENT_SIZE_MISMATCH 3225026583

#define SMB_NTSTATUS_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED 3225026584

#define SMB_NTSTATUS_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT 3225026585

#define SMB1_HEADER_SIZE 32

#define NBSS_MSGTYPE_SESSION_MESSAGE 0

#define NBSS_MSGTYPE_SESSION_REQUEST 129

#define NBSS_MSGTYPE_POSITIVE_SSN_RESPONSE 130

#define NBSS_MSGTYPE_NEGATIVE_SSN_RESPONSE 131

#define NBSS_MSGTYPE_RETARG_RESPONSE 132

#define NBSS_MSGTYPE_KEEP_ALIVE 133

#define MIN_REC_SIZE (32 + 4)

#define SMB_CONFIG_DEFAULT_STREAM_DEPTH 0

#define SMB_SRV_ERROR 1

#define SMB_SRV_BADPW 2

#define SMB_SRV_BADTYPE 3

#define SMB_SRV_ACCESS 4

#define SMB_SRV_BADUID 91

#define SMB_DOS_SUCCESS 0

#define SMB_DOS_BAD_FUNC 1

#define SMB_DOS_BAD_FILE 2

#define SMB_DOS_BAD_PATH 3

#define SMB_DOS_TOO_MANY_OPEN_FILES 4

#define SMB_DOS_ACCESS_DENIED 5

#define NTLMSSP_NEGOTIATE 1

#define NTLMSSP_CHALLENGE 2

#define NTLMSSP_AUTH 3

/**
 * type values to make sure we're not mixing things
 * up in hashmap lookups
 */
#define SMBHDR_TYPE_GUID 1

#define SMBHDR_TYPE_SHARE 2

#define SMBHDR_TYPE_FILENAME 3

#define SMBHDR_TYPE_OFFSET 4

#define SMBHDR_TYPE_GENERICTX 5

#define SMBHDR_TYPE_HEADER 6

#define SMBHDR_TYPE_TRANS_FRAG 8

#define SMBHDR_TYPE_TREE 9

#define SMBHDR_TYPE_DCERPCTX 10

#define SMB1_COMMAND_CREATE_DIRECTORY 0

#define SMB1_COMMAND_DELETE_DIRECTORY 1

#define SMB1_COMMAND_OPEN 2

#define SMB1_COMMAND_CREATE 3

#define SMB1_COMMAND_CLOSE 4

#define SMB1_COMMAND_FLUSH 5

#define SMB1_COMMAND_DELETE 6

#define SMB1_COMMAND_RENAME 7

#define SMB1_COMMAND_QUERY_INFORMATION 8

#define SMB1_COMMAND_SET_INFORMATION 9

#define SMB1_COMMAND_READ 10

#define SMB1_COMMAND_WRITE 11

#define SMB1_COMMAND_LOCK_BYTE_RANGE 12

#define SMB1_COMMAND_UNLOCK_BYTE_RANGE 13

#define SMB1_COMMAND_CREATE_TEMPORARY 14

#define SMB1_COMMAND_CREATE_NEW 15

#define SMB1_COMMAND_CHECK_DIRECTORY 16

#define SMB1_COMMAND_PROCESS_EXIT 17

#define SMB1_COMMAND_SEEK 18

#define SMB1_COMMAND_LOCK_AND_READ 19

#define SMB1_COMMAND_WRITE_AND_UNLOCK 20

#define SMB1_COMMAND_LOCKING_ANDX 36

#define SMB1_COMMAND_TRANS 37

#define SMB1_COMMAND_ECHO 43

#define SMB1_COMMAND_WRITE_AND_CLOSE 44

#define SMB1_COMMAND_OPEN_ANDX 45

#define SMB1_COMMAND_READ_ANDX 46

#define SMB1_COMMAND_WRITE_ANDX 47

#define SMB1_COMMAND_TRANS2 50

#define SMB1_COMMAND_TRANS2_SECONDARY 51

#define SMB1_COMMAND_FIND_CLOSE2 52

#define SMB1_COMMAND_TREE_DISCONNECT 113

#define SMB1_COMMAND_NEGOTIATE_PROTOCOL 114

#define SMB1_COMMAND_SESSION_SETUP_ANDX 115

#define SMB1_COMMAND_LOGOFF_ANDX 116

#define SMB1_COMMAND_TREE_CONNECT_ANDX 117

#define SMB1_COMMAND_QUERY_INFO_DISK 128

#define SMB1_COMMAND_NT_TRANS 160

#define SMB1_COMMAND_NT_TRANS_SECONDARY 161

#define SMB1_COMMAND_NT_CREATE_ANDX 162

#define SMB1_COMMAND_NT_CANCEL 164

#define SMB1_COMMAND_NONE 255

#define SMB2_COMMAND_NEGOTIATE_PROTOCOL 0

#define SMB2_COMMAND_SESSION_SETUP 1

#define SMB2_COMMAND_SESSION_LOGOFF 2

#define SMB2_COMMAND_TREE_CONNECT 3

#define SMB2_COMMAND_TREE_DISCONNECT 4

#define SMB2_COMMAND_CREATE 5

#define SMB2_COMMAND_CLOSE 6

#define SMB2_COMMAND_FLUSH 7

#define SMB2_COMMAND_READ 8

#define SMB2_COMMAND_WRITE 9

#define SMB2_COMMAND_LOCK 10

#define SMB2_COMMAND_IOCTL 11

#define SMB2_COMMAND_CANCEL 12

#define SMB2_COMMAND_KEEPALIVE 13

#define SMB2_COMMAND_FIND 14

#define SMB2_COMMAND_CHANGE_NOTIFY 15

#define SMB2_COMMAND_GET_INFO 16

#define SMB2_COMMAND_SET_INFO 17

#define SMB2_COMMAND_OPLOCK_BREAK 18

#define DCERPC_HDR_LEN 16

#define DCERPC_UUID_ENTRY_FLAG_FF 1

#define PFC_FIRST_FRAG 1

#define PFC_LAST_FRAG 2

#define PFC_PENDING_CANCEL 4

#define PFC_RESERVED_1 8

#define PFC_CONC_MPX 16

#define PFC_DID_NOT_EXECUTE 32

#define PFC_MAYBE 64

#define PFC_OBJECT_UUID 128

#define PFCL1_RESERVED_01 1

#define PFCL1_LASTFRAG 2

#define PFCL1_FRAG 4

#define PFCL1_NOFACK 8

#define PFCL1_MAYBE 16

#define PFCL1_IDEMPOTENT 32

#define PFCL1_BROADCAST 64

#define PFCL1_RESERVED_80 128

#define PFCL2_RESERVED_01 1

#define PFCL2_CANCEL_PENDING 2

#define PFCL2_RESERVED_04 4

#define PFCL2_RESERVED_08 8

#define PFCL2_RESERVED_10 16

#define PFCL2_RESERVED_20 32

#define PFCL2_RESERVED_40 64

#define PFCL2_RESERVED_80 128

#define REASON_NOT_SPECIFIED 0

#define TEMPORARY_CONGESTION 1

#define LOCAL_LIMIT_EXCEEDED 2

#define CALLED_PADDR_UNKNOWN 3

#define PROTOCOL_VERSION_NOT_SUPPORTED 4

#define DEFAULT_CONTEXT_NOT_SUPPORTED 5

#define USER_DATA_NOT_READABLE 6

#define NO_PSAP_AVAILABLE 7

#define DCERPC_TYPE_REQUEST 0

#define DCERPC_TYPE_PING 1

#define DCERPC_TYPE_RESPONSE 2

#define DCERPC_TYPE_FAULT 3

#define DCERPC_TYPE_WORKING 4

#define DCERPC_TYPE_NOCALL 5

#define DCERPC_TYPE_REJECT 6

#define DCERPC_TYPE_ACK 7

#define DCERPC_TYPE_CL_CANCEL 8

#define DCERPC_TYPE_FACK 9

#define DCERPC_TYPE_CANCEL_ACK 10

#define DCERPC_TYPE_BIND 11

#define DCERPC_TYPE_BINDACK 12

#define DCERPC_TYPE_BINDNAK 13

#define DCERPC_TYPE_ALTER_CONTEXT 14

#define DCERPC_TYPE_ALTER_CONTEXT_RESP 15

#define DCERPC_TYPE_AUTH3 16

#define DCERPC_TYPE_SHUTDOWN 17

#define DCERPC_TYPE_CO_CANCEL 18

#define DCERPC_TYPE_ORPHANED 19

#define DCERPC_TYPE_RTS 20

#define DCERPC_TYPE_UNKNOWN 99

#define DCERPC_UDP_HDR_LEN 80

#define DETECT_DCE_OPNUM_RANGE_UNINITIALIZED 100000

#define REQUEST_FLOOD 500

#define BOOTP_REQUEST 1

#define BOOTP_REPLY 2

#define DHCP_OPT_SUBNET_MASK 1

#define DHCP_OPT_ROUTERS 3

#define DHCP_OPT_DNS_SERVER 6

#define DHCP_OPT_HOSTNAME 12

#define DHCP_OPT_REQUESTED_IP 50

#define DHCP_OPT_ADDRESS_TIME 51

#define DHCP_OPT_TYPE 53

#define DHCP_OPT_PARAMETER_LIST 55

#define DHCP_OPT_RENEWAL_TIME 58

#define DHCP_OPT_REBINDING_TIME 59

#define DHCP_OPT_VENDOR_CLASS_ID 60

#define DHCP_OPT_CLIENT_ID 61

#define DHCP_OPT_END 255

/**
 * DHCP message types.
 */
#define DHCP_TYPE_DISCOVER 1

#define DHCP_TYPE_OFFER 2

#define DHCP_TYPE_REQUEST 3

#define DHCP_TYPE_DECLINE 4

#define DHCP_TYPE_ACK 5

#define DHCP_TYPE_NAK 6

#define DHCP_TYPE_RELEASE 7

#define DHCP_TYPE_INFORM 8

#define DHCP_PARAM_SUBNET_MASK 1

#define DHCP_PARAM_ROUTER 3

#define DHCP_PARAM_DNS_SERVER 6

#define DHCP_PARAM_DOMAIN 15

#define DHCP_PARAM_ARP_TIMEOUT 35

#define DHCP_PARAM_NTP_SERVER 42

#define DHCP_PARAM_TFTP_SERVER_NAME 66

#define DHCP_PARAM_TFTP_SERVER_IP 150

#define CIP_GET_ATTR_LIST 3

#define CIP_SET_ATTR_LIST 4

#define CIP_MULTIPLE_SERVICE 10

#define ENIP_ITEM_TYPE_CONNECTED_DATA 177

#define ENIP_ITEM_TYPE_UNCONNECTED_DATA 178

#define ENIP_ITEM_TYPE_IDENTITY 12

#define ENIP_ITEM_TYPE_SERVICES 256

#define MIME_EVENT_FLAG_INVALID_HEADER 1

#define MIME_EVENT_FLAG_NO_FILEDATA 2

#define MIME_ANOM_INVALID_BASE64 1

#define MIME_ANOM_INVALID_QP 2

#define MIME_ANOM_LONG_LINE 4

#define MIME_ANOM_LONG_ENC_LINE 8

#define MIME_ANOM_LONG_HEADER_NAME 16

#define MIME_ANOM_LONG_HEADER_VALUE 32

#define MIME_ANOM_LONG_BOUNDARY 128

#define MIME_ANOM_LONG_FILENAME 256

#define SSH_MAX_BANNER_LEN 256

#define HTTP2_DECOMPRESSION_CHUNK_SIZE 4096

#define HTTP2_STATIC_HEADERS_NUMBER 61

#define HTTP2_FLAG_HEADER_EOS 1

#define HTTP2_FLAG_HEADER_END_HEADERS 4

#define HTTP2_FLAG_HEADER_PADDED 8

#define AES128_KEY_LEN 16

#define AES128_TAG_LEN 16

#define AES128_IV_LEN 12

#define SC_SHA256_LEN 32

#define SC_SHA1_LEN 20

#define SC_MD5_LEN 16

#define SC_SHA256_HEX_LEN 64

#define SC_SHA1_HEX_LEN 40

#define SC_MD5_HEX_LEN 32

#define DIR_BOTH 12

typedef enum AppLayerEventType {
    APP_LAYER_EVENT_TYPE_TRANSACTION = 1,
    APP_LAYER_EVENT_TYPE_PACKET = 2,
} AppLayerEventType;

enum ByteBase {
    BaseOct = 8,
    BaseDec = 10,
    BaseHex = 16,
};
typedef uint8_t ByteBase;

enum ByteEndian {
    BigEndian = 1,
    LittleEndian = 2,
    EndianDCE = 3,
};
typedef uint8_t ByteEndian;

enum ByteMathOperator {
    OperatorNone = 1,
    Addition = 2,
    Subtraction = 3,
    Division = 4,
    Multiplication = 5,
    LeftShift = 6,
    RightShift = 7,
};
typedef uint8_t ByteMathOperator;

typedef enum DatasetType {
    DSString = 0,
    DSMd5,
    DSSha256,
    DSIpv4,
    DSIpv6,
} DatasetType;

enum DetectFloatMode {
    DetectFloatModeEqual,
    DetectFloatModeLt,
    DetectFloatModeLte,
    DetectFloatModeGt,
    DetectFloatModeGte,
    DetectFloatModeRange,
    DetectFloatModeNe,
    DetectFloatModeNegRg,
};
typedef uint8_t DetectFloatMode;

/**
 * This data structure is also used in detect-flow-pkts.c
 */
enum DetectFlowDir {
    DETECT_FLOW_TOSERVER = 1,
    DETECT_FLOW_TOCLIENT = 2,
    DETECT_FLOW_TOEITHER = 3,
};
typedef uint8_t DetectFlowDir;

enum DetectIPRepDataCmd {
    IPRepCmdAny = 0,
    IPRepCmdBoth = 1,
    IPRepCmdSrc = 2,
    IPRepCmdDst = 3,
};
typedef uint8_t DetectIPRepDataCmd;

enum DetectStreamSizeDataFlags {
    StreamSizeServer = 1,
    StreamSizeClient = 2,
    StreamSizeBoth = 3,
    StreamSizeEither = 4,
};
typedef uint8_t DetectStreamSizeDataFlags;

enum DetectUintMode {
    DetectUintModeEqual,
    DetectUintModeLt,
    DetectUintModeLte,
    DetectUintModeGt,
    DetectUintModeGte,
    DetectUintModeRange,
    DetectUintModeNe,
    DetectUintModeNegRg,
    DetectUintModeBitmask,
    DetectUintModeNegBitmask,
};
typedef uint8_t DetectUintMode;

enum FtpDataStateValues {
    FTPDATA_STATE_IN_PROGRESS,
    FTPDATA_STATE_FINISHED,
};
typedef uint8_t FtpDataStateValues;

typedef enum FtpEvent {
    FtpEventRequestCommandTooLong,
    FtpEventResponseCommandTooLong,
} FtpEvent;

enum FtpRequestCommand {
    FTP_COMMAND_UNKNOWN,
    FTP_COMMAND_ABOR,
    FTP_COMMAND_ACCT,
    FTP_COMMAND_ALLO,
    FTP_COMMAND_APPE,
    FTP_COMMAND_AUTH_TLS,
    FTP_COMMAND_CDUP,
    FTP_COMMAND_CHMOD,
    FTP_COMMAND_CWD,
    FTP_COMMAND_DELE,
    FTP_COMMAND_EPSV,
    FTP_COMMAND_HELP,
    FTP_COMMAND_IDLE,
    FTP_COMMAND_LIST,
    FTP_COMMAND_MAIL,
    FTP_COMMAND_MDTM,
    FTP_COMMAND_MKD,
    FTP_COMMAND_MLFL,
    FTP_COMMAND_MODE,
    FTP_COMMAND_MRCP,
    FTP_COMMAND_MRSQ,
    FTP_COMMAND_MSAM,
    FTP_COMMAND_MSND,
    FTP_COMMAND_MSOM,
    FTP_COMMAND_NLST,
    FTP_COMMAND_NOOP,
    FTP_COMMAND_PASS,
    FTP_COMMAND_PASV,
    FTP_COMMAND_PORT,
    FTP_COMMAND_PWD,
    FTP_COMMAND_QUIT,
    FTP_COMMAND_REIN,
    FTP_COMMAND_REST,
    FTP_COMMAND_RETR,
    FTP_COMMAND_RMD,
    FTP_COMMAND_RNFR,
    FTP_COMMAND_RNTO,
    FTP_COMMAND_SITE,
    FTP_COMMAND_SIZE,
    FTP_COMMAND_SMNT,
    FTP_COMMAND_STAT,
    FTP_COMMAND_STOR,
    FTP_COMMAND_STOU,
    FTP_COMMAND_STRU,
    FTP_COMMAND_SYST,
    FTP_COMMAND_TYPE,
    FTP_COMMAND_UMASK,
    FTP_COMMAND_USER,
    FTP_COMMAND_EPRT,
};
typedef uint8_t FtpRequestCommand;

enum FtpStateValues {
    FTP_STATE_IN_PROGRESS,
    FTP_STATE_FINISHED,
};
typedef uint8_t FtpStateValues;

enum HTTP2TransactionState {
    HTTP2StateIdle = 0,
    HTTP2StateOpen = 1,
    HTTP2StateReserved = 2,
    HTTP2StateDataClient = 3,
    HTTP2StateHalfClosedClient = 4,
    HTTP2StateDataServer = 5,
    HTTP2StateHalfClosedServer = 6,
    HTTP2StateClosed = 7,
    HTTP2StateGlobal = 8,
    HTTP2StateTodrop = 9,
};
typedef uint8_t HTTP2TransactionState;

/**
 * Propagate lzma crate errors
 */
typedef enum LzmaStatus {
    LzmaOk,
    LzmaIoError,
    LzmaHeaderTooShortError,
    LzmaError,
    LzmaMemoryError,
    LzmaXzError,
} LzmaStatus;

enum MimeParserResult {
    MimeNeedsMore = 0,
    MimeFileOpen = 1,
    MimeFileChunk = 2,
    MimeFileClose = 3,
};
typedef uint8_t MimeParserResult;

enum MimeSmtpParserResult {
    MimeSmtpNeedsMore = 0,
    MimeSmtpFileOpen = 1,
    MimeSmtpFileClose = 2,
    MimeSmtpFileChunk = 3,
};
typedef uint8_t MimeSmtpParserResult;

enum MimeSmtpParserState {
    MimeSmtpStart = 0,
    MimeSmtpHeader = 1,
    MimeSmtpBody = 2,
    MimeSmtpParserError = 3,
};
typedef uint8_t MimeSmtpParserState;

enum SCBase64Mode {
    SCBase64ModeRFC2045 = 0,
    SCBase64ModeStrict,
    SCBase64ModeRFC4648,
    /**
     * Standard base64 without padding, and strict about it.
     */
    SCBase64ModeNoPad,
    /**
     * Standard base64 with optional padding: decode only.
     */
    SCBase64ModePadOpt,
};
typedef uint8_t SCBase64Mode;

typedef enum SCBase64ReturnCode {
    SC_BASE64_OK = 0,
    SC_BASE64_INVALID_ARG,
    SC_BASE64_OVERFLOW,
} SCBase64ReturnCode;

enum SSHConnectionState {
    SshStateInProgress = 0,
    SshStateBannerWaitEol = 1,
    SshStateBannerDone = 2,
    SshStateFinished = 3,
};
typedef uint8_t SSHConnectionState;

typedef enum SshEncryptionHandling {
    SSH_HANDLE_ENCRYPTION_TRACK_ONLY = 0,
    SSH_HANDLE_ENCRYPTION_BYPASS = 1,
    SSH_HANDLE_ENCRYPTION_FULL = 2,
} SshEncryptionHandling;

/**
 * Container for parsed Asn1 objects
 */
typedef struct Asn1 Asn1;

typedef struct DCEIfaceData DCEIfaceData;

typedef struct DCEOpnumData DCEOpnumData;

typedef struct DCERPCState DCERPCState;

typedef struct DCERPCTransaction DCERPCTransaction;

typedef struct DCERPCUDPState DCERPCUDPState;

typedef struct DNSTransaction DNSTransaction;

/**
 * Opaque Dataset type defined in C
 */
typedef struct Dataset Dataset;

/**
 * Struct to hold parsed asn1 keyword options
 */
typedef struct DetectAsn1Data DetectAsn1Data;

typedef struct DetectKrb5TicketEncryptionData DetectKrb5TicketEncryptionData;

typedef struct DetectModbusRust DetectModbusRust;

typedef struct HTTP2State HTTP2State;

typedef struct HTTP2Transaction HTTP2Transaction;

typedef struct HandshakeParams HandshakeParams;

typedef struct HashMap_i32__CString HashMap_i32__CString;

typedef struct SCJsonBuilder SCJsonBuilder;

typedef struct KRB5Transaction KRB5Transaction;

typedef struct MQTTTransaction MQTTTransaction;

typedef struct MimeStateHTTP MimeStateHTTP;

typedef struct MimeStateSMTP MimeStateSMTP;

typedef struct ModbusState ModbusState;

typedef struct ModbusTransaction ModbusTransaction;

typedef struct NFSState NFSState;

typedef struct NFSTransaction NFSTransaction;

typedef struct QuicState QuicState;

typedef struct QuicTransaction QuicTransaction;

typedef struct QuicVersion QuicVersion;

typedef struct RdpState RdpState;

typedef struct RdpTransaction RdpTransaction;

/**
 * Status object to hold required features and the latest version of
 * Suricata required.
 *
 * Full qualified name as it is exposed to C.
 */
typedef struct SCDetectRequiresStatus SCDetectRequiresStatus;

typedef struct SCMd5 SCMd5;

typedef struct SCSha1 SCSha1;

typedef struct SCSha256 SCSha256;

typedef struct SIPState SIPState;

typedef struct SIPTransaction SIPTransaction;

typedef struct SMBState SMBState;

typedef struct SMBTransaction SMBTransaction;

typedef struct WebSocketTransaction WebSocketTransaction;

typedef struct X509 X509;

/**
 * A "mark" or saved state for a JsonBuilder object.
 *
 * The name is full, and the types are u64 as this object is used
 * directly in C as well.
 */
typedef struct SCJsonBuilderMark {
    uint64_t position;
    uint64_t state_index;
    uint64_t state;
} SCJsonBuilderMark;

typedef struct AppLayerTxConfig {
    /**
     * config: log flags
     */
    uint8_t log_flags;
} AppLayerTxConfig;

/**
 * LoggerFlags tracks which loggers have already been executed.
 */
typedef struct LoggerFlags {
    uint32_t flags;
} LoggerFlags;

typedef struct AppLayerTxData {
    /**
     * config: log flags
     */
    struct AppLayerTxConfig config;
    /**
     * The tx has been updated and needs to be processed : detection, logging, cleaning
     * It can then be skipped until new data arrives.
     * There is a boolean for both directions : to server and to client
     */
    bool updated_tc;
    bool updated_ts;
    uint8_t flags;
    /**
     * logger flags for tx logging api
     */
    struct LoggerFlags logged;
    /**
     * track file open/logs so we can know how long to keep the tx
     */
    uint32_t files_opened;
    uint32_t files_logged;
    uint32_t files_stored;
    uint16_t file_flags;
    /**
     * Indicated if a file tracking tx, and if so in which direction:
     *  0: not a file tx
     * STREAM_TOSERVER: file tx, files only in toserver dir
     * STREAM_TOCLIENT: file tx , files only in toclient dir
     * STREAM_TOSERVER|STREAM_TOCLIENT: files possible in both dirs
     */
    uint8_t file_tx;
    /**
     * Number of times this tx data has already been logged for signatures
     * not using application layer keywords
     */
    uint8_t guessed_applayer_logged;
    /**
     * detection engine progress tracking for use by detection engine
     * Reflects the "progress" of prefilter engines into this TX, where
     * the value is offset by 1. So if for progress state 0 the engines
     * are done, the value here will be 1. So a value of 0 means, no
     * progress tracked yet.
     *
     */
    uint8_t detect_progress_ts;
    uint8_t detect_progress_tc;
    DetectEngineState *de_state;
    AppLayerDecoderEvents *events;
    GenericVar *txbits;
} AppLayerTxData;

/**
 * Names of SigTableElmt for release by rust
 */
typedef struct SCSigTableNamesElmt {
    /**
     * keyword name
     */
    char *name;
    /**
     * keyword description
     */
    char *desc;
    /**
     * keyword documentation url
     */
    char *url;
} SCSigTableNamesElmt;

typedef struct SCDetectByteExtractData {
    uint8_t local_id;
    uint8_t nbytes;
    int16_t offset;
    const char *name;
    uint16_t flags;
    ByteEndian endian;
    ByteBase base;
    uint8_t align_value;
    uint16_t multiplier_value;
    uint16_t id;
} SCDetectByteExtractData;

typedef struct DetectByteMathData {
    const char *rvalue_str;
    const char *result;
    const char *nbytes_str;
    uint32_t rvalue;
    int32_t offset;
    uint32_t bitmask_val;
    uint16_t bitmask_shift_count;
    uint16_t id;
    uint8_t flags;
    uint8_t local_id;
    uint8_t nbytes;
    ByteMathOperator oper;
    ByteEndian endian;
    ByteBase base;
} DetectByteMathData;

typedef struct DetectFloatData_f64 {
    double arg1;
    double arg2;
    DetectFloatMode mode;
} DetectFloatData_f64;

typedef struct DetectEntropyData {
    int32_t offset;
    int32_t nbytes;
    int32_t fv_idx;
    struct DetectFloatData_f64 value;
} DetectEntropyData;

typedef struct DetectUintData_u32 {
    uint32_t arg1;
    uint32_t arg2;
    DetectUintMode mode;
} DetectUintData_u32;

/**
 * This data structure is also used in detect-flow-pkts.c
 */
typedef struct DetectFlowPkts {
    struct DetectUintData_u32 pkt_data;
    DetectFlowDir dir;
} DetectFlowPkts;

typedef struct DetectUintData_u64 {
    uint64_t arg1;
    uint64_t arg2;
    DetectUintMode mode;
} DetectUintData_u64;

/**
 * This data structure is also used in detect-flow-pkts.c
 */
typedef struct DetectFlowBytes {
    struct DetectUintData_u64 byte_data;
    DetectFlowDir dir;
} DetectFlowBytes;

typedef struct DetectUintData_u8 {
    uint8_t arg1;
    uint8_t arg2;
    DetectUintMode mode;
} DetectUintData_u8;

/**
 * value matching is done use `DetectUintData` logic.
 *
 * isset matching is done using special `DetectUintData` value ">= 0"
 * isnotset matching bypasses `DetectUintData` and is handled directly
 * in the match function (in C).
 */
typedef struct DetectIPRepData {
    struct DetectUintData_u8 du8;
    uint8_t cat;
    DetectIPRepDataCmd cmd;
    bool isnotset;
} DetectIPRepData;

typedef struct DetectStreamSizeData {
    DetectStreamSizeDataFlags flags;
    struct DetectUintData_u32 du32;
} DetectStreamSizeData;

typedef struct DetectUintData_u16 {
    uint16_t arg1;
    uint16_t arg2;
    DetectUintMode mode;
} DetectUintData_u16;

typedef struct DetectUrilenData {
    struct DetectUintData_u16 du16;
    bool raw_buffer;
} DetectUrilenData;

/**
 * This data structure is also used in detect-vlan.c
 */
typedef struct DetectVlanIdData {
    /**
     * Vlan id
     */
    struct DetectUintData_u16 du16;
    /**
     * Layer can be DETECT_VLAN_ID_ANY to match with any vlan layer
     * DETECT_VLAN_ID_ALL to match if all layers match, or an integer
     * within the range -VLAN_MAX_LAYERS to VLAN_MAX_LAYERS-1 for indexing.
     * Negative values represent back to front indexing.
     */
    int8_t layer;
} DetectVlanIdData;

typedef struct CStringData {
    const uint8_t *data;
    uintptr_t len;
} CStringData;

typedef struct DetectFtpReplyReceivedData {
    bool received;
} DetectFtpReplyReceivedData;

typedef struct DetectFtpModeData {
    bool active;
} DetectFtpModeData;

typedef struct FtpTransferCmd {
    void (*data_free)(void*);
    uint64_t flow_id;
    uint8_t *file_name;
    uint16_t file_len;
    uint8_t direction;
    uint8_t cmd;
} FtpTransferCmd;

typedef struct FTPResponseLine {
    uint8_t *code;
    uint8_t *response;
    uintptr_t length;
    uintptr_t code_length;
    bool truncated;
    uintptr_t total_size;
} FTPResponseLine;

typedef struct ModbusMessage {
    const void *_0;
} ModbusMessage;

typedef struct AppLayerStateData {
    uint16_t file_flags;
} AppLayerStateData;

typedef struct HTTPContentRange {
    int64_t start;
    int64_t end;
    int64_t size;
} HTTPContentRange;

typedef struct StreamSlice {
    const uint8_t *input;
    uint32_t input_len;
    /**
     * STREAM_* flags
     */
    uint8_t flags;
    uint64_t offset;
} StreamSlice;

typedef struct AppLayerResult {
    int32_t status;
    uint32_t consumed;
    uint32_t needed;
} AppLayerResult;

/**
 * helper for the GetTxFilesFn. Not meant to be embedded as the config
 * pointer is passed around in the API.
 */
typedef struct AppLayerGetFileState {
    FileContainer *fc;
    const StreamingBufferConfig *cfg;
} AppLayerGetFileState;

typedef struct AppLayerGetTxIterTuple {
    void *tx_ptr;
    uint64_t tx_id;
    bool has_next;
} AppLayerGetTxIterTuple;

typedef struct DataRepType {
    uint16_t value;
} DataRepType;



















void SCRustInit(const SuricataContext *context);

/**
 * Set the Rust context's idea of the log level.
 *
 * This will be called during Suricata initialization with the
 * runtime log level.
 */
void SCSetRustLogLevel(SCLogLevel level);

/**
 * Free a CString allocated by Rust (for ex. using `rust_string_to_c`)
 *
 * # Safety
 *
 * s must be allocated by rust, using `CString::new`
 */
void SCRustCStringFree(char *s);

void SCToHex(uint8_t *output,
             uintptr_t out_len,
             const uint8_t *input,
             uintptr_t in_len);

void SCToHex_sep(uint8_t *output,
                 uintptr_t out_len,
                 uint8_t sep,
                 const uint8_t *input,
                 uintptr_t in_len);

struct SCJsonBuilder *SCJbNewObject(void);

struct SCJsonBuilder *SCJbNewArray(void);

struct SCJsonBuilder *SCJbClone(struct SCJsonBuilder *js);

void SCJbFree(struct SCJsonBuilder *js);

uintptr_t SCJbCapacity(struct SCJsonBuilder *jb);

void SCJbReset(struct SCJsonBuilder *jb);

bool SCJbOpenObject(struct SCJsonBuilder *js, const char *key);

bool SCJbStartObject(struct SCJsonBuilder *js);

bool SCJbOpenArray(struct SCJsonBuilder *js, const char *key);

bool SCJbSetString(struct SCJsonBuilder *js, const char *key, const char *val);

bool SCJbSetStringFromBytes(struct SCJsonBuilder *js,
                            const char *key,
                            const uint8_t *bytes,
                            uint32_t len);

bool SCJbSetPrintAsciiString(struct SCJsonBuilder *js,
                             const char *key,
                             const uint8_t *bytes,
                             uint32_t len);

bool SCJbSetBase64(struct SCJsonBuilder *js,
                   const char *key,
                   const uint8_t *bytes,
                   uint32_t len);

bool SCJbSetHex(struct SCJsonBuilder *js,
                const char *key,
                const uint8_t *bytes,
                uint32_t len);

bool SCJbSetFormatted(struct SCJsonBuilder *js, const char *formatted);

bool SCJbAppendObject(struct SCJsonBuilder *jb,
                      const struct SCJsonBuilder *obj);

bool SCJbSetObject(struct SCJsonBuilder *js,
                   const char *key,
                   struct SCJsonBuilder *val);

bool SCJbAppendString(struct SCJsonBuilder *js, const char *val);

bool SCJbAppendStringFromBytes(struct SCJsonBuilder *js,
                               const uint8_t *bytes,
                               uint32_t len);

bool SCJbAppendBase64(struct SCJsonBuilder *js,
                      const uint8_t *bytes,
                      uint32_t len);

bool SCJbAppendUint(struct SCJsonBuilder *js, uint64_t val);

bool SCJbAppendFloat(struct SCJsonBuilder *js, double val);

bool SCJbSetUint(struct SCJsonBuilder *js, const char *key, uint64_t val);

bool SCJbSetInt(struct SCJsonBuilder *js, const char *key, int64_t val);

bool SCJbSetFloat(struct SCJsonBuilder *js, const char *key, double val);

bool SCJbSetBool(struct SCJsonBuilder *js, const char *key, bool val);

bool SCJbClose(struct SCJsonBuilder *js);

uintptr_t SCJbLen(const struct SCJsonBuilder *js);

const uint8_t *SCJbPtr(struct SCJsonBuilder *js);

void SCJbGetMark(struct SCJsonBuilder *js, struct SCJsonBuilderMark *mark);

bool SCJbRestoreMark(struct SCJsonBuilder *js, struct SCJsonBuilderMark *mark);

void SCAppLayerTxDataCleanup(struct AppLayerTxData *txd);

void SCTxDataUpdateFileFlags(struct AppLayerTxData *txd, uint16_t state_flags);

void SCDetectSigMatchNamesFree(struct SCSigTableNamesElmt *kw);

/**
 * Intermediary function between the C code and the parsing functions.
 */
struct SCDetectByteExtractData *SCByteExtractParse(const char *c_arg);

void SCByteExtractFree(struct SCDetectByteExtractData *ptr);

/**
 * Intermediary function between the C code and the parsing functions.
 */
struct DetectByteMathData *SCByteMathParse(const char *c_arg);

void SCByteMathFree(struct DetectByteMathData *ptr);

bool SCDetectEntropyMatch(const void *c_data,
                          int32_t length,
                          const struct DetectEntropyData *ctx,
                          double *calculated_entropy);

struct DetectEntropyData *SCDetectEntropyParse(const char *c_arg);

void SCDetectEntropyFree(void *ptr);

struct DetectFlowPkts *SCDetectFlowPktsParseDir(const char *ustr,
                                                DetectFlowDir dir);

struct DetectFlowPkts *SCDetectFlowPktsParse(const char *ustr);

void SCDetectFlowPktsFree(struct DetectFlowPkts *ctx);

struct DetectFlowBytes *SCDetectFlowBytesParseDir(const char *ustr,
                                                  DetectFlowDir dir);

struct DetectFlowBytes *SCDetectFlowBytesParse(const char *ustr);

void SCDetectFlowBytesFree(struct DetectFlowBytes *ctx);

struct DetectIPRepData *SCDetectIPRepParse(const char *ustr);

void SCDetectIPRepFree(struct DetectIPRepData *ctx);

struct SCDetectRequiresStatus *SCDetectRequiresStatusNew(void);

void SCDetectRequiresStatusFree(struct SCDetectRequiresStatus *status);

void SCDetectRequiresStatusLog(struct SCDetectRequiresStatus *status,
                               const char *suricata_version,
                               uint32_t tenant_id);

/**
 * Parse a "requires" rule option.
 *
 * Return values:
 *   *  0 - OK, rule should continue loading
 *   * -1 - Error parsing the requires content
 *   * -4 - Requirements not met, don't continue loading the rule, this
 *     value is chosen so it can be passed back to the options parser
 *     as its treated as a non-fatal silent error.
 */
int SCDetectCheckRequires(const char *requires,
                          const char *suricata_version_string,
                          const char **errstr,
                          struct SCDetectRequiresStatus *status);

struct DetectStreamSizeData *SCDetectStreamSizeParse(const char *ustr);

void SCDetectStreamSizeFree(struct DetectStreamSizeData *ctx);

void DetectTransformFromBase64DecodeRegister(void);

void DetectTransformToLowerRegister(void);

void DetectTransformToUpperRegister(void);

void DetectTransformCompressWhitespaceRegister(void);

void SCDetectTransformDomainRegister(void);

void DetectTransformDotPrefixRegister(void);

void DetectTransformMd5Register(void);

void DetectTransformSha1Register(void);

void DetectTransformSha256Register(void);

void DetectTransformHeaderLowercaseRegister(void);

void DetectTransformStripPseudoHeadersRegister(void);

void DetectTransformStripWhitespaceRegister(void);

void DetectTransformUrlDecodeRegister(void);

void DetectTransformXorRegister(void);

struct DetectUintData_u64 *SCDetectU64Parse(const char *ustr);

int SCDetectU64Match(uint64_t arg, const struct DetectUintData_u64 *ctx);

void SCDetectU64Free(struct DetectUintData_u64 *ctx);

struct DetectUintData_u32 *SCDetectU32Parse(const char *ustr);

struct DetectUintData_u32 *SCDetectU32ParseInclusive(const char *ustr);

int SCDetectU32Match(uint32_t arg, const struct DetectUintData_u32 *ctx);

void SCDetectU32Free(struct DetectUintData_u32 *ctx);

struct DetectUintData_u8 *SCDetectU8Parse(const char *ustr);

int SCDetectU8Match(uint8_t arg, const struct DetectUintData_u8 *ctx);

void SCDetectU8Free(struct DetectUintData_u8 *ctx);

struct DetectUintData_u16 *SCDetectU16Parse(const char *ustr);

int SCDetectU16Match(uint16_t arg, const struct DetectUintData_u16 *ctx);

void SCDetectU16Free(struct DetectUintData_u16 *ctx);

struct DetectFloatData_f64 *SCDetectF64Parse(const char *ustr);

int SCDetectF64Match(double arg, const struct DetectFloatData_f64 *ctx);

void SCDetectF64Free(struct DetectFloatData_f64 *ctx);

struct DetectFloatData_f64 *SCDetectParseF64(const char *ustr);

int SCDetectMatchF64(double arg, const struct DetectFloatData_f64 *ctx);

void SCDetectFreeF64(struct DetectFloatData_f64 *ctx);

struct DetectUrilenData *SCDetectUrilenParse(const char *ustr);

void SCDetectUrilenFree(struct DetectUrilenData *ctx);

bool SCDetectU8ToJson(struct SCJsonBuilder *js,
                      const struct DetectUintData_u8 *du);

bool SCDetectU16ToJson(struct SCJsonBuilder *js,
                       const struct DetectUintData_u16 *du);

bool SCDetectU32ToJson(struct SCJsonBuilder *js,
                       const struct DetectUintData_u32 *du);

struct DetectVlanIdData *SCDetectVlanIdParse(const char *ustr);

void SCDetectVlanIdFree(struct DetectVlanIdData *ctx);

int32_t ParseDatasets(const struct Dataset *set,
                      const char *name,
                      const char *fname,
                      const char *fmode,
                      enum DatasetType dstype);

struct HashMap_i32__CString *SCDatalinkInit(void);

void SCDatalinkValueNameInsert(struct HashMap_i32__CString *map,
                               int32_t key,
                               const char *value);

const char *SCDatalinkValueToName(struct HashMap_i32__CString *map,
                                  int32_t key);

void SCDatalinkDeInit(struct HashMap_i32__CString *map);

void SCJA4GetHash(const struct HandshakeParams *hs,
                  uint8_t (*out)[JA4_HEX_LEN]);

bool TLSVersionValid(uint16_t v);

bool SSLVersionToString(uint16_t v, char *buf);

struct HandshakeParams *SCTLSHandshakeNew(void);

bool SCTLSHandshakeIsEmpty(const struct HandshakeParams *hs);

void SCTLSHandshakeSetTLSVersion(struct HandshakeParams *hs, uint16_t version);

void SCTLSHandshakeAddCipher(struct HandshakeParams *hs, uint16_t cipher);

void SCTLSHandshakeAddExtension(struct HandshakeParams *hs, uint16_t ext);

void SCTLSHandshakeAddSigAlgo(struct HandshakeParams *hs, uint16_t sigalgo);

void SCTLSHandshakeAddALPN(struct HandshakeParams *hs,
                           const char *alpn,
                           uint16_t len);

void SCTLSHandshakeFree(struct HandshakeParams *hs);

bool SCTLSHandshakeLogVersion(const struct HandshakeParams *hs,
                              struct SCJsonBuilder *js);

bool SCTLSHandshakeLogCiphers(const struct HandshakeParams *hs,
                              struct SCJsonBuilder *js);

bool SCTLSHandshakeLogFirstCipher(const struct HandshakeParams *hs,
                                  struct SCJsonBuilder *js);

bool SCTLSHandshakeLogExtensions(const struct HandshakeParams *hs,
                                 struct SCJsonBuilder *js);

bool SCTLSHandshakeLogSigAlgs(const struct HandshakeParams *hs,
                              struct SCJsonBuilder *js);

bool SCTLSHandshakeLogALPNs(const struct HandshakeParams *hs,
                            struct SCJsonBuilder *js,
                            const char *ptr);

bool SCTLSHandshakeGetALPN(const struct HandshakeParams *hs,
                           uint32_t idx,
                           struct CStringData *out);

void SCDetectDNSRegister(void);

bool SCDnsTxIsRequest(struct DNSTransaction *tx);

bool SCDnsTxIsResponse(struct DNSTransaction *tx);

/**
 * Get the DNS query name at index i.
 */
bool SCDnsTxGetQueryName(DetectEngineThreadCtx *_de,
                         const void *tx,
                         uint8_t flow_flags,
                         uint32_t i,
                         const uint8_t **buf,
                         uint32_t *len);

/**
 * Get the DNS response answer name and index i.
 */
bool SCDnsTxGetAnswerName(DetectEngineThreadCtx *_de,
                          const void *tx,
                          uint8_t flow_flags,
                          uint32_t i,
                          const uint8_t **buf,
                          uint32_t *len);

/**
 * Get the DNS response authority name at index i.
 */
bool SCDnsTxGetAuthorityName(DetectEngineThreadCtx *_de,
                             const void *tx,
                             uint8_t _flow_flags,
                             uint32_t i,
                             const uint8_t **buf,
                             uint32_t *len);

/**
 * Get the DNS response additional name at index i.
 */
bool SCDnsTxGetAdditionalName(DetectEngineThreadCtx *_de,
                              const void *tx,
                              uint8_t _flow_flags,
                              uint32_t i,
                              const uint8_t **buf,
                              uint32_t *len);

/**
 * Get the DNS response answer rdata at index i that could be a domain name.
 */
bool SCDnsTxGetAnswerRdata(struct DNSTransaction *tx,
                           uint32_t i,
                           const uint8_t **buf,
                           uint32_t *len);

/**
 * Get the DNS response authority rdata at index i that could be a domain name.
 */
bool SCDnsTxGetAuthorityRdata(struct DNSTransaction *tx,
                              uint32_t i,
                              const uint8_t **buf,
                              uint32_t *len);

/**
 * Get the DNS response additional rdata at index i that could be a domain name.
 */
bool SCDnsTxGetAdditionalRdata(struct DNSTransaction *tx,
                               uint32_t i,
                               const uint8_t **buf,
                               uint32_t *len);

/**
 * Get the DNS response flags for a transaction.
 */
uint16_t SCDnsTxGetResponseFlags(struct DNSTransaction *tx);

void SCRegisterDnsUdpParser(void);

void SCRegisterDnsTcpParser(void);

bool SCDnsLogJsonQuery(const struct DNSTransaction *tx,
                       uint16_t i,
                       uint64_t flags,
                       struct SCJsonBuilder *jb);

/**
 * FFI wrapper around the common V3 style DNS logger.
 */
bool SCDnsLogJson(const struct DNSTransaction *tx,
                  uint64_t flags,
                  struct SCJsonBuilder *jb);

/**
 * Check if a DNS transaction should be logged based on the
 * configured flags.
 */
bool SCDnsLogEnabled(const struct DNSTransaction *tx, uint64_t flags);

/**
 * Note: For v2 style logging.
 */
bool SCDnsLogJsonAnswer(const struct DNSTransaction *tx,
                        uint64_t flags,
                        struct SCJsonBuilder *js);

/**
 * Note: For v2 style logging.
 */
bool SCDnsLogAnswerEnabled(const struct DNSTransaction *tx, uint64_t flags);

int SCDnsLuaGetTxId(lua_State *clua, struct DNSTransaction *tx);

int SCDnsLuaGetRrname(lua_State *clua, struct DNSTransaction *tx);

int SCDnsLuaGetRcode(lua_State *clua, struct DNSTransaction *tx);

int SCDnsLuaGetRcodeString(lua_State *clua, struct DNSTransaction *tx);

int SCDnsLuaGetQueryTable(lua_State *clua, struct DNSTransaction *tx);

int SCDnsLuaGetAnswerTable(lua_State *clua, struct DNSTransaction *tx);

int SCDnsLuaGetAuthorityTable(lua_State *clua, struct DNSTransaction *tx);

/**
 * FFI wrapper around the common V3 style mDNS logger.
 */
bool SCMdnsLogJson(const struct DNSTransaction *tx, struct SCJsonBuilder *jb);

/**
 * Get the mDNS response answer name and index i.
 *
 * Very similar to the DNS version, but mDNS is always to_server.
 */
bool SCMdnsTxGetAnswerName(DetectEngineThreadCtx *_de,
                           const void *tx,
                           uint8_t _flow_flags,
                           uint32_t i,
                           const uint8_t **buf,
                           uint32_t *len);

void SCRegisterMdnsParser(void);

uint8_t SCNfsTxLoggingIsFiltered(struct NFSState *state,
                                 const struct NFSTransaction *tx);

bool SCNfsLogJsonResponse(struct NFSState *state,
                          const struct NFSTransaction *tx,
                          struct SCJsonBuilder *js);

bool SCNfsRpcLogJsonResponse(const struct NFSTransaction *tx,
                             struct SCJsonBuilder *js);

/**
 * return procedure(s) in the tx. At 0 return the main proc,
 * otherwise get procs from the 'file_additional_procs'.
 * Keep calling until 0 is returned.
 */
uint8_t SCNfsTxGetProcedures(struct NFSTransaction *tx,
                             uint16_t i,
                             uint32_t *procedure);

void SCNfsTxGetVersion(struct NFSTransaction *tx, uint32_t *version);

void SCNfsInit(SuricataFileContext *context);

void SCRegisterNfsParser(void);

void SCRegisterNfsUdpParser(void);

uint16_t SCFTPParsePort(const uint8_t *input, uint32_t len);

uint16_t SCFTPParsePortPasv(const uint8_t *input, uint32_t len);

uint16_t SCFTPParsePortEprt(const uint8_t *input, uint32_t len);

uint16_t SCFTPParsePortEpsv(const uint8_t *input, uint32_t len);

/**
 * Wrapper around the Rust generic function for get_event_info.
 *
 * # Safety
 * Unsafe as called from C.
 */
int ftp_get_event_info(const char *event_name,
                       uint8_t *event_id,
                       enum AppLayerEventType *event_type);

/**
 * Wrapper around the Rust generic function for get_event_info_by_id.
 *
 * # Safety
 * Unsafe as called from C.
 */
int ftp_get_event_info_by_id(uint8_t event_id,
                             const char **event_name,
                             enum AppLayerEventType *event_type);

bool SCGetFtpCommandInfo(uintptr_t index,
                         const char **name_ptr,
                         uint8_t *code_ptr,
                         uint8_t *len_ptr);

void SCFTPSetMpmState(const void *ctx);

void SCFTPGetConfigValues(uint64_t *memcap,
                          uint32_t *max_tx,
                          uint32_t *max_line_len);

struct DetectFtpReplyReceivedData *SCFTPParseReplyReceived(const char *c_str);

void SCFTPFreeReplyReceivedData(struct DetectFtpReplyReceivedData *ptr);

struct DetectFtpModeData *SCFTPParseMode(const char *c_str);

void SCFTPFreeModeData(struct DetectFtpModeData *ptr);

/**
 * Returns *mut FtpTransferCmd
 */
struct FtpTransferCmd *SCFTPTransferCmdNew(void);

/**
 * Params:
 * - transfer command: *mut FTPTransferCmd as void pointer
 */
void SCFTPTransferCmdFree(struct FtpTransferCmd *cmd);

/**
 * Parses an FTP response string and returns a pointer to an `FTPResponseLine` struct.
 */
struct FTPResponseLine *SCFTPParseResponseLine(const char *input,
                                               uintptr_t length);

/**
 * Frees the memory allocated for an `FTPResponseLine` struct.
 */
void SCFTPFreeResponseLine(struct FTPResponseLine *response);

void SCSmbInit(SuricataFileContext *context);

void SCRegisterSmbParser(void);

bool SCSmbLogJsonResponse(struct SCJsonBuilder *jsb,
                          struct SMBState *state,
                          const struct SMBTransaction *tx,
                          uint64_t flags);

uint64_t SCSmbLogParseConfig(const SCConfNode *conf);

uint8_t SCSmbTxGetShare(const struct SMBTransaction *tx,
                        const uint8_t **buffer,
                        uint32_t *buffer_len);

uint8_t SCSmbTxGetNamedPipe(const struct SMBTransaction *tx,
                            const uint8_t **buffer,
                            uint32_t *buffer_len);

uint8_t SCSmbTxGetStubData(const struct SMBTransaction *tx,
                           uint8_t direction,
                           const uint8_t **buffer,
                           uint32_t *buffer_len);

uint8_t SCSmbTxMatchDceOpnum(const struct SMBTransaction *tx,
                             struct DCEOpnumData *dce_data);

uint8_t SCSmbTxGetDceIface(struct SMBState *state,
                           const struct SMBTransaction *tx,
                           struct DCEIfaceData *dce_data);

uint8_t SCSmbTxGetNtlmsspUser(const struct SMBTransaction *tx,
                              const uint8_t **buffer,
                              uint32_t *buffer_len);

uint8_t SCSmbTxGetNtlmsspDomain(const struct SMBTransaction *tx,
                                const uint8_t **buffer,
                                uint32_t *buffer_len);

uint8_t SCSmbVersionMatch(const struct SMBTransaction *tx,
                          uint8_t *version_data);

void *SCSmbVersionParse(const char *carg);

void SCSmbVersionFree(void *ptr);

void SCKrb5TxGetMsgType(const struct KRB5Transaction *tx, uint32_t *ptr);

/**
 * Get error code, if present in transaction
 * Return 0 if error code was filled, else 1
 */
uint32_t SCKrb5TxGetErrorCode(const struct KRB5Transaction *tx, int32_t *ptr);

bool SCKrb5TxGetCname(DetectEngineThreadCtx *_de,
                      const void *tx,
                      uint8_t _flags,
                      uint32_t i,
                      const uint8_t **buffer,
                      uint32_t *buffer_len);

bool SCKrb5TxGetSname(DetectEngineThreadCtx *_de,
                      const void *tx,
                      uint8_t _flags,
                      uint32_t i,
                      const uint8_t **buffer,
                      uint32_t *buffer_len);

struct DetectKrb5TicketEncryptionData *SCKrb5DetectEncryptionParse(const char *ustr);

int SCKrb5DetectEncryptionMatch(const struct KRB5Transaction *tx,
                                const struct DetectKrb5TicketEncryptionData *ctx);

void SCKrb5DetectEncryptionFree(struct DetectKrb5TicketEncryptionData *ctx);

void SCRegisterKrb5Parser(void);

bool SCKrb5LogJsonResponse(const struct KRB5Transaction *tx,
                           struct SCJsonBuilder *jsb);

void SCDcerpcGetStubData(struct DCERPCTransaction *tx,
                         const uint8_t **buf,
                         uint32_t *len,
                         uint8_t *endianness,
                         uint8_t dir);

void SCRegisterDcerpcParser(void);

void SCRegisterDcerpcUdpParser(void);

uint8_t SCDcerpcIfaceMatch(const struct DCERPCTransaction *tx,
                           struct DCERPCState *state,
                           struct DCEIfaceData *if_data);

void *SCDcerpcIfaceParse(const char *carg);

void SCDcerpcIfaceFree(void *ptr);

uint8_t SCDcerpcOpnumMatch(const struct DCERPCTransaction *tx,
                           struct DCEOpnumData *opnum_data);

void *SCDcerpcOpnumParse(const char *carg);

void SCDcerpcOpnumFree(void *ptr);

bool SCDcerpcLogJsonRecordTcp(const struct DCERPCState *state,
                              const struct DCERPCTransaction *tx,
                              struct SCJsonBuilder *jsb);

bool SCDcerpcLogJsonRecordUdp(const struct DCERPCUDPState *state,
                              const struct DCERPCTransaction *tx,
                              struct SCJsonBuilder *jsb);

/**
 * Intermediary function between the C code and the parsing functions.
 */
void *SCModbusParse(const char *c_arg);

void SCModbusFree(void *ptr);

/**
 * Compares a transaction to a signature to determine whether the transaction
 * matches the signature. If it does, 1 is returned; otherwise 0 is returned.
 */
uint8_t SCModbusInspect(const struct ModbusTransaction *tx,
                        const struct DetectModbusRust *modbus);

bool SCModbusToJson(const struct ModbusTransaction *tx,
                    struct SCJsonBuilder *js);

uint64_t SCModbusStateGetTxCount(void *state);

void SCRegisterModbusParser(void);

uint8_t SCModbusMessageGetFunction(const struct ModbusMessage *msg);

uint16_t SCModbusMessageGetSubfunction(const struct ModbusMessage *msg);

uint16_t SCModbusMessageGetReadRequestAddress(const struct ModbusMessage *msg);

uint16_t SCModbusMessageGetReadRequestQuantity(const struct ModbusMessage *msg);

uint16_t SCModbusMessageGetRwMultreqReadAddress(const struct ModbusMessage *msg);

uint16_t SCModbusMessageGetRwMultreqReadQuantity(const struct ModbusMessage *msg);

uint16_t SCModbusMessageGetRwMultreqWriteAddress(const struct ModbusMessage *msg);

uint16_t SCModbusMessageGetRwMultreqWriteQuantity(const struct ModbusMessage *msg);

const uint8_t *SCModbusMessageGetRwMultreqWriteData(const struct ModbusMessage *msg,
                                                    uintptr_t *data_len);

uint16_t SCModbusMessageGetWriteMultreqAddress(const struct ModbusMessage *msg);

uint16_t SCModbusMessageGetWriteMultreqQuantity(const struct ModbusMessage *msg);

const uint8_t *SCModbusMessageGetWriteMultreqData(const struct ModbusMessage *msg,
                                                  uintptr_t *data_len);

uint16_t SCModbusMessageGetAndMask(const struct ModbusMessage *msg);

uint16_t SCModbusMessageGetOrMask(const struct ModbusMessage *msg);

uint16_t SCModbusMessageGetWriteAddress(const struct ModbusMessage *msg);

uint16_t SCModbusMessageGetWriteData(const struct ModbusMessage *msg);

const uint8_t *SCModbusMessageGetBytevecData(const struct ModbusMessage *msg,
                                             uintptr_t *data_len);

struct ModbusMessage SCModbusStateGetTxRequest(void *state, uint64_t tx_id);

struct ModbusMessage SCModbusStateGetTxResponse(void *state, uint64_t tx_id);

uint8_t SCIkeStateGetExchType(const IKETransaction *tx, uint8_t *exch_type);

uint8_t SCIkeStateGetSpiInitiator(const IKETransaction *tx,
                                  const uint8_t **buffer,
                                  uint32_t *buffer_len);

uint8_t SCIkeStateGetSpiResponder(const IKETransaction *tx,
                                  const uint8_t **buffer,
                                  uint32_t *buffer_len);

uint8_t SCIkeStateGetNonce(const IKETransaction *tx,
                           const uint8_t **buffer,
                           uint32_t *buffer_len);

uint8_t SCIkeStateGetKeyExchange(const IKETransaction *tx,
                                 const uint8_t **buffer,
                                 uint32_t *buffer_len);

bool SCIkeTxGetVendor(DetectEngineThreadCtx *_de,
                      const void *tx,
                      uint8_t _flags,
                      uint32_t i,
                      const uint8_t **buf,
                      uint32_t *len);

uint8_t SCIkeStateGetSaAttribute(const IKETransaction *tx,
                                 const char *sa_type,
                                 uint32_t *value);

uint8_t SCIkeStateGetKeyExchangePayloadLength(const IKETransaction *tx,
                                              uint32_t *value);

uint8_t SCIkeStateGetNoncePayloadLength(const IKETransaction *tx,
                                        uint32_t *value);

void SCRegisterIkeParser(void);

bool SCIkeLoggerLog(IKEState *state,
                    void *tx,
                    uint32_t flags,
                    struct SCJsonBuilder *js);

void SCRegisterSnmpParser(void);

void SCRegisterNtpParser(void);

void *SCTftpStateAlloc(void);

void SCTftpStateFree(void *state);

void SCTftpStateTxFree(TFTPState *state, uint64_t tx_id);

void *SCTftpGetTx(TFTPState *state, uint64_t tx_id);

uint64_t SCTftpGetTxCnt(TFTPState *state);

int64_t SCTftpParseRequest(TFTPState *state,
                           const uint8_t *input,
                           uint32_t len);

struct AppLayerTxData *SCTftpGetTxData(void *tx);

struct AppLayerStateData *SCTftpGetStateData(void *state);

bool SCTftpLogJsonRequest(const TFTPTransaction *tx, struct SCJsonBuilder *jb);

void SCDetectDHCPRegister(void);

void SCRegisterDhcpParser(void);

void *SCDhcpLoggerNew(const SCConfNode *conf);

void SCDhcpLoggerFree(void *logger);

bool SCDhcpLoggerLog(void *logger, void *tx, struct SCJsonBuilder *js);

bool SCDhcpLoggerDoLog(void *logger, void *tx);

uint8_t SCSipTxGetMethod(const struct SIPTransaction *tx,
                         const uint8_t **buffer,
                         uint32_t *buffer_len);

uint8_t SCSipTxGetUri(const struct SIPTransaction *tx,
                      const uint8_t **buffer,
                      uint32_t *buffer_len);

void SCDetectSipRegister(void);

bool SCSipLogJson(const struct SIPTransaction *tx, struct SCJsonBuilder *js);

void SCRegisterSipParser(void);

void SCDetectRfbRegister(void);

bool SCRfbJsonLogger(void *tx, struct SCJsonBuilder *js);

void SCRfbRegisterParser(void);

void SCDetectMqttRegister(void);

bool SCMqttLoggerLog(void *tx,
                     uint32_t flags,
                     uint32_t max_log_len,
                     struct SCJsonBuilder *js);

int SCMqttTxIsToClient(const struct MQTTTransaction *tx);

void SCMqttRegisterParser(void);

void SCDetectPgsqlRegister(void);

bool SCPgsqlLogger(void *tx, uint32_t flags, struct SCJsonBuilder *js);

void SCRegisterPgsqlParser(void);

void SCRegisterTelnetParser(void);

void SCDetectWebsocketRegister(void);

bool SCWebSocketLoggerLog(void *tx, struct SCJsonBuilder *js);

bool SCWebSocketLogDetails(const struct WebSocketTransaction *tx,
                           struct SCJsonBuilder *js,
                           bool pp,
                           bool pb64);

void SCRegisterWebSocketParser(void);

void SCDetectEnipRegister(void);

void SCEnipRegisterParsers(void);

bool SCEnipLoggerLog(void *tx, struct SCJsonBuilder *js);

bool SCPop3LoggerLog(void *tx, struct SCJsonBuilder *js);

void SCRegisterPop3Parser(void);

void SCRegisterTemplateParser(void);

void SCDetectTemplateRegister(void);

bool SCTemplateLoggerLog(const void *tx, void *js);

bool SCRdpToJson(const struct RdpTransaction *tx, struct SCJsonBuilder *js);

void SCRegisterRdpParser(void);

/**
 * Attempt to parse a X.509 from input, and return a pointer to the parsed object if successful.
 *
 * # Safety
 *
 * input must be a valid buffer of at least input_len bytes
 */
struct X509 *SCX509Decode(const uint8_t *input,
                          uint32_t input_len,
                          uint32_t *err_code);

char *SCX509GetSubject(const struct X509 *ptr);

uint16_t SCX509GetSubjectAltNameLen(const struct X509 *ptr);

char *SCX509GetSubjectAltNameAt(const struct X509 *ptr, uint16_t idx);

char *SCX509GetIssuer(const struct X509 *ptr);

char *SCX509GetSerial(const struct X509 *ptr);

/**
 * Extract validity from input X.509 object
 *
 * # Safety
 *
 * ptr must be a valid object obtained using `SCX509Decode`
 */
int32_t SCX509GetValidity(const struct X509 *ptr,
                          int64_t *not_before,
                          int64_t *not_after);

/**
 * Free a X.509 object allocated by Rust
 *
 * # Safety
 *
 * ptr must be a valid object obtained using `SCX509Decode`
 */
void SCX509Free(struct X509 *ptr);

/**
 * Format a x509 ISO timestamp into the provided C buffer.
 *
 * Returns false if an error occurs, otherwise true is returned if
 * the timestamp is properly formatted into the provided buffer.
 *
 * # Safety
 *
 * Access buffers from C that are expected to be valid.
 */
bool sc_x509_format_timestamp(int64_t timestamp, char *buf, uintptr_t size);

/**
 * Helper function to log a TLS timestamp from C to JSON with the
 * provided key. The format of the timestamp is ISO 8601 timestamp
 * with no sub-second or offset information as UTC is assumed.
 *
 * # Safety
 *
 * FFI function that dereferences pointers from C.
 */
bool sc_x509_log_timestamp(struct SCJsonBuilder *jb,
                           const char *key,
                           int64_t timestamp);

/**
 * Attempt to parse a Asn1 object from input, and return a pointer
 * to the parsed object if successful, null on failure
 *
 * # Safety
 *
 * input must be a valid buffer of at least input_len bytes
 * pointer must be freed using `SCAsn1Free`
 */
struct Asn1 *SCAsn1Decode(const uint8_t *input,
                          uint32_t input_len,
                          uint32_t buffer_offset,
                          const struct DetectAsn1Data *ad_ptr);

/**
 * Free a Asn1 object allocated by Rust
 *
 * # Safety
 *
 * ptr must be a valid object obtained using `SCAsn1Decode`
 */
void SCAsn1Free(struct Asn1 *ptr);

/**
 * This function implements the detection of the following options:
 *   - oversize_length
 *   - bitstring_overflow
 *   - double_overflow
 *
 * # Safety
 *
 * ptr must be a valid object obtained using `SCAsn1Decode`
 * ad_ptr must be a valid object obtained using `SCAsn1DetectParse`
 *
 * Returns 1 if any of the options match, 0 if not
 */
uint8_t SCAsn1Checks(const struct Asn1 *ptr,
                     const struct DetectAsn1Data *ad_ptr);

/**
 * Parse the asn1 keyword and return a pointer to a `DetectAsn1Data`
 * containing the parsed options, returns null on failure
 *
 * # Safety
 *
 * pointer must be free'd using `SCAsn1DetectFree`
 */
struct DetectAsn1Data *SCAsn1DetectParse(const char *input);

/**
 * Free a `DetectAsn1Data` object allocated by Rust
 *
 * # Safety
 *
 * ptr must be a valid object obtained using `SCAsn1DetectParse`
 */
void SCAsn1DetectFree(struct DetectAsn1Data *ptr);

/**
 * Intermediary function used in detect-email.c to access data from the MimeStateSMTP structure.
 * The hname parameter determines which data will be returned.
 */
uint8_t SCDetectMimeEmailGetData(const struct MimeStateSMTP *ctx,
                                 const uint8_t **buffer,
                                 uint32_t *buffer_len,
                                 const char *hname);

uint8_t SCDetectMimeEmailGetUrl(const struct MimeStateSMTP *ctx,
                                const uint8_t **buffer,
                                uint32_t *buffer_len,
                                uint32_t idx);

/**
 * Intermediary function used in detect-email.c to access data from the MimeStateSMTP structure
 * for array header fields.
 * The hname parameter determines which data will be returned.
 */
uint8_t SCDetectMimeEmailGetDataArray(const struct MimeStateSMTP *ctx,
                                      const uint8_t **buffer,
                                      uint32_t *buffer_len,
                                      const char *hname,
                                      uint32_t idx);

struct MimeStateHTTP *SCMimeStateInit(const uint8_t *input, uint32_t input_len);

MimeParserResult SCMimeParse(struct MimeStateHTTP *ctx,
                             const uint8_t *input,
                             uint32_t input_len,
                             uint32_t *consumed,
                             uint32_t *warnings);

void SCMimeStateGetFilename(struct MimeStateHTTP *ctx,
                            const uint8_t **buffer,
                            uint16_t *filename_len);

void SCMimeStateFree(struct MimeStateHTTP *ctx);

struct MimeStateSMTP *SCMimeSmtpStateInit(FileContainer *files,
                                          const StreamingBufferConfig *sbcfg);

void SCMimeSmtpStateFree(struct MimeStateSMTP *ctx);

extern int FileAppendData(FileContainer *c,
                          const StreamingBufferConfig *sbcfg,
                          const unsigned char *data,
                          uint32_t data_len);

extern uint32_t BasicSearchNocaseIndex(const unsigned char *data,
                                       uint32_t data_len,
                                       const unsigned char *needle,
                                       uint16_t needle_len);

MimeSmtpParserResult SCSmtpMimeParseLine(const uint8_t *input,
                                         uint32_t input_len,
                                         uint8_t delim_len,
                                         uint32_t *warnings,
                                         struct MimeStateSMTP *ctx);

void SCSmtpMimeComplete(struct MimeStateSMTP *ctx);

MimeSmtpParserState SCMimeSmtpGetState(struct MimeStateSMTP *ctx);

void SCMimeSmtpGetFilename(struct MimeStateSMTP *ctx,
                           const uint8_t **buffer,
                           uint16_t *filename_len);

bool SCMimeSmtpGetHeader(struct MimeStateSMTP *ctx,
                         const char *str,
                         const uint8_t **buffer,
                         uint32_t *buffer_len);

bool SCMimeSmtpGetHeaderName(struct MimeStateSMTP *ctx,
                             const uint8_t **buffer,
                             uint32_t *buffer_len,
                             uint32_t num);

void SCMimeSmtpConfigDecodeBase64(int val);

void SCMimeSmtpConfigDecodeQuoted(int val);

void SCMimeSmtpConfigExtractUrls(int val);

void SCMimeSmtpConfigLogUrlScheme(int val);

void SCMimeSmtpConfigBodyMd5(int val);

void SCMimeSmtpConfigHeaderValueDepth(uint32_t val);

int SCMimeSmtpConfigExtractUrlsSchemeAdd(const char *str);

bool SCMimeSmtpLogSubjectMd5(struct SCJsonBuilder *js,
                             const struct MimeStateSMTP *ctx);

bool SCMimeSmtpLogBodyMd5(struct SCJsonBuilder *js,
                          const struct MimeStateSMTP *ctx);

bool SCMimeSmtpLogFieldArray(struct SCJsonBuilder *js,
                             const struct MimeStateSMTP *ctx,
                             const char *email,
                             const char *config);

bool SCMimeSmtpLogFieldComma(struct SCJsonBuilder *js,
                             const struct MimeStateSMTP *ctx,
                             const char *email,
                             const char *config);

bool SCMimeSmtpLogFieldString(struct SCJsonBuilder *js,
                              const struct MimeStateSMTP *ctx,
                              const char *email,
                              const char *config);

bool SCMimeSmtpLogData(struct SCJsonBuilder *js,
                       const struct MimeStateSMTP *ctx);

uint8_t SCSshTxGetProtocol(void *tx,
                           const uint8_t **buffer,
                           uint32_t *buffer_len,
                           uint8_t direction);

uint8_t SCSshTxGetSoftware(void *tx,
                           const uint8_t **buffer,
                           uint32_t *buffer_len,
                           uint8_t direction);

uint8_t SCSshTxGetHassh(void *tx,
                        const uint8_t **buffer,
                        uint32_t *buffer_len,
                        uint8_t direction);

uint8_t SCSshTxGetHasshString(void *tx,
                              const uint8_t **buffer,
                              uint32_t *buffer_len,
                              uint8_t direction);

bool SCSshLogJson(void *tx, struct SCJsonBuilder *js);

void *SCSshStateGetTx(void *state, uint64_t _tx_id);

SSHConnectionState SCSshTxGetFlags(void *tx, uint8_t direction);

int SCSshTxGetAlStateProgress(void *tx, uint8_t direction);

void SCRegisterSshParser(void);

void SCSshEnableHassh(void);

bool SCSshHasshIsEnabled(void);

void SCSshEnableBypass(enum SshEncryptionHandling mode);

bool SCSshTxGetLogCondition(void *tx);

int SCHttp2TxHasFrametype(void *tx, uint8_t direction, uint8_t value);

int SCHttp2ParseFrametype(const char *str);

int SCHttp2TxHasErrorCode(void *tx, uint8_t direction, uint32_t code);

int SCHttp2ParseErrorCode(const char *str);

int SCHttp2TxGetNextPriority(void *tx, uint8_t direction, uint32_t nb);

int SCHttp2TxGetNextWindow(void *tx, uint8_t direction, uint32_t nb);

void *SCHttp2DetectSettingsCtxParse(const char *str);

void SCHttp2DetectSettingsCtxFree(void *ctx);

int SCHttp2DetectSettingsCtxMatch(const void *ctx, void *tx, uint8_t direction);

int SCHttp2DetectSizeUpdateCtxMatch(const void *ctx,
                                    void *tx,
                                    uint8_t direction);

bool SCHttp2TxGetHeaderName(DetectEngineThreadCtx *_de,
                            const void *tx,
                            uint8_t direction,
                            uint32_t nb,
                            const uint8_t **buffer,
                            uint32_t *buffer_len);

uint8_t SCHttp2TxGetRequestLine(struct HTTP2Transaction *tx,
                                const uint8_t **buffer,
                                uint32_t *buffer_len);

uint8_t SCHttp2TxGetResponseLine(struct HTTP2Transaction *tx,
                                 const uint8_t **buffer,
                                 uint32_t *buffer_len);

uint8_t SCHttp2TxGetUri(struct HTTP2Transaction *tx,
                        const uint8_t **buffer,
                        uint32_t *buffer_len);

uint8_t SCHttp2TxGetMethod(struct HTTP2Transaction *tx,
                           const uint8_t **buffer,
                           uint32_t *buffer_len);

uint8_t SCHttp2TxGetHost(struct HTTP2Transaction *tx,
                         const uint8_t **buffer,
                         uint32_t *buffer_len);

uint8_t SCHttp2TxGetHostNorm(struct HTTP2Transaction *tx,
                             const uint8_t **buffer,
                             uint32_t *buffer_len);

uint8_t SCHttp2TxGetUserAgent(struct HTTP2Transaction *tx,
                              const uint8_t **buffer,
                              uint32_t *buffer_len);

uint8_t SCHttp2TxGetStatus(struct HTTP2Transaction *tx,
                           const uint8_t **buffer,
                           uint32_t *buffer_len);

uint8_t SCHttp2TxGetCookie(struct HTTP2Transaction *tx,
                           uint8_t direction,
                           const uint8_t **buffer,
                           uint32_t *buffer_len);

uint8_t SCHttp2TxGetHeaderValue(struct HTTP2Transaction *tx,
                                uint8_t direction,
                                const char *strname,
                                const uint8_t **buffer,
                                uint32_t *buffer_len);

uint8_t SCHttp2TxGetHeaderNames(struct HTTP2Transaction *tx,
                                uint8_t direction,
                                const uint8_t **buffer,
                                uint32_t *buffer_len);

uint8_t SCHttp2TxGetHeaders(struct HTTP2Transaction *tx,
                            uint8_t direction,
                            const uint8_t **buffer,
                            uint32_t *buffer_len);

uint8_t SCHttp2TxGetHeadersRaw(struct HTTP2Transaction *tx,
                               uint8_t direction,
                               const uint8_t **buffer,
                               uint32_t *buffer_len);

bool SCHttp2TxGetHeader(DetectEngineThreadCtx *_de,
                        const void *tx,
                        uint8_t direction,
                        uint32_t nb,
                        const uint8_t **buffer,
                        uint32_t *buffer_len);

void SCHttp2TxSetMethod(struct HTTP2State *state,
                        const uint8_t *buffer,
                        uint32_t buffer_len);

void SCHttp2TxSetUri(struct HTTP2State *state,
                     const uint8_t *buffer,
                     uint32_t buffer_len);

void SCHttp2TxAddHeader(struct HTTP2State *state,
                        const uint8_t *name,
                        uint32_t name_len,
                        const uint8_t *value,
                        uint32_t value_len);

void SCHttp2Init(SuricataFileContext *context);

void *SCDoH2GetDnsTx(const struct HTTP2Transaction *tx, uint8_t flags);

extern void HTTP2MimicHttp1Request(void *orig_state, void *new_state);

void SCRegisterHttp2Parser(void);

bool SCHttp2LogJson(void *tx, struct SCJsonBuilder *js);

int SCHttpParseContentRange(struct HTTPContentRange *cr,
                            const uint8_t *buffer,
                            uint32_t buffer_len);

extern HttpRangeContainerBlock *HttpRangeContainerOpenFile(const unsigned char *key,
                                                           uint32_t keylen,
                                                           const Flow *f,
                                                           const struct HTTPContentRange *cr,
                                                           const StreamingBufferConfig *sbcfg,
                                                           const unsigned char *name,
                                                           uint16_t name_len,
                                                           uint16_t flags,
                                                           const unsigned char *data,
                                                           uint32_t data_len);

extern int HttpRangeAppendData(const StreamingBufferConfig *cfg,
                               HttpRangeContainerBlock *c,
                               const unsigned char *data,
                               uint32_t data_len);

uint8_t SCQuicTxGetUa(const struct QuicTransaction *tx,
                      const uint8_t **buffer,
                      uint32_t *buffer_len);

uint8_t SCQuicTxGetSni(const struct QuicTransaction *tx,
                       const uint8_t **buffer,
                       uint32_t *buffer_len);

bool SCQuicTxGetJa3(const struct QuicTransaction *tx,
                    uint8_t dir,
                    const uint8_t **buffer,
                    uint32_t *buffer_len);

uint8_t SCQuicTxGetJa4(const struct QuicTransaction *tx,
                       const uint8_t **buffer,
                       uint32_t *buffer_len);

uint8_t SCQuicTxGetVersion(const struct QuicTransaction *tx,
                           const uint8_t **buffer,
                           uint32_t *buffer_len);

bool SCQuicTxGetCyuHash(DetectEngineThreadCtx *_de,
                        const void *tx,
                        uint8_t _flags,
                        uint32_t i,
                        const uint8_t **buffer,
                        uint32_t *buffer_len);

bool SCQuicTxGetCyuString(DetectEngineThreadCtx *_de,
                          const void *tx,
                          uint8_t _flags,
                          uint32_t i,
                          const uint8_t **buffer,
                          uint32_t *buffer_len);

bool SCQuicLogJson(void *tx, struct SCJsonBuilder *js);

void SCRegisterQuicParser(void);

void SCRegisterBittorrentDhtUdpParser(void);

bool SCBittorrentDhtLogger(void *tx, struct SCJsonBuilder *js);

/**
 * Use the lzma algorithm to decompress a chunk of data.
 */
enum LzmaStatus lzma_decompress(const uint8_t *input,
                                uintptr_t *input_len,
                                uint8_t *output,
                                uintptr_t *output_len,
                                uintptr_t memlimit);

bool SCCheckUtf8(const char *val);

uint32_t SCValidateDomain(const uint8_t *input, uint32_t in_len);

struct SCSha256 *SCSha256New(void);

void SCSha256Update(struct SCSha256 *hasher,
                    const uint8_t *bytes,
                    uint32_t len);

void SCSha256Finalize(struct SCSha256 *hasher, uint8_t *out, uint32_t len);

/**
 * C function to finalize the Sha256 hasher to a hex string.
 *
 * Notes:
 * - There is probably room for optimization here, by iterating the result and writing
 *   the output directly to the output buffer.
 *
 * But even given the notes, this appears to be faster than the equivalent that we
 * did in C using NSS.
 */
bool SCSha256FinalizeToHex(struct SCSha256 *hasher,
                           char *out,
                           uint32_t len);

/**
 * Free an unfinalized Sha256 context.
 */
void SCSha256Free(struct SCSha256 *hasher);

bool SCSha256HashBuffer(const uint8_t *buf,
                        uint32_t buf_len,
                        uint8_t *out,
                        uint32_t len);

bool SCSha256HashBufferToHex(const uint8_t *buf,
                             uint32_t buf_len,
                             char *out,
                             uint32_t len);

struct SCSha1 *SCSha1New(void);

void SCSha1Update(struct SCSha1 *hasher, const uint8_t *bytes, uint32_t len);

void SCSha1Finalize(struct SCSha1 *hasher, uint8_t *out, uint32_t len);

bool SCSha1FinalizeToHex(struct SCSha1 *hasher, char *out, uint32_t len);

/**
 * Free an unfinalized Sha1 context.
 */
void SCSha1Free(struct SCSha1 *hasher);

bool SCSha1HashBuffer(const uint8_t *buf,
                      uint32_t buf_len,
                      uint8_t *out,
                      uint32_t len);

bool SCSha1HashBufferToHex(const uint8_t *buf,
                           uint32_t buf_len,
                           char *out,
                           uint32_t len);

struct SCMd5 *SCMd5New(void);

void SCMd5Update(struct SCMd5 *hasher, const uint8_t *bytes, uint32_t len);

/**
 * Finalize the MD5 hash placing the digest in the provided out buffer.
 *
 * This function consumes the SCMd5 hash context.
 */
void SCMd5Finalize(struct SCMd5 *hasher, uint8_t *out, uint32_t len);

/**
 * Finalize MD5 context to a hex string.
 *
 * Consumes the hash context and cannot be re-used.
 */
bool SCMd5FinalizeToHex(struct SCMd5 *hasher, char *out, uint32_t len);

/**
 * Free an unfinalized Sha1 context.
 */
void SCMd5Free(struct SCMd5 *hasher);

bool SCMd5HashBuffer(const uint8_t *buf,
                     uint32_t buf_len,
                     uint8_t *out,
                     uint32_t len);

/**
 * C binding for a function to MD5 hash a single buffer to a hex string.
 */
bool SCMd5HashBufferToHex(const uint8_t *buf,
                          uint32_t buf_len,
                          char *out,
                          uint32_t len);

void SCDisableHashing(void);

uint32_t SCBase64DecodeBufferSize(uint32_t input_len);

/**
 * Base64 decode a buffer.
 *
 * This method exposes the Rust base64 decoder to C and should not be called from
 * Rust code.
 *
 * It allows decoding in the modes described by ``SCBase64Mode`` enum.
 */
uint32_t SCBase64Decode(const uint8_t *input,
                        uintptr_t len,
                        SCBase64Mode mode,
                        uint8_t *output);

/**
 * Base64 encode a buffer with a provided mode.
 *
 * This method exposes the Rust base64 encoder to C and should not be called from
 * Rust code.
 *
 * The output parameter must be an allocated buffer of at least the size returned
 * from SCBase64EncodeBufferSize for the input_len, and this length must be provided
 * in the output_len variable.
 */
enum SCBase64ReturnCode SCBase64EncodeWithMode(const uint8_t *input,
                                               unsigned long input_len,
                                               unsigned char *output,
                                               unsigned long *output_len,
                                               SCBase64Mode mode);

/**
 * Base64 encode a buffer.
 *
 * This method exposes the Rust base64 encoder to C and should not be called from
 * Rust code.
 *
 * The output parameter must be an allocated buffer of at least the size returned
 * from SCBase64EncodeBufferSize for the input_len, and this length must be provided
 * in the output_len variable.
 */
enum SCBase64ReturnCode SCBase64Encode(const uint8_t *input,
                                       unsigned long input_len,
                                       unsigned char *output,
                                       unsigned long *output_len);

/**
 * Ratio of output bytes to input bytes for Base64 Encoding is 4:3, hence the
 * required output bytes are 4 * ceil(input_len / 3) and an additional byte for
 * storing the NULL pointer.
 */
unsigned long SCBase64EncodeBufferSize(unsigned long len);

extern bool RequiresFeature(const char *feature);

extern bool SigTableHasKeyword(const char *keyword);

void SCDetectSdpRegister(void);

void SCDetectLdapRegister(void);

void SCRegisterLdapTcpParser(void);

void SCRegisterLdapUdpParser(void);

bool SCLdapLoggerLog(void *tx, struct SCJsonBuilder *js);

#endif /* __RUST_BINDINGS_GEN_H_ */
