# Infrared Longwave Window - Band 14

As described in *Band 14 - ABI Quick Information Guide* by Lindstrom et al. [1], even though the 11.2 µm (Band 14) band is a window channel, at this wavelength, the water vapor absorbs energy, affecting the brightness temperatures.

In general, the brightness temperatures will be cooler than those seen in the 10.3 µm window. This is, by part, due to the amount of moisture in the atmosphere.

For Lindstrom et al. [1], the usage is similar to the "clean" 10.3 µm window, even though, comparatively, there's more absorption of energy. Thus clear-sky brightness temperatures are more influenced by water vapor.

### Intended usage

This composite is used primarily to diagnose discrete clouds and organized features for general weather forecasting, analysis, and broadcasting applications.


### Appearance

The brightness temperatures over cold could tops, like overshooting tops, will be shown similarly to the 10.3 µm Band composite, "because there is little water vapor above the overshoot to absorb the energy." Lindstrom et al. [1].

Clean air over land or water will be cooler than on 10.3 µm because of the absorption of energy by the water vapor.

![Scale](lut/cal/abi_ir_11-15.png)

### Limitations

According to Lindstrom et al. [1], the limitations are that, at this wavelength, the water vapor absorbs more atmospheric energy than compared to the 10.3 µm band, which is subsequently re-emitted from higher, cooler temperatures. "Thus, surface or near-surface clear-sky brightness temperatures will be cooler than observed by an amount that is a function of the amount of moisture in the atmosphere" Lindstrom et al. [1]. Additionally, this band is less affected than the 12.3 µm band.


### References

1. S. Lindstrom, T. Schmit and J. Gerth "Band 14 - ABI Quick Information Guide", UW-Madison CIMSS/NOAA, Aug. 2017, https://cimss.ssec.wisc.edu/goes/OCLOFactSheetPDFs/ABIQuickGuide_Band14.pdf. [View Article](https://cimss.ssec.wisc.edu/goes/OCLOFactSheetPDFs/ABIQuickGuide_Band14.pdf)
