

#ifdef SOLARIS
#  include <utmpx.h>
#else
#  include <utmp.h>
#  include <paths.h>
#endif

#ifdef BSD
#  define ut_user ut_name
#endif

/* Weee... */
#ifdef WTMPX_FILE
#  define _PATH_WTMP WTMPX_FILE
#else
#  ifndef WTMP_FILE
     /* FSSTND (now FHS) compliance courtesy of Edward S. Marshall */
#    ifndef _PATH_WTMP
#      define _PATH_WTMP "/var/log/wtmp" /* FSSTND compliant */
#    endif
#  else
#    ifndef _PATH_WTMP
#      define _PATH_WTMP WTMP_FILE
#    endif
#  endif
#endif

#ifndef RADIUS_DIR
#  define RADIUS_DIR	"/usr/adm/radacct"
#endif

/* This is _NOT_ a good way to do this. */
#ifdef SOLARIS
#  define UT_NAMESIZE	32
#  define UT_LINESIZE	32
#  define UT_HOSTSIZE	257
#  define utmp utmpx
#  define ut_time ut_tv.tv_sec
#endif

struct tacacs3_utmp {
  char ut_line[8];
  char ut_user[8];
  char ut_host[16];
  time_t ut_tactime;
};

struct tacacs4_utmp {
  char ut_line[8];
  char ut_user[8];
  char ut_host[16];
  time_t ut_tactime;
  char ut_comment[16];
};

#define LIBC6_LINESIZE	32
#define LIBC6_NAMESIZE	32
#define LIBC6_HOSTSIZE	256

struct libc6_utmp {
  short int ut_type;            /* Type of login.  */
  pid_t ut_pid;                 /* Process ID of login process.  */
  char ut_line[LIBC6_LINESIZE]; /* Devicename.  */
  char ut_id[4];                /* Inittab ID.  */
  char ut_user[LIBC6_NAMESIZE]; /* Username.  */
  char ut_host[LIBC6_HOSTSIZE]; /* Hostname for remote login.  */
  struct libc6_exit_status {
    short int e_termination;    /* Process termination status.  */
    short int e_exit;           /* Process exit status.  */
  } ut_exit;			/* Exit status of a process marked as DEAD_PROCESS. */
  long int ut_session;          /* Session ID, used for windowing.  */
  struct timeval ut_tv;         /* Time entry was made.  */
  int32_t ut_addr_v6[4];        /* Internet address of remote host.  */
  char __unused[20];            /* Reserved for future use.  */
};

#define LIBC5_LINESIZE	12
#define LIBC5_NAMESIZE	8
#define LIBC5_HOSTSIZE	16

struct libc5_utmp {
  short ut_type;		/* type of login */
  pid_t ut_pid;			/* pid of login-process */
  char ut_line[LIBC5_LINESIZE];	/* devicename of tty -"/dev/", null-term */
  char ut_id[4];		/* abbrev. ttyname, as 01, s1 etc. */
  time_t ut_5time;		/* logintime */
  char ut_user[LIBC5_NAMESIZE];	/* username, not null-term */
  char ut_host[LIBC5_HOSTSIZE];	/* hostname for remote login... */
  long ut_5addr;		/* IP addr of remote host */
};

#define BSD_LINESIZE  8
#define BSD_NAMESIZE  16
#define BSD_HOSTSIZE  16

struct bsd_utmp {
  char ut_line[BSD_LINESIZE];
  char ut_name[BSD_NAMESIZE];
  char ut_host[BSD_HOSTSIZE];
  time_t ut_bsdtime;
};

struct sactmp {
  struct utmp u;
  /* detail files have lots of extra fun stuff */
  double inoct, outoct;
  double inpkt, outpkt;
  u_long datarate;
  char callid[32];
};
