//! Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline 25519_scalar 64 '2^252 + 27742317777372353535851937790883648493' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
//! curve description: 25519_scalar
//! machine_wordsize = 64 (from "64")
//! requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
//! m = 0x1000000000000000000000000000000014def9dea2f79cd65812631a5cf5d3ed (from "2^252 + 27742317777372353535851937790883648493")
//!
//! NOTE: In addition to the bounds specified above each function, all
//!   functions synthesized for this Montgomery arithmetic require the
//!   input to be strictly less than the prime modulus (m), and also
//!   require the input to be in the unique saturated representation.
//!   All functions also ensure that these two properties are true of
//!   return values.
//!
//! Computed values:
//!   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248)
//!   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) in
//!                            if x1 & (2^256-1) < 2^255 then x1 & (2^256-1) else (x1 & (2^256-1)) - 2^256

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

pub type fiat_25519_scalar_u1 = u8;
pub type fiat_25519_scalar_i1 = i8;
pub type fiat_25519_scalar_u2 = u8;
pub type fiat_25519_scalar_i2 = i8;

/** The type fiat_25519_scalar_montgomery_domain_field_element is a field element in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_25519_scalar_montgomery_domain_field_element(pub [u64; 4]);

impl core::ops::Index<usize> for fiat_25519_scalar_montgomery_domain_field_element {
    type Output = u64;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_25519_scalar_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

/** The type fiat_25519_scalar_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_25519_scalar_non_montgomery_domain_field_element(pub [u64; 4]);

impl core::ops::Index<usize> for fiat_25519_scalar_non_montgomery_domain_field_element {
    type Output = u64;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_25519_scalar_non_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}


/// The function fiat_25519_scalar_addcarryx_u64 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^64
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_25519_scalar_addcarryx_u64(out1: &mut u64, out2: &mut fiat_25519_scalar_u1, arg1: fiat_25519_scalar_u1, arg2: u64, arg3: u64) {
  let x1: u128 = (((arg1 as u128) + (arg2 as u128)) + (arg3 as u128));
  let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
  let x3: fiat_25519_scalar_u1 = ((x1 >> 64) as fiat_25519_scalar_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_25519_scalar_subborrowx_u64 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^64
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_25519_scalar_subborrowx_u64(out1: &mut u64, out2: &mut fiat_25519_scalar_u1, arg1: fiat_25519_scalar_u1, arg2: u64, arg3: u64) {
  let x1: i128 = (((arg2 as i128) - (arg1 as i128)) - (arg3 as i128));
  let x2: fiat_25519_scalar_i1 = ((x1 >> 64) as fiat_25519_scalar_i1);
  let x3: u64 = ((x1 & (0xffffffffffffffff as i128)) as u64);
  *out1 = x3;
  *out2 = (((0x0 as fiat_25519_scalar_i2) - (x2 as fiat_25519_scalar_i2)) as fiat_25519_scalar_u1);
}

/// The function fiat_25519_scalar_mulx_u64 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^64
///   out2 = ⌊arg1 * arg2 / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_25519_scalar_mulx_u64(out1: &mut u64, out2: &mut u64, arg1: u64, arg2: u64) {
  let x1: u128 = ((arg1 as u128) * (arg2 as u128));
  let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
  let x3: u64 = ((x1 >> 64) as u64);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_25519_scalar_cmovznz_u64 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_25519_scalar_cmovznz_u64(out1: &mut u64, arg1: fiat_25519_scalar_u1, arg2: u64, arg3: u64) {
  let x1: fiat_25519_scalar_u1 = (!(!arg1));
  let x2: u64 = ((((((0x0 as fiat_25519_scalar_i2) - (x1 as fiat_25519_scalar_i2)) as fiat_25519_scalar_i1) as i128) & (0xffffffffffffffff as i128)) as u64);
  let x3: u64 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_25519_scalar_mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_mul(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element, arg2: &fiat_25519_scalar_montgomery_domain_field_element) {
  let x1: u64 = (arg1[1]);
  let x2: u64 = (arg1[2]);
  let x3: u64 = (arg1[3]);
  let x4: u64 = (arg1[0]);
  let mut x5: u64 = 0;
  let mut x6: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x5, &mut x6, x4, (arg2[3]));
  let mut x7: u64 = 0;
  let mut x8: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x7, &mut x8, x4, (arg2[2]));
  let mut x9: u64 = 0;
  let mut x10: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x9, &mut x10, x4, (arg2[1]));
  let mut x11: u64 = 0;
  let mut x12: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x11, &mut x12, x4, (arg2[0]));
  let mut x13: u64 = 0;
  let mut x14: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x13, &mut x14, 0x0, x12, x9);
  let mut x15: u64 = 0;
  let mut x16: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x15, &mut x16, x14, x10, x7);
  let mut x17: u64 = 0;
  let mut x18: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x17, &mut x18, x16, x8, x5);
  let x19: u64 = ((x18 as u64) + x6);
  let mut x20: u64 = 0;
  let mut x21: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x20, &mut x21, x11, 0xd2b51da312547e1b);
  let mut x22: u64 = 0;
  let mut x23: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x22, &mut x23, x20, 0x1000000000000000);
  let mut x24: u64 = 0;
  let mut x25: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x24, &mut x25, x20, 0x14def9dea2f79cd6);
  let mut x26: u64 = 0;
  let mut x27: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x26, &mut x27, x20, 0x5812631a5cf5d3ed);
  let mut x28: u64 = 0;
  let mut x29: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x28, &mut x29, 0x0, x27, x24);
  let x30: u64 = ((x29 as u64) + x25);
  let mut x31: u64 = 0;
  let mut x32: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x31, &mut x32, 0x0, x11, x26);
  let mut x33: u64 = 0;
  let mut x34: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x33, &mut x34, x32, x13, x28);
  let mut x35: u64 = 0;
  let mut x36: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x35, &mut x36, x34, x15, x30);
  let mut x37: u64 = 0;
  let mut x38: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x37, &mut x38, x36, x17, x22);
  let mut x39: u64 = 0;
  let mut x40: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x39, &mut x40, x38, x19, x23);
  let mut x41: u64 = 0;
  let mut x42: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x41, &mut x42, x1, (arg2[3]));
  let mut x43: u64 = 0;
  let mut x44: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x43, &mut x44, x1, (arg2[2]));
  let mut x45: u64 = 0;
  let mut x46: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x45, &mut x46, x1, (arg2[1]));
  let mut x47: u64 = 0;
  let mut x48: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x47, &mut x48, x1, (arg2[0]));
  let mut x49: u64 = 0;
  let mut x50: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x49, &mut x50, 0x0, x48, x45);
  let mut x51: u64 = 0;
  let mut x52: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x51, &mut x52, x50, x46, x43);
  let mut x53: u64 = 0;
  let mut x54: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x53, &mut x54, x52, x44, x41);
  let x55: u64 = ((x54 as u64) + x42);
  let mut x56: u64 = 0;
  let mut x57: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x56, &mut x57, 0x0, x33, x47);
  let mut x58: u64 = 0;
  let mut x59: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x58, &mut x59, x57, x35, x49);
  let mut x60: u64 = 0;
  let mut x61: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x60, &mut x61, x59, x37, x51);
  let mut x62: u64 = 0;
  let mut x63: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x62, &mut x63, x61, x39, x53);
  let mut x64: u64 = 0;
  let mut x65: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x64, &mut x65, x63, (x40 as u64), x55);
  let mut x66: u64 = 0;
  let mut x67: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x66, &mut x67, x56, 0xd2b51da312547e1b);
  let mut x68: u64 = 0;
  let mut x69: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x68, &mut x69, x66, 0x1000000000000000);
  let mut x70: u64 = 0;
  let mut x71: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x70, &mut x71, x66, 0x14def9dea2f79cd6);
  let mut x72: u64 = 0;
  let mut x73: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x72, &mut x73, x66, 0x5812631a5cf5d3ed);
  let mut x74: u64 = 0;
  let mut x75: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x74, &mut x75, 0x0, x73, x70);
  let x76: u64 = ((x75 as u64) + x71);
  let mut x77: u64 = 0;
  let mut x78: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x77, &mut x78, 0x0, x56, x72);
  let mut x79: u64 = 0;
  let mut x80: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x79, &mut x80, x78, x58, x74);
  let mut x81: u64 = 0;
  let mut x82: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x81, &mut x82, x80, x60, x76);
  let mut x83: u64 = 0;
  let mut x84: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x83, &mut x84, x82, x62, x68);
  let mut x85: u64 = 0;
  let mut x86: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x85, &mut x86, x84, x64, x69);
  let x87: u64 = ((x86 as u64) + (x65 as u64));
  let mut x88: u64 = 0;
  let mut x89: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x88, &mut x89, x2, (arg2[3]));
  let mut x90: u64 = 0;
  let mut x91: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x90, &mut x91, x2, (arg2[2]));
  let mut x92: u64 = 0;
  let mut x93: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x92, &mut x93, x2, (arg2[1]));
  let mut x94: u64 = 0;
  let mut x95: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x94, &mut x95, x2, (arg2[0]));
  let mut x96: u64 = 0;
  let mut x97: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x96, &mut x97, 0x0, x95, x92);
  let mut x98: u64 = 0;
  let mut x99: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x98, &mut x99, x97, x93, x90);
  let mut x100: u64 = 0;
  let mut x101: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x100, &mut x101, x99, x91, x88);
  let x102: u64 = ((x101 as u64) + x89);
  let mut x103: u64 = 0;
  let mut x104: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x103, &mut x104, 0x0, x79, x94);
  let mut x105: u64 = 0;
  let mut x106: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x105, &mut x106, x104, x81, x96);
  let mut x107: u64 = 0;
  let mut x108: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x107, &mut x108, x106, x83, x98);
  let mut x109: u64 = 0;
  let mut x110: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x109, &mut x110, x108, x85, x100);
  let mut x111: u64 = 0;
  let mut x112: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x111, &mut x112, x110, x87, x102);
  let mut x113: u64 = 0;
  let mut x114: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x113, &mut x114, x103, 0xd2b51da312547e1b);
  let mut x115: u64 = 0;
  let mut x116: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x115, &mut x116, x113, 0x1000000000000000);
  let mut x117: u64 = 0;
  let mut x118: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x117, &mut x118, x113, 0x14def9dea2f79cd6);
  let mut x119: u64 = 0;
  let mut x120: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x119, &mut x120, x113, 0x5812631a5cf5d3ed);
  let mut x121: u64 = 0;
  let mut x122: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x121, &mut x122, 0x0, x120, x117);
  let x123: u64 = ((x122 as u64) + x118);
  let mut x124: u64 = 0;
  let mut x125: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x124, &mut x125, 0x0, x103, x119);
  let mut x126: u64 = 0;
  let mut x127: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x126, &mut x127, x125, x105, x121);
  let mut x128: u64 = 0;
  let mut x129: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x128, &mut x129, x127, x107, x123);
  let mut x130: u64 = 0;
  let mut x131: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x130, &mut x131, x129, x109, x115);
  let mut x132: u64 = 0;
  let mut x133: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x132, &mut x133, x131, x111, x116);
  let x134: u64 = ((x133 as u64) + (x112 as u64));
  let mut x135: u64 = 0;
  let mut x136: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x135, &mut x136, x3, (arg2[3]));
  let mut x137: u64 = 0;
  let mut x138: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x137, &mut x138, x3, (arg2[2]));
  let mut x139: u64 = 0;
  let mut x140: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x139, &mut x140, x3, (arg2[1]));
  let mut x141: u64 = 0;
  let mut x142: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x141, &mut x142, x3, (arg2[0]));
  let mut x143: u64 = 0;
  let mut x144: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x143, &mut x144, 0x0, x142, x139);
  let mut x145: u64 = 0;
  let mut x146: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x145, &mut x146, x144, x140, x137);
  let mut x147: u64 = 0;
  let mut x148: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x147, &mut x148, x146, x138, x135);
  let x149: u64 = ((x148 as u64) + x136);
  let mut x150: u64 = 0;
  let mut x151: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x150, &mut x151, 0x0, x126, x141);
  let mut x152: u64 = 0;
  let mut x153: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x152, &mut x153, x151, x128, x143);
  let mut x154: u64 = 0;
  let mut x155: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x154, &mut x155, x153, x130, x145);
  let mut x156: u64 = 0;
  let mut x157: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x156, &mut x157, x155, x132, x147);
  let mut x158: u64 = 0;
  let mut x159: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x158, &mut x159, x157, x134, x149);
  let mut x160: u64 = 0;
  let mut x161: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x160, &mut x161, x150, 0xd2b51da312547e1b);
  let mut x162: u64 = 0;
  let mut x163: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x162, &mut x163, x160, 0x1000000000000000);
  let mut x164: u64 = 0;
  let mut x165: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x164, &mut x165, x160, 0x14def9dea2f79cd6);
  let mut x166: u64 = 0;
  let mut x167: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x166, &mut x167, x160, 0x5812631a5cf5d3ed);
  let mut x168: u64 = 0;
  let mut x169: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x168, &mut x169, 0x0, x167, x164);
  let x170: u64 = ((x169 as u64) + x165);
  let mut x171: u64 = 0;
  let mut x172: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x171, &mut x172, 0x0, x150, x166);
  let mut x173: u64 = 0;
  let mut x174: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x173, &mut x174, x172, x152, x168);
  let mut x175: u64 = 0;
  let mut x176: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x175, &mut x176, x174, x154, x170);
  let mut x177: u64 = 0;
  let mut x178: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x177, &mut x178, x176, x156, x162);
  let mut x179: u64 = 0;
  let mut x180: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x179, &mut x180, x178, x158, x163);
  let x181: u64 = ((x180 as u64) + (x159 as u64));
  let mut x182: u64 = 0;
  let mut x183: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x182, &mut x183, 0x0, x173, 0x5812631a5cf5d3ed);
  let mut x184: u64 = 0;
  let mut x185: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x184, &mut x185, x183, x175, 0x14def9dea2f79cd6);
  let mut x186: u64 = 0;
  let mut x187: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x186, &mut x187, x185, x177, (0x0 as u64));
  let mut x188: u64 = 0;
  let mut x189: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x188, &mut x189, x187, x179, 0x1000000000000000);
  let mut x190: u64 = 0;
  let mut x191: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x190, &mut x191, x189, x181, (0x0 as u64));
  let mut x192: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x192, x191, x182, x173);
  let mut x193: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x193, x191, x184, x175);
  let mut x194: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x194, x191, x186, x177);
  let mut x195: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x195, x191, x188, x179);
  out1[0] = x192;
  out1[1] = x193;
  out1[2] = x194;
  out1[3] = x195;
}

/// The function fiat_25519_scalar_square squares a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_square(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element) {
  let x1: u64 = (arg1[1]);
  let x2: u64 = (arg1[2]);
  let x3: u64 = (arg1[3]);
  let x4: u64 = (arg1[0]);
  let mut x5: u64 = 0;
  let mut x6: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x5, &mut x6, x4, (arg1[3]));
  let mut x7: u64 = 0;
  let mut x8: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x7, &mut x8, x4, (arg1[2]));
  let mut x9: u64 = 0;
  let mut x10: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x9, &mut x10, x4, (arg1[1]));
  let mut x11: u64 = 0;
  let mut x12: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x11, &mut x12, x4, (arg1[0]));
  let mut x13: u64 = 0;
  let mut x14: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x13, &mut x14, 0x0, x12, x9);
  let mut x15: u64 = 0;
  let mut x16: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x15, &mut x16, x14, x10, x7);
  let mut x17: u64 = 0;
  let mut x18: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x17, &mut x18, x16, x8, x5);
  let x19: u64 = ((x18 as u64) + x6);
  let mut x20: u64 = 0;
  let mut x21: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x20, &mut x21, x11, 0xd2b51da312547e1b);
  let mut x22: u64 = 0;
  let mut x23: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x22, &mut x23, x20, 0x1000000000000000);
  let mut x24: u64 = 0;
  let mut x25: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x24, &mut x25, x20, 0x14def9dea2f79cd6);
  let mut x26: u64 = 0;
  let mut x27: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x26, &mut x27, x20, 0x5812631a5cf5d3ed);
  let mut x28: u64 = 0;
  let mut x29: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x28, &mut x29, 0x0, x27, x24);
  let x30: u64 = ((x29 as u64) + x25);
  let mut x31: u64 = 0;
  let mut x32: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x31, &mut x32, 0x0, x11, x26);
  let mut x33: u64 = 0;
  let mut x34: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x33, &mut x34, x32, x13, x28);
  let mut x35: u64 = 0;
  let mut x36: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x35, &mut x36, x34, x15, x30);
  let mut x37: u64 = 0;
  let mut x38: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x37, &mut x38, x36, x17, x22);
  let mut x39: u64 = 0;
  let mut x40: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x39, &mut x40, x38, x19, x23);
  let mut x41: u64 = 0;
  let mut x42: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x41, &mut x42, x1, (arg1[3]));
  let mut x43: u64 = 0;
  let mut x44: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x43, &mut x44, x1, (arg1[2]));
  let mut x45: u64 = 0;
  let mut x46: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x45, &mut x46, x1, (arg1[1]));
  let mut x47: u64 = 0;
  let mut x48: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x47, &mut x48, x1, (arg1[0]));
  let mut x49: u64 = 0;
  let mut x50: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x49, &mut x50, 0x0, x48, x45);
  let mut x51: u64 = 0;
  let mut x52: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x51, &mut x52, x50, x46, x43);
  let mut x53: u64 = 0;
  let mut x54: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x53, &mut x54, x52, x44, x41);
  let x55: u64 = ((x54 as u64) + x42);
  let mut x56: u64 = 0;
  let mut x57: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x56, &mut x57, 0x0, x33, x47);
  let mut x58: u64 = 0;
  let mut x59: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x58, &mut x59, x57, x35, x49);
  let mut x60: u64 = 0;
  let mut x61: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x60, &mut x61, x59, x37, x51);
  let mut x62: u64 = 0;
  let mut x63: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x62, &mut x63, x61, x39, x53);
  let mut x64: u64 = 0;
  let mut x65: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x64, &mut x65, x63, (x40 as u64), x55);
  let mut x66: u64 = 0;
  let mut x67: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x66, &mut x67, x56, 0xd2b51da312547e1b);
  let mut x68: u64 = 0;
  let mut x69: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x68, &mut x69, x66, 0x1000000000000000);
  let mut x70: u64 = 0;
  let mut x71: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x70, &mut x71, x66, 0x14def9dea2f79cd6);
  let mut x72: u64 = 0;
  let mut x73: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x72, &mut x73, x66, 0x5812631a5cf5d3ed);
  let mut x74: u64 = 0;
  let mut x75: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x74, &mut x75, 0x0, x73, x70);
  let x76: u64 = ((x75 as u64) + x71);
  let mut x77: u64 = 0;
  let mut x78: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x77, &mut x78, 0x0, x56, x72);
  let mut x79: u64 = 0;
  let mut x80: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x79, &mut x80, x78, x58, x74);
  let mut x81: u64 = 0;
  let mut x82: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x81, &mut x82, x80, x60, x76);
  let mut x83: u64 = 0;
  let mut x84: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x83, &mut x84, x82, x62, x68);
  let mut x85: u64 = 0;
  let mut x86: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x85, &mut x86, x84, x64, x69);
  let x87: u64 = ((x86 as u64) + (x65 as u64));
  let mut x88: u64 = 0;
  let mut x89: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x88, &mut x89, x2, (arg1[3]));
  let mut x90: u64 = 0;
  let mut x91: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x90, &mut x91, x2, (arg1[2]));
  let mut x92: u64 = 0;
  let mut x93: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x92, &mut x93, x2, (arg1[1]));
  let mut x94: u64 = 0;
  let mut x95: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x94, &mut x95, x2, (arg1[0]));
  let mut x96: u64 = 0;
  let mut x97: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x96, &mut x97, 0x0, x95, x92);
  let mut x98: u64 = 0;
  let mut x99: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x98, &mut x99, x97, x93, x90);
  let mut x100: u64 = 0;
  let mut x101: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x100, &mut x101, x99, x91, x88);
  let x102: u64 = ((x101 as u64) + x89);
  let mut x103: u64 = 0;
  let mut x104: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x103, &mut x104, 0x0, x79, x94);
  let mut x105: u64 = 0;
  let mut x106: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x105, &mut x106, x104, x81, x96);
  let mut x107: u64 = 0;
  let mut x108: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x107, &mut x108, x106, x83, x98);
  let mut x109: u64 = 0;
  let mut x110: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x109, &mut x110, x108, x85, x100);
  let mut x111: u64 = 0;
  let mut x112: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x111, &mut x112, x110, x87, x102);
  let mut x113: u64 = 0;
  let mut x114: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x113, &mut x114, x103, 0xd2b51da312547e1b);
  let mut x115: u64 = 0;
  let mut x116: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x115, &mut x116, x113, 0x1000000000000000);
  let mut x117: u64 = 0;
  let mut x118: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x117, &mut x118, x113, 0x14def9dea2f79cd6);
  let mut x119: u64 = 0;
  let mut x120: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x119, &mut x120, x113, 0x5812631a5cf5d3ed);
  let mut x121: u64 = 0;
  let mut x122: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x121, &mut x122, 0x0, x120, x117);
  let x123: u64 = ((x122 as u64) + x118);
  let mut x124: u64 = 0;
  let mut x125: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x124, &mut x125, 0x0, x103, x119);
  let mut x126: u64 = 0;
  let mut x127: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x126, &mut x127, x125, x105, x121);
  let mut x128: u64 = 0;
  let mut x129: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x128, &mut x129, x127, x107, x123);
  let mut x130: u64 = 0;
  let mut x131: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x130, &mut x131, x129, x109, x115);
  let mut x132: u64 = 0;
  let mut x133: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x132, &mut x133, x131, x111, x116);
  let x134: u64 = ((x133 as u64) + (x112 as u64));
  let mut x135: u64 = 0;
  let mut x136: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x135, &mut x136, x3, (arg1[3]));
  let mut x137: u64 = 0;
  let mut x138: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x137, &mut x138, x3, (arg1[2]));
  let mut x139: u64 = 0;
  let mut x140: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x139, &mut x140, x3, (arg1[1]));
  let mut x141: u64 = 0;
  let mut x142: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x141, &mut x142, x3, (arg1[0]));
  let mut x143: u64 = 0;
  let mut x144: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x143, &mut x144, 0x0, x142, x139);
  let mut x145: u64 = 0;
  let mut x146: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x145, &mut x146, x144, x140, x137);
  let mut x147: u64 = 0;
  let mut x148: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x147, &mut x148, x146, x138, x135);
  let x149: u64 = ((x148 as u64) + x136);
  let mut x150: u64 = 0;
  let mut x151: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x150, &mut x151, 0x0, x126, x141);
  let mut x152: u64 = 0;
  let mut x153: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x152, &mut x153, x151, x128, x143);
  let mut x154: u64 = 0;
  let mut x155: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x154, &mut x155, x153, x130, x145);
  let mut x156: u64 = 0;
  let mut x157: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x156, &mut x157, x155, x132, x147);
  let mut x158: u64 = 0;
  let mut x159: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x158, &mut x159, x157, x134, x149);
  let mut x160: u64 = 0;
  let mut x161: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x160, &mut x161, x150, 0xd2b51da312547e1b);
  let mut x162: u64 = 0;
  let mut x163: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x162, &mut x163, x160, 0x1000000000000000);
  let mut x164: u64 = 0;
  let mut x165: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x164, &mut x165, x160, 0x14def9dea2f79cd6);
  let mut x166: u64 = 0;
  let mut x167: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x166, &mut x167, x160, 0x5812631a5cf5d3ed);
  let mut x168: u64 = 0;
  let mut x169: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x168, &mut x169, 0x0, x167, x164);
  let x170: u64 = ((x169 as u64) + x165);
  let mut x171: u64 = 0;
  let mut x172: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x171, &mut x172, 0x0, x150, x166);
  let mut x173: u64 = 0;
  let mut x174: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x173, &mut x174, x172, x152, x168);
  let mut x175: u64 = 0;
  let mut x176: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x175, &mut x176, x174, x154, x170);
  let mut x177: u64 = 0;
  let mut x178: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x177, &mut x178, x176, x156, x162);
  let mut x179: u64 = 0;
  let mut x180: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x179, &mut x180, x178, x158, x163);
  let x181: u64 = ((x180 as u64) + (x159 as u64));
  let mut x182: u64 = 0;
  let mut x183: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x182, &mut x183, 0x0, x173, 0x5812631a5cf5d3ed);
  let mut x184: u64 = 0;
  let mut x185: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x184, &mut x185, x183, x175, 0x14def9dea2f79cd6);
  let mut x186: u64 = 0;
  let mut x187: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x186, &mut x187, x185, x177, (0x0 as u64));
  let mut x188: u64 = 0;
  let mut x189: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x188, &mut x189, x187, x179, 0x1000000000000000);
  let mut x190: u64 = 0;
  let mut x191: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x190, &mut x191, x189, x181, (0x0 as u64));
  let mut x192: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x192, x191, x182, x173);
  let mut x193: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x193, x191, x184, x175);
  let mut x194: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x194, x191, x186, x177);
  let mut x195: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x195, x191, x188, x179);
  out1[0] = x192;
  out1[1] = x193;
  out1[2] = x194;
  out1[3] = x195;
}

/// The function fiat_25519_scalar_add adds two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_add(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element, arg2: &fiat_25519_scalar_montgomery_domain_field_element) {
  let mut x1: u64 = 0;
  let mut x2: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u64 = 0;
  let mut x4: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u64 = 0;
  let mut x6: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u64 = 0;
  let mut x8: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u64 = 0;
  let mut x10: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x9, &mut x10, 0x0, x1, 0x5812631a5cf5d3ed);
  let mut x11: u64 = 0;
  let mut x12: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x11, &mut x12, x10, x3, 0x14def9dea2f79cd6);
  let mut x13: u64 = 0;
  let mut x14: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x13, &mut x14, x12, x5, (0x0 as u64));
  let mut x15: u64 = 0;
  let mut x16: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x15, &mut x16, x14, x7, 0x1000000000000000);
  let mut x17: u64 = 0;
  let mut x18: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x17, &mut x18, x16, (x8 as u64), (0x0 as u64));
  let mut x19: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x19, x18, x9, x1);
  let mut x20: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x20, x18, x11, x3);
  let mut x21: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x21, x18, x13, x5);
  let mut x22: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x22, x18, x15, x7);
  out1[0] = x19;
  out1[1] = x20;
  out1[2] = x21;
  out1[3] = x22;
}

/// The function fiat_25519_scalar_sub subtracts two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_sub(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element, arg2: &fiat_25519_scalar_montgomery_domain_field_element) {
  let mut x1: u64 = 0;
  let mut x2: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u64 = 0;
  let mut x4: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u64 = 0;
  let mut x6: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u64 = 0;
  let mut x8: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x9, x8, (0x0 as u64), 0xffffffffffffffff);
  let mut x10: u64 = 0;
  let mut x11: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x10, &mut x11, 0x0, x1, (x9 & 0x5812631a5cf5d3ed));
  let mut x12: u64 = 0;
  let mut x13: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x12, &mut x13, x11, x3, (x9 & 0x14def9dea2f79cd6));
  let mut x14: u64 = 0;
  let mut x15: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x14, &mut x15, x13, x5, (0x0 as u64));
  let mut x16: u64 = 0;
  let mut x17: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x16, &mut x17, x15, x7, (x9 & 0x1000000000000000));
  out1[0] = x10;
  out1[1] = x12;
  out1[2] = x14;
  out1[3] = x16;
}

/// The function fiat_25519_scalar_opp negates a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_opp(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element) {
  let mut x1: u64 = 0;
  let mut x2: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x1, &mut x2, 0x0, (0x0 as u64), (arg1[0]));
  let mut x3: u64 = 0;
  let mut x4: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x3, &mut x4, x2, (0x0 as u64), (arg1[1]));
  let mut x5: u64 = 0;
  let mut x6: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x5, &mut x6, x4, (0x0 as u64), (arg1[2]));
  let mut x7: u64 = 0;
  let mut x8: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x7, &mut x8, x6, (0x0 as u64), (arg1[3]));
  let mut x9: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x9, x8, (0x0 as u64), 0xffffffffffffffff);
  let mut x10: u64 = 0;
  let mut x11: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x10, &mut x11, 0x0, x1, (x9 & 0x5812631a5cf5d3ed));
  let mut x12: u64 = 0;
  let mut x13: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x12, &mut x13, x11, x3, (x9 & 0x14def9dea2f79cd6));
  let mut x14: u64 = 0;
  let mut x15: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x14, &mut x15, x13, x5, (0x0 as u64));
  let mut x16: u64 = 0;
  let mut x17: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x16, &mut x17, x15, x7, (x9 & 0x1000000000000000));
  out1[0] = x10;
  out1[1] = x12;
  out1[2] = x14;
  out1[3] = x16;
}

/// The function fiat_25519_scalar_from_montgomery translates a field element out of the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_from_montgomery(out1: &mut fiat_25519_scalar_non_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element) {
  let x1: u64 = (arg1[0]);
  let mut x2: u64 = 0;
  let mut x3: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x2, &mut x3, x1, 0xd2b51da312547e1b);
  let mut x4: u64 = 0;
  let mut x5: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x4, &mut x5, x2, 0x1000000000000000);
  let mut x6: u64 = 0;
  let mut x7: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x6, &mut x7, x2, 0x14def9dea2f79cd6);
  let mut x8: u64 = 0;
  let mut x9: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x8, &mut x9, x2, 0x5812631a5cf5d3ed);
  let mut x10: u64 = 0;
  let mut x11: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x10, &mut x11, 0x0, x9, x6);
  let mut x12: u64 = 0;
  let mut x13: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x12, &mut x13, 0x0, x1, x8);
  let mut x14: u64 = 0;
  let mut x15: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x14, &mut x15, x13, (0x0 as u64), x10);
  let mut x16: u64 = 0;
  let mut x17: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x16, &mut x17, 0x0, x14, (arg1[1]));
  let mut x18: u64 = 0;
  let mut x19: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x18, &mut x19, x16, 0xd2b51da312547e1b);
  let mut x20: u64 = 0;
  let mut x21: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x20, &mut x21, x18, 0x1000000000000000);
  let mut x22: u64 = 0;
  let mut x23: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x22, &mut x23, x18, 0x14def9dea2f79cd6);
  let mut x24: u64 = 0;
  let mut x25: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x24, &mut x25, x18, 0x5812631a5cf5d3ed);
  let mut x26: u64 = 0;
  let mut x27: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x26, &mut x27, 0x0, x25, x22);
  let mut x28: u64 = 0;
  let mut x29: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x28, &mut x29, 0x0, x16, x24);
  let mut x30: u64 = 0;
  let mut x31: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x30, &mut x31, x29, ((x17 as u64) + ((x15 as u64) + ((x11 as u64) + x7))), x26);
  let mut x32: u64 = 0;
  let mut x33: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x32, &mut x33, x31, x4, ((x27 as u64) + x23));
  let mut x34: u64 = 0;
  let mut x35: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x34, &mut x35, x33, x5, x20);
  let mut x36: u64 = 0;
  let mut x37: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x36, &mut x37, 0x0, x30, (arg1[2]));
  let mut x38: u64 = 0;
  let mut x39: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x38, &mut x39, x37, x32, (0x0 as u64));
  let mut x40: u64 = 0;
  let mut x41: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x40, &mut x41, x39, x34, (0x0 as u64));
  let mut x42: u64 = 0;
  let mut x43: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x42, &mut x43, x36, 0xd2b51da312547e1b);
  let mut x44: u64 = 0;
  let mut x45: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x44, &mut x45, x42, 0x1000000000000000);
  let mut x46: u64 = 0;
  let mut x47: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x46, &mut x47, x42, 0x14def9dea2f79cd6);
  let mut x48: u64 = 0;
  let mut x49: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x48, &mut x49, x42, 0x5812631a5cf5d3ed);
  let mut x50: u64 = 0;
  let mut x51: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x50, &mut x51, 0x0, x49, x46);
  let mut x52: u64 = 0;
  let mut x53: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x52, &mut x53, 0x0, x36, x48);
  let mut x54: u64 = 0;
  let mut x55: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x54, &mut x55, x53, x38, x50);
  let mut x56: u64 = 0;
  let mut x57: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x56, &mut x57, x55, x40, ((x51 as u64) + x47));
  let mut x58: u64 = 0;
  let mut x59: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x58, &mut x59, x57, ((x41 as u64) + ((x35 as u64) + x21)), x44);
  let mut x60: u64 = 0;
  let mut x61: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x60, &mut x61, 0x0, x54, (arg1[3]));
  let mut x62: u64 = 0;
  let mut x63: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x62, &mut x63, x61, x56, (0x0 as u64));
  let mut x64: u64 = 0;
  let mut x65: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x64, &mut x65, x63, x58, (0x0 as u64));
  let mut x66: u64 = 0;
  let mut x67: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x66, &mut x67, x60, 0xd2b51da312547e1b);
  let mut x68: u64 = 0;
  let mut x69: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x68, &mut x69, x66, 0x1000000000000000);
  let mut x70: u64 = 0;
  let mut x71: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x70, &mut x71, x66, 0x14def9dea2f79cd6);
  let mut x72: u64 = 0;
  let mut x73: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x72, &mut x73, x66, 0x5812631a5cf5d3ed);
  let mut x74: u64 = 0;
  let mut x75: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x74, &mut x75, 0x0, x73, x70);
  let mut x76: u64 = 0;
  let mut x77: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x76, &mut x77, 0x0, x60, x72);
  let mut x78: u64 = 0;
  let mut x79: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x78, &mut x79, x77, x62, x74);
  let mut x80: u64 = 0;
  let mut x81: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x80, &mut x81, x79, x64, ((x75 as u64) + x71));
  let mut x82: u64 = 0;
  let mut x83: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x82, &mut x83, x81, ((x65 as u64) + ((x59 as u64) + x45)), x68);
  let x84: u64 = ((x83 as u64) + x69);
  let mut x85: u64 = 0;
  let mut x86: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x85, &mut x86, 0x0, x78, 0x5812631a5cf5d3ed);
  let mut x87: u64 = 0;
  let mut x88: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x87, &mut x88, x86, x80, 0x14def9dea2f79cd6);
  let mut x89: u64 = 0;
  let mut x90: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x89, &mut x90, x88, x82, (0x0 as u64));
  let mut x91: u64 = 0;
  let mut x92: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x91, &mut x92, x90, x84, 0x1000000000000000);
  let mut x93: u64 = 0;
  let mut x94: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x93, &mut x94, x92, (0x0 as u64), (0x0 as u64));
  let mut x95: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x95, x94, x85, x78);
  let mut x96: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x96, x94, x87, x80);
  let mut x97: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x97, x94, x89, x82);
  let mut x98: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x98, x94, x91, x84);
  out1[0] = x95;
  out1[1] = x96;
  out1[2] = x97;
  out1[3] = x98;
}

/// The function fiat_25519_scalar_to_montgomery translates a field element into the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_to_montgomery(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_non_montgomery_domain_field_element) {
  let x1: u64 = (arg1[1]);
  let x2: u64 = (arg1[2]);
  let x3: u64 = (arg1[3]);
  let x4: u64 = (arg1[0]);
  let mut x5: u64 = 0;
  let mut x6: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x5, &mut x6, x4, 0x399411b7c309a3d);
  let mut x7: u64 = 0;
  let mut x8: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x7, &mut x8, x4, 0xceec73d217f5be65);
  let mut x9: u64 = 0;
  let mut x10: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x9, &mut x10, x4, 0xd00e1ba768859347);
  let mut x11: u64 = 0;
  let mut x12: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x11, &mut x12, x4, 0xa40611e3449c0f01);
  let mut x13: u64 = 0;
  let mut x14: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x13, &mut x14, 0x0, x12, x9);
  let mut x15: u64 = 0;
  let mut x16: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x15, &mut x16, x14, x10, x7);
  let mut x17: u64 = 0;
  let mut x18: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x17, &mut x18, x16, x8, x5);
  let mut x19: u64 = 0;
  let mut x20: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x19, &mut x20, x11, 0xd2b51da312547e1b);
  let mut x21: u64 = 0;
  let mut x22: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x21, &mut x22, x19, 0x1000000000000000);
  let mut x23: u64 = 0;
  let mut x24: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x23, &mut x24, x19, 0x14def9dea2f79cd6);
  let mut x25: u64 = 0;
  let mut x26: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x25, &mut x26, x19, 0x5812631a5cf5d3ed);
  let mut x27: u64 = 0;
  let mut x28: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x27, &mut x28, 0x0, x26, x23);
  let mut x29: u64 = 0;
  let mut x30: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x29, &mut x30, 0x0, x11, x25);
  let mut x31: u64 = 0;
  let mut x32: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x31, &mut x32, x30, x13, x27);
  let mut x33: u64 = 0;
  let mut x34: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x33, &mut x34, x32, x15, ((x28 as u64) + x24));
  let mut x35: u64 = 0;
  let mut x36: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x35, &mut x36, x34, x17, x21);
  let mut x37: u64 = 0;
  let mut x38: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x37, &mut x38, x1, 0x399411b7c309a3d);
  let mut x39: u64 = 0;
  let mut x40: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x39, &mut x40, x1, 0xceec73d217f5be65);
  let mut x41: u64 = 0;
  let mut x42: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x41, &mut x42, x1, 0xd00e1ba768859347);
  let mut x43: u64 = 0;
  let mut x44: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x43, &mut x44, x1, 0xa40611e3449c0f01);
  let mut x45: u64 = 0;
  let mut x46: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x45, &mut x46, 0x0, x44, x41);
  let mut x47: u64 = 0;
  let mut x48: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x47, &mut x48, x46, x42, x39);
  let mut x49: u64 = 0;
  let mut x50: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x49, &mut x50, x48, x40, x37);
  let mut x51: u64 = 0;
  let mut x52: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x51, &mut x52, 0x0, x31, x43);
  let mut x53: u64 = 0;
  let mut x54: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x53, &mut x54, x52, x33, x45);
  let mut x55: u64 = 0;
  let mut x56: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x55, &mut x56, x54, x35, x47);
  let mut x57: u64 = 0;
  let mut x58: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x57, &mut x58, x56, (((x36 as u64) + ((x18 as u64) + x6)) + x22), x49);
  let mut x59: u64 = 0;
  let mut x60: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x59, &mut x60, x51, 0xd2b51da312547e1b);
  let mut x61: u64 = 0;
  let mut x62: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x61, &mut x62, x59, 0x1000000000000000);
  let mut x63: u64 = 0;
  let mut x64: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x63, &mut x64, x59, 0x14def9dea2f79cd6);
  let mut x65: u64 = 0;
  let mut x66: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x65, &mut x66, x59, 0x5812631a5cf5d3ed);
  let mut x67: u64 = 0;
  let mut x68: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x67, &mut x68, 0x0, x66, x63);
  let mut x69: u64 = 0;
  let mut x70: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x69, &mut x70, 0x0, x51, x65);
  let mut x71: u64 = 0;
  let mut x72: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x71, &mut x72, x70, x53, x67);
  let mut x73: u64 = 0;
  let mut x74: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x73, &mut x74, x72, x55, ((x68 as u64) + x64));
  let mut x75: u64 = 0;
  let mut x76: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x75, &mut x76, x74, x57, x61);
  let mut x77: u64 = 0;
  let mut x78: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x77, &mut x78, x2, 0x399411b7c309a3d);
  let mut x79: u64 = 0;
  let mut x80: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x79, &mut x80, x2, 0xceec73d217f5be65);
  let mut x81: u64 = 0;
  let mut x82: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x81, &mut x82, x2, 0xd00e1ba768859347);
  let mut x83: u64 = 0;
  let mut x84: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x83, &mut x84, x2, 0xa40611e3449c0f01);
  let mut x85: u64 = 0;
  let mut x86: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x85, &mut x86, 0x0, x84, x81);
  let mut x87: u64 = 0;
  let mut x88: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x87, &mut x88, x86, x82, x79);
  let mut x89: u64 = 0;
  let mut x90: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x89, &mut x90, x88, x80, x77);
  let mut x91: u64 = 0;
  let mut x92: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x91, &mut x92, 0x0, x71, x83);
  let mut x93: u64 = 0;
  let mut x94: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x93, &mut x94, x92, x73, x85);
  let mut x95: u64 = 0;
  let mut x96: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x95, &mut x96, x94, x75, x87);
  let mut x97: u64 = 0;
  let mut x98: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x97, &mut x98, x96, (((x76 as u64) + ((x58 as u64) + ((x50 as u64) + x38))) + x62), x89);
  let mut x99: u64 = 0;
  let mut x100: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x99, &mut x100, x91, 0xd2b51da312547e1b);
  let mut x101: u64 = 0;
  let mut x102: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x101, &mut x102, x99, 0x1000000000000000);
  let mut x103: u64 = 0;
  let mut x104: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x103, &mut x104, x99, 0x14def9dea2f79cd6);
  let mut x105: u64 = 0;
  let mut x106: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x105, &mut x106, x99, 0x5812631a5cf5d3ed);
  let mut x107: u64 = 0;
  let mut x108: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x107, &mut x108, 0x0, x106, x103);
  let mut x109: u64 = 0;
  let mut x110: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x109, &mut x110, 0x0, x91, x105);
  let mut x111: u64 = 0;
  let mut x112: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x111, &mut x112, x110, x93, x107);
  let mut x113: u64 = 0;
  let mut x114: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x113, &mut x114, x112, x95, ((x108 as u64) + x104));
  let mut x115: u64 = 0;
  let mut x116: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x115, &mut x116, x114, x97, x101);
  let mut x117: u64 = 0;
  let mut x118: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x117, &mut x118, x3, 0x399411b7c309a3d);
  let mut x119: u64 = 0;
  let mut x120: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x119, &mut x120, x3, 0xceec73d217f5be65);
  let mut x121: u64 = 0;
  let mut x122: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x121, &mut x122, x3, 0xd00e1ba768859347);
  let mut x123: u64 = 0;
  let mut x124: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x123, &mut x124, x3, 0xa40611e3449c0f01);
  let mut x125: u64 = 0;
  let mut x126: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x125, &mut x126, 0x0, x124, x121);
  let mut x127: u64 = 0;
  let mut x128: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x127, &mut x128, x126, x122, x119);
  let mut x129: u64 = 0;
  let mut x130: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x129, &mut x130, x128, x120, x117);
  let mut x131: u64 = 0;
  let mut x132: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x131, &mut x132, 0x0, x111, x123);
  let mut x133: u64 = 0;
  let mut x134: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x133, &mut x134, x132, x113, x125);
  let mut x135: u64 = 0;
  let mut x136: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x135, &mut x136, x134, x115, x127);
  let mut x137: u64 = 0;
  let mut x138: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x137, &mut x138, x136, (((x116 as u64) + ((x98 as u64) + ((x90 as u64) + x78))) + x102), x129);
  let mut x139: u64 = 0;
  let mut x140: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x139, &mut x140, x131, 0xd2b51da312547e1b);
  let mut x141: u64 = 0;
  let mut x142: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x141, &mut x142, x139, 0x1000000000000000);
  let mut x143: u64 = 0;
  let mut x144: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x143, &mut x144, x139, 0x14def9dea2f79cd6);
  let mut x145: u64 = 0;
  let mut x146: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x145, &mut x146, x139, 0x5812631a5cf5d3ed);
  let mut x147: u64 = 0;
  let mut x148: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x147, &mut x148, 0x0, x146, x143);
  let mut x149: u64 = 0;
  let mut x150: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x149, &mut x150, 0x0, x131, x145);
  let mut x151: u64 = 0;
  let mut x152: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x151, &mut x152, x150, x133, x147);
  let mut x153: u64 = 0;
  let mut x154: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x153, &mut x154, x152, x135, ((x148 as u64) + x144));
  let mut x155: u64 = 0;
  let mut x156: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x155, &mut x156, x154, x137, x141);
  let x157: u64 = (((x156 as u64) + ((x138 as u64) + ((x130 as u64) + x118))) + x142);
  let mut x158: u64 = 0;
  let mut x159: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x158, &mut x159, 0x0, x151, 0x5812631a5cf5d3ed);
  let mut x160: u64 = 0;
  let mut x161: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x160, &mut x161, x159, x153, 0x14def9dea2f79cd6);
  let mut x162: u64 = 0;
  let mut x163: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x162, &mut x163, x161, x155, (0x0 as u64));
  let mut x164: u64 = 0;
  let mut x165: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x164, &mut x165, x163, x157, 0x1000000000000000);
  let mut x166: u64 = 0;
  let mut x167: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x166, &mut x167, x165, (0x0 as u64), (0x0 as u64));
  let mut x168: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x168, x167, x158, x151);
  let mut x169: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x169, x167, x160, x153);
  let mut x170: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x170, x167, x162, x155);
  let mut x171: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x171, x167, x164, x157);
  out1[0] = x168;
  out1[1] = x169;
  out1[2] = x170;
  out1[3] = x171;
}

/// The function fiat_25519_scalar_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_25519_scalar_nonzero(out1: &mut u64, arg1: &[u64; 4]) {
  let x1: u64 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | (arg1[3]))));
  *out1 = x1;
}

/// The function fiat_25519_scalar_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_25519_scalar_selectznz(out1: &mut [u64; 4], arg1: fiat_25519_scalar_u1, arg2: &[u64; 4], arg3: &[u64; 4]) {
  let mut x1: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x4, arg1, (arg2[3]), (arg3[3]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
}

/// The function fiat_25519_scalar_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0x1fffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1f]]
#[inline]
pub fn fiat_25519_scalar_to_bytes(out1: &mut [u8; 32], arg1: &[u64; 4]) {
  let x1: u64 = (arg1[3]);
  let x2: u64 = (arg1[2]);
  let x3: u64 = (arg1[1]);
  let x4: u64 = (arg1[0]);
  let x5: u8 = ((x4 & (0xff as u64)) as u8);
  let x6: u64 = (x4 >> 8);
  let x7: u8 = ((x6 & (0xff as u64)) as u8);
  let x8: u64 = (x6 >> 8);
  let x9: u8 = ((x8 & (0xff as u64)) as u8);
  let x10: u64 = (x8 >> 8);
  let x11: u8 = ((x10 & (0xff as u64)) as u8);
  let x12: u64 = (x10 >> 8);
  let x13: u8 = ((x12 & (0xff as u64)) as u8);
  let x14: u64 = (x12 >> 8);
  let x15: u8 = ((x14 & (0xff as u64)) as u8);
  let x16: u64 = (x14 >> 8);
  let x17: u8 = ((x16 & (0xff as u64)) as u8);
  let x18: u8 = ((x16 >> 8) as u8);
  let x19: u8 = ((x3 & (0xff as u64)) as u8);
  let x20: u64 = (x3 >> 8);
  let x21: u8 = ((x20 & (0xff as u64)) as u8);
  let x22: u64 = (x20 >> 8);
  let x23: u8 = ((x22 & (0xff as u64)) as u8);
  let x24: u64 = (x22 >> 8);
  let x25: u8 = ((x24 & (0xff as u64)) as u8);
  let x26: u64 = (x24 >> 8);
  let x27: u8 = ((x26 & (0xff as u64)) as u8);
  let x28: u64 = (x26 >> 8);
  let x29: u8 = ((x28 & (0xff as u64)) as u8);
  let x30: u64 = (x28 >> 8);
  let x31: u8 = ((x30 & (0xff as u64)) as u8);
  let x32: u8 = ((x30 >> 8) as u8);
  let x33: u8 = ((x2 & (0xff as u64)) as u8);
  let x34: u64 = (x2 >> 8);
  let x35: u8 = ((x34 & (0xff as u64)) as u8);
  let x36: u64 = (x34 >> 8);
  let x37: u8 = ((x36 & (0xff as u64)) as u8);
  let x38: u64 = (x36 >> 8);
  let x39: u8 = ((x38 & (0xff as u64)) as u8);
  let x40: u64 = (x38 >> 8);
  let x41: u8 = ((x40 & (0xff as u64)) as u8);
  let x42: u64 = (x40 >> 8);
  let x43: u8 = ((x42 & (0xff as u64)) as u8);
  let x44: u64 = (x42 >> 8);
  let x45: u8 = ((x44 & (0xff as u64)) as u8);
  let x46: u8 = ((x44 >> 8) as u8);
  let x47: u8 = ((x1 & (0xff as u64)) as u8);
  let x48: u64 = (x1 >> 8);
  let x49: u8 = ((x48 & (0xff as u64)) as u8);
  let x50: u64 = (x48 >> 8);
  let x51: u8 = ((x50 & (0xff as u64)) as u8);
  let x52: u64 = (x50 >> 8);
  let x53: u8 = ((x52 & (0xff as u64)) as u8);
  let x54: u64 = (x52 >> 8);
  let x55: u8 = ((x54 & (0xff as u64)) as u8);
  let x56: u64 = (x54 >> 8);
  let x57: u8 = ((x56 & (0xff as u64)) as u8);
  let x58: u64 = (x56 >> 8);
  let x59: u8 = ((x58 & (0xff as u64)) as u8);
  let x60: u8 = ((x58 >> 8) as u8);
  out1[0] = x5;
  out1[1] = x7;
  out1[2] = x9;
  out1[3] = x11;
  out1[4] = x13;
  out1[5] = x15;
  out1[6] = x17;
  out1[7] = x18;
  out1[8] = x19;
  out1[9] = x21;
  out1[10] = x23;
  out1[11] = x25;
  out1[12] = x27;
  out1[13] = x29;
  out1[14] = x31;
  out1[15] = x32;
  out1[16] = x33;
  out1[17] = x35;
  out1[18] = x37;
  out1[19] = x39;
  out1[20] = x41;
  out1[21] = x43;
  out1[22] = x45;
  out1[23] = x46;
  out1[24] = x47;
  out1[25] = x49;
  out1[26] = x51;
  out1[27] = x53;
  out1[28] = x55;
  out1[29] = x57;
  out1[30] = x59;
  out1[31] = x60;
}

/// The function fiat_25519_scalar_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1f]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0x1fffffffffffffff]]
#[inline]
pub fn fiat_25519_scalar_from_bytes(out1: &mut [u64; 4], arg1: &[u8; 32]) {
  let x1: u64 = (((arg1[31]) as u64) << 56);
  let x2: u64 = (((arg1[30]) as u64) << 48);
  let x3: u64 = (((arg1[29]) as u64) << 40);
  let x4: u64 = (((arg1[28]) as u64) << 32);
  let x5: u64 = (((arg1[27]) as u64) << 24);
  let x6: u64 = (((arg1[26]) as u64) << 16);
  let x7: u64 = (((arg1[25]) as u64) << 8);
  let x8: u8 = (arg1[24]);
  let x9: u64 = (((arg1[23]) as u64) << 56);
  let x10: u64 = (((arg1[22]) as u64) << 48);
  let x11: u64 = (((arg1[21]) as u64) << 40);
  let x12: u64 = (((arg1[20]) as u64) << 32);
  let x13: u64 = (((arg1[19]) as u64) << 24);
  let x14: u64 = (((arg1[18]) as u64) << 16);
  let x15: u64 = (((arg1[17]) as u64) << 8);
  let x16: u8 = (arg1[16]);
  let x17: u64 = (((arg1[15]) as u64) << 56);
  let x18: u64 = (((arg1[14]) as u64) << 48);
  let x19: u64 = (((arg1[13]) as u64) << 40);
  let x20: u64 = (((arg1[12]) as u64) << 32);
  let x21: u64 = (((arg1[11]) as u64) << 24);
  let x22: u64 = (((arg1[10]) as u64) << 16);
  let x23: u64 = (((arg1[9]) as u64) << 8);
  let x24: u8 = (arg1[8]);
  let x25: u64 = (((arg1[7]) as u64) << 56);
  let x26: u64 = (((arg1[6]) as u64) << 48);
  let x27: u64 = (((arg1[5]) as u64) << 40);
  let x28: u64 = (((arg1[4]) as u64) << 32);
  let x29: u64 = (((arg1[3]) as u64) << 24);
  let x30: u64 = (((arg1[2]) as u64) << 16);
  let x31: u64 = (((arg1[1]) as u64) << 8);
  let x32: u8 = (arg1[0]);
  let x33: u64 = (x31 + (x32 as u64));
  let x34: u64 = (x30 + x33);
  let x35: u64 = (x29 + x34);
  let x36: u64 = (x28 + x35);
  let x37: u64 = (x27 + x36);
  let x38: u64 = (x26 + x37);
  let x39: u64 = (x25 + x38);
  let x40: u64 = (x23 + (x24 as u64));
  let x41: u64 = (x22 + x40);
  let x42: u64 = (x21 + x41);
  let x43: u64 = (x20 + x42);
  let x44: u64 = (x19 + x43);
  let x45: u64 = (x18 + x44);
  let x46: u64 = (x17 + x45);
  let x47: u64 = (x15 + (x16 as u64));
  let x48: u64 = (x14 + x47);
  let x49: u64 = (x13 + x48);
  let x50: u64 = (x12 + x49);
  let x51: u64 = (x11 + x50);
  let x52: u64 = (x10 + x51);
  let x53: u64 = (x9 + x52);
  let x54: u64 = (x7 + (x8 as u64));
  let x55: u64 = (x6 + x54);
  let x56: u64 = (x5 + x55);
  let x57: u64 = (x4 + x56);
  let x58: u64 = (x3 + x57);
  let x59: u64 = (x2 + x58);
  let x60: u64 = (x1 + x59);
  out1[0] = x39;
  out1[1] = x46;
  out1[2] = x53;
  out1[3] = x60;
}

/// The function fiat_25519_scalar_set_one returns the field element one in the Montgomery domain.
///
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_set_one(out1: &mut fiat_25519_scalar_montgomery_domain_field_element) {
  out1[0] = 0xd6ec31748d98951d;
  out1[1] = 0xc6ef5bf4737dcf70;
  out1[2] = 0xfffffffffffffffe;
  out1[3] = 0xfffffffffffffff;
}

/// The function fiat_25519_scalar_msat returns the saturated representation of the prime modulus.
///
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_25519_scalar_msat(out1: &mut [u64; 5]) {
  out1[0] = 0x5812631a5cf5d3ed;
  out1[1] = 0x14def9dea2f79cd6;
  out1[2] = (0x0 as u64);
  out1[3] = 0x1000000000000000;
  out1[4] = (0x0 as u64);
}

/// The function fiat_25519_scalar_divstep computes a divstep.
///
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_25519_scalar_divstep(out1: &mut u64, out2: &mut [u64; 5], out3: &mut [u64; 5], out4: &mut [u64; 4], out5: &mut [u64; 4], arg1: u64, arg2: &[u64; 5], arg3: &[u64; 5], arg4: &[u64; 4], arg5: &[u64; 4]) {
  let mut x1: u64 = 0;
  let mut x2: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x1, &mut x2, 0x0, (!arg1), (0x1 as u64));
  let x3: fiat_25519_scalar_u1 = (((x1 >> 63) as fiat_25519_scalar_u1) & (((arg3[0]) & (0x1 as u64)) as fiat_25519_scalar_u1));
  let mut x4: u64 = 0;
  let mut x5: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x4, &mut x5, 0x0, (!arg1), (0x1 as u64));
  let mut x6: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x6, x3, arg1, x4);
  let mut x7: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x7, x3, (arg2[0]), (arg3[0]));
  let mut x8: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x8, x3, (arg2[1]), (arg3[1]));
  let mut x9: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x9, x3, (arg2[2]), (arg3[2]));
  let mut x10: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x10, x3, (arg2[3]), (arg3[3]));
  let mut x11: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x11, x3, (arg2[4]), (arg3[4]));
  let mut x12: u64 = 0;
  let mut x13: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x12, &mut x13, 0x0, (0x1 as u64), (!(arg2[0])));
  let mut x14: u64 = 0;
  let mut x15: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x14, &mut x15, x13, (0x0 as u64), (!(arg2[1])));
  let mut x16: u64 = 0;
  let mut x17: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x16, &mut x17, x15, (0x0 as u64), (!(arg2[2])));
  let mut x18: u64 = 0;
  let mut x19: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x18, &mut x19, x17, (0x0 as u64), (!(arg2[3])));
  let mut x20: u64 = 0;
  let mut x21: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x20, &mut x21, x19, (0x0 as u64), (!(arg2[4])));
  let mut x22: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x22, x3, (arg3[0]), x12);
  let mut x23: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x23, x3, (arg3[1]), x14);
  let mut x24: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x24, x3, (arg3[2]), x16);
  let mut x25: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x25, x3, (arg3[3]), x18);
  let mut x26: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x26, x3, (arg3[4]), x20);
  let mut x27: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x27, x3, (arg4[0]), (arg5[0]));
  let mut x28: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x28, x3, (arg4[1]), (arg5[1]));
  let mut x29: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x29, x3, (arg4[2]), (arg5[2]));
  let mut x30: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x30, x3, (arg4[3]), (arg5[3]));
  let mut x31: u64 = 0;
  let mut x32: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x31, &mut x32, 0x0, x27, x27);
  let mut x33: u64 = 0;
  let mut x34: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x33, &mut x34, x32, x28, x28);
  let mut x35: u64 = 0;
  let mut x36: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x35, &mut x36, x34, x29, x29);
  let mut x37: u64 = 0;
  let mut x38: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x37, &mut x38, x36, x30, x30);
  let mut x39: u64 = 0;
  let mut x40: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x39, &mut x40, 0x0, x31, 0x5812631a5cf5d3ed);
  let mut x41: u64 = 0;
  let mut x42: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x41, &mut x42, x40, x33, 0x14def9dea2f79cd6);
  let mut x43: u64 = 0;
  let mut x44: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x43, &mut x44, x42, x35, (0x0 as u64));
  let mut x45: u64 = 0;
  let mut x46: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x45, &mut x46, x44, x37, 0x1000000000000000);
  let mut x47: u64 = 0;
  let mut x48: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x47, &mut x48, x46, (x38 as u64), (0x0 as u64));
  let x49: u64 = (arg4[3]);
  let x50: u64 = (arg4[2]);
  let x51: u64 = (arg4[1]);
  let x52: u64 = (arg4[0]);
  let mut x53: u64 = 0;
  let mut x54: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x53, &mut x54, 0x0, (0x0 as u64), x52);
  let mut x55: u64 = 0;
  let mut x56: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x55, &mut x56, x54, (0x0 as u64), x51);
  let mut x57: u64 = 0;
  let mut x58: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x57, &mut x58, x56, (0x0 as u64), x50);
  let mut x59: u64 = 0;
  let mut x60: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x59, &mut x60, x58, (0x0 as u64), x49);
  let mut x61: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x61, x60, (0x0 as u64), 0xffffffffffffffff);
  let mut x62: u64 = 0;
  let mut x63: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x62, &mut x63, 0x0, x53, (x61 & 0x5812631a5cf5d3ed));
  let mut x64: u64 = 0;
  let mut x65: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x64, &mut x65, x63, x55, (x61 & 0x14def9dea2f79cd6));
  let mut x66: u64 = 0;
  let mut x67: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x66, &mut x67, x65, x57, (0x0 as u64));
  let mut x68: u64 = 0;
  let mut x69: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x68, &mut x69, x67, x59, (x61 & 0x1000000000000000));
  let mut x70: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x70, x3, (arg5[0]), x62);
  let mut x71: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x71, x3, (arg5[1]), x64);
  let mut x72: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x72, x3, (arg5[2]), x66);
  let mut x73: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x73, x3, (arg5[3]), x68);
  let x74: fiat_25519_scalar_u1 = ((x22 & (0x1 as u64)) as fiat_25519_scalar_u1);
  let mut x75: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x75, x74, (0x0 as u64), x7);
  let mut x76: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x76, x74, (0x0 as u64), x8);
  let mut x77: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x77, x74, (0x0 as u64), x9);
  let mut x78: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x78, x74, (0x0 as u64), x10);
  let mut x79: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x79, x74, (0x0 as u64), x11);
  let mut x80: u64 = 0;
  let mut x81: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x80, &mut x81, 0x0, x22, x75);
  let mut x82: u64 = 0;
  let mut x83: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x82, &mut x83, x81, x23, x76);
  let mut x84: u64 = 0;
  let mut x85: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x84, &mut x85, x83, x24, x77);
  let mut x86: u64 = 0;
  let mut x87: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x86, &mut x87, x85, x25, x78);
  let mut x88: u64 = 0;
  let mut x89: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x88, &mut x89, x87, x26, x79);
  let mut x90: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x90, x74, (0x0 as u64), x27);
  let mut x91: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x91, x74, (0x0 as u64), x28);
  let mut x92: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x92, x74, (0x0 as u64), x29);
  let mut x93: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x93, x74, (0x0 as u64), x30);
  let mut x94: u64 = 0;
  let mut x95: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x94, &mut x95, 0x0, x70, x90);
  let mut x96: u64 = 0;
  let mut x97: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x96, &mut x97, x95, x71, x91);
  let mut x98: u64 = 0;
  let mut x99: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x98, &mut x99, x97, x72, x92);
  let mut x100: u64 = 0;
  let mut x101: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x100, &mut x101, x99, x73, x93);
  let mut x102: u64 = 0;
  let mut x103: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x102, &mut x103, 0x0, x94, 0x5812631a5cf5d3ed);
  let mut x104: u64 = 0;
  let mut x105: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x104, &mut x105, x103, x96, 0x14def9dea2f79cd6);
  let mut x106: u64 = 0;
  let mut x107: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x106, &mut x107, x105, x98, (0x0 as u64));
  let mut x108: u64 = 0;
  let mut x109: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x108, &mut x109, x107, x100, 0x1000000000000000);
  let mut x110: u64 = 0;
  let mut x111: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u64(&mut x110, &mut x111, x109, (x101 as u64), (0x0 as u64));
  let mut x112: u64 = 0;
  let mut x113: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x112, &mut x113, 0x0, x6, (0x1 as u64));
  let x114: u64 = ((x80 >> 1) | ((x82 << 63) & 0xffffffffffffffff));
  let x115: u64 = ((x82 >> 1) | ((x84 << 63) & 0xffffffffffffffff));
  let x116: u64 = ((x84 >> 1) | ((x86 << 63) & 0xffffffffffffffff));
  let x117: u64 = ((x86 >> 1) | ((x88 << 63) & 0xffffffffffffffff));
  let x118: u64 = ((x88 & 0x8000000000000000) | (x88 >> 1));
  let mut x119: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x119, x48, x39, x31);
  let mut x120: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x120, x48, x41, x33);
  let mut x121: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x121, x48, x43, x35);
  let mut x122: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x122, x48, x45, x37);
  let mut x123: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x123, x111, x102, x94);
  let mut x124: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x124, x111, x104, x96);
  let mut x125: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x125, x111, x106, x98);
  let mut x126: u64 = 0;
  fiat_25519_scalar_cmovznz_u64(&mut x126, x111, x108, x100);
  *out1 = x112;
  out2[0] = x7;
  out2[1] = x8;
  out2[2] = x9;
  out2[3] = x10;
  out2[4] = x11;
  out3[0] = x114;
  out3[1] = x115;
  out3[2] = x116;
  out3[3] = x117;
  out3[4] = x118;
  out4[0] = x119;
  out4[1] = x120;
  out4[2] = x121;
  out4[3] = x122;
  out5[0] = x123;
  out5[1] = x124;
  out5[2] = x125;
  out5[3] = x126;
}

/// The function fiat_25519_scalar_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
///
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_25519_scalar_divstep_precomp(out1: &mut [u64; 4]) {
  out1[0] = 0xd70af84436a7cb92;
  out1[1] = 0x5f71c978b0b8b159;
  out1[2] = 0xe76d816974947f1a;
  out1[3] = 0x19a2d36f193e4ff;
}
