Sys.setenv(TZ="")
suppressPackageStartupMessages(library(stars))
matrix(1:4,2)
m = matrix(1:4,2)
s = st_as_stars(m)

s = st_set_dimensions(s, st_dimensions(s), xy = NULL) 
sfc = st_sfc(st_point(0:1), st_point(3:2))
s = st_set_dimensions(s, 1, sfc) |> st_set_crs(4326)
tm = as.POSIXct("2023-03-04 12:35") + c(0, 3600)
s = st_set_dimensions(s, 2, tm)
f = tempfile(fileext = ".nc")
write_mdim(s, f, as_float = FALSE)
s2 = read_mdim(f)
#print(s2)
print(all.equal(s, s2, check.attributes = FALSE))
print(all.equal(s, s2))

st_crs(sfc) = st_crs(s2)
st_crs(s) = st_crs(s2)
tm = as.Date("2023-02-25") + 0:1
sd = st_set_dimensions(s, 2, tm)
print(sd)
sd = st_set_dimensions(sd, 1, sfc)
print(sd)
f = tempfile(fileext = ".nc")
write_mdim(sd, f)
sd2 = read_mdim(f)
print(sd2)
print(all.equal(sd, sd2, check.attributes = FALSE))
print(all.equal(sd, sd2))
# if (.Platform$OS.type == "unix") {
#   print(read_mdim(paste0("/vsizip/", (system.file("zarr/sic_daily_sample.zarr.zip", package = "stars"))))
# }
