% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_order.R
\name{get_order}
\alias{get_order}
\alias{get_order.ser_permutation_vector}
\alias{get_order.ser_permutation}
\alias{get_order.hclust}
\alias{get_order.dendrogram}
\alias{get_order.integer}
\alias{get_rank}
\alias{get_permutation_matrix}
\title{Extracting Order Information from a Permutation Object}
\usage{
get_order(x, ...)

\method{get_order}{ser_permutation_vector}(x, ...)

\method{get_order}{ser_permutation}(x, dim = 1, ...)

\method{get_order}{hclust}(x, ...)

\method{get_order}{dendrogram}(x, ...)

\method{get_order}{integer}(x, ...)

get_rank(x, ...)

get_permutation_matrix(x, ...)
}
\arguments{
\item{x}{an object of class \link{ser_permutation} or
\link{ser_permutation_vector}.}

\item{...}{further arguments are ignored for \code{get_order()}.  For
\code{get_rank()} and for \code{get_permutation_matrix()} the additional
arguments are passed on to \code{get_order()} (e.g., as \code{dim}).}

\item{dim}{order information for which dimension should be returned?}
}
\value{
Returns an integer permutation vector/a permutation matrix.
}
\description{
Method to get the order information from an object of class
\link{ser_permutation} or \link{ser_permutation_vector}. Order information
can be extracted as an integer permutation vector, a vector containing the
object ranks or a permutation matrix.
}
\details{
\code{get_order()} returns the seriation as an integer vector containing the
order of the objects after permutation. That is, the index of the first,
second, \eqn{..., n}-th object. These permutation vectors can directly be
used to reorder objects using subsetting with \code{"["}.  \emph{Note:} In
\pkg{seriation} we usually use these order-based permutation vectors.

\code{get_rank()} returns the seriation as an integer vector containing the
rank/position for each objects in the permutation. That is, position of the
first, second, \eqn{..., n}-th object after permutation.  Note: Use
\code{order()} to convert ranks back to an order.

\code{get_permutation_matrix()} returns a \eqn{n \times n}{n x n} permutation
matrix.
}
\examples{
## ser_permutation_vector is a single permutation vector
o <- ser_permutation_vector(sample(10))
o

get_order(o)
get_rank(o)
get_permutation_matrix(o)

## ser_permutation contains one permutation vector for each dimension
o2 <- ser_permutation(o, sample(5))
o2

get_order(o2, dim = 2)
get_rank(o2, dim = 2)
get_permutation_matrix(o2, dim = 2)
}
\seealso{
Other permutation: 
\code{\link{permutation_vector2matrix}()},
\code{\link{permute}()},
\code{\link{ser_dist}()},
\code{\link{ser_permutation_vector}()},
\code{\link{ser_permutation}()}
}
\author{
Michael Hahsler
}
\concept{permutation}
\keyword{manip}
