% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback.R
\name{callback}
\alias{callback}
\alias{ChunkCallback}
\alias{SideEffectChunkCallback}
\alias{DataFrameCallback}
\alias{ListCallback}
\alias{AccumulateCallback}
\title{Callback classes}
\description{
These classes are used to define callback behaviors.
}
\details{
\describe{
\item{ChunkCallback}{Callback interface definition, all callback functions should inherit from this class.}
\item{SideEffectChunkCallback}{Callback function that is used only for side effects, no results are returned.}
\item{DataFrameCallback}{Callback function that combines each result together at the end.}
\item{AccumulateCallBack}{
Callback function that accumulates a single result. Requires the parameter \code{acc} to specify
the initial value of the accumulator.  The parameter \code{acc} is \code{NULL} by default.
}
}
}
\examples{
## If given a regular function it is converted to a SideEffectChunkCallback

# view structure of each chunk
read_lines_chunked(readr_example("mtcars.csv"), str, chunk_size = 5)

# Print starting line of each chunk
f <- function(x, pos) print(pos)
read_lines_chunked(readr_example("mtcars.csv"), SideEffectChunkCallback$new(f), chunk_size = 5)

# If combined results are desired you can use the DataFrameCallback

# Cars with 3 gears
f <- function(x, pos) subset(x, gear == 3)
read_csv_chunked(readr_example("mtcars.csv"), DataFrameCallback$new(f), chunk_size = 5)

# The ListCallback can be used for more flexible output
f <- function(x, pos) x$mpg[x$hp > 100]
read_csv_chunked(readr_example("mtcars.csv"), ListCallback$new(f), chunk_size = 5)

# The AccumulateCallback accumulates results from each chunk
f <- function(x, pos, acc) sum(x$mpg) + acc
read_csv_chunked(readr_example("mtcars.csv"), AccumulateCallback$new(f, acc = 0), chunk_size = 5)
}
\seealso{
Other chunked: 
\code{\link{melt_delim_chunked}()},
\code{\link{read_delim_chunked}()},
\code{\link{read_lines_chunked}()}
}
\concept{chunked}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ChunkCallback$new()}}
\item \href{#method-receive}{\code{ChunkCallback$receive()}}
\item \href{#method-continue}{\code{ChunkCallback$continue()}}
\item \href{#method-result}{\code{ChunkCallback$result()}}
\item \href{#method-finally}{\code{ChunkCallback$finally()}}
\item \href{#method-clone}{\code{ChunkCallback$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-continue"></a>}}
\if{latex}{\out{\hypertarget{method-continue}{}}}
\subsection{Method \code{continue()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$continue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-result"></a>}}
\if{latex}{\out{\hypertarget{method-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finally"></a>}}
\if{latex}{\out{\hypertarget{method-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[readr:ChunkCallback]{readr::ChunkCallback}} -> \code{SideEffectChunkCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SideEffectChunkCallback$new()}}
\item \href{#method-receive}{\code{SideEffectChunkCallback$receive()}}
\item \href{#method-continue}{\code{SideEffectChunkCallback$continue()}}
\item \href{#method-clone}{\code{SideEffectChunkCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="readr" data-topic="ChunkCallback" data-id="finally">}\href{../../readr/html/ChunkCallback.html#method-finally}{\code{readr::ChunkCallback$finally()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="readr" data-topic="ChunkCallback" data-id="result">}\href{../../readr/html/ChunkCallback.html#method-result}{\code{readr::ChunkCallback$result()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SideEffectChunkCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SideEffectChunkCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-continue"></a>}}
\if{latex}{\out{\hypertarget{method-continue}{}}}
\subsection{Method \code{continue()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SideEffectChunkCallback$continue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SideEffectChunkCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[readr:ChunkCallback]{readr::ChunkCallback}} -> \code{DataFrameCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DataFrameCallback$new()}}
\item \href{#method-receive}{\code{DataFrameCallback$receive()}}
\item \href{#method-result}{\code{DataFrameCallback$result()}}
\item \href{#method-finally}{\code{DataFrameCallback$finally()}}
\item \href{#method-clone}{\code{DataFrameCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="readr" data-topic="ChunkCallback" data-id="continue">}\href{../../readr/html/ChunkCallback.html#method-continue}{\code{readr::ChunkCallback$continue()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataFrameCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataFrameCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-result"></a>}}
\if{latex}{\out{\hypertarget{method-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataFrameCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finally"></a>}}
\if{latex}{\out{\hypertarget{method-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataFrameCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataFrameCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[readr:ChunkCallback]{readr::ChunkCallback}} -> \code{ListCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ListCallback$new()}}
\item \href{#method-receive}{\code{ListCallback$receive()}}
\item \href{#method-result}{\code{ListCallback$result()}}
\item \href{#method-finally}{\code{ListCallback$finally()}}
\item \href{#method-clone}{\code{ListCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="readr" data-topic="ChunkCallback" data-id="continue">}\href{../../readr/html/ChunkCallback.html#method-continue}{\code{readr::ChunkCallback$continue()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-result"></a>}}
\if{latex}{\out{\hypertarget{method-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finally"></a>}}
\if{latex}{\out{\hypertarget{method-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[readr:ChunkCallback]{readr::ChunkCallback}} -> \code{AccumulateCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AccumulateCallback$new()}}
\item \href{#method-receive}{\code{AccumulateCallback$receive()}}
\item \href{#method-result}{\code{AccumulateCallback$result()}}
\item \href{#method-clone}{\code{AccumulateCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="readr" data-topic="ChunkCallback" data-id="continue">}\href{../../readr/html/ChunkCallback.html#method-continue}{\code{readr::ChunkCallback$continue()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="readr" data-topic="ChunkCallback" data-id="finally">}\href{../../readr/html/ChunkCallback.html#method-finally}{\code{readr::ChunkCallback$finally()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AccumulateCallback$new(callback, acc = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AccumulateCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-result"></a>}}
\if{latex}{\out{\hypertarget{method-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AccumulateCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AccumulateCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
